/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ServerChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.transport.CopyBytesServerSocketChannel;
import org.elasticsearch.transport.CopyBytesSocketChannel;

public class NettyAllocator {
    private static final ByteBufAllocator ALLOCATOR;
    private static final String USE_UNPOOLED = "es.use_unpooled_allocator";
    private static final String USE_NETTY_DEFAULT = "es.unsafe.use_netty_default_allocator";

    public static ByteBufAllocator getAllocator() {
        return ALLOCATOR;
    }

    public static Class<? extends Channel> getChannelType() {
        if (ALLOCATOR instanceof NoDirectBuffers) {
            return CopyBytesSocketChannel.class;
        }
        return NioSocketChannel.class;
    }

    public static Class<? extends ServerChannel> getServerChannelType() {
        if (ALLOCATOR instanceof NoDirectBuffers) {
            return CopyBytesServerSocketChannel.class;
        }
        return NioServerSocketChannel.class;
    }

    private static boolean useUnpooled() {
        if (System.getProperty(USE_UNPOOLED) != null) {
            return Booleans.parseBoolean((String)System.getProperty(USE_UNPOOLED));
        }
        long heapSize = JvmInfo.jvmInfo().getMem().getHeapMax().getBytes();
        return heapSize <= 0x40000000L;
    }

    static {
        if (Booleans.parseBoolean((String)System.getProperty(USE_NETTY_DEFAULT), (boolean)false)) {
            ALLOCATOR = ByteBufAllocator.DEFAULT;
        } else {
            NoDirectBuffers delegate;
            if (NettyAllocator.useUnpooled()) {
                delegate = new NoDirectBuffers((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
            } else {
                int nHeapArena = PooledByteBufAllocator.defaultNumHeapArena();
                int pageSize = PooledByteBufAllocator.defaultPageSize();
                int maxOrder = PooledByteBufAllocator.defaultMaxOrder();
                int tinyCacheSize = PooledByteBufAllocator.defaultTinyCacheSize();
                int smallCacheSize = PooledByteBufAllocator.defaultSmallCacheSize();
                int normalCacheSize = PooledByteBufAllocator.defaultNormalCacheSize();
                boolean useCacheForAllThreads = PooledByteBufAllocator.defaultUseCacheForAllThreads();
                delegate = new PooledByteBufAllocator(false, nHeapArena, 0, pageSize, maxOrder, tinyCacheSize, smallCacheSize, normalCacheSize, useCacheForAllThreads);
            }
            ALLOCATOR = new NoDirectBuffers(delegate);
        }
    }

    private static class NoDirectBuffers
    implements ByteBufAllocator {
        private final ByteBufAllocator delegate;

        private NoDirectBuffers(ByteBufAllocator delegate) {
            this.delegate = delegate;
        }

        public ByteBuf buffer() {
            return this.heapBuffer();
        }

        public ByteBuf buffer(int initialCapacity) {
            return this.heapBuffer(initialCapacity);
        }

        public ByteBuf buffer(int initialCapacity, int maxCapacity) {
            return this.heapBuffer(initialCapacity, maxCapacity);
        }

        public ByteBuf ioBuffer() {
            return this.heapBuffer();
        }

        public ByteBuf ioBuffer(int initialCapacity) {
            return this.heapBuffer(initialCapacity);
        }

        public ByteBuf ioBuffer(int initialCapacity, int maxCapacity) {
            return this.heapBuffer(initialCapacity, maxCapacity);
        }

        public ByteBuf heapBuffer() {
            return this.delegate.heapBuffer();
        }

        public ByteBuf heapBuffer(int initialCapacity) {
            return this.delegate.heapBuffer(initialCapacity);
        }

        public ByteBuf heapBuffer(int initialCapacity, int maxCapacity) {
            return this.delegate.heapBuffer(initialCapacity, maxCapacity);
        }

        public ByteBuf directBuffer() {
            throw new UnsupportedOperationException("Direct buffers not supported");
        }

        public ByteBuf directBuffer(int initialCapacity) {
            throw new UnsupportedOperationException("Direct buffers not supported");
        }

        public ByteBuf directBuffer(int initialCapacity, int maxCapacity) {
            throw new UnsupportedOperationException("Direct buffers not supported");
        }

        public CompositeByteBuf compositeBuffer() {
            return this.compositeHeapBuffer();
        }

        public CompositeByteBuf compositeBuffer(int maxNumComponents) {
            return this.compositeHeapBuffer(maxNumComponents);
        }

        public CompositeByteBuf compositeHeapBuffer() {
            return this.delegate.compositeHeapBuffer();
        }

        public CompositeByteBuf compositeHeapBuffer(int maxNumComponents) {
            return this.delegate.compositeHeapBuffer(maxNumComponents);
        }

        public CompositeByteBuf compositeDirectBuffer() {
            throw new UnsupportedOperationException("Direct buffers not supported.");
        }

        public CompositeByteBuf compositeDirectBuffer(int maxNumComponents) {
            throw new UnsupportedOperationException("Direct buffers not supported.");
        }

        public boolean isDirectBufferPooled() {
            assert (!this.delegate.isDirectBufferPooled());
            return false;
        }

        public int calculateNewCapacity(int minNewCapacity, int maxCapacity) {
            return this.delegate.calculateNewCapacity(minNewCapacity, maxCapacity);
        }
    }
}

