/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Component;
import java.awt.Point;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.util.Contract;

public interface HighlightPredicate {
    public static final HighlightPredicate ALWAYS = new HighlightPredicate(){

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            return true;
        }
    };
    public static final HighlightPredicate NEVER = new HighlightPredicate(){

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            return false;
        }
    };
    public static final HighlightPredicate ROLLOVER_ROW = new HighlightPredicate(){

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            if (!adapter.getComponent().isEnabled()) {
                return false;
            }
            Point p = (Point)adapter.getComponent().getClientProperty("swingx.rollover");
            return p != null && p.y == adapter.row;
        }
    };
    public static final HighlightPredicate EDITABLE = new HighlightPredicate(){

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            return adapter.isEditable();
        }
    };
    public static final HighlightPredicate READ_ONLY = new HighlightPredicate(){

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            return !adapter.isEditable();
        }
    };
    public static final HighlightPredicate IS_LEAF = new HighlightPredicate(){

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            return adapter.isLeaf();
        }
    };
    public static final HighlightPredicate IS_FOLDER = new HighlightPredicate(){

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            return !adapter.isLeaf();
        }
    };
    public static final HighlightPredicate HAS_FOCUS = new HighlightPredicate(){

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            return adapter.hasFocus();
        }
    };
    public static final HighlightPredicate EVEN = new HighlightPredicate(){

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            return adapter.row % 2 == 0;
        }
    };
    public static final HighlightPredicate ODD = new HighlightPredicate(){

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            return !EVEN.isHighlighted(renderer, adapter);
        }
    };
    public static final HighlightPredicate BIG_DECIMAL_NEGATIVE = new HighlightPredicate(){

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            return adapter.getValue() instanceof BigDecimal && ((BigDecimal)adapter.getValue()).compareTo(BigDecimal.ZERO) < 0;
        }
    };
    public static final HighlightPredicate INTEGER_NEGATIVE = new HighlightPredicate(){

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            return adapter.getValue() instanceof Number && ((Number)adapter.getValue()).intValue() < 0;
        }
    };
    public static final HighlightPredicate[] EMPTY_PREDICATE_ARRAY = new HighlightPredicate[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Integer[] EMPTY_INTEGER_ARRAY = new Integer[0];

    public boolean isHighlighted(Component var1, ComponentAdapter var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeHighlightPredicate
    implements HighlightPredicate {
        private Class<?> clazz;

        public TypeHighlightPredicate() {
            this(Object.class);
        }

        public TypeHighlightPredicate(Class<?> compareValue) {
            this.clazz = compareValue;
        }

        @Override
        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            return adapter.getValue() != null ? this.clazz.isAssignableFrom(adapter.getValue().getClass()) : false;
        }

        public Class<?> getType() {
            return this.clazz;
        }
    }

    public static class EqualsHighlightPredicate
    implements HighlightPredicate {
        private Object compareValue;

        public EqualsHighlightPredicate() {
            this(null);
        }

        public EqualsHighlightPredicate(Object compareValue) {
            this.compareValue = compareValue;
        }

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            if (this.compareValue == null) {
                return adapter.getValue() == null;
            }
            return this.compareValue.equals(adapter.getValue());
        }

        public Object getCompareValue() {
            return this.compareValue;
        }
    }

    public static class DepthHighlightPredicate
    implements HighlightPredicate {
        private List<Integer> depthList = new ArrayList<Integer>();

        public DepthHighlightPredicate(int ... depths) {
            for (int i = 0; i < depths.length; ++i) {
                this.depthList.add(depths[i]);
            }
        }

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            int depth = adapter.getDepth();
            return this.depthList.contains(depth);
        }

        public Integer[] getDepths() {
            if (this.depthList.isEmpty()) {
                return EMPTY_INTEGER_ARRAY;
            }
            return this.depthList.toArray(new Integer[this.depthList.size()]);
        }
    }

    public static class IdentifierHighlightPredicate
    implements HighlightPredicate {
        List<Object> columnList = new ArrayList<Object>();

        public IdentifierHighlightPredicate(Object ... columns) {
            for (int i = 0; i < columns.length; ++i) {
                this.columnList.add(columns[i]);
            }
        }

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            int modelIndex = adapter.viewToModel(adapter.column);
            Object identifier = adapter.getColumnIdentifierAt(modelIndex);
            return identifier != null ? this.columnList.contains(identifier) : false;
        }

        public Object[] getIdentifiers() {
            if (this.columnList.isEmpty()) {
                return EMPTY_OBJECT_ARRAY;
            }
            return this.columnList.toArray(new Object[0]);
        }
    }

    public static class ColumnHighlightPredicate
    implements HighlightPredicate {
        List<Integer> columnList = new ArrayList<Integer>();

        public ColumnHighlightPredicate(int ... columns) {
            for (int i = 0; i < columns.length; ++i) {
                this.columnList.add(columns[i]);
            }
        }

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            int modelIndex = adapter.viewToModel(adapter.column);
            return this.columnList.contains(modelIndex);
        }

        public Integer[] getColumns() {
            if (this.columnList.isEmpty()) {
                return EMPTY_INTEGER_ARRAY;
            }
            return this.columnList.toArray(new Integer[this.columnList.size()]);
        }
    }

    public static class RowGroupHighlightPredicate
    implements HighlightPredicate {
        private int linesPerGroup;

        public RowGroupHighlightPredicate(int linesPerGroup) {
            if (linesPerGroup < 1) {
                throw new IllegalArgumentException("a group contain at least 1 row, was: " + linesPerGroup);
            }
            this.linesPerGroup = linesPerGroup;
        }

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            return adapter.row / this.linesPerGroup % 2 == 1;
        }

        public int getLinesPerGroup() {
            return this.linesPerGroup;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OrHighlightPredicate
    implements HighlightPredicate {
        private List<HighlightPredicate> predicate;

        public OrHighlightPredicate(HighlightPredicate ... predicate) {
            this.predicate = Arrays.asList((Object[])Contract.asNotNull(predicate, "predicate must not be null"));
        }

        public OrHighlightPredicate(Collection<HighlightPredicate> list) {
            this.predicate = new ArrayList<HighlightPredicate>(Contract.asNotNull(list, "predicate list must not be null"));
        }

        @Override
        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            for (HighlightPredicate hp : this.predicate) {
                if (!hp.isHighlighted(renderer, adapter)) continue;
                return true;
            }
            return false;
        }

        public HighlightPredicate[] getHighlightPredicates() {
            if (this.predicate.isEmpty()) {
                return EMPTY_PREDICATE_ARRAY;
            }
            return this.predicate.toArray(new HighlightPredicate[this.predicate.size()]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AndHighlightPredicate
    implements HighlightPredicate {
        private List<HighlightPredicate> predicate;

        public AndHighlightPredicate(HighlightPredicate ... predicate) {
            this.predicate = Arrays.asList((Object[])Contract.asNotNull(predicate, "predicate must not be null"));
        }

        public AndHighlightPredicate(Collection<HighlightPredicate> list) {
            this.predicate = new ArrayList<HighlightPredicate>(Contract.asNotNull(list, "predicate list must not be null"));
        }

        @Override
        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            for (HighlightPredicate hp : this.predicate) {
                if (hp.isHighlighted(renderer, adapter)) continue;
                return false;
            }
            return !this.predicate.isEmpty();
        }

        public HighlightPredicate[] getHighlightPredicates() {
            if (this.predicate.isEmpty()) {
                return EMPTY_PREDICATE_ARRAY;
            }
            return this.predicate.toArray(new HighlightPredicate[this.predicate.size()]);
        }
    }

    public static class NotHighlightPredicate
    implements HighlightPredicate {
        private HighlightPredicate predicate;

        public NotHighlightPredicate(HighlightPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException("predicate must not be null");
            }
            this.predicate = predicate;
        }

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            return !this.predicate.isHighlighted(renderer, adapter);
        }

        public HighlightPredicate getHighlightPredicate() {
            return this.predicate;
        }
    }
}

