/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram.command;

import java.util.List;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.activitydiagram.ActivityDiagram;
import net.sourceforge.plantuml.activitydiagram.command.CommandLinkActivity;
import net.sourceforge.plantuml.classdiagram.command.CommandLinkClass;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Ident;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.NamespaceStrategy;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.color.ColorType;

public class CommandLinkLongActivity
extends CommandMultilines2<ActivityDiagram> {
    public CommandLinkLongActivity() {
        super(CommandLinkLongActivity.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE);
    }

    @Override
    public String getPatternEnd() {
        return "(?i)^[%s]*([^%g]*)[%g](?:[%s]+as[%s]+([\\p{L}0-9][\\p{L}0-9_.]*))?[%s]*(\\<\\<.*\\>\\>)?[%s]*(?:in[%s]+([%g][^%g]+[%g]|\\S+))?[%s]*(#\\w+)?$";
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandLinkLongActivity.class.getName(), RegexLeaf.start(), new RegexOptional((IRegex)new RegexOr("FIRST", new RegexLeaf("STAR", "(\\(\\*(top)?\\))"), new RegexLeaf("CODE", "([\\p{L}0-9][\\p{L}0-9_.]*)"), new RegexLeaf("BAR", "(?:==+)[%s]*([\\p{L}0-9_.]+)[%s]*(?:==+)"), new RegexLeaf("QUOTED", "[%g]([^%g]+)[%g](?:[%s]+as[%s]+([\\p{L}0-9_.]+))?"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("BACKCOLOR", "(#\\w+)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("ARROW_BODY1", "([-.]+)"), new RegexLeaf("ARROW_STYLE1", "(?:\\[((?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*)\\])?"), new RegexLeaf("ARROW_DIRECTION", "(\\*|left|right|up|down|le?|ri?|up?|do?)?"), new RegexLeaf("ARROW_STYLE2", "(?:\\[((?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*)\\])?"), new RegexLeaf("ARROW_BODY2", "([-.]*)"), new RegexLeaf("\\>"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf("BRACKET", "\\[([^\\]*]+[^\\]]*)\\]")), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("[%g]"), new RegexLeaf("DESC", "([^%g]*?)"), RegexLeaf.spaceZeroOrMore(), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeNow(ActivityDiagram diagram, BlocLines lines) {
        IEntity entity2;
        String stringColor;
        lines = lines.trim(false);
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst499().getTrimmed().getString());
        IEntity entity1 = CommandLinkActivity.getEntity(diagram, line0, true);
        if (entity1 == null) {
            return CommandExecutionResult.error("No such entity");
        }
        if (line0.get("STEREOTYPE", 0) != null) {
            entity1.setStereotype(new Stereotype(line0.get("STEREOTYPE", 0)));
        }
        if ((stringColor = line0.get("BACKCOLOR", 0)) != null) {
            entity1.setSpecificColorTOBEREMOVED(ColorType.BACK, diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(stringColor));
        }
        StringBuilder sb = new StringBuilder();
        String desc0 = line0.get("DESC", 0);
        Url urlActivity = null;
        if (StringUtils.isNotEmpty(desc0) && (urlActivity = this.extractUrlString(diagram, desc0)) == null) {
            sb.append(desc0);
            sb.append("\\n");
        }
        int i = 0;
        for (StringLocated cs : lines.subExtract(1, 1)) {
            if (++i == 1 && urlActivity == null && (urlActivity = this.extractUrl(diagram, cs)) != null) continue;
            sb.append(cs.getString());
            if (i >= lines.size() - 2) continue;
            sb.append("\\n");
        }
        List<String> lineLast = StringUtils.getSplit(MyPattern.cmpile(this.getPatternEnd()), lines.getLast499().getString());
        if (StringUtils.isNotEmpty(lineLast.get(0))) {
            if (sb.length() > 0 && !sb.toString().endsWith("\\n")) {
                sb.append("\\n");
            }
            sb.append(lineLast.get(0));
        }
        String display = sb.toString();
        String idShort = lineLast.get(1) == null ? display : lineLast.get(1);
        Code code = diagram.buildCode(idShort);
        String partition = null;
        if (lineLast.get(3) != null) {
            partition = lineLast.get(3);
            partition = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(partition);
        }
        if (partition != null) {
            Ident idNewLong = diagram.buildLeafIdent(partition);
            diagram.gotoGroup(idNewLong, diagram.buildCode(partition), Display.getWithNewlines(partition), GroupType.PACKAGE, null, NamespaceStrategy.SINGLE);
        }
        if ((entity2 = diagram.getOrCreate(diagram.buildLeafIdent(idShort), code, Display.getWithNewlines(display), LeafType.ACTIVITY)) == null) {
            return CommandExecutionResult.error("No such entity");
        }
        if (partition != null) {
            diagram.endGroup();
        }
        if (urlActivity != null) {
            entity2.addUrl(urlActivity);
        }
        if (lineLast.get(2) != null) {
            entity2.setStereotype(new Stereotype(lineLast.get(2)));
        }
        if (lineLast.get(4) != null) {
            entity2.setSpecificColorTOBEREMOVED(ColorType.BACK, diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(lineLast.get(4)));
        }
        String arrowBody1 = CommandLinkClass.notNull(line0.get("ARROW_BODY1", 0));
        String arrowBody2 = CommandLinkClass.notNull(line0.get("ARROW_BODY2", 0));
        String arrowDirection = CommandLinkClass.notNull(line0.get("ARROW_DIRECTION", 0));
        String arrow = StringUtils.manageArrowForCuca(arrowBody1 + arrowDirection + arrowBody2 + ">");
        int lenght = arrow.length() - 1;
        Display linkLabel = Display.getWithNewlines(line0.get("BRACKET", 0));
        LinkType type = new LinkType(LinkDecor.ARROW, LinkDecor.NONE);
        if (arrow.contains(".")) {
            type = type.goDotted();
        }
        Link link = new Link(entity1, entity2, type, linkLabel, lenght, diagram.getSkinParam().getCurrentStyleBuilder());
        Direction direction = StringUtils.getArrowDirection(arrowBody1 + arrowDirection + arrowBody2 + ">");
        if (direction == Direction.LEFT || direction == Direction.UP) {
            link = link.getInv();
        }
        if (line0.get("URL", 0) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            Url urlLink = urlBuilder.getUrl(line0.get("URL", 0));
            link.setUrl(urlLink);
        }
        link.applyStyle(line0.getLazzy("ARROW_STYLE", 0));
        diagram.addLink(link);
        return CommandExecutionResult.ok();
    }

    public Url extractUrl(ActivityDiagram diagram, StringLocated string) {
        return this.extractUrlString(diagram, string.getString());
    }

    public Url extractUrlString(ActivityDiagram diagram, String string) {
        UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
        return urlBuilder.getUrl(string);
    }
}

