/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.sequencediagram.AbstractMessage;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.style.StyleBuilder;

public final class Message
extends AbstractMessage {
    private final Participant p1;
    private final Participant p2;

    public Message(StyleBuilder styleBuilder, Participant p1, Participant p2, Display label, ArrowConfiguration arrowConfiguration, String messageNumber) {
        super(styleBuilder, label, arrowConfiguration, messageNumber);
        this.p1 = p1;
        this.p2 = p2;
    }

    public String toString() {
        return super.toString() + " " + this.p1 + "->" + this.p2 + " " + this.getLabel();
    }

    public Participant getParticipant1() {
        return this.p1;
    }

    public Participant getParticipant2() {
        return this.p2;
    }

    @Override
    public boolean dealWith(Participant someone) {
        return someone == this.p1 || someone == this.p2;
    }

    @Override
    public boolean compatibleForCreate(Participant p) {
        return this.p1 != p && this.p2 == p;
    }

    @Override
    public boolean isSelfMessage() {
        return this.p1 == this.p2;
    }
}

