/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.repository.extractors;

import com.google.common.base.Optional;
import java.net.URI;
import org.protege.editor.owl.model.repository.extractors.OntologyIdExtractor;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LastResortExtractor
implements OntologyIdExtractor {
    private Logger log = LoggerFactory.getLogger(LastResortExtractor.class);

    @Override
    public Optional<OWLOntologyID> getOntologyId(URI location) {
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        try {
            OWLOntology ontology = manager.loadOntologyFromOntologyDocument(IRI.create((URI)location));
            return Optional.of((Object)ontology.getOntologyID());
        }
        catch (Throwable t) {
            this.log.info("Exception caught trying to get ontology id for " + location, t);
            return null;
        }
    }
}

