/*
 * Copyright (c) 2012, 2019, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_to extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Moscow = new String[] {
               "houa fakal\u016bsia-mosikou taimi totonu",
               "",
               "houa fakal\u016bsia-mosikou taimi liliu",
               "",
               "houa fakal\u016bsia-mosikou",
               "",
            };
        final String[] Pakistan = new String[] {
               "houa fakap\u0101kisitani taimi totonu",
               "",
               "houa fakap\u0101kisitani taimi liliu",
               "",
               "houa fakap\u0101kisitani",
               "",
            };
        final String[] Magadan = new String[] {
               "houa fakal\u016bsia-makatani taimi totonu",
               "",
               "houa fakal\u016bsia-makatani taimi liliu",
               "",
               "houa fakal\u016bsia-makatani",
               "",
            };
        final String[] Europe_Central = new String[] {
               "houa faka\u02bbeulope-loto taimi totonu",
               "",
               "houa faka\u02bbeulope-loto taimi liliu",
               "",
               "houa faka\u02bbeulope-loto",
               "",
            };
        final String[] Acre = new String[] {
               "houa faka\u02bbakel\u012b taimi totonu",
               "",
               "houa faka\u02bbakel\u012b taimi liliu",
               "",
               "houa faka\u02bbakel\u012b",
               "",
            };
        final String[] America_Eastern = new String[] {
               "houa faka\u02bbamelika-tokelau hahake taimi totonu",
               "",
               "houa faka\u02bbamelika-tokelau hahake taimi liliu",
               "",
               "houa faka\u02bbamelika-tokelau hahake",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "houa fakamotu\u02bbeikihoue taimi totonu",
               "",
               "houa fakamotu\u02bbeikihoue taimi liliu",
               "",
               "houa fakamotu\u02bbeikihoue",
               "",
            };
        final String[] New_Zealand = new String[] {
               "houa fakanu\u02bbusila taimi totonu",
               "",
               "houa fakanu\u02bbusila taimi liliu",
               "",
               "houa fakanu\u02bbusila",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "houa fakamoana\u02bbinitia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yakutsk = new String[] {
               "houa fakal\u016bsia-\u02bbi\u0101kutisiki taimi totonu",
               "",
               "houa fakal\u016bsia-\u02bbi\u0101kutisiki taimi liliu",
               "",
               "houa fakal\u016bsia-\u02bbi\u0101kutisiki",
               "",
            };
        final String[] East_Timor = new String[] {
               "houa fakatimoa-hahake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kosrae = new String[] {
               "houa fakakosilae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "houa faka\u02bbeulope-hahake taimi totonu",
               "",
               "houa faka\u02bbeulope-hahake taimi liliu",
               "",
               "houa faka\u02bbeulope-hahake",
               "",
            };
        final String[] Argentina_Western = new String[] {
               "houa faka\u02bbasenitina-hihifo taimi totonu",
               "",
               "houa faka\u02bbasenitina-hihifo taimi liliu",
               "",
               "houa faka\u02bbasenitina-hihifo",
               "",
            };
        final String[] Ponape = new String[] {
               "houa fakap\u014dnap\u0113",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Bolivia = new String[] {
               "houa fakapol\u012bvia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "houa fakas\u0101-piea-mo-mikeloni taimi totonu",
               "",
               "houa fakas\u0101-piea-mo-mikeloni taimi liliu",
               "",
               "houa fakas\u0101-piea-mo-mikeloni",
               "",
            };
        final String[] Indochina = new String[] {
               "houa faka\u02bbinitosiaina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "houa fakal\u016bsia-\u02bbiekatelinep\u016bki taimi totonu",
               "",
               "houa fakal\u016bsia-\u02bbiekatelinep\u016bki taimi liliu",
               "",
               "houa fakal\u016bsia-\u02bbiekatelinep\u016bki",
               "",
            };
        final String[] Maldives = new String[] {
               "houa fakamalativisi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "houa fakatahisi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "houa faka\u02bbuvea mo futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "houa faka\u02bbafelika-tonga",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Syowa = new String[] {
               "houa fakasioua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "houa faka\u02bbotumotulaine",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "houa faka\u02bbusipekitani taimi totonu",
               "",
               "houa faka\u02bbusipekitani taimi liliu",
               "",
               "houa faka\u02bbusipekitani",
               "",
            };
        final String[] Mongolia = new String[] {
               "houa faka\u02bbul\u0101nip\u0101t\u0101 taimi totonu",
               "",
               "houa faka\u02bbul\u0101nip\u0101t\u0101 taimi liliu",
               "",
               "houa faka\u02bbul\u0101nip\u0101t\u0101",
               "",
            };
        final String[] America_Central = new String[] {
               "houa faka\u02bbamelika-tokelau loto taimi totonu",
               "",
               "houa faka\u02bbamelika-tokelau loto taimi liliu",
               "",
               "houa faka\u02bbamelika-tokelau loto",
               "",
            };
        final String[] Niue = new String[] {
               "houa fakaniu\u0113",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "houa fakamotuueke",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Falkland = new String[] {
               "houa faka\u02bbotumotu-fokulani taimi totonu",
               "",
               "houa faka\u02bbotumotu-fokulani taimi liliu",
               "",
               "houa faka\u02bbotumotu-fokulani",
               "",
            };
        final String[] Apia = new String[] {
               "houa fakaapia taimi totonu",
               "",
               "houa fakaapia taimi liliu",
               "",
               "houa fakaapia",
               "",
            };
        final String[] Bhutan = new String[] {
               "houa fakap\u016btani",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nauru = new String[] {
               "houa fakanaulu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "houa fakakasakitani-hihifo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Christmas = new String[] {
               "houa fakamotukilisimasi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Reunion = new String[] {
               "houa fakal\u0113unioni",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cocos = new String[] {
               "houa fakamotukokosi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "houa fakasatihami taimi totonu",
               "",
               "houa fakasatihami taimi liliu",
               "",
               "houa fakasatihami",
               "",
            };
        final String[] Vostok = new String[] {
               "houa fakavositoki",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "houa faka\u02bbasenitina taimi totonu",
               "",
               "houa faka\u02bbasenitina taimi liliu",
               "",
               "houa faka\u02bbasenitina",
               "",
            };
        final String[] Gambier = new String[] {
               "houa fakakamipi\u0113",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "houa fakakalapakosi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "houa fakavenesuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "houa faka\u02bbotumotufoinikisi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "houa fakamui\u02bbi-v\u0113te taimi totonu",
               "",
               "houa fakamui\u02bbi-v\u0113te taimi liliu",
               "",
               "houa fakamui\u02bbi-v\u0113te",
               "",
            };
        final String[] Norfolk = new String[] {
               "houa fakanoaf\u014dki",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "houa fakaha\u02bbamoa taimi totonu",
               "",
               "houa fakaha\u02bbamoa taimi liliu",
               "",
               "houa fakaha\u02bbamoa",
               "",
            };
        final String[] Davis = new String[] {
               "houa fakatavisi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cuba = new String[] {
               "houa fakakiupa taimi totonu",
               "",
               "houa fakakiupa taimi liliu",
               "",
               "houa fakakiupa",
               "",
            };
        final String[] GMT = new String[] {
               "houa fakakiliniuisi m\u0101lie",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Philippines = new String[] {
               "houa fakafilipaine taimi totonu",
               "",
               "houa fakafilipaine taimi liliu",
               "",
               "houa fakafilipaine",
               "",
            };
        final String[] French_Southern = new String[] {
               "houa faka\u02bbanet\u0101tikafalanis\u0113",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "houa fakakalet\u014dniafo\u02bbou taimi totonu",
               "",
               "houa fakakalet\u014dniafo\u02bbou taimi liliu",
               "",
               "houa fakakalet\u014dniafo\u02bbou",
               "",
            };
        final String[] Brunei = new String[] {
               "houa fakapulunei",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Iran = new String[] {
               "houa faka\u02bbilaani taimi totonu",
               "",
               "houa faka\u02bbilaani taimi liliu",
               "",
               "houa faka\u02bbilaani",
               "",
            };
        final String[] Tajikistan = new String[] {
               "houa fakatasikitani",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "houa fakatonga taimi totonu",
               "",
               "houa fakatonga taimi liliu",
               "",
               "houa fakatonga",
               "",
            };
        final String[] Bangladesh = new String[] {
               "houa fakap\u0101ngil\u0101tesi taimi totonu",
               "",
               "houa fakap\u0101ngil\u0101tesi taimi liliu",
               "",
               "houa fakap\u0101ngil\u0101tesi",
               "",
            };
        final String[] Peru = new String[] {
               "houa fakapel\u016b taimi totonu",
               "",
               "houa fakapel\u016b taimi liliu",
               "",
               "houa fakapel\u016b",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "houa fakafonuamata-hahake taimi totonu",
               "",
               "houa fakafonuamata-hahake taimi liliu",
               "",
               "houa fakafonuamata-hahake",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "houa faka\u02bbinitonisia-hahake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "houa fakak\u012bkisitani",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "houa faka\u02bbaositel\u0113lia-hahake taimi totonu",
               "",
               "houa faka\u02bbaositel\u0113lia-hahake taimi liliu",
               "",
               "houa faka\u02bbaositel\u0113lia-hahake",
               "",
            };
        final String[] French_Guiana = new String[] {
               "houa fakakuiana-fakafalanis\u0113",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "houa fakakolomipia taimi totonu",
               "",
               "houa fakakolomipia taimi liliu",
               "",
               "houa fakakolomipia",
               "",
            };
        final String[] Chile = new String[] {
               "houa fakasili taimi totonu",
               "",
               "houa fakasili taimi liliu",
               "",
               "houa fakasili",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "houa fakakilipasi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Irkutsk = new String[] {
               "houa fakal\u016bsia-\u02bb\u012bkutisiki taimi totonu",
               "",
               "houa fakal\u016bsia-\u02bb\u012bkutisiki taimi liliu",
               "",
               "houa fakal\u016bsia-\u02bb\u012bkutisiki",
               "",
            };
        final String[] Georgia = new String[] {
               "houa fakase\u014dsia taimi totonu",
               "",
               "houa fakase\u014dsia taimi liliu",
               "",
               "houa fakase\u014dsia",
               "",
            };
        final String[] Choibalsan = new String[] {
               "houa fakakoipalisani taimi totonu",
               "",
               "houa fakakoipalisani taimi liliu",
               "",
               "houa fakakoipalisani",
               "",
            };
        final String[] China = new String[] {
               "houa fakasiaina taimi totonu",
               "",
               "houa fakasiaina taimi liliu",
               "",
               "houa fakasiaina",
               "",
            };
        final String[] Armenia = new String[] {
               "houa faka\u02bb\u0101menia taimi totonu",
               "",
               "houa faka\u02bb\u0101menia taimi liliu",
               "",
               "houa faka\u02bb\u0101menia",
               "",
            };
        final String[] Africa_Central = new String[] {
               "houa faka\u02bbafelika-loto",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "houa fakasiapani taimi totonu",
               "",
               "houa fakasiapani taimi liliu",
               "",
               "houa fakasiapani",
               "",
            };
        final String[] Taipei = new String[] {
               "houa fakataipei taimi totonu",
               "",
               "houa fakataipei taimi liliu",
               "",
               "houa fakataipei",
               "",
            };
        final String[] Hovd = new String[] {
               "houa fakahovite taimi totonu",
               "",
               "houa fakahovite taimi liliu",
               "",
               "houa fakahovite",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "houa faka\u02bbaositel\u0113lia-loto-hihifo taimi totonu",
               "",
               "houa faka\u02bbaositel\u0113lia-loto-hihifo taimi liliu",
               "",
               "houa faka\u02bbaositel\u0113lia-loto-hihifo",
               "",
            };
        final String[] Sakhalin = new String[] {
               "houa fakal\u016bsia-sak\u0101line taimi totonu",
               "",
               "houa fakal\u016bsia-sak\u0101line taimi liliu",
               "",
               "houa fakal\u016bsia-sak\u0101line",
               "",
            };
        final String[] Paraguay = new String[] {
               "houa fakapalakuai taimi totonu",
               "",
               "houa fakapalakuai taimi liliu",
               "",
               "houa fakapalakuai",
               "",
            };
        final String[] Malaysia = new String[] {
               "houa fakamaleisia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "houa fakamaulitiusi taimi totonu",
               "",
               "houa fakamaulitiusi taimi liliu",
               "",
               "houa fakamaulitiusi",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "houa faka\u02bbafelika-hahake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "houa faka\u02bbotumotusolomone",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "houa faka\u02bbotumotumasolo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "houa fakafonua\u02bbilofo\u02bbou taimi totonu",
               "",
               "houa fakafonua\u02bbilofo\u02bbou taimi liliu",
               "",
               "houa fakafonua\u02bbilofo\u02bbou",
               "",
            };
        final String[] Afghanistan = new String[] {
               "houa faka\u02bbafik\u0101nisitani",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "houa fakahongi-kongi taimi totonu",
               "",
               "houa fakahongi-kongi taimi liliu",
               "",
               "houa fakahongi-kongi",
               "",
            };
        final String[] Atlantic = new String[] {
               "houa faka\u02bbamelika-tokelau \u02bbatalanitiki taimi totonu",
               "",
               "houa faka\u02bbamelika-tokelau \u02bbatalanitiki taimi liliu",
               "",
               "houa faka\u02bbamelika-tokelau \u02bbatalanitiki",
               "",
            };
        final String[] Israel = new String[] {
               "houa faka\u02bbisileli taimi totonu",
               "",
               "houa faka\u02bbisileli taimi liliu",
               "",
               "houa faka\u02bbisileli",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "houa faka\u02bbinitonisia-loto",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "houa fakal\u016bsia-\u02bbomisiki taimi totonu",
               "",
               "houa fakal\u016bsia-\u02bbomisiki taimi liliu",
               "",
               "houa fakal\u016bsia-\u02bbomisiki",
               "",
            };
        final String[] Seychelles = new String[] {
               "houa faka\u02bbotumotu-seiseli",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "houa faka\u02bbulukuai taimi totonu",
               "",
               "houa faka\u02bbulukuai taimi liliu",
               "",
               "houa faka\u02bbulukuai",
               "",
            };
        final String[] Nepal = new String[] {
               "houa fakanepali",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Truk = new String[] {
               "houa fakat\u016bke",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vanuatu = new String[] {
               "houa fakavanuatu taimi totonu",
               "",
               "houa fakavanuatu taimi liliu",
               "",
               "houa fakavanuatu",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "houa fakal\u016bsia-novosip\u012bsiki taimi totonu",
               "",
               "houa fakal\u016bsia-novosip\u012bsiki taimi liliu",
               "",
               "houa fakal\u016bsia-novosip\u012bsiki",
               "",
            };
        final String[] Singapore = new String[] {
               "houa fakasingapoa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azores = new String[] {
               "houa faka\u02bb\u0101solesi taimi totonu",
               "",
               "houa faka\u02bb\u0101solesi taimi liliu",
               "",
               "houa faka\u02bb\u0101solesi",
               "",
            };
        final String[] Suriname = new String[] {
               "houa fakasuliname",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "houa fakal\u016bsia-kalasinoi\u0101siki taimi totonu",
               "",
               "houa fakal\u016bsia-kalasinoi\u0101siki taimi liliu",
               "",
               "houa fakal\u016bsia-kalasinoi\u0101siki",
               "",
            };
        final String[] Myanmar = new String[] {
               "houa fakapema",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Amazon = new String[] {
               "houa faka\u02bbamas\u014dne taimi totonu",
               "",
               "houa faka\u02bbamas\u014dne taimi liliu",
               "",
               "houa faka\u02bbamas\u014dne",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "houa fakakasakitani-hahake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Fiji = new String[] {
               "houa fakafisi taimi totonu",
               "",
               "houa fakafisi taimi liliu",
               "",
               "houa fakafisi",
               "",
            };
        final String[] Kamchatka = new String[] {
               "houa fakal\u016bsia-petelopavilovisiki taimi totonu",
               "",
               "houa fakal\u016bsia-petelopavilovisiki taimi liliu",
               "",
               "houa fakal\u016bsia-petelopavilovisiki",
               "",
            };
        final String[] Tuvalu = new String[] {
               "houa fakat\u016bvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Macquarie = new String[] {
               "houa fakamotumakuali",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "houa fakahaua\u02bbi taimi totonu",
               "",
               "houa fakahaua\u02bbi taimi liliu",
               "",
               "houa fakahaua\u02bbi",
               "",
            };
        final String[] Australia_Central = new String[] {
               "houa faka\u02bbaositel\u0113lia-loto taimi totonu",
               "",
               "houa faka\u02bbaositel\u0113lia-loto taimi liliu",
               "",
               "houa faka\u02bbaositel\u0113lia-loto",
               "",
            };
        final String[] America_Pacific = new String[] {
               "houa faka\u02bbamelika-tokelau pasifika taimi totonu",
               "",
               "houa faka\u02bbamelika-tokelau pasifika taimi liliu",
               "",
               "houa faka\u02bbamelika-tokelau pasifika",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "houa fakat\u016bkimenisitani taimi totonu",
               "",
               "houa fakat\u016bkimenisitani taimi liliu",
               "",
               "houa fakat\u016bkimenisitani",
               "",
            };
        final String[] Europe_Western = new String[] {
               "houa faka\u02bbeulope-hihifo taimi totonu",
               "",
               "houa faka\u02bbeulope-hihifo taimi liliu",
               "",
               "houa faka\u02bbeulope-hihifo",
               "",
            };
        final String[] Guyana = new String[] {
               "houa fakakuiana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pitcairn = new String[] {
               "houa fakapitikani",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "houa fakalotela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "houa fakapalau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "houa faka\u02bbasapaisani taimi totonu",
               "",
               "houa faka\u02bbasapaisani taimi liliu",
               "",
               "houa faka\u02bbasapaisani",
               "",
            };
        final String[] Mawson = new String[] {
               "houa fakamausoni",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "houa fakamekisikou-pasifika taimi totonu",
               "",
               "houa fakamekisikou-pasifika taimi liliu",
               "",
               "houa fakamekisikou-pasifika",
               "",
            };
        final String[] Africa_Western = new String[] {
               "houa faka\u02bbafelika-hihifo taimi totonu",
               "",
               "houa faka\u02bbafelika-hihifo taimi liliu",
               "",
               "houa faka\u02bbafelika-hihifo",
               "",
            };
        final String[] South_Georgia = new String[] {
               "houa fakasiosiatonga",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "houa fakal\u016bsia-volikokalati taimi totonu",
               "",
               "houa fakal\u016bsia-volikokalati taimi liliu",
               "",
               "houa fakal\u016bsia-volikokalati",
               "",
            };
        final String[] Easter = new String[] {
               "houa fakalapanui taimi totonu",
               "",
               "houa fakalapanui taimi liliu",
               "",
               "houa fakalapanui",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "houa fakamekisikou-tokelauhihifo taimi totonu",
               "",
               "houa fakamekisikou-tokelauhihifo taimi liliu",
               "",
               "houa fakamekisikou-tokelauhihifo",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "houa fakat\u016bmoni-t\u016bvile",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "houa fakafonuamata-hihifo taimi totonu",
               "",
               "houa fakafonuamata-hihifo taimi liliu",
               "",
               "houa fakafonuamata-hihifo",
               "",
            };
        final String[] Ecuador = new String[] {
               "houa faka\u02bbekuetoa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gulf = new String[] {
               "houa fakak\u016blifi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Korea = new String[] {
               "houa fakak\u014dlea taimi totonu",
               "",
               "houa fakak\u014dlea taimi liliu",
               "",
               "houa fakak\u014dlea",
               "",
            };
        final String[] Australia_Western = new String[] {
               "houa faka\u02bbaositel\u0113lia-hihifo taimi totonu",
               "",
               "houa faka\u02bbaositel\u0113lia-hihifo taimi liliu",
               "",
               "houa faka\u02bbaositel\u0113lia-hihifo",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "houa faka\u02bbinitonisia-hihifo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Mountain = new String[] {
               "houa faka\u02bbamelika-tokelau mo\u02bbunga taimi totonu",
               "",
               "houa faka\u02bbamelika-tokelau mo\u02bbunga taimi liliu",
               "",
               "houa faka\u02bbamelika-tokelau mo\u02bbunga",
               "",
            };
        final String[] Marquesas = new String[] {
               "houa fakam\u0101kesasi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "houa faka\u02bbalepea taimi totonu",
               "",
               "houa faka\u02bbalepea taimi liliu",
               "",
               "houa faka\u02bbalepea",
               "",
            };
        final String[] Alaska = new String[] {
               "houa faka\u02bbalasika taimi totonu",
               "",
               "houa faka\u02bbalasika taimi liliu",
               "",
               "houa faka\u02bbalasika",
               "",
            };
        final String[] Vladivostok = new String[] {
               "houa fakal\u016bsia-valativositoki taimi totonu",
               "",
               "houa fakal\u016bsia-valativositoki taimi liliu",
               "",
               "houa fakal\u016bsia-valativositoki",
               "",
            };
        final String[] Chamorro = new String[] {
               "houa fakakamolo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "houa fakatokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "houa fakapapuaniukini",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Noronha = new String[] {
               "houa fakaf\u0113nanito-te-nol\u014dnia taimi totonu",
               "",
               "houa fakaf\u0113nanito-te-nol\u014dnia taimi liliu",
               "",
               "houa fakaf\u0113nanito-te-nol\u014dnia",
               "",
            };
        final String[] Brasilia = new String[] {
               "houa fakapal\u0101sila taimi totonu",
               "",
               "houa fakapal\u0101sila taimi liliu",
               "",
               "houa fakapal\u0101sila",
               "",
            };
        final String[] Anadyr = new String[] {
               "houa fakal\u016bsia-\u02bbanatili taimi totonu",
               "",
               "houa fakal\u016bsia-\u02bbanatili taimi liliu",
               "",
               "houa fakal\u016bsia-\u02bbanatili",
               "",
            };
        final String[] Samara = new String[] {
               "houa fakal\u016bsia-samala taimi totonu",
               "",
               "houa fakal\u016bsia-samala taimi liliu",
               "",
               "houa fakal\u016bsia-samala",
               "",
            };
        final String[] India = new String[] {
               "houa faka\u02bbinitia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cook = new String[] {
               "houa faka\u02bbotumotukuki taimi totonu",
               "",
               "houa faka\u02bbotumotukuki taimi liliu",
               "",
               "houa faka\u02bbotumotukuki",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Aden", Arabian },
            { "timezone.excity.America/Phoenix", "Phoenix" },
            { "timezone.excity.America/Antigua", "Antigua" },
            { "timezone.excity.Europe/Ljubljana", "Ljubljana" },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "timezone.excity.Pacific/Marquesas", "Marquesas" },
            { "America/El_Salvador", America_Central },
            { "timezone.excity.America/Buenos_Aires", "Buenos Aires" },
            { "Asia/Pontianak", Indonesia_Western },
            { "timezone.excity.America/Danmarkshavn", "Danmarkshavn" },
            { "timezone.excity.America/Anchorage", "Anchorage" },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Europe/London",
                new String[] {
                    "houa fakakiliniuisi m\u0101lie",
                    "",
                    "houa fakapilit\u0101nia taimi liliu",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Antarctica/Vostok", "Vostok" },
            { "America/Panama", America_Eastern },
            { "timezone.excity.Pacific/Fiji", "Fisi" },
            { "timezone.excity.Europe/Gibraltar", "Gibraltar" },
            { "Europe/Jersey", GMT },
            { "timezone.excity.Africa/Malabo", "Malabo" },
            { "America/Eirunepe", Acre },
            { "Europe/Luxembourg", Europe_Central },
            { "timezone.excity.Africa/Libreville", "Libreville" },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "timezone.excity.Africa/Dakar", "Dakar" },
            { "Atlantic/St_Helena", GMT },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Ababa" },
            { "timezone.excity.Africa/Kinshasa", "Kinshasa" },
            { "timezone.excity.Asia/Dushanbe", "Dushanbe" },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "timezone.excity.Europe/Tallinn", "Tallinn" },
            { "timezone.excity.Pacific/Truk", "T\u016bke" },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "timezone.excity.Pacific/Guam", "Kuami" },
            { "timezone.excity.Europe/Vaduz", "Vaduz" },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "timezone.excity.America/Santa_Isabel", "Santa Isabel" },
            { "Antarctica/Syowa", Syowa },
            { "timezone.excity.Africa/Maseru", "Maseru" },
            { "Pacific/Palau", Palau },
            { "timezone.excity.Europe/London", "Lonitoni" },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Central },
            { "Asia/Karachi", Pakistan },
            { "timezone.excity.Pacific/Pitcairn", "Pitcairn" },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnoyarsk" },
            { "Antarctica/McMurdo", New_Zealand },
            { "timezone.excity.America/Nome", "Nome" },
            { "Pacific/Tahiti", Tahiti },
            { "timezone.excity.America/Vancouver", "Vancouver" },
            { "timezone.excity.America/Matamoros", "Matamoros" },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "timezone.excity.Asia/Choibalsan", "Choibalsan" },
            { "timezone.excity.America/Inuvik", "Inuvik" },
            { "Africa/Malabo", Africa_Western },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuznetsk" },
            { "timezone.excity.Europe/Berlin", "Berlin" },
            { "Africa/Lagos", Africa_Western },
            { "timezone.excity.Pacific/Midway", "Midway" },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "timezone.excity.America/Martinique", "Martinique" },
            { "America/Dawson_Creek", America_Mountain },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "Asia/Dili", East_Timor },
            { "timezone.excity.Australia/Perth", "Perth" },
            { "Africa/Bamako", GMT },
            { "timezone.excity.Arctic/Longyearbyen", "Longyearbyen" },
            { "Pacific/Wallis", Wallis },
            { "timezone.excity.America/Tegucigalpa", "Tegucigalpa" },
            { "timezone.excity.Africa/Windhoek", "Windhoek" },
            { "Africa/Lubumbashi", Africa_Central },
            { "timezone.excity.Pacific/Majuro", "Majuro" },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "timezone.excity.Africa/Banjul", "Banjul" },
            { "Asia/Dhaka", Bangladesh },
            { "timezone.excity.Australia/Lindeman", "Lindeman" },
            { "timezone.excity.America/Miquelon", "Miquelon" },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "timezone.excity.America/Jujuy", "Jujuy" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ushuaia" },
            { "timezone.excity.America/Cayenne", "Cayenne" },
            { "Pacific/Chatham", Chatham },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "timezone.excity.America/Belize", "Belize" },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "timezone.excity.Asia/Bangkok", "Bangkok" },
            { "Europe/Moscow", Moscow },
            { "America/Puerto_Rico", Atlantic },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Helsinki", Europe_Eastern },
            { "timezone.excity.America/Montevideo", "Montevideo" },
            { "timezone.excity.Pacific/Johnston", "Johnston" },
            { "America/Cayenne", French_Guiana },
            { "timezone.excity.Europe/Jersey", "Jersey" },
            { "timezone.excity.America/Pangnirtung", "Pangnirtung" },
            { "timezone.excity.Atlantic/South_Georgia", "South Georgia" },
            { "Pacific/Fiji", Fiji },
            { "timezone.excity.Africa/Juba", "Juba" },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "SystemV/AST4", Atlantic },
            { "timezone.excity.America/Havana", "Havana" },
            { "timezone.excity.Europe/Madrid", "Madrid" },
            { "Asia/Oral", Kazakhstan_Western },
            { "timezone.excity.America/Detroit", "Detroit" },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "timezone.excity.America/Grenada", "Grenada" },
            { "timezone.excity.Asia/Phnom_Penh", "Phnom Penh" },
            { "timezone.excity.Europe/Rome", "Loma" },
            { "timezone.excity.Asia/Hebron", "Hebron" },
            { "Asia/Jakarta", Indonesia_Western },
            { "timezone.excity.Antarctica/Mawson", "Mawson" },
            { "timezone.excity.Asia/Karachi", "Karachi" },
            { "timezone.excity.America/Resolute", "Resolute" },
            { "timezone.excity.Africa/Nouakchott", "Nouakchott" },
            { "timezone.excity.Africa/Bamako", "Bamako" },
            { "timezone.excity.America/Argentina/Salta", "Salta" },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "timezone.excity.Asia/Muscat", "Muscat" },
            { "America/Noronha", Noronha },
            { "timezone.excity.Africa/El_Aaiun", "El Aaiun" },
            { "timezone.excity.Australia/Hobart", "Hobart" },
            { "Australia/Adelaide", Australia_Central },
            { "timezone.excity.America/Lima", "Lima" },
            { "America/Paramaribo", Suriname },
            { "timezone.excity.Asia/Bishkek", "Bishkek" },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "timezone.excity.America/Paramaribo", "Paramaribo" },
            { "Antarctica/Troll", GMT },
            { "timezone.excity.America/Ojinaga", "Ojinaga" },
            { "timezone.excity.Europe/Zurich", "Zurich" },
            { "Europe/Samara", Samara },
            { "America/Antigua", Atlantic },
            { "timezone.excity.America/Sao_Paulo", "Sao Paulo" },
            { "Pacific/Gambier", Gambier },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Korea },
            { "timezone.excity.America/New_York", "Niu \u02bbIoke" },
            { "Asia/Gaza", Europe_Eastern },
            { "timezone.excity.Africa/Accra", "Accra" },
            { "timezone.excity.Etc/Unknown", "Feitu\u02bbu ta\u02bbe\u02bbiloa" },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "timezone.excity.America/Thule", "Thule" },
            { "timezone.excity.America/Grand_Turk", "Grand Turk" },
            { "America/Yakutat", Alaska },
            { "Europe/Vienna", Europe_Central },
            { "timezone.excity.America/Winnipeg", "Winnipeg" },
            { "timezone.excity.Antarctica/Macquarie", "Macquarie" },
            { "timezone.excity.Europe/Uzhgorod", "Uzhhorod" },
            { "timezone.excity.America/Caracas", "Caracas" },
            { "timezone.excity.America/Dawson_Creek", "Dawson Creek" },
            { "timezone.excity.America/Bogota", "Bogota" },
            { "timezone.excity.Asia/Baku", "Baku" },
            { "timezone.excity.Asia/Hovd", "Hovd" },
            { "timezone.excity.Africa/Harare", "Harare" },
            { "Europe/Tirane", Europe_Central },
            { "timezone.excity.America/Blanc-Sablon", "Blanc-Sablon" },
            { "timezone.excity.Africa/Algiers", "Algiers" },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "timezone.excity.Africa/Khartoum", "Khartoum" },
            { "Africa/Abidjan", GMT },
            { "America/Santarem", Brasilia },
            { "timezone.excity.Asia/Khandyga", "Khandyga" },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Atlantic/Bermuda", Atlantic },
            { "timezone.excity.Pacific/Galapagos", "Galapagos" },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "timezone.excity.America/Argentina/Tucuman", "Tucuman" },
            { "timezone.excity.America/Rio_Branco", "Rio Branco" },
            { "Africa/Accra", GMT },
            { "timezone.excity.Africa/Niamey", "Niamey" },
            { "timezone.excity.Indian/Mayotte", "Mayotte" },
            { "America/Maceio", Brasilia },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "houa fakakiliniuisi m\u0101lie",
                    "",
                    "houa faka\u02bbaealani taimi totonu",
                    "",
                    "",
                    "",
                }
            },
            { "Pacific/Truk", Truk },
            { "timezone.excity.Africa/Conakry", "Conakry" },
            { "timezone.excity.Asia/Jakarta", "Jakarta" },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "SystemV/CST6", America_Central },
            { "timezone.excity.Pacific/Efate", "Efate" },
            { "timezone.excity.Asia/Aqtobe", "Aqtobe" },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Ouagadougou", GMT },
            { "Africa/El_Aaiun",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Pacific/Rarotonga", "Lalotonga" },
            { "timezone.excity.Europe/Luxembourg", "Luxembourg" },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "timezone.excity.Asia/Bahrain", "Bahrain" },
            { "timezone.excity.Indian/Mahe", "Mahe" },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "timezone.excity.Europe/Isle_of_Man", "Isle of Man" },
            { "Pacific/Saipan", Chamorro },
            { "timezone.excity.America/Curacao", "Cura\u00e7ao" },
            { "timezone.excity.Pacific/Nauru", "Naulu" },
            { "timezone.excity.Pacific/Pago_Pago", "Pangopango" },
            { "Antarctica/Rothera", Rothera },
            { "timezone.excity.America/Guyana", "Guyana" },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "timezone.excity.Europe/Paris", "Palesi" },
            { "timezone.excity.Europe/Zagreb", "Zagreb" },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "timezone.excity.America/Swift_Current", "Swift Current" },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "timezone.excity.America/Tortola", "Tortola" },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "timezone.excity.Europe/Budapest", "Budapest" },
            { "timezone.excity.America/Catamarca", "Catamarca" },
            { "timezone.excity.America/Port_of_Spain", "Port of Spain" },
            { "America/Indiana/Marengo", America_Eastern },
            { "timezone.excity.America/Rankin_Inlet", "Rankin Inlet" },
            { "America/Punta_Arenas",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.America/Santarem", "Santarem" },
            { "timezone.excity.Europe/Helsinki", "Helsinki" },
            { "America/Mexico_City", America_Central },
            { "timezone.excity.America/Yakutat", "Yakutat" },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "timezone.excity.Asia/Anadyr", "Anadyr" },
            { "timezone.excity.Asia/Urumqi", "Urumqi" },
            { "timezone.excity.America/Costa_Rica", "Costa Rica" },
            { "timezone.excity.Africa/Lagos", "Lagos" },
            { "timezone.excity.Africa/Bissau", "Bissau" },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "timezone.excity.Africa/Douala", "Douala" },
            { "Europe/Oslo", Europe_Central },
            { "timezone.excity.Africa/Mogadishu", "Mogadishu" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
            { "timezone.excity.Asia/Jayapura", "Jayapura" },
            { "America/Menominee", America_Central },
            { "timezone.excity.Pacific/Guadalcanal", "Guadalcanal" },
            { "America/Resolute", America_Central },
            { "timezone.excity.Africa/Lome", "Lome" },
            { "timezone.excity.America/Nassau", "Nassau" },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "timezone.excity.Asia/Kuwait", "Kuwait" },
            { "timezone.excity.America/Santo_Domingo", "Santo Domingo" },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "timezone.excity.Europe/Moscow", "Mosikou" },
            { "Africa/Bujumbura", Africa_Central },
            { "Europe/Minsk", Moscow },
            { "Pacific/Auckland", New_Zealand },
            { "timezone.excity.Asia/Taipei", "Taipei" },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "America/Port-au-Prince", America_Eastern },
            { "Europe/Belfast",
                new String[] {
                    "houa fakakiliniuisi m\u0101lie",
                    "",
                    "houa fakapilit\u0101nia taimi liliu",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Ashgabat", Turkmenistan },
            { "timezone.excity.Asia/Dhaka", "Dhaka" },
            { "America/Nipigon", America_Eastern },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "America/Lima", Peru },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "America/Vancouver", America_Pacific },
            { "timezone.excity.America/Marigot", "Marigot" },
            { "Africa/Blantyre", Africa_Central },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "timezone.excity.Africa/Lubumbashi", "Lubumbashi" },
            { "Asia/Hong_Kong", Hong_Kong },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulaanbaatar" },
            { "timezone.excity.Antarctica/McMurdo", "McMurdo" },
            { "Asia/Sakhalin", Sakhalin },
            { "timezone.excity.Asia/Novosibirsk", "Novosibirsk" },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "timezone.excity.Africa/Nairobi", "Nairobi" },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "timezone.excity.Pacific/Fakaofo", "Fakaofo" },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Astrakhan",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "timezone.excity.Asia/Tokyo", "Tokyo" },
            { "Asia/Saigon", Indochina },
            { "timezone.excity.Africa/Johannesburg", "Johannesburg" },
            { "Africa/Timbuktu", GMT },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "timezone.excity.Europe/Dublin", "Dublin" },
            { "timezone.excity.Antarctica/Casey", "Casey" },
            { "timezone.excity.Atlantic/Cape_Verde", "Cape Verde" },
            { "timezone.excity.Africa/Maputo", "Maputo" },
            { "timezone.excity.Africa/Luanda", "Luanda" },
            { "timezone.excity.America/Goose_Bay", "Goose Bay" },
            { "timezone.excity.America/Eirunepe", "Eirunepe" },
            { "timezone.excity.America/Los_Angeles", "Los Angeles" },
            { "America/Whitehorse", America_Pacific },
            { "timezone.excity.America/Cuiaba", "Cuiaba" },
            { "Pacific/Noumea", New_Caledonia },
            { "timezone.excity.Atlantic/Azores", "Azores" },
            { "timezone.excity.Australia/Melbourne", "Melipoane" },
            { "America/Montreal", America_Eastern },
            { "timezone.excity.America/Anguilla", "Anguilla" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "timezone.excity.Australia/Brisbane", "Pelisipane" },
            { "timezone.excity.Indian/Antananarivo", "Antananarivo" },
            { "SystemV/MST7MDT", America_Mountain },
            { "timezone.excity.America/Manaus", "Manaus" },
            { "timezone.excity.Asia/Vientiane", "Vientiane" },
            { "America/Grenada", Atlantic },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "timezone.excity.Indian/Christmas", "Christmas" },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "timezone.excity.Asia/Aqtau", "Aqtau" },
            { "timezone.excity.America/Regina", "Regina" },
            { "SystemV/YST9YDT", Alaska },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "timezone.excity.America/Thunder_Bay", "Thunder Bay" },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "Asia/Hebron", Europe_Eastern },
            { "SystemV/PST8PDT", America_Pacific },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "timezone.excity.America/Louisville", "Louisville" },
            { "timezone.excity.America/Cancun", "Cancun" },
            { "timezone.excity.Australia/Broken_Hill", "Broken Hill" },
            { "timezone.excity.Europe/Kaliningrad", "Kaliningrad" },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Pacific/Kiritimati", "Kiritimati" },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "timezone.excity.Europe/Tirane", "Tirane" },
            { "timezone.excity.Europe/Prague", "Prague" },
            { "timezone.excity.Pacific/Tarawa", "Talava" },
            { "Europe/Vatican", Europe_Central },
            { "timezone.excity.America/Asuncion", "Asunci\u00f3n" },
            { "Asia/Amman", Europe_Eastern },
            { "timezone.excity.Europe/Chisinau", "Chisinau" },
            { "timezone.excity.America/Moncton", "Moncton" },
            { "Asia/Singapore", Singapore },
            { "timezone.excity.America/Guatemala", "Guatemala" },
            { "SystemV/EST5EDT", America_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "timezone.excity.Europe/Vilnius", "Vilnius" },
            { "Europe/Monaco", Europe_Central },
            { "timezone.excity.America/Chicago", "Chicago" },
            { "America/Cuiaba", Amazon },
            { "timezone.excity.Europe/San_Marino", "San Marino" },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "timezone.excity.Pacific/Ponape", "Ponap\u0113" },
            { "timezone.excity.Asia/Irkutsk", "Irkutsk" },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "timezone.excity.Europe/Skopje", "Skopje" },
            { "timezone.excity.America/Chihuahua", "Chihuahua" },
            { "America/Belize", America_Central },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjavik" },
            { "timezone.excity.Asia/Kamchatka", "Kamchatka" },
            { "Europe/Warsaw", Europe_Central },
            { "Pacific/Yap", Truk },
            { "timezone.excity.Asia/Yakutsk", "Yakutsk" },
            { "timezone.excity.Africa/Djibouti", "Djibouti" },
            { "America/Tegucigalpa", America_Central },
            { "timezone.excity.America/Recife", "Recife" },
            { "timezone.excity.Pacific/Wallis", "\u02bbUvea" },
            { "America/Miquelon", Pierre_Miquelon },
            { "timezone.excity.Africa/Porto-Novo", "Porto-Novo" },
            { "timezone.excity.Antarctica/Palmer", "Palmer" },
            { "timezone.excity.Asia/Tashkent", "Tashkent" },
            { "timezone.excity.America/Argentina/San_Juan", "San Juan" },
            { "timezone.excity.Antarctica/Rothera", "Rothera" },
            { "timezone.excity.Asia/Shanghai", "Shanghai" },
            { "timezone.excity.America/Juneau", "Juneau" },
            { "timezone.excity.Pacific/Apia", "Apia" },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "timezone.excity.America/El_Salvador", "El Salvador" },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "timezone.excity.Pacific/Easter", "Lapanui" },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Indian/Comoro", Africa_Eastern },
            { "timezone.excity.Pacific/Niue", "Niu\u0113" },
            { "timezone.excity.America/Menominee", "Menominee" },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "timezone.excity.Australia/Lord_Howe", "Lord Howe" },
            { "Indian/Reunion", Reunion },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "timezone.excity.Asia/Magadan", "Magadan" },
            { "timezone.excity.Pacific/Wake", "Wake" },
            { "timezone.excity.Atlantic/Canary", "Canary" },
            { "Africa/Mogadishu", Africa_Eastern },
            { "timezone.excity.America/Glace_Bay", "Glace Bay" },
            { "timezone.excity.Africa/Casablanca", "Casablanca" },
            { "Etc/GMT", GMT },
            { "timezone.excity.America/Kralendijk", "Kralendijk" },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "timezone.excity.Asia/Yerevan", "Yerevan" },
            { "timezone.excity.America/Creston", "Creston" },
            { "timezone.excity.Africa/Cairo", "Cairo" },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "timezone.excity.Europe/Warsaw", "Warsaw" },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Sarajevo", Europe_Central },
            { "America/Cordoba", Argentina },
            { "America/Regina", America_Central },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/Anguilla", Atlantic },
            { "Europe/Saratov",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "America/Havana", Cuba },
            { "timezone.excity.America/Edmonton", "Edmonton" },
            { "timezone.excity.Africa/Sao_Tome", "Sao Tom\u00e9" },
            { "timezone.excity.America/Dawson", "Dawson" },
            { "timezone.excity.Africa/Abidjan", "Abidjan" },
            { "America/Barbados", Atlantic },
            { "timezone.excity.America/Guadeloupe", "Guadeloupe" },
            { "timezone.excity.Africa/Freetown", "Freetown" },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "timezone.excity.America/Fortaleza", "Fortaleza" },
            { "timezone.excity.Europe/Vatican", "Vatikani" },
            { "timezone.excity.Asia/Almaty", "Almaty" },
            { "timezone.excity.Asia/Tbilisi", "Tbilisi" },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "timezone.excity.Europe/Andorra", "Andorra" },
            { "timezone.excity.Europe/Minsk", "Minsk" },
            { "America/Curacao", Atlantic },
            { "timezone.excity.Africa/Monrovia", "Monrovia" },
            { "America/Guayaquil", Ecuador },
            { "timezone.excity.Africa/Mbabane", "Mbabane" },
            { "timezone.excity.America/Rainy_River", "Rainy River" },
            { "timezone.excity.Asia/Beirut", "Beirut" },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Rankin_Inlet", America_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "timezone.excity.Asia/Pontianak", "Pontianak" },
            { "timezone.excity.America/Adak", "Adak" },
            { "Europe/Zagreb", Europe_Central },
            { "timezone.excity.America/Toronto", "Toronto" },
            { "America/Port_of_Spain", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "timezone.excity.Asia/Baghdad", "Baghdad" },
            { "Pacific/Bougainville",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "timezone.excity.America/Metlakatla", "Metlakatla" },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "timezone.excity.America/Maceio", "Maceio" },
            { "timezone.excity.America/Guayaquil", "Guayaquil" },
            { "Africa/Ndjamena", Africa_Western },
            { "timezone.excity.America/Panama", "Panama" },
            { "timezone.excity.Europe/Simferopol", "Simferopol" },
            { "timezone.excity.Indian/Kerguelen", "Kerguelen" },
            { "timezone.excity.Europe/Volgograd", "Volgograd" },
            { "timezone.excity.Europe/Monaco", "Monaco" },
            { "Asia/Tashkent", Uzbekistan },
            { "Africa/Ceuta", Europe_Central },
            { "timezone.excity.America/La_Paz", "La Paz" },
            { "timezone.excity.Africa/Tripoli", "Tripoli" },
            { "America/Swift_Current", America_Central },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Asia/Pyongyang", "Pyongyang" },
            { "timezone.excity.Europe/Bucharest", "Bucharest" },
            { "America/Metlakatla", Alaska },
            { "timezone.excity.Europe/Athens", "\u02bbAtenisi" },
            { "Africa/Djibouti", Africa_Eastern },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "timezone.excity.America/Porto_Velho", "Porto Velho" },
            { "Europe/Prague", Europe_Central },
            { "timezone.excity.America/Managua", "Managua" },
            { "America/Kralendijk", Atlantic },
            { "Indian/Christmas", Christmas },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "timezone.excity.America/Montserrat", "Montserrat" },
            { "America/Moncton", Atlantic },
            { "timezone.excity.Europe/Copenhagen", "Copenhagen" },
            { "timezone.excity.Australia/Darwin", "Darwin" },
            { "America/St_Vincent", Atlantic },
            { "PST8PDT", America_Pacific },
            { "timezone.excity.Asia/Jerusalem", "Sel\u016bsalema" },
            { "Atlantic/Faeroe", Europe_Western },
            { "timezone.excity.Asia/Riyadh", "Riyadh" },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "timezone.excity.Africa/Bangui", "Bangui" },
            { "timezone.excity.Africa/Lusaka", "Lusaka" },
            { "Atlantic/Azores", Azores },
            { "timezone.excity.Asia/Ust-Nera", "Ust-Nera" },
            { "timezone.excity.Asia/Damascus", "Damascus" },
            { "Pacific/Pitcairn", Pitcairn },
            { "timezone.excity.Pacific/Kosrae", "Kosilae" },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "timezone.excity.Africa/Brazzaville", "Brazzaville" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Rio Gallegos" },
            { "SystemV/MST7", America_Mountain },
            { "America/Dominica", Atlantic },
            { "timezone.excity.America/Bahia", "Bahia" },
            { "America/Mendoza", Argentina },
            { "timezone.excity.Asia/Tehran", "Tehran" },
            { "timezone.excity.Pacific/Tahiti", "Tahisi" },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar es Salaam" },
            { "timezone.excity.America/Monterrey", "Monterrey" },
            { "Pacific/Wake", Wake },
            { "timezone.excity.America/Belem", "Belem" },
            { "Asia/Chongqing", China },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "timezone.excity.Asia/Makassar", "Makassar" },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "timezone.excity.Asia/Yekaterinburg", "Yekaterinburg" },
            { "timezone.excity.Europe/Sofia", "Sofia" },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "timezone.excity.America/Yellowknife", "Yellowknife" },
            { "timezone.excity.Europe/Belgrade", "Belgrade" },
            { "timezone.excity.America/Puerto_Rico", "Puerto Rico" },
            { "timezone.excity.America/Denver", "Denver" },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "timezone.excity.Asia/Gaza", "Gaza" },
            { "timezone.excity.Africa/Ceuta", "Ceuta" },
            { "Africa/Libreville", Africa_Western },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "timezone.excity.Antarctica/Troll", "Troll" },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Hong_Kong", "Hong Kong" },
            { "timezone.excity.America/Port-au-Prince", "Port-au-Prince" },
            { "America/Tijuana", America_Pacific },
            { "timezone.excity.Australia/Eucla", "Eucla" },
            { "timezone.excity.America/Mexico_City", "Mexico City" },
            { "timezone.excity.Pacific/Kwajalein", "Kwajalein" },
            { "SystemV/YST9", Gambier },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "timezone.excity.Europe/Lisbon", "Lisbon" },
            { "timezone.excity.Pacific/Gambier", "Gambier" },
            { "timezone.excity.America/Boise", "Boise" },
            { "America/Santiago", Chile },
            { "timezone.excity.Europe/Zaporozhye", "Zaporozhye" },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.America/Dominica", "Dominica" },
            { "Asia/Taipei", Taipei },
            { "Antarctica/South_Pole", New_Zealand },
            { "timezone.excity.Africa/Kampala", "Kampala" },
            { "timezone.excity.Pacific/Chatham", "Chatham" },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Antarctica/Palmer",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "timezone.excity.Asia/Colombo", "Colombo" },
            { "timezone.excity.Pacific/Port_Moresby", "Port Moresby" },
            { "America/Creston", America_Mountain },
            { "timezone.excity.America/Mendoza", "Mendoza" },
            { "Asia/Vientiane", Indochina },
            { "timezone.excity.America/Noronha", "Noronha" },
            { "timezone.excity.Asia/Sakhalin", "Sakhalin" },
            { "Pacific/Kiritimati", Line_Islands },
            { "timezone.excity.America/Nipigon", "Nipigon" },
            { "timezone.excity.Europe/Guernsey", "Guernsey" },
            { "timezone.excity.America/Argentina/San_Luis", "San Luis" },
            { "timezone.excity.Europe/Riga", "Riga" },
            { "timezone.excity.America/Araguaina", "Araguaina" },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "timezone.excity.America/Cordoba", "Cordoba" },
            { "timezone.excity.America/Cambridge_Bay", "Cambridge Bay" },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "timezone.excity.America/Campo_Grande", "Campo Grande" },
            { "timezone.excity.Africa/Blantyre", "Blantyre" },
            { "timezone.excity.Europe/Malta", "Malta" },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "timezone.excity.Australia/Sydney", "Sen\u0113" },
            { "timezone.excity.Asia/Qatar", "Qatar" },
            { "timezone.excity.America/Sitka", "Sitka" },
            { "SystemV/EST5", America_Eastern },
            { "timezone.excity.Antarctica/Davis", "Davis" },
            { "America/Santo_Domingo", Atlantic },
            { "timezone.excity.America/Aruba", "Aruba" },
            { "timezone.excity.Asia/Qyzylorda", "Qyzylorda" },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Magadan", Magadan },
            { "SystemV/PST8", Pitcairn },
            { "timezone.excity.Indian/Mauritius", "Mauritius" },
            { "America/St_Barthelemy", Atlantic },
            { "timezone.excity.America/Argentina/La_Rioja", "La Rioja" },
            { "Africa/Luanda", Africa_Western },
            { "timezone.excity.Europe/Mariehamn", "Mariehamn" },
            { "timezone.excity.America/St_Barthelemy", "St. Barth\u00e9lemy" },
            { "timezone.excity.America/Santiago", "Santiago" },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "timezone.excity.Asia/Oral", "Oral" },
            { "America/Cancun", America_Eastern },
            { "timezone.excity.Asia/Manila", "Manila" },
            { "Pacific/Kosrae", Kosrae },
            { "Australia/Sydney", Australia_Eastern },
            { "timezone.excity.America/Indianapolis", "Indianapolis" },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "timezone.excity.Asia/Seoul", "Seoul" },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "timezone.excity.Europe/Busingen", "Busingen" },
            { "Europe/Volgograd", Volgograd },
            { "America/Lower_Princes", Atlantic },
            { "timezone.excity.Europe/Istanbul", "Istanbul" },
            { "America/Rio_Branco", Acre },
            { "timezone.excity.Europe/Sarajevo", "Sarajevo" },
            { "America/Danmarkshavn", GMT },
            { "timezone.excity.Africa/Ndjamena", "Ndjamena" },
            { "timezone.excity.Africa/Kigali", "Kigali" },
            { "timezone.excity.Asia/Vladivostok", "Vladivostok" },
            { "Africa/Lusaka", Africa_Central },
            { "timezone.excity.Africa/Tunis", "Tunis" },
            { "timezone.excity.Asia/Macau", "Macau" },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "SystemV/CST6CDT", America_Central },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "timezone.excity.Asia/Samarkand", "Samarkand" },
            { "Africa/Khartoum", Africa_Central },
            { "timezone.excity.Australia/Adelaide", "Atelaite" },
            { "timezone.excity.Asia/Singapore", "Singapore" },
            { "Europe/Belgrade", Europe_Central },
            { "timezone.excity.Europe/Vienna", "Vienna" },
            { "Africa/Bissau", GMT },
            { "timezone.excity.America/Cayman", "Cayman" },
            { "timezone.excity.Europe/Bratislava", "Bratislava" },
            { "Asia/Tehran", Iran },
            { "timezone.excity.America/Barbados", "Barbados" },
            { "timezone.excity.Asia/Nicosia", "Nicosia" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "timezone.excity.Asia/Dili", "Dili" },
            { "timezone.excity.Asia/Omsk", "Omsk" },
            { "timezone.excity.Africa/Bujumbura", "Bujumbura" },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "timezone.excity.America/Mazatlan", "Mazatlan" },
            { "timezone.excity.Asia/Brunei", "Brunei" },
            { "timezone.excity.America/Whitehorse", "Whitehorse" },
            { "timezone.excity.Asia/Kuching", "Kuching" },
            { "timezone.excity.America/Halifax", "Halifax" },
            { "timezone.excity.America/Merida", "Merida" },
            { "America/Pangnirtung", America_Eastern },
            { "timezone.excity.Pacific/Palau", "Palau" },
            { "Asia/Katmandu", Nepal },
            { "timezone.excity.Pacific/Auckland", "\u02bbAokalani" },
            { "Africa/Niamey", Africa_Western },
            { "timezone.excity.Pacific/Norfolk", "Noaf\u014dki" },
            { "Asia/Tbilisi", Georgia },
            { "timezone.excity.Asia/Ashgabat", "Ashgabat" },
            { "timezone.excity.Pacific/Tongatapu", "Tongatapu" },
            { "timezone.excity.Antarctica/Syowa", "Syowa" },
            { "timezone.excity.America/Jamaica", "Jamaica" },
            { "timezone.excity.America/Hermosillo", "Hermosillo" },
            { "timezone.excity.Pacific/Funafuti", "Funafuti" },
            { "timezone.excity.Europe/Podgorica", "Podgorica" },
            { "timezone.excity.Indian/Reunion", "R\u00e9union" },
            { "timezone.excity.Pacific/Noumea", "Noumea" },
            { "timezone.excity.Asia/Aden", "Aden" },
            { "timezone.excity.Europe/Oslo", "Oslo" },
            { "America/Boa_Vista", Amazon },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Famagusta",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Bratislava", Europe_Central },
            { "timezone.excity.Atlantic/Stanley", "Stanley" },
            { "Pacific/Tongatapu", Tonga },
            { "timezone.excity.Asia/Rangoon", "Rangoon" },
            { "timezone.excity.Asia/Thimphu", "Thimphu" },
            { "Europe/Ulyanovsk",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Asia/Dubai", "Dubai" },
            { "Arctic/Longyearbyen", Europe_Central },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuala Lumpur" },
            { "America/Guadeloupe", Atlantic },
            { "Indian/Kerguelen", French_Southern },
            { "timezone.excity.Africa/Ouagadougou", "Ouagadougou" },
            { "timezone.excity.Africa/Gaborone", "Gaborone" },
            { "Asia/Srednekolymsk",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Anadyr", Anadyr },
            { "timezone.excity.Indian/Chagos", "Chagos" },
            { "timezone.excity.Asia/Kabul", "Kabul" },
            { "timezone.excity.America/Iqaluit", "Iqaluit" },
            { "America/Winnipeg", America_Central },
            { "timezone.excity.Europe/Amsterdam", "Amsterdam" },
            { "timezone.excity.Atlantic/Bermuda", "Bermuda" },
            { "timezone.excity.Pacific/Saipan", "Saipan" },
            { "timezone.excity.Indian/Cocos", "Cocos" },
            { "timezone.excity.Australia/Currie", "Currie" },
            { "SystemV/AST4ADT", Atlantic },
            { "timezone.excity.Asia/Amman", "Amman" },
            { "America/Toronto", America_Eastern },
            { "timezone.excity.Europe/Brussels", "Brussels" },
            { "Australia/Lindeman", Australia_Eastern },
            { "timezone.excity.Atlantic/Madeira", "Madeira" },
            { "timezone.excity.Indian/Comoro", "Comoro" },
            { "timezone.excity.America/Boa_Vista", "Boa Vista" },
            { "Pacific/Majuro", Marshall_Islands },
            { "timezone.excity.Europe/Stockholm", "Stockholm" },
            { "timezone.excity.Europe/Samara", "Samara" },
            { "timezone.excity.America/Tijuana", "Tijuana" },
            { "timezone.excity.Indian/Maldives", "Maldives" },
        };
        return data;
    }
}
