/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceConfig;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceParserHelper;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

public class TermsValuesSourceBuilder
extends CompositeValuesSourceBuilder<TermsValuesSourceBuilder> {
    static final String TYPE = "terms";
    private static final ObjectParser<TermsValuesSourceBuilder, Void> PARSER = new ObjectParser("terms");

    static TermsValuesSourceBuilder parse(String name, XContentParser parser) throws IOException {
        return (TermsValuesSourceBuilder)PARSER.parse(parser, (Object)new TermsValuesSourceBuilder(name), null);
    }

    public TermsValuesSourceBuilder(String name) {
        super(name);
    }

    protected TermsValuesSourceBuilder(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    protected CompositeValuesSourceConfig innerBuild(QueryShardContext queryShardContext, ValuesSourceConfig<?> config) throws IOException {
        Object vs = config.toValuesSource(queryShardContext);
        if (vs == null) {
            vs = ValuesSource.Bytes.WithOrdinals.EMPTY;
        }
        MappedFieldType fieldType = config.fieldContext() != null ? config.fieldContext().fieldType() : null;
        DocValueFormat format = this.format() == null && fieldType instanceof DateFieldMapper.DateFieldType ? DocValueFormat.RAW : config.format();
        return new CompositeValuesSourceConfig(this.name, fieldType, (ValuesSource)vs, format, this.order(), this.missingBucket());
    }

    static {
        CompositeValuesSourceParserHelper.declareValuesSourceFields(PARSER, null);
    }
}

