/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.ColumnIterable;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Estimator;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.TimeRepresentation;
import org.gephi.graph.api.types.IntervalBooleanMap;
import org.gephi.graph.api.types.IntervalByteMap;
import org.gephi.graph.api.types.IntervalCharMap;
import org.gephi.graph.api.types.IntervalDoubleMap;
import org.gephi.graph.api.types.IntervalFloatMap;
import org.gephi.graph.api.types.IntervalIntegerMap;
import org.gephi.graph.api.types.IntervalLongMap;
import org.gephi.graph.api.types.IntervalMap;
import org.gephi.graph.api.types.IntervalSet;
import org.gephi.graph.api.types.IntervalShortMap;
import org.gephi.graph.api.types.IntervalStringMap;
import org.gephi.graph.api.types.TimeMap;
import org.gephi.graph.api.types.TimeSet;
import org.gephi.graph.api.types.TimestampBooleanMap;
import org.gephi.graph.api.types.TimestampByteMap;
import org.gephi.graph.api.types.TimestampCharMap;
import org.gephi.graph.api.types.TimestampDoubleMap;
import org.gephi.graph.api.types.TimestampFloatMap;
import org.gephi.graph.api.types.TimestampIntegerMap;
import org.gephi.graph.api.types.TimestampLongMap;
import org.gephi.graph.api.types.TimestampMap;
import org.gephi.graph.api.types.TimestampSet;
import org.gephi.graph.api.types.TimestampShortMap;
import org.gephi.graph.api.types.TimestampStringMap;
import org.gephi.graph.impl.ColumnImpl;
import org.gephi.graph.impl.ColumnStore;
import org.gephi.graph.impl.GraphStore;
import org.gephi.graph.impl.GraphStoreConfiguration;
import org.gephi.graph.impl.GraphViewImpl;
import org.gephi.graph.impl.TimeAttributeIterable;
import org.gephi.graph.impl.TimeIndexStore;

public abstract class ElementImpl
implements Element {
    protected final GraphStore graphStore;
    protected Object[] attributes;

    public ElementImpl(Object id, GraphStore graphStore) {
        if (id == null) {
            throw new NullPointerException();
        }
        this.graphStore = graphStore;
    }

    abstract ColumnStore getColumnStore();

    abstract TimeIndexStore getTimeIndexStore();

    abstract boolean isValid();

    @Override
    public Object getId() {
        return this.attributes[0];
    }

    @Override
    public String getLabel() {
        if (this.attributes.length > 1) {
            return (String)this.attributes[1];
        }
        return null;
    }

    @Override
    public Object getAttribute(String key) {
        return this.getAttribute(this.checkColumnExists(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getAttribute(Column column) {
        this.checkColumn(column);
        int index = column.getIndex();
        Object res = null;
        ElementImpl elementImpl = this;
        synchronized (elementImpl) {
            if (index < this.attributes.length) {
                res = this.attributes[index];
            }
        }
        if (res == null) {
            return column.getDefaultValue();
        }
        return res;
    }

    @Override
    public Object getAttribute(String key, double timestamp) {
        return this.getAttribute(this.checkColumnExists(key), timestamp);
    }

    @Override
    public Object getAttribute(Column column, double timestamp) {
        this.checkTimeRepresentationTimestamp();
        this.checkDouble(timestamp);
        return this.getTimeAttribute(column, timestamp);
    }

    @Override
    public Object getAttribute(String key, Interval interval) {
        return this.getAttribute(this.checkColumnExists(key), interval);
    }

    @Override
    public Object getAttribute(Column column, Interval interval) {
        this.checkTimeRepresentationInterval();
        return this.getTimeAttribute(column, interval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getTimeAttribute(Column column, Object timeObject) {
        this.checkColumn(column);
        this.checkColumnDynamic(column);
        int index = column.getIndex();
        ElementImpl elementImpl = this;
        synchronized (elementImpl) {
            TimeMap dynamicValue = null;
            if (index < this.attributes.length) {
                dynamicValue = (TimeMap)this.attributes[index];
            }
            if (dynamicValue != null) {
                return dynamicValue.get(timeObject, column.getDefaultValue());
            }
        }
        return null;
    }

    @Override
    public Object getAttribute(String key, GraphView view) {
        return this.getAttribute(this.checkColumnExists(key), view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getAttribute(Column column, GraphView view) {
        this.checkColumn(column);
        if (!column.isDynamic()) {
            return this.getAttribute(column);
        }
        Interval interval = view.getTimeInterval();
        this.checkViewExist(view);
        int index = column.getIndex();
        ElementImpl elementImpl = this;
        synchronized (elementImpl) {
            TimeMap dynamicValue = null;
            if (index < this.attributes.length) {
                dynamicValue = (TimeMap)this.attributes[index];
            }
            if (dynamicValue != null && !dynamicValue.isEmpty()) {
                Estimator estimator = column.getEstimator();
                if (estimator == null) {
                    estimator = GraphStoreConfiguration.DEFAULT_ESTIMATOR;
                }
                return dynamicValue.get(interval, estimator);
            }
        }
        return null;
    }

    @Override
    public Object[] getAttributes() {
        return this.attributes;
    }

    @Override
    public Set<String> getAttributeKeys() {
        return this.getColumnStore().getColumnKeys();
    }

    @Override
    public ColumnIterable getAttributeColumns() {
        return this.getColumnStore();
    }

    @Override
    public Object removeAttribute(String key) {
        return this.removeAttribute(this.checkColumnExists(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object removeAttribute(Column column) {
        this.checkColumn(column);
        this.checkReadOnlyColumn(column);
        int index = column.getIndex();
        Object oldValue = null;
        ElementImpl elementImpl = this;
        synchronized (elementImpl) {
            if (index >= this.attributes.length) {
                Object[] newArray = new Object[index + 1];
                System.arraycopy(this.attributes, 0, newArray, 0, this.attributes.length);
                this.attributes = newArray;
            } else {
                oldValue = this.attributes[index];
            }
            this.attributes[index] = null;
        }
        if (this.isValid()) {
            ColumnStore columnStore = this.getColumnStore();
            ColumnImpl columnImpl = (ColumnImpl)column;
            if (columnImpl.isDynamic() && oldValue != null) {
                TimeIndexStore timeIndexStore = this.getTimeIndexStore();
                if (timeIndexStore != null) {
                    if (TimeMap.class.isAssignableFrom(columnImpl.getTypeClass())) {
                        timeIndexStore.remove((TimeMap)oldValue);
                    } else if (TimeSet.class.isAssignableFrom(columnImpl.getTypeClass())) {
                        timeIndexStore.remove((TimeSet)oldValue);
                    }
                }
            } else if (column.isIndexed() && columnStore != null && this.isValid()) {
                columnStore.indexStore.set(column, oldValue, column.getDefaultValue(), this);
            }
            columnImpl.incrementVersion(this);
        }
        return oldValue;
    }

    @Override
    public Object removeAttribute(Column column, double timestamp) {
        this.checkTimeRepresentationTimestamp();
        this.checkDouble(timestamp);
        return this.removeTimeAttribute(column, timestamp);
    }

    @Override
    public Object removeAttribute(String key, double timestamp) {
        return this.removeAttribute(this.checkColumnExists(key), timestamp);
    }

    @Override
    public Object removeAttribute(Column column, Interval interval) {
        this.checkTimeRepresentationInterval();
        return this.removeTimeAttribute(column, interval);
    }

    @Override
    public Object removeAttribute(String key, Interval interval) {
        return this.removeAttribute(this.checkColumnExists(key), interval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object removeTimeAttribute(Column column, Object timeObject) {
        this.checkColumn(column);
        this.checkColumnDynamic(column);
        this.checkReadOnlyColumn(column);
        int index = column.getIndex();
        Object oldValue = null;
        boolean res = false;
        ElementImpl elementImpl = this;
        synchronized (elementImpl) {
            TimeMap dynamicValue = (TimeMap)this.attributes[index];
            if (dynamicValue != null) {
                oldValue = dynamicValue.get(timeObject, null);
                res = dynamicValue.remove(timeObject);
            }
        }
        if (res && this.isValid()) {
            TimeIndexStore timeIndexStore = this.getTimeIndexStore();
            if (timeIndexStore != null) {
                timeIndexStore.remove(timeObject);
            }
            ((ColumnImpl)column).incrementVersion(this);
        }
        return oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLabel(String label) {
        int index = 1;
        ElementImpl elementImpl = this;
        synchronized (elementImpl) {
            if (index >= this.attributes.length) {
                Object[] newArray = new Object[index + 1];
                System.arraycopy(this.attributes, 0, newArray, 0, this.attributes.length);
                this.attributes = newArray;
            }
            this.attributes[index] = label;
        }
        ColumnStore columnStore = this.getColumnStore();
        if (columnStore != null && this.isValid()) {
            Column col = columnStore.getColumnByIndex(index);
            ((ColumnImpl)col).incrementVersion(this);
        }
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.setAttribute(this.checkColumnExists(key), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttribute(Column column, Object value) {
        this.checkColumn(column);
        this.checkReadOnlyColumn(column);
        value = AttributeUtils.standardizeValue(value);
        this.checkType(column, value);
        int index = column.getIndex();
        ColumnStore columnStore = this.getColumnStore();
        Object oldValue = null;
        ElementImpl elementImpl = this;
        synchronized (elementImpl) {
            if (index >= this.attributes.length) {
                Object[] newArray = new Object[index + 1];
                System.arraycopy(this.attributes, 0, newArray, 0, this.attributes.length);
                this.attributes = newArray;
            } else {
                oldValue = this.attributes[index];
            }
            if (column.isDynamic() && this.isValid()) {
                TimeIndexStore timeIndexStore = this.getTimeIndexStore();
                if (timeIndexStore != null) {
                    if (TimeMap.class.isAssignableFrom(column.getTypeClass())) {
                        if (oldValue != null && oldValue instanceof TimeMap) {
                            timeIndexStore.remove((TimeMap)oldValue);
                        }
                        if (value != null) {
                            timeIndexStore.add((TimeMap)value);
                        }
                    } else if (TimeSet.class.isAssignableFrom(column.getTypeClass()) && column.getIndex() == 2) {
                        if (oldValue != null) {
                            timeIndexStore.remove((TimeSet)oldValue);
                        }
                        if (value != null) {
                            timeIndexStore.add((TimeSet)value);
                        }
                    }
                }
            } else if (column.isIndexed() && columnStore != null && this.isValid()) {
                value = columnStore.indexStore.set(column, oldValue, value, this);
            }
            this.attributes[index] = value;
        }
        if (this.isValid()) {
            ((ColumnImpl)column).incrementVersion(this);
        }
    }

    @Override
    public void setAttribute(String key, Object value, double timestamp) {
        this.setAttribute(this.checkColumnExists(key), value, timestamp);
    }

    @Override
    public void setAttribute(Column column, Object value, double timestamp) {
        this.checkTimeRepresentationTimestamp();
        this.checkDouble(timestamp);
        this.setTimeAttribute(column, value, timestamp);
    }

    @Override
    public void setAttribute(String key, Object value, Interval interval) {
        this.setAttribute(this.checkColumnExists(key), value, interval);
    }

    @Override
    public void setAttribute(Column column, Object value, Interval interval) {
        this.checkTimeRepresentationInterval();
        this.setTimeAttribute(column, value, interval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTimeAttribute(Column column, Object value, Object timeObject) {
        TimeIndexStore timeIndexStore;
        boolean res;
        this.checkColumn(column);
        this.checkColumnDynamic(column);
        this.checkReadOnlyColumn(column);
        this.checkType(column, value);
        int index = column.getIndex();
        Object oldValue = null;
        ElementImpl elementImpl = this;
        synchronized (elementImpl) {
            if (index >= this.attributes.length) {
                Object[] newArray = new Object[index + 1];
                System.arraycopy(this.attributes, 0, newArray, 0, this.attributes.length);
                this.attributes = newArray;
            } else {
                oldValue = this.attributes[index];
            }
            TimeMap dynamicValue = null;
            if (oldValue == null) {
                try {
                    dynamicValue = (TimeMap)column.getTypeClass().newInstance();
                    this.attributes[index] = dynamicValue;
                }
                catch (InstantiationException ex) {
                    throw new RuntimeException(ex);
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException(ex);
                }
            } else {
                dynamicValue = (TimeMap)oldValue;
            }
            res = dynamicValue.put(timeObject, value);
        }
        if (res && this.isValid() && (timeIndexStore = this.getTimeIndexStore()) != null) {
            timeIndexStore.add(timeObject);
        }
        if (this.isValid()) {
            ((ColumnImpl)column).incrementVersion(this);
        }
    }

    @Override
    public boolean addTimestamp(double timestamp) {
        this.checkDouble(timestamp);
        this.checkTimeRepresentationTimestamp();
        return this.addTime(timestamp);
    }

    @Override
    public boolean addInterval(Interval interval) {
        this.checkTimeRepresentationInterval();
        return this.addTime(interval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addTime(Object timeObject) {
        boolean res;
        this.checkEnabledTimeSet();
        ElementImpl elementImpl = this;
        synchronized (elementImpl) {
            TimeSet timeSet = this.getTimeSet();
            if (timeSet == null) {
                TimeRepresentation timeRepresentation = this.getTimeRepresentation();
                switch (timeRepresentation) {
                    case INTERVAL: {
                        timeSet = new IntervalSet();
                        break;
                    }
                    case TIMESTAMP: {
                        timeSet = new TimestampSet();
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unrecognized time representation");
                    }
                }
                int index = 2;
                if (index >= this.attributes.length) {
                    Object[] newArray = new Object[index + 1];
                    System.arraycopy(this.attributes, 0, newArray, 0, this.attributes.length);
                    this.attributes = newArray;
                }
                this.attributes[index] = timeSet;
            }
            res = timeSet.add(timeObject);
        }
        if (res && this.isValid()) {
            ColumnStore columnStore;
            TimeIndexStore timeIndexStore = this.getTimeIndexStore();
            if (timeIndexStore != null) {
                timeIndexStore.add(timeObject, this);
            }
            if ((columnStore = this.getColumnStore()) != null) {
                Column column = columnStore.getColumnByIndex(2);
                ((ColumnImpl)column).incrementVersion(this);
            }
        }
        return res;
    }

    @Override
    public boolean removeTimestamp(double timestamp) {
        this.checkDouble(timestamp);
        this.checkTimeRepresentationTimestamp();
        return this.removeTime(timestamp);
    }

    @Override
    public boolean removeInterval(Interval interval) {
        this.checkTimeRepresentationInterval();
        return this.removeTime(interval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeTime(Object timeObject) {
        this.checkEnabledTimeSet();
        boolean res = false;
        ElementImpl elementImpl = this;
        synchronized (elementImpl) {
            TimeSet timeSet = this.getTimeSet();
            if (timeSet != null) {
                res = timeSet.remove(timeObject);
            }
        }
        if (res && this.isValid()) {
            ColumnStore columnStore;
            TimeIndexStore timeIndexStore = this.getTimeIndexStore();
            if (timeIndexStore != null) {
                timeIndexStore.remove(timeObject, this);
            }
            if ((columnStore = this.getColumnStore()) != null) {
                Column column = columnStore.getColumnByIndex(2);
                ((ColumnImpl)column).incrementVersion(this);
            }
        }
        return res;
    }

    @Override
    public double[] getTimestamps() {
        this.checkTimeRepresentationTimestamp();
        Object res = this.getTimeSetArray();
        if (res == null) {
            return new double[0];
        }
        return (double[])res;
    }

    @Override
    public Interval[] getIntervals() {
        this.checkTimeRepresentationInterval();
        Object res = this.getTimeSetArray();
        if (res == null) {
            return new Interval[0];
        }
        return (Interval[])res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getTimeSetArray() {
        this.checkEnabledTimeSet();
        ElementImpl elementImpl = this;
        synchronized (elementImpl) {
            TimeSet timeSet = this.getTimeSet();
            if (timeSet != null) {
                return timeSet.toPrimitiveArray();
            }
        }
        return null;
    }

    @Override
    public boolean hasTimestamp(double timestamp) {
        this.checkTimeRepresentationTimestamp();
        return this.hasTime(timestamp);
    }

    @Override
    public boolean hasInterval(Interval interval) {
        this.checkTimeRepresentationInterval();
        return this.hasTime(interval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasTime(Object timeObject) {
        this.checkEnabledTimeSet();
        ElementImpl elementImpl = this;
        synchronized (elementImpl) {
            TimeSet timeSet = this.getTimeSet();
            if (timeSet != null) {
                return timeSet.contains(timeObject);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<Map.Entry> getAttributes(Column column) {
        this.checkColumn(column);
        this.checkColumnDynamic(column);
        int index = column.getIndex();
        TimeMap dynamicValue = null;
        ElementImpl elementImpl = this;
        synchronized (elementImpl) {
            if (index < this.attributes.length) {
                dynamicValue = (TimeMap)this.attributes[index];
            }
            if (dynamicValue != null) {
                Object[] values = dynamicValue.toValuesArray();
                if (dynamicValue instanceof TimestampMap) {
                    return new TimeAttributeIterable(((TimestampMap)dynamicValue).getTimestamps(), values);
                }
                if (dynamicValue instanceof IntervalMap) {
                    return new TimeAttributeIterable(((IntervalMap)dynamicValue).toKeysArray(), values);
                }
            }
        }
        return TimeAttributeIterable.EMPTY_ITERABLE;
    }

    private TimeSet getTimeSet() {
        if (2 < this.attributes.length) {
            return (TimeSet)this.attributes[2];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void indexAttributes() {
        ElementImpl elementImpl = this;
        synchronized (elementImpl) {
            TimeIndexStore timeIndexStore;
            ColumnStore columnStore = this.getColumnStore();
            if (columnStore != null) {
                columnStore.indexStore.index(this);
            }
            if ((timeIndexStore = this.getTimeIndexStore()) != null) {
                timeIndexStore.index(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAttributes() {
        ElementImpl elementImpl = this;
        synchronized (elementImpl) {
            TimeSet timeSet;
            if (this.isValid()) {
                TimeIndexStore timeIndexStore;
                ColumnStore columnStore = this.getColumnStore();
                if (columnStore != null) {
                    columnStore.indexStore.clear(this);
                }
                if ((timeIndexStore = this.getTimeIndexStore()) != null) {
                    timeIndexStore.clear(this);
                }
            }
            if ((timeSet = this.getTimeSet()) != null) {
                timeSet.clear();
            }
            Object[] newAttributes = new Object[]{this.attributes[0]};
            this.attributes = newAttributes;
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + this.getId().hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ElementImpl other = (ElementImpl)obj;
        return this.getId().equals(other.getId());
    }

    protected GraphStore getGraphStore() {
        return this.graphStore;
    }

    protected void checkTimeRepresentationTimestamp() {
        if (!this.getTimeRepresentation().equals((Object)TimeRepresentation.TIMESTAMP)) {
            throw new RuntimeException("Can't use timestamps as the configuration is set to " + (Object)((Object)this.getTimeRepresentation()));
        }
    }

    protected void checkTimeRepresentationInterval() {
        if (!this.getTimeRepresentation().equals((Object)TimeRepresentation.INTERVAL)) {
            throw new RuntimeException("Can't use intervals as the configuration is set to " + (Object)((Object)this.getTimeRepresentation()));
        }
    }

    void checkEnabledTimeSet() {
    }

    void checkDouble(double timestamp) {
        if (Double.isInfinite(timestamp) || Double.isNaN(timestamp)) {
            throw new IllegalArgumentException("Timestamp can't be NaN or infinity");
        }
    }

    Column checkColumnExists(String key) {
        Column col = this.getColumnStore().getColumn(key);
        if (col == null) {
            throw new IllegalArgumentException("The column '" + key + "' is not found");
        }
        return col;
    }

    void checkColumn(Column column) {
        if (column.getIndex() == -1) {
            throw new IllegalArgumentException("The column does not exist");
        }
        ColumnStore columnStore = this.getColumnStore();
        if (columnStore != null && columnStore.getColumnByIndex(column.getIndex()) != column) {
            throw new IllegalArgumentException("The column does not belong to the right column store");
        }
    }

    void checkReadOnlyColumn(Column column) {
        if (column.isReadOnly()) {
            throw new RuntimeException("Can't modify the read-only '" + column.getId() + "' column");
        }
    }

    void checkColumnDynamic(Column column) {
        if (!((ColumnImpl)column).isDynamic()) {
            throw new IllegalArgumentException("The column is not dynamic");
        }
    }

    void checkType(Column column, Object value) {
        if (value != null) {
            Class typeClass = column.getTypeClass();
            if (TimestampMap.class.isAssignableFrom(typeClass)) {
                if (value instanceof Double && !typeClass.equals(TimestampDoubleMap.class) || value instanceof Float && !typeClass.equals(TimestampFloatMap.class) || value instanceof Boolean && !typeClass.equals(TimestampBooleanMap.class) || value instanceof Integer && !typeClass.equals(TimestampIntegerMap.class) || value instanceof Long && !typeClass.equals(TimestampLongMap.class) || value instanceof Short && !typeClass.equals(TimestampShortMap.class) || value instanceof Byte && !typeClass.equals(TimestampByteMap.class) || value instanceof String && !typeClass.equals(TimestampStringMap.class) || value instanceof Character && !typeClass.equals(TimestampCharMap.class)) {
                    throw new IllegalArgumentException("The object class does not match with the dynamic type (" + typeClass.getName() + ")");
                }
            } else if (IntervalMap.class.isAssignableFrom(typeClass)) {
                if (value instanceof Double && !typeClass.equals(IntervalDoubleMap.class) || value instanceof Float && !typeClass.equals(IntervalFloatMap.class) || value instanceof Boolean && !typeClass.equals(IntervalBooleanMap.class) || value instanceof Integer && !typeClass.equals(IntervalIntegerMap.class) || value instanceof Long && !typeClass.equals(IntervalLongMap.class) || value instanceof Short && !typeClass.equals(IntervalShortMap.class) || value instanceof Byte && !typeClass.equals(IntervalByteMap.class) || value instanceof String && !typeClass.equals(IntervalStringMap.class) || value instanceof Character && !typeClass.equals(IntervalCharMap.class)) {
                    throw new IllegalArgumentException("The object class does not match with the dynamic type (" + typeClass.getName() + ")");
                }
            } else if (List.class.isAssignableFrom(typeClass)) {
                if (!(value instanceof List)) {
                    throw new IllegalArgumentException("The object class does not match with the list type (" + typeClass.getName() + ")");
                }
            } else if (Set.class.isAssignableFrom(typeClass)) {
                if (!(value instanceof Set)) {
                    throw new IllegalArgumentException("The object class does not match with the set type (" + typeClass.getName() + ")");
                }
            } else if (Map.class.isAssignableFrom(typeClass)) {
                if (!(value instanceof Map)) {
                    throw new IllegalArgumentException("The object class does not match with the map type (" + typeClass.getName() + ")");
                }
            } else if (!value.getClass().equals(typeClass)) {
                throw new IllegalArgumentException("The object class does not match with the column type (" + typeClass.getName() + ")");
            }
        }
    }

    void checkViewExist(GraphView view) {
        this.graphStore.viewStore.checkNonNullViewObject(view);
        if (!view.isMainView()) {
            this.graphStore.viewStore.checkViewExist((GraphViewImpl)view);
        }
    }

    TimeRepresentation getTimeRepresentation() {
        if (this.graphStore != null) {
            return this.graphStore.configuration.getTimeRepresentation();
        }
        return GraphStoreConfiguration.DEFAULT_TIME_REPRESENTATION;
    }
}

