/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.undo;

import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.data.DataPoint;
import tim.prune.data.Track;
import tim.prune.data.TrackInfo;
import tim.prune.undo.UndoException;
import tim.prune.undo.UndoOperation;

public class UndoMergeTrackSegments
implements UndoOperation {
    private int _startIndex;
    private boolean[] _segmentFlags = null;
    private DataPoint _nextTrackPoint = null;
    private boolean _nextSegmentFlag = false;

    public UndoMergeTrackSegments(Track track, int n, int n2) {
        this._startIndex = n;
        int n3 = n2 - n + 1;
        this._segmentFlags = new boolean[n3];
        int n4 = n;
        while (n4 <= n2) {
            this._segmentFlags[n4 - n] = track.getPoint(n4).getSegmentStart();
            ++n4;
        }
        this._nextTrackPoint = track.getNextTrackPoint(n2 + 1);
        if (this._nextTrackPoint != null) {
            this._nextSegmentFlag = this._nextTrackPoint.getSegmentStart();
        }
    }

    public String getDescription() {
        return I18nManager.getText("undo.mergetracksegments");
    }

    public void performUndo(TrackInfo trackInfo) throws UndoException {
        int n = 0;
        while (n < this._segmentFlags.length) {
            DataPoint dataPoint = trackInfo.getTrack().getPoint(this._startIndex + n);
            if (!dataPoint.isWaypoint()) {
                dataPoint.setSegmentStart(this._segmentFlags[n]);
            }
            ++n;
        }
        if (this._nextTrackPoint != null) {
            this._nextTrackPoint.setSegmentStart(this._nextSegmentFlag);
        }
        UpdateMessageBroker.informSubscribers();
    }
}

