/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject;

import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.exceptions.BeanInstantiationException;
import io.micronaut.inject.BeanDefinition;
import java.util.Optional;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public interface ValidatedBeanDefinition<T>
extends BeanDefinition<T> {
    default public T validate(BeanResolutionContext resolutionContext, T instance) {
        ValidatorFactory validatorFactory;
        Validator validator;
        Set errors;
        Optional<ValidatorFactory> validatorFactoryBean = resolutionContext.getContext().findBean(ValidatorFactory.class);
        if (validatorFactoryBean.isPresent() && !(errors = (validator = (validatorFactory = validatorFactoryBean.get()).getValidator()).validate(instance, new Class[0])).isEmpty()) {
            StringBuilder builder = new StringBuilder();
            builder.append("Validation failed for bean definition [");
            builder.append(instance.getClass().getName());
            builder.append("]\nList of constraint violations:[\n");
            for (ConstraintViolation violation : errors) {
                builder.append("\t").append(violation.getPropertyPath()).append(" - ").append(violation.getMessage()).append("\n");
            }
            builder.append("]");
            throw new BeanInstantiationException(resolutionContext, builder.toString());
        }
        return instance;
    }
}

