/*
 * Decompiled with CFR 0.152.
 */
package SQLite.JDBC2z1;

import SQLite.Exception;
import SQLite.JDBC2z1.JDBCConnection;
import SQLite.JDBC2z1.JDBCResultSet;
import SQLite.JDBC2z1.TableResultX;
import SQLite.TableResult;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;

public class JDBCStatement
implements Statement {
    protected JDBCConnection conn;
    protected JDBCResultSet rs;
    protected int updcnt;
    protected int maxrows = 0;
    private ArrayList<String> batch;

    public JDBCStatement(JDBCConnection jDBCConnection) {
        this.conn = jDBCConnection;
        this.updcnt = 0;
        this.rs = null;
        this.batch = null;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        if (n != 1) {
            throw new SQLException("fetch size not 1");
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 1;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxrows;
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException("max must be >= 0 (was " + n + ")");
        }
        this.maxrows = n;
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1002;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1004;
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("can't set query timeout on a closed statement");
        }
        if (n < 0) {
            throw new SQLException("can't set a query timeout of less than 0 seconds");
        }
        this.conn.timeout = n == 0 ? 5000 : n * 1000;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.conn.timeout / 1000;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResultSet executeQuery(String string, String[] stringArray, boolean bl) throws SQLException {
        TableResult tableResult = null;
        if (this.rs != null) {
            this.rs.close();
            this.rs = null;
        }
        this.updcnt = -1;
        if (this.conn == null || this.conn.db == null) {
            throw new SQLException("stale connection");
        }
        int n = 0;
        boolean bl2 = !this.conn.autocommit && !this.conn.intrans;
        while (true) {
            try {
                if (bl2) {
                    this.conn.db.exec("BEGIN TRANSACTION", null);
                    this.conn.intrans = true;
                }
                if (stringArray == null) {
                    if (bl) {
                        this.conn.db.exec(string, null);
                    } else {
                        tableResult = this.conn.db.get_table(string, this.maxrows);
                    }
                } else if (bl) {
                    this.conn.db.exec(string, null, stringArray);
                } else {
                    tableResult = this.conn.db.get_table(string, this.maxrows, stringArray);
                }
                this.updcnt = (int)this.conn.db.changes();
            }
            catch (Exception exception) {
                if (this.conn.db.is3() && this.conn.db.last_error() == 5 && this.conn.busy3(this.conn.db, ++n)) {
                    try {
                        if (bl2 && this.conn.intrans) {
                            this.conn.db.exec("ROLLBACK", null);
                            this.conn.intrans = false;
                        }
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    try {
                        int n2 = 20 + n * 10;
                        if (n2 > 1000) {
                            n2 = 1000;
                        }
                        JDBCStatement jDBCStatement = this;
                        synchronized (jDBCStatement) {
                            this.wait(n2);
                            continue;
                        }
                    }
                    catch (java.lang.Exception exception3) {
                        continue;
                    }
                }
                throw new SQLException(exception);
            }
            break;
        }
        if (!bl && tableResult == null) {
            throw new SQLException("no result set produced");
        }
        if (!bl && tableResult != null) {
            this.rs = new JDBCResultSet(new TableResultX(tableResult), this);
        }
        return this.rs;
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        return this.executeQuery(string, null, false);
    }

    @Override
    public boolean execute(String string) throws SQLException {
        return this.executeQuery(string) != null;
    }

    @Override
    public void cancel() throws SQLException {
        if (this.conn == null || this.conn.db == null) {
            throw new SQLException("stale connection");
        }
        this.conn.db.interrupt();
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    @Override
    public void addBatch(String string) throws SQLException {
        if (this.batch == null) {
            this.batch = new ArrayList(1);
        }
        this.batch.add(string);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int n;
        if (this.batch == null) {
            return new int[0];
        }
        int[] nArray = new int[this.batch.size()];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = -3;
        }
        n = 0;
        SQLException sQLException = null;
        for (int i = 0; i < nArray.length; ++i) {
            try {
                this.execute(this.batch.get(i));
                nArray[i] = this.updcnt;
                continue;
            }
            catch (SQLException sQLException2) {
                ++n;
                if (sQLException != null) continue;
                sQLException = sQLException2;
            }
        }
        if (n > 0) {
            throw new BatchUpdateException("batch failed", nArray, (Throwable)sQLException);
        }
        return nArray;
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.batch != null) {
            this.batch.clear();
            this.batch = null;
        }
    }

    @Override
    public void close() throws SQLException {
        this.clearBatch();
        this.conn = null;
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        this.executeQuery(string, null, true);
        return this.updcnt;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (this.rs != null) {
            this.rs.close();
            this.rs = null;
        }
        return false;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.updcnt;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public boolean getMoreResults(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        if (n != 2) {
            throw new SQLFeatureNotSupportedException("generated keys not supported");
        }
        return this.executeUpdate(string);
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        if (n != 2) {
            throw new SQLFeatureNotSupportedException("autogenerated keys not supported");
        }
        return this.execute(string);
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.conn == null;
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        if (bl) {
            throw new SQLException("poolable statements not supported");
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLException("unsupported");
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

