/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.logo;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.logo.TinyJavaLogo;
import net.sourceforge.plantuml.logo.TurtleGraphicsPane;
import net.sourceforge.plantuml.png.PngIO;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;

public class PSystemLogo
extends AbstractPSystem {
    private final List<String> lines = new ArrayList<String>();

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat, long seed) throws IOException {
        int width = 640;
        int height = 480;
        EmptyImageBuilder builder = new EmptyImageBuilder(640, 480, Color.WHITE);
        BufferedImage im = builder.getBufferedImage();
        UGraphicG2d ug = new UGraphicG2d(new ColorMapperIdentity(), builder.getGraphics2D(), 1.0);
        ug.setBufferedImage(im);
        TurtleGraphicsPane turtleGraphicsPane = new TurtleGraphicsPane(640, 480);
        TinyJavaLogo tinyJavaLogo = new TinyJavaLogo(turtleGraphicsPane);
        for (String line : this.lines) {
            tinyJavaLogo.doCommandLine(line);
        }
        turtleGraphicsPane.paint(ug);
        PngIO.write((RenderedImage)im, os, 96);
        return new ImageDataSimple(im.getWidth(), im.getHeight());
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Logo)");
    }

    public void doCommandLine(String line) {
        this.lines.add(line);
    }
}

