/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Locale;
import net.htmlparser.jericho.Config;
import net.htmlparser.jericho.Logger;
import net.htmlparser.jericho.LoggerProvider;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Priority;
import org.parosproxy.paros.CommandLine;
import org.parosproxy.paros.network.SSLConnector;
import org.zaproxy.zap.CommandLineBootstrap;
import org.zaproxy.zap.DaemonBootstrap;
import org.zaproxy.zap.GuiBootstrap;
import org.zaproxy.zap.ZapBootstrap;
import org.zaproxy.zap.eventBus.EventBus;
import org.zaproxy.zap.eventBus.SimpleEventBus;

public class ZAP {
    public static final LoggerProvider JERICHO_LOGGER_PROVIDER = new LoggerProviderLog4j();
    private static ProcessType processType;
    private static final EventBus eventBus;
    private static final org.apache.log4j.Logger logger;

    public static void main(String[] args) throws Exception {
        ZAP.setCustomErrStream();
        CommandLine cmdLine = null;
        try {
            cmdLine = new CommandLine(args != null ? Arrays.copyOf(args, args.length) : null);
        }
        catch (Exception e) {
            System.out.println("Failed due to invalid parameters: " + Arrays.toString(args));
            System.out.println(e.getMessage());
            System.out.println("Use '-h' for more details.");
            System.exit(1);
        }
        ZapBootstrap bootstrap = ZAP.createZapBootstrap(cmdLine);
        try {
            int rc = bootstrap.start();
            if (rc != 0) {
                System.exit(rc);
            }
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            System.exit(1);
        }
    }

    private static void setCustomErrStream() {
        System.setErr(new DelegatorPrintStream(System.err){

            @Override
            public void println(String x) {
                if ("Warning: Nashorn engine is planned to be removed from a future JDK release".equals(x)) {
                    return;
                }
                super.println(x);
            }
        });
    }

    private static ZapBootstrap createZapBootstrap(CommandLine cmdLineArgs) {
        ZapBootstrap bootstrap;
        if (cmdLineArgs.isGUI()) {
            processType = ProcessType.desktop;
            bootstrap = new GuiBootstrap(cmdLineArgs);
        } else if (cmdLineArgs.isDaemon()) {
            processType = ProcessType.daemon;
            bootstrap = new DaemonBootstrap(cmdLineArgs);
        } else {
            processType = ProcessType.cmdline;
            bootstrap = new CommandLineBootstrap(cmdLineArgs);
        }
        return bootstrap;
    }

    public static ProcessType getProcessType() {
        return processType;
    }

    public static EventBus getEventBus() {
        return eventBus;
    }

    static {
        eventBus = new SimpleEventBus();
        logger = org.apache.log4j.Logger.getLogger(ZAP.class);
        Thread.setDefaultUncaughtExceptionHandler(new UncaughtExceptionLogger());
        ProtocolSocketFactory sslFactory = null;
        try {
            Protocol protocol = Protocol.getProtocol((String)"https");
            sslFactory = protocol.getSocketFactory();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        if (sslFactory == null || !(sslFactory instanceof SSLConnector)) {
            Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)new SSLConnector(), 443));
        }
        Config.LoggerProvider = JERICHO_LOGGER_PROVIDER;
    }

    private static class LoggerProviderLog4j
    implements LoggerProvider {
        private static volatile Logger sourceLogger = null;

        private LoggerProviderLog4j() {
        }

        public Logger getLogger(String name) {
            return new Log4JLogger(LogManager.getLogger((String)name));
        }

        public Logger getSourceLogger() {
            if (sourceLogger == null) {
                sourceLogger = this.getLogger("net.htmlparser.jericho");
            }
            return sourceLogger;
        }

        private static class Log4JLogger
        implements Logger {
            private final org.apache.log4j.Logger log4JLogger;

            public Log4JLogger(org.apache.log4j.Logger log4JLogger) {
                this.log4JLogger = log4JLogger;
            }

            public void error(String message) {
                this.log4JLogger.error((Object)message);
            }

            public void warn(String message) {
                this.log4JLogger.warn((Object)message);
            }

            public void info(String message) {
                this.log4JLogger.info((Object)message);
            }

            public void debug(String message) {
                this.log4JLogger.debug((Object)message);
            }

            public boolean isErrorEnabled() {
                return this.log4JLogger.isEnabledFor((Priority)Level.ERROR);
            }

            public boolean isWarnEnabled() {
                return this.log4JLogger.isEnabledFor((Priority)Level.WARN);
            }

            public boolean isInfoEnabled() {
                return this.log4JLogger.isEnabledFor((Priority)Level.INFO);
            }

            public boolean isDebugEnabled() {
                return this.log4JLogger.isEnabledFor((Priority)Level.DEBUG);
            }
        }
    }

    private static class DelegatorPrintStream
    extends PrintStream {
        private final PrintStream delegatee;

        public DelegatorPrintStream(PrintStream delegatee) {
            super((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
            this.delegatee = delegatee;
        }

        @Override
        public void flush() {
            this.delegatee.flush();
        }

        @Override
        public void close() {
            this.delegatee.close();
        }

        @Override
        public boolean checkError() {
            return this.delegatee.checkError();
        }

        @Override
        protected void setError() {
        }

        @Override
        protected void clearError() {
        }

        @Override
        public void write(int b) {
            this.delegatee.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.delegatee.write(b);
        }

        @Override
        public void write(byte[] buf, int off, int len) {
            this.delegatee.write(buf, off, len);
        }

        @Override
        public void print(boolean b) {
            this.delegatee.print(b);
        }

        @Override
        public void print(char c) {
            this.delegatee.print(c);
        }

        @Override
        public void print(int i) {
            this.delegatee.print(i);
        }

        @Override
        public void print(long l) {
            this.delegatee.print(l);
        }

        @Override
        public void print(float f) {
            this.delegatee.print(f);
        }

        @Override
        public void print(double d) {
            this.delegatee.print(d);
        }

        @Override
        public void print(char[] s) {
            this.delegatee.print(s);
        }

        @Override
        public void print(String s) {
            this.delegatee.print(s);
        }

        @Override
        public void print(Object obj) {
            this.delegatee.print(obj);
        }

        @Override
        public void println() {
            this.delegatee.println();
        }

        @Override
        public void println(boolean x) {
            this.delegatee.println(x);
        }

        @Override
        public void println(char x) {
            this.delegatee.println(x);
        }

        @Override
        public void println(int x) {
            this.delegatee.println(x);
        }

        @Override
        public void println(long x) {
            this.delegatee.println(x);
        }

        @Override
        public void println(float x) {
            this.delegatee.println(x);
        }

        @Override
        public void println(double x) {
            this.delegatee.println(x);
        }

        @Override
        public void println(char[] x) {
            this.delegatee.println(x);
        }

        @Override
        public void println(String x) {
            this.delegatee.println(x);
        }

        @Override
        public void println(Object x) {
            this.delegatee.println(x);
        }

        @Override
        public PrintStream printf(String format, Object ... args) {
            return this.delegatee.printf(format, args);
        }

        @Override
        public PrintStream printf(Locale l, String format, Object ... args) {
            return this.delegatee.printf(l, format, args);
        }

        @Override
        public PrintStream format(String format, Object ... args) {
            this.delegatee.format(format, args);
            return this;
        }

        @Override
        public PrintStream format(Locale l, String format, Object ... args) {
            this.delegatee.format(l, format, args);
            return this;
        }

        @Override
        public PrintStream append(CharSequence csq) {
            this.delegatee.append(csq);
            return this;
        }

        @Override
        public PrintStream append(CharSequence csq, int start, int end) {
            this.delegatee.append(csq, start, end);
            return this;
        }

        @Override
        public PrintStream append(char c) {
            this.delegatee.append(c);
            return this;
        }
    }

    private static final class UncaughtExceptionLogger
    implements Thread.UncaughtExceptionHandler {
        private static final org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger(UncaughtExceptionLogger.class);
        private static boolean loggerConfigured = false;

        private UncaughtExceptionLogger() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (!(e instanceof ThreadDeath)) {
                if (loggerConfigured || UncaughtExceptionLogger.isLoggerConfigured()) {
                    logger.error((Object)("Exception in thread \"" + t.getName() + "\""), e);
                } else {
                    System.err.println("Exception in thread \"" + t.getName() + "\"");
                    e.printStackTrace();
                }
            }
        }

        private static boolean isLoggerConfigured() {
            if (loggerConfigured) {
                return true;
            }
            Enumeration appenders = LogManager.getRootLogger().getAllAppenders();
            if (appenders.hasMoreElements()) {
                loggerConfigured = true;
            } else {
                Enumeration loggers = LogManager.getCurrentLoggers();
                while (loggers.hasMoreElements()) {
                    org.apache.log4j.Logger c = (org.apache.log4j.Logger)loggers.nextElement();
                    if (!c.getAllAppenders().hasMoreElements()) continue;
                    loggerConfigured = true;
                    break;
                }
            }
            return loggerConfigured;
        }
    }

    public static enum ProcessType {
        cmdline,
        daemon,
        desktop,
        zaas;

    }
}

