﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/iot/IoT_EXPORTS.h>
#include <aws/iot/IoTRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/iot/model/Tag.h>
#include <utility>

namespace Aws
{
namespace IoT
{
namespace Model
{

  /**
   */
  class AWS_IOT_API CreateProvisioningTemplateRequest : public IoTRequest
  {
  public:
    CreateProvisioningTemplateRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "CreateProvisioningTemplate"; }

    Aws::String SerializePayload() const override;


    /**
     * <p>The name of the fleet provisioning template.</p>
     */
    inline const Aws::String& GetTemplateName() const{ return m_templateName; }

    /**
     * <p>The name of the fleet provisioning template.</p>
     */
    inline bool TemplateNameHasBeenSet() const { return m_templateNameHasBeenSet; }

    /**
     * <p>The name of the fleet provisioning template.</p>
     */
    inline void SetTemplateName(const Aws::String& value) { m_templateNameHasBeenSet = true; m_templateName = value; }

    /**
     * <p>The name of the fleet provisioning template.</p>
     */
    inline void SetTemplateName(Aws::String&& value) { m_templateNameHasBeenSet = true; m_templateName = std::move(value); }

    /**
     * <p>The name of the fleet provisioning template.</p>
     */
    inline void SetTemplateName(const char* value) { m_templateNameHasBeenSet = true; m_templateName.assign(value); }

    /**
     * <p>The name of the fleet provisioning template.</p>
     */
    inline CreateProvisioningTemplateRequest& WithTemplateName(const Aws::String& value) { SetTemplateName(value); return *this;}

    /**
     * <p>The name of the fleet provisioning template.</p>
     */
    inline CreateProvisioningTemplateRequest& WithTemplateName(Aws::String&& value) { SetTemplateName(std::move(value)); return *this;}

    /**
     * <p>The name of the fleet provisioning template.</p>
     */
    inline CreateProvisioningTemplateRequest& WithTemplateName(const char* value) { SetTemplateName(value); return *this;}


    /**
     * <p>The description of the fleet provisioning template.</p>
     */
    inline const Aws::String& GetDescription() const{ return m_description; }

    /**
     * <p>The description of the fleet provisioning template.</p>
     */
    inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }

    /**
     * <p>The description of the fleet provisioning template.</p>
     */
    inline void SetDescription(const Aws::String& value) { m_descriptionHasBeenSet = true; m_description = value; }

    /**
     * <p>The description of the fleet provisioning template.</p>
     */
    inline void SetDescription(Aws::String&& value) { m_descriptionHasBeenSet = true; m_description = std::move(value); }

    /**
     * <p>The description of the fleet provisioning template.</p>
     */
    inline void SetDescription(const char* value) { m_descriptionHasBeenSet = true; m_description.assign(value); }

    /**
     * <p>The description of the fleet provisioning template.</p>
     */
    inline CreateProvisioningTemplateRequest& WithDescription(const Aws::String& value) { SetDescription(value); return *this;}

    /**
     * <p>The description of the fleet provisioning template.</p>
     */
    inline CreateProvisioningTemplateRequest& WithDescription(Aws::String&& value) { SetDescription(std::move(value)); return *this;}

    /**
     * <p>The description of the fleet provisioning template.</p>
     */
    inline CreateProvisioningTemplateRequest& WithDescription(const char* value) { SetDescription(value); return *this;}


    /**
     * <p>The JSON formatted contents of the fleet provisioning template.</p>
     */
    inline const Aws::String& GetTemplateBody() const{ return m_templateBody; }

    /**
     * <p>The JSON formatted contents of the fleet provisioning template.</p>
     */
    inline bool TemplateBodyHasBeenSet() const { return m_templateBodyHasBeenSet; }

    /**
     * <p>The JSON formatted contents of the fleet provisioning template.</p>
     */
    inline void SetTemplateBody(const Aws::String& value) { m_templateBodyHasBeenSet = true; m_templateBody = value; }

    /**
     * <p>The JSON formatted contents of the fleet provisioning template.</p>
     */
    inline void SetTemplateBody(Aws::String&& value) { m_templateBodyHasBeenSet = true; m_templateBody = std::move(value); }

    /**
     * <p>The JSON formatted contents of the fleet provisioning template.</p>
     */
    inline void SetTemplateBody(const char* value) { m_templateBodyHasBeenSet = true; m_templateBody.assign(value); }

    /**
     * <p>The JSON formatted contents of the fleet provisioning template.</p>
     */
    inline CreateProvisioningTemplateRequest& WithTemplateBody(const Aws::String& value) { SetTemplateBody(value); return *this;}

    /**
     * <p>The JSON formatted contents of the fleet provisioning template.</p>
     */
    inline CreateProvisioningTemplateRequest& WithTemplateBody(Aws::String&& value) { SetTemplateBody(std::move(value)); return *this;}

    /**
     * <p>The JSON formatted contents of the fleet provisioning template.</p>
     */
    inline CreateProvisioningTemplateRequest& WithTemplateBody(const char* value) { SetTemplateBody(value); return *this;}


    /**
     * <p>True to enable the fleet provisioning template, otherwise false.</p>
     */
    inline bool GetEnabled() const{ return m_enabled; }

    /**
     * <p>True to enable the fleet provisioning template, otherwise false.</p>
     */
    inline bool EnabledHasBeenSet() const { return m_enabledHasBeenSet; }

    /**
     * <p>True to enable the fleet provisioning template, otherwise false.</p>
     */
    inline void SetEnabled(bool value) { m_enabledHasBeenSet = true; m_enabled = value; }

    /**
     * <p>True to enable the fleet provisioning template, otherwise false.</p>
     */
    inline CreateProvisioningTemplateRequest& WithEnabled(bool value) { SetEnabled(value); return *this;}


    /**
     * <p>The role ARN for the role associated with the fleet provisioning template.
     * This IoT role grants permission to provision a device.</p>
     */
    inline const Aws::String& GetProvisioningRoleArn() const{ return m_provisioningRoleArn; }

    /**
     * <p>The role ARN for the role associated with the fleet provisioning template.
     * This IoT role grants permission to provision a device.</p>
     */
    inline bool ProvisioningRoleArnHasBeenSet() const { return m_provisioningRoleArnHasBeenSet; }

    /**
     * <p>The role ARN for the role associated with the fleet provisioning template.
     * This IoT role grants permission to provision a device.</p>
     */
    inline void SetProvisioningRoleArn(const Aws::String& value) { m_provisioningRoleArnHasBeenSet = true; m_provisioningRoleArn = value; }

    /**
     * <p>The role ARN for the role associated with the fleet provisioning template.
     * This IoT role grants permission to provision a device.</p>
     */
    inline void SetProvisioningRoleArn(Aws::String&& value) { m_provisioningRoleArnHasBeenSet = true; m_provisioningRoleArn = std::move(value); }

    /**
     * <p>The role ARN for the role associated with the fleet provisioning template.
     * This IoT role grants permission to provision a device.</p>
     */
    inline void SetProvisioningRoleArn(const char* value) { m_provisioningRoleArnHasBeenSet = true; m_provisioningRoleArn.assign(value); }

    /**
     * <p>The role ARN for the role associated with the fleet provisioning template.
     * This IoT role grants permission to provision a device.</p>
     */
    inline CreateProvisioningTemplateRequest& WithProvisioningRoleArn(const Aws::String& value) { SetProvisioningRoleArn(value); return *this;}

    /**
     * <p>The role ARN for the role associated with the fleet provisioning template.
     * This IoT role grants permission to provision a device.</p>
     */
    inline CreateProvisioningTemplateRequest& WithProvisioningRoleArn(Aws::String&& value) { SetProvisioningRoleArn(std::move(value)); return *this;}

    /**
     * <p>The role ARN for the role associated with the fleet provisioning template.
     * This IoT role grants permission to provision a device.</p>
     */
    inline CreateProvisioningTemplateRequest& WithProvisioningRoleArn(const char* value) { SetProvisioningRoleArn(value); return *this;}


    /**
     * <p>Metadata which can be used to manage the fleet provisioning template.</p>
     * <note> <p>For URI Request parameters use format:
     * ...key1=value1&amp;key2=value2...</p> <p>For the CLI command-line parameter use
     * format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p> <p>For the
     * cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
     * </note>
     */
    inline const Aws::Vector<Tag>& GetTags() const{ return m_tags; }

    /**
     * <p>Metadata which can be used to manage the fleet provisioning template.</p>
     * <note> <p>For URI Request parameters use format:
     * ...key1=value1&amp;key2=value2...</p> <p>For the CLI command-line parameter use
     * format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p> <p>For the
     * cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
     * </note>
     */
    inline bool TagsHasBeenSet() const { return m_tagsHasBeenSet; }

    /**
     * <p>Metadata which can be used to manage the fleet provisioning template.</p>
     * <note> <p>For URI Request parameters use format:
     * ...key1=value1&amp;key2=value2...</p> <p>For the CLI command-line parameter use
     * format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p> <p>For the
     * cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
     * </note>
     */
    inline void SetTags(const Aws::Vector<Tag>& value) { m_tagsHasBeenSet = true; m_tags = value; }

    /**
     * <p>Metadata which can be used to manage the fleet provisioning template.</p>
     * <note> <p>For URI Request parameters use format:
     * ...key1=value1&amp;key2=value2...</p> <p>For the CLI command-line parameter use
     * format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p> <p>For the
     * cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
     * </note>
     */
    inline void SetTags(Aws::Vector<Tag>&& value) { m_tagsHasBeenSet = true; m_tags = std::move(value); }

    /**
     * <p>Metadata which can be used to manage the fleet provisioning template.</p>
     * <note> <p>For URI Request parameters use format:
     * ...key1=value1&amp;key2=value2...</p> <p>For the CLI command-line parameter use
     * format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p> <p>For the
     * cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
     * </note>
     */
    inline CreateProvisioningTemplateRequest& WithTags(const Aws::Vector<Tag>& value) { SetTags(value); return *this;}

    /**
     * <p>Metadata which can be used to manage the fleet provisioning template.</p>
     * <note> <p>For URI Request parameters use format:
     * ...key1=value1&amp;key2=value2...</p> <p>For the CLI command-line parameter use
     * format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p> <p>For the
     * cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
     * </note>
     */
    inline CreateProvisioningTemplateRequest& WithTags(Aws::Vector<Tag>&& value) { SetTags(std::move(value)); return *this;}

    /**
     * <p>Metadata which can be used to manage the fleet provisioning template.</p>
     * <note> <p>For URI Request parameters use format:
     * ...key1=value1&amp;key2=value2...</p> <p>For the CLI command-line parameter use
     * format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p> <p>For the
     * cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
     * </note>
     */
    inline CreateProvisioningTemplateRequest& AddTags(const Tag& value) { m_tagsHasBeenSet = true; m_tags.push_back(value); return *this; }

    /**
     * <p>Metadata which can be used to manage the fleet provisioning template.</p>
     * <note> <p>For URI Request parameters use format:
     * ...key1=value1&amp;key2=value2...</p> <p>For the CLI command-line parameter use
     * format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p> <p>For the
     * cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
     * </note>
     */
    inline CreateProvisioningTemplateRequest& AddTags(Tag&& value) { m_tagsHasBeenSet = true; m_tags.push_back(std::move(value)); return *this; }

  private:

    Aws::String m_templateName;
    bool m_templateNameHasBeenSet;

    Aws::String m_description;
    bool m_descriptionHasBeenSet;

    Aws::String m_templateBody;
    bool m_templateBodyHasBeenSet;

    bool m_enabled;
    bool m_enabledHasBeenSet;

    Aws::String m_provisioningRoleArn;
    bool m_provisioningRoleArnHasBeenSet;

    Aws::Vector<Tag> m_tags;
    bool m_tagsHasBeenSet;
  };

} // namespace Model
} // namespace IoT
} // namespace Aws
