/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import com.google.common.base.Objects;
import java.io.File;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.file.DefaultFilePropertyFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.state.ManagedFactory;

public class ManagedFactories {

    public static class DirectoryPropertyManagedFactory
    implements ManagedFactory {
        private static final Class<?> PUBLIC_TYPE = DirectoryProperty.class;
        private static final Class<?> IMPL_TYPE = DefaultFilePropertyFactory.DefaultDirectoryVar.class;
        public static final int FACTORY_ID = Objects.hashCode((Object[])new Object[]{IMPL_TYPE.getName()});
        private final FileResolver fileResolver;

        public DirectoryPropertyManagedFactory(FileResolver fileResolver) {
            this.fileResolver = fileResolver;
        }

        public <T> T fromState(Class<T> type, Object state) {
            if (!type.isAssignableFrom(PUBLIC_TYPE)) {
                return null;
            }
            return type.cast(new DefaultFilePropertyFactory.DefaultDirectoryVar(this.fileResolver).value((Directory)state));
        }

        public int getId() {
            return FACTORY_ID;
        }
    }

    public static class DirectoryManagedFactory
    implements ManagedFactory {
        private static final Class<?> PUBLIC_TYPE = Directory.class;
        private static final Class<?> IMPL_TYPE = DefaultFilePropertyFactory.FixedDirectory.class;
        public static final int FACTORY_ID = Objects.hashCode((Object[])new Object[]{IMPL_TYPE.getName()});
        private final FileResolver fileResolver;

        public DirectoryManagedFactory(FileResolver fileResolver) {
            this.fileResolver = fileResolver;
        }

        public <T> T fromState(Class<T> type, Object state) {
            if (!type.isAssignableFrom(PUBLIC_TYPE)) {
                return null;
            }
            return type.cast(new DefaultFilePropertyFactory.FixedDirectory((File)state, this.fileResolver));
        }

        public int getId() {
            return FACTORY_ID;
        }
    }

    public static class RegularFilePropertyManagedFactory
    implements ManagedFactory {
        private static final Class<?> PUBLIC_TYPE = RegularFileProperty.class;
        private static final Class<?> IMPL_TYPE = DefaultFilePropertyFactory.DefaultRegularFileVar.class;
        public static final int FACTORY_ID = Objects.hashCode((Object[])new Object[]{IMPL_TYPE.getName()});
        private final FileResolver fileResolver;

        public RegularFilePropertyManagedFactory(FileResolver fileResolver) {
            this.fileResolver = fileResolver;
        }

        public <T> T fromState(Class<T> type, Object state) {
            if (!type.isAssignableFrom(PUBLIC_TYPE)) {
                return null;
            }
            return type.cast(new DefaultFilePropertyFactory.DefaultRegularFileVar(this.fileResolver).value((RegularFile)state));
        }

        public int getId() {
            return FACTORY_ID;
        }
    }

    public static class RegularFileManagedFactory
    implements ManagedFactory {
        private static final Class<?> PUBLIC_TYPE = RegularFile.class;
        private static final Class<?> IMPL_TYPE = DefaultFilePropertyFactory.FixedFile.class;
        public static final int FACTORY_ID = Objects.hashCode((Object[])new Object[]{IMPL_TYPE.getName()});

        public <T> T fromState(Class<T> type, Object state) {
            if (!type.isAssignableFrom(PUBLIC_TYPE)) {
                return null;
            }
            return type.cast(new DefaultFilePropertyFactory.FixedFile((File)state));
        }

        public int getId() {
            return FACTORY_ID;
        }
    }
}

