/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.util.Objects;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.io.importexport.GeoJSONImporter;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;

public class GeoJSONServerReader
extends OsmServerReader {
    private final String url;

    public GeoJSONServerReader(String url) {
        this.url = Objects.requireNonNull(url);
    }

    @Override
    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        try {
            progressMonitor.beginTask(I18n.tr("Contacting Server...", new Object[0]), 10);
            DataSet dataSet = new GeoJSONImporter().parseDataSet(this.url);
            return dataSet;
        }
        catch (IOException | IllegalDataException e) {
            throw new OsmTransferException(e);
        }
        finally {
            progressMonitor.finishTask();
        }
    }
}

