/*
 * Decompiled with CFR 0.152.
 */
package jnr.constants.platform.solaris;

import java.util.EnumMap;
import java.util.Map;
import jnr.constants.Constant;

public enum Signal implements Constant
{
    SIGHUP(1L),
    SIGINT(2L),
    SIGQUIT(3L),
    SIGILL(4L),
    SIGTRAP(5L),
    SIGABRT(6L),
    SIGIOT(6L),
    SIGBUS(10L),
    SIGFPE(8L),
    SIGKILL(9L),
    SIGUSR1(16L),
    SIGSEGV(11L),
    SIGUSR2(17L),
    SIGPIPE(13L),
    SIGALRM(14L),
    SIGTERM(15L),
    SIGCLD(18L),
    SIGCHLD(18L),
    SIGCONT(25L),
    SIGSTOP(23L),
    SIGTSTP(24L),
    SIGTTIN(26L),
    SIGTTOU(27L),
    SIGURG(21L),
    SIGXCPU(30L),
    SIGXFSZ(31L),
    SIGVTALRM(28L),
    SIGPROF(29L),
    SIGWINCH(20L),
    SIGPOLL(22L),
    SIGIO(22L),
    SIGPWR(19L),
    SIGSYS(12L),
    SIGRTMIN(41L),
    SIGRTMAX(72L),
    NSIG(73L);

    private final long value;
    public static final long MIN_VALUE = 1L;
    public static final long MAX_VALUE = 73L;

    private Signal(long value2) {
        this.value = value2;
    }

    public final String toString() {
        return StringTable.descriptions.get(this);
    }

    public final int value() {
        return (int)this.value;
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final boolean defined() {
        return true;
    }

    static final class StringTable {
        public static final Map<Signal, String> descriptions = StringTable.generateTable();

        StringTable() {
        }

        public static final Map<Signal, String> generateTable() {
            EnumMap<Signal, String> map2 = new EnumMap<Signal, String>(Signal.class);
            map2.put(SIGHUP, "SIGHUP");
            map2.put(SIGINT, "SIGINT");
            map2.put(SIGQUIT, "SIGQUIT");
            map2.put(SIGILL, "SIGILL");
            map2.put(SIGTRAP, "SIGTRAP");
            map2.put(SIGABRT, "SIGABRT");
            map2.put(SIGIOT, "SIGIOT");
            map2.put(SIGBUS, "SIGBUS");
            map2.put(SIGFPE, "SIGFPE");
            map2.put(SIGKILL, "SIGKILL");
            map2.put(SIGUSR1, "SIGUSR1");
            map2.put(SIGSEGV, "SIGSEGV");
            map2.put(SIGUSR2, "SIGUSR2");
            map2.put(SIGPIPE, "SIGPIPE");
            map2.put(SIGALRM, "SIGALRM");
            map2.put(SIGTERM, "SIGTERM");
            map2.put(SIGCLD, "SIGCLD");
            map2.put(SIGCHLD, "SIGCHLD");
            map2.put(SIGCONT, "SIGCONT");
            map2.put(SIGSTOP, "SIGSTOP");
            map2.put(SIGTSTP, "SIGTSTP");
            map2.put(SIGTTIN, "SIGTTIN");
            map2.put(SIGTTOU, "SIGTTOU");
            map2.put(SIGURG, "SIGURG");
            map2.put(SIGXCPU, "SIGXCPU");
            map2.put(SIGXFSZ, "SIGXFSZ");
            map2.put(SIGVTALRM, "SIGVTALRM");
            map2.put(SIGPROF, "SIGPROF");
            map2.put(SIGWINCH, "SIGWINCH");
            map2.put(SIGPOLL, "SIGPOLL");
            map2.put(SIGIO, "SIGIO");
            map2.put(SIGPWR, "SIGPWR");
            map2.put(SIGSYS, "SIGSYS");
            map2.put(SIGRTMIN, "SIGRTMIN");
            map2.put(SIGRTMAX, "SIGRTMAX");
            map2.put(NSIG, "NSIG");
            return map2;
        }
    }
}

