/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;

public abstract class PartialPosTagFilter
extends RuleFilter {
    @Nullable
    protected abstract List<AnalyzedTokenReadings> tag(String var1);

    @Override
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> args, int patternTokenPos, AnalyzedTokenReadings[] patternTokens) {
        if (!(args.containsKey("no") && args.containsKey("regexp") && args.containsKey("postag_regexp"))) {
            throw new RuntimeException("Set 'no', 'regexp' and 'postag_regexp' for filter " + PartialPosTagFilter.class.getSimpleName());
        }
        int tokenPos = Integer.parseInt(args.get("no"));
        Pattern pattern = Pattern.compile(args.get("regexp"));
        String requiredTagRegexp = args.get("postag_regexp");
        boolean negatePos = args.containsKey("negate_pos");
        boolean two_groups_regexp = args.containsKey("two_groups_regexp");
        String token = patternTokens[tokenPos - 1].getToken();
        Matcher matcher = pattern.matcher(token);
        if (matcher.groupCount() != 1 && !two_groups_regexp) {
            throw new RuntimeException("Got " + matcher.groupCount() + " groups for regex '" + pattern.pattern() + "', expected 1");
        }
        if (matcher.groupCount() != 2 && two_groups_regexp) {
            throw new RuntimeException("Got " + matcher.groupCount() + " groups for regex '" + pattern.pattern() + "', expected 2");
        }
        if (matcher.matches()) {
            List<AnalyzedTokenReadings> tags;
            String partialToken = matcher.group(1);
            if (matcher.groupCount() == 2) {
                partialToken = partialToken + matcher.group(2);
            }
            if ((tags = this.tag(partialToken)) != null && this.partialTagHasRequiredTag(tags, requiredTagRegexp, negatePos)) {
                return match;
            }
            return null;
        }
        return null;
    }

    private boolean partialTagHasRequiredTag(List<AnalyzedTokenReadings> tags, String requiredTagRegexp, boolean negatePos) {
        int postagCount = 0;
        for (AnalyzedTokenReadings tag : tags) {
            for (AnalyzedToken analyzedToken : tag.getReadings()) {
                if (analyzedToken.getPOSTag() == null) continue;
                if (negatePos) {
                    ++postagCount;
                    if (!analyzedToken.getPOSTag().matches(requiredTagRegexp)) continue;
                    return false;
                }
                if (!analyzedToken.getPOSTag().matches(requiredTagRegexp)) continue;
                return true;
            }
        }
        return postagCount == 0 ? false : negatePos;
    }
}

