/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import net.sourceforge.plantuml.graph.SortedCollection;

public class SortedCollectionLinked<S extends Comparable<S>>
implements SortedCollection<S> {
    private final List<S> all = new LinkedList<S>();

    @Override
    public Iterator<S> iterator() {
        return this.all.iterator();
    }

    @Override
    public void add(S newEntry) {
        ListIterator<S> it = this.all.listIterator();
        while (it.hasNext()) {
            Comparable cur = (Comparable)it.next();
            if (cur.compareTo(newEntry) < 0) continue;
            it.previous();
            it.add(newEntry);
            assert (this.isSorted());
            return;
        }
        this.all.add(newEntry);
        assert (this.isSorted());
    }

    @Override
    public int size() {
        return this.all.size();
    }

    List<S> toList() {
        return new ArrayList<S>(this.all);
    }

    boolean isSorted() {
        Comparable before = null;
        for (Comparable ent : this.all) {
            if (before != null && ent.compareTo(before) < 0) {
                return false;
            }
            before = ent;
        }
        return true;
    }

    @Override
    public boolean contains(S entry) {
        return this.all.contains(entry);
    }
}

