/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.NullAnnotationMatching;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.InferenceSubstitution;
import org.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBound;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class TypeVariableBinding
extends ReferenceBinding {
    public Binding declaringElement;
    public int rank;
    public TypeBinding firstBound;
    public ReferenceBinding superclass;
    public ReferenceBinding[] superInterfaces;
    public char[] genericTypeSignature;
    LookupEnvironment environment;
    boolean inRecursiveFunction = false;

    public TypeVariableBinding(char[] cArray, Binding binding, int n, LookupEnvironment lookupEnvironment) {
        this.sourceName = cArray;
        this.declaringElement = binding;
        this.rank = n;
        this.modifiers = 0x40000001;
        this.tagBits |= 0x20000000L;
        this.environment = lookupEnvironment;
        this.typeBits = 0x8000000;
        this.computeId(lookupEnvironment);
    }

    protected TypeVariableBinding(char[] cArray, LookupEnvironment lookupEnvironment) {
        this.sourceName = cArray;
        this.modifiers = 0x40000001;
        this.tagBits |= 0x20000000L;
        this.environment = lookupEnvironment;
        this.typeBits = 0x8000000;
    }

    public TypeVariableBinding(TypeVariableBinding typeVariableBinding) {
        super(typeVariableBinding);
        this.declaringElement = typeVariableBinding.declaringElement;
        this.rank = typeVariableBinding.rank;
        this.firstBound = typeVariableBinding.firstBound;
        this.superclass = typeVariableBinding.superclass;
        if (typeVariableBinding.superInterfaces != null) {
            int n = typeVariableBinding.superInterfaces.length;
            if (n > 0) {
                this.superInterfaces = new ReferenceBinding[n];
                System.arraycopy(typeVariableBinding.superInterfaces, 0, this.superInterfaces, 0, n);
            } else {
                this.superInterfaces = Binding.NO_SUPERINTERFACES;
            }
        }
        this.genericTypeSignature = typeVariableBinding.genericTypeSignature;
        this.environment = typeVariableBinding.environment;
        typeVariableBinding.tagBits |= 0x800000L;
        this.tagBits &= 0xFFFFFFFFFF7FFFFFL;
    }

    public TypeConstants.BoundCheckStatus boundCheck(Substitution substitution, TypeBinding typeBinding, Scope scope, ASTNode aSTNode) {
        TypeBinding typeBinding2;
        TypeConstants.BoundCheckStatus boundCheckStatus = this.internalBoundCheck(substitution, typeBinding, scope, aSTNode);
        if (boundCheckStatus == TypeConstants.BoundCheckStatus.MISMATCH && typeBinding instanceof TypeVariableBinding && scope != null && (typeBinding2 = ((TypeVariableBinding)typeBinding).firstBound) instanceof ParameterizedTypeBinding) {
            TypeConstants.BoundCheckStatus boundCheckStatus2 = this.boundCheck(substitution, typeBinding2.capture(scope, -1, -1), scope, aSTNode);
            return boundCheckStatus.betterOf(boundCheckStatus2);
        }
        return boundCheckStatus;
    }

    private TypeConstants.BoundCheckStatus internalBoundCheck(Substitution substitution, TypeBinding typeBinding, Scope scope, ASTNode aSTNode) {
        long l;
        boolean bl;
        if (typeBinding == TypeBinding.NULL || TypeBinding.equalsEquals(typeBinding, this)) {
            return TypeConstants.BoundCheckStatus.OK;
        }
        boolean bl2 = bl = substitution != null;
        if (!(typeBinding instanceof ReferenceBinding) && !typeBinding.isArrayType()) {
            return TypeConstants.BoundCheckStatus.MISMATCH;
        }
        if (this.superclass == null) {
            return TypeConstants.BoundCheckStatus.OK;
        }
        TypeConstants.BoundCheckStatus boundCheckStatus = TypeConstants.BoundCheckStatus.OK;
        boolean bl3 = scope.environment().usesNullTypeAnnotations();
        if (typeBinding.kind() == 516) {
            WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
            switch (wildcardBinding.boundKind) {
                case 1: {
                    boolean bl4 = false;
                    TypeBinding typeBinding2 = wildcardBinding.bound;
                    if (TypeBinding.equalsEquals(typeBinding2, this)) {
                        bl4 = true;
                    }
                    boolean bl5 = typeBinding2.isArrayType();
                    if (!typeBinding2.isInterface()) {
                        TypeBinding typeBinding3;
                        ReferenceBinding referenceBinding;
                        TypeBinding typeBinding4 = referenceBinding = bl ? Scope.substitute(substitution, this.superclass) : this.superclass;
                        if (!bl4 && referenceBinding.id != 1 && (bl5 ? !typeBinding2.isCompatibleWith(referenceBinding, scope) : ((typeBinding3 = typeBinding2.findSuperTypeOriginatingFrom(referenceBinding)) != null ? referenceBinding.isProvablyDistinct(typeBinding3) : ((typeBinding3 = referenceBinding.findSuperTypeOriginatingFrom(typeBinding2)) != null ? typeBinding3.isProvablyDistinct(typeBinding2) : this.denotesRelevantSuperClass(typeBinding2) && this.denotesRelevantSuperClass(referenceBinding))))) {
                            return TypeConstants.BoundCheckStatus.MISMATCH;
                        }
                        if (bl3 && typeBinding.hasNullTypeAnnotations()) {
                            boundCheckStatus = this.nullBoundCheck(scope, typeBinding, referenceBinding, substitution, aSTNode, boundCheckStatus);
                        }
                    }
                    boolean bl6 = bl5 || ((ReferenceBinding)typeBinding2).isFinal();
                    int n = this.superInterfaces.length;
                    for (int i = 0; i < n; ++i) {
                        TypeBinding typeBinding5;
                        ReferenceBinding referenceBinding;
                        TypeBinding typeBinding6 = referenceBinding = bl ? Scope.substitute(substitution, this.superInterfaces[i]) : this.superInterfaces[i];
                        if (!bl4 && (bl5 ? !typeBinding2.isCompatibleWith(referenceBinding, scope) : ((typeBinding5 = typeBinding2.findSuperTypeOriginatingFrom(referenceBinding)) != null ? referenceBinding.isProvablyDistinct(typeBinding5) : bl6))) {
                            return TypeConstants.BoundCheckStatus.MISMATCH;
                        }
                        if (!bl3 || !typeBinding.hasNullTypeAnnotations()) continue;
                        boundCheckStatus = this.nullBoundCheck(scope, typeBinding, referenceBinding, substitution, aSTNode, boundCheckStatus);
                    }
                    if (boundCheckStatus == null) break;
                    return boundCheckStatus;
                }
                case 2: {
                    TypeConstants.BoundCheckStatus boundCheckStatus2;
                    if (wildcardBinding.bound.isTypeVariable() && ((TypeVariableBinding)wildcardBinding.bound).superclass.id == 1) {
                        return this.nullBoundCheck(scope, typeBinding, null, substitution, aSTNode, boundCheckStatus);
                    }
                    TypeBinding typeBinding7 = wildcardBinding.bound;
                    if (bl3 && this.environment.containsNullTypeAnnotation(wildcardBinding.typeAnnotations)) {
                        typeBinding7 = this.environment.createAnnotatedType(typeBinding7.withoutToplevelNullAnnotation(), wildcardBinding.getTypeAnnotations());
                    }
                    if ((boundCheckStatus2 = this.boundCheck(substitution, typeBinding7, scope, null)) == TypeConstants.BoundCheckStatus.NULL_PROBLEM && aSTNode != null) {
                        scope.problemReporter().nullityMismatchTypeArgument(this, wildcardBinding, aSTNode);
                    }
                    return boundCheckStatus2;
                }
                case 0: {
                    if (!bl3 || !typeBinding.hasNullTypeAnnotations()) break;
                    return this.nullBoundCheck(scope, typeBinding, null, substitution, aSTNode, boundCheckStatus);
                }
            }
            return TypeConstants.BoundCheckStatus.OK;
        }
        boolean bl7 = false;
        if (this.superclass.id != 1) {
            ReferenceBinding referenceBinding;
            TypeBinding typeBinding8 = referenceBinding = bl ? Scope.substitute(substitution, this.superclass) : this.superclass;
            if (TypeBinding.notEquals(referenceBinding, typeBinding)) {
                if (!typeBinding.isCompatibleWith(referenceBinding, scope)) {
                    return TypeConstants.BoundCheckStatus.MISMATCH;
                }
                TypeBinding typeBinding9 = typeBinding.findSuperTypeOriginatingFrom(referenceBinding);
                if (typeBinding9 != null && typeBinding9.isRawType() && referenceBinding.isBoundParameterizedType()) {
                    bl7 = true;
                }
            }
            if (bl3) {
                boundCheckStatus = this.nullBoundCheck(scope, typeBinding, referenceBinding, substitution, aSTNode, boundCheckStatus);
            }
        }
        int n = this.superInterfaces.length;
        for (int i = 0; i < n; ++i) {
            ReferenceBinding referenceBinding;
            TypeBinding typeBinding10 = referenceBinding = bl ? Scope.substitute(substitution, this.superInterfaces[i]) : this.superInterfaces[i];
            if (TypeBinding.notEquals(referenceBinding, typeBinding)) {
                if (!typeBinding.isCompatibleWith(referenceBinding, scope)) {
                    return TypeConstants.BoundCheckStatus.MISMATCH;
                }
                TypeBinding typeBinding11 = typeBinding.findSuperTypeOriginatingFrom(referenceBinding);
                if (typeBinding11 != null && typeBinding11.isRawType() && referenceBinding.isBoundParameterizedType()) {
                    bl7 = true;
                }
            }
            if (!bl3) continue;
            boundCheckStatus = this.nullBoundCheck(scope, typeBinding, referenceBinding, substitution, aSTNode, boundCheckStatus);
        }
        if (bl3 && boundCheckStatus != TypeConstants.BoundCheckStatus.NULL_PROBLEM && (l = this.tagBits & 0x180000000000000L) != 0L && l != (typeBinding.tagBits & 0x180000000000000L)) {
            if (aSTNode != null) {
                scope.problemReporter().nullityMismatchTypeArgument(this, typeBinding, aSTNode);
            }
            boundCheckStatus = TypeConstants.BoundCheckStatus.NULL_PROBLEM;
        }
        return bl7 ? TypeConstants.BoundCheckStatus.UNCHECKED : (boundCheckStatus != null ? boundCheckStatus : TypeConstants.BoundCheckStatus.OK);
    }

    private TypeConstants.BoundCheckStatus nullBoundCheck(Scope scope, TypeBinding typeBinding, TypeBinding typeBinding2, Substitution substitution, ASTNode aSTNode, TypeConstants.BoundCheckStatus boundCheckStatus) {
        if (NullAnnotationMatching.analyse(this, typeBinding, typeBinding2, substitution, -1, null, NullAnnotationMatching.CheckMode.BOUND_CHECK).isAnyMismatch()) {
            if (aSTNode != null) {
                scope.problemReporter().nullityMismatchTypeArgument(this, typeBinding, aSTNode);
            }
            return TypeConstants.BoundCheckStatus.NULL_PROBLEM;
        }
        return boundCheckStatus;
    }

    boolean denotesRelevantSuperClass(TypeBinding typeBinding) {
        if (!typeBinding.isTypeVariable() && !typeBinding.isInterface() && typeBinding.id != 1) {
            return true;
        }
        ReferenceBinding referenceBinding = typeBinding.superclass();
        return referenceBinding != null && referenceBinding.id != 1 && !referenceBinding.isTypeVariable();
    }

    public int boundsCount() {
        if (this.firstBound == null) {
            return 0;
        }
        if (this.firstBound.isInterface()) {
            return this.superInterfaces.length;
        }
        return this.superInterfaces.length + 1;
    }

    @Override
    public boolean canBeInstantiated() {
        return false;
    }

    @Override
    public void collectSubstitutes(Scope scope, TypeBinding typeBinding, InferenceContext inferenceContext, int n) {
        int n2;
        if (this.declaringElement != inferenceContext.genericMethod) {
            return;
        }
        switch (typeBinding.kind()) {
            case 132: {
                if (typeBinding == TypeBinding.NULL) {
                    return;
                }
                TypeBinding typeBinding2 = scope.environment().computeBoxingType(typeBinding);
                if (typeBinding2 == typeBinding) {
                    return;
                }
                typeBinding = typeBinding2;
                break;
            }
            case 516: 
            case 65540: {
                return;
            }
        }
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            default: {
                n2 = 1;
            }
        }
        inferenceContext.recordSubstitute(this, typeBinding, n2);
    }

    @Override
    public char[] computeUniqueKey(boolean bl) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        Binding binding = this.declaringElement;
        if (!bl && binding.kind() == 8) {
            MethodBinding methodBinding = (MethodBinding)binding;
            object = methodBinding.declaringClass;
            stringBuffer.append(((ReferenceBinding)object).computeUniqueKey(false));
            stringBuffer.append(':');
            MethodBinding[] methodBindingArray = ((ReferenceBinding)object).methods();
            if (methodBindingArray != null) {
                int n = methodBindingArray.length;
                for (int i = 0; i < n; ++i) {
                    MethodBinding methodBinding2 = methodBindingArray[i];
                    if (methodBinding2 != methodBinding) continue;
                    stringBuffer.append(i);
                    break;
                }
            }
        } else {
            stringBuffer.append(binding.computeUniqueKey(false));
            stringBuffer.append(':');
        }
        stringBuffer.append(this.genericTypeSignature());
        int n = stringBuffer.length();
        object = new char[n];
        stringBuffer.getChars(0, n, (char[])object, 0);
        return object;
    }

    @Override
    public char[] constantPoolName() {
        if (this.firstBound != null) {
            return this.firstBound.constantPoolName();
        }
        return this.superclass.constantPoolName();
    }

    @Override
    public TypeBinding clone(TypeBinding typeBinding) {
        return new TypeVariableBinding(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String annotatedDebugName() {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append(super.annotatedDebugName());
        if (!this.inRecursiveFunction) {
            this.inRecursiveFunction = true;
            try {
                if (this.superclass != null && TypeBinding.equalsEquals(this.firstBound, this.superclass)) {
                    stringBuffer.append(" extends ").append(this.superclass.annotatedDebugName());
                }
                if (this.superInterfaces != null && this.superInterfaces != Binding.NO_SUPERINTERFACES) {
                    if (TypeBinding.notEquals(this.firstBound, this.superclass)) {
                        stringBuffer.append(" extends ");
                    }
                    int n = this.superInterfaces.length;
                    for (int i = 0; i < n; ++i) {
                        if (i > 0 || TypeBinding.equalsEquals(this.firstBound, this.superclass)) {
                            stringBuffer.append(" & ");
                        }
                        stringBuffer.append(this.superInterfaces[i].annotatedDebugName());
                    }
                }
            }
            finally {
                this.inRecursiveFunction = false;
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public String debugName() {
        if (this.hasTypeAnnotations()) {
            return super.annotatedDebugName();
        }
        return new String(this.sourceName);
    }

    @Override
    public TypeBinding erasure() {
        if (this.firstBound != null) {
            return this.firstBound.erasure();
        }
        return this.superclass;
    }

    public char[] genericSignature() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append(this.sourceName).append(':');
        int n3 = n2 = this.superInterfaces == null ? 0 : this.superInterfaces.length;
        if ((n2 == 0 || TypeBinding.equalsEquals(this.firstBound, this.superclass)) && this.superclass != null) {
            stringBuffer.append(this.superclass.genericTypeSignature());
        }
        for (n = 0; n < n2; ++n) {
            stringBuffer.append(':').append(this.superInterfaces[n].genericTypeSignature());
        }
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    @Override
    public char[] genericTypeSignature() {
        if (this.genericTypeSignature != null) {
            return this.genericTypeSignature;
        }
        this.genericTypeSignature = CharOperation.concat('T', this.sourceName, ';');
        return this.genericTypeSignature;
    }

    TypeBound[] getTypeBounds(InferenceVariable inferenceVariable, InferenceSubstitution inferenceSubstitution) {
        int n = this.boundsCount();
        if (n == 0) {
            return NO_TYPE_BOUNDS;
        }
        TypeBound[] typeBoundArray = new TypeBound[n];
        int n2 = 0;
        if (!this.firstBound.isInterface()) {
            typeBoundArray[n2++] = TypeBound.createBoundOrDependency(inferenceSubstitution, this.firstBound, inferenceVariable);
        }
        for (int i = 0; i < this.superInterfaces.length; ++i) {
            typeBoundArray[n2++] = TypeBound.createBoundOrDependency(inferenceSubstitution, this.superInterfaces[i], inferenceVariable);
        }
        return typeBoundArray;
    }

    boolean hasOnlyRawBounds() {
        if (this.superclass != null && TypeBinding.equalsEquals(this.firstBound, this.superclass) && !this.superclass.isRawType()) {
            return false;
        }
        if (this.superInterfaces != null) {
            int n = this.superInterfaces.length;
            for (int i = 0; i < n; ++i) {
                if (this.superInterfaces[i].isRawType()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean hasTypeBit(int n) {
        if (this.typeBits == 0x8000000) {
            this.typeBits = 0;
            if (this.superclass != null && this.superclass.hasTypeBit(-134217729)) {
                this.typeBits |= this.superclass.typeBits & 0x13;
            }
            if (this.superInterfaces != null) {
                int n2 = this.superInterfaces.length;
                for (int i = 0; i < n2; ++i) {
                    if (!this.superInterfaces[i].hasTypeBit(-134217729)) continue;
                    this.typeBits |= this.superInterfaces[i].typeBits & 0x13;
                }
            }
        }
        return (this.typeBits & n) != 0;
    }

    public boolean isErasureBoundTo(TypeBinding typeBinding) {
        if (TypeBinding.equalsEquals(this.superclass.erasure(), typeBinding)) {
            return true;
        }
        int n = this.superInterfaces.length;
        for (int i = 0; i < n; ++i) {
            if (!TypeBinding.equalsEquals(this.superInterfaces[i].erasure(), typeBinding)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isHierarchyConnected() {
        return (this.modifiers & 0x2000000) == 0;
    }

    public boolean isInterchangeableWith(TypeVariableBinding typeVariableBinding, Substitution substitution) {
        if (TypeBinding.equalsEquals(this, typeVariableBinding)) {
            return true;
        }
        int n = this.superInterfaces.length;
        if (n != typeVariableBinding.superInterfaces.length) {
            return false;
        }
        if (TypeBinding.notEquals(this.superclass, Scope.substitute(substitution, typeVariableBinding.superclass))) {
            return false;
        }
        block0: for (int i = 0; i < n; ++i) {
            TypeBinding typeBinding = Scope.substitute(substitution, typeVariableBinding.superInterfaces[i]);
            for (int j = 0; j < n; ++j) {
                if (TypeBinding.equalsEquals(typeBinding, this.superInterfaces[j])) continue block0;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isSubtypeOf(TypeBinding typeBinding) {
        if (this.isSubTypeOfRTL(typeBinding)) {
            return true;
        }
        if (this.firstBound != null && this.firstBound.isSubtypeOf(typeBinding)) {
            return true;
        }
        if (this.superclass != null && this.superclass.isSubtypeOf(typeBinding)) {
            return true;
        }
        if (this.superInterfaces != null) {
            int n = this.superInterfaces.length;
            for (int i = 0; i < n; ++i) {
                if (!this.superInterfaces[i].isSubtypeOf(typeBinding)) continue;
                return true;
            }
        }
        return typeBinding.id == 1;
    }

    @Override
    public boolean enterRecursiveFunction() {
        if (this.inRecursiveFunction) {
            return false;
        }
        this.inRecursiveFunction = true;
        return true;
    }

    @Override
    public void exitRecursiveFunction() {
        this.inRecursiveFunction = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProperType(boolean bl) {
        if (this.inRecursiveFunction) {
            return true;
        }
        this.inRecursiveFunction = true;
        try {
            int n;
            if (this.superclass != null && !this.superclass.isProperType(bl)) {
                boolean bl2 = false;
                return bl2;
            }
            if (this.superInterfaces != null) {
                int n2 = this.superInterfaces.length;
                for (n = 0; n < n2; ++n) {
                    if (this.superInterfaces[n].isProperType(bl)) continue;
                    boolean bl3 = false;
                    return bl3;
                }
            }
            n = 1;
            return n != 0;
        }
        finally {
            this.inRecursiveFunction = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    TypeBinding substituteInferenceVariable(InferenceVariable inferenceVariable, TypeBinding typeBinding) {
        if (this.inRecursiveFunction) {
            return this;
        }
        this.inRecursiveFunction = true;
        try {
            boolean bl = false;
            ReferenceBinding referenceBinding = this.superclass;
            if (referenceBinding != null) {
                referenceBinding = (ReferenceBinding)referenceBinding.substituteInferenceVariable(inferenceVariable, typeBinding);
                bl |= TypeBinding.notEquals(referenceBinding, this.superclass);
            }
            ReferenceBinding[] referenceBindingArray = null;
            if (this.superInterfaces != null) {
                int n = this.superInterfaces.length;
                if (bl) {
                    referenceBindingArray = new ReferenceBinding[n];
                    System.arraycopy(this.superInterfaces, 0, referenceBindingArray, 0, n);
                }
                for (int i = 0; i < n; ++i) {
                    ReferenceBinding referenceBinding2 = this.superInterfaces[i];
                    if (referenceBinding2 == null || !TypeBinding.notEquals(referenceBinding2 = (ReferenceBinding)referenceBinding2.substituteInferenceVariable(inferenceVariable, typeBinding), this.superInterfaces[i])) continue;
                    if (referenceBindingArray == null) {
                        referenceBindingArray = new ReferenceBinding[n];
                        System.arraycopy(this.superInterfaces, 0, referenceBindingArray, 0, n);
                    }
                    referenceBindingArray[i] = referenceBinding2;
                    bl = true;
                }
            }
            if (bl) {
                TypeVariableBinding typeVariableBinding = new TypeVariableBinding(this.sourceName, this.declaringElement, this.rank, this.environment);
                typeVariableBinding.superclass = referenceBinding;
                typeVariableBinding.superInterfaces = referenceBindingArray;
                typeVariableBinding.tagBits = this.tagBits;
                TypeVariableBinding typeVariableBinding2 = typeVariableBinding;
                return typeVariableBinding2;
            }
            TypeVariableBinding typeVariableBinding = this;
            return typeVariableBinding;
        }
        finally {
            this.inRecursiveFunction = false;
        }
    }

    @Override
    public boolean isTypeVariable() {
        return true;
    }

    @Override
    public int kind() {
        return 4100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mentionsAny(TypeBinding[] typeBindingArray, int n) {
        if (this.inRecursiveFunction) {
            return false;
        }
        this.inRecursiveFunction = true;
        try {
            int n2;
            if (super.mentionsAny(typeBindingArray, n)) {
                boolean bl = true;
                return bl;
            }
            if (this.superclass != null && this.superclass.mentionsAny(typeBindingArray, n)) {
                boolean bl = true;
                return bl;
            }
            if (this.superInterfaces != null) {
                for (n2 = 0; n2 < this.superInterfaces.length; ++n2) {
                    if (!this.superInterfaces[n2].mentionsAny(typeBindingArray, n)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            n2 = 0;
            return n2 != 0;
        }
        finally {
            this.inRecursiveFunction = false;
        }
    }

    @Override
    void collectInferenceVariables(Set<InferenceVariable> set) {
        if (this.inRecursiveFunction) {
            return;
        }
        this.inRecursiveFunction = true;
        try {
            if (this.superclass != null) {
                this.superclass.collectInferenceVariables(set);
            }
            if (this.superInterfaces != null) {
                for (int i = 0; i < this.superInterfaces.length; ++i) {
                    this.superInterfaces[i].collectInferenceVariables(set);
                }
            }
        }
        finally {
            this.inRecursiveFunction = false;
        }
    }

    public TypeBinding[] otherUpperBounds() {
        if (this.firstBound == null) {
            return Binding.NO_TYPES;
        }
        if (TypeBinding.equalsEquals(this.firstBound, this.superclass)) {
            return this.superInterfaces;
        }
        int n = this.superInterfaces.length - 1;
        if (n > 0) {
            TypeBinding[] typeBindingArray = new TypeBinding[n];
            System.arraycopy(this.superInterfaces, 1, typeBindingArray, 0, n);
            return typeBindingArray;
        }
        return Binding.NO_TYPES;
    }

    @Override
    public char[] readableName() {
        return this.sourceName;
    }

    ReferenceBinding resolve() {
        int n;
        Object object;
        if ((this.modifiers & 0x2000000) == 0) {
            return this;
        }
        long l = this.tagBits & 0x180000000000000L;
        ReferenceBinding referenceBinding = this.superclass;
        ReferenceBinding referenceBinding2 = null;
        if (this.superclass != null) {
            object = (ReferenceBinding)BinaryTypeBinding.resolveType(this.superclass, this.environment, true);
            this.tagBits |= object.tagBits & 0x800L;
            long l2 = object.tagBits & 0x180000000000000L;
            if (l2 != 0L && l == 0L && (l2 & 0x100000000000000L) != 0L) {
                l = l2;
            }
            this.setSuperClass((ReferenceBinding)object);
        }
        if ((n = ((ReferenceBinding[])(object = this.superInterfaces)).length) != 0) {
            referenceBinding2 = object[0];
            int n2 = n;
            while (--n2 >= 0) {
                ReferenceBinding referenceBinding3 = (ReferenceBinding)BinaryTypeBinding.resolveType(object[n2], this.environment, true);
                this.tagBits |= referenceBinding3.tagBits & 0x800L;
                long l3 = referenceBinding3.tagBits & 0x180000000000000L;
                if (l3 != 0L && l == 0L && (l3 & 0x100000000000000L) != 0L) {
                    l = l3;
                }
                object[n2] = referenceBinding3;
            }
        }
        if (l != 0L) {
            this.tagBits |= l | 0x100000L;
        }
        if (this.firstBound != null) {
            if (TypeBinding.equalsEquals(this.firstBound, referenceBinding)) {
                this.setFirstBound(this.superclass);
            } else if (TypeBinding.equalsEquals(this.firstBound, referenceBinding2)) {
                this.setFirstBound(object[0]);
            }
        }
        this.modifiers &= 0xFDFFFFFF;
        return this;
    }

    @Override
    public void setTypeAnnotations(AnnotationBinding[] annotationBindingArray, boolean bl) {
        if (this.getClass() == TypeVariableBinding.class) {
            this.environment.typeSystem.forceRegisterAsDerived(this);
        } else {
            this.environment.getUnannotatedType(this);
        }
        super.setTypeAnnotations(annotationBindingArray, bl);
    }

    @Override
    public char[] shortReadableName() {
        return this.readableName();
    }

    @Override
    public ReferenceBinding superclass() {
        return this.superclass;
    }

    @Override
    public ReferenceBinding[] superInterfaces() {
        return this.superInterfaces;
    }

    public String toString() {
        if (this.hasTypeAnnotations()) {
            return this.annotatedDebugName();
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append('<').append(this.sourceName);
        if (this.superclass != null && TypeBinding.equalsEquals(this.firstBound, this.superclass)) {
            stringBuffer.append(" extends ").append(this.superclass.debugName());
        }
        if (this.superInterfaces != null && this.superInterfaces != Binding.NO_SUPERINTERFACES) {
            if (TypeBinding.notEquals(this.firstBound, this.superclass)) {
                stringBuffer.append(" extends ");
            }
            int n = this.superInterfaces.length;
            for (int i = 0; i < n; ++i) {
                if (i > 0 || TypeBinding.equalsEquals(this.firstBound, this.superclass)) {
                    stringBuffer.append(" & ");
                }
                stringBuffer.append(this.superInterfaces[i].debugName());
            }
        }
        stringBuffer.append('>');
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char[] nullAnnotatedReadableName(CompilerOptions compilerOptions, boolean bl) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(10);
        this.appendNullAnnotation(stringBuffer, compilerOptions);
        stringBuffer.append(this.sourceName());
        if (!this.inRecursiveFunction) {
            this.inRecursiveFunction = true;
            try {
                if (this.superclass != null && TypeBinding.equalsEquals(this.firstBound, this.superclass)) {
                    stringBuffer.append(" extends ").append(this.superclass.nullAnnotatedReadableName(compilerOptions, bl));
                }
                if (this.superInterfaces != null && this.superInterfaces != Binding.NO_SUPERINTERFACES) {
                    if (TypeBinding.notEquals(this.firstBound, this.superclass)) {
                        stringBuffer.append(" extends ");
                    }
                    int n2 = this.superInterfaces.length;
                    for (n = 0; n < n2; ++n) {
                        if (n > 0 || TypeBinding.equalsEquals(this.firstBound, this.superclass)) {
                            stringBuffer.append(" & ");
                        }
                        stringBuffer.append(this.superInterfaces[n].nullAnnotatedReadableName(compilerOptions, bl));
                    }
                }
            }
            finally {
                this.inRecursiveFunction = false;
            }
        }
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    @Override
    protected void appendNullAnnotation(StringBuffer stringBuffer, CompilerOptions compilerOptions) {
        int n = stringBuffer.length();
        super.appendNullAnnotation(stringBuffer, compilerOptions);
        if (n == stringBuffer.length() && this.hasNullTypeAnnotations()) {
            TypeVariableBinding typeVariableBinding;
            TypeVariableBinding[] typeVariableBindingArray = null;
            if (this.declaringElement instanceof ReferenceBinding) {
                typeVariableBindingArray = ((ReferenceBinding)this.declaringElement).typeVariables();
            } else if (this.declaringElement instanceof MethodBinding) {
                typeVariableBindingArray = ((MethodBinding)this.declaringElement).typeVariables();
            }
            if (typeVariableBindingArray != null && typeVariableBindingArray.length > this.rank && (typeVariableBinding = typeVariableBindingArray[this.rank]) != this) {
                typeVariableBinding.appendNullAnnotation(stringBuffer, compilerOptions);
            }
        }
    }

    @Override
    public TypeBinding unannotated() {
        return this.hasTypeAnnotations() ? this.environment.getUnannotatedType(this) : this;
    }

    @Override
    public TypeBinding withoutToplevelNullAnnotation() {
        if (!this.hasNullTypeAnnotations()) {
            return this;
        }
        TypeBinding typeBinding = this.environment.getUnannotatedType(this);
        AnnotationBinding[] annotationBindingArray = this.environment.filterNullTypeAnnotations(this.typeAnnotations);
        if (annotationBindingArray.length > 0) {
            return this.environment.createAnnotatedType(typeBinding, annotationBindingArray);
        }
        return typeBinding;
    }

    public TypeBinding upperBound() {
        if (this.firstBound != null) {
            return this.firstBound;
        }
        return this.superclass;
    }

    public void evaluateNullAnnotations(Scope scope, TypeParameter typeParameter) {
        int n;
        ReferenceBinding[] referenceBindingArray;
        long l;
        long l2 = NullAnnotationMatching.validNullTagBits(this.tagBits);
        if (this.firstBound != null && this.firstBound.isValidBinding() && (l = NullAnnotationMatching.validNullTagBits(this.firstBound.tagBits)) != 0L) {
            if (l2 == 0L) {
                if ((l & 0x100000000000000L) != 0L) {
                    l2 = l;
                }
            } else if (l != l2 && typeParameter != null) {
                this.firstBound = this.nullMismatchOnBound(typeParameter, this.firstBound, l, l2, scope);
            }
        }
        if ((referenceBindingArray = this.superInterfaces) != null && (n = referenceBindingArray.length) != 0) {
            int n2 = n;
            while (--n2 >= 0) {
                ReferenceBinding referenceBinding = referenceBindingArray[n2];
                long l3 = NullAnnotationMatching.validNullTagBits(referenceBinding.tagBits);
                if (l3 == 0L) continue;
                if (l2 == 0L) {
                    if ((l3 & 0x100000000000000L) == 0L) continue;
                    l2 = l3;
                    continue;
                }
                if (l3 == l2 || typeParameter == null) continue;
                referenceBindingArray[n2] = (ReferenceBinding)this.nullMismatchOnBound(typeParameter, referenceBinding, l3, l2, scope);
            }
        }
        if (l2 != 0L) {
            this.tagBits |= l2 | 0x100000L;
        }
    }

    private TypeBinding nullMismatchOnBound(TypeParameter typeParameter, TypeBinding typeBinding, long l, long l2, Scope scope) {
        TypeReference typeReference = this.findBound(typeBinding, typeParameter);
        Annotation annotation = typeReference.findAnnotation(l);
        if (annotation != null) {
            scope.problemReporter().contradictoryNullAnnotationsOnBounds(annotation, l2);
            this.tagBits &= 0xFE7FFFFFFFFFFFFFL;
        } else {
            return typeBinding.withoutToplevelNullAnnotation();
        }
        return typeBinding;
    }

    private TypeReference findBound(TypeBinding typeBinding, TypeParameter typeParameter) {
        if (typeParameter.type != null && TypeBinding.equalsEquals(typeParameter.type.resolvedType, typeBinding)) {
            return typeParameter.type;
        }
        TypeReference[] typeReferenceArray = typeParameter.bounds;
        if (typeReferenceArray != null) {
            for (int i = 0; i < typeReferenceArray.length; ++i) {
                if (!TypeBinding.equalsEquals(typeReferenceArray[i].resolvedType, typeBinding)) continue;
                return typeReferenceArray[i];
            }
        }
        return null;
    }

    public TypeBinding setFirstBound(TypeBinding typeBinding) {
        this.firstBound = typeBinding;
        if ((this.tagBits & 0x800000L) != 0L) {
            int n;
            TypeBinding[] typeBindingArray = this.getDerivedTypesForDeferredInitialization();
            int n2 = n = typeBindingArray == null ? 0 : typeBindingArray.length;
            for (int i = 0; i < n; ++i) {
                TypeVariableBinding typeVariableBinding = (TypeVariableBinding)typeBindingArray[i];
                if (typeVariableBinding.firstBound != null) continue;
                typeVariableBinding.firstBound = typeBinding;
            }
        }
        if (typeBinding != null && typeBinding.hasNullTypeAnnotations()) {
            this.tagBits |= 0x100000L;
        }
        return typeBinding;
    }

    public ReferenceBinding setSuperClass(ReferenceBinding referenceBinding) {
        this.superclass = referenceBinding;
        if ((this.tagBits & 0x800000L) != 0L) {
            int n;
            TypeBinding[] typeBindingArray = this.getDerivedTypesForDeferredInitialization();
            int n2 = n = typeBindingArray == null ? 0 : typeBindingArray.length;
            for (int i = 0; i < n; ++i) {
                TypeVariableBinding typeVariableBinding = (TypeVariableBinding)typeBindingArray[i];
                if (typeVariableBinding.superclass != null) continue;
                typeVariableBinding.superclass = referenceBinding;
            }
        }
        return referenceBinding;
    }

    public ReferenceBinding[] setSuperInterfaces(ReferenceBinding[] referenceBindingArray) {
        this.superInterfaces = referenceBindingArray;
        if ((this.tagBits & 0x800000L) != 0L) {
            int n;
            TypeBinding[] typeBindingArray = this.getDerivedTypesForDeferredInitialization();
            int n2 = n = typeBindingArray == null ? 0 : typeBindingArray.length;
            for (int i = 0; i < n; ++i) {
                TypeVariableBinding typeVariableBinding = (TypeVariableBinding)typeBindingArray[i];
                if (typeVariableBinding.superInterfaces != null) continue;
                typeVariableBinding.superInterfaces = referenceBindingArray;
            }
        }
        return referenceBindingArray;
    }

    protected TypeBinding[] getDerivedTypesForDeferredInitialization() {
        return this.environment.getAnnotatedTypes(this);
    }

    public TypeBinding combineTypeAnnotations(TypeBinding typeBinding) {
        if (this.hasTypeAnnotations()) {
            if (this.hasRelevantTypeUseNullAnnotations()) {
                typeBinding = typeBinding.withoutToplevelNullAnnotation();
            }
            if (this.typeAnnotations != Binding.NO_ANNOTATIONS) {
                return this.environment.createAnnotatedType(typeBinding, this.typeAnnotations);
            }
        }
        return typeBinding;
    }

    private boolean hasRelevantTypeUseNullAnnotations() {
        TypeVariableBinding[] typeVariableBindingArray;
        if (this.declaringElement instanceof ReferenceBinding) {
            typeVariableBindingArray = ((ReferenceBinding)this.declaringElement).original().typeVariables();
        } else if (this.declaringElement instanceof MethodBinding) {
            typeVariableBindingArray = ((MethodBinding)this.declaringElement).original().typeVariables;
        } else {
            throw new IllegalStateException("Unexpected declaring element:" + String.valueOf(this.declaringElement.readableName()));
        }
        TypeVariableBinding typeVariableBinding = typeVariableBindingArray[this.rank];
        long l = this.tagBits & 0x180000000000000L;
        long l2 = typeVariableBinding.tagBits & 0x180000000000000L;
        return (l & (l2 ^ 0xFFFFFFFFFFFFFFFFL)) != 0L;
    }

    @Override
    public boolean acceptsNonNullDefault() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long updateTagBits() {
        if (!this.inRecursiveFunction) {
            this.inRecursiveFunction = true;
            try {
                if (this.superclass != null) {
                    this.tagBits |= this.superclass.updateTagBits();
                }
                if (this.superInterfaces != null) {
                    for (ReferenceBinding referenceBinding : this.superInterfaces) {
                        this.tagBits |= referenceBinding.updateTagBits();
                    }
                }
            }
            finally {
                this.inRecursiveFunction = false;
            }
        }
        return super.updateTagBits();
    }

    @Override
    public boolean isFreeTypeVariable() {
        return this.environment.usesNullTypeAnnotations() && this.environment.globalOptions.pessimisticNullAnalysisForFreeTypeVariablesEnabled && (this.tagBits & 0x180000000000000L) == 0L;
    }
}

