/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ScriptRoot;
import org.elasticsearch.painless.lookup.PainlessField;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.lookup.def;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.AStoreable;
import org.elasticsearch.painless.node.EConstant;
import org.elasticsearch.painless.node.EStatic;
import org.elasticsearch.painless.node.PSubArrayLength;
import org.elasticsearch.painless.node.PSubDefField;
import org.elasticsearch.painless.node.PSubField;
import org.elasticsearch.painless.node.PSubListShortcut;
import org.elasticsearch.painless.node.PSubMapShortcut;
import org.elasticsearch.painless.node.PSubNullSafeField;
import org.elasticsearch.painless.node.PSubShortcut;

public final class PField
extends AStoreable {
    private final boolean nullSafe;
    private final String value;
    private AStoreable sub = null;

    public PField(Location location, AExpression prefix, boolean nullSafe, String value) {
        super(location, prefix);
        this.nullSafe = nullSafe;
        this.value = Objects.requireNonNull(value);
    }

    @Override
    void storeSettings(CompilerSettings settings) {
        this.prefix.storeSettings(settings);
    }

    @Override
    void extractVariables(Set<String> variables) {
        this.prefix.extractVariables(variables);
    }

    @Override
    void analyze(ScriptRoot scriptRoot, Locals locals) {
        this.prefix.analyze(scriptRoot, locals);
        this.prefix.expected = this.prefix.actual;
        this.prefix = this.prefix.cast(scriptRoot, locals);
        if (this.prefix.actual.isArray()) {
            this.sub = new PSubArrayLength(this.location, PainlessLookupUtility.typeToCanonicalTypeName(this.prefix.actual), this.value);
        } else if (this.prefix.actual == def.class) {
            this.sub = new PSubDefField(this.location, this.value);
        } else {
            PainlessField field = scriptRoot.getPainlessLookup().lookupPainlessField(this.prefix.actual, this.prefix instanceof EStatic, this.value);
            if (field == null) {
                PainlessMethod getter = scriptRoot.getPainlessLookup().lookupPainlessMethod(this.prefix.actual, false, "get" + Character.toUpperCase(this.value.charAt(0)) + this.value.substring(1), 0);
                if (getter == null) {
                    getter = scriptRoot.getPainlessLookup().lookupPainlessMethod(this.prefix.actual, false, "is" + Character.toUpperCase(this.value.charAt(0)) + this.value.substring(1), 0);
                }
                PainlessMethod setter = scriptRoot.getPainlessLookup().lookupPainlessMethod(this.prefix.actual, false, "set" + Character.toUpperCase(this.value.charAt(0)) + this.value.substring(1), 0);
                if (getter != null || setter != null) {
                    this.sub = new PSubShortcut(this.location, this.value, PainlessLookupUtility.typeToCanonicalTypeName(this.prefix.actual), getter, setter);
                } else {
                    EConstant index = new EConstant(this.location, this.value);
                    index.analyze(scriptRoot, locals);
                    if (Map.class.isAssignableFrom(this.prefix.actual)) {
                        this.sub = new PSubMapShortcut(this.location, this.prefix.actual, index);
                    }
                    if (List.class.isAssignableFrom(this.prefix.actual)) {
                        this.sub = new PSubListShortcut(this.location, this.prefix.actual, index);
                    }
                }
                if (this.sub == null) {
                    throw this.createError(new IllegalArgumentException("field [" + PainlessLookupUtility.typeToCanonicalTypeName(this.prefix.actual) + ", " + this.value + "] not found"));
                }
            } else {
                this.sub = new PSubField(this.location, field);
            }
        }
        if (this.nullSafe) {
            this.sub = new PSubNullSafeField(this.location, this.sub);
        }
        this.sub.write = this.write;
        this.sub.read = this.read;
        this.sub.expected = this.expected;
        this.sub.explicit = this.explicit;
        this.sub.analyze(scriptRoot, locals);
        this.actual = this.sub.actual;
    }

    @Override
    void write(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        this.prefix.write(classWriter, methodWriter, globals);
        this.sub.write(classWriter, methodWriter, globals);
    }

    @Override
    boolean isDefOptimized() {
        return this.sub.isDefOptimized();
    }

    @Override
    void updateActual(Class<?> actual) {
        this.sub.updateActual(actual);
        this.actual = actual;
    }

    @Override
    int accessElementCount() {
        return this.sub.accessElementCount();
    }

    @Override
    void setup(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        this.prefix.write(classWriter, methodWriter, globals);
        this.sub.setup(classWriter, methodWriter, globals);
    }

    @Override
    void load(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        this.sub.load(classWriter, methodWriter, globals);
    }

    @Override
    void store(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        this.sub.store(classWriter, methodWriter, globals);
    }

    @Override
    public String toString() {
        if (this.nullSafe) {
            return this.singleLineToString("nullSafe", this.prefix, this.value);
        }
        return this.singleLineToString(this.prefix, this.value);
    }
}

