/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.Constant;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ScriptClassInfo;
import org.elasticsearch.painless.ScriptRoot;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.painless.lookup.PainlessLookup;
import org.elasticsearch.painless.node.AStatement;
import org.elasticsearch.painless.node.SField;
import org.elasticsearch.painless.node.SFunction;
import org.elasticsearch.painless.symbol.FunctionTable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.util.Printer;

public final class SClass
extends AStatement {
    private final ScriptClassInfo scriptClassInfo;
    private final String name;
    private final Printer debugStream;
    private final List<SFunction> functions = new ArrayList<SFunction>();
    private final List<SField> fields = new ArrayList<SField>();
    private final Globals globals;
    private final List<AStatement> statements;
    private CompilerSettings settings;
    private ScriptRoot table;
    private Locals mainMethod;
    private final Set<String> extractedVariables;
    private final List<Method> getMethods;
    private byte[] bytes;

    public SClass(ScriptClassInfo scriptClassInfo, String name, String sourceText, Printer debugStream, Location location, List<SFunction> functions, List<AStatement> statements) {
        super(location);
        this.scriptClassInfo = Objects.requireNonNull(scriptClassInfo);
        this.name = Objects.requireNonNull(name);
        this.debugStream = debugStream;
        this.functions.addAll((Collection<SFunction>)Objects.requireNonNull(functions));
        this.statements = Collections.unmodifiableList(statements);
        this.globals = new Globals(new BitSet(sourceText.length()));
        this.extractedVariables = new HashSet<String>();
        this.getMethods = new ArrayList<Method>();
    }

    void addFunction(SFunction function) {
        this.functions.add(function);
    }

    void addField(SField field) {
        this.fields.add(field);
    }

    @Override
    public void storeSettings(CompilerSettings settings) {
        for (SFunction function : this.functions) {
            function.storeSettings(settings);
        }
        for (AStatement statement : this.statements) {
            statement.storeSettings(settings);
        }
        this.settings = settings;
    }

    @Override
    public void extractVariables(Set<String> variables) {
        for (SFunction function : this.functions) {
            function.extractVariables(null);
        }
        for (AStatement statement : this.statements) {
            statement.extractVariables(variables);
        }
        this.extractedVariables.addAll(variables);
    }

    public void analyze(PainlessLookup painlessLookup) {
        this.table = new ScriptRoot(painlessLookup, this.settings, this.scriptClassInfo, this);
        for (SFunction function : this.functions) {
            function.generateSignature(painlessLookup);
            String key = FunctionTable.buildLocalFunctionKey(function.name, function.parameters.size());
            if (this.table.getFunctionTable().getFunction(key) != null) {
                throw this.createError(new IllegalArgumentException("Illegal duplicate functions [" + key + "]."));
            }
            this.table.getFunctionTable().addFunction(function.name, function.returnType, function.typeParameters, false);
        }
        Locals locals = Locals.newProgramScope();
        this.analyze(this.table, locals);
    }

    @Override
    void analyze(ScriptRoot scriptRoot, Locals program) {
        ArrayList<SFunction> functions = new ArrayList<SFunction>(this.functions);
        for (SFunction function : functions) {
            Locals functionLocals = Locals.newFunctionScope(program, function.returnType, function.parameters, this.settings.getMaxLoopCounter());
            function.analyze(scriptRoot, functionLocals);
        }
        if (this.statements == null || this.statements.isEmpty()) {
            throw this.createError(new IllegalArgumentException("Cannot generate an empty script."));
        }
        this.mainMethod = Locals.newMainMethodScope(this.scriptClassInfo, program, this.settings.getMaxLoopCounter());
        for (int get = 0; get < this.scriptClassInfo.getGetMethods().size(); ++get) {
            Method method = this.scriptClassInfo.getGetMethods().get(get);
            String name = method.getName().substring(3);
            if (!this.extractedVariables.contains(name = Character.toLowerCase(name.charAt(0)) + name.substring(1))) continue;
            Class<?> rtn = this.scriptClassInfo.getGetReturns().get(get);
            this.mainMethod.addVariable(new Location("getter [" + name + "]", 0), rtn, name, true);
            this.getMethods.add(method);
        }
        AStatement last = this.statements.get(this.statements.size() - 1);
        for (AStatement statement : this.statements) {
            if (this.allEscape) {
                throw this.createError(new IllegalArgumentException("Unreachable statement."));
            }
            statement.lastSource = statement == last;
            statement.analyze(scriptRoot, this.mainMethod);
            this.methodEscape = statement.methodEscape;
            this.allEscape = statement.allEscape;
        }
    }

    public Map<String, Object> write() {
        int classFrames = 3;
        int classAccess = 49;
        String interfaceBase = WriterConstants.BASE_INTERFACE_TYPE.getInternalName();
        String className = WriterConstants.CLASS_TYPE.getInternalName();
        String[] classInterfaces = new String[]{interfaceBase};
        ClassWriter classWriter = new ClassWriter(this.settings, this.globals.getStatements(), this.debugStream, this.scriptClassInfo.getBaseClass(), classFrames, classAccess, className, classInterfaces);
        ClassVisitor classVisitor = classWriter.getClassVisitor();
        classVisitor.visitSource(Location.computeSourceName(this.name), null);
        MethodWriter bootstrapDef = classWriter.newMethodWriter(136, WriterConstants.DEF_BOOTSTRAP_METHOD);
        bootstrapDef.visitCode();
        bootstrapDef.getStatic(WriterConstants.CLASS_TYPE, "$DEFINITION", WriterConstants.DEFINITION_TYPE);
        bootstrapDef.getStatic(WriterConstants.CLASS_TYPE, "$FUNCTIONS", WriterConstants.FUNCTION_TABLE_TYPE);
        bootstrapDef.loadArgs();
        bootstrapDef.invokeStatic(WriterConstants.DEF_BOOTSTRAP_DELEGATE_TYPE, WriterConstants.DEF_BOOTSTRAP_DELEGATE_METHOD);
        bootstrapDef.returnValue();
        bootstrapDef.endMethod();
        classVisitor.visitField(9, "$NAME", WriterConstants.STRING_TYPE.getDescriptor(), null, null).visitEnd();
        classVisitor.visitField(9, "$SOURCE", WriterConstants.STRING_TYPE.getDescriptor(), null, null).visitEnd();
        classVisitor.visitField(9, "$STATEMENTS", WriterConstants.BITSET_TYPE.getDescriptor(), null, null).visitEnd();
        classVisitor.visitField(9, "$DEFINITION", WriterConstants.DEFINITION_TYPE.getDescriptor(), null, null).visitEnd();
        classVisitor.visitField(9, "$FUNCTIONS", WriterConstants.FUNCTION_TABLE_TYPE.getDescriptor(), null, null).visitEnd();
        Method init = this.scriptClassInfo.getBaseClass().getConstructors().length == 0 ? new Method("<init>", MethodType.methodType(Void.TYPE).toMethodDescriptorString()) : new Method("<init>", MethodType.methodType(Void.TYPE, this.scriptClassInfo.getBaseClass().getConstructors()[0].getParameterTypes()).toMethodDescriptorString());
        MethodWriter constructor = classWriter.newMethodWriter(1, init);
        constructor.visitCode();
        constructor.loadThis();
        constructor.loadArgs();
        constructor.invokeConstructor(Type.getType(this.scriptClassInfo.getBaseClass()), init);
        constructor.returnValue();
        constructor.endMethod();
        MethodWriter nameMethod = classWriter.newMethodWriter(1, WriterConstants.GET_NAME_METHOD);
        nameMethod.visitCode();
        nameMethod.getStatic(WriterConstants.CLASS_TYPE, "$NAME", WriterConstants.STRING_TYPE);
        nameMethod.returnValue();
        nameMethod.endMethod();
        MethodWriter sourceMethod = classWriter.newMethodWriter(1, WriterConstants.GET_SOURCE_METHOD);
        sourceMethod.visitCode();
        sourceMethod.getStatic(WriterConstants.CLASS_TYPE, "$SOURCE", WriterConstants.STRING_TYPE);
        sourceMethod.returnValue();
        sourceMethod.endMethod();
        MethodWriter statementsMethod = classWriter.newMethodWriter(1, WriterConstants.GET_STATEMENTS_METHOD);
        statementsMethod.visitCode();
        statementsMethod.getStatic(WriterConstants.CLASS_TYPE, "$STATEMENTS", WriterConstants.BITSET_TYPE);
        statementsMethod.returnValue();
        statementsMethod.endMethod();
        MethodWriter executeMethod = classWriter.newMethodWriter(1, this.scriptClassInfo.getExecuteMethod());
        executeMethod.visitCode();
        this.write(classWriter, executeMethod, this.globals);
        executeMethod.endMethod();
        for (SFunction function : this.functions) {
            function.write(classWriter, this.globals);
        }
        for (SField field : this.fields) {
            field.write(classWriter);
        }
        if (!this.globals.getConstantInitializers().isEmpty()) {
            Collection<Constant> inits = this.globals.getConstantInitializers().values();
            MethodWriter clinit = new MethodWriter(8, WriterConstants.CLINIT, classVisitor, this.globals.getStatements(), this.settings);
            clinit.visitCode();
            Iterator iterator = inits.iterator();
            while (iterator.hasNext()) {
                Constant constant = (Constant)iterator.next();
                constant.initializer.accept(clinit);
                clinit.putStatic(WriterConstants.CLASS_TYPE, constant.name, constant.type);
            }
            clinit.returnValue();
            clinit.endMethod();
        }
        for (Method needsMethod : this.scriptClassInfo.getNeedsMethods()) {
            String name = needsMethod.getName();
            name = name.substring(5);
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            MethodWriter ifaceMethod = classWriter.newMethodWriter(1, needsMethod);
            ifaceMethod.visitCode();
            ifaceMethod.push(this.extractedVariables.contains(name));
            ifaceMethod.returnValue();
            ifaceMethod.endMethod();
        }
        classVisitor.visitEnd();
        this.bytes = classWriter.getClassBytes();
        HashMap<String, Object> statics = new HashMap<String, Object>();
        statics.put("$FUNCTIONS", this.table.getFunctionTable());
        for (SField field : this.fields) {
            if (field.getInstance() == null) continue;
            statics.put(field.getName(), field.getInstance());
        }
        return statics;
    }

    @Override
    void write(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        Label startTry = new Label();
        Label endTry = new Label();
        Label startExplainCatch = new Label();
        Label startOtherCatch = new Label();
        Label endCatch = new Label();
        methodWriter.mark(startTry);
        if (this.settings.getMaxLoopCounter() > 0) {
            Locals.Variable loop = this.mainMethod.getVariable(null, "#loop");
            methodWriter.push(this.settings.getMaxLoopCounter());
            methodWriter.visitVarInsn(54, loop.getSlot());
        }
        for (Method method : this.getMethods) {
            String name = method.getName().substring(3);
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            Locals.Variable variable = this.mainMethod.getVariable(null, name);
            methodWriter.loadThis();
            methodWriter.invokeVirtual(Type.getType(this.scriptClassInfo.getBaseClass()), method);
            methodWriter.visitVarInsn(method.getReturnType().getOpcode(54), variable.getSlot());
        }
        for (AStatement statement : this.statements) {
            statement.write(classWriter, methodWriter, globals);
        }
        if (!this.methodEscape) {
            switch (this.scriptClassInfo.getExecuteMethod().getReturnType().getSort()) {
                case 0: {
                    break;
                }
                case 1: {
                    methodWriter.push(false);
                    break;
                }
                case 3: {
                    methodWriter.push(0);
                    break;
                }
                case 4: {
                    methodWriter.push(0);
                    break;
                }
                case 5: {
                    methodWriter.push(0);
                    break;
                }
                case 7: {
                    methodWriter.push(0L);
                    break;
                }
                case 6: {
                    methodWriter.push(0.0f);
                    break;
                }
                case 8: {
                    methodWriter.push(0.0);
                    break;
                }
                default: {
                    methodWriter.visitInsn(1);
                }
            }
            methodWriter.returnValue();
        }
        methodWriter.mark(endTry);
        methodWriter.goTo(endCatch);
        methodWriter.visitTryCatchBlock(startTry, endTry, startExplainCatch, WriterConstants.PAINLESS_EXPLAIN_ERROR_TYPE.getInternalName());
        methodWriter.mark(startExplainCatch);
        methodWriter.loadThis();
        methodWriter.swap();
        methodWriter.dup();
        methodWriter.getStatic(WriterConstants.CLASS_TYPE, "$DEFINITION", WriterConstants.DEFINITION_TYPE);
        methodWriter.invokeVirtual(WriterConstants.PAINLESS_EXPLAIN_ERROR_TYPE, WriterConstants.PAINLESS_EXPLAIN_ERROR_GET_HEADERS_METHOD);
        methodWriter.invokeInterface(WriterConstants.BASE_INTERFACE_TYPE, WriterConstants.CONVERT_TO_SCRIPT_EXCEPTION_METHOD);
        methodWriter.throwException();
        methodWriter.visitTryCatchBlock(startTry, endTry, startOtherCatch, WriterConstants.PAINLESS_ERROR_TYPE.getInternalName());
        methodWriter.visitTryCatchBlock(startTry, endTry, startOtherCatch, WriterConstants.BOOTSTRAP_METHOD_ERROR_TYPE.getInternalName());
        methodWriter.visitTryCatchBlock(startTry, endTry, startOtherCatch, WriterConstants.OUT_OF_MEMORY_ERROR_TYPE.getInternalName());
        methodWriter.visitTryCatchBlock(startTry, endTry, startOtherCatch, WriterConstants.STACK_OVERFLOW_ERROR_TYPE.getInternalName());
        methodWriter.visitTryCatchBlock(startTry, endTry, startOtherCatch, WriterConstants.EXCEPTION_TYPE.getInternalName());
        methodWriter.mark(startOtherCatch);
        methodWriter.loadThis();
        methodWriter.swap();
        methodWriter.invokeStatic(WriterConstants.COLLECTIONS_TYPE, WriterConstants.EMPTY_MAP_METHOD);
        methodWriter.invokeInterface(WriterConstants.BASE_INTERFACE_TYPE, WriterConstants.CONVERT_TO_SCRIPT_EXCEPTION_METHOD);
        methodWriter.throwException();
        methodWriter.mark(endCatch);
    }

    public BitSet getStatements() {
        return this.globals.getStatements();
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public String toString() {
        ArrayList<AStatement> subs = new ArrayList<AStatement>(this.functions.size() + this.statements.size());
        subs.addAll(this.functions);
        subs.addAll(this.statements);
        return this.multilineToString(Collections.emptyList(), subs);
    }
}

