/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.DigestAlgorithm;
import org.bouncycastle.crypto.OutputSigner;
import org.bouncycastle.crypto.OutputVerifier;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.SignatureOperatorFactory;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsDigestAlgorithm;
import org.bouncycastle.crypto.fips.FipsRSA;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.DigestUtil;
import org.bouncycastle.jcajce.provider.PrivateKeyConverter;
import org.bouncycastle.jcajce.provider.PublicKeyConverter;
import org.bouncycastle.jcajce.provider.Utils;

class BaseSignature
extends SignatureSpi
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers {
    private static final byte TRAILER_IMPLICIT = -68;
    private final SignatureOperatorFactory operatorFactory;
    private final PublicKeyConverter publicKeyConverter;
    private final PrivateKeyConverter privateKeyConverter;
    private final BouncyCastleFipsProvider fipsProvider;
    private final AlgorithmParameterSpec originalSpec;
    protected Parameters parameters;
    protected OutputVerifier verifier;
    protected OutputSigner signer;
    protected UpdateOutputStream dataStream;
    protected AlgorithmParameters engineParams;
    protected AlgorithmParameterSpec paramSpec;

    protected BaseSignature(BouncyCastleFipsProvider bouncyCastleFipsProvider, SignatureOperatorFactory signatureOperatorFactory, PublicKeyConverter publicKeyConverter, PrivateKeyConverter privateKeyConverter, Parameters parameters) {
        this.fipsProvider = bouncyCastleFipsProvider;
        this.operatorFactory = signatureOperatorFactory;
        this.publicKeyConverter = publicKeyConverter;
        this.privateKeyConverter = privateKeyConverter;
        this.parameters = parameters;
        this.originalSpec = null;
    }

    protected BaseSignature(BouncyCastleFipsProvider bouncyCastleFipsProvider, SignatureOperatorFactory signatureOperatorFactory, PublicKeyConverter publicKeyConverter, PrivateKeyConverter privateKeyConverter, Parameters parameters, AlgorithmParameterSpec algorithmParameterSpec) {
        this.fipsProvider = bouncyCastleFipsProvider;
        this.operatorFactory = signatureOperatorFactory;
        this.publicKeyConverter = publicKeyConverter;
        this.privateKeyConverter = privateKeyConverter;
        this.parameters = parameters;
        this.paramSpec = algorithmParameterSpec;
        this.originalSpec = algorithmParameterSpec;
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        Object t = this.publicKeyConverter.convertKey(this.parameters.getAlgorithm(), publicKey);
        this.verifier = this.operatorFactory.createVerifier((AsymmetricPublicKey)t, this.parameters);
        this.dataStream = this.verifier.getVerifyingStream();
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        Object t = this.privateKeyConverter.convertKey(this.parameters.getAlgorithm(), privateKey);
        try {
            this.signer = Utils.addRandomIfNeeded(this.operatorFactory.createSigner((AsymmetricPrivateKey)t, this.parameters), this.fipsProvider.getDefaultSecureRandom());
            this.dataStream = this.signer.getSigningStream();
        }
        catch (Exception exception) {
            throw new InvalidKeyException("Cannot initialize for signing: " + exception.getMessage(), exception);
        }
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        Object t = this.privateKeyConverter.convertKey(this.parameters.getAlgorithm(), privateKey);
        this.signer = Utils.addRandomIfNeeded(this.operatorFactory.createSigner((AsymmetricPrivateKey)t, this.parameters), secureRandom != null ? secureRandom : this.fipsProvider.getDefaultSecureRandom());
        this.dataStream = this.signer.getSigningStream();
    }

    protected void engineUpdate(byte by) throws SignatureException {
        this.dataStream.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.dataStream.update(byArray, n, n2);
    }

    protected byte[] engineSign() throws SignatureException {
        try {
            return this.signer.getSignature();
        }
        catch (Exception exception) {
            throw new SignatureException(exception.toString(), exception);
        }
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        try {
            return this.verifier.isVerified(byArray);
        }
        catch (Exception exception) {
            throw new SignatureException(exception.toString(), exception);
        }
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        PSSParameterSpec pSSParameterSpec;
        if (algorithmParameterSpec instanceof PSSParameterSpec) {
            AlgorithmParameterSpec algorithmParameterSpec2;
            pSSParameterSpec = (PSSParameterSpec)algorithmParameterSpec;
            if (this.originalSpec instanceof PSSParameterSpec && !DigestUtil.isSameDigest(((PSSParameterSpec)(algorithmParameterSpec2 = (PSSParameterSpec)this.originalSpec)).getDigestAlgorithm(), pSSParameterSpec.getDigestAlgorithm())) {
                throw new InvalidAlgorithmParameterException("Parameter must be using " + ((PSSParameterSpec)algorithmParameterSpec2).getDigestAlgorithm());
            }
            if (!pSSParameterSpec.getMGFAlgorithm().equalsIgnoreCase("MGF1") && !pSSParameterSpec.getMGFAlgorithm().equals(PKCSObjectIdentifiers.id_mgf1.getId())) {
                throw new InvalidAlgorithmParameterException("Unknown mask generation function specified");
            }
            if (!(pSSParameterSpec.getMGFParameters() instanceof MGF1ParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Unknown MGF parameters");
            }
            algorithmParameterSpec2 = (MGF1ParameterSpec)pSSParameterSpec.getMGFParameters();
            if (!DigestUtil.isSameDigest(((MGF1ParameterSpec)algorithmParameterSpec2).getDigestAlgorithm(), pSSParameterSpec.getDigestAlgorithm())) {
                throw new InvalidAlgorithmParameterException("Digest algorithm for MGF should be the same as for PSS parameters.");
            }
            DigestAlgorithm digestAlgorithm = DigestUtil.getDigestID(((MGF1ParameterSpec)algorithmParameterSpec2).getDigestAlgorithm());
            if (digestAlgorithm == null) {
                throw new InvalidAlgorithmParameterException("No match on MGF digest algorithm: " + ((MGF1ParameterSpec)algorithmParameterSpec2).getDigestAlgorithm());
            }
            if (!(digestAlgorithm instanceof FipsAlgorithm)) {
                throw new InvalidAlgorithmParameterException("Digest algorithm not supported: " + ((MGF1ParameterSpec)algorithmParameterSpec2).getDigestAlgorithm());
            }
            this.parameters = FipsRSA.PSS.withDigestAlgorithm((FipsDigestAlgorithm)digestAlgorithm).withMGFDigest((FipsDigestAlgorithm)digestAlgorithm).withSaltLength(pSSParameterSpec.getSaltLength()).withTrailer(this.getPssTrailer(pSSParameterSpec.getTrailerField()));
        } else {
            throw new InvalidAlgorithmParameterException("Only PSSParameterSpec supported");
        }
        this.paramSpec = pSSParameterSpec;
    }

    private byte getPssTrailer(int n) {
        if (n == 1) {
            return -68;
        }
        throw new IllegalArgumentException("Unknown trailer field");
    }

    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null && this.paramSpec != null) {
            try {
                this.engineParams = AlgorithmParameters.getInstance("PSS", this.fipsProvider);
                this.engineParams.init(this.paramSpec);
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception.toString(), exception);
            }
        }
        return this.engineParams;
    }

    protected void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("SetParameter unsupported");
    }

    protected Object engineGetParameter(String string) {
        throw new UnsupportedOperationException("GetParameter unsupported");
    }
}

