/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.profile;

import tim.prune.I18nManager;
import tim.prune.data.SpeedCalculator;
import tim.prune.data.SpeedValue;
import tim.prune.data.Track;
import tim.prune.data.UnitSet;
import tim.prune.gui.profile.ProfileData;

public class VerticalSpeedData
extends ProfileData {
    public VerticalSpeedData(Track track) {
        super(track);
    }

    public void init(UnitSet unitSet) {
        this.setUnitSet(unitSet);
        this.initArrays();
        this._hasData = false;
        this._maxValue = 0.0;
        this._minValue = 0.0;
        SpeedValue speedValue = new SpeedValue();
        if (this._track != null) {
            int n = 0;
            while (n < this._track.getNumPoints()) {
                SpeedCalculator.calculateVerticalSpeed(this._track, n, speedValue);
                if (speedValue.isValid()) {
                    double d;
                    this._pointValues[n] = d = speedValue.getValue();
                    if (d < this._minValue || !this._hasData) {
                        this._minValue = d;
                    }
                    if (d > this._maxValue || !this._hasData) {
                        this._maxValue = d;
                    }
                    this._hasData = true;
                }
                this._pointHasData[n] = speedValue.isValid();
                ++n;
            }
        }
    }

    public String getLabel() {
        return String.valueOf(I18nManager.getText("fieldname.verticalspeed")) + " (" + I18nManager.getText(this._unitSet.getVerticalSpeedUnit().getShortnameKey()) + ")";
    }

    public String getNoDataKey() {
        if (!this._track.hasAltitudeData()) {
            return "display.noaltitudes";
        }
        return "display.notimestamps";
    }
}

