/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.impl.internal;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.codehaus.plexus.component.annotations.Component;
import org.sonatype.aether.spi.io.FileProcessor;

@Component(role=FileProcessor.class)
public class DefaultFileProcessor
implements FileProcessor {
    private static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean mkdirs(File directory) {
        if (directory == null) {
            return false;
        }
        if (directory.exists()) {
            return false;
        }
        if (directory.mkdir()) {
            return true;
        }
        File canonDir = null;
        try {
            canonDir = directory.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        File parentDir = canonDir.getParentFile();
        return parentDir != null && (this.mkdirs(parentDir) || parentDir.exists()) && canonDir.mkdir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file, String data) throws IOException {
        this.mkdirs(file.getParentFile());
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            if (data != null) {
                fos.write(data.getBytes("UTF-8"));
            }
        }
        catch (Throwable throwable) {
            DefaultFileProcessor.close(fos);
            throw throwable;
        }
        DefaultFileProcessor.close(fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long copy(File source, File target, FileProcessor.ProgressListener listener) throws IOException {
        long total = 0L;
        FileInputStream fis = null;
        BufferedOutputStream fos = null;
        try {
            int bytes;
            fis = new FileInputStream(source);
            this.mkdirs(target.getParentFile());
            fos = new BufferedOutputStream(new FileOutputStream(target));
            ByteBuffer buffer = ByteBuffer.allocate(32768);
            byte[] array = buffer.array();
            while ((bytes = fis.read(array)) >= 0) {
                ((OutputStream)fos).write(array, 0, bytes);
                total += (long)bytes;
                if (listener == null || bytes <= 0) continue;
                try {
                    buffer.rewind();
                    buffer.limit(bytes);
                    listener.progressed(buffer);
                }
                catch (Exception e) {}
            }
        }
        catch (Throwable throwable) {
            DefaultFileProcessor.close(fis);
            DefaultFileProcessor.close(fos);
            throw throwable;
        }
        DefaultFileProcessor.close(fis);
        DefaultFileProcessor.close(fos);
        return total;
    }

    public void move(File source, File target) throws IOException {
        if (!source.renameTo(target)) {
            this.copy(source, target, null);
            target.setLastModified(source.lastModified());
            source.delete();
        }
    }
}

