/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import one.util.streamex.Java9Specific;
import one.util.streamex.VersionSpecific;
import sun.misc.Unsafe;

final class StreamExInternals {
    static final Function<int[], Integer> UNBOX_INT = box -> box[0];
    static final Function<long[], Long> UNBOX_LONG = box -> box[0];
    static final Function<double[], Double> UNBOX_DOUBLE = box -> box[0];
    static final Object NONE = new Object();
    static final Set<Collector.Characteristics> NO_CHARACTERISTICS = EnumSet.noneOf(Collector.Characteristics.class);
    static final Set<Collector.Characteristics> UNORDERED_CHARACTERISTICS = EnumSet.of(Collector.Characteristics.UNORDERED);
    static final Set<Collector.Characteristics> UNORDERED_ID_CHARACTERISTICS = EnumSet.of(Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH);
    static final Set<Collector.Characteristics> ID_CHARACTERISTICS = EnumSet.of(Collector.Characteristics.IDENTITY_FINISH);
    static final Field SOURCE_SPLITERATOR;
    static final Field SOURCE_STAGE;
    static final Field SOURCE_CLOSE_ACTION;
    static final Field SPLITERATOR_ITERATOR;
    static final VersionSpecific VER_SPEC;

    static <A> Predicate<A> finished(Collector<?, A, ?> collector2) {
        if (collector2 instanceof CancellableCollector) {
            return ((CancellableCollector)collector2).finished();
        }
        return null;
    }

    static {
        VER_SPEC = System.getProperty("java.version", "").compareTo("1.9") > 0 ? new Java9Specific() : new VersionSpecific();
        ArrayDeque fields2 = new ArrayDeque();
        try {
            AccessController.doPrivileged(() -> {
                Class<?> abstractPipelineClass = Class.forName("java.util.stream.AbstractPipeline");
                fields2.add(abstractPipelineClass.getDeclaredField("sourceSpliterator"));
                fields2.add(abstractPipelineClass.getDeclaredField("sourceStage"));
                fields2.add(abstractPipelineClass.getDeclaredField("sourceCloseAction"));
                fields2.add(Class.forName("java.util.Spliterators$IteratorSpliterator").getDeclaredField("it"));
                try {
                    Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
                    unsafeField.setAccessible(true);
                    Unsafe U = (Unsafe)unsafeField.get(null);
                    Field override = AccessibleObject.class.getDeclaredField("override");
                    long offset2 = U.objectFieldOffset(override);
                    for (Field f : fields2) {
                        U.putBoolean(f, offset2, true);
                    }
                }
                catch (LinkageError | ReflectiveOperationException | SecurityException ex) {
                    for (Field f : fields2) {
                        f.setAccessible(true);
                    }
                }
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            fields2.clear();
        }
        SOURCE_SPLITERATOR = (Field)fields2.poll();
        SOURCE_STAGE = (Field)fields2.poll();
        SOURCE_CLOSE_ACTION = (Field)fields2.poll();
        SPLITERATOR_ITERATOR = (Field)fields2.poll();
    }

    static abstract class CloneableSpliterator<T, S extends CloneableSpliterator<T, ?>>
    implements Cloneable,
    Spliterator<T> {
        CloneableSpliterator() {
        }

        S doClone() {
            try {
                return (S)((CloneableSpliterator)this.clone());
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }
    }

    static class ArrayCollection
    extends AbstractCollection<Object> {
        private final Object[] arr;

        ArrayCollection(Object[] arr) {
            this.arr = arr;
        }

        @Override
        public Iterator<Object> iterator() {
            return Arrays.asList(this.arr).iterator();
        }

        @Override
        public int size() {
            return this.arr.length;
        }

        @Override
        public Object[] toArray() {
            return this.arr;
        }
    }

    static class CancelException
    extends Error {
        CancelException() {
            super(null, null, false, false);
        }
    }

    static abstract class CancellableCollector<T, A, R>
    implements Collector<T, A, R> {
        CancellableCollector() {
        }

        abstract Predicate<A> finished();
    }
}

