/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionManager;
import org.jetbrains.kotlin.com.intellij.util.ConcurrencyUtil;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.Producer;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public abstract class ConcurrentFactoryMap<K, V>
implements ConcurrentMap<K, V> {
    private static final RecursionGuard ourGuard = RecursionManager.createGuard("factoryMap");
    private final ConcurrentMap<K, V> myMap = this.createMap();

    @Deprecated
    public ConcurrentFactoryMap() {
    }

    @Nullable
    protected abstract V create(K var1);

    @Override
    public V get(Object key) {
        ConcurrentMap<K, V> map2 = this.myMap;
        Object k = ConcurrentFactoryMap.notNull(key);
        Object value = map2.get(k);
        if (value == null) {
            RecursionGuard.StackStamp stamp = ourGuard.markStack();
            value = this.create(key);
            if (stamp.mayCacheNow()) {
                Object v2 = ConcurrentFactoryMap.notNull(value);
                value = ConcurrencyUtil.cacheOrGet(map2, k, v2);
            }
        }
        return ConcurrentFactoryMap.nullize(value);
    }

    @Nullable
    private static <T> T nullize(T value) {
        return value == ConcurrentFactoryMap.FAKE_NULL() ? null : (T)value;
    }

    private static <T> T FAKE_NULL() {
        return (T)ObjectUtils.NULL;
    }

    private static <T> T notNull(Object key) {
        return (T)(key == null ? ConcurrentFactoryMap.FAKE_NULL() : key);
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.myMap.containsKey(ConcurrentFactoryMap.notNull(key));
    }

    @Override
    public V put(K key, V value) {
        Object k = ConcurrentFactoryMap.notNull(key);
        Object v2 = ConcurrentFactoryMap.notNull(value);
        v2 = this.myMap.put(k, v2);
        return (V)ConcurrentFactoryMap.nullize(v2);
    }

    @Override
    public V remove(Object key) {
        Object v2 = this.myMap.remove(ConcurrentFactoryMap.notNull(key));
        return ConcurrentFactoryMap.nullize(v2);
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        CollectionWrapper.Set set = new CollectionWrapper.Set(this.myMap.keySet());
        if (set == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    public void clear() {
        this.myMap.clear();
    }

    @Override
    public int size() {
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.myMap.containsValue(ConcurrentFactoryMap.notNull(value));
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        if (m == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(1);
        }
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    @NotNull
    public Collection<V> values() {
        CollectionWrapper collectionWrapper = new CollectionWrapper(this.myMap.values());
        if (collectionWrapper == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(2);
        }
        return collectionWrapper;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        CollectionWrapper.Set set = new CollectionWrapper.Set<Map.Entry<K, V>>(this.myMap.entrySet()){

            @Override
            public Object wrap(Object val) {
                return val instanceof CollectionWrapper.EntryWrapper ? ((CollectionWrapper.EntryWrapper)val).myEntry : val;
            }

            @Override
            public Map.Entry<K, V> unwrap(Map.Entry<K, V> val) {
                return val.getKey() == ConcurrentFactoryMap.FAKE_NULL() || val.getValue() == ConcurrentFactoryMap.FAKE_NULL() ? new CollectionWrapper.EntryWrapper(val) : val;
            }
        };
        if (set == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    protected ConcurrentMap<K, V> createMap() {
        ConcurrentMap concurrentMap = ContainerUtil.newConcurrentMap();
        if (concurrentMap == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(4);
        }
        return concurrentMap;
    }

    @Override
    public V putIfAbsent(@NotNull K key, V value) {
        if (key == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(5);
        }
        return ConcurrentFactoryMap.nullize(this.myMap.putIfAbsent(ConcurrentFactoryMap.notNull(key), ConcurrentFactoryMap.notNull(value)));
    }

    @Override
    public boolean remove(@NotNull Object key, Object value) {
        if (key == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(6);
        }
        return this.myMap.remove(ConcurrentFactoryMap.notNull(key), ConcurrentFactoryMap.notNull(value));
    }

    @Override
    public boolean replace(@NotNull K key, @NotNull V oldValue, @NotNull V newValue) {
        if (key == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(7);
        }
        if (oldValue == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(8);
        }
        if (newValue == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(9);
        }
        return this.myMap.replace(ConcurrentFactoryMap.notNull(key), ConcurrentFactoryMap.notNull(oldValue), ConcurrentFactoryMap.notNull(newValue));
    }

    @Override
    public V replace(@NotNull K key, @NotNull V value) {
        if (key == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(10);
        }
        if (value == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(11);
        }
        return ConcurrentFactoryMap.nullize(this.myMap.replace(ConcurrentFactoryMap.notNull(key), ConcurrentFactoryMap.notNull(value)));
    }

    @NotNull
    public static <T, V> ConcurrentMap<T, V> createMap(final @NotNull Function<? super T, ? extends V> computeValue) {
        if (computeValue == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(12);
        }
        ConcurrentFactoryMap concurrentFactoryMap = new ConcurrentFactoryMap<T, V>(){

            @Override
            @Nullable
            protected V create(T key) {
                return computeValue.fun(key);
            }
        };
        if (concurrentFactoryMap == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(13);
        }
        return concurrentFactoryMap;
    }

    @NotNull
    public static <K, V> ConcurrentMap<K, V> createMap(final @NotNull Function<? super K, ? extends V> computeValue, final @NotNull Producer<? extends ConcurrentMap<K, V>> mapCreator) {
        if (computeValue == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(14);
        }
        if (mapCreator == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(15);
        }
        ConcurrentFactoryMap concurrentFactoryMap = new ConcurrentFactoryMap<K, V>(){

            @Override
            @Nullable
            protected V create(K key) {
                return computeValue.fun(key);
            }

            @Override
            @NotNull
            protected ConcurrentMap<K, V> createMap() {
                ConcurrentMap concurrentMap = (ConcurrentMap)mapCreator.produce();
                if (concurrentMap == null) {
                    3.$$$reportNull$$$0(0);
                }
                return concurrentMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentFactoryMap$3", "createMap"));
            }
        };
        if (concurrentFactoryMap == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(16);
        }
        return concurrentFactoryMap;
    }

    @NotNull
    public static <T, V> ConcurrentMap<T, V> createWeakMap(@NotNull Function<? super T, ? extends V> compute) {
        if (compute == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(17);
        }
        ConcurrentMap<? super T, ? extends V> concurrentMap = ConcurrentFactoryMap.createMap(compute, new Producer<ConcurrentMap<T, V>>(){

            @Override
            public ConcurrentMap<T, V> produce() {
                return ContainerUtil.createConcurrentWeakMap();
            }
        });
        if (concurrentMap == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(18);
        }
        return concurrentMap;
    }

    @Override
    @Deprecated
    public V getOrDefault(Object key, V defaultValue) {
        V v2 = this.get(key);
        return v2 != null ? v2 : defaultValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentFactoryMap";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldValue";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computeValue";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapCreator";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "keySet";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentFactoryMap";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "entrySet";
                break;
            }
            case 4: 
            case 13: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createMap";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakMap";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "putAll";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "putIfAbsent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createMap";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createWeakMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CollectionWrapper<K>
    extends AbstractCollection<K> {
        private final Collection<K> myDelegate;

        CollectionWrapper(Collection<K> delegate) {
            this.myDelegate = delegate;
        }

        @Override
        @NotNull
        public Iterator<K> iterator() {
            Iterator iterator2 = new Iterator<K>(){
                Iterator<K> it;
                {
                    this.it = CollectionWrapper.this.myDelegate.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public K next() {
                    return CollectionWrapper.this.unwrap(this.it.next());
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
            if (iterator2 == null) {
                CollectionWrapper.$$$reportNull$$$0(0);
            }
            return iterator2;
        }

        @Override
        public int size() {
            return this.myDelegate.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.myDelegate.contains(this.wrap(o));
        }

        @Override
        public boolean remove(Object o) {
            return this.myDelegate.remove(this.wrap(o));
        }

        protected Object wrap(Object val) {
            return ConcurrentFactoryMap.notNull(val);
        }

        protected K unwrap(K val) {
            return (K)ConcurrentFactoryMap.nullize(val);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentFactoryMap$CollectionWrapper", "iterator"));
        }

        protected static class EntryWrapper<K, V>
        implements Map.Entry<K, V> {
            final Map.Entry<? extends K, V> myEntry;

            private EntryWrapper(Map.Entry<? extends K, V> entry) {
                this.myEntry = entry;
            }

            @Override
            public K getKey() {
                return (K)ConcurrentFactoryMap.nullize(this.myEntry.getKey());
            }

            @Override
            public V getValue() {
                return (V)ConcurrentFactoryMap.nullize(this.myEntry.getValue());
            }

            @Override
            public V setValue(V value) {
                return (V)this.myEntry.setValue(ConcurrentFactoryMap.notNull(value));
            }

            @Override
            public int hashCode() {
                return this.myEntry.hashCode();
            }

            @Override
            public boolean equals(Object obj) {
                return this.myEntry.equals(obj instanceof EntryWrapper ? ((EntryWrapper)obj).myEntry : obj);
            }
        }

        private static class Set<K>
        extends CollectionWrapper<K>
        implements java.util.Set<K> {
            Set(Collection<K> delegate) {
                super(delegate);
            }
        }
    }
}

