/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.compile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.JavaVersion;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.collections.ImmutableFileCollection;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.JavaToolChainFactory;
import org.gradle.api.internal.tasks.compile.CleaningGroovyCompiler;
import org.gradle.api.internal.tasks.compile.CompilerForkUtils;
import org.gradle.api.internal.tasks.compile.DefaultGroovyJavaJointCompileSpec;
import org.gradle.api.internal.tasks.compile.DefaultGroovyJavaJointCompileSpecFactory;
import org.gradle.api.internal.tasks.compile.GroovyCompilerFactory;
import org.gradle.api.internal.tasks.compile.GroovyJavaJointCompileSpec;
import org.gradle.api.internal.tasks.compile.processing.AnnotationProcessorDetector;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskOutputs;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.GroovyCompileOptions;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.jvm.inspection.JvmVersionDetector;
import org.gradle.jvm.toolchain.JavaToolChain;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.util.GFileUtils;
import org.gradle.workers.internal.IsolatedClassloaderWorkerFactory;
import org.gradle.workers.internal.WorkerDaemonFactory;

@CacheableTask
public class GroovyCompile
extends AbstractCompile {
    private Compiler<GroovyJavaJointCompileSpec> compiler;
    private FileCollection groovyClasspath;
    private final CompileOptions compileOptions;
    private final GroovyCompileOptions groovyCompileOptions = new GroovyCompileOptions();

    public GroovyCompile() {
        CompileOptions compileOptions;
        this.compileOptions = compileOptions = (CompileOptions)((ObjectFactory)this.getServices().get(ObjectFactory.class)).newInstance(CompileOptions.class, new Object[0]);
        CompilerForkUtils.doNotCacheIfForkingViaExecutable((CompileOptions)compileOptions, (TaskOutputs)this.getOutputs());
    }

    @TaskAction
    protected void compile() {
        this.checkGroovyClasspathIsNonEmpty();
        DefaultGroovyJavaJointCompileSpec spec = this.createSpec();
        WorkResult result = this.getCompiler(spec).execute((CompileSpec)spec);
        this.setDidWork(result.getDidWork());
    }

    private Compiler<GroovyJavaJointCompileSpec> getCompiler(GroovyJavaJointCompileSpec spec) {
        if (this.compiler == null) {
            ProjectInternal projectInternal = (ProjectInternal)this.getProject();
            WorkerDaemonFactory workerDaemonFactory = (WorkerDaemonFactory)this.getServices().get(WorkerDaemonFactory.class);
            IsolatedClassloaderWorkerFactory inProcessWorkerFactory = (IsolatedClassloaderWorkerFactory)this.getServices().get(IsolatedClassloaderWorkerFactory.class);
            PathToFileResolver fileResolver = (PathToFileResolver)this.getServices().get(PathToFileResolver.class);
            AnnotationProcessorDetector processorDetector = (AnnotationProcessorDetector)this.getServices().get(AnnotationProcessorDetector.class);
            JvmVersionDetector jvmVersionDetector = (JvmVersionDetector)this.getServices().get(JvmVersionDetector.class);
            GroovyCompilerFactory groovyCompilerFactory = new GroovyCompilerFactory(projectInternal, workerDaemonFactory, inProcessWorkerFactory, fileResolver, processorDetector, jvmVersionDetector);
            Compiler<GroovyJavaJointCompileSpec> delegatingCompiler = groovyCompilerFactory.newCompiler(spec);
            this.compiler = new CleaningGroovyCompiler(delegatingCompiler, this.getOutputs());
        }
        return this.compiler;
    }

    private DefaultGroovyJavaJointCompileSpec createSpec() {
        DefaultGroovyJavaJointCompileSpec spec = (DefaultGroovyJavaJointCompileSpec)new DefaultGroovyJavaJointCompileSpecFactory(this.compileOptions).create();
        spec.setSourceFiles((Iterable)this.getSource());
        spec.setDestinationDir(this.getDestinationDir());
        spec.setWorkingDir(this.getProject().getProjectDir());
        spec.setTempDir(this.getTemporaryDir());
        spec.setCompileClasspath((List)ImmutableList.copyOf((Iterable)this.getClasspath()));
        spec.setSourceCompatibility(this.getSourceCompatibility());
        spec.setTargetCompatibility(this.getTargetCompatibility());
        spec.setAnnotationProcessorPath(Lists.newArrayList((Iterable)(this.compileOptions.getAnnotationProcessorPath() == null ? ImmutableFileCollection.of() : this.compileOptions.getAnnotationProcessorPath())));
        spec.setGroovyClasspath(Lists.newArrayList((Iterable)this.getGroovyClasspath()));
        spec.setCompileOptions(this.compileOptions);
        spec.setGroovyCompileOptions(this.groovyCompileOptions);
        if (spec.getGroovyCompileOptions().getStubDir() == null) {
            File dir = new File(this.getTemporaryDir(), "groovy-java-stubs");
            GFileUtils.mkdirs((File)dir);
            spec.getGroovyCompileOptions().setStubDir(dir);
        }
        return spec;
    }

    private void checkGroovyClasspathIsNonEmpty() {
        if (this.getGroovyClasspath().isEmpty()) {
            throw new InvalidUserDataException("'" + this.getName() + ".groovyClasspath' must not be empty. If a Groovy compile dependency is provided, the 'groovy-base' plugin will attempt to configure 'groovyClasspath' automatically. Alternatively, you may configure 'groovyClasspath' explicitly.");
        }
    }

    @Input
    protected String getGroovyCompilerJvmVersion() {
        return JavaVersion.current().getMajorVersion();
    }

    @Nested
    protected JavaToolChain getJavaToolChain() {
        return this.getJavaToolChainFactory().forCompileOptions(this.getOptions());
    }

    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    public FileTree getSource() {
        return super.getSource();
    }

    @Nested
    public GroovyCompileOptions getGroovyOptions() {
        return this.groovyCompileOptions;
    }

    @Nested
    public CompileOptions getOptions() {
        return this.compileOptions;
    }

    @Classpath
    public FileCollection getGroovyClasspath() {
        return this.groovyClasspath;
    }

    public void setGroovyClasspath(FileCollection groovyClasspath) {
        this.groovyClasspath = groovyClasspath;
    }

    @Internal
    public Compiler<GroovyJavaJointCompileSpec> getCompiler() {
        return this.getCompiler(this.createSpec());
    }

    public void setCompiler(Compiler<GroovyJavaJointCompileSpec> compiler) {
        this.compiler = compiler;
    }

    @Inject
    protected JavaToolChainFactory getJavaToolChainFactory() {
        throw new UnsupportedOperationException();
    }
}

