/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.commandline;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.languagetool.Language;
import org.languagetool.rules.CategoryId;

public class CommandLineOptions {
    private final Set<CategoryId> enabledCategories = new HashSet<CategoryId>();
    private final Set<CategoryId> disabledCategories = new HashSet<CategoryId>();
    private boolean printUsage = false;
    private boolean printVersion = false;
    private boolean printLanguages = false;
    private boolean verbose = false;
    private boolean recursive = false;
    private boolean taggerOnly = false;
    private boolean singleLineBreakMarksParagraph = false;
    private OutputFormat outputFormat = OutputFormat.PLAINTEXT;
    private boolean listUnknown = false;
    private boolean applySuggestions = false;
    private boolean profile = false;
    private boolean bitext = false;
    private boolean autoDetect = false;
    private boolean xmlFiltering = false;
    private boolean lineByLine = false;
    @Nullable
    private Language language = null;
    @Nullable
    private Language motherTongue = null;
    @Nullable
    private File languageModel = null;
    @Nullable
    private File word2vecModel = null;
    @Nullable
    private File neuralNetworkModel = null;
    @Nullable
    private File fasttextModel = null;
    @Nullable
    private File fasttextBinary = null;
    @Nullable
    private String encoding = null;
    @Nullable
    private String filename = null;
    private List<String> disabledRules = new ArrayList<String>();
    private List<String> enabledRules = new ArrayList<String>();
    private boolean useEnabledOnly = false;
    @Nullable
    private String ruleFile = null;
    @Nullable
    private String falseFriendFile = null;
    @Nullable
    private String bitextRuleFile = null;

    public boolean isPrintUsage() {
        return this.printUsage;
    }

    public void setPrintUsage(boolean printUsage) {
        this.printUsage = printUsage;
    }

    public boolean isPrintVersion() {
        return this.printVersion;
    }

    public void setPrintVersion(boolean printVersion) {
        this.printVersion = printVersion;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isLineByLine() {
        return this.lineByLine;
    }

    public void setLineByLine(boolean lineByLine) {
        this.lineByLine = lineByLine;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public boolean isTaggerOnly() {
        return this.taggerOnly;
    }

    public void setTaggerOnly(boolean taggerOnly) {
        this.taggerOnly = taggerOnly;
    }

    public boolean isSingleLineBreakMarksParagraph() {
        return this.singleLineBreakMarksParagraph;
    }

    public void setSingleLineBreakMarksParagraph(boolean singleLineBreakMarksParagraph) {
        this.singleLineBreakMarksParagraph = singleLineBreakMarksParagraph;
    }

    public boolean isXmlFormat() {
        return this.outputFormat == OutputFormat.XML;
    }

    public void setXmlFormat() {
        this.outputFormat = OutputFormat.XML;
    }

    public boolean isJsonFormat() {
        return this.outputFormat == OutputFormat.JSON;
    }

    public void setJsonFormat() {
        this.outputFormat = OutputFormat.JSON;
    }

    public boolean isListUnknown() {
        return this.listUnknown;
    }

    public void setListUnknown(boolean listUnknown) {
        this.listUnknown = listUnknown;
    }

    public boolean isApplySuggestions() {
        return this.applySuggestions;
    }

    public void setApplySuggestions(boolean applySuggestions) {
        this.applySuggestions = applySuggestions;
    }

    public boolean isProfile() {
        return this.profile;
    }

    public void setProfile(boolean profile) {
        this.profile = profile;
    }

    public boolean isBitext() {
        return this.bitext;
    }

    public void setBitext(boolean bitext) {
        this.bitext = bitext;
    }

    public boolean isAutoDetect() {
        return this.autoDetect;
    }

    public void setAutoDetect(boolean autoDetect) {
        this.autoDetect = autoDetect;
    }

    @Nullable
    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    @Nullable
    public Language getMotherTongue() {
        return this.motherTongue;
    }

    public void setMotherTongue(Language motherTongue) {
        this.motherTongue = motherTongue;
    }

    @Nullable
    public File getLanguageModel() {
        return this.languageModel;
    }

    public void setLanguageModel(File languageModel) {
        this.languageModel = languageModel;
    }

    @Nullable
    public File getWord2VecModel() {
        return this.word2vecModel;
    }

    public void setWord2VecModel(File neuralNetworkLanguageModel) {
        this.word2vecModel = neuralNetworkLanguageModel;
    }

    @Nullable
    public File getNeuralNetworkModel() {
        return this.neuralNetworkModel;
    }

    public void setNeuralNetworkModel(File neuralNetworkModel) {
        this.neuralNetworkModel = neuralNetworkModel;
    }

    @Nullable
    public File getFasttextModel() {
        return this.fasttextModel;
    }

    public void setFasttextModel(File fasttextModel) {
        this.fasttextModel = fasttextModel;
    }

    @Nullable
    public File getFasttextBinary() {
        return this.fasttextBinary;
    }

    public void setFasttextBinary(File fasttextBinary) {
        this.fasttextBinary = fasttextBinary;
    }

    @Nullable
    public String getRuleFile() {
        return this.ruleFile;
    }

    public void setRuleFile(String ruleFile) {
        this.ruleFile = ruleFile;
    }

    @Nullable
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Nullable
    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public List<String> getDisabledRules() {
        return this.disabledRules;
    }

    public void setDisabledRules(List<String> disabledRules) {
        this.disabledRules = Objects.requireNonNull(disabledRules);
    }

    public List<String> getEnabledRules() {
        return this.enabledRules;
    }

    public void setEnabledRules(List<String> enabledRules) {
        this.enabledRules = Objects.requireNonNull(enabledRules);
    }

    public void setEnabledCategories(List<String> categoryIds) {
        for (String categoryId : categoryIds) {
            this.enabledCategories.add(new CategoryId(categoryId));
        }
    }

    public Set<CategoryId> getEnabledCategories() {
        return Collections.unmodifiableSet(this.enabledCategories);
    }

    public void setDisabledCategories(List<String> categoryIds) {
        for (String categoryId : categoryIds) {
            this.disabledCategories.add(new CategoryId(categoryId));
        }
    }

    public Set<CategoryId> getDisabledCategories() {
        return Collections.unmodifiableSet(this.disabledCategories);
    }

    public boolean isUseEnabledOnly() {
        return this.useEnabledOnly;
    }

    public void setUseEnabledOnly() {
        this.useEnabledOnly = true;
    }

    public boolean isXmlFiltering() {
        return this.xmlFiltering;
    }

    public void setXmlFiltering(boolean xmlFiltering) {
        this.xmlFiltering = xmlFiltering;
    }

    public boolean isPrintLanguages() {
        return this.printLanguages;
    }

    public void setPrintLanguages(boolean printLanguages) {
        this.printLanguages = printLanguages;
    }

    public void setFalseFriendFile(String file) {
        this.falseFriendFile = file;
    }

    @Nullable
    public String getFalseFriendFile() {
        return this.falseFriendFile;
    }

    @Nullable
    public String getBitextRuleFile() {
        return this.bitextRuleFile;
    }

    public void setBitextRuleFile(String bitextRuleFile) {
        this.bitextRuleFile = bitextRuleFile;
    }

    public static enum OutputFormat {
        PLAINTEXT,
        JSON,
        XML;

    }
}

