/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.render;

import gnu.trove.TLongCollection;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.list.TLongList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.awt.Graphics2D;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.osmand.IProgress;
import net.osmand.PlatformUtil;
import net.osmand.ResultMatcher;
import net.osmand.binary.BinaryMapDataObject;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.binary.RouteDataObject;
import net.osmand.data.QuadPointDouble;
import net.osmand.data.QuadRect;
import net.osmand.data.RotatedTileBox;
import net.osmand.plus.OsmandSettings;
import net.osmand.plus.render.DrawSettings;
import net.osmand.plus.render.OsmandRenderer;
import net.osmand.render.RenderingRuleProperty;
import net.osmand.render.RenderingRuleSearchRequest;
import net.osmand.render.RenderingRulesStorage;
import net.osmand.util.Algorithms;
import net.osmand.util.MapAlgorithms;
import net.osmand.util.MapUtils;
import net.sourceforge.offroad.OsmWindow;
import net.sourceforge.offroad.ui.OsmBitmapPanel;
import org.apache.commons.logging.Log;

public class MapRenderRepositories {
    public static boolean checkForDuplicateObjectIds = true;
    private static final Log log = PlatformUtil.getLog(MapRenderRepositories.class);
    private static final int zoomOnlyForBasemaps = 11;
    static int zoomForBaseRouteRendering = 14;
    private Map<String, BinaryMapIndexReader> files = new LinkedHashMap<String, BinaryMapIndexReader>();
    private Set<String> nativeFiles = new HashSet<String>();
    private OsmandRenderer renderer;
    private QuadRect cObjectsBox = new QuadRect();
    private int cObjectsZoom = 0;
    private List<BinaryMapDataObject> cObjects = new LinkedList<BinaryMapDataObject>();
    private RotatedTileBox requestedBox = null;
    private RotatedTileBox prevBmpLocation = null;
    private int checkedRenderedState;
    private RotatedTileBox checkedBox;
    private RotatedTileBox bmpLocation = null;
    private boolean interrupted = false;
    private int renderedState = 0;
    private OsmandRenderer.RenderingContext currentRenderingContext;
    private BinaryMapIndexReader.SearchRequest<BinaryMapDataObject> searchRequest;
    private OsmandSettings prefs;

    public MapRenderRepositories(OsmandSettings pPrefs) {
        this.prefs = pPrefs;
        this.renderer = new OsmandRenderer();
    }

    public OsmandRenderer getRenderer() {
        return this.renderer;
    }

    public void initializeNewResource(IProgress progress, File file, BinaryMapIndexReader reader) {
        if (this.files.containsKey(file.getName())) {
            this.closeConnection(file.getName());
        }
        LinkedHashMap<String, BinaryMapIndexReader> cpfiles = new LinkedHashMap<String, BinaryMapIndexReader>(this.files);
        cpfiles.put(file.getName(), reader);
        this.files = cpfiles;
    }

    public RotatedTileBox getBitmapLocation() {
        return this.bmpLocation;
    }

    public RotatedTileBox getPrevBmpLocation() {
        return this.prevBmpLocation;
    }

    public synchronized void closeConnection(String file) {
        LinkedHashMap<String, BinaryMapIndexReader> cpfiles = new LinkedHashMap<String, BinaryMapIndexReader>(this.files);
        BinaryMapIndexReader bmir = (BinaryMapIndexReader)cpfiles.remove(file);
        this.files = cpfiles;
        if (bmir != null) {
            try {
                bmir.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean containsLatLonMapData(double lat, double lon, int zoom) {
        int x = MapUtils.get31TileNumberX(lon);
        int y = MapUtils.get31TileNumberY(lat);
        for (BinaryMapIndexReader reader : this.files.values()) {
            if (!reader.containsMapData(x, y, zoom)) continue;
            return true;
        }
        return false;
    }

    public void clearAllResources() {
        this.clearCache();
        this.bmpLocation = null;
        for (String f : new ArrayList<String>(this.files.keySet())) {
            this.closeConnection(f);
        }
    }

    public boolean updateMapIsNeeded(RotatedTileBox box, DrawSettings drawSettings) {
        boolean upd;
        if (box == null) {
            return false;
        }
        if (this.requestedBox == null) {
            log.debug((Object)"RENDER MAP: update due to start");
            return true;
        }
        if (drawSettings.isUpdateVectorRendering()) {
            log.debug((Object)"RENDER MAP: update due to request");
            return true;
        }
        if (this.requestedBox.getZoom() != box.getZoom() || this.requestedBox.getMapDensity() != box.getMapDensity()) {
            log.debug((Object)"RENDER MAP: update due zoom/map density");
            return true;
        }
        float deltaRotate = this.requestedBox.getRotate() - box.getRotate();
        if (deltaRotate > 180.0f) {
            deltaRotate -= 360.0f;
        } else if (deltaRotate < -180.0f) {
            deltaRotate += 360.0f;
        }
        if (Math.abs(deltaRotate) > 25.0f) {
            log.debug((Object)"RENDER MAP: update due to rotation");
            return true;
        }
        boolean bl = upd = !this.requestedBox.containsTileBox(box);
        if (upd) {
            log.debug((Object)"RENDER MAP: update due to tile box");
        }
        return upd;
    }

    public boolean isEmpty() {
        return this.files.isEmpty();
    }

    public void interruptLoadingMap() {
        this.interrupted = true;
        if (this.currentRenderingContext != null) {
            this.currentRenderingContext.interrupted = true;
        }
        if (this.searchRequest != null) {
            this.searchRequest.setInterrupted(true);
        }
        log.info((Object)"RENDER MAP: Interrupt rendering map");
    }

    public boolean wasInterrupted() {
        return this.interrupted;
    }

    private boolean checkWhetherInterrupted() {
        if (this.interrupted || this.currentRenderingContext != null && this.currentRenderingContext.interrupted) {
            this.requestedBox = this.bmpLocation;
            return true;
        }
        return false;
    }

    public boolean basemapExists() {
        for (BinaryMapIndexReader f : this.files.values()) {
            if (!f.isBasemap()) continue;
            return true;
        }
        return false;
    }

    private boolean loadVectorDataNative(QuadRect dataBox, int zoom, RenderingRuleSearchRequest renderingReq) {
        int leftX = MapUtils.get31TileNumberX(dataBox.left);
        int rightX = MapUtils.get31TileNumberX(dataBox.right);
        int bottomY = MapUtils.get31TileNumberY(dataBox.bottom);
        int topY = MapUtils.get31TileNumberY(dataBox.top);
        long now = System.currentTimeMillis();
        if (this.checkWhetherInterrupted()) {
            return false;
        }
        this.cObjectsBox = dataBox;
        this.cObjectsZoom = zoom;
        log.debug((Object)String.format("BLat=%s, TLat=%s, LLong=%s, RLong=%s, zoom=%s", dataBox.bottom, dataBox.top, dataBox.left, dataBox.right, zoom));
        log.debug((Object)String.format("Native search: %s ms ", System.currentTimeMillis() - now));
        return true;
    }

    private void readRouteDataAsMapObjects(BinaryMapIndexReader.SearchRequest<BinaryMapDataObject> sr, BinaryMapIndexReader c, final ArrayList<BinaryMapDataObject> tempResult, final TLongSet ids) {
        final boolean basemap = c.isBasemap();
        try {
            for (BinaryMapRouteReaderAdapter.RouteRegion reg : c.getRoutingIndexes()) {
                List<BinaryMapRouteReaderAdapter.RouteSubregion> parent = sr.getZoom() < 15 ? reg.getBaseSubregions() : reg.getSubregions();
                List<BinaryMapRouteReaderAdapter.RouteSubregion> searchRouteIndexTree = c.searchRouteIndexTree(sr, parent);
                final BinaryMapIndexReader.MapIndex nmi = new BinaryMapIndexReader.MapIndex();
                c.loadRouteIndexData(searchRouteIndexTree, new ResultMatcher<RouteDataObject>(){

                    @Override
                    public boolean publish(RouteDataObject r) {
                        int k;
                        if (basemap) {
                            MapRenderRepositories.this.renderedState = MapRenderRepositories.this.renderedState | 1;
                        } else {
                            MapRenderRepositories.this.renderedState = MapRenderRepositories.this.renderedState | 2;
                        }
                        if (checkForDuplicateObjectIds && !basemap) {
                            if (ids.contains(r.getId()) && r.getId() > 0L) {
                                return false;
                            }
                            ids.add(r.getId());
                        }
                        int[] coordinantes = new int[r.getPointsLength() * 2];
                        int[] roTypes = r.getTypes();
                        for (k = 0; k < roTypes.length; ++k) {
                            int type = roTypes[k];
                            this.registerMissingType(nmi, r, type);
                        }
                        for (k = 0; k < coordinantes.length / 2; ++k) {
                            coordinantes[2 * k] = r.getPoint31XTile(k);
                            coordinantes[2 * k + 1] = r.getPoint31YTile(k);
                        }
                        BinaryMapDataObject mo = new BinaryMapDataObject(coordinantes, roTypes, new int[0][], r.getId());
                        TIntObjectHashMap<String> names = r.getNames();
                        if (names != null) {
                            TIntObjectIterator it = names.iterator();
                            while (it.hasNext()) {
                                it.advance();
                                this.registerMissingType(nmi, r, it.key());
                                mo.putObjectName(it.key(), (String)it.value());
                            }
                        }
                        mo.setMapIndex(nmi);
                        tempResult.add(mo);
                        return false;
                    }

                    private void registerMissingType(BinaryMapIndexReader.MapIndex nmi2, RouteDataObject r, int type) {
                        if (!nmi2.isRegisteredRule(type)) {
                            BinaryMapRouteReaderAdapter.RouteTypeRule rr = r.region.quickGetEncodingRule(type);
                            String tag = rr.getTag();
                            int additional = "highway".equals(tag) || "route".equals(tag) || "railway".equals(tag) || "aeroway".equals(tag) || "aerialway".equals(tag) ? 0 : 1;
                            nmi2.initMapEncodingRule(additional, type, rr.getTag(), rr.getValue());
                        }
                    }

                    @Override
                    public boolean isCancelled() {
                        return !MapRenderRepositories.this.interrupted;
                    }
                });
            }
        }
        catch (IOException e) {
            log.error((Object)("Search failed " + c.getRegionNames()), (Throwable)e);
        }
    }

    private boolean loadVectorData(QuadRect dataBox, int zoom, RenderingRuleSearchRequest renderingReq) {
        boolean coastlinesWereAdded;
        long ms;
        boolean detailedLandData;
        boolean objectsFromMapSectionRead;
        double cBottomLatitude = dataBox.bottom;
        double cTopLatitude = dataBox.top;
        double cLeftLongitude = dataBox.left;
        double cRightLongitude = dataBox.right;
        long now = System.currentTimeMillis();
        System.gc();
        ArrayList<BinaryMapDataObject> tempResult = new ArrayList<BinaryMapDataObject>();
        ArrayList<BinaryMapDataObject> basemapResult = new ArrayList<BinaryMapDataObject>();
        int[] count = new int[]{0};
        boolean[] ocean = new boolean[]{false};
        boolean[] land = new boolean[]{false};
        ArrayList<BinaryMapDataObject> coastLines = new ArrayList<BinaryMapDataObject>();
        ArrayList<BinaryMapDataObject> basemapCoastLines = new ArrayList<BinaryMapDataObject>();
        int leftX = MapUtils.get31TileNumberX(cLeftLongitude);
        int rightX = MapUtils.get31TileNumberX(cRightLongitude);
        int bottomY = MapUtils.get31TileNumberY(cBottomLatitude);
        int topY = MapUtils.get31TileNumberY(cTopLatitude);
        TLongHashSet ids = new TLongHashSet();
        BinaryMapIndexReader.MapIndex mi = this.readMapObjectsForRendering(zoom, renderingReq, tempResult, basemapResult, (TLongSet)ids, count, ocean, land, coastLines, basemapCoastLines, leftX, rightX, bottomY, topY);
        int renderRouteDataFile = 0;
        if (renderingReq.searchRenderingAttribute("showRoadMapsAttribute")) {
            renderRouteDataFile = renderingReq.getIntPropertyValue(renderingReq.ALL.R_ATTR_INT_VALUE);
        }
        if (this.checkWhetherInterrupted()) {
            return false;
        }
        boolean bl = objectsFromMapSectionRead = tempResult.size() > 0;
        if (renderRouteDataFile >= 0 && zoom >= 11) {
            this.searchRequest = BinaryMapIndexReader.buildSearchRequest(leftX, rightX, topY, bottomY, zoom, null);
            for (BinaryMapIndexReader c : this.files.values()) {
                if (c.getMapIndexes().size() != 0 && renderRouteDataFile != 1) continue;
                this.readRouteDataAsMapObjects(this.searchRequest, c, tempResult, (TLongSet)ids);
            }
            log.debug((Object)String.format("Route objects %s", tempResult.size() + ""));
        }
        String coastlineTime = "";
        boolean addBasemapCoastlines = true;
        boolean emptyData = zoom > 11 && tempResult.isEmpty() && coastLines.isEmpty();
        boolean basemapMissing = zoom <= 11 && basemapCoastLines.isEmpty() && mi == null;
        boolean bl2 = detailedLandData = zoom >= zoomForBaseRouteRendering && tempResult.size() > 0 && objectsFromMapSectionRead;
        if (!coastLines.isEmpty()) {
            ms = System.currentTimeMillis();
            coastlinesWereAdded = this.processCoastlines(coastLines, leftX, rightX, bottomY, topY, zoom, basemapCoastLines.isEmpty(), true, tempResult);
            addBasemapCoastlines = !coastlinesWereAdded && !detailedLandData || zoom <= 11;
            coastlineTime = "(coastline " + (System.currentTimeMillis() - ms) + " ms )";
        } else {
            boolean bl3 = addBasemapCoastlines = !detailedLandData;
        }
        if (addBasemapCoastlines) {
            ms = System.currentTimeMillis();
            coastlinesWereAdded = this.processCoastlines(basemapCoastLines, leftX, rightX, bottomY, topY, zoom, true, true, tempResult);
            addBasemapCoastlines = !coastlinesWereAdded;
            coastlineTime = "(coastline " + (System.currentTimeMillis() - ms) + " ms )";
        }
        if (addBasemapCoastlines && mi != null) {
            BinaryMapDataObject o = new BinaryMapDataObject(new int[]{leftX, topY, rightX, topY, rightX, bottomY, leftX, bottomY, leftX, topY}, new int[]{ocean[0] && !land[0] ? mi.coastlineEncodingType : mi.landEncodingType}, null, -1L);
            o.setMapIndex(mi);
            tempResult.add(o);
        }
        if (emptyData || basemapMissing) {
            if (!tempResult.isEmpty()) {
                BinaryMapIndexReader.MapIndex mapIndex = tempResult.get(0).getMapIndex();
            } else {
                BinaryMapIndexReader.MapIndex mapIndex = new BinaryMapIndexReader.MapIndex();
                mapIndex.initMapEncodingRule(0, 1, "natural", "coastline");
                mapIndex.initMapEncodingRule(0, 2, "name", "");
            }
        }
        if (zoom <= 11 || emptyData) {
            tempResult.addAll(basemapResult);
        }
        if (count[0] > 0) {
            log.debug((Object)String.format("BLat=%s, TLat=%s, LLong=%s, RLong=%s, zoom=%s", cBottomLatitude, cTopLatitude, cLeftLongitude, cRightLongitude, zoom));
            log.debug((Object)String.format("Searching: %s ms  %s (%s results found)", System.currentTimeMillis() - now, coastlineTime, count[0]));
        }
        this.cObjects = tempResult;
        this.cObjectsBox = dataBox;
        this.cObjectsZoom = zoom;
        return true;
    }

    private BinaryMapIndexReader.MapIndex readMapObjectsForRendering(final int zoom, final RenderingRuleSearchRequest renderingReq, ArrayList<BinaryMapDataObject> tempResult, ArrayList<BinaryMapDataObject> basemapResult, TLongSet ids, int[] count, boolean[] ocean, boolean[] land, List<BinaryMapDataObject> coastLines, List<BinaryMapDataObject> basemapCoastLines, int leftX, int rightX, int bottomY, int topY) {
        BinaryMapIndexReader.SearchFilter searchFilter = new BinaryMapIndexReader.SearchFilter(){

            @Override
            public boolean accept(TIntArrayList types, BinaryMapIndexReader.MapIndex root) {
                for (int j = 0; j < types.size(); ++j) {
                    int type = types.get(j);
                    BinaryMapIndexReader.TagValuePair pair = root.decodeType(type);
                    if (pair == null) continue;
                    for (int i = 1; i <= 3; ++i) {
                        renderingReq.setIntFilter(renderingReq.ALL.R_MINZOOM, zoom);
                        renderingReq.setStringFilter(renderingReq.ALL.R_TAG, pair.tag);
                        renderingReq.setStringFilter(renderingReq.ALL.R_VALUE, pair.value);
                        if (!renderingReq.search(i, false)) continue;
                        return true;
                    }
                    renderingReq.setStringFilter(renderingReq.ALL.R_TAG, pair.tag);
                    renderingReq.setStringFilter(renderingReq.ALL.R_VALUE, pair.value);
                    if (!renderingReq.search(4, false)) continue;
                    return true;
                }
                return false;
            }
        };
        if (zoom > 16) {
            searchFilter = null;
        }
        BinaryMapIndexReader.MapIndex mi = null;
        this.searchRequest = BinaryMapIndexReader.buildSearchRequest(leftX, rightX, topY, bottomY, zoom, searchFilter);
        for (BinaryMapIndexReader c : this.files.values()) {
            List<BinaryMapDataObject> res;
            boolean basemap = c.isBasemap();
            this.searchRequest.clearSearchResults();
            try {
                res = c.searchMapIndex(this.searchRequest);
            }
            catch (IOException e) {
                res = new ArrayList<BinaryMapDataObject>();
                log.error((Object)("Search failed " + c.getRegionNames()), (Throwable)e);
            }
            if (res.size() > 0) {
                this.renderedState = basemap ? (this.renderedState |= 1) : (this.renderedState |= 2);
            }
            for (BinaryMapDataObject r : res) {
                if (checkForDuplicateObjectIds && !basemap) {
                    if (ids.contains(r.getId()) && r.getId() > 0L) continue;
                    ids.add(r.getId());
                }
                count[0] = count[0] + 1;
                if (r.containsType(r.getMapIndex().coastlineEncodingType)) {
                    if (basemap) {
                        basemapCoastLines.add(r);
                    } else {
                        coastLines.add(r);
                    }
                } else if (basemap) {
                    basemapResult.add(r);
                } else {
                    tempResult.add(r);
                }
                if (!this.checkWhetherInterrupted()) continue;
                return null;
            }
            if (this.searchRequest.isOcean()) {
                mi = c.getMapIndexes().get(0);
                ocean[0] = true;
            }
            if (!this.searchRequest.isLand()) continue;
            mi = c.getMapIndexes().get(0);
            land[0] = true;
        }
        return mi;
    }

    private void validateLatLonBox(QuadRect box) {
        if (box.top > 90.0) {
            box.top = 85.5;
        }
        if (box.bottom < -90.0) {
            box.bottom = -85.5;
        }
        if (box.left <= -180.0) {
            box.left = -179.5;
        }
        if (box.right > 180.0) {
            box.right = 180.0;
        }
    }

    public RotatedTileBox getCheckedBox() {
        return this.checkedBox;
    }

    public int getCheckedRenderedState() {
        return this.checkedRenderedState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized OsmandRenderer.RenderingResult loadMGap(Graphics2D pGraphics2d, RotatedTileBox tileRect, RenderingRulesStorage storage, OsmBitmapPanel.IntermediateImageListener pListener) {
        boolean prevInterrupted = this.interrupted;
        this.interrupted = false;
        OsmandRenderer.RenderingResult result = null;
        this.requestedBox = new RotatedTileBox(tileRect);
        log.debug((Object)("RENDER MAP: new request " + tileRect));
        if (this.currentRenderingContext != null) {
            this.currentRenderingContext = null;
        }
        try {
            boolean nightMode = false;
            RenderingRuleSearchRequest renderingReq = new RenderingRuleSearchRequest(storage);
            renderingReq.setBooleanFilter(renderingReq.ALL.R_NIGHT_MODE, nightMode);
            for (RenderingRuleProperty customProp : storage.PROPS.getCustomRules()) {
                if (customProp.isBoolean()) {
                    if (customProp.getAttrName().equals("engine_v1")) {
                        renderingReq.setBooleanFilter(customProp, true);
                        continue;
                    }
                    if ("ui_hidden".equals(customProp.getCategory())) {
                        renderingReq.setBooleanFilter(customProp, false);
                        continue;
                    }
                    OsmandSettings.CommonPreference<Boolean> pref = this.prefs.getCustomRenderBooleanProperty(customProp.getAttrName());
                    renderingReq.setBooleanFilter(customProp, pref.get());
                    log.debug((Object)("Property : " + customProp.getAttrName() + " is  " + pref.get()));
                    continue;
                }
                if ("ui_hidden".equals(customProp.getCategory())) {
                    if (customProp.isString()) {
                        renderingReq.setStringFilter(customProp, "");
                        continue;
                    }
                    renderingReq.setIntFilter(customProp, 0);
                    continue;
                }
                OsmandSettings.CommonPreference<String> settings = this.prefs.getCustomRenderProperty(customProp.getAttrName());
                String res = settings.get();
                if (!Algorithms.isEmpty(res)) {
                    if (customProp.isString()) {
                        renderingReq.setStringFilter(customProp, res);
                        continue;
                    }
                    try {
                        renderingReq.setIntFilter(customProp, Integer.parseInt(res));
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!customProp.isString()) continue;
                renderingReq.setStringFilter(customProp, "");
            }
            renderingReq.saveState();
            QuadRect dataBox = this.requestedBox.getLatLonBounds();
            int dataBoxZoom = this.requestedBox.getZoom();
            long now = System.currentTimeMillis();
            if (this.cObjectsBox.left > dataBox.left || this.cObjectsBox.top < dataBox.top || this.cObjectsBox.right < dataBox.right || this.cObjectsBox.bottom > dataBox.bottom || dataBoxZoom != this.cObjectsZoom || prevInterrupted) {
                if (dataBox.right - dataBox.left > dataBox.top - dataBox.bottom) {
                    double wi = (dataBox.right - dataBox.left) * 0.05;
                    dataBox.left -= wi;
                    dataBox.right += wi;
                } else {
                    double hi = (dataBox.top - dataBox.bottom) * 0.05;
                    dataBox.top += hi;
                    dataBox.bottom -= hi;
                }
                this.validateLatLonBox(dataBox);
                this.renderedState = 0;
                boolean loaded = this.loadVectorData(dataBox, this.requestedBox.getZoom(), renderingReq);
                if (!loaded || this.checkWhetherInterrupted()) {
                    OsmandRenderer.RenderingResult renderingResult = null;
                    return renderingResult;
                }
            }
            long searchTime = System.currentTimeMillis() - now;
            this.currentRenderingContext = new OsmandRenderer.RenderingContext();
            renderingReq.clearState();
            renderingReq.setIntFilter(renderingReq.ALL.R_MINZOOM, this.requestedBox.getZoom());
            if (renderingReq.searchRenderingAttribute("defaultColor")) {
                this.currentRenderingContext.defaultColor = renderingReq.getIntPropertyValue(renderingReq.ALL.R_ATTR_COLOR_VALUE);
            }
            renderingReq.clearState();
            renderingReq.setIntFilter(renderingReq.ALL.R_MINZOOM, this.requestedBox.getZoom());
            if (renderingReq.searchRenderingAttribute("shadowRendering")) {
                this.currentRenderingContext.shadowRenderingMode = renderingReq.getIntPropertyValue(renderingReq.ALL.R_ATTR_INT_VALUE);
                this.currentRenderingContext.shadowRenderingColor = renderingReq.getIntPropertyValue(renderingReq.ALL.R_SHADOW_COLOR);
            }
            if (renderingReq.searchRenderingAttribute("polygonMinSizeToDisplay")) {
                this.currentRenderingContext.polygonMinSizeToDisplay = renderingReq.getIntPropertyValue(renderingReq.ALL.R_ATTR_INT_VALUE);
            }
            QuadPointDouble lt = this.requestedBox.getLeftTopTile(this.requestedBox.getZoom());
            double cfd = MapUtils.getPowZoom(this.requestedBox.getZoomFloatPart()) * this.requestedBox.getMapDensity();
            lt.x *= cfd;
            lt.y *= cfd;
            double tileDivisor = MapUtils.getPowZoom(31 - this.requestedBox.getZoom()) / cfd;
            this.currentRenderingContext.leftX = lt.x;
            this.currentRenderingContext.topY = lt.y;
            this.currentRenderingContext.zoom = this.requestedBox.getZoom();
            this.currentRenderingContext.rotate = this.requestedBox.getRotate();
            this.currentRenderingContext.width = this.requestedBox.getPixWidth();
            this.currentRenderingContext.height = this.requestedBox.getPixHeight();
            this.currentRenderingContext.nightMode = nightMode;
            this.currentRenderingContext.preferredLocale = this.requestedBox.getZoom() <= 11 && "".equals(this.prefs.MAP_PREFERRED_LOCALE.get()) ? OsmWindow.getInstance().getLanguage() : this.prefs.MAP_PREFERRED_LOCALE.get();
            float mapDensity = (float)this.requestedBox.getMapDensity();
            this.currentRenderingContext.setDensityValue(mapDensity);
            this.currentRenderingContext.textScale = this.requestedBox.getDensity() * this.prefs.TEXT_SCALE.get().floatValue() / mapDensity;
            this.currentRenderingContext.screenDensityRatio = 1.0f / Math.max(1.0f, this.requestedBox.getDensity());
            this.currentRenderingContext.tileDivisor = tileDivisor;
            if (this.checkWhetherInterrupted()) {
                OsmandRenderer.RenderingResult renderingResult = null;
                return renderingResult;
            }
            now = System.currentTimeMillis();
            boolean transparent = false;
            RenderingRuleProperty rr = storage.PROPS.get("noPolygons");
            if (rr != null) {
                transparent = renderingReq.getIntPropertyValue(rr) > 0;
            }
            this.prevBmpLocation = this.bmpLocation;
            this.bmpLocation = tileRect;
            this.renderer.generateNewBitmap(this.currentRenderingContext, this.cObjects, pGraphics2d, renderingReq, pListener);
            if (renderingReq != null) {
                log.debug((Object)("Debug :" + renderingReq != null ? 1 : 0));
            }
            String renderingDebugInfo = this.currentRenderingContext.renderingDebugInfo;
            result = this.currentRenderingContext.result;
            this.currentRenderingContext.ended = true;
            if (this.checkWhetherInterrupted()) {
                if (this.currentRenderingContext.lastRenderedKey < 35) {
                    this.bmpLocation = this.prevBmpLocation;
                    this.prevBmpLocation = null;
                }
                this.currentRenderingContext = null;
                OsmandRenderer.RenderingResult renderingResult = null;
                return renderingResult;
            }
            this.checkedRenderedState = this.renderedState;
            this.checkedBox = this.bmpLocation;
            this.currentRenderingContext = null;
            this.prevBmpLocation = null;
        }
        catch (RuntimeException e) {
            log.error((Object)"Runtime memory exception", (Throwable)e);
        }
        catch (OutOfMemoryError e) {
            log.error((Object)"Out of memory error", (Throwable)e);
            this.cObjects = new ArrayList<BinaryMapDataObject>();
            this.cObjectsBox = new QuadRect();
        }
        finally {
            if (this.currentRenderingContext != null) {
                this.currentRenderingContext.ended = true;
            }
        }
        return result;
    }

    public synchronized void clearCache() {
        this.cObjects = new ArrayList<BinaryMapDataObject>();
        this.cObjectsBox = new QuadRect();
        this.prevBmpLocation = null;
        this.requestedBox = null;
    }

    public Map<String, BinaryMapIndexReader> getMetaInfoFiles() {
        return this.files;
    }

    private boolean processCoastlines(List<BinaryMapDataObject> coastLines, int leftX, int rightX, int bottomY, int topY, int zoom, boolean doNotAddIfIncompleted, boolean addDebugIncompleted, List<BinaryMapDataObject> result) {
        ArrayList<TLongList> completedRings = new ArrayList<TLongList>();
        ArrayList<TLongList> uncompletedRings = new ArrayList<TLongList>();
        BinaryMapIndexReader.MapIndex mapIndex = null;
        long dbId = 0L;
        for (BinaryMapDataObject o : coastLines) {
            boolean pinside;
            int len = o.getPointsLength();
            if (len < 2) continue;
            mapIndex = o.getMapIndex();
            dbId = o.getId() >> 1;
            TLongArrayList coordinates = new TLongArrayList(o.getPointsLength() / 2);
            int px = o.getPoint31XTile(0);
            int py = o.getPoint31YTile(0);
            int x = px;
            int y = py;
            boolean bl = pinside = leftX <= x && x <= rightX && y >= topY && y <= bottomY;
            if (pinside) {
                coordinates.add(MapRenderRepositories.combine2Points(x, y));
            }
            for (int i = 1; i < len; ++i) {
                x = o.getPoint31XTile(i);
                boolean inside = leftX <= x && x <= rightX && y >= topY && y <= bottomY;
                boolean lineEnded = this.calculateLineCoordinates(inside, x, y = o.getPoint31YTile(i), pinside, px, py, leftX, rightX, bottomY, topY, (TLongList)coordinates);
                if (lineEnded) {
                    this.combineMultipolygonLine(completedRings, uncompletedRings, (TLongList)coordinates);
                    coordinates = new TLongArrayList();
                }
                px = x;
                py = y;
                pinside = inside;
            }
            this.combineMultipolygonLine(completedRings, uncompletedRings, (TLongList)coordinates);
        }
        if (completedRings.size() == 0 && uncompletedRings.size() == 0) {
            return false;
        }
        if (uncompletedRings.size() > 0) {
            this.unifyIncompletedRings(uncompletedRings, completedRings, leftX, rightX, bottomY, topY, dbId, zoom);
        }
        long mask = 0xFFFFFFFFL;
        for (int i = 0; i < uncompletedRings.size(); ++i) {
            TLongList ring = (TLongList)uncompletedRings.get(i);
            int[] coordinates = new int[ring.size() * 2];
            for (int j = 0; j < ring.size(); ++j) {
                coordinates[j * 2] = (int)(ring.get(j) >> 32);
                coordinates[j * 2 + 1] = (int)(ring.get(j) & mask);
            }
            BinaryMapDataObject o = new BinaryMapDataObject(coordinates, new int[]{mapIndex.coastlineBrokenEncodingType}, null, dbId);
            o.setMapIndex(mapIndex);
            result.add(o);
        }
        if (!doNotAddIfIncompleted && uncompletedRings.size() > 0) {
            return false;
        }
        boolean clockwiseFound = false;
        for (int i = 0; i < completedRings.size(); ++i) {
            TLongList ring = (TLongList)completedRings.get(i);
            int[] coordinates = new int[ring.size() * 2];
            for (int j = 0; j < ring.size(); ++j) {
                coordinates[j * 2] = (int)(ring.get(j) >> 32);
                coordinates[j * 2 + 1] = (int)(ring.get(j) & mask);
            }
            boolean clockwise = MapAlgorithms.isClockwiseWay(ring);
            clockwiseFound = clockwiseFound || clockwise;
            BinaryMapDataObject o = new BinaryMapDataObject(coordinates, new int[]{clockwise ? mapIndex.coastlineEncodingType : mapIndex.landEncodingType}, null, dbId);
            o.setMapIndex(mapIndex);
            o.setArea(true);
            result.add(o);
        }
        if (!clockwiseFound && uncompletedRings.size() == 0) {
            BinaryMapDataObject o = new BinaryMapDataObject(new int[]{leftX, topY, rightX, topY, rightX, bottomY, leftX, bottomY, leftX, topY}, new int[]{mapIndex.coastlineEncodingType}, null, dbId);
            o.setMapIndex(mapIndex);
            log.info((Object)"!!! Isolated islands !!!");
            result.add(o);
        }
        return true;
    }

    private boolean eq(long i1, long i2) {
        return i1 == i2;
    }

    private void combineMultipolygonLine(List<TLongList> completedRings, List<TLongList> incompletedRings, TLongList coordinates) {
        if (coordinates.size() > 0) {
            if (this.eq(coordinates.get(0), coordinates.get(coordinates.size() - 1))) {
                completedRings.add(coordinates);
            } else {
                boolean add = true;
                int k = 0;
                while (k < incompletedRings.size()) {
                    boolean remove = false;
                    TLongList i = incompletedRings.get(k);
                    if (this.eq(coordinates.get(0), i.get(i.size() - 1))) {
                        i.addAll((TLongCollection)coordinates.subList(1, coordinates.size()));
                        remove = true;
                        coordinates = i;
                    } else if (this.eq(coordinates.get(coordinates.size() - 1), i.get(0))) {
                        coordinates.addAll((TLongCollection)i.subList(1, i.size()));
                        remove = true;
                    }
                    if (remove) {
                        incompletedRings.remove(k);
                    } else {
                        ++k;
                    }
                    if (!this.eq(coordinates.get(0), coordinates.get(coordinates.size() - 1))) continue;
                    completedRings.add(coordinates);
                    add = false;
                    break;
                }
                if (add) {
                    incompletedRings.add(coordinates);
                }
            }
        }
    }

    private void unifyIncompletedRings(List<TLongList> toProcces, List<TLongList> completedRings, int leftX, int rightX, int bottomY, int topY, long dbId, int zoom) {
        int st;
        int y;
        int x;
        TLongList i;
        int j;
        int mask = -1;
        ArrayList<TLongList> uncompletedRings = new ArrayList<TLongList>(toProcces);
        toProcces.clear();
        LinkedHashSet<Integer> nonvisitedRings = new LinkedHashSet<Integer>();
        for (j = 0; j < uncompletedRings.size(); ++j) {
            boolean end;
            i = (TLongList)uncompletedRings.get(j);
            x = (int)(i.get(i.size() - 1) >> 32);
            y = (int)(i.get(i.size() - 1) & (long)mask);
            int sx = (int)(i.get(0) >> 32);
            int sy = (int)(i.get(0) & (long)mask);
            st = y == topY || x == rightX || y == bottomY || x == leftX ? 1 : 0;
            boolean bl = end = sy == topY || sx == rightX || sy == bottomY || sx == leftX;
            if (!end || st == 0) {
                String str;
                float dx = (float)MapUtils.get31LongitudeX(x);
                float dsx = (float)MapUtils.get31LongitudeX(sx);
                float dy = (float)MapUtils.get31LatitudeY(y);
                float dsy = (float)MapUtils.get31LatitudeY(sy);
                if (!end) {
                    str = " Starting point (to close) not found : end_x = {0}, end_y = {1}, start_x = {2}, start_y = {3} : bounds {4} {5} - {6} {7}";
                    System.err.println(MessageFormat.format(dbId + str, Float.valueOf(dx), Float.valueOf(dy), Float.valueOf(dsx), Float.valueOf(dsy), leftX + "", topY + "", rightX + "", bottomY + ""));
                }
                if (st == 0) {
                    str = " End not found : end_x = {0}, end_y = {1}, start_x = {2}, start_y = {3} : bounds {4} {5} - {6} {7}";
                    System.err.println(MessageFormat.format(dbId + str, Float.valueOf(dx), Float.valueOf(dy), Float.valueOf(dsx), Float.valueOf(dsy), leftX + "", topY + "", rightX + "", bottomY + ""));
                }
                toProcces.add(i);
                continue;
            }
            nonvisitedRings.add(j);
        }
        for (j = 0; j < uncompletedRings.size(); ++j) {
            i = (TLongList)uncompletedRings.get(j);
            if (!nonvisitedRings.contains(j)) continue;
            x = (int)(i.get(i.size() - 1) >> 32);
            y = (int)(i.get(i.size() - 1) & (long)mask);
            int EVAL_DELTA = 6 << 23 - zoom;
            int UNDEFINED_MIN_DIFF = -1 - EVAL_DELTA;
            while (true) {
                st = 0;
                if (y == topY) {
                    st = 0;
                } else if (x == rightX) {
                    st = 1;
                } else if (y == bottomY) {
                    st = 2;
                } else if (x == leftX) {
                    st = 3;
                }
                int nextRingIndex = -1;
                for (int h = st; h < st + 4; ++h) {
                    int mindiff = UNDEFINED_MIN_DIFF;
                    for (Integer ni : nonvisitedRings) {
                        TLongList cni = (TLongList)uncompletedRings.get(ni);
                        int csx = (int)(cni.get(0) >> 32);
                        int csy = (int)(cni.get(0) & (long)mask);
                        if (h % 4 == 0) {
                            if (csy != topY || csx < this.safelyAddDelta(x, -EVAL_DELTA) || mindiff != UNDEFINED_MIN_DIFF && csx - x > mindiff) continue;
                            mindiff = csx - x;
                            nextRingIndex = ni;
                            continue;
                        }
                        if (h % 4 == 1) {
                            if (csx != rightX || csy < this.safelyAddDelta(y, -EVAL_DELTA) || mindiff != UNDEFINED_MIN_DIFF && csy - y > mindiff) continue;
                            mindiff = csy - y;
                            nextRingIndex = ni;
                            continue;
                        }
                        if (h % 4 == 2) {
                            if (csy != bottomY || csx > this.safelyAddDelta(x, EVAL_DELTA) || mindiff != UNDEFINED_MIN_DIFF && x - csx > mindiff) continue;
                            mindiff = x - csx;
                            nextRingIndex = ni;
                            continue;
                        }
                        if (h % 4 != 3 || csx != leftX || csy > this.safelyAddDelta(y, EVAL_DELTA) || mindiff != UNDEFINED_MIN_DIFF && y - csy > mindiff) continue;
                        mindiff = y - csy;
                        nextRingIndex = ni;
                    }
                    if (mindiff != UNDEFINED_MIN_DIFF) break;
                    if (h % 4 == 0) {
                        y = topY;
                        x = rightX;
                    } else if (h % 4 == 1) {
                        y = bottomY;
                        x = rightX;
                    } else if (h % 4 == 2) {
                        y = bottomY;
                        x = leftX;
                    } else if (h % 4 == 3) {
                        y = topY;
                        x = leftX;
                    }
                    i.add((long)x << 32 | (long)y);
                }
                if (nextRingIndex == -1) continue;
                if (nextRingIndex == j) break;
                i.addAll((TLongCollection)uncompletedRings.get(nextRingIndex));
                nonvisitedRings.remove(nextRingIndex);
                x = (int)(i.get(i.size() - 1) >> 32);
                y = (int)(i.get(i.size() - 1) & (long)mask);
            }
            i.add(i.get(0));
            nonvisitedRings.remove(j);
            completedRings.add(i);
        }
    }

    private int safelyAddDelta(int number, int delta) {
        int res = number + delta;
        if (delta > 0 && res < number) {
            return Integer.MAX_VALUE;
        }
        if (delta < 0 && res > number) {
            return Integer.MIN_VALUE;
        }
        return res;
    }

    private static long combine2Points(int x, int y) {
        return (long)x << 32 | (long)y;
    }

    private boolean calculateLineCoordinates(boolean inside, int x, int y, boolean pinside, int px, int py, int leftX, int rightX, int bottomY, int topY, TLongList coordinates) {
        boolean lineEnded = false;
        if (pinside) {
            if (!inside) {
                long is = MapAlgorithms.calculateIntersection(x, y, px, py, leftX, rightX, bottomY, topY);
                if (is == -1L) {
                    is = MapRenderRepositories.combine2Points(px, py);
                }
                coordinates.add(is);
                lineEnded = true;
            } else {
                coordinates.add(MapRenderRepositories.combine2Points(x, y));
            }
        } else {
            long is = MapAlgorithms.calculateIntersection(x, y, px, py, leftX, rightX, bottomY, topY);
            if (inside) {
                coordinates.add(is);
                coordinates.add(MapRenderRepositories.combine2Points(x, y));
            } else if (is != -1L) {
                int bx = (int)(is >> 32);
                int by = (int)(is & 0xFFFFFFFFFFFFFFFFL);
                coordinates.add(is);
                is = MapAlgorithms.calculateIntersection(x, y, bx, by, leftX, rightX, bottomY, topY);
                coordinates.add(is);
                lineEnded = true;
            }
        }
        return lineEnded;
    }
}

