/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.descriptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.ivy.core.module.descriptor.ConfigurationAware;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.util.extendable.UnmodifiableExtendableItem;

public abstract class AbstractIncludeExcludeRule
extends UnmodifiableExtendableItem
implements ConfigurationAware {
    private ArtifactId id;
    private Collection confs = new ArrayList();
    private PatternMatcher patternMatcher;

    public AbstractIncludeExcludeRule(ArtifactId artifactId, PatternMatcher patternMatcher, Map map) {
        super(null, map);
        this.id = artifactId;
        this.patternMatcher = patternMatcher;
        this.initStandardAttributes();
    }

    private void initStandardAttributes() {
        this.setStandardAttribute("organisation", this.id.getModuleId().getOrganisation());
        this.setStandardAttribute("module", this.id.getModuleId().getName());
        this.setStandardAttribute("artifact", this.id.getName());
        this.setStandardAttribute("type", this.id.getType());
        this.setStandardAttribute("ext", this.id.getExt());
        this.setStandardAttribute("matcher", this.patternMatcher.getName());
    }

    public boolean equals(Object object) {
        if (!(object instanceof AbstractIncludeExcludeRule)) {
            return false;
        }
        AbstractIncludeExcludeRule abstractIncludeExcludeRule = (AbstractIncludeExcludeRule)object;
        return this.getId().equals(abstractIncludeExcludeRule.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    @Override
    public void addConfiguration(String string) {
        this.confs.add(string);
    }

    public ArtifactId getId() {
        return this.id;
    }

    @Override
    public String[] getConfigurations() {
        return this.confs.toArray(new String[this.confs.size()]);
    }

    public PatternMatcher getMatcher() {
        return this.patternMatcher;
    }

    public String toString() {
        return this.id + "(" + this.confs + ")";
    }
}

