/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;

public class MimeTypeParameterList {
    private static final String TSPECIALS = "()<>@,;:/[]?=\\\"";
    private List parameterNames = new ArrayList();
    private Map parameterValues = new HashMap();

    public MimeTypeParameterList() {
    }

    public MimeTypeParameterList(String string) throws MimeTypeParseException {
        this.parse(string);
    }

    protected void parse(String string) throws MimeTypeParseException {
        if (string == null) {
            return;
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (c == ';' && !bl) {
                String string2 = stringBuffer.toString().trim();
                if (string2.length() > 0) {
                    arrayList.add(string2);
                }
                stringBuffer.setLength(0);
                continue;
            }
            if (c == '\"') {
                bl = !bl;
            }
            stringBuffer.append(c);
        }
        String string32 = stringBuffer.toString().trim();
        if (string32.length() > 0) {
            arrayList.add(string32);
        }
        for (String string32 : arrayList) {
            int n2 = string32.indexOf(61);
            if (n2 == -1) {
                throw new MimeTypeParseException("Couldn't find the '=' that separates a parameter name from its value.");
            }
            String string4 = string32.substring(0, n2).trim();
            MimeType.checkValidity(string4, "Parameter name is invalid");
            String string5 = string32.substring(n2 + 1).trim();
            n = string5.length();
            if (n > 1 && string5.charAt(0) == '\"' && string5.charAt(n - 1) == '\"') {
                string5 = MimeTypeParameterList.unquote(string5);
            } else {
                MimeType.checkValidity(string4, "Parameter value is invalid");
            }
            this.parameterNames.add(string4);
            this.parameterValues.put(string4.toLowerCase(), string5);
        }
    }

    public synchronized int size() {
        return this.parameterNames.size();
    }

    public synchronized boolean isEmpty() {
        return this.parameterNames.isEmpty();
    }

    public synchronized String get(String string) {
        string = string.trim();
        return (String)this.parameterValues.get(string.toLowerCase());
    }

    public synchronized void set(String string, String string2) {
        string = string.trim();
        boolean bl = false;
        for (String string3 : this.parameterNames) {
            if (!string.equalsIgnoreCase(string3)) continue;
            bl = true;
        }
        if (!bl) {
            this.parameterNames.add(string);
        }
        this.parameterValues.put(string.toLowerCase(), string2);
    }

    public synchronized void remove(String string) {
        string = string.trim();
        Iterator iterator = this.parameterNames.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string.equalsIgnoreCase(string2)) continue;
            iterator.remove();
        }
        this.parameterValues.remove(string.toLowerCase());
    }

    public synchronized Enumeration getNames() {
        return new IteratorEnumeration(this.parameterNames.iterator());
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.parameterNames) {
            String string2 = (String)this.parameterValues.get(string.toLowerCase());
            stringBuffer.append(';');
            stringBuffer.append(' ');
            stringBuffer.append(string);
            stringBuffer.append('=');
            stringBuffer.append(MimeTypeParameterList.quote(string2));
        }
        return stringBuffer.toString();
    }

    private static String quote(String string) {
        boolean bl = false;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (MimeType.isValidChar(string.charAt(i))) continue;
            bl = true;
            break;
        }
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('\"');
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == '\\' || c == '\"') {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c);
            }
            stringBuffer.append('\"');
            return stringBuffer.toString();
        }
        return string;
    }

    private static String unquote(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i < n - 1; ++i) {
            char c = string.charAt(i);
            if (c == '\\' && ++i < n - 1 && (c = string.charAt(i)) != '\\' && c != '\"') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    static class IteratorEnumeration
    implements Enumeration {
        final Iterator iterator;

        IteratorEnumeration(Iterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        public Object nextElement() {
            return this.iterator.next();
        }
    }
}

