/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.heapviewer.java;

import com.sun.tools.visualvm.heapviewer.model.DataType;
import com.sun.tools.visualvm.heapviewer.model.HeapViewerNode;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.JavaClass;

public class ClassNode
extends HeapViewerNode {
    private final JavaClass jclass;
    private String name;

    public ClassNode(JavaClass jclass) {
        this.jclass = jclass;
    }

    public JavaClass getJavaClass() {
        return this.jclass;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.jclass.getName();
        }
        return this.name;
    }

    public int getInstancesCount() {
        return this.jclass.getInstancesCount();
    }

    public long getOwnSize() {
        return this.jclass.getAllInstancesSize();
    }

    public long getRetainedSize(Heap heap) {
        return DataType.RETAINED_SIZE.valuesAvailable(heap) ? this.jclass.getRetainedSizeByClass() : DataType.RETAINED_SIZE.getNotAvailableValue().longValue();
    }

    @Override
    public boolean isLeaf() {
        return this.jclass.getInstancesCount() == 0 ? true : super.isLeaf();
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassNode)) {
            return false;
        }
        return this.jclass.equals(((ClassNode)((Object)o)).jclass);
    }

    public int hashCode() {
        return this.jclass.hashCode();
    }

    protected Object getValue(DataType type, Heap heap) {
        if (type == DataType.NAME) {
            return this.getName();
        }
        if (type == DataType.COUNT) {
            return this.getInstancesCount();
        }
        if (type == DataType.OWN_SIZE) {
            return this.getOwnSize();
        }
        if (type == DataType.RETAINED_SIZE) {
            return this.getRetainedSize(heap);
        }
        if (type == DataType.CLASS) {
            return this.getJavaClass();
        }
        if (type == DataType.OBJECT_ID) {
            return this.getJavaClass().getJavaClassId();
        }
        return super.getValue(type, heap);
    }

    @Override
    public ClassNode createCopy() {
        ClassNode copy = new ClassNode(this.getJavaClass());
        this.setupCopy(copy);
        return copy;
    }

    protected void setupCopy(ClassNode copy) {
        super.setupCopy(copy);
        copy.name = this.name;
    }
}

