/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.impl;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.table.TableCellRenderer;
import org.netbeans.core.multitabs.Controller;
import org.netbeans.core.multitabs.TabDisplayer;
import org.netbeans.core.multitabs.impl.TabDataRenderer;
import org.netbeans.core.multitabs.impl.TabTable;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;

class CloseButtonHandler
extends MouseAdapter {
    private final TabDisplayer displayer;
    private final Controller controller;

    public CloseButtonHandler(TabDisplayer tabDisplayer, Controller controller) {
        this.controller = controller;
        this.displayer = tabDisplayer;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof TabTable) {
            int n;
            TabData tabData;
            TabTable tabTable = (TabTable)mouseEvent.getSource();
            if (!tabTable.isShowing()) {
                return;
            }
            Point point = mouseEvent.getPoint();
            int n2 = tabTable.rowAtPoint(point);
            int n3 = tabTable.columnAtPoint(point);
            if (n2 >= 0 && n3 >= 0 && tabTable.isCloseButtonHighlighted(n2, n3) && null != (tabData = tabTable.getTabAt(point)) && (n = this.displayer.getModel().indexOf(tabData)) >= 0 && mouseEvent.getButton() == 1) {
                TabActionEvent tabActionEvent = null;
                tabActionEvent = (mouseEvent.getModifiersEx() & 0x40) > 0 ? new TabActionEvent((Object)this.displayer, "closeAll", n) : ((mouseEvent.getModifiersEx() & 0x200) > 0 ? new TabActionEvent((Object)this.displayer, "closeAllButThis", n) : new TabActionEvent((Object)this.displayer, "close", n));
                if (null != tabActionEvent) {
                    this.controller.postActionEvent(tabActionEvent);
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof TabTable) {
            TabDataRenderer tabDataRenderer;
            TableCellRenderer tableCellRenderer;
            int n = -1;
            int n2 = -1;
            TabTable tabTable = (TabTable)mouseEvent.getSource();
            Point point = mouseEvent.getPoint();
            int n3 = tabTable.rowAtPoint(point);
            int n4 = tabTable.columnAtPoint(point);
            if (n3 >= 0 && n4 >= 0 && (tableCellRenderer = tabTable.getCellRenderer(n3, n4)) instanceof TabDataRenderer && (tabDataRenderer = (TabDataRenderer)tableCellRenderer).isInCloseButton(tabTable.getCellRect(n3, n4, true), point)) {
                n = n3;
                n2 = n4;
            }
            tabTable.setCurrentCloseButtonCoords(n, n2);
        }
    }
}

