/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.sampler.cpu;

import com.sun.tools.visualvm.sampler.cpu.ThreadsCPUInfo;
import java.io.IOException;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class ThreadsCPU {
    private static final ObjectName THREAD_NAME = ThreadsCPU.getThreadName();
    private static final Logger LOGGER = Logger.getLogger(ThreadsCPU.class.getName());
    private final ThreadMXBean threadBean;
    private final MBeanServerConnection connection;
    private boolean useBulkOperation = true;

    public ThreadsCPU(ThreadMXBean bean, MBeanServerConnection conn) {
        this.threadBean = bean;
        this.connection = conn;
    }

    public ThreadsCPUInfo getThreadsCPUInfo() throws MBeanException, ReflectionException, IOException, InstanceNotFoundException {
        long[] tinfo;
        long[] ids = this.threadBean.getAllThreadIds();
        ThreadInfo[] tids = this.threadBean.getThreadInfo(ids);
        if (this.useBulkOperation) {
            Object[] args = new Object[]{ids};
            String[] sigs = new String[]{"[J"};
            try {
                tinfo = (long[])this.connection.invoke(THREAD_NAME, "getThreadCpuTime", args, sigs);
            }
            catch (ReflectionException ex) {
                LOGGER.log(Level.INFO, "getThreadCpuTime failed", ex);
                this.useBulkOperation = false;
                return this.getThreadsCPUInfo();
            }
        } else {
            tinfo = new long[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                tinfo[i] = this.threadBean.getThreadCpuTime(ids[i]);
            }
        }
        long time = System.currentTimeMillis();
        return new ThreadsCPUInfo(time, tids, tinfo);
    }

    private static ObjectName getThreadName() {
        try {
            return new ObjectName("java.lang:type=Threading");
        }
        catch (MalformedObjectNameException ex) {
            throw new RuntimeException(ex);
        }
    }
}

