/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.global.TransactionalSupport;
import org.netbeans.lib.profiler.server.ClassBytesLoader;
import org.netbeans.lib.profiler.server.ClassLoaderManager;
import org.netbeans.lib.profiler.server.EventBufferManager;
import org.netbeans.lib.profiler.server.HeapHistogramManager;
import org.netbeans.lib.profiler.server.Monitors;
import org.netbeans.lib.profiler.server.ProfilerCalibrator;
import org.netbeans.lib.profiler.server.ProfilerRuntime;
import org.netbeans.lib.profiler.server.ProfilerRuntimeCPU;
import org.netbeans.lib.profiler.server.ProfilerRuntimeCPUCodeRegion;
import org.netbeans.lib.profiler.server.ProfilerRuntimeCPUFullInstr;
import org.netbeans.lib.profiler.server.ProfilerRuntimeCPUSampledInstr;
import org.netbeans.lib.profiler.server.ProfilerRuntimeMemory;
import org.netbeans.lib.profiler.server.ProfilerRuntimeObjAlloc;
import org.netbeans.lib.profiler.server.ProfilerRuntimeObjLiveness;
import org.netbeans.lib.profiler.server.ProfilerRuntimeSampler;
import org.netbeans.lib.profiler.server.ProfilerServer;
import org.netbeans.lib.profiler.server.ProfilingPointServerHandler;
import org.netbeans.lib.profiler.server.ThreadInfo;
import org.netbeans.lib.profiler.server.system.Classes;
import org.netbeans.lib.profiler.server.system.GC;
import org.netbeans.lib.profiler.server.system.HeapDump;
import org.netbeans.lib.profiler.server.system.Histogram;
import org.netbeans.lib.profiler.server.system.Stacks;
import org.netbeans.lib.profiler.server.system.ThreadDump;
import org.netbeans.lib.profiler.server.system.Threads;
import org.netbeans.lib.profiler.server.system.Timers;
import org.netbeans.lib.profiler.wireprotocol.AsyncMessageCommand;
import org.netbeans.lib.profiler.wireprotocol.ClassLoadedCommand;
import org.netbeans.lib.profiler.wireprotocol.CodeRegionCPUResultsResponse;
import org.netbeans.lib.profiler.wireprotocol.Command;
import org.netbeans.lib.profiler.wireprotocol.GetClassIdCommand;
import org.netbeans.lib.profiler.wireprotocol.GetClassIdResponse;
import org.netbeans.lib.profiler.wireprotocol.InitiateProfilingCommand;
import org.netbeans.lib.profiler.wireprotocol.InstrumentMethodGroupCommand;
import org.netbeans.lib.profiler.wireprotocol.InstrumentMethodGroupData;
import org.netbeans.lib.profiler.wireprotocol.InstrumentMethodGroupResponse;
import org.netbeans.lib.profiler.wireprotocol.MethodInvokedFirstTimeCommand;
import org.netbeans.lib.profiler.wireprotocol.MethodLoadedCommand;
import org.netbeans.lib.profiler.wireprotocol.MethodNamesResponse;
import org.netbeans.lib.profiler.wireprotocol.ObjectAllocationResultsResponse;
import org.netbeans.lib.profiler.wireprotocol.Response;
import org.netbeans.lib.profiler.wireprotocol.RootClassLoadedCommand;
import org.netbeans.lib.profiler.wireprotocol.ThreadLivenessStatusResponse;

public class ProfilerInterface
implements CommonConstants {
    private static final int REDEFINE_CHUNK_SIZE = 500;
    static final char BOOLEAN = 'Z';
    static final char CHAR = 'C';
    static final char BYTE = 'B';
    static final char SHORT = 'S';
    static final char INT = 'I';
    static final char LONG = 'J';
    static final char FLOAT = 'F';
    static final char DOUBLE = 'D';
    static final char VOID = 'V';
    static final char REFERENCE = 'L';
    private static String INTERNAL_ERROR_MSG = "Internal error:\nExpected InstrumentMethodGroupResponse, got response of class {0},\nvalue = {1}\nAll instrumentation will be removed";
    private static String UNEXPECTED_EXCEPTION_MSG = "Unexpected exception caught when trying to instrument classes.\nOriginal exception:\n{0}\nStack trace:\n\n{1}";
    private static String INSTRUMENTATION_SUCCESSFUL_MSG = "Deferred instrumentation performed successfully";
    private static String HISTOGRAM_NOT_AVAILABLE_MSG = "Histogram is not available.";
    private static final boolean DEBUG;
    private static final boolean INSTRUMENT_JFLUID_CLASSES;
    private static final byte[] EMPTY;
    public static final TransactionalSupport serialClientOperationsLock;
    private static ProfilerServer profilerServer;
    private static ProfilingSessionStatus status;
    private static EventBufferManager evBufManager;
    private static WeakReference[] loadedClassesArray;
    private static int[] loadedClassesLoaders;
    private static WeakHashMap reflectMethods;
    private static boolean targetAppSuspended;
    private static boolean instrumentReflection;
    private static boolean instrSpawnedThreads;
    private static int[] packedArrayOffsets;
    private static int nSystemThreads;
    private static Thread initInstrumentationThread;
    private static String[] rootClassNames;
    private static boolean[] rootClassNameWildcard;
    private static boolean[] rootClassNamePackageWildcard;
    static int nClassLoads;
    static int nFirstMethodInvocations;
    static int nEmptyInstrMethodGroupResponses;
    static int nNonEmptyInstrMethodGroupResponses;
    static int nSingleMethodInstrMethodGroupResponses;
    static int nTotalInstrMethods;
    static long totalHotswappingTime;
    static long minHotswappingTime;
    static long maxHotswappingTime;
    static long clientInstrStartTime;
    static long clientInstrTime;
    static long clientDataProcStartTime;
    static long clientDataProcTime;
    private static boolean rootClassLoaded;
    private static volatile Thread instrumentMethodGroupCallThread;
    private static volatile boolean detachStarted;
    private static HeapHistogramManager heapHistgramManager;

    public static CodeRegionCPUResultsResponse getCodeRegionCPUResults() {
        CodeRegionCPUResultsResponse codeRegionCPUResultsResponse = new CodeRegionCPUResultsResponse(ProfilerRuntimeCPUCodeRegion.getProfilingResults());
        return codeRegionCPUResultsResponse;
    }

    public static void setCurrentInstrType(int n) {
        boolean bl = n == 5 || n == 6;
        ProfilerInterface.status.currentInstrType = n;
        Classes.setVMObjectAllocEnabled((boolean)bl);
    }

    public static int getCurrentInstrType() {
        return ProfilerInterface.status.currentInstrType;
    }

    public static ThreadLivenessStatusResponse getCurrentThreadLivenessStatus() {
        ThreadLivenessStatusResponse threadLivenessStatusResponse = new ThreadLivenessStatusResponse(ThreadInfo.getCurrentLivenessStatus());
        return threadLivenessStatusResponse;
    }

    public static void setInstrumentReflection(boolean bl) {
        if (ProfilerInterface.status.targetAppRunning) {
            ProfilerRuntimeCPU.setJavaLangReflectMethodInvokeInterceptEnabled(bl);
        } else {
            instrumentReflection = bl;
        }
    }

    public static MethodNamesResponse getMethodNamesForJMethodIds(int[] nArray) {
        int n = nArray.length;
        int n2 = n * 4;
        packedArrayOffsets = new int[n2];
        byte[] byArray = Stacks.getMethodNamesForJMethodIds(n, nArray, packedArrayOffsets);
        MethodNamesResponse methodNamesResponse = new MethodNamesResponse(byArray, packedArrayOffsets);
        return methodNamesResponse;
    }

    public static int getNPrerecordedSystemThreads() {
        return nSystemThreads;
    }

    public static ObjectAllocationResultsResponse getObjectAllocationResults() {
        status.beginTrans(false);
        try {
            ObjectAllocationResultsResponse objectAllocationResultsResponse;
            ObjectAllocationResultsResponse objectAllocationResultsResponse2 = objectAllocationResultsResponse = new ObjectAllocationResultsResponse(status.getAllocatedInstancesCount(), status.getNInstrClasses());
            return objectAllocationResultsResponse2;
        }
        finally {
            status.endTrans();
        }
    }

    public static void setProfilerServer(ProfilerServer profilerServer) {
        ProfilerInterface.profilerServer = profilerServer;
    }

    public static void clearProfilerDataStructures() {
        reflectMethods = null;
    }

    public static boolean cpuResultsExist() {
        return ProfilerRuntime.profiledTargetAppThreadsExist();
    }

    static void disableProfiling() {
        int n = ProfilerInterface.getCurrentInstrType();
        switch (n) {
            case 0: 
            case 7: {
                ProfilerRuntime.clearDataStructures();
                break;
            }
            case 2: {
                ProfilerRuntimeSampler.shutdown();
                break;
            }
            case 1: {
                ProfilerRuntimeCPUCodeRegion.enableProfiling(false);
                if (rootClassNames == null) break;
                rootClassNames = null;
                break;
            }
            case 3: {
                ProfilerRuntimeCPUFullInstr.enableProfiling(false);
                ProfilerRuntimeCPU.setTimerTypes(false, false);
                break;
            }
            case 4: {
                ProfilerRuntimeCPUSampledInstr.enableProfiling(false);
                ProfilerRuntimeCPU.setTimerTypes(false, false);
                break;
            }
            case 5: {
                ProfilerRuntimeObjAlloc.enableProfiling(false);
                break;
            }
            case 6: {
                ProfilerRuntimeObjLiveness.enableProfiling(false);
            }
        }
    }

    public static void deactivateInjectedCode() {
        ProfilerInterface.disableProfilerHooks();
        ProfilerInterface.disableProfiling();
        status.resetInstrClassAndMethodInfo();
        ProfilerInterface.setCurrentInstrType(0);
    }

    public static void disableProfilerHooks() {
        Classes.setWaitTrackingEnabled((boolean)false);
        Classes.setParkTrackingEnabled((boolean)false);
        Classes.setSleepTrackingEnabled((boolean)false);
        Classes.setVMObjectAllocEnabled((boolean)false);
        Classes.disableClassLoadHook();
        ProfilerRuntimeCPU.setJavaLangReflectMethodInvokeInterceptEnabled(false);
        ClassLoaderManager.setNotifyToolAboutUnloadedClasses(false);
    }

    public static void dumpExistingResults(boolean bl) {
        if (!bl && ProfilerInterface.getCurrentInstrType() == 6 && ProfilerRuntimeObjLiveness.getRunGCOnGetResults()) {
            GC.runGC();
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ProfilerRuntime.dumpEventBuffer();
    }

    public static void initProfilerInterface(ProfilingSessionStatus profilingSessionStatus, Thread thread) {
        boolean bl = Platform.getJDKVersionNumber() == 2;
        Timers.initialize();
        Classes.initialize();
        GC.initialize();
        Stacks.initialize();
        Threads.initialize();
        HeapDump.initialize((boolean)bl);
        ThreadDump.initialize((boolean)bl);
        ClassLoaderManager.initialize(profilerServer);
        ClassLoaderManager.addSystemClassLoader();
        reflectMethods = new WeakHashMap();
        evBufManager = new EventBufferManager(profilerServer);
        heapHistgramManager = new HeapHistogramManager();
        status = profilingSessionStatus;
        detachStarted = false;
        while (!Monitors.monitorThreadsStarted()) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {}
        }
        if (profilingSessionStatus.runningInAttachedMode) {
            Threads.recordProfilerOwnThreads(false, thread);
            nSystemThreads = -1;
        } else {
            nSystemThreads = Threads.recordProfilerOwnThreads(true, thread);
        }
        ProfilerRuntime.init(new ProfilerRuntime.ExternalActionsHandler(){

            public void handleFirstTimeMethodInvoke(char c) {
                ProfilerInterface.firstTimeMethodInvokeHook(c);
            }

            public void handleReflectiveInvoke(Method method) {
                ProfilerInterface.reflectiveMethodInvokeHook(method);
            }

            public int handleFirstTimeVMObjectAlloc(String string, int n) {
                return ProfilerInterface.firstTimeVMObjectAlloc(string, n);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleEventBufferDump(byte[] byArray, int n, int n2) {
                serialClientOperationsLock.beginTrans(true);
                try {
                    clientDataProcStartTime = Timers.getCurrentTimeInCounts();
                    evBufManager.eventBufferDumpHook(byArray, n, n2);
                    clientDataProcTime += Timers.getCurrentTimeInCounts() - clientDataProcStartTime;
                }
                finally {
                    serialClientOperationsLock.endTrans();
                }
            }
        });
    }

    public static void initiateProfiling(InitiateProfilingCommand initiateProfilingCommand, boolean bl) throws Exception {
        int n = initiateProfilingCommand.getInstrType();
        String string = initiateProfilingCommand.getRootClassName();
        if (string.equals("*FAKE_CLASS_FOR_INTERNAL_TEST*")) {
            ProfilerInterface.handleFakeInitRecursiveInstrumentationCommand();
            return;
        }
        switch (n) {
            case 0: 
            case 7: {
                ProfilerInterface.createEventBuffer();
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                ProfilerInterface.createEventBuffer();
                status.resetInstrClassAndMethodInfo();
                if (n == 5 || n == 6) {
                    ClassLoaderManager.setNotifyToolAboutUnloadedClasses(true);
                    break;
                }
                ClassLoaderManager.setNotifyToolAboutUnloadedClasses(false);
                break;
            }
            case 1: {
                ProfilerRuntimeCPUCodeRegion.resetProfilerCollectors();
                break;
            }
            case 2: {
                ProfilerInterface.createEventBuffer();
                break;
            }
            default: {
                throw new IllegalArgumentException("Instr. type: " + n);
            }
        }
        new InitiateProfilingThread(initiateProfilingCommand, bl).start();
    }

    public static void instrumentMethods(InstrumentMethodGroupCommand instrumentMethodGroupCommand) throws Exception {
        if (!instrumentMethodGroupCommand.isEmpty()) {
            try {
                ProfilerInterface.instrumentMethodGroupNow(instrumentMethodGroupCommand.getBase());
            }
            catch (Exception exception) {
                ProfilerInterface.deactivateInjectedCode();
                ProfilerInterface.setCurrentInstrType(0);
                throw exception;
            }
        }
        ProfilerInterface.setCurrentInstrType(instrumentMethodGroupCommand.getInstrType());
    }

    public static void resetProfilerCollectors() {
        ProfilerRuntime.resetProfilerCollectors(ProfilerInterface.getCurrentInstrType());
        reflectMethods = new WeakHashMap();
    }

    public static void resumeTargetApp() {
        if (ProfilerInterface.getCurrentInstrType() == 3) {
            ProfilerRuntimeCPUFullInstr.resumeActiveTimers();
        }
        Threads.resumeTargetAppThreads(null);
        targetAppSuspended = false;
    }

    public static void suspendTargetApp() {
        Threads.suspendTargetAppThreads(null);
        if (ProfilerInterface.getCurrentInstrType() == 3) {
            ProfilerRuntimeCPUFullInstr.suspendActiveTimers();
        }
        targetAppSuspended = true;
    }

    static void createEventBuffer() throws IOException {
        evBufManager.openBufferFile(1200000);
        ProfilerRuntime.createEventBuffer(1200000);
    }

    static String getBufferFileName() {
        if (evBufManager != null) {
            return evBufManager.getBufferFileName();
        }
        return "";
    }

    static void setDetachStarted(boolean bl) {
        detachStarted = bl;
    }

    static boolean isDetachStarted() {
        return detachStarted;
    }

    static Response computeHistogram() {
        Response response = null;
        if (Histogram.isAvailable()) {
            response = heapHistgramManager.computeHistogram(Histogram.getRawHistogram());
        }
        if (response == null) {
            response = new Response(HISTOGRAM_NOT_AVAILABLE_MSG);
        }
        return response;
    }

    static byte[][] getClassFileBytes(String[] stringArray, int[] nArray) {
        int n;
        int n2 = 1000;
        Class[] classArray = new Class[n2 + 1];
        int n3 = 0;
        byte[][] byArrayArray = new byte[stringArray.length][];
        Class[] classArray2 = new Class[stringArray.length];
        for (n = 0; n < loadedClassesArray.length; ++n) {
            Class clazz = ProfilerInterface.getOrdinaryClass(loadedClassesArray[n]);
            if (clazz == null) continue;
            int n4 = loadedClassesLoaders[n];
            String string = clazz.getName();
            if (n4 == -1) {
                n4 = 0;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (nArray[i] != n4 || !stringArray[i].equals(string)) continue;
                classArray2[i] = clazz;
                classArray[n3++] = clazz;
                break;
            }
            if (n3 != n2) continue;
            ProfilerInterface.cacheLoadedClasses(classArray, n3);
            n3 = 0;
            profilerServer.sendSimpleCmdToClient(43);
        }
        if (n3 > 0) {
            ProfilerInterface.cacheLoadedClasses(classArray, n3);
        }
        for (n = 0; n < classArray2.length; ++n) {
            if (classArray2[n] == null) continue;
            byArrayArray[n] = ProfilerInterface.getClassFileBytes(classArray2[n], nArray[n]);
        }
        return byArrayArray;
    }

    private static boolean getAndInstrumentClasses(boolean bl) {
        Response response = profilerServer.getLastResponse();
        if (!(response instanceof InstrumentMethodGroupResponse)) {
            String string = MessageFormat.format(INTERNAL_ERROR_MSG, response.getClass(), response);
            ProfilerInterface.deactivateInjectedCode();
            profilerServer.sendComplexCmdToClient(new AsyncMessageCommand(false, string));
            return false;
        }
        InstrumentMethodGroupResponse instrumentMethodGroupResponse = (InstrumentMethodGroupResponse)response;
        clientInstrTime += Timers.getCurrentTimeInCounts() - clientInstrStartTime;
        if (!instrumentMethodGroupResponse.isOK()) {
            return false;
        }
        if (instrumentMethodGroupResponse.isEmpty()) {
            ++nEmptyInstrMethodGroupResponses;
        } else {
            ProfilerInterface.updateInstrClassAndMethodNames(instrumentMethodGroupResponse.getBase(), true);
            if (bl && ProfilerInterface.getCurrentInstrType() == 6) {
                ThreadInfo.getThreadInfo();
            }
            try {
                ProfilerInterface.instrumentMethodGroupNow(instrumentMethodGroupResponse.getBase());
            }
            catch (Exception exception) {
                profilerServer.sendComplexCmdToClient(new AsyncMessageCommand(false, exception.getMessage()));
                return true;
            }
        }
        if (bl) {
            switch (ProfilerInterface.getCurrentInstrType()) {
                case 3: {
                    if (instrumentReflection) {
                        ProfilerRuntimeCPU.setJavaLangReflectMethodInvokeInterceptEnabled(true);
                    }
                    ProfilerRuntimeCPUFullInstr.enableProfiling(true);
                    break;
                }
                case 4: {
                    if (instrumentReflection) {
                        ProfilerRuntimeCPU.setJavaLangReflectMethodInvokeInterceptEnabled(true);
                    }
                    ProfilerRuntimeCPUSampledInstr.enableProfiling(true);
                    break;
                }
                case 1: {
                    ProfilerRuntimeCPUCodeRegion.enableProfiling(true);
                    break;
                }
                case 5: {
                    ProfilerRuntimeObjAlloc.enableProfiling(true);
                    break;
                }
                case 6: {
                    ProfilerRuntimeObjLiveness.enableProfiling(true);
                }
            }
        }
        return true;
    }

    private static boolean isCoreClassName(String string) {
        return (string = string.replace('.', '/')).startsWith("java/") || string.startsWith("sun/") || string.startsWith("javax/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getLoadedClasses() {
        if (loadedClassesArray == null) {
            boolean bl = false;
            int n = 1000;
            Class[] classArray = new Class[n + 1];
            boolean bl2 = profilerServer.isDynamic();
            Class[] classArray2 = Classes.getAllLoadedClasses();
            loadedClassesArray = new WeakReference[classArray2.length];
            loadedClassesLoaders = new int[classArray2.length];
            Monitors.DeterminateProgress determinateProgress = Monitors.enterServerState(2, loadedClassesArray.length);
            try {
                for (int i = 0; i < loadedClassesArray.length; ++i) {
                    determinateProgress.next();
                    if (detachStarted) {
                        return;
                    }
                    Class clazz = classArray2[i];
                    ProfilerInterface.loadedClassesArray[i] = new WeakReference<Class>(clazz);
                    ProfilerInterface.loadedClassesLoaders[i] = ClassLoaderManager.registerLoader(clazz);
                }
            }
            finally {
                Monitors.exitServerState();
            }
        }
    }

    private static boolean isRootClass(String string) {
        for (int i = 0; i < rootClassNames.length; ++i) {
            String string2 = rootClassNames[i];
            if (rootClassNameWildcard[i]) {
                if (string.startsWith(string2)) {
                    if (rootClassNamePackageWildcard[i]) {
                        return true;
                    }
                    if (string.indexOf(46, string2.length()) != -1) continue;
                    return true;
                }
                if (!rootClassNamePackageWildcard[i] || !string.equals(string2.substring(0, string2.length() - 1))) continue;
                return true;
            }
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private static void appendTypeName(StringBuffer stringBuffer, Class clazz) {
        if (clazz.isArray()) {
            do {
                stringBuffer.append('[');
            } while ((clazz = clazz.getComponentType()).isArray());
        }
        if (clazz == Integer.TYPE) {
            stringBuffer.append('I');
        } else if (clazz == Boolean.TYPE) {
            stringBuffer.append('Z');
        } else if (clazz == Byte.TYPE) {
            stringBuffer.append('B');
        } else if (clazz == Character.TYPE) {
            stringBuffer.append('C');
        } else if (clazz == Long.TYPE) {
            stringBuffer.append('J');
        } else if (clazz == Float.TYPE) {
            stringBuffer.append('F');
        } else if (clazz == Double.TYPE) {
            stringBuffer.append('D');
        } else if (clazz == Void.TYPE) {
            stringBuffer.append('V');
        } else {
            stringBuffer.append('L');
            stringBuffer.append(clazz.getName().replace('.', '/'));
            stringBuffer.append(';');
        }
    }

    private static boolean checkForLoadedRootClasses() {
        for (int i = 0; i < loadedClassesArray.length; ++i) {
            Class clazz = (Class)loadedClassesArray[i].get();
            if (clazz == null || !ProfilerInterface.isRootClass(clazz.getName())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void classLoadHook(Class clazz) {
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        ++threadInfo.inProfilingRuntimeMethod;
        try {
            int n;
            String string = clazz.getName();
            if (instrumentMethodGroupCallThread == Thread.currentThread() || ProfilerInterface.internalClassName(string)) {
                ClassLoaderManager.registerLoader(clazz);
                return;
            }
            Thread thread = Thread.currentThread();
            if ("*** Profiler Agent Communication Thread".equals(thread.getName())) {
                System.err.println("*** Profiler engine warning: class " + string + " loaded by " + "*** Profiler Agent Communication Thread");
                return;
            }
            if (initInstrumentationThread != null && thread == initInstrumentationThread) {
                System.err.println("*** Profiler engine warning: class load hook invoked at inappropriate time for " + string + ", loader = " + clazz.getClassLoader());
                System.err.println("*** This class will not be instrumented unless you re-run the instrumentation command");
                System.err.println("*** Please report this problem to feedback@profiler.netbeans.org");
                System.err.println("=============================== Stack trace =====================");
                Thread.dumpStack();
                System.err.println("=============================== End stack trace =================");
                return;
            }
            int n2 = ClassLoaderManager.registerLoader(clazz);
            boolean bl = false;
            if (DEBUG) {
                System.err.println("ProfilerInterface.classLoadHook.DEBUG: " + string + ", classLoaderId: " + n2);
            }
            serialClientOperationsLock.beginTrans(true);
            try {
                n = 0;
                String string2 = null;
                int n3 = ProfilerInterface.getCurrentInstrType();
                if (n3 == 0) {
                    return;
                }
                boolean bl2 = false;
                if (ThreadInfo.profilingSuspended()) {
                    ThreadInfo.suspendProfiling();
                    bl2 = true;
                }
                try {
                    Object object;
                    if (rootClassLoaded) {
                        if (n3 != 3 && n3 != 4 && n3 != 5 && n3 != 6) {
                            if (n3 != 1) return;
                            if (!string.equals(rootClassNames[0])) {
                                return;
                            }
                        }
                        object = null;
                        if (n3 == 3 || n3 == 4) {
                            ++nClassLoads;
                            object = ProfilerRuntimeCPU.suspendCurrentThreadTimer();
                            clientInstrStartTime = Timers.getCurrentTimeInCounts();
                            bl = true;
                        }
                        byte[] byArray = ProfilerInterface.getClassFileBytes(clazz, n2);
                        ClassLoadedCommand classLoadedCommand = new ClassLoadedCommand(string, ClassLoaderManager.getThisAndParentLoaderData(n2), byArray, object != null ? ((ThreadInfo)object).isInCallGraph() : false);
                        profilerServer.sendComplexCmdToClient(classLoadedCommand);
                        if (!ProfilerInterface.getAndInstrumentClasses(false)) {
                            ProfilerInterface.disableProfilerHooks();
                            return;
                        }
                    } else {
                        boolean bl3;
                        boolean bl4 = bl3 = (n3 == 3 || n3 == 4) && ProfilerInterface.status.instrScheme == 3;
                        if (!bl3 && !ProfilerInterface.isRootClass(string)) {
                            return;
                        }
                        ++nClassLoads;
                        clientInstrStartTime = Timers.getCurrentTimeInCounts();
                        ProfilerInterface.sendRootClassLoadedCommand(true);
                        if (!ProfilerInterface.getAndInstrumentClasses(true)) {
                            ProfilerInterface.disableProfilerHooks();
                            return;
                        }
                        n = 1;
                        rootClassLoaded = true;
                        ProfilerCalibrator.resetInternalStatsCollectors();
                    }
                    if (n != 0 || string2 != null) {
                        object = null;
                        object = string2 == null ? new AsyncMessageCommand(true, INSTRUMENTATION_SUCCESSFUL_MSG) : new AsyncMessageCommand(false, string2);
                        profilerServer.sendComplexCmdToClient((Command)object);
                    }
                }
                finally {
                    if (bl2) {
                        ThreadInfo.resumeProfiling();
                    }
                }
            }
            finally {
                serialClientOperationsLock.endTrans();
            }
            if (!bl) return;
            n = ProfilerInterface.getCurrentInstrType();
            if (n != 3) {
                if (n != 4) return;
            }
            ProfilerRuntimeCPU.resumeCurrentThreadTimer();
            return;
        }
        finally {
            --threadInfo.inProfilingRuntimeMethod;
        }
    }

    private static void firstTimeMethodInvokeHook(char c) {
        serialClientOperationsLock.beginTrans(true);
        try {
            int n = ProfilerInterface.getCurrentInstrType();
            if (n != 3 && n != 4) {
                return;
            }
            clientInstrStartTime = Timers.getCurrentTimeInCounts();
            MethodInvokedFirstTimeCommand methodInvokedFirstTimeCommand = new MethodInvokedFirstTimeCommand(c);
            profilerServer.sendComplexCmdToClient(methodInvokedFirstTimeCommand);
            if (!ProfilerInterface.getAndInstrumentClasses(false)) {
                ProfilerInterface.disableProfilerHooks();
                return;
            }
            if (nFirstMethodInvocations == 0) {
                ProfilerCalibrator.resetInternalStatsCollectors();
            }
            ++nFirstMethodInvocations;
        }
        finally {
            serialClientOperationsLock.endTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int firstTimeVMObjectAlloc(String string, int n) {
        GetClassIdResponse getClassIdResponse;
        if (ProfilerInterface.internalClassName(string)) {
            return -1;
        }
        serialClientOperationsLock.beginTrans(true);
        try {
            GetClassIdCommand getClassIdCommand = new GetClassIdCommand(string, n);
            profilerServer.sendComplexCmdToClient(getClassIdCommand);
            getClassIdResponse = (GetClassIdResponse)profilerServer.getLastResponse();
        }
        finally {
            serialClientOperationsLock.endTrans();
        }
        if (getClassIdResponse.isOK()) {
            int n2 = getClassIdResponse.getClassId();
            int n3 = n2 + 1;
            if (n3 > status.getNInstrClasses()) {
                status.updateAllocatedInstancesCountInfoInServer(n3);
                ProfilerRuntimeMemory.setAllocatedInstancesCountArray(status.getAllocatedInstancesCount());
            }
            return n2;
        }
        return -1;
    }

    private static void handleFakeInitRecursiveInstrumentationCommand() {
        new HFIRIThread().start();
    }

    private static boolean hasAnyCoreClassNames(String[] stringArray) {
        if (stringArray.length <= 0) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!ProfilerInterface.isCoreClassName(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void instrumentMethodGroupNow(InstrumentMethodGroupData instrumentMethodGroupData) throws Exception {
        Monitors.DeterminateProgress determinateProgress = Monitors.enterServerState(1, 2);
        try {
            instrumentMethodGroupCallThread = Thread.currentThread();
            boolean bl = false;
            long l = Timers.getCurrentTimeInCounts();
            ++nNonEmptyInstrMethodGroupResponses;
            int n = instrumentMethodGroupData.getNClasses();
            String[] stringArray = instrumentMethodGroupData.getMethodClasses();
            int[] nArray = instrumentMethodGroupData.getClassLoaderIds();
            int n2 = instrumentMethodGroupData.getNMethods();
            Class[] classArray = new Class[n];
            byte[][] byArray = instrumentMethodGroupData.getReplacementClassFileBytes();
            int n3 = 0;
            Monitors.DeterminateProgress determinateProgress2 = Monitors.enterServerState(2, n);
            try {
                for (int i = 0; i < n; ++i) {
                    determinateProgress2.next();
                    classArray[n3] = ClassLoaderManager.getLoadedClass(stringArray[i], nArray[i]);
                    if (classArray[n3] != null) {
                        if (byArray[n3] == null) {
                            if (nArray[i] == 0) {
                                byArray[n3] = ClassBytesLoader.getClassFileBytes(stringArray[i]);
                            }
                            if (byArray[n3] == null) {
                                byArray[n3] = ProfilerInterface.getCachedClassFileBytes(classArray[n3]);
                            }
                        }
                        ++n3;
                        continue;
                    }
                    ProfilerInterface.reportUnloadedClass(stringArray[i]);
                    int n4 = n - n3 - 1;
                    System.arraycopy(classArray, n3 + 1, classArray, n3, n4);
                    System.arraycopy(byArray, n3 + 1, byArray, n3, n4);
                }
                if (n3 < n) {
                    Class[] classArray2 = classArray;
                    classArray = new Class[n3];
                    System.arraycopy(classArray2, 0, classArray, 0, n3);
                }
            }
            finally {
                determinateProgress2 = null;
                Monitors.exitServerState();
            }
            determinateProgress.next();
            ProfilerInterface.redefineClasses(classArray, instrumentMethodGroupData.getReplacementClassFileBytes());
            l = Timers.getCurrentTimeInCounts() - l;
            totalHotswappingTime += l;
            if (l < minHotswappingTime) {
                minHotswappingTime = l;
            } else if (l > maxHotswappingTime) {
                maxHotswappingTime = l;
            }
            instrumentMethodGroupCallThread = null;
        }
        catch (Throwable throwable) {
            if (throwable instanceof Classes.RedefineException) {
                int n = instrumentMethodGroupData.getNClasses();
                String[] stringArray = instrumentMethodGroupData.getMethodClasses();
                System.err.println("Profiler Agent Error: Redefinition failed for classes:");
                for (int i = 0; i < n; ++i) {
                    System.err.println(stringArray[i]);
                }
                System.err.println("Profiler Agent Error: with message: " + ((Classes.RedefineException)throwable).getMessage());
                byte[][] byArray = instrumentMethodGroupData.getReplacementClassFileBytes();
                for (int i = 0; i < n; ++i) {
                    String string = stringArray[i];
                    File file = new File(string + ".class");
                    System.err.println("Debug: writing class file: " + string + ", into file: " + file.getPath());
                    try {
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        fileOutputStream.write(byArray[i]);
                        fileOutputStream.close();
                        continue;
                    }
                    catch (IOException iOException) {
                        System.err.println("error: " + iOException + " writing class file: " + file.getPath());
                    }
                }
                throw (Classes.RedefineException)throwable;
            }
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            throw new Exception(MessageFormat.format(UNEXPECTED_EXCEPTION_MSG, throwable, stringWriter.toString()));
        }
        finally {
            instrumentMethodGroupCallThread = null;
            Monitors.exitServerState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void redefineClasses(Class[] classArray, byte[][] byArray) throws Classes.RedefineException {
        Monitors.DeterminateProgress determinateProgress = Monitors.enterServerState(3, (classArray.length + 500 - 1) / 500);
        try {
            int n;
            Class[] classArray2 = null;
            Object object = null;
            for (int i = 0; i < classArray.length; i += n) {
                n = Math.min(classArray.length - i, 500);
                if (classArray2 == null || classArray2.length != n) {
                    classArray2 = new Class[n];
                    object = new byte[n][];
                }
                System.arraycopy(classArray, i, classArray2, 0, n);
                System.arraycopy(byArray, i, object, 0, n);
                Classes.redefineClasses((Class[])classArray2, (byte[][])object);
                determinateProgress.next();
            }
        }
        finally {
            Monitors.exitServerState();
        }
    }

    private static boolean internalClassName(String string) {
        return ProfilerInterface.serverInternalClassName(string) || string.startsWith("sun.reflect.") && !string.startsWith("sun.reflect.GeneratedSerializationConstructorAccessor") && !string.startsWith("sun.reflect.GeneratedConstructorAccessor") || string.startsWith("sun.instrument.") || string.equals("com.sun.enterprise.J2EESecurityManager") || string.contains("/");
    }

    static boolean serverInternalClassName(String string) {
        if (INSTRUMENT_JFLUID_CLASSES) {
            return string.startsWith("org.netbeans.lib.profiler.server") || string.startsWith("org.netbeans.lib.profiler.global") || string.startsWith("org.netbeans.lib.profiler.wireprotocol");
        }
        return string.startsWith("org.netbeans.lib.profiler.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reflectiveMethodInvokeHook(Method method) {
        serialClientOperationsLock.beginTrans(true);
        try {
            if (reflectMethods.containsKey(method)) {
                return;
            }
            ProfilerRuntimeCPU.suspendCurrentThreadTimer();
            reflectMethods.put(method, null);
            Class<?> clazz = method.getDeclaringClass();
            String string = clazz.getName();
            String string2 = method.getName();
            Class<?>[] classArray = method.getParameterTypes();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('(');
            for (int i = 0; i < classArray.length; ++i) {
                ProfilerInterface.appendTypeName(stringBuffer, classArray[i]);
            }
            stringBuffer.append(')');
            ProfilerInterface.appendTypeName(stringBuffer, method.getReturnType());
            String string3 = stringBuffer.toString();
            clientInstrStartTime = Timers.getCurrentTimeInCounts();
            MethodLoadedCommand methodLoadedCommand = new MethodLoadedCommand(string, ClassLoaderManager.registerLoader(clazz), string2, string3);
            profilerServer.sendComplexCmdToClient(methodLoadedCommand);
            if (!ProfilerInterface.getAndInstrumentClasses(false)) {
                ProfilerInterface.disableProfilerHooks();
                return;
            }
            ProfilerRuntimeCPU.resumeCurrentThreadTimer();
        }
        finally {
            serialClientOperationsLock.endTrans();
        }
    }

    private static void reportUnloadedClass(String string) {
        System.err.println("*** Profiler engine warning: target VM cannot load class to instrument " + string);
        System.err.println("*** probably it has been unloaded recently");
    }

    private static void reportCacheMiss(byte[] byArray, Class clazz) {
        if (byArray == null) {
            System.err.println("*** Profiler engine warning: Failed to lookup cached class " + clazz.getName());
        }
    }

    private static byte[] getCachedClassFileBytes(Class clazz) {
        byte[] byArray = Classes.getCachedClassFileBytes((Class)clazz);
        ProfilerInterface.reportCacheMiss(byArray, clazz);
        return byArray;
    }

    private static void cacheLoadedClass(Class clazz) {
        Class[] classArray = new Class[2];
        classArray[0] = clazz;
        ProfilerInterface.cacheLoadedClasses(classArray, 1);
    }

    private static void cacheLoadedClasses(Class[] classArray, int n) {
        if (DEBUG) {
            System.out.println("Caching " + n + " classes");
        }
        classArray[n++] = InitiateProfilingThread.class;
        Classes.cacheLoadedClasses((Class[])classArray, (int)n);
    }

    private static byte[] getClassFileBytes(Class clazz, int n) {
        return ProfilerInterface.getClassFileBytes(clazz, n, true);
    }

    private static byte[] getClassFileBytes(Class clazz, int n, boolean bl) {
        byte[] byArray = null;
        URL uRL = null;
        if (n > 0 || (uRL = ClassBytesLoader.getClassFileURL(clazz.getName())) == null) {
            byArray = Classes.getCachedClassFileBytes((Class)clazz);
            if (byArray == null) {
                if (DEBUG) {
                    System.err.println("Cannot get classbytes for " + clazz.getName() + " loader " + n);
                }
                if (!bl) {
                    return EMPTY;
                }
                ProfilerInterface.cacheLoadedClass(clazz);
                byArray = ProfilerInterface.getCachedClassFileBytes(clazz);
                if (byArray == null && Platform.getJDKVersionNumber() != 5) {
                    System.err.println("***Profiler agent warning: could not get .class file for a synthetic class " + clazz.getName() + " in ProfilerInterface.getClassFileBytes");
                }
            }
        } else if (ProfilerInterface.status.remoteProfiling || Platform.getJDKVersionNumber() >= 7) {
            byArray = ClassBytesLoader.getClassFileBytes(uRL);
        }
        return byArray;
    }

    private static void sendRootClassLoadedCommand(boolean bl) {
        Class clazz;
        int n;
        if (bl) {
            ProfilerInterface.getLoadedClasses();
        }
        int n2 = loadedClassesArray.length;
        String[] stringArray = new String[n2];
        int[] nArray = new int[n2];
        byte[][] byArrayArray = new byte[n2][];
        int[] nArray2 = new int[n2];
        int[][] nArrayArray = new int[n2][];
        int n3 = ProfilerInterface.getCurrentInstrType();
        boolean bl2 = profilerServer.isDynamic() && (n3 == 3 || n3 == 4) && ProfilerInterface.status.instrScheme == 1 && !instrSpawnedThreads;
        boolean bl3 = profilerServer.isDynamic() && (n3 == 5 || n3 == 6);
        HashMap<Class, Integer> hashMap = new HashMap<Class, Integer>(loadedClassesArray.length * 4 / 3);
        Class[] classArray = new Class[n2];
        for (n = 0; n < n2; ++n) {
            clazz = ProfilerInterface.getOrdinaryClass(loadedClassesArray[n]);
            if (clazz == null) continue;
            int n4 = hashMap.size();
            classArray[n4] = clazz;
            nArray[n4] = loadedClassesLoaders[n];
            hashMap.put(clazz, new Integer(n4));
        }
        for (n = 0; n < hashMap.size(); ++n) {
            Integer n5;
            clazz = classArray[n];
            String string = clazz.getName();
            boolean bl4 = !bl2 && !bl3 || ProfilerInterface.isRootClass(string);
            stringArray[n] = string;
            byArrayArray[n] = ProfilerInterface.getClassFileBytes(clazz, nArray[n], bl4);
            if (bl4) continue;
            Class clazz2 = clazz.getSuperclass();
            Class<?>[] classArray2 = clazz.getInterfaces();
            nArray2[n] = clazz2 != null ? ((n5 = (Integer)hashMap.get(clazz2)) != null ? n5 : -1) : -1;
            nArrayArray[n] = new int[classArray2.length];
            for (int i = 0; i < classArray2.length; ++i) {
                Integer n6 = (Integer)hashMap.get(classArray2[i]);
                if (n6 != null) {
                    nArrayArray[n][i] = n6;
                    continue;
                }
                nArray2[n] = -1;
            }
        }
        RootClassLoadedCommand rootClassLoadedCommand = new RootClassLoadedCommand(stringArray, nArray, byArrayArray, nArray2, nArrayArray, hashMap.size(), ClassLoaderManager.getParentLoaderIdTable());
        profilerServer.sendComplexCmdToClient(rootClassLoadedCommand);
    }

    private static Class getOrdinaryClass(WeakReference weakReference) {
        String string;
        Class clazz = (Class)weakReference.get();
        if (clazz != null && !(string = clazz.getName()).startsWith("[") && !ProfilerInterface.internalClassName(string)) {
            return clazz;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void updateInstrClassAndMethodNames(InstrumentMethodGroupData instrumentMethodGroupData, boolean bl) {
        status.beginTrans(false);
        try {
            switch (ProfilerInterface.getCurrentInstrType()) {
                case 3: 
                case 4: {
                    status.updateInstrMethodsInfo(instrumentMethodGroupData.getNClasses(), instrumentMethodGroupData.getNMethods(), null, null, null, null, null, instrumentMethodGroupData.getInstrMethodLeaf());
                    ProfilerRuntimeCPU.setInstrMethodsInvoked(status.getInstrMethodInvoked());
                    return;
                }
                case 5: 
                case 6: {
                    status.updateAllocatedInstancesCountInfoInServer(instrumentMethodGroupData.getAddInfo());
                    ProfilerRuntimeMemory.setAllocatedInstancesCountArray(status.getAllocatedInstancesCount());
                    return;
                }
            }
            return;
        }
        finally {
            status.endTrans();
        }
    }

    static /* synthetic */ String[] access$202(String[] stringArray) {
        rootClassNames = stringArray;
        return stringArray;
    }

    static /* synthetic */ WeakReference[] access$502(WeakReference[] weakReferenceArray) {
        loadedClassesArray = weakReferenceArray;
        return weakReferenceArray;
    }

    static /* synthetic */ int[] access$602(int[] nArray) {
        loadedClassesLoaders = nArray;
        return nArray;
    }

    static /* synthetic */ boolean[] access$1402(boolean[] blArray) {
        rootClassNameWildcard = blArray;
        return blArray;
    }

    static /* synthetic */ boolean[] access$1502(boolean[] blArray) {
        rootClassNamePackageWildcard = blArray;
        return blArray;
    }

    static {
        ResourceBundle resourceBundle = ProfilerServer.getProfilerServerResourceBundle();
        if (resourceBundle != null) {
            INTERNAL_ERROR_MSG = resourceBundle.getString("ProfilerInterface_InternalErrorMsg");
            UNEXPECTED_EXCEPTION_MSG = resourceBundle.getString("ProfilerInterface_UnexpectedExceptionMsg");
            INSTRUMENTATION_SUCCESSFUL_MSG = resourceBundle.getString("ProfilerInterface_InstrumentationSuccessfulMsg");
            HISTOGRAM_NOT_AVAILABLE_MSG = resourceBundle.getString("ProfilerInterface_HistogramNotAvailableMsg");
        }
        DEBUG = Boolean.getBoolean("org.netbeans.lib.profiler.server.ProfilerInterface.classLoadHook");
        INSTRUMENT_JFLUID_CLASSES = Boolean.getBoolean("org.netbeans.lib.profiler.server.instrumentJFluidClasses");
        EMPTY = new byte[0];
        serialClientOperationsLock = new TransactionalSupport();
        targetAppSuspended = false;
        instrumentReflection = false;
        minHotswappingTime = 10000000000L;
    }

    private static class InitiateProfilingThread
    extends Thread {
        private InitiateProfilingCommand cmd;
        private boolean targetAppRunning;

        InitiateProfilingThread(InitiateProfilingCommand initiateProfilingCommand, boolean bl) {
            ThreadInfo.addProfilerServerThread(this);
            this.setName("*** Profiler Agent Special Execution Thread 2");
            this.cmd = initiateProfilingCommand;
            this.targetAppRunning = bl;
        }

        public void run() {
            Monitors.enterServerState(1);
            serialClientOperationsLock.beginTrans(true);
            try {
                initInstrumentationThread = Thread.currentThread();
                int n = this.cmd.getInstrType();
                ProfilerInterface.setCurrentInstrType(n);
                switch (n) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        ProfilerRuntimeSampler.initialize();
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        this.initiateInstrumentation(n);
                        break;
                    }
                    case 7: {
                        if (!Histogram.initialize((Platform.getJDKVersionNumber() >= 7 ? 1 : 0) != 0)) break;
                        profilerServer;
                        ProfilerServer.notifyClientOnResultsAvailability();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Instr. type: " + n);
                    }
                }
                initInstrumentationThread = null;
            }
            finally {
                serialClientOperationsLock.endTrans();
                Monitors.exitServerState();
            }
            ThreadInfo.removeProfilerServerThread(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initiateInstrumentation(int n) {
            Monitors.DeterminateProgress determinateProgress = Monitors.enterServerState(1, 2);
            int[] nArray = this.cmd.getProfilingPointIDs();
            String[] stringArray = this.cmd.getProfilingPointHandlers();
            String[] stringArray2 = this.cmd.getProfilingPointInfos();
            ProfilerInterface.access$202(this.cmd.getRootClassNames());
            status.startProfilingPointsActive = this.cmd.isStartProfilingPointsActive();
            ProfilingPointServerHandler.initInstances(nArray, stringArray, stringArray2);
            InitiateProfilingThread.computeRootWildcard();
            rootClassLoaded = false;
            new LinkedHashMap().keySet().iterator();
            try {
                Class.forName("java.lang.reflect.InvocationTargetException");
                Class.forName("java.lang.InterruptedException");
                Class.forName("java.lang.ClassFormatError");
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace(System.err);
            }
            if (Platform.getJDKVersionNumber() >= 7) {
                try {
                    Class.forName("java.lang.WeakPairMap$Pair");
                    Class.forName("java.lang.WeakPairMap$WeakRefPeer");
                    Class.forName("java.lang.WeakPairMap$Pair$Weak");
                    Class.forName("java.lang.WeakPairMap$Pair$Weak$1");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace(System.err);
                }
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            InitiateProfilingThread initiateProfilingThread = this;
            synchronized (initiateProfilingThread) {
                try {
                    this.wait(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ProfilerInterface.access$502(null);
            ProfilerInterface.access$602(null);
            Classes.enableClassLoadHook();
            instrSpawnedThreads = this.cmd.getInstrSpawnedThreads();
            if (this.targetAppRunning || ProfilerInterface.hasAnyCoreClassNames(this.cmd.getRootClassNames()) || instrSpawnedThreads || n == 5 || n == 6) {
                ProfilerInterface.getLoadedClasses();
                boolean bl = false;
                if (!detachStarted) {
                    switch (n) {
                        case 3: 
                        case 4: {
                            bl = instrSpawnedThreads ? true : ProfilerInterface.checkForLoadedRootClasses();
                            break;
                        }
                        case 1: {
                            bl = ProfilerInterface.checkForLoadedRootClasses();
                            break;
                        }
                        case 5: 
                        case 6: {
                            bl = true;
                        }
                    }
                }
                determinateProgress.next();
                if (bl) {
                    ProfilerInterface.sendRootClassLoadedCommand(false);
                    if (!ProfilerInterface.getAndInstrumentClasses(true)) {
                        ProfilerInterface.disableProfilerHooks();
                    }
                    rootClassLoaded = true;
                } else {
                    ProfilerInterface.access$502(null);
                    ProfilerInterface.access$602(null);
                }
            }
            Monitors.exitServerState();
        }

        private static void computeRootWildcard() {
            ProfilerInterface.access$1402(new boolean[rootClassNames.length]);
            ProfilerInterface.access$1502(new boolean[rootClassNames.length]);
            for (int i = 0; i < rootClassNames.length; ++i) {
                int n = rootClassNames[i].length();
                boolean bl = rootClassNameWildcard[i] = n == 0 || rootClassNames[i].charAt(n - 1) == '.';
                if (rootClassNameWildcard[i] || rootClassNames[i].charAt(n - 1) != '*') continue;
                rootClassNames[i] = rootClassNames[i].substring(0, n - 1);
                rootClassNameWildcard[i] = true;
                rootClassNamePackageWildcard[i] = true;
            }
        }
    }

    private static class HFIRIThread
    extends Thread {
        HFIRIThread() {
            ThreadInfo.addProfilerServerThread(this);
            this.setName("*** Profiler Agent Special Execution Thread 1");
            this.setDaemon(true);
        }

        public void run() {
            RootClassLoadedCommand rootClassLoadedCommand = new RootClassLoadedCommand(new String[]{"*FAKE_CLASS_1*", "*FAKE_CLASS_2*"}, new int[]{0, 0}, null, new int[]{0, 0}, new int[2][], 2, new int[]{-1});
            profilerServer.sendComplexCmdToClient(rootClassLoadedCommand);
            profilerServer;
            InstrumentMethodGroupResponse instrumentMethodGroupResponse = (InstrumentMethodGroupResponse)ProfilerServer.getLastResponse();
            ThreadInfo.removeProfilerServerThread(this);
        }
    }
}

