#!/usr/bin/perl
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

# --------------------------------

$Lang{Start_Archive} = "Dmarrer l'archivage";
$Lang{Stop_Dequeue_Archive} = "Arrt/Mise en attente de l'archivage";
$Lang{Start_Full_Backup} = "Dmarrer la sauvegarde complte";
$Lang{Start_Incr_Backup} = "Dmarrer la sauvegarde incrmentielle";
$Lang{Stop_Dequeue_Backup} = "Arrter/annuler la sauvegarde";
$Lang{Restore} = "Restaurer";

$Lang{Type_full} = "complte";
$Lang{Type_incr} = "incrmentielle";

# -----

$Lang{Only_privileged_users_can_view_admin_options} = "Seuls les utilisateurs privilgis peuvent voir les options d'administration.";
$Lang{H_Admin_Options} = "BackupPC: Options d'administration";
$Lang{Admin_Options} = "Options d'administration";
$Lang{Admin_Options_Page} = <<EOF;
\${h1(qq{$Lang{Admin_Options}})}
<br>
\${h2("Contrle du serveur")}
<form name="ReloadForm" action="\$MyURL" method="get">
<input type="hidden" name="action" value="">
<table class="tableStnd">
  <tr><td>Recharger la configuration:<td><input type="button" value="Recharger"
     onClick="document.ReloadForm.action.value='Reload';
              document.ReloadForm.submit();">
</table>
</form>
<!--
\${h2("Server Configuration")}
<ul>
  <li><i>Other options can go here... e.g.,</i>
  <li>Edit server configuration
</ul>
-->
EOF

$Lang{Unable_to_connect_to_BackupPC_server} = "Impossible de se connecter au serveur BackupPC";
$Lang{Unable_to_connect_to_BackupPC_server_error_message} = <<EOF;
Ce script CGI (\$MyURL) est incapable de se connecter au serveur BackupPC
sur \$Conf{ServerHost} au port \$Conf{ServerPort}.<br>
L'erreur est: \$err.<br>
Il est possible que le serveur BackupPC ne fonctionne pas actuellement ou qu'il
y ait une erreur de configuration. Veuillez contacter votre administrateur systme.
EOF

$Lang{Admin_Start_Server} = <<EOF;
\${h1(qq{$Lang{Unable_to_connect_to_BackupPC_server}})}
<form action="\$MyURL" method="get">
Le serveur BackupPC sur <tt>\$Conf{ServerHost}</tt>, port <tt>\$Conf{ServerPort}</tt>
n'est pas en fonction (vous l'avez peut-tre arrt, ou vous ne l'avez pas encore dmarr).<br>
Voulez-vous le dmarrer ?
<input type="hidden" name="action" value="startServer">
<input type="submit" value="Dmarrer le serveur" name="ignore">
</form>
EOF

# -----

$Lang{H_BackupPC_Server_Status} = "tat du serveur BackupPC";

$Lang{BackupPC_Server_Status_General_Info}= <<EOF;
\${h2(\"Informations gnrales du serveur\")}

<ul>
<li> Le PID du serveur est \$Info{pid}, sur l\'hte \$Conf{ServerHost},
     version \$Info{Version}, dmarr le \$serverStartTime.
<li> Ce rapport a t gnr le \$now.
<li> La configuration a t charge pour la dernire fois  \$configLoadTime.
<li> La prochaine file d\'attente sera remplie  \$nextWakeupTime.
<li> Autres infos:
    <ul>
        <li>\$numBgQueue demandes de sauvegardes en attente depuis le dernier rveil automatique,
        <li>\$numUserQueue requtes de sauvegardes utilisateur en attente,
        <li>\$numCmdQueue requtes de commandes en attente,
        \$poolInfo
        <li>L\'espace de stockage a t rcemment rempli  \$Info{DUlastValue}%
            (\$DUlastTime), le maximum aujourd\'hui a t de \$Info{DUDailyMax}% (\$DUmaxTime)
            et hier le maximum tait de \$Info{DUDailyMaxPrev}%.
        <li>Inode L\'espace de stockage a t rcemment rempli  \$Info{DUInodelastValue}%
            (\$DUlastTime), le maximum aujourd\'hui a t de \$Info{DUInodeDailyMax}% (\$DUInodemaxTime)
            et hier le maximum tait de \$Info{DUInodeDailyMaxPrev}%.
    </ul>
</ul>
EOF

$Lang{BackupPC_Server_Status} = <<EOF;
\${h1(qq{$Lang{H_BackupPC_Server_Status}})}

<p>
\${h2("Travaux en cours d'excution")}
<p>
<table class="tableStnd sortable" border cellspacing="1" cellpadding="3">
<tr class="tableheader"><td> Hte </td>
    <td> Type </td>
    <td> Utilisateur </td>
    <td> Date de dpart </td>
    <td> Commande </td>
    <td align="center"> PID </td>
    <td align="center"> PID du transfert </td>
    <td align="center"> Status </td>
    <td align="center"> Count </td>
    </tr>
\$jobStr
</table>

<p>
\$generalInfo

\${h2("checs qui demandent de l'attention")}
<p>
<table class="tableStnd sortable" border cellspacing="1" cellpadding="3">
<tr class="tableheader"><td align="center"> Hte </td>
    <td align="center"> Type </td>
    <td align="center"> Utilisateur </td>
    <td align="center"> Dernier essai </td>
    <td align="center"> Dtails </td>
    <td align="center"> Date d\'erreur </td>
    <td> Dernire erreur (autre que pas de ping) </td></tr>
\$statusStr
</table>
EOF

# --------------------------------
$Lang{BackupPC__Server_Summary} = "BackupPC: Bilan des machines";
$Lang{BackupPC__Archive} = "BackupPC: Archivage";
$Lang{BackupPC_Summary}=<<EOF;

\${h1(qq{$Lang{BackupPC__Server_Summary}})}
<p>
<ul>
<li>Ce statut a t gnr le \$now.
<li>L\'espace de stockage a t rcemment rempli  \$Info{DUlastValue}%
    (\$DUlastTime), le maximum aujourd\'hui a t de \$Info{DUDailyMax}% (\$DUmaxTime)
    et hier le maximum tait de \$Info{DUDailyMaxPrev}%.
<li>Inode L\'espace de stockage a t rcemment rempli  \$Info{DUInodelastValue}%
    (\$DUlastTime), le maximum aujourd\'hui a t de \$Info{DUInodeDailyMax}% (\$DUInodemaxTime)
    et hier le maximum tait de \$Info{DUInodeDailyMaxPrev}%.
</ul>
</p>

\${h2("Htes avec de bonnes sauvegardes")}
<p>
Il y a \$hostCntGood htes ayant t sauvegards, pour un total de :
<ul>
<li> \$fullTot sauvegardes compltes de tailles cumules de \${fullSizeTot} Go
     (prcdant la mise en commun et la compression),
<li> \$incrTot sauvegardes incrmentielles de tailles cumules de \${incrSizeTot} Go
     (prcdant la mise en commun et la compression).
</ul>
</p>
<table class="sortable" id="host_summary_backups" border cellpadding="3" cellspacing="1">
<tr class="tableheader"><td> Hte </td>
    <td align="center"> Utilisateur </td>
    <td align="center"> Commentaire </td>
    <td align="center"> Nb compltes </td>
    <td align="center"> Compltes ge (jours) </td>
    <td align="center"> Compltes Taille (Go) </td>
    <td align="center"> Vitesse (Mo/s) </td>
    <td align="center"> Nb incrmentielles </td>
    <td align="center"> Incrmentielles ge (jours) </td>
    <td align="center"> Dernire sauvegarde (jours) </td>
    <td align="center"> tat actuel </td>
    <td align="center"> Nb erreurs transfert </td>
    <td align="center"> Dernire tentative </td></tr>
\$strGood
</table>
\${h2("Htes sans sauvegardes")}
<p>
Il y a \$hostCntNone htes sans sauvegardes.
<p>
<table class="sortable" id="host_summary_nobackups" border cellpadding="3" cellspacing="1">
<tr class="tableheader"><td> Hte </td>
    <td align="center"> Utilisateur </td>
    <td align="center"> Commentaire </td>
    <td align="center"> Nb compltes </td>
    <td align="center"> Compltes ge (jours) </td>
    <td align="center"> Compltes Taille (Go) </td>
    <td align="center"> Vitesse (Mo/s) </td>
    <td align="center"> Nb incrmentielles </td>
    <td align="center"> Incrmentielles ge (jours) </td>
    <td align="center"> Dernire sauvegarde (jours) </td>
    <td align="center"> tat actuel </td>
    <td align="center"> Nb erreurs transfert </td>
    <td align="center"> Dernire tentative </td></tr>
\$strNone
</table>
EOF

$Lang{BackupPC_Archive}=<<EOF;
\${h1(qq{$Lang{BackupPC__Archive}})}
<script language="javascript" type="text/javascript">
<!--

    function checkAll(location)
    {
      for (var i=0;i<document.form1.elements.length;i++)
      {
        var e = document.form1.elements[i];
        if ((e.checked || !e.checked) && e.name != \'all\') {
            if (eval("document.form1."+location+".checked")) {
                e.checked = true;
            } else {
                e.checked = false;
            }
        }
      }
    }

    function toggleThis(checkbox)
    {
       var cb = eval("document.form1."+checkbox);
       cb.checked = !cb.checked;
    }

//-->
</script>

Il y a \$hostCntGood htes qui ont t sauvegards, reprsentant \${fullSizeTot} Go
<p>
<form name="form1" method="post" action="\$MyURL">
<input type="hidden" name="fcbMax" value="\$checkBoxCnt">
<input type="hidden" name="type" value="1">
<input type="hidden" name="host" value="\${EscHTML(\$archHost)}">
<input type="hidden" name="action" value="Archive">
<table class="tableStnd" border cellpadding="3" cellspacing="1">
<tr class="tableheader"><td align=center> Host</td>
    <td align="center"> Utilisateur </td>
    <td align="center"> Taille </td>
\$strGood
\$checkAllHosts
</table>
</form>
<p>

EOF

$Lang{BackupPC_Archive2}=<<EOF;
\${h1(qq{$Lang{BackupPC__Archive}})}
Prt  dmarrer l'archivage des htes suivants
<ul>
\$HostListStr
</ul>
<form action="\$MyURL" method="post">
\$hiddenStr
<input type="hidden" name="action" value="Archive">
<input type="hidden" name="host" value="\${EscHTML(\$archHost)}">
<input type="hidden" name="type" value="2">
<input type="hidden" value="0" name="archive_type">
<table class="tableStnd" border cellspacing="1" cellpadding="3">
\$paramStr
<tr>
    <td colspan=2><input type="submit" value="Dmarrer l'archivage" name="ignore"></td>
</tr>
</form>
</table>
EOF

$Lang{BackupPC_Archive2_location} = <<EOF;
<tr>
    <td>Dispositif/Localisation de l'archive</td>
    <td><input type="text" value="\$ArchiveDest" name="archive_device"></td>
</tr>
EOF

$Lang{BackupPC_Archive2_compression} = <<EOF;
<tr>
    <td>Compression</td>
    <td>
    <input type="radio" value="0" name="compression" \$ArchiveCompNone>Aucune<br>
    <input type="radio" value="1" name="compression" \$ArchiveCompGzip>gzip<br>
    <input type="radio" value="2" name="compression" \$ArchiveCompBzip2>bzip2
    </td>
</tr>
EOF

$Lang{BackupPC_Archive2_parity} = <<EOF;
<tr>
    <td>Pourcentage des donnes de parit (0 = dsactiv, 5 = typique)</td>
    <td><input type="numeric" value="\$ArchivePar" name="par"></td>
</tr>
EOF

$Lang{BackupPC_Archive2_split} = <<EOF;
<tr>
    <td>Scinder le fichier en fichiers de</td>
    <td><input type="numeric" value="\$ArchiveSplit" name="splitsize"> Mo</td>
</tr>
EOF

# -----------------------------------
$Lang{Pool_Stat} = <<EOF;
        <li>La mise en commun est constitue de \$info->{"\${name}FileCnt"} fichiers
            et \$info->{"\${name}DirCnt"} rpertoires reprsentant \${poolSize} Go (depuis le \$poolTime),
        <li>Le hachage de mise en commun des fichiers donne \$info->{"\${name}FileCntRep"} fichiers rpts
            avec comme plus longue chane \$info->{"\${name}FileRepMax"},
        <li>Le nettoyage nocturne a effac \$info->{"\${name}FileCntRm"} fichiers, soit
            \${poolRmSize} Go (vers \$poolTime),
EOF

# -----------------------------------
$Lang{BackupPC__Backup_Requested_on__host} = "BackupPC: Sauvegarde demande sur \$host";
$Lang{BackupPC__Delete_Requested_for_a_backup_of__host} = "BackupPC: Delete Requested for a backup of \$host";
# --------------------------------
$Lang{REPLY_FROM_SERVER} = <<EOF;
\${h1(\$str)}
<p>
La rponse du serveur a t : \$reply
<p>
Retourner  la page d\'accueil de <a href="\$MyURL?host=\$host">\$host</a>.
EOF
# --------------------------------
$Lang{BackupPC__Start_Backup_Confirm_on__host} = "BackupPC: Confirmation du dmarrage de la sauvegarde de \$host";
# --------------------------------
$Lang{Are_you_sure_start} = <<EOF;
\${h1("tes-vous certain ?")}
<p>
Vous allez bientt dmarrer une sauvegarde \$type depuis \$host.

<form name="Confirm" action="\$MyURL" method="get">
<input type="hidden" name="host" value="\$host">
<input type="hidden" name="hostIP" value="\$ipAddr">
<input type="hidden" name="doit" value="1">
<input type="hidden" name="action" value="">
Voulez-vous vraiment le faire ?
<input type="button" value="\$buttonText"
  onClick="document.Confirm.action.value='\$In{action}';
           document.Confirm.submit();">
<input type="submit" value="Non" name="ignore">
</form>
EOF
# --------------------------------
$Lang{BackupPC__Stop_Backup_Confirm_on__host} = "BackupPC: Confirmer l\'arrt de la sauvegarde sur \$host";
# --------------------------------
$Lang{Are_you_sure_stop} = <<EOF;

\${h1("tes-vous certain ?")}

<p>
Vous tes sur le point d\'arrter/supprimer de la file les sauvegardes de \$host;

<form name="Confirm" action="\$MyURL" method="get">
<input type="hidden" name="host"   value="\$host">
<input type="hidden" name="doit"   value="1">
<input type="hidden" name="action" value="">
En outre, prire de ne pas dmarrer d\'autre sauvegarde pendant
<input type="text" name="backoff" size="10" value="\$backoff"> heures.
<p>
Voulez-vous vraiment le faire ?
<input type="button" value="\$buttonText"
  onClick="document.Confirm.action.value='\$In{action}';
           document.Confirm.submit();">
<input type="submit" value="Non" name="ignore">
</form>

EOF
# --------------------------------
$Lang{Only_privileged_users_can_view_queues_} = "Seuls les utilisateurs privilgis peuvent voir les files.";
# --------------------------------
$Lang{Only_privileged_users_can_archive} = "Seuls les utilisateurs privilgis peuvent archiver.";
# --------------------------------
$Lang{BackupPC__Queue_Summary} = "BackupPC: Rsum de la file";
# --------------------------------
$Lang{Backup_Queue_Summary} = <<EOF;
\${h1("Rsum de la file")}
\${h2("Rsum des files des utilisateurs")}
<p>
Les demandes utilisateurs suivantes sont actuellement en attente :
</p>
<table class="tableStnd sortable" border cellspacing="1" cellpadding="3" width="80%">
<tr class="tableheader"><td> Hte </td>
    <td> Action </td>
    <td> Temps Requis </td>
    <td> Utilisateur </td></tr>
\$strUser
</table>

\${h2("Rsum de la file en arrire plan")}
<p>
Les demandes en arrire plan suivantes sont actuellement en attente :
</p>
<table class="tableStnd sortable" border cellspacing="1" cellpadding="3" width="80%">
<tr class="tableheader"><td> Hte </td>
    <td> Action </td>
    <td> Temps requis </td>
    <td> Utilisateur </td></tr>
\$strBg
</table>
\${h2("Rsum de la file d\'attente des commandes")}
<p>
Les demandes de commande suivantes sont actuellement en attente :
</p>
<table class="tableStnd sortable" border cellspacing="1" cellpadding="3" width="80%">
<tr class="tableheader"><td> Htes </td>
    <td> Action </td>
    <td> Temps Requis </td>
    <td> Utilisateur </td>
    <td> Commande </td></tr>
\$strCmd
</table>
EOF

# --------------------------------
$Lang{Backup_PC__Log_File__file} = "BackupPC: Fichier \$file";
$Lang{Log_File__file__comment} = <<EOF;
\${h1("Fichier \$file \$comment")}
<p>
EOF
# --------------------------------
$Lang{Contents_of_log_file} = <<EOF;
Contenu du fichier <tt>\$file</tt>, modifi le \$mtimeStr \$comment
EOF

# --------------------------------
$Lang{skipped__skipped_lines} = "[ \$skipped lignes sautes ]\n";
# --------------------------------
$Lang{_pre___Can_t_open_log_file__file} = "<pre>\nNe peut pas ouvrir le fichier journal \$file\n";

# --------------------------------
$Lang{BackupPC__Log_File_History} = "BackupPC: Historique du fichier journal";
$Lang{Log_File_History__hdr} = <<EOF;
\${h1("Historique du fichier journal \$hdr")}
<p>
<table class="tableStnd sortable" border cellspacing="1" cellpadding="3" width="80%">
<tr class="tableheader"><td align="center"> Fichier </td>
    <td align="center"> Taille </td>
    <td align="center"> Date de modification </td></tr>
\$str
</table>
EOF

# -------------------------------
$Lang{Recent_Email_Summary} = <<EOF;
\${h1("Rsum des courriels rcents (du plus rcent au plus vieux)")}
<p>
<table class="tableStnd sortable" border cellspacing="1" cellpadding="3" width="80%">
<tr class="tableheader"><td align="center"> Destinataire </td>
    <td align="center"> Hte </td>
    <td align="center"> Date </td>
    <td align="center"> Sujet </td></tr>
\$str
</table>
EOF


# ------------------------------
$Lang{Browse_backup__num_for__host} = "BackupPC: Navigation dans la sauvegarde \$num de \$host";

# ------------------------------
$Lang{Restore_Options_for__host} = "BackupPC: Options de restauration sur \$host";
$Lang{Restore_Options_for__host2} = <<EOF;
\${h1("Options de restauration sur \$host")}
<p>
Vous avez slectionn les fichiers/rpertoires suivants depuis
le partage \$share, sauvegarde numro \$num:
<ul>
\$fileListStr
</ul>
</p><p>
Vous avez trois choix pour restaurer ces fichiers/rpertoires.
Veuillez slectionner une des options suivantes.
</p>
\${h2("Option 1: Restauration directe")}
<p>
EOF

$Lang{Restore_Options_for__host_Option1} = <<EOF;
Vous pouvez dmarrer une restauration de ces fichiers 
directement sur <b>\$directHost</b>.
</p><p>
<b>Attention:</b>
tous les fichiers correspondant  ceux que vous avez slectionns vont tre crass !
</p>
<form action="\$MyURL" method="post" name="direct">
<input type="hidden" name="host" value="\${EscHTML(\$host)}">
<input type="hidden" name="num" value="\$num">
<input type="hidden" name="type" value="3">
\$hiddenStr
<input type="hidden" value="\$In{action}" name="action">
<table class="tableStnd" border="0">
<tr>
    <td>Restaure les fichiers vers l'hte</td>
    <td><!--<input type="text" size="40" value="\${EscHTML(\$host)}"
	 name="hostDest">-->
	 <select name="hostDest" onChange="document.direct.shareDest.value=''">
	 \$hostDestSel
	 </select>
	 <script language="Javascript">
	 function myOpen(URL) {
		window.open(URL,'','width=500,height=400');
	}
	 </script>
	 <!--<a href="javascript:myOpen('\$MyURL?action=findShares&host='+document.direct.hostDest.options.value)">Chercher les partitions disponibles (NON IMPLANTE)</a>--></td>
</tr><tr>
    <td>Restaurer les fichiers vers le partage</td>
    <td><input type="text" size="40" value="\${EscHTML(\$share)}"
	 name="shareDest"></td>
</tr><tr>
    <td>Restaurer les fichiers du rpertoire<br>(relatif au partage)</td>
    <td valign="top"><input type="text" size="40" maxlength="256"
	value="\${EscHTML(\$pathHdr)}" name="pathHdr"></td>
</tr><tr>
    <td><input type="submit" value="Dmarrer la restauration" name="ignore"></td>
</table>
</form>
EOF

$Lang{Restore_Options_for__host_Option1_disabled} = <<EOF;
La restauration directe a t dsactive pour l'hte \${EscHTML(\$hostDest)}.
Veuillez choisir une autre option.
EOF

# ------------------------------
$Lang{Option_2__Download_Zip_archive} = <<EOF;
<p>
\${h2("Option 2: Tlcharger une archive Zip")}
<p>
Vous pouvez tlcharger une archive compresse (.zip) contenant tous les fichiers/rpertoires que vous 
avez slectionns. Vous pouvez utiliser une application locale, comme Winzip, pour voir ou extraire n\'importe quel fichier.
</p><p>
<b>Attention:</b> en fonction des fichiers/rpertoires que vous avez slectionns,
cette archive peut devenir trs trs volumineuse. Cela peut prendre plusieurs minutes pour crer
et transfrer cette archive, et vous aurez besoin d\'assez d\'espace disque pour la stocker.
</p>
<form action="\$MyURL" method="post">
<input type="hidden" name="host" value="\${EscHTML(\$host)}">
<input type="hidden" name="num" value="\$num">
<input type="hidden" name="type" value="2">
\$hiddenStr
<input type="hidden" value="\$In{action}" name="action">
<input type="checkbox" value="1" name="relative" checked> Faire l\'archive relative 
\${EscHTML(\$pathHdr eq "" ? "/" : \$pathHdr)}
(Autrement l\'archive contiendra les chemins complets).
<br>
<table class="tableStnd" border="0">
<tr>
    <td>Compression (0=dsactive, 1=rapide,...,9=meilleure)</td>
    <td><input type="text" size="6" value="5" name="compressLevel"></td>
</tr><tr>
    <td>Code page (e.g. cp866)</td>
    <td><input type="text" size="6" value="utf8" name="codePage"></td>
</tr>
</table>
<br>
<input type="submit" value="Tlcharger le fichier Zip" name="ignore">
</form>
EOF


# ------------------------------

$Lang{Option_2__Download_Zip_archive2} = <<EOF;
<p>
\${h2("Option 2: Tlcharger une archive Zip")}
<p>
Vous ne pouvez pas tlcharger d'archive zip, car Archive::Zip n\'est pas
install. 
Veuillez demander  votre administrateur systme d\'installer 
Archive::Zip depuis <a href="http://www.cpan.org">www.cpan.org</a>.
</p>
EOF


# ------------------------------
$Lang{Option_3__Download_Zip_archive} = <<EOF;
\${h2("Option 3: Tlcharger une archive tar")}
<p>
Vous pouvez tlcharger une archive Tar contenant tous les fichiers/rpertoires 
que vous avez slectionns. Vous pourrez alors utiliser une application locale, 
comme tar ou winzip pour voir ou extraire n\'importe quel fichier.
</p><p>
<b>Attention:</b> en fonction des fichiers/rpertoires que vous avez slectionns,
cette archive peut devenir trs trs volumineuse.  Cela peut prendre plusieurs minutes
pour crer et transfrer l\'archive, et vous aurez besoin d\'assez
d\'espace disque local pour la stocker.
</p>
<form action="\$MyURL" method="post">
<input type="hidden" name="host" value="\${EscHTML(\$host)}">
<input type="hidden" name="num" value="\$num">
<input type="hidden" name="type" value="1">
\$hiddenStr
<input type="hidden" value="\$In{action}" name="action">
<input type="checkbox" value="1" name="relative" checked> Faire l\'archive relative 
\${EscHTML(\$pathHdr eq "" ? "/" : \$pathHdr)}
(Autrement l\'archive contiendra des chemins absolus).
<br>
<input type="submit" value="Tlcharger le fichier Tar" name="ignore">
</form>
EOF


# ------------------------------
$Lang{Restore_Confirm_on__host} = "BackupPC: Confirmation de restauration sur \$host";

$Lang{Are_you_sure} = <<EOF;
\${h1("tes-vous sr ?")}
<p>
Vous tes sur le point de dmarrer une restauration directement sur 
la machine \$In{hostDest}. Les fichiers suivants vont tre restaurs 
dans le partage \$In{shareDest}, depuis la sauvegarde numro \$num:
<p>
<table class="tableStnd" border>
<tr class="tableheader"><td>Fichier/Rpertoire original</td><td>Va tre restaur </td></tr>
\$fileListStr
</table>

<form name="RestoreForm" action="\$MyURL" method="post">
<input type="hidden" name="host" value="\${EscHTML(\$host)}">
<input type="hidden" name="hostDest" value="\${EscHTML(\$In{hostDest})}">
<input type="hidden" name="shareDest" value="\${EscHTML(\$In{shareDest})}">
<input type="hidden" name="pathHdr" value="\${EscHTML(\$In{pathHdr})}">
<input type="hidden" name="num" value="\$num">
<input type="hidden" name="type" value="4">
<input type="hidden" name="action" value="">
\$hiddenStr
Voulez-vous vraiment le faire ?
<input type="button" value="\$Lang->{Restore}"
 onClick="document.RestoreForm.action.value='Restore';
          document.RestoreForm.submit();">
<input type="submit" value="No" name="ignore">
</form>
EOF

# --------------------------
$Lang{Restore_Requested_on__hostDest} = "BackupPC: Restauration demande sur \$hostDest";
$Lang{Reply_from_server_was___reply} = <<EOF;
\${h1(\$str)}
<p>
La rponse du serveur est : \$reply
<p>
Retourner  la page d\'accueil de <a href="\$MyURL?host=\$hostDest">\$hostDest </a>.
EOF

$Lang{BackupPC_Archive_Reply_from_server} = <<EOF;
\${h1(\$str)}
<p>
La rponse du serveur est : \$reply
EOF


# --------------------------------
$Lang{BackupPC__Delete_Backup_Confirm__num_of__host} = "BackupPC: Delete Backup Confirm #\$num of \$host";
# --------------------------------
$Lang{A_filled} = "a filled";
$Lang{An_unfilled} = "an unfilled";
$Lang{Are_you_sure_delete} = <<EOF;
\${h1("Are you sure?")}
<p>
You are about to delete \$filled \$type backup #\$num of \$host.

<form name="Confirm" action="\$MyURL" method="get">

<input type="hidden" name="host" value="\${EscHTML(\$host)}">
<input type="hidden" name="num" value="\$num">

<input type="hidden" name="doit" value="1">
<input type="hidden" name="action" value="">

Do you really want to do this?

<input type="button" value="\${EscHTML(\$Lang->{CfgEdit_Button_Delete})}"
 onClick="document.Confirm.action.value='deleteBackup';
          document.Confirm.submit();">

<input type="submit" value="No" name="ignore">
</form>
EOF

# -------------------------
$Lang{Host__host_Backup_Summary} = "BackupPC: Rsum de la sauvegarde de l\'hte \$host ";

$Lang{Host__host_Backup_Summary2} = <<EOF;
\${h1("Rsum de la sauvegarde de l\'hte \$host ")}
<p>
\$warnStr
<ul>
\$statusStr
</ul>
</p>
\${h2("Actions de l\'utilisateur")}
<p>
<form name="StartStopForm" action="\$MyURL" method="get">
<input type="hidden" name="host"   value="\$host">
<input type="hidden" name="action" value="">
\$startIncrStr
<input type="button" value="\$Lang->{Start_Full_Backup}"
 onClick="document.StartStopForm.action.value='Start_Full_Backup';
          document.StartStopForm.submit();">
<input type="button" value="\$Lang->{Stop_Dequeue_Backup}"
 onClick="document.StartStopForm.action.value='Stop_Dequeue_Backup';
          document.StartStopForm.submit();">
</form>
</p>
\${h2("Rsum de la sauvegarde")}
<p>
Cliquer sur le numro de l\'archive pour naviguer et restaurer les fichiers de sauvegarde.
</p>
<table class="tableStnd sortable" border cellspacing="1" cellpadding="3">
<tr class="tableheader"><td align="center"> Sauvegarde n </td>
    <td align="center"> Type </td>
    <td align="center"> Fusionne </td> 
    <td align="center"> Niveau </td>
    <td align="center"> Date de dmarrage </td>
    <td align="center"> Dure (min) </td>
    <td align="center"> ge (jours) </td>
    \$deleteHdrStr
    <td align="center"> Chemin d\'accs de la sauvegarde sur le serveur </td>
</tr>
\$str
</table>
<p>

\$restoreStr
</p>
\${h2("Rsum des erreurs de transfert")}
<table class="tableStnd sortable" border cellspacing="1" cellpadding="3" width="80%">
<tr class="tableheader"><td align="center"> Sauvegarde n </td>
    <td align="center"> Type </td>
    <td align="center"> Voir </td>
    <td align="center"> Nb erreurs transfert </td>
    <td align="center"> Nb mauvais fichiers </td>
    <td align="center"> Nb mauvais partages </td>
    <td align="center"> Nb erreurs tar </td>
</tr>
\$errStr
</table>

\${h2("Rcapitulatif de la taille des fichier et du nombre de rutilisations")}
<p>
Les fichiers existants sont ceux qui sont dj sur le serveur; 
Les nouveaux fichiers sont ceux qui ont t ajouts au serveur.
Les fichiers vides et les erreurs de SMB ne sont pas comptabiliss dans les fichiers nouveaux ou rutiliss.
</p>
<table class="tableStnd sortable" border cellspacing="1" cellpadding="3" width="80%">
<tr class="tableheader"><td colspan="2" bgcolor="#ffffff"></td>
    <td align="center" colspan="3"> Totaux </td>
    <td align="center" colspan="2"> Fichiers existants </td>
    <td align="center" colspan="2"> Nouveaux fichiers </td>
</tr>
<tr class="tableheader sortheader">
    <td align="center"> Sauvegarde n </td>
    <td align="center"> Type </td>
    <td align="center"> Nb de Fichiers </td>
    <td align="center"> Taille (Mo) </td>
    <td align="center"> Mo/s </td>
    <td align="center"> Nb de Fichiers </td>
    <td align="center"> Taille (Mo) </td>
    <td align="center"> Nb de Fichiers </td>
    <td align="center"> Taille (Mo) </td>
</tr>
\$sizeStr
</table>

\${h2("Rsum de la compression")}
<p>
Performance de la compression pour les fichiers dj sur le serveur et
rcemment compresss.
</p>
<table class="tableStnd sortable" border cellspacing="1" cellpadding="3" width="80%">
<tr class="tableheader"><td colspan="3" bgcolor="#ffffff"></td>
    <td align="center" colspan="3"> Fichiers existants </td>
    <td align="center" colspan="3"> Nouveaux fichiers </td>
</tr>
<tr class="tableheader sortheader"><td align="center"> Nb de sauvegardes </td>
    <td align="center"> Type </td>
    <td align="center"> Niveau de Compression </td>
    <td align="center"> Taille (Mo) </td>
    <td align="center"> Taille compresse (Mo) </td>
    <td align="center"> Compression </td>
    <td align="center"> Taille (Mo) </td>
    <td align="center"> Taille compresse (Mo) </td>
    <td align="center"> Compression </td>
</tr>
\$compStr
</table>
EOF

$Lang{Host__host_Archive_Summary} = "BackupPC: Rsum de l'archivage pour l'hte \$host";
$Lang{Host__host_Archive_Summary2} = <<EOF;
\${h1("Rsum de l\'archivage pour l\'hte \$host")}
<p>
\$warnStr
<ul>
\$statusStr
</ul>

\${h2("User Actions")}
<p>
<form name="StartStopForm" action="\$MyURL" method="get">
<input type="hidden" name="archivehost" value="\$host">
<input type="hidden" name="host" value="\$host">
<input type="hidden" name="action" value="">
<input type="button" value="\$Lang->{Start_Archive}"
 onClick="document.StartStopForm.action.value='Start_Archive';
          document.StartStopForm.submit();">
<input type="button" value="\$Lang->{Stop_Dequeue_Archive}"
 onClick="document.StartStopForm.action.value='Stop_Dequeue_Archive';
          document.StartStopForm.submit();">
</form>


\$ArchiveStr

EOF

# -------------------------
$Lang{Error} = "BackupPC: Erreur";
$Lang{Error____head} = <<EOF;
\${h1("Erreur: \$head")}
<p>\$mesg</p>
EOF

# -------------------------
$Lang{NavSectionTitle_} = "Serveur";

# -------------------------
$Lang{Backup_browse_for__host} = <<EOF;
\${h1("Navigation dans la sauvegarde de \$host")}

<script language="javascript" type="text/javascript">
<!--

    function checkAll(location)
    {
      for (var i=0;i<document.form1.elements.length;i++)
      {
        var e = document.form1.elements[i];
        if ((e.checked || !e.checked) && e.name != \'all\') {
            if (eval("document.form1."+location+".checked")) {
            	e.checked = true;
            } else {
            	e.checked = false;
            }
        }
      }
    }
    
    function toggleThis(checkbox)
    {
       var cb = eval("document.form1."+checkbox);
       cb.checked = !cb.checked;	
    }

//-->
</script>

<form name="form0" method="post" action="\$MyURL">
<input type="hidden" name="num" value="\$num">
<input type="hidden" name="host" value="\$host">
<input type="hidden" name="share" value="\${EscHTML(\$share)}">
<input type="hidden" name="action" value="browse">
<ul>
<li> Vous naviguez dans la sauvegarde n\$num, qui a commenc vers \$backupTime
        (il y a \$backupAge jours),
\$filledBackup
<li> Entrez le rpertoire: <input type="text" name="dir" size="50" maxlength="4096" value="\${EscHTML(\$dir)}"> <input type="submit" value="\$Lang->{Go}" name="Submit">
<li> Cliquer sur un rpertoire ci-dessous pour y naviguer,
<li> Cliquer sur un fichier ci-dessous pour le restaurer,
<li> Vous pouvez voir l'<a href="\$MyURL?action=dirHistory&host=\${EscURI(\$host)}&share=\$shareURI&dir=\$pathURI">historique</a> des diffrentes sauvegardes du rpertoire courant.
</ul>
</form>

\${h2("Contenu de \$dirDisplay")}
<form name="form1" method="post" action="\$MyURL">
<input type="hidden" name="num" value="\$num">
<input type="hidden" name="host" value="\$host">
<input type="hidden" name="share" value="\${EscHTML(\$share)}">
<input type="hidden" name="fcbMax" value="\$checkBoxCnt">
<input type="hidden" name="action" value="Restore">
<br>
<table width="100%">
<tr><td valign="top" width="30%">
    <table align="left" border="0" cellpadding="0" cellspacing="0" bgcolor="#ffffff">
    \$dirStr
    </table>
</td><td width="3%">
</td><td valign="top">
    <br>
        <table border width="100%" align="left" cellpadding="3" cellspacing="1">
        \$fileHeader
        \$topCheckAll
        \$fileStr
        \$checkAll
        </table>
    </td></tr></table>
<br>
<!--
This is now in the checkAll row
<input type="submit" name="Submit" value="Restore selected files">
-->
</form>
EOF

# ------------------------------
$Lang{DirHistory_backup_for__host} = "BackupPC: Historique des sauvegardes du rpertoire courant pour \$host";

#
# These two strings are used to build the links for directories and
# file versions.  Files are appended with a version number.
#
$Lang{DirHistory_dirLink}  = "rep";
$Lang{DirHistory_fileLink} = "v";

$Lang{DirHistory_for__host} = <<EOF;
\${h1("Historique des sauvegardes du rpertoire courant pour \$host")}
<p>
Cette page montre toutes les version disponibles des fichiers sauvegards pour le rpertoire courant :
<ul>
<li> Cliquez sur un numro de sauvegarde pour revenir  la navigation de sauvegarde,
<li> Cliquez sur un rpertoire (\$Lang->{DirHistory_dirLink}) pour naviguer
     dans celui-ci.
<li> Cliquez sur une version d'un fichier (\$Lang->{DirHistory_fileLink}0,
     \$Lang->{DirHistory_fileLink}1, ...) pour le tlcharger.
<li> Les fichiers avec des contenus identiques pour plusieurs sauvegardes ont 
     le mme numro de version (PleaseTranslateThis: except between v3 and v4 backups).
<li> Les fichiers qui ne sont pas prsents sur une sauvegarde en particulier 
     sont reprsents par une bote vide.
<li> Les fichiers montrs avec la mme version peuvent avoir des attributs diffrents. 
     Choisissez le numro de sauvegarde pour voir les attributs de fichiers.
</ul>

\${h2("Historique de \$dirDisplay")}

<br>
<table border cellspacing="2" cellpadding="3">
<tr class="fviewheader"><td>Numro de sauvegarde</td>\$backupNumStr</tr>
<tr class="fviewheader"><td>Date</td>\$backupTimeStr</tr>
\$fileStr
</table>
EOF

# ------------------------------
$Lang{Restore___num_details_for__host} = "BackupPC: Dtails de la restauration n\$num pour \$host"; 

$Lang{Restore___num_details_for__host2} = <<EOF;
\${h1("Dtails de la restauration n\$num pour \$host")} 
<p>
<table class="tableStnd" border cellspacing="1" cellpadding="3" width="90%">
<tr><td class="tableheader"> Numro </td><td class="border"> \$Restores[\$i]{num} </td></tr>
<tr><td class="tableheader"> Demande par </td><td class="border"> \$RestoreReq{user} </td></tr>
<tr><td class="tableheader"> Demande  </td><td class="border"> \$reqTime </td></tr>
<tr><td class="tableheader"> Rsultat </td><td class="border"> \$Restores[\$i]{result} </td></tr>
<tr><td class="tableheader"> Message d'erreur </td><td class="border"> \$Restores[\$i]{errorMsg} </td></tr>
<tr><td class="tableheader"> Hte source </td><td class="border"> \$RestoreReq{hostSrc} </td></tr>
<tr><td class="tableheader"> N de sauvegarde </td><td class="border"> \$RestoreReq{num} </td></tr>
<tr><td class="tableheader"> Partition source </td><td class="border"> \$RestoreReq{shareSrc} </td></tr>
<tr><td class="tableheader"> Hte de destination </td><td class="border"> \$RestoreReq{hostDest} </td></tr>
<tr><td class="tableheader"> Partition de destination </td><td class="border"> \$RestoreReq{shareDest} </td></tr>
<tr><td class="tableheader"> Dbut </td><td class="border"> \$startTime </td></tr>
<tr><td class="tableheader"> Dure </td><td class="border"> \$duration min </td></tr>
<tr><td class="tableheader"> Nombre de fichiers </td><td class="border"> \$Restores[\$i]{nFiles} </td></tr>
<tr><td class="tableheader"> Taille totale </td><td class="border"> \${MB} Mo </td></tr>
<tr><td class="tableheader"> Taux de transfert </td><td class="border"> \$MBperSec Mo/s </td></tr>
<tr><td class="tableheader"> Erreurs de TarCreate </td><td class="border"> \$Restores[\$i]{tarCreateErrs} </td></tr>
<tr><td class="tableheader"> Erreurs de transfert </td><td class="border"> \$Restores[\$i]{xferErrs} </td></tr>
<tr><td class="tableheader"> Journal de transfert </td><td class="border">
<a href="\$MyURL?action=view&type=RestoreLOG&num=\$Restores[\$i]{num}&host=\$host">Visionner</a>,
<a href="\$MyURL?action=view&type=RestoreErr&num=\$Restores[\$i]{num}&host=\$host">Erreurs</a>
</tr></tr>
</table>
</p>
\${h1("Liste des Fichiers/Rpertoires")}
<p>
<table class="tableStnd" border cellspacing="1" cellpadding="3" width="100%">
<tr class="tableheader"><td>Fichier/rpertoire original</td><td>Restaur vers</td></tr>
\$fileListStr
</table>
EOF

# ------------------------------
$Lang{Archive___num_details_for__host} = "BackupPC: Dtails de l'archivage n\$num pour \$host";

$Lang{Archive___num_details_for__host2 } = <<EOF;
\${h1("Dtails de l'archivage n\$num pour \$host")}
<p>
<table class="tableStnd" border cellspacing="1" cellpadding="3" width="80%">
<tr><td class="tableheader"> Numro </td><td class="border"> \$Archives[\$i]{num} </td></tr>
<tr><td class="tableheader"> Demand par </td><td class="border"> \$ArchiveReq{user} </td></tr>
<tr><td class="tableheader"> Heure de demande </td><td class="border"> \$reqTime </td></tr>
<tr><td class="tableheader"> Rsultat </td><td class="border"> \$Archives[\$i]{result} </td></tr>
<tr><td class="tableheader"> Message d'erreur </td><td class="border"> \$Archives[\$i]{errorMsg} </td></tr>
<tr><td class="tableheader"> Heure de dbut </td><td class="border"> \$startTime </td></tr>
<tr><td class="tableheader"> Dure </td><td class="border"> \$duration min </td></tr>
<tr><td class="tableheader"> Journal de transfert </td><td class="border">
<a href="\$MyURL?action=view&type=ArchiveLOG&num=\$Archives[\$i]{num}&host=\$host">Voir</a>,
<a href="\$MyURL?action=view&type=ArchiveErr&num=\$Archives[\$i]{num}&host=\$host">Erreurs</a>
</tr></tr>
</table>
<p>
\${h1("Liste de htes")}
<p>
<table class="tableStnd" border cellspacing="1" cellpadding="3" width="80%">
<tr class="tableheader"><td>Host</td><td>Numro de sauvegarde</td></tr>
\$HostListStr
</table>
EOF

# -----------------------------------
$Lang{Email_Summary} = "BackupPC: Rsum du courriel";

# -----------------------------------
#  !! ERROR messages !!
# -----------------------------------
$Lang{BackupPC__Lib__new_failed__check_apache_error_log} = "BackupPC::Lib->new a chou: regardez le fichier error_log d\'apache\n";
$Lang{Wrong_user__my_userid_is___} =  
              "Mauvais utilisateur: mon userid est \$>,  la place de \$uid "
              . "(\$Conf{BackupPCUser})\n";
#$Lang{Only_privileged_users_can_view_PC_summaries} = "Seuls les utilisateurs privilgis peuvent voir les rsums des machines.";
$Lang{Only_privileged_users_can_stop_or_start_backups} = 
                  "Seuls les utilisateurs privilgis peuvent arrter ou dmarrer des sauvegardes sur "
                  . " \${EscHTML(\$host)}.";
$Lang{Invalid_number__num} = "Numro invalide \${EscHTML(\$In{num})}";
$Lang{Unable_to_open__file__configuration_problem} = "Impossible d\'ouvrir \$file : problme de configuration ?";
$Lang{Only_privileged_users_can_view_log_or_config_files} = "Seuls les utilisateurs privilgis peuvent voir les fichiers de journal ou les fichiers de configuration.";
$Lang{Only_privileged_users_can_view_log_files} = "Seuls les utilisateurs privilgis peuvent voir les fichiers de journal.";
$Lang{Only_privileged_users_can_view_email_summaries} = "Seuls les utilisateurs privilgis peuvent voir les compte-rendus des courriels.";
$Lang{Only_privileged_users_can_browse_backup_files} = "Seuls les utilisateurs privilgis peuvent parcourir les fichiers de sauvegarde"
                 . " pour l'hte \${EscHTML(\$In{host})}.";
$Lang{Only_privileged_users_can_delete_backups} = "Only privileged users can delete backups"
                . " of host \${EscHTML(\$host)}.";
$Lang{Empty_host_name} = "Nom d\'hte vide.";
$Lang{Directory___EscHTML} = "Le rpertoire \${EscHTML(\"\$TopDir/pc/\$host/\$num\")}"
		    . " est vide";
$Lang{Can_t_browse_bad_directory_name2} = "Ne peut pas parcourir "
	            . " \${EscHTML(\$relDir)} : mauvais nom de rpertoire";
$Lang{Only_privileged_users_can_restore_backup_files} = "Seuls les utilisateurs privilgis peuvent restaurer "
                . " des fichiers de sauvegarde pour l\'hte \${EscHTML(\$In{host})}.";
$Lang{Bad_host_name} = "Mauvais nom d\'hte \${EscHTML(\$host)}";
$Lang{You_haven_t_selected_any_files__please_go_Back_to} = "Vous n\'avez slectionn aucun fichier ; "
    . "vous pouvez revenir en arrire pour slectionner des fichiers.";
$Lang{You_haven_t_selected_any_hosts} = "Vous n\'avez slectionn aucun hte ; veuillez retourner  la page prcdente pour"
                . " faire la slection d\'un hte.";
$Lang{Nice_try__but_you_can_t_put} = "Bien tent, mais vous ne pouvez pas mettre \'..\' dans un nom de fichier.";
$Lang{Host__doesn_t_exist} = "L'hte \${EscHTML(\$In{hostDest})} n\'existe pas.";
$Lang{You_don_t_have_permission_to_restore_onto_host} = "Vous n\'avez pas la permission de restaurer sur l\'hte"
		    . " \${EscHTML(\$In{hostDest})}";
$Lang{Can_t_open_create__openPath} = "Ne peut pas ouvrir/crer "
		. "\${EscHTML(\"\$openPath\")}";
$Lang{Only_privileged_users_can_restore_backup_files2} = "Seuls les utilisateurs privilgis peuvent restaurer"
                . " des fichiers de sauvegarde pour l\'hte \${EscHTML(\$host)}.";
$Lang{Empty_host_name} = "Nom d\'hte vide";
$Lang{Unknown_host_or_user} = "\${EscHTML(\$host)}, hte ou utilisateur inconnu.";
$Lang{Only_privileged_users_can_view_information_about} = "Seuls les utilisateurs privilgis peuvent accder aux "
                . " informations sur l\'hte \${EscHTML(\$host)}." ;
$Lang{Only_privileged_users_can_view_archive_information} = "Seuls les utilisateurs privilgis peuvent voir les informations d'archivage.";
$Lang{Only_privileged_users_can_view_restore_information} = "Seuls les utilisateurs privilgis peuvent restaurer des informations.";
$Lang{Restore_number__num_for_host__does_not_exist} = "La restauration numro \$num de l\'hte \${EscHTML(\$host)} n\'existe pas";

$Lang{Archive_number__num_for_host__does_not_exist} = "L\'archive n\$num pour l\'hte \${EscHTML(\$host)} n\'existe pas.";

$Lang{Can_t_find_IP_address_for} = "Ne peut pas trouver d\'adresse IP pour \${EscHTML(\$host)}";
$Lang{host_is_a_DHCP_host} = <<EOF;
L\'hte est un serveur DHCP, et je ne connais pas son adresse IP. J\'ai 
vrifi le nom netbios de \$ENV{REMOTE_ADDR}\$tryIP, et j\'ai trouv que 
cette machine n\'est pas \$host.
<p>
Tant que je ne verrai pas \$host  une adresse DHCP particulire, vous 
ne pourrez dmarrer cette requte que depuis la machine elle mme.
EOF

# ------------------------------------
# !! Server Mesg !!
# ------------------------------------

$Lang{Backup_requested_on_DHCP__host} = "Demande de sauvegarde sur l\'hte \$host (\$In{hostIP}) par"
		                      . " \$User depuis \$ENV{REMOTE_ADDR}";
$Lang{Backup_requested_on__host_by__User} = "Sauvegarde demande sur \$host par \$User";
$Lang{Backup_stopped_dequeued_on__host_by__User} = "Sauvegarde arrte/dprogramme pour \$host par \$User";
$Lang{Restore_requested_to_host__hostDest__backup___num} = "Restauration demande pour l\'hte \$hostDest, "
             . "sauvegarde n\$num, par \$User depuis \$ENV{REMOTE_ADDR}";
$Lang{Delete_requested_for_backup_of__host_by__User} = "Delete requested for backup #\$num of \$host"
             . " by \$User from \$ENV{REMOTE_ADDR}";
$Lang{Archive_requested} = "Archivage demand par \$User de \$ENV{REMOTE_ADDR}";

# -------------------------------------------------
# ------- Stuff that was forgotten ----------------
# -------------------------------------------------

$Lang{Status} = "tat";
$Lang{PC_Summary} = "Bilan des machines";
$Lang{LOG_file} = "Fichier journal";
$Lang{LOG_files} = "Fichiers journaux";
$Lang{Old_LOGs} = "Vieux journaux";
$Lang{Email_summary} = "Rsum des courriels";
$Lang{Config_file} = "Fichier de configuration";
# $Lang{Hosts_file} = "Fichiers des htes";
$Lang{Current_queues} = "Files actuelles";
$Lang{Documentation} = "Documentation";

#$Lang{Host_or_User_name} = "<small>Hte ou Nom d\'utilisateur:</small>";
$Lang{Go} = "Chercher";
$Lang{Hosts} = "Htes";
$Lang{Select_a_host} = "Choisissez un hte...";

$Lang{There_have_been_no_archives} = "<h2> Il n'y a pas d'archives </h2>\n";
$Lang{This_PC_has_never_been_backed_up} = "<h2> Cette machine n'a jamais t sauvegarde !! </h2>\n";
$Lang{This_PC_is_used_by} = "<li>Cette machine est utilise par \${UserLink(\$user)}";

$Lang{Extracting_only_Errors} = "(Extraction des erreurs seulement)";
$Lang{XferLOG} = "JournalXfer";
$Lang{Errors}  = "Erreurs";

# ------------
$Lang{Last_email_sent_to__was_at___subject} = <<EOF;
<li>Le dernier courriel envoy  \${UserLink(\$user)} le \$mailTime, avait comme sujet "\$subj".
EOF
# ------------
$Lang{The_command_cmd_is_currently_running_for_started} = <<EOF;
<li>La commande \$cmd s\'excute actuellement sur \$host, dmarre le \$startTime.
EOF

# -----------
$Lang{Host_host_is_queued_on_the_background_queue_will_be_backed_up_soon} = <<EOF;
<li>L\'hte \$host se trouve dans la liste d\'attente d\'arrire plan (il sera sauvegard bientt).
EOF

# ----------
$Lang{Host_host_is_queued_on_the_user_queue__will_be_backed_up_soon} = <<EOF;
<li>L\'hte \$host se trouve dans la liste d\'attente utilisateur (il sera sauvegard bientt).
EOF

# ---------
$Lang{A_command_for_host_is_on_the_command_queue_will_run_soon} = <<EOF;
<li>Une commande pour l\'hte \$host est dans la liste d\'attente des commandes (sera lance bientt).
EOF

# --------
$Lang{Last_status_is_state_StatusHost_state_reason_as_of_startTime} = <<EOF;
<li>L\'tat courant est \"\$Lang->{\$StatusHost{state}}\"\$reason depuis \$startTime.
EOF

# --------
$Lang{Last_error_is____EscHTML_StatusHost_error} = <<EOF;
<li>La dernire erreur est \"\${EscHTML(\$StatusHost{error})}\".
EOF

# ------
$Lang{Pings_to_host_have_failed_StatusHost_deadCnt__consecutive_times} = <<EOF;
<li>Les pings vers \$host ont chou \$StatusHost{deadCnt} fois conscutives.
EOF

# -----
$Lang{Prior_to_that__pings} = "Avant cela, les pings";

# -----
$Lang{priorStr_to_host_have_succeeded_StatusHostaliveCnt_consecutive_times} = <<EOF;
<li>Les \$priorStr vers \$host ont russi \$StatusHost{aliveCnt} 
            fois conscutives.
EOF

$Lang{Because__host_has_been_on_the_network_at_least__Conf_BlackoutGoodCnt_consecutive_times___} = <<EOF;
<li>\$host a t prsent sur le rseau au moins \$Conf{BlackoutGoodCnt}
fois conscutives, il ne sera donc pas sauvegard de \$blackoutStr.
EOF

$Lang{__time0_to__time1_on__days} = "\$t0  \$t1 pendant \$days";

$Lang{Backups_are_deferred_for_hours_hours_change_this_number} = <<EOF;
<li>Les sauvegardes sont reportes pour \$hours heures
(<a href=\"\$MyURL?action=Stop_Dequeue_Backup&host=\$host\">changer ce nombre</a>).
EOF

$Lang{tryIP} = " et \$StatusHost{dhcpHostIP}";

# $Lang{Host_Inhost} = "Hte \$In{host}";

$Lang{checkAll} = <<EOF;
<tr><td class="fviewborder">
<input type="checkbox" name="allFiles" onClick="return checkAll('allFiles');">&nbsp;Tout slectionner
</td><td colspan="5" align="center" class="fviewborder">
<input type="submit" name="Submit" value="Restaurer les fichiers slectionns">
</td></tr>
EOF

$Lang{checkAllHosts} = <<EOF;
<tr><td class="fviewborder">
<input type="checkbox" name="allFiles" onClick="return checkAll('allFiles');">&nbsp;Tout slectionner
</td><td colspan="2" align="center" class="fviewborder">
<input type="submit" name="Submit" value="Archiver les machines slectionnes">
</td></tr>
EOF

$Lang{fileHeader} = <<EOF;
    <tr class="fviewheader"><td align=center> Nom</td>
       <td align="center"> Type</td>
       <td align="center"> Mode</td>
       <td align="center"> n</td>
       <td align="center"> Taille</td>
       <td align="center"> Date de modification</td>
    </tr>
EOF

$Lang{Home} = "Accueil";
$Lang{Browse} = "Explorer les sauvegardes";
$Lang{Last_bad_XferLOG} = "Bilan des derniers transferts chous";
$Lang{Last_bad_XferLOG_errors_only} = "Bilan des derniers transferts chous (erreurs seulement)";

$Lang{This_display_is_merged_with_backup} = <<EOF;
<li> Cet affichage est fusionn avec la sauvegarde n\$numF, la plus rcente copie intgrale.
EOF

$Lang{Visit_this_directory_in_backup} = <<EOF;
<li> Choisissez la sauvegarde que vous dsirez voir : <select onChange="window.location=this.value">\$otherDirs </select>
EOF

$Lang{Restore_Summary} = <<EOF;
\${h2("Rsum de la restauration")}
<p>
Cliquer sur le numro de restauration pour plus de dtails.
<table class="tableStnd sortable" border cellspacing="1" cellpadding="3" width="80%">
<tr class="tableheader"><td align="center"> Sauvegarde n </td>
    <td align="center"> Rsultat </td>
    <td align="right"> Date de dpart</td>
    <td align="right"> Dure (min)</td>
    <td align="right"> Nb fichiers </td>
    <td align="right"> Taille (Mo) </td>
    <td align="right"> Nb errs tar </td>
    <td align="right"> Nb errs trans </td>
</tr>
\$restoreStr
</table>
<p>
EOF

$Lang{Archive_Summary} = <<EOF;
\${h2("Rsum de l'archive")}
<p>
Cliquez sur le numro de l'archive pour plus de dtails.
<table class="tableStnd" border cellspacing="1" cellpadding="3" width="80%">
<tr class="tableheader"><td align="center"> No. Archive </td>
    <td align="center">Rsultat</td>
    <td align="right">Date dbut</td>
    <td align="right">Dure (min)</td>
</tr>
\$ArchiveStr
</table>
<p>
EOF

$Lang{BackupPC__Documentation} = "BackupPC: Documentation";

$Lang{No} = "non";
$Lang{Yes} = "oui";

$Lang{The_directory_is_empty} = <<EOF;
<tr><td bgcolor="#ffffff">Le rpertoire \$dirDisplay est vide
</td></tr>
EOF

#$Lang{on} = "actif";
$Lang{off} = "inactif";

$Lang{backupType_full}    = "complte";
$Lang{backupType_incr}    = "incrmentielle";
$Lang{backupType_active}  = "active";
$Lang{backupType_partial} = "partielle";

$Lang{failed} = "chec";
$Lang{success} = "succs";
$Lang{and} = "et";

# ------
# Hosts states and reasons
$Lang{Status_idle} = "inactif";
$Lang{Status_backup_starting} = "dbut de la sauvegarde";
$Lang{Status_backup_in_progress} = "sauvegarde en cours";
$Lang{Status_restore_starting} = "dbut de la restauration";
$Lang{Status_restore_in_progress} = "restauration en cours";
$Lang{Status_admin_pending} = "en attente de l'dition de liens";
$Lang{Status_admin_running} = "dition de liens en cours";

$Lang{Reason_backup_done}    = "sauvegarde termine";
$Lang{Reason_restore_done}   = "restauration termine";
$Lang{Reason_archive_done}   = "archivage termin";
$Lang{Reason_nothing_to_do}  = "rien  faire";
$Lang{Reason_backup_failed}  = "la sauvegarde a chou";
$Lang{Reason_restore_failed} = "la restauration a chou";
$Lang{Reason_archive_failed} = "l'archivage a chou";
$Lang{Reason_no_ping}        = "pas de ping";
$Lang{Reason_backup_canceled_by_user}  = "sauvegarde annule par l'utilisateur";
$Lang{Reason_restore_canceled_by_user} = "restauration annule par l'utilisateur";
$Lang{Reason_archive_canceled_by_user} = "archivage annul par l'utilisateur";
$Lang{Disabled_OnlyManualBackups}  = "auto dsactiv";  
$Lang{Disabled_AllBackupsDisabled} = "dsactiv";                  

# ---------
# Email messages

# No backup ever
$Lang{EMailNoBackupEverSubj} = "BackupPC: aucune sauvegarde de \$host n'a russi";
$Lang{EMailNoBackupEverMesg} = <<'EOF';
To: $user$domain
cc:
Subject: $subj
$headers
$userName,

Notre logiciel de copies de scurit n'a jamais russi 
effectuer la sauvegarde de votre ordinateur ($host). Les sauvegardes
devraient normalement survenir lorsque votre ordinateur est connect
au rseau. Vous devriez contacter le responsable informatique si :

  - Votre ordinateur est rgulirement connect au rseau, ce qui
    signifie qu'il y aurait un problme de configuration
    empchant les sauvegardes de s'effectuer.

  - Vous ne voulez pas qu'il y ait de sauvegardes de
    votre ordinateur ni ne voulez recevoir d'autres messages
    comme celui-ci.

Dans le cas contraire, veuillez vous assurer ds que possible que votre 
ordinateur est correctement connect au rseau.

Merci de votre attention,
BackupPC Gnie
https://backuppc.github.io/backuppc
EOF

# No recent backup
$Lang{EMailNoBackupRecentSubj} = "BackupPC: aucune sauvegarde rcente de \$host";
$Lang{EMailNoBackupRecentMesg} = <<'EOF';
To: $user$domain
cc:
Subject: $subj
$headers
$userName,

Aucune sauvegarde de votre ordinateur n'a t effectue depuis $days
jours. $numBackups sauvegardes ont ts effectues du $firstTime
jusqu' il y a $days jours. Les sauvegardes devraient normalement
survenir lorsque votre ordinateur est connect au rseau.

Si votre ordinateur a effectivement t connect au rseau plus de 
quelques heures durant les derniers $days jours, vous devriez 
contacter votre responsable informatique pour savoir pourquoi les 
sauvegardes ne s'effectuent pas correctement.

Autrement, si vous tes en dehors du bureau, il n'y a pas d'autre
chose que vous pouvez faire,  part faire des copies de vos fichiers
importants sur d'autres medias. Vous devez raliser que tout fichier cre
ou modifi durant les $days derniers jours (incluant les courriels et
les fichiers attachs) ne pourra pas tre restaur si un problme survient
avec votre ordinateur.

Merci de votre attention,
BackupPC Gnie
https://backuppc.github.io/backuppc
EOF

# Old Outlook files
$Lang{EMailOutlookBackupSubj} = "BackupPC: Les fichiers de Outlook sur \$host doivent tre sauvegards";
$Lang{EMailOutlookBackupMesg} = <<'EOF';
To: $user$domain
cc:
Subject: $subj
$headers
$userName,

Les fichiers Outlook sur votre ordinateur n'ont $howLong. Ces fichiers
contiennent tous vos courriels, fichiers attachs, carnets d'adresses et
calendriers. $numBackups sauvegardes ont ts effectues du $firstTime
au $lastTime.  Par contre, Outlook bloque ses fichiers lorsqu'il est
ouvert, ce qui empche de les sauvegarder.

Il est recommand d'effectuer une sauvegarde de vos fichiers Outlook
quand vous serez connect au rseau en quittant Outlook et toute autre
application, et en visitant ce lien avec votre navigateur web:

    $CgiURL?host=$host               

Choisissez "Dmarrer la sauvegarde incrmentielle" deux fois afin
d'effectuer une nouvelle sauvegarde. Vous pouvez ensuite choisir
"Retourner  la page de $host" et appuyer sur "Recharger" dans votre
navigateur avec de vrifier le bon fonctionnement de la sauvegarde. La
sauvegarde devrait prendre quelques minutes  s'effectuer.

Merci de votre attention,
BackupPC Gnie
https://backuppc.github.io/backuppc
EOF

$Lang{howLong_not_been_backed_up} = "jamais t sauvegards";
$Lang{howLong_not_been_backed_up_for_days_days} = "pas t sauvegards depuis \$days jours";

#######################################################################
# RSS strings
#######################################################################
$Lang{RSS_Doc_Title}       = "BackupPC Server";
$Lang{RSS_Doc_Description} = "RSS feed for BackupPC";
$Lang{RSS_Host_Summary}    = <<EOF;
Nb compltes : \$fullCnt;
Compltes ge (jours) : \$fullAge;
Compltes Taille (Go) : \$fullSize;
Vitesse (Mo/s) : \$fullRate;
Nb incrmentielles : \$incrCnt;
Incrmentielles ge (jours) : \$incrAge;
tat actuel : \$host_state;
Dsactive: \$host_disabled;
Dernire tentative : \$host_last_attempt;
EOF

#######################################################################
# Configuration editor strings
#######################################################################

$Lang{Only_privileged_users_can_edit_config_files} = "Seuls les utilisateurs privilgis peuvent modifier les paramtres de configuration.";
$Lang{CfgEdit_Edit_Config} = "Modifier la configuration";
$Lang{CfgEdit_Edit_Hosts}  = "Modifier les machines";

$Lang{CfgEdit_Title_Server} = "Serveur";
$Lang{CfgEdit_Title_General_Parameters} = "Paramtres gnraux";
$Lang{CfgEdit_Title_Wakeup_Schedule} = "Horaire des rveils";
$Lang{CfgEdit_Title_Concurrent_Jobs} = "Tches concurrentes";
$Lang{CfgEdit_Title_Pool_Filesystem_Limits} = "Limites du systme de fichiers";
$Lang{CfgEdit_Title_Other_Parameters} = "Autres paramtres";
$Lang{CfgEdit_Title_Remote_Apache_Settings} = "Options d'Apache  distance";
$Lang{CfgEdit_Title_Program_Paths} = "Chemins des programmes";
$Lang{CfgEdit_Title_Install_Paths} = "Chemins d'installation";
$Lang{CfgEdit_Title_Email} = "Courriel";
$Lang{CfgEdit_Title_Email_settings} = "Paramtres de courriel";
$Lang{CfgEdit_Title_Email_User_Messages} = "Messages des usagers par courriel";
$Lang{CfgEdit_Title_CGI} = "CGI";
$Lang{CfgEdit_Title_Admin_Privileges} = "Privilges administrateur";
$Lang{CfgEdit_Title_Page_Rendering} = "Rendu des pages";
$Lang{CfgEdit_Title_Paths} = "Chemins";
$Lang{CfgEdit_Title_User_URLs} = "URL des usagers";
$Lang{CfgEdit_Title_User_Config_Editing} = "Modifications des configurations des usagers";
$Lang{CfgEdit_Title_Xfer} = "Xfer";
$Lang{CfgEdit_Title_Xfer_Settings} = "Paramtres des transfers";
$Lang{CfgEdit_Title_Ftp_Settings} = "Paramtres de FTP";
$Lang{CfgEdit_Title_Smb_Settings} = "Paramtres de Smb";
$Lang{CfgEdit_Title_Tar_Settings} = "Paramtres de Tar";
$Lang{CfgEdit_Title_Rsync_Settings} = "Paramtres de Rsync";
$Lang{CfgEdit_Title_Rsyncd_Settings} = "Paramtres de Rsyncd";
$Lang{CfgEdit_Title_Archive_Settings} = "Paramtres d'archivage";
$Lang{CfgEdit_Title_Include_Exclude} = "Inclure/Exclure";
$Lang{CfgEdit_Title_Smb_Paths_Commands} = "Chemins/Commandes Smb";
$Lang{CfgEdit_Title_Tar_Paths_Commands} = "Chemins/Commandes Tar";
$Lang{CfgEdit_Title_Rsync_Paths_Commands_Args} = "Chemins/Commandes/Args Rsync";
$Lang{CfgEdit_Title_Rsyncd_Port_Args} = "Port/Args Rsyncd";
$Lang{CfgEdit_Title_Archive_Paths_Commands} = "Chemins/Commandes d'archivage";
$Lang{CfgEdit_Title_Schedule} = "Horaire";
$Lang{CfgEdit_Title_Full_Backups} = "Sauvegardes compltes";
$Lang{CfgEdit_Title_Incremental_Backups} = "Sauvegardes incrmentielles";
$Lang{CfgEdit_Title_Blackouts} = "Suspension";
$Lang{CfgEdit_Title_Other} = "Divers";
$Lang{CfgEdit_Title_Backup_Settings} = "Paramtres de sauvegarde";
$Lang{CfgEdit_Title_Client_Lookup} = "Consultation des clients";
$Lang{CfgEdit_Title_User_Commands} = "Commandes des usagers";
$Lang{CfgEdit_Title_Hosts} = "Machines";

$Lang{CfgEdit_Hosts_Comment} = <<EOF;
Pour ajouter une machine, choisissez Ajouter et entrez ensuite le nom. Pour faire
une copie de la configuration d'une autre machine, entrer le nom de la machine
comme NOUVEAU=ACOPIER. Cela va craser toute configuration par dfaut pour
cette machine. Vous pouvez aussi faire cela pour une machine existante.
Pour dtruire une machine, cliquer sur le bouton Dtruire. Les ajouts, 
destructions et modifications ne prennent effet que lorsque que vous cliquez 
sur le bouton Sauvegarder. Aucune des sauvegardes des machines ne sera
dtruite, donc si vous effacez une machine par erreur, crez-la  nouveau. Pour
dtruire les sauvegardes d'une machine, vous devez effacer les fichiers 
manuellement dans \$topDir/pc/HOST
EOF

$Lang{CfgEdit_Header_Main} = <<EOF;
\${h1("diteur de configuration")}
EOF

$Lang{CfgEdit_Header_Host} = <<EOF;
\${h1("diteur de la configuration de \$host")}
<p>
Note: Cochez craser pour modifier une valeur spcifique  cette machine.
<p>
EOF

$Lang{CfgEdit_Button_Save}     = "Sauvegarder";
$Lang{CfgEdit_Button_Insert}   = "Insrer";
$Lang{CfgEdit_Button_Delete}   = "Dtruire";
$Lang{CfgEdit_Button_Add}      = "Ajouter";
$Lang{CfgEdit_Button_Override} = "craser";
$Lang{CfgEdit_Button_New_Key}  = "Nouvelle cl";
$Lang{CfgEdit_Button_New_Share} = "New ShareName or '*'";

$Lang{CfgEdit_Error_No_Save}
            = "Erreur: Pas de sauvegarde  cause d'erreurs.";
$Lang{CfgEdit_Error__must_be_an_integer}
            = "Erreur: \$var doit tre un nombre entier";
$Lang{CfgEdit_Error__must_be_real_valued_number}
            = "Erreur: \$var doit tre un nombre rel";
$Lang{CfgEdit_Error__entry__must_be_an_integer}
            = "Erreur: l'entre \$k de \$var doit tre un nombre entier";
$Lang{CfgEdit_Error__entry__must_be_real_valued_number}
            = "Erreur: l'entre \$k de \$var doit tre un nombre rel";
$Lang{CfgEdit_Error__must_be_executable_program}
            = "Erreur: \$var doit tre un chemin excutable";
$Lang{CfgEdit_Error__must_be_valid_option}
            = "Erreur: \$var doit tre une option valide";
$Lang{CfgEdit_Error_Copy_host_does_not_exist}
            = "La machine \$copyHost ne peut tre copie, car elle n'existe pas ; cration d'une machine nomme \$fullHost.  Dtruisez cette machine si ce n'est pas ce que vous vouliez.";

$Lang{CfgEdit_Log_Copy_host_config}
            = "\$User a copi la config de \$fromHost  \$host\n";
$Lang{CfgEdit_Log_Delete_param}
            = "\$User a dtruit \$p de \$conf\n";
$Lang{CfgEdit_Log_Add_param_value}
            = "\$User a ajout \$p  \$conf en fixant sa valeur  \$value\n";
$Lang{CfgEdit_Log_Change_param_value}
            = "\$User a chang \$p dans \$conf de \$valueOld  \$valueNew\n";
$Lang{CfgEdit_Log_Host_Delete}
            = "\$User a dtruit la machine \$host\n";
$Lang{CfgEdit_Log_Host_Change}
            = "\$User a chang \$key de \$valueOld  \$valueNew sur \$host\n";
$Lang{CfgEdit_Log_Host_Add}
            = "\$User a jout la machine \$host: \$value\n";
  
#end of lang_fr.pm
