/*
 * Decompiled with CFR 0.152.
 */
package plugins.map;

import accessories.plugins.time.TableSorter;
import freemind.common.TextTranslator;
import freemind.controller.MapModuleManager;
import freemind.controller.actions.generated.instance.MapLocationStorage;
import freemind.controller.actions.generated.instance.MapWindowConfigurationStorage;
import freemind.controller.actions.generated.instance.Place;
import freemind.controller.actions.generated.instance.TableColumnSetting;
import freemind.controller.actions.generated.instance.WindowConfigurationStorage;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.MindMapNode;
import freemind.modes.Mode;
import freemind.modes.ModeController;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.hooks.MindMapHookAdapter;
import freemind.view.MapModule;
import freemind.view.mindmapview.NodeView;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.OsmMercator;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.events.JMVCommandEvent;
import org.openstreetmap.gui.jmapviewer.interfaces.JMapViewerEventListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;
import plugins.map.FreeMindMapController;
import plugins.map.JCursorMapViewer;
import plugins.map.MapMarkerLocation;
import plugins.map.MapNodePositionHolder;
import plugins.map.MapSearchMarkerLocation;
import plugins.map.Registration;

public class MapDialog
extends MindMapHookAdapter
implements JMapViewerEventListener,
MapModuleManager.MapModuleChangeObserver,
MapNodePositionHolder.MapNodePositionListener,
ModeController.NodeSelectionListener,
Registration.NodeVisibilityListener {
    private static final String WINDOW_PREFERENCE_STORAGE_PROPERTY = MapDialog.class.getName();
    static final String TILE_CACHE_CLASS = "tile_cache_class";
    static final String FILE_TILE_CACHE_DIRECTORY = "file_tile_cache_directory";
    public static final String TILE_CACHE_MAX_AGE = "tile_cache_max_age";
    private static final int SEARCH_DESCRIPTION_COLUMN = 0;
    public static final int SEARCH_DISTANCE_COLUMN = 1;
    private JCursorMapViewer map = null;
    private JLabel zoomValue = null;
    private JLabel mperpLabelValue = null;
    private MindMapController mMyMindMapController;
    private JDialog mMapDialog;
    private HashMap mMarkerMap = new HashMap();
    private CloseAction mCloseAction;
    private JPanel mSearchFieldPanel;
    private JSplitPane mSearchSplitPane;
    private boolean mSearchBarVisible;
    private JPanel mSearchPanel;
    private JTextField mSearchTerm;
    static final String MAP_HOOK_NAME = "plugins/map/MapDialog.properties";
    public static final String TILE_CACHE_PURGE_TIME = "tile_cache_purge_time";
    public static final long TILE_CACHE_PURGE_TIME_DEFAULT = 600000L;
    private static final String SEARCH_DESCRIPTION_COLUMN_TEXT = "plugins/map/MapDialog.Description";
    private static final String SEARCH_DISTANCE_COLUMN_TEXT = "plugins/map/MapDialog.Distance";
    private JLabel mStatusLabel;
    private boolean mSingleSearch = false;
    private JTable mResultTable;
    private ResultTableModel mResultTableModel;
    private TableSorter mResultTableSorter;
    private Color mTableOriginalBackgroundColor;
    private int mLastDividerPosition = 300;
    private boolean mLimitSearchToRegion = false;
    private JLabel mSearchStringLabel;
    private String mResourceSearchLocationString;
    private String mResourceSearchString;

    public void startupMapHook() {
        super.startupMapHook();
        this.mMyMindMapController = super.getMindMapController();
        this.getMindMapController().getController().getMapModuleManager().addListener((MapModuleManager.MapModuleChangeObserver)this);
        this.mMapDialog = new JDialog((Frame)this.getController().getFrame().getJFrame(), false);
        this.mMapDialog.setTitle(this.getResourceString("MapDialog_title"));
        this.mMapDialog.setDefaultCloseOperation(0);
        this.mMapDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                MapDialog.this.disposeDialog();
            }
        });
        this.mCloseAction = new CloseAction();
        Tools.addEscapeActionToDialog((JDialog)this.mMapDialog, (Action)new CloseAction());
        this.mMapDialog.setSize(400, 400);
        this.map = new JCursorMapViewer(this.getMindMapController(), this.mMapDialog, this.getRegistration().getTileCache(), this);
        this.map.addJMVListener(this);
        this.map.setScrollWrapEnabled(true);
        FreeMindMapController.changeTileSource(OsmTileSource.Mapnik.class.getName(), this.map);
        OsmTileLoader loader = this.getRegistration().createTileLoader((TileLoaderListener)this.map);
        this.map.setTileLoader((TileLoader)loader);
        this.map.setCursorPosition(new Coordinate(49.8, 8.8));
        this.map.setUseCursor(true);
        this.mMapDialog.setLayout(new BorderLayout());
        this.mSearchPanel = new JPanel(new BorderLayout());
        this.mResourceSearchString = this.getResourceString("MapDialog_Search");
        this.mResourceSearchLocationString = this.getResourceString("MapDialog_Search_Location");
        this.mSearchStringLabel = new JLabel(this.mResourceSearchString);
        this.mSearchTerm = new JTextField();
        this.mSearchTerm.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent pEvent) {
                if (pEvent.getKeyCode() == 40 && pEvent.getModifiers() == 0) {
                    MapDialog.this.logger.info("Set Focus to search list.");
                    MapDialog.this.mResultTable.requestFocusInWindow();
                    MapDialog.this.mResultTable.getSelectionModel().setSelectionInterval(0, 0);
                    pEvent.consume();
                }
            }
        });
        this.mSearchFieldPanel = new JPanel();
        this.mSearchFieldPanel.setLayout(new BorderLayout(10, 0));
        JButton clearButton = new JButton(new ImageIcon(Resources.getInstance().getResource("images/clear_box.png")));
        clearButton.setFocusable(false);
        this.mSearchFieldPanel.add((Component)this.mSearchStringLabel, "West");
        this.mSearchFieldPanel.add((Component)this.mSearchTerm, "Center");
        this.mSearchFieldPanel.add((Component)clearButton, "East");
        this.mResultTable = new JTable();
        this.mTableOriginalBackgroundColor = this.mResultTable.getBackground();
        this.mResultTable.setSelectionMode(2);
        this.mResultTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent pEvent) {
                int index = MapDialog.this.mResultTable.getSelectedRow();
                if (index == 0 && pEvent.getKeyCode() == 38 && pEvent.getModifiers() == 0) {
                    MapDialog.this.logger.info("Set Focus to search item.");
                    MapDialog.this.mResultTable.clearSelection();
                    MapDialog.this.mSearchTerm.requestFocusInWindow();
                    pEvent.consume();
                    return;
                }
                if (pEvent.getKeyCode() == 10 && pEvent.getModifiers() == 0 && index >= 0) {
                    MapDialog.this.logger.info("Set result in map.");
                    pEvent.consume();
                    MapDialog.this.displaySearchItem(index);
                    return;
                }
                if (pEvent.getKeyCode() == 10 && pEvent.isControlDown() && index >= 0) {
                    pEvent.consume();
                    MapDialog.this.addSearchResultsToMap();
                    MapDialog.this.displaySearchItem(index);
                    return;
                }
            }
        });
        this.mResultTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent pE) {
                this.clearIndexes();
                int selectedRow = MapDialog.this.mResultTable.getSelectedRow();
                if (selectedRow >= 0 && selectedRow < MapDialog.this.mResultTableSorter.getRowCount()) {
                    int index = selectedRow;
                    index = MapDialog.this.mResultTableSorter.modelIndex(index);
                    MapSearchMarkerLocation marker = MapDialog.this.mResultTableModel.getMapSearchMarkerLocation(index);
                    marker.setSelected(true);
                }
                MapDialog.this.mResultTable.repaint();
                MapDialog.this.getMap().repaint();
            }

            private void clearIndexes() {
                for (int i = 0; i < MapDialog.this.mResultTableModel.getRowCount(); ++i) {
                    MapSearchMarkerLocation marker = MapDialog.this.mResultTableModel.getMapSearchMarkerLocation(i);
                    marker.setSelected(false);
                }
            }
        });
        this.mResultTable.getTableHeader().setReorderingAllowed(false);
        this.mResultTableModel = new ResultTableModel(this.getMap().getCursorPosition(), (TextTranslator)this.getMindMapController());
        this.getFreeMindMapController().addCursorPositionListener(this.mResultTableModel);
        this.mResultTableSorter = new TableSorter((TableModel)this.mResultTableModel);
        this.mResultTable.setModel((TableModel)this.mResultTableSorter);
        this.mResultTableSorter.setTableHeader(this.mResultTable.getTableHeader());
        this.mResultTableSorter.setColumnComparator(String.class, TableSorter.LEXICAL_COMPARATOR);
        this.mResultTableSorter.setColumnComparator(Double.class, TableSorter.COMPARABLE_COMAPRATOR);
        this.mResultTableSorter.setSortingStatus(1, 1);
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent pE) {
                MapDialog.this.mResultTableModel.clear();
                MapDialog.this.mSearchTerm.setText("");
                MapDialog.this.mResultTable.setBackground(MapDialog.this.mTableOriginalBackgroundColor);
            }
        });
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int index = MapDialog.this.mResultTable.getSelectedRow();
                    MapDialog.this.displaySearchItem(index);
                }
            }
        };
        this.mResultTable.addMouseListener(mouseListener);
        this.mSearchTerm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent pE) {
                MapDialog.this.search(MapDialog.this.mSearchTerm.getText(), false);
            }
        });
        JScrollPane resultTableScrollPane = new JScrollPane(this.mResultTable);
        this.mSearchPanel.setLayout(new BorderLayout());
        this.mSearchPanel.add((Component)this.mSearchFieldPanel, "North");
        this.mSearchPanel.add((Component)resultTableScrollPane, "Center");
        this.mSearchBarVisible = true;
        this.mSearchSplitPane = new JSplitPane(0, this.mSearchPanel, (Component)((Object)this.map));
        this.mSearchSplitPane.setContinuousLayout(true);
        this.mSearchSplitPane.setOneTouchExpandable(false);
        Tools.correctJSplitPaneKeyMap();
        this.mSearchSplitPane.setResizeWeight(0.0);
        this.mSearchSplitPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pEvt) {
                int dividerLocation = MapDialog.this.mSearchSplitPane.getDividerLocation();
                if (dividerLocation > 1) {
                    MapDialog.this.mLastDividerPosition = dividerLocation;
                    MapDialog.this.logger.info("Setting last divider to " + MapDialog.this.mLastDividerPosition);
                }
            }
        });
        this.mMapDialog.add((Component)this.mSearchSplitPane, "Center");
        this.mStatusLabel = new JLabel(" ");
        this.mMapDialog.add((Component)this.mStatusLabel, "South");
        this.getRegistration().registerMapNodePositionListener(this);
        this.getRegistration().registerNodeVisibilityListener(this);
        this.getMindMapController().registerNodeSelectionListener((ModeController.NodeSelectionListener)this, true);
        this.mMapDialog.validate();
        MapWindowConfigurationStorage storage = (MapWindowConfigurationStorage)this.getMindMapController().decorateDialog(this.mMapDialog, WINDOW_PREFERENCE_STORAGE_PROPERTY);
        if (storage != null) {
            this.map.setZoomContolsVisible(storage.getZoomControlsVisible());
            this.map.setTileGridVisible(storage.getTileGridVisible());
            this.map.setMapMarkerVisible(storage.getShowMapMarker());
            this.map.setHideFoldedNodes(storage.getHideFoldedNodes());
            int column = 0;
            for (TableColumnSetting setting : storage.getListTableColumnSettingList()) {
                this.mResultTable.getColumnModel().getColumn(column).setPreferredWidth(setting.getColumnWidth());
                this.mResultTableSorter.setSortingStatus(column, setting.getColumnSorting());
                ++column;
            }
            if (storage.getLimitSearchToVisibleArea()) {
                this.toggleLimitSearchToRegion();
            }
            if (!storage.getSearchControlVisible()) {
                this.toggleSearchBar();
            }
            this.mLastDividerPosition = storage.getLastDividerPosition();
            this.mSearchSplitPane.setDividerLocation(this.mLastDividerPosition);
            Vector positionHolderVector = this.getFreeMindMapController().getPositionHolderVector();
            for (MapLocationStorage location : storage.getListMapLocationStorageList()) {
                positionHolderVector.add(new FreeMindMapController.PositionHolder(location.getCursorLatitude(), location.getCursorLongitude(), location.getZoom()));
            }
            if (this.getFreeMindMapController().checkPositionHolderIndex(storage.getMapLocationStorageIndex())) {
                this.getFreeMindMapController().setPositionHolderIndex(storage.getMapLocationStorageIndex());
            }
            this.map.setDisplayPositionByLatLon(storage.getMapCenterLatitude(), storage.getMapCenterLongitude(), storage.getZoom());
            Coordinate position = new Coordinate(storage.getCursorLatitude(), storage.getCursorLongitude());
            this.getFreeMindMapController().setCursorPosition(position);
            FreeMindMapController.changeTileSource(storage.getTileSource(), this.map);
        }
        this.addMarkersToMap();
        this.mMapDialog.setVisible(true);
        this.getRegistration().setMapDialog(this);
    }

    public void addMarkersToMap() {
        Set mapNodePositionHolders = this.getAllMapNodePositionHolders();
        for (MapNodePositionHolder nodePositionHolder : mapNodePositionHolders) {
            boolean visible = !nodePositionHolder.hasFoldedParents();
            this.changeVisibilityOfNode(nodePositionHolder, visible);
        }
    }

    protected void changeVisibilityOfNode(MapNodePositionHolder nodePositionHolder, boolean pVisible) {
        if (!pVisible && this.map.isHideFoldedNodes()) {
            this.removeMapMarker(nodePositionHolder);
        } else {
            this.addMapMarker(nodePositionHolder);
        }
    }

    public Registration getRegistration() {
        return (Registration)this.getPluginBaseClass();
    }

    public void toggleSearchBar() {
        this.mSingleSearch = false;
        this.toggleSearchBar(null);
    }

    public void toggleSearchBar(AWTEvent pEvent) {
        if (this.mSearchBarVisible) {
            this.mLastDividerPosition = this.mSearchSplitPane.getDividerLocation();
            this.logger.fine("Setting last divider to " + this.mLastDividerPosition);
            this.mResultTableModel.clear();
            this.mSearchSplitPane.setBottomComponent(null);
            this.mMapDialog.remove(this.mSearchSplitPane);
            this.mMapDialog.add((Component)((Object)this.map), "Center");
            this.mMapDialog.requestFocusInWindow();
            this.mSearchBarVisible = false;
        } else {
            this.mMapDialog.remove((Component)((Object)this.map));
            this.mMapDialog.add((Component)this.mSearchSplitPane, "Center");
            this.mSearchSplitPane.setBottomComponent((Component)((Object)this.map));
            this.mSearchSplitPane.setDividerLocation(this.mLastDividerPosition);
            this.focusSearchTerm();
            this.mSearchBarVisible = true;
        }
        this.mMapDialog.validate();
        if (pEvent != null) {
            this.mSearchTerm.setText("");
            this.mSearchTerm.dispatchEvent(pEvent);
            if (Tools.isMacOsX()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MapDialog.this.mSearchTerm.setCaretPosition(MapDialog.this.mSearchTerm.getDocument().getLength());
                    }
                });
            }
        }
    }

    protected void focusSearchTerm() {
        this.mSearchTerm.selectAll();
        this.mSearchTerm.requestFocusInWindow();
    }

    public Set getAllMapNodePositionHolders() {
        return this.getRegistration().getMapNodePositionHolders();
    }

    public Set getMapNodePositionHolders() {
        return this.mMarkerMap.keySet();
    }

    protected void addMapMarker(MapNodePositionHolder nodePositionHolder) {
        if (this.mMarkerMap.containsKey((Object)nodePositionHolder)) {
            this.logger.fine("Node " + (Object)((Object)nodePositionHolder) + " already present.");
            return;
        }
        Coordinate position = nodePositionHolder.getPosition();
        this.logger.fine("Adding map position for " + nodePositionHolder.getNode() + " at " + position);
        MapMarkerLocation marker = new MapMarkerLocation(nodePositionHolder, this);
        this.map.addMapMarker(marker);
        this.mMarkerMap.put(nodePositionHolder, marker);
    }

    protected void removeMapMarker(MapNodePositionHolder pMapNodePositionHolder) {
        MapMarkerLocation marker = (MapMarkerLocation)this.mMarkerMap.remove((Object)pMapNodePositionHolder);
        if (marker != null) {
            this.map.removeMapMarker(marker);
        }
    }

    public MindMapController getMindMapController() {
        return this.mMyMindMapController;
    }

    public FreeMindMapController getFreeMindMapController() {
        return this.map.getFreeMindMapController();
    }

    public void disposeDialog() {
        Registration registration = (Registration)this.getPluginBaseClass();
        if (registration != null) {
            registration.setMapDialog(null);
            registration.deregisterMapNodePositionListener(this);
            registration.deregisterNodeVisibilityListener(this);
        }
        this.getMindMapController().deregisterNodeSelectionListener((ModeController.NodeSelectionListener)this);
        MapWindowConfigurationStorage storage = new MapWindowConfigurationStorage();
        storage.setZoom(this.map.getZoom());
        Coordinate position = this.map.getPosition();
        storage.setMapCenterLongitude(position.getLon());
        storage.setMapCenterLatitude(position.getLat());
        Coordinate cursorPosition = this.map.getCursorPosition();
        storage.setCursorLongitude(cursorPosition.getLon());
        storage.setCursorLatitude(cursorPosition.getLat());
        storage.setTileSource(this.map.getTileController().getTileSource().getClass().getName());
        storage.setTileGridVisible(this.map.isTileGridVisible());
        storage.setZoomControlsVisible(this.map.getZoomContolsVisible());
        storage.setShowMapMarker(this.map.getMapMarkersVisible());
        storage.setSearchControlVisible(this.mSearchBarVisible);
        storage.setLimitSearchToVisibleArea(this.mLimitSearchToRegion);
        storage.setHideFoldedNodes(this.map.isHideFoldedNodes());
        storage.setLastDividerPosition(this.mLastDividerPosition);
        for (int i = 0; i < this.mResultTable.getColumnCount(); ++i) {
            TableColumnSetting setting = new TableColumnSetting();
            setting.setColumnWidth(this.mResultTable.getColumnModel().getColumn(i).getWidth());
            setting.setColumnSorting(this.mResultTableSorter.getSortingStatus(i));
            storage.addTableColumnSetting(setting);
        }
        for (FreeMindMapController.PositionHolder pos : this.getFreeMindMapController().getPositionHolderVector()) {
            MapLocationStorage mapLocationStorage = new MapLocationStorage();
            mapLocationStorage.setCursorLatitude(pos.lat);
            mapLocationStorage.setCursorLongitude(pos.lon);
            mapLocationStorage.setZoom(pos.zoom);
            storage.addMapLocationStorage(mapLocationStorage);
        }
        storage.setMapLocationStorageIndex(this.getFreeMindMapController().getPositionHolderIndex());
        this.getMindMapController().storeDialogPositions(this.mMapDialog, (WindowConfigurationStorage)storage, WINDOW_PREFERENCE_STORAGE_PROPERTY);
        this.getMindMapController().getController().getMapModuleManager().removeListener((MapModuleManager.MapModuleChangeObserver)this);
        this.mMapDialog.setVisible(false);
        this.mMapDialog.dispose();
    }

    private void updateZoomParameters() {
        if (this.mperpLabelValue != null) {
            this.mperpLabelValue.setText(this.format("%s", this.map.getMeterPerPixel()));
        }
        if (this.zoomValue != null) {
            this.zoomValue.setText(this.format("%s", this.map.getZoom()));
        }
    }

    private String format(String pString, double pObject) {
        return "" + pObject;
    }

    public void processCommand(JMVCommandEvent command) {
        if (command.getCommand().equals((Object)JMVCommandEvent.COMMAND.ZOOM) || command.getCommand().equals((Object)JMVCommandEvent.COMMAND.MOVE)) {
            this.updateZoomParameters();
        }
    }

    public boolean isMapModuleChangeAllowed(MapModule pOldMapModule, Mode pOldMode, MapModule pNewMapModule, Mode pNewMode) {
        return true;
    }

    public void beforeMapModuleChange(MapModule pOldMapModule, Mode pOldMode, MapModule pNewMapModule, Mode pNewMode) {
    }

    public void afterMapClose(MapModule pOldMapModule, Mode pOldMode) {
        this.disposeDialog();
    }

    public void afterMapModuleChange(MapModule pOldMapModule, Mode pOldMode, MapModule pNewMapModule, Mode pNewMode) {
        this.disposeDialog();
    }

    public void numberOfOpenMapInformation(int pNumber, int pIndex) {
    }

    @Override
    public void registerMapNode(MapNodePositionHolder pMapNodePositionHolder) {
        this.addMapMarker(pMapNodePositionHolder);
    }

    @Override
    public void deregisterMapNode(MapNodePositionHolder pMapNodePositionHolder) {
        this.removeMapMarker(pMapNodePositionHolder);
    }

    public void onUpdateNodeHook(MindMapNode pNode) {
        MapNodePositionHolder hook = MapNodePositionHolder.getHook(pNode);
        if (hook != null && this.mMarkerMap.containsKey((Object)hook)) {
            MapMarkerLocation location = (MapMarkerLocation)this.mMarkerMap.get((Object)hook);
            location.update();
            location.repaint();
        }
    }

    public void onFocusNode(NodeView pNode) {
    }

    public void selectMapPosition(NodeView pNode, boolean sel) {
        MapNodePositionHolder hook = MapNodePositionHolder.getHook(pNode.getModel());
        if (hook != null && this.mMarkerMap.containsKey((Object)hook)) {
            MapMarkerLocation location = (MapMarkerLocation)this.mMarkerMap.get((Object)hook);
            location.setSelected(sel);
            this.map.repaint();
        }
    }

    public void onLostFocusNode(NodeView pNode) {
    }

    public void onSaveNode(MindMapNode pNode) {
    }

    public void onSelectionChange(NodeView pNode, boolean pIsSelected) {
        this.selectMapPosition(pNode, pIsSelected);
    }

    public CloseAction getCloseAction() {
        return this.mCloseAction;
    }

    public boolean isSearchBarVisible() {
        return this.mSearchBarVisible;
    }

    public Map getMarkerMap() {
        return Collections.unmodifiableMap(this.mMarkerMap);
    }

    public JCursorMapViewer getMap() {
        return this.map;
    }

    public void displaySearchItem(int index) {
        Place place = this.getPlace(index);
        this.getFreeMindMapController().setCursorPosition(place);
        if (this.mSingleSearch && this.isSearchBarVisible()) {
            this.toggleSearchBar();
        }
        this.mSingleSearch = false;
    }

    public Place getPlace(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Index " + index + " out of bounds.");
        }
        index = this.mResultTableSorter.modelIndex(index);
        Place place = this.mResultTableModel.getPlace(index);
        return place;
    }

    public JDialog getMapDialog() {
        return this.mMapDialog;
    }

    @Override
    public void nodeVisibilityChanged(MapNodePositionHolder pMapNodePositionHolder, boolean pVisible) {
        this.changeVisibilityOfNode(pMapNodePositionHolder, pVisible);
    }

    public JLabel getStatusLabel() {
        return this.mStatusLabel;
    }

    public void search(String searchText, boolean pSelectFirstResult) {
        if (!this.isSearchBarVisible()) {
            this.toggleSearchBar();
        }
        this.mSearchTerm.setText(searchText);
        boolean resultOk = this.getFreeMindMapController().search(this.mResultTableModel, this.mResultTable, searchText, this.mTableOriginalBackgroundColor);
        int rowCount = this.mResultTableModel.getRowCount();
        if (resultOk) {
            if (this.mSingleSearch && rowCount == 1) {
                this.displaySearchItem(0);
                this.map.requestFocus();
                return;
            }
            if (pSelectFirstResult && rowCount > 0) {
                this.displaySearchItem(0);
            }
            this.mResultTable.requestFocus();
        } else {
            this.mSearchTerm.requestFocus();
        }
    }

    public void setSingleSearch() {
        this.mSingleSearch = true;
    }

    public boolean isLimitSearchToRegion() {
        return this.mLimitSearchToRegion;
    }

    public void toggleLimitSearchToRegion() {
        boolean bl = this.mLimitSearchToRegion = !this.mLimitSearchToRegion;
        if (this.mLimitSearchToRegion) {
            this.mSearchStringLabel.setText(this.mResourceSearchLocationString);
        } else {
            this.mSearchStringLabel.setText(this.mResourceSearchString);
        }
        this.mSearchStringLabel.validate();
    }

    protected void addSearchResultsToMap() {
        int[] selectedRows = this.mResultTable.getSelectedRows();
        this.logger.info("Add results to map.");
        this.getFreeMindMapController().addSearchResultsToMap(selectedRows);
    }

    public final class ResultTableModel
    extends AbstractTableModel
    implements FreeMindMapController.CursorPositionListener {
        private final String[] COLUMNS = new String[]{"plugins/map/MapDialog.Description", "plugins/map/MapDialog.Distance"};
        Vector mData = new Vector();
        private Coordinate mCursorCoordinate = new Coordinate(0.0, 0.0);
        private HashMap mMapSearchMarkerLocationHash = new HashMap();
        private final TextTranslator mTextTranslator;

        public ResultTableModel(Coordinate pCursorCoordinate, TextTranslator pTextTranslator) {
            this.mCursorCoordinate = pCursorCoordinate;
            this.mTextTranslator = pTextTranslator;
        }

        public Class getColumnClass(int arg0) {
            switch (arg0) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Double.class;
                }
            }
            return Object.class;
        }

        public void addPlace(Place pPlace) {
            this.mData.add(pPlace);
            int row = this.mData.size() - 1;
            MapSearchMarkerLocation location = new MapSearchMarkerLocation(MapDialog.this, pPlace);
            this.mMapSearchMarkerLocationHash.put(pPlace, location);
            MapDialog.this.getMap().addMapMarker(location);
            this.fireTableRowsInserted(row, row);
        }

        public MapSearchMarkerLocation getMapSearchMarkerLocation(int index) {
            if (index >= 0 && index < this.getRowCount()) {
                Place place = this.getPlace(index);
                return (MapSearchMarkerLocation)this.mMapSearchMarkerLocationHash.get(place);
            }
            throw new IllegalArgumentException("Index " + index + " is out of range.");
        }

        public Place getPlace(int pIndex) {
            return (Place)this.mData.get(pIndex);
        }

        @Override
        public String getColumnName(int pColumn) {
            return this.mTextTranslator.getText(this.COLUMNS[pColumn]);
        }

        @Override
        public int getRowCount() {
            return this.mData.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int pRowIndex, int pColumnIndex) {
            Place place = this.getPlace(pRowIndex);
            switch (pColumnIndex) {
                case 1: {
                    double value = OsmMercator.getDistance((double)this.mCursorCoordinate.getLat(), (double)this.mCursorCoordinate.getLon(), (double)place.getLat(), (double)place.getLon()) / 1000.0;
                    if (Double.isInfinite(value) || Double.isNaN(value)) {
                        return -1.0;
                    }
                    return new Double(value);
                }
                case 0: {
                    return place.getDisplayName();
                }
            }
            return null;
        }

        public void clear() {
            for (Place place : this.mMapSearchMarkerLocationHash.keySet()) {
                MapSearchMarkerLocation location = (MapSearchMarkerLocation)this.mMapSearchMarkerLocationHash.get(place);
                MapDialog.this.getMap().removeMapMarker(location);
            }
            this.mMapSearchMarkerLocationHash.clear();
            this.mData.clear();
            this.fireTableDataChanged();
        }

        @Override
        public void cursorPositionChanged(Coordinate pCursorPosition) {
            this.mCursorCoordinate = pCursorPosition;
            this.fireTableDataChanged();
        }
    }

    private final class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(MapDialog.this.getResourceString("MapDialog_close"));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            MapDialog.this.disposeDialog();
        }
    }
}

