/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Name;
import org.jruby.org.objectweb.asm.AnnotationVisitor;
import org.jruby.org.objectweb.asm.Type;

public class CodegenUtils {
    public static String c(String p2) {
        return p2.replace('/', '.');
    }

    public static String p(Class n) {
        return n.getName().replace('.', '/');
    }

    public static String ci(Class n) {
        if (n.isArray()) {
            if ((n = n.getComponentType()).isPrimitive()) {
                if (n == Byte.TYPE) {
                    return "[B";
                }
                if (n == Boolean.TYPE) {
                    return "[Z";
                }
                if (n == Short.TYPE) {
                    return "[S";
                }
                if (n == Character.TYPE) {
                    return "[C";
                }
                if (n == Integer.TYPE) {
                    return "[I";
                }
                if (n == Float.TYPE) {
                    return "[F";
                }
                if (n == Double.TYPE) {
                    return "[D";
                }
                if (n == Long.TYPE) {
                    return "[J";
                }
                throw new RuntimeException("Unrecognized type in compiler: " + n.getName());
            }
            return '[' + CodegenUtils.ci(n);
        }
        if (n.isPrimitive()) {
            if (n == Byte.TYPE) {
                return "B";
            }
            if (n == Boolean.TYPE) {
                return "Z";
            }
            if (n == Short.TYPE) {
                return "S";
            }
            if (n == Character.TYPE) {
                return "C";
            }
            if (n == Integer.TYPE) {
                return "I";
            }
            if (n == Float.TYPE) {
                return "F";
            }
            if (n == Double.TYPE) {
                return "D";
            }
            if (n == Long.TYPE) {
                return "J";
            }
            if (n == Void.TYPE) {
                return "V";
            }
            throw new RuntimeException("Unrecognized type in compiler: " + n.getName());
        }
        return 'L' + CodegenUtils.p(n) + ';';
    }

    public static String human(Class n) {
        return n.getCanonicalName();
    }

    public static String humanShort(Class n) {
        return n.getSimpleName();
    }

    public static String sig(Class retval, Class ... params2) {
        return CodegenUtils.sigParams(new StringBuilder(), null, params2).append(CodegenUtils.ci(retval)).toString();
    }

    public static String sig(Class[] retvalParams) {
        Class[] justParams = new Class[retvalParams.length - 1];
        System.arraycopy(retvalParams, 1, justParams, 0, justParams.length);
        return CodegenUtils.sigParams(new StringBuilder(), null, justParams).append(CodegenUtils.ci(retvalParams[0])).toString();
    }

    public static String sig(Class retval, String descriptor, Class ... params2) {
        return CodegenUtils.sigParams(new StringBuilder(), descriptor, params2).append(CodegenUtils.ci(retval)).toString();
    }

    @Deprecated
    public static String sigParams(Class ... params2) {
        return CodegenUtils.sigParams(new StringBuilder(), null, params2).toString();
    }

    @Deprecated
    public static String sigParams(String descriptor, Class ... params2) {
        return CodegenUtils.sigParams(new StringBuilder(), descriptor, params2).toString();
    }

    private static StringBuilder sigParams(StringBuilder str, String descriptor, Class ... params2) {
        str.append('(');
        if (descriptor != null) {
            str.append(descriptor);
        }
        for (int i2 = 0; i2 < params2.length; ++i2) {
            str.append(CodegenUtils.ci(params2[i2]));
        }
        return str.append(')');
    }

    public static String pretty(Class retval, Class ... params2) {
        return CodegenUtils.prettyParams(params2) + CodegenUtils.human(retval);
    }

    public static CharSequence prettyParams(Class ... types) {
        return CodegenUtils.prettyParams(new StringBuilder(), types);
    }

    public static StringBuilder prettyParams(StringBuilder str, Class ... types) {
        int len1 = types.length - 1;
        str.append('(');
        for (int i2 = 0; i2 <= len1; ++i2) {
            str.append(CodegenUtils.human(types[i2]));
            if (i2 >= len1) continue;
            str.append(',');
        }
        return str.append(')');
    }

    public static String prettyShortParams(Class ... types) {
        int len1 = types.length - 1;
        StringBuilder signature = new StringBuilder();
        signature.append('(');
        for (int i2 = 0; i2 <= len1; ++i2) {
            signature.append(CodegenUtils.humanShort(types[i2]));
            if (i2 >= len1) continue;
            signature.append(',');
        }
        signature.append(')');
        return signature.toString();
    }

    public static Class[] params(Class ... classes2) {
        return classes2;
    }

    public static Class[] params(Class cls, int times2) {
        Object[] classes2 = new Class[times2];
        Arrays.fill(classes2, cls);
        return classes2;
    }

    public static Class[] params(Class cls1, Class clsFill, int times2) {
        Object[] classes2 = new Class[times2 + 1];
        Arrays.fill(classes2, 1, 1 + times2, clsFill);
        classes2[0] = cls1;
        return classes2;
    }

    public static Class[] params(Class cls1, Class cls2, Class clsFill, int times2) {
        Object[] classes2 = new Class[times2 + 2];
        Arrays.fill(classes2, 2, 2 + times2, clsFill);
        classes2[0] = cls1;
        classes2[1] = cls2;
        return classes2;
    }

    public static Class[] params(Class cls1, Class cls2, Class cls3, Class clsFill, int times2) {
        Object[] classes2 = new Class[times2 + 3];
        Arrays.fill(classes2, 3, 3 + times2, clsFill);
        classes2[0] = cls1;
        classes2[1] = cls2;
        classes2[2] = cls3;
        return classes2;
    }

    public static Class[] params(Class cls1, Class cls2, Class cls3, Class cls4, Class clsFill, int times2) {
        Object[] classes2 = new Class[times2 + 4];
        Arrays.fill(classes2, 4, 4 + times2, clsFill);
        classes2[0] = cls1;
        classes2[1] = cls2;
        classes2[2] = cls3;
        classes2[3] = cls4;
        return classes2;
    }

    public static Class[] params(Class cls1, Class clsFill, int times2, Class clsTail) {
        Object[] classes2 = new Class[times2 + 2];
        Arrays.fill(classes2, 1, 1 + times2, clsFill);
        classes2[0] = cls1;
        classes2[times2 + 1] = clsTail;
        return classes2;
    }

    public static Class[] params(Class cls1, Class cls2, Class clsFill, int times2, Class clsTail) {
        Object[] classes2 = new Class[times2 + 3];
        Arrays.fill(classes2, 2, 2 + times2, clsFill);
        classes2[0] = cls1;
        classes2[1] = cls2;
        classes2[times2 + 2] = clsTail;
        return classes2;
    }

    public static Class[] params(Class cls1, Class cls2, Class cls3, Class clsFill, int times2, Class clsTail) {
        Object[] classes2 = new Class[times2 + 4];
        Arrays.fill(classes2, 3, 3 + times2, clsFill);
        classes2[0] = cls1;
        classes2[1] = cls2;
        classes2[2] = cls3;
        classes2[times2 + 3] = clsTail;
        return classes2;
    }

    public static Class[] params(Class cls1, Class cls2, Class cls3, Class cls4, Class clsFill, int times2, Class clsTail) {
        Object[] classes2 = new Class[times2 + 5];
        Arrays.fill(classes2, 4, 4 + times2, clsFill);
        classes2[0] = cls1;
        classes2[1] = cls2;
        classes2[2] = cls3;
        classes2[3] = cls4;
        classes2[times2 + 4] = clsTail;
        return classes2;
    }

    public static Class[] params(Class cls1, Class[] clsFills, int times2) {
        Class[] classes2 = new Class[clsFills.length * times2 + 1];
        classes2[0] = cls1;
        for (int i2 = 0; i2 < times2; ++i2) {
            int base = i2 * clsFills.length + 1;
            for (int j = 0; j < clsFills.length; ++j) {
                classes2[base + j] = clsFills[j];
            }
        }
        return classes2;
    }

    public static String getAnnotatedBindingClassName(Name javaMethodName, CharSequence typeName, boolean isStatic, int required, int optional, boolean multi, boolean framed) {
        return CodegenUtils.getAnnotatedBindingClassName(javaMethodName.toString(), typeName, isStatic, required, optional, multi, framed);
    }

    public static String getAnnotatedBindingClassName(String javaMethodName, CharSequence typeName, boolean isStatic, int required, int optional, boolean multi, boolean framed) {
        if (multi) {
            return new StringBuilder(typeName.length() + 8 + 3 + javaMethodName.length()).append(typeName).append("$INVOKER").append(isStatic ? "$s$" : "$i$").append(javaMethodName).toString();
        }
        return new StringBuilder(typeName.length() + 8 + 3 + 4 + javaMethodName.length()).append(typeName).append("$INVOKER").append(isStatic ? "$s$" : "$i$").append(required).append('$').append(optional).append('$').append(javaMethodName).toString();
    }

    public static void visitAnnotationFields(AnnotationVisitor visitor, Map<String, Object> fields2) {
        try {
            for (Map.Entry<String, Object> fieldEntry : fields2.entrySet()) {
                Object value2 = fieldEntry.getValue();
                String key2 = fieldEntry.getKey();
                if (value2 instanceof Map) {
                    Map nestedAnnotationMap = (Map)value2;
                    for (Map.Entry nestedAnnotation : nestedAnnotationMap.entrySet()) {
                        AnnotationVisitor annotationV = visitor.visitAnnotation(key2, Type.getType((Class)nestedAnnotation.getKey()).getDescriptor());
                        CodegenUtils.visitAnnotationFields(annotationV, (Map)nestedAnnotation.getValue());
                        annotationV.visitEnd();
                    }
                    continue;
                }
                if (value2.getClass().isArray()) {
                    Object[] values2 = (Object[])value2;
                    AnnotationVisitor arrayV = visitor.visitArray(key2);
                    for (int i2 = 0; i2 < values2.length; ++i2) {
                        HashMap<String, Object> map2 = new HashMap<String, Object>();
                        map2.put(null, values2[i2]);
                        CodegenUtils.visitAnnotationFields(arrayV, map2);
                    }
                    arrayV.visitEnd();
                    continue;
                }
                if (value2.getClass().isEnum()) {
                    visitor.visitEnum(key2, CodegenUtils.ci(value2.getClass()), value2.toString());
                    continue;
                }
                if (value2 instanceof Class) {
                    visitor.visit(key2, Type.getType((Class)value2));
                    continue;
                }
                visitor.visit(key2, value2);
            }
        }
        catch (ClassCastException e) {
            throw new InvalidAnnotationDescriptorException("Fields " + fields2 + " did not match annotation format.  See CodegenUtils#visitAnnotationFields for format", e);
        }
    }

    public static Class getBoxType(Class type2) {
        if (type2 == Integer.TYPE) {
            return Integer.class;
        }
        if (type2 == Byte.TYPE) {
            return Byte.class;
        }
        if (type2 == Short.TYPE) {
            return Short.class;
        }
        if (type2 == Character.TYPE) {
            return Character.class;
        }
        if (type2 == Long.TYPE) {
            return Long.class;
        }
        if (type2 == Float.TYPE) {
            return Float.class;
        }
        if (type2 == Double.TYPE) {
            return Double.class;
        }
        if (type2 == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type2 == Void.TYPE) {
            return Void.class;
        }
        throw new RuntimeException("Not a native type: " + type2);
    }

    public static class InvalidAnnotationDescriptorException
    extends RuntimeException {
        public InvalidAnnotationDescriptorException() {
        }

        public InvalidAnnotationDescriptorException(String s2) {
            super(s2);
        }

        public InvalidAnnotationDescriptorException(String s2, Throwable throwable) {
            super(s2, throwable);
        }

        public InvalidAnnotationDescriptorException(Throwable throwable) {
            super(throwable);
        }
    }
}

