/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.IrArrayBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.IrArrayBuilderKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.UnsignedType;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u00012\u00020\u0002:\u0001\u001fB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001cH\u0016J\u0014\u0010\u001d\u001a\u00020\u0012*\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u001cH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00020\t*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u000b\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/VarargLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "isArrayOf", "", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "(Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;)Z", "createBuilder", "Lorg/jetbrains/kotlin/backend/jvm/ir/JvmIrBuilder;", "startOffset", "", "endOffset", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "visitFunctionAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "visitVararg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "addVararg", "Lorg/jetbrains/kotlin/backend/jvm/ir/IrArrayBuilder;", "Companion", "backend.jvm"})
final class VarargLowering
extends IrElementTransformerVoidWithContext
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    private static final Set<String> PRIMITIVE_ARRAY_OF_NAMES;
    public static final Companion Companion;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull(irFile, "irFile");
        this.transformChildrenVoid(irFile);
    }

    @Override
    @NotNull
    public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrConstructor constructor = (IrConstructor)expression2.getSymbol().getOwner();
        if (IrUtilsKt.isAnnotationClass(AdditionalIrUtilsKt.getConstructedClass(constructor))) {
            return expression2;
        }
        return super.visitConstructorCall(expression2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrExpression visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        IrExpression irExpression;
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        this.transformChildrenVoid(expression2);
        IrFunctionSymbol function2 = expression2.getSymbol();
        int n = 0;
        int n2 = expression2.getValueArgumentsCount();
        while (n < n2) {
            IrValueParameter parameter;
            void i;
            if (expression2.getValueArgument((int)i) == null && (parameter = function2.getOwner().getValueParameters().get((int)i)).getVarargElementType() != null && !IrUtilsKt.hasDefaultValue(parameter)) {
                IrType arrayType = IrTypeUtilsKt.substitute(parameter.getType(), IrUtilsKt.getTypeSubstitutionMap(expression2));
                expression2.putValueArgument((int)i, IrArrayBuilderKt.irArrayOf$default(VarargLowering.createBuilder$default(this, 0, 0, 3, null), arrayType, null, 2, null));
            }
            ++i;
        }
        if (this.isArrayOf(function2)) {
            irExpression = expression2.getValueArgument(0);
            if (irExpression == null) {
                Intrinsics.throwNpe();
            }
        } else {
            irExpression = expression2;
        }
        return irExpression;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrExpression visitVararg(@NotNull IrVararg expression2) {
        void $this$irArray$iv;
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        JvmIrBuilder jvmIrBuilder = this.createBuilder(expression2.getStartOffset(), expression2.getEndOffset());
        IrType arrayType$iv = expression2.getType();
        boolean $i$f$irArray = false;
        IrArrayBuilder irArrayBuilder = new IrArrayBuilder((JvmIrBuilder)$this$irArray$iv, arrayType$iv);
        boolean bl = false;
        boolean bl2 = false;
        IrArrayBuilder $this$apply$iv = irArrayBuilder;
        boolean bl3 = false;
        IrArrayBuilder $this$irArray = $this$apply$iv;
        boolean bl4 = false;
        this.addVararg($this$irArray, expression2);
        return irArrayBuilder.build();
    }

    private final void addVararg(@NotNull IrArrayBuilder $this$addVararg, IrVararg expression2) {
        for (IrVarargElement element : expression2.getElements()) {
            IrVarargElement irVarargElement = element;
            if (irVarargElement instanceof IrExpression) {
                $this$addVararg.unaryPlus(((IrExpression)element).transform(this, null));
                continue;
            }
            if (irVarargElement instanceof IrSpreadElement) {
                IrExpression spread = ((IrSpreadElement)element).getExpression();
                if (spread instanceof IrFunctionAccessExpression && this.isArrayOf(((IrFunctionAccessExpression)spread).getSymbol())) {
                    IrExpression argument;
                    if (((IrFunctionAccessExpression)spread).getValueArgument(0) == null) {
                        continue;
                    }
                    if (argument instanceof IrVararg) {
                        this.addVararg($this$addVararg, (IrVararg)argument);
                        continue;
                    }
                }
                $this$addVararg.addSpread(spread.transform(this, null));
                continue;
            }
            String string2 = "Unexpected IrVarargElement subclass: " + element;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
    }

    private final JvmIrBuilder createBuilder(int startOffset, int endOffset) {
        ScopeWithIr scopeWithIr = this.getCurrentScope();
        if (scopeWithIr == null) {
            Intrinsics.throwNpe();
        }
        return org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.createJvmIrBuilder(this.context, scopeWithIr.getScope().getScopeOwnerSymbol(), startOffset, endOffset);
    }

    static /* synthetic */ JvmIrBuilder createBuilder$default(VarargLowering varargLowering, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = -1;
        }
        if ((n3 & 2) != 0) {
            n2 = -1;
        }
        return varargLowering.createBuilder(n, n2);
    }

    private final boolean isArrayOf(@NotNull IrFunctionSymbol $this$isArrayOf) {
        return Intrinsics.areEqual($this$isArrayOf, this.context.getIr().getSymbols().getArrayOf()) || VarargLowering.Companion.isPrimitiveArrayOf($this$isArrayOf.getOwner());
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public VarargLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkParameterIsNotNull(context2, "context");
        this.context = context2;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        Object object;
        Enum type2;
        boolean bl;
        Collection collection;
        Enum[] $this$mapTo$iv$iv;
        Companion = new Companion(null);
        Object $this$map$iv = PrimitiveType.values();
        boolean $i$f$map = false;
        PrimitiveType[] primitiveTypeArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((PrimitiveType[])$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (Enum item$iv$iv : $this$mapTo$iv$iv) {
            void var9_13 = item$iv$iv;
            collection = destination$iv$iv;
            bl = false;
            object = type2.name();
            collection.add(object);
        }
        $this$map$iv = UnsignedType.values();
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(((Enum[])$this$map$iv).length);
        $i$f$mapTo = false;
        Enum[] enumArray = $this$mapTo$iv$iv;
        int n = enumArray.length;
        for (int string3 = 0; string3 < n; ++string3) {
            String string2;
            void type3;
            Enum item$iv$iv;
            type2 = item$iv$iv = enumArray[string3];
            object = destination$iv$iv;
            bl = false;
            Intrinsics.checkExpressionValueIsNotNull(type3.getTypeName().asString(), "type.typeName.asString()");
            object.add(string2);
        }
        object = (List)destination$iv$iv;
        $this$map$iv = CollectionsKt.plus(collection, (Iterable)object);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object e : $this$mapTo$iv$iv) {
            void name;
            String string3 = (String)e;
            collection = destination$iv$iv;
            boolean bl2 = false;
            object = CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly((String)name) + "ArrayOf";
            collection.add(object);
        }
        PRIMITIVE_ARRAY_OF_NAMES = CollectionsKt.toSet((List)var3_3);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\u00020\u0007*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/VarargLowering$Companion;", "", "()V", "PRIMITIVE_ARRAY_OF_NAMES", "", "", "isPrimitiveArrayOf", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Z", "backend.jvm"})
    public static final class Companion {
        private final boolean isPrimitiveArrayOf(@NotNull IrFunction $this$isPrimitiveArrayOf) {
            IrPackageFragment irPackageFragment;
            IrDeclarationParent directParent = $this$isPrimitiveArrayOf.getParent();
            if (directParent instanceof IrClass) {
                irPackageFragment = IrUtilsKt.getPackageFragment(directParent);
                if (irPackageFragment == null) {
                    return false;
                }
            } else if (directParent instanceof IrPackageFragment) {
                irPackageFragment = (IrPackageFragment)directParent;
            } else {
                return false;
            }
            IrPackageFragment parent2 = irPackageFragment;
            return Intrinsics.areEqual(parent2.getFqName(), KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME) && PRIMITIVE_ARRAY_OF_NAMES.contains($this$isPrimitiveArrayOf.getName().asString()) && $this$isPrimitiveArrayOf.getExtensionReceiverParameter() == null && $this$isPrimitiveArrayOf.getDispatchReceiverParameter() == null && $this$isPrimitiveArrayOf.getValueParameters().size() == 1 && AdditionalIrUtilsKt.isVararg($this$isPrimitiveArrayOf.getValueParameters().get(0));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

