/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.w2lcommon.helper;

import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XModel;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class StyleNameProvider {
    private Map<String, Map<String, String>> displayNameCollection = new HashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> internalNameCollection = new HashMap<String, Map<String, String>>();

    public StyleNameProvider(XComponentContext xContext) {
        XStyleFamiliesSupplier xSupplier;
        XModel xModel = null;
        try {
            Object desktop = xContext.getServiceManager().createInstanceWithContext("com.sun.star.frame.Desktop", xContext);
            XDesktop xDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)desktop);
            XController xController = xDesktop.getCurrentFrame().getController();
            if (xController != null) {
                xModel = xController.getModel();
            }
        }
        catch (Exception desktop) {
            // empty catch block
        }
        if (xModel != null && (xSupplier = (XStyleFamiliesSupplier)UnoRuntime.queryInterface(XStyleFamiliesSupplier.class, xModel)) != null) {
            String[] sFamilyNames;
            XNameAccess xFamilies = xSupplier.getStyleFamilies();
            for (String sFamilyName : sFamilyNames = xFamilies.getElementNames()) {
                HashMap<String, String> displayNames = new HashMap<String, String>();
                this.displayNameCollection.put(sFamilyName, displayNames);
                HashMap<String, String> internalNames = new HashMap<String, String>();
                this.internalNameCollection.put(sFamilyName, internalNames);
                try {
                    String[] sStyleNames;
                    XNameContainer xFamily = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)xFamilies.getByName(sFamilyName));
                    if (xFamily == null) continue;
                    for (String sStyleName : sStyleNames = xFamily.getElementNames()) {
                        XPropertySet xProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xFamily.getByName(sStyleName));
                        if (xProps == null) continue;
                        String sDisplayName = (String)xProps.getPropertyValue("DisplayName");
                        displayNames.put(sStyleName, sDisplayName);
                        internalNames.put(sDisplayName, sStyleName);
                    }
                }
                catch (WrappedTargetException wrappedTargetException) {
                }
                catch (NoSuchElementException noSuchElementException) {
                }
                catch (UnknownPropertyException unknownPropertyException) {
                    // empty catch block
                }
            }
        }
    }

    public Map<String, String> getDisplayNames(String sFamily) {
        if (this.displayNameCollection.containsKey(sFamily)) {
            return Collections.unmodifiableMap(this.displayNameCollection.get(sFamily));
        }
        return null;
    }

    public Map<String, String> getInternalNames(String sFamily) {
        if (this.internalNameCollection.containsKey(sFamily)) {
            return Collections.unmodifiableMap(this.internalNameCollection.get(sFamily));
        }
        return null;
    }
}

