/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.project3.ComplementColors;
import net.sourceforge.plantuml.project3.Instant;
import net.sourceforge.plantuml.project3.TaskDraw;
import net.sourceforge.plantuml.project3.TaskSeparator;
import net.sourceforge.plantuml.project3.TimeScale;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class TaskDrawSeparator
implements TaskDraw {
    private final TimeScale timeScale;
    private final double y;
    private final Instant min;
    private final Instant max;
    private final String name;
    private static final double MARGIN1 = 10.0;
    private static final double MARGIN2 = 2.0;

    public TaskDrawSeparator(TaskSeparator task, TimeScale timeScale, double y, Instant min, Instant max) {
        this.name = task.getName();
        this.y = y;
        this.timeScale = timeScale;
        this.min = min;
        this.max = max;
    }

    @Override
    public void drawTitle(UGraphic ug) {
        this.getTitle().drawU(ug.apply(new UTranslate(10.0, 0.0)));
    }

    private TextBlock getTitle() {
        if (this.name == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        return Display.getWithNewlines(this.name).create(this.getFontConfiguration(), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
    }

    private FontConfiguration getFontConfiguration() {
        UFont font = UFont.serif(11);
        return new FontConfiguration(font, HtmlColorUtils.BLACK, HtmlColorUtils.BLACK, false);
    }

    @Override
    public void drawU(UGraphic ug) {
        double widthTitle = this.getTitle().calculateDimension(ug.getStringBounder()).getWidth();
        double start = this.timeScale.getStartingPosition(this.min) + widthTitle;
        double end = this.timeScale.getEndingPosition(this.max);
        ug = ug.apply(new UChangeColor(HtmlColorUtils.BLACK));
        ug = ug.apply(new UTranslate(0.0, this.getHeight() / 2.0));
        if (widthTitle == 0.0) {
            ULine line = new ULine(end - start, 0.0);
            ug.draw(line);
        } else {
            ULine line1 = new ULine(8.0, 0.0);
            ULine line2 = new ULine(end - start - 10.0 - 2.0, 0.0);
            ug.draw(line1);
            ug.apply(new UTranslate(widthTitle + 10.0 + 2.0, 0.0)).draw(line2);
        }
    }

    @Override
    public double getHeight() {
        return 16.0;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getY(Direction direction) {
        if (direction == Direction.UP) {
            return this.y;
        }
        if (direction == Direction.DOWN) {
            return this.y + this.getHeight();
        }
        return this.y + this.getHeight() / 2.0;
    }

    @Override
    public void setColors(ComplementColors colors) {
    }
}

