/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.zip;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.concurrent.TimeUnit;

class ZipUtils {
    private static final long WINDOWS_EPOCH_IN_MICROSECONDS = -11644473600000000L;

    ZipUtils() {
    }

    static void writeShort(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n & 0xFF);
        outputStream.write(n >>> 8 & 0xFF);
    }

    static void writeInt(OutputStream outputStream, long l) throws IOException {
        outputStream.write((int)(l & 0xFFL));
        outputStream.write((int)(l >>> 8 & 0xFFL));
        outputStream.write((int)(l >>> 16 & 0xFFL));
        outputStream.write((int)(l >>> 24 & 0xFFL));
    }

    static void writeLong(OutputStream outputStream, long l) throws IOException {
        outputStream.write((int)(l & 0xFFL));
        outputStream.write((int)(l >>> 8 & 0xFFL));
        outputStream.write((int)(l >>> 16 & 0xFFL));
        outputStream.write((int)(l >>> 24 & 0xFFL));
        outputStream.write((int)(l >>> 32 & 0xFFL));
        outputStream.write((int)(l >>> 40 & 0xFFL));
        outputStream.write((int)(l >>> 48 & 0xFFL));
        outputStream.write((int)(l >>> 56 & 0xFFL));
    }

    static void writeBytes(OutputStream outputStream, byte[] byArray) throws IOException {
        outputStream.write(byArray, 0, byArray.length);
    }

    static long dosToJavaTime(long l) {
        Date date = new Date((int)((l >> 25 & 0x7FL) + 80L), (int)((l >> 21 & 0xFL) - 1L), (int)(l >> 16 & 0x1FL), (int)(l >> 11 & 0x1FL), (int)(l >> 5 & 0x3FL), (int)(l << 1 & 0x3EL));
        return date.getTime();
    }

    static long javaToDosTime(long l) {
        Date date = new Date(l);
        int n = date.getYear() + 1900;
        if (n < 1980) {
            return 0x210000L;
        }
        return n - 1980 << 25 | date.getMonth() + 1 << 21 | date.getDate() << 16 | date.getHours() << 11 | date.getMinutes() << 5 | date.getSeconds() >> 1;
    }

    static long winToJavaTime(long l) {
        return TimeUnit.MILLISECONDS.convert(l / 10L + -11644473600000000L, TimeUnit.MICROSECONDS);
    }

    static long javaToWinTime(long l) {
        return (TimeUnit.MICROSECONDS.convert(l, TimeUnit.MILLISECONDS) - -11644473600000000L) * 10L;
    }

    static long unixToJavaTime(long l) {
        return TimeUnit.MILLISECONDS.convert(l, TimeUnit.SECONDS);
    }

    static long javaToUnixTime(long l) {
        return TimeUnit.SECONDS.convert(l, TimeUnit.MILLISECONDS);
    }
}

