/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.media.j3d.BadTransformException;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Pipeline;
import javax.media.j3d.Renderer;
import javax.media.j3d.ScreenViewCache;
import javax.media.j3d.Transform3D;
import javax.media.j3d.UnorderList;
import javax.media.j3d.View;
import javax.media.j3d.VirtualUniverse;

public class Screen3D {
    private static final boolean debug = false;
    private static final double METERS_PER_PIXEL = 2.8222222222222223E-4;
    GraphicsDevice graphicsDevice;
    boolean offScreen;
    long display;
    int screen;
    double physicalScreenWidth;
    double physicalScreenHeight;
    Dimension screenSize = new Dimension(0, 0);
    Transform3D trackerBaseToImagePlate = new Transform3D();
    Transform3D headTrackerToLeftImagePlate = new Transform3D();
    Transform3D headTrackerToRightImagePlate = new Transform3D();
    static final int PHYSICAL_SCREEN_SIZE_DIRTY = 1;
    static final int SCREEN_SIZE_DIRTY_DIRTY = 2;
    static final int TRACKER_BASE_TO_IMAGE_PLATE_DIRTY = 4;
    static final int HEAD_TRACKER_TO_IMAGE_PLATE_DIRTY = 8;
    int scrDirtyMask = 15;
    ScreenViewCache screenViewCache = null;
    Renderer renderer = null;
    static Hashtable deviceRendererMap = new Hashtable();
    int canvasCount = 0;
    UnorderList activeViews = new UnorderList(1, View.class);
    ArrayList users = new ArrayList();

    void addActiveView(View view) {
        this.activeViews.addUnique(view);
    }

    void removeActiveView(View view) {
        this.activeViews.remove(view);
    }

    boolean activeViewEmpty() {
        return this.activeViews.isEmpty();
    }

    synchronized void removeUser(Canvas3D canvas3D) {
        int n = this.users.indexOf(canvas3D);
        if (n >= 0) {
            this.users.remove(n);
        }
    }

    synchronized void addUser(Canvas3D canvas3D) {
        int n = this.users.indexOf(canvas3D);
        if (n < 0) {
            this.users.add(canvas3D);
        }
    }

    synchronized void notifyUsers() {
        for (int i = 0; i < this.users.size(); ++i) {
            Canvas3D canvas3D = (Canvas3D)this.users.get(i);
            canvas3D.redraw();
        }
    }

    public Dimension getSize() {
        return new Dimension(this.screenSize);
    }

    public Dimension getSize(Dimension dimension) {
        if (dimension == null) {
            return new Dimension(this.screenSize);
        }
        dimension.setSize(this.screenSize);
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize(int n, int n2) {
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Screen3D1"));
        }
        Screen3D screen3D = this;
        synchronized (screen3D) {
            this.screenSize.width = n;
            this.screenSize.height = n2;
            this.scrDirtyMask |= 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize(Dimension dimension) {
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Screen3D1"));
        }
        Screen3D screen3D = this;
        synchronized (screen3D) {
            this.screenSize.width = dimension.width;
            this.screenSize.height = dimension.height;
            this.scrDirtyMask |= 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPhysicalScreenWidth(double d) {
        Screen3D screen3D = this;
        synchronized (screen3D) {
            this.physicalScreenWidth = d;
            this.scrDirtyMask |= 1;
        }
        this.notifyUsers();
    }

    public double getPhysicalScreenWidth() {
        return this.physicalScreenWidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPhysicalScreenHeight(double d) {
        Screen3D screen3D = this;
        synchronized (screen3D) {
            this.physicalScreenHeight = d;
            this.scrDirtyMask |= 1;
        }
        this.notifyUsers();
    }

    public double getPhysicalScreenHeight() {
        return this.physicalScreenHeight;
    }

    public String toString() {
        return "Screen3D: size = (" + this.getSize().width + " x " + this.getSize().height + ")" + ", physical size = " + "(" + this.getPhysicalScreenWidth() + "m x " + this.getPhysicalScreenHeight() + "m)";
    }

    Screen3D(GraphicsConfiguration graphicsConfiguration, boolean bl) {
        this.offScreen = bl;
        this.graphicsDevice = graphicsConfiguration.getDevice();
        this.screenViewCache = new ScreenViewCache(this);
        this.display = Pipeline.getPipeline().getDisplay();
        this.screen = Pipeline.getPipeline().getScreen(this.graphicsDevice);
        if (!bl) {
            Rectangle rectangle = graphicsConfiguration.getBounds();
            this.screenSize.width = rectangle.width;
            this.screenSize.height = rectangle.height;
        }
        this.physicalScreenWidth = (double)this.screenSize.width * 2.8222222222222223E-4;
        this.physicalScreenHeight = (double)this.screenSize.height * 2.8222222222222223E-4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTrackerBaseToImagePlate(Transform3D transform3D) {
        Screen3D screen3D = this;
        synchronized (screen3D) {
            if (!transform3D.isRigid()) {
                throw new BadTransformException(J3dI18N.getString("Screen3D0"));
            }
            this.trackerBaseToImagePlate.setWithLock(transform3D);
            this.scrDirtyMask |= 4;
        }
        this.notifyUsers();
    }

    public void getTrackerBaseToImagePlate(Transform3D transform3D) {
        transform3D.set(this.trackerBaseToImagePlate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeadTrackerToLeftImagePlate(Transform3D transform3D) {
        Screen3D screen3D = this;
        synchronized (screen3D) {
            if (!transform3D.isRigid()) {
                throw new BadTransformException(J3dI18N.getString("Screen3D0"));
            }
            this.headTrackerToLeftImagePlate.setWithLock(transform3D);
            this.scrDirtyMask |= 8;
        }
        this.notifyUsers();
    }

    public void getHeadTrackerToLeftImagePlate(Transform3D transform3D) {
        transform3D.set(this.headTrackerToLeftImagePlate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeadTrackerToRightImagePlate(Transform3D transform3D) {
        Screen3D screen3D = this;
        synchronized (screen3D) {
            if (!transform3D.isRigid()) {
                throw new BadTransformException(J3dI18N.getString("Screen3D0"));
            }
            this.headTrackerToRightImagePlate.setWithLock(transform3D);
            this.scrDirtyMask |= 8;
        }
        this.notifyUsers();
    }

    public void getHeadTrackerToRightImagePlate(Transform3D transform3D) {
        transform3D.set(this.headTrackerToRightImagePlate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateViewCache() {
        Screen3D screen3D = this;
        synchronized (screen3D) {
            this.screenViewCache.snapshot();
        }
    }

    synchronized void incCanvasCount() {
        ++this.canvasCount;
    }

    synchronized void decCanvasCount() {
        --this.canvasCount;
    }

    static {
        VirtualUniverse.loadLibraries();
    }
}

