/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junitlauncher;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.AbstractJUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.TestResultFormatter;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

class LegacyPlainResultFormatter
extends AbstractJUnitResultFormatter
implements TestResultFormatter {
    private OutputStream outputStream;
    private final Map<TestIdentifier, Stats> testIds = new ConcurrentHashMap<TestIdentifier, Stats>();
    private TestPlan testPlan;
    private BufferedWriter writer;

    LegacyPlainResultFormatter() {
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.testPlan = testPlan;
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        for (Map.Entry<TestIdentifier, Stats> entry : this.testIds.entrySet()) {
            TestIdentifier testIdentifier = entry.getKey();
            if (!LegacyPlainResultFormatter.isTestClass(testIdentifier).isPresent()) continue;
            Stats stats = entry.getValue();
            StringBuilder sb = new StringBuilder("Tests run: ").append(stats.numTestsRun.get());
            sb.append(", Failures: ").append(stats.numTestsFailed.get());
            sb.append(", Skipped: ").append(stats.numTestsSkipped.get());
            sb.append(", Aborted: ").append(stats.numTestsAborted.get());
            long timeElapsed = stats.endedAt - stats.startedAt;
            sb.append(", Time elapsed: ");
            if (timeElapsed < 1000L) {
                sb.append(timeElapsed).append(" milli sec(s)");
            } else {
                sb.append(TimeUnit.SECONDS.convert(timeElapsed, TimeUnit.MILLISECONDS)).append(" sec(s)");
            }
            try {
                this.writer.write(sb.toString());
                this.writer.newLine();
            }
            catch (IOException ioe) {
                this.handleException(ioe);
                return;
            }
        }
        try {
            if (this.hasSysOut()) {
                this.writer.write("------------- Standard Output ---------------");
                this.writer.newLine();
                this.writeSysOut(this.writer);
                this.writer.write("------------- ---------------- ---------------");
                this.writer.newLine();
            }
            if (this.hasSysErr()) {
                this.writer.write("------------- Standard Error ---------------");
                this.writer.newLine();
                this.writeSysErr(this.writer);
                this.writer.write("------------- ---------------- ---------------");
                this.writer.newLine();
            }
        }
        catch (IOException ioe) {
            this.handleException(ioe);
        }
    }

    public void dynamicTestRegistered(TestIdentifier testIdentifier) {
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        Optional<TestIdentifier> parentTestClass;
        long currentTime = System.currentTimeMillis();
        this.testIds.putIfAbsent(testIdentifier, new Stats(testIdentifier, currentTime));
        Stats stats = this.testIds.get(testIdentifier);
        stats.setEndedAt(currentTime);
        if (testIdentifier.isTest()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Test: ");
            sb.append(testIdentifier.getLegacyReportingName());
            long timeElapsed = stats.endedAt - stats.startedAt;
            sb.append(" took ");
            if (timeElapsed < 1000L) {
                sb.append(timeElapsed).append(" milli sec(s)");
            } else {
                sb.append(TimeUnit.SECONDS.convert(timeElapsed, TimeUnit.MILLISECONDS)).append(" sec(s)");
            }
            sb.append(" SKIPPED");
            if (reason != null && !reason.isEmpty()) {
                sb.append(": ").append(reason);
            }
            try {
                this.writer.write(sb.toString());
                this.writer.newLine();
            }
            catch (IOException ioe) {
                this.handleException(ioe);
                return;
            }
        }
        if (!(parentTestClass = LegacyPlainResultFormatter.traverseAndFindTestClass(this.testPlan, testIdentifier)).isPresent()) {
            return;
        }
        Stats parentClassStats = this.testIds.get(parentTestClass.get());
        parentClassStats.numTestsSkipped.incrementAndGet();
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        Stats parentClassStats;
        Optional<TestIdentifier> parentTestClass;
        long currentTime = System.currentTimeMillis();
        this.testIds.putIfAbsent(testIdentifier, new Stats(testIdentifier, currentTime));
        Optional<ClassSource> testClass = LegacyPlainResultFormatter.isTestClass(testIdentifier);
        if (testClass.isPresent()) {
            try {
                this.writer.write("Testcase: " + testClass.get().getClassName());
                this.writer.newLine();
            }
            catch (IOException ioe) {
                this.handleException(ioe);
                return;
            }
        }
        if (testIdentifier.isTest() && (parentTestClass = LegacyPlainResultFormatter.traverseAndFindTestClass(this.testPlan, testIdentifier)).isPresent() && (parentClassStats = this.testIds.get(parentTestClass.get())) != null) {
            parentClassStats.numTestsRun.incrementAndGet();
        }
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        Optional<TestIdentifier> parentTestClass;
        long currentTime = System.currentTimeMillis();
        Stats stats = this.testIds.get(testIdentifier);
        if (stats != null) {
            stats.setEndedAt(currentTime);
        }
        if (testIdentifier.isTest() && this.shouldReportExecutionFinished(testIdentifier, testExecutionResult)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Test: ");
            sb.append(testIdentifier.getLegacyReportingName());
            if (stats != null) {
                long timeElapsed = stats.endedAt - stats.startedAt;
                sb.append(" took ");
                if (timeElapsed < 1000L) {
                    sb.append(timeElapsed).append(" milli sec(s)");
                } else {
                    sb.append(TimeUnit.SECONDS.convert(timeElapsed, TimeUnit.MILLISECONDS)).append(" sec(s)");
                }
            }
            switch (testExecutionResult.getStatus()) {
                case ABORTED: {
                    sb.append(" ABORTED");
                    LegacyPlainResultFormatter.appendThrowable(sb, testExecutionResult);
                    break;
                }
                case FAILED: {
                    sb.append(" FAILED");
                    LegacyPlainResultFormatter.appendThrowable(sb, testExecutionResult);
                }
            }
            try {
                this.writer.write(sb.toString());
                this.writer.newLine();
            }
            catch (IOException ioe) {
                this.handleException(ioe);
                return;
            }
        }
        if (!(parentTestClass = LegacyPlainResultFormatter.traverseAndFindTestClass(this.testPlan, testIdentifier)).isPresent()) {
            return;
        }
        Stats parentClassStats = this.testIds.get(parentTestClass.get());
        switch (testExecutionResult.getStatus()) {
            case ABORTED: {
                parentClassStats.numTestsAborted.incrementAndGet();
                break;
            }
            case FAILED: {
                parentClassStats.numTestsFailed.incrementAndGet();
            }
        }
    }

    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
    }

    @Override
    public void setDestination(OutputStream os) {
        this.outputStream = os;
        this.writer = new BufferedWriter(new OutputStreamWriter(this.outputStream, StandardCharsets.UTF_8));
    }

    protected boolean shouldReportExecutionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        return true;
    }

    private static void appendThrowable(StringBuilder sb, TestExecutionResult result) {
        if (!result.getThrowable().isPresent()) {
            return;
        }
        Throwable throwable = (Throwable)result.getThrowable().get();
        sb.append(String.format(": %s%n", throwable.getMessage()));
        StringWriter stacktrace = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stacktrace));
        sb.append(stacktrace.toString());
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
        super.close();
    }

    private final class Stats {
        private final TestIdentifier testIdentifier;
        private final AtomicLong numTestsRun = new AtomicLong(0L);
        private final AtomicLong numTestsFailed = new AtomicLong(0L);
        private final AtomicLong numTestsSkipped = new AtomicLong(0L);
        private final AtomicLong numTestsAborted = new AtomicLong(0L);
        private final long startedAt;
        private long endedAt;

        private Stats(TestIdentifier testIdentifier, long startedAt) {
            this.testIdentifier = testIdentifier;
            this.startedAt = startedAt;
        }

        private void setEndedAt(long endedAt) {
            this.endedAt = endedAt;
        }
    }
}

