/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.matcher;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.api.search.SearchPattern;
import org.netbeans.api.search.provider.SearchListener;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.TextDetail;
import org.netbeans.modules.search.TextRegexpUtil;
import org.netbeans.modules.search.matcher.AbstractMatcher;
import org.netbeans.modules.search.matcher.BufferedCharSequence;
import org.netbeans.modules.search.matcher.DefaultMatcher;
import org.netbeans.modules.search.matcher.MatcherUtils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class MultiLineStreamMatcher
extends AbstractMatcher {
    private static final Logger LOG = Logger.getLogger(MultiLineStreamMatcher.class.getName());
    private volatile boolean terminated = false;
    private List<BufferedCharSequence> currentlyProcessedSequences = new ArrayList<BufferedCharSequence>(1);
    private Pattern pattern;
    private SearchPattern searchPattern;

    public MultiLineStreamMatcher(SearchPattern searchPattern) {
        this.searchPattern = searchPattern;
        this.pattern = TextRegexpUtil.makeTextPattern(searchPattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MatchingObject.Def checkMeasuredInternal(FileObject fileObject, SearchListener searchListener) {
        searchListener.fileContentMatchingStarted(fileObject.getPath());
        Charset charset = FileEncodingQuery.getEncoding((FileObject)fileObject);
        BufferedCharSequence bufferedCharSequence = null;
        CharsetDecoder charsetDecoder = this.prepareDecoder(charset);
        try {
            bufferedCharSequence = new BufferedCharSequence(fileObject, charsetDecoder, fileObject.getSize());
            bufferedCharSequence.setSearchListener(searchListener);
            this.registerProcessedSequence(bufferedCharSequence);
            ArrayList<TextDetail> arrayList = this.getTextDetailsML(bufferedCharSequence, fileObject, this.searchPattern);
            this.unregisterProcessedSequence(bufferedCharSequence);
            if (arrayList != null && !arrayList.isEmpty()) {
                MatchingObject.Def def = new MatchingObject.Def(fileObject, charset, arrayList);
                return def;
            }
        }
        catch (BufferedCharSequence.TerminatedException terminatedException) {
            LOG.log(Level.INFO, "Search in {0} was terminated.", fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            LOG.log(Level.SEVERE, "Unable to get data object for the {0}", fileObject);
            LOG.throwing(DefaultMatcher.class.getName(), "checkFileContent", dataObjectNotFoundException);
            searchListener.generalError(dataObjectNotFoundException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOG.log(Level.SEVERE, "Unable to get input stream for the {0}", fileObject);
            LOG.throwing(DefaultMatcher.class.getName(), "checkFileContent", fileNotFoundException);
            searchListener.generalError(fileNotFoundException);
        }
        catch (BufferedCharSequence.SourceIOException sourceIOException) {
            if (sourceIOException.getCause() instanceof CharacterCodingException) {
                this.handleDecodingError(searchListener, fileObject, charsetDecoder, (CharacterCodingException)sourceIOException.getCause());
            } else {
                LOG.log(Level.SEVERE, "IOException during process for the {0}", fileObject);
                LOG.log(Level.INFO, "checkFileContent", sourceIOException);
                searchListener.generalError(sourceIOException);
            }
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, "Unexpected Exception during process for the {0}", fileObject);
            LOG.log(Level.INFO, "checkFileContent", exception);
            searchListener.generalError(exception);
        }
        finally {
            if (bufferedCharSequence != null) {
                try {
                    bufferedCharSequence.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private ArrayList<TextDetail> getTextDetailsML(BufferedCharSequence bufferedCharSequence, FileObject fileObject, SearchPattern searchPattern) throws BufferedCharSequence.SourceIOException, DataObjectNotFoundException {
        ArrayList<TextDetail> arrayList = null;
        DataObject dataObject = null;
        FindState findState = new FindState(bufferedCharSequence);
        Matcher matcher = this.pattern.matcher(bufferedCharSequence);
        while (matcher.find() && (arrayList == null || arrayList.size() < 5000)) {
            if (arrayList == null) {
                arrayList = new ArrayList<TextDetail>();
                dataObject = DataObject.find((FileObject)fileObject);
            }
            int n = matcher.start();
            int n2 = findState.calcColumn(n);
            int n3 = findState.getLineNumber();
            String string = findState.getLineText();
            TextDetail textDetail = MatcherUtils.createTextDetail(true, matcher, dataObject, n3, string, n2, this.searchPattern);
            arrayList.add(textDetail);
        }
        return arrayList;
    }

    @Override
    public void terminate() {
        this.terminated = true;
        try {
            this.terminateCurrentSearches();
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, iOException.getMessage(), iOException);
        }
    }

    private synchronized void registerProcessedSequence(BufferedCharSequence bufferedCharSequence) throws IOException {
        if (this.terminated) {
            bufferedCharSequence.close();
        } else {
            this.currentlyProcessedSequences.add(bufferedCharSequence);
        }
    }

    private synchronized void unregisterProcessedSequence(BufferedCharSequence bufferedCharSequence) {
        this.currentlyProcessedSequences.remove(bufferedCharSequence);
    }

    private synchronized void terminateCurrentSearches() throws IOException {
        for (BufferedCharSequence bufferedCharSequence : this.currentlyProcessedSequences) {
            bufferedCharSequence.terminate();
        }
        this.currentlyProcessedSequences.clear();
    }

    private class FindState {
        int lineNumber = 1;
        int lineStartOffset = 0;
        int prevCR = 0;
        BufferedCharSequence bcs;

        FindState(BufferedCharSequence bufferedCharSequence) {
            this.bcs = bufferedCharSequence;
        }

        int getLineNumber() {
            return this.lineNumber;
        }

        String getLineText() {
            return this.bcs.getLineText(this.lineStartOffset);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        int calcColumn(int n) {
            try {
                block6: while (this.bcs.position() < n) {
                    char c = this.bcs.nextChar();
                    switch (c) {
                        case '\n': 
                        case '\u0085': 
                        case '\u2028': 
                        case '\u2029': {
                            ++this.lineNumber;
                            this.lineStartOffset = this.bcs.position();
                            this.prevCR = 0;
                            continue block6;
                        }
                        case '\r': {
                            ++this.prevCR;
                            char c2 = this.bcs.charAt(this.bcs.position());
                            if (c2 == '\n') continue block6;
                            ++this.lineNumber;
                            this.lineStartOffset = this.bcs.position();
                            this.prevCR = 0;
                            continue block6;
                        }
                    }
                    this.prevCR = 0;
                }
                return n - this.lineStartOffset + 1 - this.prevCR;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            return n - this.lineStartOffset + 1 - this.prevCR;
        }
    }
}

