/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.tools.jmx;

import com.sun.tools.visualvm.tools.jmx.CachedMBeanServerConnection;
import com.sun.tools.visualvm.tools.jmx.CachedMBeanServerConnectionFactory;
import com.sun.tools.visualvm.tools.jmx.JmxModel;
import com.sun.tools.visualvm.tools.jmx.JvmMXBeans;
import com.sun.tools.visualvm.tools.jmx.MBeanCacheListener;
import java.io.IOException;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.LoggingMXBean;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public final class JvmMXBeansFactory {
    private JvmMXBeansFactory() {
    }

    public static JvmMXBeans getJvmMXBeans(MBeanServerConnection mbsc) {
        return new JvmMXBeansImpl(mbsc);
    }

    public static JvmMXBeans getJvmMXBeans(MBeanServerConnection mbsc, int interval) throws IllegalArgumentException {
        if (interval < 0) {
            throw new IllegalArgumentException("interval cannot be negative");
        }
        return new JvmMXBeansImpl(CachedMBeanServerConnectionFactory.getCachedMBeanServerConnection(mbsc, interval));
    }

    public static JvmMXBeans getJvmMXBeans(JmxModel jmx) {
        return new JvmMXBeansImpl(jmx.getMBeanServerConnection());
    }

    public static JvmMXBeans getJvmMXBeans(JmxModel jmx, int interval) throws IllegalArgumentException {
        if (interval < 0) {
            throw new IllegalArgumentException("interval cannot be negative");
        }
        return new JvmMXBeansImpl(CachedMBeanServerConnectionFactory.getCachedMBeanServerConnection(jmx.getMBeanServerConnection(), interval));
    }

    static class JvmMXBeansImpl
    implements JvmMXBeans {
        protected MBeanServerConnection mbsc;
        private ClassLoadingMXBean classLoadingMXBean = null;
        private CompilationMXBean compilationMXBean = null;
        private LoggingMXBean loggingMXBean = null;
        private MemoryMXBean memoryMXBean = null;
        private OperatingSystemMXBean operatingSystemMXBean = null;
        private RuntimeMXBean runtimeMXBean = null;
        private ThreadMXBean threadMXBean = null;
        private List<GarbageCollectorMXBean> garbageCollectorMXBeans = null;
        private List<MemoryManagerMXBean> memoryManagerMXBeans = null;
        private List<MemoryPoolMXBean> memoryPoolMXBeans = null;
        private static final Logger LOGGER = Logger.getLogger(JvmMXBeansImpl.class.getName());

        public JvmMXBeansImpl(MBeanServerConnection mbsc) {
            this.mbsc = mbsc;
        }

        @Override
        public synchronized ClassLoadingMXBean getClassLoadingMXBean() {
            if (this.mbsc != null && this.classLoadingMXBean == null) {
                this.classLoadingMXBean = this.getMXBean("java.lang:type=ClassLoading", ClassLoadingMXBean.class);
            }
            return this.classLoadingMXBean;
        }

        @Override
        public synchronized CompilationMXBean getCompilationMXBean() {
            if (this.mbsc != null && this.compilationMXBean == null) {
                this.compilationMXBean = this.getMXBean("java.lang:type=Compilation", CompilationMXBean.class);
            }
            return this.compilationMXBean;
        }

        @Override
        public synchronized LoggingMXBean getLoggingMXBean() {
            if (this.mbsc != null && this.loggingMXBean == null) {
                this.loggingMXBean = this.getMXBean("java.util.logging:type=Logging", LoggingMXBean.class);
            }
            return this.loggingMXBean;
        }

        @Override
        public synchronized Collection<GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
            if (this.mbsc != null && this.garbageCollectorMXBeans == null) {
                Set<ObjectName> mbeans;
                ObjectName gcName;
                try {
                    gcName = new ObjectName("java.lang:type=GarbageCollector,*");
                }
                catch (MalformedObjectNameException e) {
                    LOGGER.throwing(JvmMXBeansImpl.class.getName(), "getGarbageCollectorMXBeans", e);
                    return null;
                }
                try {
                    mbeans = this.mbsc.queryNames(gcName, null);
                }
                catch (Exception e) {
                    LOGGER.throwing(JvmMXBeansImpl.class.getName(), "getGarbageCollectorMXBeans", e);
                    return null;
                }
                if (mbeans != null) {
                    this.garbageCollectorMXBeans = new ArrayList<GarbageCollectorMXBean>();
                    for (ObjectName on : mbeans) {
                        String name = "java.lang:type=GarbageCollector,name=" + on.getKeyProperty("name");
                        try {
                            GarbageCollectorMXBean mbean = ManagementFactory.newPlatformMXBeanProxy(this.mbsc, name, GarbageCollectorMXBean.class);
                            this.garbageCollectorMXBeans.add(mbean);
                        }
                        catch (Exception e) {
                            LOGGER.throwing(JvmMXBeansImpl.class.getName(), "getGarbageCollectorMXBeans", e);
                        }
                    }
                }
            }
            return this.garbageCollectorMXBeans;
        }

        @Override
        public synchronized Collection<MemoryManagerMXBean> getMemoryManagerMXBeans() {
            if (this.mbsc != null && this.memoryManagerMXBeans == null) {
                Set<ObjectName> mbeans;
                ObjectName managerName;
                try {
                    managerName = new ObjectName("java.lang:type=MemoryManager,*");
                }
                catch (MalformedObjectNameException e) {
                    LOGGER.throwing(JvmMXBeansImpl.class.getName(), "getMemoryManagerMXBeans", e);
                    return null;
                }
                try {
                    mbeans = this.mbsc.queryNames(managerName, null);
                }
                catch (Exception e) {
                    LOGGER.throwing(JvmMXBeansImpl.class.getName(), "getMemoryManagerMXBeans", e);
                    return null;
                }
                if (mbeans != null) {
                    this.memoryManagerMXBeans = new ArrayList<MemoryManagerMXBean>();
                    for (ObjectName on : mbeans) {
                        String name = "java.lang:type=MemoryManager,name=" + on.getKeyProperty("name");
                        try {
                            MemoryManagerMXBean mbean = ManagementFactory.newPlatformMXBeanProxy(this.mbsc, name, MemoryManagerMXBean.class);
                            this.memoryManagerMXBeans.add(mbean);
                        }
                        catch (Exception e) {
                            LOGGER.throwing(JvmMXBeansImpl.class.getName(), "getMemoryManagerMXBeans", e);
                        }
                    }
                }
            }
            return this.memoryManagerMXBeans;
        }

        @Override
        public synchronized MemoryMXBean getMemoryMXBean() {
            if (this.mbsc != null && this.memoryMXBean == null) {
                this.memoryMXBean = this.getMXBean("java.lang:type=Memory", MemoryMXBean.class);
            }
            return this.memoryMXBean;
        }

        @Override
        public synchronized Collection<MemoryPoolMXBean> getMemoryPoolMXBeans() {
            if (this.mbsc != null && this.memoryPoolMXBeans == null) {
                Set<ObjectName> mbeans;
                ObjectName poolName;
                try {
                    poolName = new ObjectName("java.lang:type=MemoryPool,*");
                }
                catch (MalformedObjectNameException e) {
                    LOGGER.throwing(JvmMXBeansImpl.class.getName(), "getMemoryPoolMXBeans", e);
                    return null;
                }
                try {
                    mbeans = this.mbsc.queryNames(poolName, null);
                }
                catch (Exception e) {
                    LOGGER.throwing(JvmMXBeansImpl.class.getName(), "getMemoryPoolMXBeans", e);
                    return null;
                }
                if (mbeans != null) {
                    this.memoryPoolMXBeans = new ArrayList<MemoryPoolMXBean>();
                    for (ObjectName on : mbeans) {
                        String name = "java.lang:type=MemoryPool,name=" + on.getKeyProperty("name");
                        try {
                            MemoryPoolMXBean mbean = ManagementFactory.newPlatformMXBeanProxy(this.mbsc, name, MemoryPoolMXBean.class);
                            this.memoryPoolMXBeans.add(mbean);
                        }
                        catch (Exception e) {
                            LOGGER.throwing(JvmMXBeansImpl.class.getName(), "getMemoryPoolMXBeans", e);
                        }
                    }
                }
            }
            return this.memoryPoolMXBeans;
        }

        @Override
        public synchronized OperatingSystemMXBean getOperatingSystemMXBean() {
            if (this.mbsc != null && this.operatingSystemMXBean == null) {
                this.operatingSystemMXBean = this.getMXBean("java.lang:type=OperatingSystem", OperatingSystemMXBean.class);
            }
            return this.operatingSystemMXBean;
        }

        @Override
        public synchronized RuntimeMXBean getRuntimeMXBean() {
            if (this.mbsc != null && this.runtimeMXBean == null) {
                this.runtimeMXBean = this.getMXBean("java.lang:type=Runtime", RuntimeMXBean.class);
            }
            return this.runtimeMXBean;
        }

        @Override
        public synchronized ThreadMXBean getThreadMXBean() {
            if (this.mbsc != null && this.threadMXBean == null) {
                this.threadMXBean = this.getMXBean("java.lang:type=Threading", ThreadMXBean.class);
            }
            return this.threadMXBean;
        }

        @Override
        public <T> T getMXBean(ObjectName objectName, Class<T> interfaceClass) {
            return this.getMXBean(objectName.toString(), interfaceClass);
        }

        <T> T getMXBean(String objectNameStr, Class<T> interfaceClass) {
            if (this.mbsc != null) {
                try {
                    return ManagementFactory.newPlatformMXBeanProxy(this.mbsc, objectNameStr, interfaceClass);
                }
                catch (IOException e) {
                    LOGGER.throwing(JvmMXBeansImpl.class.getName(), "getMXBean", e);
                }
                catch (IllegalArgumentException iae) {
                    LOGGER.log(Level.INFO, JvmMXBeansImpl.class.getName() + ".getMXBean()", iae);
                }
            }
            return null;
        }

        @Override
        public void addMBeanCacheListener(MBeanCacheListener listener) {
            if (!(this.mbsc instanceof CachedMBeanServerConnection)) {
                throw new UnsupportedOperationException("The underlying MBeanServerConnection does not support caching.");
            }
            ((CachedMBeanServerConnection)this.mbsc).addMBeanCacheListener(listener);
        }

        @Override
        public void removeMBeanCacheListener(MBeanCacheListener listener) {
            if (!(this.mbsc instanceof CachedMBeanServerConnection)) {
                throw new UnsupportedOperationException("The underlying MBeanServerConnection does not support caching.");
            }
            ((CachedMBeanServerConnection)this.mbsc).removeMBeanCacheListener(listener);
        }

        @Override
        public void flush() {
            if (!(this.mbsc instanceof CachedMBeanServerConnection)) {
                throw new UnsupportedOperationException("The underlying MBeanServerConnection does not support caching.");
            }
            ((CachedMBeanServerConnection)this.mbsc).flush();
        }

        @Override
        public int getInterval() {
            if (this.mbsc instanceof CachedMBeanServerConnection) {
                return ((CachedMBeanServerConnection)this.mbsc).getInterval();
            }
            throw new UnsupportedOperationException("The underlying MBeanServerConnection does not support caching.");
        }
    }
}

