<?php
declare(strict_types=1);

/**
 *
 * @copyright Copyright (c) 2018, Daniel Calviño Sánchez (danxuliu@gmail.com)
 *
 * @license GNU AGPL version 3 or any later version
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

namespace OCA\Spreed\PublicShare;

use OCP\Files\FileInfo;
use OCP\Share\IShare;
use OCP\Util;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Symfony\Component\EventDispatcher\Event;
use Symfony\Component\EventDispatcher\GenericEvent;

/**
 * Helper class to extend the "publicshare" template from the server.
 *
 * The "loadTalkSidebarUi" method loads additional scripts that, when run on the
 * browser, adjust the page generated by the server to inject the Talk UI as
 * needed.
 */
class TemplateLoader {

	public static function register(EventDispatcherInterface $dispatcher): void {
		$dispatcher->addListener('OCA\Files_Sharing::loadAdditionalScripts', static function(Event $event) {
			/** @var IShare $share */
			$share = null;
			if ($event instanceof GenericEvent) {
				$share = $event->getArgument('share');
			}
			self::loadTalkSidebarUi($share);
		});
	}

	/**
	 * Load the "Talk sidebar" UI in the public share page for the given share.
	 *
	 * This method should be called when loading additional scripts for the
	 * public share page of the server.
	 *
	 * @param IShare $share
	 */
	public static function loadTalkSidebarUi(?IShare $share): void {
		$config = \OC::$server->getConfig();
		if ($config->getAppValue('spreed', 'conversations_files', '1') !== '1' ||
			$config->getAppValue('spreed', 'conversations_files_public_shares', '1') !== '1') {
			return;
		}

		if (!$share || $share->getNodeType() !== FileInfo::TYPE_FILE) {
			return;
		}

		Util::addStyle('spreed', 'merged-public-share');
		Util::addScript('spreed', 'merged-public-share');
	}

}
