/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.IEntity;

public class CommandUrl
extends SingleLineCommand2<AbstractEntityDiagram> {
    public CommandUrl() {
        super(CommandUrl.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandUrl.class.getName(), RegexLeaf.start(), new RegexLeaf("url"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf("of|for")), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE", "([\\p{L}0-9_.]+|[%g][^%g]+[%g])"), RegexLeaf.spaceOneOrMore(), new RegexOptional((IRegex)new RegexLeaf("is")), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(AbstractEntityDiagram diagram, LineLocation location, RegexResult arg) {
        IEntity entity;
        String idShort = arg.get("CODE", 0);
        Code code = diagram.buildCode(idShort);
        String urlString = arg.get("URL", 0);
        if (diagram.leafExist(code)) {
            entity = diagram.getOrCreateLeaf(diagram.buildLeafIdent(idShort), code, null, null);
        } else if (diagram.isGroup(code)) {
            entity = diagram.getGroup(code);
        } else {
            return CommandExecutionResult.error(code + " does not exist");
        }
        UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
        Url url = urlBuilder.getUrl(urlString);
        entity.addUrl(url);
        return CommandExecutionResult.ok();
    }
}

