ntkrnlmp_10_types = {
  'LIST_ENTRY64' : [ 0x10, {
    'Flink' : [ 0x0, ['unsigned long long']],
    'Blink' : [ 0x8, ['unsigned long long']],
} ],
  'LIST_ENTRY32' : [ 0x8, {
    'Flink' : [ 0x0, ['unsigned long']],
    'Blink' : [ 0x4, ['unsigned long']],
} ],
  '_PS_MITIGATION_OPTIONS_MAP' : [ 0x10, {
    'Map' : [ 0x0, ['array', 2, ['unsigned long long']]],
} ],
  '_PS_MITIGATION_AUDIT_OPTIONS_MAP' : [ 0x10, {
    'Map' : [ 0x0, ['array', 2, ['unsigned long long']]],
} ],
  '_KUSER_SHARED_DATA' : [ 0x708, {
    'TickCountLowDeprecated' : [ 0x0, ['unsigned long']],
    'TickCountMultiplier' : [ 0x4, ['unsigned long']],
    'InterruptTime' : [ 0x8, ['_KSYSTEM_TIME']],
    'SystemTime' : [ 0x14, ['_KSYSTEM_TIME']],
    'TimeZoneBias' : [ 0x20, ['_KSYSTEM_TIME']],
    'ImageNumberLow' : [ 0x2c, ['unsigned short']],
    'ImageNumberHigh' : [ 0x2e, ['unsigned short']],
    'NtSystemRoot' : [ 0x30, ['array', 260, ['wchar']]],
    'MaxStackTraceDepth' : [ 0x238, ['unsigned long']],
    'CryptoExponent' : [ 0x23c, ['unsigned long']],
    'TimeZoneId' : [ 0x240, ['unsigned long']],
    'LargePageMinimum' : [ 0x244, ['unsigned long']],
    'AitSamplingValue' : [ 0x248, ['unsigned long']],
    'AppCompatFlag' : [ 0x24c, ['unsigned long']],
    'RNGSeedVersion' : [ 0x250, ['unsigned long long']],
    'GlobalValidationRunlevel' : [ 0x258, ['unsigned long']],
    'TimeZoneBiasStamp' : [ 0x25c, ['long']],
    'NtBuildNumber' : [ 0x260, ['unsigned long']],
    'NtProductType' : [ 0x264, ['Enumeration', dict(target = 'long', choices = {1: u'NtProductWinNt', 2: u'NtProductLanManNt', 3: u'NtProductServer'})]],
    'ProductTypeIsValid' : [ 0x268, ['unsigned char']],
    'Reserved0' : [ 0x269, ['array', 1, ['unsigned char']]],
    'NativeProcessorArchitecture' : [ 0x26a, ['unsigned short']],
    'NtMajorVersion' : [ 0x26c, ['unsigned long']],
    'NtMinorVersion' : [ 0x270, ['unsigned long']],
    'ProcessorFeatures' : [ 0x274, ['array', 64, ['unsigned char']]],
    'Reserved1' : [ 0x2b4, ['unsigned long']],
    'Reserved3' : [ 0x2b8, ['unsigned long']],
    'TimeSlip' : [ 0x2bc, ['unsigned long']],
    'AlternativeArchitecture' : [ 0x2c0, ['Enumeration', dict(target = 'long', choices = {0: u'StandardDesign', 1: u'NEC98x86', 2: u'EndAlternatives'})]],
    'BootId' : [ 0x2c4, ['unsigned long']],
    'SystemExpirationDate' : [ 0x2c8, ['_LARGE_INTEGER']],
    'SuiteMask' : [ 0x2d0, ['unsigned long']],
    'KdDebuggerEnabled' : [ 0x2d4, ['unsigned char']],
    'MitigationPolicies' : [ 0x2d5, ['unsigned char']],
    'NXSupportPolicy' : [ 0x2d5, ['BitField', dict(start_bit = 0, end_bit = 2, native_type='unsigned char')]],
    'SEHValidationPolicy' : [ 0x2d5, ['BitField', dict(start_bit = 2, end_bit = 4, native_type='unsigned char')]],
    'CurDirDevicesSkippedForDlls' : [ 0x2d5, ['BitField', dict(start_bit = 4, end_bit = 6, native_type='unsigned char')]],
    'Reserved' : [ 0x2d5, ['BitField', dict(start_bit = 6, end_bit = 8, native_type='unsigned char')]],
    'Reserved6' : [ 0x2d6, ['array', 2, ['unsigned char']]],
    'ActiveConsoleId' : [ 0x2d8, ['unsigned long']],
    'DismountCount' : [ 0x2dc, ['unsigned long']],
    'ComPlusPackage' : [ 0x2e0, ['unsigned long']],
    'LastSystemRITEventTickCount' : [ 0x2e4, ['unsigned long']],
    'NumberOfPhysicalPages' : [ 0x2e8, ['unsigned long']],
    'SafeBootMode' : [ 0x2ec, ['unsigned char']],
    'VirtualizationFlags' : [ 0x2ed, ['unsigned char']],
    'Reserved12' : [ 0x2ee, ['array', 2, ['unsigned char']]],
    'SharedDataFlags' : [ 0x2f0, ['unsigned long']],
    'DbgErrorPortPresent' : [ 0x2f0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'DbgElevationEnabled' : [ 0x2f0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'DbgVirtEnabled' : [ 0x2f0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'DbgInstallerDetectEnabled' : [ 0x2f0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'DbgLkgEnabled' : [ 0x2f0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'DbgDynProcessorEnabled' : [ 0x2f0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'DbgConsoleBrokerEnabled' : [ 0x2f0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'DbgSecureBootEnabled' : [ 0x2f0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'DbgMultiSessionSku' : [ 0x2f0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'DbgMultiUsersInSessionSku' : [ 0x2f0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'DbgStateSeparationEnabled' : [ 0x2f0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'SpareBits' : [ 0x2f0, ['BitField', dict(start_bit = 11, end_bit = 32, native_type='unsigned long')]],
    'DataFlagsPad' : [ 0x2f4, ['array', 1, ['unsigned long']]],
    'TestRetInstruction' : [ 0x2f8, ['unsigned long long']],
    'QpcFrequency' : [ 0x300, ['long long']],
    'SystemCall' : [ 0x308, ['unsigned long']],
    'SystemCallPad0' : [ 0x30c, ['unsigned long']],
    'SystemCallPad' : [ 0x310, ['array', 2, ['unsigned long long']]],
    'TickCount' : [ 0x320, ['_KSYSTEM_TIME']],
    'TickCountQuad' : [ 0x320, ['unsigned long long']],
    'ReservedTickCountOverlay' : [ 0x320, ['array', 3, ['unsigned long']]],
    'TickCountPad' : [ 0x32c, ['array', 1, ['unsigned long']]],
    'Cookie' : [ 0x330, ['unsigned long']],
    'CookiePad' : [ 0x334, ['array', 1, ['unsigned long']]],
    'ConsoleSessionForegroundProcessId' : [ 0x338, ['long long']],
    'TimeUpdateLock' : [ 0x340, ['unsigned long long']],
    'BaselineSystemTimeQpc' : [ 0x348, ['unsigned long long']],
    'BaselineInterruptTimeQpc' : [ 0x350, ['unsigned long long']],
    'QpcSystemTimeIncrement' : [ 0x358, ['unsigned long long']],
    'QpcInterruptTimeIncrement' : [ 0x360, ['unsigned long long']],
    'QpcSystemTimeIncrementShift' : [ 0x368, ['unsigned char']],
    'QpcInterruptTimeIncrementShift' : [ 0x369, ['unsigned char']],
    'UnparkedProcessorCount' : [ 0x36a, ['unsigned short']],
    'EnclaveFeatureMask' : [ 0x36c, ['array', 4, ['unsigned long']]],
    'TelemetryCoverageRound' : [ 0x37c, ['unsigned long']],
    'UserModeGlobalLogger' : [ 0x380, ['array', 16, ['unsigned short']]],
    'ImageFileExecutionOptions' : [ 0x3a0, ['unsigned long']],
    'LangGenerationCount' : [ 0x3a4, ['unsigned long']],
    'Reserved4' : [ 0x3a8, ['unsigned long long']],
    'InterruptTimeBias' : [ 0x3b0, ['unsigned long long']],
    'QpcBias' : [ 0x3b8, ['unsigned long long']],
    'ActiveProcessorCount' : [ 0x3c0, ['unsigned long']],
    'ActiveGroupCount' : [ 0x3c4, ['unsigned char']],
    'Reserved9' : [ 0x3c5, ['unsigned char']],
    'QpcData' : [ 0x3c6, ['unsigned short']],
    'QpcBypassEnabled' : [ 0x3c6, ['unsigned char']],
    'QpcShift' : [ 0x3c7, ['unsigned char']],
    'TimeZoneBiasEffectiveStart' : [ 0x3c8, ['_LARGE_INTEGER']],
    'TimeZoneBiasEffectiveEnd' : [ 0x3d0, ['_LARGE_INTEGER']],
    'XState' : [ 0x3d8, ['_XSTATE_CONFIGURATION']],
} ],
  '__unnamed_108b' : [ 0x8, {
    'LowPart' : [ 0x0, ['unsigned long']],
    'HighPart' : [ 0x4, ['unsigned long']],
} ],
  '_ULARGE_INTEGER' : [ 0x8, {
    'LowPart' : [ 0x0, ['unsigned long']],
    'HighPart' : [ 0x4, ['unsigned long']],
    'u' : [ 0x0, ['__unnamed_108b']],
    'QuadPart' : [ 0x0, ['unsigned long long']],
} ],
  '__unnamed_10a3' : [ 0x4, {
    'LongFunction' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Persistent' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'Private' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 32, native_type='unsigned long')]],
} ],
  '__unnamed_10a5' : [ 0x4, {
    'Flags' : [ 0x0, ['unsigned long']],
    's' : [ 0x0, ['__unnamed_10a3']],
} ],
  '_TP_CALLBACK_ENVIRON_V3' : [ 0x48, {
    'Version' : [ 0x0, ['unsigned long']],
    'Pool' : [ 0x8, ['pointer64', ['_TP_POOL']]],
    'CleanupGroup' : [ 0x10, ['pointer64', ['_TP_CLEANUP_GROUP']]],
    'CleanupGroupCancelCallback' : [ 0x18, ['pointer64', ['void']]],
    'RaceDll' : [ 0x20, ['pointer64', ['void']]],
    'ActivationContext' : [ 0x28, ['pointer64', ['_ACTIVATION_CONTEXT']]],
    'FinalizationCallback' : [ 0x30, ['pointer64', ['void']]],
    'u' : [ 0x38, ['__unnamed_10a5']],
    'CallbackPriority' : [ 0x3c, ['Enumeration', dict(target = 'long', choices = {0: u'TP_CALLBACK_PRIORITY_HIGH', 1: u'TP_CALLBACK_PRIORITY_NORMAL', 2: u'TP_CALLBACK_PRIORITY_LOW', 3: u'TP_CALLBACK_PRIORITY_COUNT'})]],
    'Size' : [ 0x40, ['unsigned long']],
} ],
  '_TEB' : [ 0x1838, {
    'NtTib' : [ 0x0, ['_NT_TIB']],
    'EnvironmentPointer' : [ 0x38, ['pointer64', ['void']]],
    'ClientId' : [ 0x40, ['_CLIENT_ID']],
    'ActiveRpcHandle' : [ 0x50, ['pointer64', ['void']]],
    'ThreadLocalStoragePointer' : [ 0x58, ['pointer64', ['void']]],
    'ProcessEnvironmentBlock' : [ 0x60, ['pointer64', ['_PEB']]],
    'LastErrorValue' : [ 0x68, ['unsigned long']],
    'CountOfOwnedCriticalSections' : [ 0x6c, ['unsigned long']],
    'CsrClientThread' : [ 0x70, ['pointer64', ['void']]],
    'Win32ThreadInfo' : [ 0x78, ['pointer64', ['void']]],
    'User32Reserved' : [ 0x80, ['array', 26, ['unsigned long']]],
    'UserReserved' : [ 0xe8, ['array', 5, ['unsigned long']]],
    'WOW32Reserved' : [ 0x100, ['pointer64', ['void']]],
    'CurrentLocale' : [ 0x108, ['unsigned long']],
    'FpSoftwareStatusRegister' : [ 0x10c, ['unsigned long']],
    'ReservedForDebuggerInstrumentation' : [ 0x110, ['array', 16, ['pointer64', ['void']]]],
    'SystemReserved1' : [ 0x190, ['array', 30, ['pointer64', ['void']]]],
    'PlaceholderCompatibilityMode' : [ 0x280, ['unsigned char']],
    'PlaceholderReserved' : [ 0x281, ['array', 11, ['unsigned char']]],
    'ProxiedProcessId' : [ 0x28c, ['unsigned long']],
    '_ActivationStack' : [ 0x290, ['_ACTIVATION_CONTEXT_STACK']],
    'WorkingOnBehalfTicket' : [ 0x2b8, ['array', 8, ['unsigned char']]],
    'ExceptionCode' : [ 0x2c0, ['long']],
    'Padding0' : [ 0x2c4, ['array', 4, ['unsigned char']]],
    'ActivationContextStackPointer' : [ 0x2c8, ['pointer64', ['_ACTIVATION_CONTEXT_STACK']]],
    'InstrumentationCallbackSp' : [ 0x2d0, ['unsigned long long']],
    'InstrumentationCallbackPreviousPc' : [ 0x2d8, ['unsigned long long']],
    'InstrumentationCallbackPreviousSp' : [ 0x2e0, ['unsigned long long']],
    'TxFsContext' : [ 0x2e8, ['unsigned long']],
    'InstrumentationCallbackDisabled' : [ 0x2ec, ['unsigned char']],
    'Padding1' : [ 0x2ed, ['array', 3, ['unsigned char']]],
    'GdiTebBatch' : [ 0x2f0, ['_GDI_TEB_BATCH']],
    'RealClientId' : [ 0x7d8, ['_CLIENT_ID']],
    'GdiCachedProcessHandle' : [ 0x7e8, ['pointer64', ['void']]],
    'GdiClientPID' : [ 0x7f0, ['unsigned long']],
    'GdiClientTID' : [ 0x7f4, ['unsigned long']],
    'GdiThreadLocalInfo' : [ 0x7f8, ['pointer64', ['void']]],
    'Win32ClientInfo' : [ 0x800, ['array', 62, ['unsigned long long']]],
    'glDispatchTable' : [ 0x9f0, ['array', 233, ['pointer64', ['void']]]],
    'glReserved1' : [ 0x1138, ['array', 29, ['unsigned long long']]],
    'glReserved2' : [ 0x1220, ['pointer64', ['void']]],
    'glSectionInfo' : [ 0x1228, ['pointer64', ['void']]],
    'glSection' : [ 0x1230, ['pointer64', ['void']]],
    'glTable' : [ 0x1238, ['pointer64', ['void']]],
    'glCurrentRC' : [ 0x1240, ['pointer64', ['void']]],
    'glContext' : [ 0x1248, ['pointer64', ['void']]],
    'LastStatusValue' : [ 0x1250, ['unsigned long']],
    'Padding2' : [ 0x1254, ['array', 4, ['unsigned char']]],
    'StaticUnicodeString' : [ 0x1258, ['_UNICODE_STRING']],
    'StaticUnicodeBuffer' : [ 0x1268, ['array', 261, ['wchar']]],
    'Padding3' : [ 0x1472, ['array', 6, ['unsigned char']]],
    'DeallocationStack' : [ 0x1478, ['pointer64', ['void']]],
    'TlsSlots' : [ 0x1480, ['array', 64, ['pointer64', ['void']]]],
    'TlsLinks' : [ 0x1680, ['_LIST_ENTRY']],
    'Vdm' : [ 0x1690, ['pointer64', ['void']]],
    'ReservedForNtRpc' : [ 0x1698, ['pointer64', ['void']]],
    'DbgSsReserved' : [ 0x16a0, ['array', 2, ['pointer64', ['void']]]],
    'HardErrorMode' : [ 0x16b0, ['unsigned long']],
    'Padding4' : [ 0x16b4, ['array', 4, ['unsigned char']]],
    'Instrumentation' : [ 0x16b8, ['array', 11, ['pointer64', ['void']]]],
    'ActivityId' : [ 0x1710, ['_GUID']],
    'SubProcessTag' : [ 0x1720, ['pointer64', ['void']]],
    'PerflibData' : [ 0x1728, ['pointer64', ['void']]],
    'EtwTraceData' : [ 0x1730, ['pointer64', ['void']]],
    'WinSockData' : [ 0x1738, ['pointer64', ['void']]],
    'GdiBatchCount' : [ 0x1740, ['unsigned long']],
    'CurrentIdealProcessor' : [ 0x1744, ['_PROCESSOR_NUMBER']],
    'IdealProcessorValue' : [ 0x1744, ['unsigned long']],
    'ReservedPad0' : [ 0x1744, ['unsigned char']],
    'ReservedPad1' : [ 0x1745, ['unsigned char']],
    'ReservedPad2' : [ 0x1746, ['unsigned char']],
    'IdealProcessor' : [ 0x1747, ['unsigned char']],
    'GuaranteedStackBytes' : [ 0x1748, ['unsigned long']],
    'Padding5' : [ 0x174c, ['array', 4, ['unsigned char']]],
    'ReservedForPerf' : [ 0x1750, ['pointer64', ['void']]],
    'ReservedForOle' : [ 0x1758, ['pointer64', ['void']]],
    'WaitingOnLoaderLock' : [ 0x1760, ['unsigned long']],
    'Padding6' : [ 0x1764, ['array', 4, ['unsigned char']]],
    'SavedPriorityState' : [ 0x1768, ['pointer64', ['void']]],
    'ReservedForCodeCoverage' : [ 0x1770, ['unsigned long long']],
    'ThreadPoolData' : [ 0x1778, ['pointer64', ['void']]],
    'TlsExpansionSlots' : [ 0x1780, ['pointer64', ['pointer64', ['void']]]],
    'DeallocationBStore' : [ 0x1788, ['pointer64', ['void']]],
    'BStoreLimit' : [ 0x1790, ['pointer64', ['void']]],
    'MuiGeneration' : [ 0x1798, ['unsigned long']],
    'IsImpersonating' : [ 0x179c, ['unsigned long']],
    'NlsCache' : [ 0x17a0, ['pointer64', ['void']]],
    'pShimData' : [ 0x17a8, ['pointer64', ['void']]],
    'HeapVirtualAffinity' : [ 0x17b0, ['unsigned short']],
    'LowFragHeapDataSlot' : [ 0x17b2, ['unsigned short']],
    'Padding7' : [ 0x17b4, ['array', 4, ['unsigned char']]],
    'CurrentTransactionHandle' : [ 0x17b8, ['pointer64', ['void']]],
    'ActiveFrame' : [ 0x17c0, ['pointer64', ['_TEB_ACTIVE_FRAME']]],
    'FlsData' : [ 0x17c8, ['pointer64', ['void']]],
    'PreferredLanguages' : [ 0x17d0, ['pointer64', ['void']]],
    'UserPrefLanguages' : [ 0x17d8, ['pointer64', ['void']]],
    'MergedPrefLanguages' : [ 0x17e0, ['pointer64', ['void']]],
    'MuiImpersonation' : [ 0x17e8, ['unsigned long']],
    'CrossTebFlags' : [ 0x17ec, ['unsigned short']],
    'SpareCrossTebBits' : [ 0x17ec, ['BitField', dict(start_bit = 0, end_bit = 16, native_type='unsigned short')]],
    'SameTebFlags' : [ 0x17ee, ['unsigned short']],
    'SafeThunkCall' : [ 0x17ee, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
    'InDebugPrint' : [ 0x17ee, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned short')]],
    'HasFiberData' : [ 0x17ee, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned short')]],
    'SkipThreadAttach' : [ 0x17ee, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned short')]],
    'WerInShipAssertCode' : [ 0x17ee, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned short')]],
    'RanProcessInit' : [ 0x17ee, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned short')]],
    'ClonedThread' : [ 0x17ee, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned short')]],
    'SuppressDebugMsg' : [ 0x17ee, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned short')]],
    'DisableUserStackWalk' : [ 0x17ee, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned short')]],
    'RtlExceptionAttached' : [ 0x17ee, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned short')]],
    'InitialThread' : [ 0x17ee, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned short')]],
    'SessionAware' : [ 0x17ee, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned short')]],
    'LoadOwner' : [ 0x17ee, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned short')]],
    'LoaderWorker' : [ 0x17ee, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned short')]],
    'SkipLoaderInit' : [ 0x17ee, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned short')]],
    'SpareSameTebBits' : [ 0x17ee, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned short')]],
    'TxnScopeEnterCallback' : [ 0x17f0, ['pointer64', ['void']]],
    'TxnScopeExitCallback' : [ 0x17f8, ['pointer64', ['void']]],
    'TxnScopeContext' : [ 0x1800, ['pointer64', ['void']]],
    'LockCount' : [ 0x1808, ['unsigned long']],
    'WowTebOffset' : [ 0x180c, ['long']],
    'ResourceRetValue' : [ 0x1810, ['pointer64', ['void']]],
    'ReservedForWdf' : [ 0x1818, ['pointer64', ['void']]],
    'ReservedForCrt' : [ 0x1820, ['unsigned long long']],
    'EffectiveContainerId' : [ 0x1828, ['_GUID']],
} ],
  '_LIST_ENTRY' : [ 0x10, {
    'Flink' : [ 0x0, ['pointer64', ['_LIST_ENTRY']]],
    'Blink' : [ 0x8, ['pointer64', ['_LIST_ENTRY']]],
} ],
  '_SINGLE_LIST_ENTRY' : [ 0x8, {
    'Next' : [ 0x0, ['pointer64', ['_SINGLE_LIST_ENTRY']]],
} ],
  '_RTL_SPLAY_LINKS' : [ 0x18, {
    'Parent' : [ 0x0, ['pointer64', ['_RTL_SPLAY_LINKS']]],
    'LeftChild' : [ 0x8, ['pointer64', ['_RTL_SPLAY_LINKS']]],
    'RightChild' : [ 0x10, ['pointer64', ['_RTL_SPLAY_LINKS']]],
} ],
  '_RTL_DYNAMIC_HASH_TABLE_CONTEXT' : [ 0x18, {
    'ChainHead' : [ 0x0, ['pointer64', ['_LIST_ENTRY']]],
    'PrevLinkage' : [ 0x8, ['pointer64', ['_LIST_ENTRY']]],
    'Signature' : [ 0x10, ['unsigned long long']],
} ],
  '_RTL_DYNAMIC_HASH_TABLE_ENUMERATOR' : [ 0x28, {
    'HashEntry' : [ 0x0, ['_RTL_DYNAMIC_HASH_TABLE_ENTRY']],
    'CurEntry' : [ 0x0, ['pointer64', ['_LIST_ENTRY']]],
    'ChainHead' : [ 0x18, ['pointer64', ['_LIST_ENTRY']]],
    'BucketIndex' : [ 0x20, ['unsigned long']],
} ],
  '_RTL_DYNAMIC_HASH_TABLE' : [ 0x28, {
    'Flags' : [ 0x0, ['unsigned long']],
    'Shift' : [ 0x4, ['unsigned long']],
    'TableSize' : [ 0x8, ['unsigned long']],
    'Pivot' : [ 0xc, ['unsigned long']],
    'DivisorMask' : [ 0x10, ['unsigned long']],
    'NumEntries' : [ 0x14, ['unsigned long']],
    'NonEmptyBuckets' : [ 0x18, ['unsigned long']],
    'NumEnumerators' : [ 0x1c, ['unsigned long']],
    'Directory' : [ 0x20, ['pointer64', ['void']]],
} ],
  '_UNICODE_STRING' : [ 0x10, {
    'Length' : [ 0x0, ['unsigned short']],
    'MaximumLength' : [ 0x2, ['unsigned short']],
    'Buffer' : [ 0x8, ['pointer64', ['wchar']]],
} ],
  '_STRING' : [ 0x10, {
    'Length' : [ 0x0, ['unsigned short']],
    'MaximumLength' : [ 0x2, ['unsigned short']],
    'Buffer' : [ 0x8, ['pointer64', ['unsigned char']]],
} ],
  '__unnamed_1117' : [ 0x8, {
    'LowPart' : [ 0x0, ['unsigned long']],
    'HighPart' : [ 0x4, ['long']],
} ],
  '_LARGE_INTEGER' : [ 0x8, {
    'LowPart' : [ 0x0, ['unsigned long']],
    'HighPart' : [ 0x4, ['long']],
    'u' : [ 0x0, ['__unnamed_1117']],
    'QuadPart' : [ 0x0, ['long long']],
} ],
  '_RTL_BITMAP' : [ 0x10, {
    'SizeOfBitMap' : [ 0x0, ['unsigned long']],
    'Buffer' : [ 0x8, ['pointer64', ['unsigned long']]],
} ],
  '_LUID' : [ 0x8, {
    'LowPart' : [ 0x0, ['unsigned long']],
    'HighPart' : [ 0x4, ['long']],
} ],
  '_CUSTOM_SYSTEM_EVENT_TRIGGER_CONFIG' : [ 0x10, {
    'Size' : [ 0x0, ['unsigned long']],
    'TriggerId' : [ 0x8, ['pointer64', ['wchar']]],
} ],
  '_IMAGE_NT_HEADERS64' : [ 0x108, {
    'Signature' : [ 0x0, ['unsigned long']],
    'FileHeader' : [ 0x4, ['_IMAGE_FILE_HEADER']],
    'OptionalHeader' : [ 0x18, ['_IMAGE_OPTIONAL_HEADER64']],
} ],
  '_IMAGE_DOS_HEADER' : [ 0x40, {
    'e_magic' : [ 0x0, ['unsigned short']],
    'e_cblp' : [ 0x2, ['unsigned short']],
    'e_cp' : [ 0x4, ['unsigned short']],
    'e_crlc' : [ 0x6, ['unsigned short']],
    'e_cparhdr' : [ 0x8, ['unsigned short']],
    'e_minalloc' : [ 0xa, ['unsigned short']],
    'e_maxalloc' : [ 0xc, ['unsigned short']],
    'e_ss' : [ 0xe, ['unsigned short']],
    'e_sp' : [ 0x10, ['unsigned short']],
    'e_csum' : [ 0x12, ['unsigned short']],
    'e_ip' : [ 0x14, ['unsigned short']],
    'e_cs' : [ 0x16, ['unsigned short']],
    'e_lfarlc' : [ 0x18, ['unsigned short']],
    'e_ovno' : [ 0x1a, ['unsigned short']],
    'e_res' : [ 0x1c, ['array', 4, ['unsigned short']]],
    'e_oemid' : [ 0x24, ['unsigned short']],
    'e_oeminfo' : [ 0x26, ['unsigned short']],
    'e_res2' : [ 0x28, ['array', 10, ['unsigned short']]],
    'e_lfanew' : [ 0x3c, ['long']],
} ],
  '_RTL_BALANCED_NODE' : [ 0x18, {
    'Children' : [ 0x0, ['array', 2, ['pointer64', ['_RTL_BALANCED_NODE']]]],
    'Left' : [ 0x0, ['pointer64', ['_RTL_BALANCED_NODE']]],
    'Right' : [ 0x8, ['pointer64', ['_RTL_BALANCED_NODE']]],
    'Red' : [ 0x10, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'Balance' : [ 0x10, ['BitField', dict(start_bit = 0, end_bit = 2, native_type='unsigned char')]],
    'ParentValue' : [ 0x10, ['unsigned long long']],
} ],
  '_RTL_RB_TREE' : [ 0x10, {
    'Root' : [ 0x0, ['pointer64', ['_RTL_BALANCED_NODE']]],
    'Encoded' : [ 0x8, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'Min' : [ 0x8, ['pointer64', ['_RTL_BALANCED_NODE']]],
} ],
  '_RTL_AVL_TREE' : [ 0x8, {
    'Root' : [ 0x0, ['pointer64', ['_RTL_BALANCED_NODE']]],
} ],
  '_GUID' : [ 0x10, {
    'Data1' : [ 0x0, ['unsigned long']],
    'Data2' : [ 0x4, ['unsigned short']],
    'Data3' : [ 0x6, ['unsigned short']],
    'Data4' : [ 0x8, ['array', 8, ['unsigned char']]],
} ],
  '_KPCR' : [ 0x8040, {
    'NtTib' : [ 0x0, ['_NT_TIB']],
    'GdtBase' : [ 0x0, ['pointer64', ['_KGDTENTRY64']]],
    'TssBase' : [ 0x8, ['pointer64', ['_KTSS64']]],
    'UserRsp' : [ 0x10, ['unsigned long long']],
    'Self' : [ 0x18, ['pointer64', ['_KPCR']]],
    'CurrentPrcb' : [ 0x20, ['pointer64', ['_KPRCB']]],
    'LockArray' : [ 0x28, ['pointer64', ['_KSPIN_LOCK_QUEUE']]],
    'Used_Self' : [ 0x30, ['pointer64', ['void']]],
    'IdtBase' : [ 0x38, ['pointer64', ['_KIDTENTRY64']]],
    'Unused' : [ 0x40, ['array', 2, ['unsigned long long']]],
    'Irql' : [ 0x50, ['unsigned char']],
    'SecondLevelCacheAssociativity' : [ 0x51, ['unsigned char']],
    'ObsoleteNumber' : [ 0x52, ['unsigned char']],
    'Fill0' : [ 0x53, ['unsigned char']],
    'Unused0' : [ 0x54, ['array', 3, ['unsigned long']]],
    'MajorVersion' : [ 0x60, ['unsigned short']],
    'MinorVersion' : [ 0x62, ['unsigned short']],
    'StallScaleFactor' : [ 0x64, ['unsigned long']],
    'Unused1' : [ 0x68, ['array', 3, ['pointer64', ['void']]]],
    'KernelReserved' : [ 0x80, ['array', 15, ['unsigned long']]],
    'SecondLevelCacheSize' : [ 0xbc, ['unsigned long']],
    'HalReserved' : [ 0xc0, ['array', 16, ['unsigned long']]],
    'Unused2' : [ 0x100, ['unsigned long']],
    'KdVersionBlock' : [ 0x108, ['pointer64', ['void']]],
    'Unused3' : [ 0x110, ['pointer64', ['void']]],
    'PcrAlign1' : [ 0x118, ['array', 24, ['unsigned long']]],
    'Prcb' : [ 0x180, ['_KPRCB']],
} ],
  '_KPRCB' : [ 0x7ec0, {
    'MxCsr' : [ 0x0, ['unsigned long']],
    'LegacyNumber' : [ 0x4, ['unsigned char']],
    'ReservedMustBeZero' : [ 0x5, ['unsigned char']],
    'InterruptRequest' : [ 0x6, ['unsigned char']],
    'IdleHalt' : [ 0x7, ['unsigned char']],
    'CurrentThread' : [ 0x8, ['pointer64', ['_KTHREAD']]],
    'NextThread' : [ 0x10, ['pointer64', ['_KTHREAD']]],
    'IdleThread' : [ 0x18, ['pointer64', ['_KTHREAD']]],
    'NestingLevel' : [ 0x20, ['unsigned char']],
    'ClockOwner' : [ 0x21, ['unsigned char']],
    'PendingTickFlags' : [ 0x22, ['unsigned char']],
    'PendingTick' : [ 0x22, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'PendingBackupTick' : [ 0x22, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'IdleState' : [ 0x23, ['unsigned char']],
    'Number' : [ 0x24, ['unsigned long']],
    'RspBase' : [ 0x28, ['unsigned long long']],
    'PrcbLock' : [ 0x30, ['unsigned long long']],
    'PriorityState' : [ 0x38, ['pointer64', ['unsigned char']]],
    'CpuType' : [ 0x40, ['unsigned char']],
    'CpuID' : [ 0x41, ['unsigned char']],
    'CpuStep' : [ 0x42, ['unsigned short']],
    'CpuStepping' : [ 0x42, ['unsigned char']],
    'CpuModel' : [ 0x43, ['unsigned char']],
    'MHz' : [ 0x44, ['unsigned long']],
    'HalReserved' : [ 0x48, ['array', 8, ['unsigned long long']]],
    'MinorVersion' : [ 0x88, ['unsigned short']],
    'MajorVersion' : [ 0x8a, ['unsigned short']],
    'BuildType' : [ 0x8c, ['unsigned char']],
    'CpuVendor' : [ 0x8d, ['unsigned char']],
    'CoresPerPhysicalProcessor' : [ 0x8e, ['unsigned char']],
    'LogicalProcessorsPerCore' : [ 0x8f, ['unsigned char']],
    'PrcbPad04' : [ 0x90, ['array', 6, ['unsigned long long']]],
    'ParentNode' : [ 0xc0, ['pointer64', ['_KNODE']]],
    'GroupSetMember' : [ 0xc8, ['unsigned long long']],
    'Group' : [ 0xd0, ['unsigned char']],
    'GroupIndex' : [ 0xd1, ['unsigned char']],
    'PrcbPad05' : [ 0xd2, ['array', 2, ['unsigned char']]],
    'InitialApicId' : [ 0xd4, ['unsigned long']],
    'ScbOffset' : [ 0xd8, ['unsigned long']],
    'ApicMask' : [ 0xdc, ['unsigned long']],
    'AcpiReserved' : [ 0xe0, ['pointer64', ['void']]],
    'CFlushSize' : [ 0xe8, ['unsigned long']],
    'PrcbFlags' : [ 0xec, ['_KPRCBFLAG']],
    'TrappedSecurityDomain' : [ 0xf0, ['unsigned long long']],
    'BpbState' : [ 0xf8, ['unsigned short']],
    'BpbIbrsPresent' : [ 0xf8, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
    'BpbStibpPresent' : [ 0xf8, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned short')]],
    'BpbSmepPresent' : [ 0xf8, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned short')]],
    'BpbSimulateSpecCtrl' : [ 0xf8, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned short')]],
    'BpbSimulateIbpb' : [ 0xf8, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned short')]],
    'BpbIbpbPresent' : [ 0xf8, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned short')]],
    'BpbCpuIdle' : [ 0xf8, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned short')]],
    'BpbClearSpecCtrlOnIdle' : [ 0xf8, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned short')]],
    'BpbHTDisabled' : [ 0xf8, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned short')]],
    'BpbUserToUserOnly' : [ 0xf8, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned short')]],
    'BpbReserved' : [ 0xf8, ['BitField', dict(start_bit = 10, end_bit = 16, native_type='unsigned short')]],
    'BpbSpecCtrlValue' : [ 0xfa, ['unsigned char']],
    'BpbCtxSwapSetValue' : [ 0xfb, ['unsigned char']],
    'BpbPad' : [ 0xfc, ['array', 4, ['unsigned char']]],
    'PrcbPad11' : [ 0xf0, ['array', 2, ['unsigned long long']]],
    'ProcessorState' : [ 0x100, ['_KPROCESSOR_STATE']],
    'ExtendedSupervisorState' : [ 0x6c0, ['pointer64', ['_XSAVE_AREA_HEADER']]],
    'PrcbPad12' : [ 0x6c8, ['array', 5, ['unsigned long long']]],
    'LockQueue' : [ 0x6f0, ['array', 17, ['_KSPIN_LOCK_QUEUE']]],
    'PPLookasideList' : [ 0x800, ['array', 16, ['_PP_LOOKASIDE_LIST']]],
    'PPNxPagedLookasideList' : [ 0x900, ['array', 32, ['_GENERAL_LOOKASIDE_POOL']]],
    'PPNPagedLookasideList' : [ 0x1500, ['array', 32, ['_GENERAL_LOOKASIDE_POOL']]],
    'PPPagedLookasideList' : [ 0x2100, ['array', 32, ['_GENERAL_LOOKASIDE_POOL']]],
    'PrcbPad20' : [ 0x2d00, ['unsigned long long']],
    'DeferredReadyListHead' : [ 0x2d08, ['_SINGLE_LIST_ENTRY']],
    'MmPageFaultCount' : [ 0x2d10, ['long']],
    'MmCopyOnWriteCount' : [ 0x2d14, ['long']],
    'MmTransitionCount' : [ 0x2d18, ['long']],
    'MmDemandZeroCount' : [ 0x2d1c, ['long']],
    'MmPageReadCount' : [ 0x2d20, ['long']],
    'MmPageReadIoCount' : [ 0x2d24, ['long']],
    'MmDirtyPagesWriteCount' : [ 0x2d28, ['long']],
    'MmDirtyWriteIoCount' : [ 0x2d2c, ['long']],
    'MmMappedPagesWriteCount' : [ 0x2d30, ['long']],
    'MmMappedWriteIoCount' : [ 0x2d34, ['long']],
    'KeSystemCalls' : [ 0x2d38, ['unsigned long']],
    'KeContextSwitches' : [ 0x2d3c, ['unsigned long']],
    'PrcbPad40' : [ 0x2d40, ['unsigned long']],
    'CcFastReadNoWait' : [ 0x2d44, ['unsigned long']],
    'CcFastReadWait' : [ 0x2d48, ['unsigned long']],
    'CcFastReadNotPossible' : [ 0x2d4c, ['unsigned long']],
    'CcCopyReadNoWait' : [ 0x2d50, ['unsigned long']],
    'CcCopyReadWait' : [ 0x2d54, ['unsigned long']],
    'CcCopyReadNoWaitMiss' : [ 0x2d58, ['unsigned long']],
    'IoReadOperationCount' : [ 0x2d5c, ['long']],
    'IoWriteOperationCount' : [ 0x2d60, ['long']],
    'IoOtherOperationCount' : [ 0x2d64, ['long']],
    'IoReadTransferCount' : [ 0x2d68, ['_LARGE_INTEGER']],
    'IoWriteTransferCount' : [ 0x2d70, ['_LARGE_INTEGER']],
    'IoOtherTransferCount' : [ 0x2d78, ['_LARGE_INTEGER']],
    'PacketBarrier' : [ 0x2d80, ['long']],
    'TargetCount' : [ 0x2d84, ['long']],
    'IpiFrozen' : [ 0x2d88, ['unsigned long']],
    'PrcbPad30' : [ 0x2d8c, ['unsigned long']],
    'IsrDpcStats' : [ 0x2d90, ['pointer64', ['void']]],
    'DeviceInterrupts' : [ 0x2d98, ['unsigned long']],
    'LookasideIrpFloat' : [ 0x2d9c, ['long']],
    'InterruptLastCount' : [ 0x2da0, ['unsigned long']],
    'InterruptRate' : [ 0x2da4, ['unsigned long']],
    'LastNonHrTimerExpiration' : [ 0x2da8, ['unsigned long long']],
    'PrcbPad35' : [ 0x2db0, ['array', 2, ['unsigned long long']]],
    'InterruptObjectPool' : [ 0x2dc0, ['_SLIST_HEADER']],
    'PrcbPad41' : [ 0x2dd0, ['array', 6, ['unsigned long long']]],
    'DpcData' : [ 0x2e00, ['array', 2, ['_KDPC_DATA']]],
    'DpcStack' : [ 0x2e50, ['pointer64', ['void']]],
    'MaximumDpcQueueDepth' : [ 0x2e58, ['long']],
    'DpcRequestRate' : [ 0x2e5c, ['unsigned long']],
    'MinimumDpcRate' : [ 0x2e60, ['unsigned long']],
    'DpcLastCount' : [ 0x2e64, ['unsigned long']],
    'ThreadDpcEnable' : [ 0x2e68, ['unsigned char']],
    'QuantumEnd' : [ 0x2e69, ['unsigned char']],
    'DpcRoutineActive' : [ 0x2e6a, ['unsigned char']],
    'IdleSchedule' : [ 0x2e6b, ['unsigned char']],
    'DpcRequestSummary' : [ 0x2e6c, ['long']],
    'DpcRequestSlot' : [ 0x2e6c, ['array', 2, ['short']]],
    'NormalDpcState' : [ 0x2e6c, ['short']],
    'ThreadDpcState' : [ 0x2e6e, ['short']],
    'DpcNormalProcessingActive' : [ 0x2e6c, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'DpcNormalProcessingRequested' : [ 0x2e6c, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'DpcNormalThreadSignal' : [ 0x2e6c, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'DpcNormalTimerExpiration' : [ 0x2e6c, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'DpcNormalDpcPresent' : [ 0x2e6c, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'DpcNormalLocalInterrupt' : [ 0x2e6c, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'DpcNormalSpare' : [ 0x2e6c, ['BitField', dict(start_bit = 6, end_bit = 16, native_type='unsigned long')]],
    'DpcThreadActive' : [ 0x2e6c, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'DpcThreadRequested' : [ 0x2e6c, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'DpcThreadSpare' : [ 0x2e6c, ['BitField', dict(start_bit = 18, end_bit = 32, native_type='unsigned long')]],
    'LastTimerHand' : [ 0x2e70, ['unsigned long']],
    'LastTick' : [ 0x2e74, ['unsigned long']],
    'ClockInterrupts' : [ 0x2e78, ['unsigned long']],
    'ReadyScanTick' : [ 0x2e7c, ['unsigned long']],
    'InterruptObject' : [ 0x2e80, ['array', 256, ['pointer64', ['void']]]],
    'TimerTable' : [ 0x3680, ['_KTIMER_TABLE']],
    'DpcGate' : [ 0x5880, ['_KGATE']],
    'PrcbPad52' : [ 0x5898, ['pointer64', ['void']]],
    'CallDpc' : [ 0x58a0, ['_KDPC']],
    'ClockKeepAlive' : [ 0x58e0, ['long']],
    'PrcbPad60' : [ 0x58e4, ['array', 2, ['unsigned char']]],
    'NmiActive' : [ 0x58e6, ['unsigned short']],
    'DpcWatchdogPeriod' : [ 0x58e8, ['long']],
    'DpcWatchdogCount' : [ 0x58ec, ['long']],
    'KeSpinLockOrdering' : [ 0x58f0, ['long']],
    'DpcWatchdogProfileCumulativeDpcThreshold' : [ 0x58f4, ['unsigned long']],
    'CachedPtes' : [ 0x58f8, ['pointer64', ['void']]],
    'WaitListHead' : [ 0x5900, ['_LIST_ENTRY']],
    'WaitLock' : [ 0x5910, ['unsigned long long']],
    'ReadySummary' : [ 0x5918, ['unsigned long']],
    'AffinitizedSelectionMask' : [ 0x591c, ['long']],
    'QueueIndex' : [ 0x5920, ['unsigned long']],
    'PrcbPad75' : [ 0x5924, ['array', 3, ['unsigned long']]],
    'TimerExpirationDpc' : [ 0x5930, ['_KDPC']],
    'ScbQueue' : [ 0x5970, ['_RTL_RB_TREE']],
    'DispatcherReadyListHead' : [ 0x5980, ['array', 32, ['_LIST_ENTRY']]],
    'InterruptCount' : [ 0x5b80, ['unsigned long']],
    'KernelTime' : [ 0x5b84, ['unsigned long']],
    'UserTime' : [ 0x5b88, ['unsigned long']],
    'DpcTime' : [ 0x5b8c, ['unsigned long']],
    'InterruptTime' : [ 0x5b90, ['unsigned long']],
    'AdjustDpcThreshold' : [ 0x5b94, ['unsigned long']],
    'DebuggerSavedIRQL' : [ 0x5b98, ['unsigned char']],
    'GroupSchedulingOverQuota' : [ 0x5b99, ['unsigned char']],
    'DeepSleep' : [ 0x5b9a, ['unsigned char']],
    'PrcbPad80' : [ 0x5b9b, ['unsigned char']],
    'DpcTimeCount' : [ 0x5b9c, ['unsigned long']],
    'DpcTimeLimit' : [ 0x5ba0, ['unsigned long']],
    'PeriodicCount' : [ 0x5ba4, ['unsigned long']],
    'PeriodicBias' : [ 0x5ba8, ['unsigned long']],
    'AvailableTime' : [ 0x5bac, ['unsigned long']],
    'KeExceptionDispatchCount' : [ 0x5bb0, ['unsigned long']],
    'ReadyThreadCount' : [ 0x5bb4, ['unsigned long']],
    'ReadyQueueExpectedRunTime' : [ 0x5bb8, ['unsigned long long']],
    'StartCycles' : [ 0x5bc0, ['unsigned long long']],
    'TaggedCyclesStart' : [ 0x5bc8, ['unsigned long long']],
    'TaggedCycles' : [ 0x5bd0, ['array', 2, ['unsigned long long']]],
    'GenerationTarget' : [ 0x5be0, ['unsigned long long']],
    'AffinitizedCycles' : [ 0x5be8, ['unsigned long long']],
    'ImportantCycles' : [ 0x5bf0, ['unsigned long long']],
    'UnimportantCycles' : [ 0x5bf8, ['unsigned long long']],
    'DpcWatchdogProfileSingleDpcThreshold' : [ 0x5c00, ['unsigned long']],
    'MmSpinLockOrdering' : [ 0x5c04, ['long']],
    'CachedStack' : [ 0x5c08, ['pointer64', ['void']]],
    'PageColor' : [ 0x5c10, ['unsigned long']],
    'NodeColor' : [ 0x5c14, ['unsigned long']],
    'NodeShiftedColor' : [ 0x5c18, ['unsigned long']],
    'SecondaryColorMask' : [ 0x5c1c, ['unsigned long']],
    'PrcbPad81' : [ 0x5c20, ['array', 7, ['unsigned char']]],
    'TbFlushListActive' : [ 0x5c27, ['unsigned char']],
    'PrcbPad82' : [ 0x5c28, ['array', 2, ['unsigned long long']]],
    'CycleTime' : [ 0x5c38, ['unsigned long long']],
    'Cycles' : [ 0x5c40, ['array', 4, ['array', 2, ['unsigned long long']]]],
    'CcFastMdlReadNoWait' : [ 0x5c80, ['unsigned long']],
    'CcFastMdlReadWait' : [ 0x5c84, ['unsigned long']],
    'CcFastMdlReadNotPossible' : [ 0x5c88, ['unsigned long']],
    'CcMapDataNoWait' : [ 0x5c8c, ['unsigned long']],
    'CcMapDataWait' : [ 0x5c90, ['unsigned long']],
    'CcPinMappedDataCount' : [ 0x5c94, ['unsigned long']],
    'CcPinReadNoWait' : [ 0x5c98, ['unsigned long']],
    'CcPinReadWait' : [ 0x5c9c, ['unsigned long']],
    'CcMdlReadNoWait' : [ 0x5ca0, ['unsigned long']],
    'CcMdlReadWait' : [ 0x5ca4, ['unsigned long']],
    'CcLazyWriteHotSpots' : [ 0x5ca8, ['unsigned long']],
    'CcLazyWriteIos' : [ 0x5cac, ['unsigned long']],
    'CcLazyWritePages' : [ 0x5cb0, ['unsigned long']],
    'CcDataFlushes' : [ 0x5cb4, ['unsigned long']],
    'CcDataPages' : [ 0x5cb8, ['unsigned long']],
    'CcLostDelayedWrites' : [ 0x5cbc, ['unsigned long']],
    'CcFastReadResourceMiss' : [ 0x5cc0, ['unsigned long']],
    'CcCopyReadWaitMiss' : [ 0x5cc4, ['unsigned long']],
    'CcFastMdlReadResourceMiss' : [ 0x5cc8, ['unsigned long']],
    'CcMapDataNoWaitMiss' : [ 0x5ccc, ['unsigned long']],
    'CcMapDataWaitMiss' : [ 0x5cd0, ['unsigned long']],
    'CcPinReadNoWaitMiss' : [ 0x5cd4, ['unsigned long']],
    'CcPinReadWaitMiss' : [ 0x5cd8, ['unsigned long']],
    'CcMdlReadNoWaitMiss' : [ 0x5cdc, ['unsigned long']],
    'CcMdlReadWaitMiss' : [ 0x5ce0, ['unsigned long']],
    'CcReadAheadIos' : [ 0x5ce4, ['unsigned long']],
    'MmCacheTransitionCount' : [ 0x5ce8, ['long']],
    'MmCacheReadCount' : [ 0x5cec, ['long']],
    'MmCacheIoCount' : [ 0x5cf0, ['long']],
    'PrcbPad91' : [ 0x5cf4, ['unsigned long']],
    'MmFlushList' : [ 0x5cf8, ['pointer64', ['void']]],
    'PowerState' : [ 0x5d00, ['_PROCESSOR_POWER_STATE']],
    'HyperPte' : [ 0x5f00, ['pointer64', ['void']]],
    'ScbList' : [ 0x5f08, ['_LIST_ENTRY']],
    'ForceIdleDpc' : [ 0x5f18, ['_KDPC']],
    'DpcWatchdogDpc' : [ 0x5f58, ['_KDPC']],
    'DpcWatchdogTimer' : [ 0x5f98, ['_KTIMER']],
    'Cache' : [ 0x5fd8, ['array', 5, ['_CACHE_DESCRIPTOR']]],
    'CacheCount' : [ 0x6014, ['unsigned long']],
    'CachedCommit' : [ 0x6018, ['unsigned long']],
    'CachedResidentAvailable' : [ 0x601c, ['unsigned long']],
    'WheaInfo' : [ 0x6020, ['pointer64', ['void']]],
    'EtwSupport' : [ 0x6028, ['pointer64', ['void']]],
    'ExSaPageArray' : [ 0x6030, ['pointer64', ['void']]],
    'KeAlignmentFixupCount' : [ 0x6038, ['unsigned long']],
    'PrcbPad95' : [ 0x603c, ['unsigned long']],
    'HypercallPageList' : [ 0x6040, ['_SLIST_HEADER']],
    'StatisticsPage' : [ 0x6050, ['pointer64', ['unsigned long long']]],
    'PrcbPad85' : [ 0x6058, ['array', 5, ['unsigned long long']]],
    'HypercallCachedPages' : [ 0x6080, ['pointer64', ['void']]],
    'VirtualApicAssist' : [ 0x6088, ['pointer64', ['void']]],
    'PackageProcessorSet' : [ 0x6090, ['_KAFFINITY_EX']],
    'PrcbPad86' : [ 0x6138, ['unsigned long long']],
    'SharedReadyQueueMask' : [ 0x6140, ['unsigned long long']],
    'SharedReadyQueue' : [ 0x6148, ['pointer64', ['_KSHARED_READY_QUEUE']]],
    'SharedQueueScanOwner' : [ 0x6150, ['unsigned long']],
    'ScanSiblingIndex' : [ 0x6154, ['unsigned long']],
    'CoreProcessorSet' : [ 0x6158, ['unsigned long long']],
    'ScanSiblingMask' : [ 0x6160, ['unsigned long long']],
    'LLCMask' : [ 0x6168, ['unsigned long long']],
    'CacheProcessorMask' : [ 0x6170, ['array', 5, ['unsigned long long']]],
    'ProcessorProfileControlArea' : [ 0x6198, ['pointer64', ['_PROCESSOR_PROFILE_CONTROL_AREA']]],
    'ProfileEventIndexAddress' : [ 0x61a0, ['pointer64', ['void']]],
    'DpcWatchdogProfile' : [ 0x61a8, ['pointer64', ['pointer64', ['void']]]],
    'DpcWatchdogProfileCurrentEmptyCapture' : [ 0x61b0, ['pointer64', ['pointer64', ['void']]]],
    'SchedulerAssist' : [ 0x61b8, ['pointer64', ['void']]],
    'SynchCounters' : [ 0x61c0, ['_SYNCH_COUNTERS']],
    'PrcbPad94' : [ 0x6278, ['unsigned long long']],
    'FsCounters' : [ 0x6280, ['_FILESYSTEM_DISK_COUNTERS']],
    'VendorString' : [ 0x6290, ['array', 13, ['unsigned char']]],
    'PrcbPad100' : [ 0x629d, ['array', 3, ['unsigned char']]],
    'FeatureBits' : [ 0x62a0, ['unsigned long long']],
    'UpdateSignature' : [ 0x62a8, ['_LARGE_INTEGER']],
    'PteBitCache' : [ 0x62b0, ['unsigned long long']],
    'PteBitOffset' : [ 0x62b8, ['unsigned long']],
    'PrcbPad105' : [ 0x62bc, ['unsigned long']],
    'Context' : [ 0x62c0, ['pointer64', ['_CONTEXT']]],
    'ContextFlagsInit' : [ 0x62c8, ['unsigned long']],
    'PrcbPad115' : [ 0x62cc, ['unsigned long']],
    'ExtendedState' : [ 0x62d0, ['pointer64', ['_XSAVE_AREA']]],
    'IsrStack' : [ 0x62d8, ['pointer64', ['void']]],
    'EntropyTimingState' : [ 0x62e0, ['_KENTROPY_TIMING_STATE']],
    'PrcbPad110' : [ 0x6430, ['unsigned long long']],
    'PrcbPad111' : [ 0x6438, ['array', 7, ['unsigned long long']]],
    'AbSelfIoBoostsList' : [ 0x6470, ['_SINGLE_LIST_ENTRY']],
    'AbPropagateBoostsList' : [ 0x6478, ['_SINGLE_LIST_ENTRY']],
    'AbDpc' : [ 0x6480, ['_KDPC']],
    'IoIrpStackProfilerCurrent' : [ 0x64c0, ['_IOP_IRP_STACK_PROFILER']],
    'IoIrpStackProfilerPrevious' : [ 0x6514, ['_IOP_IRP_STACK_PROFILER']],
    'SecureFault' : [ 0x6568, ['_KSECURE_FAULT_INFORMATION']],
    'PrcbPad120' : [ 0x6578, ['unsigned long long']],
    'LocalSharedReadyQueue' : [ 0x6580, ['_KSHARED_READY_QUEUE']],
    'PrcbPad125' : [ 0x67f0, ['array', 2, ['unsigned long long']]],
    'TimerExpirationTraceCount' : [ 0x6800, ['unsigned long']],
    'PrcbPad127' : [ 0x6804, ['unsigned long']],
    'TimerExpirationTrace' : [ 0x6808, ['array', 16, ['_KTIMER_EXPIRATION_TRACE']]],
    'PrcbPad128' : [ 0x6908, ['array', 7, ['unsigned long long']]],
    'Mailbox' : [ 0x6940, ['pointer64', ['_REQUEST_MAILBOX']]],
    'PrcbPad130' : [ 0x6948, ['array', 7, ['unsigned long long']]],
    'SelfmapLockHandle' : [ 0x6980, ['array', 4, ['_KLOCK_QUEUE_HANDLE']]],
    'PrcbPad135' : [ 0x69e0, ['array', 1184, ['unsigned char']]],
    'KernelDirectoryTableBase' : [ 0x6e80, ['unsigned long long']],
    'RspBaseShadow' : [ 0x6e88, ['unsigned long long']],
    'UserRspShadow' : [ 0x6e90, ['unsigned long long']],
    'ShadowFlags' : [ 0x6e98, ['unsigned long']],
    'PrcbPad139' : [ 0x6e9c, ['unsigned long']],
    'PrcbPad140' : [ 0x6ea0, ['array', 508, ['unsigned long long']]],
    'RequestMailbox' : [ 0x7e80, ['array', 1, ['_REQUEST_MAILBOX']]],
} ],
  '_KFLOATING_SAVE' : [ 0x4, {
    'Dummy' : [ 0x0, ['unsigned long']],
} ],
  '__unnamed_11e8' : [ 0x10, {
    'Pcid' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 12, native_type='unsigned long long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 64, native_type='unsigned long long')]],
    'EntirePcid' : [ 0x0, ['unsigned long long']],
    'Virtual' : [ 0x8, ['unsigned long long']],
} ],
  '__unnamed_11ea' : [ 0x10, {
    'Pcid' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 12, native_type='unsigned long long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 64, native_type='unsigned long long')]],
    'EntirePcid' : [ 0x0, ['unsigned long long']],
    'Reserved2' : [ 0x8, ['unsigned long long']],
} ],
  '__unnamed_11ec' : [ 0x10, {
    'Reserved' : [ 0x0, ['array', 2, ['unsigned long long']]],
} ],
  '_INVPCID_DESCRIPTOR' : [ 0x10, {
    'IndividualAddress' : [ 0x0, ['__unnamed_11e8']],
    'SingleContext' : [ 0x0, ['__unnamed_11ea']],
    'AllContextAndGlobals' : [ 0x0, ['__unnamed_11ec']],
    'AllContext' : [ 0x0, ['__unnamed_11ec']],
} ],
  '_SINGLE_LIST_ENTRY32' : [ 0x4, {
    'Next' : [ 0x0, ['unsigned long']],
} ],
  '_EXT_SET_PARAMETERS_V0' : [ 0x10, {
    'Version' : [ 0x0, ['unsigned long']],
    'Reserved' : [ 0x4, ['unsigned long']],
    'NoWakeTolerance' : [ 0x8, ['long long']],
} ],
  '_PS_TRUSTLET_CREATE_ATTRIBUTES' : [ 0x18, {
    'TrustletIdentity' : [ 0x0, ['unsigned long long']],
    'Attributes' : [ 0x8, ['array', 1, ['_PS_TRUSTLET_ATTRIBUTE_DATA']]],
} ],
  '_PS_TRUSTLET_ATTRIBUTE_DATA' : [ 0x10, {
    'Header' : [ 0x0, ['_PS_TRUSTLET_ATTRIBUTE_HEADER']],
    'Data' : [ 0x8, ['array', 1, ['unsigned long long']]],
} ],
  '_PS_TRUSTLET_ATTRIBUTE_HEADER' : [ 0x8, {
    'AttributeType' : [ 0x0, ['_PS_TRUSTLET_ATTRIBUTE_TYPE']],
    'InstanceNumber' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned long')]],
    'Reserved' : [ 0x4, ['BitField', dict(start_bit = 8, end_bit = 32, native_type='unsigned long')]],
} ],
  '_TRUSTLET_MAILBOX_KEY' : [ 0x10, {
    'SecretValue' : [ 0x0, ['array', 2, ['unsigned long long']]],
} ],
  '_TRUSTLET_COLLABORATION_ID' : [ 0x10, {
    'Value' : [ 0x0, ['array', 2, ['unsigned long long']]],
} ],
  '__unnamed_1235' : [ 0x8, {
    'SecureProcess' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'Unused' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long long')]],
} ],
  '__unnamed_1237' : [ 0x8, {
    'SecureHandle' : [ 0x0, ['unsigned long long']],
    'Flags' : [ 0x0, ['__unnamed_1235']],
} ],
  '_KPROCESS' : [ 0x2d8, {
    'Header' : [ 0x0, ['_DISPATCHER_HEADER']],
    'ProfileListHead' : [ 0x18, ['_LIST_ENTRY']],
    'DirectoryTableBase' : [ 0x28, ['unsigned long long']],
    'ThreadListHead' : [ 0x30, ['_LIST_ENTRY']],
    'ProcessLock' : [ 0x40, ['unsigned long']],
    'ProcessTimerDelay' : [ 0x44, ['unsigned long']],
    'DeepFreezeStartTime' : [ 0x48, ['unsigned long long']],
    'Affinity' : [ 0x50, ['_KAFFINITY_EX']],
    'ReadyListHead' : [ 0xf8, ['_LIST_ENTRY']],
    'SwapListEntry' : [ 0x108, ['_SINGLE_LIST_ENTRY']],
    'ActiveProcessors' : [ 0x110, ['_KAFFINITY_EX']],
    'AutoAlignment' : [ 0x1b8, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'DisableBoost' : [ 0x1b8, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'DisableQuantum' : [ 0x1b8, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'DeepFreeze' : [ 0x1b8, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'TimerVirtualization' : [ 0x1b8, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'CheckStackExtents' : [ 0x1b8, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'CacheIsolationEnabled' : [ 0x1b8, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'PpmPolicy' : [ 0x1b8, ['BitField', dict(start_bit = 7, end_bit = 10, native_type='unsigned long')]],
    'ActiveGroupsMask' : [ 0x1b8, ['BitField', dict(start_bit = 10, end_bit = 30, native_type='unsigned long')]],
    'VaSpaceDeleted' : [ 0x1b8, ['BitField', dict(start_bit = 30, end_bit = 31, native_type='unsigned long')]],
    'ReservedFlags' : [ 0x1b8, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
    'ProcessFlags' : [ 0x1b8, ['long']],
    'BasePriority' : [ 0x1bc, ['unsigned char']],
    'QuantumReset' : [ 0x1bd, ['unsigned char']],
    'Visited' : [ 0x1be, ['unsigned char']],
    'Flags' : [ 0x1bf, ['_KEXECUTE_OPTIONS']],
    'ThreadSeed' : [ 0x1c0, ['array', 20, ['unsigned long']]],
    'IdealNode' : [ 0x210, ['array', 20, ['unsigned short']]],
    'IdealGlobalNode' : [ 0x238, ['unsigned short']],
    'Spare1' : [ 0x23a, ['unsigned short']],
    'StackCount' : [ 0x23c, ['_KSTACK_COUNT']],
    'ProcessListEntry' : [ 0x240, ['_LIST_ENTRY']],
    'CycleTime' : [ 0x250, ['unsigned long long']],
    'ContextSwitches' : [ 0x258, ['unsigned long long']],
    'SchedulingGroup' : [ 0x260, ['pointer64', ['_KSCHEDULING_GROUP']]],
    'FreezeCount' : [ 0x268, ['unsigned long']],
    'KernelTime' : [ 0x26c, ['unsigned long']],
    'UserTime' : [ 0x270, ['unsigned long']],
    'ReadyTime' : [ 0x274, ['unsigned long']],
    'UserDirectoryTableBase' : [ 0x278, ['unsigned long long']],
    'AddressPolicy' : [ 0x280, ['unsigned char']],
    'Spare2' : [ 0x281, ['array', 71, ['unsigned char']]],
    'InstrumentationCallback' : [ 0x2c8, ['pointer64', ['void']]],
    'SecureState' : [ 0x2d0, ['__unnamed_1237']],
} ],
  '_KTHREAD' : [ 0x5f0, {
    'Header' : [ 0x0, ['_DISPATCHER_HEADER']],
    'SListFaultAddress' : [ 0x18, ['pointer64', ['void']]],
    'QuantumTarget' : [ 0x20, ['unsigned long long']],
    'InitialStack' : [ 0x28, ['pointer64', ['void']]],
    'StackLimit' : [ 0x30, ['pointer64', ['void']]],
    'StackBase' : [ 0x38, ['pointer64', ['void']]],
    'ThreadLock' : [ 0x40, ['unsigned long long']],
    'CycleTime' : [ 0x48, ['unsigned long long']],
    'CurrentRunTime' : [ 0x50, ['unsigned long']],
    'ExpectedRunTime' : [ 0x54, ['unsigned long']],
    'KernelStack' : [ 0x58, ['pointer64', ['void']]],
    'StateSaveArea' : [ 0x60, ['pointer64', ['_XSAVE_FORMAT']]],
    'SchedulingGroup' : [ 0x68, ['pointer64', ['_KSCHEDULING_GROUP']]],
    'WaitRegister' : [ 0x70, ['_KWAIT_STATUS_REGISTER']],
    'Running' : [ 0x71, ['unsigned char']],
    'Alerted' : [ 0x72, ['array', 2, ['unsigned char']]],
    'AutoBoostActive' : [ 0x74, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'ReadyTransition' : [ 0x74, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'WaitNext' : [ 0x74, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'SystemAffinityActive' : [ 0x74, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'Alertable' : [ 0x74, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'UserStackWalkActive' : [ 0x74, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'ApcInterruptRequest' : [ 0x74, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'QuantumEndMigrate' : [ 0x74, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'UmsDirectedSwitchEnable' : [ 0x74, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'TimerActive' : [ 0x74, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'SystemThread' : [ 0x74, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'ProcessDetachActive' : [ 0x74, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'CalloutActive' : [ 0x74, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long')]],
    'ScbReadyQueue' : [ 0x74, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long')]],
    'ApcQueueable' : [ 0x74, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long')]],
    'ReservedStackInUse' : [ 0x74, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'UmsPerformingSyscall' : [ 0x74, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'TimerSuspended' : [ 0x74, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'SuspendedWaitMode' : [ 0x74, ['BitField', dict(start_bit = 18, end_bit = 19, native_type='unsigned long')]],
    'SuspendSchedulerApcWait' : [ 0x74, ['BitField', dict(start_bit = 19, end_bit = 20, native_type='unsigned long')]],
    'Reserved' : [ 0x74, ['BitField', dict(start_bit = 20, end_bit = 32, native_type='unsigned long')]],
    'MiscFlags' : [ 0x74, ['long']],
    'BamQosLevel' : [ 0x78, ['BitField', dict(start_bit = 0, end_bit = 2, native_type='unsigned long')]],
    'AutoAlignment' : [ 0x78, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'DisableBoost' : [ 0x78, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'AlertedByThreadId' : [ 0x78, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'QuantumDonation' : [ 0x78, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'EnableStackSwap' : [ 0x78, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'GuiThread' : [ 0x78, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'DisableQuantum' : [ 0x78, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'ChargeOnlySchedulingGroup' : [ 0x78, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'DeferPreemption' : [ 0x78, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'QueueDeferPreemption' : [ 0x78, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'ForceDeferSchedule' : [ 0x78, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long')]],
    'SharedReadyQueueAffinity' : [ 0x78, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long')]],
    'FreezeCount' : [ 0x78, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long')]],
    'TerminationApcRequest' : [ 0x78, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'AutoBoostEntriesExhausted' : [ 0x78, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'KernelStackResident' : [ 0x78, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'TerminateRequestReason' : [ 0x78, ['BitField', dict(start_bit = 18, end_bit = 20, native_type='unsigned long')]],
    'ProcessStackCountDecremented' : [ 0x78, ['BitField', dict(start_bit = 20, end_bit = 21, native_type='unsigned long')]],
    'RestrictedGuiThread' : [ 0x78, ['BitField', dict(start_bit = 21, end_bit = 22, native_type='unsigned long')]],
    'VpBackingThread' : [ 0x78, ['BitField', dict(start_bit = 22, end_bit = 23, native_type='unsigned long')]],
    'ThreadFlagsSpare' : [ 0x78, ['BitField', dict(start_bit = 23, end_bit = 24, native_type='unsigned long')]],
    'EtwStackTraceApcInserted' : [ 0x78, ['BitField', dict(start_bit = 24, end_bit = 32, native_type='unsigned long')]],
    'ThreadFlags' : [ 0x78, ['long']],
    'Tag' : [ 0x7c, ['unsigned char']],
    'SystemHeteroCpuPolicy' : [ 0x7d, ['unsigned char']],
    'UserHeteroCpuPolicy' : [ 0x7e, ['BitField', dict(start_bit = 0, end_bit = 7, native_type='unsigned char')]],
    'ExplicitSystemHeteroCpuPolicy' : [ 0x7e, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
    'Spare0' : [ 0x7f, ['unsigned char']],
    'SystemCallNumber' : [ 0x80, ['unsigned long']],
    'ReadyTime' : [ 0x84, ['unsigned long']],
    'FirstArgument' : [ 0x88, ['pointer64', ['void']]],
    'TrapFrame' : [ 0x90, ['pointer64', ['_KTRAP_FRAME']]],
    'ApcState' : [ 0x98, ['_KAPC_STATE']],
    'ApcStateFill' : [ 0x98, ['array', 43, ['unsigned char']]],
    'Priority' : [ 0xc3, ['unsigned char']],
    'UserIdealProcessor' : [ 0xc4, ['unsigned long']],
    'WaitStatus' : [ 0xc8, ['long long']],
    'WaitBlockList' : [ 0xd0, ['pointer64', ['_KWAIT_BLOCK']]],
    'WaitListEntry' : [ 0xd8, ['_LIST_ENTRY']],
    'SwapListEntry' : [ 0xd8, ['_SINGLE_LIST_ENTRY']],
    'Queue' : [ 0xe8, ['pointer64', ['_DISPATCHER_HEADER']]],
    'Teb' : [ 0xf0, ['pointer64', ['void']]],
    'RelativeTimerBias' : [ 0xf8, ['unsigned long long']],
    'Timer' : [ 0x100, ['_KTIMER']],
    'WaitBlock' : [ 0x140, ['array', 4, ['_KWAIT_BLOCK']]],
    'WaitBlockFill4' : [ 0x140, ['array', 20, ['unsigned char']]],
    'ContextSwitches' : [ 0x154, ['unsigned long']],
    'WaitBlockFill5' : [ 0x140, ['array', 68, ['unsigned char']]],
    'State' : [ 0x184, ['unsigned char']],
    'Spare13' : [ 0x185, ['unsigned char']],
    'WaitIrql' : [ 0x186, ['unsigned char']],
    'WaitMode' : [ 0x187, ['unsigned char']],
    'WaitBlockFill6' : [ 0x140, ['array', 116, ['unsigned char']]],
    'WaitTime' : [ 0x1b4, ['unsigned long']],
    'WaitBlockFill7' : [ 0x140, ['array', 164, ['unsigned char']]],
    'KernelApcDisable' : [ 0x1e4, ['short']],
    'SpecialApcDisable' : [ 0x1e6, ['short']],
    'CombinedApcDisable' : [ 0x1e4, ['unsigned long']],
    'WaitBlockFill8' : [ 0x140, ['array', 40, ['unsigned char']]],
    'ThreadCounters' : [ 0x168, ['pointer64', ['_KTHREAD_COUNTERS']]],
    'WaitBlockFill9' : [ 0x140, ['array', 88, ['unsigned char']]],
    'XStateSave' : [ 0x198, ['pointer64', ['_XSTATE_SAVE']]],
    'WaitBlockFill10' : [ 0x140, ['array', 136, ['unsigned char']]],
    'Win32Thread' : [ 0x1c8, ['pointer64', ['void']]],
    'WaitBlockFill11' : [ 0x140, ['array', 176, ['unsigned char']]],
    'Ucb' : [ 0x1f0, ['pointer64', ['_UMS_CONTROL_BLOCK']]],
    'Uch' : [ 0x1f8, ['pointer64', ['_KUMS_CONTEXT_HEADER']]],
    'Spare21' : [ 0x200, ['pointer64', ['void']]],
    'QueueListEntry' : [ 0x208, ['_LIST_ENTRY']],
    'NextProcessor' : [ 0x218, ['unsigned long']],
    'NextProcessorNumber' : [ 0x218, ['BitField', dict(start_bit = 0, end_bit = 31, native_type='unsigned long')]],
    'SharedReadyQueue' : [ 0x218, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
    'QueuePriority' : [ 0x21c, ['long']],
    'Process' : [ 0x220, ['pointer64', ['_KPROCESS']]],
    'UserAffinity' : [ 0x228, ['_GROUP_AFFINITY']],
    'UserAffinityFill' : [ 0x228, ['array', 10, ['unsigned char']]],
    'PreviousMode' : [ 0x232, ['unsigned char']],
    'BasePriority' : [ 0x233, ['unsigned char']],
    'PriorityDecrement' : [ 0x234, ['unsigned char']],
    'ForegroundBoost' : [ 0x234, ['BitField', dict(start_bit = 0, end_bit = 4, native_type='unsigned char')]],
    'UnusualBoost' : [ 0x234, ['BitField', dict(start_bit = 4, end_bit = 8, native_type='unsigned char')]],
    'Preempted' : [ 0x235, ['unsigned char']],
    'AdjustReason' : [ 0x236, ['unsigned char']],
    'AdjustIncrement' : [ 0x237, ['unsigned char']],
    'AffinityVersion' : [ 0x238, ['unsigned long long']],
    'Affinity' : [ 0x240, ['_GROUP_AFFINITY']],
    'AffinityFill' : [ 0x240, ['array', 10, ['unsigned char']]],
    'ApcStateIndex' : [ 0x24a, ['unsigned char']],
    'WaitBlockCount' : [ 0x24b, ['unsigned char']],
    'IdealProcessor' : [ 0x24c, ['unsigned long']],
    'NpxState' : [ 0x250, ['unsigned long long']],
    'SavedApcState' : [ 0x258, ['_KAPC_STATE']],
    'SavedApcStateFill' : [ 0x258, ['array', 43, ['unsigned char']]],
    'WaitReason' : [ 0x283, ['unsigned char']],
    'SuspendCount' : [ 0x284, ['unsigned char']],
    'Saturation' : [ 0x285, ['unsigned char']],
    'SListFaultCount' : [ 0x286, ['unsigned short']],
    'SchedulerApc' : [ 0x288, ['_KAPC']],
    'SchedulerApcFill0' : [ 0x288, ['array', 1, ['unsigned char']]],
    'ResourceIndex' : [ 0x289, ['unsigned char']],
    'SchedulerApcFill1' : [ 0x288, ['array', 3, ['unsigned char']]],
    'QuantumReset' : [ 0x28b, ['unsigned char']],
    'SchedulerApcFill2' : [ 0x288, ['array', 4, ['unsigned char']]],
    'KernelTime' : [ 0x28c, ['unsigned long']],
    'SchedulerApcFill3' : [ 0x288, ['array', 64, ['unsigned char']]],
    'WaitPrcb' : [ 0x2c8, ['pointer64', ['_KPRCB']]],
    'SchedulerApcFill4' : [ 0x288, ['array', 72, ['unsigned char']]],
    'LegoData' : [ 0x2d0, ['pointer64', ['void']]],
    'SchedulerApcFill5' : [ 0x288, ['array', 83, ['unsigned char']]],
    'CallbackNestingLevel' : [ 0x2db, ['unsigned char']],
    'UserTime' : [ 0x2dc, ['unsigned long']],
    'SuspendEvent' : [ 0x2e0, ['_KEVENT']],
    'ThreadListEntry' : [ 0x2f8, ['_LIST_ENTRY']],
    'MutantListHead' : [ 0x308, ['_LIST_ENTRY']],
    'AbEntrySummary' : [ 0x318, ['unsigned char']],
    'AbWaitEntryCount' : [ 0x319, ['unsigned char']],
    'AbAllocationRegionCount' : [ 0x31a, ['unsigned char']],
    'SystemPriority' : [ 0x31b, ['unsigned char']],
    'SecureThreadCookie' : [ 0x31c, ['unsigned long']],
    'LockEntries' : [ 0x320, ['array', 6, ['_KLOCK_ENTRY']]],
    'PropagateBoostsEntry' : [ 0x560, ['_SINGLE_LIST_ENTRY']],
    'IoSelfBoostsEntry' : [ 0x568, ['_SINGLE_LIST_ENTRY']],
    'PriorityFloorCounts' : [ 0x570, ['array', 16, ['unsigned char']]],
    'PriorityFloorSummary' : [ 0x580, ['unsigned long']],
    'AbCompletedIoBoostCount' : [ 0x584, ['long']],
    'AbCompletedIoQoSBoostCount' : [ 0x588, ['long']],
    'KeReferenceCount' : [ 0x58c, ['short']],
    'AbOrphanedEntrySummary' : [ 0x58e, ['unsigned char']],
    'AbOwnedEntryCount' : [ 0x58f, ['unsigned char']],
    'ForegroundLossTime' : [ 0x590, ['unsigned long']],
    'GlobalForegroundListEntry' : [ 0x598, ['_LIST_ENTRY']],
    'ForegroundDpcStackListEntry' : [ 0x598, ['_SINGLE_LIST_ENTRY']],
    'InGlobalForegroundList' : [ 0x5a0, ['unsigned long long']],
    'ReadOperationCount' : [ 0x5a8, ['long long']],
    'WriteOperationCount' : [ 0x5b0, ['long long']],
    'OtherOperationCount' : [ 0x5b8, ['long long']],
    'ReadTransferCount' : [ 0x5c0, ['long long']],
    'WriteTransferCount' : [ 0x5c8, ['long long']],
    'OtherTransferCount' : [ 0x5d0, ['long long']],
    'QueuedScb' : [ 0x5d8, ['pointer64', ['_KSCB']]],
    'ThreadTimerDelay' : [ 0x5e0, ['unsigned long']],
    'ThreadFlags2' : [ 0x5e4, ['long']],
    'PpmPolicy' : [ 0x5e4, ['BitField', dict(start_bit = 0, end_bit = 2, native_type='unsigned long')]],
    'ThreadFlags2Reserved' : [ 0x5e4, ['BitField', dict(start_bit = 2, end_bit = 32, native_type='unsigned long')]],
    'SchedulerAssist' : [ 0x5e8, ['pointer64', ['void']]],
} ],
  '_KSTACK_CONTROL' : [ 0x30, {
    'StackBase' : [ 0x0, ['unsigned long long']],
    'ActualLimit' : [ 0x8, ['unsigned long long']],
    'StackExpansion' : [ 0x8, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'Previous' : [ 0x10, ['_KERNEL_STACK_SEGMENT']],
} ],
  '_KSPIN_LOCK_QUEUE' : [ 0x10, {
    'Next' : [ 0x0, ['pointer64', ['_KSPIN_LOCK_QUEUE']]],
    'Lock' : [ 0x8, ['pointer64', ['unsigned long long']]],
} ],
  '_FAST_MUTEX' : [ 0x38, {
    'Count' : [ 0x0, ['long']],
    'Owner' : [ 0x8, ['pointer64', ['void']]],
    'Contention' : [ 0x10, ['unsigned long']],
    'Event' : [ 0x18, ['_KEVENT']],
    'OldIrql' : [ 0x30, ['unsigned long']],
} ],
  '_KEVENT' : [ 0x18, {
    'Header' : [ 0x0, ['_DISPATCHER_HEADER']],
} ],
  '__unnamed_12a6' : [ 0x10, {
    'Depth' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 16, native_type='unsigned long long')]],
    'Sequence' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 64, native_type='unsigned long long')]],
    'Reserved' : [ 0x8, ['BitField', dict(start_bit = 0, end_bit = 4, native_type='unsigned long long')]],
    'NextEntry' : [ 0x8, ['BitField', dict(start_bit = 4, end_bit = 64, native_type='unsigned long long')]],
} ],
  '_SLIST_HEADER' : [ 0x10, {
    'Alignment' : [ 0x0, ['unsigned long long']],
    'Region' : [ 0x8, ['unsigned long long']],
    'HeaderX64' : [ 0x0, ['__unnamed_12a6']],
} ],
  '_LOOKASIDE_LIST_EX' : [ 0x60, {
    'L' : [ 0x0, ['_GENERAL_LOOKASIDE_POOL']],
} ],
  '_SLIST_ENTRY' : [ 0x10, {
    'Next' : [ 0x0, ['pointer64', ['_SLIST_ENTRY']]],
} ],
  '_NPAGED_LOOKASIDE_LIST' : [ 0x80, {
    'L' : [ 0x0, ['_GENERAL_LOOKASIDE']],
} ],
  '_PAGED_LOOKASIDE_LIST' : [ 0x80, {
    'L' : [ 0x0, ['_GENERAL_LOOKASIDE']],
} ],
  '_IO_STATUS_BLOCK' : [ 0x10, {
    'Status' : [ 0x0, ['long']],
    'Pointer' : [ 0x0, ['pointer64', ['void']]],
    'Information' : [ 0x8, ['unsigned long long']],
} ],
  '_QUAD' : [ 0x8, {
    'UseThisFieldToCopy' : [ 0x0, ['long long']],
    'DoNotUseThisField' : [ 0x0, ['double']],
} ],
  '_WORK_QUEUE_ITEM' : [ 0x20, {
    'List' : [ 0x0, ['_LIST_ENTRY']],
    'WorkerRoutine' : [ 0x10, ['pointer64', ['void']]],
    'Parameter' : [ 0x18, ['pointer64', ['void']]],
} ],
  '_EXT_DELETE_PARAMETERS' : [ 0x18, {
    'Version' : [ 0x0, ['unsigned long']],
    'Reserved' : [ 0x4, ['unsigned long']],
    'DeleteCallback' : [ 0x8, ['pointer64', ['void']]],
    'DeleteContext' : [ 0x10, ['pointer64', ['void']]],
} ],
  '_EX_PUSH_LOCK' : [ 0x8, {
    'Locked' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'Waiting' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long long')]],
    'Waking' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long long')]],
    'MultipleShared' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long long')]],
    'Shared' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 64, native_type='unsigned long long')]],
    'Value' : [ 0x0, ['unsigned long long']],
    'Ptr' : [ 0x0, ['pointer64', ['void']]],
} ],
  '_PP_LOOKASIDE_LIST' : [ 0x10, {
    'P' : [ 0x0, ['pointer64', ['_GENERAL_LOOKASIDE']]],
    'L' : [ 0x8, ['pointer64', ['_GENERAL_LOOKASIDE']]],
} ],
  '_GENERAL_LOOKASIDE' : [ 0x80, {
    'ListHead' : [ 0x0, ['_SLIST_HEADER']],
    'SingleListHead' : [ 0x0, ['_SINGLE_LIST_ENTRY']],
    'Depth' : [ 0x10, ['unsigned short']],
    'MaximumDepth' : [ 0x12, ['unsigned short']],
    'TotalAllocates' : [ 0x14, ['unsigned long']],
    'AllocateMisses' : [ 0x18, ['unsigned long']],
    'AllocateHits' : [ 0x18, ['unsigned long']],
    'TotalFrees' : [ 0x1c, ['unsigned long']],
    'FreeMisses' : [ 0x20, ['unsigned long']],
    'FreeHits' : [ 0x20, ['unsigned long']],
    'Type' : [ 0x24, ['Enumeration', dict(target = 'long', choices = {0: u'NonPagedPoolBase', 1: u'PagedPool', 2: u'NonPagedPoolBaseMustSucceed', 3: u'DontUseThisType', 4: u'NonPagedPoolBaseCacheAligned', 5: u'PagedPoolCacheAligned', 6: u'NonPagedPoolBaseCacheAlignedMustS', 7: u'MaxPoolType', 34: u'NonPagedPoolMustSucceedSession', 516: u'NonPagedPoolNxCacheAligned', 35: u'DontUseThisTypeSession', 32: u'NonPagedPoolSession', 512: u'NonPagedPoolNx', 544: u'NonPagedPoolSessionNx', 36: u'NonPagedPoolCacheAlignedSession', 33: u'PagedPoolSession', 38: u'NonPagedPoolCacheAlignedMustSSession', 37: u'PagedPoolCacheAlignedSession'})]],
    'Tag' : [ 0x28, ['unsigned long']],
    'Size' : [ 0x2c, ['unsigned long']],
    'AllocateEx' : [ 0x30, ['pointer64', ['void']]],
    'Allocate' : [ 0x30, ['pointer64', ['void']]],
    'FreeEx' : [ 0x38, ['pointer64', ['void']]],
    'Free' : [ 0x38, ['pointer64', ['void']]],
    'ListEntry' : [ 0x40, ['_LIST_ENTRY']],
    'LastTotalAllocates' : [ 0x50, ['unsigned long']],
    'LastAllocateMisses' : [ 0x54, ['unsigned long']],
    'LastAllocateHits' : [ 0x54, ['unsigned long']],
    'Future' : [ 0x58, ['array', 2, ['unsigned long']]],
} ],
  '_KNODE' : [ 0x180, {
    'IdleNonParkedCpuSet' : [ 0x0, ['unsigned long long']],
    'IdleSmtSet' : [ 0x8, ['unsigned long long']],
    'IdleCpuSet' : [ 0x10, ['unsigned long long']],
    'DeepIdleSet' : [ 0x40, ['unsigned long long']],
    'IdleConstrainedSet' : [ 0x48, ['unsigned long long']],
    'NonParkedSet' : [ 0x50, ['unsigned long long']],
    'NonIsrTargetedSet' : [ 0x58, ['unsigned long long']],
    'ParkLock' : [ 0x60, ['long']],
    'Seed' : [ 0x64, ['unsigned long']],
    'SiblingMask' : [ 0x80, ['unsigned long']],
    'Affinity' : [ 0x88, ['_GROUP_AFFINITY']],
    'AffinityFill' : [ 0x88, ['array', 10, ['unsigned char']]],
    'NodeNumber' : [ 0x92, ['unsigned short']],
    'PrimaryNodeNumber' : [ 0x94, ['unsigned short']],
    'Stride' : [ 0x96, ['unsigned char']],
    'Spare0' : [ 0x97, ['unsigned char']],
    'SharedReadyQueueLeaders' : [ 0x98, ['unsigned long long']],
    'ProximityId' : [ 0xa0, ['unsigned long']],
    'Lowest' : [ 0xa4, ['unsigned long']],
    'Highest' : [ 0xa8, ['unsigned long']],
    'MaximumProcessors' : [ 0xac, ['unsigned char']],
    'Flags' : [ 0xad, ['_flags']],
    'Spare10' : [ 0xae, ['unsigned char']],
    'HeteroSets' : [ 0xb0, ['array', 5, ['_KHETERO_PROCESSOR_SET']]],
    'PpmConfiguredQosSets' : [ 0x128, ['array', 4, ['unsigned long long']]],
} ],
  '_ENODE' : [ 0x1c0, {
    'Ncb' : [ 0x0, ['_KNODE']],
    'HotAddProcessorWorkItem' : [ 0x180, ['_WORK_QUEUE_ITEM']],
} ],
  '_HANDLE_TABLE' : [ 0x80, {
    'NextHandleNeedingPool' : [ 0x0, ['unsigned long']],
    'ExtraInfoPages' : [ 0x4, ['long']],
    'TableCode' : [ 0x8, ['unsigned long long']],
    'QuotaProcess' : [ 0x10, ['pointer64', ['_EPROCESS']]],
    'HandleTableList' : [ 0x18, ['_LIST_ENTRY']],
    'UniqueProcessId' : [ 0x28, ['unsigned long']],
    'Flags' : [ 0x2c, ['unsigned long']],
    'StrictFIFO' : [ 0x2c, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'EnableHandleExceptions' : [ 0x2c, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'Rundown' : [ 0x2c, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'Duplicated' : [ 0x2c, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'RaiseUMExceptionOnInvalidHandleClose' : [ 0x2c, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'HandleContentionEvent' : [ 0x30, ['_EX_PUSH_LOCK']],
    'HandleTableLock' : [ 0x38, ['_EX_PUSH_LOCK']],
    'FreeLists' : [ 0x40, ['array', 1, ['_HANDLE_TABLE_FREE_LIST']]],
    'ActualEntry' : [ 0x40, ['array', 32, ['unsigned char']]],
    'DebugInfo' : [ 0x60, ['pointer64', ['_HANDLE_TRACE_DEBUG_INFO']]],
} ],
  '_HANDLE_TABLE_ENTRY_INFO' : [ 0x8, {
    'AuditMask' : [ 0x0, ['unsigned long']],
    'MaxRelativeAccessMask' : [ 0x4, ['unsigned long']],
} ],
  '_HANDLE_TABLE_ENTRY' : [ 0x10, {
    'VolatileLowValue' : [ 0x0, ['long long']],
    'LowValue' : [ 0x0, ['long long']],
    'InfoTable' : [ 0x0, ['pointer64', ['_HANDLE_TABLE_ENTRY_INFO']]],
    'HighValue' : [ 0x8, ['long long']],
    'NextFreeHandleEntry' : [ 0x8, ['pointer64', ['_HANDLE_TABLE_ENTRY']]],
    'LeafHandleValue' : [ 0x8, ['_EXHANDLE']],
    'RefCountField' : [ 0x0, ['long long']],
    'Unlocked' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'RefCnt' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 17, native_type='unsigned long long')]],
    'Attributes' : [ 0x0, ['BitField', dict(start_bit = 17, end_bit = 20, native_type='unsigned long long')]],
    'ObjectPointerBits' : [ 0x0, ['BitField', dict(start_bit = 20, end_bit = 64, native_type='unsigned long long')]],
    'GrantedAccessBits' : [ 0x8, ['BitField', dict(start_bit = 0, end_bit = 25, native_type='unsigned long')]],
    'NoRightsUpgrade' : [ 0x8, ['BitField', dict(start_bit = 25, end_bit = 26, native_type='unsigned long')]],
    'Spare1' : [ 0x8, ['BitField', dict(start_bit = 26, end_bit = 32, native_type='unsigned long')]],
    'Spare2' : [ 0xc, ['unsigned long']],
} ],
  '_EX_FAST_REF' : [ 0x8, {
    'Object' : [ 0x0, ['pointer64', ['void']]],
    'RefCnt' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 4, native_type='unsigned long long')]],
    'Value' : [ 0x0, ['unsigned long long']],
} ],
  '__unnamed_1392' : [ 0x2c, {
    'InitialPrivilegeSet' : [ 0x0, ['_INITIAL_PRIVILEGE_SET']],
    'PrivilegeSet' : [ 0x0, ['_PRIVILEGE_SET']],
} ],
  '_ACCESS_STATE' : [ 0xa0, {
    'OperationID' : [ 0x0, ['_LUID']],
    'SecurityEvaluated' : [ 0x8, ['unsigned char']],
    'GenerateAudit' : [ 0x9, ['unsigned char']],
    'GenerateOnClose' : [ 0xa, ['unsigned char']],
    'PrivilegesAllocated' : [ 0xb, ['unsigned char']],
    'Flags' : [ 0xc, ['unsigned long']],
    'RemainingDesiredAccess' : [ 0x10, ['unsigned long']],
    'PreviouslyGrantedAccess' : [ 0x14, ['unsigned long']],
    'OriginalDesiredAccess' : [ 0x18, ['unsigned long']],
    'SubjectSecurityContext' : [ 0x20, ['_SECURITY_SUBJECT_CONTEXT']],
    'SecurityDescriptor' : [ 0x40, ['pointer64', ['void']]],
    'AuxData' : [ 0x48, ['pointer64', ['void']]],
    'Privileges' : [ 0x50, ['__unnamed_1392']],
    'AuditPrivileges' : [ 0x7c, ['unsigned char']],
    'ObjectName' : [ 0x80, ['_UNICODE_STRING']],
    'ObjectTypeName' : [ 0x90, ['_UNICODE_STRING']],
} ],
  '_AUX_ACCESS_DATA' : [ 0xe0, {
    'PrivilegesUsed' : [ 0x0, ['pointer64', ['_PRIVILEGE_SET']]],
    'GenericMapping' : [ 0x8, ['_GENERIC_MAPPING']],
    'AccessesToAudit' : [ 0x18, ['unsigned long']],
    'MaximumAuditMask' : [ 0x1c, ['unsigned long']],
    'TransactionId' : [ 0x20, ['_GUID']],
    'NewSecurityDescriptor' : [ 0x30, ['pointer64', ['void']]],
    'ExistingSecurityDescriptor' : [ 0x38, ['pointer64', ['void']]],
    'ParentSecurityDescriptor' : [ 0x40, ['pointer64', ['void']]],
    'DeRefSecurityDescriptor' : [ 0x48, ['pointer64', ['void']]],
    'SDLock' : [ 0x50, ['pointer64', ['void']]],
    'AccessReasons' : [ 0x58, ['_ACCESS_REASONS']],
    'GenerateStagingEvents' : [ 0xd8, ['unsigned char']],
} ],
  '_OBJECT_HANDLE_INFORMATION' : [ 0x8, {
    'HandleAttributes' : [ 0x0, ['unsigned long']],
    'GrantedAccess' : [ 0x4, ['unsigned long']],
} ],
  '_ETHREAD' : [ 0x818, {
    'Tcb' : [ 0x0, ['_KTHREAD']],
    'CreateTime' : [ 0x5f0, ['_LARGE_INTEGER']],
    'ExitTime' : [ 0x5f8, ['_LARGE_INTEGER']],
    'KeyedWaitChain' : [ 0x5f8, ['_LIST_ENTRY']],
    'PostBlockList' : [ 0x608, ['_LIST_ENTRY']],
    'ForwardLinkShadow' : [ 0x608, ['pointer64', ['void']]],
    'StartAddress' : [ 0x610, ['pointer64', ['void']]],
    'TerminationPort' : [ 0x618, ['pointer64', ['_TERMINATION_PORT']]],
    'ReaperLink' : [ 0x618, ['pointer64', ['_ETHREAD']]],
    'KeyedWaitValue' : [ 0x618, ['pointer64', ['void']]],
    'ActiveTimerListLock' : [ 0x620, ['unsigned long long']],
    'ActiveTimerListHead' : [ 0x628, ['_LIST_ENTRY']],
    'Cid' : [ 0x638, ['_CLIENT_ID']],
    'KeyedWaitSemaphore' : [ 0x648, ['_KSEMAPHORE']],
    'AlpcWaitSemaphore' : [ 0x648, ['_KSEMAPHORE']],
    'ClientSecurity' : [ 0x668, ['_PS_CLIENT_SECURITY_CONTEXT']],
    'IrpList' : [ 0x670, ['_LIST_ENTRY']],
    'TopLevelIrp' : [ 0x680, ['unsigned long long']],
    'DeviceToVerify' : [ 0x688, ['pointer64', ['_DEVICE_OBJECT']]],
    'Win32StartAddress' : [ 0x690, ['pointer64', ['void']]],
    'ChargeOnlySession' : [ 0x698, ['pointer64', ['void']]],
    'LegacyPowerObject' : [ 0x6a0, ['pointer64', ['void']]],
    'ThreadListEntry' : [ 0x6a8, ['_LIST_ENTRY']],
    'RundownProtect' : [ 0x6b8, ['_EX_RUNDOWN_REF']],
    'ThreadLock' : [ 0x6c0, ['_EX_PUSH_LOCK']],
    'ReadClusterSize' : [ 0x6c8, ['unsigned long']],
    'MmLockOrdering' : [ 0x6cc, ['long']],
    'CrossThreadFlags' : [ 0x6d0, ['unsigned long']],
    'Terminated' : [ 0x6d0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'ThreadInserted' : [ 0x6d0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'HideFromDebugger' : [ 0x6d0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'ActiveImpersonationInfo' : [ 0x6d0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'HardErrorsAreDisabled' : [ 0x6d0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'BreakOnTermination' : [ 0x6d0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'SkipCreationMsg' : [ 0x6d0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'SkipTerminationMsg' : [ 0x6d0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'CopyTokenOnOpen' : [ 0x6d0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'ThreadIoPriority' : [ 0x6d0, ['BitField', dict(start_bit = 9, end_bit = 12, native_type='unsigned long')]],
    'ThreadPagePriority' : [ 0x6d0, ['BitField', dict(start_bit = 12, end_bit = 15, native_type='unsigned long')]],
    'RundownFail' : [ 0x6d0, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'UmsForceQueueTermination' : [ 0x6d0, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'IndirectCpuSets' : [ 0x6d0, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'DisableDynamicCodeOptOut' : [ 0x6d0, ['BitField', dict(start_bit = 18, end_bit = 19, native_type='unsigned long')]],
    'ExplicitCaseSensitivity' : [ 0x6d0, ['BitField', dict(start_bit = 19, end_bit = 20, native_type='unsigned long')]],
    'PicoNotifyExit' : [ 0x6d0, ['BitField', dict(start_bit = 20, end_bit = 21, native_type='unsigned long')]],
    'DbgWerUserReportActive' : [ 0x6d0, ['BitField', dict(start_bit = 21, end_bit = 22, native_type='unsigned long')]],
    'ForcedSelfTrimActive' : [ 0x6d0, ['BitField', dict(start_bit = 22, end_bit = 23, native_type='unsigned long')]],
    'SamplingCoverage' : [ 0x6d0, ['BitField', dict(start_bit = 23, end_bit = 24, native_type='unsigned long')]],
    'ReservedCrossThreadFlags' : [ 0x6d0, ['BitField', dict(start_bit = 24, end_bit = 32, native_type='unsigned long')]],
    'SameThreadPassiveFlags' : [ 0x6d4, ['unsigned long']],
    'ActiveExWorker' : [ 0x6d4, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'MemoryMaker' : [ 0x6d4, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'StoreLockThread' : [ 0x6d4, ['BitField', dict(start_bit = 2, end_bit = 4, native_type='unsigned long')]],
    'ClonedThread' : [ 0x6d4, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'KeyedEventInUse' : [ 0x6d4, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'SelfTerminate' : [ 0x6d4, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'RespectIoPriority' : [ 0x6d4, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'ActivePageLists' : [ 0x6d4, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'SecureContext' : [ 0x6d4, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'ZeroPageThread' : [ 0x6d4, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'ReservedSameThreadPassiveFlags' : [ 0x6d4, ['BitField', dict(start_bit = 11, end_bit = 32, native_type='unsigned long')]],
    'SameThreadApcFlags' : [ 0x6d8, ['unsigned long']],
    'OwnsProcessAddressSpaceExclusive' : [ 0x6d8, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'OwnsProcessAddressSpaceShared' : [ 0x6d8, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'HardFaultBehavior' : [ 0x6d8, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'StartAddressInvalid' : [ 0x6d8, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'EtwCalloutActive' : [ 0x6d8, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'SuppressSymbolLoad' : [ 0x6d8, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'Prefetching' : [ 0x6d8, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned char')]],
    'OwnsVadExclusive' : [ 0x6d8, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
    'SystemPagePriorityActive' : [ 0x6d9, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'SystemPagePriority' : [ 0x6d9, ['BitField', dict(start_bit = 1, end_bit = 4, native_type='unsigned char')]],
    'AllowWritesToExecutableMemory' : [ 0x6d9, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'CacheManagerActive' : [ 0x6dc, ['unsigned char']],
    'DisablePageFaultClustering' : [ 0x6dd, ['unsigned char']],
    'ActiveFaultCount' : [ 0x6de, ['unsigned char']],
    'LockOrderState' : [ 0x6df, ['unsigned char']],
    'AlpcMessageId' : [ 0x6e0, ['unsigned long long']],
    'AlpcMessage' : [ 0x6e8, ['pointer64', ['void']]],
    'AlpcReceiveAttributeSet' : [ 0x6e8, ['unsigned long']],
    'AlpcWaitListEntry' : [ 0x6f0, ['_LIST_ENTRY']],
    'ExitStatus' : [ 0x700, ['long']],
    'CacheManagerCount' : [ 0x704, ['unsigned long']],
    'IoBoostCount' : [ 0x708, ['unsigned long']],
    'IoQoSBoostCount' : [ 0x70c, ['unsigned long']],
    'IoQoSThrottleCount' : [ 0x710, ['unsigned long']],
    'BoostList' : [ 0x718, ['_LIST_ENTRY']],
    'DeboostList' : [ 0x728, ['_LIST_ENTRY']],
    'BoostListLock' : [ 0x738, ['unsigned long long']],
    'IrpListLock' : [ 0x740, ['unsigned long long']],
    'ReservedForSynchTracking' : [ 0x748, ['pointer64', ['void']]],
    'CmCallbackListHead' : [ 0x750, ['_SINGLE_LIST_ENTRY']],
    'ActivityId' : [ 0x758, ['pointer64', ['_GUID']]],
    'SeLearningModeListHead' : [ 0x760, ['_SINGLE_LIST_ENTRY']],
    'VerifierContext' : [ 0x768, ['pointer64', ['void']]],
    'KernelStackReference' : [ 0x770, ['unsigned long']],
    'AdjustedClientToken' : [ 0x778, ['pointer64', ['void']]],
    'WorkOnBehalfThread' : [ 0x780, ['pointer64', ['void']]],
    'PropertySet' : [ 0x788, ['_PS_PROPERTY_SET']],
    'PicoContext' : [ 0x7a0, ['pointer64', ['void']]],
    'UserFsBase' : [ 0x7a8, ['unsigned long long']],
    'UserGsBase' : [ 0x7b0, ['unsigned long long']],
    'EnergyValues' : [ 0x7b8, ['pointer64', ['_THREAD_ENERGY_VALUES']]],
    'CmDbgInfo' : [ 0x7c0, ['pointer64', ['void']]],
    'SelectedCpuSets' : [ 0x7c8, ['unsigned long long']],
    'SelectedCpuSetsIndirect' : [ 0x7c8, ['pointer64', ['unsigned long long']]],
    'Silo' : [ 0x7d0, ['pointer64', ['_EJOB']]],
    'ThreadName' : [ 0x7d8, ['pointer64', ['_UNICODE_STRING']]],
    'SetContextState' : [ 0x7e0, ['pointer64', ['_CONTEXT']]],
    'LastExpectedRunTime' : [ 0x7e8, ['unsigned long']],
    'OwnerEntryListHead' : [ 0x7f0, ['_LIST_ENTRY']],
    'DisownedOwnerEntryListLock' : [ 0x800, ['unsigned long long']],
    'DisownedOwnerEntryListHead' : [ 0x808, ['_LIST_ENTRY']],
} ],
  '__unnamed_13e8' : [ 0x4, {
    'ControlFlowGuardEnabled' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'ControlFlowGuardExportSuppressionEnabled' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'ControlFlowGuardStrict' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'DisallowStrippedImages' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'ForceRelocateImages' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'HighEntropyASLREnabled' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'StackRandomizationDisabled' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'ExtensionPointDisable' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'DisableDynamicCode' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'DisableDynamicCodeAllowOptOut' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'DisableDynamicCodeAllowRemoteDowngrade' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'AuditDisableDynamicCode' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'DisallowWin32kSystemCalls' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long')]],
    'AuditDisallowWin32kSystemCalls' : [ 0x0, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long')]],
    'EnableFilteredWin32kAPIs' : [ 0x0, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long')]],
    'AuditFilteredWin32kAPIs' : [ 0x0, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'DisableNonSystemFonts' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'AuditNonSystemFontLoading' : [ 0x0, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'PreferSystem32Images' : [ 0x0, ['BitField', dict(start_bit = 18, end_bit = 19, native_type='unsigned long')]],
    'ProhibitRemoteImageMap' : [ 0x0, ['BitField', dict(start_bit = 19, end_bit = 20, native_type='unsigned long')]],
    'AuditProhibitRemoteImageMap' : [ 0x0, ['BitField', dict(start_bit = 20, end_bit = 21, native_type='unsigned long')]],
    'ProhibitLowILImageMap' : [ 0x0, ['BitField', dict(start_bit = 21, end_bit = 22, native_type='unsigned long')]],
    'AuditProhibitLowILImageMap' : [ 0x0, ['BitField', dict(start_bit = 22, end_bit = 23, native_type='unsigned long')]],
    'SignatureMitigationOptIn' : [ 0x0, ['BitField', dict(start_bit = 23, end_bit = 24, native_type='unsigned long')]],
    'AuditBlockNonMicrosoftBinaries' : [ 0x0, ['BitField', dict(start_bit = 24, end_bit = 25, native_type='unsigned long')]],
    'AuditBlockNonMicrosoftBinariesAllowStore' : [ 0x0, ['BitField', dict(start_bit = 25, end_bit = 26, native_type='unsigned long')]],
    'LoaderIntegrityContinuityEnabled' : [ 0x0, ['BitField', dict(start_bit = 26, end_bit = 27, native_type='unsigned long')]],
    'AuditLoaderIntegrityContinuity' : [ 0x0, ['BitField', dict(start_bit = 27, end_bit = 28, native_type='unsigned long')]],
    'EnableModuleTamperingProtection' : [ 0x0, ['BitField', dict(start_bit = 28, end_bit = 29, native_type='unsigned long')]],
    'EnableModuleTamperingProtectionNoInherit' : [ 0x0, ['BitField', dict(start_bit = 29, end_bit = 30, native_type='unsigned long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 30, end_bit = 31, native_type='unsigned long')]],
} ],
  '__unnamed_13ea' : [ 0x4, {
    'EnableExportAddressFilter' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'AuditExportAddressFilter' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'EnableExportAddressFilterPlus' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'AuditExportAddressFilterPlus' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'EnableRopStackPivot' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'AuditRopStackPivot' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'EnableRopCallerCheck' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'AuditRopCallerCheck' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'EnableRopSimExec' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'AuditRopSimExec' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'EnableImportAddressFilter' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'AuditImportAddressFilter' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
} ],
  '_EPROCESS' : [ 0x848, {
    'Pcb' : [ 0x0, ['_KPROCESS']],
    'ProcessLock' : [ 0x2d8, ['_EX_PUSH_LOCK']],
    'UniqueProcessId' : [ 0x2e0, ['pointer64', ['void']]],
    'ActiveProcessLinks' : [ 0x2e8, ['_LIST_ENTRY']],
    'RundownProtect' : [ 0x2f8, ['_EX_RUNDOWN_REF']],
    'Flags2' : [ 0x300, ['unsigned long']],
    'JobNotReallyActive' : [ 0x300, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'AccountingFolded' : [ 0x300, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'NewProcessReported' : [ 0x300, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'ExitProcessReported' : [ 0x300, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'ReportCommitChanges' : [ 0x300, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'LastReportMemory' : [ 0x300, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'ForceWakeCharge' : [ 0x300, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'CrossSessionCreate' : [ 0x300, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'NeedsHandleRundown' : [ 0x300, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'RefTraceEnabled' : [ 0x300, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'PicoCreated' : [ 0x300, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'EmptyJobEvaluated' : [ 0x300, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'DefaultPagePriority' : [ 0x300, ['BitField', dict(start_bit = 12, end_bit = 15, native_type='unsigned long')]],
    'PrimaryTokenFrozen' : [ 0x300, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'ProcessVerifierTarget' : [ 0x300, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'RestrictSetThreadContext' : [ 0x300, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'AffinityPermanent' : [ 0x300, ['BitField', dict(start_bit = 18, end_bit = 19, native_type='unsigned long')]],
    'AffinityUpdateEnable' : [ 0x300, ['BitField', dict(start_bit = 19, end_bit = 20, native_type='unsigned long')]],
    'PropagateNode' : [ 0x300, ['BitField', dict(start_bit = 20, end_bit = 21, native_type='unsigned long')]],
    'ExplicitAffinity' : [ 0x300, ['BitField', dict(start_bit = 21, end_bit = 22, native_type='unsigned long')]],
    'ProcessExecutionState' : [ 0x300, ['BitField', dict(start_bit = 22, end_bit = 24, native_type='unsigned long')]],
    'EnableReadVmLogging' : [ 0x300, ['BitField', dict(start_bit = 24, end_bit = 25, native_type='unsigned long')]],
    'EnableWriteVmLogging' : [ 0x300, ['BitField', dict(start_bit = 25, end_bit = 26, native_type='unsigned long')]],
    'FatalAccessTerminationRequested' : [ 0x300, ['BitField', dict(start_bit = 26, end_bit = 27, native_type='unsigned long')]],
    'DisableSystemAllowedCpuSet' : [ 0x300, ['BitField', dict(start_bit = 27, end_bit = 28, native_type='unsigned long')]],
    'ProcessStateChangeRequest' : [ 0x300, ['BitField', dict(start_bit = 28, end_bit = 30, native_type='unsigned long')]],
    'ProcessStateChangeInProgress' : [ 0x300, ['BitField', dict(start_bit = 30, end_bit = 31, native_type='unsigned long')]],
    'InPrivate' : [ 0x300, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
    'Flags' : [ 0x304, ['unsigned long']],
    'CreateReported' : [ 0x304, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'NoDebugInherit' : [ 0x304, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'ProcessExiting' : [ 0x304, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'ProcessDelete' : [ 0x304, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'ManageExecutableMemoryWrites' : [ 0x304, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'VmDeleted' : [ 0x304, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'OutswapEnabled' : [ 0x304, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'Outswapped' : [ 0x304, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'FailFastOnCommitFail' : [ 0x304, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'Wow64VaSpace4Gb' : [ 0x304, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'AddressSpaceInitialized' : [ 0x304, ['BitField', dict(start_bit = 10, end_bit = 12, native_type='unsigned long')]],
    'SetTimerResolution' : [ 0x304, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long')]],
    'BreakOnTermination' : [ 0x304, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long')]],
    'DeprioritizeViews' : [ 0x304, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long')]],
    'WriteWatch' : [ 0x304, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'ProcessInSession' : [ 0x304, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'OverrideAddressSpace' : [ 0x304, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'HasAddressSpace' : [ 0x304, ['BitField', dict(start_bit = 18, end_bit = 19, native_type='unsigned long')]],
    'LaunchPrefetched' : [ 0x304, ['BitField', dict(start_bit = 19, end_bit = 20, native_type='unsigned long')]],
    'Background' : [ 0x304, ['BitField', dict(start_bit = 20, end_bit = 21, native_type='unsigned long')]],
    'VmTopDown' : [ 0x304, ['BitField', dict(start_bit = 21, end_bit = 22, native_type='unsigned long')]],
    'ImageNotifyDone' : [ 0x304, ['BitField', dict(start_bit = 22, end_bit = 23, native_type='unsigned long')]],
    'PdeUpdateNeeded' : [ 0x304, ['BitField', dict(start_bit = 23, end_bit = 24, native_type='unsigned long')]],
    'VdmAllowed' : [ 0x304, ['BitField', dict(start_bit = 24, end_bit = 25, native_type='unsigned long')]],
    'ProcessRundown' : [ 0x304, ['BitField', dict(start_bit = 25, end_bit = 26, native_type='unsigned long')]],
    'ProcessInserted' : [ 0x304, ['BitField', dict(start_bit = 26, end_bit = 27, native_type='unsigned long')]],
    'DefaultIoPriority' : [ 0x304, ['BitField', dict(start_bit = 27, end_bit = 30, native_type='unsigned long')]],
    'ProcessSelfDelete' : [ 0x304, ['BitField', dict(start_bit = 30, end_bit = 31, native_type='unsigned long')]],
    'SetTimerResolutionLink' : [ 0x304, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
    'CreateTime' : [ 0x308, ['_LARGE_INTEGER']],
    'ProcessQuotaUsage' : [ 0x310, ['array', 2, ['unsigned long long']]],
    'ProcessQuotaPeak' : [ 0x320, ['array', 2, ['unsigned long long']]],
    'PeakVirtualSize' : [ 0x330, ['unsigned long long']],
    'VirtualSize' : [ 0x338, ['unsigned long long']],
    'SessionProcessLinks' : [ 0x340, ['_LIST_ENTRY']],
    'ExceptionPortData' : [ 0x350, ['pointer64', ['void']]],
    'ExceptionPortValue' : [ 0x350, ['unsigned long long']],
    'ExceptionPortState' : [ 0x350, ['BitField', dict(start_bit = 0, end_bit = 3, native_type='unsigned long long')]],
    'Token' : [ 0x358, ['_EX_FAST_REF']],
    'MmReserved' : [ 0x360, ['unsigned long long']],
    'AddressCreationLock' : [ 0x368, ['_EX_PUSH_LOCK']],
    'PageTableCommitmentLock' : [ 0x370, ['_EX_PUSH_LOCK']],
    'RotateInProgress' : [ 0x378, ['pointer64', ['_ETHREAD']]],
    'ForkInProgress' : [ 0x380, ['pointer64', ['_ETHREAD']]],
    'CommitChargeJob' : [ 0x388, ['pointer64', ['_EJOB']]],
    'CloneRoot' : [ 0x390, ['_RTL_AVL_TREE']],
    'NumberOfPrivatePages' : [ 0x398, ['unsigned long long']],
    'NumberOfLockedPages' : [ 0x3a0, ['unsigned long long']],
    'Win32Process' : [ 0x3a8, ['pointer64', ['void']]],
    'Job' : [ 0x3b0, ['pointer64', ['_EJOB']]],
    'SectionObject' : [ 0x3b8, ['pointer64', ['void']]],
    'SectionBaseAddress' : [ 0x3c0, ['pointer64', ['void']]],
    'Cookie' : [ 0x3c8, ['unsigned long']],
    'WorkingSetWatch' : [ 0x3d0, ['pointer64', ['_PAGEFAULT_HISTORY']]],
    'Win32WindowStation' : [ 0x3d8, ['pointer64', ['void']]],
    'InheritedFromUniqueProcessId' : [ 0x3e0, ['pointer64', ['void']]],
    'LdtInformation' : [ 0x3e8, ['pointer64', ['void']]],
    'OwnerProcessId' : [ 0x3f0, ['unsigned long long']],
    'Peb' : [ 0x3f8, ['pointer64', ['_PEB']]],
    'Session' : [ 0x400, ['pointer64', ['_MM_SESSION_SPACE']]],
    'AweInfo' : [ 0x408, ['pointer64', ['void']]],
    'QuotaBlock' : [ 0x410, ['pointer64', ['_EPROCESS_QUOTA_BLOCK']]],
    'ObjectTable' : [ 0x418, ['pointer64', ['_HANDLE_TABLE']]],
    'DebugPort' : [ 0x420, ['pointer64', ['void']]],
    'WoW64Process' : [ 0x428, ['pointer64', ['_EWOW64PROCESS']]],
    'DeviceMap' : [ 0x430, ['pointer64', ['void']]],
    'EtwDataSource' : [ 0x438, ['pointer64', ['void']]],
    'PageDirectoryPte' : [ 0x440, ['unsigned long long']],
    'ImageFilePointer' : [ 0x448, ['pointer64', ['_FILE_OBJECT']]],
    'ImageFileName' : [ 0x450, ['array', 15, ['unsigned char']]],
    'PriorityClass' : [ 0x45f, ['unsigned char']],
    'SecurityPort' : [ 0x460, ['pointer64', ['void']]],
    'SeAuditProcessCreationInfo' : [ 0x468, ['_SE_AUDIT_PROCESS_CREATION_INFO']],
    'JobLinks' : [ 0x470, ['_LIST_ENTRY']],
    'HighestUserAddress' : [ 0x480, ['pointer64', ['void']]],
    'ThreadListHead' : [ 0x488, ['_LIST_ENTRY']],
    'ActiveThreads' : [ 0x498, ['unsigned long']],
    'ImagePathHash' : [ 0x49c, ['unsigned long']],
    'DefaultHardErrorProcessing' : [ 0x4a0, ['unsigned long']],
    'LastThreadExitStatus' : [ 0x4a4, ['long']],
    'PrefetchTrace' : [ 0x4a8, ['_EX_FAST_REF']],
    'LockedPagesList' : [ 0x4b0, ['pointer64', ['void']]],
    'ReadOperationCount' : [ 0x4b8, ['_LARGE_INTEGER']],
    'WriteOperationCount' : [ 0x4c0, ['_LARGE_INTEGER']],
    'OtherOperationCount' : [ 0x4c8, ['_LARGE_INTEGER']],
    'ReadTransferCount' : [ 0x4d0, ['_LARGE_INTEGER']],
    'WriteTransferCount' : [ 0x4d8, ['_LARGE_INTEGER']],
    'OtherTransferCount' : [ 0x4e0, ['_LARGE_INTEGER']],
    'CommitChargeLimit' : [ 0x4e8, ['unsigned long long']],
    'CommitCharge' : [ 0x4f0, ['unsigned long long']],
    'CommitChargePeak' : [ 0x4f8, ['unsigned long long']],
    'Vm' : [ 0x500, ['_MMSUPPORT_FULL']],
    'MmProcessLinks' : [ 0x610, ['_LIST_ENTRY']],
    'ModifiedPageCount' : [ 0x620, ['unsigned long']],
    'ExitStatus' : [ 0x624, ['long']],
    'VadRoot' : [ 0x628, ['_RTL_AVL_TREE']],
    'VadHint' : [ 0x630, ['pointer64', ['void']]],
    'VadCount' : [ 0x638, ['unsigned long long']],
    'VadPhysicalPages' : [ 0x640, ['unsigned long long']],
    'VadPhysicalPagesLimit' : [ 0x648, ['unsigned long long']],
    'AlpcContext' : [ 0x650, ['_ALPC_PROCESS_CONTEXT']],
    'TimerResolutionLink' : [ 0x670, ['_LIST_ENTRY']],
    'TimerResolutionStackRecord' : [ 0x680, ['pointer64', ['_PO_DIAG_STACK_RECORD']]],
    'RequestedTimerResolution' : [ 0x688, ['unsigned long']],
    'SmallestTimerResolution' : [ 0x68c, ['unsigned long']],
    'ExitTime' : [ 0x690, ['_LARGE_INTEGER']],
    'InvertedFunctionTable' : [ 0x698, ['pointer64', ['_INVERTED_FUNCTION_TABLE']]],
    'InvertedFunctionTableLock' : [ 0x6a0, ['_EX_PUSH_LOCK']],
    'ActiveThreadsHighWatermark' : [ 0x6a8, ['unsigned long']],
    'LargePrivateVadCount' : [ 0x6ac, ['unsigned long']],
    'ThreadListLock' : [ 0x6b0, ['_EX_PUSH_LOCK']],
    'WnfContext' : [ 0x6b8, ['pointer64', ['void']]],
    'ServerSilo' : [ 0x6c0, ['pointer64', ['_EJOB']]],
    'SignatureLevel' : [ 0x6c8, ['unsigned char']],
    'SectionSignatureLevel' : [ 0x6c9, ['unsigned char']],
    'Protection' : [ 0x6ca, ['_PS_PROTECTION']],
    'HangCount' : [ 0x6cb, ['BitField', dict(start_bit = 0, end_bit = 4, native_type='unsigned char')]],
    'GhostCount' : [ 0x6cb, ['BitField', dict(start_bit = 4, end_bit = 8, native_type='unsigned char')]],
    'Flags3' : [ 0x6cc, ['unsigned long']],
    'Minimal' : [ 0x6cc, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'ReplacingPageRoot' : [ 0x6cc, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'Crashed' : [ 0x6cc, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'JobVadsAreTracked' : [ 0x6cc, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'VadTrackingDisabled' : [ 0x6cc, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'AuxiliaryProcess' : [ 0x6cc, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'SubsystemProcess' : [ 0x6cc, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'IndirectCpuSets' : [ 0x6cc, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'RelinquishedCommit' : [ 0x6cc, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'HighGraphicsPriority' : [ 0x6cc, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'CommitFailLogged' : [ 0x6cc, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'ReserveFailLogged' : [ 0x6cc, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'SystemProcess' : [ 0x6cc, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long')]],
    'HideImageBaseAddresses' : [ 0x6cc, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long')]],
    'AddressPolicyFrozen' : [ 0x6cc, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long')]],
    'ProcessFirstResume' : [ 0x6cc, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'ForegroundExternal' : [ 0x6cc, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'ForegroundSystem' : [ 0x6cc, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'HighMemoryPriority' : [ 0x6cc, ['BitField', dict(start_bit = 18, end_bit = 19, native_type='unsigned long')]],
    'DeviceAsid' : [ 0x6d0, ['long']],
    'SvmData' : [ 0x6d8, ['pointer64', ['void']]],
    'SvmProcessLock' : [ 0x6e0, ['_EX_PUSH_LOCK']],
    'SvmLock' : [ 0x6e8, ['unsigned long long']],
    'SvmProcessDeviceListHead' : [ 0x6f0, ['_LIST_ENTRY']],
    'LastFreezeInterruptTime' : [ 0x700, ['unsigned long long']],
    'DiskCounters' : [ 0x708, ['pointer64', ['_PROCESS_DISK_COUNTERS']]],
    'PicoContext' : [ 0x710, ['pointer64', ['void']]],
    'TrustletIdentity' : [ 0x718, ['unsigned long long']],
    'EnclaveTable' : [ 0x720, ['pointer64', ['void']]],
    'EnclaveNumber' : [ 0x728, ['unsigned long long']],
    'EnclaveLock' : [ 0x730, ['_EX_PUSH_LOCK']],
    'HighPriorityFaultsAllowed' : [ 0x738, ['unsigned long']],
    'EnergyContext' : [ 0x740, ['pointer64', ['_PO_PROCESS_ENERGY_CONTEXT']]],
    'VmContext' : [ 0x748, ['pointer64', ['void']]],
    'SequenceNumber' : [ 0x750, ['unsigned long long']],
    'CreateInterruptTime' : [ 0x758, ['unsigned long long']],
    'CreateUnbiasedInterruptTime' : [ 0x760, ['unsigned long long']],
    'TotalUnbiasedFrozenTime' : [ 0x768, ['unsigned long long']],
    'LastAppStateUpdateTime' : [ 0x770, ['unsigned long long']],
    'LastAppStateUptime' : [ 0x778, ['BitField', dict(start_bit = 0, end_bit = 61, native_type='unsigned long long')]],
    'LastAppState' : [ 0x778, ['BitField', dict(start_bit = 61, end_bit = 64, native_type='unsigned long long')]],
    'SharedCommitCharge' : [ 0x780, ['unsigned long long']],
    'SharedCommitLock' : [ 0x788, ['_EX_PUSH_LOCK']],
    'SharedCommitLinks' : [ 0x790, ['_LIST_ENTRY']],
    'AllowedCpuSets' : [ 0x7a0, ['unsigned long long']],
    'DefaultCpuSets' : [ 0x7a8, ['unsigned long long']],
    'AllowedCpuSetsIndirect' : [ 0x7a0, ['pointer64', ['unsigned long long']]],
    'DefaultCpuSetsIndirect' : [ 0x7a8, ['pointer64', ['unsigned long long']]],
    'DiskIoAttribution' : [ 0x7b0, ['pointer64', ['void']]],
    'DxgProcess' : [ 0x7b8, ['pointer64', ['void']]],
    'Win32KFilterSet' : [ 0x7c0, ['unsigned long']],
    'ProcessTimerDelay' : [ 0x7c8, ['_PS_INTERLOCKED_TIMER_DELAY_VALUES']],
    'KTimerSets' : [ 0x7d0, ['unsigned long']],
    'KTimer2Sets' : [ 0x7d4, ['unsigned long']],
    'ThreadTimerSets' : [ 0x7d8, ['unsigned long']],
    'VirtualTimerListLock' : [ 0x7e0, ['unsigned long long']],
    'VirtualTimerListHead' : [ 0x7e8, ['_LIST_ENTRY']],
    'WakeChannel' : [ 0x7f8, ['_WNF_STATE_NAME']],
    'WakeInfo' : [ 0x7f8, ['_PS_PROCESS_WAKE_INFORMATION']],
    'MitigationFlags' : [ 0x828, ['unsigned long']],
    'MitigationFlagsValues' : [ 0x828, ['__unnamed_13e8']],
    'MitigationFlags2' : [ 0x82c, ['unsigned long']],
    'MitigationFlags2Values' : [ 0x82c, ['__unnamed_13ea']],
    'PartitionObject' : [ 0x830, ['pointer64', ['void']]],
    'SecurityDomain' : [ 0x838, ['unsigned long long']],
    'CoverageSamplerContext' : [ 0x840, ['pointer64', ['void']]],
} ],
  '_EWOW64PROCESS' : [ 0x10, {
    'Peb' : [ 0x0, ['pointer64', ['void']]],
    'Machine' : [ 0x8, ['unsigned short']],
    'NtdllType' : [ 0xc, ['Enumeration', dict(target = 'long', choices = {0: u'PsNativeSystemDll', 1: u'PsWowX86SystemDll', 2: u'PsWowArm32SystemDll', 3: u'PsWowAmd64SystemDll', 4: u'PsWowChpeX86SystemDll', 5: u'PsVsmEnclaveRuntimeDll', 6: u'PsSystemDllTotalTypes'})]],
} ],
  '__unnamed_140a' : [ 0x8, {
    'MasterIrp' : [ 0x0, ['pointer64', ['_IRP']]],
    'IrpCount' : [ 0x0, ['long']],
    'SystemBuffer' : [ 0x0, ['pointer64', ['void']]],
} ],
  '__unnamed_1410' : [ 0x10, {
    'UserApcRoutine' : [ 0x0, ['pointer64', ['void']]],
    'IssuingProcess' : [ 0x0, ['pointer64', ['void']]],
    'UserApcContext' : [ 0x8, ['pointer64', ['void']]],
} ],
  '__unnamed_1412' : [ 0x10, {
    'AsynchronousParameters' : [ 0x0, ['__unnamed_1410']],
    'AllocationSize' : [ 0x0, ['_LARGE_INTEGER']],
} ],
  '__unnamed_141b' : [ 0x58, {
    'DeviceQueueEntry' : [ 0x0, ['_KDEVICE_QUEUE_ENTRY']],
    'DriverContext' : [ 0x0, ['array', 4, ['pointer64', ['void']]]],
    'Thread' : [ 0x20, ['pointer64', ['_ETHREAD']]],
    'AuxiliaryBuffer' : [ 0x28, ['pointer64', ['unsigned char']]],
    'ListEntry' : [ 0x30, ['_LIST_ENTRY']],
    'CurrentStackLocation' : [ 0x40, ['pointer64', ['_IO_STACK_LOCATION']]],
    'PacketType' : [ 0x40, ['unsigned long']],
    'OriginalFileObject' : [ 0x48, ['pointer64', ['_FILE_OBJECT']]],
    'IrpExtension' : [ 0x50, ['pointer64', ['void']]],
} ],
  '__unnamed_141d' : [ 0x58, {
    'Overlay' : [ 0x0, ['__unnamed_141b']],
    'Apc' : [ 0x0, ['_KAPC']],
    'CompletionKey' : [ 0x0, ['pointer64', ['void']]],
} ],
  '_IRP' : [ 0xd0, {
    'Type' : [ 0x0, ['short']],
    'Size' : [ 0x2, ['unsigned short']],
    'AllocationProcessorNumber' : [ 0x4, ['unsigned short']],
    'Reserved' : [ 0x6, ['unsigned short']],
    'MdlAddress' : [ 0x8, ['pointer64', ['_MDL']]],
    'Flags' : [ 0x10, ['unsigned long']],
    'AssociatedIrp' : [ 0x18, ['__unnamed_140a']],
    'ThreadListEntry' : [ 0x20, ['_LIST_ENTRY']],
    'IoStatus' : [ 0x30, ['_IO_STATUS_BLOCK']],
    'RequestorMode' : [ 0x40, ['unsigned char']],
    'PendingReturned' : [ 0x41, ['unsigned char']],
    'StackCount' : [ 0x42, ['unsigned char']],
    'CurrentLocation' : [ 0x43, ['unsigned char']],
    'Cancel' : [ 0x44, ['unsigned char']],
    'CancelIrql' : [ 0x45, ['unsigned char']],
    'ApcEnvironment' : [ 0x46, ['unsigned char']],
    'AllocationFlags' : [ 0x47, ['unsigned char']],
    'UserIosb' : [ 0x48, ['pointer64', ['_IO_STATUS_BLOCK']]],
    'UserEvent' : [ 0x50, ['pointer64', ['_KEVENT']]],
    'Overlay' : [ 0x58, ['__unnamed_1412']],
    'CancelRoutine' : [ 0x68, ['pointer64', ['void']]],
    'UserBuffer' : [ 0x70, ['pointer64', ['void']]],
    'Tail' : [ 0x78, ['__unnamed_141d']],
} ],
  '__unnamed_1424' : [ 0x20, {
    'SecurityContext' : [ 0x0, ['pointer64', ['_IO_SECURITY_CONTEXT']]],
    'Options' : [ 0x8, ['unsigned long']],
    'FileAttributes' : [ 0x10, ['unsigned short']],
    'ShareAccess' : [ 0x12, ['unsigned short']],
    'EaLength' : [ 0x18, ['unsigned long']],
} ],
  '__unnamed_1428' : [ 0x20, {
    'SecurityContext' : [ 0x0, ['pointer64', ['_IO_SECURITY_CONTEXT']]],
    'Options' : [ 0x8, ['unsigned long']],
    'Reserved' : [ 0x10, ['unsigned short']],
    'ShareAccess' : [ 0x12, ['unsigned short']],
    'Parameters' : [ 0x18, ['pointer64', ['_NAMED_PIPE_CREATE_PARAMETERS']]],
} ],
  '__unnamed_142c' : [ 0x20, {
    'SecurityContext' : [ 0x0, ['pointer64', ['_IO_SECURITY_CONTEXT']]],
    'Options' : [ 0x8, ['unsigned long']],
    'Reserved' : [ 0x10, ['unsigned short']],
    'ShareAccess' : [ 0x12, ['unsigned short']],
    'Parameters' : [ 0x18, ['pointer64', ['_MAILSLOT_CREATE_PARAMETERS']]],
} ],
  '__unnamed_142e' : [ 0x18, {
    'Length' : [ 0x0, ['unsigned long']],
    'Key' : [ 0x8, ['unsigned long']],
    'ByteOffset' : [ 0x10, ['_LARGE_INTEGER']],
} ],
  '__unnamed_1432' : [ 0x20, {
    'Length' : [ 0x0, ['unsigned long']],
    'FileName' : [ 0x8, ['pointer64', ['_UNICODE_STRING']]],
    'FileInformationClass' : [ 0x10, ['Enumeration', dict(target = 'long', choices = {1: u'FileDirectoryInformation', 2: u'FileFullDirectoryInformation', 3: u'FileBothDirectoryInformation', 4: u'FileBasicInformation', 5: u'FileStandardInformation', 6: u'FileInternalInformation', 7: u'FileEaInformation', 8: u'FileAccessInformation', 9: u'FileNameInformation', 10: u'FileRenameInformation', 11: u'FileLinkInformation', 12: u'FileNamesInformation', 13: u'FileDispositionInformation', 14: u'FilePositionInformation', 15: u'FileFullEaInformation', 16: u'FileModeInformation', 17: u'FileAlignmentInformation', 18: u'FileAllInformation', 19: u'FileAllocationInformation', 20: u'FileEndOfFileInformation', 21: u'FileAlternateNameInformation', 22: u'FileStreamInformation', 23: u'FilePipeInformation', 24: u'FilePipeLocalInformation', 25: u'FilePipeRemoteInformation', 26: u'FileMailslotQueryInformation', 27: u'FileMailslotSetInformation', 28: u'FileCompressionInformation', 29: u'FileObjectIdInformation', 30: u'FileCompletionInformation', 31: u'FileMoveClusterInformation', 32: u'FileQuotaInformation', 33: u'FileReparsePointInformation', 34: u'FileNetworkOpenInformation', 35: u'FileAttributeTagInformation', 36: u'FileTrackingInformation', 37: u'FileIdBothDirectoryInformation', 38: u'FileIdFullDirectoryInformation', 39: u'FileValidDataLengthInformation', 40: u'FileShortNameInformation', 41: u'FileIoCompletionNotificationInformation', 42: u'FileIoStatusBlockRangeInformation', 43: u'FileIoPriorityHintInformation', 44: u'FileSfioReserveInformation', 45: u'FileSfioVolumeInformation', 46: u'FileHardLinkInformation', 47: u'FileProcessIdsUsingFileInformation', 48: u'FileNormalizedNameInformation', 49: u'FileNetworkPhysicalNameInformation', 50: u'FileIdGlobalTxDirectoryInformation', 51: u'FileIsRemoteDeviceInformation', 52: u'FileUnusedInformation', 53: u'FileNumaNodeInformation', 54: u'FileStandardLinkInformation', 55: u'FileRemoteProtocolInformation', 56: u'FileRenameInformationBypassAccessCheck', 57: u'FileLinkInformationBypassAccessCheck', 58: u'FileVolumeNameInformation', 59: u'FileIdInformation', 60: u'FileIdExtdDirectoryInformation', 61: u'FileReplaceCompletionInformation', 62: u'FileHardLinkFullIdInformation', 63: u'FileIdExtdBothDirectoryInformation', 64: u'FileDispositionInformationEx', 65: u'FileRenameInformationEx', 66: u'FileRenameInformationExBypassAccessCheck', 67: u'FileDesiredStorageClassInformation', 68: u'FileStatInformation', 69: u'FileMemoryPartitionInformation', 70: u'FileStatLxInformation', 71: u'FileCaseSensitiveInformation', 72: u'FileMaximumInformation'})]],
    'FileIndex' : [ 0x18, ['unsigned long']],
} ],
  '__unnamed_1434' : [ 0x10, {
    'Length' : [ 0x0, ['unsigned long']],
    'CompletionFilter' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_1438' : [ 0x18, {
    'Length' : [ 0x0, ['unsigned long']],
    'CompletionFilter' : [ 0x8, ['unsigned long']],
    'DirectoryNotifyInformationClass' : [ 0x10, ['Enumeration', dict(target = 'long', choices = {1: u'DirectoryNotifyInformation', 2: u'DirectoryNotifyExtendedInformation'})]],
} ],
  '__unnamed_143a' : [ 0x10, {
    'Length' : [ 0x0, ['unsigned long']],
    'FileInformationClass' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {1: u'FileDirectoryInformation', 2: u'FileFullDirectoryInformation', 3: u'FileBothDirectoryInformation', 4: u'FileBasicInformation', 5: u'FileStandardInformation', 6: u'FileInternalInformation', 7: u'FileEaInformation', 8: u'FileAccessInformation', 9: u'FileNameInformation', 10: u'FileRenameInformation', 11: u'FileLinkInformation', 12: u'FileNamesInformation', 13: u'FileDispositionInformation', 14: u'FilePositionInformation', 15: u'FileFullEaInformation', 16: u'FileModeInformation', 17: u'FileAlignmentInformation', 18: u'FileAllInformation', 19: u'FileAllocationInformation', 20: u'FileEndOfFileInformation', 21: u'FileAlternateNameInformation', 22: u'FileStreamInformation', 23: u'FilePipeInformation', 24: u'FilePipeLocalInformation', 25: u'FilePipeRemoteInformation', 26: u'FileMailslotQueryInformation', 27: u'FileMailslotSetInformation', 28: u'FileCompressionInformation', 29: u'FileObjectIdInformation', 30: u'FileCompletionInformation', 31: u'FileMoveClusterInformation', 32: u'FileQuotaInformation', 33: u'FileReparsePointInformation', 34: u'FileNetworkOpenInformation', 35: u'FileAttributeTagInformation', 36: u'FileTrackingInformation', 37: u'FileIdBothDirectoryInformation', 38: u'FileIdFullDirectoryInformation', 39: u'FileValidDataLengthInformation', 40: u'FileShortNameInformation', 41: u'FileIoCompletionNotificationInformation', 42: u'FileIoStatusBlockRangeInformation', 43: u'FileIoPriorityHintInformation', 44: u'FileSfioReserveInformation', 45: u'FileSfioVolumeInformation', 46: u'FileHardLinkInformation', 47: u'FileProcessIdsUsingFileInformation', 48: u'FileNormalizedNameInformation', 49: u'FileNetworkPhysicalNameInformation', 50: u'FileIdGlobalTxDirectoryInformation', 51: u'FileIsRemoteDeviceInformation', 52: u'FileUnusedInformation', 53: u'FileNumaNodeInformation', 54: u'FileStandardLinkInformation', 55: u'FileRemoteProtocolInformation', 56: u'FileRenameInformationBypassAccessCheck', 57: u'FileLinkInformationBypassAccessCheck', 58: u'FileVolumeNameInformation', 59: u'FileIdInformation', 60: u'FileIdExtdDirectoryInformation', 61: u'FileReplaceCompletionInformation', 62: u'FileHardLinkFullIdInformation', 63: u'FileIdExtdBothDirectoryInformation', 64: u'FileDispositionInformationEx', 65: u'FileRenameInformationEx', 66: u'FileRenameInformationExBypassAccessCheck', 67: u'FileDesiredStorageClassInformation', 68: u'FileStatInformation', 69: u'FileMemoryPartitionInformation', 70: u'FileStatLxInformation', 71: u'FileCaseSensitiveInformation', 72: u'FileMaximumInformation'})]],
} ],
  '__unnamed_143c' : [ 0x20, {
    'Length' : [ 0x0, ['unsigned long']],
    'FileInformationClass' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {1: u'FileDirectoryInformation', 2: u'FileFullDirectoryInformation', 3: u'FileBothDirectoryInformation', 4: u'FileBasicInformation', 5: u'FileStandardInformation', 6: u'FileInternalInformation', 7: u'FileEaInformation', 8: u'FileAccessInformation', 9: u'FileNameInformation', 10: u'FileRenameInformation', 11: u'FileLinkInformation', 12: u'FileNamesInformation', 13: u'FileDispositionInformation', 14: u'FilePositionInformation', 15: u'FileFullEaInformation', 16: u'FileModeInformation', 17: u'FileAlignmentInformation', 18: u'FileAllInformation', 19: u'FileAllocationInformation', 20: u'FileEndOfFileInformation', 21: u'FileAlternateNameInformation', 22: u'FileStreamInformation', 23: u'FilePipeInformation', 24: u'FilePipeLocalInformation', 25: u'FilePipeRemoteInformation', 26: u'FileMailslotQueryInformation', 27: u'FileMailslotSetInformation', 28: u'FileCompressionInformation', 29: u'FileObjectIdInformation', 30: u'FileCompletionInformation', 31: u'FileMoveClusterInformation', 32: u'FileQuotaInformation', 33: u'FileReparsePointInformation', 34: u'FileNetworkOpenInformation', 35: u'FileAttributeTagInformation', 36: u'FileTrackingInformation', 37: u'FileIdBothDirectoryInformation', 38: u'FileIdFullDirectoryInformation', 39: u'FileValidDataLengthInformation', 40: u'FileShortNameInformation', 41: u'FileIoCompletionNotificationInformation', 42: u'FileIoStatusBlockRangeInformation', 43: u'FileIoPriorityHintInformation', 44: u'FileSfioReserveInformation', 45: u'FileSfioVolumeInformation', 46: u'FileHardLinkInformation', 47: u'FileProcessIdsUsingFileInformation', 48: u'FileNormalizedNameInformation', 49: u'FileNetworkPhysicalNameInformation', 50: u'FileIdGlobalTxDirectoryInformation', 51: u'FileIsRemoteDeviceInformation', 52: u'FileUnusedInformation', 53: u'FileNumaNodeInformation', 54: u'FileStandardLinkInformation', 55: u'FileRemoteProtocolInformation', 56: u'FileRenameInformationBypassAccessCheck', 57: u'FileLinkInformationBypassAccessCheck', 58: u'FileVolumeNameInformation', 59: u'FileIdInformation', 60: u'FileIdExtdDirectoryInformation', 61: u'FileReplaceCompletionInformation', 62: u'FileHardLinkFullIdInformation', 63: u'FileIdExtdBothDirectoryInformation', 64: u'FileDispositionInformationEx', 65: u'FileRenameInformationEx', 66: u'FileRenameInformationExBypassAccessCheck', 67: u'FileDesiredStorageClassInformation', 68: u'FileStatInformation', 69: u'FileMemoryPartitionInformation', 70: u'FileStatLxInformation', 71: u'FileCaseSensitiveInformation', 72: u'FileMaximumInformation'})]],
    'FileObject' : [ 0x10, ['pointer64', ['_FILE_OBJECT']]],
    'ReplaceIfExists' : [ 0x18, ['unsigned char']],
    'AdvanceOnly' : [ 0x19, ['unsigned char']],
    'ClusterCount' : [ 0x18, ['unsigned long']],
    'DeleteHandle' : [ 0x18, ['pointer64', ['void']]],
} ],
  '__unnamed_143e' : [ 0x20, {
    'Length' : [ 0x0, ['unsigned long']],
    'EaList' : [ 0x8, ['pointer64', ['void']]],
    'EaListLength' : [ 0x10, ['unsigned long']],
    'EaIndex' : [ 0x18, ['unsigned long']],
} ],
  '__unnamed_1440' : [ 0x4, {
    'Length' : [ 0x0, ['unsigned long']],
} ],
  '__unnamed_1444' : [ 0x10, {
    'Length' : [ 0x0, ['unsigned long']],
    'FsInformationClass' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {1: u'FileFsVolumeInformation', 2: u'FileFsLabelInformation', 3: u'FileFsSizeInformation', 4: u'FileFsDeviceInformation', 5: u'FileFsAttributeInformation', 6: u'FileFsControlInformation', 7: u'FileFsFullSizeInformation', 8: u'FileFsObjectIdInformation', 9: u'FileFsDriverPathInformation', 10: u'FileFsVolumeFlagsInformation', 11: u'FileFsSectorSizeInformation', 12: u'FileFsDataCopyInformation', 13: u'FileFsMetadataSizeInformation', 14: u'FileFsMaximumInformation'})]],
} ],
  '__unnamed_1446' : [ 0x20, {
    'OutputBufferLength' : [ 0x0, ['unsigned long']],
    'InputBufferLength' : [ 0x8, ['unsigned long']],
    'FsControlCode' : [ 0x10, ['unsigned long']],
    'Type3InputBuffer' : [ 0x18, ['pointer64', ['void']]],
} ],
  '__unnamed_1448' : [ 0x18, {
    'Length' : [ 0x0, ['pointer64', ['_LARGE_INTEGER']]],
    'Key' : [ 0x8, ['unsigned long']],
    'ByteOffset' : [ 0x10, ['_LARGE_INTEGER']],
} ],
  '__unnamed_144a' : [ 0x20, {
    'OutputBufferLength' : [ 0x0, ['unsigned long']],
    'InputBufferLength' : [ 0x8, ['unsigned long']],
    'IoControlCode' : [ 0x10, ['unsigned long']],
    'Type3InputBuffer' : [ 0x18, ['pointer64', ['void']]],
} ],
  '__unnamed_144c' : [ 0x10, {
    'SecurityInformation' : [ 0x0, ['unsigned long']],
    'Length' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_144e' : [ 0x10, {
    'SecurityInformation' : [ 0x0, ['unsigned long']],
    'SecurityDescriptor' : [ 0x8, ['pointer64', ['void']]],
} ],
  '__unnamed_1452' : [ 0x10, {
    'Vpb' : [ 0x0, ['pointer64', ['_VPB']]],
    'DeviceObject' : [ 0x8, ['pointer64', ['_DEVICE_OBJECT']]],
} ],
  '__unnamed_1456' : [ 0x8, {
    'Srb' : [ 0x0, ['pointer64', ['_SCSI_REQUEST_BLOCK']]],
} ],
  '__unnamed_145a' : [ 0x20, {
    'Length' : [ 0x0, ['unsigned long']],
    'StartSid' : [ 0x8, ['pointer64', ['void']]],
    'SidList' : [ 0x10, ['pointer64', ['_FILE_GET_QUOTA_INFORMATION']]],
    'SidListLength' : [ 0x18, ['unsigned long']],
} ],
  '__unnamed_145e' : [ 0x4, {
    'Type' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: u'BusRelations', 1: u'EjectionRelations', 2: u'PowerRelations', 3: u'RemovalRelations', 4: u'TargetDeviceRelation', 5: u'SingleBusRelations', 6: u'TransportRelations'})]],
} ],
  '__unnamed_1462' : [ 0x20, {
    'InterfaceType' : [ 0x0, ['pointer64', ['_GUID']]],
    'Size' : [ 0x8, ['unsigned short']],
    'Version' : [ 0xa, ['unsigned short']],
    'Interface' : [ 0x10, ['pointer64', ['_INTERFACE']]],
    'InterfaceSpecificData' : [ 0x18, ['pointer64', ['void']]],
} ],
  '__unnamed_1466' : [ 0x8, {
    'Capabilities' : [ 0x0, ['pointer64', ['_DEVICE_CAPABILITIES']]],
} ],
  '__unnamed_146a' : [ 0x8, {
    'IoResourceRequirementList' : [ 0x0, ['pointer64', ['_IO_RESOURCE_REQUIREMENTS_LIST']]],
} ],
  '__unnamed_146c' : [ 0x20, {
    'WhichSpace' : [ 0x0, ['unsigned long']],
    'Buffer' : [ 0x8, ['pointer64', ['void']]],
    'Offset' : [ 0x10, ['unsigned long']],
    'Length' : [ 0x18, ['unsigned long']],
} ],
  '__unnamed_146e' : [ 0x1, {
    'Lock' : [ 0x0, ['unsigned char']],
} ],
  '__unnamed_1472' : [ 0x4, {
    'IdType' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: u'BusQueryDeviceID', 1: u'BusQueryHardwareIDs', 2: u'BusQueryCompatibleIDs', 3: u'BusQueryInstanceID', 4: u'BusQueryDeviceSerialNumber', 5: u'BusQueryContainerID'})]],
} ],
  '__unnamed_1476' : [ 0x10, {
    'DeviceTextType' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: u'DeviceTextDescription', 1: u'DeviceTextLocationInformation'})]],
    'LocaleId' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_147a' : [ 0x10, {
    'InPath' : [ 0x0, ['unsigned char']],
    'Reserved' : [ 0x1, ['array', 3, ['unsigned char']]],
    'Type' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {0: u'DeviceUsageTypeUndefined', 1: u'DeviceUsageTypePaging', 2: u'DeviceUsageTypeHibernation', 3: u'DeviceUsageTypeDumpFile', 4: u'DeviceUsageTypeBoot', 5: u'DeviceUsageTypePostDisplay'})]],
} ],
  '__unnamed_147e' : [ 0x4, {
    'PowerState' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: u'PowerSystemUnspecified', 1: u'PowerSystemWorking', 2: u'PowerSystemSleeping1', 3: u'PowerSystemSleeping2', 4: u'PowerSystemSleeping3', 5: u'PowerSystemHibernate', 6: u'PowerSystemShutdown', 7: u'PowerSystemMaximum'})]],
} ],
  '__unnamed_1482' : [ 0x8, {
    'PowerSequence' : [ 0x0, ['pointer64', ['_POWER_SEQUENCE']]],
} ],
  '__unnamed_148a' : [ 0x20, {
    'SystemContext' : [ 0x0, ['unsigned long']],
    'SystemPowerStateContext' : [ 0x0, ['_SYSTEM_POWER_STATE_CONTEXT']],
    'Type' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {0: u'SystemPowerState', 1: u'DevicePowerState'})]],
    'State' : [ 0x10, ['_POWER_STATE']],
    'ShutdownType' : [ 0x18, ['Enumeration', dict(target = 'long', choices = {0: u'PowerActionNone', 1: u'PowerActionReserved', 2: u'PowerActionSleep', 3: u'PowerActionHibernate', 4: u'PowerActionShutdown', 5: u'PowerActionShutdownReset', 6: u'PowerActionShutdownOff', 7: u'PowerActionWarmEject', 8: u'PowerActionDisplayOff'})]],
} ],
  '__unnamed_148e' : [ 0x10, {
    'AllocatedResources' : [ 0x0, ['pointer64', ['_CM_RESOURCE_LIST']]],
    'AllocatedResourcesTranslated' : [ 0x8, ['pointer64', ['_CM_RESOURCE_LIST']]],
} ],
  '__unnamed_1490' : [ 0x20, {
    'ProviderId' : [ 0x0, ['unsigned long long']],
    'DataPath' : [ 0x8, ['pointer64', ['void']]],
    'BufferSize' : [ 0x10, ['unsigned long']],
    'Buffer' : [ 0x18, ['pointer64', ['void']]],
} ],
  '__unnamed_1492' : [ 0x20, {
    'Argument1' : [ 0x0, ['pointer64', ['void']]],
    'Argument2' : [ 0x8, ['pointer64', ['void']]],
    'Argument3' : [ 0x10, ['pointer64', ['void']]],
    'Argument4' : [ 0x18, ['pointer64', ['void']]],
} ],
  '__unnamed_1494' : [ 0x20, {
    'Create' : [ 0x0, ['__unnamed_1424']],
    'CreatePipe' : [ 0x0, ['__unnamed_1428']],
    'CreateMailslot' : [ 0x0, ['__unnamed_142c']],
    'Read' : [ 0x0, ['__unnamed_142e']],
    'Write' : [ 0x0, ['__unnamed_142e']],
    'QueryDirectory' : [ 0x0, ['__unnamed_1432']],
    'NotifyDirectory' : [ 0x0, ['__unnamed_1434']],
    'NotifyDirectoryEx' : [ 0x0, ['__unnamed_1438']],
    'QueryFile' : [ 0x0, ['__unnamed_143a']],
    'SetFile' : [ 0x0, ['__unnamed_143c']],
    'QueryEa' : [ 0x0, ['__unnamed_143e']],
    'SetEa' : [ 0x0, ['__unnamed_1440']],
    'QueryVolume' : [ 0x0, ['__unnamed_1444']],
    'SetVolume' : [ 0x0, ['__unnamed_1444']],
    'FileSystemControl' : [ 0x0, ['__unnamed_1446']],
    'LockControl' : [ 0x0, ['__unnamed_1448']],
    'DeviceIoControl' : [ 0x0, ['__unnamed_144a']],
    'QuerySecurity' : [ 0x0, ['__unnamed_144c']],
    'SetSecurity' : [ 0x0, ['__unnamed_144e']],
    'MountVolume' : [ 0x0, ['__unnamed_1452']],
    'VerifyVolume' : [ 0x0, ['__unnamed_1452']],
    'Scsi' : [ 0x0, ['__unnamed_1456']],
    'QueryQuota' : [ 0x0, ['__unnamed_145a']],
    'SetQuota' : [ 0x0, ['__unnamed_1440']],
    'QueryDeviceRelations' : [ 0x0, ['__unnamed_145e']],
    'QueryInterface' : [ 0x0, ['__unnamed_1462']],
    'DeviceCapabilities' : [ 0x0, ['__unnamed_1466']],
    'FilterResourceRequirements' : [ 0x0, ['__unnamed_146a']],
    'ReadWriteConfig' : [ 0x0, ['__unnamed_146c']],
    'SetLock' : [ 0x0, ['__unnamed_146e']],
    'QueryId' : [ 0x0, ['__unnamed_1472']],
    'QueryDeviceText' : [ 0x0, ['__unnamed_1476']],
    'UsageNotification' : [ 0x0, ['__unnamed_147a']],
    'WaitWake' : [ 0x0, ['__unnamed_147e']],
    'PowerSequence' : [ 0x0, ['__unnamed_1482']],
    'Power' : [ 0x0, ['__unnamed_148a']],
    'StartDevice' : [ 0x0, ['__unnamed_148e']],
    'WMI' : [ 0x0, ['__unnamed_1490']],
    'Others' : [ 0x0, ['__unnamed_1492']],
} ],
  '_IO_STACK_LOCATION' : [ 0x48, {
    'MajorFunction' : [ 0x0, ['unsigned char']],
    'MinorFunction' : [ 0x1, ['unsigned char']],
    'Flags' : [ 0x2, ['unsigned char']],
    'Control' : [ 0x3, ['unsigned char']],
    'Parameters' : [ 0x8, ['__unnamed_1494']],
    'DeviceObject' : [ 0x28, ['pointer64', ['_DEVICE_OBJECT']]],
    'FileObject' : [ 0x30, ['pointer64', ['_FILE_OBJECT']]],
    'CompletionRoutine' : [ 0x38, ['pointer64', ['void']]],
    'Context' : [ 0x40, ['pointer64', ['void']]],
} ],
  '__unnamed_14aa' : [ 0x48, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'Wcb' : [ 0x0, ['_WAIT_CONTEXT_BLOCK']],
} ],
  '_DEVICE_OBJECT' : [ 0x150, {
    'Type' : [ 0x0, ['short']],
    'Size' : [ 0x2, ['unsigned short']],
    'ReferenceCount' : [ 0x4, ['long']],
    'DriverObject' : [ 0x8, ['pointer64', ['_DRIVER_OBJECT']]],
    'NextDevice' : [ 0x10, ['pointer64', ['_DEVICE_OBJECT']]],
    'AttachedDevice' : [ 0x18, ['pointer64', ['_DEVICE_OBJECT']]],
    'CurrentIrp' : [ 0x20, ['pointer64', ['_IRP']]],
    'Timer' : [ 0x28, ['pointer64', ['_IO_TIMER']]],
    'Flags' : [ 0x30, ['unsigned long']],
    'Characteristics' : [ 0x34, ['unsigned long']],
    'Vpb' : [ 0x38, ['pointer64', ['_VPB']]],
    'DeviceExtension' : [ 0x40, ['pointer64', ['void']]],
    'DeviceType' : [ 0x48, ['unsigned long']],
    'StackSize' : [ 0x4c, ['unsigned char']],
    'Queue' : [ 0x50, ['__unnamed_14aa']],
    'AlignmentRequirement' : [ 0x98, ['unsigned long']],
    'DeviceQueue' : [ 0xa0, ['_KDEVICE_QUEUE']],
    'Dpc' : [ 0xc8, ['_KDPC']],
    'ActiveThreadCount' : [ 0x108, ['unsigned long']],
    'SecurityDescriptor' : [ 0x110, ['pointer64', ['void']]],
    'DeviceLock' : [ 0x118, ['_KEVENT']],
    'SectorSize' : [ 0x130, ['unsigned short']],
    'Spare1' : [ 0x132, ['unsigned short']],
    'DeviceObjectExtension' : [ 0x138, ['pointer64', ['_DEVOBJ_EXTENSION']]],
    'Reserved' : [ 0x140, ['pointer64', ['void']]],
} ],
  '_KDPC' : [ 0x40, {
    'TargetInfoAsUlong' : [ 0x0, ['unsigned long']],
    'Type' : [ 0x0, ['unsigned char']],
    'Importance' : [ 0x1, ['unsigned char']],
    'Number' : [ 0x2, ['unsigned short']],
    'DpcListEntry' : [ 0x8, ['_SINGLE_LIST_ENTRY']],
    'ProcessorHistory' : [ 0x10, ['unsigned long long']],
    'DeferredRoutine' : [ 0x18, ['pointer64', ['void']]],
    'DeferredContext' : [ 0x20, ['pointer64', ['void']]],
    'SystemArgument1' : [ 0x28, ['pointer64', ['void']]],
    'SystemArgument2' : [ 0x30, ['pointer64', ['void']]],
    'DpcData' : [ 0x38, ['pointer64', ['void']]],
} ],
  '_IO_DRIVER_CREATE_CONTEXT' : [ 0x28, {
    'Size' : [ 0x0, ['short']],
    'ExtraCreateParameter' : [ 0x8, ['pointer64', ['_ECP_LIST']]],
    'DeviceObjectHint' : [ 0x10, ['pointer64', ['void']]],
    'TxnParameters' : [ 0x18, ['pointer64', ['_TXN_PARAMETER_BLOCK']]],
    'SiloContext' : [ 0x20, ['pointer64', ['_EJOB']]],
} ],
  '_EJOB' : [ 0x620, {
    'Event' : [ 0x0, ['_KEVENT']],
    'JobLinks' : [ 0x18, ['_LIST_ENTRY']],
    'ProcessListHead' : [ 0x28, ['_LIST_ENTRY']],
    'JobLock' : [ 0x38, ['_ERESOURCE']],
    'TotalUserTime' : [ 0xa0, ['_LARGE_INTEGER']],
    'TotalKernelTime' : [ 0xa8, ['_LARGE_INTEGER']],
    'TotalCycleTime' : [ 0xb0, ['_LARGE_INTEGER']],
    'ThisPeriodTotalUserTime' : [ 0xb8, ['_LARGE_INTEGER']],
    'ThisPeriodTotalKernelTime' : [ 0xc0, ['_LARGE_INTEGER']],
    'TotalContextSwitches' : [ 0xc8, ['unsigned long long']],
    'TotalPageFaultCount' : [ 0xd0, ['unsigned long']],
    'TotalProcesses' : [ 0xd4, ['unsigned long']],
    'ActiveProcesses' : [ 0xd8, ['unsigned long']],
    'TotalTerminatedProcesses' : [ 0xdc, ['unsigned long']],
    'PerProcessUserTimeLimit' : [ 0xe0, ['_LARGE_INTEGER']],
    'PerJobUserTimeLimit' : [ 0xe8, ['_LARGE_INTEGER']],
    'MinimumWorkingSetSize' : [ 0xf0, ['unsigned long long']],
    'MaximumWorkingSetSize' : [ 0xf8, ['unsigned long long']],
    'LimitFlags' : [ 0x100, ['unsigned long']],
    'ActiveProcessLimit' : [ 0x104, ['unsigned long']],
    'Affinity' : [ 0x108, ['_KAFFINITY_EX']],
    'AccessState' : [ 0x1b0, ['pointer64', ['_JOB_ACCESS_STATE']]],
    'AccessStateQuotaReference' : [ 0x1b8, ['pointer64', ['void']]],
    'UIRestrictionsClass' : [ 0x1c0, ['unsigned long']],
    'EndOfJobTimeAction' : [ 0x1c4, ['unsigned long']],
    'CompletionPort' : [ 0x1c8, ['pointer64', ['void']]],
    'CompletionKey' : [ 0x1d0, ['pointer64', ['void']]],
    'CompletionCount' : [ 0x1d8, ['unsigned long long']],
    'SessionId' : [ 0x1e0, ['unsigned long']],
    'SchedulingClass' : [ 0x1e4, ['unsigned long']],
    'ReadOperationCount' : [ 0x1e8, ['unsigned long long']],
    'WriteOperationCount' : [ 0x1f0, ['unsigned long long']],
    'OtherOperationCount' : [ 0x1f8, ['unsigned long long']],
    'ReadTransferCount' : [ 0x200, ['unsigned long long']],
    'WriteTransferCount' : [ 0x208, ['unsigned long long']],
    'OtherTransferCount' : [ 0x210, ['unsigned long long']],
    'DiskIoInfo' : [ 0x218, ['_PROCESS_DISK_COUNTERS']],
    'ProcessMemoryLimit' : [ 0x240, ['unsigned long long']],
    'JobMemoryLimit' : [ 0x248, ['unsigned long long']],
    'JobTotalMemoryLimit' : [ 0x250, ['unsigned long long']],
    'PeakProcessMemoryUsed' : [ 0x258, ['unsigned long long']],
    'PeakJobMemoryUsed' : [ 0x260, ['unsigned long long']],
    'EffectiveAffinity' : [ 0x268, ['_KAFFINITY_EX']],
    'EffectivePerProcessUserTimeLimit' : [ 0x310, ['_LARGE_INTEGER']],
    'EffectiveMinimumWorkingSetSize' : [ 0x318, ['unsigned long long']],
    'EffectiveMaximumWorkingSetSize' : [ 0x320, ['unsigned long long']],
    'EffectiveProcessMemoryLimit' : [ 0x328, ['unsigned long long']],
    'EffectiveProcessMemoryLimitJob' : [ 0x330, ['pointer64', ['_EJOB']]],
    'EffectivePerProcessUserTimeLimitJob' : [ 0x338, ['pointer64', ['_EJOB']]],
    'EffectiveNetIoRateLimitJob' : [ 0x340, ['pointer64', ['_EJOB']]],
    'EffectiveHeapAttributionJob' : [ 0x348, ['pointer64', ['_EJOB']]],
    'EffectiveLimitFlags' : [ 0x350, ['unsigned long']],
    'EffectiveSchedulingClass' : [ 0x354, ['unsigned long']],
    'EffectiveFreezeCount' : [ 0x358, ['unsigned long']],
    'EffectiveBackgroundCount' : [ 0x35c, ['unsigned long']],
    'EffectiveSwapCount' : [ 0x360, ['unsigned long']],
    'EffectiveNotificationLimitCount' : [ 0x364, ['unsigned long']],
    'EffectivePriorityClass' : [ 0x368, ['unsigned char']],
    'PriorityClass' : [ 0x369, ['unsigned char']],
    'NestingDepth' : [ 0x36a, ['unsigned char']],
    'Reserved1' : [ 0x36b, ['array', 1, ['unsigned char']]],
    'CompletionFilter' : [ 0x36c, ['unsigned long']],
    'WakeChannel' : [ 0x370, ['_WNF_STATE_NAME']],
    'WakeInfo' : [ 0x370, ['_PS_JOB_WAKE_INFORMATION']],
    'WakeFilter' : [ 0x3b8, ['_JOBOBJECT_WAKE_FILTER']],
    'LowEdgeLatchFilter' : [ 0x3c0, ['unsigned long']],
    'NotificationLink' : [ 0x3c8, ['pointer64', ['_EJOB']]],
    'CurrentJobMemoryUsed' : [ 0x3d0, ['unsigned long long']],
    'NotificationInfo' : [ 0x3d8, ['pointer64', ['_JOB_NOTIFICATION_INFORMATION']]],
    'NotificationInfoQuotaReference' : [ 0x3e0, ['pointer64', ['void']]],
    'NotificationPacket' : [ 0x3e8, ['pointer64', ['_IO_MINI_COMPLETION_PACKET_USER']]],
    'CpuRateControl' : [ 0x3f0, ['pointer64', ['_JOB_CPU_RATE_CONTROL']]],
    'EffectiveSchedulingGroup' : [ 0x3f8, ['pointer64', ['void']]],
    'ReadyTime' : [ 0x400, ['unsigned long long']],
    'MemoryLimitsLock' : [ 0x408, ['_EX_PUSH_LOCK']],
    'SiblingJobLinks' : [ 0x410, ['_LIST_ENTRY']],
    'ChildJobListHead' : [ 0x420, ['_LIST_ENTRY']],
    'ParentJob' : [ 0x430, ['pointer64', ['_EJOB']]],
    'RootJob' : [ 0x438, ['pointer64', ['_EJOB']]],
    'IteratorListHead' : [ 0x440, ['_LIST_ENTRY']],
    'AncestorCount' : [ 0x450, ['unsigned long long']],
    'Ancestors' : [ 0x458, ['pointer64', ['pointer64', ['_EJOB']]]],
    'SessionObject' : [ 0x458, ['pointer64', ['void']]],
    'Accounting' : [ 0x460, ['_EPROCESS_VALUES']],
    'ShadowActiveProcessCount' : [ 0x4b8, ['unsigned long']],
    'ActiveAuxiliaryProcessCount' : [ 0x4bc, ['unsigned long']],
    'SequenceNumber' : [ 0x4c0, ['unsigned long']],
    'JobId' : [ 0x4c4, ['unsigned long']],
    'ContainerId' : [ 0x4c8, ['_GUID']],
    'ContainerTelemetryId' : [ 0x4d8, ['_GUID']],
    'ServerSiloGlobals' : [ 0x4e8, ['pointer64', ['_ESERVERSILO_GLOBALS']]],
    'PropertySet' : [ 0x4f0, ['_PS_PROPERTY_SET']],
    'Storage' : [ 0x508, ['pointer64', ['_PSP_STORAGE']]],
    'NetRateControl' : [ 0x510, ['pointer64', ['_JOB_NET_RATE_CONTROL']]],
    'JobFlags' : [ 0x518, ['unsigned long']],
    'CloseDone' : [ 0x518, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'MultiGroup' : [ 0x518, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'OutstandingNotification' : [ 0x518, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'NotificationInProgress' : [ 0x518, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'UILimits' : [ 0x518, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'CpuRateControlActive' : [ 0x518, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'OwnCpuRateControl' : [ 0x518, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'Terminating' : [ 0x518, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'WorkingSetLock' : [ 0x518, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'JobFrozen' : [ 0x518, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'Background' : [ 0x518, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'WakeNotificationAllocated' : [ 0x518, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'WakeNotificationEnabled' : [ 0x518, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long')]],
    'WakeNotificationPending' : [ 0x518, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long')]],
    'LimitNotificationRequired' : [ 0x518, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long')]],
    'ZeroCountNotificationRequired' : [ 0x518, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'CycleTimeNotificationRequired' : [ 0x518, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'CycleTimeNotificationPending' : [ 0x518, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'TimersVirtualized' : [ 0x518, ['BitField', dict(start_bit = 18, end_bit = 19, native_type='unsigned long')]],
    'JobSwapped' : [ 0x518, ['BitField', dict(start_bit = 19, end_bit = 20, native_type='unsigned long')]],
    'ViolationDetected' : [ 0x518, ['BitField', dict(start_bit = 20, end_bit = 21, native_type='unsigned long')]],
    'EmptyJobNotified' : [ 0x518, ['BitField', dict(start_bit = 21, end_bit = 22, native_type='unsigned long')]],
    'NoSystemCharge' : [ 0x518, ['BitField', dict(start_bit = 22, end_bit = 23, native_type='unsigned long')]],
    'DropNoWakeCharges' : [ 0x518, ['BitField', dict(start_bit = 23, end_bit = 24, native_type='unsigned long')]],
    'NoWakeChargePolicyDecided' : [ 0x518, ['BitField', dict(start_bit = 24, end_bit = 25, native_type='unsigned long')]],
    'NetRateControlActive' : [ 0x518, ['BitField', dict(start_bit = 25, end_bit = 26, native_type='unsigned long')]],
    'OwnNetRateControl' : [ 0x518, ['BitField', dict(start_bit = 26, end_bit = 27, native_type='unsigned long')]],
    'IoRateControlActive' : [ 0x518, ['BitField', dict(start_bit = 27, end_bit = 28, native_type='unsigned long')]],
    'OwnIoRateControl' : [ 0x518, ['BitField', dict(start_bit = 28, end_bit = 29, native_type='unsigned long')]],
    'DisallowNewProcesses' : [ 0x518, ['BitField', dict(start_bit = 29, end_bit = 30, native_type='unsigned long')]],
    'Silo' : [ 0x518, ['BitField', dict(start_bit = 30, end_bit = 31, native_type='unsigned long')]],
    'ContainerTelemetryIdSet' : [ 0x518, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
    'JobFlags2' : [ 0x51c, ['unsigned long']],
    'ParentLocked' : [ 0x51c, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'EnableUsermodeSiloThreadImpersonation' : [ 0x51c, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'DisallowUsermodeSiloThreadImpersonation' : [ 0x51c, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'EnergyValues' : [ 0x520, ['pointer64', ['_PROCESS_EXTENDED_ENERGY_VALUES']]],
    'SharedCommitCharge' : [ 0x528, ['unsigned long long']],
    'DiskIoAttributionUserRefCount' : [ 0x530, ['unsigned long']],
    'DiskIoAttributionRefCount' : [ 0x534, ['unsigned long']],
    'DiskIoAttributionContext' : [ 0x538, ['pointer64', ['void']]],
    'DiskIoAttributionOwnerJob' : [ 0x538, ['pointer64', ['_EJOB']]],
    'IoRateControlHeader' : [ 0x540, ['_JOB_RATE_CONTROL_HEADER']],
    'GlobalIoControl' : [ 0x568, ['_PS_IO_CONTROL_ENTRY']],
    'IoControlStateLock' : [ 0x5a0, ['long']],
    'VolumeIoControlTree' : [ 0x5a8, ['_RTL_RB_TREE']],
    'IoRateOverQuotaHistory' : [ 0x5b8, ['unsigned long long']],
    'IoRateCurrentGeneration' : [ 0x5c0, ['unsigned long']],
    'IoRateLastQueryGeneration' : [ 0x5c4, ['unsigned long']],
    'IoRateGenerationLength' : [ 0x5c8, ['unsigned long']],
    'IoRateOverQuotaNotifySequenceId' : [ 0x5cc, ['unsigned long']],
    'LastThrottledIoTime' : [ 0x5d0, ['unsigned long long']],
    'IoControlLock' : [ 0x5d8, ['_EX_PUSH_LOCK']],
    'SiloHardReferenceCount' : [ 0x5e0, ['unsigned long long']],
    'RundownWorkItem' : [ 0x5e8, ['_WORK_QUEUE_ITEM']],
    'PartitionObject' : [ 0x608, ['pointer64', ['void']]],
    'PartitionOwnerJob' : [ 0x610, ['pointer64', ['_EJOB']]],
    'EnergyTrackingState' : [ 0x618, ['_JOBOBJECT_ENERGY_TRACKING_STATE']],
} ],
  '_IO_PRIORITY_INFO' : [ 0x10, {
    'Size' : [ 0x0, ['unsigned long']],
    'ThreadPriority' : [ 0x4, ['unsigned long']],
    'PagePriority' : [ 0x8, ['unsigned long']],
    'IoPriority' : [ 0xc, ['Enumeration', dict(target = 'long', choices = {0: u'IoPriorityVeryLow', 1: u'IoPriorityLow', 2: u'IoPriorityNormal', 3: u'IoPriorityHigh', 4: u'IoPriorityCritical', 5: u'MaxIoPriorityTypes'})]],
} ],
  '_MDL' : [ 0x30, {
    'Next' : [ 0x0, ['pointer64', ['_MDL']]],
    'Size' : [ 0x8, ['short']],
    'MdlFlags' : [ 0xa, ['short']],
    'AllocationProcessorNumber' : [ 0xc, ['unsigned short']],
    'Reserved' : [ 0xe, ['unsigned short']],
    'Process' : [ 0x10, ['pointer64', ['_EPROCESS']]],
    'MappedSystemVa' : [ 0x18, ['pointer64', ['void']]],
    'StartVa' : [ 0x20, ['pointer64', ['void']]],
    'ByteCount' : [ 0x28, ['unsigned long']],
    'ByteOffset' : [ 0x2c, ['unsigned long']],
} ],
  '_EVENT_DATA_DESCRIPTOR' : [ 0x10, {
    'Ptr' : [ 0x0, ['unsigned long long']],
    'Size' : [ 0x8, ['unsigned long']],
    'Reserved' : [ 0xc, ['unsigned long']],
    'Type' : [ 0xc, ['unsigned char']],
    'Reserved1' : [ 0xd, ['unsigned char']],
    'Reserved2' : [ 0xe, ['unsigned short']],
} ],
  '_EVENT_DESCRIPTOR' : [ 0x10, {
    'Id' : [ 0x0, ['unsigned short']],
    'Version' : [ 0x2, ['unsigned char']],
    'Channel' : [ 0x3, ['unsigned char']],
    'Level' : [ 0x4, ['unsigned char']],
    'Opcode' : [ 0x5, ['unsigned char']],
    'Task' : [ 0x6, ['unsigned short']],
    'Keyword' : [ 0x8, ['unsigned long long']],
} ],
  '_EVENT_RECORD' : [ 0x70, {
    'EventHeader' : [ 0x0, ['_EVENT_HEADER']],
    'BufferContext' : [ 0x50, ['_ETW_BUFFER_CONTEXT']],
    'ExtendedDataCount' : [ 0x54, ['unsigned short']],
    'UserDataLength' : [ 0x56, ['unsigned short']],
    'ExtendedData' : [ 0x58, ['pointer64', ['_EVENT_HEADER_EXTENDED_DATA_ITEM']]],
    'UserData' : [ 0x60, ['pointer64', ['void']]],
    'UserContext' : [ 0x68, ['pointer64', ['void']]],
} ],
  '_PERFINFO_GROUPMASK' : [ 0x20, {
    'Masks' : [ 0x0, ['array', 8, ['unsigned long']]],
} ],
  '_FILE_OBJECT' : [ 0xd8, {
    'Type' : [ 0x0, ['short']],
    'Size' : [ 0x2, ['short']],
    'DeviceObject' : [ 0x8, ['pointer64', ['_DEVICE_OBJECT']]],
    'Vpb' : [ 0x10, ['pointer64', ['_VPB']]],
    'FsContext' : [ 0x18, ['pointer64', ['void']]],
    'FsContext2' : [ 0x20, ['pointer64', ['void']]],
    'SectionObjectPointer' : [ 0x28, ['pointer64', ['_SECTION_OBJECT_POINTERS']]],
    'PrivateCacheMap' : [ 0x30, ['pointer64', ['void']]],
    'FinalStatus' : [ 0x38, ['long']],
    'RelatedFileObject' : [ 0x40, ['pointer64', ['_FILE_OBJECT']]],
    'LockOperation' : [ 0x48, ['unsigned char']],
    'DeletePending' : [ 0x49, ['unsigned char']],
    'ReadAccess' : [ 0x4a, ['unsigned char']],
    'WriteAccess' : [ 0x4b, ['unsigned char']],
    'DeleteAccess' : [ 0x4c, ['unsigned char']],
    'SharedRead' : [ 0x4d, ['unsigned char']],
    'SharedWrite' : [ 0x4e, ['unsigned char']],
    'SharedDelete' : [ 0x4f, ['unsigned char']],
    'Flags' : [ 0x50, ['unsigned long']],
    'FileName' : [ 0x58, ['_UNICODE_STRING']],
    'CurrentByteOffset' : [ 0x68, ['_LARGE_INTEGER']],
    'Waiters' : [ 0x70, ['unsigned long']],
    'Busy' : [ 0x74, ['unsigned long']],
    'LastLock' : [ 0x78, ['pointer64', ['void']]],
    'Lock' : [ 0x80, ['_KEVENT']],
    'Event' : [ 0x98, ['_KEVENT']],
    'CompletionContext' : [ 0xb0, ['pointer64', ['_IO_COMPLETION_CONTEXT']]],
    'IrpListLock' : [ 0xb8, ['unsigned long long']],
    'IrpList' : [ 0xc0, ['_LIST_ENTRY']],
    'FileObjectExtension' : [ 0xd0, ['pointer64', ['void']]],
} ],
  '_EX_RUNDOWN_REF' : [ 0x8, {
    'Count' : [ 0x0, ['unsigned long long']],
    'Ptr' : [ 0x0, ['pointer64', ['void']]],
} ],
  '_MM_PAGE_ACCESS_INFO_HEADER' : [ 0x48, {
    'Link' : [ 0x0, ['_SINGLE_LIST_ENTRY']],
    'Type' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {0: u'MmPteAccessType', 1: u'MmCcReadAheadType', 2: u'MmPfnRepurposeType', 3: u'MmMaximumPageAccessType'})]],
    'EmptySequenceNumber' : [ 0xc, ['unsigned long']],
    'CurrentFileIndex' : [ 0xc, ['unsigned long']],
    'CreateTime' : [ 0x10, ['unsigned long long']],
    'EmptyTime' : [ 0x18, ['unsigned long long']],
    'TempEntry' : [ 0x18, ['pointer64', ['_MM_PAGE_ACCESS_INFO']]],
    'PageEntry' : [ 0x20, ['pointer64', ['_MM_PAGE_ACCESS_INFO']]],
    'FileEntry' : [ 0x28, ['pointer64', ['unsigned long long']]],
    'FirstFileEntry' : [ 0x30, ['pointer64', ['unsigned long long']]],
    'Process' : [ 0x38, ['pointer64', ['_EPROCESS']]],
    'SessionId' : [ 0x40, ['unsigned long']],
    'PageFrameEntry' : [ 0x20, ['pointer64', ['unsigned long long']]],
    'LastPageFrameEntry' : [ 0x28, ['pointer64', ['unsigned long long']]],
} ],
  '_PROCESS_EXTENDED_ENERGY_VALUES' : [ 0x1b0, {
    'Base' : [ 0x0, ['_PROCESS_ENERGY_VALUES']],
    'Extension' : [ 0x110, ['_PROCESS_ENERGY_VALUES_EXTENSION']],
} ],
  '_WHEA_ERROR_PACKET_V2' : [ 0x50, {
    'Signature' : [ 0x0, ['unsigned long']],
    'Version' : [ 0x4, ['unsigned long']],
    'Length' : [ 0x8, ['unsigned long']],
    'Flags' : [ 0xc, ['_WHEA_ERROR_PACKET_FLAGS']],
    'ErrorType' : [ 0x10, ['Enumeration', dict(target = 'long', choices = {0: u'WheaErrTypeProcessor', 1: u'WheaErrTypeMemory', 2: u'WheaErrTypePCIExpress', 3: u'WheaErrTypeNMI', 4: u'WheaErrTypePCIXBus', 5: u'WheaErrTypePCIXDevice', 6: u'WheaErrTypeGeneric'})]],
    'ErrorSeverity' : [ 0x14, ['Enumeration', dict(target = 'long', choices = {0: u'WheaErrSevRecoverable', 1: u'WheaErrSevFatal', 2: u'WheaErrSevCorrected', 3: u'WheaErrSevInformational'})]],
    'ErrorSourceId' : [ 0x18, ['unsigned long']],
    'ErrorSourceType' : [ 0x1c, ['Enumeration', dict(target = 'long', choices = {0: u'WheaErrSrcTypeMCE', 1: u'WheaErrSrcTypeCMC', 2: u'WheaErrSrcTypeCPE', 3: u'WheaErrSrcTypeNMI', 4: u'WheaErrSrcTypePCIe', 5: u'WheaErrSrcTypeGeneric', 6: u'WheaErrSrcTypeINIT', 7: u'WheaErrSrcTypeBOOT', 8: u'WheaErrSrcTypeSCIGeneric', 9: u'WheaErrSrcTypeIPFMCA', 10: u'WheaErrSrcTypeIPFCMC', 11: u'WheaErrSrcTypeIPFCPE', 12: u'WheaErrSrcTypeGenericV2', 13: u'WheaErrSrcTypeSCIGenericV2', 14: u'WheaErrSrcTypeMax'})]],
    'NotifyType' : [ 0x20, ['_GUID']],
    'Context' : [ 0x30, ['unsigned long long']],
    'DataFormat' : [ 0x38, ['Enumeration', dict(target = 'long', choices = {0: u'WheaDataFormatIPFSalRecord', 1: u'WheaDataFormatXPFMCA', 2: u'WheaDataFormatMemory', 3: u'WheaDataFormatPCIExpress', 4: u'WheaDataFormatNMIPort', 5: u'WheaDataFormatPCIXBus', 6: u'WheaDataFormatPCIXDevice', 7: u'WheaDataFormatGeneric', 8: u'WheaDataFormatMax'})]],
    'Reserved1' : [ 0x3c, ['unsigned long']],
    'DataOffset' : [ 0x40, ['unsigned long']],
    'DataLength' : [ 0x44, ['unsigned long']],
    'PshedDataOffset' : [ 0x48, ['unsigned long']],
    'PshedDataLength' : [ 0x4c, ['unsigned long']],
} ],
  '_WHEA_ERROR_RECORD' : [ 0xc8, {
    'Header' : [ 0x0, ['_WHEA_ERROR_RECORD_HEADER']],
    'SectionDescriptor' : [ 0x80, ['array', 1, ['_WHEA_ERROR_RECORD_SECTION_DESCRIPTOR']]],
} ],
  '_WHEA_ERROR_RECORD_SECTION_DESCRIPTOR' : [ 0x48, {
    'SectionOffset' : [ 0x0, ['unsigned long']],
    'SectionLength' : [ 0x4, ['unsigned long']],
    'Revision' : [ 0x8, ['_WHEA_REVISION']],
    'ValidBits' : [ 0xa, ['_WHEA_ERROR_RECORD_SECTION_DESCRIPTOR_VALIDBITS']],
    'Reserved' : [ 0xb, ['unsigned char']],
    'Flags' : [ 0xc, ['_WHEA_ERROR_RECORD_SECTION_DESCRIPTOR_FLAGS']],
    'SectionType' : [ 0x10, ['_GUID']],
    'FRUId' : [ 0x20, ['_GUID']],
    'SectionSeverity' : [ 0x30, ['Enumeration', dict(target = 'long', choices = {0: u'WheaErrSevRecoverable', 1: u'WheaErrSevFatal', 2: u'WheaErrSevCorrected', 3: u'WheaErrSevInformational'})]],
    'FRUText' : [ 0x34, ['array', 20, ['unsigned char']]],
} ],
  '_FSRTL_ADVANCED_FCB_HEADER' : [ 0x68, {
    'NodeTypeCode' : [ 0x0, ['short']],
    'NodeByteSize' : [ 0x2, ['short']],
    'Flags' : [ 0x4, ['unsigned char']],
    'IsFastIoPossible' : [ 0x5, ['unsigned char']],
    'Flags2' : [ 0x6, ['unsigned char']],
    'Reserved' : [ 0x7, ['BitField', dict(start_bit = 0, end_bit = 4, native_type='unsigned char')]],
    'Version' : [ 0x7, ['BitField', dict(start_bit = 4, end_bit = 8, native_type='unsigned char')]],
    'Resource' : [ 0x8, ['pointer64', ['_ERESOURCE']]],
    'PagingIoResource' : [ 0x10, ['pointer64', ['_ERESOURCE']]],
    'AllocationSize' : [ 0x18, ['_LARGE_INTEGER']],
    'FileSize' : [ 0x20, ['_LARGE_INTEGER']],
    'ValidDataLength' : [ 0x28, ['_LARGE_INTEGER']],
    'FastMutex' : [ 0x30, ['pointer64', ['_FAST_MUTEX']]],
    'FilterContexts' : [ 0x38, ['_LIST_ENTRY']],
    'PushLock' : [ 0x48, ['_EX_PUSH_LOCK']],
    'FileContextSupportPointer' : [ 0x50, ['pointer64', ['pointer64', ['void']]]],
    'Oplock' : [ 0x58, ['pointer64', ['void']]],
    'ReservedForRemote' : [ 0x58, ['pointer64', ['void']]],
    'ReservedContext' : [ 0x60, ['pointer64', ['void']]],
} ],
  '_iobuf' : [ 0x30, {
    '_ptr' : [ 0x0, ['pointer64', ['unsigned char']]],
    '_cnt' : [ 0x8, ['long']],
    '_base' : [ 0x10, ['pointer64', ['unsigned char']]],
    '_flag' : [ 0x18, ['long']],
    '_file' : [ 0x1c, ['long']],
    '_charbuf' : [ 0x20, ['long']],
    '_bufsiz' : [ 0x24, ['long']],
    '_tmpfname' : [ 0x28, ['pointer64', ['unsigned char']]],
} ],
  '_RTL_HASH_TABLE' : [ 0x10, {
    'EntryCount' : [ 0x0, ['unsigned long']],
    'MaskBitCount' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 5, native_type='unsigned long')]],
    'BucketCount' : [ 0x4, ['BitField', dict(start_bit = 5, end_bit = 32, native_type='unsigned long')]],
    'Buckets' : [ 0x8, ['pointer64', ['_SINGLE_LIST_ENTRY']]],
} ],
  '_RTL_HASH_ENTRY' : [ 0x10, {
    'BucketLink' : [ 0x0, ['_SINGLE_LIST_ENTRY']],
    'Key' : [ 0x8, ['unsigned long long']],
} ],
  '_RTL_HASH_TABLE_ITERATOR' : [ 0x18, {
    'Hash' : [ 0x0, ['pointer64', ['_RTL_HASH_TABLE']]],
    'HashEntry' : [ 0x8, ['pointer64', ['_RTL_HASH_ENTRY']]],
    'Bucket' : [ 0x10, ['pointer64', ['_SINGLE_LIST_ENTRY']]],
} ],
  '_RTL_CHASH_TABLE' : [ 0x18, {
    'Table' : [ 0x0, ['pointer64', ['_RTL_CHASH_ENTRY']]],
    'EntrySizeShift' : [ 0x8, ['unsigned long']],
    'EntryMax' : [ 0xc, ['unsigned long']],
    'EntryCount' : [ 0x10, ['unsigned long']],
} ],
  '_RTL_CHASH_ENTRY' : [ 0x8, {
    'Key' : [ 0x0, ['unsigned long long']],
} ],
  '_TlgProvider_t' : [ 0x40, {
    'LevelPlus1' : [ 0x0, ['unsigned long']],
    'ProviderMetadataPtr' : [ 0x8, ['pointer64', ['unsigned short']]],
    'KeywordAny' : [ 0x10, ['unsigned long long']],
    'KeywordAll' : [ 0x18, ['unsigned long long']],
    'RegHandle' : [ 0x20, ['unsigned long long']],
    'EnableCallback' : [ 0x28, ['pointer64', ['void']]],
    'CallbackContext' : [ 0x30, ['pointer64', ['void']]],
    'AnnotationFunc' : [ 0x38, ['pointer64', ['void']]],
} ],
  '_EVENT_FILTER_DESCRIPTOR' : [ 0x10, {
    'Ptr' : [ 0x0, ['unsigned long long']],
    'Size' : [ 0x8, ['unsigned long']],
    'Type' : [ 0xc, ['unsigned long']],
} ],
  '_TlgProviderMetadata_t' : [ 0x13, {
    'Type' : [ 0x0, ['unsigned char']],
    'ProviderId' : [ 0x1, ['_GUID']],
    'RemainingSize' : [ 0x11, ['unsigned short']],
} ],
  '_SID' : [ 0xc, {
    'Revision' : [ 0x0, ['unsigned char']],
    'SubAuthorityCount' : [ 0x1, ['unsigned char']],
    'IdentifierAuthority' : [ 0x2, ['_SID_IDENTIFIER_AUTHORITY']],
    'SubAuthority' : [ 0x8, ['array', 1, ['unsigned long']]],
} ],
  '__unnamed_1701' : [ 0x8, {
    'Long' : [ 0x0, ['unsigned long long']],
    'VolatileLong' : [ 0x0, ['unsigned long long']],
    'Hard' : [ 0x0, ['_MMPTE_HARDWARE']],
    'Flush' : [ 0x0, ['_HARDWARE_PTE']],
    'Proto' : [ 0x0, ['_MMPTE_PROTOTYPE']],
    'Soft' : [ 0x0, ['_MMPTE_SOFTWARE']],
    'TimeStamp' : [ 0x0, ['_MMPTE_TIMESTAMP']],
    'Trans' : [ 0x0, ['_MMPTE_TRANSITION']],
    'Subsect' : [ 0x0, ['_MMPTE_SUBSECTION']],
    'List' : [ 0x0, ['_MMPTE_LIST']],
} ],
  '_MMPTE' : [ 0x8, {
    'u' : [ 0x0, ['__unnamed_1701']],
} ],
  '_EX_PUSH_LOCK_AUTO_EXPAND' : [ 0x10, {
    'LocalLock' : [ 0x0, ['_EX_PUSH_LOCK']],
    'State' : [ 0x8, ['_EX_PUSH_LOCK_AUTO_EXPAND_STATE']],
    'Stats' : [ 0xc, ['unsigned long']],
} ],
  '_ERESOURCE' : [ 0x68, {
    'SystemResourcesList' : [ 0x0, ['_LIST_ENTRY']],
    'OwnerTable' : [ 0x10, ['pointer64', ['_OWNER_ENTRY']]],
    'ActiveCount' : [ 0x18, ['short']],
    'Flag' : [ 0x1a, ['unsigned short']],
    'ReservedLowFlags' : [ 0x1a, ['unsigned char']],
    'WaiterPriority' : [ 0x1b, ['unsigned char']],
    'SharedWaiters' : [ 0x20, ['pointer64', ['void']]],
    'ExclusiveWaiters' : [ 0x28, ['pointer64', ['void']]],
    'OwnerEntry' : [ 0x30, ['_OWNER_ENTRY']],
    'ActiveEntries' : [ 0x40, ['unsigned long']],
    'ContentionCount' : [ 0x44, ['unsigned long']],
    'NumberOfSharedWaiters' : [ 0x48, ['unsigned long']],
    'NumberOfExclusiveWaiters' : [ 0x4c, ['unsigned long']],
    'Reserved2' : [ 0x50, ['pointer64', ['void']]],
    'Address' : [ 0x58, ['pointer64', ['void']]],
    'CreatorBackTraceIndex' : [ 0x58, ['unsigned long long']],
    'SpinLock' : [ 0x60, ['unsigned long long']],
} ],
  '_MI_CACHED_PTE' : [ 0x8, {
    'GlobalTimeStamp' : [ 0x0, ['unsigned long']],
    'PteIndex' : [ 0x4, ['unsigned long']],
    'Long' : [ 0x0, ['long long']],
} ],
  '_KLOCK_QUEUE_HANDLE' : [ 0x18, {
    'LockQueue' : [ 0x0, ['_KSPIN_LOCK_QUEUE']],
    'OldIrql' : [ 0x10, ['unsigned char']],
} ],
  '_MMPFNLIST' : [ 0x28, {
    'Total' : [ 0x0, ['unsigned long long']],
    'ListName' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {0: u'ZeroedPageList', 1: u'FreePageList', 2: u'StandbyPageList', 3: u'ModifiedPageList', 4: u'ModifiedNoWritePageList', 5: u'BadPageList', 6: u'ActiveAndValid', 7: u'TransitionPage'})]],
    'Flink' : [ 0x10, ['unsigned long long']],
    'Blink' : [ 0x18, ['unsigned long long']],
    'Lock' : [ 0x20, ['unsigned long long']],
} ],
  '_MMCLONE_DESCRIPTOR' : [ 0x70, {
    'CloneNode' : [ 0x0, ['_RTL_BALANCED_NODE']],
    'Next' : [ 0x0, ['pointer64', ['_MMCLONE_DESCRIPTOR']]],
    'StartingCloneBlock' : [ 0x18, ['pointer64', ['_MMCLONE_BLOCK']]],
    'EndingCloneBlock' : [ 0x20, ['pointer64', ['_MMCLONE_BLOCK']]],
    'NumberOfPtes' : [ 0x28, ['unsigned long long']],
    'NumberOfReferences' : [ 0x30, ['unsigned long long']],
    'CloneHeader' : [ 0x38, ['pointer64', ['_MMCLONE_HEADER']]],
    'NonPagedPoolQuotaCharge' : [ 0x40, ['unsigned long long']],
    'DeleteList' : [ 0x50, ['_SLIST_ENTRY']],
    'NestingLevel' : [ 0x60, ['unsigned long long']],
} ],
  '__unnamed_1740' : [ 0x8, {
    'NextSlistPfn' : [ 0x0, ['_SINGLE_LIST_ENTRY']],
    'Next' : [ 0x0, ['pointer64', ['void']]],
    'Flink' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 36, native_type='unsigned long long')]],
    'NodeFlinkHigh' : [ 0x0, ['BitField', dict(start_bit = 36, end_bit = 64, native_type='unsigned long long')]],
    'Active' : [ 0x0, ['_MI_ACTIVE_PFN']],
} ],
  '__unnamed_1745' : [ 0x2, {
    'ReferenceCount' : [ 0x0, ['unsigned short']],
} ],
  '__unnamed_1747' : [ 0x4, {
    'EntireField' : [ 0x0, ['unsigned long']],
} ],
  '__unnamed_1749' : [ 0x4, {
    'ReferenceCount' : [ 0x0, ['unsigned short']],
    'e1' : [ 0x2, ['_MMPFNENTRY1']],
    'e3' : [ 0x3, ['_MMPFNENTRY3']],
    'e2' : [ 0x0, ['__unnamed_1745']],
    'e4' : [ 0x0, ['__unnamed_1747']],
} ],
  '__unnamed_1755' : [ 0x8, {
    'PteFrame' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 36, native_type='unsigned long long')]],
    'Channel' : [ 0x0, ['BitField', dict(start_bit = 36, end_bit = 38, native_type='unsigned long long')]],
    'Unused1' : [ 0x0, ['BitField', dict(start_bit = 38, end_bit = 39, native_type='unsigned long long')]],
    'Unused2' : [ 0x0, ['BitField', dict(start_bit = 39, end_bit = 40, native_type='unsigned long long')]],
    'Partition' : [ 0x0, ['BitField', dict(start_bit = 40, end_bit = 50, native_type='unsigned long long')]],
    'Spare' : [ 0x0, ['BitField', dict(start_bit = 50, end_bit = 52, native_type='unsigned long long')]],
    'FileOnly' : [ 0x0, ['BitField', dict(start_bit = 52, end_bit = 53, native_type='unsigned long long')]],
    'PfnExists' : [ 0x0, ['BitField', dict(start_bit = 53, end_bit = 54, native_type='unsigned long long')]],
    'PageIdentity' : [ 0x0, ['BitField', dict(start_bit = 54, end_bit = 57, native_type='unsigned long long')]],
    'PrototypePte' : [ 0x0, ['BitField', dict(start_bit = 57, end_bit = 58, native_type='unsigned long long')]],
    'PageColor' : [ 0x0, ['BitField', dict(start_bit = 58, end_bit = 64, native_type='unsigned long long')]],
    'EntireField' : [ 0x0, ['unsigned long long']],
} ],
  '_MMPFN' : [ 0x30, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'TreeNode' : [ 0x0, ['_RTL_BALANCED_NODE']],
    'u1' : [ 0x0, ['__unnamed_1740']],
    'PteAddress' : [ 0x8, ['pointer64', ['_MMPTE']]],
    'VolatilePteAddress' : [ 0x8, ['pointer64', ['void']]],
    'PteLong' : [ 0x8, ['unsigned long long']],
    'OriginalPte' : [ 0x10, ['_MMPTE']],
    'u2' : [ 0x18, ['_MIPFNBLINK']],
    'u3' : [ 0x20, ['__unnamed_1749']],
    'NodeBlinkLow' : [ 0x24, ['unsigned short']],
    'Unused' : [ 0x26, ['BitField', dict(start_bit = 0, end_bit = 4, native_type='unsigned char')]],
    'Unused2' : [ 0x26, ['BitField', dict(start_bit = 4, end_bit = 8, native_type='unsigned char')]],
    'ViewCount' : [ 0x27, ['unsigned char']],
    'NodeFlinkLow' : [ 0x27, ['unsigned char']],
    'u4' : [ 0x28, ['__unnamed_1755']],
} ],
  '__unnamed_1760' : [ 0x8, {
    'ImageCommitment' : [ 0x0, ['unsigned long long']],
    'CreatingProcessId' : [ 0x0, ['unsigned long']],
} ],
  '__unnamed_1764' : [ 0x8, {
    'ImageInformation' : [ 0x0, ['pointer64', ['_MI_SECTION_IMAGE_INFORMATION']]],
    'FirstMappedVa' : [ 0x0, ['pointer64', ['void']]],
} ],
  '_SEGMENT' : [ 0x48, {
    'ControlArea' : [ 0x0, ['pointer64', ['_CONTROL_AREA']]],
    'TotalNumberOfPtes' : [ 0x8, ['unsigned long']],
    'SegmentFlags' : [ 0xc, ['_SEGMENT_FLAGS']],
    'NumberOfCommittedPages' : [ 0x10, ['unsigned long long']],
    'SizeOfSegment' : [ 0x18, ['unsigned long long']],
    'ExtendInfo' : [ 0x20, ['pointer64', ['_MMEXTEND_INFO']]],
    'BasedAddress' : [ 0x20, ['pointer64', ['void']]],
    'SegmentLock' : [ 0x28, ['_EX_PUSH_LOCK']],
    'u1' : [ 0x30, ['__unnamed_1760']],
    'u2' : [ 0x38, ['__unnamed_1764']],
    'PrototypePte' : [ 0x40, ['pointer64', ['_MMPTE']]],
} ],
  '__unnamed_1769' : [ 0x4, {
    'LongFlags' : [ 0x0, ['unsigned long']],
    'Flags' : [ 0x0, ['_MMSECTION_FLAGS']],
} ],
  '__unnamed_176c' : [ 0x4, {
    'LongFlags' : [ 0x0, ['unsigned long']],
    'Flags' : [ 0x0, ['_MMSECTION_FLAGS2']],
} ],
  '__unnamed_1774' : [ 0x10, {
    'NumberOfSystemCacheViews' : [ 0x0, ['unsigned long']],
    'ImageRelocationStartBit' : [ 0x0, ['unsigned long']],
    'WritableUserReferences' : [ 0x4, ['long']],
    'ImageRelocationSizeIn64k' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 16, native_type='unsigned long')]],
    'LargePage' : [ 0x4, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'SystemImage' : [ 0x4, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'StrongCode' : [ 0x4, ['BitField', dict(start_bit = 18, end_bit = 20, native_type='unsigned long')]],
    'CantMove' : [ 0x4, ['BitField', dict(start_bit = 20, end_bit = 21, native_type='unsigned long')]],
    'BitMap' : [ 0x4, ['BitField', dict(start_bit = 21, end_bit = 23, native_type='unsigned long')]],
    'ImageActive' : [ 0x4, ['BitField', dict(start_bit = 23, end_bit = 24, native_type='unsigned long')]],
    'FlushInProgressCount' : [ 0x8, ['unsigned long']],
    'NumberOfSubsections' : [ 0x8, ['unsigned long']],
    'SeImageStub' : [ 0x8, ['pointer64', ['_MI_IMAGE_SECURITY_REFERENCE']]],
} ],
  '__unnamed_1776' : [ 0x10, {
    'e2' : [ 0x0, ['__unnamed_1774']],
} ],
  '__unnamed_1778' : [ 0x8, {
    'IoAttributionContext' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 61, native_type='unsigned long long')]],
    'Spare' : [ 0x0, ['BitField', dict(start_bit = 61, end_bit = 64, native_type='unsigned long long')]],
    'ImageCrossPartitionCharge' : [ 0x0, ['unsigned long long']],
    'CommittedPageCount' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 36, native_type='unsigned long long')]],
} ],
  '_CONTROL_AREA' : [ 0x80, {
    'Segment' : [ 0x0, ['pointer64', ['_SEGMENT']]],
    'ListHead' : [ 0x8, ['_LIST_ENTRY']],
    'NumberOfSectionReferences' : [ 0x18, ['unsigned long long']],
    'NumberOfPfnReferences' : [ 0x20, ['unsigned long long']],
    'NumberOfMappedViews' : [ 0x28, ['unsigned long long']],
    'NumberOfUserReferences' : [ 0x30, ['unsigned long long']],
    'u' : [ 0x38, ['__unnamed_1769']],
    'u1' : [ 0x3c, ['__unnamed_176c']],
    'FilePointer' : [ 0x40, ['_EX_FAST_REF']],
    'ControlAreaLock' : [ 0x48, ['long']],
    'ModifiedWriteCount' : [ 0x4c, ['unsigned long']],
    'WaitList' : [ 0x50, ['pointer64', ['_MI_CONTROL_AREA_WAIT_BLOCK']]],
    'u2' : [ 0x58, ['__unnamed_1776']],
    'FileObjectLock' : [ 0x68, ['_EX_PUSH_LOCK']],
    'LockedPages' : [ 0x70, ['unsigned long long']],
    'u3' : [ 0x78, ['__unnamed_1778']],
} ],
  '_MI_SYSTEM_PTE_TYPE' : [ 0x60, {
    'Bitmap' : [ 0x0, ['_RTL_BITMAP_EX']],
    'BasePte' : [ 0x10, ['pointer64', ['_MMPTE']]],
    'Flags' : [ 0x18, ['unsigned long']],
    'VaType' : [ 0x1c, ['Enumeration', dict(target = 'long', choices = {0: u'MiVaUnused', 1: u'MiVaSessionSpace', 2: u'MiVaProcessSpace', 3: u'MiVaBootLoaded', 4: u'MiVaPfnDatabase', 5: u'MiVaNonPagedPool', 6: u'MiVaPagedPool', 7: u'MiVaSpecialPoolPaged', 8: u'MiVaSystemCache', 9: u'MiVaSystemPtes', 10: u'MiVaHal', 11: u'MiVaSessionGlobalSpace', 12: u'MiVaDriverImages', 13: u'MiVaSpecialPoolNonPaged', 14: u'MiVaSystemPtesLarge', 15: u'MiVaKernelStacks', 16: u'MiVaMaximumType'})]],
    'FailureCount' : [ 0x20, ['pointer64', ['unsigned long']]],
    'PteFailures' : [ 0x28, ['unsigned long']],
    'SpinLock' : [ 0x30, ['unsigned long long']],
    'GlobalPushLock' : [ 0x30, ['pointer64', ['_EX_PUSH_LOCK']]],
    'TotalSystemPtes' : [ 0x38, ['unsigned long long']],
    'Hint' : [ 0x40, ['unsigned long long']],
    'LowestBitEverAllocated' : [ 0x48, ['unsigned long long']],
    'CachedPtes' : [ 0x50, ['pointer64', ['_MI_CACHED_PTES']]],
    'TotalFreeSystemPtes' : [ 0x58, ['unsigned long long']],
} ],
  '__unnamed_1790' : [ 0x4, {
    'LongFlags' : [ 0x0, ['unsigned long']],
    'VadFlags' : [ 0x0, ['_MMVAD_FLAGS']],
    'VolatileVadLong' : [ 0x0, ['unsigned long']],
} ],
  '__unnamed_1793' : [ 0x4, {
    'LongFlags1' : [ 0x0, ['unsigned long']],
    'VadFlags1' : [ 0x0, ['_MMVAD_FLAGS1']],
} ],
  '_MMVAD_SHORT' : [ 0x40, {
    'NextVad' : [ 0x0, ['pointer64', ['_MMVAD_SHORT']]],
    'ExtraCreateInfo' : [ 0x8, ['pointer64', ['void']]],
    'VadNode' : [ 0x0, ['_RTL_BALANCED_NODE']],
    'StartingVpn' : [ 0x18, ['unsigned long']],
    'EndingVpn' : [ 0x1c, ['unsigned long']],
    'StartingVpnHigh' : [ 0x20, ['unsigned char']],
    'EndingVpnHigh' : [ 0x21, ['unsigned char']],
    'CommitChargeHigh' : [ 0x22, ['unsigned char']],
    'SpareNT64VadUChar' : [ 0x23, ['unsigned char']],
    'ReferenceCount' : [ 0x24, ['long']],
    'PushLock' : [ 0x28, ['_EX_PUSH_LOCK']],
    'u' : [ 0x30, ['__unnamed_1790']],
    'u1' : [ 0x34, ['__unnamed_1793']],
    'EventList' : [ 0x38, ['pointer64', ['_MI_VAD_EVENT_BLOCK']]],
} ],
  '_MM_STORE_KEY' : [ 0x8, {
    'KeyLow' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 60, native_type='unsigned long long')]],
    'KeyHigh' : [ 0x0, ['BitField', dict(start_bit = 60, end_bit = 64, native_type='unsigned long long')]],
    'EntireKey' : [ 0x0, ['unsigned long long']],
} ],
  '_MI_PARTITION' : [ 0x2cc0, {
    'Core' : [ 0x0, ['_MI_PARTITION_CORE']],
    'Modwriter' : [ 0x1a8, ['_MI_PARTITION_MODWRITES']],
    'Store' : [ 0x470, ['_MI_PARTITION_STORES']],
    'Segments' : [ 0x500, ['_MI_PARTITION_SEGMENTS']],
    'PageLists' : [ 0x840, ['_MI_PARTITION_PAGE_LISTS']],
    'Commit' : [ 0x1800, ['_MI_PARTITION_COMMIT']],
    'Zeroing' : [ 0x1880, ['_MI_PARTITION_ZEROING']],
    'PageCombine' : [ 0x18e8, ['_MI_PAGE_COMBINING_SUPPORT']],
    'WorkingSetControl' : [ 0x1a70, ['pointer64', ['void']]],
    'WorkingSetExpansionHead' : [ 0x1a78, ['_MMWORKING_SET_EXPANSION_HEAD']],
    'Vp' : [ 0x1ac0, ['_MI_VISIBLE_PARTITION']],
} ],
  '_EPARTITION' : [ 0x80, {
    'MmPartition' : [ 0x0, ['pointer64', ['void']]],
    'CcPartition' : [ 0x8, ['pointer64', ['void']]],
    'ExPartition' : [ 0x10, ['pointer64', ['void']]],
    'HardReferenceCount' : [ 0x18, ['long long']],
    'OpenHandleCount' : [ 0x20, ['long long']],
    'ActivePartitionLinks' : [ 0x28, ['_LIST_ENTRY']],
    'ParentPartition' : [ 0x38, ['pointer64', ['_EPARTITION']]],
    'TeardownWorkItem' : [ 0x40, ['_WORK_QUEUE_ITEM']],
    'TeardownLock' : [ 0x60, ['_EX_PUSH_LOCK']],
    'SystemProcess' : [ 0x68, ['pointer64', ['_EPROCESS']]],
    'SystemProcessHandle' : [ 0x70, ['pointer64', ['void']]],
    'PartitionFlags' : [ 0x78, ['unsigned long']],
    'PairedWithJob' : [ 0x78, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
} ],
  '_HHIVE' : [ 0x600, {
    'Signature' : [ 0x0, ['unsigned long']],
    'GetCellRoutine' : [ 0x8, ['pointer64', ['void']]],
    'ReleaseCellRoutine' : [ 0x10, ['pointer64', ['void']]],
    'Allocate' : [ 0x18, ['pointer64', ['void']]],
    'Free' : [ 0x20, ['pointer64', ['void']]],
    'FileWrite' : [ 0x28, ['pointer64', ['void']]],
    'FileRead' : [ 0x30, ['pointer64', ['void']]],
    'HiveLoadFailure' : [ 0x38, ['pointer64', ['void']]],
    'BaseBlock' : [ 0x40, ['pointer64', ['_HBASE_BLOCK']]],
    'FlusherLock' : [ 0x48, ['_CMSI_RW_LOCK']],
    'WriterLock' : [ 0x50, ['_CMSI_RW_LOCK']],
    'DirtyVector' : [ 0x58, ['_RTL_BITMAP']],
    'DirtyCount' : [ 0x68, ['unsigned long']],
    'DirtyAlloc' : [ 0x6c, ['unsigned long']],
    'UnreconciledVector' : [ 0x70, ['_RTL_BITMAP']],
    'UnreconciledCount' : [ 0x80, ['unsigned long']],
    'BaseBlockAlloc' : [ 0x84, ['unsigned long']],
    'Cluster' : [ 0x88, ['unsigned long']],
    'Flat' : [ 0x8c, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'ReadOnly' : [ 0x8c, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'Reserved' : [ 0x8c, ['BitField', dict(start_bit = 2, end_bit = 8, native_type='unsigned char')]],
    'DirtyFlag' : [ 0x8d, ['unsigned char']],
    'HvBinHeadersUse' : [ 0x90, ['unsigned long']],
    'HvFreeCellsUse' : [ 0x94, ['unsigned long']],
    'HvUsedCellsUse' : [ 0x98, ['unsigned long']],
    'CmUsedCellsUse' : [ 0x9c, ['unsigned long']],
    'HiveFlags' : [ 0xa0, ['unsigned long']],
    'CurrentLog' : [ 0xa4, ['unsigned long']],
    'CurrentLogSequence' : [ 0xa8, ['unsigned long']],
    'CurrentLogMinimumSequence' : [ 0xac, ['unsigned long']],
    'CurrentLogOffset' : [ 0xb0, ['unsigned long']],
    'MinimumLogSequence' : [ 0xb4, ['unsigned long']],
    'LogFileSizeCap' : [ 0xb8, ['unsigned long']],
    'LogDataPresent' : [ 0xbc, ['array', 2, ['unsigned char']]],
    'PrimaryFileValid' : [ 0xbe, ['unsigned char']],
    'BaseBlockDirty' : [ 0xbf, ['unsigned char']],
    'LastLogSwapTime' : [ 0xc0, ['_LARGE_INTEGER']],
    'FirstLogFile' : [ 0xc8, ['BitField', dict(start_bit = 0, end_bit = 3, native_type='unsigned short')]],
    'SecondLogFile' : [ 0xc8, ['BitField', dict(start_bit = 3, end_bit = 6, native_type='unsigned short')]],
    'HeaderRecovered' : [ 0xc8, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned short')]],
    'LegacyRecoveryIndicated' : [ 0xc8, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned short')]],
    'RecoveryInformationReserved' : [ 0xc8, ['BitField', dict(start_bit = 8, end_bit = 16, native_type='unsigned short')]],
    'RecoveryInformation' : [ 0xc8, ['unsigned short']],
    'LogEntriesRecovered' : [ 0xca, ['array', 2, ['unsigned char']]],
    'RefreshCount' : [ 0xcc, ['unsigned long']],
    'StorageTypeCount' : [ 0xd0, ['unsigned long']],
    'Version' : [ 0xd4, ['unsigned long']],
    'ViewMap' : [ 0xd8, ['_HVP_VIEW_MAP']],
    'Storage' : [ 0x110, ['array', 2, ['_DUAL']]],
} ],
  '_HV_GET_CELL_CONTEXT' : [ 0x8, {
    'Cell' : [ 0x0, ['unsigned long']],
    'BinContext' : [ 0x4, ['_HV_GET_BIN_CONTEXT']],
} ],
  '_CM_KEY_CONTROL_BLOCK' : [ 0x130, {
    'RefCount' : [ 0x0, ['unsigned long']],
    'ExtFlags' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 16, native_type='unsigned long')]],
    'PrivateAlloc' : [ 0x4, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'Discarded' : [ 0x4, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'HiveUnloaded' : [ 0x4, ['BitField', dict(start_bit = 18, end_bit = 19, native_type='unsigned long')]],
    'Decommissioned' : [ 0x4, ['BitField', dict(start_bit = 19, end_bit = 20, native_type='unsigned long')]],
    'SpareExtFlag' : [ 0x4, ['BitField', dict(start_bit = 20, end_bit = 21, native_type='unsigned long')]],
    'TotalLevels' : [ 0x4, ['BitField', dict(start_bit = 21, end_bit = 31, native_type='unsigned long')]],
    'KeyHash' : [ 0x8, ['_CM_KEY_HASH']],
    'ConvKey' : [ 0x8, ['_CM_PATH_HASH']],
    'NextHash' : [ 0x10, ['pointer64', ['_CM_KEY_HASH']]],
    'KeyHive' : [ 0x18, ['pointer64', ['_HHIVE']]],
    'KeyCell' : [ 0x20, ['unsigned long']],
    'KcbPushlock' : [ 0x28, ['_EX_PUSH_LOCK']],
    'Owner' : [ 0x30, ['pointer64', ['_KTHREAD']]],
    'SharedCount' : [ 0x30, ['long']],
    'DelayedDeref' : [ 0x38, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'DelayedClose' : [ 0x38, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'Parking' : [ 0x38, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'LayerSemantics' : [ 0x39, ['unsigned char']],
    'LayerHeight' : [ 0x3a, ['short']],
    'Spare1' : [ 0x3c, ['unsigned long']],
    'ParentKcb' : [ 0x40, ['pointer64', ['_CM_KEY_CONTROL_BLOCK']]],
    'NameBlock' : [ 0x48, ['pointer64', ['_CM_NAME_CONTROL_BLOCK']]],
    'CachedSecurity' : [ 0x50, ['pointer64', ['_CM_KEY_SECURITY_CACHE']]],
    'ValueCache' : [ 0x58, ['_CACHED_CHILD_LIST']],
    'IndexHint' : [ 0x68, ['pointer64', ['_CM_INDEX_HINT_BLOCK']]],
    'HashKey' : [ 0x68, ['unsigned long']],
    'SubKeyCount' : [ 0x68, ['unsigned long']],
    'KeyBodyListHead' : [ 0x70, ['_LIST_ENTRY']],
    'FreeListEntry' : [ 0x70, ['_LIST_ENTRY']],
    'KeyBodyArray' : [ 0x80, ['array', 4, ['pointer64', ['_CM_KEY_BODY']]]],
    'KcbLastWriteTime' : [ 0xa0, ['_LARGE_INTEGER']],
    'KcbMaxNameLen' : [ 0xa8, ['unsigned short']],
    'KcbMaxValueNameLen' : [ 0xaa, ['unsigned short']],
    'KcbMaxValueDataLen' : [ 0xac, ['unsigned long']],
    'KcbUserFlags' : [ 0xb0, ['BitField', dict(start_bit = 0, end_bit = 4, native_type='unsigned long')]],
    'KcbVirtControlFlags' : [ 0xb0, ['BitField', dict(start_bit = 4, end_bit = 8, native_type='unsigned long')]],
    'KcbDebug' : [ 0xb0, ['BitField', dict(start_bit = 8, end_bit = 16, native_type='unsigned long')]],
    'Flags' : [ 0xb0, ['BitField', dict(start_bit = 16, end_bit = 32, native_type='unsigned long')]],
    'Spare3' : [ 0xb4, ['unsigned long']],
    'LayerInfo' : [ 0xb8, ['pointer64', ['_CM_KCB_LAYER_INFO']]],
    'RealKeyName' : [ 0xc0, ['pointer64', ['unsigned char']]],
    'KCBUoWListHead' : [ 0xc8, ['_LIST_ENTRY']],
    'DelayQueueEntry' : [ 0xd8, ['_LIST_ENTRY']],
    'Stolen' : [ 0xd8, ['pointer64', ['unsigned char']]],
    'TransKCBOwner' : [ 0xe8, ['pointer64', ['_CM_TRANS']]],
    'KCBLock' : [ 0xf0, ['_CM_INTENT_LOCK']],
    'KeyLock' : [ 0x100, ['_CM_INTENT_LOCK']],
    'TransValueCache' : [ 0x110, ['_CHILD_LIST']],
    'TransValueListOwner' : [ 0x118, ['pointer64', ['_CM_TRANS']]],
    'FullKCBName' : [ 0x120, ['pointer64', ['_UNICODE_STRING']]],
    'FullKCBNameStale' : [ 0x120, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'Reserved' : [ 0x120, ['BitField', dict(start_bit = 1, end_bit = 64, native_type='unsigned long long')]],
    'SequenceNumber' : [ 0x128, ['unsigned long long']],
} ],
  'tagSWITCH_CONTEXT' : [ 0x358, {
    'Attribute' : [ 0x0, ['tagSWITCH_CONTEXT_ATTRIBUTE']],
    'Data' : [ 0x18, ['tagSWITCH_CONTEXT_DATA']],
} ],
  '_CM_KEY_BODY' : [ 0x60, {
    'Type' : [ 0x0, ['unsigned long']],
    'KeyControlBlock' : [ 0x8, ['pointer64', ['_CM_KEY_CONTROL_BLOCK']]],
    'NotifyBlock' : [ 0x10, ['pointer64', ['_CM_NOTIFY_BLOCK']]],
    'ProcessID' : [ 0x18, ['pointer64', ['void']]],
    'KeyBodyList' : [ 0x20, ['_LIST_ENTRY']],
    'Flags' : [ 0x30, ['BitField', dict(start_bit = 0, end_bit = 16, native_type='unsigned long')]],
    'HandleTags' : [ 0x30, ['BitField', dict(start_bit = 16, end_bit = 32, native_type='unsigned long')]],
    'Trans' : [ 0x38, ['_CM_TRANS_PTR']],
    'KtmUow' : [ 0x40, ['pointer64', ['_GUID']]],
    'ContextListHead' : [ 0x48, ['_LIST_ENTRY']],
    'EnumerationResumeContext' : [ 0x58, ['pointer64', ['void']]],
} ],
  '_CM_KEY_NODE' : [ 0x50, {
    'Signature' : [ 0x0, ['unsigned short']],
    'Flags' : [ 0x2, ['unsigned short']],
    'LastWriteTime' : [ 0x4, ['_LARGE_INTEGER']],
    'AccessBits' : [ 0xc, ['unsigned char']],
    'LayerSemantics' : [ 0xd, ['BitField', dict(start_bit = 0, end_bit = 2, native_type='unsigned char')]],
    'Spare1' : [ 0xd, ['BitField', dict(start_bit = 2, end_bit = 7, native_type='unsigned char')]],
    'InheritClass' : [ 0xd, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
    'Spare2' : [ 0xe, ['unsigned short']],
    'Parent' : [ 0x10, ['unsigned long']],
    'SubKeyCounts' : [ 0x14, ['array', 2, ['unsigned long']]],
    'SubKeyLists' : [ 0x1c, ['array', 2, ['unsigned long']]],
    'ValueList' : [ 0x24, ['_CHILD_LIST']],
    'ChildHiveReference' : [ 0x1c, ['_CM_KEY_REFERENCE']],
    'Security' : [ 0x2c, ['unsigned long']],
    'Class' : [ 0x30, ['unsigned long']],
    'MaxNameLen' : [ 0x34, ['BitField', dict(start_bit = 0, end_bit = 16, native_type='unsigned long')]],
    'UserFlags' : [ 0x34, ['BitField', dict(start_bit = 16, end_bit = 20, native_type='unsigned long')]],
    'VirtControlFlags' : [ 0x34, ['BitField', dict(start_bit = 20, end_bit = 24, native_type='unsigned long')]],
    'Debug' : [ 0x34, ['BitField', dict(start_bit = 24, end_bit = 32, native_type='unsigned long')]],
    'MaxClassLen' : [ 0x38, ['unsigned long']],
    'MaxValueNameLen' : [ 0x3c, ['unsigned long']],
    'MaxValueDataLen' : [ 0x40, ['unsigned long']],
    'WorkVar' : [ 0x44, ['unsigned long']],
    'NameLength' : [ 0x48, ['unsigned short']],
    'ClassLength' : [ 0x4a, ['unsigned short']],
    'Name' : [ 0x4c, ['array', 1, ['wchar']]],
} ],
  '_CM_NAME_CONTROL_BLOCK' : [ 0x20, {
    'Compressed' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'RefCount' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 32, native_type='unsigned long')]],
    'NameHash' : [ 0x8, ['_CM_NAME_HASH']],
    'ConvKey' : [ 0x8, ['_CM_COMPONENT_HASH']],
    'NextHash' : [ 0x10, ['pointer64', ['_CM_KEY_HASH']]],
    'NameLength' : [ 0x18, ['unsigned short']],
    'Name' : [ 0x1a, ['array', 1, ['wchar']]],
} ],
  '_CM_KEY_VALUE' : [ 0x18, {
    'Signature' : [ 0x0, ['unsigned short']],
    'NameLength' : [ 0x2, ['unsigned short']],
    'DataLength' : [ 0x4, ['unsigned long']],
    'Data' : [ 0x8, ['unsigned long']],
    'Type' : [ 0xc, ['unsigned long']],
    'Flags' : [ 0x10, ['unsigned short']],
    'Spare' : [ 0x12, ['unsigned short']],
    'Name' : [ 0x14, ['array', 1, ['wchar']]],
} ],
  '_SECURITY_SUBJECT_CONTEXT' : [ 0x20, {
    'ClientToken' : [ 0x0, ['pointer64', ['void']]],
    'ImpersonationLevel' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {0: u'SecurityAnonymous', 1: u'SecurityIdentification', 2: u'SecurityImpersonation', 3: u'SecurityDelegation'})]],
    'PrimaryToken' : [ 0x10, ['pointer64', ['void']]],
    'ProcessAuditId' : [ 0x18, ['pointer64', ['void']]],
} ],
  '_CMHIVE' : [ 0x12f8, {
    'Hive' : [ 0x0, ['_HHIVE']],
    'FileHandles' : [ 0x600, ['array', 6, ['pointer64', ['void']]]],
    'NotifyList' : [ 0x630, ['_LIST_ENTRY']],
    'HiveList' : [ 0x640, ['_LIST_ENTRY']],
    'PreloadedHiveList' : [ 0x650, ['_LIST_ENTRY']],
    'HiveRundown' : [ 0x660, ['_EX_RUNDOWN_REF']],
    'KcbCacheTable' : [ 0x668, ['pointer64', ['_CM_KEY_HASH_TABLE_ENTRY']]],
    'KcbCacheTableSize' : [ 0x670, ['unsigned long']],
    'DeletedKcbTable' : [ 0x678, ['pointer64', ['_CM_KEY_HASH_TABLE_ENTRY']]],
    'DeletedKcbTableSize' : [ 0x680, ['unsigned long']],
    'Identity' : [ 0x684, ['unsigned long']],
    'HiveLock' : [ 0x688, ['_CMSI_RW_LOCK']],
    'FlushDirtyVector' : [ 0x690, ['_RTL_BITMAP']],
    'FlushDirtyVectorSize' : [ 0x6a0, ['unsigned long']],
    'FlushLogEntry' : [ 0x6a8, ['pointer64', ['unsigned char']]],
    'FlushLogEntrySize' : [ 0x6b0, ['unsigned long']],
    'FlushHiveTruncated' : [ 0x6b4, ['unsigned long']],
    'FlushBaseBlockDirty' : [ 0x6b8, ['unsigned char']],
    'CapturedUnreconciledVector' : [ 0x6c0, ['_RTL_BITMAP']],
    'CapturedUnreconciledVectorSize' : [ 0x6d0, ['unsigned long']],
    'UnreconciledOffsetArray' : [ 0x6d8, ['pointer64', ['CMP_OFFSET_ARRAY']]],
    'UnreconciledOffsetArrayCount' : [ 0x6e0, ['unsigned long']],
    'UnreconciledBaseBlock' : [ 0x6e8, ['pointer64', ['_HBASE_BLOCK']]],
    'SecurityLock' : [ 0x6f0, ['_EX_PUSH_LOCK']],
    'LastShrinkHiveSize' : [ 0x6f8, ['unsigned long']],
    'ActualFileSize' : [ 0x700, ['_LARGE_INTEGER']],
    'LogFileSizes' : [ 0x708, ['array', 2, ['_LARGE_INTEGER']]],
    'FileFullPath' : [ 0x718, ['_UNICODE_STRING']],
    'FileUserName' : [ 0x728, ['_UNICODE_STRING']],
    'HiveRootPath' : [ 0x738, ['_UNICODE_STRING']],
    'SecurityCount' : [ 0x748, ['unsigned long']],
    'SecurityCacheSize' : [ 0x74c, ['unsigned long']],
    'SecurityHitHint' : [ 0x750, ['long']],
    'SecurityCache' : [ 0x758, ['pointer64', ['_CM_KEY_SECURITY_CACHE_ENTRY']]],
    'SecurityHash' : [ 0x760, ['array', 64, ['_LIST_ENTRY']]],
    'UnloadEventCount' : [ 0xb60, ['unsigned long']],
    'UnloadEventArray' : [ 0xb68, ['pointer64', ['pointer64', ['_KEVENT']]]],
    'RootKcb' : [ 0xb70, ['pointer64', ['_CM_KEY_CONTROL_BLOCK']]],
    'Frozen' : [ 0xb78, ['unsigned char']],
    'UnloadWorkItem' : [ 0xb80, ['pointer64', ['_CM_WORKITEM']]],
    'UnloadWorkItemHolder' : [ 0xb88, ['_CM_WORKITEM']],
    'DirtyVectorLog' : [ 0xbb0, ['_CM_DIRTY_VECTOR_LOG']],
    'Flags' : [ 0x1038, ['unsigned long']],
    'TrustClassEntry' : [ 0x1040, ['_LIST_ENTRY']],
    'DirtyTime' : [ 0x1050, ['unsigned long long']],
    'UnreconciledTime' : [ 0x1058, ['unsigned long long']],
    'CmRm' : [ 0x1060, ['pointer64', ['_CM_RM']]],
    'CmRmInitFailPoint' : [ 0x1068, ['unsigned long']],
    'CmRmInitFailStatus' : [ 0x106c, ['long']],
    'CreatorOwner' : [ 0x1070, ['pointer64', ['_KTHREAD']]],
    'RundownThread' : [ 0x1078, ['pointer64', ['_KTHREAD']]],
    'LastWriteTime' : [ 0x1080, ['_LARGE_INTEGER']],
    'FlushQueue' : [ 0x1088, ['_HIVE_WRITE_WAIT_QUEUE']],
    'ReconcileQueue' : [ 0x10a0, ['_HIVE_WRITE_WAIT_QUEUE']],
    'FlushFlags' : [ 0x10b8, ['unsigned long']],
    'FlushActive' : [ 0x10b8, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'ReconcileActive' : [ 0x10b8, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'PrimaryFilePurged' : [ 0x10b8, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'DiskFileBad' : [ 0x10b8, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'PrimaryFileSizeBeforeLastFlush' : [ 0x10bc, ['unsigned long']],
    'ReferenceCount' : [ 0x10c0, ['long']],
    'UnloadHistoryIndex' : [ 0x10c4, ['long']],
    'UnloadHistory' : [ 0x10c8, ['array', 128, ['unsigned long']]],
    'BootStart' : [ 0x12c8, ['unsigned long']],
    'UnaccessedStart' : [ 0x12cc, ['unsigned long']],
    'UnaccessedEnd' : [ 0x12d0, ['unsigned long']],
    'LoadedKeyCount' : [ 0x12d4, ['unsigned long']],
    'HandleClosePending' : [ 0x12d8, ['unsigned long']],
    'HandleClosePendingEvent' : [ 0x12e0, ['_EX_PUSH_LOCK']],
    'FinalFlushSucceeded' : [ 0x12e8, ['unsigned char']],
    'VolumeContext' : [ 0x12f0, ['pointer64', ['_CMP_VOLUME_CONTEXT']]],
} ],
  '__unnamed_1851' : [ 0xc, {
    'Failure' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: u'_None', 1: u'_CmCreateHive', 3: u'_HvpBuildMap', 4: u'_HvpBuildMapForLoaderHive', 5: u'_HvpInitMap', 6: u'_HvLoadHive', 7: u'_HvpMapHiveImage', 8: u'_HvpRecoverData', 9: u'_CmpValidateHiveSecurityDescriptors', 10: u'_HvpEnlistBinInMap', 11: u'_CmCheckRegistry', 12: u'_CmRegistryIO', 13: u'_CmCheckRegistry2', 14: u'_CmpCheckKey', 15: u'_CmpCheckValueList', 16: u'_HvCheckHive', 17: u'_HvCheckBin', 18: u'_HvpGetLogEntryDirtyVector', 19: u'_HvpReadLogEntryHeader', 20: u'_HvpReadLogEntry', 21: u'_CmpMountPreloadedHives', 22: u'_CmpLoadHiveThread', 23: u'_CmpCheckLeaf', 24: u'_HvHiveStartFileBacked', 25: u'_HvStartHiveMemoryBacked', 26: u'_HvpEnlistFreeCells', 27: u'_HvpPerformLogFileRecovery'})]],
    'Status' : [ 0x4, ['long']],
    'Point' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_1854' : [ 0x18, {
    'Action' : [ 0x0, ['unsigned long']],
    'Handle' : [ 0x8, ['pointer64', ['void']]],
    'Status' : [ 0x10, ['long']],
} ],
  '__unnamed_1856' : [ 0x8, {
    'CheckStack' : [ 0x0, ['pointer64', ['void']]],
} ],
  '__unnamed_1858' : [ 0x20, {
    'Cell' : [ 0x0, ['unsigned long']],
    'CellPoint' : [ 0x8, ['pointer64', ['_CELL_DATA']]],
    'RootPoint' : [ 0x10, ['pointer64', ['void']]],
    'Index' : [ 0x18, ['unsigned long']],
} ],
  '__unnamed_185a' : [ 0x18, {
    'List' : [ 0x0, ['pointer64', ['_CELL_DATA']]],
    'Index' : [ 0x8, ['unsigned long']],
    'Cell' : [ 0xc, ['unsigned long']],
    'CellPoint' : [ 0x10, ['pointer64', ['_CELL_DATA']]],
} ],
  '__unnamed_185e' : [ 0x10, {
    'Space' : [ 0x0, ['unsigned long']],
    'MapPoint' : [ 0x4, ['unsigned long']],
    'BinPoint' : [ 0x8, ['pointer64', ['_HBIN']]],
} ],
  '__unnamed_1862' : [ 0x10, {
    'Bin' : [ 0x0, ['pointer64', ['_HBIN']]],
    'CellPoint' : [ 0x8, ['pointer64', ['_HCELL']]],
} ],
  '__unnamed_1864' : [ 0x4, {
    'FileOffset' : [ 0x0, ['unsigned long']],
} ],
  '_HIVE_LOAD_FAILURE' : [ 0x160, {
    'Hive' : [ 0x0, ['pointer64', ['_HHIVE']]],
    'Index' : [ 0x8, ['unsigned short']],
    'RecoverableIndex' : [ 0xa, ['unsigned short']],
    'Locations' : [ 0xc, ['array', 8, ['__unnamed_1851']]],
    'RecoverableLocations' : [ 0x6c, ['array', 8, ['__unnamed_1851']]],
    'RegistryIO' : [ 0xd0, ['__unnamed_1854']],
    'CheckRegistry2' : [ 0xe8, ['__unnamed_1856']],
    'CheckKey' : [ 0xf0, ['__unnamed_1858']],
    'CheckValueList' : [ 0x110, ['__unnamed_185a']],
    'CheckHive' : [ 0x128, ['__unnamed_185e']],
    'CheckHive1' : [ 0x138, ['__unnamed_185e']],
    'CheckBin' : [ 0x148, ['__unnamed_1862']],
    'RecoverData' : [ 0x158, ['__unnamed_1864']],
} ],
  '_CM_KCB_UOW' : [ 0x78, {
    'TransactionListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'KCBLock' : [ 0x10, ['pointer64', ['_CM_INTENT_LOCK']]],
    'KeyLock' : [ 0x18, ['pointer64', ['_CM_INTENT_LOCK']]],
    'KCBListEntry' : [ 0x20, ['_LIST_ENTRY']],
    'KeyControlBlock' : [ 0x30, ['pointer64', ['_CM_KEY_CONTROL_BLOCK']]],
    'Transaction' : [ 0x38, ['pointer64', ['_CM_TRANS']]],
    'UoWState' : [ 0x40, ['unsigned long']],
    'ActionType' : [ 0x44, ['Enumeration', dict(target = 'long', choices = {0: u'UoWAddThisKey', 1: u'UoWAddChildKey', 2: u'UoWDeleteThisKey', 3: u'UoWDeleteChildKey', 4: u'UoWSetValueNew', 5: u'UoWSetValueExisting', 6: u'UoWDeleteValue', 7: u'UoWSetKeyUserFlags', 8: u'UoWSetLastWriteTime', 9: u'UoWSetSecurityDescriptor', 10: u'UoWRenameSubKey', 11: u'UoWRenameOldSubKey', 12: u'UoWRenameNewSubKey', 13: u'UoWIsolation', 14: u'UoWInvalid'})]],
    'StorageType' : [ 0x48, ['Enumeration', dict(target = 'long', choices = {0: u'Stable', 1: u'Volatile', 2: u'InvalidStorage'})]],
    'ParentUoW' : [ 0x50, ['pointer64', ['_CM_KCB_UOW']]],
    'ChildKCB' : [ 0x58, ['pointer64', ['_CM_KEY_CONTROL_BLOCK']]],
    'VolatileKeyCell' : [ 0x58, ['unsigned long']],
    'OldValueCell' : [ 0x58, ['unsigned long']],
    'NewValueCell' : [ 0x5c, ['unsigned long']],
    'UserFlags' : [ 0x58, ['unsigned long']],
    'LastWriteTime' : [ 0x58, ['_LARGE_INTEGER']],
    'TxCachedSecurity' : [ 0x58, ['pointer64', ['_CM_KEY_SECURITY_CACHE']]],
    'TxSecurityCell' : [ 0x60, ['unsigned long']],
    'OldChildKCB' : [ 0x58, ['pointer64', ['_CM_KEY_CONTROL_BLOCK']]],
    'NewChildKCB' : [ 0x60, ['pointer64', ['_CM_KEY_CONTROL_BLOCK']]],
    'OtherChildKCB' : [ 0x58, ['pointer64', ['_CM_KEY_CONTROL_BLOCK']]],
    'ThisVolatileKeyCell' : [ 0x60, ['unsigned long']],
    'PrepareDataPointer' : [ 0x68, ['pointer64', ['void']]],
    'SecurityData' : [ 0x68, ['pointer64', ['_CM_UOW_SET_SD_DATA']]],
    'ModifyKeysData' : [ 0x68, ['pointer64', ['_CM_UOW_KEY_STATE_MODIFICATION']]],
    'SetValueData' : [ 0x68, ['pointer64', ['_CM_UOW_SET_VALUE_LIST_DATA']]],
    'ValueData' : [ 0x70, ['pointer64', ['_CM_UOW_SET_VALUE_KEY_DATA']]],
    'DiscardReplaceContext' : [ 0x70, ['pointer64', ['_CMP_DISCARD_AND_REPLACE_KCB_CONTEXT']]],
} ],
  '_CM_TRANS' : [ 0xb8, {
    'TransactionListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'KCBUoWListHead' : [ 0x10, ['_LIST_ENTRY']],
    'LazyCommitListEntry' : [ 0x20, ['_LIST_ENTRY']],
    'Prepared' : [ 0x30, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Aborted' : [ 0x30, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'Committed' : [ 0x30, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'Initializing' : [ 0x30, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'Invalid' : [ 0x30, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'UseReservation' : [ 0x30, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'TmCallbacksActive' : [ 0x30, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'LightWeight' : [ 0x30, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'Freed1' : [ 0x30, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'Freed2' : [ 0x30, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'Spare1' : [ 0x30, ['BitField', dict(start_bit = 10, end_bit = 12, native_type='unsigned long')]],
    'Freed' : [ 0x30, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long')]],
    'Spare' : [ 0x30, ['BitField', dict(start_bit = 13, end_bit = 32, native_type='unsigned long')]],
    'TransState' : [ 0x30, ['unsigned long']],
    'Trans' : [ 0x38, ['_CM_TRANS_PTR']],
    'CmRm' : [ 0x40, ['pointer64', ['_CM_RM']]],
    'KtmEnlistmentObject' : [ 0x48, ['pointer64', ['_KENLISTMENT']]],
    'KtmEnlistmentHandle' : [ 0x50, ['pointer64', ['void']]],
    'KtmUow' : [ 0x58, ['_GUID']],
    'StartLsn' : [ 0x68, ['unsigned long long']],
    'HiveCount' : [ 0x70, ['unsigned long']],
    'HiveArray' : [ 0x78, ['array', 8, ['pointer64', ['_CMHIVE']]]],
} ],
  '_PCW_COUNTER_DESCRIPTOR' : [ 0x8, {
    'Id' : [ 0x0, ['unsigned short']],
    'StructIndex' : [ 0x2, ['unsigned short']],
    'Offset' : [ 0x4, ['unsigned short']],
    'Size' : [ 0x6, ['unsigned short']],
} ],
  '_PCW_REGISTRATION_INFORMATION' : [ 0x30, {
    'Version' : [ 0x0, ['unsigned long']],
    'Name' : [ 0x8, ['pointer64', ['_UNICODE_STRING']]],
    'CounterCount' : [ 0x10, ['unsigned long']],
    'Counters' : [ 0x18, ['pointer64', ['_PCW_COUNTER_DESCRIPTOR']]],
    'Callback' : [ 0x20, ['pointer64', ['void']]],
    'CallbackContext' : [ 0x28, ['pointer64', ['void']]],
} ],
  '_PCW_PROCESSOR_INFO' : [ 0xc0, {
    'IdleTime' : [ 0x0, ['unsigned long long']],
    'AvailableTime' : [ 0x8, ['unsigned long long']],
    'UserTime' : [ 0x10, ['unsigned long long']],
    'KernelTime' : [ 0x18, ['unsigned long long']],
    'Interrupts' : [ 0x20, ['unsigned long']],
    'DpcTime' : [ 0x28, ['unsigned long long']],
    'InterruptTime' : [ 0x30, ['unsigned long long']],
    'ClockInterrupts' : [ 0x38, ['unsigned long']],
    'DpcCount' : [ 0x3c, ['unsigned long']],
    'DpcRate' : [ 0x40, ['unsigned long']],
    'C1Time' : [ 0x48, ['unsigned long long']],
    'C2Time' : [ 0x50, ['unsigned long long']],
    'C3Time' : [ 0x58, ['unsigned long long']],
    'C1Transitions' : [ 0x60, ['unsigned long long']],
    'C2Transitions' : [ 0x68, ['unsigned long long']],
    'C3Transitions' : [ 0x70, ['unsigned long long']],
    'StallTime' : [ 0x78, ['unsigned long long']],
    'ParkingStatus' : [ 0x80, ['unsigned long']],
    'CurrentFrequency' : [ 0x84, ['unsigned long']],
    'PercentMaxFrequency' : [ 0x88, ['unsigned long']],
    'StateFlags' : [ 0x8c, ['unsigned long']],
    'NominalThroughput' : [ 0x90, ['unsigned long']],
    'ActiveThroughput' : [ 0x94, ['unsigned long']],
    'ScaledThroughput' : [ 0x98, ['unsigned long long']],
    'ScaledKernelThroughput' : [ 0xa0, ['unsigned long long']],
    'AverageIdleTime' : [ 0xa8, ['unsigned long long']],
    'IdleBreakEvents' : [ 0xb0, ['unsigned long long']],
    'PerformanceLimit' : [ 0xb8, ['unsigned long']],
    'PerformanceLimitFlags' : [ 0xbc, ['unsigned long']],
} ],
  '_PCW_DATA' : [ 0x10, {
    'Data' : [ 0x0, ['pointer64', ['void']]],
    'Size' : [ 0x8, ['unsigned long']],
} ],
  '_SYNCH_COUNTERS' : [ 0xb8, {
    'SpinLockAcquireCount' : [ 0x0, ['unsigned long']],
    'SpinLockContentionCount' : [ 0x4, ['unsigned long']],
    'SpinLockSpinCount' : [ 0x8, ['unsigned long']],
    'IpiSendRequestBroadcastCount' : [ 0xc, ['unsigned long']],
    'IpiSendRequestRoutineCount' : [ 0x10, ['unsigned long']],
    'IpiSendSoftwareInterruptCount' : [ 0x14, ['unsigned long']],
    'ExInitializeResourceCount' : [ 0x18, ['unsigned long']],
    'ExReInitializeResourceCount' : [ 0x1c, ['unsigned long']],
    'ExDeleteResourceCount' : [ 0x20, ['unsigned long']],
    'ExecutiveResourceAcquiresCount' : [ 0x24, ['unsigned long']],
    'ExecutiveResourceContentionsCount' : [ 0x28, ['unsigned long']],
    'ExecutiveResourceReleaseExclusiveCount' : [ 0x2c, ['unsigned long']],
    'ExecutiveResourceReleaseSharedCount' : [ 0x30, ['unsigned long']],
    'ExecutiveResourceConvertsCount' : [ 0x34, ['unsigned long']],
    'ExAcqResExclusiveAttempts' : [ 0x38, ['unsigned long']],
    'ExAcqResExclusiveAcquiresExclusive' : [ 0x3c, ['unsigned long']],
    'ExAcqResExclusiveAcquiresExclusiveRecursive' : [ 0x40, ['unsigned long']],
    'ExAcqResExclusiveWaits' : [ 0x44, ['unsigned long']],
    'ExAcqResExclusiveNotAcquires' : [ 0x48, ['unsigned long']],
    'ExAcqResSharedAttempts' : [ 0x4c, ['unsigned long']],
    'ExAcqResSharedAcquiresExclusive' : [ 0x50, ['unsigned long']],
    'ExAcqResSharedAcquiresShared' : [ 0x54, ['unsigned long']],
    'ExAcqResSharedAcquiresSharedRecursive' : [ 0x58, ['unsigned long']],
    'ExAcqResSharedWaits' : [ 0x5c, ['unsigned long']],
    'ExAcqResSharedNotAcquires' : [ 0x60, ['unsigned long']],
    'ExAcqResSharedStarveExclusiveAttempts' : [ 0x64, ['unsigned long']],
    'ExAcqResSharedStarveExclusiveAcquiresExclusive' : [ 0x68, ['unsigned long']],
    'ExAcqResSharedStarveExclusiveAcquiresShared' : [ 0x6c, ['unsigned long']],
    'ExAcqResSharedStarveExclusiveAcquiresSharedRecursive' : [ 0x70, ['unsigned long']],
    'ExAcqResSharedStarveExclusiveWaits' : [ 0x74, ['unsigned long']],
    'ExAcqResSharedStarveExclusiveNotAcquires' : [ 0x78, ['unsigned long']],
    'ExAcqResSharedWaitForExclusiveAttempts' : [ 0x7c, ['unsigned long']],
    'ExAcqResSharedWaitForExclusiveAcquiresExclusive' : [ 0x80, ['unsigned long']],
    'ExAcqResSharedWaitForExclusiveAcquiresShared' : [ 0x84, ['unsigned long']],
    'ExAcqResSharedWaitForExclusiveAcquiresSharedRecursive' : [ 0x88, ['unsigned long']],
    'ExAcqResSharedWaitForExclusiveWaits' : [ 0x8c, ['unsigned long']],
    'ExAcqResSharedWaitForExclusiveNotAcquires' : [ 0x90, ['unsigned long']],
    'ExSetResOwnerPointerExclusive' : [ 0x94, ['unsigned long']],
    'ExSetResOwnerPointerSharedNew' : [ 0x98, ['unsigned long']],
    'ExSetResOwnerPointerSharedOld' : [ 0x9c, ['unsigned long']],
    'ExTryToAcqExclusiveAttempts' : [ 0xa0, ['unsigned long']],
    'ExTryToAcqExclusiveAcquires' : [ 0xa4, ['unsigned long']],
    'ExBoostExclusiveOwner' : [ 0xa8, ['unsigned long']],
    'ExBoostSharedOwners' : [ 0xac, ['unsigned long']],
    'ExEtwSynchTrackingNotificationsCount' : [ 0xb0, ['unsigned long']],
    'ExEtwSynchTrackingNotificationsAccountedCount' : [ 0xb4, ['unsigned long']],
} ],
  '_ETW_PERF_COUNTERS' : [ 0x18, {
    'TotalActiveSessions' : [ 0x0, ['long']],
    'TotalBufferMemoryNonPagedPool' : [ 0x4, ['long']],
    'TotalBufferMemoryPagedPool' : [ 0x8, ['long']],
    'TotalGuidsEnabled' : [ 0xc, ['long']],
    'TotalGuidsNotEnabled' : [ 0x10, ['long']],
    'TotalGuidsPreEnabled' : [ 0x14, ['long']],
} ],
  '_ETW_SESSION_PERF_COUNTERS' : [ 0x18, {
    'BufferMemoryPagedPool' : [ 0x0, ['long']],
    'BufferMemoryNonPagedPool' : [ 0x4, ['long']],
    'EventsLoggedCount' : [ 0x8, ['unsigned long long']],
    'EventsLost' : [ 0x10, ['long']],
    'NumConsumers' : [ 0x14, ['long']],
} ],
  '_FILESYSTEM_DISK_COUNTERS' : [ 0x10, {
    'FsBytesRead' : [ 0x0, ['unsigned long long']],
    'FsBytesWritten' : [ 0x8, ['unsigned long long']],
} ],
  '_THERMAL_ZONE_COUNTERS' : [ 0x10, {
    'Temperature' : [ 0x0, ['unsigned long']],
    'ThrottleLimit' : [ 0x4, ['unsigned long']],
    'ThrottleReasons' : [ 0x8, ['unsigned long']],
    'TemperatureHighPrecision' : [ 0xc, ['unsigned long']],
} ],
  '_TEB32' : [ 0x1000, {
    'NtTib' : [ 0x0, ['_NT_TIB32']],
    'EnvironmentPointer' : [ 0x1c, ['unsigned long']],
    'ClientId' : [ 0x20, ['_CLIENT_ID32']],
    'ActiveRpcHandle' : [ 0x28, ['unsigned long']],
    'ThreadLocalStoragePointer' : [ 0x2c, ['unsigned long']],
    'ProcessEnvironmentBlock' : [ 0x30, ['unsigned long']],
    'LastErrorValue' : [ 0x34, ['unsigned long']],
    'CountOfOwnedCriticalSections' : [ 0x38, ['unsigned long']],
    'CsrClientThread' : [ 0x3c, ['unsigned long']],
    'Win32ThreadInfo' : [ 0x40, ['unsigned long']],
    'User32Reserved' : [ 0x44, ['array', 26, ['unsigned long']]],
    'UserReserved' : [ 0xac, ['array', 5, ['unsigned long']]],
    'WOW32Reserved' : [ 0xc0, ['unsigned long']],
    'CurrentLocale' : [ 0xc4, ['unsigned long']],
    'FpSoftwareStatusRegister' : [ 0xc8, ['unsigned long']],
    'ReservedForDebuggerInstrumentation' : [ 0xcc, ['array', 16, ['unsigned long']]],
    'SystemReserved1' : [ 0x10c, ['array', 26, ['unsigned long']]],
    'PlaceholderCompatibilityMode' : [ 0x174, ['unsigned char']],
    'PlaceholderReserved' : [ 0x175, ['array', 11, ['unsigned char']]],
    'ProxiedProcessId' : [ 0x180, ['unsigned long']],
    '_ActivationStack' : [ 0x184, ['_ACTIVATION_CONTEXT_STACK32']],
    'WorkingOnBehalfTicket' : [ 0x19c, ['array', 8, ['unsigned char']]],
    'ExceptionCode' : [ 0x1a4, ['long']],
    'ActivationContextStackPointer' : [ 0x1a8, ['unsigned long']],
    'InstrumentationCallbackSp' : [ 0x1ac, ['unsigned long']],
    'InstrumentationCallbackPreviousPc' : [ 0x1b0, ['unsigned long']],
    'InstrumentationCallbackPreviousSp' : [ 0x1b4, ['unsigned long']],
    'InstrumentationCallbackDisabled' : [ 0x1b8, ['unsigned char']],
    'SpareBytes' : [ 0x1b9, ['array', 23, ['unsigned char']]],
    'TxFsContext' : [ 0x1d0, ['unsigned long']],
    'GdiTebBatch' : [ 0x1d4, ['_GDI_TEB_BATCH32']],
    'RealClientId' : [ 0x6b4, ['_CLIENT_ID32']],
    'GdiCachedProcessHandle' : [ 0x6bc, ['unsigned long']],
    'GdiClientPID' : [ 0x6c0, ['unsigned long']],
    'GdiClientTID' : [ 0x6c4, ['unsigned long']],
    'GdiThreadLocalInfo' : [ 0x6c8, ['unsigned long']],
    'Win32ClientInfo' : [ 0x6cc, ['array', 62, ['unsigned long']]],
    'glDispatchTable' : [ 0x7c4, ['array', 233, ['unsigned long']]],
    'glReserved1' : [ 0xb68, ['array', 29, ['unsigned long']]],
    'glReserved2' : [ 0xbdc, ['unsigned long']],
    'glSectionInfo' : [ 0xbe0, ['unsigned long']],
    'glSection' : [ 0xbe4, ['unsigned long']],
    'glTable' : [ 0xbe8, ['unsigned long']],
    'glCurrentRC' : [ 0xbec, ['unsigned long']],
    'glContext' : [ 0xbf0, ['unsigned long']],
    'LastStatusValue' : [ 0xbf4, ['unsigned long']],
    'StaticUnicodeString' : [ 0xbf8, ['_STRING32']],
    'StaticUnicodeBuffer' : [ 0xc00, ['array', 261, ['wchar']]],
    'DeallocationStack' : [ 0xe0c, ['unsigned long']],
    'TlsSlots' : [ 0xe10, ['array', 64, ['unsigned long']]],
    'TlsLinks' : [ 0xf10, ['LIST_ENTRY32']],
    'Vdm' : [ 0xf18, ['unsigned long']],
    'ReservedForNtRpc' : [ 0xf1c, ['unsigned long']],
    'DbgSsReserved' : [ 0xf20, ['array', 2, ['unsigned long']]],
    'HardErrorMode' : [ 0xf28, ['unsigned long']],
    'Instrumentation' : [ 0xf2c, ['array', 9, ['unsigned long']]],
    'ActivityId' : [ 0xf50, ['_GUID']],
    'SubProcessTag' : [ 0xf60, ['unsigned long']],
    'PerflibData' : [ 0xf64, ['unsigned long']],
    'EtwTraceData' : [ 0xf68, ['unsigned long']],
    'WinSockData' : [ 0xf6c, ['unsigned long']],
    'GdiBatchCount' : [ 0xf70, ['unsigned long']],
    'CurrentIdealProcessor' : [ 0xf74, ['_PROCESSOR_NUMBER']],
    'IdealProcessorValue' : [ 0xf74, ['unsigned long']],
    'ReservedPad0' : [ 0xf74, ['unsigned char']],
    'ReservedPad1' : [ 0xf75, ['unsigned char']],
    'ReservedPad2' : [ 0xf76, ['unsigned char']],
    'IdealProcessor' : [ 0xf77, ['unsigned char']],
    'GuaranteedStackBytes' : [ 0xf78, ['unsigned long']],
    'ReservedForPerf' : [ 0xf7c, ['unsigned long']],
    'ReservedForOle' : [ 0xf80, ['unsigned long']],
    'WaitingOnLoaderLock' : [ 0xf84, ['unsigned long']],
    'SavedPriorityState' : [ 0xf88, ['unsigned long']],
    'ReservedForCodeCoverage' : [ 0xf8c, ['unsigned long']],
    'ThreadPoolData' : [ 0xf90, ['unsigned long']],
    'TlsExpansionSlots' : [ 0xf94, ['unsigned long']],
    'MuiGeneration' : [ 0xf98, ['unsigned long']],
    'IsImpersonating' : [ 0xf9c, ['unsigned long']],
    'NlsCache' : [ 0xfa0, ['unsigned long']],
    'pShimData' : [ 0xfa4, ['unsigned long']],
    'HeapVirtualAffinity' : [ 0xfa8, ['unsigned short']],
    'LowFragHeapDataSlot' : [ 0xfaa, ['unsigned short']],
    'CurrentTransactionHandle' : [ 0xfac, ['unsigned long']],
    'ActiveFrame' : [ 0xfb0, ['unsigned long']],
    'FlsData' : [ 0xfb4, ['unsigned long']],
    'PreferredLanguages' : [ 0xfb8, ['unsigned long']],
    'UserPrefLanguages' : [ 0xfbc, ['unsigned long']],
    'MergedPrefLanguages' : [ 0xfc0, ['unsigned long']],
    'MuiImpersonation' : [ 0xfc4, ['unsigned long']],
    'CrossTebFlags' : [ 0xfc8, ['unsigned short']],
    'SpareCrossTebBits' : [ 0xfc8, ['BitField', dict(start_bit = 0, end_bit = 16, native_type='unsigned short')]],
    'SameTebFlags' : [ 0xfca, ['unsigned short']],
    'SafeThunkCall' : [ 0xfca, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
    'InDebugPrint' : [ 0xfca, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned short')]],
    'HasFiberData' : [ 0xfca, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned short')]],
    'SkipThreadAttach' : [ 0xfca, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned short')]],
    'WerInShipAssertCode' : [ 0xfca, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned short')]],
    'RanProcessInit' : [ 0xfca, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned short')]],
    'ClonedThread' : [ 0xfca, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned short')]],
    'SuppressDebugMsg' : [ 0xfca, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned short')]],
    'DisableUserStackWalk' : [ 0xfca, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned short')]],
    'RtlExceptionAttached' : [ 0xfca, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned short')]],
    'InitialThread' : [ 0xfca, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned short')]],
    'SessionAware' : [ 0xfca, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned short')]],
    'LoadOwner' : [ 0xfca, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned short')]],
    'LoaderWorker' : [ 0xfca, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned short')]],
    'SkipLoaderInit' : [ 0xfca, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned short')]],
    'SpareSameTebBits' : [ 0xfca, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned short')]],
    'TxnScopeEnterCallback' : [ 0xfcc, ['unsigned long']],
    'TxnScopeExitCallback' : [ 0xfd0, ['unsigned long']],
    'TxnScopeContext' : [ 0xfd4, ['unsigned long']],
    'LockCount' : [ 0xfd8, ['unsigned long']],
    'WowTebOffset' : [ 0xfdc, ['long']],
    'ResourceRetValue' : [ 0xfe0, ['unsigned long']],
    'ReservedForWdf' : [ 0xfe4, ['unsigned long']],
    'ReservedForCrt' : [ 0xfe8, ['unsigned long long']],
    'EffectiveContainerId' : [ 0xff0, ['_GUID']],
} ],
  '_TEB64' : [ 0x1838, {
    'NtTib' : [ 0x0, ['_NT_TIB64']],
    'EnvironmentPointer' : [ 0x38, ['unsigned long long']],
    'ClientId' : [ 0x40, ['_CLIENT_ID64']],
    'ActiveRpcHandle' : [ 0x50, ['unsigned long long']],
    'ThreadLocalStoragePointer' : [ 0x58, ['unsigned long long']],
    'ProcessEnvironmentBlock' : [ 0x60, ['unsigned long long']],
    'LastErrorValue' : [ 0x68, ['unsigned long']],
    'CountOfOwnedCriticalSections' : [ 0x6c, ['unsigned long']],
    'CsrClientThread' : [ 0x70, ['unsigned long long']],
    'Win32ThreadInfo' : [ 0x78, ['unsigned long long']],
    'User32Reserved' : [ 0x80, ['array', 26, ['unsigned long']]],
    'UserReserved' : [ 0xe8, ['array', 5, ['unsigned long']]],
    'WOW32Reserved' : [ 0x100, ['unsigned long long']],
    'CurrentLocale' : [ 0x108, ['unsigned long']],
    'FpSoftwareStatusRegister' : [ 0x10c, ['unsigned long']],
    'ReservedForDebuggerInstrumentation' : [ 0x110, ['array', 16, ['unsigned long long']]],
    'SystemReserved1' : [ 0x190, ['array', 30, ['unsigned long long']]],
    'PlaceholderCompatibilityMode' : [ 0x280, ['unsigned char']],
    'PlaceholderReserved' : [ 0x281, ['array', 11, ['unsigned char']]],
    'ProxiedProcessId' : [ 0x28c, ['unsigned long']],
    '_ActivationStack' : [ 0x290, ['_ACTIVATION_CONTEXT_STACK64']],
    'WorkingOnBehalfTicket' : [ 0x2b8, ['array', 8, ['unsigned char']]],
    'ExceptionCode' : [ 0x2c0, ['long']],
    'Padding0' : [ 0x2c4, ['array', 4, ['unsigned char']]],
    'ActivationContextStackPointer' : [ 0x2c8, ['unsigned long long']],
    'InstrumentationCallbackSp' : [ 0x2d0, ['unsigned long long']],
    'InstrumentationCallbackPreviousPc' : [ 0x2d8, ['unsigned long long']],
    'InstrumentationCallbackPreviousSp' : [ 0x2e0, ['unsigned long long']],
    'TxFsContext' : [ 0x2e8, ['unsigned long']],
    'InstrumentationCallbackDisabled' : [ 0x2ec, ['unsigned char']],
    'Padding1' : [ 0x2ed, ['array', 3, ['unsigned char']]],
    'GdiTebBatch' : [ 0x2f0, ['_GDI_TEB_BATCH64']],
    'RealClientId' : [ 0x7d8, ['_CLIENT_ID64']],
    'GdiCachedProcessHandle' : [ 0x7e8, ['unsigned long long']],
    'GdiClientPID' : [ 0x7f0, ['unsigned long']],
    'GdiClientTID' : [ 0x7f4, ['unsigned long']],
    'GdiThreadLocalInfo' : [ 0x7f8, ['unsigned long long']],
    'Win32ClientInfo' : [ 0x800, ['array', 62, ['unsigned long long']]],
    'glDispatchTable' : [ 0x9f0, ['array', 233, ['unsigned long long']]],
    'glReserved1' : [ 0x1138, ['array', 29, ['unsigned long long']]],
    'glReserved2' : [ 0x1220, ['unsigned long long']],
    'glSectionInfo' : [ 0x1228, ['unsigned long long']],
    'glSection' : [ 0x1230, ['unsigned long long']],
    'glTable' : [ 0x1238, ['unsigned long long']],
    'glCurrentRC' : [ 0x1240, ['unsigned long long']],
    'glContext' : [ 0x1248, ['unsigned long long']],
    'LastStatusValue' : [ 0x1250, ['unsigned long']],
    'Padding2' : [ 0x1254, ['array', 4, ['unsigned char']]],
    'StaticUnicodeString' : [ 0x1258, ['_STRING64']],
    'StaticUnicodeBuffer' : [ 0x1268, ['array', 261, ['wchar']]],
    'Padding3' : [ 0x1472, ['array', 6, ['unsigned char']]],
    'DeallocationStack' : [ 0x1478, ['unsigned long long']],
    'TlsSlots' : [ 0x1480, ['array', 64, ['unsigned long long']]],
    'TlsLinks' : [ 0x1680, ['LIST_ENTRY64']],
    'Vdm' : [ 0x1690, ['unsigned long long']],
    'ReservedForNtRpc' : [ 0x1698, ['unsigned long long']],
    'DbgSsReserved' : [ 0x16a0, ['array', 2, ['unsigned long long']]],
    'HardErrorMode' : [ 0x16b0, ['unsigned long']],
    'Padding4' : [ 0x16b4, ['array', 4, ['unsigned char']]],
    'Instrumentation' : [ 0x16b8, ['array', 11, ['unsigned long long']]],
    'ActivityId' : [ 0x1710, ['_GUID']],
    'SubProcessTag' : [ 0x1720, ['unsigned long long']],
    'PerflibData' : [ 0x1728, ['unsigned long long']],
    'EtwTraceData' : [ 0x1730, ['unsigned long long']],
    'WinSockData' : [ 0x1738, ['unsigned long long']],
    'GdiBatchCount' : [ 0x1740, ['unsigned long']],
    'CurrentIdealProcessor' : [ 0x1744, ['_PROCESSOR_NUMBER']],
    'IdealProcessorValue' : [ 0x1744, ['unsigned long']],
    'ReservedPad0' : [ 0x1744, ['unsigned char']],
    'ReservedPad1' : [ 0x1745, ['unsigned char']],
    'ReservedPad2' : [ 0x1746, ['unsigned char']],
    'IdealProcessor' : [ 0x1747, ['unsigned char']],
    'GuaranteedStackBytes' : [ 0x1748, ['unsigned long']],
    'Padding5' : [ 0x174c, ['array', 4, ['unsigned char']]],
    'ReservedForPerf' : [ 0x1750, ['unsigned long long']],
    'ReservedForOle' : [ 0x1758, ['unsigned long long']],
    'WaitingOnLoaderLock' : [ 0x1760, ['unsigned long']],
    'Padding6' : [ 0x1764, ['array', 4, ['unsigned char']]],
    'SavedPriorityState' : [ 0x1768, ['unsigned long long']],
    'ReservedForCodeCoverage' : [ 0x1770, ['unsigned long long']],
    'ThreadPoolData' : [ 0x1778, ['unsigned long long']],
    'TlsExpansionSlots' : [ 0x1780, ['unsigned long long']],
    'DeallocationBStore' : [ 0x1788, ['unsigned long long']],
    'BStoreLimit' : [ 0x1790, ['unsigned long long']],
    'MuiGeneration' : [ 0x1798, ['unsigned long']],
    'IsImpersonating' : [ 0x179c, ['unsigned long']],
    'NlsCache' : [ 0x17a0, ['unsigned long long']],
    'pShimData' : [ 0x17a8, ['unsigned long long']],
    'HeapVirtualAffinity' : [ 0x17b0, ['unsigned short']],
    'LowFragHeapDataSlot' : [ 0x17b2, ['unsigned short']],
    'Padding7' : [ 0x17b4, ['array', 4, ['unsigned char']]],
    'CurrentTransactionHandle' : [ 0x17b8, ['unsigned long long']],
    'ActiveFrame' : [ 0x17c0, ['unsigned long long']],
    'FlsData' : [ 0x17c8, ['unsigned long long']],
    'PreferredLanguages' : [ 0x17d0, ['unsigned long long']],
    'UserPrefLanguages' : [ 0x17d8, ['unsigned long long']],
    'MergedPrefLanguages' : [ 0x17e0, ['unsigned long long']],
    'MuiImpersonation' : [ 0x17e8, ['unsigned long']],
    'CrossTebFlags' : [ 0x17ec, ['unsigned short']],
    'SpareCrossTebBits' : [ 0x17ec, ['BitField', dict(start_bit = 0, end_bit = 16, native_type='unsigned short')]],
    'SameTebFlags' : [ 0x17ee, ['unsigned short']],
    'SafeThunkCall' : [ 0x17ee, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
    'InDebugPrint' : [ 0x17ee, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned short')]],
    'HasFiberData' : [ 0x17ee, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned short')]],
    'SkipThreadAttach' : [ 0x17ee, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned short')]],
    'WerInShipAssertCode' : [ 0x17ee, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned short')]],
    'RanProcessInit' : [ 0x17ee, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned short')]],
    'ClonedThread' : [ 0x17ee, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned short')]],
    'SuppressDebugMsg' : [ 0x17ee, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned short')]],
    'DisableUserStackWalk' : [ 0x17ee, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned short')]],
    'RtlExceptionAttached' : [ 0x17ee, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned short')]],
    'InitialThread' : [ 0x17ee, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned short')]],
    'SessionAware' : [ 0x17ee, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned short')]],
    'LoadOwner' : [ 0x17ee, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned short')]],
    'LoaderWorker' : [ 0x17ee, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned short')]],
    'SkipLoaderInit' : [ 0x17ee, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned short')]],
    'SpareSameTebBits' : [ 0x17ee, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned short')]],
    'TxnScopeEnterCallback' : [ 0x17f0, ['unsigned long long']],
    'TxnScopeExitCallback' : [ 0x17f8, ['unsigned long long']],
    'TxnScopeContext' : [ 0x1800, ['unsigned long long']],
    'LockCount' : [ 0x1808, ['unsigned long']],
    'WowTebOffset' : [ 0x180c, ['long']],
    'ResourceRetValue' : [ 0x1810, ['unsigned long long']],
    'ReservedForWdf' : [ 0x1818, ['unsigned long long']],
    'ReservedForCrt' : [ 0x1820, ['unsigned long long']],
    'EffectiveContainerId' : [ 0x1828, ['_GUID']],
} ],
  '_HV_X64_HYPERVISOR_FEATURES' : [ 0x10, {
    'PartitionPrivileges' : [ 0x0, ['_HV_PARTITION_PRIVILEGE_MASK']],
    'MaxSupportedCState' : [ 0x8, ['BitField', dict(start_bit = 0, end_bit = 4, native_type='unsigned long')]],
    'HpetNeededForC3PowerState_Deprecated' : [ 0x8, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'Reserved' : [ 0x8, ['BitField', dict(start_bit = 5, end_bit = 32, native_type='unsigned long')]],
    'MwaitAvailable_Deprecated' : [ 0xc, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'GuestDebuggingAvailable' : [ 0xc, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'PerformanceMonitorsAvailable' : [ 0xc, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'CpuDynamicPartitioningAvailable' : [ 0xc, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'XmmRegistersForFastHypercallAvailable' : [ 0xc, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'GuestIdleAvailable' : [ 0xc, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'HypervisorSleepStateSupportAvailable' : [ 0xc, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'NumaDistanceQueryAvailable' : [ 0xc, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'FrequencyRegsAvailable' : [ 0xc, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'SyntheticMachineCheckAvailable' : [ 0xc, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'GuestCrashRegsAvailable' : [ 0xc, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'DebugRegsAvailable' : [ 0xc, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'Npiep1Available' : [ 0xc, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long')]],
    'DisableHypervisorAvailable' : [ 0xc, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long')]],
    'ExtendedGvaRangesForFlushVirtualAddressListAvailable' : [ 0xc, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long')]],
    'FastHypercallOutputAvailable' : [ 0xc, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'SvmFeaturesAvailable' : [ 0xc, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'SintPollingModeAvailable' : [ 0xc, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'HypercallMsrLockAvailable' : [ 0xc, ['BitField', dict(start_bit = 18, end_bit = 19, native_type='unsigned long')]],
    'DirectSyntheticTimers' : [ 0xc, ['BitField', dict(start_bit = 19, end_bit = 20, native_type='unsigned long')]],
    'RegisterPatAvailable' : [ 0xc, ['BitField', dict(start_bit = 20, end_bit = 21, native_type='unsigned long')]],
    'RegisterBndcfgsAvailable' : [ 0xc, ['BitField', dict(start_bit = 21, end_bit = 22, native_type='unsigned long')]],
    'WatchdogTimerAvailable' : [ 0xc, ['BitField', dict(start_bit = 22, end_bit = 23, native_type='unsigned long')]],
    'SyntheticTimeUnhaltedTimerAvailable' : [ 0xc, ['BitField', dict(start_bit = 23, end_bit = 24, native_type='unsigned long')]],
    'DeviceDomainsAvailable' : [ 0xc, ['BitField', dict(start_bit = 24, end_bit = 25, native_type='unsigned long')]],
    'S1DeviceDomainsAvailable' : [ 0xc, ['BitField', dict(start_bit = 25, end_bit = 26, native_type='unsigned long')]],
    'Reserved1' : [ 0xc, ['BitField', dict(start_bit = 26, end_bit = 32, native_type='unsigned long')]],
} ],
  '_HV_PARTITION_PRIVILEGE_MASK' : [ 0x8, {
    'AsUINT64' : [ 0x0, ['unsigned long long']],
    'AccessVpRunTimeReg' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'AccessPartitionReferenceCounter' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long long')]],
    'AccessSynicRegs' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long long')]],
    'AccessSyntheticTimerRegs' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long long')]],
    'AccessIntrCtrlRegs' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long long')]],
    'AccessHypercallMsrs' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long long')]],
    'AccessVpIndex' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long long')]],
    'AccessResetReg' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long long')]],
    'AccessStatsReg' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long long')]],
    'AccessPartitionReferenceTsc' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long long')]],
    'AccessGuestIdleReg' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long long')]],
    'AccessFrequencyRegs' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long long')]],
    'AccessDebugRegs' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long long')]],
    'AccessReenlightenmentControls' : [ 0x0, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long long')]],
    'AccessRootSchedulerReg' : [ 0x0, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long long')]],
    'Reserved1' : [ 0x0, ['BitField', dict(start_bit = 15, end_bit = 32, native_type='unsigned long long')]],
    'CreatePartitions' : [ 0x0, ['BitField', dict(start_bit = 32, end_bit = 33, native_type='unsigned long long')]],
    'AccessPartitionId' : [ 0x0, ['BitField', dict(start_bit = 33, end_bit = 34, native_type='unsigned long long')]],
    'AccessMemoryPool' : [ 0x0, ['BitField', dict(start_bit = 34, end_bit = 35, native_type='unsigned long long')]],
    'AdjustMessageBuffers' : [ 0x0, ['BitField', dict(start_bit = 35, end_bit = 36, native_type='unsigned long long')]],
    'PostMessages' : [ 0x0, ['BitField', dict(start_bit = 36, end_bit = 37, native_type='unsigned long long')]],
    'SignalEvents' : [ 0x0, ['BitField', dict(start_bit = 37, end_bit = 38, native_type='unsigned long long')]],
    'CreatePort' : [ 0x0, ['BitField', dict(start_bit = 38, end_bit = 39, native_type='unsigned long long')]],
    'ConnectPort' : [ 0x0, ['BitField', dict(start_bit = 39, end_bit = 40, native_type='unsigned long long')]],
    'AccessStats' : [ 0x0, ['BitField', dict(start_bit = 40, end_bit = 41, native_type='unsigned long long')]],
    'Reserved2' : [ 0x0, ['BitField', dict(start_bit = 41, end_bit = 43, native_type='unsigned long long')]],
    'Debugging' : [ 0x0, ['BitField', dict(start_bit = 43, end_bit = 44, native_type='unsigned long long')]],
    'CpuManagement' : [ 0x0, ['BitField', dict(start_bit = 44, end_bit = 45, native_type='unsigned long long')]],
    'ConfigureProfiler' : [ 0x0, ['BitField', dict(start_bit = 45, end_bit = 46, native_type='unsigned long long')]],
    'AccessVpExitTracing' : [ 0x0, ['BitField', dict(start_bit = 46, end_bit = 47, native_type='unsigned long long')]],
    'EnableExtendedGvaRangesForFlushVirtualAddressList' : [ 0x0, ['BitField', dict(start_bit = 47, end_bit = 48, native_type='unsigned long long')]],
    'AccessVsm' : [ 0x0, ['BitField', dict(start_bit = 48, end_bit = 49, native_type='unsigned long long')]],
    'AccessVpRegisters' : [ 0x0, ['BitField', dict(start_bit = 49, end_bit = 50, native_type='unsigned long long')]],
    'UnusedBit' : [ 0x0, ['BitField', dict(start_bit = 50, end_bit = 51, native_type='unsigned long long')]],
    'FastHypercallOutput' : [ 0x0, ['BitField', dict(start_bit = 51, end_bit = 52, native_type='unsigned long long')]],
    'EnableExtendedHypercalls' : [ 0x0, ['BitField', dict(start_bit = 52, end_bit = 53, native_type='unsigned long long')]],
    'StartVirtualProcessor' : [ 0x0, ['BitField', dict(start_bit = 53, end_bit = 54, native_type='unsigned long long')]],
    'Reserved3' : [ 0x0, ['BitField', dict(start_bit = 54, end_bit = 64, native_type='unsigned long long')]],
} ],
  '_KTIMER_TABLE' : [ 0x2200, {
    'TimerExpiry' : [ 0x0, ['array', 64, ['pointer64', ['_KTIMER']]]],
    'TimerEntries' : [ 0x200, ['array', 256, ['_KTIMER_TABLE_ENTRY']]],
} ],
  '_KTIMER_TABLE_ENTRY' : [ 0x20, {
    'Lock' : [ 0x0, ['unsigned long long']],
    'Entry' : [ 0x8, ['_LIST_ENTRY']],
    'Time' : [ 0x18, ['_ULARGE_INTEGER']],
} ],
  '_XSTATE_SAVE' : [ 0x38, {
    'Prev' : [ 0x0, ['pointer64', ['_XSTATE_SAVE']]],
    'Thread' : [ 0x8, ['pointer64', ['_KTHREAD']]],
    'Level' : [ 0x10, ['unsigned char']],
    'XStateContext' : [ 0x18, ['_XSTATE_CONTEXT']],
} ],
  '_XSAVE_AREA' : [ 0x240, {
    'LegacyState' : [ 0x0, ['_XSAVE_FORMAT']],
    'Header' : [ 0x200, ['_XSAVE_AREA_HEADER']],
} ],
  '_KSHARED_READY_QUEUE' : [ 0x270, {
    'Lock' : [ 0x0, ['unsigned long long']],
    'ReadySummary' : [ 0x8, ['unsigned long']],
    'ReadyListHead' : [ 0x10, ['array', 32, ['_LIST_ENTRY']]],
    'RunningSummary' : [ 0x210, ['array', 64, ['unsigned char']]],
    'Span' : [ 0x250, ['unsigned char']],
    'LowProcIndex' : [ 0x251, ['unsigned char']],
    'QueueIndex' : [ 0x252, ['unsigned char']],
    'ProcCount' : [ 0x253, ['unsigned char']],
    'ScanOwner' : [ 0x254, ['unsigned char']],
    'Spare' : [ 0x255, ['array', 3, ['unsigned char']]],
    'Affinity' : [ 0x258, ['unsigned long long']],
    'ReadyThreadCount' : [ 0x260, ['unsigned long']],
    'ReadyQueueExpectedRunTime' : [ 0x268, ['unsigned long long']],
} ],
  '_KEXCEPTION_FRAME' : [ 0x140, {
    'P1Home' : [ 0x0, ['unsigned long long']],
    'P2Home' : [ 0x8, ['unsigned long long']],
    'P3Home' : [ 0x10, ['unsigned long long']],
    'P4Home' : [ 0x18, ['unsigned long long']],
    'P5' : [ 0x20, ['unsigned long long']],
    'Spare1' : [ 0x28, ['unsigned long long']],
    'Xmm6' : [ 0x30, ['_M128A']],
    'Xmm7' : [ 0x40, ['_M128A']],
    'Xmm8' : [ 0x50, ['_M128A']],
    'Xmm9' : [ 0x60, ['_M128A']],
    'Xmm10' : [ 0x70, ['_M128A']],
    'Xmm11' : [ 0x80, ['_M128A']],
    'Xmm12' : [ 0x90, ['_M128A']],
    'Xmm13' : [ 0xa0, ['_M128A']],
    'Xmm14' : [ 0xb0, ['_M128A']],
    'Xmm15' : [ 0xc0, ['_M128A']],
    'TrapFrame' : [ 0xd0, ['unsigned long long']],
    'OutputBuffer' : [ 0xd8, ['unsigned long long']],
    'OutputLength' : [ 0xe0, ['unsigned long long']],
    'Spare2' : [ 0xe8, ['unsigned long long']],
    'MxCsr' : [ 0xf0, ['unsigned long long']],
    'Rbp' : [ 0xf8, ['unsigned long long']],
    'Rbx' : [ 0x100, ['unsigned long long']],
    'Rdi' : [ 0x108, ['unsigned long long']],
    'Rsi' : [ 0x110, ['unsigned long long']],
    'R12' : [ 0x118, ['unsigned long long']],
    'R13' : [ 0x120, ['unsigned long long']],
    'R14' : [ 0x128, ['unsigned long long']],
    'R15' : [ 0x130, ['unsigned long long']],
    'Return' : [ 0x138, ['unsigned long long']],
} ],
  '_KTRAP_FRAME' : [ 0x190, {
    'P1Home' : [ 0x0, ['unsigned long long']],
    'P2Home' : [ 0x8, ['unsigned long long']],
    'P3Home' : [ 0x10, ['unsigned long long']],
    'P4Home' : [ 0x18, ['unsigned long long']],
    'P5' : [ 0x20, ['unsigned long long']],
    'PreviousMode' : [ 0x28, ['unsigned char']],
    'PreviousIrql' : [ 0x29, ['unsigned char']],
    'FaultIndicator' : [ 0x2a, ['unsigned char']],
    'NmiMsrIbrs' : [ 0x2a, ['unsigned char']],
    'ExceptionActive' : [ 0x2b, ['unsigned char']],
    'MxCsr' : [ 0x2c, ['unsigned long']],
    'Rax' : [ 0x30, ['unsigned long long']],
    'Rcx' : [ 0x38, ['unsigned long long']],
    'Rdx' : [ 0x40, ['unsigned long long']],
    'R8' : [ 0x48, ['unsigned long long']],
    'R9' : [ 0x50, ['unsigned long long']],
    'R10' : [ 0x58, ['unsigned long long']],
    'R11' : [ 0x60, ['unsigned long long']],
    'GsBase' : [ 0x68, ['unsigned long long']],
    'GsSwap' : [ 0x68, ['unsigned long long']],
    'Xmm0' : [ 0x70, ['_M128A']],
    'Xmm1' : [ 0x80, ['_M128A']],
    'Xmm2' : [ 0x90, ['_M128A']],
    'Xmm3' : [ 0xa0, ['_M128A']],
    'Xmm4' : [ 0xb0, ['_M128A']],
    'Xmm5' : [ 0xc0, ['_M128A']],
    'FaultAddress' : [ 0xd0, ['unsigned long long']],
    'ContextRecord' : [ 0xd0, ['unsigned long long']],
    'Dr0' : [ 0xd8, ['unsigned long long']],
    'Dr1' : [ 0xe0, ['unsigned long long']],
    'Dr2' : [ 0xe8, ['unsigned long long']],
    'Dr3' : [ 0xf0, ['unsigned long long']],
    'Dr6' : [ 0xf8, ['unsigned long long']],
    'Dr7' : [ 0x100, ['unsigned long long']],
    'DebugControl' : [ 0x108, ['unsigned long long']],
    'LastBranchToRip' : [ 0x110, ['unsigned long long']],
    'LastBranchFromRip' : [ 0x118, ['unsigned long long']],
    'LastExceptionToRip' : [ 0x120, ['unsigned long long']],
    'LastExceptionFromRip' : [ 0x128, ['unsigned long long']],
    'SegDs' : [ 0x130, ['unsigned short']],
    'SegEs' : [ 0x132, ['unsigned short']],
    'SegFs' : [ 0x134, ['unsigned short']],
    'SegGs' : [ 0x136, ['unsigned short']],
    'TrapFrame' : [ 0x138, ['unsigned long long']],
    'Rbx' : [ 0x140, ['unsigned long long']],
    'Rdi' : [ 0x148, ['unsigned long long']],
    'Rsi' : [ 0x150, ['unsigned long long']],
    'Rbp' : [ 0x158, ['unsigned long long']],
    'ErrorCode' : [ 0x160, ['unsigned long long']],
    'ExceptionFrame' : [ 0x160, ['unsigned long long']],
    'Rip' : [ 0x168, ['unsigned long long']],
    'SegCs' : [ 0x170, ['unsigned short']],
    'Fill0' : [ 0x172, ['unsigned char']],
    'Logging' : [ 0x173, ['unsigned char']],
    'Fill1' : [ 0x174, ['array', 2, ['unsigned short']]],
    'EFlags' : [ 0x178, ['unsigned long']],
    'Fill2' : [ 0x17c, ['unsigned long']],
    'Rsp' : [ 0x180, ['unsigned long long']],
    'SegSs' : [ 0x188, ['unsigned short']],
    'Fill3' : [ 0x18a, ['unsigned short']],
    'Fill4' : [ 0x18c, ['unsigned long']],
} ],
  '__unnamed_198e' : [ 0x8, {
    'LegacyDeviceNode' : [ 0x0, ['pointer64', ['_DEVICE_NODE']]],
    'PendingDeviceRelations' : [ 0x0, ['pointer64', ['_DEVICE_RELATIONS']]],
    'Information' : [ 0x0, ['pointer64', ['void']]],
} ],
  '__unnamed_1990' : [ 0x8, {
    'NextResourceDeviceNode' : [ 0x0, ['pointer64', ['_DEVICE_NODE']]],
} ],
  '__unnamed_1994' : [ 0x20, {
    'DockStatus' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: u'DOCK_NOTDOCKDEVICE', 1: u'DOCK_QUIESCENT', 2: u'DOCK_ARRIVING', 3: u'DOCK_DEPARTING', 4: u'DOCK_EJECTIRP_COMPLETED'})]],
    'ListEntry' : [ 0x8, ['_LIST_ENTRY']],
    'SerialNumber' : [ 0x18, ['pointer64', ['wchar']]],
} ],
  '_DEVICE_NODE' : [ 0x2d8, {
    'Sibling' : [ 0x0, ['pointer64', ['_DEVICE_NODE']]],
    'Child' : [ 0x8, ['pointer64', ['_DEVICE_NODE']]],
    'Parent' : [ 0x10, ['pointer64', ['_DEVICE_NODE']]],
    'LastChild' : [ 0x18, ['pointer64', ['_DEVICE_NODE']]],
    'PhysicalDeviceObject' : [ 0x20, ['pointer64', ['_DEVICE_OBJECT']]],
    'InstancePath' : [ 0x28, ['_UNICODE_STRING']],
    'ServiceName' : [ 0x38, ['_UNICODE_STRING']],
    'PendingIrp' : [ 0x48, ['pointer64', ['_IRP']]],
    'FxDevice' : [ 0x50, ['pointer64', ['_POP_FX_DEVICE']]],
    'FxDeviceLock' : [ 0x58, ['long']],
    'FxRemoveEvent' : [ 0x60, ['_KEVENT']],
    'FxActivationCount' : [ 0x78, ['long']],
    'FxSleepCount' : [ 0x7c, ['long']],
    'Plugin' : [ 0x80, ['pointer64', ['_POP_FX_PLUGIN']]],
    'Level' : [ 0x88, ['unsigned long']],
    'CurrentPowerState' : [ 0x8c, ['_POWER_STATE']],
    'Notify' : [ 0x90, ['_PO_DEVICE_NOTIFY']],
    'PoIrpManager' : [ 0xf8, ['_PO_IRP_MANAGER']],
    'UniqueId' : [ 0x118, ['_UNICODE_STRING']],
    'PowerFlags' : [ 0x128, ['unsigned long']],
    'State' : [ 0x12c, ['Enumeration', dict(target = 'long', choices = {768: u'DeviceNodeUnspecified', 769: u'DeviceNodeUninitialized', 770: u'DeviceNodeInitialized', 771: u'DeviceNodeDriversAdded', 772: u'DeviceNodeResourcesAssigned', 773: u'DeviceNodeStartPending', 774: u'DeviceNodeStartCompletion', 775: u'DeviceNodeStartPostWork', 776: u'DeviceNodeStarted', 777: u'DeviceNodeQueryStopped', 778: u'DeviceNodeStopped', 779: u'DeviceNodeRestartCompletion', 780: u'DeviceNodeEnumeratePending', 781: u'DeviceNodeEnumerateCompletion', 782: u'DeviceNodeAwaitingQueuedDeletion', 783: u'DeviceNodeAwaitingQueuedRemoval', 784: u'DeviceNodeQueryRemoved', 785: u'DeviceNodeRemovePendingCloses', 786: u'DeviceNodeRemoved', 787: u'DeviceNodeDeletePendingCloses', 788: u'DeviceNodeDeleted', 789: u'MaxDeviceNodeState'})]],
    'PreviousState' : [ 0x130, ['Enumeration', dict(target = 'long', choices = {768: u'DeviceNodeUnspecified', 769: u'DeviceNodeUninitialized', 770: u'DeviceNodeInitialized', 771: u'DeviceNodeDriversAdded', 772: u'DeviceNodeResourcesAssigned', 773: u'DeviceNodeStartPending', 774: u'DeviceNodeStartCompletion', 775: u'DeviceNodeStartPostWork', 776: u'DeviceNodeStarted', 777: u'DeviceNodeQueryStopped', 778: u'DeviceNodeStopped', 779: u'DeviceNodeRestartCompletion', 780: u'DeviceNodeEnumeratePending', 781: u'DeviceNodeEnumerateCompletion', 782: u'DeviceNodeAwaitingQueuedDeletion', 783: u'DeviceNodeAwaitingQueuedRemoval', 784: u'DeviceNodeQueryRemoved', 785: u'DeviceNodeRemovePendingCloses', 786: u'DeviceNodeRemoved', 787: u'DeviceNodeDeletePendingCloses', 788: u'DeviceNodeDeleted', 789: u'MaxDeviceNodeState'})]],
    'StateHistory' : [ 0x134, ['array', 20, ['Enumeration', dict(target = 'long', choices = {768: u'DeviceNodeUnspecified', 769: u'DeviceNodeUninitialized', 770: u'DeviceNodeInitialized', 771: u'DeviceNodeDriversAdded', 772: u'DeviceNodeResourcesAssigned', 773: u'DeviceNodeStartPending', 774: u'DeviceNodeStartCompletion', 775: u'DeviceNodeStartPostWork', 776: u'DeviceNodeStarted', 777: u'DeviceNodeQueryStopped', 778: u'DeviceNodeStopped', 779: u'DeviceNodeRestartCompletion', 780: u'DeviceNodeEnumeratePending', 781: u'DeviceNodeEnumerateCompletion', 782: u'DeviceNodeAwaitingQueuedDeletion', 783: u'DeviceNodeAwaitingQueuedRemoval', 784: u'DeviceNodeQueryRemoved', 785: u'DeviceNodeRemovePendingCloses', 786: u'DeviceNodeRemoved', 787: u'DeviceNodeDeletePendingCloses', 788: u'DeviceNodeDeleted', 789: u'MaxDeviceNodeState'})]]],
    'StateHistoryEntry' : [ 0x184, ['unsigned long']],
    'CompletionStatus' : [ 0x188, ['long']],
    'Flags' : [ 0x18c, ['unsigned long']],
    'UserFlags' : [ 0x190, ['unsigned long']],
    'Problem' : [ 0x194, ['unsigned long']],
    'ProblemStatus' : [ 0x198, ['long']],
    'ResourceList' : [ 0x1a0, ['pointer64', ['_CM_RESOURCE_LIST']]],
    'ResourceListTranslated' : [ 0x1a8, ['pointer64', ['_CM_RESOURCE_LIST']]],
    'DuplicatePDO' : [ 0x1b0, ['pointer64', ['_DEVICE_OBJECT']]],
    'ResourceRequirements' : [ 0x1b8, ['pointer64', ['_IO_RESOURCE_REQUIREMENTS_LIST']]],
    'InterfaceType' : [ 0x1c0, ['Enumeration', dict(target = 'long', choices = {0: u'Internal', 1: u'Isa', 2: u'Eisa', 3: u'MicroChannel', 4: u'TurboChannel', 5: u'PCIBus', 6: u'VMEBus', 7: u'NuBus', 8: u'PCMCIABus', 9: u'CBus', 10: u'MPIBus', 11: u'MPSABus', 12: u'ProcessorInternal', 13: u'InternalPowerBus', 14: u'PNPISABus', 15: u'PNPBus', 16: u'Vmcs', 17: u'ACPIBus', 18: u'MaximumInterfaceType', -1: u'InterfaceTypeUndefined'})]],
    'BusNumber' : [ 0x1c4, ['unsigned long']],
    'ChildInterfaceType' : [ 0x1c8, ['Enumeration', dict(target = 'long', choices = {0: u'Internal', 1: u'Isa', 2: u'Eisa', 3: u'MicroChannel', 4: u'TurboChannel', 5: u'PCIBus', 6: u'VMEBus', 7: u'NuBus', 8: u'PCMCIABus', 9: u'CBus', 10: u'MPIBus', 11: u'MPSABus', 12: u'ProcessorInternal', 13: u'InternalPowerBus', 14: u'PNPISABus', 15: u'PNPBus', 16: u'Vmcs', 17: u'ACPIBus', 18: u'MaximumInterfaceType', -1: u'InterfaceTypeUndefined'})]],
    'ChildBusNumber' : [ 0x1cc, ['unsigned long']],
    'ChildBusTypeIndex' : [ 0x1d0, ['unsigned short']],
    'RemovalPolicy' : [ 0x1d2, ['unsigned char']],
    'HardwareRemovalPolicy' : [ 0x1d3, ['unsigned char']],
    'TargetDeviceNotify' : [ 0x1d8, ['_LIST_ENTRY']],
    'DeviceArbiterList' : [ 0x1e8, ['_LIST_ENTRY']],
    'DeviceTranslatorList' : [ 0x1f8, ['_LIST_ENTRY']],
    'NoTranslatorMask' : [ 0x208, ['unsigned short']],
    'QueryTranslatorMask' : [ 0x20a, ['unsigned short']],
    'NoArbiterMask' : [ 0x20c, ['unsigned short']],
    'QueryArbiterMask' : [ 0x20e, ['unsigned short']],
    'OverUsed1' : [ 0x210, ['__unnamed_198e']],
    'OverUsed2' : [ 0x218, ['__unnamed_1990']],
    'BootResources' : [ 0x220, ['pointer64', ['_CM_RESOURCE_LIST']]],
    'BootResourcesTranslated' : [ 0x228, ['pointer64', ['_CM_RESOURCE_LIST']]],
    'CapabilityFlags' : [ 0x230, ['unsigned long']],
    'DockInfo' : [ 0x238, ['__unnamed_1994']],
    'DisableableDepends' : [ 0x258, ['unsigned long']],
    'PendedSetInterfaceState' : [ 0x260, ['_LIST_ENTRY']],
    'LegacyBusListEntry' : [ 0x270, ['_LIST_ENTRY']],
    'DriverUnloadRetryCount' : [ 0x280, ['unsigned long']],
    'PreviousParent' : [ 0x288, ['pointer64', ['_DEVICE_NODE']]],
    'DeletedChildren' : [ 0x290, ['long']],
    'NumaNodeIndex' : [ 0x294, ['unsigned long']],
    'ContainerID' : [ 0x298, ['_GUID']],
    'OverrideFlags' : [ 0x2a8, ['unsigned char']],
    'DeviceIdsHash' : [ 0x2ac, ['unsigned long']],
    'RequiresUnloadedDriver' : [ 0x2b0, ['unsigned char']],
    'PendingEjectRelations' : [ 0x2b8, ['pointer64', ['_PENDING_RELATIONS_LIST_ENTRY']]],
    'StateFlags' : [ 0x2c0, ['unsigned long']],
    'RebalanceContext' : [ 0x2c8, ['pointer64', ['_PNP_REBALANCE_TRACE_CONTEXT']]],
    'IommuExtension' : [ 0x2d0, ['pointer64', ['_DEVICE_NODE_IOMMU_EXTENSION']]],
} ],
  '_MCGEN_TRACE_CONTEXT' : [ 0x48, {
    'RegistrationHandle' : [ 0x0, ['unsigned long long']],
    'Logger' : [ 0x8, ['unsigned long long']],
    'MatchAnyKeyword' : [ 0x10, ['unsigned long long']],
    'MatchAllKeyword' : [ 0x18, ['unsigned long long']],
    'Flags' : [ 0x20, ['unsigned long']],
    'IsEnabled' : [ 0x24, ['unsigned long']],
    'Level' : [ 0x28, ['unsigned char']],
    'Reserve' : [ 0x29, ['unsigned char']],
    'EnableBitsCount' : [ 0x2a, ['unsigned short']],
    'EnableBitMask' : [ 0x30, ['pointer64', ['unsigned long']]],
    'EnableKeyWords' : [ 0x38, ['pointer64', ['unsigned long long']]],
    'EnableLevel' : [ 0x40, ['pointer64', ['unsigned char']]],
} ],
  '_PNP_DEVICE_COMPLETION_QUEUE' : [ 0x50, {
    'DispatchedList' : [ 0x0, ['_LIST_ENTRY']],
    'DispatchedCount' : [ 0x10, ['unsigned long']],
    'CompletedList' : [ 0x18, ['_LIST_ENTRY']],
    'CompletedSemaphore' : [ 0x28, ['_KSEMAPHORE']],
    'SpinLock' : [ 0x48, ['unsigned long long']],
} ],
  '_KSEMAPHORE' : [ 0x20, {
    'Header' : [ 0x0, ['_DISPATCHER_HEADER']],
    'Limit' : [ 0x18, ['long']],
} ],
  '_DEVOBJ_EXTENSION' : [ 0x68, {
    'Type' : [ 0x0, ['short']],
    'Size' : [ 0x2, ['unsigned short']],
    'DeviceObject' : [ 0x8, ['pointer64', ['_DEVICE_OBJECT']]],
    'PowerFlags' : [ 0x10, ['unsigned long']],
    'Dope' : [ 0x18, ['pointer64', ['_DEVICE_OBJECT_POWER_EXTENSION']]],
    'ExtensionFlags' : [ 0x20, ['unsigned long']],
    'DeviceNode' : [ 0x28, ['pointer64', ['void']]],
    'AttachedTo' : [ 0x30, ['pointer64', ['_DEVICE_OBJECT']]],
    'StartIoCount' : [ 0x38, ['long']],
    'StartIoKey' : [ 0x3c, ['long']],
    'StartIoFlags' : [ 0x40, ['unsigned long']],
    'Vpb' : [ 0x48, ['pointer64', ['_VPB']]],
    'DependencyNode' : [ 0x50, ['pointer64', ['void']]],
    'InterruptContext' : [ 0x58, ['pointer64', ['void']]],
    'VerifierContext' : [ 0x60, ['pointer64', ['void']]],
} ],
  '_GROUP_AFFINITY' : [ 0x10, {
    'Mask' : [ 0x0, ['unsigned long long']],
    'Group' : [ 0x8, ['unsigned short']],
    'Reserved' : [ 0xa, ['array', 3, ['unsigned short']]],
} ],
  '_KAFFINITY_EX' : [ 0xa8, {
    'Count' : [ 0x0, ['unsigned short']],
    'Size' : [ 0x2, ['unsigned short']],
    'Reserved' : [ 0x4, ['unsigned long']],
    'Bitmap' : [ 0x8, ['array', 20, ['unsigned long long']]],
} ],
  '_PNP_ASSIGN_RESOURCES_CONTEXT' : [ 0x10, {
    'IncludeFailedDevices' : [ 0x0, ['unsigned long']],
    'DeviceCount' : [ 0x4, ['unsigned long']],
    'DeviceList' : [ 0x8, ['array', 1, ['pointer64', ['_DEVICE_OBJECT']]]],
} ],
  '_PNP_RESOURCE_REQUEST' : [ 0x40, {
    'PhysicalDevice' : [ 0x0, ['pointer64', ['_DEVICE_OBJECT']]],
    'Flags' : [ 0x8, ['unsigned long']],
    'AllocationType' : [ 0xc, ['Enumeration', dict(target = 'long', choices = {0: u'ArbiterRequestLegacyReported', 1: u'ArbiterRequestHalReported', 2: u'ArbiterRequestLegacyAssigned', 3: u'ArbiterRequestPnpDetected', 4: u'ArbiterRequestPnpEnumerated', -1: u'ArbiterRequestUndefined'})]],
    'Priority' : [ 0x10, ['unsigned long']],
    'Position' : [ 0x14, ['unsigned long']],
    'ResourceRequirements' : [ 0x18, ['pointer64', ['_IO_RESOURCE_REQUIREMENTS_LIST']]],
    'ReqList' : [ 0x20, ['pointer64', ['void']]],
    'ResourceAssignment' : [ 0x28, ['pointer64', ['_CM_RESOURCE_LIST']]],
    'TranslatedResourceAssignment' : [ 0x30, ['pointer64', ['_CM_RESOURCE_LIST']]],
    'Status' : [ 0x38, ['long']],
} ],
  '_IO_RESOURCE_REQUIREMENTS_LIST' : [ 0x48, {
    'ListSize' : [ 0x0, ['unsigned long']],
    'InterfaceType' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {0: u'Internal', 1: u'Isa', 2: u'Eisa', 3: u'MicroChannel', 4: u'TurboChannel', 5: u'PCIBus', 6: u'VMEBus', 7: u'NuBus', 8: u'PCMCIABus', 9: u'CBus', 10: u'MPIBus', 11: u'MPSABus', 12: u'ProcessorInternal', 13: u'InternalPowerBus', 14: u'PNPISABus', 15: u'PNPBus', 16: u'Vmcs', 17: u'ACPIBus', 18: u'MaximumInterfaceType', -1: u'InterfaceTypeUndefined'})]],
    'BusNumber' : [ 0x8, ['unsigned long']],
    'SlotNumber' : [ 0xc, ['unsigned long']],
    'Reserved' : [ 0x10, ['array', 3, ['unsigned long']]],
    'AlternativeLists' : [ 0x1c, ['unsigned long']],
    'List' : [ 0x20, ['array', 1, ['_IO_RESOURCE_LIST']]],
} ],
  '_EXCEPTION_RECORD64' : [ 0x98, {
    'ExceptionCode' : [ 0x0, ['long']],
    'ExceptionFlags' : [ 0x4, ['unsigned long']],
    'ExceptionRecord' : [ 0x8, ['unsigned long long']],
    'ExceptionAddress' : [ 0x10, ['unsigned long long']],
    'NumberParameters' : [ 0x18, ['unsigned long']],
    '__unusedAlignment' : [ 0x1c, ['unsigned long']],
    'ExceptionInformation' : [ 0x20, ['array', 15, ['unsigned long long']]],
} ],
  '_EXCEPTION_RECORD32' : [ 0x50, {
    'ExceptionCode' : [ 0x0, ['long']],
    'ExceptionFlags' : [ 0x4, ['unsigned long']],
    'ExceptionRecord' : [ 0x8, ['unsigned long']],
    'ExceptionAddress' : [ 0xc, ['unsigned long']],
    'NumberParameters' : [ 0x10, ['unsigned long']],
    'ExceptionInformation' : [ 0x14, ['array', 15, ['unsigned long']]],
} ],
  '_DBGKM_EXCEPTION64' : [ 0xa0, {
    'ExceptionRecord' : [ 0x0, ['_EXCEPTION_RECORD64']],
    'FirstChance' : [ 0x98, ['unsigned long']],
} ],
  '_DBGKM_EXCEPTION32' : [ 0x54, {
    'ExceptionRecord' : [ 0x0, ['_EXCEPTION_RECORD32']],
    'FirstChance' : [ 0x50, ['unsigned long']],
} ],
  '_X86_KTRAP_FRAME' : [ 0x8c, {
    'DbgEbp' : [ 0x0, ['unsigned long']],
    'DbgEip' : [ 0x4, ['unsigned long']],
    'DbgArgMark' : [ 0x8, ['unsigned long']],
    'DbgArgPointer' : [ 0xc, ['unsigned long']],
    'TempSegCs' : [ 0x10, ['unsigned long']],
    'TempEsp' : [ 0x14, ['unsigned long']],
    'Dr0' : [ 0x18, ['unsigned long']],
    'Dr1' : [ 0x1c, ['unsigned long']],
    'Dr2' : [ 0x20, ['unsigned long']],
    'Dr3' : [ 0x24, ['unsigned long']],
    'Dr6' : [ 0x28, ['unsigned long']],
    'Dr7' : [ 0x2c, ['unsigned long']],
    'SegGs' : [ 0x30, ['unsigned long']],
    'SegEs' : [ 0x34, ['unsigned long']],
    'SegDs' : [ 0x38, ['unsigned long']],
    'Edx' : [ 0x3c, ['unsigned long']],
    'Ecx' : [ 0x40, ['unsigned long']],
    'Eax' : [ 0x44, ['unsigned long']],
    'PreviousPreviousMode' : [ 0x48, ['unsigned char']],
    'EntropyQueueDpc' : [ 0x49, ['unsigned char']],
    'Reserved' : [ 0x4a, ['array', 2, ['unsigned char']]],
    'ExceptionList' : [ 0x4c, ['unsigned long']],
    'SegFs' : [ 0x50, ['unsigned long']],
    'Edi' : [ 0x54, ['unsigned long']],
    'Esi' : [ 0x58, ['unsigned long']],
    'Ebx' : [ 0x5c, ['unsigned long']],
    'Ebp' : [ 0x60, ['unsigned long']],
    'ErrCode' : [ 0x64, ['unsigned long']],
    'Eip' : [ 0x68, ['unsigned long']],
    'SegCs' : [ 0x6c, ['unsigned long']],
    'EFlags' : [ 0x70, ['unsigned long']],
    'HardwareEsp' : [ 0x74, ['unsigned long']],
    'HardwareSegSs' : [ 0x78, ['unsigned long']],
    'V86Es' : [ 0x7c, ['unsigned long']],
    'V86Ds' : [ 0x80, ['unsigned long']],
    'V86Fs' : [ 0x84, ['unsigned long']],
    'V86Gs' : [ 0x88, ['unsigned long']],
} ],
  '_X86_KTRAP_FRAME_BLUE' : [ 0x8c, {
    'DbgEbp' : [ 0x0, ['unsigned long']],
    'DbgEip' : [ 0x4, ['unsigned long']],
    'DbgArgMark' : [ 0x8, ['unsigned long']],
    'TempSegCs' : [ 0xc, ['unsigned short']],
    'Logging' : [ 0xe, ['unsigned char']],
    'FrameType' : [ 0xf, ['unsigned char']],
    'TempEsp' : [ 0x10, ['unsigned long']],
    'Dr0' : [ 0x14, ['unsigned long']],
    'Dr1' : [ 0x18, ['unsigned long']],
    'Dr2' : [ 0x1c, ['unsigned long']],
    'Dr3' : [ 0x20, ['unsigned long']],
    'Dr6' : [ 0x24, ['unsigned long']],
    'Dr7' : [ 0x28, ['unsigned long']],
    'SegGs' : [ 0x2c, ['unsigned long']],
    'SegEs' : [ 0x30, ['unsigned long']],
    'SegDs' : [ 0x34, ['unsigned long']],
    'Edx' : [ 0x38, ['unsigned long']],
    'Ecx' : [ 0x3c, ['unsigned long']],
    'Eax' : [ 0x40, ['unsigned long']],
    'PreviousPreviousMode' : [ 0x44, ['unsigned char']],
    'EntropyQueueDpc' : [ 0x45, ['unsigned char']],
    'Reserved' : [ 0x46, ['array', 2, ['unsigned char']]],
    'MxCsr' : [ 0x48, ['unsigned long']],
    'ExceptionList' : [ 0x4c, ['unsigned long']],
    'SegFs' : [ 0x50, ['unsigned long']],
    'Edi' : [ 0x54, ['unsigned long']],
    'Esi' : [ 0x58, ['unsigned long']],
    'Ebx' : [ 0x5c, ['unsigned long']],
    'Ebp' : [ 0x60, ['unsigned long']],
    'ErrCode' : [ 0x64, ['unsigned long']],
    'Eip' : [ 0x68, ['unsigned long']],
    'SegCs' : [ 0x6c, ['unsigned long']],
    'EFlags' : [ 0x70, ['unsigned long']],
    'HardwareEsp' : [ 0x74, ['unsigned long']],
    'HardwareSegSs' : [ 0x78, ['unsigned long']],
    'V86Es' : [ 0x7c, ['unsigned long']],
    'V86Ds' : [ 0x80, ['unsigned long']],
    'V86Fs' : [ 0x84, ['unsigned long']],
    'V86Gs' : [ 0x88, ['unsigned long']],
} ],
  '_DBGKD_LOAD_SYMBOLS64' : [ 0x28, {
    'PathNameLength' : [ 0x0, ['unsigned long']],
    'BaseOfDll' : [ 0x8, ['unsigned long long']],
    'ProcessId' : [ 0x10, ['unsigned long long']],
    'CheckSum' : [ 0x18, ['unsigned long']],
    'SizeOfImage' : [ 0x1c, ['unsigned long']],
    'UnloadSymbols' : [ 0x20, ['unsigned char']],
} ],
  '_DBGKD_LOAD_SYMBOLS32' : [ 0x18, {
    'PathNameLength' : [ 0x0, ['unsigned long']],
    'BaseOfDll' : [ 0x4, ['unsigned long']],
    'ProcessId' : [ 0x8, ['unsigned long']],
    'CheckSum' : [ 0xc, ['unsigned long']],
    'SizeOfImage' : [ 0x10, ['unsigned long']],
    'UnloadSymbols' : [ 0x14, ['unsigned char']],
} ],
  '_DBGKD_READ_MEMORY64' : [ 0x10, {
    'TargetBaseAddress' : [ 0x0, ['unsigned long long']],
    'TransferCount' : [ 0x8, ['unsigned long']],
    'ActualBytesRead' : [ 0xc, ['unsigned long']],
} ],
  '_DBGKD_READ_MEMORY32' : [ 0xc, {
    'TargetBaseAddress' : [ 0x0, ['unsigned long']],
    'TransferCount' : [ 0x4, ['unsigned long']],
    'ActualBytesRead' : [ 0x8, ['unsigned long']],
} ],
  '_DBGKD_WRITE_MEMORY64' : [ 0x10, {
    'TargetBaseAddress' : [ 0x0, ['unsigned long long']],
    'TransferCount' : [ 0x8, ['unsigned long']],
    'ActualBytesWritten' : [ 0xc, ['unsigned long']],
} ],
  '_DBGKD_WRITE_MEMORY32' : [ 0xc, {
    'TargetBaseAddress' : [ 0x0, ['unsigned long']],
    'TransferCount' : [ 0x4, ['unsigned long']],
    'ActualBytesWritten' : [ 0x8, ['unsigned long']],
} ],
  '_DBGKD_WRITE_BREAKPOINT64' : [ 0x10, {
    'BreakPointAddress' : [ 0x0, ['unsigned long long']],
    'BreakPointHandle' : [ 0x8, ['unsigned long']],
} ],
  '_DBGKD_WRITE_BREAKPOINT32' : [ 0x8, {
    'BreakPointAddress' : [ 0x0, ['unsigned long']],
    'BreakPointHandle' : [ 0x4, ['unsigned long']],
} ],
  '_DBGKD_READ_WRITE_IO64' : [ 0x10, {
    'IoAddress' : [ 0x0, ['unsigned long long']],
    'DataSize' : [ 0x8, ['unsigned long']],
    'DataValue' : [ 0xc, ['unsigned long']],
} ],
  '_DBGKD_READ_WRITE_IO32' : [ 0xc, {
    'DataSize' : [ 0x0, ['unsigned long']],
    'IoAddress' : [ 0x4, ['unsigned long']],
    'DataValue' : [ 0x8, ['unsigned long']],
} ],
  '_DBGKD_READ_WRITE_IO_EXTENDED64' : [ 0x20, {
    'DataSize' : [ 0x0, ['unsigned long']],
    'InterfaceType' : [ 0x4, ['unsigned long']],
    'BusNumber' : [ 0x8, ['unsigned long']],
    'AddressSpace' : [ 0xc, ['unsigned long']],
    'IoAddress' : [ 0x10, ['unsigned long long']],
    'DataValue' : [ 0x18, ['unsigned long']],
} ],
  '_DBGKD_READ_WRITE_IO_EXTENDED32' : [ 0x18, {
    'DataSize' : [ 0x0, ['unsigned long']],
    'InterfaceType' : [ 0x4, ['unsigned long']],
    'BusNumber' : [ 0x8, ['unsigned long']],
    'AddressSpace' : [ 0xc, ['unsigned long']],
    'IoAddress' : [ 0x10, ['unsigned long']],
    'DataValue' : [ 0x14, ['unsigned long']],
} ],
  '_DBGKD_SET_SPECIAL_CALL32' : [ 0x4, {
    'SpecialCall' : [ 0x0, ['unsigned long']],
} ],
  '_DBGKD_SET_SPECIAL_CALL64' : [ 0x8, {
    'SpecialCall' : [ 0x0, ['unsigned long long']],
} ],
  '_DBGKD_SET_INTERNAL_BREAKPOINT32' : [ 0x8, {
    'BreakpointAddress' : [ 0x0, ['unsigned long']],
    'Flags' : [ 0x4, ['unsigned long']],
} ],
  '_DBGKD_SET_INTERNAL_BREAKPOINT64' : [ 0x10, {
    'BreakpointAddress' : [ 0x0, ['unsigned long long']],
    'Flags' : [ 0x8, ['unsigned long']],
} ],
  '_DBGKD_GET_INTERNAL_BREAKPOINT64' : [ 0x20, {
    'BreakpointAddress' : [ 0x0, ['unsigned long long']],
    'Flags' : [ 0x8, ['unsigned long']],
    'Calls' : [ 0xc, ['unsigned long']],
    'MaxCallsPerPeriod' : [ 0x10, ['unsigned long']],
    'MinInstructions' : [ 0x14, ['unsigned long']],
    'MaxInstructions' : [ 0x18, ['unsigned long']],
    'TotalInstructions' : [ 0x1c, ['unsigned long']],
} ],
  '_DBGKD_GET_INTERNAL_BREAKPOINT32' : [ 0x1c, {
    'BreakpointAddress' : [ 0x0, ['unsigned long']],
    'Flags' : [ 0x4, ['unsigned long']],
    'Calls' : [ 0x8, ['unsigned long']],
    'MaxCallsPerPeriod' : [ 0xc, ['unsigned long']],
    'MinInstructions' : [ 0x10, ['unsigned long']],
    'MaxInstructions' : [ 0x14, ['unsigned long']],
    'TotalInstructions' : [ 0x18, ['unsigned long']],
} ],
  '__unnamed_1a8a' : [ 0x28, {
    'ReadMemory' : [ 0x0, ['_DBGKD_READ_MEMORY64']],
    'WriteMemory' : [ 0x0, ['_DBGKD_WRITE_MEMORY64']],
    'GetContext' : [ 0x0, ['_DBGKD_GET_CONTEXT']],
    'SetContext' : [ 0x0, ['_DBGKD_SET_CONTEXT']],
    'WriteBreakPoint' : [ 0x0, ['_DBGKD_WRITE_BREAKPOINT64']],
    'RestoreBreakPoint' : [ 0x0, ['_DBGKD_RESTORE_BREAKPOINT']],
    'Continue' : [ 0x0, ['_DBGKD_CONTINUE']],
    'Continue2' : [ 0x0, ['_DBGKD_CONTINUE2']],
    'ReadWriteIo' : [ 0x0, ['_DBGKD_READ_WRITE_IO64']],
    'ReadWriteIoExtended' : [ 0x0, ['_DBGKD_READ_WRITE_IO_EXTENDED64']],
    'QuerySpecialCalls' : [ 0x0, ['_DBGKD_QUERY_SPECIAL_CALLS']],
    'SetSpecialCall' : [ 0x0, ['_DBGKD_SET_SPECIAL_CALL64']],
    'SetInternalBreakpoint' : [ 0x0, ['_DBGKD_SET_INTERNAL_BREAKPOINT64']],
    'GetInternalBreakpoint' : [ 0x0, ['_DBGKD_GET_INTERNAL_BREAKPOINT64']],
    'GetVersion64' : [ 0x0, ['_DBGKD_GET_VERSION64']],
    'BreakPointEx' : [ 0x0, ['_DBGKD_BREAKPOINTEX']],
    'ReadWriteMsr' : [ 0x0, ['_DBGKD_READ_WRITE_MSR']],
    'SearchMemory' : [ 0x0, ['_DBGKD_SEARCH_MEMORY']],
    'GetSetBusData' : [ 0x0, ['_DBGKD_GET_SET_BUS_DATA']],
    'FillMemory' : [ 0x0, ['_DBGKD_FILL_MEMORY']],
    'QueryMemory' : [ 0x0, ['_DBGKD_QUERY_MEMORY']],
    'SwitchPartition' : [ 0x0, ['_DBGKD_SWITCH_PARTITION']],
    'GetContextEx' : [ 0x0, ['_DBGKD_CONTEXT_EX']],
    'SetContextEx' : [ 0x0, ['_DBGKD_CONTEXT_EX']],
    'WriteCustomBreakPoint' : [ 0x0, ['_DBGKD_WRITE_CUSTOM_BREAKPOINT']],
} ],
  '_DBGKD_MANIPULATE_STATE64' : [ 0x38, {
    'ApiNumber' : [ 0x0, ['unsigned long']],
    'ProcessorLevel' : [ 0x4, ['unsigned short']],
    'Processor' : [ 0x6, ['unsigned short']],
    'ReturnStatus' : [ 0x8, ['long']],
    'u' : [ 0x10, ['__unnamed_1a8a']],
} ],
  '__unnamed_1a91' : [ 0x28, {
    'ReadMemory' : [ 0x0, ['_DBGKD_READ_MEMORY32']],
    'WriteMemory' : [ 0x0, ['_DBGKD_WRITE_MEMORY32']],
    'ReadMemory64' : [ 0x0, ['_DBGKD_READ_MEMORY64']],
    'WriteMemory64' : [ 0x0, ['_DBGKD_WRITE_MEMORY64']],
    'GetContext' : [ 0x0, ['_DBGKD_GET_CONTEXT']],
    'SetContext' : [ 0x0, ['_DBGKD_SET_CONTEXT']],
    'WriteBreakPoint' : [ 0x0, ['_DBGKD_WRITE_BREAKPOINT32']],
    'RestoreBreakPoint' : [ 0x0, ['_DBGKD_RESTORE_BREAKPOINT']],
    'Continue' : [ 0x0, ['_DBGKD_CONTINUE']],
    'Continue2' : [ 0x0, ['_DBGKD_CONTINUE2']],
    'ReadWriteIo' : [ 0x0, ['_DBGKD_READ_WRITE_IO32']],
    'ReadWriteIoExtended' : [ 0x0, ['_DBGKD_READ_WRITE_IO_EXTENDED32']],
    'QuerySpecialCalls' : [ 0x0, ['_DBGKD_QUERY_SPECIAL_CALLS']],
    'SetSpecialCall' : [ 0x0, ['_DBGKD_SET_SPECIAL_CALL32']],
    'SetInternalBreakpoint' : [ 0x0, ['_DBGKD_SET_INTERNAL_BREAKPOINT32']],
    'GetInternalBreakpoint' : [ 0x0, ['_DBGKD_GET_INTERNAL_BREAKPOINT32']],
    'GetVersion32' : [ 0x0, ['_DBGKD_GET_VERSION32']],
    'BreakPointEx' : [ 0x0, ['_DBGKD_BREAKPOINTEX']],
    'ReadWriteMsr' : [ 0x0, ['_DBGKD_READ_WRITE_MSR']],
    'SearchMemory' : [ 0x0, ['_DBGKD_SEARCH_MEMORY']],
    'GetContextEx' : [ 0x0, ['_DBGKD_CONTEXT_EX']],
    'SetContextEx' : [ 0x0, ['_DBGKD_CONTEXT_EX']],
} ],
  '_DBGKD_MANIPULATE_STATE32' : [ 0x34, {
    'ApiNumber' : [ 0x0, ['unsigned long']],
    'ProcessorLevel' : [ 0x4, ['unsigned short']],
    'Processor' : [ 0x6, ['unsigned short']],
    'ReturnStatus' : [ 0x8, ['long']],
    'u' : [ 0xc, ['__unnamed_1a91']],
} ],
  '_DBGKD_READ_WRITE_MSR' : [ 0xc, {
    'Msr' : [ 0x0, ['unsigned long']],
    'DataValueLow' : [ 0x4, ['unsigned long']],
    'DataValueHigh' : [ 0x8, ['unsigned long']],
} ],
  '_DBGKD_BREAKPOINTEX' : [ 0x8, {
    'BreakPointCount' : [ 0x0, ['unsigned long']],
    'ContinueStatus' : [ 0x4, ['long']],
} ],
  '_DBGKD_SEARCH_MEMORY' : [ 0x18, {
    'SearchAddress' : [ 0x0, ['unsigned long long']],
    'FoundAddress' : [ 0x0, ['unsigned long long']],
    'SearchLength' : [ 0x8, ['unsigned long long']],
    'PatternLength' : [ 0x10, ['unsigned long']],
} ],
  '_DBGKD_RESTORE_BREAKPOINT' : [ 0x4, {
    'BreakPointHandle' : [ 0x0, ['unsigned long']],
} ],
  '_DBGKD_CONTINUE' : [ 0x4, {
    'ContinueStatus' : [ 0x0, ['long']],
} ],
  '_DBGKD_CONTINUE2' : [ 0x20, {
    'ContinueStatus' : [ 0x0, ['long']],
    'ControlSet' : [ 0x4, ['_AMD64_DBGKD_CONTROL_SET']],
    'AnyControlSet' : [ 0x4, ['_DBGKD_ANY_CONTROL_SET']],
} ],
  '_DEVICE_MANAGE_DATA_SET_ATTRIBUTES' : [ 0x1c, {
    'Size' : [ 0x0, ['unsigned long']],
    'Action' : [ 0x4, ['unsigned long']],
    'Flags' : [ 0x8, ['unsigned long']],
    'ParameterBlockOffset' : [ 0xc, ['unsigned long']],
    'ParameterBlockLength' : [ 0x10, ['unsigned long']],
    'DataSetRangesOffset' : [ 0x14, ['unsigned long']],
    'DataSetRangesLength' : [ 0x18, ['unsigned long']],
} ],
  '_DEVICE_DATA_SET_RANGE' : [ 0x10, {
    'StartingOffset' : [ 0x0, ['long long']],
    'LengthInBytes' : [ 0x8, ['unsigned long long']],
} ],
  '_DEVICE_DSM_DEFINITION' : [ 0x1c, {
    'Action' : [ 0x0, ['unsigned long']],
    'SingleRange' : [ 0x4, ['unsigned char']],
    'ParameterBlockAlignment' : [ 0x8, ['unsigned long']],
    'ParameterBlockLength' : [ 0xc, ['unsigned long']],
    'HasOutput' : [ 0x10, ['unsigned char']],
    'OutputBlockAlignment' : [ 0x14, ['unsigned long']],
    'OutputBlockLength' : [ 0x18, ['unsigned long']],
} ],
  '_DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUT' : [ 0x24, {
    'Size' : [ 0x0, ['unsigned long']],
    'Action' : [ 0x4, ['unsigned long']],
    'Flags' : [ 0x8, ['unsigned long']],
    'OperationStatus' : [ 0xc, ['unsigned long']],
    'ExtendedError' : [ 0x10, ['unsigned long']],
    'TargetDetailedError' : [ 0x14, ['unsigned long']],
    'ReservedStatus' : [ 0x18, ['unsigned long']],
    'OutputBlockOffset' : [ 0x1c, ['unsigned long']],
    'OutputBlockLength' : [ 0x20, ['unsigned long']],
} ],
  '_PEP_ACPI_RESOURCE' : [ 0x48, {
    'Type' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: u'PepAcpiMemory', 1: u'PepAcpiIoPort', 2: u'PepAcpiInterrupt', 3: u'PepAcpiGpioIo', 4: u'PepAcpiGpioInt', 5: u'PepAcpiSpbI2c', 6: u'PepAcpiSpbSpi', 7: u'PepAcpiSpbUart', 8: u'PepAcpiExtendedMemory', 9: u'PepAcpiExtendedIo'})]],
    'IoMemory' : [ 0x0, ['_PEP_ACPI_IO_MEMORY_RESOURCE']],
    'Interrupt' : [ 0x0, ['_PEP_ACPI_INTERRUPT_RESOURCE']],
    'Gpio' : [ 0x0, ['_PEP_ACPI_GPIO_RESOURCE']],
    'SpbI2c' : [ 0x0, ['_PEP_ACPI_SPB_I2C_RESOURCE']],
    'SpbSpi' : [ 0x0, ['_PEP_ACPI_SPB_SPI_RESOURCE']],
    'SpbUart' : [ 0x0, ['_PEP_ACPI_SPB_UART_RESOURCE']],
    'ExtendedAddress' : [ 0x0, ['_PEP_ACPI_EXTENDED_ADDRESS']],
} ],
  '_PEP_ACPI_IO_MEMORY_RESOURCE' : [ 0x20, {
    'Type' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: u'PepAcpiMemory', 1: u'PepAcpiIoPort', 2: u'PepAcpiInterrupt', 3: u'PepAcpiGpioIo', 4: u'PepAcpiGpioInt', 5: u'PepAcpiSpbI2c', 6: u'PepAcpiSpbSpi', 7: u'PepAcpiSpbUart', 8: u'PepAcpiExtendedMemory', 9: u'PepAcpiExtendedIo'})]],
    'Information' : [ 0x4, ['unsigned char']],
    'MinimumAddress' : [ 0x8, ['_LARGE_INTEGER']],
    'MaximumAddress' : [ 0x10, ['_LARGE_INTEGER']],
    'Alignment' : [ 0x18, ['unsigned long']],
    'Length' : [ 0x1c, ['unsigned long']],
} ],
  '_PEP_ACPI_INTERRUPT_RESOURCE' : [ 0x20, {
    'Type' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: u'PepAcpiMemory', 1: u'PepAcpiIoPort', 2: u'PepAcpiInterrupt', 3: u'PepAcpiGpioIo', 4: u'PepAcpiGpioInt', 5: u'PepAcpiSpbI2c', 6: u'PepAcpiSpbSpi', 7: u'PepAcpiSpbUart', 8: u'PepAcpiExtendedMemory', 9: u'PepAcpiExtendedIo'})]],
    'InterruptType' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {0: u'LevelSensitive', 1: u'Latched'})]],
    'InterruptPolarity' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {0: u'InterruptPolarityUnknown', 1: u'InterruptRisingEdge', 2: u'InterruptFallingEdge', 3: u'InterruptActiveBothTriggerLow', 4: u'InterruptActiveBothTriggerHigh'})]],
    'Flags' : [ 0xc, ['_PEP_ACPI_RESOURCE_FLAGS']],
    'Count' : [ 0x10, ['unsigned char']],
    'Pins' : [ 0x18, ['pointer64', ['unsigned long']]],
} ],
  '_PEP_ACPI_GPIO_RESOURCE' : [ 0x48, {
    'Type' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: u'PepAcpiMemory', 1: u'PepAcpiIoPort', 2: u'PepAcpiInterrupt', 3: u'PepAcpiGpioIo', 4: u'PepAcpiGpioInt', 5: u'PepAcpiSpbI2c', 6: u'PepAcpiSpbSpi', 7: u'PepAcpiSpbUart', 8: u'PepAcpiExtendedMemory', 9: u'PepAcpiExtendedIo'})]],
    'Flags' : [ 0x4, ['_PEP_ACPI_RESOURCE_FLAGS']],
    'InterruptType' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {0: u'LevelSensitive', 1: u'Latched'})]],
    'InterruptPolarity' : [ 0xc, ['Enumeration', dict(target = 'long', choices = {0: u'InterruptPolarityUnknown', 1: u'InterruptRisingEdge', 2: u'InterruptFallingEdge', 3: u'InterruptActiveBothTriggerLow', 4: u'InterruptActiveBothTriggerHigh'})]],
    'PinConfig' : [ 0x10, ['Enumeration', dict(target = 'long', choices = {0: u'PullDefault', 1: u'PullUp', 2: u'PullDown', 3: u'PullNone'})]],
    'IoRestrictionType' : [ 0x14, ['Enumeration', dict(target = 'long', choices = {0: u'IoRestrictionNone', 1: u'IoRestrictionInputOnly', 2: u'IoRestrictionOutputOnly', 3: u'IoRestrictionNoneAndPreserve'})]],
    'DriveStrength' : [ 0x18, ['unsigned short']],
    'DebounceTimeout' : [ 0x1a, ['unsigned short']],
    'PinTable' : [ 0x20, ['pointer64', ['unsigned short']]],
    'PinCount' : [ 0x28, ['unsigned short']],
    'ResourceSourceIndex' : [ 0x2a, ['unsigned char']],
    'ResourceSourceName' : [ 0x30, ['pointer64', ['_UNICODE_STRING']]],
    'VendorData' : [ 0x38, ['pointer64', ['unsigned char']]],
    'VendorDataLength' : [ 0x40, ['unsigned short']],
} ],
  '_PEP_ACPI_SPB_I2C_RESOURCE' : [ 0x30, {
    'SpbCommon' : [ 0x0, ['_PEP_ACPI_SPB_RESOURCE']],
    'ConnectionSpeed' : [ 0x28, ['unsigned long']],
    'SlaveAddress' : [ 0x2c, ['unsigned short']],
} ],
  '_PEP_ACPI_SPB_UART_RESOURCE' : [ 0x38, {
    'SpbCommon' : [ 0x0, ['_PEP_ACPI_SPB_RESOURCE']],
    'BaudRate' : [ 0x28, ['unsigned long']],
    'RxBufferSize' : [ 0x2c, ['unsigned short']],
    'TxBufferSize' : [ 0x2e, ['unsigned short']],
    'Parity' : [ 0x30, ['unsigned char']],
    'LinesInUse' : [ 0x31, ['unsigned char']],
} ],
  '_PEP_ACPI_SPB_SPI_RESOURCE' : [ 0x38, {
    'SpbCommon' : [ 0x0, ['_PEP_ACPI_SPB_RESOURCE']],
    'ConnectionSpeed' : [ 0x28, ['unsigned long']],
    'DataBitLength' : [ 0x2c, ['unsigned char']],
    'Phase' : [ 0x2d, ['unsigned char']],
    'Polarity' : [ 0x2e, ['unsigned char']],
    'DeviceSelection' : [ 0x30, ['unsigned short']],
} ],
  '_PEP_ACPI_EXTENDED_ADDRESS' : [ 0x48, {
    'Type' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: u'PepAcpiMemory', 1: u'PepAcpiIoPort', 2: u'PepAcpiInterrupt', 3: u'PepAcpiGpioIo', 4: u'PepAcpiGpioInt', 5: u'PepAcpiSpbI2c', 6: u'PepAcpiSpbSpi', 7: u'PepAcpiSpbUart', 8: u'PepAcpiExtendedMemory', 9: u'PepAcpiExtendedIo'})]],
    'Flags' : [ 0x4, ['_PEP_ACPI_RESOURCE_FLAGS']],
    'ResourceFlags' : [ 0x8, ['unsigned char']],
    'GeneralFlags' : [ 0x9, ['unsigned char']],
    'TypeSpecificFlags' : [ 0xa, ['unsigned char']],
    'RevisionId' : [ 0xb, ['unsigned char']],
    'Reserved' : [ 0xc, ['unsigned char']],
    'Granularity' : [ 0x10, ['unsigned long long']],
    'MinimumAddress' : [ 0x18, ['unsigned long long']],
    'MaximumAddress' : [ 0x20, ['unsigned long long']],
    'TranslationAddress' : [ 0x28, ['unsigned long long']],
    'AddressLength' : [ 0x30, ['unsigned long long']],
    'TypeAttribute' : [ 0x38, ['unsigned long long']],
    'DescriptorName' : [ 0x40, ['pointer64', ['_UNICODE_STRING']]],
} ],
  '_PPM_PLATFORM_STATES' : [ 0x1c0, {
    'StateCount' : [ 0x0, ['unsigned long']],
    'InterfaceVersion' : [ 0x4, ['unsigned long']],
    'ProcessorCount' : [ 0x8, ['unsigned long']],
    'CoordinatedInterface' : [ 0xc, ['unsigned char']],
    'IdleTest' : [ 0x10, ['pointer64', ['void']]],
    'IdlePreExecute' : [ 0x18, ['pointer64', ['void']]],
    'IdleComplete' : [ 0x20, ['pointer64', ['void']]],
    'QueryPlatformStateResidency' : [ 0x28, ['pointer64', ['void']]],
    'Accounting' : [ 0x30, ['pointer64', ['_PLATFORM_IDLE_ACCOUNTING']]],
    'DeepSleepEnabled' : [ 0x38, ['unsigned char']],
    'State' : [ 0x40, ['array', 1, ['_PPM_PLATFORM_STATE']]],
} ],
  '_CPU_INFO' : [ 0x10, {
    'AsUINT32' : [ 0x0, ['array', 4, ['unsigned long']]],
    'Eax' : [ 0x0, ['unsigned long']],
    'Ebx' : [ 0x4, ['unsigned long']],
    'Ecx' : [ 0x8, ['unsigned long']],
    'Edx' : [ 0xc, ['unsigned long']],
} ],
  '_POP_PPM_PROFILE' : [ 0x1550, {
    'Name' : [ 0x0, ['pointer64', ['wchar']]],
    'Id' : [ 0x8, ['unsigned char']],
    'Guid' : [ 0xc, ['_GUID']],
    'Flags' : [ 0x1c, ['unsigned long']],
    'Priority' : [ 0x20, ['unsigned char']],
    'Settings' : [ 0x28, ['array', 2, ['_PPM_ENGINE_SETTINGS']]],
    'StartTime' : [ 0x1528, ['unsigned long long']],
    'Count' : [ 0x1530, ['unsigned long long']],
    'MaxDuration' : [ 0x1538, ['unsigned long long']],
    'MinDuration' : [ 0x1540, ['unsigned long long']],
    'TotalDuration' : [ 0x1548, ['unsigned long long']],
} ],
  '_PPM_ENGINE_SETTINGS' : [ 0xa80, {
    'ExplicitSetting' : [ 0x0, ['array', 2, ['_PPM_POLICY_SETTINGS_MASK']]],
    'ThrottlingPolicy' : [ 0x10, ['unsigned char']],
    'PerfTimeCheck' : [ 0x14, ['unsigned long']],
    'PerfHistoryCount' : [ 0x18, ['array', 2, ['unsigned char']]],
    'PerfMinPolicy' : [ 0x1a, ['array', 2, ['unsigned char']]],
    'PerfMaxPolicy' : [ 0x1c, ['array', 2, ['unsigned char']]],
    'PerfDecreaseTime' : [ 0x1e, ['array', 2, ['unsigned char']]],
    'PerfIncreaseTime' : [ 0x20, ['array', 2, ['unsigned char']]],
    'PerfDecreasePolicy' : [ 0x22, ['array', 2, ['unsigned char']]],
    'PerfIncreasePolicy' : [ 0x24, ['array', 2, ['unsigned char']]],
    'PerfDecreaseThreshold' : [ 0x26, ['array', 2, ['unsigned char']]],
    'PerfIncreaseThreshold' : [ 0x28, ['array', 2, ['unsigned char']]],
    'PerfFrequencyCap' : [ 0x2c, ['array', 2, ['unsigned long']]],
    'PerfBoostPolicy' : [ 0x34, ['unsigned long']],
    'PerfBoostMode' : [ 0x38, ['unsigned long']],
    'PerfReductionTolerance' : [ 0x3c, ['unsigned long']],
    'EnergyPerfPreference' : [ 0x40, ['unsigned long']],
    'AutonomousActivityWindow' : [ 0x44, ['unsigned long']],
    'AutonomousPreference' : [ 0x48, ['unsigned char']],
    'LatencyHintPerf' : [ 0x49, ['array', 2, ['unsigned char']]],
    'LatencyHintUnpark' : [ 0x4b, ['array', 2, ['unsigned char']]],
    'DutyCycling' : [ 0x4d, ['unsigned char']],
    'ParkingPerfState' : [ 0x4e, ['array', 2, ['unsigned char']]],
    'DistributeUtility' : [ 0x50, ['unsigned char']],
    'CoreParkingOverUtilizationThreshold' : [ 0x51, ['unsigned char']],
    'CoreParkingConcurrencyThreshold' : [ 0x52, ['unsigned char']],
    'CoreParkingHeadroomThreshold' : [ 0x53, ['unsigned char']],
    'CoreParkingDistributionThreshold' : [ 0x54, ['unsigned char']],
    'CoreParkingDecreasePolicy' : [ 0x55, ['unsigned char']],
    'CoreParkingIncreasePolicy' : [ 0x56, ['unsigned char']],
    'CoreParkingDecreaseTime' : [ 0x58, ['unsigned long']],
    'CoreParkingIncreaseTime' : [ 0x5c, ['unsigned long']],
    'CoreParkingMinCores' : [ 0x60, ['array', 2, ['unsigned char']]],
    'CoreParkingMaxCores' : [ 0x62, ['array', 2, ['unsigned char']]],
    'AllowScaling' : [ 0x64, ['unsigned char']],
    'IdleDisabled' : [ 0x65, ['unsigned char']],
    'IdleTimeCheck' : [ 0x68, ['unsigned long']],
    'IdleDemotePercent' : [ 0x6c, ['unsigned char']],
    'IdlePromotePercent' : [ 0x6d, ['unsigned char']],
    'IdleStateMax' : [ 0x6e, ['unsigned char']],
    'HeteroDecreaseTime' : [ 0x6f, ['unsigned char']],
    'HeteroIncreaseTime' : [ 0x70, ['unsigned char']],
    'HeteroDecreaseThreshold' : [ 0x71, ['array', 1280, ['unsigned char']]],
    'HeteroIncreaseThreshold' : [ 0x571, ['array', 1280, ['unsigned char']]],
    'Class0FloorPerformance' : [ 0xa71, ['unsigned char']],
    'Class1InitialPerformance' : [ 0xa72, ['unsigned char']],
    'ThreadPolicies' : [ 0xa74, ['array', 2, ['Enumeration', dict(target = 'long', choices = {0: u'KHeteroCpuPolicyAll', 1: u'KHeteroCpuPolicyLarge', 2: u'KHeteroCpuPolicyLargeOrIdle', 3: u'KHeteroCpuPolicySmall', 4: u'KHeteroCpuPolicySmallOrIdle', 5: u'KHeteroCpuPolicyStaticMax', 6: u'KHeteroCpuPolicyBiasedSmall', 7: u'KHeteroCpuPolicyBiasedLarge', 8: u'KHeteroCpuPolicyDefault', 9: u'KHeteroCpuPolicyMax'})]]],
} ],
  '_ESERVERSILO_GLOBALS' : [ 0x480, {
    'ObSiloState' : [ 0x0, ['_OBP_SILODRIVERSTATE']],
    'SeSiloState' : [ 0x2e0, ['_SEP_SILOSTATE']],
    'SeRmSiloState' : [ 0x310, ['_SEP_RM_LSA_CONNECTION_STATE']],
    'EtwSiloState' : [ 0x360, ['pointer64', ['_ETW_SILODRIVERSTATE']]],
    'MiSessionLeaderProcess' : [ 0x368, ['pointer64', ['_EPROCESS']]],
    'ExpDefaultErrorPortProcess' : [ 0x370, ['pointer64', ['_EPROCESS']]],
    'ExpDefaultErrorPort' : [ 0x378, ['pointer64', ['void']]],
    'HardErrorState' : [ 0x380, ['unsigned long']],
    'WnfSiloState' : [ 0x388, ['_WNF_SILODRIVERSTATE']],
    'DbgkSiloState' : [ 0x3c0, ['_DBGK_SILOSTATE']],
    'PsProtectedCurrentDirectory' : [ 0x3e0, ['_UNICODE_STRING']],
    'PsProtectedEnvironment' : [ 0x3f0, ['_UNICODE_STRING']],
    'ApiSetSection' : [ 0x400, ['pointer64', ['void']]],
    'ApiSetSchema' : [ 0x408, ['pointer64', ['void']]],
    'OneCoreForwardersEnabled' : [ 0x410, ['unsigned char']],
    'NtSystemRoot' : [ 0x418, ['_UNICODE_STRING']],
    'SiloRootDirectoryName' : [ 0x428, ['_UNICODE_STRING']],
    'Storage' : [ 0x438, ['pointer64', ['_PSP_STORAGE']]],
    'State' : [ 0x440, ['Enumeration', dict(target = 'long', choices = {0: u'SERVERSILO_INITING', 1: u'SERVERSILO_STARTED', 2: u'SERVERSILO_SHUTTING_DOWN', 3: u'SERVERSILO_TERMINATING', 4: u'SERVERSILO_TERMINATED'})]],
    'ExitStatus' : [ 0x444, ['long']],
    'DeleteEvent' : [ 0x448, ['pointer64', ['_KEVENT']]],
    'UserSharedData' : [ 0x450, ['pointer64', ['_SILO_USER_SHARED_DATA']]],
    'UserSharedSection' : [ 0x458, ['pointer64', ['void']]],
    'TerminateWorkItem' : [ 0x460, ['_WORK_QUEUE_ITEM']],
} ],
  '_SILO_USER_SHARED_DATA' : [ 0x248, {
    'ServiceSessionId' : [ 0x0, ['unsigned long']],
    'ActiveConsoleId' : [ 0x4, ['unsigned long']],
    'ConsoleSessionForegroundProcessId' : [ 0x8, ['long long']],
    'NtProductType' : [ 0x10, ['Enumeration', dict(target = 'long', choices = {1: u'NtProductWinNt', 2: u'NtProductLanManNt', 3: u'NtProductServer'})]],
    'SuiteMask' : [ 0x14, ['unsigned long']],
    'SharedUserSessionId' : [ 0x18, ['unsigned long']],
    'IsMultiSessionSku' : [ 0x1c, ['unsigned char']],
    'NtSystemRoot' : [ 0x1e, ['array', 260, ['wchar']]],
    'UserModeGlobalLogger' : [ 0x226, ['array', 16, ['unsigned short']]],
} ],
  '_POP_FX_COMPONENT_FLAGS' : [ 0x8, {
    'Value' : [ 0x0, ['long']],
    'Value2' : [ 0x4, ['long']],
    'RefCount' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 30, native_type='unsigned long')]],
    'Idling' : [ 0x0, ['BitField', dict(start_bit = 30, end_bit = 31, native_type='unsigned long')]],
    'Active' : [ 0x0, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
    'CriticalIdleOverride' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'ResidentOverride' : [ 0x4, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'Reserved' : [ 0x4, ['BitField', dict(start_bit = 2, end_bit = 32, native_type='unsigned long')]],
} ],
  '_POP_FX_PERF_FLAGS' : [ 0x4, {
    'Value' : [ 0x0, ['long']],
    'Progress' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 3, native_type='unsigned long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 27, native_type='unsigned long')]],
    'Synchronicity' : [ 0x0, ['BitField', dict(start_bit = 27, end_bit = 29, native_type='unsigned long')]],
    'RequestPepCompleted' : [ 0x0, ['BitField', dict(start_bit = 29, end_bit = 30, native_type='unsigned long')]],
    'RequestSucceeded' : [ 0x0, ['BitField', dict(start_bit = 30, end_bit = 31, native_type='unsigned long')]],
    'NestedCallback' : [ 0x0, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
} ],
  '_POP_FX_DEVICE_STATUS' : [ 0x4, {
    'Value' : [ 0x0, ['long']],
    'SystemTransition' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'PepD0Notify' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'IdleTimerOn' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'IgnoreIdleTimeout' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'IrpInUse' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'IrpPending' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'DPNRDeviceNotified' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'DPNRReceivedFromPep' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'IrpFirstPendingIndex' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'IrpLastPendingIndex' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'SIrpBlocked' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'BlockFastResume' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 32, native_type='unsigned long')]],
} ],
  '_POP_RW_LOCK' : [ 0x10, {
    'Lock' : [ 0x0, ['_EX_PUSH_LOCK']],
    'Thread' : [ 0x8, ['pointer64', ['_KTHREAD']]],
} ],
  '_VOLUME_CACHE_MAP' : [ 0xd0, {
    'NodeTypeCode' : [ 0x0, ['short']],
    'NodeByteCode' : [ 0x2, ['short']],
    'UseCount' : [ 0x4, ['unsigned long']],
    'DeviceObject' : [ 0x8, ['pointer64', ['_DEVICE_OBJECT']]],
    'VolumeCacheMapLinks' : [ 0x10, ['_LIST_ENTRY']],
    'DirtyPages' : [ 0x20, ['unsigned long long']],
    'LogHandleContext' : [ 0x28, ['_LOG_HANDLE_CONTEXT']],
    'Flags' : [ 0xc0, ['unsigned long']],
    'PagesQueuedToDisk' : [ 0xc4, ['unsigned long']],
    'LoggedPagesQueuedToDisk' : [ 0xc8, ['unsigned long']],
} ],
  '_SHARED_CACHE_MAP' : [ 0x218, {
    'NodeTypeCode' : [ 0x0, ['short']],
    'NodeByteSize' : [ 0x2, ['short']],
    'OpenCount' : [ 0x4, ['unsigned long']],
    'FileSize' : [ 0x8, ['_LARGE_INTEGER']],
    'BcbList' : [ 0x10, ['_LIST_ENTRY']],
    'SectionSize' : [ 0x20, ['_LARGE_INTEGER']],
    'ValidDataLength' : [ 0x28, ['_LARGE_INTEGER']],
    'ValidDataGoal' : [ 0x30, ['_LARGE_INTEGER']],
    'InitialVacbs' : [ 0x38, ['array', 4, ['pointer64', ['_VACB']]]],
    'Vacbs' : [ 0x58, ['pointer64', ['pointer64', ['_VACB']]]],
    'FileObjectFastRef' : [ 0x60, ['_EX_FAST_REF']],
    'VacbLock' : [ 0x68, ['_EX_PUSH_LOCK']],
    'DirtyPages' : [ 0x70, ['unsigned long']],
    'LoggedStreamLinks' : [ 0x78, ['_LIST_ENTRY']],
    'SharedCacheMapLinks' : [ 0x88, ['_LIST_ENTRY']],
    'Flags' : [ 0x98, ['unsigned long']],
    'Status' : [ 0x9c, ['long']],
    'Mbcb' : [ 0xa0, ['pointer64', ['_MBCB']]],
    'Section' : [ 0xa8, ['pointer64', ['void']]],
    'CreateEvent' : [ 0xb0, ['pointer64', ['_KEVENT']]],
    'WaitOnActiveCount' : [ 0xb8, ['pointer64', ['_KEVENT']]],
    'PagesToWrite' : [ 0xc0, ['unsigned long']],
    'BeyondLastFlush' : [ 0xc8, ['long long']],
    'Callbacks' : [ 0xd0, ['pointer64', ['_CACHE_MANAGER_CALLBACKS']]],
    'LazyWriteContext' : [ 0xd8, ['pointer64', ['void']]],
    'PrivateList' : [ 0xe0, ['_LIST_ENTRY']],
    'V1' : [ 0xf0, ['_LOGGED_STREAM_CALLBACK_V1']],
    'V2' : [ 0xf0, ['_LOGGED_STREAM_CALLBACK_V2']],
    'LargestLSN' : [ 0x100, ['_LARGE_INTEGER']],
    'DirtyPageThreshold' : [ 0x108, ['unsigned long']],
    'LazyWritePassCount' : [ 0x10c, ['unsigned long']],
    'UninitializeEvent' : [ 0x110, ['pointer64', ['_CACHE_UNINITIALIZE_EVENT']]],
    'BcbLock' : [ 0x118, ['_FAST_MUTEX']],
    'LastUnmapBehindOffset' : [ 0x150, ['_LARGE_INTEGER']],
    'Event' : [ 0x158, ['_KEVENT']],
    'HighWaterMappingOffset' : [ 0x170, ['_LARGE_INTEGER']],
    'PrivateCacheMap' : [ 0x178, ['_PRIVATE_CACHE_MAP']],
    'WriteBehindWorkQueueEntry' : [ 0x1f0, ['pointer64', ['void']]],
    'VolumeCacheMap' : [ 0x1f8, ['pointer64', ['_VOLUME_CACHE_MAP']]],
    'ProcImagePathHash' : [ 0x200, ['unsigned long']],
    'WritesInProgress' : [ 0x204, ['unsigned long']],
    'AsyncReadRequestCount' : [ 0x208, ['unsigned long']],
    'Partition' : [ 0x210, ['pointer64', ['_CC_PARTITION']]],
} ],
  '__unnamed_1baf' : [ 0x10, {
    'FileOffset' : [ 0x0, ['_LARGE_INTEGER']],
    'ActiveCount' : [ 0x0, ['unsigned short']],
    'Links' : [ 0x0, ['_LIST_ENTRY']],
} ],
  '_VACB' : [ 0x28, {
    'BaseAddress' : [ 0x0, ['pointer64', ['void']]],
    'SharedCacheMap' : [ 0x8, ['pointer64', ['_SHARED_CACHE_MAP']]],
    'Overlay' : [ 0x10, ['__unnamed_1baf']],
    'ArrayHead' : [ 0x20, ['pointer64', ['_VACB_ARRAY_HEADER']]],
} ],
  '_CC_PARTITION' : [ 0x400, {
    'NodeTypeCode' : [ 0x0, ['short']],
    'NodeByteSize' : [ 0x2, ['short']],
    'PartitionObject' : [ 0x8, ['pointer64', ['_EPARTITION']]],
    'CleanSharedCacheMapList' : [ 0x10, ['_LIST_ENTRY']],
    'CleanSharedCacheMapWithLogHandleList' : [ 0x20, ['_LIST_ENTRY']],
    'DirtySharedCacheMapList' : [ 0x30, ['_SHARED_CACHE_MAP_LIST_CURSOR']],
    'LazyWriteCursor' : [ 0x48, ['_SHARED_CACHE_MAP_LIST_CURSOR']],
    'DirtySharedCacheMapWithLogHandleList' : [ 0x60, ['_LIST_ENTRY']],
    'PrivateLock' : [ 0x80, ['unsigned long long']],
    'ConsecutiveWorklessLazyScanCount' : [ 0x88, ['unsigned long']],
    'ForcedDisableLazywriteScan' : [ 0x8c, ['unsigned char']],
    'WorkQueueLock' : [ 0xc0, ['unsigned long long']],
    'NumberWorkerThreads' : [ 0xc8, ['unsigned long']],
    'NumberActiveWorkerThreads' : [ 0xcc, ['unsigned long']],
    'IdleWorkerThreadList' : [ 0xd0, ['_LIST_ENTRY']],
    'FastTeardownWorkQueue' : [ 0xe0, ['_LIST_ENTRY']],
    'ExpressWorkQueue' : [ 0xf0, ['_LIST_ENTRY']],
    'RegularWorkQueue' : [ 0x100, ['_LIST_ENTRY']],
    'PostTickWorkQueue' : [ 0x110, ['_LIST_ENTRY']],
    'IdleExtraWriteBehindThreadList' : [ 0x120, ['_LIST_ENTRY']],
    'ActiveExtraWriteBehindThreads' : [ 0x130, ['unsigned long']],
    'MaxExtraWriteBehindThreads' : [ 0x134, ['unsigned long']],
    'QueueThrottle' : [ 0x138, ['unsigned char']],
    'PostTickWorkItemCount' : [ 0x13c, ['unsigned long']],
    'ThreadsActiveBeforeThrottle' : [ 0x140, ['unsigned long']],
    'ExtraWBThreadsActiveBeforeThrottle' : [ 0x144, ['unsigned long']],
    'ExecutingWriteBehindWorkItems' : [ 0x148, ['unsigned long']],
    'ExecutingHighPriorityWorkItem' : [ 0x14c, ['unsigned long']],
    'LowMemoryEvent' : [ 0x150, ['_KEVENT']],
    'PowerEvent' : [ 0x168, ['_KEVENT']],
    'PeriodicEvent' : [ 0x180, ['_KEVENT']],
    'WaitingForTeardownEvent' : [ 0x198, ['_KEVENT']],
    'CoalescingFlushEvent' : [ 0x1b0, ['_KEVENT']],
    'PagesYetToWrite' : [ 0x1c8, ['unsigned long']],
    'LazyWriter' : [ 0x1d0, ['_LAZY_WRITER']],
    'DirtyPageStatistics' : [ 0x258, ['_DIRTY_PAGE_STATISTICS']],
    'DirtyPageThresholds' : [ 0x270, ['_DIRTY_PAGE_THRESHOLDS']],
    'ThroughputStats' : [ 0x2a8, ['pointer64', ['_WRITE_BEHIND_THROUGHPUT']]],
    'ThroughputTrend' : [ 0x2b0, ['long']],
    'AverageAvailablePages' : [ 0x2b8, ['unsigned long long']],
    'AverageDirtyPages' : [ 0x2c0, ['unsigned long long']],
    'PagesSkippedDueToHotSpot' : [ 0x2c8, ['unsigned long long']],
    'PrevRegularQueueItemRunTime' : [ 0x2d0, ['_LARGE_INTEGER']],
    'PrevExtraWBThreadCheckTime' : [ 0x2d8, ['_LARGE_INTEGER']],
    'AddExtraWriteBehindThreads' : [ 0x2e0, ['unsigned char']],
    'RemoveExtraThreadPending' : [ 0x2e1, ['unsigned char']],
    'DeferredWrites' : [ 0x2e8, ['_LIST_ENTRY']],
    'DeferredWriteSpinLock' : [ 0x300, ['unsigned long long']],
    'IdleAsyncReadWorkerThreadList' : [ 0x308, ['pointer64', ['_LIST_ENTRY']]],
    'NumberActiveAsyncReadWorkerThreads' : [ 0x310, ['pointer64', ['unsigned long']]],
    'NumberActiveCompleteAsyncReadWorkItems' : [ 0x318, ['pointer64', ['unsigned long']]],
    'AsyncReadWorkQueue' : [ 0x320, ['pointer64', ['_LIST_ENTRY']]],
    'AsyncReadCompletionWorkQueue' : [ 0x328, ['pointer64', ['_LIST_ENTRY']]],
    'NewAsyncReadRequestEvent' : [ 0x330, ['pointer64', ['_KEVENT']]],
    'ReaderThreadsStats' : [ 0x338, ['pointer64', ['_ASYNC_READ_THREAD_STATS']]],
    'AsyncReadWorkQueueLock' : [ 0x340, ['_EX_PUSH_LOCK']],
    'VacbFreeHighPriorityList' : [ 0x348, ['_LIST_ENTRY']],
    'NumberOfFreeHighPriorityVacbs' : [ 0x358, ['unsigned long']],
    'LowPriWorkerThread' : [ 0x360, ['pointer64', ['_ETHREAD']]],
    'LowPriSharedCacheMap' : [ 0x368, ['pointer64', ['_SHARED_CACHE_MAP']]],
    'LowPriOldCpuPriority' : [ 0x370, ['long']],
    'LowPriOldIoPriority' : [ 0x374, ['Enumeration', dict(target = 'long', choices = {0: u'IoPriorityVeryLow', 1: u'IoPriorityLow', 2: u'IoPriorityNormal', 3: u'IoPriorityHigh', 4: u'IoPriorityCritical', 5: u'MaxIoPriorityTypes'})]],
    'LowPriorityWorkerThreadLock' : [ 0x378, ['_EX_PUSH_LOCK']],
    'MaxNumberOfWriteBehindThreads' : [ 0x380, ['unsigned long']],
    'CoalescingState' : [ 0x384, ['unsigned char']],
    'ActivePartition' : [ 0x385, ['unsigned char']],
    'RundownPhase' : [ 0x386, ['unsigned char']],
    'RefCount' : [ 0x388, ['long long']],
    'ExitEvent' : [ 0x390, ['_KEVENT']],
    'FinalDereferenceEvent' : [ 0x3a8, ['_KEVENT']],
    'LazyWriteScanThreadHandle' : [ 0x3c0, ['pointer64', ['void']]],
} ],
  '__unnamed_1bd5' : [ 0x10, {
    'FileObject' : [ 0x0, ['pointer64', ['_FILE_OBJECT']]],
    'DiskIoAttribution' : [ 0x8, ['pointer64', ['void']]],
} ],
  '__unnamed_1bd7' : [ 0x8, {
    'SharedCacheMap' : [ 0x0, ['pointer64', ['_SHARED_CACHE_MAP']]],
} ],
  '__unnamed_1bd9' : [ 0x8, {
    'Event' : [ 0x0, ['pointer64', ['_KEVENT']]],
} ],
  '__unnamed_1bdb' : [ 0x4, {
    'Reason' : [ 0x0, ['unsigned long']],
} ],
  '__unnamed_1bdd' : [ 0x30, {
    'SharedCacheMap' : [ 0x0, ['pointer64', ['_SHARED_CACHE_MAP']]],
    'IoStatus' : [ 0x8, ['pointer64', ['_IO_STATUS_BLOCK']]],
    'CallerWaitEvent' : [ 0x10, ['_KEVENT']],
    'IsLowPriWriteBehind' : [ 0x28, ['unsigned char']],
} ],
  '__unnamed_1be1' : [ 0x68, {
    'SharedCacheMap' : [ 0x0, ['pointer64', ['_SHARED_CACHE_MAP']]],
    'FileOffset' : [ 0x8, ['_LARGE_INTEGER']],
    'FileObject' : [ 0x10, ['pointer64', ['_FILE_OBJECT']]],
    'Length' : [ 0x18, ['unsigned long']],
    'PrefetchList' : [ 0x20, ['pointer64', ['_SINGLE_LIST_ENTRY']]],
    'PrefetchPagePriority' : [ 0x28, ['unsigned long']],
    'Mdl' : [ 0x30, ['pointer64', ['_MDL']]],
    'IoStatusBlock' : [ 0x38, ['pointer64', ['_IO_STATUS_BLOCK']]],
    'CallbackContext' : [ 0x40, ['pointer64', ['_CC_ASYNC_READ_CONTEXT']]],
    'OriginatingProcess' : [ 0x48, ['pointer64', ['_EPROCESS']]],
    'IoIssuerThread' : [ 0x50, ['pointer64', ['_ETHREAD']]],
    'DiskIoAttribution' : [ 0x58, ['pointer64', ['void']]],
    'RequestorMode' : [ 0x60, ['unsigned char']],
    'NestingLevel' : [ 0x64, ['unsigned long']],
} ],
  '__unnamed_1be3' : [ 0x68, {
    'Read' : [ 0x0, ['__unnamed_1bd5']],
    'Write' : [ 0x0, ['__unnamed_1bd7']],
    'Event' : [ 0x0, ['__unnamed_1bd9']],
    'Notification' : [ 0x0, ['__unnamed_1bdb']],
    'LowPriWrite' : [ 0x0, ['__unnamed_1bdd']],
    'AsyncRead' : [ 0x0, ['__unnamed_1be1']],
} ],
  '_WORK_QUEUE_ENTRY' : [ 0x88, {
    'WorkQueueLinks' : [ 0x0, ['_LIST_ENTRY']],
    'Parameters' : [ 0x10, ['__unnamed_1be3']],
    'Function' : [ 0x78, ['unsigned char']],
    'Partition' : [ 0x80, ['pointer64', ['_CC_PARTITION']]],
} ],
  '_DEFERRED_WRITE' : [ 0x50, {
    'NodeTypeCode' : [ 0x0, ['short']],
    'NodeByteSize' : [ 0x2, ['short']],
    'FileObject' : [ 0x8, ['pointer64', ['_FILE_OBJECT']]],
    'BytesToWrite' : [ 0x10, ['unsigned long']],
    'DeferredWriteLinks' : [ 0x18, ['_LIST_ENTRY']],
    'Event' : [ 0x28, ['pointer64', ['_KEVENT']]],
    'PostRoutine' : [ 0x30, ['pointer64', ['void']]],
    'Context1' : [ 0x38, ['pointer64', ['void']]],
    'Context2' : [ 0x40, ['pointer64', ['void']]],
    'Partition' : [ 0x48, ['pointer64', ['_CC_PARTITION']]],
} ],
  '_SECTION_OBJECT_POINTERS' : [ 0x18, {
    'DataSectionObject' : [ 0x0, ['pointer64', ['void']]],
    'SharedCacheMap' : [ 0x8, ['pointer64', ['void']]],
    'ImageSectionObject' : [ 0x10, ['pointer64', ['void']]],
} ],
  '_CC_EXTERNAL_CACHE_INFO' : [ 0x30, {
    'Callback' : [ 0x0, ['pointer64', ['void']]],
    'DirtyPageStatistics' : [ 0x8, ['_DIRTY_PAGE_STATISTICS']],
    'Links' : [ 0x20, ['_LIST_ENTRY']],
} ],
  'VACB_LEVEL_ALLOCATION_LIST' : [ 0x20, {
    'VacbLevelList' : [ 0x0, ['_LIST_ENTRY']],
    'VacbLevelWithBcbListHeads' : [ 0x10, ['pointer64', ['void']]],
    'VacbLevelsAllocated' : [ 0x18, ['unsigned long']],
} ],
  '_VACB_LEVEL_REFERENCE' : [ 0x8, {
    'Reference' : [ 0x0, ['long']],
    'SpecialReference' : [ 0x4, ['long']],
} ],
  '_LOG_HANDLE_CONTEXT' : [ 0x98, {
    'LogHandle' : [ 0x0, ['pointer64', ['void']]],
    'FlushToLsnRoutine' : [ 0x8, ['pointer64', ['void']]],
    'QueryLogHandleInfoRoutine' : [ 0x10, ['pointer64', ['void']]],
    'DirtyPageStatistics' : [ 0x18, ['_DIRTY_PAGE_STATISTICS']],
    'DirtyPageThresholds' : [ 0x30, ['_DIRTY_PAGE_THRESHOLDS']],
    'AdditionalPagesToWrite' : [ 0x68, ['unsigned long']],
    'CcLWScanDPThreshold' : [ 0x6c, ['unsigned long']],
    'LargestLsnForCurrentLWScan' : [ 0x70, ['_LARGE_INTEGER']],
    'RelatedFileObject' : [ 0x78, ['pointer64', ['_FILE_OBJECT']]],
    'LargestLsnFileObjectKey' : [ 0x80, ['unsigned long long']],
    'LastLWTimeStamp' : [ 0x88, ['_LARGE_INTEGER']],
    'Flags' : [ 0x90, ['unsigned long']],
} ],
  '_MBCB' : [ 0xc0, {
    'NodeTypeCode' : [ 0x0, ['short']],
    'NodeIsInZone' : [ 0x2, ['short']],
    'PagesToWrite' : [ 0x4, ['unsigned long']],
    'DirtyPages' : [ 0x8, ['unsigned long']],
    'Reserved' : [ 0xc, ['unsigned long']],
    'BitmapRanges' : [ 0x10, ['_LIST_ENTRY']],
    'ResumeWritePage' : [ 0x20, ['long long']],
    'MostRecentlyDirtiedPage' : [ 0x28, ['long long']],
    'BitmapRange1' : [ 0x30, ['_BITMAP_RANGE']],
    'BitmapRange2' : [ 0x60, ['_BITMAP_RANGE']],
    'BitmapRange3' : [ 0x90, ['_BITMAP_RANGE']],
} ],
  '_BITMAP_RANGE' : [ 0x30, {
    'Links' : [ 0x0, ['_LIST_ENTRY']],
    'BasePage' : [ 0x10, ['long long']],
    'FirstDirtyPage' : [ 0x18, ['unsigned long']],
    'LastDirtyPage' : [ 0x1c, ['unsigned long']],
    'DirtyPages' : [ 0x20, ['unsigned long']],
    'Bitmap' : [ 0x28, ['pointer64', ['unsigned long']]],
} ],
  '_SHARED_CACHE_MAP_LIST_CURSOR' : [ 0x18, {
    'SharedCacheMapLinks' : [ 0x0, ['_LIST_ENTRY']],
    'Flags' : [ 0x10, ['unsigned long']],
} ],
  '_LAZY_WRITER' : [ 0x88, {
    'ScanDpc' : [ 0x0, ['_KDPC']],
    'ScanTimer' : [ 0x40, ['_KTIMER']],
    'ScanActive' : [ 0x80, ['unsigned char']],
    'OtherWork' : [ 0x81, ['unsigned char']],
    'PendingTeardownScan' : [ 0x82, ['unsigned char']],
    'PendingPeriodicScan' : [ 0x83, ['unsigned char']],
    'PendingLowMemoryScan' : [ 0x84, ['unsigned char']],
    'PendingPowerScan' : [ 0x85, ['unsigned char']],
    'PendingCoalescingFlushScan' : [ 0x86, ['unsigned char']],
} ],
  '_CACHE_UNINITIALIZE_EVENT' : [ 0x20, {
    'Next' : [ 0x0, ['pointer64', ['_CACHE_UNINITIALIZE_EVENT']]],
    'Event' : [ 0x8, ['_KEVENT']],
} ],
  '_HEAP_SUBALLOCATOR_CALLBACKS' : [ 0x28, {
    'Allocate' : [ 0x0, ['unsigned long long']],
    'Free' : [ 0x8, ['unsigned long long']],
    'Commit' : [ 0x10, ['unsigned long long']],
    'Decommit' : [ 0x18, ['unsigned long long']],
    'ExtendContext' : [ 0x20, ['unsigned long long']],
} ],
  '_SEGMENT_HEAP_EXTRA' : [ 0x10, {
    'AllocationTag' : [ 0x0, ['unsigned short']],
    'InterceptorIndex' : [ 0x2, ['BitField', dict(start_bit = 0, end_bit = 4, native_type='unsigned char')]],
    'UserFlags' : [ 0x2, ['BitField', dict(start_bit = 4, end_bit = 8, native_type='unsigned char')]],
    'ExtraSizeInUnits' : [ 0x3, ['unsigned char']],
    'Settable' : [ 0x8, ['pointer64', ['void']]],
} ],
  '_RTL_CSPARSE_BITMAP' : [ 0x40, {
    'CommitDirectory' : [ 0x0, ['unsigned long long']],
    'CommitBitmap' : [ 0x8, ['pointer64', ['unsigned long long']]],
    'UserBitmap' : [ 0x10, ['pointer64', ['unsigned long long']]],
    'BitCount' : [ 0x18, ['long long']],
    'BitmapLock' : [ 0x20, ['unsigned long long']],
    'DecommitPageIndex' : [ 0x28, ['unsigned long long']],
    'RtlpCSparseBitmapWakeLock' : [ 0x30, ['unsigned long long']],
    'LockType' : [ 0x38, ['unsigned char']],
    'AddressSpace' : [ 0x39, ['unsigned char']],
    'MemType' : [ 0x3a, ['unsigned char']],
    'AllocAlignment' : [ 0x3b, ['unsigned char']],
} ],
  '_RTL_SPARSE_ARRAY' : [ 0x50, {
    'Bitmap' : [ 0x0, ['_RTL_CSPARSE_BITMAP']],
    'ElementCount' : [ 0x40, ['unsigned long long']],
    'ElementSizeShift' : [ 0x48, ['unsigned long']],
} ],
  '_HEAP_VAMGR_ALLOCATOR' : [ 0x30, {
    'TreeLock' : [ 0x0, ['unsigned long long']],
    'FreeRanges' : [ 0x8, ['_RTL_RB_TREE']],
    'VaSpace' : [ 0x18, ['pointer64', ['_HEAP_VAMGR_VASPACE']]],
    'PartitionHandle' : [ 0x20, ['pointer64', ['void']]],
    'ChunksPerRegion' : [ 0x28, ['unsigned short']],
    'RefCount' : [ 0x2a, ['unsigned short']],
    'AllocatorIndex' : [ 0x2c, ['unsigned char']],
    'NumaNode' : [ 0x2d, ['unsigned char']],
    'LockType' : [ 0x2e, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'MemoryType' : [ 0x2e, ['BitField', dict(start_bit = 1, end_bit = 3, native_type='unsigned char')]],
    'ConstrainedVA' : [ 0x2e, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'AllowFreeHead' : [ 0x2e, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'Spare0' : [ 0x2e, ['BitField', dict(start_bit = 5, end_bit = 8, native_type='unsigned char')]],
    'Spare1' : [ 0x2f, ['unsigned char']],
} ],
  '_HEAP_VAMGR_VASPACE' : [ 0x60, {
    'AddressSpaceType' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: u'HeapAddressUser', 1: u'HeapAddressKernel', 2: u'HeapAddressSession', 3: u'HeapAddressTypeMax'})]],
    'BaseAddress' : [ 0x8, ['unsigned long long']],
    'VaRangeArray' : [ 0x10, ['_RTL_SPARSE_ARRAY']],
} ],
  '_HEAP_VAMGR_RANGE' : [ 0x20, {
    'RbNode' : [ 0x0, ['_RTL_BALANCED_NODE']],
    'Next' : [ 0x0, ['_SINGLE_LIST_ENTRY']],
    'Allocated' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'Internal' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'Standalone' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'Spare0' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 8, native_type='unsigned char')]],
    'AllocatorIndex' : [ 0x1, ['unsigned char']],
    'OwnerCtx' : [ 0x8, ['unsigned long long']],
    'Spare1' : [ 0x10, ['unsigned long long']],
    'SizeInChunks' : [ 0x18, ['unsigned long long']],
    'ChunkCount' : [ 0x18, ['unsigned short']],
    'PrevChunkCount' : [ 0x1a, ['unsigned short']],
    'Signature' : [ 0x18, ['unsigned long long']],
} ],
  '_RTLP_HP_HEAP_MANAGER' : [ 0x30d0, {
    'Globals' : [ 0x0, ['pointer64', ['_RTLP_HP_HEAP_GLOBALS']]],
    'AllocTracker' : [ 0x8, ['_RTLP_HP_ALLOC_TRACKER']],
    'VaMgr' : [ 0x50, ['_HEAP_VAMGR_CTX']],
    'MetadataHeaps' : [ 0x3090, ['array', 3, ['_RTLP_HP_METADATA_HEAP_CTX']]],
    'SubAllocConfigs' : [ 0x30c0, ['_RTL_HP_SUB_ALLOCATOR_CONFIGS']],
} ],
  '_RTLP_HP_ALLOC_TRACKER' : [ 0x48, {
    'AllocTrackerBitmap' : [ 0x0, ['_RTL_CSPARSE_BITMAP']],
    'BaseAddress' : [ 0x40, ['unsigned long long']],
} ],
  '_HEAP_LIST_LOOKUP' : [ 0x38, {
    'ExtendedLookup' : [ 0x0, ['pointer64', ['_HEAP_LIST_LOOKUP']]],
    'ArraySize' : [ 0x8, ['unsigned long']],
    'ExtraItem' : [ 0xc, ['unsigned long']],
    'ItemCount' : [ 0x10, ['unsigned long']],
    'OutOfRangeItems' : [ 0x14, ['unsigned long']],
    'BaseIndex' : [ 0x18, ['unsigned long']],
    'ListHead' : [ 0x20, ['pointer64', ['_LIST_ENTRY']]],
    'ListsInUseUlong' : [ 0x28, ['pointer64', ['unsigned long']]],
    'ListHints' : [ 0x30, ['pointer64', ['pointer64', ['_LIST_ENTRY']]]],
} ],
  '_HEAP' : [ 0x2a0, {
    'Segment' : [ 0x0, ['_HEAP_SEGMENT']],
    'Entry' : [ 0x0, ['_HEAP_ENTRY']],
    'SegmentSignature' : [ 0x10, ['unsigned long']],
    'SegmentFlags' : [ 0x14, ['unsigned long']],
    'SegmentListEntry' : [ 0x18, ['_LIST_ENTRY']],
    'Heap' : [ 0x28, ['pointer64', ['_HEAP']]],
    'BaseAddress' : [ 0x30, ['pointer64', ['void']]],
    'NumberOfPages' : [ 0x38, ['unsigned long']],
    'FirstEntry' : [ 0x40, ['pointer64', ['_HEAP_ENTRY']]],
    'LastValidEntry' : [ 0x48, ['pointer64', ['_HEAP_ENTRY']]],
    'NumberOfUnCommittedPages' : [ 0x50, ['unsigned long']],
    'NumberOfUnCommittedRanges' : [ 0x54, ['unsigned long']],
    'SegmentAllocatorBackTraceIndex' : [ 0x58, ['unsigned short']],
    'Reserved' : [ 0x5a, ['unsigned short']],
    'UCRSegmentList' : [ 0x60, ['_LIST_ENTRY']],
    'Flags' : [ 0x70, ['unsigned long']],
    'ForceFlags' : [ 0x74, ['unsigned long']],
    'CompatibilityFlags' : [ 0x78, ['unsigned long']],
    'EncodeFlagMask' : [ 0x7c, ['unsigned long']],
    'Encoding' : [ 0x80, ['_HEAP_ENTRY']],
    'Interceptor' : [ 0x90, ['unsigned long']],
    'VirtualMemoryThreshold' : [ 0x94, ['unsigned long']],
    'Signature' : [ 0x98, ['unsigned long']],
    'SegmentReserve' : [ 0xa0, ['unsigned long long']],
    'SegmentCommit' : [ 0xa8, ['unsigned long long']],
    'DeCommitFreeBlockThreshold' : [ 0xb0, ['unsigned long long']],
    'DeCommitTotalFreeThreshold' : [ 0xb8, ['unsigned long long']],
    'TotalFreeSize' : [ 0xc0, ['unsigned long long']],
    'MaximumAllocationSize' : [ 0xc8, ['unsigned long long']],
    'ProcessHeapsListIndex' : [ 0xd0, ['unsigned short']],
    'HeaderValidateLength' : [ 0xd2, ['unsigned short']],
    'HeaderValidateCopy' : [ 0xd8, ['pointer64', ['void']]],
    'NextAvailableTagIndex' : [ 0xe0, ['unsigned short']],
    'MaximumTagIndex' : [ 0xe2, ['unsigned short']],
    'TagEntries' : [ 0xe8, ['pointer64', ['_HEAP_TAG_ENTRY']]],
    'UCRList' : [ 0xf0, ['_LIST_ENTRY']],
    'AlignRound' : [ 0x100, ['unsigned long long']],
    'AlignMask' : [ 0x108, ['unsigned long long']],
    'VirtualAllocdBlocks' : [ 0x110, ['_LIST_ENTRY']],
    'SegmentList' : [ 0x120, ['_LIST_ENTRY']],
    'AllocatorBackTraceIndex' : [ 0x130, ['unsigned short']],
    'NonDedicatedListLength' : [ 0x134, ['unsigned long']],
    'BlocksIndex' : [ 0x138, ['pointer64', ['void']]],
    'UCRIndex' : [ 0x140, ['pointer64', ['void']]],
    'PseudoTagEntries' : [ 0x148, ['pointer64', ['_HEAP_PSEUDO_TAG_ENTRY']]],
    'FreeLists' : [ 0x150, ['_LIST_ENTRY']],
    'LockVariable' : [ 0x160, ['pointer64', ['_HEAP_LOCK']]],
    'CommitRoutine' : [ 0x168, ['pointer64', ['void']]],
    'StackTraceInitVar' : [ 0x170, ['_RTL_RUN_ONCE']],
    'FrontEndHeap' : [ 0x178, ['pointer64', ['void']]],
    'FrontHeapLockCount' : [ 0x180, ['unsigned short']],
    'FrontEndHeapType' : [ 0x182, ['unsigned char']],
    'RequestedFrontEndHeapType' : [ 0x183, ['unsigned char']],
    'FrontEndHeapUsageData' : [ 0x188, ['pointer64', ['unsigned short']]],
    'FrontEndHeapMaximumIndex' : [ 0x190, ['unsigned short']],
    'FrontEndHeapStatusBitmap' : [ 0x192, ['array', 129, ['unsigned char']]],
    'Counters' : [ 0x218, ['_HEAP_COUNTERS']],
    'TuningParameters' : [ 0x290, ['_HEAP_TUNING_PARAMETERS']],
} ],
  '__unnamed_1cdc' : [ 0x68, {
    'CriticalSection' : [ 0x0, ['_RTL_CRITICAL_SECTION']],
    'Resource' : [ 0x0, ['_ERESOURCE']],
} ],
  '_HEAP_LOCK' : [ 0x68, {
    'Lock' : [ 0x0, ['__unnamed_1cdc']],
} ],
  '_HEAP_ENTRY' : [ 0x10, {
    'UnpackedEntry' : [ 0x0, ['_HEAP_UNPACKED_ENTRY']],
    'PreviousBlockPrivateData' : [ 0x0, ['pointer64', ['void']]],
    'Size' : [ 0x8, ['unsigned short']],
    'Flags' : [ 0xa, ['unsigned char']],
    'SmallTagIndex' : [ 0xb, ['unsigned char']],
    'SubSegmentCode' : [ 0x8, ['unsigned long']],
    'PreviousSize' : [ 0xc, ['unsigned short']],
    'SegmentOffset' : [ 0xe, ['unsigned char']],
    'LFHFlags' : [ 0xe, ['unsigned char']],
    'UnusedBytes' : [ 0xf, ['unsigned char']],
    'CompactHeader' : [ 0x8, ['unsigned long long']],
    'ExtendedEntry' : [ 0x0, ['_HEAP_EXTENDED_ENTRY']],
    'Reserved' : [ 0x0, ['pointer64', ['void']]],
    'FunctionIndex' : [ 0x8, ['unsigned short']],
    'ContextValue' : [ 0xa, ['unsigned short']],
    'InterceptorValue' : [ 0x8, ['unsigned long']],
    'UnusedBytesLength' : [ 0xc, ['unsigned short']],
    'EntryOffset' : [ 0xe, ['unsigned char']],
    'ExtendedBlockSignature' : [ 0xf, ['unsigned char']],
    'ReservedForAlignment' : [ 0x0, ['pointer64', ['void']]],
    'Code1' : [ 0x8, ['unsigned long']],
    'Code2' : [ 0xc, ['unsigned short']],
    'Code3' : [ 0xe, ['unsigned char']],
    'Code4' : [ 0xf, ['unsigned char']],
    'Code234' : [ 0xc, ['unsigned long']],
    'AgregateCode' : [ 0x8, ['unsigned long long']],
} ],
  '_HEAP_SEGMENT' : [ 0x70, {
    'Entry' : [ 0x0, ['_HEAP_ENTRY']],
    'SegmentSignature' : [ 0x10, ['unsigned long']],
    'SegmentFlags' : [ 0x14, ['unsigned long']],
    'SegmentListEntry' : [ 0x18, ['_LIST_ENTRY']],
    'Heap' : [ 0x28, ['pointer64', ['_HEAP']]],
    'BaseAddress' : [ 0x30, ['pointer64', ['void']]],
    'NumberOfPages' : [ 0x38, ['unsigned long']],
    'FirstEntry' : [ 0x40, ['pointer64', ['_HEAP_ENTRY']]],
    'LastValidEntry' : [ 0x48, ['pointer64', ['_HEAP_ENTRY']]],
    'NumberOfUnCommittedPages' : [ 0x50, ['unsigned long']],
    'NumberOfUnCommittedRanges' : [ 0x54, ['unsigned long']],
    'SegmentAllocatorBackTraceIndex' : [ 0x58, ['unsigned short']],
    'Reserved' : [ 0x5a, ['unsigned short']],
    'UCRSegmentList' : [ 0x60, ['_LIST_ENTRY']],
} ],
  '_HEAP_VIRTUAL_ALLOC_ENTRY' : [ 0x40, {
    'Entry' : [ 0x0, ['_LIST_ENTRY']],
    'ExtraStuff' : [ 0x10, ['_HEAP_ENTRY_EXTRA']],
    'CommitSize' : [ 0x20, ['unsigned long long']],
    'ReserveSize' : [ 0x28, ['unsigned long long']],
    'BusyBlock' : [ 0x30, ['_HEAP_ENTRY']],
} ],
  '_HEAP_FREE_ENTRY' : [ 0x20, {
    'HeapEntry' : [ 0x0, ['_HEAP_ENTRY']],
    'UnpackedEntry' : [ 0x0, ['_HEAP_UNPACKED_ENTRY']],
    'PreviousBlockPrivateData' : [ 0x0, ['pointer64', ['void']]],
    'Size' : [ 0x8, ['unsigned short']],
    'Flags' : [ 0xa, ['unsigned char']],
    'SmallTagIndex' : [ 0xb, ['unsigned char']],
    'SubSegmentCode' : [ 0x8, ['unsigned long']],
    'PreviousSize' : [ 0xc, ['unsigned short']],
    'SegmentOffset' : [ 0xe, ['unsigned char']],
    'LFHFlags' : [ 0xe, ['unsigned char']],
    'UnusedBytes' : [ 0xf, ['unsigned char']],
    'CompactHeader' : [ 0x8, ['unsigned long long']],
    'ExtendedEntry' : [ 0x0, ['_HEAP_EXTENDED_ENTRY']],
    'Reserved' : [ 0x0, ['pointer64', ['void']]],
    'FunctionIndex' : [ 0x8, ['unsigned short']],
    'ContextValue' : [ 0xa, ['unsigned short']],
    'InterceptorValue' : [ 0x8, ['unsigned long']],
    'UnusedBytesLength' : [ 0xc, ['unsigned short']],
    'EntryOffset' : [ 0xe, ['unsigned char']],
    'ExtendedBlockSignature' : [ 0xf, ['unsigned char']],
    'ReservedForAlignment' : [ 0x0, ['pointer64', ['void']]],
    'Code1' : [ 0x8, ['unsigned long']],
    'Code2' : [ 0xc, ['unsigned short']],
    'Code3' : [ 0xe, ['unsigned char']],
    'Code4' : [ 0xf, ['unsigned char']],
    'Code234' : [ 0xc, ['unsigned long']],
    'AgregateCode' : [ 0x8, ['unsigned long long']],
    'FreeList' : [ 0x10, ['_LIST_ENTRY']],
} ],
  '_RTLP_HP_PADDING_HEADER' : [ 0x10, {
    'PaddingSize' : [ 0x0, ['unsigned long long']],
    'Spare' : [ 0x8, ['unsigned long long']],
} ],
  '__unnamed_1d2f' : [ 0x4, {
    'DataLength' : [ 0x0, ['short']],
    'TotalLength' : [ 0x2, ['short']],
} ],
  '__unnamed_1d31' : [ 0x4, {
    's1' : [ 0x0, ['__unnamed_1d2f']],
    'Length' : [ 0x0, ['unsigned long']],
} ],
  '__unnamed_1d33' : [ 0x4, {
    'Type' : [ 0x0, ['short']],
    'DataInfoOffset' : [ 0x2, ['short']],
} ],
  '__unnamed_1d35' : [ 0x4, {
    's2' : [ 0x0, ['__unnamed_1d33']],
    'ZeroInit' : [ 0x0, ['unsigned long']],
} ],
  '_PORT_MESSAGE' : [ 0x28, {
    'u1' : [ 0x0, ['__unnamed_1d31']],
    'u2' : [ 0x4, ['__unnamed_1d35']],
    'ClientId' : [ 0x8, ['_CLIENT_ID']],
    'DoNotUseThisField' : [ 0x8, ['double']],
    'MessageId' : [ 0x18, ['unsigned long']],
    'ClientViewSize' : [ 0x20, ['unsigned long long']],
    'CallbackId' : [ 0x20, ['unsigned long']],
} ],
  '_ALPC_MESSAGE_ATTRIBUTES' : [ 0x8, {
    'AllocatedAttributes' : [ 0x0, ['unsigned long']],
    'ValidAttributes' : [ 0x4, ['unsigned long']],
} ],
  '_ALPC_HANDLE_ENTRY' : [ 0x8, {
    'Object' : [ 0x0, ['pointer64', ['void']]],
} ],
  '_BLOB_TYPE' : [ 0x38, {
    'ResourceId' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: u'BLOB_TYPE_UNKNOWN', 1: u'BLOB_TYPE_CONNECTION_INFO', 2: u'BLOB_TYPE_MESSAGE', 3: u'BLOB_TYPE_SECURITY_CONTEXT', 4: u'BLOB_TYPE_SECTION', 5: u'BLOB_TYPE_REGION', 6: u'BLOB_TYPE_VIEW', 7: u'BLOB_TYPE_RESERVE', 8: u'BLOB_TYPE_DIRECT_TRANSFER', 9: u'BLOB_TYPE_HANDLE_DATA', 10: u'BLOB_TYPE_MAX_ID'})]],
    'PoolTag' : [ 0x4, ['unsigned long']],
    'LookasideIndex' : [ 0x8, ['unsigned long']],
    'Flags' : [ 0xc, ['unsigned long']],
    'Counters' : [ 0x10, ['pointer64', ['_BLOB_COUNTERS']]],
    'CleanupProcedure' : [ 0x18, ['pointer64', ['void']]],
    'DeleteProcedure' : [ 0x20, ['pointer64', ['void']]],
    'DestroyProcedure' : [ 0x28, ['pointer64', ['void']]],
    'UsualSize' : [ 0x30, ['unsigned long long']],
} ],
  '__unnamed_1d50' : [ 0x1, {
    'ReferenceCache' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'Lookaside' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'Initializing' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'Deleted' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
} ],
  '__unnamed_1d52' : [ 0x1, {
    's1' : [ 0x0, ['__unnamed_1d50']],
    'Flags' : [ 0x0, ['unsigned char']],
} ],
  '_BLOB' : [ 0x30, {
    'ResourceList' : [ 0x0, ['_LIST_ENTRY']],
    'FreeListEntry' : [ 0x0, ['_SLIST_ENTRY']],
    'u1' : [ 0x10, ['__unnamed_1d52']],
    'ResourceId' : [ 0x11, ['unsigned char']],
    'CachedReferences' : [ 0x12, ['short']],
    'ReferenceCount' : [ 0x18, ['long long']],
    'Lock' : [ 0x20, ['_EX_PUSH_LOCK']],
} ],
  '__unnamed_1d66' : [ 0x4, {
    'Internal' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Secure' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
} ],
  '__unnamed_1d68' : [ 0x4, {
    's1' : [ 0x0, ['__unnamed_1d66']],
} ],
  '_KALPC_SECTION' : [ 0x48, {
    'SectionObject' : [ 0x0, ['pointer64', ['void']]],
    'Size' : [ 0x8, ['unsigned long long']],
    'HandleTable' : [ 0x10, ['pointer64', ['_ALPC_HANDLE_TABLE']]],
    'SectionHandle' : [ 0x18, ['pointer64', ['void']]],
    'OwnerProcess' : [ 0x20, ['pointer64', ['_EPROCESS']]],
    'OwnerPort' : [ 0x28, ['pointer64', ['_ALPC_PORT']]],
    'u1' : [ 0x30, ['__unnamed_1d68']],
    'NumberOfRegions' : [ 0x34, ['unsigned long']],
    'RegionListHead' : [ 0x38, ['_LIST_ENTRY']],
} ],
  '__unnamed_1d71' : [ 0x4, {
    'Secure' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
} ],
  '__unnamed_1d73' : [ 0x4, {
    's1' : [ 0x0, ['__unnamed_1d71']],
} ],
  '_KALPC_REGION' : [ 0x58, {
    'RegionListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'Section' : [ 0x10, ['pointer64', ['_KALPC_SECTION']]],
    'Offset' : [ 0x18, ['unsigned long long']],
    'Size' : [ 0x20, ['unsigned long long']],
    'ViewSize' : [ 0x28, ['unsigned long long']],
    'u1' : [ 0x30, ['__unnamed_1d73']],
    'NumberOfViews' : [ 0x34, ['unsigned long']],
    'ViewListHead' : [ 0x38, ['_LIST_ENTRY']],
    'ReadOnlyView' : [ 0x48, ['pointer64', ['_KALPC_VIEW']]],
    'ReadWriteView' : [ 0x50, ['pointer64', ['_KALPC_VIEW']]],
} ],
  '__unnamed_1d79' : [ 0x4, {
    'WriteAccess' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'AutoRelease' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'ForceUnlink' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'SystemSpace' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
} ],
  '__unnamed_1d7b' : [ 0x4, {
    's1' : [ 0x0, ['__unnamed_1d79']],
} ],
  '_KALPC_VIEW' : [ 0x60, {
    'ViewListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'Region' : [ 0x10, ['pointer64', ['_KALPC_REGION']]],
    'OwnerPort' : [ 0x18, ['pointer64', ['_ALPC_PORT']]],
    'OwnerProcess' : [ 0x20, ['pointer64', ['_EPROCESS']]],
    'Address' : [ 0x28, ['pointer64', ['void']]],
    'Size' : [ 0x30, ['unsigned long long']],
    'SecureViewHandle' : [ 0x38, ['pointer64', ['void']]],
    'WriteAccessHandle' : [ 0x40, ['pointer64', ['void']]],
    'u1' : [ 0x48, ['__unnamed_1d7b']],
    'NumberOfOwnerMessages' : [ 0x4c, ['unsigned long']],
    'ProcessViewListEntry' : [ 0x50, ['_LIST_ENTRY']],
} ],
  '_ALPC_COMMUNICATION_INFO' : [ 0x48, {
    'ConnectionPort' : [ 0x0, ['pointer64', ['_ALPC_PORT']]],
    'ServerCommunicationPort' : [ 0x8, ['pointer64', ['_ALPC_PORT']]],
    'ClientCommunicationPort' : [ 0x10, ['pointer64', ['_ALPC_PORT']]],
    'CommunicationList' : [ 0x18, ['_LIST_ENTRY']],
    'HandleTable' : [ 0x28, ['_ALPC_HANDLE_TABLE']],
    'CloseMessage' : [ 0x40, ['pointer64', ['_KALPC_MESSAGE']]],
} ],
  '__unnamed_1d99' : [ 0x4, {
    'Initialized' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Type' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 3, native_type='unsigned long')]],
    'ConnectionPending' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'ConnectionRefused' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'Disconnected' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'Closed' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'NoFlushOnClose' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'ReturnExtendedInfo' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'Waitable' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'DynamicSecurity' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'Wow64CompletionList' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'Lpc' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long')]],
    'LpcToLpc' : [ 0x0, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long')]],
    'HasCompletionList' : [ 0x0, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long')]],
    'HadCompletionList' : [ 0x0, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'EnableCompletionList' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
} ],
  '__unnamed_1d9b' : [ 0x4, {
    's1' : [ 0x0, ['__unnamed_1d99']],
    'State' : [ 0x0, ['unsigned long']],
} ],
  '_ALPC_PORT' : [ 0x1d8, {
    'PortListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'CommunicationInfo' : [ 0x10, ['pointer64', ['_ALPC_COMMUNICATION_INFO']]],
    'OwnerProcess' : [ 0x18, ['pointer64', ['_EPROCESS']]],
    'CompletionPort' : [ 0x20, ['pointer64', ['void']]],
    'CompletionKey' : [ 0x28, ['pointer64', ['void']]],
    'CompletionPacketLookaside' : [ 0x30, ['pointer64', ['_ALPC_COMPLETION_PACKET_LOOKASIDE']]],
    'PortContext' : [ 0x38, ['pointer64', ['void']]],
    'StaticSecurity' : [ 0x40, ['_SECURITY_CLIENT_CONTEXT']],
    'IncomingQueueLock' : [ 0x88, ['_EX_PUSH_LOCK']],
    'MainQueue' : [ 0x90, ['_LIST_ENTRY']],
    'LargeMessageQueue' : [ 0xa0, ['_LIST_ENTRY']],
    'PendingQueueLock' : [ 0xb0, ['_EX_PUSH_LOCK']],
    'PendingQueue' : [ 0xb8, ['_LIST_ENTRY']],
    'DirectQueueLock' : [ 0xc8, ['_EX_PUSH_LOCK']],
    'DirectQueue' : [ 0xd0, ['_LIST_ENTRY']],
    'WaitQueueLock' : [ 0xe0, ['_EX_PUSH_LOCK']],
    'WaitQueue' : [ 0xe8, ['_LIST_ENTRY']],
    'Semaphore' : [ 0xf8, ['pointer64', ['_KSEMAPHORE']]],
    'DummyEvent' : [ 0xf8, ['pointer64', ['_KEVENT']]],
    'PortAttributes' : [ 0x100, ['_ALPC_PORT_ATTRIBUTES']],
    'ResourceListLock' : [ 0x148, ['_EX_PUSH_LOCK']],
    'ResourceListHead' : [ 0x150, ['_LIST_ENTRY']],
    'PortObjectLock' : [ 0x160, ['_EX_PUSH_LOCK']],
    'CompletionList' : [ 0x168, ['pointer64', ['_ALPC_COMPLETION_LIST']]],
    'CallbackObject' : [ 0x170, ['pointer64', ['_CALLBACK_OBJECT']]],
    'CallbackContext' : [ 0x178, ['pointer64', ['void']]],
    'CanceledQueue' : [ 0x180, ['_LIST_ENTRY']],
    'SequenceNo' : [ 0x190, ['long']],
    'ReferenceNo' : [ 0x194, ['long']],
    'ReferenceNoWait' : [ 0x198, ['pointer64', ['_PALPC_PORT_REFERENCE_WAIT_BLOCK']]],
    'u1' : [ 0x1a0, ['__unnamed_1d9b']],
    'TargetQueuePort' : [ 0x1a8, ['pointer64', ['_ALPC_PORT']]],
    'TargetSequencePort' : [ 0x1b0, ['pointer64', ['_ALPC_PORT']]],
    'CachedMessage' : [ 0x1b8, ['pointer64', ['_KALPC_MESSAGE']]],
    'MainQueueLength' : [ 0x1c0, ['unsigned long']],
    'LargeMessageQueueLength' : [ 0x1c4, ['unsigned long']],
    'PendingQueueLength' : [ 0x1c8, ['unsigned long']],
    'DirectQueueLength' : [ 0x1cc, ['unsigned long']],
    'CanceledQueueLength' : [ 0x1d0, ['unsigned long']],
    'WaitQueueLength' : [ 0x1d4, ['unsigned long']],
} ],
  '_ALPC_COMPLETION_LIST' : [ 0xa0, {
    'Entry' : [ 0x0, ['_LIST_ENTRY']],
    'OwnerProcess' : [ 0x10, ['pointer64', ['_EPROCESS']]],
    'CompletionListLock' : [ 0x18, ['_EX_PUSH_LOCK']],
    'Mdl' : [ 0x20, ['pointer64', ['_MDL']]],
    'UserVa' : [ 0x28, ['pointer64', ['void']]],
    'UserLimit' : [ 0x30, ['pointer64', ['void']]],
    'DataUserVa' : [ 0x38, ['pointer64', ['void']]],
    'SystemVa' : [ 0x40, ['pointer64', ['void']]],
    'TotalSize' : [ 0x48, ['unsigned long long']],
    'Header' : [ 0x50, ['pointer64', ['_ALPC_COMPLETION_LIST_HEADER']]],
    'List' : [ 0x58, ['pointer64', ['void']]],
    'ListSize' : [ 0x60, ['unsigned long long']],
    'Bitmap' : [ 0x68, ['pointer64', ['void']]],
    'BitmapSize' : [ 0x70, ['unsigned long long']],
    'Data' : [ 0x78, ['pointer64', ['void']]],
    'DataSize' : [ 0x80, ['unsigned long long']],
    'BitmapLimit' : [ 0x88, ['unsigned long']],
    'BitmapNextHint' : [ 0x8c, ['unsigned long']],
    'ConcurrencyCount' : [ 0x90, ['unsigned long']],
    'AttributeFlags' : [ 0x94, ['unsigned long']],
    'AttributeSize' : [ 0x98, ['unsigned long']],
} ],
  '_OBJECT_ATTRIBUTES' : [ 0x30, {
    'Length' : [ 0x0, ['unsigned long']],
    'RootDirectory' : [ 0x8, ['pointer64', ['void']]],
    'ObjectName' : [ 0x10, ['pointer64', ['_UNICODE_STRING']]],
    'Attributes' : [ 0x18, ['unsigned long']],
    'SecurityDescriptor' : [ 0x20, ['pointer64', ['void']]],
    'SecurityQualityOfService' : [ 0x28, ['pointer64', ['void']]],
} ],
  '_OBJECT_TYPE' : [ 0xd8, {
    'TypeList' : [ 0x0, ['_LIST_ENTRY']],
    'Name' : [ 0x10, ['_UNICODE_STRING']],
    'DefaultObject' : [ 0x20, ['pointer64', ['void']]],
    'Index' : [ 0x28, ['unsigned char']],
    'TotalNumberOfObjects' : [ 0x2c, ['unsigned long']],
    'TotalNumberOfHandles' : [ 0x30, ['unsigned long']],
    'HighWaterNumberOfObjects' : [ 0x34, ['unsigned long']],
    'HighWaterNumberOfHandles' : [ 0x38, ['unsigned long']],
    'TypeInfo' : [ 0x40, ['_OBJECT_TYPE_INITIALIZER']],
    'TypeLock' : [ 0xb8, ['_EX_PUSH_LOCK']],
    'Key' : [ 0xc0, ['unsigned long']],
    'CallbackList' : [ 0xc8, ['_LIST_ENTRY']],
} ],
  '_PALPC_PORT_REFERENCE_WAIT_BLOCK' : [ 0x20, {
    'DesiredReferenceNoEvent' : [ 0x0, ['_KEVENT']],
    'DesiredReferenceNo' : [ 0x18, ['long']],
} ],
  '_PORT_MESSAGE32' : [ 0x18, {
    'u1' : [ 0x0, ['__unnamed_1d31']],
    'u2' : [ 0x4, ['__unnamed_1d35']],
    'ClientId' : [ 0x8, ['_CLIENT_ID32']],
    'DoNotUseThisField' : [ 0x8, ['double']],
    'MessageId' : [ 0x10, ['unsigned long']],
    'ClientViewSize' : [ 0x14, ['unsigned long']],
    'CallbackId' : [ 0x14, ['unsigned long']],
} ],
  '__unnamed_1dc1' : [ 0x4, {
    'QueueType' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 3, native_type='unsigned long')]],
    'QueuePortType' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 7, native_type='unsigned long')]],
    'Canceled' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'Ready' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'ReleaseMessage' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'SharedQuota' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'ReplyWaitReply' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'OwnerPortReference' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long')]],
    'ReceiverReference' : [ 0x0, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long')]],
    'ViewAttributeRetrieved' : [ 0x0, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long')]],
    'InDispatch' : [ 0x0, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
} ],
  '__unnamed_1dc3' : [ 0x4, {
    's1' : [ 0x0, ['__unnamed_1dc1']],
    'State' : [ 0x0, ['unsigned long']],
} ],
  '_KALPC_MESSAGE' : [ 0x118, {
    'Entry' : [ 0x0, ['_LIST_ENTRY']],
    'PortQueue' : [ 0x10, ['pointer64', ['_ALPC_PORT']]],
    'OwnerPort' : [ 0x18, ['pointer64', ['_ALPC_PORT']]],
    'WaitingThread' : [ 0x20, ['pointer64', ['_ETHREAD']]],
    'u1' : [ 0x28, ['__unnamed_1dc3']],
    'SequenceNo' : [ 0x2c, ['long']],
    'QuotaProcess' : [ 0x30, ['pointer64', ['_EPROCESS']]],
    'QuotaBlock' : [ 0x30, ['pointer64', ['void']]],
    'CancelSequencePort' : [ 0x38, ['pointer64', ['_ALPC_PORT']]],
    'CancelQueuePort' : [ 0x40, ['pointer64', ['_ALPC_PORT']]],
    'CancelSequenceNo' : [ 0x48, ['long']],
    'CancelListEntry' : [ 0x50, ['_LIST_ENTRY']],
    'Reserve' : [ 0x60, ['pointer64', ['_KALPC_RESERVE']]],
    'MessageAttributes' : [ 0x68, ['_KALPC_MESSAGE_ATTRIBUTES']],
    'DataUserVa' : [ 0xb0, ['pointer64', ['void']]],
    'CommunicationInfo' : [ 0xb8, ['pointer64', ['_ALPC_COMMUNICATION_INFO']]],
    'ConnectionPort' : [ 0xc0, ['pointer64', ['_ALPC_PORT']]],
    'ServerThread' : [ 0xc8, ['pointer64', ['_ETHREAD']]],
    'WakeReference' : [ 0xd0, ['pointer64', ['void']]],
    'WakeReference2' : [ 0xd8, ['pointer64', ['void']]],
    'ExtensionBuffer' : [ 0xe0, ['pointer64', ['void']]],
    'ExtensionBufferSize' : [ 0xe8, ['unsigned long long']],
    'PortMessage' : [ 0xf0, ['_PORT_MESSAGE']],
} ],
  '_ALPC_DISPATCH_CONTEXT' : [ 0x40, {
    'PortObject' : [ 0x0, ['pointer64', ['_ALPC_PORT']]],
    'Message' : [ 0x8, ['pointer64', ['_KALPC_MESSAGE']]],
    'CommunicationInfo' : [ 0x10, ['pointer64', ['_ALPC_COMMUNICATION_INFO']]],
    'TargetThread' : [ 0x18, ['pointer64', ['_ETHREAD']]],
    'TargetPort' : [ 0x20, ['pointer64', ['_ALPC_PORT']]],
    'DirectEvent' : [ 0x28, ['_KALPC_DIRECT_EVENT']],
    'Flags' : [ 0x30, ['unsigned long']],
    'TotalLength' : [ 0x34, ['unsigned short']],
    'Type' : [ 0x36, ['unsigned short']],
    'DataInfoOffset' : [ 0x38, ['unsigned short']],
    'SignalCompletion' : [ 0x3a, ['unsigned char']],
    'PostedToCompletionList' : [ 0x3b, ['unsigned char']],
} ],
  '_REMOTE_PORT_VIEW' : [ 0x18, {
    'Length' : [ 0x0, ['unsigned long']],
    'ViewSize' : [ 0x8, ['unsigned long long']],
    'ViewBase' : [ 0x10, ['pointer64', ['void']]],
} ],
  '_KALPC_RESERVE' : [ 0x28, {
    'OwnerPort' : [ 0x0, ['pointer64', ['_ALPC_PORT']]],
    'HandleTable' : [ 0x8, ['pointer64', ['_ALPC_HANDLE_TABLE']]],
    'Handle' : [ 0x10, ['pointer64', ['void']]],
    'Message' : [ 0x18, ['pointer64', ['_KALPC_MESSAGE']]],
    'Active' : [ 0x20, ['long']],
} ],
  '_KALPC_HANDLE_DATA' : [ 0x30, {
    'ObjectType' : [ 0x0, ['unsigned long']],
    'Count' : [ 0x4, ['unsigned long']],
    'DuplicateContext' : [ 0x8, ['_OB_DUPLICATE_OBJECT_STATE']],
} ],
  '_KALPC_MESSAGE_ATTRIBUTES' : [ 0x48, {
    'ClientContext' : [ 0x0, ['pointer64', ['void']]],
    'ServerContext' : [ 0x8, ['pointer64', ['void']]],
    'PortContext' : [ 0x10, ['pointer64', ['void']]],
    'CancelPortContext' : [ 0x18, ['pointer64', ['void']]],
    'SecurityData' : [ 0x20, ['pointer64', ['_KALPC_SECURITY_DATA']]],
    'View' : [ 0x28, ['pointer64', ['_KALPC_VIEW']]],
    'HandleData' : [ 0x30, ['pointer64', ['_KALPC_HANDLE_DATA']]],
    'DirectEvent' : [ 0x38, ['_KALPC_DIRECT_EVENT']],
    'WorkOnBehalfData' : [ 0x40, ['_KALPC_WORK_ON_BEHALF_DATA']],
} ],
  '__unnamed_1e06' : [ 0x4, {
    'Revoked' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Impersonated' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
} ],
  '__unnamed_1e08' : [ 0x4, {
    's1' : [ 0x0, ['__unnamed_1e06']],
} ],
  '_KALPC_SECURITY_DATA' : [ 0x70, {
    'HandleTable' : [ 0x0, ['pointer64', ['_ALPC_HANDLE_TABLE']]],
    'ContextHandle' : [ 0x8, ['pointer64', ['void']]],
    'OwningProcess' : [ 0x10, ['pointer64', ['_EPROCESS']]],
    'OwnerPort' : [ 0x18, ['pointer64', ['_ALPC_PORT']]],
    'DynamicSecurity' : [ 0x20, ['_SECURITY_CLIENT_CONTEXT']],
    'u1' : [ 0x68, ['__unnamed_1e08']],
} ],
  '_ALPC_WORK_ON_BEHALF_TICKET' : [ 0x8, {
    'ThreadId' : [ 0x0, ['unsigned long']],
    'ThreadCreationTimeLow' : [ 0x4, ['unsigned long']],
} ],
  '_KALPC_DIRECT_EVENT' : [ 0x8, {
    'Event' : [ 0x0, ['unsigned long long']],
    'Referenced' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 64, native_type='unsigned long long')]],
} ],
  '_IO_MINI_COMPLETION_PACKET_USER' : [ 0x50, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'PacketType' : [ 0x10, ['unsigned long']],
    'KeyContext' : [ 0x18, ['pointer64', ['void']]],
    'ApcContext' : [ 0x20, ['pointer64', ['void']]],
    'IoStatus' : [ 0x28, ['long']],
    'IoStatusInformation' : [ 0x30, ['unsigned long long']],
    'MiniPacketCallback' : [ 0x38, ['pointer64', ['void']]],
    'Context' : [ 0x40, ['pointer64', ['void']]],
    'Allocated' : [ 0x48, ['unsigned char']],
} ],
  '_IOP_IRP_EXTENSION' : [ 0x38, {
    'ExtensionFlags' : [ 0x0, ['unsigned short']],
    'Allocated' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
    'PropagateId' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned short')]],
    'SpareBits' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 16, native_type='unsigned short')]],
    'TypesAllocated' : [ 0x2, ['unsigned short']],
    'GenericExtension' : [ 0x4, ['array', 4, ['unsigned char']]],
    'VerifierContext' : [ 0x8, ['pointer64', ['void']]],
    'DiskIoAttributionHandle' : [ 0x10, ['unsigned long long']],
    'ActivityId' : [ 0x18, ['_GUID']],
    'Timestamp' : [ 0x28, ['_LARGE_INTEGER']],
    'ZeroingOffset' : [ 0x28, ['unsigned long']],
    'FsTrackOffsetBlob' : [ 0x28, ['pointer64', ['_IO_IRP_EXT_TRACK_OFFSET_HEADER']]],
    'FsTrackedOffset' : [ 0x30, ['long long']],
    'AdapterCryptoParameters' : [ 0x28, ['_IO_ADAPTER_CRYPTO_PARAMETERS']],
} ],
  '_DRIVER_OBJECT' : [ 0x150, {
    'Type' : [ 0x0, ['short']],
    'Size' : [ 0x2, ['short']],
    'DeviceObject' : [ 0x8, ['pointer64', ['_DEVICE_OBJECT']]],
    'Flags' : [ 0x10, ['unsigned long']],
    'DriverStart' : [ 0x18, ['pointer64', ['void']]],
    'DriverSize' : [ 0x20, ['unsigned long']],
    'DriverSection' : [ 0x28, ['pointer64', ['void']]],
    'DriverExtension' : [ 0x30, ['pointer64', ['_DRIVER_EXTENSION']]],
    'DriverName' : [ 0x38, ['_UNICODE_STRING']],
    'HardwareDatabase' : [ 0x48, ['pointer64', ['_UNICODE_STRING']]],
    'FastIoDispatch' : [ 0x50, ['pointer64', ['_FAST_IO_DISPATCH']]],
    'DriverInit' : [ 0x58, ['pointer64', ['void']]],
    'DriverStartIo' : [ 0x60, ['pointer64', ['void']]],
    'DriverUnload' : [ 0x68, ['pointer64', ['void']]],
    'MajorFunction' : [ 0x70, ['array', 28, ['pointer64', ['void']]]],
} ],
  '_FILE_SEGMENT_ELEMENT' : [ 0x8, {
    'Buffer' : [ 0x0, ['pointer64', ['void']]],
    'Alignment' : [ 0x0, ['unsigned long long']],
} ],
  '_RELATIVE_SYMLINK_INFO' : [ 0x20, {
    'ExposedNamespaceLength' : [ 0x0, ['unsigned short']],
    'Flags' : [ 0x2, ['unsigned short']],
    'DeviceNameLength' : [ 0x4, ['unsigned short']],
    'Reserved' : [ 0x6, ['unsigned short']],
    'InteriorMountPoint' : [ 0x8, ['pointer64', ['_RELATIVE_SYMLINK_INFO']]],
    'OpenedName' : [ 0x10, ['_UNICODE_STRING']],
} ],
  '_ECP_LIST' : [ 0x18, {
    'Signature' : [ 0x0, ['unsigned long']],
    'Flags' : [ 0x4, ['unsigned long']],
    'EcpList' : [ 0x8, ['_LIST_ENTRY']],
} ],
  '_IOP_FILE_OBJECT_EXTENSION' : [ 0x58, {
    'FoExtFlags' : [ 0x0, ['unsigned long']],
    'FoExtPerTypeExtension' : [ 0x8, ['array', 9, ['pointer64', ['void']]]],
    'FoIoPriorityHint' : [ 0x50, ['Enumeration', dict(target = 'long', choices = {0: u'IopIoPriorityNotSet', 1: u'IopIoPriorityVeryLow', 2: u'IopIoPriorityLow', 3: u'IopIoPriorityNormal', 4: u'IopIoPriorityHigh', 5: u'IopIoPriorityCritical', 6: u'MaxIopIoPriorityTypes'})]],
} ],
  '_OPEN_PACKET' : [ 0xd8, {
    'Type' : [ 0x0, ['short']],
    'Size' : [ 0x2, ['short']],
    'FileObject' : [ 0x8, ['pointer64', ['_FILE_OBJECT']]],
    'FinalStatus' : [ 0x10, ['long']],
    'Information' : [ 0x18, ['unsigned long long']],
    'ParseCheck' : [ 0x20, ['unsigned long']],
    'RelatedFileObject' : [ 0x28, ['pointer64', ['_FILE_OBJECT']]],
    'ReferencedDeviceObject' : [ 0x28, ['pointer64', ['_DEVICE_OBJECT']]],
    'OriginalAttributes' : [ 0x30, ['pointer64', ['_OBJECT_ATTRIBUTES']]],
    'AllocationSize' : [ 0x38, ['_LARGE_INTEGER']],
    'CreateOptions' : [ 0x40, ['unsigned long']],
    'FileAttributes' : [ 0x44, ['unsigned short']],
    'ShareAccess' : [ 0x46, ['unsigned short']],
    'EaBuffer' : [ 0x48, ['pointer64', ['void']]],
    'EaLength' : [ 0x50, ['unsigned long']],
    'Options' : [ 0x54, ['unsigned long']],
    'Disposition' : [ 0x58, ['unsigned long']],
    'BasicInformation' : [ 0x60, ['pointer64', ['_FILE_BASIC_INFORMATION']]],
    'NetworkInformation' : [ 0x68, ['pointer64', ['_FILE_NETWORK_OPEN_INFORMATION']]],
    'FileInformation' : [ 0x70, ['pointer64', ['void']]],
    'CreateFileType' : [ 0x78, ['Enumeration', dict(target = 'long', choices = {0: u'CreateFileTypeNone', 1: u'CreateFileTypeNamedPipe', 2: u'CreateFileTypeMailslot'})]],
    'MailslotOrPipeParameters' : [ 0x80, ['pointer64', ['void']]],
    'Override' : [ 0x88, ['unsigned char']],
    'QueryOnly' : [ 0x89, ['unsigned char']],
    'DeleteOnly' : [ 0x8a, ['unsigned char']],
    'FullAttributes' : [ 0x8b, ['unsigned char']],
    'LocalFileObject' : [ 0x90, ['pointer64', ['_DUMMY_FILE_OBJECT']]],
    'InternalFlags' : [ 0x98, ['unsigned long']],
    'AccessMode' : [ 0x9c, ['unsigned char']],
    'DriverCreateContext' : [ 0xa0, ['_IO_DRIVER_CREATE_CONTEXT']],
    'FileInformationClass' : [ 0xc8, ['Enumeration', dict(target = 'long', choices = {1: u'FileDirectoryInformation', 2: u'FileFullDirectoryInformation', 3: u'FileBothDirectoryInformation', 4: u'FileBasicInformation', 5: u'FileStandardInformation', 6: u'FileInternalInformation', 7: u'FileEaInformation', 8: u'FileAccessInformation', 9: u'FileNameInformation', 10: u'FileRenameInformation', 11: u'FileLinkInformation', 12: u'FileNamesInformation', 13: u'FileDispositionInformation', 14: u'FilePositionInformation', 15: u'FileFullEaInformation', 16: u'FileModeInformation', 17: u'FileAlignmentInformation', 18: u'FileAllInformation', 19: u'FileAllocationInformation', 20: u'FileEndOfFileInformation', 21: u'FileAlternateNameInformation', 22: u'FileStreamInformation', 23: u'FilePipeInformation', 24: u'FilePipeLocalInformation', 25: u'FilePipeRemoteInformation', 26: u'FileMailslotQueryInformation', 27: u'FileMailslotSetInformation', 28: u'FileCompressionInformation', 29: u'FileObjectIdInformation', 30: u'FileCompletionInformation', 31: u'FileMoveClusterInformation', 32: u'FileQuotaInformation', 33: u'FileReparsePointInformation', 34: u'FileNetworkOpenInformation', 35: u'FileAttributeTagInformation', 36: u'FileTrackingInformation', 37: u'FileIdBothDirectoryInformation', 38: u'FileIdFullDirectoryInformation', 39: u'FileValidDataLengthInformation', 40: u'FileShortNameInformation', 41: u'FileIoCompletionNotificationInformation', 42: u'FileIoStatusBlockRangeInformation', 43: u'FileIoPriorityHintInformation', 44: u'FileSfioReserveInformation', 45: u'FileSfioVolumeInformation', 46: u'FileHardLinkInformation', 47: u'FileProcessIdsUsingFileInformation', 48: u'FileNormalizedNameInformation', 49: u'FileNetworkPhysicalNameInformation', 50: u'FileIdGlobalTxDirectoryInformation', 51: u'FileIsRemoteDeviceInformation', 52: u'FileUnusedInformation', 53: u'FileNumaNodeInformation', 54: u'FileStandardLinkInformation', 55: u'FileRemoteProtocolInformation', 56: u'FileRenameInformationBypassAccessCheck', 57: u'FileLinkInformationBypassAccessCheck', 58: u'FileVolumeNameInformation', 59: u'FileIdInformation', 60: u'FileIdExtdDirectoryInformation', 61: u'FileReplaceCompletionInformation', 62: u'FileHardLinkFullIdInformation', 63: u'FileIdExtdBothDirectoryInformation', 64: u'FileDispositionInformationEx', 65: u'FileRenameInformationEx', 66: u'FileRenameInformationExBypassAccessCheck', 67: u'FileDesiredStorageClassInformation', 68: u'FileStatInformation', 69: u'FileMemoryPartitionInformation', 70: u'FileStatLxInformation', 71: u'FileCaseSensitiveInformation', 72: u'FileMaximumInformation'})]],
    'FileInformationLength' : [ 0xcc, ['unsigned long']],
    'FilterQuery' : [ 0xd0, ['unsigned char']],
} ],
  '_ETW_SYSTEMTIME' : [ 0x10, {
    'Year' : [ 0x0, ['unsigned short']],
    'Month' : [ 0x2, ['unsigned short']],
    'DayOfWeek' : [ 0x4, ['unsigned short']],
    'Day' : [ 0x6, ['unsigned short']],
    'Hour' : [ 0x8, ['unsigned short']],
    'Minute' : [ 0xa, ['unsigned short']],
    'Second' : [ 0xc, ['unsigned short']],
    'Milliseconds' : [ 0xe, ['unsigned short']],
} ],
  '_TIME_FIELDS' : [ 0x10, {
    'Year' : [ 0x0, ['short']],
    'Month' : [ 0x2, ['short']],
    'Day' : [ 0x4, ['short']],
    'Hour' : [ 0x6, ['short']],
    'Minute' : [ 0x8, ['short']],
    'Second' : [ 0xa, ['short']],
    'Milliseconds' : [ 0xc, ['short']],
    'Weekday' : [ 0xe, ['short']],
} ],
  '__unnamed_1ed2' : [ 0x4, {
    'MajorVersion' : [ 0x0, ['unsigned char']],
    'MinorVersion' : [ 0x1, ['unsigned char']],
    'SubVersion' : [ 0x2, ['unsigned char']],
    'SubMinorVersion' : [ 0x3, ['unsigned char']],
} ],
  '_TRACE_LOGFILE_HEADER' : [ 0x118, {
    'BufferSize' : [ 0x0, ['unsigned long']],
    'Version' : [ 0x4, ['unsigned long']],
    'VersionDetail' : [ 0x4, ['__unnamed_1ed2']],
    'ProviderVersion' : [ 0x8, ['unsigned long']],
    'NumberOfProcessors' : [ 0xc, ['unsigned long']],
    'EndTime' : [ 0x10, ['_LARGE_INTEGER']],
    'TimerResolution' : [ 0x18, ['unsigned long']],
    'MaximumFileSize' : [ 0x1c, ['unsigned long']],
    'LogFileMode' : [ 0x20, ['unsigned long']],
    'BuffersWritten' : [ 0x24, ['unsigned long']],
    'LogInstanceGuid' : [ 0x28, ['_GUID']],
    'StartBuffers' : [ 0x28, ['unsigned long']],
    'PointerSize' : [ 0x2c, ['unsigned long']],
    'EventsLost' : [ 0x30, ['unsigned long']],
    'CpuSpeedInMHz' : [ 0x34, ['unsigned long']],
    'LoggerName' : [ 0x38, ['pointer64', ['wchar']]],
    'LogFileName' : [ 0x40, ['pointer64', ['wchar']]],
    'TimeZone' : [ 0x48, ['_RTL_TIME_ZONE_INFORMATION']],
    'BootTime' : [ 0xf8, ['_LARGE_INTEGER']],
    'PerfFreq' : [ 0x100, ['_LARGE_INTEGER']],
    'StartTime' : [ 0x108, ['_LARGE_INTEGER']],
    'ReservedFlags' : [ 0x110, ['unsigned long']],
    'BuffersLost' : [ 0x114, ['unsigned long']],
} ],
  '_ETW_BUFFER_QUEUE' : [ 0x10, {
    'QueueTail' : [ 0x0, ['pointer64', ['_SINGLE_LIST_ENTRY']]],
    'QueueEntry' : [ 0x8, ['_SINGLE_LIST_ENTRY']],
} ],
  '_WMI_BUFFER_HEADER' : [ 0x48, {
    'BufferSize' : [ 0x0, ['unsigned long']],
    'SavedOffset' : [ 0x4, ['unsigned long']],
    'CurrentOffset' : [ 0x8, ['unsigned long']],
    'ReferenceCount' : [ 0xc, ['long']],
    'TimeStamp' : [ 0x10, ['_LARGE_INTEGER']],
    'SequenceNumber' : [ 0x18, ['long long']],
    'ClockType' : [ 0x20, ['BitField', dict(start_bit = 0, end_bit = 3, native_type='unsigned long long')]],
    'Frequency' : [ 0x20, ['BitField', dict(start_bit = 3, end_bit = 64, native_type='unsigned long long')]],
    'SlistEntry' : [ 0x20, ['_SINGLE_LIST_ENTRY']],
    'NextBuffer' : [ 0x20, ['pointer64', ['_WMI_BUFFER_HEADER']]],
    'ClientContext' : [ 0x28, ['_ETW_BUFFER_CONTEXT']],
    'State' : [ 0x2c, ['Enumeration', dict(target = 'long', choices = {0: u'EtwBufferStateFree', 1: u'EtwBufferStateGeneralLogging', 2: u'EtwBufferStateCSwitch', 3: u'EtwBufferStateFlush', 4: u'EtwBufferStatePendingCompression', 5: u'EtwBufferStateCompressed', 6: u'EtwBufferStatePlaceholder', 7: u'EtwBufferStateMaximum'})]],
    'Offset' : [ 0x30, ['unsigned long']],
    'BufferFlag' : [ 0x34, ['unsigned short']],
    'BufferType' : [ 0x36, ['unsigned short']],
    'Padding1' : [ 0x38, ['array', 4, ['unsigned long']]],
    'ReferenceTime' : [ 0x38, ['_ETW_REF_CLOCK']],
    'GlobalEntry' : [ 0x38, ['_LIST_ENTRY']],
    'Pointer0' : [ 0x38, ['pointer64', ['void']]],
    'Pointer1' : [ 0x40, ['pointer64', ['void']]],
} ],
  '_WMI_LOGGER_CONTEXT' : [ 0x510, {
    'LoggerId' : [ 0x0, ['unsigned long']],
    'BufferSize' : [ 0x4, ['unsigned long']],
    'MaximumEventSize' : [ 0x8, ['unsigned long']],
    'LoggerMode' : [ 0xc, ['unsigned long']],
    'AcceptNewEvents' : [ 0x10, ['long']],
    'EventMarker' : [ 0x14, ['array', 2, ['unsigned long']]],
    'ErrorMarker' : [ 0x1c, ['unsigned long']],
    'SizeMask' : [ 0x20, ['unsigned long']],
    'GetCpuClock' : [ 0x28, ['pointer64', ['void']]],
    'LoggerThread' : [ 0x30, ['pointer64', ['_ETHREAD']]],
    'LoggerStatus' : [ 0x38, ['long']],
    'FailureReason' : [ 0x3c, ['unsigned long']],
    'BufferQueue' : [ 0x40, ['_ETW_BUFFER_QUEUE']],
    'OverflowQueue' : [ 0x50, ['_ETW_BUFFER_QUEUE']],
    'GlobalList' : [ 0x60, ['_LIST_ENTRY']],
    'DebugIdTrackingList' : [ 0x70, ['_LIST_ENTRY']],
    'DecodeControlList' : [ 0x80, ['pointer64', ['_ETW_DECODE_CONTROL_ENTRY']]],
    'DecodeControlCount' : [ 0x88, ['unsigned long']],
    'BatchedBufferList' : [ 0x90, ['pointer64', ['_WMI_BUFFER_HEADER']]],
    'CurrentBuffer' : [ 0x90, ['_EX_FAST_REF']],
    'LoggerName' : [ 0x98, ['_UNICODE_STRING']],
    'LogFileName' : [ 0xa8, ['_UNICODE_STRING']],
    'LogFilePattern' : [ 0xb8, ['_UNICODE_STRING']],
    'NewLogFileName' : [ 0xc8, ['_UNICODE_STRING']],
    'ClockType' : [ 0xd8, ['unsigned long']],
    'LastFlushedBuffer' : [ 0xdc, ['unsigned long']],
    'FlushTimer' : [ 0xe0, ['unsigned long']],
    'FlushThreshold' : [ 0xe4, ['unsigned long']],
    'ByteOffset' : [ 0xe8, ['_LARGE_INTEGER']],
    'MinimumBuffers' : [ 0xf0, ['unsigned long']],
    'BuffersAvailable' : [ 0xf4, ['long']],
    'NumberOfBuffers' : [ 0xf8, ['long']],
    'MaximumBuffers' : [ 0xfc, ['unsigned long']],
    'EventsLost' : [ 0x100, ['unsigned long']],
    'PeakBuffersCount' : [ 0x104, ['long']],
    'BuffersWritten' : [ 0x108, ['unsigned long']],
    'LogBuffersLost' : [ 0x10c, ['unsigned long']],
    'RealTimeBuffersDelivered' : [ 0x110, ['unsigned long']],
    'RealTimeBuffersLost' : [ 0x114, ['unsigned long']],
    'SequencePtr' : [ 0x118, ['pointer64', ['long']]],
    'LocalSequence' : [ 0x120, ['unsigned long']],
    'InstanceGuid' : [ 0x124, ['_GUID']],
    'MaximumFileSize' : [ 0x134, ['unsigned long']],
    'FileCounter' : [ 0x138, ['long']],
    'PoolType' : [ 0x13c, ['Enumeration', dict(target = 'long', choices = {0: u'NonPagedPoolBase', 1: u'PagedPool', 2: u'NonPagedPoolBaseMustSucceed', 3: u'DontUseThisType', 4: u'NonPagedPoolBaseCacheAligned', 5: u'PagedPoolCacheAligned', 6: u'NonPagedPoolBaseCacheAlignedMustS', 7: u'MaxPoolType', 34: u'NonPagedPoolMustSucceedSession', 516: u'NonPagedPoolNxCacheAligned', 35: u'DontUseThisTypeSession', 32: u'NonPagedPoolSession', 512: u'NonPagedPoolNx', 544: u'NonPagedPoolSessionNx', 36: u'NonPagedPoolCacheAlignedSession', 33: u'PagedPoolSession', 38: u'NonPagedPoolCacheAlignedMustSSession', 37: u'PagedPoolCacheAlignedSession'})]],
    'ReferenceTime' : [ 0x140, ['_ETW_REF_CLOCK']],
    'CollectionOn' : [ 0x150, ['long']],
    'ProviderInfoSize' : [ 0x154, ['unsigned long']],
    'Consumers' : [ 0x158, ['_LIST_ENTRY']],
    'NumConsumers' : [ 0x168, ['unsigned long']],
    'TransitionConsumer' : [ 0x170, ['pointer64', ['_ETW_REALTIME_CONSUMER']]],
    'RealtimeLogfileHandle' : [ 0x178, ['pointer64', ['void']]],
    'RealtimeLogfileName' : [ 0x180, ['_UNICODE_STRING']],
    'RealtimeWriteOffset' : [ 0x190, ['_LARGE_INTEGER']],
    'RealtimeReadOffset' : [ 0x198, ['_LARGE_INTEGER']],
    'RealtimeLogfileSize' : [ 0x1a0, ['_LARGE_INTEGER']],
    'RealtimeLogfileUsage' : [ 0x1a8, ['unsigned long long']],
    'RealtimeMaximumFileSize' : [ 0x1b0, ['unsigned long long']],
    'RealtimeBuffersSaved' : [ 0x1b8, ['unsigned long']],
    'RealtimeReferenceTime' : [ 0x1c0, ['_ETW_REF_CLOCK']],
    'NewRTEventsLost' : [ 0x1d0, ['Enumeration', dict(target = 'long', choices = {0: u'EtwRtEventNoLoss', 1: u'EtwRtEventLost', 2: u'EtwRtBufferLost', 3: u'EtwRtBackupLost', 4: u'EtwRtEventLossMax'})]],
    'LoggerEvent' : [ 0x1d8, ['_KEVENT']],
    'FlushEvent' : [ 0x1f0, ['_KEVENT']],
    'FlushTimeOutTimer' : [ 0x208, ['_KTIMER']],
    'LoggerDpc' : [ 0x248, ['_KDPC']],
    'LoggerMutex' : [ 0x288, ['_KMUTANT']],
    'LoggerLock' : [ 0x2c0, ['_EX_PUSH_LOCK']],
    'BufferListSpinLock' : [ 0x2c8, ['unsigned long long']],
    'BufferListPushLock' : [ 0x2c8, ['_EX_PUSH_LOCK']],
    'ClientSecurityContext' : [ 0x2d0, ['_SECURITY_CLIENT_CONTEXT']],
    'TokenAccessInformation' : [ 0x318, ['pointer64', ['_TOKEN_ACCESS_INFORMATION']]],
    'SecurityDescriptor' : [ 0x320, ['_EX_FAST_REF']],
    'StartTime' : [ 0x328, ['_LARGE_INTEGER']],
    'LogFileHandle' : [ 0x330, ['pointer64', ['void']]],
    'BufferSequenceNumber' : [ 0x338, ['long long']],
    'Flags' : [ 0x340, ['unsigned long']],
    'Persistent' : [ 0x340, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'AutoLogger' : [ 0x340, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'FsReady' : [ 0x340, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'RealTime' : [ 0x340, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'Wow' : [ 0x340, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'KernelTrace' : [ 0x340, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'NoMoreEnable' : [ 0x340, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'StackTracing' : [ 0x340, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'ErrorLogged' : [ 0x340, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'RealtimeLoggerContextFreed' : [ 0x340, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'PebsTracing' : [ 0x340, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'PmcCounters' : [ 0x340, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'PageAlignBuffers' : [ 0x340, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long')]],
    'StackLookasideListAllocated' : [ 0x340, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long')]],
    'SecurityTrace' : [ 0x340, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long')]],
    'LastBranchTracing' : [ 0x340, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'SystemLoggerIndex' : [ 0x340, ['BitField', dict(start_bit = 16, end_bit = 24, native_type='unsigned long')]],
    'StackCaching' : [ 0x340, ['BitField', dict(start_bit = 24, end_bit = 25, native_type='unsigned long')]],
    'ProviderTracking' : [ 0x340, ['BitField', dict(start_bit = 25, end_bit = 26, native_type='unsigned long')]],
    'ProcessorTrace' : [ 0x340, ['BitField', dict(start_bit = 26, end_bit = 27, native_type='unsigned long')]],
    'SpareFlags2' : [ 0x340, ['BitField', dict(start_bit = 27, end_bit = 32, native_type='unsigned long')]],
    'RequestFlag' : [ 0x344, ['unsigned long']],
    'DbgRequestNewFile' : [ 0x344, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'DbgRequestUpdateFile' : [ 0x344, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'DbgRequestFlush' : [ 0x344, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'DbgRequestDisableRealtime' : [ 0x344, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'DbgRequestDisconnectConsumer' : [ 0x344, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'DbgRequestConnectConsumer' : [ 0x344, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'DbgRequestNotifyConsumer' : [ 0x344, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'DbgRequestUpdateHeader' : [ 0x344, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'DbgRequestDeferredFlush' : [ 0x344, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'DbgRequestDeferredFlushTimer' : [ 0x344, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'DbgRequestFlushTimer' : [ 0x344, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'DbgRequestUpdateDebugger' : [ 0x344, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'DbgSpareRequestFlags' : [ 0x344, ['BitField', dict(start_bit = 12, end_bit = 32, native_type='unsigned long')]],
    'StackTraceBlock' : [ 0x350, ['_ETW_STACK_TRACE_BLOCK']],
    'HookIdMap' : [ 0x3d0, ['_RTL_BITMAP']],
    'StackCache' : [ 0x3e0, ['pointer64', ['_ETW_STACK_CACHE']]],
    'PmcData' : [ 0x3e8, ['pointer64', ['_ETW_PMC_SUPPORT']]],
    'LbrData' : [ 0x3f0, ['pointer64', ['_ETW_LBR_SUPPORT']]],
    'IptData' : [ 0x3f8, ['pointer64', ['_ETW_IPT_SUPPORT']]],
    'BinaryTrackingList' : [ 0x400, ['_LIST_ENTRY']],
    'ScratchArray' : [ 0x410, ['pointer64', ['pointer64', ['_WMI_BUFFER_HEADER']]]],
    'DisallowedGuids' : [ 0x418, ['_DISALLOWED_GUIDS']],
    'RelativeTimerDueTime' : [ 0x428, ['long long']],
    'PeriodicCaptureStateGuids' : [ 0x430, ['_PERIODIC_CAPTURE_STATE_GUIDS']],
    'PeriodicCaptureStateTimer' : [ 0x440, ['pointer64', ['_EX_TIMER']]],
    'PeriodicCaptureStateTimerState' : [ 0x448, ['Enumeration', dict(target = 'long', choices = {0: u'EtwpPeriodicTimerUnset', 1: u'EtwpPeriodicTimerSet'})]],
    'SoftRestartContext' : [ 0x450, ['pointer64', ['_ETW_SOFT_RESTART_CONTEXT']]],
    'SiloState' : [ 0x458, ['pointer64', ['_ETW_SILODRIVERSTATE']]],
    'CompressionWorkItem' : [ 0x460, ['_WORK_QUEUE_ITEM']],
    'CompressionWorkItemState' : [ 0x480, ['long']],
    'CompressionLock' : [ 0x488, ['_EX_PUSH_LOCK']],
    'CompressionTarget' : [ 0x490, ['pointer64', ['_WMI_BUFFER_HEADER']]],
    'CompressionWorkspace' : [ 0x498, ['pointer64', ['void']]],
    'CompressionOn' : [ 0x4a0, ['long']],
    'CompressionRatioGuess' : [ 0x4a4, ['unsigned long']],
    'PartialBufferCompressionLevel' : [ 0x4a8, ['unsigned long']],
    'CompressionResumptionMode' : [ 0x4ac, ['Enumeration', dict(target = 'long', choices = {0: u'EtwCompressionModeRestart', 1: u'EtwCompressionModeNoDisable', 2: u'EtwCompressionModeNoRestart'})]],
    'PlaceholderList' : [ 0x4b0, ['_SINGLE_LIST_ENTRY']],
    'CompressionDpc' : [ 0x4b8, ['_KDPC']],
    'LastBufferSwitchTime' : [ 0x4f8, ['_LARGE_INTEGER']],
    'BufferWriteDuration' : [ 0x500, ['_LARGE_INTEGER']],
    'BufferCompressDuration' : [ 0x508, ['_LARGE_INTEGER']],
} ],
  '_ETW_PMC_SUPPORT' : [ 0x38, {
    'Source' : [ 0x0, ['array', 8, ['Enumeration', dict(target = 'long', choices = {0: u'ProfileTime', 1: u'ProfileAlignmentFixup', 2: u'ProfileTotalIssues', 3: u'ProfilePipelineDry', 4: u'ProfileLoadInstructions', 5: u'ProfilePipelineFrozen', 6: u'ProfileBranchInstructions', 7: u'ProfileTotalNonissues', 8: u'ProfileDcacheMisses', 9: u'ProfileIcacheMisses', 10: u'ProfileCacheMisses', 11: u'ProfileBranchMispredictions', 12: u'ProfileStoreInstructions', 13: u'ProfileFpInstructions', 14: u'ProfileIntegerInstructions', 15: u'Profile2Issue', 16: u'Profile3Issue', 17: u'Profile4Issue', 18: u'ProfileSpecialInstructions', 19: u'ProfileTotalCycles', 20: u'ProfileIcacheIssues', 21: u'ProfileDcacheAccesses', 22: u'ProfileMemoryBarrierCycles', 23: u'ProfileLoadLinkedIssues', 24: u'ProfileMaximum'})]]],
    'HookIdCount' : [ 0x20, ['unsigned long']],
    'HookId' : [ 0x24, ['array', 4, ['unsigned short']]],
    'CountersCount' : [ 0x2c, ['unsigned long']],
    'ProcessorCtrs' : [ 0x30, ['array', 1, ['pointer64', ['_HAL_PMC_COUNTERS']]]],
} ],
  '_ETW_LBR_SUPPORT' : [ 0x14, {
    'LbrHandle' : [ 0x0, ['unsigned long']],
    'LbrOptions' : [ 0x4, ['unsigned long']],
    'HookIdCount' : [ 0x8, ['unsigned long']],
    'HookId' : [ 0xc, ['array', 4, ['unsigned short']]],
} ],
  '_ETW_IPT_SUPPORT' : [ 0x28, {
    'IptHandle' : [ 0x0, ['pointer64', ['void']]],
    'IptOption' : [ 0x8, ['unsigned long long']],
    'EtwHwTraceExtInterface' : [ 0x10, ['pointer64', ['_ETW_HW_TRACE_EXT_INTERFACE']]],
    'HookIdCount' : [ 0x18, ['unsigned long']],
    'HookId' : [ 0x1c, ['array', 4, ['unsigned short']]],
} ],
  '_ETW_SILODRIVERSTATE' : [ 0x11c0, {
    'Silo' : [ 0x0, ['pointer64', ['_EJOB']]],
    'SiloGlobals' : [ 0x8, ['pointer64', ['_ESERVERSILO_GLOBALS']]],
    'MaxLoggers' : [ 0x10, ['unsigned long']],
    'EtwpSecurityProviderGuidEntry' : [ 0x18, ['_ETW_GUID_ENTRY']],
    'EtwpLoggerRundown' : [ 0x1a8, ['pointer64', ['pointer64', ['_EX_RUNDOWN_REF_CACHE_AWARE']]]],
    'EtwpLoggerContext' : [ 0x1b0, ['pointer64', ['pointer64', ['_WMI_LOGGER_CONTEXT']]]],
    'EtwpGuidHashTable' : [ 0x1b8, ['array', 64, ['_ETW_HASH_BUCKET']]],
    'EtwpSecurityLoggers' : [ 0xfb8, ['array', 8, ['unsigned short']]],
    'EtwpSecurityProviderEnableMask' : [ 0xfc8, ['unsigned char']],
    'EtwpShutdownInProgress' : [ 0xfcc, ['long']],
    'EtwpSecurityProviderPID' : [ 0xfd0, ['unsigned long']],
    'PrivHandleDemuxTable' : [ 0xfd8, ['_ETW_PRIV_HANDLE_DEMUX_TABLE']],
    'EtwpCounters' : [ 0xff8, ['_ETW_COUNTERS']],
    'LogfileBytesWritten' : [ 0x1008, ['_LARGE_INTEGER']],
    'ProcessorBlocks' : [ 0x1010, ['pointer64', ['_ETW_SILO_TRACING_BLOCK']]],
    'ContainerRestoreWnfSubscription' : [ 0x1018, ['pointer64', ['_EX_WNF_SUBSCRIPTION']]],
    'PartitionId' : [ 0x1020, ['_GUID']],
    'ParentId' : [ 0x1030, ['_GUID']],
    'QpcOffsetFromRoot' : [ 0x1040, ['_LARGE_INTEGER']],
    'PartitionType' : [ 0x1048, ['unsigned long']],
    'SystemLoggerSettings' : [ 0x104c, ['_ETW_SYSTEM_LOGGER_SETTINGS']],
} ],
  '_ETW_LOGGER_HANDLE' : [ 0x1, {
    'DereferenceAndLeave' : [ 0x0, ['unsigned char']],
} ],
  '_SEP_SILOSTATE' : [ 0x30, {
    'SystemLogonSession' : [ 0x0, ['pointer64', ['_SEP_LOGON_SESSION_REFERENCES']]],
    'AnonymousLogonSession' : [ 0x8, ['pointer64', ['_SEP_LOGON_SESSION_REFERENCES']]],
    'AnonymousLogonToken' : [ 0x10, ['pointer64', ['void']]],
    'AnonymousLogonTokenNoEveryone' : [ 0x18, ['pointer64', ['void']]],
    'UncSystemPaths' : [ 0x20, ['pointer64', ['_UNICODE_STRING']]],
    'NgenPaths' : [ 0x28, ['pointer64', ['_CI_NGEN_PATHS']]],
} ],
  '_LUID_AND_ATTRIBUTES' : [ 0xc, {
    'Luid' : [ 0x0, ['_LUID']],
    'Attributes' : [ 0x8, ['unsigned long']],
} ],
  '_TOKEN' : [ 0x498, {
    'TokenSource' : [ 0x0, ['_TOKEN_SOURCE']],
    'TokenId' : [ 0x10, ['_LUID']],
    'AuthenticationId' : [ 0x18, ['_LUID']],
    'ParentTokenId' : [ 0x20, ['_LUID']],
    'ExpirationTime' : [ 0x28, ['_LARGE_INTEGER']],
    'TokenLock' : [ 0x30, ['pointer64', ['_ERESOURCE']]],
    'ModifiedId' : [ 0x38, ['_LUID']],
    'Privileges' : [ 0x40, ['_SEP_TOKEN_PRIVILEGES']],
    'AuditPolicy' : [ 0x58, ['_SEP_AUDIT_POLICY']],
    'SessionId' : [ 0x78, ['unsigned long']],
    'UserAndGroupCount' : [ 0x7c, ['unsigned long']],
    'RestrictedSidCount' : [ 0x80, ['unsigned long']],
    'VariableLength' : [ 0x84, ['unsigned long']],
    'DynamicCharged' : [ 0x88, ['unsigned long']],
    'DynamicAvailable' : [ 0x8c, ['unsigned long']],
    'DefaultOwnerIndex' : [ 0x90, ['unsigned long']],
    'UserAndGroups' : [ 0x98, ['pointer64', ['_SID_AND_ATTRIBUTES']]],
    'RestrictedSids' : [ 0xa0, ['pointer64', ['_SID_AND_ATTRIBUTES']]],
    'PrimaryGroup' : [ 0xa8, ['pointer64', ['void']]],
    'DynamicPart' : [ 0xb0, ['pointer64', ['unsigned long']]],
    'DefaultDacl' : [ 0xb8, ['pointer64', ['_ACL']]],
    'TokenType' : [ 0xc0, ['Enumeration', dict(target = 'long', choices = {1: u'TokenPrimary', 2: u'TokenImpersonation'})]],
    'ImpersonationLevel' : [ 0xc4, ['Enumeration', dict(target = 'long', choices = {0: u'SecurityAnonymous', 1: u'SecurityIdentification', 2: u'SecurityImpersonation', 3: u'SecurityDelegation'})]],
    'TokenFlags' : [ 0xc8, ['unsigned long']],
    'TokenInUse' : [ 0xcc, ['unsigned char']],
    'IntegrityLevelIndex' : [ 0xd0, ['unsigned long']],
    'MandatoryPolicy' : [ 0xd4, ['unsigned long']],
    'LogonSession' : [ 0xd8, ['pointer64', ['_SEP_LOGON_SESSION_REFERENCES']]],
    'OriginatingLogonSession' : [ 0xe0, ['_LUID']],
    'SidHash' : [ 0xe8, ['_SID_AND_ATTRIBUTES_HASH']],
    'RestrictedSidHash' : [ 0x1f8, ['_SID_AND_ATTRIBUTES_HASH']],
    'pSecurityAttributes' : [ 0x308, ['pointer64', ['_AUTHZBASEP_SECURITY_ATTRIBUTES_INFORMATION']]],
    'Package' : [ 0x310, ['pointer64', ['void']]],
    'Capabilities' : [ 0x318, ['pointer64', ['_SID_AND_ATTRIBUTES']]],
    'CapabilityCount' : [ 0x320, ['unsigned long']],
    'CapabilitiesHash' : [ 0x328, ['_SID_AND_ATTRIBUTES_HASH']],
    'LowboxNumberEntry' : [ 0x438, ['pointer64', ['_SEP_LOWBOX_NUMBER_ENTRY']]],
    'LowboxHandlesEntry' : [ 0x440, ['pointer64', ['_SEP_CACHED_HANDLES_ENTRY']]],
    'pClaimAttributes' : [ 0x448, ['pointer64', ['_AUTHZBASEP_CLAIM_ATTRIBUTES_COLLECTION']]],
    'TrustLevelSid' : [ 0x450, ['pointer64', ['void']]],
    'TrustLinkedToken' : [ 0x458, ['pointer64', ['_TOKEN']]],
    'IntegrityLevelSidValue' : [ 0x460, ['pointer64', ['void']]],
    'TokenSidValues' : [ 0x468, ['pointer64', ['_SEP_SID_VALUES_BLOCK']]],
    'IndexEntry' : [ 0x470, ['pointer64', ['_SEP_LUID_TO_INDEX_MAP_ENTRY']]],
    'DiagnosticInfo' : [ 0x478, ['pointer64', ['_SEP_TOKEN_DIAG_TRACK_ENTRY']]],
    'BnoIsolationHandlesEntry' : [ 0x480, ['pointer64', ['_SEP_CACHED_HANDLES_ENTRY']]],
    'SessionObject' : [ 0x488, ['pointer64', ['void']]],
    'VariablePart' : [ 0x490, ['unsigned long long']],
} ],
  '_SEP_LOGON_SESSION_REFERENCES' : [ 0xc0, {
    'Next' : [ 0x0, ['pointer64', ['_SEP_LOGON_SESSION_REFERENCES']]],
    'LogonId' : [ 0x8, ['_LUID']],
    'BuddyLogonId' : [ 0x10, ['_LUID']],
    'ReferenceCount' : [ 0x18, ['long long']],
    'Flags' : [ 0x20, ['unsigned long']],
    'pDeviceMap' : [ 0x28, ['pointer64', ['_DEVICE_MAP']]],
    'Token' : [ 0x30, ['pointer64', ['void']]],
    'AccountName' : [ 0x38, ['_UNICODE_STRING']],
    'AuthorityName' : [ 0x48, ['_UNICODE_STRING']],
    'CachedHandlesTable' : [ 0x58, ['_SEP_CACHED_HANDLES_TABLE']],
    'SharedDataLock' : [ 0x68, ['_EX_PUSH_LOCK']],
    'SharedClaimAttributes' : [ 0x70, ['pointer64', ['_AUTHZBASEP_CLAIM_ATTRIBUTES_COLLECTION']]],
    'SharedSidValues' : [ 0x78, ['pointer64', ['_SEP_SID_VALUES_BLOCK']]],
    'RevocationBlock' : [ 0x80, ['_OB_HANDLE_REVOCATION_BLOCK']],
    'ServerSilo' : [ 0xa0, ['pointer64', ['_EJOB']]],
    'SiblingAuthId' : [ 0xa8, ['_LUID']],
    'TokenList' : [ 0xb0, ['_LIST_ENTRY']],
} ],
  '_OBJECT_HEADER' : [ 0x38, {
    'PointerCount' : [ 0x0, ['long long']],
    'HandleCount' : [ 0x8, ['long long']],
    'NextToFree' : [ 0x8, ['pointer64', ['void']]],
    'Lock' : [ 0x10, ['_EX_PUSH_LOCK']],
    'TypeIndex' : [ 0x18, ['unsigned char']],
    'TraceFlags' : [ 0x19, ['unsigned char']],
    'DbgRefTrace' : [ 0x19, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'DbgTracePermanent' : [ 0x19, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'InfoMask' : [ 0x1a, ['unsigned char']],
    'Flags' : [ 0x1b, ['unsigned char']],
    'NewObject' : [ 0x1b, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'KernelObject' : [ 0x1b, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'KernelOnlyAccess' : [ 0x1b, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'ExclusiveObject' : [ 0x1b, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'PermanentObject' : [ 0x1b, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'DefaultSecurityQuota' : [ 0x1b, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'SingleHandleEntry' : [ 0x1b, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned char')]],
    'DeletedInline' : [ 0x1b, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
    'Reserved' : [ 0x1c, ['unsigned long']],
    'ObjectCreateInfo' : [ 0x20, ['pointer64', ['_OBJECT_CREATE_INFORMATION']]],
    'QuotaBlockCharged' : [ 0x20, ['pointer64', ['void']]],
    'SecurityDescriptor' : [ 0x28, ['pointer64', ['void']]],
    'Body' : [ 0x30, ['_QUAD']],
} ],
  '_OBJECT_HEADER_QUOTA_INFO' : [ 0x20, {
    'PagedPoolCharge' : [ 0x0, ['unsigned long']],
    'NonPagedPoolCharge' : [ 0x4, ['unsigned long']],
    'SecurityDescriptorCharge' : [ 0x8, ['unsigned long']],
    'Reserved1' : [ 0xc, ['unsigned long']],
    'SecurityDescriptorQuotaBlock' : [ 0x10, ['pointer64', ['void']]],
    'Reserved2' : [ 0x18, ['unsigned long long']],
} ],
  '_OBJECT_HEADER_PROCESS_INFO' : [ 0x10, {
    'ExclusiveProcess' : [ 0x0, ['pointer64', ['_EPROCESS']]],
    'Reserved' : [ 0x8, ['unsigned long long']],
} ],
  '_OBJECT_HEADER_HANDLE_INFO' : [ 0x10, {
    'HandleCountDataBase' : [ 0x0, ['pointer64', ['_OBJECT_HANDLE_COUNT_DATABASE']]],
    'SingleEntry' : [ 0x0, ['_OBJECT_HANDLE_COUNT_ENTRY']],
} ],
  '_OBJECT_HEADER_NAME_INFO' : [ 0x20, {
    'Directory' : [ 0x0, ['pointer64', ['_OBJECT_DIRECTORY']]],
    'Name' : [ 0x8, ['_UNICODE_STRING']],
    'ReferenceCount' : [ 0x18, ['long']],
    'Reserved' : [ 0x1c, ['unsigned long']],
} ],
  '_OBJECT_HEADER_CREATOR_INFO' : [ 0x20, {
    'TypeList' : [ 0x0, ['_LIST_ENTRY']],
    'CreatorUniqueProcess' : [ 0x10, ['pointer64', ['void']]],
    'CreatorBackTraceIndex' : [ 0x18, ['unsigned short']],
    'Reserved1' : [ 0x1a, ['unsigned short']],
    'Reserved2' : [ 0x1c, ['unsigned long']],
} ],
  '_OBJECT_HEADER_AUDIT_INFO' : [ 0x10, {
    'SecurityDescriptor' : [ 0x0, ['pointer64', ['void']]],
    'Reserved' : [ 0x8, ['unsigned long long']],
} ],
  '_OBJECT_HEADER_EXTENDED_INFO' : [ 0x10, {
    'Footer' : [ 0x0, ['pointer64', ['_OBJECT_FOOTER']]],
    'Reserved' : [ 0x8, ['unsigned long long']],
} ],
  '_OBJECT_FOOTER' : [ 0x30, {
    'HandleRevocationInfo' : [ 0x0, ['_HANDLE_REVOCATION_INFO']],
    'ExtendedUserInfo' : [ 0x20, ['_OB_EXTENDED_USER_INFO']],
} ],
  '_OB_EXTENDED_USER_INFO' : [ 0x10, {
    'Context1' : [ 0x0, ['pointer64', ['void']]],
    'Context2' : [ 0x8, ['pointer64', ['void']]],
} ],
  '_HANDLE_REVOCATION_INFO' : [ 0x20, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'RevocationBlock' : [ 0x10, ['pointer64', ['_OB_HANDLE_REVOCATION_BLOCK']]],
    'AllowHandleRevocation' : [ 0x18, ['unsigned char']],
    'Padding1' : [ 0x19, ['array', 3, ['unsigned char']]],
    'Padding2' : [ 0x1c, ['array', 4, ['unsigned char']]],
} ],
  '_OBP_LOOKUP_CONTEXT' : [ 0x28, {
    'Directory' : [ 0x0, ['pointer64', ['_OBJECT_DIRECTORY']]],
    'Object' : [ 0x8, ['pointer64', ['void']]],
    'EntryLink' : [ 0x10, ['pointer64', ['pointer64', ['_OBJECT_DIRECTORY_ENTRY']]]],
    'HashValue' : [ 0x18, ['unsigned long']],
    'HashIndex' : [ 0x1c, ['unsigned short']],
    'DirectoryLocked' : [ 0x1e, ['unsigned char']],
    'LockedExclusive' : [ 0x1f, ['unsigned char']],
    'LockStateSignature' : [ 0x20, ['unsigned long']],
} ],
  '_OBJECT_DIRECTORY' : [ 0x158, {
    'HashBuckets' : [ 0x0, ['array', 37, ['pointer64', ['_OBJECT_DIRECTORY_ENTRY']]]],
    'Lock' : [ 0x128, ['_EX_PUSH_LOCK']],
    'DeviceMap' : [ 0x130, ['pointer64', ['_DEVICE_MAP']]],
    'ShadowDirectory' : [ 0x138, ['pointer64', ['_OBJECT_DIRECTORY']]],
    'NamespaceEntry' : [ 0x140, ['pointer64', ['void']]],
    'SessionObject' : [ 0x148, ['pointer64', ['void']]],
    'Flags' : [ 0x150, ['unsigned long']],
    'SessionId' : [ 0x154, ['unsigned long']],
} ],
  '_OBP_SILODRIVERSTATE' : [ 0x2e0, {
    'SystemDeviceMap' : [ 0x0, ['pointer64', ['_DEVICE_MAP']]],
    'SystemDosDeviceState' : [ 0x8, ['_OBP_SYSTEM_DOS_DEVICE_STATE']],
    'DeviceMapLock' : [ 0x78, ['_EX_PUSH_LOCK']],
    'PrivateNamespaceLookupTable' : [ 0x80, ['_OBJECT_NAMESPACE_LOOKUPTABLE']],
} ],
  '_WHEAP_INFO_BLOCK' : [ 0x18, {
    'ErrorSourceCount' : [ 0x0, ['unsigned long']],
    'ErrorSourceTable' : [ 0x8, ['pointer64', ['_WHEAP_ERROR_SOURCE_TABLE']]],
    'WorkQueue' : [ 0x10, ['pointer64', ['_WHEAP_WORK_QUEUE']]],
} ],
  '_WHEAP_ERROR_SOURCE' : [ 0x428, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'FailedAllocations' : [ 0x10, ['unsigned long']],
    'PlatformErrorSourceId' : [ 0x14, ['unsigned long']],
    'ErrorCount' : [ 0x18, ['long']],
    'RecordCount' : [ 0x1c, ['unsigned long']],
    'RecordLength' : [ 0x20, ['unsigned long']],
    'PoolTag' : [ 0x24, ['unsigned long']],
    'Type' : [ 0x28, ['Enumeration', dict(target = 'long', choices = {0: u'WheaErrSrcTypeMCE', 1: u'WheaErrSrcTypeCMC', 2: u'WheaErrSrcTypeCPE', 3: u'WheaErrSrcTypeNMI', 4: u'WheaErrSrcTypePCIe', 5: u'WheaErrSrcTypeGeneric', 6: u'WheaErrSrcTypeINIT', 7: u'WheaErrSrcTypeBOOT', 8: u'WheaErrSrcTypeSCIGeneric', 9: u'WheaErrSrcTypeIPFMCA', 10: u'WheaErrSrcTypeIPFCMC', 11: u'WheaErrSrcTypeIPFCPE', 12: u'WheaErrSrcTypeGenericV2', 13: u'WheaErrSrcTypeSCIGenericV2', 14: u'WheaErrSrcTypeMax'})]],
    'Records' : [ 0x30, ['pointer64', ['_WHEAP_ERROR_RECORD_WRAPPER']]],
    'Context' : [ 0x38, ['pointer64', ['void']]],
    'SectionCount' : [ 0x40, ['unsigned long']],
    'SectionLength' : [ 0x44, ['unsigned long']],
    'TickCountAtLastError' : [ 0x48, ['_LARGE_INTEGER']],
    'AccumulatedErrors' : [ 0x50, ['unsigned long']],
    'TotalErrors' : [ 0x54, ['unsigned long']],
    'Deferred' : [ 0x58, ['unsigned char']],
    'Descriptor' : [ 0x59, ['_WHEA_ERROR_SOURCE_DESCRIPTOR']],
} ],
  '_WHEAP_ERROR_RECORD_WRAPPER' : [ 0xf0, {
    'WorkEntry' : [ 0x0, ['_LIST_ENTRY']],
    'Length' : [ 0x10, ['unsigned long']],
    'ProcessorNumber' : [ 0x14, ['unsigned long']],
    'Flags' : [ 0x18, ['_WHEAP_ERROR_RECORD_WRAPPER_FLAGS']],
    'InUse' : [ 0x1c, ['long']],
    'ErrorSource' : [ 0x20, ['pointer64', ['_WHEAP_ERROR_SOURCE']]],
    'ErrorRecord' : [ 0x28, ['_WHEA_ERROR_RECORD']],
} ],
  '_GENERAL_LOOKASIDE_POOL' : [ 0x60, {
    'ListHead' : [ 0x0, ['_SLIST_HEADER']],
    'SingleListHead' : [ 0x0, ['_SINGLE_LIST_ENTRY']],
    'Depth' : [ 0x10, ['unsigned short']],
    'MaximumDepth' : [ 0x12, ['unsigned short']],
    'TotalAllocates' : [ 0x14, ['unsigned long']],
    'AllocateMisses' : [ 0x18, ['unsigned long']],
    'AllocateHits' : [ 0x18, ['unsigned long']],
    'TotalFrees' : [ 0x1c, ['unsigned long']],
    'FreeMisses' : [ 0x20, ['unsigned long']],
    'FreeHits' : [ 0x20, ['unsigned long']],
    'Type' : [ 0x24, ['Enumeration', dict(target = 'long', choices = {0: u'NonPagedPoolBase', 1: u'PagedPool', 2: u'NonPagedPoolBaseMustSucceed', 3: u'DontUseThisType', 4: u'NonPagedPoolBaseCacheAligned', 5: u'PagedPoolCacheAligned', 6: u'NonPagedPoolBaseCacheAlignedMustS', 7: u'MaxPoolType', 34: u'NonPagedPoolMustSucceedSession', 516: u'NonPagedPoolNxCacheAligned', 35: u'DontUseThisTypeSession', 32: u'NonPagedPoolSession', 512: u'NonPagedPoolNx', 544: u'NonPagedPoolSessionNx', 36: u'NonPagedPoolCacheAlignedSession', 33: u'PagedPoolSession', 38: u'NonPagedPoolCacheAlignedMustSSession', 37: u'PagedPoolCacheAlignedSession'})]],
    'Tag' : [ 0x28, ['unsigned long']],
    'Size' : [ 0x2c, ['unsigned long']],
    'AllocateEx' : [ 0x30, ['pointer64', ['void']]],
    'Allocate' : [ 0x30, ['pointer64', ['void']]],
    'FreeEx' : [ 0x38, ['pointer64', ['void']]],
    'Free' : [ 0x38, ['pointer64', ['void']]],
    'ListEntry' : [ 0x40, ['_LIST_ENTRY']],
    'LastTotalAllocates' : [ 0x50, ['unsigned long']],
    'LastAllocateMisses' : [ 0x54, ['unsigned long']],
    'LastAllocateHits' : [ 0x54, ['unsigned long']],
    'Future' : [ 0x58, ['array', 2, ['unsigned long']]],
} ],
  '_PCW_CALLBACK_INFORMATION' : [ 0x28, {
    'AddCounter' : [ 0x0, ['_PCW_COUNTER_INFORMATION']],
    'RemoveCounter' : [ 0x0, ['_PCW_COUNTER_INFORMATION']],
    'EnumerateInstances' : [ 0x0, ['_PCW_MASK_INFORMATION']],
    'CollectData' : [ 0x0, ['_PCW_MASK_INFORMATION']],
} ],
  '_WNF_STATE_NAME' : [ 0x8, {
    'Data' : [ 0x0, ['array', 2, ['unsigned long']]],
} ],
  '_MMSECTION_FLAGS' : [ 0x4, {
    'BeingDeleted' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'BeingCreated' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'BeingPurged' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'NoModifiedWriting' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'FailAllIo' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'Image' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'Based' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'File' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'AttemptingDelete' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'PrefetchCreated' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'PhysicalMemory' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'ImageControlAreaOnRemovableMedia' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'Reserve' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long')]],
    'Commit' : [ 0x0, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long')]],
    'NoChange' : [ 0x0, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long')]],
    'WasPurged' : [ 0x0, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'UserReference' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'GlobalMemory' : [ 0x0, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'DeleteOnClose' : [ 0x0, ['BitField', dict(start_bit = 18, end_bit = 19, native_type='unsigned long')]],
    'FilePointerNull' : [ 0x0, ['BitField', dict(start_bit = 19, end_bit = 20, native_type='unsigned long')]],
    'PreferredNode' : [ 0x0, ['BitField', dict(start_bit = 20, end_bit = 26, native_type='unsigned long')]],
    'GlobalOnlyPerSession' : [ 0x0, ['BitField', dict(start_bit = 26, end_bit = 27, native_type='unsigned long')]],
    'UserWritable' : [ 0x0, ['BitField', dict(start_bit = 27, end_bit = 28, native_type='unsigned long')]],
    'SystemVaAllocated' : [ 0x0, ['BitField', dict(start_bit = 28, end_bit = 29, native_type='unsigned long')]],
    'PreferredFsCompressionBoundary' : [ 0x0, ['BitField', dict(start_bit = 29, end_bit = 30, native_type='unsigned long')]],
    'UsingFileExtents' : [ 0x0, ['BitField', dict(start_bit = 30, end_bit = 31, native_type='unsigned long')]],
    'PageSize64K' : [ 0x0, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
} ],
  '_PEP_ACPI_SPB_RESOURCE' : [ 0x28, {
    'Type' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: u'PepAcpiMemory', 1: u'PepAcpiIoPort', 2: u'PepAcpiInterrupt', 3: u'PepAcpiGpioIo', 4: u'PepAcpiGpioInt', 5: u'PepAcpiSpbI2c', 6: u'PepAcpiSpbSpi', 7: u'PepAcpiSpbUart', 8: u'PepAcpiExtendedMemory', 9: u'PepAcpiExtendedIo'})]],
    'Flags' : [ 0x4, ['_PEP_ACPI_RESOURCE_FLAGS']],
    'TypeSpecificFlags' : [ 0x8, ['unsigned short']],
    'ResourceSourceIndex' : [ 0xa, ['unsigned char']],
    'ResourceSourceName' : [ 0x10, ['pointer64', ['_UNICODE_STRING']]],
    'VendorData' : [ 0x18, ['pointer64', ['unsigned char']]],
    'VendorDataLength' : [ 0x20, ['unsigned short']],
} ],
  '_DBGKD_GET_VERSION32' : [ 0x28, {
    'MajorVersion' : [ 0x0, ['unsigned short']],
    'MinorVersion' : [ 0x2, ['unsigned short']],
    'ProtocolVersion' : [ 0x4, ['unsigned short']],
    'Flags' : [ 0x6, ['unsigned short']],
    'KernBase' : [ 0x8, ['unsigned long']],
    'PsLoadedModuleList' : [ 0xc, ['unsigned long']],
    'MachineType' : [ 0x10, ['unsigned short']],
    'ThCallbackStack' : [ 0x12, ['unsigned short']],
    'NextCallback' : [ 0x14, ['unsigned short']],
    'FramePointer' : [ 0x16, ['unsigned short']],
    'KiCallUserMode' : [ 0x18, ['unsigned long']],
    'KeUserCallbackDispatcher' : [ 0x1c, ['unsigned long']],
    'BreakpointWithStatus' : [ 0x20, ['unsigned long']],
    'DebuggerDataList' : [ 0x24, ['unsigned long']],
} ],
  '_HANDLE_TABLE_FREE_LIST' : [ 0x40, {
    'FreeListLock' : [ 0x0, ['_EX_PUSH_LOCK']],
    'FirstFreeHandleEntry' : [ 0x8, ['pointer64', ['_HANDLE_TABLE_ENTRY']]],
    'LastFreeHandleEntry' : [ 0x10, ['pointer64', ['_HANDLE_TABLE_ENTRY']]],
    'HandleCount' : [ 0x18, ['long']],
    'HighWaterMark' : [ 0x1c, ['unsigned long']],
} ],
  '_VF_KE_CRITICAL_REGION_TRACE' : [ 0x40, {
    'Thread' : [ 0x0, ['pointer64', ['_ETHREAD']]],
    'StackTrace' : [ 0x8, ['array', 7, ['pointer64', ['void']]]],
} ],
  '_KDPC_DATA' : [ 0x28, {
    'DpcList' : [ 0x0, ['_KDPC_LIST']],
    'DpcLock' : [ 0x10, ['unsigned long long']],
    'DpcQueueDepth' : [ 0x18, ['long']],
    'DpcCount' : [ 0x1c, ['unsigned long']],
    'ActiveDpc' : [ 0x20, ['pointer64', ['_KDPC']]],
} ],
  '_DBGKD_QUERY_SPECIAL_CALLS' : [ 0x4, {
    'NumberOfSpecialCalls' : [ 0x0, ['unsigned long']],
} ],
  '_PLATFORM_IDLE_ACCOUNTING' : [ 0x408, {
    'ResetCount' : [ 0x0, ['unsigned long']],
    'StateCount' : [ 0x4, ['unsigned long']],
    'DeepSleepCount' : [ 0x8, ['unsigned long']],
    'TimeUnit' : [ 0xc, ['Enumeration', dict(target = 'long', choices = {0: u'PpmIdleBucketTimeInQpc', 1: u'PpmIdleBucketTimeIn100ns', 2: u'PpmIdleBucketTimeMaximum'})]],
    'StartTime' : [ 0x10, ['unsigned long long']],
    'State' : [ 0x18, ['array', 1, ['_PLATFORM_IDLE_STATE_ACCOUNTING']]],
} ],
  '_ACTIVATION_CONTEXT_STACK32' : [ 0x18, {
    'ActiveFrame' : [ 0x0, ['unsigned long']],
    'FrameListCache' : [ 0x4, ['LIST_ENTRY32']],
    'Flags' : [ 0xc, ['unsigned long']],
    'NextCookieSequenceNumber' : [ 0x10, ['unsigned long']],
    'StackId' : [ 0x14, ['unsigned long']],
} ],
  '_IMAGE_ROM_OPTIONAL_HEADER' : [ 0x38, {
    'Magic' : [ 0x0, ['unsigned short']],
    'MajorLinkerVersion' : [ 0x2, ['unsigned char']],
    'MinorLinkerVersion' : [ 0x3, ['unsigned char']],
    'SizeOfCode' : [ 0x4, ['unsigned long']],
    'SizeOfInitializedData' : [ 0x8, ['unsigned long']],
    'SizeOfUninitializedData' : [ 0xc, ['unsigned long']],
    'AddressOfEntryPoint' : [ 0x10, ['unsigned long']],
    'BaseOfCode' : [ 0x14, ['unsigned long']],
    'BaseOfData' : [ 0x18, ['unsigned long']],
    'BaseOfBss' : [ 0x1c, ['unsigned long']],
    'GprMask' : [ 0x20, ['unsigned long']],
    'CprMask' : [ 0x24, ['array', 4, ['unsigned long']]],
    'GpValue' : [ 0x34, ['unsigned long']],
} ],
  '__unnamed_205c' : [ 0x4, {
    'LongFlags' : [ 0x0, ['unsigned long']],
    'Flags' : [ 0x0, ['_MM_SESSION_SPACE_FLAGS']],
} ],
  '_MM_SESSION_SPACE' : [ 0x5000, {
    'ReferenceCount' : [ 0x0, ['long']],
    'u' : [ 0x4, ['__unnamed_205c']],
    'SessionId' : [ 0x8, ['unsigned long']],
    'ProcessReferenceToSession' : [ 0xc, ['long']],
    'ProcessList' : [ 0x10, ['_LIST_ENTRY']],
    'SessionPageDirectoryIndex' : [ 0x20, ['unsigned long long']],
    'NonPagablePages' : [ 0x28, ['unsigned long long']],
    'CommittedPages' : [ 0x30, ['unsigned long long']],
    'PagedPoolStart' : [ 0x38, ['pointer64', ['void']]],
    'PagedPoolEnd' : [ 0x40, ['pointer64', ['void']]],
    'SessionObject' : [ 0x48, ['pointer64', ['void']]],
    'SessionObjectHandle' : [ 0x50, ['pointer64', ['void']]],
    'SessionPoolAllocationFailures' : [ 0x58, ['array', 4, ['unsigned long']]],
    'ImageTree' : [ 0x68, ['_RTL_AVL_TREE']],
    'LocaleId' : [ 0x70, ['unsigned long']],
    'AttachCount' : [ 0x74, ['unsigned long']],
    'AttachGate' : [ 0x78, ['_KGATE']],
    'WsListEntry' : [ 0x90, ['_LIST_ENTRY']],
    'PagedPoolInfo' : [ 0xa0, ['_MM_PAGED_POOL_INFO']],
    'Lookaside' : [ 0x100, ['array', 21, ['_GENERAL_LOOKASIDE']]],
    'Session' : [ 0xb80, ['_MMSESSION']],
    'Vm' : [ 0xbc0, ['_MMSUPPORT_FULL']],
    'WorkingSetList' : [ 0xd00, ['_MMWSL_INSTANCE']],
    'AggregateSessionWs' : [ 0xd40, ['_MMSUPPORT_AGGREGATION']],
    'HeapState' : [ 0xd60, ['pointer64', ['void']]],
    'PagedPool' : [ 0xd80, ['_POOL_DESCRIPTOR']],
    'DriverUnload' : [ 0x1ec0, ['_MI_SESSION_DRIVER_UNLOAD']],
    'TopLevelPteLockBits' : [ 0x1ec8, ['array', 32, ['unsigned long']]],
    'PageDirectory' : [ 0x1f48, ['_MMPTE']],
    'SessionVaLock' : [ 0x1f50, ['_EX_PUSH_LOCK']],
    'DynamicVaBitMap' : [ 0x1f58, ['_RTL_BITMAP_EX']],
    'DynamicVaHint' : [ 0x1f68, ['unsigned long long']],
    'SpecialPool' : [ 0x1f70, ['_MI_SPECIAL_POOL']],
    'SessionPteLock' : [ 0x1fb0, ['_EX_PUSH_LOCK']],
    'PoolBigEntriesInUse' : [ 0x1fb8, ['long']],
    'PagedPoolPdeCount' : [ 0x1fbc, ['unsigned long']],
    'SpecialPoolPdeCount' : [ 0x1fc0, ['unsigned long']],
    'DynamicSessionPdeCount' : [ 0x1fc4, ['unsigned long']],
    'SystemPteInfo' : [ 0x1fc8, ['_MI_SYSTEM_PTE_TYPE']],
    'PoolTrackTableExpansion' : [ 0x2028, ['pointer64', ['void']]],
    'PoolTrackTableExpansionSize' : [ 0x2030, ['unsigned long long']],
    'PoolTrackBigPages' : [ 0x2038, ['pointer64', ['void']]],
    'PoolTrackBigPagesSize' : [ 0x2040, ['unsigned long long']],
    'PermittedFaultsTree' : [ 0x2048, ['_RTL_AVL_TREE']],
    'IoState' : [ 0x2050, ['Enumeration', dict(target = 'long', choices = {1: u'IoSessionStateCreated', 2: u'IoSessionStateInitialized', 3: u'IoSessionStateConnected', 4: u'IoSessionStateDisconnected', 5: u'IoSessionStateDisconnectedLoggedOn', 6: u'IoSessionStateLoggedOn', 7: u'IoSessionStateLoggedOff', 8: u'IoSessionStateTerminated', 9: u'IoSessionStateMax'})]],
    'IoStateSequence' : [ 0x2054, ['unsigned long']],
    'IoNotificationEvent' : [ 0x2058, ['_KEVENT']],
    'ServerSilo' : [ 0x2070, ['pointer64', ['_EJOB']]],
    'CreateTime' : [ 0x2078, ['unsigned long long']],
    'PoolTags' : [ 0x3000, ['array', 8192, ['unsigned char']]],
} ],
  '_OBJECT_NAMESPACE_LOOKUPTABLE' : [ 0x260, {
    'HashBuckets' : [ 0x0, ['array', 37, ['_LIST_ENTRY']]],
    'Lock' : [ 0x250, ['_EX_PUSH_LOCK']],
    'NumberOfPrivateSpaces' : [ 0x258, ['unsigned long']],
} ],
  '_CMP_VOLUME_CONTEXT' : [ 0x48, {
    'VolumeContextListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'VolumeManager' : [ 0x10, ['pointer64', ['_CMP_VOLUME_MANAGER']]],
    'RefCount' : [ 0x18, ['long long']],
    'VolumeGuid' : [ 0x20, ['_GUID']],
    'VolumeFileObject' : [ 0x30, ['pointer64', ['void']]],
    'VolumeContextLock' : [ 0x38, ['_CMSI_RW_LOCK']],
    'DeviceUsageNotificationSent' : [ 0x40, ['unsigned char']],
} ],
  '_MI_CACHED_PTES' : [ 0x48, {
    'Bins' : [ 0x0, ['array', 8, ['_MI_CACHED_PTE']]],
    'CachedPteCount' : [ 0x40, ['long']],
} ],
  '_OBJECT_TYPE_INITIALIZER' : [ 0x78, {
    'Length' : [ 0x0, ['unsigned short']],
    'ObjectTypeFlags' : [ 0x2, ['unsigned short']],
    'CaseInsensitive' : [ 0x2, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'UnnamedObjectsOnly' : [ 0x2, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'UseDefaultObject' : [ 0x2, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'SecurityRequired' : [ 0x2, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'MaintainHandleCount' : [ 0x2, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'MaintainTypeList' : [ 0x2, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'SupportsObjectCallbacks' : [ 0x2, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned char')]],
    'CacheAligned' : [ 0x2, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
    'UseExtendedParameters' : [ 0x3, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'Reserved' : [ 0x3, ['BitField', dict(start_bit = 1, end_bit = 8, native_type='unsigned char')]],
    'ObjectTypeCode' : [ 0x4, ['unsigned long']],
    'InvalidAttributes' : [ 0x8, ['unsigned long']],
    'GenericMapping' : [ 0xc, ['_GENERIC_MAPPING']],
    'ValidAccessMask' : [ 0x1c, ['unsigned long']],
    'RetainAccess' : [ 0x20, ['unsigned long']],
    'PoolType' : [ 0x24, ['Enumeration', dict(target = 'long', choices = {0: u'NonPagedPoolBase', 1: u'PagedPool', 2: u'NonPagedPoolBaseMustSucceed', 3: u'DontUseThisType', 4: u'NonPagedPoolBaseCacheAligned', 5: u'PagedPoolCacheAligned', 6: u'NonPagedPoolBaseCacheAlignedMustS', 7: u'MaxPoolType', 34: u'NonPagedPoolMustSucceedSession', 516: u'NonPagedPoolNxCacheAligned', 35: u'DontUseThisTypeSession', 32: u'NonPagedPoolSession', 512: u'NonPagedPoolNx', 544: u'NonPagedPoolSessionNx', 36: u'NonPagedPoolCacheAlignedSession', 33: u'PagedPoolSession', 38: u'NonPagedPoolCacheAlignedMustSSession', 37: u'PagedPoolCacheAlignedSession'})]],
    'DefaultPagedPoolCharge' : [ 0x28, ['unsigned long']],
    'DefaultNonPagedPoolCharge' : [ 0x2c, ['unsigned long']],
    'DumpProcedure' : [ 0x30, ['pointer64', ['void']]],
    'OpenProcedure' : [ 0x38, ['pointer64', ['void']]],
    'CloseProcedure' : [ 0x40, ['pointer64', ['void']]],
    'DeleteProcedure' : [ 0x48, ['pointer64', ['void']]],
    'ParseProcedure' : [ 0x50, ['pointer64', ['void']]],
    'ParseProcedureEx' : [ 0x50, ['pointer64', ['void']]],
    'SecurityProcedure' : [ 0x58, ['pointer64', ['void']]],
    'QueryNameProcedure' : [ 0x60, ['pointer64', ['void']]],
    'OkayToCloseProcedure' : [ 0x68, ['pointer64', ['void']]],
    'WaitObjectFlagMask' : [ 0x70, ['unsigned long']],
    'WaitObjectFlagOffset' : [ 0x74, ['unsigned short']],
    'WaitObjectPointerOffset' : [ 0x76, ['unsigned short']],
} ],
  '_KLOCK_ENTRY' : [ 0x60, {
    'TreeNode' : [ 0x0, ['_RTL_BALANCED_NODE']],
    'FreeListEntry' : [ 0x0, ['_SINGLE_LIST_ENTRY']],
    'EntryFlags' : [ 0x18, ['unsigned long']],
    'EntryOffset' : [ 0x18, ['unsigned char']],
    'ThreadLocalFlags' : [ 0x19, ['unsigned char']],
    'WaitingBit' : [ 0x19, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'Spare0' : [ 0x19, ['BitField', dict(start_bit = 1, end_bit = 8, native_type='unsigned char')]],
    'AcquiredByte' : [ 0x1a, ['unsigned char']],
    'AcquiredBit' : [ 0x1a, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'CrossThreadFlags' : [ 0x1b, ['unsigned char']],
    'HeadNodeBit' : [ 0x1b, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'IoPriorityBit' : [ 0x1b, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'IoQoSWaiter' : [ 0x1b, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'Spare1' : [ 0x1b, ['BitField', dict(start_bit = 3, end_bit = 8, native_type='unsigned char')]],
    'StaticState' : [ 0x18, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned long')]],
    'AllFlags' : [ 0x18, ['BitField', dict(start_bit = 8, end_bit = 32, native_type='unsigned long')]],
    'SpareFlags' : [ 0x1c, ['unsigned long']],
    'LockState' : [ 0x20, ['_KLOCK_ENTRY_LOCK_STATE']],
    'LockUnsafe' : [ 0x20, ['pointer64', ['void']]],
    'CrossThreadReleasableAndBusyByte' : [ 0x20, ['unsigned char']],
    'Reserved' : [ 0x21, ['array', 6, ['unsigned char']]],
    'InTreeByte' : [ 0x27, ['unsigned char']],
    'SessionState' : [ 0x28, ['pointer64', ['void']]],
    'SessionId' : [ 0x28, ['unsigned long']],
    'SessionPad' : [ 0x2c, ['unsigned long']],
    'OwnerTree' : [ 0x30, ['_RTL_RB_TREE']],
    'WaiterTree' : [ 0x40, ['_RTL_RB_TREE']],
    'CpuPriorityKey' : [ 0x30, ['unsigned char']],
    'EntryLock' : [ 0x50, ['unsigned long long']],
    'BoostBitmap' : [ 0x58, ['_KLOCK_ENTRY_BOOST_BITMAP']],
    'SparePad' : [ 0x5c, ['unsigned long']],
} ],
  '_KTHREAD_COUNTERS' : [ 0x1a8, {
    'WaitReasonBitMap' : [ 0x0, ['unsigned long long']],
    'UserData' : [ 0x8, ['pointer64', ['_THREAD_PERFORMANCE_DATA']]],
    'Flags' : [ 0x10, ['unsigned long']],
    'ContextSwitches' : [ 0x14, ['unsigned long']],
    'CycleTimeBias' : [ 0x18, ['unsigned long long']],
    'HardwareCounters' : [ 0x20, ['unsigned long long']],
    'HwCounter' : [ 0x28, ['array', 16, ['_COUNTER_READING']]],
} ],
  '_HEAP_TAG_ENTRY' : [ 0x48, {
    'Allocs' : [ 0x0, ['unsigned long']],
    'Frees' : [ 0x4, ['unsigned long']],
    'Size' : [ 0x8, ['unsigned long long']],
    'TagIndex' : [ 0x10, ['unsigned short']],
    'CreatorBackTraceIndex' : [ 0x12, ['unsigned short']],
    'TagName' : [ 0x14, ['array', 24, ['wchar']]],
} ],
  '_DBGKD_ANY_CONTROL_SET' : [ 0x1c, {
    'X86ControlSet' : [ 0x0, ['_X86_DBGKD_CONTROL_SET']],
    'AlphaControlSet' : [ 0x0, ['unsigned long']],
    'IA64ControlSet' : [ 0x0, ['_IA64_DBGKD_CONTROL_SET']],
    'Amd64ControlSet' : [ 0x0, ['_AMD64_DBGKD_CONTROL_SET']],
    'ArmControlSet' : [ 0x0, ['_ARM_DBGKD_CONTROL_SET']],
    'Arm64ControlSet' : [ 0x0, ['_ARM64_DBGKD_CONTROL_SET']],
    'ArmCeControlSet' : [ 0x0, ['_ARMCE_DBGKD_CONTROL_SET']],
    'PpcControlSet' : [ 0x0, ['_PPC_DBGKD_CONTROL_SET']],
} ],
  '_MMVAD_FLAGS' : [ 0x4, {
    'VadType' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 3, native_type='unsigned long')]],
    'Protection' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 8, native_type='unsigned long')]],
    'PreferredNode' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 14, native_type='unsigned long')]],
    'PrivateMemory' : [ 0x0, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long')]],
    'PrivateFixup' : [ 0x0, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'Enclave' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'PageSize64K' : [ 0x0, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'RfgControlStack' : [ 0x0, ['BitField', dict(start_bit = 18, end_bit = 19, native_type='unsigned long')]],
    'Spare' : [ 0x0, ['BitField', dict(start_bit = 19, end_bit = 27, native_type='unsigned long')]],
    'NoChange' : [ 0x0, ['BitField', dict(start_bit = 27, end_bit = 28, native_type='unsigned long')]],
    'ManySubsections' : [ 0x0, ['BitField', dict(start_bit = 28, end_bit = 29, native_type='unsigned long')]],
    'DeleteInProgress' : [ 0x0, ['BitField', dict(start_bit = 29, end_bit = 30, native_type='unsigned long')]],
    'LockContended' : [ 0x0, ['BitField', dict(start_bit = 30, end_bit = 31, native_type='unsigned long')]],
    'Lock' : [ 0x0, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
} ],
  '_HEAP_COUNTERS' : [ 0x78, {
    'TotalMemoryReserved' : [ 0x0, ['unsigned long long']],
    'TotalMemoryCommitted' : [ 0x8, ['unsigned long long']],
    'TotalMemoryLargeUCR' : [ 0x10, ['unsigned long long']],
    'TotalSizeInVirtualBlocks' : [ 0x18, ['unsigned long long']],
    'TotalSegments' : [ 0x20, ['unsigned long']],
    'TotalUCRs' : [ 0x24, ['unsigned long']],
    'CommittOps' : [ 0x28, ['unsigned long']],
    'DeCommitOps' : [ 0x2c, ['unsigned long']],
    'LockAcquires' : [ 0x30, ['unsigned long']],
    'LockCollisions' : [ 0x34, ['unsigned long']],
    'CommitRate' : [ 0x38, ['unsigned long']],
    'DecommittRate' : [ 0x3c, ['unsigned long']],
    'CommitFailures' : [ 0x40, ['unsigned long']],
    'InBlockCommitFailures' : [ 0x44, ['unsigned long']],
    'PollIntervalCounter' : [ 0x48, ['unsigned long']],
    'DecommitsSinceLastCheck' : [ 0x4c, ['unsigned long']],
    'HeapPollInterval' : [ 0x50, ['unsigned long']],
    'AllocAndFreeOps' : [ 0x54, ['unsigned long']],
    'AllocationIndicesActive' : [ 0x58, ['unsigned long']],
    'InBlockDeccommits' : [ 0x5c, ['unsigned long']],
    'InBlockDeccomitSize' : [ 0x60, ['unsigned long long']],
    'HighWatermarkSize' : [ 0x68, ['unsigned long long']],
    'LastPolledSize' : [ 0x70, ['unsigned long long']],
} ],
  '_INTERFACE' : [ 0x20, {
    'Size' : [ 0x0, ['unsigned short']],
    'Version' : [ 0x2, ['unsigned short']],
    'Context' : [ 0x8, ['pointer64', ['void']]],
    'InterfaceReference' : [ 0x10, ['pointer64', ['void']]],
    'InterfaceDereference' : [ 0x18, ['pointer64', ['void']]],
} ],
  '_HEAP_PSEUDO_TAG_ENTRY' : [ 0x10, {
    'Allocs' : [ 0x0, ['unsigned long']],
    'Frees' : [ 0x4, ['unsigned long']],
    'Size' : [ 0x8, ['unsigned long long']],
} ],
  '_POP_IRP_WORKER_ENTRY' : [ 0x30, {
    'Link' : [ 0x0, ['_LIST_ENTRY']],
    'Thread' : [ 0x10, ['pointer64', ['_ETHREAD']]],
    'Irp' : [ 0x18, ['pointer64', ['_IRP']]],
    'Device' : [ 0x20, ['pointer64', ['_DEVICE_OBJECT']]],
    'Static' : [ 0x28, ['unsigned char']],
} ],
  '__unnamed_20c7' : [ 0x20, {
    'CallerCompletion' : [ 0x0, ['pointer64', ['void']]],
    'CallerContext' : [ 0x8, ['pointer64', ['void']]],
    'CallerDevice' : [ 0x10, ['pointer64', ['_DEVICE_OBJECT']]],
    'SystemWake' : [ 0x18, ['unsigned char']],
} ],
  '__unnamed_20ca' : [ 0x10, {
    'NotifyDevice' : [ 0x0, ['pointer64', ['_PO_DEVICE_NOTIFY']]],
    'FxDeviceActivated' : [ 0x8, ['unsigned char']],
} ],
  '_POP_IRP_DATA' : [ 0xf8, {
    'Link' : [ 0x0, ['_LIST_ENTRY']],
    'Irp' : [ 0x10, ['pointer64', ['_IRP']]],
    'Pdo' : [ 0x18, ['pointer64', ['_DEVICE_OBJECT']]],
    'TargetDevice' : [ 0x20, ['pointer64', ['_DEVICE_OBJECT']]],
    'CurrentDevice' : [ 0x28, ['pointer64', ['_DEVICE_OBJECT']]],
    'WatchdogStart' : [ 0x30, ['unsigned long long']],
    'WatchdogTimer' : [ 0x38, ['_KTIMER']],
    'WatchdogDpc' : [ 0x78, ['_KDPC']],
    'MinorFunction' : [ 0xb8, ['unsigned char']],
    'PowerStateType' : [ 0xbc, ['Enumeration', dict(target = 'long', choices = {0: u'SystemPowerState', 1: u'DevicePowerState'})]],
    'PowerState' : [ 0xc0, ['_POWER_STATE']],
    'WatchdogEnabled' : [ 0xc4, ['unsigned char']],
    'FxDevice' : [ 0xc8, ['pointer64', ['_POP_FX_DEVICE']]],
    'SystemTransition' : [ 0xd0, ['unsigned char']],
    'NotifyPEP' : [ 0xd1, ['unsigned char']],
    'IrpSequenceID' : [ 0xd4, ['long']],
    'Device' : [ 0xd8, ['__unnamed_20c7']],
    'System' : [ 0xd8, ['__unnamed_20ca']],
} ],
  '_CLIENT_ID' : [ 0x10, {
    'UniqueProcess' : [ 0x0, ['pointer64', ['void']]],
    'UniqueThread' : [ 0x8, ['pointer64', ['void']]],
} ],
  '_PROCESS_DISK_COUNTERS' : [ 0x28, {
    'BytesRead' : [ 0x0, ['unsigned long long']],
    'BytesWritten' : [ 0x8, ['unsigned long long']],
    'ReadOperationCount' : [ 0x10, ['unsigned long long']],
    'WriteOperationCount' : [ 0x18, ['unsigned long long']],
    'FlushOperationCount' : [ 0x20, ['unsigned long long']],
} ],
  '_POOL_TRACKER_TABLE' : [ 0x38, {
    'Key' : [ 0x0, ['long']],
    'NonPagedBytes' : [ 0x8, ['unsigned long long']],
    'NonPagedAllocs' : [ 0x10, ['unsigned long long']],
    'NonPagedFrees' : [ 0x18, ['unsigned long long']],
    'PagedBytes' : [ 0x20, ['unsigned long long']],
    'PagedAllocs' : [ 0x28, ['unsigned long long']],
    'PagedFrees' : [ 0x30, ['unsigned long long']],
} ],
  '_KLOCK_ENTRY_BOOST_BITMAP' : [ 0x4, {
    'AllFields' : [ 0x0, ['unsigned long']],
    'AllBoosts' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 17, native_type='unsigned long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 17, end_bit = 32, native_type='unsigned long')]],
    'CpuBoostsBitmap' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 15, native_type='unsigned short')]],
    'IoBoost' : [ 0x0, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned short')]],
    'IoQoSBoost' : [ 0x2, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
    'IoNormalPriorityWaiterCount' : [ 0x2, ['BitField', dict(start_bit = 1, end_bit = 9, native_type='unsigned short')]],
    'IoQoSWaiterCount' : [ 0x2, ['BitField', dict(start_bit = 9, end_bit = 16, native_type='unsigned short')]],
} ],
  '_CMP_VOLUME_MANAGER' : [ 0x18, {
    'VolumeContextListLock' : [ 0x0, ['_CMSI_RW_LOCK']],
    'VolumeContextListHead' : [ 0x8, ['_LIST_ENTRY']],
} ],
  '_DBGKD_GET_SET_BUS_DATA' : [ 0x14, {
    'BusDataType' : [ 0x0, ['unsigned long']],
    'BusNumber' : [ 0x4, ['unsigned long']],
    'SlotNumber' : [ 0x8, ['unsigned long']],
    'Offset' : [ 0xc, ['unsigned long']],
    'Length' : [ 0x10, ['unsigned long']],
} ],
  '_DBGK_SILOSTATE' : [ 0x20, {
    'ErrorPortLock' : [ 0x0, ['_EX_PUSH_LOCK']],
    'ErrorPort' : [ 0x8, ['pointer64', ['_DBGKP_ERROR_PORT']]],
    'ErrorProcess' : [ 0x10, ['pointer64', ['_EPROCESS']]],
    'ErrorPortRegisteredEvent' : [ 0x18, ['pointer64', ['_KEVENT']]],
} ],
  '_STACK_TABLE' : [ 0x8088, {
    'NumStackTraces' : [ 0x0, ['unsigned short']],
    'TraceCapacity' : [ 0x2, ['unsigned short']],
    'StackTrace' : [ 0x8, ['array', 16, ['pointer64', ['_OBJECT_REF_TRACE']]]],
    'StackTableHash' : [ 0x88, ['array', 16381, ['unsigned short']]],
} ],
  '_PPM_IDLE_STATES' : [ 0x428, {
    'InterfaceVersion' : [ 0x0, ['unsigned char']],
    'IdleOverride' : [ 0x1, ['unsigned char']],
    'EstimateIdleDuration' : [ 0x2, ['unsigned char']],
    'ExitLatencyTraceEnabled' : [ 0x3, ['unsigned char']],
    'NonInterruptibleTransition' : [ 0x4, ['unsigned char']],
    'UnaccountedTransition' : [ 0x5, ['unsigned char']],
    'IdleDurationLimited' : [ 0x6, ['unsigned char']],
    'IdleCheckLimited' : [ 0x7, ['unsigned char']],
    'StrictVetoBias' : [ 0x8, ['unsigned char']],
    'ExitLatencyCountdown' : [ 0xc, ['unsigned long']],
    'TargetState' : [ 0x10, ['unsigned long']],
    'ActualState' : [ 0x14, ['unsigned long']],
    'OldState' : [ 0x18, ['unsigned long']],
    'OverrideIndex' : [ 0x1c, ['unsigned long']],
    'ProcessorIdleCount' : [ 0x20, ['unsigned long']],
    'Type' : [ 0x24, ['unsigned long']],
    'LevelId' : [ 0x28, ['unsigned long long']],
    'ReasonFlags' : [ 0x30, ['unsigned short']],
    'InitiateWakeStamp' : [ 0x38, ['unsigned long long']],
    'PreviousStatus' : [ 0x40, ['long']],
    'PreviousCancelReason' : [ 0x44, ['unsigned long']],
    'PrimaryProcessorMask' : [ 0x48, ['_KAFFINITY_EX']],
    'SecondaryProcessorMask' : [ 0xf0, ['_KAFFINITY_EX']],
    'IdlePrepare' : [ 0x198, ['pointer64', ['void']]],
    'IdlePreExecute' : [ 0x1a0, ['pointer64', ['void']]],
    'IdleExecute' : [ 0x1a8, ['pointer64', ['void']]],
    'IdlePreselect' : [ 0x1b0, ['pointer64', ['void']]],
    'IdleTest' : [ 0x1b8, ['pointer64', ['void']]],
    'IdleAvailabilityCheck' : [ 0x1c0, ['pointer64', ['void']]],
    'IdleComplete' : [ 0x1c8, ['pointer64', ['void']]],
    'IdleCancel' : [ 0x1d0, ['pointer64', ['void']]],
    'IdleIsHalted' : [ 0x1d8, ['pointer64', ['void']]],
    'IdleInitiateWake' : [ 0x1e0, ['pointer64', ['void']]],
    'PrepareInfo' : [ 0x1e8, ['_PROCESSOR_IDLE_PREPARE_INFO']],
    'DeepIdleSnapshot' : [ 0x240, ['_KAFFINITY_EX']],
    'Tracing' : [ 0x2e8, ['pointer64', ['_PERFINFO_PPM_STATE_SELECTION']]],
    'CoordinatedTracing' : [ 0x2f0, ['pointer64', ['_PERFINFO_PPM_STATE_SELECTION']]],
    'ProcessorMenu' : [ 0x2f8, ['_PPM_SELECTION_MENU']],
    'CoordinatedMenu' : [ 0x308, ['_PPM_SELECTION_MENU']],
    'CoordinatedSelection' : [ 0x318, ['_PPM_COORDINATED_SELECTION']],
    'State' : [ 0x330, ['array', 1, ['_PPM_IDLE_STATE']]],
} ],
  '_MMVAD_FLAGS1' : [ 0x4, {
    'CommitCharge' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 31, native_type='unsigned long')]],
    'MemCommit' : [ 0x0, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
} ],
  '_EVENT_HEADER_EXTENDED_DATA_ITEM' : [ 0x10, {
    'Reserved1' : [ 0x0, ['unsigned short']],
    'ExtType' : [ 0x2, ['unsigned short']],
    'Linkage' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
    'Reserved2' : [ 0x4, ['BitField', dict(start_bit = 1, end_bit = 16, native_type='unsigned short')]],
    'DataSize' : [ 0x6, ['unsigned short']],
    'DataPtr' : [ 0x8, ['unsigned long long']],
} ],
  '_ETW_HASH_BUCKET' : [ 0x38, {
    'ListHead' : [ 0x0, ['array', 3, ['_LIST_ENTRY']]],
    'BucketLock' : [ 0x30, ['_EX_PUSH_LOCK']],
} ],
  '__unnamed_2121' : [ 0x3a4, {
    'XpfMceDescriptor' : [ 0x0, ['_WHEA_XPF_MCE_DESCRIPTOR']],
    'XpfCmcDescriptor' : [ 0x0, ['_WHEA_XPF_CMC_DESCRIPTOR']],
    'XpfNmiDescriptor' : [ 0x0, ['_WHEA_XPF_NMI_DESCRIPTOR']],
    'IpfMcaDescriptor' : [ 0x0, ['_WHEA_IPF_MCA_DESCRIPTOR']],
    'IpfCmcDescriptor' : [ 0x0, ['_WHEA_IPF_CMC_DESCRIPTOR']],
    'IpfCpeDescriptor' : [ 0x0, ['_WHEA_IPF_CPE_DESCRIPTOR']],
    'AerRootportDescriptor' : [ 0x0, ['_WHEA_AER_ROOTPORT_DESCRIPTOR']],
    'AerEndpointDescriptor' : [ 0x0, ['_WHEA_AER_ENDPOINT_DESCRIPTOR']],
    'AerBridgeDescriptor' : [ 0x0, ['_WHEA_AER_BRIDGE_DESCRIPTOR']],
    'GenErrDescriptor' : [ 0x0, ['_WHEA_GENERIC_ERROR_DESCRIPTOR']],
    'GenErrDescriptorV2' : [ 0x0, ['_WHEA_GENERIC_ERROR_DESCRIPTOR_V2']],
} ],
  '_WHEA_ERROR_SOURCE_DESCRIPTOR' : [ 0x3cc, {
    'Length' : [ 0x0, ['unsigned long']],
    'Version' : [ 0x4, ['unsigned long']],
    'Type' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {0: u'WheaErrSrcTypeMCE', 1: u'WheaErrSrcTypeCMC', 2: u'WheaErrSrcTypeCPE', 3: u'WheaErrSrcTypeNMI', 4: u'WheaErrSrcTypePCIe', 5: u'WheaErrSrcTypeGeneric', 6: u'WheaErrSrcTypeINIT', 7: u'WheaErrSrcTypeBOOT', 8: u'WheaErrSrcTypeSCIGeneric', 9: u'WheaErrSrcTypeIPFMCA', 10: u'WheaErrSrcTypeIPFCMC', 11: u'WheaErrSrcTypeIPFCPE', 12: u'WheaErrSrcTypeGenericV2', 13: u'WheaErrSrcTypeSCIGenericV2', 14: u'WheaErrSrcTypeMax'})]],
    'State' : [ 0xc, ['Enumeration', dict(target = 'long', choices = {1: u'WheaErrSrcStateStopped', 2: u'WheaErrSrcStateStarted'})]],
    'MaxRawDataLength' : [ 0x10, ['unsigned long']],
    'NumRecordsToPreallocate' : [ 0x14, ['unsigned long']],
    'MaxSectionsPerRecord' : [ 0x18, ['unsigned long']],
    'ErrorSourceId' : [ 0x1c, ['unsigned long']],
    'PlatformErrorSourceId' : [ 0x20, ['unsigned long']],
    'Flags' : [ 0x24, ['unsigned long']],
    'Info' : [ 0x28, ['__unnamed_2121']],
} ],
  '_VI_DEADLOCK_RESOURCE' : [ 0xf8, {
    'Type' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: u'VfDeadlockUnknown', 1: u'VfDeadlockMutex', 2: u'VfDeadlockMutexAbandoned', 3: u'VfDeadlockFastMutex', 4: u'VfDeadlockFastMutexUnsafe', 5: u'VfDeadlockSpinLock', 6: u'VfDeadlockInStackQueuedSpinLock', 7: u'VfDeadlockUnusedSpinLock', 8: u'VfDeadlockEresource', 9: u'VfDeadlockTypeMaximum'})]],
    'NodeCount' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 16, native_type='unsigned long')]],
    'RecursionCount' : [ 0x4, ['BitField', dict(start_bit = 16, end_bit = 32, native_type='unsigned long')]],
    'ResourceAddress' : [ 0x8, ['pointer64', ['void']]],
    'ThreadOwner' : [ 0x10, ['pointer64', ['_VI_DEADLOCK_THREAD']]],
    'ResourceList' : [ 0x18, ['_LIST_ENTRY']],
    'HashChainList' : [ 0x28, ['_LIST_ENTRY']],
    'FreeListEntry' : [ 0x28, ['_LIST_ENTRY']],
    'StackTrace' : [ 0x38, ['array', 8, ['pointer64', ['void']]]],
    'LastAcquireTrace' : [ 0x78, ['array', 8, ['pointer64', ['void']]]],
    'LastReleaseTrace' : [ 0xb8, ['array', 8, ['pointer64', ['void']]]],
} ],
  '_SEP_TOKEN_DIAG_TRACK_ENTRY' : [ 0x120, {
    'ProcessCid' : [ 0x0, ['pointer64', ['void']]],
    'ThreadCid' : [ 0x8, ['pointer64', ['void']]],
    'ImageFileName' : [ 0x10, ['array', 16, ['unsigned char']]],
    'CreateMethod' : [ 0x20, ['unsigned long']],
    'CreateTrace' : [ 0x28, ['array', 30, ['unsigned long long']]],
    'Count' : [ 0x118, ['long']],
    'CaptureCount' : [ 0x11c, ['long']],
} ],
  '_EX_PUSH_LOCK_AUTO_EXPAND_STATE' : [ 0x4, {
    'Expanded' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Transitioning' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'Pageable' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'Value' : [ 0x0, ['unsigned long']],
} ],
  '_DUMMY_FILE_OBJECT' : [ 0x110, {
    'ObjectHeader' : [ 0x0, ['_OBJECT_HEADER']],
    'FileObjectBody' : [ 0x38, ['array', 216, ['unsigned char']]],
} ],
  '_HARDWARE_PTE' : [ 0x8, {
    'Valid' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'Write' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long long')]],
    'Owner' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long long')]],
    'WriteThrough' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long long')]],
    'CacheDisable' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long long')]],
    'Accessed' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long long')]],
    'Dirty' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long long')]],
    'LargePage' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long long')]],
    'Global' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long long')]],
    'CopyOnWrite' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long long')]],
    'Prototype' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long long')]],
    'reserved0' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long long')]],
    'PageFrameNumber' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 48, native_type='unsigned long long')]],
    'reserved1' : [ 0x0, ['BitField', dict(start_bit = 48, end_bit = 52, native_type='unsigned long long')]],
    'SoftwareWsIndex' : [ 0x0, ['BitField', dict(start_bit = 52, end_bit = 63, native_type='unsigned long long')]],
    'NoExecute' : [ 0x0, ['BitField', dict(start_bit = 63, end_bit = 64, native_type='unsigned long long')]],
} ],
  '_PPM_POLICY_SETTINGS_MASK' : [ 0x8, {
    'Value' : [ 0x0, ['unsigned long long']],
    'PerfDecreaseTime' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'PerfIncreaseTime' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'PerfDecreasePolicy' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'PerfIncreasePolicy' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'PerfDecreaseThreshold' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'PerfIncreaseThreshold' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'PerfMinPolicy' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'PerfMaxPolicy' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'PerfTimeCheck' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'PerfBoostPolicy' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'PerfBoostMode' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'AllowThrottling' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'PerfHistoryCount' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long')]],
    'ParkingPerfState' : [ 0x0, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long')]],
    'LatencyHintPerf' : [ 0x0, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long')]],
    'LatencyHintUnpark' : [ 0x0, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'CoreParkingMinCores' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'CoreParkingMaxCores' : [ 0x0, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'CoreParkingDecreasePolicy' : [ 0x0, ['BitField', dict(start_bit = 18, end_bit = 19, native_type='unsigned long')]],
    'CoreParkingIncreasePolicy' : [ 0x0, ['BitField', dict(start_bit = 19, end_bit = 20, native_type='unsigned long')]],
    'CoreParkingDecreaseTime' : [ 0x0, ['BitField', dict(start_bit = 20, end_bit = 21, native_type='unsigned long')]],
    'CoreParkingIncreaseTime' : [ 0x0, ['BitField', dict(start_bit = 21, end_bit = 22, native_type='unsigned long')]],
    'CoreParkingOverUtilizationThreshold' : [ 0x0, ['BitField', dict(start_bit = 22, end_bit = 23, native_type='unsigned long')]],
    'CoreParkingDistributeUtility' : [ 0x0, ['BitField', dict(start_bit = 23, end_bit = 24, native_type='unsigned long')]],
    'CoreParkingConcurrencyThreshold' : [ 0x0, ['BitField', dict(start_bit = 24, end_bit = 25, native_type='unsigned long')]],
    'CoreParkingHeadroomThreshold' : [ 0x0, ['BitField', dict(start_bit = 25, end_bit = 26, native_type='unsigned long')]],
    'CoreParkingDistributionThreshold' : [ 0x0, ['BitField', dict(start_bit = 26, end_bit = 27, native_type='unsigned long')]],
    'IdleAllowScaling' : [ 0x0, ['BitField', dict(start_bit = 27, end_bit = 28, native_type='unsigned long')]],
    'IdleDisable' : [ 0x0, ['BitField', dict(start_bit = 28, end_bit = 29, native_type='unsigned long')]],
    'IdleTimeCheck' : [ 0x0, ['BitField', dict(start_bit = 29, end_bit = 30, native_type='unsigned long')]],
    'IdleDemoteThreshold' : [ 0x0, ['BitField', dict(start_bit = 30, end_bit = 31, native_type='unsigned long')]],
    'IdlePromoteThreshold' : [ 0x0, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
    'HeteroDecreaseTime' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'HeteroIncreaseTime' : [ 0x4, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'HeteroDecreaseThreshold' : [ 0x4, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'HeteroIncreaseThreshold' : [ 0x4, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'Class0FloorPerformance' : [ 0x4, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'Class1InitialPerformance' : [ 0x4, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'EnergyPerfPreference' : [ 0x4, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'AutonomousActivityWindow' : [ 0x4, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'AutonomousMode' : [ 0x4, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'DutyCycling' : [ 0x4, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'FrequencyCap' : [ 0x4, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'ThreadPolicy' : [ 0x4, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'ShortThreadPolicy' : [ 0x4, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long')]],
    'IdleStateMax' : [ 0x4, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long')]],
    'Spare' : [ 0x4, ['BitField', dict(start_bit = 14, end_bit = 32, native_type='unsigned long')]],
} ],
  '_KSCHEDULING_GROUP' : [ 0x240, {
    'Policy' : [ 0x0, ['_KSCHEDULING_GROUP_POLICY']],
    'RelativeWeight' : [ 0x8, ['unsigned long']],
    'ChildMinRate' : [ 0xc, ['unsigned long']],
    'ChildMinWeight' : [ 0x10, ['unsigned long']],
    'ChildTotalWeight' : [ 0x14, ['unsigned long']],
    'QueryHistoryTimeStamp' : [ 0x18, ['unsigned long long']],
    'NotificationCycles' : [ 0x20, ['long long']],
    'MaxQuotaLimitCycles' : [ 0x28, ['long long']],
    'MaxQuotaCyclesRemaining' : [ 0x30, ['long long']],
    'SchedulingGroupList' : [ 0x38, ['_LIST_ENTRY']],
    'Sibling' : [ 0x38, ['_LIST_ENTRY']],
    'NotificationDpc' : [ 0x48, ['pointer64', ['_KDPC']]],
    'ChildList' : [ 0x50, ['_LIST_ENTRY']],
    'Parent' : [ 0x60, ['pointer64', ['_KSCHEDULING_GROUP']]],
    'PerProcessor' : [ 0x80, ['array', 1, ['_KSCB']]],
} ],
  '_CM_INTENT_LOCK' : [ 0x10, {
    'OwnerCount' : [ 0x0, ['unsigned long']],
    'OwnerTable' : [ 0x8, ['pointer64', ['pointer64', ['_CM_KCB_UOW']]]],
} ],
  '_AUTHZBASEP_CLAIM_ATTRIBUTES_COLLECTION' : [ 0x260, {
    'DeviceGroupsCount' : [ 0x0, ['unsigned long']],
    'pDeviceGroups' : [ 0x8, ['pointer64', ['_SID_AND_ATTRIBUTES']]],
    'RestrictedDeviceGroupsCount' : [ 0x10, ['unsigned long']],
    'pRestrictedDeviceGroups' : [ 0x18, ['pointer64', ['_SID_AND_ATTRIBUTES']]],
    'DeviceGroupsHash' : [ 0x20, ['_SID_AND_ATTRIBUTES_HASH']],
    'RestrictedDeviceGroupsHash' : [ 0x130, ['_SID_AND_ATTRIBUTES_HASH']],
    'pUserSecurityAttributes' : [ 0x240, ['pointer64', ['_AUTHZBASEP_SECURITY_ATTRIBUTES_INFORMATION']]],
    'pDeviceSecurityAttributes' : [ 0x248, ['pointer64', ['_AUTHZBASEP_SECURITY_ATTRIBUTES_INFORMATION']]],
    'pRestrictedUserSecurityAttributes' : [ 0x250, ['pointer64', ['_AUTHZBASEP_SECURITY_ATTRIBUTES_INFORMATION']]],
    'pRestrictedDeviceSecurityAttributes' : [ 0x258, ['pointer64', ['_AUTHZBASEP_SECURITY_ATTRIBUTES_INFORMATION']]],
} ],
  '_TEB_ACTIVE_FRAME' : [ 0x18, {
    'Flags' : [ 0x0, ['unsigned long']],
    'Previous' : [ 0x8, ['pointer64', ['_TEB_ACTIVE_FRAME']]],
    'Context' : [ 0x10, ['pointer64', ['_TEB_ACTIVE_FRAME_CONTEXT']]],
} ],
  '_DEVICE_CAPABILITIES' : [ 0x40, {
    'Size' : [ 0x0, ['unsigned short']],
    'Version' : [ 0x2, ['unsigned short']],
    'DeviceD1' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'DeviceD2' : [ 0x4, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'LockSupported' : [ 0x4, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'EjectSupported' : [ 0x4, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'Removable' : [ 0x4, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'DockDevice' : [ 0x4, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'UniqueID' : [ 0x4, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'SilentInstall' : [ 0x4, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'RawDeviceOK' : [ 0x4, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'SurpriseRemovalOK' : [ 0x4, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'WakeFromD0' : [ 0x4, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'WakeFromD1' : [ 0x4, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'WakeFromD2' : [ 0x4, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long')]],
    'WakeFromD3' : [ 0x4, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long')]],
    'HardwareDisabled' : [ 0x4, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long')]],
    'NonDynamic' : [ 0x4, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'WarmEjectSupported' : [ 0x4, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'NoDisplayInUI' : [ 0x4, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'Reserved1' : [ 0x4, ['BitField', dict(start_bit = 18, end_bit = 19, native_type='unsigned long')]],
    'WakeFromInterrupt' : [ 0x4, ['BitField', dict(start_bit = 19, end_bit = 20, native_type='unsigned long')]],
    'SecureDevice' : [ 0x4, ['BitField', dict(start_bit = 20, end_bit = 21, native_type='unsigned long')]],
    'ChildOfVgaEnabledBridge' : [ 0x4, ['BitField', dict(start_bit = 21, end_bit = 22, native_type='unsigned long')]],
    'DecodeIoOnBoot' : [ 0x4, ['BitField', dict(start_bit = 22, end_bit = 23, native_type='unsigned long')]],
    'Reserved' : [ 0x4, ['BitField', dict(start_bit = 23, end_bit = 32, native_type='unsigned long')]],
    'Address' : [ 0x8, ['unsigned long']],
    'UINumber' : [ 0xc, ['unsigned long']],
    'DeviceState' : [ 0x10, ['array', 7, ['Enumeration', dict(target = 'long', choices = {0: u'PowerDeviceUnspecified', 1: u'PowerDeviceD0', 2: u'PowerDeviceD1', 3: u'PowerDeviceD2', 4: u'PowerDeviceD3', 5: u'PowerDeviceMaximum'})]]],
    'SystemWake' : [ 0x2c, ['Enumeration', dict(target = 'long', choices = {0: u'PowerSystemUnspecified', 1: u'PowerSystemWorking', 2: u'PowerSystemSleeping1', 3: u'PowerSystemSleeping2', 4: u'PowerSystemSleeping3', 5: u'PowerSystemHibernate', 6: u'PowerSystemShutdown', 7: u'PowerSystemMaximum'})]],
    'DeviceWake' : [ 0x30, ['Enumeration', dict(target = 'long', choices = {0: u'PowerDeviceUnspecified', 1: u'PowerDeviceD0', 2: u'PowerDeviceD1', 3: u'PowerDeviceD2', 4: u'PowerDeviceD3', 5: u'PowerDeviceMaximum'})]],
    'D1Latency' : [ 0x34, ['unsigned long']],
    'D2Latency' : [ 0x38, ['unsigned long']],
    'D3Latency' : [ 0x3c, ['unsigned long']],
} ],
  '_JOBOBJECT_ENERGY_TRACKING_STATE' : [ 0x8, {
    'Value' : [ 0x0, ['unsigned long long']],
    'UpdateMask' : [ 0x0, ['unsigned long']],
    'DesiredState' : [ 0x4, ['unsigned long']],
} ],
  '_LOCK_HEADER' : [ 0x28, {
    'LockTree' : [ 0x0, ['_RTL_AVL_TREE']],
    'LockMdlSwitchedTree' : [ 0x8, ['_RTL_AVL_TREE']],
    'Count' : [ 0x10, ['unsigned long long']],
    'Lock' : [ 0x18, ['unsigned long long']],
    'Valid' : [ 0x20, ['unsigned long']],
} ],
  '_SEP_CACHED_HANDLES_ENTRY' : [ 0x48, {
    'HashEntry' : [ 0x0, ['_RTL_DYNAMIC_HASH_TABLE_ENTRY']],
    'ReferenceCount' : [ 0x18, ['long long']],
    'EntryDescriptor' : [ 0x20, ['_SEP_CACHED_HANDLES_ENTRY_DESCRIPTOR']],
    'HandleCount' : [ 0x38, ['unsigned long']],
    'Handles' : [ 0x40, ['pointer64', ['pointer64', ['void']]]],
} ],
  '_PROCESSOR_PROFILE_CONTROL_AREA' : [ 0x60, {
    'PebsDsSaveArea' : [ 0x0, ['_PEBS_DS_SAVE_AREA']],
} ],
  '_KHETERO_PROCESSOR_SET' : [ 0x18, {
    'IdealMask' : [ 0x0, ['unsigned long long']],
    'PreferredMask' : [ 0x8, ['unsigned long long']],
    'AvailableMask' : [ 0x10, ['unsigned long long']],
} ],
  '_CM_NAME_HASH' : [ 0x18, {
    'ConvKey' : [ 0x0, ['_CM_COMPONENT_HASH']],
    'NextHash' : [ 0x8, ['pointer64', ['_CM_NAME_HASH']]],
    'NameLength' : [ 0x10, ['unsigned short']],
    'Name' : [ 0x12, ['array', 1, ['wchar']]],
} ],
  '_MMSESSION' : [ 0x20, {
    'SystemSpaceViewLock' : [ 0x0, ['_EX_PUSH_LOCK']],
    'SystemSpaceViewLockPointer' : [ 0x8, ['pointer64', ['_EX_PUSH_LOCK']]],
    'ViewRoot' : [ 0x10, ['_RTL_AVL_TREE']],
    'ViewCount' : [ 0x18, ['unsigned long']],
    'BitmapFailures' : [ 0x1c, ['unsigned long']],
} ],
  '_CC_ASYNC_READ_CONTEXT' : [ 0x20, {
    'CompletionRoutine' : [ 0x0, ['pointer64', ['void']]],
    'Context' : [ 0x8, ['pointer64', ['void']]],
    'Mdl' : [ 0x10, ['pointer64', ['_MDL']]],
    'RequestorMode' : [ 0x18, ['unsigned char']],
    'NestingLevel' : [ 0x1c, ['unsigned long']],
} ],
  '_CLIENT_ID64' : [ 0x10, {
    'UniqueProcess' : [ 0x0, ['unsigned long long']],
    'UniqueThread' : [ 0x8, ['unsigned long long']],
} ],
  '_DIRTY_PAGE_STATISTICS' : [ 0x18, {
    'DirtyPages' : [ 0x0, ['unsigned long long']],
    'DirtyPagesLastScan' : [ 0x8, ['unsigned long long']],
    'DirtyPagesScheduledLastScan' : [ 0x10, ['unsigned long']],
} ],
  '_EPROCESS_VALUES' : [ 0x58, {
    'KernelTime' : [ 0x0, ['unsigned long long']],
    'UserTime' : [ 0x8, ['unsigned long long']],
    'ReadyTime' : [ 0x10, ['unsigned long long']],
    'CycleTime' : [ 0x18, ['unsigned long long']],
    'ContextSwitches' : [ 0x20, ['unsigned long long']],
    'ReadOperationCount' : [ 0x28, ['long long']],
    'WriteOperationCount' : [ 0x30, ['long long']],
    'OtherOperationCount' : [ 0x38, ['long long']],
    'ReadTransferCount' : [ 0x40, ['long long']],
    'WriteTransferCount' : [ 0x48, ['long long']],
    'OtherTransferCount' : [ 0x50, ['long long']],
} ],
  '_WHEA_XPF_CMC_DESCRIPTOR' : [ 0x3a4, {
    'Type' : [ 0x0, ['unsigned short']],
    'Enabled' : [ 0x2, ['unsigned char']],
    'NumberOfBanks' : [ 0x3, ['unsigned char']],
    'Reserved' : [ 0x4, ['unsigned long']],
    'Notify' : [ 0x8, ['_WHEA_NOTIFICATION_DESCRIPTOR']],
    'Banks' : [ 0x24, ['array', 32, ['_WHEA_XPF_MC_BANK_DESCRIPTOR']]],
} ],
  '_SK_CRASH_MINIDUMP' : [ 0x1000, {
    'Size' : [ 0x0, ['unsigned long']],
    'Version' : [ 0x4, ['unsigned long']],
    'ModuleCount' : [ 0x8, ['unsigned long']],
    'FrameCount' : [ 0xc, ['unsigned long']],
    'Modules' : [ 0x10, ['array', 16, ['_SK_CRASH_MODULE']]],
    'StackFrames' : [ 0x490, ['array', 366, ['_SK_CRASH_STACK_FRAME']]],
} ],
  '_SID_AND_ATTRIBUTES' : [ 0x10, {
    'Sid' : [ 0x0, ['pointer64', ['void']]],
    'Attributes' : [ 0x8, ['unsigned long']],
} ],
  '_SK_CRASH_STACK_FRAME' : [ 0x8, {
    'ModuleId' : [ 0x0, ['unsigned long']],
    'Rva' : [ 0x4, ['unsigned long']],
    'Pc' : [ 0x0, ['unsigned long long']],
} ],
  '_DEVICE_MAP' : [ 0x48, {
    'DosDevicesDirectory' : [ 0x0, ['pointer64', ['_OBJECT_DIRECTORY']]],
    'GlobalDosDevicesDirectory' : [ 0x8, ['pointer64', ['_OBJECT_DIRECTORY']]],
    'DosDevicesDirectoryHandle' : [ 0x10, ['pointer64', ['void']]],
    'ReferenceCount' : [ 0x18, ['long']],
    'DriveMap' : [ 0x1c, ['unsigned long']],
    'DriveType' : [ 0x20, ['array', 32, ['unsigned char']]],
    'ServerSilo' : [ 0x40, ['pointer64', ['_EJOB']]],
} ],
  '_RTL_BITMAP_EX' : [ 0x10, {
    'SizeOfBitMap' : [ 0x0, ['unsigned long long']],
    'Buffer' : [ 0x8, ['pointer64', ['unsigned long long']]],
} ],
  '_MMPTE_SUBSECTION' : [ 0x8, {
    'Valid' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'Unused0' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 5, native_type='unsigned long long')]],
    'Protection' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 10, native_type='unsigned long long')]],
    'Prototype' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long long')]],
    'ColdPage' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long long')]],
    'Unused1' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 15, native_type='unsigned long long')]],
    'ExecutePrivilege' : [ 0x0, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long long')]],
    'SubsectionAddress' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 64, native_type='long long')]],
} ],
  '_TRIAGE_9F_PNP' : [ 0x20, {
    'Signature' : [ 0x0, ['unsigned short']],
    'Revision' : [ 0x2, ['unsigned short']],
    'CompletionQueue' : [ 0x8, ['pointer64', ['_TRIAGE_PNP_DEVICE_COMPLETION_QUEUE']]],
    'DelayedWorkQueue' : [ 0x10, ['pointer64', ['_TRIAGE_EX_WORK_QUEUE']]],
    'DelayedIoWorkQueue' : [ 0x18, ['pointer64', ['_TRIAGE_EX_WORK_QUEUE']]],
} ],
  '_CM_KEY_SECURITY_CACHE_ENTRY' : [ 0x10, {
    'Cell' : [ 0x0, ['unsigned long']],
    'CachedSecurity' : [ 0x8, ['pointer64', ['_CM_KEY_SECURITY_CACHE']]],
} ],
  '_POP_CURRENT_BROADCAST' : [ 0x18, {
    'InProgress' : [ 0x0, ['unsigned char']],
    'SystemContext' : [ 0x4, ['_SYSTEM_POWER_STATE_CONTEXT']],
    'PowerAction' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {0: u'PowerActionNone', 1: u'PowerActionReserved', 2: u'PowerActionSleep', 3: u'PowerActionHibernate', 4: u'PowerActionShutdown', 5: u'PowerActionShutdownReset', 6: u'PowerActionShutdownOff', 7: u'PowerActionWarmEject', 8: u'PowerActionDisplayOff'})]],
    'DeviceState' : [ 0x10, ['pointer64', ['_POP_DEVICE_SYS_STATE']]],
} ],
  '_PHYSICAL_MEMORY_DESCRIPTOR' : [ 0x20, {
    'NumberOfRuns' : [ 0x0, ['unsigned long']],
    'NumberOfPages' : [ 0x8, ['unsigned long long']],
    'Run' : [ 0x10, ['array', 1, ['_PHYSICAL_MEMORY_RUN']]],
} ],
  '_MMPTE_HARDWARE' : [ 0x8, {
    'Valid' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'Dirty1' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long long')]],
    'Owner' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long long')]],
    'WriteThrough' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long long')]],
    'CacheDisable' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long long')]],
    'Accessed' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long long')]],
    'Dirty' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long long')]],
    'LargePage' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long long')]],
    'Global' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long long')]],
    'CopyOnWrite' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long long')]],
    'Unused' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long long')]],
    'Write' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long long')]],
    'PageFrameNumber' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 48, native_type='unsigned long long')]],
    'ReservedForHardware' : [ 0x0, ['BitField', dict(start_bit = 48, end_bit = 52, native_type='unsigned long long')]],
    'ReservedForSoftware' : [ 0x0, ['BitField', dict(start_bit = 52, end_bit = 56, native_type='unsigned long long')]],
    'WsleAge' : [ 0x0, ['BitField', dict(start_bit = 56, end_bit = 60, native_type='unsigned long long')]],
    'WsleProtection' : [ 0x0, ['BitField', dict(start_bit = 60, end_bit = 63, native_type='unsigned long long')]],
    'NoExecute' : [ 0x0, ['BitField', dict(start_bit = 63, end_bit = 64, native_type='unsigned long long')]],
} ],
  '_MM_SESSION_SPACE_FLAGS' : [ 0x4, {
    'Initialized' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'DeletePending' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'PoolInitialized' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'DynamicVaInitialized' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'WsInitialized' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'PoolDestroyed' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'ObjectInitialized' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'LeakedPoolDeliberately' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'SessionHeapInitialized' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'SessionHeapDestroyed' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'Filler' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 32, native_type='unsigned long')]],
} ],
  '_OBJECT_HANDLE_COUNT_DATABASE' : [ 0x18, {
    'CountEntries' : [ 0x0, ['unsigned long']],
    'HandleCountEntries' : [ 0x8, ['array', 1, ['_OBJECT_HANDLE_COUNT_ENTRY']]],
} ],
  '_JOB_RATE_CONTROL_HEADER' : [ 0x28, {
    'RateControlQuotaReference' : [ 0x0, ['pointer64', ['void']]],
    'OverQuotaHistory' : [ 0x8, ['_RTL_BITMAP']],
    'BitMapBuffer' : [ 0x18, ['pointer64', ['unsigned char']]],
    'BitMapBufferSize' : [ 0x20, ['unsigned long long']],
} ],
  '_RTL_DYNAMIC_HASH_TABLE_ENTRY' : [ 0x18, {
    'Linkage' : [ 0x0, ['_LIST_ENTRY']],
    'Signature' : [ 0x10, ['unsigned long long']],
} ],
  '_OBJECT_NAME_INFORMATION' : [ 0x10, {
    'Name' : [ 0x0, ['_UNICODE_STRING']],
} ],
  '_WHEA_GENERIC_ERROR_DESCRIPTOR_V2' : [ 0x50, {
    'Type' : [ 0x0, ['unsigned short']],
    'Reserved' : [ 0x2, ['unsigned char']],
    'Enabled' : [ 0x3, ['unsigned char']],
    'ErrStatusBlockLength' : [ 0x4, ['unsigned long']],
    'RelatedErrorSourceId' : [ 0x8, ['unsigned long']],
    'ErrStatusAddressSpaceID' : [ 0xc, ['unsigned char']],
    'ErrStatusAddressBitWidth' : [ 0xd, ['unsigned char']],
    'ErrStatusAddressBitOffset' : [ 0xe, ['unsigned char']],
    'ErrStatusAddressAccessSize' : [ 0xf, ['unsigned char']],
    'ErrStatusAddress' : [ 0x10, ['_LARGE_INTEGER']],
    'Notify' : [ 0x18, ['_WHEA_NOTIFICATION_DESCRIPTOR']],
    'ReadAckAddressSpaceID' : [ 0x34, ['unsigned char']],
    'ReadAckAddressBitWidth' : [ 0x35, ['unsigned char']],
    'ReadAckAddressBitOffset' : [ 0x36, ['unsigned char']],
    'ReadAckAddressAccessSize' : [ 0x37, ['unsigned char']],
    'ReadAckAddress' : [ 0x38, ['_LARGE_INTEGER']],
    'ReadAckPreserveMask' : [ 0x40, ['unsigned long long']],
    'ReadAckWriteMask' : [ 0x48, ['unsigned long long']],
} ],
  '_PROCESSOR_NUMBER' : [ 0x4, {
    'Group' : [ 0x0, ['unsigned short']],
    'Number' : [ 0x2, ['unsigned char']],
    'Reserved' : [ 0x3, ['unsigned char']],
} ],
  '_DBGKD_SET_CONTEXT' : [ 0x4, {
    'ContextFlags' : [ 0x0, ['unsigned long']],
} ],
  '_GDI_TEB_BATCH64' : [ 0x4e8, {
    'Offset' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 31, native_type='unsigned long')]],
    'HasRenderingCommand' : [ 0x0, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
    'HDC' : [ 0x8, ['unsigned long long']],
    'Buffer' : [ 0x10, ['array', 310, ['unsigned long']]],
} ],
  '_HEAP_TUNING_PARAMETERS' : [ 0x10, {
    'CommittThresholdShift' : [ 0x0, ['unsigned long']],
    'MaxPreCommittThreshold' : [ 0x8, ['unsigned long long']],
} ],
  '_LPCP_MESSAGE' : [ 0x50, {
    'Entry' : [ 0x0, ['_LIST_ENTRY']],
    'FreeEntry' : [ 0x0, ['_SINGLE_LIST_ENTRY']],
    'Reserved0' : [ 0x8, ['unsigned long']],
    'SenderPort' : [ 0x10, ['pointer64', ['void']]],
    'RepliedToThread' : [ 0x18, ['pointer64', ['_ETHREAD']]],
    'PortContext' : [ 0x20, ['pointer64', ['void']]],
    'Request' : [ 0x28, ['_PORT_MESSAGE']],
} ],
  '_MI_SPECIAL_POOL' : [ 0x40, {
    'Lock' : [ 0x0, ['unsigned long long']],
    'Paged' : [ 0x8, ['_MI_PTE_CHAIN_HEAD']],
    'NonPaged' : [ 0x20, ['_MI_PTE_CHAIN_HEAD']],
    'PagesInUse' : [ 0x38, ['unsigned long long']],
} ],
  '_PCW_MASK_INFORMATION' : [ 0x28, {
    'CounterMask' : [ 0x0, ['unsigned long long']],
    'InstanceMask' : [ 0x8, ['pointer64', ['_UNICODE_STRING']]],
    'InstanceId' : [ 0x10, ['unsigned long']],
    'CollectMultiple' : [ 0x14, ['unsigned char']],
    'Buffer' : [ 0x18, ['pointer64', ['_PCW_BUFFER']]],
    'CancelEvent' : [ 0x20, ['pointer64', ['_KEVENT']]],
} ],
  '_DBGKD_WRITE_CUSTOM_BREAKPOINT' : [ 0x18, {
    'BreakPointAddress' : [ 0x0, ['unsigned long long']],
    'BreakPointInstruction' : [ 0x8, ['unsigned long long']],
    'BreakPointHandle' : [ 0x10, ['unsigned long']],
    'BreakPointInstructionSize' : [ 0x14, ['unsigned char']],
    'BreakPointInstructionAlignment' : [ 0x15, ['unsigned char']],
} ],
  '_DBGKD_QUERY_MEMORY' : [ 0x18, {
    'Address' : [ 0x0, ['unsigned long long']],
    'Reserved' : [ 0x8, ['unsigned long long']],
    'AddressSpace' : [ 0x10, ['unsigned long']],
    'Flags' : [ 0x14, ['unsigned long']],
} ],
  '_OBJECT_REF_INFO' : [ 0x28, {
    'ObjectHeader' : [ 0x0, ['pointer64', ['_OBJECT_HEADER']]],
    'NextRef' : [ 0x8, ['pointer64', ['void']]],
    'ImageFileName' : [ 0x10, ['array', 16, ['unsigned char']]],
    'NextPos' : [ 0x20, ['unsigned short']],
    'MaxStacks' : [ 0x22, ['unsigned short']],
    'StackInfo' : [ 0x24, ['array', 0, ['_OBJECT_REF_STACK_INFO']]],
} ],
  '__unnamed_21dc' : [ 0x4, {
    'FlushCompleting' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='long')]],
    'FlushInProgress' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 32, native_type='long')]],
    'Long' : [ 0x0, ['long']],
} ],
  '_MI_PARTITION_STORES' : [ 0x90, {
    'WriteAllStoreHintedPages' : [ 0x0, ['__unnamed_21dc']],
    'VirtualPageFileNumber' : [ 0x4, ['unsigned long']],
    'Registered' : [ 0x8, ['unsigned long']],
    'ReadClusterSizeMax' : [ 0xc, ['unsigned long']],
    'EvictFlushRequestCount' : [ 0x10, ['unsigned long']],
    'ModifiedWriteDisableCount' : [ 0x14, ['unsigned long']],
    'WriteIssueFailures' : [ 0x18, ['unsigned long']],
    'WritesOutstanding' : [ 0x1c, ['unsigned long']],
    'EvictFlushLock' : [ 0x20, ['long']],
    'EvictionThread' : [ 0x28, ['pointer64', ['_ETHREAD']]],
    'EvictEvent' : [ 0x30, ['_KEVENT']],
    'WriteSupportSListHead' : [ 0x50, ['_SLIST_HEADER']],
    'EvictFlushCompleteEvent' : [ 0x60, ['_KEVENT']],
    'ModifiedWriteFailedBitmap' : [ 0x78, ['pointer64', ['_RTL_BITMAP']]],
    'StoreProcess' : [ 0x80, ['pointer64', ['_EPROCESS']]],
    'DeleteStoredPages' : [ 0x88, ['unsigned long']],
} ],
  '_PS_PROPERTY_SET' : [ 0x18, {
    'ListHead' : [ 0x0, ['_LIST_ENTRY']],
    'Lock' : [ 0x10, ['unsigned long long']],
} ],
  '_TRIAGE_EX_WORK_QUEUE' : [ 0x2b0, {
    'WorkPriQueue' : [ 0x0, ['_KPRIQUEUE']],
} ],
  '_PROCESSOR_IDLE_CONSTRAINTS' : [ 0x30, {
    'TotalTime' : [ 0x0, ['unsigned long long']],
    'IdleTime' : [ 0x8, ['unsigned long long']],
    'ExpectedIdleDuration' : [ 0x10, ['unsigned long long']],
    'MaxIdleDuration' : [ 0x18, ['unsigned long long']],
    'OverrideState' : [ 0x20, ['unsigned long']],
    'TimeCheck' : [ 0x24, ['unsigned long']],
    'PromotePercent' : [ 0x28, ['unsigned char']],
    'DemotePercent' : [ 0x29, ['unsigned char']],
    'Parked' : [ 0x2a, ['unsigned char']],
    'Interruptible' : [ 0x2b, ['unsigned char']],
    'PlatformIdle' : [ 0x2c, ['unsigned char']],
    'ExpectedWakeReason' : [ 0x2d, ['unsigned char']],
    'IdleStateMax' : [ 0x2e, ['unsigned char']],
} ],
  '_ALPC_PORT_ATTRIBUTES' : [ 0x48, {
    'Flags' : [ 0x0, ['unsigned long']],
    'SecurityQos' : [ 0x4, ['_SECURITY_QUALITY_OF_SERVICE']],
    'MaxMessageLength' : [ 0x10, ['unsigned long long']],
    'MemoryBandwidth' : [ 0x18, ['unsigned long long']],
    'MaxPoolUsage' : [ 0x20, ['unsigned long long']],
    'MaxSectionSize' : [ 0x28, ['unsigned long long']],
    'MaxViewSize' : [ 0x30, ['unsigned long long']],
    'MaxTotalSectionSize' : [ 0x38, ['unsigned long long']],
    'DupObjectTypes' : [ 0x40, ['unsigned long']],
    'Reserved' : [ 0x44, ['unsigned long']],
} ],
  '_THREAD_ENERGY_VALUES' : [ 0xc8, {
    'Cycles' : [ 0x0, ['array', 4, ['array', 2, ['unsigned long long']]]],
    'AttributedCycles' : [ 0x40, ['array', 4, ['array', 2, ['unsigned long long']]]],
    'WorkOnBehalfCycles' : [ 0x80, ['array', 4, ['array', 2, ['unsigned long long']]]],
    'CpuTimeline' : [ 0xc0, ['_TIMELINE_BITMAP']],
} ],
  '_WHEAP_WORK_QUEUE' : [ 0x88, {
    'ListHead' : [ 0x0, ['_LIST_ENTRY']],
    'ListLock' : [ 0x10, ['unsigned long long']],
    'ItemCount' : [ 0x18, ['long']],
    'Dpc' : [ 0x20, ['_KDPC']],
    'WorkItem' : [ 0x60, ['_WORK_QUEUE_ITEM']],
    'WorkRoutine' : [ 0x80, ['pointer64', ['void']]],
} ],
  '_EXCEPTION_RECORD' : [ 0x98, {
    'ExceptionCode' : [ 0x0, ['long']],
    'ExceptionFlags' : [ 0x4, ['unsigned long']],
    'ExceptionRecord' : [ 0x8, ['pointer64', ['_EXCEPTION_RECORD']]],
    'ExceptionAddress' : [ 0x10, ['pointer64', ['void']]],
    'NumberParameters' : [ 0x18, ['unsigned long']],
    'ExceptionInformation' : [ 0x20, ['array', 15, ['unsigned long long']]],
} ],
  '_RTL_RUN_ONCE' : [ 0x8, {
    'Ptr' : [ 0x0, ['pointer64', ['void']]],
    'Value' : [ 0x0, ['unsigned long long']],
    'State' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 2, native_type='unsigned long long')]],
} ],
  '_CM_PATH_HASH' : [ 0x4, {
    'Hash' : [ 0x0, ['unsigned long']],
} ],
  '_EXHANDLE' : [ 0x8, {
    'TagBits' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 2, native_type='unsigned long')]],
    'Index' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 32, native_type='unsigned long')]],
    'GenericHandleOverlay' : [ 0x0, ['pointer64', ['void']]],
    'Value' : [ 0x0, ['unsigned long long']],
} ],
  '_COUNTER_READING' : [ 0x18, {
    'Type' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: u'PMCCounter', 1: u'MaxHardwareCounterType'})]],
    'Index' : [ 0x4, ['unsigned long']],
    'Start' : [ 0x8, ['unsigned long long']],
    'Total' : [ 0x10, ['unsigned long long']],
} ],
  '_SECURITY_DESCRIPTOR' : [ 0x28, {
    'Revision' : [ 0x0, ['unsigned char']],
    'Sbz1' : [ 0x1, ['unsigned char']],
    'Control' : [ 0x2, ['unsigned short']],
    'Owner' : [ 0x8, ['pointer64', ['void']]],
    'Group' : [ 0x10, ['pointer64', ['void']]],
    'Sacl' : [ 0x18, ['pointer64', ['_ACL']]],
    'Dacl' : [ 0x20, ['pointer64', ['_ACL']]],
} ],
  '_WHEA_AER_BRIDGE_DESCRIPTOR' : [ 0x2c, {
    'Type' : [ 0x0, ['unsigned short']],
    'Enabled' : [ 0x2, ['unsigned char']],
    'Reserved' : [ 0x3, ['unsigned char']],
    'BusNumber' : [ 0x4, ['unsigned long']],
    'Slot' : [ 0x8, ['_WHEA_PCI_SLOT_NUMBER']],
    'DeviceControl' : [ 0xc, ['unsigned short']],
    'Flags' : [ 0xe, ['_AER_BRIDGE_DESCRIPTOR_FLAGS']],
    'UncorrectableErrorMask' : [ 0x10, ['unsigned long']],
    'UncorrectableErrorSeverity' : [ 0x14, ['unsigned long']],
    'CorrectableErrorMask' : [ 0x18, ['unsigned long']],
    'AdvancedCapsAndControl' : [ 0x1c, ['unsigned long']],
    'SecondaryUncorrectableErrorMask' : [ 0x20, ['unsigned long']],
    'SecondaryUncorrectableErrorSev' : [ 0x24, ['unsigned long']],
    'SecondaryCapsAndControl' : [ 0x28, ['unsigned long']],
} ],
  '_PNP_DEVICE_EVENT_LIST' : [ 0x88, {
    'Status' : [ 0x0, ['long']],
    'EventQueueMutex' : [ 0x8, ['_KMUTANT']],
    'Lock' : [ 0x40, ['_FAST_MUTEX']],
    'List' : [ 0x78, ['_LIST_ENTRY']],
} ],
  '_PO_DEVICE_NOTIFY' : [ 0x68, {
    'Link' : [ 0x0, ['_LIST_ENTRY']],
    'PowerChildren' : [ 0x10, ['_LIST_ENTRY']],
    'PowerParents' : [ 0x20, ['_LIST_ENTRY']],
    'TargetDevice' : [ 0x30, ['pointer64', ['_DEVICE_OBJECT']]],
    'OrderLevel' : [ 0x38, ['unsigned char']],
    'DeviceObject' : [ 0x40, ['pointer64', ['_DEVICE_OBJECT']]],
    'DeviceName' : [ 0x48, ['pointer64', ['wchar']]],
    'DriverName' : [ 0x50, ['pointer64', ['wchar']]],
    'ChildCount' : [ 0x58, ['unsigned long']],
    'ActiveChild' : [ 0x5c, ['unsigned long']],
    'ParentCount' : [ 0x60, ['unsigned long']],
    'ActiveParent' : [ 0x64, ['unsigned long']],
} ],
  '_DUAL' : [ 0x278, {
    'Length' : [ 0x0, ['unsigned long']],
    'Map' : [ 0x8, ['pointer64', ['_HMAP_DIRECTORY']]],
    'SmallDir' : [ 0x10, ['pointer64', ['_HMAP_TABLE']]],
    'Guard' : [ 0x18, ['unsigned long']],
    'FreeDisplay' : [ 0x20, ['array', 24, ['_FREE_DISPLAY']]],
    'FreeBins' : [ 0x260, ['_LIST_ENTRY']],
    'FreeSummary' : [ 0x270, ['unsigned long']],
} ],
  '_MI_VAD_EVENT_BLOCK' : [ 0x48, {
    'Next' : [ 0x0, ['pointer64', ['_MI_VAD_EVENT_BLOCK']]],
    'Gate' : [ 0x8, ['_KGATE']],
    'SecureInfo' : [ 0x8, ['_MMADDRESS_LIST']],
    'BitMap' : [ 0x8, ['_RTL_BITMAP_EX']],
    'InPageSupport' : [ 0x8, ['pointer64', ['_MMINPAGE_SUPPORT']]],
    'LargePage' : [ 0x8, ['_MI_LARGEPAGE_IMAGE_INFO']],
    'CreatingThread' : [ 0x8, ['pointer64', ['_ETHREAD']]],
    'PebTebRfg' : [ 0x8, ['_MI_SUB64K_FREE_RANGES']],
    'RfgProtectedStack' : [ 0x8, ['_MI_RFG_PROTECTED_STACK']],
    'PlaceholderVad' : [ 0x8, ['pointer64', ['_MMVAD_SHORT']]],
    'WaitReason' : [ 0x40, ['unsigned long']],
} ],
  '__unnamed_222b' : [ 0x4, {
    'LongFlags' : [ 0x0, ['unsigned long']],
    'SubsectionFlags' : [ 0x0, ['_MMSUBSECTION_FLAGS']],
} ],
  '__unnamed_222e' : [ 0x4, {
    'e1' : [ 0x0, ['_MI_SUBSECTION_ENTRY1']],
    'EntireField' : [ 0x0, ['unsigned long']],
} ],
  '_SUBSECTION' : [ 0x38, {
    'ControlArea' : [ 0x0, ['pointer64', ['_CONTROL_AREA']]],
    'SubsectionBase' : [ 0x8, ['pointer64', ['_MMPTE']]],
    'NextSubsection' : [ 0x10, ['pointer64', ['_SUBSECTION']]],
    'GlobalPerSessionHead' : [ 0x18, ['_RTL_AVL_TREE']],
    'CreationWaitList' : [ 0x18, ['pointer64', ['_MI_CONTROL_AREA_WAIT_BLOCK']]],
    'SessionDriverProtos' : [ 0x18, ['pointer64', ['_MI_PER_SESSION_PROTOS']]],
    'u' : [ 0x20, ['__unnamed_222b']],
    'StartingSector' : [ 0x24, ['unsigned long']],
    'NumberOfFullSectors' : [ 0x28, ['unsigned long']],
    'PtesInSubsection' : [ 0x2c, ['unsigned long']],
    'u1' : [ 0x30, ['__unnamed_222e']],
    'UnusedPtes' : [ 0x34, ['BitField', dict(start_bit = 0, end_bit = 30, native_type='unsigned long')]],
    'ExtentQueryNeeded' : [ 0x34, ['BitField', dict(start_bit = 30, end_bit = 31, native_type='unsigned long')]],
    'DirtyPages' : [ 0x34, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
} ],
  '_KUMS_CONTEXT_HEADER' : [ 0x70, {
    'P1Home' : [ 0x0, ['unsigned long long']],
    'P2Home' : [ 0x8, ['unsigned long long']],
    'P3Home' : [ 0x10, ['unsigned long long']],
    'P4Home' : [ 0x18, ['unsigned long long']],
    'StackTop' : [ 0x20, ['pointer64', ['void']]],
    'StackSize' : [ 0x28, ['unsigned long long']],
    'RspOffset' : [ 0x30, ['unsigned long long']],
    'Rip' : [ 0x38, ['unsigned long long']],
    'FltSave' : [ 0x40, ['pointer64', ['_XSAVE_FORMAT']]],
    'Volatile' : [ 0x48, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'Reserved' : [ 0x48, ['BitField', dict(start_bit = 1, end_bit = 64, native_type='unsigned long long')]],
    'Flags' : [ 0x48, ['unsigned long long']],
    'TrapFrame' : [ 0x50, ['pointer64', ['_KTRAP_FRAME']]],
    'ExceptionFrame' : [ 0x58, ['pointer64', ['_KEXCEPTION_FRAME']]],
    'SourceThread' : [ 0x60, ['pointer64', ['_KTHREAD']]],
    'Return' : [ 0x68, ['unsigned long long']],
} ],
  '_REQUEST_MAILBOX' : [ 0x40, {
    'Next' : [ 0x0, ['pointer64', ['_REQUEST_MAILBOX']]],
    'RequestSummary' : [ 0x8, ['unsigned long long']],
    'RequestPacket' : [ 0x10, ['_KREQUEST_PACKET']],
    'NodeTargetCountAddr' : [ 0x30, ['pointer64', ['long']]],
    'NodeTargetCount' : [ 0x38, ['long']],
} ],
  '_ACTIVATION_CONTEXT_STACK' : [ 0x28, {
    'ActiveFrame' : [ 0x0, ['pointer64', ['_RTL_ACTIVATION_CONTEXT_STACK_FRAME']]],
    'FrameListCache' : [ 0x8, ['_LIST_ENTRY']],
    'Flags' : [ 0x18, ['unsigned long']],
    'NextCookieSequenceNumber' : [ 0x1c, ['unsigned long']],
    'StackId' : [ 0x20, ['unsigned long']],
} ],
  'CMP_OFFSET_ARRAY' : [ 0x18, {
    'FileOffset' : [ 0x0, ['unsigned long']],
    'DataBuffer' : [ 0x8, ['pointer64', ['void']]],
    'DataLength' : [ 0x10, ['unsigned long']],
} ],
  '_FAST_ERESOURCE' : [ 0x68, {
    'Reserved1' : [ 0x0, ['array', 3, ['pointer64', ['void']]]],
    'Reserved2' : [ 0x18, ['unsigned long']],
    'Reserved3' : [ 0x20, ['array', 4, ['pointer64', ['void']]]],
    'Reserved4' : [ 0x40, ['array', 4, ['unsigned long']]],
    'Reserved5' : [ 0x50, ['pointer64', ['void']]],
    'Reserved6' : [ 0x58, ['array', 2, ['pointer64', ['void']]]],
} ],
  '_KEXECUTE_OPTIONS' : [ 0x1, {
    'ExecuteDisable' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'ExecuteEnable' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'DisableThunkEmulation' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'Permanent' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'ExecuteDispatchEnable' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'ImageDispatchEnable' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'DisableExceptionChainValidation' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned char')]],
    'Spare' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
    'ExecuteOptions' : [ 0x0, ['unsigned char']],
    'ExecuteOptionsNV' : [ 0x0, ['unsigned char']],
} ],
  '_TRIAGE_PNP_DEVICE_COMPLETION_QUEUE' : [ 0x10, {
    'DispatchedList' : [ 0x0, ['_LIST_ENTRY']],
} ],
  '_HEAP_STOP_ON_VALUES' : [ 0x30, {
    'AllocAddress' : [ 0x0, ['unsigned long long']],
    'AllocTag' : [ 0x8, ['_HEAP_STOP_ON_TAG']],
    'ReAllocAddress' : [ 0x10, ['unsigned long long']],
    'ReAllocTag' : [ 0x18, ['_HEAP_STOP_ON_TAG']],
    'FreeAddress' : [ 0x20, ['unsigned long long']],
    'FreeTag' : [ 0x28, ['_HEAP_STOP_ON_TAG']],
} ],
  '_SEP_RM_LSA_CONNECTION_STATE' : [ 0x50, {
    'LsaProcessHandle' : [ 0x0, ['pointer64', ['void']]],
    'LsaCommandPortHandle' : [ 0x8, ['pointer64', ['void']]],
    'SepRmThreadHandle' : [ 0x10, ['pointer64', ['void']]],
    'RmCommandPortHandle' : [ 0x18, ['pointer64', ['void']]],
    'RmCommandServerPortHandle' : [ 0x20, ['pointer64', ['void']]],
    'LsaCommandPortSectionHandle' : [ 0x28, ['pointer64', ['void']]],
    'LsaCommandPortSectionSize' : [ 0x30, ['_LARGE_INTEGER']],
    'LsaViewPortMemory' : [ 0x38, ['pointer64', ['void']]],
    'RmViewPortMemory' : [ 0x40, ['pointer64', ['void']]],
    'LsaCommandPortMemoryDelta' : [ 0x48, ['long']],
    'LsaCommandPortActive' : [ 0x4c, ['unsigned char']],
} ],
  '_CM_KCB_LAYER_INFO' : [ 0x30, {
    'LayerListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'Kcb' : [ 0x10, ['pointer64', ['_CM_KEY_CONTROL_BLOCK']]],
    'LowerLayer' : [ 0x18, ['pointer64', ['_CM_KCB_LAYER_INFO']]],
    'UpperLayerListHead' : [ 0x20, ['_LIST_ENTRY']],
} ],
  '_CM_RM' : [ 0x88, {
    'RmListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'TransactionListHead' : [ 0x10, ['_LIST_ENTRY']],
    'TmHandle' : [ 0x20, ['pointer64', ['void']]],
    'Tm' : [ 0x28, ['pointer64', ['void']]],
    'RmHandle' : [ 0x30, ['pointer64', ['void']]],
    'KtmRm' : [ 0x38, ['pointer64', ['void']]],
    'RefCount' : [ 0x40, ['unsigned long']],
    'ContainerNum' : [ 0x44, ['unsigned long']],
    'ContainerSize' : [ 0x48, ['unsigned long long']],
    'CmHive' : [ 0x50, ['pointer64', ['_CMHIVE']]],
    'LogFileObject' : [ 0x58, ['pointer64', ['void']]],
    'MarshallingContext' : [ 0x60, ['pointer64', ['void']]],
    'RmFlags' : [ 0x68, ['unsigned long']],
    'LogStartStatus1' : [ 0x6c, ['long']],
    'LogStartStatus2' : [ 0x70, ['long']],
    'BaseLsn' : [ 0x78, ['unsigned long long']],
    'RmLock' : [ 0x80, ['pointer64', ['_ERESOURCE']]],
} ],
  '_MMWORKING_SET_EXPANSION_HEAD' : [ 0x10, {
    'ListHead' : [ 0x0, ['_LIST_ENTRY']],
} ],
  '_SECURITY_QUALITY_OF_SERVICE' : [ 0xc, {
    'Length' : [ 0x0, ['unsigned long']],
    'ImpersonationLevel' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {0: u'SecurityAnonymous', 1: u'SecurityIdentification', 2: u'SecurityImpersonation', 3: u'SecurityDelegation'})]],
    'ContextTrackingMode' : [ 0x8, ['unsigned char']],
    'EffectiveOnly' : [ 0x9, ['unsigned char']],
} ],
  '_MM_PAGED_POOL_INFO' : [ 0x38, {
    'Lock' : [ 0x0, ['_EX_PUSH_LOCK']],
    'PagedPoolAllocationMap' : [ 0x8, ['_RTL_BITMAP_EX']],
    'FirstPteForPagedPool' : [ 0x18, ['pointer64', ['_MMPTE']]],
    'MaximumSize' : [ 0x20, ['unsigned long long']],
    'PagedPoolHint' : [ 0x28, ['unsigned long long']],
    'AllocatedPagedPool' : [ 0x30, ['unsigned long long']],
} ],
  '_PPM_IDLE_STATE' : [ 0xf8, {
    'DomainMembers' : [ 0x0, ['_KAFFINITY_EX']],
    'Name' : [ 0xa8, ['_UNICODE_STRING']],
    'Latency' : [ 0xb8, ['unsigned long']],
    'BreakEvenDuration' : [ 0xbc, ['unsigned long']],
    'Power' : [ 0xc0, ['unsigned long']],
    'StateFlags' : [ 0xc4, ['unsigned long']],
    'VetoAccounting' : [ 0xc8, ['_PPM_VETO_ACCOUNTING']],
    'StateType' : [ 0xf0, ['unsigned char']],
    'InterruptsEnabled' : [ 0xf1, ['unsigned char']],
    'Interruptible' : [ 0xf2, ['unsigned char']],
    'ContextRetained' : [ 0xf3, ['unsigned char']],
    'CacheCoherent' : [ 0xf4, ['unsigned char']],
    'WakesSpuriously' : [ 0xf5, ['unsigned char']],
    'PlatformOnly' : [ 0xf6, ['unsigned char']],
    'NoCState' : [ 0xf7, ['unsigned char']],
} ],
  '_CLIENT_ID32' : [ 0x8, {
    'UniqueProcess' : [ 0x0, ['unsigned long']],
    'UniqueThread' : [ 0x4, ['unsigned long']],
} ],
  '_CACHED_CHILD_LIST' : [ 0x10, {
    'Count' : [ 0x0, ['unsigned long']],
    'ValueList' : [ 0x8, ['unsigned long long']],
    'RealKcb' : [ 0x8, ['pointer64', ['_CM_KEY_CONTROL_BLOCK']]],
} ],
  '_ARMCE_DBGKD_CONTROL_SET' : [ 0xc, {
    'Continue' : [ 0x0, ['unsigned long']],
    'CurrentSymbolStart' : [ 0x4, ['unsigned long']],
    'CurrentSymbolEnd' : [ 0x8, ['unsigned long']],
} ],
  '_GDI_TEB_BATCH32' : [ 0x4e0, {
    'Offset' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 31, native_type='unsigned long')]],
    'HasRenderingCommand' : [ 0x0, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
    'HDC' : [ 0x4, ['unsigned long']],
    'Buffer' : [ 0x8, ['array', 310, ['unsigned long']]],
} ],
  '__unnamed_2268' : [ 0x4, {
    'MissedEtwRegistration' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Spare' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 32, native_type='unsigned long')]],
} ],
  '__unnamed_226a' : [ 0x4, {
    'Flags' : [ 0x0, ['__unnamed_2268']],
    'Whole' : [ 0x0, ['unsigned long']],
} ],
  '_VF_TARGET_VERIFIED_DRIVER_DATA' : [ 0x120, {
    'SuspectDriverEntry' : [ 0x0, ['pointer64', ['_VF_SUSPECT_DRIVER_ENTRY']]],
    'WMICallback' : [ 0x8, ['pointer64', ['void']]],
    'EtwHandlesListHead' : [ 0x10, ['_LIST_ENTRY']],
    'u1' : [ 0x20, ['__unnamed_226a']],
    'Signature' : [ 0x28, ['unsigned long long']],
    'SeSigningLevel' : [ 0x30, ['unsigned char']],
    'PoolPageHeaders' : [ 0x40, ['_SLIST_HEADER']],
    'PoolTrackers' : [ 0x50, ['_SLIST_HEADER']],
    'CurrentPagedPoolAllocations' : [ 0x60, ['unsigned long']],
    'CurrentNonPagedPoolAllocations' : [ 0x64, ['unsigned long']],
    'PeakPagedPoolAllocations' : [ 0x68, ['unsigned long']],
    'PeakNonPagedPoolAllocations' : [ 0x6c, ['unsigned long']],
    'PagedBytes' : [ 0x70, ['unsigned long long']],
    'NonPagedBytes' : [ 0x78, ['unsigned long long']],
    'PeakPagedBytes' : [ 0x80, ['unsigned long long']],
    'PeakNonPagedBytes' : [ 0x88, ['unsigned long long']],
    'RaiseIrqls' : [ 0x90, ['unsigned long']],
    'AcquireSpinLocks' : [ 0x94, ['unsigned long']],
    'SynchronizeExecutions' : [ 0x98, ['unsigned long']],
    'AllocationsWithNoTag' : [ 0x9c, ['unsigned long']],
    'AllocationsFailed' : [ 0xa0, ['unsigned long']],
    'AllocationsFailedDeliberately' : [ 0xa4, ['unsigned long']],
    'LockedBytes' : [ 0xa8, ['unsigned long long']],
    'PeakLockedBytes' : [ 0xb0, ['unsigned long long']],
    'MappedLockedBytes' : [ 0xb8, ['unsigned long long']],
    'PeakMappedLockedBytes' : [ 0xc0, ['unsigned long long']],
    'MappedIoSpaceBytes' : [ 0xc8, ['unsigned long long']],
    'PeakMappedIoSpaceBytes' : [ 0xd0, ['unsigned long long']],
    'PagesForMdlBytes' : [ 0xd8, ['unsigned long long']],
    'PeakPagesForMdlBytes' : [ 0xe0, ['unsigned long long']],
    'ContiguousMemoryBytes' : [ 0xe8, ['unsigned long long']],
    'PeakContiguousMemoryBytes' : [ 0xf0, ['unsigned long long']],
    'ContiguousMemoryListHead' : [ 0xf8, ['_LIST_ENTRY']],
    'ExecutePoolTypes' : [ 0x108, ['unsigned long']],
    'ExecutePageProtections' : [ 0x10c, ['unsigned long']],
    'ExecutePageMappings' : [ 0x110, ['unsigned long']],
    'ExecuteWriteSections' : [ 0x114, ['unsigned long']],
    'SectionAlignmentFailures' : [ 0x118, ['unsigned long']],
    'IATInExecutableSection' : [ 0x11c, ['unsigned long']],
} ],
  '_SEP_LUID_TO_INDEX_MAP_ENTRY' : [ 0x38, {
    'HashEntry' : [ 0x0, ['_RTL_DYNAMIC_HASH_TABLE_ENTRY']],
    'ReferenceCount' : [ 0x18, ['long long']],
    'Luid' : [ 0x20, ['unsigned long long']],
    'IndexIntoGlobalSingletonTable' : [ 0x28, ['unsigned long long']],
    'MarkedForDeletion' : [ 0x30, ['unsigned char']],
} ],
  '_MI_IMAGE_SECURITY_REFERENCE' : [ 0x38, {
    'ProtosNode' : [ 0x0, ['_MI_PROTOTYPE_PTES_NODE']],
    'DynamicRelocations' : [ 0x20, ['pointer64', ['void']]],
    'SecurityContext' : [ 0x28, ['_IMAGE_SECURITY_CONTEXT']],
    'StrongImageReference' : [ 0x30, ['unsigned long long']],
} ],
  '_MEMORY_ALLOCATION_DESCRIPTOR' : [ 0x28, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'MemoryType' : [ 0x10, ['Enumeration', dict(target = 'long', choices = {0: u'LoaderExceptionBlock', 1: u'LoaderSystemBlock', 2: u'LoaderFree', 3: u'LoaderBad', 4: u'LoaderLoadedProgram', 5: u'LoaderFirmwareTemporary', 6: u'LoaderFirmwarePermanent', 7: u'LoaderOsloaderHeap', 8: u'LoaderOsloaderStack', 9: u'LoaderSystemCode', 10: u'LoaderHalCode', 11: u'LoaderBootDriver', 12: u'LoaderConsoleInDriver', 13: u'LoaderConsoleOutDriver', 14: u'LoaderStartupDpcStack', 15: u'LoaderStartupKernelStack', 16: u'LoaderStartupPanicStack', 17: u'LoaderStartupPcrPage', 18: u'LoaderStartupPdrPage', 19: u'LoaderRegistryData', 20: u'LoaderMemoryData', 21: u'LoaderNlsData', 22: u'LoaderSpecialMemory', 23: u'LoaderBBTMemory', 24: u'LoaderZero', 25: u'LoaderXIPRom', 26: u'LoaderHALCachedMemory', 27: u'LoaderLargePageFiller', 28: u'LoaderErrorLogMemory', 29: u'LoaderVsmMemory', 30: u'LoaderFirmwareCode', 31: u'LoaderFirmwareData', 32: u'LoaderFirmwareReserved', 33: u'LoaderEnclaveMemory', 34: u'LoaderFirmwareKsr', 35: u'LoaderEnclaveKsr', 36: u'LoaderMaximum'})]],
    'BasePage' : [ 0x18, ['unsigned long long']],
    'PageCount' : [ 0x20, ['unsigned long long']],
} ],
  '_SYSTEM_POWER_POLICY' : [ 0xe8, {
    'Revision' : [ 0x0, ['unsigned long']],
    'PowerButton' : [ 0x4, ['POWER_ACTION_POLICY']],
    'SleepButton' : [ 0x10, ['POWER_ACTION_POLICY']],
    'LidClose' : [ 0x1c, ['POWER_ACTION_POLICY']],
    'LidOpenWake' : [ 0x28, ['Enumeration', dict(target = 'long', choices = {0: u'PowerSystemUnspecified', 1: u'PowerSystemWorking', 2: u'PowerSystemSleeping1', 3: u'PowerSystemSleeping2', 4: u'PowerSystemSleeping3', 5: u'PowerSystemHibernate', 6: u'PowerSystemShutdown', 7: u'PowerSystemMaximum'})]],
    'Reserved' : [ 0x2c, ['unsigned long']],
    'Idle' : [ 0x30, ['POWER_ACTION_POLICY']],
    'IdleTimeout' : [ 0x3c, ['unsigned long']],
    'IdleSensitivity' : [ 0x40, ['unsigned char']],
    'DynamicThrottle' : [ 0x41, ['unsigned char']],
    'Spare2' : [ 0x42, ['array', 2, ['unsigned char']]],
    'MinSleep' : [ 0x44, ['Enumeration', dict(target = 'long', choices = {0: u'PowerSystemUnspecified', 1: u'PowerSystemWorking', 2: u'PowerSystemSleeping1', 3: u'PowerSystemSleeping2', 4: u'PowerSystemSleeping3', 5: u'PowerSystemHibernate', 6: u'PowerSystemShutdown', 7: u'PowerSystemMaximum'})]],
    'MaxSleep' : [ 0x48, ['Enumeration', dict(target = 'long', choices = {0: u'PowerSystemUnspecified', 1: u'PowerSystemWorking', 2: u'PowerSystemSleeping1', 3: u'PowerSystemSleeping2', 4: u'PowerSystemSleeping3', 5: u'PowerSystemHibernate', 6: u'PowerSystemShutdown', 7: u'PowerSystemMaximum'})]],
    'ReducedLatencySleep' : [ 0x4c, ['Enumeration', dict(target = 'long', choices = {0: u'PowerSystemUnspecified', 1: u'PowerSystemWorking', 2: u'PowerSystemSleeping1', 3: u'PowerSystemSleeping2', 4: u'PowerSystemSleeping3', 5: u'PowerSystemHibernate', 6: u'PowerSystemShutdown', 7: u'PowerSystemMaximum'})]],
    'WinLogonFlags' : [ 0x50, ['unsigned long']],
    'Spare3' : [ 0x54, ['unsigned long']],
    'DozeS4Timeout' : [ 0x58, ['unsigned long']],
    'BroadcastCapacityResolution' : [ 0x5c, ['unsigned long']],
    'DischargePolicy' : [ 0x60, ['array', 4, ['SYSTEM_POWER_LEVEL']]],
    'VideoTimeout' : [ 0xc0, ['unsigned long']],
    'VideoDimDisplay' : [ 0xc4, ['unsigned char']],
    'VideoReserved' : [ 0xc8, ['array', 3, ['unsigned long']]],
    'SpindownTimeout' : [ 0xd4, ['unsigned long']],
    'OptimizeForPower' : [ 0xd8, ['unsigned char']],
    'FanThrottleTolerance' : [ 0xd9, ['unsigned char']],
    'ForcedThrottle' : [ 0xda, ['unsigned char']],
    'MinThrottle' : [ 0xdb, ['unsigned char']],
    'OverThrottled' : [ 0xdc, ['POWER_ACTION_POLICY']],
} ],
  '_OBP_SYSTEM_DOS_DEVICE_STATE' : [ 0x6c, {
    'GlobalDeviceMap' : [ 0x0, ['unsigned long']],
    'LocalDeviceCount' : [ 0x4, ['array', 26, ['unsigned long']]],
} ],
  '_WNF_SILODRIVERSTATE' : [ 0x38, {
    'ScopeMap' : [ 0x0, ['pointer64', ['_WNF_SCOPE_MAP']]],
    'PermanentNameStoreRootKey' : [ 0x8, ['pointer64', ['void']]],
    'PersistentNameStoreRootKey' : [ 0x10, ['pointer64', ['void']]],
    'PermanentNameSequenceNumber' : [ 0x18, ['long long']],
    'PermanentNameSequenceNumberLock' : [ 0x20, ['_WNF_LOCK']],
    'PermanentNameSequenceNumberPool' : [ 0x28, ['long long']],
    'RuntimeNameSequenceNumber' : [ 0x30, ['long long']],
} ],
  '_DELAY_ACK_FO' : [ 0x18, {
    'Links' : [ 0x0, ['_LIST_ENTRY']],
    'OriginalFileObject' : [ 0x10, ['pointer64', ['_FILE_OBJECT']]],
} ],
  '_CM_KEY_REFERENCE' : [ 0x10, {
    'KeyCell' : [ 0x0, ['unsigned long']],
    'KeyHive' : [ 0x8, ['pointer64', ['_HHIVE']]],
} ],
  '_DISPATCHER_HEADER' : [ 0x18, {
    'Lock' : [ 0x0, ['long']],
    'LockNV' : [ 0x0, ['long']],
    'Type' : [ 0x0, ['unsigned char']],
    'Signalling' : [ 0x1, ['unsigned char']],
    'Size' : [ 0x2, ['unsigned char']],
    'Reserved1' : [ 0x3, ['unsigned char']],
    'TimerType' : [ 0x0, ['unsigned char']],
    'TimerControlFlags' : [ 0x1, ['unsigned char']],
    'Absolute' : [ 0x1, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'Wake' : [ 0x1, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'EncodedTolerableDelay' : [ 0x1, ['BitField', dict(start_bit = 2, end_bit = 8, native_type='unsigned char')]],
    'Hand' : [ 0x2, ['unsigned char']],
    'TimerMiscFlags' : [ 0x3, ['unsigned char']],
    'Index' : [ 0x3, ['BitField', dict(start_bit = 0, end_bit = 6, native_type='unsigned char')]],
    'Inserted' : [ 0x3, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned char')]],
    'Expired' : [ 0x3, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
    'Timer2Type' : [ 0x0, ['unsigned char']],
    'Timer2Flags' : [ 0x1, ['unsigned char']],
    'Timer2Inserted' : [ 0x1, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'Timer2Expiring' : [ 0x1, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'Timer2CancelPending' : [ 0x1, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'Timer2SetPending' : [ 0x1, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'Timer2Running' : [ 0x1, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'Timer2Disabled' : [ 0x1, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'Timer2ReservedFlags' : [ 0x1, ['BitField', dict(start_bit = 6, end_bit = 8, native_type='unsigned char')]],
    'Timer2ComponentId' : [ 0x2, ['unsigned char']],
    'Timer2RelativeId' : [ 0x3, ['unsigned char']],
    'QueueType' : [ 0x0, ['unsigned char']],
    'QueueControlFlags' : [ 0x1, ['unsigned char']],
    'Abandoned' : [ 0x1, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'DisableIncrement' : [ 0x1, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'QueueReservedControlFlags' : [ 0x1, ['BitField', dict(start_bit = 2, end_bit = 8, native_type='unsigned char')]],
    'QueueSize' : [ 0x2, ['unsigned char']],
    'QueueReserved' : [ 0x3, ['unsigned char']],
    'ThreadType' : [ 0x0, ['unsigned char']],
    'ThreadSpecControl' : [ 0x1, ['unsigned char']],
    'SpecControlIbrs' : [ 0x1, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'SpecControlStibp' : [ 0x1, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'SpecControlReserved' : [ 0x1, ['BitField', dict(start_bit = 2, end_bit = 8, native_type='unsigned char')]],
    'ThreadControlFlags' : [ 0x2, ['unsigned char']],
    'CycleProfiling' : [ 0x2, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'CounterProfiling' : [ 0x2, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'GroupScheduling' : [ 0x2, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'AffinitySet' : [ 0x2, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'Tagged' : [ 0x2, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'EnergyProfiling' : [ 0x2, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'SchedulerAssist' : [ 0x2, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned char')]],
    'ThreadReservedControlFlags' : [ 0x2, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
    'DebugActive' : [ 0x3, ['unsigned char']],
    'ActiveDR7' : [ 0x3, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'Instrumented' : [ 0x3, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'Minimal' : [ 0x3, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'Reserved4' : [ 0x3, ['BitField', dict(start_bit = 3, end_bit = 6, native_type='unsigned char')]],
    'UmsScheduled' : [ 0x3, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned char')]],
    'UmsPrimary' : [ 0x3, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
    'MutantType' : [ 0x0, ['unsigned char']],
    'MutantSize' : [ 0x1, ['unsigned char']],
    'DpcActive' : [ 0x2, ['unsigned char']],
    'MutantReserved' : [ 0x3, ['unsigned char']],
    'SignalState' : [ 0x4, ['long']],
    'WaitListHead' : [ 0x8, ['_LIST_ENTRY']],
} ],
  '_PEBS_DS_SAVE_AREA' : [ 0x60, {
    'BtsBufferBase' : [ 0x0, ['unsigned long long']],
    'BtsIndex' : [ 0x8, ['unsigned long long']],
    'BtsAbsoluteMaximum' : [ 0x10, ['unsigned long long']],
    'BtsInterruptThreshold' : [ 0x18, ['unsigned long long']],
    'PebsBufferBase' : [ 0x20, ['unsigned long long']],
    'PebsIndex' : [ 0x28, ['unsigned long long']],
    'PebsAbsoluteMaximum' : [ 0x30, ['unsigned long long']],
    'PebsInterruptThreshold' : [ 0x38, ['unsigned long long']],
    'PebsCounterReset0' : [ 0x40, ['unsigned long long']],
    'PebsCounterReset1' : [ 0x48, ['unsigned long long']],
    'PebsCounterReset2' : [ 0x50, ['unsigned long long']],
    'PebsCounterReset3' : [ 0x58, ['unsigned long long']],
} ],
  '_OB_HANDLE_REVOCATION_BLOCK' : [ 0x20, {
    'RevocationInfos' : [ 0x0, ['_LIST_ENTRY']],
    'Lock' : [ 0x10, ['_EX_PUSH_LOCK']],
    'Rundown' : [ 0x18, ['_EX_RUNDOWN_REF']],
} ],
  '_DIRTY_PAGE_THRESHOLDS' : [ 0x38, {
    'DirtyPageThreshold' : [ 0x0, ['unsigned long long']],
    'DirtyPageThresholdTop' : [ 0x8, ['unsigned long long']],
    'DirtyPageThresholdBottom' : [ 0x10, ['unsigned long long']],
    'DirtyPageTarget' : [ 0x18, ['unsigned long']],
    'AggregateAvailablePages' : [ 0x20, ['unsigned long long']],
    'AggregateDirtyPages' : [ 0x28, ['unsigned long long']],
    'AvailableHistory' : [ 0x30, ['unsigned long']],
} ],
  '_LOCK_TRACKER' : [ 0x90, {
    'LockTrackerNode' : [ 0x0, ['_RTL_BALANCED_NODE']],
    'Mdl' : [ 0x18, ['pointer64', ['_MDL']]],
    'StartVa' : [ 0x20, ['pointer64', ['void']]],
    'Count' : [ 0x28, ['unsigned long long']],
    'Offset' : [ 0x30, ['unsigned long']],
    'Length' : [ 0x34, ['unsigned long']],
    'Who' : [ 0x38, ['unsigned long']],
    'Hash' : [ 0x3c, ['unsigned long']],
    'Page' : [ 0x40, ['unsigned long long']],
    'StackTrace' : [ 0x48, ['array', 8, ['pointer64', ['void']]]],
    'Process' : [ 0x88, ['pointer64', ['_EPROCESS']]],
} ],
  '_CONTEXT' : [ 0x4d0, {
    'P1Home' : [ 0x0, ['unsigned long long']],
    'P2Home' : [ 0x8, ['unsigned long long']],
    'P3Home' : [ 0x10, ['unsigned long long']],
    'P4Home' : [ 0x18, ['unsigned long long']],
    'P5Home' : [ 0x20, ['unsigned long long']],
    'P6Home' : [ 0x28, ['unsigned long long']],
    'ContextFlags' : [ 0x30, ['unsigned long']],
    'MxCsr' : [ 0x34, ['unsigned long']],
    'SegCs' : [ 0x38, ['unsigned short']],
    'SegDs' : [ 0x3a, ['unsigned short']],
    'SegEs' : [ 0x3c, ['unsigned short']],
    'SegFs' : [ 0x3e, ['unsigned short']],
    'SegGs' : [ 0x40, ['unsigned short']],
    'SegSs' : [ 0x42, ['unsigned short']],
    'EFlags' : [ 0x44, ['unsigned long']],
    'Dr0' : [ 0x48, ['unsigned long long']],
    'Dr1' : [ 0x50, ['unsigned long long']],
    'Dr2' : [ 0x58, ['unsigned long long']],
    'Dr3' : [ 0x60, ['unsigned long long']],
    'Dr6' : [ 0x68, ['unsigned long long']],
    'Dr7' : [ 0x70, ['unsigned long long']],
    'Rax' : [ 0x78, ['unsigned long long']],
    'Rcx' : [ 0x80, ['unsigned long long']],
    'Rdx' : [ 0x88, ['unsigned long long']],
    'Rbx' : [ 0x90, ['unsigned long long']],
    'Rsp' : [ 0x98, ['unsigned long long']],
    'Rbp' : [ 0xa0, ['unsigned long long']],
    'Rsi' : [ 0xa8, ['unsigned long long']],
    'Rdi' : [ 0xb0, ['unsigned long long']],
    'R8' : [ 0xb8, ['unsigned long long']],
    'R9' : [ 0xc0, ['unsigned long long']],
    'R10' : [ 0xc8, ['unsigned long long']],
    'R11' : [ 0xd0, ['unsigned long long']],
    'R12' : [ 0xd8, ['unsigned long long']],
    'R13' : [ 0xe0, ['unsigned long long']],
    'R14' : [ 0xe8, ['unsigned long long']],
    'R15' : [ 0xf0, ['unsigned long long']],
    'Rip' : [ 0xf8, ['unsigned long long']],
    'FltSave' : [ 0x100, ['_XSAVE_FORMAT']],
    'Header' : [ 0x100, ['array', 2, ['_M128A']]],
    'Legacy' : [ 0x120, ['array', 8, ['_M128A']]],
    'Xmm0' : [ 0x1a0, ['_M128A']],
    'Xmm1' : [ 0x1b0, ['_M128A']],
    'Xmm2' : [ 0x1c0, ['_M128A']],
    'Xmm3' : [ 0x1d0, ['_M128A']],
    'Xmm4' : [ 0x1e0, ['_M128A']],
    'Xmm5' : [ 0x1f0, ['_M128A']],
    'Xmm6' : [ 0x200, ['_M128A']],
    'Xmm7' : [ 0x210, ['_M128A']],
    'Xmm8' : [ 0x220, ['_M128A']],
    'Xmm9' : [ 0x230, ['_M128A']],
    'Xmm10' : [ 0x240, ['_M128A']],
    'Xmm11' : [ 0x250, ['_M128A']],
    'Xmm12' : [ 0x260, ['_M128A']],
    'Xmm13' : [ 0x270, ['_M128A']],
    'Xmm14' : [ 0x280, ['_M128A']],
    'Xmm15' : [ 0x290, ['_M128A']],
    'VectorRegister' : [ 0x300, ['array', 26, ['_M128A']]],
    'VectorControl' : [ 0x4a0, ['unsigned long long']],
    'DebugControl' : [ 0x4a8, ['unsigned long long']],
    'LastBranchToRip' : [ 0x4b0, ['unsigned long long']],
    'LastBranchFromRip' : [ 0x4b8, ['unsigned long long']],
    'LastExceptionToRip' : [ 0x4c0, ['unsigned long long']],
    'LastExceptionFromRip' : [ 0x4c8, ['unsigned long long']],
} ],
  '_WHEA_GENERIC_ERROR_DESCRIPTOR' : [ 0x34, {
    'Type' : [ 0x0, ['unsigned short']],
    'Reserved' : [ 0x2, ['unsigned char']],
    'Enabled' : [ 0x3, ['unsigned char']],
    'ErrStatusBlockLength' : [ 0x4, ['unsigned long']],
    'RelatedErrorSourceId' : [ 0x8, ['unsigned long']],
    'ErrStatusAddressSpaceID' : [ 0xc, ['unsigned char']],
    'ErrStatusAddressBitWidth' : [ 0xd, ['unsigned char']],
    'ErrStatusAddressBitOffset' : [ 0xe, ['unsigned char']],
    'ErrStatusAddressAccessSize' : [ 0xf, ['unsigned char']],
    'ErrStatusAddress' : [ 0x10, ['_LARGE_INTEGER']],
    'Notify' : [ 0x18, ['_WHEA_NOTIFICATION_DESCRIPTOR']],
} ],
  '_MMSECTION_FLAGS2' : [ 0x4, {
    'PartitionId' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 10, native_type='unsigned short')]],
    'NoCrossPartitionAccess' : [ 0x2, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'SubsectionCrossPartitionReferenceOverflow' : [ 0x2, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
} ],
  '_MI_PTE_CHAIN_HEAD' : [ 0x18, {
    'Flink' : [ 0x0, ['_MMPTE']],
    'Blink' : [ 0x8, ['_MMPTE']],
    'PteBase' : [ 0x10, ['pointer64', ['_MMPTE']]],
} ],
  '_HANDLE_TRACE_DEBUG_INFO' : [ 0xf0, {
    'RefCount' : [ 0x0, ['long']],
    'TableSize' : [ 0x4, ['unsigned long']],
    'BitMaskFlags' : [ 0x8, ['unsigned long']],
    'CloseCompactionLock' : [ 0x10, ['_FAST_MUTEX']],
    'CurrentStackIndex' : [ 0x48, ['unsigned long']],
    'TraceDb' : [ 0x50, ['array', 1, ['_HANDLE_TRACE_DB_ENTRY']]],
} ],
  '_ALPC_HANDLE_TABLE' : [ 0x18, {
    'Handles' : [ 0x0, ['pointer64', ['_ALPC_HANDLE_ENTRY']]],
    'TotalHandles' : [ 0x8, ['unsigned long']],
    'Flags' : [ 0xc, ['unsigned long']],
    'Lock' : [ 0x10, ['_EX_PUSH_LOCK']],
} ],
  'HAL_PRIVATE_DISPATCH' : [ 0x458, {
    'Version' : [ 0x0, ['unsigned long']],
    'HalHandlerForBus' : [ 0x8, ['pointer64', ['void']]],
    'HalHandlerForConfigSpace' : [ 0x10, ['pointer64', ['void']]],
    'HalLocateHiberRanges' : [ 0x18, ['pointer64', ['void']]],
    'HalRegisterBusHandler' : [ 0x20, ['pointer64', ['void']]],
    'HalSetWakeEnable' : [ 0x28, ['pointer64', ['void']]],
    'HalSetWakeAlarm' : [ 0x30, ['pointer64', ['void']]],
    'HalPciTranslateBusAddress' : [ 0x38, ['pointer64', ['void']]],
    'HalPciAssignSlotResources' : [ 0x40, ['pointer64', ['void']]],
    'HalHaltSystem' : [ 0x48, ['pointer64', ['void']]],
    'HalFindBusAddressTranslation' : [ 0x50, ['pointer64', ['void']]],
    'HalResetDisplay' : [ 0x58, ['pointer64', ['void']]],
    'HalAllocateMapRegisters' : [ 0x60, ['pointer64', ['void']]],
    'KdSetupPciDeviceForDebugging' : [ 0x68, ['pointer64', ['void']]],
    'KdReleasePciDeviceForDebugging' : [ 0x70, ['pointer64', ['void']]],
    'KdGetAcpiTablePhase0' : [ 0x78, ['pointer64', ['void']]],
    'KdCheckPowerButton' : [ 0x80, ['pointer64', ['void']]],
    'HalVectorToIDTEntry' : [ 0x88, ['pointer64', ['void']]],
    'KdMapPhysicalMemory64' : [ 0x90, ['pointer64', ['void']]],
    'KdUnmapVirtualAddress' : [ 0x98, ['pointer64', ['void']]],
    'KdGetPciDataByOffset' : [ 0xa0, ['pointer64', ['void']]],
    'KdSetPciDataByOffset' : [ 0xa8, ['pointer64', ['void']]],
    'HalGetInterruptVectorOverride' : [ 0xb0, ['pointer64', ['void']]],
    'HalGetVectorInputOverride' : [ 0xb8, ['pointer64', ['void']]],
    'HalLoadMicrocode' : [ 0xc0, ['pointer64', ['void']]],
    'HalUnloadMicrocode' : [ 0xc8, ['pointer64', ['void']]],
    'HalPostMicrocodeUpdate' : [ 0xd0, ['pointer64', ['void']]],
    'HalAllocateMessageTargetOverride' : [ 0xd8, ['pointer64', ['void']]],
    'HalFreeMessageTargetOverride' : [ 0xe0, ['pointer64', ['void']]],
    'HalDpReplaceBegin' : [ 0xe8, ['pointer64', ['void']]],
    'HalDpReplaceTarget' : [ 0xf0, ['pointer64', ['void']]],
    'HalDpReplaceControl' : [ 0xf8, ['pointer64', ['void']]],
    'HalDpReplaceEnd' : [ 0x100, ['pointer64', ['void']]],
    'HalPrepareForBugcheck' : [ 0x108, ['pointer64', ['void']]],
    'HalQueryWakeTime' : [ 0x110, ['pointer64', ['void']]],
    'HalReportIdleStateUsage' : [ 0x118, ['pointer64', ['void']]],
    'HalTscSynchronization' : [ 0x120, ['pointer64', ['void']]],
    'HalWheaInitProcessorGenericSection' : [ 0x128, ['pointer64', ['void']]],
    'HalStopLegacyUsbInterrupts' : [ 0x130, ['pointer64', ['void']]],
    'HalReadWheaPhysicalMemory' : [ 0x138, ['pointer64', ['void']]],
    'HalWriteWheaPhysicalMemory' : [ 0x140, ['pointer64', ['void']]],
    'HalDpMaskLevelTriggeredInterrupts' : [ 0x148, ['pointer64', ['void']]],
    'HalDpUnmaskLevelTriggeredInterrupts' : [ 0x150, ['pointer64', ['void']]],
    'HalDpGetInterruptReplayState' : [ 0x158, ['pointer64', ['void']]],
    'HalDpReplayInterrupts' : [ 0x160, ['pointer64', ['void']]],
    'HalQueryIoPortAccessSupported' : [ 0x168, ['pointer64', ['void']]],
    'KdSetupIntegratedDeviceForDebugging' : [ 0x170, ['pointer64', ['void']]],
    'KdReleaseIntegratedDeviceForDebugging' : [ 0x178, ['pointer64', ['void']]],
    'HalGetEnlightenmentInformation' : [ 0x180, ['pointer64', ['void']]],
    'HalAllocateEarlyPages' : [ 0x188, ['pointer64', ['void']]],
    'HalMapEarlyPages' : [ 0x190, ['pointer64', ['void']]],
    'Dummy1' : [ 0x198, ['pointer64', ['void']]],
    'Dummy2' : [ 0x1a0, ['pointer64', ['void']]],
    'HalNotifyProcessorFreeze' : [ 0x1a8, ['pointer64', ['void']]],
    'HalPrepareProcessorForIdle' : [ 0x1b0, ['pointer64', ['void']]],
    'HalRegisterLogRoutine' : [ 0x1b8, ['pointer64', ['void']]],
    'HalResumeProcessorFromIdle' : [ 0x1c0, ['pointer64', ['void']]],
    'Dummy' : [ 0x1c8, ['pointer64', ['void']]],
    'HalVectorToIDTEntryEx' : [ 0x1d0, ['pointer64', ['void']]],
    'HalSecondaryInterruptQueryPrimaryInformation' : [ 0x1d8, ['pointer64', ['void']]],
    'HalMaskInterrupt' : [ 0x1e0, ['pointer64', ['void']]],
    'HalUnmaskInterrupt' : [ 0x1e8, ['pointer64', ['void']]],
    'HalIsInterruptTypeSecondary' : [ 0x1f0, ['pointer64', ['void']]],
    'HalAllocateGsivForSecondaryInterrupt' : [ 0x1f8, ['pointer64', ['void']]],
    'HalAddInterruptRemapping' : [ 0x200, ['pointer64', ['void']]],
    'HalRemoveInterruptRemapping' : [ 0x208, ['pointer64', ['void']]],
    'HalSaveAndDisableHvEnlightenment' : [ 0x210, ['pointer64', ['void']]],
    'HalRestoreHvEnlightenment' : [ 0x218, ['pointer64', ['void']]],
    'HalFlushIoBuffersExternalCache' : [ 0x220, ['pointer64', ['void']]],
    'HalFlushExternalCache' : [ 0x228, ['pointer64', ['void']]],
    'HalPciEarlyRestore' : [ 0x230, ['pointer64', ['void']]],
    'HalGetProcessorId' : [ 0x238, ['pointer64', ['void']]],
    'HalAllocatePmcCounterSet' : [ 0x240, ['pointer64', ['void']]],
    'HalCollectPmcCounters' : [ 0x248, ['pointer64', ['void']]],
    'HalFreePmcCounterSet' : [ 0x250, ['pointer64', ['void']]],
    'HalProcessorHalt' : [ 0x258, ['pointer64', ['void']]],
    'HalTimerQueryCycleCounter' : [ 0x260, ['pointer64', ['void']]],
    'Dummy3' : [ 0x268, ['pointer64', ['void']]],
    'HalPciMarkHiberPhase' : [ 0x270, ['pointer64', ['void']]],
    'HalQueryProcessorRestartEntryPoint' : [ 0x278, ['pointer64', ['void']]],
    'HalRequestInterrupt' : [ 0x280, ['pointer64', ['void']]],
    'HalEnumerateUnmaskedInterrupts' : [ 0x288, ['pointer64', ['void']]],
    'HalFlushAndInvalidatePageExternalCache' : [ 0x290, ['pointer64', ['void']]],
    'KdEnumerateDebuggingDevices' : [ 0x298, ['pointer64', ['void']]],
    'HalFlushIoRectangleExternalCache' : [ 0x2a0, ['pointer64', ['void']]],
    'HalPowerEarlyRestore' : [ 0x2a8, ['pointer64', ['void']]],
    'HalQueryCapsuleCapabilities' : [ 0x2b0, ['pointer64', ['void']]],
    'HalUpdateCapsule' : [ 0x2b8, ['pointer64', ['void']]],
    'HalPciMultiStageResumeCapable' : [ 0x2c0, ['pointer64', ['void']]],
    'HalDmaFreeCrashDumpRegisters' : [ 0x2c8, ['pointer64', ['void']]],
    'HalAcpiAoacCapable' : [ 0x2d0, ['pointer64', ['void']]],
    'HalInterruptSetDestination' : [ 0x2d8, ['pointer64', ['void']]],
    'HalGetClockConfiguration' : [ 0x2e0, ['pointer64', ['void']]],
    'HalClockTimerActivate' : [ 0x2e8, ['pointer64', ['void']]],
    'HalClockTimerInitialize' : [ 0x2f0, ['pointer64', ['void']]],
    'HalClockTimerStop' : [ 0x2f8, ['pointer64', ['void']]],
    'HalClockTimerArm' : [ 0x300, ['pointer64', ['void']]],
    'HalTimerOnlyClockInterruptPending' : [ 0x308, ['pointer64', ['void']]],
    'HalAcpiGetMultiNode' : [ 0x310, ['pointer64', ['void']]],
    'HalPowerSetRebootHandler' : [ 0x318, ['pointer64', ['void']]],
    'HalIommuRegisterDispatchTable' : [ 0x320, ['pointer64', ['void']]],
    'HalTimerWatchdogStart' : [ 0x328, ['pointer64', ['void']]],
    'HalTimerWatchdogResetCountdown' : [ 0x330, ['pointer64', ['void']]],
    'HalTimerWatchdogStop' : [ 0x338, ['pointer64', ['void']]],
    'HalTimerWatchdogGeneratedLastReset' : [ 0x340, ['pointer64', ['void']]],
    'HalTimerWatchdogTriggerSystemReset' : [ 0x348, ['pointer64', ['void']]],
    'HalInterruptVectorDataToGsiv' : [ 0x350, ['pointer64', ['void']]],
    'HalInterruptGetHighestPriorityInterrupt' : [ 0x358, ['pointer64', ['void']]],
    'HalProcessorOn' : [ 0x360, ['pointer64', ['void']]],
    'HalProcessorOff' : [ 0x368, ['pointer64', ['void']]],
    'HalProcessorFreeze' : [ 0x370, ['pointer64', ['void']]],
    'HalDmaLinkDeviceObjectByToken' : [ 0x378, ['pointer64', ['void']]],
    'HalDmaCheckAdapterToken' : [ 0x380, ['pointer64', ['void']]],
    'Dummy4' : [ 0x388, ['pointer64', ['void']]],
    'HalTimerConvertPerformanceCounterToAuxiliaryCounter' : [ 0x390, ['pointer64', ['void']]],
    'HalTimerConvertAuxiliaryCounterToPerformanceCounter' : [ 0x398, ['pointer64', ['void']]],
    'HalTimerQueryAuxiliaryCounterFrequency' : [ 0x3a0, ['pointer64', ['void']]],
    'HalConnectThermalInterrupt' : [ 0x3a8, ['pointer64', ['void']]],
    'HalIsEFIRuntimeActive' : [ 0x3b0, ['pointer64', ['void']]],
    'HalTimerQueryAndResetRtcErrors' : [ 0x3b8, ['pointer64', ['void']]],
    'HalAcpiLateRestore' : [ 0x3c0, ['pointer64', ['void']]],
    'KdWatchdogDelayExpiration' : [ 0x3c8, ['pointer64', ['void']]],
    'HalGetProcessorStats' : [ 0x3d0, ['pointer64', ['void']]],
    'HalTimerWatchdogQueryDueTime' : [ 0x3d8, ['pointer64', ['void']]],
    'HalConnectSyntheticInterrupt' : [ 0x3e0, ['pointer64', ['void']]],
    'HalPreprocessNmi' : [ 0x3e8, ['pointer64', ['void']]],
    'HalEnumerateEnvironmentVariablesWithFilter' : [ 0x3f0, ['pointer64', ['void']]],
    'HalCaptureLastBranchRecordStack' : [ 0x3f8, ['pointer64', ['void']]],
    'HalClearLastBranchRecordStack' : [ 0x400, ['pointer64', ['void']]],
    'HalConfigureLastBranchRecord' : [ 0x408, ['pointer64', ['void']]],
    'HalGetLastBranchInformation' : [ 0x410, ['pointer64', ['void']]],
    'HalResumeLastBranchRecord' : [ 0x418, ['pointer64', ['void']]],
    'HalStartLastBranchRecord' : [ 0x420, ['pointer64', ['void']]],
    'HalStopLastBranchRecord' : [ 0x428, ['pointer64', ['void']]],
    'HalIommuBlockDevice' : [ 0x430, ['pointer64', ['void']]],
    'HalIommuUnblockDevice' : [ 0x438, ['pointer64', ['void']]],
    'HalGetIommuInterface' : [ 0x440, ['pointer64', ['void']]],
    'HalRequestGenericErrorRecovery' : [ 0x448, ['pointer64', ['void']]],
    'HalTimerQueryHostPerformanceCounter' : [ 0x450, ['pointer64', ['void']]],
} ],
  '_PS_TRUSTLET_ATTRIBUTE_ACCESSRIGHTS' : [ 0x1, {
    'Trustlet' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'Ntos' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'WriteHandle' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'ReadHandle' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 8, native_type='unsigned char')]],
    'AccessRights' : [ 0x0, ['unsigned char']],
} ],
  '_KSECURE_FAULT_INFORMATION' : [ 0x10, {
    'FaultCode' : [ 0x0, ['unsigned long long']],
    'FaultVa' : [ 0x8, ['unsigned long long']],
} ],
  '_KREQUEST_PACKET' : [ 0x20, {
    'CurrentPacket' : [ 0x0, ['array', 3, ['pointer64', ['void']]]],
    'WorkerRoutine' : [ 0x18, ['pointer64', ['void']]],
} ],
  '_PS_PROCESS_WAKE_INFORMATION' : [ 0x30, {
    'NotificationChannel' : [ 0x0, ['unsigned long long']],
    'WakeCounters' : [ 0x8, ['array', 7, ['unsigned long']]],
    'WakeFilter' : [ 0x24, ['_JOBOBJECT_WAKE_FILTER']],
    'NoWakeCounter' : [ 0x2c, ['unsigned long']],
} ],
  '_HBASE_BLOCK' : [ 0x1000, {
    'Signature' : [ 0x0, ['unsigned long']],
    'Sequence1' : [ 0x4, ['unsigned long']],
    'Sequence2' : [ 0x8, ['unsigned long']],
    'TimeStamp' : [ 0xc, ['_LARGE_INTEGER']],
    'Major' : [ 0x14, ['unsigned long']],
    'Minor' : [ 0x18, ['unsigned long']],
    'Type' : [ 0x1c, ['unsigned long']],
    'Format' : [ 0x20, ['unsigned long']],
    'RootCell' : [ 0x24, ['unsigned long']],
    'Length' : [ 0x28, ['unsigned long']],
    'Cluster' : [ 0x2c, ['unsigned long']],
    'FileName' : [ 0x30, ['array', 64, ['unsigned char']]],
    'RmId' : [ 0x70, ['_GUID']],
    'LogId' : [ 0x80, ['_GUID']],
    'Flags' : [ 0x90, ['unsigned long']],
    'TmId' : [ 0x94, ['_GUID']],
    'GuidSignature' : [ 0xa4, ['unsigned long']],
    'LastReorganizeTime' : [ 0xa8, ['unsigned long long']],
    'Reserved1' : [ 0xb0, ['array', 83, ['unsigned long']]],
    'CheckSum' : [ 0x1fc, ['unsigned long']],
    'Reserved2' : [ 0x200, ['array', 882, ['unsigned long']]],
    'ThawTmId' : [ 0xfc8, ['_GUID']],
    'ThawRmId' : [ 0xfd8, ['_GUID']],
    'ThawLogId' : [ 0xfe8, ['_GUID']],
    'BootType' : [ 0xff8, ['unsigned long']],
    'BootRecover' : [ 0xffc, ['unsigned long']],
} ],
  '__unnamed_23dd' : [ 0x4, {
    'DeviceNumber' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 5, native_type='unsigned long')]],
    'FunctionNumber' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 8, native_type='unsigned long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 32, native_type='unsigned long')]],
} ],
  '__unnamed_23df' : [ 0x4, {
    'bits' : [ 0x0, ['__unnamed_23dd']],
    'AsULONG' : [ 0x0, ['unsigned long']],
} ],
  '_WHEA_PCI_SLOT_NUMBER' : [ 0x4, {
    'u' : [ 0x0, ['__unnamed_23df']],
} ],
  '_PROCESS_ENERGY_VALUES' : [ 0x110, {
    'Cycles' : [ 0x0, ['array', 4, ['array', 2, ['unsigned long long']]]],
    'DiskEnergy' : [ 0x40, ['unsigned long long']],
    'NetworkTailEnergy' : [ 0x48, ['unsigned long long']],
    'MBBTailEnergy' : [ 0x50, ['unsigned long long']],
    'NetworkTxRxBytes' : [ 0x58, ['unsigned long long']],
    'MBBTxRxBytes' : [ 0x60, ['unsigned long long']],
    'Durations' : [ 0x68, ['array', 3, ['_ENERGY_STATE_DURATION']]],
    'ForegroundDuration' : [ 0x68, ['_ENERGY_STATE_DURATION']],
    'DesktopVisibleDuration' : [ 0x70, ['_ENERGY_STATE_DURATION']],
    'PSMForegroundDuration' : [ 0x78, ['_ENERGY_STATE_DURATION']],
    'CompositionRendered' : [ 0x80, ['unsigned long']],
    'CompositionDirtyGenerated' : [ 0x84, ['unsigned long']],
    'CompositionDirtyPropagated' : [ 0x88, ['unsigned long']],
    'Reserved1' : [ 0x8c, ['unsigned long']],
    'AttributedCycles' : [ 0x90, ['array', 4, ['array', 2, ['unsigned long long']]]],
    'WorkOnBehalfCycles' : [ 0xd0, ['array', 4, ['array', 2, ['unsigned long long']]]],
} ],
  '_MMCLONE_HEADER' : [ 0x20, {
    'NumberOfPtes' : [ 0x0, ['unsigned long long']],
    'NumberOfProcessReferences' : [ 0x8, ['unsigned long long']],
    'ClonePtes' : [ 0x10, ['pointer64', ['_MMCLONE_BLOCK']]],
    'Partition' : [ 0x18, ['pointer64', ['_MI_PARTITION']]],
} ],
  '_MI_SYSTEM_INFORMATION' : [ 0x2080, {
    'Pools' : [ 0x0, ['_MI_POOL_STATE']],
    'Sections' : [ 0x180, ['_MI_SECTION_STATE']],
    'SystemImages' : [ 0x400, ['_MI_SYSTEM_IMAGE_STATE']],
    'Sessions' : [ 0x4c0, ['_MI_SESSION_STATE']],
    'Processes' : [ 0x548, ['_MI_PROCESS_STATE']],
    'Hardware' : [ 0x590, ['_MI_HARDWARE_STATE']],
    'SystemVa' : [ 0x700, ['_MI_SYSTEM_VA_STATE']],
    'PageCombines' : [ 0xc00, ['_MI_COMBINE_STATE']],
    'PageLists' : [ 0xc18, ['_MI_PAGELIST_STATE']],
    'Partitions' : [ 0xc40, ['_MI_PARTITION_STATE']],
    'Shutdowns' : [ 0xca0, ['_MI_SHUTDOWN_STATE']],
    'Errors' : [ 0xd18, ['_MI_ERROR_STATE']],
    'AccessLog' : [ 0xe00, ['_MI_ACCESS_LOG_STATE']],
    'Debugger' : [ 0xe80, ['_MI_DEBUGGER_STATE']],
    'Standby' : [ 0xfa0, ['_MI_STANDBY_STATE']],
    'SystemPtes' : [ 0x1040, ['_MI_SYSTEM_PTE_STATE']],
    'IoPages' : [ 0x1240, ['_MI_IO_PAGE_STATE']],
    'PagingIo' : [ 0x12b0, ['_MI_PAGING_IO_STATE']],
    'CommonPages' : [ 0x1300, ['_MI_COMMON_PAGE_STATE']],
    'Trims' : [ 0x13c0, ['_MI_SYSTEM_TRIM_STATE']],
    'Cookie' : [ 0x1400, ['unsigned long long']],
    'BootRegistryRuns' : [ 0x1408, ['pointer64', ['pointer64', ['void']]]],
    'ZeroingDisabled' : [ 0x1410, ['long']],
    'FullyInitialized' : [ 0x1414, ['unsigned char']],
    'SafeBooted' : [ 0x1415, ['unsigned char']],
    'TraceLogging' : [ 0x1418, ['pointer64', ['_TlgProvider_t']]],
    'Vs' : [ 0x1440, ['_MI_VISIBLE_STATE']],
} ],
  '_CMSI_RW_LOCK' : [ 0x8, {
    'Reserved' : [ 0x0, ['pointer64', ['void']]],
} ],
  '_ETW_SILO_TRACING_BLOCK' : [ 0x40, {
    'ProcessorBuffers' : [ 0x0, ['pointer64', ['_EX_FAST_REF']]],
    'EventsLoggedCount' : [ 0x8, ['pointer64', ['unsigned long long']]],
} ],
  '_MI_VISIBLE_PARTITION' : [ 0x1200, {
    'LowestPhysicalPage' : [ 0x0, ['unsigned long long']],
    'HighestPhysicalPage' : [ 0x8, ['unsigned long long']],
    'NumberOfPhysicalPages' : [ 0x10, ['unsigned long long']],
    'NumberOfPagingFiles' : [ 0x18, ['unsigned long']],
    'SystemCacheInitialized' : [ 0x1c, ['unsigned char']],
    'PagingFile' : [ 0x20, ['array', 16, ['pointer64', ['_MMPAGING_FILE']]]],
    'AvailablePages' : [ 0xc0, ['unsigned long long']],
    'ResidentAvailablePages' : [ 0x100, ['unsigned long long']],
    'PartitionWs' : [ 0x140, ['array', 1, ['_MMSUPPORT_INSTANCE']]],
    'PartitionWorkingSetLists' : [ 0x200, ['array', 1, ['_MMWSL_INSTANCE']]],
    'TotalCommittedPages' : [ 0x228, ['unsigned long long']],
    'ModifiedPageListHead' : [ 0x240, ['_MMPFNLIST']],
    'ModifiedNoWritePageListHead' : [ 0x280, ['_MMPFNLIST']],
    'TotalCommitLimit' : [ 0x2a8, ['unsigned long long']],
    'TotalPagesForPagingFile' : [ 0x2b0, ['unsigned long long']],
    'VadPhysicalPages' : [ 0x2b8, ['unsigned long long']],
    'ProcessLockedFilePages' : [ 0x2c0, ['unsigned long long']],
    'SharedCommit' : [ 0x2c8, ['unsigned long long']],
    'ChargeCommitmentFailures' : [ 0x2d0, ['array', 4, ['unsigned long']]],
    'PageFileTraceIndex' : [ 0x2e0, ['long']],
    'PageFileTraces' : [ 0x2e8, ['array', 32, ['_MI_PAGEFILE_TRACES']]],
} ],
  '_WHEA_XPF_MCE_DESCRIPTOR' : [ 0x398, {
    'Type' : [ 0x0, ['unsigned short']],
    'Enabled' : [ 0x2, ['unsigned char']],
    'NumberOfBanks' : [ 0x3, ['unsigned char']],
    'Flags' : [ 0x4, ['_XPF_MCE_FLAGS']],
    'MCG_Capability' : [ 0x8, ['unsigned long long']],
    'MCG_GlobalControl' : [ 0x10, ['unsigned long long']],
    'Banks' : [ 0x18, ['array', 32, ['_WHEA_XPF_MC_BANK_DESCRIPTOR']]],
} ],
  '_WHEAP_ERROR_SOURCE_TABLE' : [ 0x30, {
    'Signature' : [ 0x0, ['unsigned long']],
    'Count' : [ 0x4, ['long']],
    'Items' : [ 0x8, ['_LIST_ENTRY']],
    'InsertLock' : [ 0x18, ['_KEVENT']],
} ],
  '_ETW_DECODE_CONTROL_ENTRY' : [ 0x30, {
    'Next' : [ 0x0, ['pointer64', ['_ETW_DECODE_CONTROL_ENTRY']]],
    'Decode' : [ 0x8, ['_GUID']],
    'Control' : [ 0x18, ['_GUID']],
    'ConsumersNotified' : [ 0x28, ['unsigned char']],
} ],
  '__unnamed_241a' : [ 0x4, {
    'UserData' : [ 0x0, ['unsigned long']],
    'Next' : [ 0x0, ['unsigned long']],
} ],
  '__unnamed_241c' : [ 0x4, {
    'u' : [ 0x0, ['__unnamed_241a']],
} ],
  '__unnamed_241e' : [ 0x4, {
    'NewCell' : [ 0x0, ['__unnamed_241c']],
} ],
  '_HCELL' : [ 0x8, {
    'Size' : [ 0x0, ['long']],
    'u' : [ 0x4, ['__unnamed_241e']],
} ],
  '_HMAP_DIRECTORY' : [ 0x2000, {
    'Directory' : [ 0x0, ['array', 1024, ['pointer64', ['_HMAP_TABLE']]]],
} ],
  '__unnamed_2426' : [ 0x2, {
    'AsUSHORT' : [ 0x0, ['unsigned short']],
    'AllowScaling' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
    'Disabled' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned short')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 16, native_type='unsigned short')]],
} ],
  'PROCESSOR_IDLESTATE_POLICY' : [ 0x20, {
    'Revision' : [ 0x0, ['unsigned short']],
    'Flags' : [ 0x2, ['__unnamed_2426']],
    'PolicyCount' : [ 0x4, ['unsigned long']],
    'Policy' : [ 0x8, ['array', 3, ['PROCESSOR_IDLESTATE_INFO']]],
} ],
  '_LOGGED_STREAM_CALLBACK_V1' : [ 0x10, {
    'LogHandle' : [ 0x0, ['pointer64', ['void']]],
    'FlushToLsnRoutine' : [ 0x8, ['pointer64', ['void']]],
} ],
  '_MI_LARGEPAGE_IMAGE_INFO' : [ 0x10, {
    'LargeImageBias' : [ 0x0, ['unsigned char']],
    'Spare' : [ 0x1, ['array', 3, ['unsigned char']]],
    'ActualImageViewSize' : [ 0x8, ['unsigned long long']],
} ],
  '__unnamed_2433' : [ 0x4, {
    'NodeSize' : [ 0x0, ['unsigned long']],
    'UseLookaside' : [ 0x0, ['unsigned long']],
} ],
  '_VF_AVL_TREE' : [ 0x28, {
    'NodeRangeSize' : [ 0x0, ['unsigned long long']],
    'NodeCount' : [ 0x8, ['unsigned long long']],
    'Tables' : [ 0x10, ['pointer64', ['_VF_AVL_TABLE']]],
    'TablesNo' : [ 0x18, ['unsigned long']],
    'UseSessionId' : [ 0x1c, ['unsigned char']],
    'u1' : [ 0x20, ['__unnamed_2433']],
} ],
  '_IMAGE_FILE_HEADER' : [ 0x14, {
    'Machine' : [ 0x0, ['unsigned short']],
    'NumberOfSections' : [ 0x2, ['unsigned short']],
    'TimeDateStamp' : [ 0x4, ['unsigned long']],
    'PointerToSymbolTable' : [ 0x8, ['unsigned long']],
    'NumberOfSymbols' : [ 0xc, ['unsigned long']],
    'SizeOfOptionalHeader' : [ 0x10, ['unsigned short']],
    'Characteristics' : [ 0x12, ['unsigned short']],
} ],
  '_CACHE_MANAGER_CALLBACKS' : [ 0x20, {
    'AcquireForLazyWrite' : [ 0x0, ['pointer64', ['void']]],
    'ReleaseFromLazyWrite' : [ 0x8, ['pointer64', ['void']]],
    'AcquireForReadAhead' : [ 0x10, ['pointer64', ['void']]],
    'ReleaseFromReadAhead' : [ 0x18, ['pointer64', ['void']]],
} ],
  '_MMSUPPORT_FULL' : [ 0x110, {
    'Instance' : [ 0x0, ['_MMSUPPORT_INSTANCE']],
    'Shared' : [ 0xc0, ['_MMSUPPORT_SHARED']],
} ],
  '_JOBOBJECT_WAKE_FILTER' : [ 0x8, {
    'HighEdgeFilter' : [ 0x0, ['unsigned long']],
    'LowEdgeFilter' : [ 0x4, ['unsigned long']],
} ],
  '_MI_PROCESS_STATE' : [ 0x48, {
    'SystemDllBase' : [ 0x0, ['pointer64', ['void']]],
    'ColorSeed' : [ 0x8, ['unsigned long']],
    'RotatingUniprocessorNumber' : [ 0xc, ['long']],
    'CriticalSectionTimeout' : [ 0x10, ['_LARGE_INTEGER']],
    'ProcessList' : [ 0x18, ['_LIST_ENTRY']],
    'SharedUserDataPte' : [ 0x28, ['array', 2, ['pointer64', ['_MMPTE']]]],
    'HypervisorSharedVa' : [ 0x38, ['pointer64', ['void']]],
    'VadSecureCookie' : [ 0x40, ['unsigned long long']],
} ],
  '_MMSUPPORT_AGGREGATION' : [ 0x20, {
    'PageFaultCount' : [ 0x0, ['unsigned long']],
    'WorkingSetSize' : [ 0x8, ['unsigned long long']],
    'WorkingSetLeafSize' : [ 0x10, ['unsigned long long']],
    'PeakWorkingSetSize' : [ 0x18, ['unsigned long long']],
} ],
  '_IO_TIMER' : [ 0x30, {
    'Type' : [ 0x0, ['short']],
    'TimerFlag' : [ 0x2, ['short']],
    'TimerList' : [ 0x8, ['_LIST_ENTRY']],
    'TimerRoutine' : [ 0x18, ['pointer64', ['void']]],
    'Context' : [ 0x20, ['pointer64', ['void']]],
    'DeviceObject' : [ 0x28, ['pointer64', ['_DEVICE_OBJECT']]],
} ],
  '_EXCEPTION_POINTERS' : [ 0x10, {
    'ExceptionRecord' : [ 0x0, ['pointer64', ['_EXCEPTION_RECORD']]],
    'ContextRecord' : [ 0x8, ['pointer64', ['_CONTEXT']]],
} ],
  '_PRIVATE_CACHE_MAP' : [ 0x78, {
    'NodeTypeCode' : [ 0x0, ['short']],
    'Flags' : [ 0x0, ['_PRIVATE_CACHE_MAP_FLAGS']],
    'ReadAheadMask' : [ 0x4, ['unsigned long']],
    'FileObject' : [ 0x8, ['pointer64', ['_FILE_OBJECT']]],
    'FileOffset1' : [ 0x10, ['_LARGE_INTEGER']],
    'BeyondLastByte1' : [ 0x18, ['_LARGE_INTEGER']],
    'FileOffset2' : [ 0x20, ['_LARGE_INTEGER']],
    'BeyondLastByte2' : [ 0x28, ['_LARGE_INTEGER']],
    'SequentialReadCount' : [ 0x30, ['unsigned long']],
    'ReadAheadLength' : [ 0x34, ['unsigned long']],
    'ReadAheadOffset' : [ 0x38, ['_LARGE_INTEGER']],
    'ReadAheadBeyondLastByte' : [ 0x40, ['_LARGE_INTEGER']],
    'PrevReadAheadBeyondLastByte' : [ 0x48, ['unsigned long long']],
    'ReadAheadSpinLock' : [ 0x50, ['unsigned long long']],
    'PipelinedReadAheadRequestSize' : [ 0x58, ['unsigned long']],
    'ReadAheadGrowth' : [ 0x5c, ['unsigned long']],
    'PrivateLinks' : [ 0x60, ['_LIST_ENTRY']],
    'ReadAheadWorkItem' : [ 0x70, ['pointer64', ['void']]],
} ],
  '_ETW_GUID_ENTRY' : [ 0x190, {
    'GuidList' : [ 0x0, ['_LIST_ENTRY']],
    'RefCount' : [ 0x10, ['long long']],
    'Guid' : [ 0x18, ['_GUID']],
    'RegListHead' : [ 0x28, ['_LIST_ENTRY']],
    'SecurityDescriptor' : [ 0x38, ['pointer64', ['void']]],
    'LastEnable' : [ 0x40, ['_ETW_LAST_ENABLE_INFO']],
    'MatchId' : [ 0x40, ['unsigned long long']],
    'ProviderEnableInfo' : [ 0x50, ['_TRACE_ENABLE_INFO']],
    'EnableInfo' : [ 0x70, ['array', 8, ['_TRACE_ENABLE_INFO']]],
    'FilterData' : [ 0x170, ['pointer64', ['_ETW_FILTER_HEADER']]],
    'SiloState' : [ 0x178, ['pointer64', ['_ETW_SILODRIVERSTATE']]],
    'Lock' : [ 0x180, ['_EX_PUSH_LOCK']],
    'LockOwner' : [ 0x188, ['pointer64', ['_ETHREAD']]],
} ],
  '_ARBITER_INSTANCE' : [ 0x150, {
    'Signature' : [ 0x0, ['unsigned long']],
    'MutexEvent' : [ 0x8, ['pointer64', ['_KEVENT']]],
    'Name' : [ 0x10, ['pointer64', ['wchar']]],
    'OrderingName' : [ 0x18, ['pointer64', ['wchar']]],
    'ResourceType' : [ 0x20, ['long']],
    'Allocation' : [ 0x28, ['pointer64', ['_RTL_RANGE_LIST']]],
    'PossibleAllocation' : [ 0x30, ['pointer64', ['_RTL_RANGE_LIST']]],
    'OrderingList' : [ 0x38, ['_ARBITER_ORDERING_LIST']],
    'ReservedList' : [ 0x48, ['_ARBITER_ORDERING_LIST']],
    'ReferenceCount' : [ 0x58, ['long']],
    'Interface' : [ 0x60, ['pointer64', ['_ARBITER_INTERFACE']]],
    'AllocationStackMaxSize' : [ 0x68, ['unsigned long']],
    'AllocationStack' : [ 0x70, ['pointer64', ['_ARBITER_ALLOCATION_STATE']]],
    'UnpackRequirement' : [ 0x78, ['pointer64', ['void']]],
    'PackResource' : [ 0x80, ['pointer64', ['void']]],
    'UnpackResource' : [ 0x88, ['pointer64', ['void']]],
    'ScoreRequirement' : [ 0x90, ['pointer64', ['void']]],
    'TestAllocation' : [ 0x98, ['pointer64', ['void']]],
    'RetestAllocation' : [ 0xa0, ['pointer64', ['void']]],
    'CommitAllocation' : [ 0xa8, ['pointer64', ['void']]],
    'RollbackAllocation' : [ 0xb0, ['pointer64', ['void']]],
    'BootAllocation' : [ 0xb8, ['pointer64', ['void']]],
    'QueryArbitrate' : [ 0xc0, ['pointer64', ['void']]],
    'QueryConflict' : [ 0xc8, ['pointer64', ['void']]],
    'AddReserved' : [ 0xd0, ['pointer64', ['void']]],
    'StartArbiter' : [ 0xd8, ['pointer64', ['void']]],
    'PreprocessEntry' : [ 0xe0, ['pointer64', ['void']]],
    'AllocateEntry' : [ 0xe8, ['pointer64', ['void']]],
    'GetNextAllocationRange' : [ 0xf0, ['pointer64', ['void']]],
    'FindSuitableRange' : [ 0xf8, ['pointer64', ['void']]],
    'AddAllocation' : [ 0x100, ['pointer64', ['void']]],
    'BacktrackAllocation' : [ 0x108, ['pointer64', ['void']]],
    'OverrideConflict' : [ 0x110, ['pointer64', ['void']]],
    'InitializeRangeList' : [ 0x118, ['pointer64', ['void']]],
    'TransactionInProgress' : [ 0x120, ['unsigned char']],
    'TransactionEvent' : [ 0x128, ['pointer64', ['_KEVENT']]],
    'Extension' : [ 0x130, ['pointer64', ['void']]],
    'BusDeviceObject' : [ 0x138, ['pointer64', ['_DEVICE_OBJECT']]],
    'ConflictCallbackContext' : [ 0x140, ['pointer64', ['void']]],
    'ConflictCallback' : [ 0x148, ['pointer64', ['void']]],
} ],
  '_SECURITY_CLIENT_CONTEXT' : [ 0x48, {
    'SecurityQos' : [ 0x0, ['_SECURITY_QUALITY_OF_SERVICE']],
    'ClientToken' : [ 0x10, ['pointer64', ['void']]],
    'DirectlyAccessClientToken' : [ 0x18, ['unsigned char']],
    'DirectAccessEffectiveOnly' : [ 0x19, ['unsigned char']],
    'ServerIsRemote' : [ 0x1a, ['unsigned char']],
    'ClientTokenControl' : [ 0x1c, ['_TOKEN_CONTROL']],
} ],
  '_VF_POOL_TRACE' : [ 0x80, {
    'Address' : [ 0x0, ['pointer64', ['void']]],
    'Size' : [ 0x8, ['unsigned long long']],
    'Thread' : [ 0x10, ['pointer64', ['_ETHREAD']]],
    'StackTrace' : [ 0x18, ['array', 13, ['pointer64', ['void']]]],
} ],
  '_RTLP_HP_HEAP_GLOBALS' : [ 0x18, {
    'HeapKey' : [ 0x0, ['unsigned long long']],
    'LfhKey' : [ 0x8, ['unsigned long long']],
    'FailureInfo' : [ 0x10, ['pointer64', ['_HEAP_FAILURE_INFORMATION']]],
} ],
  '_MI_SYSTEM_IMAGE_STATE' : [ 0xc0, {
    'FixupList' : [ 0x0, ['_LIST_ENTRY']],
    'LoadLock' : [ 0x10, ['_KMUTANT']],
    'FixupLock' : [ 0x48, ['long']],
    'FirstLoadEver' : [ 0x4c, ['unsigned char']],
    'LargePageAll' : [ 0x4d, ['unsigned char']],
    'LastPage' : [ 0x50, ['unsigned long long']],
    'LargePageList' : [ 0x58, ['_LIST_ENTRY']],
    'StrongCodeLoadFailureList' : [ 0x68, ['_LIST_ENTRY']],
    'BeingDeleted' : [ 0x78, ['pointer64', ['_KLDR_DATA_TABLE_ENTRY']]],
    'MappingRangesPushLock' : [ 0x80, ['_EX_PUSH_LOCK']],
    'MappingRanges' : [ 0x88, ['array', 2, ['pointer64', ['_MI_DRIVER_VA']]]],
    'PageCount' : [ 0x98, ['unsigned long long']],
    'PageCounts' : [ 0xa0, ['_MM_SYSTEM_PAGE_COUNTS']],
    'CollidedLock' : [ 0xb0, ['_EX_PUSH_LOCK']],
    'ImageTree' : [ 0xb8, ['_RTL_AVL_TREE']],
} ],
  '_MMPFNENTRY1' : [ 0x1, {
    'PageLocation' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 3, native_type='unsigned char')]],
    'WriteInProgress' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'Modified' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'ReadInProgress' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'CacheAttribute' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 8, native_type='unsigned char')]],
} ],
  '_VI_FAULT_TRACE' : [ 0x48, {
    'Thread' : [ 0x0, ['pointer64', ['_ETHREAD']]],
    'StackTrace' : [ 0x8, ['array', 8, ['pointer64', ['void']]]],
} ],
  '_MI_FLAGS' : [ 0x4, {
    'EntireFlags' : [ 0x0, ['long']],
    'VerifierEnabled' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'KernelVerifierEnabled' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'LargePageKernel' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'StopOn4d' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'InitializationPhase' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 6, native_type='unsigned long')]],
    'PageKernelStacks' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'CheckZeroPages' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'ProcessorPrewalks' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'ProcessorPostwalks' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'CoverageBuild' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'AccessBitReplacementDisabled' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'CheckExecute' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long')]],
    'ProtectedPagesEnabled' : [ 0x0, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long')]],
    'SecureRelocations' : [ 0x0, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long')]],
    'StrongPageIdentity' : [ 0x0, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'StrongCodeGuarantees' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'HardCodeGuarantees' : [ 0x0, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'ExecutePagePrivilegeRequired' : [ 0x0, ['BitField', dict(start_bit = 18, end_bit = 19, native_type='unsigned long')]],
    'SecureKernelCfgEnabled' : [ 0x0, ['BitField', dict(start_bit = 19, end_bit = 20, native_type='unsigned long')]],
    'FullHvci' : [ 0x0, ['BitField', dict(start_bit = 20, end_bit = 21, native_type='unsigned long')]],
    'SlatKernelCodeProtected' : [ 0x0, ['BitField', dict(start_bit = 21, end_bit = 22, native_type='unsigned long')]],
    'BootDebuggerActive' : [ 0x0, ['BitField', dict(start_bit = 22, end_bit = 23, native_type='unsigned long')]],
    'ExceptionHandlingReady' : [ 0x0, ['BitField', dict(start_bit = 23, end_bit = 24, native_type='unsigned long')]],
} ],
  '_NAMED_PIPE_CREATE_PARAMETERS' : [ 0x28, {
    'NamedPipeType' : [ 0x0, ['unsigned long']],
    'ReadMode' : [ 0x4, ['unsigned long']],
    'CompletionMode' : [ 0x8, ['unsigned long']],
    'MaximumInstances' : [ 0xc, ['unsigned long']],
    'InboundQuota' : [ 0x10, ['unsigned long']],
    'OutboundQuota' : [ 0x14, ['unsigned long']],
    'DefaultTimeout' : [ 0x18, ['_LARGE_INTEGER']],
    'TimeoutSpecified' : [ 0x20, ['unsigned char']],
} ],
  '_ACL' : [ 0x8, {
    'AclRevision' : [ 0x0, ['unsigned char']],
    'Sbz1' : [ 0x1, ['unsigned char']],
    'AclSize' : [ 0x2, ['unsigned short']],
    'AceCount' : [ 0x4, ['unsigned short']],
    'Sbz2' : [ 0x6, ['unsigned short']],
} ],
  '_PENDING_RELATIONS_LIST_ENTRY' : [ 0x70, {
    'Link' : [ 0x0, ['_LIST_ENTRY']],
    'WorkItem' : [ 0x10, ['_WORK_QUEUE_ITEM']],
    'DeviceEvent' : [ 0x30, ['pointer64', ['_PNP_DEVICE_EVENT_ENTRY']]],
    'DeviceObject' : [ 0x38, ['pointer64', ['_DEVICE_OBJECT']]],
    'RelationsList' : [ 0x40, ['pointer64', ['_RELATION_LIST']]],
    'EjectIrp' : [ 0x48, ['pointer64', ['_IRP']]],
    'Lock' : [ 0x50, ['Enumeration', dict(target = 'long', choices = {0: u'IRPLOCK_CANCELABLE', 1: u'IRPLOCK_CANCEL_STARTED', 2: u'IRPLOCK_CANCEL_COMPLETE', 3: u'IRPLOCK_COMPLETED'})]],
    'Problem' : [ 0x54, ['unsigned long']],
    'ProfileChangingEject' : [ 0x58, ['unsigned char']],
    'DisplaySafeRemovalDialog' : [ 0x59, ['unsigned char']],
    'LightestSleepState' : [ 0x5c, ['Enumeration', dict(target = 'long', choices = {0: u'PowerSystemUnspecified', 1: u'PowerSystemWorking', 2: u'PowerSystemSleeping1', 3: u'PowerSystemSleeping2', 4: u'PowerSystemSleeping3', 5: u'PowerSystemHibernate', 6: u'PowerSystemShutdown', 7: u'PowerSystemMaximum'})]],
    'DockInterface' : [ 0x60, ['pointer64', ['DOCK_INTERFACE']]],
    'DequeuePending' : [ 0x68, ['unsigned char']],
    'DeleteType' : [ 0x6c, ['Enumeration', dict(target = 'long', choices = {0: u'QueryRemoveDevice', 1: u'CancelRemoveDevice', 2: u'RemoveDevice', 3: u'SurpriseRemoveDevice', 4: u'EjectDevice', 5: u'RemoveFailedDevice', 6: u'RemoveUnstartedFailedDevice', 7: u'MaxDeviceDeleteType'})]],
} ],
  '_AUTHZBASEP_SECURITY_ATTRIBUTES_INFORMATION' : [ 0x30, {
    'SecurityAttributeCount' : [ 0x0, ['unsigned long']],
    'SecurityAttributesList' : [ 0x8, ['_LIST_ENTRY']],
    'WorkingSecurityAttributeCount' : [ 0x18, ['unsigned long']],
    'WorkingSecurityAttributesList' : [ 0x20, ['_LIST_ENTRY']],
} ],
  '_WAIT_CONTEXT_BLOCK' : [ 0x48, {
    'WaitQueueEntry' : [ 0x0, ['_KDEVICE_QUEUE_ENTRY']],
    'DmaWaitEntry' : [ 0x0, ['_LIST_ENTRY']],
    'NumberOfChannels' : [ 0x10, ['unsigned long']],
    'SyncCallback' : [ 0x14, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'DmaContext' : [ 0x14, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'ZeroMapRegisters' : [ 0x14, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'Reserved' : [ 0x14, ['BitField', dict(start_bit = 3, end_bit = 32, native_type='unsigned long')]],
    'DeviceRoutine' : [ 0x18, ['pointer64', ['void']]],
    'DeviceContext' : [ 0x20, ['pointer64', ['void']]],
    'NumberOfMapRegisters' : [ 0x28, ['unsigned long']],
    'DeviceObject' : [ 0x30, ['pointer64', ['void']]],
    'CurrentIrp' : [ 0x38, ['pointer64', ['void']]],
    'BufferChainingDpc' : [ 0x40, ['pointer64', ['_KDPC']]],
} ],
  'SYSTEM_POWER_CAPABILITIES' : [ 0x4c, {
    'PowerButtonPresent' : [ 0x0, ['unsigned char']],
    'SleepButtonPresent' : [ 0x1, ['unsigned char']],
    'LidPresent' : [ 0x2, ['unsigned char']],
    'SystemS1' : [ 0x3, ['unsigned char']],
    'SystemS2' : [ 0x4, ['unsigned char']],
    'SystemS3' : [ 0x5, ['unsigned char']],
    'SystemS4' : [ 0x6, ['unsigned char']],
    'SystemS5' : [ 0x7, ['unsigned char']],
    'HiberFilePresent' : [ 0x8, ['unsigned char']],
    'FullWake' : [ 0x9, ['unsigned char']],
    'VideoDimPresent' : [ 0xa, ['unsigned char']],
    'ApmPresent' : [ 0xb, ['unsigned char']],
    'UpsPresent' : [ 0xc, ['unsigned char']],
    'ThermalControl' : [ 0xd, ['unsigned char']],
    'ProcessorThrottle' : [ 0xe, ['unsigned char']],
    'ProcessorMinThrottle' : [ 0xf, ['unsigned char']],
    'ProcessorMaxThrottle' : [ 0x10, ['unsigned char']],
    'FastSystemS4' : [ 0x11, ['unsigned char']],
    'Hiberboot' : [ 0x12, ['unsigned char']],
    'WakeAlarmPresent' : [ 0x13, ['unsigned char']],
    'AoAc' : [ 0x14, ['unsigned char']],
    'DiskSpinDown' : [ 0x15, ['unsigned char']],
    'HiberFileType' : [ 0x16, ['unsigned char']],
    'AoAcConnectivitySupported' : [ 0x17, ['unsigned char']],
    'spare3' : [ 0x18, ['array', 6, ['unsigned char']]],
    'SystemBatteriesPresent' : [ 0x1e, ['unsigned char']],
    'BatteriesAreShortTerm' : [ 0x1f, ['unsigned char']],
    'BatteryScale' : [ 0x20, ['array', 3, ['BATTERY_REPORTING_SCALE']]],
    'AcOnLineWake' : [ 0x38, ['Enumeration', dict(target = 'long', choices = {0: u'PowerSystemUnspecified', 1: u'PowerSystemWorking', 2: u'PowerSystemSleeping1', 3: u'PowerSystemSleeping2', 4: u'PowerSystemSleeping3', 5: u'PowerSystemHibernate', 6: u'PowerSystemShutdown', 7: u'PowerSystemMaximum'})]],
    'SoftLidWake' : [ 0x3c, ['Enumeration', dict(target = 'long', choices = {0: u'PowerSystemUnspecified', 1: u'PowerSystemWorking', 2: u'PowerSystemSleeping1', 3: u'PowerSystemSleeping2', 4: u'PowerSystemSleeping3', 5: u'PowerSystemHibernate', 6: u'PowerSystemShutdown', 7: u'PowerSystemMaximum'})]],
    'RtcWake' : [ 0x40, ['Enumeration', dict(target = 'long', choices = {0: u'PowerSystemUnspecified', 1: u'PowerSystemWorking', 2: u'PowerSystemSleeping1', 3: u'PowerSystemSleeping2', 4: u'PowerSystemSleeping3', 5: u'PowerSystemHibernate', 6: u'PowerSystemShutdown', 7: u'PowerSystemMaximum'})]],
    'MinDeviceWakeState' : [ 0x44, ['Enumeration', dict(target = 'long', choices = {0: u'PowerSystemUnspecified', 1: u'PowerSystemWorking', 2: u'PowerSystemSleeping1', 3: u'PowerSystemSleeping2', 4: u'PowerSystemSleeping3', 5: u'PowerSystemHibernate', 6: u'PowerSystemShutdown', 7: u'PowerSystemMaximum'})]],
    'DefaultLowLatencyWake' : [ 0x48, ['Enumeration', dict(target = 'long', choices = {0: u'PowerSystemUnspecified', 1: u'PowerSystemWorking', 2: u'PowerSystemSleeping1', 3: u'PowerSystemSleeping2', 4: u'PowerSystemSleeping3', 5: u'PowerSystemHibernate', 6: u'PowerSystemShutdown', 7: u'PowerSystemMaximum'})]],
} ],
  '_KWAIT_CHAIN' : [ 0x8, {
    'Head' : [ 0x0, ['pointer64', ['void']]],
} ],
  '_ALPC_COMPLETION_PACKET_LOOKASIDE' : [ 0x50, {
    'Lock' : [ 0x0, ['unsigned long long']],
    'Size' : [ 0x8, ['unsigned long']],
    'ActiveCount' : [ 0xc, ['unsigned long']],
    'PendingNullCount' : [ 0x10, ['unsigned long']],
    'PendingCheckCompletionListCount' : [ 0x14, ['unsigned long']],
    'PendingDelete' : [ 0x18, ['unsigned long']],
    'FreeListHead' : [ 0x20, ['_SINGLE_LIST_ENTRY']],
    'CompletionPort' : [ 0x28, ['pointer64', ['void']]],
    'CompletionKey' : [ 0x30, ['pointer64', ['void']]],
    'Entry' : [ 0x38, ['array', 1, ['_ALPC_COMPLETION_PACKET_LOOKASIDE_ENTRY']]],
} ],
  '_VF_DRIVER_IO_CALLBACKS' : [ 0x100, {
    'DriverInit' : [ 0x0, ['pointer64', ['void']]],
    'DriverStartIo' : [ 0x8, ['pointer64', ['void']]],
    'DriverUnload' : [ 0x10, ['pointer64', ['void']]],
    'AddDevice' : [ 0x18, ['pointer64', ['void']]],
    'MajorFunction' : [ 0x20, ['array', 28, ['pointer64', ['void']]]],
} ],
  '_CM_UOW_SET_VALUE_KEY_DATA' : [ 0x10, {
    'PreparedCell' : [ 0x0, ['unsigned long']],
    'OldValueCell' : [ 0x4, ['unsigned long']],
    'NameLength' : [ 0x8, ['unsigned short']],
    'DataSize' : [ 0xc, ['unsigned long']],
} ],
  '_MI_PARTITION_STATE' : [ 0x60, {
    'PartitionLock' : [ 0x0, ['unsigned long long']],
    'PartitionIdLock' : [ 0x8, ['_EX_PUSH_LOCK']],
    'InitialPartitionIdBits' : [ 0x10, ['unsigned long long']],
    'PartitionList' : [ 0x18, ['_LIST_ENTRY']],
    'PartitionIdBitmap' : [ 0x28, ['pointer64', ['_RTL_BITMAP']]],
    'InitialPartitionIdBitmap' : [ 0x30, ['_RTL_BITMAP']],
    'TempPartitionPointers' : [ 0x40, ['array', 1, ['pointer64', ['_MI_PARTITION']]]],
    'Partition' : [ 0x48, ['pointer64', ['pointer64', ['_MI_PARTITION']]]],
    'TotalPagesInChildPartitions' : [ 0x50, ['unsigned long long']],
    'CrossPartitionDenials' : [ 0x58, ['unsigned long']],
    'MultiplePartitionsExist' : [ 0x5c, ['unsigned char']],
} ],
  '_POP_THERMAL_ZONE' : [ 0x368, {
    'PolicyDevice' : [ 0x0, ['_POP_POLICY_DEVICE']],
    'Link' : [ 0x0, ['_LIST_ENTRY']],
    'DeviceType' : [ 0x10, ['Enumeration', dict(target = 'long', choices = {0: u'PolicyDeviceSystemButton', 1: u'PolicyDeviceThermalZone', 2: u'PolicyDeviceBattery', 3: u'PolicyDeviceMemory', 4: u'PolicyInitiatePowerActionAPI', 5: u'PolicySetPowerStateAPI', 6: u'PolicyImmediateDozeS4', 7: u'PolicySystemIdle', 8: u'PolicyDeviceWakeAlarm', 9: u'PolicyDeviceFan', 10: u'PolicyCsBatterySaver', 11: u'PolicyImmediateDozeS4Predicted', 12: u'PolicyImmediateDozeS4PredictedNoWake', 13: u'PolicyImmediateDozeS4AdaptiveBudget', 14: u'PolicyImmediateDozeS4AdaptiveReserveNoWake', 15: u'PolicySystemInitiatedShutdown', 16: u'PolicyDeviceMax'})]],
    'Notification' : [ 0x18, ['pointer64', ['void']]],
    'Name' : [ 0x20, ['_UNICODE_STRING']],
    'Device' : [ 0x30, ['pointer64', ['_DEVICE_OBJECT']]],
    'Irp' : [ 0x38, ['pointer64', ['_IRP']]],
    'State' : [ 0x40, ['unsigned char']],
    'Flags' : [ 0x41, ['unsigned char']],
    'Removing' : [ 0x42, ['unsigned char']],
    'Mode' : [ 0x43, ['unsigned char']],
    'PendingMode' : [ 0x44, ['unsigned char']],
    'ActivePoint' : [ 0x45, ['unsigned char']],
    'PendingActivePoint' : [ 0x46, ['unsigned char']],
    'Critical' : [ 0x47, ['unsigned char']],
    'ThermalStandby' : [ 0x48, ['unsigned char']],
    'OverThrottled' : [ 0x49, ['unsigned char']],
    'HighPrecisionThrottle' : [ 0x4c, ['long']],
    'Throttle' : [ 0x50, ['long']],
    'PendingThrottle' : [ 0x54, ['long']],
    'ThrottleReasons' : [ 0x58, ['unsigned long']],
    'LastPassiveTime' : [ 0x60, ['unsigned long long']],
    'SampleRate' : [ 0x68, ['unsigned long']],
    'LastTemp' : [ 0x6c, ['unsigned long']],
    'Info' : [ 0x70, ['_THERMAL_INFORMATION_EX']],
    'Policy' : [ 0xcc, ['_THERMAL_POLICY']],
    'PolicyDriver' : [ 0xe4, ['unsigned char']],
    'PollingRate' : [ 0xe8, ['unsigned long']],
    'LastTemperatureTime' : [ 0xf0, ['unsigned long long']],
    'LastActiveStartTime' : [ 0xf8, ['unsigned long long']],
    'LastPassiveStartTime' : [ 0x100, ['unsigned long long']],
    'WorkItem' : [ 0x108, ['_WORK_QUEUE_ITEM']],
    'ZoneUpdateTimer' : [ 0x128, ['_KTIMER2']],
    'Lock' : [ 0x1b0, ['_POP_RW_LOCK']],
    'ZoneStopped' : [ 0x1c0, ['_KEVENT']],
    'TemperatureUpdated' : [ 0x1d8, ['_KEVENT']],
    'InstanceId' : [ 0x1f0, ['unsigned long']],
    'TelemetryTracker' : [ 0x1f8, ['_POP_THERMAL_TELEMETRY_TRACKER']],
    'Description' : [ 0x358, ['_UNICODE_STRING']],
} ],
  '_CM_DIRTY_VECTOR_LOG' : [ 0x488, {
    'Next' : [ 0x0, ['unsigned long']],
    'Size' : [ 0x4, ['unsigned long']],
    'Log' : [ 0x8, ['array', 16, ['_CM_DIRTY_VECTOR_LOG_ENTRY']]],
} ],
  '__unnamed_250f' : [ 0x4, {
    'Bus' : [ 0x0, ['unsigned char']],
    'Device' : [ 0x1, ['unsigned char']],
    'Function' : [ 0x2, ['unsigned char']],
    'Reserved' : [ 0x3, ['unsigned char']],
} ],
  '__unnamed_2511' : [ 0x2, {
    'SecondaryBus' : [ 0x0, ['unsigned char']],
    'SubordinateBus' : [ 0x1, ['unsigned char']],
} ],
  '_PCI_BUSMASTER_DESCRIPTOR' : [ 0xc, {
    'Type' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: u'BusmasterRidFromDeviceRid', 1: u'BusmasterRidFromBridgeRid', 2: u'BusmasterRidFromMultipleBridges'})]],
    'Segment' : [ 0x4, ['unsigned long']],
    'DeviceRid' : [ 0x8, ['__unnamed_250f']],
    'BridgeRid' : [ 0x8, ['__unnamed_250f']],
    'MultipleBridges' : [ 0x8, ['__unnamed_2511']],
} ],
  '_HVP_VIEW_MAP' : [ 0x38, {
    'SectionReference' : [ 0x0, ['pointer64', ['void']]],
    'StorageEndFileOffset' : [ 0x8, ['long long']],
    'SectionEndFileOffset' : [ 0x10, ['long long']],
    'ProcessTuple' : [ 0x18, ['pointer64', ['_CMSI_PROCESS_TUPLE']]],
    'Flags' : [ 0x20, ['unsigned long']],
    'ViewTree' : [ 0x28, ['_RTL_RB_TREE']],
} ],
  '_WHEA_IPF_MCA_DESCRIPTOR' : [ 0x4, {
    'Type' : [ 0x0, ['unsigned short']],
    'Enabled' : [ 0x2, ['unsigned char']],
    'Reserved' : [ 0x3, ['unsigned char']],
} ],
  '_TRIAGE_PNP_DEVICE_COMPLETION_REQUEST' : [ 0x18, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'DeviceNode' : [ 0x10, ['pointer64', ['_TRIAGE_DEVICE_NODE']]],
} ],
  '_HIVE_WRITE_WAIT_QUEUE' : [ 0x18, {
    'ActiveThread' : [ 0x0, ['pointer64', ['_ETHREAD']]],
    'WaitList' : [ 0x8, ['pointer64', ['_HIVE_WAIT_PACKET']]],
    'OwnerBoosted' : [ 0x10, ['unsigned long']],
} ],
  '_BUS_EXTENSION_LIST' : [ 0x10, {
    'Next' : [ 0x0, ['pointer64', ['void']]],
    'BusExtension' : [ 0x8, ['pointer64', ['_PI_BUS_EXTENSION']]],
} ],
  '_HAL_LOG_REGISTER_CONTEXT' : [ 0x10, {
    'LogRoutine' : [ 0x0, ['pointer64', ['void']]],
    'Flag' : [ 0x8, ['unsigned long']],
} ],
  '_DEVICE_OBJECT_LIST_ENTRY' : [ 0x18, {
    'DeviceObject' : [ 0x0, ['pointer64', ['_DEVICE_OBJECT']]],
    'RelationLevel' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {0: u'RELATION_LEVEL_REMOVE_EJECT', 1: u'RELATION_LEVEL_DEPENDENT', 2: u'RELATION_LEVEL_DIRECT_DESCENDANT'})]],
    'Ordinal' : [ 0xc, ['unsigned long']],
    'Flags' : [ 0x10, ['unsigned long']],
} ],
  '_HBIN' : [ 0x20, {
    'Signature' : [ 0x0, ['unsigned long']],
    'FileOffset' : [ 0x4, ['unsigned long']],
    'Size' : [ 0x8, ['unsigned long']],
    'Reserved1' : [ 0xc, ['array', 2, ['unsigned long']]],
    'TimeStamp' : [ 0x14, ['_LARGE_INTEGER']],
    'Spare' : [ 0x1c, ['unsigned long']],
} ],
  '_PS_PROTECTION' : [ 0x1, {
    'Level' : [ 0x0, ['unsigned char']],
    'Type' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 3, native_type='unsigned char')]],
    'Audit' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'Signer' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 8, native_type='unsigned char')]],
} ],
  '_MMPFNENTRY3' : [ 0x1, {
    'Priority' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 3, native_type='unsigned char')]],
    'OnProtectedStandby' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'InPageError' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'SystemChargedPage' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'RemovalRequested' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned char')]],
    'ParityError' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
} ],
  '_SEP_SID_VALUES_BLOCK' : [ 0x20, {
    'BlockLength' : [ 0x0, ['unsigned long']],
    'ReferenceCount' : [ 0x8, ['long long']],
    'SidCount' : [ 0x10, ['unsigned long']],
    'SidValuesStart' : [ 0x18, ['unsigned long long']],
} ],
  '_MM_PAGE_ACCESS_INFO' : [ 0x8, {
    'Flags' : [ 0x0, ['_MM_PAGE_ACCESS_INFO_FLAGS']],
    'FileOffset' : [ 0x0, ['unsigned long long']],
    'VirtualAddress' : [ 0x0, ['pointer64', ['void']]],
    'PointerProtoPte' : [ 0x0, ['pointer64', ['void']]],
} ],
  '_NT_TIB64' : [ 0x38, {
    'ExceptionList' : [ 0x0, ['unsigned long long']],
    'StackBase' : [ 0x8, ['unsigned long long']],
    'StackLimit' : [ 0x10, ['unsigned long long']],
    'SubSystemTib' : [ 0x18, ['unsigned long long']],
    'FiberData' : [ 0x20, ['unsigned long long']],
    'Version' : [ 0x20, ['unsigned long']],
    'ArbitraryUserPointer' : [ 0x28, ['unsigned long long']],
    'Self' : [ 0x30, ['unsigned long long']],
} ],
  '_EX_RUNDOWN_REF_CACHE_AWARE' : [ 0x18, {
    'RunRefs' : [ 0x0, ['pointer64', ['_EX_RUNDOWN_REF']]],
    'PoolToFree' : [ 0x8, ['pointer64', ['void']]],
    'RunRefSize' : [ 0x10, ['unsigned long']],
    'Number' : [ 0x14, ['unsigned long']],
} ],
  '_MI_SESSION_DRIVER_UNLOAD' : [ 0x8, {
    'Function' : [ 0x0, ['pointer64', ['void']]],
    'FunctionValue' : [ 0x0, ['unsigned long long']],
} ],
  '__unnamed_2549' : [ 0x4, {
    'FilePointerIndex' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 9, native_type='unsigned long')]],
    'HardFault' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'Image' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'Spare0' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
} ],
  '__unnamed_254b' : [ 0x4, {
    'FilePointerIndex' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 9, native_type='unsigned long')]],
    'HardFault' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'Spare1' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 12, native_type='unsigned long')]],
} ],
  '_MM_PAGE_ACCESS_INFO_FLAGS' : [ 0x4, {
    'File' : [ 0x0, ['__unnamed_2549']],
    'Private' : [ 0x0, ['__unnamed_254b']],
} ],
  '_CM_TRANS_PTR' : [ 0x8, {
    'LightWeight' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'TransPtr' : [ 0x0, ['pointer64', ['void']]],
} ],
  '_CM_WORKITEM' : [ 0x28, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'Private' : [ 0x10, ['unsigned long']],
    'WorkerRoutine' : [ 0x18, ['pointer64', ['void']]],
    'Parameter' : [ 0x20, ['pointer64', ['void']]],
} ],
  '_PS_TRUSTLET_ATTRIBUTE_TYPE' : [ 0x4, {
    'Version' : [ 0x0, ['unsigned char']],
    'DataCount' : [ 0x1, ['unsigned char']],
    'SemanticType' : [ 0x2, ['unsigned char']],
    'AccessRights' : [ 0x3, ['_PS_TRUSTLET_ATTRIBUTE_ACCESSRIGHTS']],
    'AttributeType' : [ 0x0, ['unsigned long']],
} ],
  '_CM_KEY_HASH' : [ 0x20, {
    'ConvKey' : [ 0x0, ['_CM_PATH_HASH']],
    'NextHash' : [ 0x8, ['pointer64', ['_CM_KEY_HASH']]],
    'KeyHive' : [ 0x10, ['pointer64', ['_HHIVE']]],
    'KeyCell' : [ 0x18, ['unsigned long']],
} ],
  '_FAST_IO_DISPATCH' : [ 0xe0, {
    'SizeOfFastIoDispatch' : [ 0x0, ['unsigned long']],
    'FastIoCheckIfPossible' : [ 0x8, ['pointer64', ['void']]],
    'FastIoRead' : [ 0x10, ['pointer64', ['void']]],
    'FastIoWrite' : [ 0x18, ['pointer64', ['void']]],
    'FastIoQueryBasicInfo' : [ 0x20, ['pointer64', ['void']]],
    'FastIoQueryStandardInfo' : [ 0x28, ['pointer64', ['void']]],
    'FastIoLock' : [ 0x30, ['pointer64', ['void']]],
    'FastIoUnlockSingle' : [ 0x38, ['pointer64', ['void']]],
    'FastIoUnlockAll' : [ 0x40, ['pointer64', ['void']]],
    'FastIoUnlockAllByKey' : [ 0x48, ['pointer64', ['void']]],
    'FastIoDeviceControl' : [ 0x50, ['pointer64', ['void']]],
    'AcquireFileForNtCreateSection' : [ 0x58, ['pointer64', ['void']]],
    'ReleaseFileForNtCreateSection' : [ 0x60, ['pointer64', ['void']]],
    'FastIoDetachDevice' : [ 0x68, ['pointer64', ['void']]],
    'FastIoQueryNetworkOpenInfo' : [ 0x70, ['pointer64', ['void']]],
    'AcquireForModWrite' : [ 0x78, ['pointer64', ['void']]],
    'MdlRead' : [ 0x80, ['pointer64', ['void']]],
    'MdlReadComplete' : [ 0x88, ['pointer64', ['void']]],
    'PrepareMdlWrite' : [ 0x90, ['pointer64', ['void']]],
    'MdlWriteComplete' : [ 0x98, ['pointer64', ['void']]],
    'FastIoReadCompressed' : [ 0xa0, ['pointer64', ['void']]],
    'FastIoWriteCompressed' : [ 0xa8, ['pointer64', ['void']]],
    'MdlReadCompleteCompressed' : [ 0xb0, ['pointer64', ['void']]],
    'MdlWriteCompleteCompressed' : [ 0xb8, ['pointer64', ['void']]],
    'FastIoQueryOpen' : [ 0xc0, ['pointer64', ['void']]],
    'ReleaseForModWrite' : [ 0xc8, ['pointer64', ['void']]],
    'AcquireForCcFlush' : [ 0xd0, ['pointer64', ['void']]],
    'ReleaseForCcFlush' : [ 0xd8, ['pointer64', ['void']]],
} ],
  '_WHEA_AER_ROOTPORT_DESCRIPTOR' : [ 0x24, {
    'Type' : [ 0x0, ['unsigned short']],
    'Enabled' : [ 0x2, ['unsigned char']],
    'Reserved' : [ 0x3, ['unsigned char']],
    'BusNumber' : [ 0x4, ['unsigned long']],
    'Slot' : [ 0x8, ['_WHEA_PCI_SLOT_NUMBER']],
    'DeviceControl' : [ 0xc, ['unsigned short']],
    'Flags' : [ 0xe, ['_AER_ROOTPORT_DESCRIPTOR_FLAGS']],
    'UncorrectableErrorMask' : [ 0x10, ['unsigned long']],
    'UncorrectableErrorSeverity' : [ 0x14, ['unsigned long']],
    'CorrectableErrorMask' : [ 0x18, ['unsigned long']],
    'AdvancedCapsAndControl' : [ 0x1c, ['unsigned long']],
    'RootErrorCommand' : [ 0x20, ['unsigned long']],
} ],
  '_KGATE' : [ 0x18, {
    'Header' : [ 0x0, ['_DISPATCHER_HEADER']],
} ],
  '_flags' : [ 0x1, {
    'Removable' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'GroupAssigned' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'GroupCommitted' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'GroupAssignmentFixed' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'Fill' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 8, native_type='unsigned char')]],
} ],
  '_AMD64_DBGKD_CONTROL_SET' : [ 0x1c, {
    'TraceFlag' : [ 0x0, ['unsigned long']],
    'Dr7' : [ 0x4, ['unsigned long long']],
    'CurrentSymbolStart' : [ 0xc, ['unsigned long long']],
    'CurrentSymbolEnd' : [ 0x14, ['unsigned long long']],
} ],
  '_PS_IO_CONTROL_ENTRY' : [ 0x38, {
    'VolumeTreeNode' : [ 0x0, ['_RTL_BALANCED_NODE']],
    'FreeListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'ReservedForParentValue' : [ 0x10, ['unsigned long long']],
    'VolumeKey' : [ 0x18, ['unsigned long long']],
    'Rundown' : [ 0x20, ['_EX_RUNDOWN_REF']],
    'IoControl' : [ 0x28, ['pointer64', ['void']]],
    'VolumeIoAttribution' : [ 0x30, ['pointer64', ['void']]],
} ],
  '_KSYSTEM_TIME' : [ 0xc, {
    'LowPart' : [ 0x0, ['unsigned long']],
    'High1Time' : [ 0x4, ['long']],
    'High2Time' : [ 0x8, ['long']],
} ],
  '_CM_UOW_SET_VALUE_LIST_DATA' : [ 0xc, {
    'RefCount' : [ 0x0, ['unsigned long']],
    'ValueList' : [ 0x4, ['_CHILD_LIST']],
} ],
  '_IO_COMPLETION_CONTEXT' : [ 0x10, {
    'Port' : [ 0x0, ['pointer64', ['void']]],
    'Key' : [ 0x8, ['pointer64', ['void']]],
} ],
  '_VF_TRACKER_STAMP' : [ 0x10, {
    'Thread' : [ 0x0, ['pointer64', ['void']]],
    'Flags' : [ 0x8, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned char')]],
    'OldIrql' : [ 0x9, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned char')]],
    'NewIrql' : [ 0xa, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned char')]],
    'Processor' : [ 0xb, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned char')]],
} ],
  '_POOL_DESCRIPTOR' : [ 0x1140, {
    'PoolType' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: u'NonPagedPoolBase', 1: u'PagedPool', 2: u'NonPagedPoolBaseMustSucceed', 3: u'DontUseThisType', 4: u'NonPagedPoolBaseCacheAligned', 5: u'PagedPoolCacheAligned', 6: u'NonPagedPoolBaseCacheAlignedMustS', 7: u'MaxPoolType', 34: u'NonPagedPoolMustSucceedSession', 516: u'NonPagedPoolNxCacheAligned', 35: u'DontUseThisTypeSession', 32: u'NonPagedPoolSession', 512: u'NonPagedPoolNx', 544: u'NonPagedPoolSessionNx', 36: u'NonPagedPoolCacheAlignedSession', 33: u'PagedPoolSession', 38: u'NonPagedPoolCacheAlignedMustSSession', 37: u'PagedPoolCacheAlignedSession'})]],
    'PagedLock' : [ 0x8, ['_FAST_MUTEX']],
    'NonPagedLock' : [ 0x8, ['unsigned long long']],
    'RunningAllocs' : [ 0x40, ['long']],
    'PagesAllocated' : [ 0x48, ['unsigned long long']],
    'BigPagesAllocated' : [ 0x50, ['unsigned long long']],
    'BytesAllocated' : [ 0x58, ['unsigned long long']],
    'RunningDeallocs' : [ 0x80, ['long']],
    'PagesDeallocated' : [ 0x88, ['unsigned long long']],
    'BigPagesDeallocated' : [ 0x90, ['unsigned long long']],
    'BytesDeallocated' : [ 0x98, ['unsigned long long']],
    'PoolIndex' : [ 0xc0, ['unsigned long']],
    'PoolTypeCopy' : [ 0xc4, ['Enumeration', dict(target = 'long', choices = {0: u'NonPagedPoolBase', 1: u'PagedPool', 2: u'NonPagedPoolBaseMustSucceed', 3: u'DontUseThisType', 4: u'NonPagedPoolBaseCacheAligned', 5: u'PagedPoolCacheAligned', 6: u'NonPagedPoolBaseCacheAlignedMustS', 7: u'MaxPoolType', 34: u'NonPagedPoolMustSucceedSession', 516: u'NonPagedPoolNxCacheAligned', 35: u'DontUseThisTypeSession', 32: u'NonPagedPoolSession', 512: u'NonPagedPoolNx', 544: u'NonPagedPoolSessionNx', 36: u'NonPagedPoolCacheAlignedSession', 33: u'PagedPoolSession', 38: u'NonPagedPoolCacheAlignedMustSSession', 37: u'PagedPoolCacheAlignedSession'})]],
    'PendingFrees' : [ 0x100, ['_SINGLE_LIST_ENTRY']],
    'ThreadsProcessingDeferrals' : [ 0x108, ['long']],
    'PendingFreeDepth' : [ 0x10c, ['long']],
    'ListHeads' : [ 0x140, ['array', 256, ['_LIST_ENTRY']]],
} ],
  '_VI_DEADLOCK_THREAD' : [ 0x38, {
    'Thread' : [ 0x0, ['pointer64', ['_KTHREAD']]],
    'CurrentSpinNode' : [ 0x8, ['pointer64', ['_VI_DEADLOCK_NODE']]],
    'CurrentOtherNode' : [ 0x10, ['pointer64', ['_VI_DEADLOCK_NODE']]],
    'ListEntry' : [ 0x18, ['_LIST_ENTRY']],
    'FreeListEntry' : [ 0x18, ['_LIST_ENTRY']],
    'NodeCount' : [ 0x28, ['unsigned long']],
    'PagingCount' : [ 0x2c, ['unsigned long']],
    'ThreadUsesEresources' : [ 0x30, ['unsigned char']],
} ],
  '_ARBITER_RETEST_ALLOCATION_PARAMETERS' : [ 0x18, {
    'ArbitrationList' : [ 0x0, ['pointer64', ['_LIST_ENTRY']]],
    'AllocateFromCount' : [ 0x8, ['unsigned long']],
    'AllocateFrom' : [ 0x10, ['pointer64', ['_CM_PARTIAL_RESOURCE_DESCRIPTOR']]],
} ],
  '_KPRCBFLAG' : [ 0x4, {
    'PrcbFlags' : [ 0x0, ['long']],
    'BamQosLevel' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 2, native_type='unsigned long')]],
    'PendingQosUpdate' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 4, native_type='unsigned long')]],
    'CacheIsolationEnabled' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'PrcbFlagsReserved' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 32, native_type='unsigned long')]],
} ],
  '_MI_SUBSECTION_ENTRY1' : [ 0x4, {
    'CrossPartitionReferences' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 30, native_type='unsigned long')]],
    'SubsectionMappedLarge' : [ 0x0, ['BitField', dict(start_bit = 30, end_bit = 32, native_type='unsigned long')]],
} ],
  '__unnamed_25c2' : [ 0x4, {
    'PercentLevel' : [ 0x0, ['unsigned long']],
} ],
  '__unnamed_25c4' : [ 0x4, {
    'Type' : [ 0x0, ['unsigned long']],
} ],
  '_POP_ACTION_TRIGGER' : [ 0x18, {
    'Type' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: u'PolicyDeviceSystemButton', 1: u'PolicyDeviceThermalZone', 2: u'PolicyDeviceBattery', 3: u'PolicyDeviceMemory', 4: u'PolicyInitiatePowerActionAPI', 5: u'PolicySetPowerStateAPI', 6: u'PolicyImmediateDozeS4', 7: u'PolicySystemIdle', 8: u'PolicyDeviceWakeAlarm', 9: u'PolicyDeviceFan', 10: u'PolicyCsBatterySaver', 11: u'PolicyImmediateDozeS4Predicted', 12: u'PolicyImmediateDozeS4PredictedNoWake', 13: u'PolicyImmediateDozeS4AdaptiveBudget', 14: u'PolicyImmediateDozeS4AdaptiveReserveNoWake', 15: u'PolicySystemInitiatedShutdown', 16: u'PolicyDeviceMax'})]],
    'Flags' : [ 0x4, ['unsigned long']],
    'Wait' : [ 0x8, ['pointer64', ['_POP_TRIGGER_WAIT']]],
    'Battery' : [ 0x10, ['__unnamed_25c2']],
    'Button' : [ 0x10, ['__unnamed_25c4']],
} ],
  '_RTL_ATOM_TABLE' : [ 0x28, {
    'Signature' : [ 0x0, ['unsigned long']],
    'ReferenceCount' : [ 0x4, ['long']],
    'PushLock' : [ 0x8, ['_EX_PUSH_LOCK']],
    'ExHandleTable' : [ 0x10, ['pointer64', ['_HANDLE_TABLE']]],
    'Flags' : [ 0x18, ['unsigned long']],
    'NumberOfBuckets' : [ 0x1c, ['unsigned long']],
    'Buckets' : [ 0x20, ['array', 1, ['pointer64', ['_RTL_ATOM_TABLE_ENTRY']]]],
} ],
  '_POWER_STATE' : [ 0x4, {
    'SystemState' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: u'PowerSystemUnspecified', 1: u'PowerSystemWorking', 2: u'PowerSystemSleeping1', 3: u'PowerSystemSleeping2', 4: u'PowerSystemSleeping3', 5: u'PowerSystemHibernate', 6: u'PowerSystemShutdown', 7: u'PowerSystemMaximum'})]],
    'DeviceState' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: u'PowerDeviceUnspecified', 1: u'PowerDeviceD0', 2: u'PowerDeviceD1', 3: u'PowerDeviceD2', 4: u'PowerDeviceD3', 5: u'PowerDeviceMaximum'})]],
} ],
  '_KTIMER2' : [ 0x88, {
    'Header' : [ 0x0, ['_DISPATCHER_HEADER']],
    'RbNodes' : [ 0x18, ['array', 2, ['_RTL_BALANCED_NODE']]],
    'ListEntry' : [ 0x18, ['_LIST_ENTRY']],
    'DueTime' : [ 0x48, ['array', 2, ['unsigned long long']]],
    'Period' : [ 0x58, ['long long']],
    'Callback' : [ 0x60, ['pointer64', ['void']]],
    'CallbackContext' : [ 0x68, ['pointer64', ['void']]],
    'DisableCallback' : [ 0x70, ['pointer64', ['void']]],
    'DisableContext' : [ 0x78, ['pointer64', ['void']]],
    'AbsoluteSystemTime' : [ 0x80, ['unsigned char']],
    'TypeFlags' : [ 0x81, ['unsigned char']],
    'Unused' : [ 0x81, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'IdleResilient' : [ 0x81, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'HighResolution' : [ 0x81, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'NoWake' : [ 0x81, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'Unused1' : [ 0x81, ['BitField', dict(start_bit = 4, end_bit = 8, native_type='unsigned char')]],
    'CollectionIndex' : [ 0x82, ['array', 2, ['unsigned char']]],
} ],
  '_ALPC_PROCESS_CONTEXT' : [ 0x20, {
    'Lock' : [ 0x0, ['_EX_PUSH_LOCK']],
    'ViewListHead' : [ 0x8, ['_LIST_ENTRY']],
    'PagedPoolQuotaCache' : [ 0x18, ['unsigned long long']],
} ],
  '_MI_SESSION_STATE' : [ 0x88, {
    'SystemSession' : [ 0x0, ['_MMSESSION']],
    'DetachTimeStamp' : [ 0x20, ['unsigned long']],
    'CodePageEdited' : [ 0x24, ['unsigned char']],
    'DynamicPoolBitBuffer' : [ 0x28, ['pointer64', ['unsigned long']]],
    'DynamicVaBitBuffer' : [ 0x30, ['pointer64', ['unsigned long long']]],
    'DynamicVaBitBufferPages' : [ 0x38, ['unsigned long long']],
    'DynamicVaStart' : [ 0x40, ['pointer64', ['void']]],
    'ImageVaStart' : [ 0x48, ['pointer64', ['void']]],
    'DynamicPtesBitBuffer' : [ 0x50, ['pointer64', ['unsigned long']]],
    'IdLock' : [ 0x58, ['_EX_PUSH_LOCK']],
    'LeaderProcess' : [ 0x60, ['pointer64', ['_EPROCESS']]],
    'InitializeLock' : [ 0x68, ['_EX_PUSH_LOCK']],
    'WorkingSetList' : [ 0x70, ['pointer64', ['_MMWSL_INSTANCE']]],
    'SessionBase' : [ 0x78, ['pointer64', ['void']]],
    'SessionCore' : [ 0x80, ['pointer64', ['void']]],
} ],
  '_XSTATE_CONFIGURATION' : [ 0x330, {
    'EnabledFeatures' : [ 0x0, ['unsigned long long']],
    'EnabledVolatileFeatures' : [ 0x8, ['unsigned long long']],
    'Size' : [ 0x10, ['unsigned long']],
    'ControlFlags' : [ 0x14, ['unsigned long']],
    'OptimizedSave' : [ 0x14, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'CompactionEnabled' : [ 0x14, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'Features' : [ 0x18, ['array', 64, ['_XSTATE_FEATURE']]],
    'EnabledSupervisorFeatures' : [ 0x218, ['unsigned long long']],
    'AlignedFeatures' : [ 0x220, ['unsigned long long']],
    'AllFeatureSize' : [ 0x228, ['unsigned long']],
    'AllFeatures' : [ 0x22c, ['array', 64, ['unsigned long']]],
} ],
  '_OBJECT_SYMBOLIC_LINK' : [ 0x28, {
    'CreationTime' : [ 0x0, ['_LARGE_INTEGER']],
    'LinkTarget' : [ 0x8, ['_UNICODE_STRING']],
    'Callback' : [ 0x8, ['pointer64', ['void']]],
    'CallbackContext' : [ 0x10, ['pointer64', ['void']]],
    'DosDeviceDriveIndex' : [ 0x18, ['unsigned long']],
    'Flags' : [ 0x1c, ['unsigned long']],
    'AccessMask' : [ 0x20, ['unsigned long']],
} ],
  '_MI_SECTION_STATE' : [ 0x280, {
    'SectionObjectPointersLock' : [ 0x0, ['long']],
    'SectionBasedRoot' : [ 0x8, ['_RTL_AVL_TREE']],
    'SectionBasedLock' : [ 0x10, ['_EX_PUSH_LOCK']],
    'UnusedSegmentPagedPool' : [ 0x18, ['unsigned long long']],
    'DataSectionProtectionMask' : [ 0x20, ['unsigned long']],
    'HighSectionBase' : [ 0x28, ['pointer64', ['void']]],
    'PhysicalSubsection' : [ 0x30, ['_MSUBSECTION']],
    'PhysicalControlArea' : [ 0xc0, ['_CONTROL_AREA']],
    'PurgingExtentPages' : [ 0x140, ['_MMPFNLIST']],
    'DanglingExtentPages' : [ 0x168, ['pointer64', ['_MMPFN']]],
    'DanglingExtentsWorkItem' : [ 0x170, ['_WORK_QUEUE_ITEM']],
    'DanglingExtentsWorkerActive' : [ 0x190, ['unsigned char']],
    'PurgingExtentsNeedWatchdog' : [ 0x191, ['unsigned char']],
    'PrototypePtesTree' : [ 0x198, ['_RTL_AVL_TREE']],
    'PrototypePtesTreeSpinLock' : [ 0x1a0, ['long']],
    'ImageBias' : [ 0x1a4, ['unsigned long']],
    'RelocateBitmapsLock' : [ 0x1a8, ['_EX_PUSH_LOCK']],
    'ImageBitMap' : [ 0x1b0, ['_RTL_BITMAP']],
    'ImageBias64Low' : [ 0x1c0, ['unsigned long']],
    'ImageBias64High' : [ 0x1c4, ['unsigned long']],
    'ImageBitMap64Low' : [ 0x1c8, ['_RTL_BITMAP']],
    'ImageBitMap64High' : [ 0x1d8, ['_RTL_BITMAP']],
    'ImageBitMapWow64Dll' : [ 0x1e8, ['_RTL_BITMAP']],
    'ApiSetSection' : [ 0x1f8, ['pointer64', ['void']]],
    'ApiSetSchema' : [ 0x200, ['pointer64', ['void']]],
    'ApiSetSchemaSize' : [ 0x208, ['unsigned long long']],
    'LostDataFiles' : [ 0x210, ['unsigned long']],
    'LostDataPages' : [ 0x214, ['unsigned long']],
    'ImageFailureReason' : [ 0x218, ['unsigned long']],
    'CfgBitMapSection32' : [ 0x220, ['pointer64', ['_SECTION']]],
    'CfgBitMapControlArea32' : [ 0x228, ['pointer64', ['_CONTROL_AREA']]],
    'CfgBitMapSection64' : [ 0x230, ['pointer64', ['_SECTION']]],
    'CfgBitMapControlArea64' : [ 0x238, ['pointer64', ['_CONTROL_AREA']]],
    'KernelCfgBitMap' : [ 0x240, ['_RTL_BITMAP_EX']],
    'KernelCfgBitMapLock' : [ 0x250, ['_EX_PUSH_LOCK']],
    'ImageCfgFailure' : [ 0x258, ['unsigned long']],
    'ImageChecksumBreakpoint' : [ 0x25c, ['unsigned long']],
    'ImageSizeBreakpoint' : [ 0x260, ['unsigned long']],
    'ImageValidationFailed' : [ 0x264, ['long']],
} ],
  '_AER_ROOTPORT_DESCRIPTOR_FLAGS' : [ 0x2, {
    'UncorrectableErrorMaskRW' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
    'UncorrectableErrorSeverityRW' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned short')]],
    'CorrectableErrorMaskRW' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned short')]],
    'AdvancedCapsAndControlRW' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned short')]],
    'RootErrorCommandRW' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned short')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 16, native_type='unsigned short')]],
    'AsUSHORT' : [ 0x0, ['unsigned short']],
} ],
  '_RTL_ATOM_TABLE_ENTRY' : [ 0x30, {
    'HashLink' : [ 0x0, ['pointer64', ['_RTL_ATOM_TABLE_ENTRY']]],
    'HandleIndex' : [ 0x8, ['unsigned short']],
    'Atom' : [ 0xa, ['unsigned short']],
    'Reference' : [ 0x10, ['_RTL_ATOM_TABLE_REFERENCE']],
    'NameLength' : [ 0x28, ['unsigned char']],
    'Name' : [ 0x2a, ['array', 1, ['wchar']]],
} ],
  '_WHEAP_ERROR_RECORD_WRAPPER_FLAGS' : [ 0x4, {
    'Preallocated' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'FromPersistentStore' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'PlatformPfaControl' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'PlatformDirectedOffline' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 32, native_type='unsigned long')]],
    'AsULONG' : [ 0x0, ['unsigned long']],
} ],
  '_CM_UOW_KEY_STATE_MODIFICATION' : [ 0x14, {
    'RefCount' : [ 0x0, ['unsigned long']],
    'SubKeyListCount' : [ 0x4, ['array', 2, ['unsigned long']]],
    'NewSubKeyList' : [ 0xc, ['array', 2, ['unsigned long']]],
} ],
  '_MI_CONTROL_AREA_WAIT_BLOCK' : [ 0x28, {
    'Next' : [ 0x0, ['pointer64', ['_MI_CONTROL_AREA_WAIT_BLOCK']]],
    'WaitReason' : [ 0x8, ['unsigned long']],
    'WaitResponse' : [ 0xc, ['unsigned long']],
    'Gate' : [ 0x10, ['_KGATE']],
} ],
  '_RTL_CRITICAL_SECTION' : [ 0x28, {
    'DebugInfo' : [ 0x0, ['pointer64', ['_RTL_CRITICAL_SECTION_DEBUG']]],
    'LockCount' : [ 0x8, ['long']],
    'RecursionCount' : [ 0xc, ['long']],
    'OwningThread' : [ 0x10, ['pointer64', ['void']]],
    'LockSemaphore' : [ 0x18, ['pointer64', ['void']]],
    'SpinCount' : [ 0x20, ['unsigned long long']],
} ],
  '_PI_RESOURCE_ARBITER_ENTRY' : [ 0x70, {
    'DeviceArbiterList' : [ 0x0, ['_LIST_ENTRY']],
    'ResourceType' : [ 0x10, ['unsigned char']],
    'ArbiterInterface' : [ 0x18, ['pointer64', ['_ARBITER_INTERFACE']]],
    'DeviceNode' : [ 0x20, ['pointer64', ['_DEVICE_NODE']]],
    'ResourceList' : [ 0x28, ['_LIST_ENTRY']],
    'BestResourceList' : [ 0x38, ['_LIST_ENTRY']],
    'BestConfig' : [ 0x48, ['_LIST_ENTRY']],
    'ActiveArbiterList' : [ 0x58, ['_LIST_ENTRY']],
    'State' : [ 0x68, ['unsigned char']],
    'ResourcesChanged' : [ 0x69, ['unsigned char']],
} ],
  '_ETW_FILTER_HEADER' : [ 0x60, {
    'FilterFlags' : [ 0x0, ['long']],
    'PidFilter' : [ 0x8, ['pointer64', ['_ETW_FILTER_PID']]],
    'ExeFilter' : [ 0x10, ['pointer64', ['_ETW_FILTER_STRING_TOKEN']]],
    'PkgIdFilter' : [ 0x18, ['pointer64', ['_ETW_FILTER_STRING_TOKEN']]],
    'PkgAppIdFilter' : [ 0x20, ['pointer64', ['_ETW_FILTER_STRING_TOKEN']]],
    'StackWalkIdFilter' : [ 0x28, ['pointer64', ['_ETW_PERFECT_HASH_FUNCTION']]],
    'StackWalkNameFilter' : [ 0x30, ['pointer64', ['_ETW_FILTER_EVENT_NAME_DATA']]],
    'StackWalkLevelKwFilter' : [ 0x38, ['pointer64', ['_EVENT_FILTER_LEVEL_KW']]],
    'EventIdFilter' : [ 0x40, ['pointer64', ['_ETW_PERFECT_HASH_FUNCTION']]],
    'PayloadFilter' : [ 0x48, ['pointer64', ['_ETW_PAYLOAD_FILTER']]],
    'ProviderSideFilter' : [ 0x50, ['pointer64', ['_EVENT_FILTER_HEADER']]],
    'EventNameFilter' : [ 0x58, ['pointer64', ['_ETW_FILTER_EVENT_NAME_DATA']]],
} ],
  '_MMPTE_SOFTWARE' : [ 0x8, {
    'Valid' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'PageFileLow' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 5, native_type='unsigned long long')]],
    'Protection' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 10, native_type='unsigned long long')]],
    'Prototype' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long long')]],
    'Transition' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long long')]],
    'PageFileReserved' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long long')]],
    'PageFileAllocated' : [ 0x0, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long long')]],
    'UsedPageTableEntries' : [ 0x0, ['BitField', dict(start_bit = 14, end_bit = 24, native_type='unsigned long long')]],
    'ColdPage' : [ 0x0, ['BitField', dict(start_bit = 24, end_bit = 25, native_type='unsigned long long')]],
    'Unused' : [ 0x0, ['BitField', dict(start_bit = 25, end_bit = 32, native_type='unsigned long long')]],
    'PageFileHigh' : [ 0x0, ['BitField', dict(start_bit = 32, end_bit = 64, native_type='unsigned long long')]],
} ],
  '_MM_DRIVER_VERIFIER_DATA' : [ 0xa8, {
    'Level' : [ 0x0, ['unsigned long']],
    'RaiseIrqls' : [ 0x4, ['unsigned long']],
    'AcquireSpinLocks' : [ 0x8, ['unsigned long']],
    'SynchronizeExecutions' : [ 0xc, ['unsigned long']],
    'AllocationsAttempted' : [ 0x10, ['unsigned long']],
    'AllocationsSucceeded' : [ 0x14, ['unsigned long']],
    'AllocationsSucceededSpecialPool' : [ 0x18, ['unsigned long']],
    'AllocationsWithNoTag' : [ 0x1c, ['unsigned long']],
    'TrimRequests' : [ 0x20, ['unsigned long']],
    'Trims' : [ 0x24, ['unsigned long']],
    'AllocationsFailed' : [ 0x28, ['unsigned long']],
    'AllocationsFailedDeliberately' : [ 0x2c, ['unsigned long']],
    'Loads' : [ 0x30, ['unsigned long']],
    'Unloads' : [ 0x34, ['unsigned long']],
    'UnTrackedPool' : [ 0x38, ['unsigned long']],
    'UserTrims' : [ 0x3c, ['unsigned long']],
    'CurrentPagedPoolAllocations' : [ 0x40, ['unsigned long']],
    'CurrentNonPagedPoolAllocations' : [ 0x44, ['unsigned long']],
    'PeakPagedPoolAllocations' : [ 0x48, ['unsigned long']],
    'PeakNonPagedPoolAllocations' : [ 0x4c, ['unsigned long']],
    'PagedBytes' : [ 0x50, ['unsigned long long']],
    'NonPagedBytes' : [ 0x58, ['unsigned long long']],
    'PeakPagedBytes' : [ 0x60, ['unsigned long long']],
    'PeakNonPagedBytes' : [ 0x68, ['unsigned long long']],
    'BurstAllocationsFailedDeliberately' : [ 0x70, ['unsigned long']],
    'SessionTrims' : [ 0x74, ['unsigned long']],
    'OptionChanges' : [ 0x78, ['unsigned long']],
    'VerifyMode' : [ 0x7c, ['unsigned long']],
    'PreviousBucketName' : [ 0x80, ['_UNICODE_STRING']],
    'ExecutePoolTypes' : [ 0x90, ['unsigned long']],
    'ExecutePageProtections' : [ 0x94, ['unsigned long']],
    'ExecutePageMappings' : [ 0x98, ['unsigned long']],
    'ExecuteWriteSections' : [ 0x9c, ['unsigned long']],
    'SectionAlignmentFailures' : [ 0xa0, ['unsigned long']],
    'IATInExecutableSection' : [ 0xa4, ['unsigned long']],
} ],
  '_SID_IDENTIFIER_AUTHORITY' : [ 0x6, {
    'Value' : [ 0x0, ['array', 6, ['unsigned char']]],
} ],
  '_PEB' : [ 0x7b8, {
    'InheritedAddressSpace' : [ 0x0, ['unsigned char']],
    'ReadImageFileExecOptions' : [ 0x1, ['unsigned char']],
    'BeingDebugged' : [ 0x2, ['unsigned char']],
    'BitField' : [ 0x3, ['unsigned char']],
    'ImageUsesLargePages' : [ 0x3, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'IsProtectedProcess' : [ 0x3, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'IsImageDynamicallyRelocated' : [ 0x3, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'SkipPatchingUser32Forwarders' : [ 0x3, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'IsPackagedProcess' : [ 0x3, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'IsAppContainer' : [ 0x3, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'IsProtectedProcessLight' : [ 0x3, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned char')]],
    'IsLongPathAwareProcess' : [ 0x3, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
    'Padding0' : [ 0x4, ['array', 4, ['unsigned char']]],
    'Mutant' : [ 0x8, ['pointer64', ['void']]],
    'ImageBaseAddress' : [ 0x10, ['pointer64', ['void']]],
    'Ldr' : [ 0x18, ['pointer64', ['_PEB_LDR_DATA']]],
    'ProcessParameters' : [ 0x20, ['pointer64', ['_RTL_USER_PROCESS_PARAMETERS']]],
    'SubSystemData' : [ 0x28, ['pointer64', ['void']]],
    'ProcessHeap' : [ 0x30, ['pointer64', ['void']]],
    'FastPebLock' : [ 0x38, ['pointer64', ['_RTL_CRITICAL_SECTION']]],
    'AtlThunkSListPtr' : [ 0x40, ['pointer64', ['_SLIST_HEADER']]],
    'IFEOKey' : [ 0x48, ['pointer64', ['void']]],
    'CrossProcessFlags' : [ 0x50, ['unsigned long']],
    'ProcessInJob' : [ 0x50, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'ProcessInitializing' : [ 0x50, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'ProcessUsingVEH' : [ 0x50, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'ProcessUsingVCH' : [ 0x50, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'ProcessUsingFTH' : [ 0x50, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'ProcessPreviouslyThrottled' : [ 0x50, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'ProcessCurrentlyThrottled' : [ 0x50, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'ReservedBits0' : [ 0x50, ['BitField', dict(start_bit = 7, end_bit = 32, native_type='unsigned long')]],
    'Padding1' : [ 0x54, ['array', 4, ['unsigned char']]],
    'KernelCallbackTable' : [ 0x58, ['pointer64', ['void']]],
    'UserSharedInfoPtr' : [ 0x58, ['pointer64', ['void']]],
    'SystemReserved' : [ 0x60, ['unsigned long']],
    'AtlThunkSListPtr32' : [ 0x64, ['unsigned long']],
    'ApiSetMap' : [ 0x68, ['pointer64', ['void']]],
    'TlsExpansionCounter' : [ 0x70, ['unsigned long']],
    'Padding2' : [ 0x74, ['array', 4, ['unsigned char']]],
    'TlsBitmap' : [ 0x78, ['pointer64', ['void']]],
    'TlsBitmapBits' : [ 0x80, ['array', 2, ['unsigned long']]],
    'ReadOnlySharedMemoryBase' : [ 0x88, ['pointer64', ['void']]],
    'SharedData' : [ 0x90, ['pointer64', ['void']]],
    'ReadOnlyStaticServerData' : [ 0x98, ['pointer64', ['pointer64', ['void']]]],
    'AnsiCodePageData' : [ 0xa0, ['pointer64', ['void']]],
    'OemCodePageData' : [ 0xa8, ['pointer64', ['void']]],
    'UnicodeCaseTableData' : [ 0xb0, ['pointer64', ['void']]],
    'NumberOfProcessors' : [ 0xb8, ['unsigned long']],
    'NtGlobalFlag' : [ 0xbc, ['unsigned long']],
    'CriticalSectionTimeout' : [ 0xc0, ['_LARGE_INTEGER']],
    'HeapSegmentReserve' : [ 0xc8, ['unsigned long long']],
    'HeapSegmentCommit' : [ 0xd0, ['unsigned long long']],
    'HeapDeCommitTotalFreeThreshold' : [ 0xd8, ['unsigned long long']],
    'HeapDeCommitFreeBlockThreshold' : [ 0xe0, ['unsigned long long']],
    'NumberOfHeaps' : [ 0xe8, ['unsigned long']],
    'MaximumNumberOfHeaps' : [ 0xec, ['unsigned long']],
    'ProcessHeaps' : [ 0xf0, ['pointer64', ['pointer64', ['void']]]],
    'GdiSharedHandleTable' : [ 0xf8, ['pointer64', ['void']]],
    'ProcessStarterHelper' : [ 0x100, ['pointer64', ['void']]],
    'GdiDCAttributeList' : [ 0x108, ['unsigned long']],
    'Padding3' : [ 0x10c, ['array', 4, ['unsigned char']]],
    'LoaderLock' : [ 0x110, ['pointer64', ['_RTL_CRITICAL_SECTION']]],
    'OSMajorVersion' : [ 0x118, ['unsigned long']],
    'OSMinorVersion' : [ 0x11c, ['unsigned long']],
    'OSBuildNumber' : [ 0x120, ['unsigned short']],
    'OSCSDVersion' : [ 0x122, ['unsigned short']],
    'OSPlatformId' : [ 0x124, ['unsigned long']],
    'ImageSubsystem' : [ 0x128, ['unsigned long']],
    'ImageSubsystemMajorVersion' : [ 0x12c, ['unsigned long']],
    'ImageSubsystemMinorVersion' : [ 0x130, ['unsigned long']],
    'Padding4' : [ 0x134, ['array', 4, ['unsigned char']]],
    'ActiveProcessAffinityMask' : [ 0x138, ['unsigned long long']],
    'GdiHandleBuffer' : [ 0x140, ['array', 60, ['unsigned long']]],
    'PostProcessInitRoutine' : [ 0x230, ['pointer64', ['void']]],
    'TlsExpansionBitmap' : [ 0x238, ['pointer64', ['void']]],
    'TlsExpansionBitmapBits' : [ 0x240, ['array', 32, ['unsigned long']]],
    'SessionId' : [ 0x2c0, ['unsigned long']],
    'Padding5' : [ 0x2c4, ['array', 4, ['unsigned char']]],
    'AppCompatFlags' : [ 0x2c8, ['_ULARGE_INTEGER']],
    'AppCompatFlagsUser' : [ 0x2d0, ['_ULARGE_INTEGER']],
    'pShimData' : [ 0x2d8, ['pointer64', ['void']]],
    'AppCompatInfo' : [ 0x2e0, ['pointer64', ['void']]],
    'CSDVersion' : [ 0x2e8, ['_UNICODE_STRING']],
    'ActivationContextData' : [ 0x2f8, ['pointer64', ['_ACTIVATION_CONTEXT_DATA']]],
    'ProcessAssemblyStorageMap' : [ 0x300, ['pointer64', ['_ASSEMBLY_STORAGE_MAP']]],
    'SystemDefaultActivationContextData' : [ 0x308, ['pointer64', ['_ACTIVATION_CONTEXT_DATA']]],
    'SystemAssemblyStorageMap' : [ 0x310, ['pointer64', ['_ASSEMBLY_STORAGE_MAP']]],
    'MinimumStackCommit' : [ 0x318, ['unsigned long long']],
    'FlsCallback' : [ 0x320, ['pointer64', ['_FLS_CALLBACK_INFO']]],
    'FlsListHead' : [ 0x328, ['_LIST_ENTRY']],
    'FlsBitmap' : [ 0x338, ['pointer64', ['void']]],
    'FlsBitmapBits' : [ 0x340, ['array', 4, ['unsigned long']]],
    'FlsHighIndex' : [ 0x350, ['unsigned long']],
    'WerRegistrationData' : [ 0x358, ['pointer64', ['void']]],
    'WerShipAssertPtr' : [ 0x360, ['pointer64', ['void']]],
    'pUnused' : [ 0x368, ['pointer64', ['void']]],
    'pImageHeaderHash' : [ 0x370, ['pointer64', ['void']]],
    'TracingFlags' : [ 0x378, ['unsigned long']],
    'HeapTracingEnabled' : [ 0x378, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'CritSecTracingEnabled' : [ 0x378, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'LibLoaderTracingEnabled' : [ 0x378, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'SpareTracingBits' : [ 0x378, ['BitField', dict(start_bit = 3, end_bit = 32, native_type='unsigned long')]],
    'Padding6' : [ 0x37c, ['array', 4, ['unsigned char']]],
    'CsrServerReadOnlySharedMemoryBase' : [ 0x380, ['unsigned long long']],
    'TppWorkerpListLock' : [ 0x388, ['unsigned long long']],
    'TppWorkerpList' : [ 0x390, ['_LIST_ENTRY']],
    'WaitOnAddressHashTable' : [ 0x3a0, ['array', 128, ['pointer64', ['void']]]],
    'TelemetryCoverageHeader' : [ 0x7a0, ['pointer64', ['void']]],
    'CloudFileFlags' : [ 0x7a8, ['unsigned long']],
    'CloudFileDiagFlags' : [ 0x7ac, ['unsigned long']],
    'PlaceholderCompatibilityMode' : [ 0x7b0, ['unsigned char']],
    'PlaceholderCompatibilityModeReserved' : [ 0x7b1, ['array', 7, ['unsigned char']]],
} ],
  '_VF_SUSPECT_DRIVER_ENTRY' : [ 0x28, {
    'Links' : [ 0x0, ['_LIST_ENTRY']],
    'Loads' : [ 0x10, ['unsigned long']],
    'Unloads' : [ 0x14, ['unsigned long']],
    'BaseName' : [ 0x18, ['_UNICODE_STRING']],
} ],
  '_VI_VERIFIER_ISSUE' : [ 0x20, {
    'IssueType' : [ 0x0, ['unsigned long long']],
    'Address' : [ 0x8, ['pointer64', ['void']]],
    'Parameters' : [ 0x10, ['array', 2, ['unsigned long long']]],
} ],
  '_KDEVICE_QUEUE' : [ 0x28, {
    'Type' : [ 0x0, ['short']],
    'Size' : [ 0x2, ['short']],
    'DeviceListHead' : [ 0x8, ['_LIST_ENTRY']],
    'Lock' : [ 0x18, ['unsigned long long']],
    'Busy' : [ 0x20, ['unsigned char']],
    'Reserved' : [ 0x20, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='long long')]],
    'Hint' : [ 0x20, ['BitField', dict(start_bit = 8, end_bit = 64, native_type='long long')]],
} ],
  '__unnamed_2643' : [ 0x4, {
    'BaseMiddle' : [ 0x0, ['unsigned char']],
    'Flags1' : [ 0x1, ['unsigned char']],
    'Flags2' : [ 0x2, ['unsigned char']],
    'BaseHigh' : [ 0x3, ['unsigned char']],
} ],
  '__unnamed_2647' : [ 0x4, {
    'BaseMiddle' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned long')]],
    'Type' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 13, native_type='unsigned long')]],
    'Dpl' : [ 0x0, ['BitField', dict(start_bit = 13, end_bit = 15, native_type='unsigned long')]],
    'Present' : [ 0x0, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'LimitHigh' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 20, native_type='unsigned long')]],
    'System' : [ 0x0, ['BitField', dict(start_bit = 20, end_bit = 21, native_type='unsigned long')]],
    'LongMode' : [ 0x0, ['BitField', dict(start_bit = 21, end_bit = 22, native_type='unsigned long')]],
    'DefaultBig' : [ 0x0, ['BitField', dict(start_bit = 22, end_bit = 23, native_type='unsigned long')]],
    'Granularity' : [ 0x0, ['BitField', dict(start_bit = 23, end_bit = 24, native_type='unsigned long')]],
    'BaseHigh' : [ 0x0, ['BitField', dict(start_bit = 24, end_bit = 32, native_type='unsigned long')]],
} ],
  '_KGDTENTRY64' : [ 0x10, {
    'LimitLow' : [ 0x0, ['unsigned short']],
    'BaseLow' : [ 0x2, ['unsigned short']],
    'Bytes' : [ 0x4, ['__unnamed_2643']],
    'Bits' : [ 0x4, ['__unnamed_2647']],
    'BaseUpper' : [ 0x8, ['unsigned long']],
    'MustBeZero' : [ 0xc, ['unsigned long']],
    'DataLow' : [ 0x0, ['long long']],
    'DataHigh' : [ 0x8, ['long long']],
} ],
  '_KSTACK_COUNT' : [ 0x4, {
    'Value' : [ 0x0, ['long']],
    'State' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 3, native_type='unsigned long')]],
    'StackCount' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 32, native_type='unsigned long')]],
} ],
  '_ARBITER_ALLOCATION_STATE' : [ 0x50, {
    'Start' : [ 0x0, ['unsigned long long']],
    'End' : [ 0x8, ['unsigned long long']],
    'CurrentMinimum' : [ 0x10, ['unsigned long long']],
    'CurrentMaximum' : [ 0x18, ['unsigned long long']],
    'Entry' : [ 0x20, ['pointer64', ['_ARBITER_LIST_ENTRY']]],
    'CurrentAlternative' : [ 0x28, ['pointer64', ['_ARBITER_ALTERNATIVE']]],
    'AlternativeCount' : [ 0x30, ['unsigned long']],
    'Alternatives' : [ 0x38, ['pointer64', ['_ARBITER_ALTERNATIVE']]],
    'Flags' : [ 0x40, ['unsigned short']],
    'RangeAttributes' : [ 0x42, ['unsigned char']],
    'RangeAvailableAttributes' : [ 0x43, ['unsigned char']],
    'WorkSpace' : [ 0x48, ['unsigned long long']],
} ],
  '_PHYSICAL_MEMORY_RUN' : [ 0x10, {
    'BasePage' : [ 0x0, ['unsigned long long']],
    'PageCount' : [ 0x8, ['unsigned long long']],
} ],
  '_ETW_SYSTEM_LOGGER_SETTINGS' : [ 0x174, {
    'EtwpSystemLogger' : [ 0x0, ['array', 8, ['_ETW_SYSTEM_LOGGER']]],
    'EtwpActiveSystemLoggers' : [ 0x10, ['unsigned long']],
    'SiloGlobalGroupMask' : [ 0x14, ['_PERFINFO_GROUPMASK']],
    'EtwpGroupMasks' : [ 0x34, ['array', 10, ['_PERFINFO_GROUPMASK']]],
} ],
  '_MI_SUB64K_FREE_RANGES' : [ 0x38, {
    'BitMap' : [ 0x0, ['_RTL_BITMAP_EX']],
    'ListEntry' : [ 0x10, ['_LIST_ENTRY']],
    'Vad' : [ 0x20, ['pointer64', ['_MMVAD_SHORT']]],
    'SetBits' : [ 0x28, ['unsigned long']],
    'FullSetBits' : [ 0x2c, ['unsigned long']],
    'SubListIndex' : [ 0x30, ['BitField', dict(start_bit = 0, end_bit = 2, native_type='unsigned long')]],
    'Hint' : [ 0x30, ['BitField', dict(start_bit = 2, end_bit = 32, native_type='unsigned long')]],
} ],
  '_WHEA_REVISION' : [ 0x2, {
    'MinorRevision' : [ 0x0, ['unsigned char']],
    'MajorRevision' : [ 0x1, ['unsigned char']],
    'AsUSHORT' : [ 0x0, ['unsigned short']],
} ],
  '__unnamed_2663' : [ 0x30, {
    'ApcState' : [ 0x0, ['_KAPC_STATE']],
    'HardFaultState' : [ 0x0, ['_MI_HARD_FAULT_STATE']],
} ],
  '__unnamed_2665' : [ 0x4, {
    'ImagePteOffset' : [ 0x0, ['unsigned long']],
    'TossPage' : [ 0x0, ['unsigned long']],
} ],
  '__unnamed_2668' : [ 0x4, {
    'e1' : [ 0x0, ['_MMINPAGE_FLAGS']],
    'LongFlags' : [ 0x0, ['unsigned long']],
} ],
  '_MMINPAGE_SUPPORT' : [ 0x1b8, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'ListHead' : [ 0x10, ['_LIST_ENTRY']],
    'Event' : [ 0x20, ['_KEVENT']],
    'CollidedEvent' : [ 0x38, ['_KEVENT']],
    'IoStatus' : [ 0x50, ['_IO_STATUS_BLOCK']],
    'ReadOffset' : [ 0x60, ['_LARGE_INTEGER']],
    'u2' : [ 0x68, ['__unnamed_2663']],
    'Thread' : [ 0x98, ['pointer64', ['_ETHREAD']]],
    'LockedProtoPfn' : [ 0xa0, ['pointer64', ['_MMPFN']]],
    'PteContents' : [ 0xa8, ['_MMPTE']],
    'WaitCount' : [ 0xb0, ['long']],
    'ByteCount' : [ 0xb4, ['unsigned long']],
    'u3' : [ 0xb8, ['__unnamed_2665']],
    'u1' : [ 0xbc, ['__unnamed_2668']],
    'FilePointer' : [ 0xc0, ['pointer64', ['_FILE_OBJECT']]],
    'ControlArea' : [ 0xc8, ['pointer64', ['_CONTROL_AREA']]],
    'Subsection' : [ 0xc8, ['pointer64', ['_SUBSECTION']]],
    'Autoboost' : [ 0xd0, ['pointer64', ['void']]],
    'FaultingAddress' : [ 0xd8, ['pointer64', ['void']]],
    'PointerPte' : [ 0xe0, ['pointer64', ['_MMPTE']]],
    'BasePte' : [ 0xe8, ['pointer64', ['_MMPTE']]],
    'Pfn' : [ 0xf0, ['pointer64', ['_MMPFN']]],
    'PrefetchMdl' : [ 0xf8, ['pointer64', ['_MDL']]],
    'ProbeCount' : [ 0x100, ['long long']],
    'Mdl' : [ 0x108, ['_MDL']],
    'Page' : [ 0x138, ['array', 16, ['unsigned long long']]],
    'FlowThrough' : [ 0x138, ['_MMINPAGE_SUPPORT_FLOW_THROUGH']],
} ],
  '_EVENT_FILTER_HEADER' : [ 0x18, {
    'Id' : [ 0x0, ['unsigned short']],
    'Version' : [ 0x2, ['unsigned char']],
    'Reserved' : [ 0x3, ['array', 5, ['unsigned char']]],
    'InstanceId' : [ 0x8, ['unsigned long long']],
    'Size' : [ 0x10, ['unsigned long']],
    'NextOffset' : [ 0x14, ['unsigned long']],
} ],
  '__unnamed_2672' : [ 0x8, {
    'Start' : [ 0x0, ['unsigned long']],
    'Length' : [ 0x4, ['unsigned long']],
} ],
  '__unnamed_2674' : [ 0x8, {
    'RangeCount' : [ 0x0, ['unsigned long']],
    'SetBitCount' : [ 0x4, ['unsigned long']],
} ],
  '__unnamed_2676' : [ 0x8, {
    'Context1' : [ 0x0, ['unsigned long']],
    'Context2' : [ 0x4, ['unsigned long']],
} ],
  '__unnamed_2678' : [ 0x8, {
    'DirtyVectorModifiedContext' : [ 0x0, ['__unnamed_2672']],
    'DirtyDataCaptureContext' : [ 0x0, ['__unnamed_2674']],
    'Raw' : [ 0x0, ['__unnamed_2676']],
} ],
  '_CM_DIRTY_VECTOR_LOG_ENTRY' : [ 0x48, {
    'Thread' : [ 0x0, ['pointer64', ['_ETHREAD']]],
    'Operation' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {0: u'DirtyVectorModified', 1: u'DirtyDataCaptureStart', 2: u'DirtyDataCaptureEnd'})]],
    'Data' : [ 0xc, ['__unnamed_2678']],
    'Stack' : [ 0x18, ['array', 6, ['pointer64', ['void']]]],
} ],
  '_CMP_DISCARD_AND_REPLACE_KCB_CONTEXT' : [ 0x20, {
    'BaseKcb' : [ 0x0, ['pointer64', ['_CM_KEY_CONTROL_BLOCK']]],
    'PrepareStatus' : [ 0x8, ['long']],
    'ClonedKcbListHead' : [ 0x10, ['_LIST_ENTRY']],
} ],
  '_PNP_DEVICE_ACTION_ENTRY' : [ 0x60, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'DeviceObject' : [ 0x10, ['pointer64', ['_DEVICE_OBJECT']]],
    'RequestType' : [ 0x18, ['Enumeration', dict(target = 'long', choices = {0: u'AssignResources', 1: u'ClearDeviceProblem', 2: u'ClearProblem', 3: u'ClearEjectProblem', 4: u'HaltDevice', 5: u'QueryPowerRelations', 6: u'Rebalance', 7: u'ReenumerateBootDevices', 8: u'ReenumerateDeviceOnly', 9: u'ReenumerateDeviceTree', 10: u'ReenumerateRootDevices', 11: u'RequeryDeviceState', 12: u'ResetDevice', 13: u'ResourceRequirementsChanged', 14: u'RestartEnumeration', 15: u'SetDeviceProblem', 16: u'StartDevice', 17: u'StartSystemDevicesPass0', 18: u'StartSystemDevicesPass1', 19: u'NotifyTransportRelationsChange', 20: u'NotifyEjectionRelationsChange', 21: u'ConfigureDevice', 22: u'ConfigureDeviceClass', 23: u'ConfigureDeviceExtensions', 24: u'ConfigureDeviceReset', 25: u'ClearDmaGuardProblem'})]],
    'ReorderingBarrier' : [ 0x1c, ['unsigned char']],
    'RequestArgument' : [ 0x20, ['unsigned long long']],
    'CompletionEvent' : [ 0x28, ['pointer64', ['_KEVENT']]],
    'CompletionStatus' : [ 0x30, ['pointer64', ['long']]],
    'ActivityId' : [ 0x38, ['_GUID']],
    'RefCount' : [ 0x48, ['long']],
    'Dequeued' : [ 0x4c, ['unsigned char']],
    'CancelLock' : [ 0x50, ['_EX_PUSH_LOCK']],
    'CancelRequested' : [ 0x58, ['unsigned char']],
} ],
  '_PPM_PLATFORM_STATE' : [ 0x180, {
    'LevelId' : [ 0x0, ['unsigned long long']],
    'Latency' : [ 0x8, ['unsigned long']],
    'BreakEvenDuration' : [ 0xc, ['unsigned long']],
    'VetoAccounting' : [ 0x10, ['_PPM_VETO_ACCOUNTING']],
    'TransitionDebugger' : [ 0x38, ['unsigned char']],
    'Platform' : [ 0x39, ['unsigned char']],
    'DependencyListCount' : [ 0x3c, ['unsigned long']],
    'Processors' : [ 0x40, ['_KAFFINITY_EX']],
    'Name' : [ 0xe8, ['_UNICODE_STRING']],
    'DependencyLists' : [ 0xf8, ['pointer64', ['_PPM_SELECTION_DEPENDENCY']]],
    'Synchronization' : [ 0x100, ['_PPM_COORDINATED_SYNCHRONIZATION']],
    'EnterTime' : [ 0x108, ['unsigned long long']],
    'RefCount' : [ 0x140, ['long']],
    'CacheAlign0' : [ 0x140, ['array', 64, ['unsigned char']]],
} ],
  '_PEB_LDR_DATA' : [ 0x58, {
    'Length' : [ 0x0, ['unsigned long']],
    'Initialized' : [ 0x4, ['unsigned char']],
    'SsHandle' : [ 0x8, ['pointer64', ['void']]],
    'InLoadOrderModuleList' : [ 0x10, ['_LIST_ENTRY']],
    'InMemoryOrderModuleList' : [ 0x20, ['_LIST_ENTRY']],
    'InInitializationOrderModuleList' : [ 0x30, ['_LIST_ENTRY']],
    'EntryInProgress' : [ 0x40, ['pointer64', ['void']]],
    'ShutdownInProgress' : [ 0x48, ['unsigned char']],
    'ShutdownThreadId' : [ 0x50, ['pointer64', ['void']]],
} ],
  '_MI_PARTITION_PAGE_LISTS' : [ 0xfc0, {
    'FreePagesByColor' : [ 0x0, ['array', 2, ['pointer64', ['_MMPFNLIST']]]],
    'ZeroedPageListHead' : [ 0x40, ['_MMPFNLIST']],
    'FreePageListHead' : [ 0x80, ['_MMPFNLIST']],
    'StandbyPageListHead' : [ 0xc0, ['_MMPFNLIST']],
    'StandbyPageListByPriority' : [ 0x100, ['array', 8, ['_MMPFNLIST']]],
    'ModifiedPageListNoReservation' : [ 0x240, ['_MMPFNLIST']],
    'ModifiedPageListByReservation' : [ 0x280, ['array', 16, ['_MMPFNLIST']]],
    'MappedPageListHead' : [ 0x500, ['array', 16, ['_MMPFNLIST']]],
    'BadPageListHead' : [ 0x780, ['_MMPFNLIST']],
    'EnclavePageListHead' : [ 0x7c0, ['_MMPFNLIST']],
    'FreePageSlist' : [ 0x7e8, ['array', 2, ['pointer64', ['_SLIST_HEADER']]]],
    'PageLocationList' : [ 0x7f8, ['array', 8, ['pointer64', ['_MMPFNLIST']]]],
    'StandbyRepurposedByPriority' : [ 0x838, ['array', 8, ['unsigned long']]],
    'TransitionSharedPages' : [ 0x880, ['unsigned long long']],
    'TransitionSharedPagesPeak' : [ 0x888, ['array', 6, ['unsigned long long']]],
    'MappedPageListHeadEvent' : [ 0x8b8, ['array', 16, ['_KEVENT']]],
    'DecayClusterTimerHeads' : [ 0xa38, ['array', 4, ['_MI_DECAY_TIMER_LINK']]],
    'DecayHand' : [ 0xa58, ['unsigned long']],
    'StandbyListDiscard' : [ 0xa5c, ['unsigned char']],
    'FreeListDiscard' : [ 0xa5d, ['unsigned char']],
    'LargePfnBitMapsReady' : [ 0xa5e, ['unsigned char']],
    'LastDecayHandUpdateTime' : [ 0xa60, ['unsigned long long']],
    'LastChanceLdwContext' : [ 0xa68, ['_MI_LDW_WORK_CONTEXT']],
    'AvailableEventsLock' : [ 0xac0, ['unsigned long long']],
    'AvailablePageWaitStates' : [ 0xac8, ['array', 3, ['_MI_AVAILABLE_PAGE_WAIT_STATES']]],
    'MirrorListLocks' : [ 0xb28, ['pointer64', ['void']]],
    'TransitionPrivatePages' : [ 0xb40, ['unsigned long long']],
    'LargePfnBitMap' : [ 0xb48, ['array', 2, ['_RTL_BITMAP_EX']]],
    'LargePageListHeads' : [ 0xb68, ['pointer64', ['_MI_FREE_LARGE_PAGE_LIST']]],
    'LargePageCandidates' : [ 0xb70, ['array', 2, ['_MI_LARGE_PAGE_CANDIDATES']]],
    'RebuildLargePageWorkItem' : [ 0xf80, ['_WORK_QUEUE_ITEM']],
    'RebuildLargePageActive' : [ 0xfa0, ['unsigned char']],
    'LargePageRebuildLock' : [ 0xfa4, ['long']],
    'LowMemoryThreshold' : [ 0xfa8, ['unsigned long long']],
    'HighMemoryThreshold' : [ 0xfb0, ['unsigned long long']],
} ],
  '__unnamed_26a4' : [ 0x8, {
    'Long' : [ 0x0, ['unsigned long long']],
    'e1' : [ 0x0, ['_MI_DECAY_TIMER_LINKAGE']],
} ],
  '_MI_DECAY_TIMER_LINK' : [ 0x8, {
    'u1' : [ 0x0, ['__unnamed_26a4']],
} ],
  '_CACHE_DESCRIPTOR' : [ 0xc, {
    'Level' : [ 0x0, ['unsigned char']],
    'Associativity' : [ 0x1, ['unsigned char']],
    'LineSize' : [ 0x2, ['unsigned short']],
    'Size' : [ 0x4, ['unsigned long']],
    'Type' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {0: u'CacheUnified', 1: u'CacheInstruction', 2: u'CacheData', 3: u'CacheTrace'})]],
} ],
  '_KAPC' : [ 0x58, {
    'Type' : [ 0x0, ['unsigned char']],
    'SpareByte0' : [ 0x1, ['unsigned char']],
    'Size' : [ 0x2, ['unsigned char']],
    'SpareByte1' : [ 0x3, ['unsigned char']],
    'SpareLong0' : [ 0x4, ['unsigned long']],
    'Thread' : [ 0x8, ['pointer64', ['_KTHREAD']]],
    'ApcListEntry' : [ 0x10, ['_LIST_ENTRY']],
    'KernelRoutine' : [ 0x20, ['pointer64', ['void']]],
    'RundownRoutine' : [ 0x28, ['pointer64', ['void']]],
    'NormalRoutine' : [ 0x30, ['pointer64', ['void']]],
    'Reserved' : [ 0x20, ['array', 3, ['pointer64', ['void']]]],
    'NormalContext' : [ 0x38, ['pointer64', ['void']]],
    'SystemArgument1' : [ 0x40, ['pointer64', ['void']]],
    'SystemArgument2' : [ 0x48, ['pointer64', ['void']]],
    'ApcStateIndex' : [ 0x50, ['unsigned char']],
    'ApcMode' : [ 0x51, ['unsigned char']],
    'Inserted' : [ 0x52, ['unsigned char']],
} ],
  '__unnamed_26bc' : [ 0x8, {
    'AllocationType' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 3, native_type='unsigned long long')]],
    'Inserted' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long long')]],
} ],
  '__unnamed_26be' : [ 0x8, {
    'PrototypePtesFlags' : [ 0x0, ['unsigned long long']],
} ],
  '__unnamed_26c0' : [ 0x8, {
    'e1' : [ 0x0, ['__unnamed_26bc']],
    'e2' : [ 0x0, ['__unnamed_26be']],
} ],
  '_MI_PROTOTYPE_PTES_NODE' : [ 0x20, {
    'Node' : [ 0x0, ['_RTL_BALANCED_NODE']],
    'u1' : [ 0x18, ['__unnamed_26c0']],
} ],
  '_ETW_COUNTERS' : [ 0x10, {
    'GuidCount' : [ 0x0, ['long']],
    'PoolUsage' : [ 0x4, ['array', 2, ['long']]],
    'SessionCount' : [ 0xc, ['long']],
} ],
  '_ARM_DBGKD_CONTROL_SET' : [ 0xc, {
    'Continue' : [ 0x0, ['unsigned long']],
    'CurrentSymbolStart' : [ 0x4, ['unsigned long']],
    'CurrentSymbolEnd' : [ 0x8, ['unsigned long']],
} ],
  '_PCW_COUNTER_INFORMATION' : [ 0x10, {
    'CounterMask' : [ 0x0, ['unsigned long long']],
    'InstanceMask' : [ 0x8, ['pointer64', ['_UNICODE_STRING']]],
} ],
  '_MI_PAGE_COMBINING_SUPPORT' : [ 0x188, {
    'Partition' : [ 0x0, ['pointer64', ['_MI_PARTITION']]],
    'ArbitraryPfnMapList' : [ 0x8, ['_LIST_ENTRY']],
    'FreeCombinePoolItem' : [ 0x18, ['_MI_COMBINE_WORKITEM']],
    'CombiningThreadCount' : [ 0x40, ['unsigned long']],
    'CombinePageFreeList' : [ 0x48, ['_LIST_ENTRY']],
    'CombineFreeListLock' : [ 0x58, ['unsigned long long']],
    'CombinePageListHeads' : [ 0x60, ['array', 16, ['_MI_COMBINE_PAGE_LISTHEAD']]],
    'PageCombineStats' : [ 0x160, ['_MI_PAGE_COMBINE_STATISTICS']],
} ],
  '_SEP_LOWBOX_NUMBER_ENTRY' : [ 0x38, {
    'HashEntry' : [ 0x0, ['_RTL_DYNAMIC_HASH_TABLE_ENTRY']],
    'ReferenceCount' : [ 0x18, ['long long']],
    'PackageSid' : [ 0x20, ['pointer64', ['void']]],
    'LowboxNumber' : [ 0x28, ['unsigned long']],
    'AtomTable' : [ 0x30, ['pointer64', ['void']]],
} ],
  '_PPM_SELECTION_MENU' : [ 0x10, {
    'Count' : [ 0x0, ['unsigned long']],
    'Entries' : [ 0x8, ['pointer64', ['_PPM_SELECTION_MENU_ENTRY']]],
} ],
  '_EXT_IOMMU_DEVICE_ID' : [ 0x18, {
    'DeviceType' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: u'EXT_IOMMU_DEVICE_TYPE_INVALID', 1: u'EXT_IOMMU_DEVICE_TYPE_PCI', 2: u'EXT_IOMMU_DEVICE_TYPE_ACPI', 3: u'EXT_IOMMU_DEVICE_TYPE_IOAPIC', 4: u'EXT_IOMMU_DEVICE_TYPE_LOGICAL', 5: u'EXT_IOMMU_DEVICE_TYPE_TEST', 6: u'EXT_IOMMU_DEVICE_TYPE_MAX'})]],
    'Pci' : [ 0x8, ['_EXT_IOMMU_DEVICE_ID_PCI']],
    'Acpi' : [ 0x8, ['_EXT_IOMMU_DEVICE_ID_ACPI']],
    'IoApicId' : [ 0x8, ['unsigned char']],
    'LogicalId' : [ 0x8, ['unsigned long long']],
    'Test' : [ 0x8, ['_EXT_IOMMU_DEVICE_ID_TEST']],
} ],
  '_TraceLoggingMetadata_t' : [ 0x10, {
    'Signature' : [ 0x0, ['unsigned long']],
    'Size' : [ 0x4, ['unsigned short']],
    'Version' : [ 0x6, ['unsigned char']],
    'Flags' : [ 0x7, ['unsigned char']],
    'Magic' : [ 0x8, ['unsigned long long']],
} ],
  '__unnamed_26e5' : [ 0x8, {
    'Gsiv' : [ 0x0, ['unsigned long']],
    'WakeInterrupt' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'ReservedFlags' : [ 0x4, ['BitField', dict(start_bit = 1, end_bit = 32, native_type='unsigned long')]],
} ],
  '__unnamed_26e7' : [ 0x10, {
    'Address' : [ 0x0, ['_LARGE_INTEGER']],
    'DataPayload' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_26ea' : [ 0x8, {
    'IntrInfo' : [ 0x0, ['_INTERRUPT_HT_INTR_INFO']],
} ],
  '__unnamed_26ee' : [ 0x4, {
    'DestinationMode' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {1: u'ApicDestinationModePhysical', 2: u'ApicDestinationModeLogicalFlat', 3: u'ApicDestinationModeLogicalClustered', 4: u'ApicDestinationModeUnknown'})]],
} ],
  '_INTERRUPT_VECTOR_DATA' : [ 0x58, {
    'Type' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: u'InterruptTypeControllerInput', 1: u'InterruptTypeXapicMessage', 2: u'InterruptTypeHypertransport', 3: u'InterruptTypeMessageRequest'})]],
    'Vector' : [ 0x4, ['unsigned long']],
    'Irql' : [ 0x8, ['unsigned char']],
    'Polarity' : [ 0xc, ['Enumeration', dict(target = 'long', choices = {0: u'InterruptPolarityUnknown', 1: u'InterruptRisingEdge', 2: u'InterruptFallingEdge', 3: u'InterruptActiveBothTriggerLow', 4: u'InterruptActiveBothTriggerHigh'})]],
    'Mode' : [ 0x10, ['Enumeration', dict(target = 'long', choices = {0: u'LevelSensitive', 1: u'Latched'})]],
    'TargetProcessors' : [ 0x18, ['_GROUP_AFFINITY']],
    'IntRemapInfo' : [ 0x28, ['_INTERRUPT_REMAPPING_INFO']],
    'ControllerInput' : [ 0x38, ['__unnamed_26e5']],
    'HvDeviceId' : [ 0x40, ['unsigned long long']],
    'XapicMessage' : [ 0x48, ['__unnamed_26e7']],
    'Hypertransport' : [ 0x48, ['__unnamed_26ea']],
    'GenericMessage' : [ 0x48, ['__unnamed_26e7']],
    'MessageRequest' : [ 0x48, ['__unnamed_26ee']],
} ],
  '__unnamed_26f3' : [ 0x4, {
    'Mask' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Polarity' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'MessageType' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 5, native_type='unsigned long')]],
    'RequestEOI' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'DestinationMode' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'MessageType3' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'Destination' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 16, native_type='unsigned long')]],
    'Vector' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 24, native_type='unsigned long')]],
    'ExtendedAddress' : [ 0x0, ['BitField', dict(start_bit = 24, end_bit = 32, native_type='unsigned long')]],
} ],
  '__unnamed_26f5' : [ 0x4, {
    'bits' : [ 0x0, ['__unnamed_26f3']],
    'AsULONG' : [ 0x0, ['unsigned long']],
} ],
  '__unnamed_26f9' : [ 0x4, {
    'ExtendedDestination' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 24, native_type='unsigned long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 24, end_bit = 30, native_type='unsigned long')]],
    'PassPW' : [ 0x0, ['BitField', dict(start_bit = 30, end_bit = 31, native_type='unsigned long')]],
    'WaitingForEOI' : [ 0x0, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
} ],
  '__unnamed_26fb' : [ 0x4, {
    'bits' : [ 0x0, ['__unnamed_26f9']],
    'AsULONG' : [ 0x0, ['unsigned long']],
} ],
  '_INTERRUPT_HT_INTR_INFO' : [ 0x8, {
    'LowPart' : [ 0x0, ['__unnamed_26f5']],
    'HighPart' : [ 0x4, ['__unnamed_26fb']],
} ],
  '_CHILD_LIST' : [ 0x8, {
    'Count' : [ 0x0, ['unsigned long']],
    'List' : [ 0x4, ['unsigned long']],
} ],
  '_FILE_BASIC_INFORMATION' : [ 0x28, {
    'CreationTime' : [ 0x0, ['_LARGE_INTEGER']],
    'LastAccessTime' : [ 0x8, ['_LARGE_INTEGER']],
    'LastWriteTime' : [ 0x10, ['_LARGE_INTEGER']],
    'ChangeTime' : [ 0x18, ['_LARGE_INTEGER']],
    'FileAttributes' : [ 0x20, ['unsigned long']],
} ],
  '_EVENT_HEADER' : [ 0x50, {
    'Size' : [ 0x0, ['unsigned short']],
    'HeaderType' : [ 0x2, ['unsigned short']],
    'Flags' : [ 0x4, ['unsigned short']],
    'EventProperty' : [ 0x6, ['unsigned short']],
    'ThreadId' : [ 0x8, ['unsigned long']],
    'ProcessId' : [ 0xc, ['unsigned long']],
    'TimeStamp' : [ 0x10, ['_LARGE_INTEGER']],
    'ProviderId' : [ 0x18, ['_GUID']],
    'EventDescriptor' : [ 0x28, ['_EVENT_DESCRIPTOR']],
    'KernelTime' : [ 0x38, ['unsigned long']],
    'UserTime' : [ 0x3c, ['unsigned long']],
    'ProcessorTime' : [ 0x38, ['unsigned long long']],
    'ActivityId' : [ 0x40, ['_GUID']],
} ],
  '_SYSTEM_POWER_STATE_CONTEXT' : [ 0x4, {
    'Reserved1' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned long')]],
    'TargetSystemState' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 12, native_type='unsigned long')]],
    'EffectiveSystemState' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 16, native_type='unsigned long')]],
    'CurrentSystemState' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 20, native_type='unsigned long')]],
    'IgnoreHibernationPath' : [ 0x0, ['BitField', dict(start_bit = 20, end_bit = 21, native_type='unsigned long')]],
    'PseudoTransition' : [ 0x0, ['BitField', dict(start_bit = 21, end_bit = 22, native_type='unsigned long')]],
    'KernelSoftReboot' : [ 0x0, ['BitField', dict(start_bit = 22, end_bit = 23, native_type='unsigned long')]],
    'Reserved2' : [ 0x0, ['BitField', dict(start_bit = 23, end_bit = 32, native_type='unsigned long')]],
    'ContextAsUlong' : [ 0x0, ['unsigned long']],
} ],
  '_KIDTENTRY64' : [ 0x10, {
    'OffsetLow' : [ 0x0, ['unsigned short']],
    'Selector' : [ 0x2, ['unsigned short']],
    'IstIndex' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 3, native_type='unsigned short')]],
    'Reserved0' : [ 0x4, ['BitField', dict(start_bit = 3, end_bit = 8, native_type='unsigned short')]],
    'Type' : [ 0x4, ['BitField', dict(start_bit = 8, end_bit = 13, native_type='unsigned short')]],
    'Dpl' : [ 0x4, ['BitField', dict(start_bit = 13, end_bit = 15, native_type='unsigned short')]],
    'Present' : [ 0x4, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned short')]],
    'OffsetMiddle' : [ 0x6, ['unsigned short']],
    'OffsetHigh' : [ 0x8, ['unsigned long']],
    'Reserved1' : [ 0xc, ['unsigned long']],
    'Alignment' : [ 0x0, ['unsigned long long']],
} ],
  '_KINTERRUPT' : [ 0x100, {
    'Type' : [ 0x0, ['short']],
    'Size' : [ 0x2, ['short']],
    'InterruptListEntry' : [ 0x8, ['_LIST_ENTRY']],
    'ServiceRoutine' : [ 0x18, ['pointer64', ['void']]],
    'MessageServiceRoutine' : [ 0x20, ['pointer64', ['void']]],
    'MessageIndex' : [ 0x28, ['unsigned long']],
    'ServiceContext' : [ 0x30, ['pointer64', ['void']]],
    'SpinLock' : [ 0x38, ['unsigned long long']],
    'TickCount' : [ 0x40, ['unsigned long']],
    'ActualLock' : [ 0x48, ['pointer64', ['unsigned long long']]],
    'DispatchAddress' : [ 0x50, ['pointer64', ['void']]],
    'Vector' : [ 0x58, ['unsigned long']],
    'Irql' : [ 0x5c, ['unsigned char']],
    'SynchronizeIrql' : [ 0x5d, ['unsigned char']],
    'FloatingSave' : [ 0x5e, ['unsigned char']],
    'Connected' : [ 0x5f, ['unsigned char']],
    'Number' : [ 0x60, ['unsigned long']],
    'ShareVector' : [ 0x64, ['unsigned char']],
    'EmulateActiveBoth' : [ 0x65, ['unsigned char']],
    'ActiveCount' : [ 0x66, ['unsigned short']],
    'InternalState' : [ 0x68, ['long']],
    'Mode' : [ 0x6c, ['Enumeration', dict(target = 'long', choices = {0: u'LevelSensitive', 1: u'Latched'})]],
    'Polarity' : [ 0x70, ['Enumeration', dict(target = 'long', choices = {0: u'InterruptPolarityUnknown', 1: u'InterruptRisingEdge', 2: u'InterruptFallingEdge', 3: u'InterruptActiveBothTriggerLow', 4: u'InterruptActiveBothTriggerHigh'})]],
    'ServiceCount' : [ 0x74, ['unsigned long']],
    'DispatchCount' : [ 0x78, ['unsigned long']],
    'PassiveEvent' : [ 0x80, ['pointer64', ['_KEVENT']]],
    'TrapFrame' : [ 0x88, ['pointer64', ['_KTRAP_FRAME']]],
    'DisconnectData' : [ 0x90, ['pointer64', ['void']]],
    'ServiceThread' : [ 0x98, ['pointer64', ['_KTHREAD']]],
    'ConnectionData' : [ 0xa0, ['pointer64', ['_INTERRUPT_CONNECTION_DATA']]],
    'IntTrackEntry' : [ 0xa8, ['pointer64', ['void']]],
    'IsrDpcStats' : [ 0xb0, ['_ISRDPCSTATS']],
    'RedirectObject' : [ 0xf0, ['pointer64', ['void']]],
    'Padding' : [ 0xf8, ['array', 8, ['unsigned char']]],
} ],
  '_PRIVILEGE_SET' : [ 0x14, {
    'PrivilegeCount' : [ 0x0, ['unsigned long']],
    'Control' : [ 0x4, ['unsigned long']],
    'Privilege' : [ 0x8, ['array', 1, ['_LUID_AND_ATTRIBUTES']]],
} ],
  '_IO_WORKITEM' : [ 0x58, {
    'WorkItem' : [ 0x0, ['_WORK_QUEUE_ITEM']],
    'Routine' : [ 0x20, ['pointer64', ['void']]],
    'IoObject' : [ 0x28, ['pointer64', ['void']]],
    'Context' : [ 0x30, ['pointer64', ['void']]],
    'WorkOnBehalfThread' : [ 0x38, ['pointer64', ['_ETHREAD']]],
    'Type' : [ 0x40, ['unsigned long']],
    'ActivityId' : [ 0x44, ['_GUID']],
} ],
  '_DISALLOWED_GUIDS' : [ 0x10, {
    'Count' : [ 0x0, ['unsigned short']],
    'Guids' : [ 0x8, ['pointer64', ['_GUID']]],
} ],
  '_MMWSL_INSTANCE' : [ 0x28, {
    'NextPteToTrim' : [ 0x0, ['pointer64', ['_MMPTE']]],
    'NextPteToAge' : [ 0x8, ['pointer64', ['_MMPTE']]],
    'NextPteToAccessClear' : [ 0x10, ['pointer64', ['_MMPTE']]],
    'LastAccessClearingRemainder' : [ 0x18, ['unsigned long']],
    'LastAgingRemainder' : [ 0x1c, ['unsigned long']],
    'LockedEntries' : [ 0x20, ['unsigned long long']],
} ],
  '_XSAVE_AREA_HEADER' : [ 0x40, {
    'Mask' : [ 0x0, ['unsigned long long']],
    'CompactionMask' : [ 0x8, ['unsigned long long']],
    'Reserved2' : [ 0x10, ['array', 6, ['unsigned long long']]],
} ],
  '_PI_BUS_EXTENSION' : [ 0x70, {
    'Flags' : [ 0x0, ['unsigned long']],
    'NumberCSNs' : [ 0x4, ['unsigned char']],
    'ReadDataPort' : [ 0x8, ['pointer64', ['unsigned char']]],
    'DataPortMapped' : [ 0x10, ['unsigned char']],
    'AddressPort' : [ 0x18, ['pointer64', ['unsigned char']]],
    'AddrPortMapped' : [ 0x20, ['unsigned char']],
    'CommandPort' : [ 0x28, ['pointer64', ['unsigned char']]],
    'CmdPortMapped' : [ 0x30, ['unsigned char']],
    'NextSlotNumber' : [ 0x34, ['unsigned long']],
    'DeviceList' : [ 0x38, ['_SINGLE_LIST_ENTRY']],
    'CardList' : [ 0x40, ['_SINGLE_LIST_ENTRY']],
    'PhysicalBusDevice' : [ 0x48, ['pointer64', ['_DEVICE_OBJECT']]],
    'FunctionalBusDevice' : [ 0x50, ['pointer64', ['_DEVICE_OBJECT']]],
    'AttachedDevice' : [ 0x58, ['pointer64', ['_DEVICE_OBJECT']]],
    'BusNumber' : [ 0x60, ['unsigned long']],
    'SystemPowerState' : [ 0x64, ['Enumeration', dict(target = 'long', choices = {0: u'PowerSystemUnspecified', 1: u'PowerSystemWorking', 2: u'PowerSystemSleeping1', 3: u'PowerSystemSleeping2', 4: u'PowerSystemSleeping3', 5: u'PowerSystemHibernate', 6: u'PowerSystemShutdown', 7: u'PowerSystemMaximum'})]],
    'DevicePowerState' : [ 0x68, ['Enumeration', dict(target = 'long', choices = {0: u'PowerDeviceUnspecified', 1: u'PowerDeviceD0', 2: u'PowerDeviceD1', 3: u'PowerDeviceD2', 4: u'PowerDeviceD3', 5: u'PowerDeviceMaximum'})]],
} ],
  '_WHEA_MEMORY_ERROR_SECTION' : [ 0x50, {
    'ValidBits' : [ 0x0, ['_WHEA_MEMORY_ERROR_SECTION_VALIDBITS']],
    'ErrorStatus' : [ 0x8, ['_WHEA_ERROR_STATUS']],
    'PhysicalAddress' : [ 0x10, ['unsigned long long']],
    'PhysicalAddressMask' : [ 0x18, ['unsigned long long']],
    'Node' : [ 0x20, ['unsigned short']],
    'Card' : [ 0x22, ['unsigned short']],
    'Module' : [ 0x24, ['unsigned short']],
    'Bank' : [ 0x26, ['unsigned short']],
    'Device' : [ 0x28, ['unsigned short']],
    'Row' : [ 0x2a, ['unsigned short']],
    'Column' : [ 0x2c, ['unsigned short']],
    'BitPosition' : [ 0x2e, ['unsigned short']],
    'RequesterId' : [ 0x30, ['unsigned long long']],
    'ResponderId' : [ 0x38, ['unsigned long long']],
    'TargetId' : [ 0x40, ['unsigned long long']],
    'ErrorType' : [ 0x48, ['unsigned char']],
    'Extended' : [ 0x49, ['unsigned char']],
    'RankNumber' : [ 0x4a, ['unsigned short']],
    'CardHandle' : [ 0x4c, ['unsigned short']],
    'ModuleHandle' : [ 0x4e, ['unsigned short']],
} ],
  '_IO_RESOURCE_LIST' : [ 0x28, {
    'Version' : [ 0x0, ['unsigned short']],
    'Revision' : [ 0x2, ['unsigned short']],
    'Count' : [ 0x4, ['unsigned long']],
    'Descriptors' : [ 0x8, ['array', 1, ['_IO_RESOURCE_DESCRIPTOR']]],
} ],
  '_SK_CRASH_MODULE' : [ 0x48, {
    'ImageName' : [ 0x0, ['array', 32, ['wchar']]],
    'SizeOfImage' : [ 0x40, ['unsigned long']],
    'TimeDateStamp' : [ 0x44, ['unsigned long']],
} ],
  '_KPROCESSOR_STATE' : [ 0x5c0, {
    'SpecialRegisters' : [ 0x0, ['_KSPECIAL_REGISTERS']],
    'ContextFrame' : [ 0xf0, ['_CONTEXT']],
} ],
  '_KAPC_STATE' : [ 0x30, {
    'ApcListHead' : [ 0x0, ['array', 2, ['_LIST_ENTRY']]],
    'Process' : [ 0x20, ['pointer64', ['_KPROCESS']]],
    'InProgressFlags' : [ 0x28, ['unsigned char']],
    'KernelApcInProgress' : [ 0x28, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'SpecialApcInProgress' : [ 0x28, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'KernelApcPending' : [ 0x29, ['unsigned char']],
    'UserApcPending' : [ 0x2a, ['unsigned char']],
} ],
  '_KDEVICE_QUEUE_ENTRY' : [ 0x18, {
    'DeviceListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'SortKey' : [ 0x10, ['unsigned long']],
    'Inserted' : [ 0x14, ['unsigned char']],
} ],
  '_PEP_ACPI_RESOURCE_FLAGS' : [ 0x4, {
    'AsULong' : [ 0x0, ['unsigned long']],
    'Shared' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Wake' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'ResourceUsage' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'SlaveMode' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'AddressingMode' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'SharedMode' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 32, native_type='unsigned long')]],
} ],
  '_INITIAL_PRIVILEGE_SET' : [ 0x2c, {
    'PrivilegeCount' : [ 0x0, ['unsigned long']],
    'Control' : [ 0x4, ['unsigned long']],
    'Privilege' : [ 0x8, ['array', 3, ['_LUID_AND_ATTRIBUTES']]],
} ],
  '_ETW_REF_CLOCK' : [ 0x10, {
    'StartTime' : [ 0x0, ['_LARGE_INTEGER']],
    'StartPerfClock' : [ 0x8, ['_LARGE_INTEGER']],
} ],
  '_IO_ADAPTER_CRYPTO_PARAMETERS' : [ 0x10, {
    'Tweak' : [ 0x0, ['unsigned long long']],
    'KeyDescriptor' : [ 0x8, ['pointer64', ['_IO_ADAPTER_CRYPTO_KEY_DESCRIPTOR']]],
} ],
  '_HEAP_VAMGR_CTX' : [ 0x3040, {
    'VaSpace' : [ 0x0, ['_HEAP_VAMGR_VASPACE']],
    'AllocatorLock' : [ 0x60, ['unsigned long long']],
    'AllocatorCount' : [ 0x68, ['unsigned long']],
    'Allocators' : [ 0x70, ['array', 255, ['_HEAP_VAMGR_ALLOCATOR']]],
} ],
  '_TOKEN_SOURCE' : [ 0x10, {
    'SourceName' : [ 0x0, ['array', 8, ['unsigned char']]],
    'SourceIdentifier' : [ 0x8, ['_LUID']],
} ],
  '_DEBUG_DEVICE_DESCRIPTOR' : [ 0xf8, {
    'Bus' : [ 0x0, ['unsigned long']],
    'Slot' : [ 0x4, ['unsigned long']],
    'Segment' : [ 0x8, ['unsigned short']],
    'VendorID' : [ 0xa, ['unsigned short']],
    'DeviceID' : [ 0xc, ['unsigned short']],
    'BaseClass' : [ 0xe, ['unsigned char']],
    'SubClass' : [ 0xf, ['unsigned char']],
    'ProgIf' : [ 0x10, ['unsigned char']],
    'Flags' : [ 0x11, ['unsigned char']],
    'DbgHalScratchAllocated' : [ 0x11, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'DbgBarsMapped' : [ 0x11, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'DbgScratchAllocated' : [ 0x11, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'Initialized' : [ 0x12, ['unsigned char']],
    'Configured' : [ 0x13, ['unsigned char']],
    'BaseAddress' : [ 0x18, ['array', 6, ['DEBUG_DEVICE_ADDRESS']]],
    'Memory' : [ 0xa8, ['DEBUG_MEMORY_REQUIREMENTS']],
    'PortType' : [ 0xc8, ['unsigned short']],
    'PortSubtype' : [ 0xca, ['unsigned short']],
    'OemData' : [ 0xd0, ['pointer64', ['void']]],
    'OemDataLength' : [ 0xd8, ['unsigned long']],
    'NameSpace' : [ 0xdc, ['Enumeration', dict(target = 'long', choices = {0: u'KdNameSpacePCI', 1: u'KdNameSpaceACPI', 2: u'KdNameSpaceAny', 3: u'KdNameSpaceNone', 4: u'KdNameSpaceMax'})]],
    'NameSpacePath' : [ 0xe0, ['pointer64', ['wchar']]],
    'NameSpacePathLength' : [ 0xe8, ['unsigned long']],
    'TransportType' : [ 0xec, ['unsigned long']],
    'TransportData' : [ 0xf0, ['_DEBUG_TRANSPORT_DATA']],
} ],
  '__unnamed_2761' : [ 0x4, {
    'PollInterval' : [ 0x0, ['unsigned long']],
} ],
  '__unnamed_2763' : [ 0x18, {
    'PollInterval' : [ 0x0, ['unsigned long']],
    'Vector' : [ 0x4, ['unsigned long']],
    'SwitchToPollingThreshold' : [ 0x8, ['unsigned long']],
    'SwitchToPollingWindow' : [ 0xc, ['unsigned long']],
    'ErrorThreshold' : [ 0x10, ['unsigned long']],
    'ErrorThresholdWindow' : [ 0x14, ['unsigned long']],
} ],
  '__unnamed_2765' : [ 0x18, {
    'Polled' : [ 0x0, ['__unnamed_2761']],
    'Interrupt' : [ 0x0, ['__unnamed_2763']],
    'LocalInterrupt' : [ 0x0, ['__unnamed_2763']],
    'Sci' : [ 0x0, ['__unnamed_2763']],
    'Nmi' : [ 0x0, ['__unnamed_2763']],
    'Sea' : [ 0x0, ['__unnamed_2763']],
    'Sei' : [ 0x0, ['__unnamed_2763']],
    'Gsiv' : [ 0x0, ['__unnamed_2763']],
} ],
  '_WHEA_NOTIFICATION_DESCRIPTOR' : [ 0x1c, {
    'Type' : [ 0x0, ['unsigned char']],
    'Length' : [ 0x1, ['unsigned char']],
    'Flags' : [ 0x2, ['_WHEA_NOTIFICATION_FLAGS']],
    'u' : [ 0x4, ['__unnamed_2765']],
} ],
  '_THERMAL_INFORMATION_EX' : [ 0x5c, {
    'ThermalStamp' : [ 0x0, ['unsigned long']],
    'ThermalConstant1' : [ 0x4, ['unsigned long']],
    'ThermalConstant2' : [ 0x8, ['unsigned long']],
    'SamplingPeriod' : [ 0xc, ['unsigned long']],
    'CurrentTemperature' : [ 0x10, ['unsigned long']],
    'PassiveTripPoint' : [ 0x14, ['unsigned long']],
    'ThermalStandbyTripPoint' : [ 0x18, ['unsigned long']],
    'CriticalTripPoint' : [ 0x1c, ['unsigned long']],
    'ActiveTripPointCount' : [ 0x20, ['unsigned char']],
    'ActiveTripPoint' : [ 0x24, ['array', 10, ['unsigned long']]],
    'S4TransitionTripPoint' : [ 0x4c, ['unsigned long']],
    'MinimumThrottle' : [ 0x50, ['unsigned long']],
    'OverThrottleThreshold' : [ 0x54, ['unsigned long']],
    'PollingPeriod' : [ 0x58, ['unsigned long']],
} ],
  '_LOGGED_STREAM_CALLBACK_V2' : [ 0x8, {
    'LogHandleContext' : [ 0x0, ['pointer64', ['_LOG_HANDLE_CONTEXT']]],
} ],
  '_KPRIQUEUE' : [ 0x2b0, {
    'Header' : [ 0x0, ['_DISPATCHER_HEADER']],
    'EntryListHead' : [ 0x18, ['array', 32, ['_LIST_ENTRY']]],
    'CurrentCount' : [ 0x218, ['array', 32, ['long']]],
    'MaximumCount' : [ 0x298, ['unsigned long']],
    'ThreadListHead' : [ 0x2a0, ['_LIST_ENTRY']],
} ],
  '_IOP_IRP_EXTENSION_STATUS' : [ 0xc, {
    'Flags' : [ 0x0, ['unsigned long']],
    'ActivityId' : [ 0x4, ['unsigned long']],
    'IoTracking' : [ 0x8, ['unsigned long']],
} ],
  '_CM_KEY_SECURITY_CACHE' : [ 0x38, {
    'Cell' : [ 0x0, ['unsigned long']],
    'ConvKey' : [ 0x4, ['unsigned long']],
    'List' : [ 0x8, ['_LIST_ENTRY']],
    'DescriptorLength' : [ 0x18, ['unsigned long']],
    'RealRefCount' : [ 0x1c, ['unsigned long']],
    'Descriptor' : [ 0x20, ['_SECURITY_DESCRIPTOR_RELATIVE']],
} ],
  '_EX_WORK_QUEUE' : [ 0x2e0, {
    'WorkPriQueue' : [ 0x0, ['_KPRIQUEUE']],
    'Partition' : [ 0x2b0, ['pointer64', ['_EX_PARTITION']]],
    'Node' : [ 0x2b8, ['pointer64', ['_ENODE']]],
    'WorkItemsProcessed' : [ 0x2c0, ['unsigned long']],
    'WorkItemsProcessedLastPass' : [ 0x2c4, ['unsigned long']],
    'ThreadCount' : [ 0x2c8, ['long']],
    'MinThreads' : [ 0x2cc, ['BitField', dict(start_bit = 0, end_bit = 31, native_type='long')]],
    'TryFailed' : [ 0x2cc, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
    'MaxThreads' : [ 0x2d0, ['long']],
    'QueueIndex' : [ 0x2d4, ['Enumeration', dict(target = 'long', choices = {0: u'ExPoolUntrusted', 1: u'IoPoolUntrusted', 8: u'ExPoolMax'})]],
    'AllThreadsExitedEvent' : [ 0x2d8, ['pointer64', ['_KEVENT']]],
} ],
  '_KSCB' : [ 0x1a8, {
    'GenerationCycles' : [ 0x0, ['unsigned long long']],
    'MinQuotaCycleTarget' : [ 0x8, ['unsigned long long']],
    'MaxQuotaCycleTarget' : [ 0x10, ['unsigned long long']],
    'RankCycleTarget' : [ 0x18, ['unsigned long long']],
    'LongTermCycles' : [ 0x20, ['unsigned long long']],
    'LastReportedCycles' : [ 0x28, ['unsigned long long']],
    'OverQuotaHistory' : [ 0x30, ['unsigned long long']],
    'ReadyTime' : [ 0x38, ['unsigned long long']],
    'InsertTime' : [ 0x40, ['unsigned long long']],
    'PerProcessorList' : [ 0x48, ['_LIST_ENTRY']],
    'QueueNode' : [ 0x58, ['_RTL_BALANCED_NODE']],
    'Inserted' : [ 0x70, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'MaxOverQuota' : [ 0x70, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'MinOverQuota' : [ 0x70, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'RankBias' : [ 0x70, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'SoftCap' : [ 0x70, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'ShareRankOwner' : [ 0x70, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'Spare1' : [ 0x70, ['BitField', dict(start_bit = 6, end_bit = 8, native_type='unsigned char')]],
    'Depth' : [ 0x71, ['unsigned char']],
    'ReadySummary' : [ 0x72, ['unsigned short']],
    'Rank' : [ 0x74, ['unsigned long']],
    'ShareRank' : [ 0x78, ['pointer64', ['unsigned long']]],
    'OwnerShareRank' : [ 0x80, ['unsigned long']],
    'ReadyListHead' : [ 0x88, ['array', 16, ['_LIST_ENTRY']]],
    'ChildScbQueue' : [ 0x188, ['_RTL_RB_TREE']],
    'Parent' : [ 0x198, ['pointer64', ['_KSCB']]],
    'Root' : [ 0x1a0, ['pointer64', ['_KSCB']]],
} ],
  '__unnamed_278c' : [ 0x2, {
    'SignatureLevel' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 4, native_type='unsigned short')]],
    'SignatureType' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 7, native_type='unsigned short')]],
    'Unused' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 16, native_type='unsigned short')]],
    'EntireField' : [ 0x0, ['unsigned short']],
} ],
  '_KLDR_DATA_TABLE_ENTRY' : [ 0xa0, {
    'InLoadOrderLinks' : [ 0x0, ['_LIST_ENTRY']],
    'ExceptionTable' : [ 0x10, ['pointer64', ['void']]],
    'ExceptionTableSize' : [ 0x18, ['unsigned long']],
    'GpValue' : [ 0x20, ['pointer64', ['void']]],
    'NonPagedDebugInfo' : [ 0x28, ['pointer64', ['_NON_PAGED_DEBUG_INFO']]],
    'DllBase' : [ 0x30, ['pointer64', ['void']]],
    'EntryPoint' : [ 0x38, ['pointer64', ['void']]],
    'SizeOfImage' : [ 0x40, ['unsigned long']],
    'FullDllName' : [ 0x48, ['_UNICODE_STRING']],
    'BaseDllName' : [ 0x58, ['_UNICODE_STRING']],
    'Flags' : [ 0x68, ['unsigned long']],
    'LoadCount' : [ 0x6c, ['unsigned short']],
    'u1' : [ 0x6e, ['__unnamed_278c']],
    'SectionPointer' : [ 0x70, ['pointer64', ['void']]],
    'CheckSum' : [ 0x78, ['unsigned long']],
    'CoverageSectionSize' : [ 0x7c, ['unsigned long']],
    'CoverageSection' : [ 0x80, ['pointer64', ['void']]],
    'LoadedImports' : [ 0x88, ['pointer64', ['void']]],
    'Spare' : [ 0x90, ['pointer64', ['void']]],
    'SizeOfImageNotRounded' : [ 0x98, ['unsigned long']],
    'TimeDateStamp' : [ 0x9c, ['unsigned long']],
} ],
  '_VF_TRACKER' : [ 0x10, {
    'TrackerFlags' : [ 0x0, ['unsigned long']],
    'TrackerSize' : [ 0x4, ['unsigned long']],
    'TrackerIndex' : [ 0x8, ['unsigned long']],
    'TraceDepth' : [ 0xc, ['unsigned long']],
} ],
  '_MI_SYSTEM_TRIM_STATE' : [ 0x40, {
    'ExpansionLock' : [ 0x0, ['unsigned long long']],
    'TrimInProgressCount' : [ 0x8, ['long']],
    'PeriodicWorkingSetEvent' : [ 0x10, ['_KEVENT']],
    'TrimAllPageFaultCount' : [ 0x28, ['array', 3, ['unsigned long']]],
} ],
  '_RTLP_HP_METADATA_HEAP_CTX' : [ 0x10, {
    'Heap' : [ 0x0, ['pointer64', ['_SEGMENT_HEAP']]],
    'InitOnce' : [ 0x8, ['_RTL_RUN_ONCE']],
} ],
  '_KMUTANT' : [ 0x38, {
    'Header' : [ 0x0, ['_DISPATCHER_HEADER']],
    'MutantListEntry' : [ 0x18, ['_LIST_ENTRY']],
    'OwnerThread' : [ 0x28, ['pointer64', ['_KTHREAD']]],
    'Abandoned' : [ 0x30, ['unsigned char']],
    'ApcDisable' : [ 0x31, ['unsigned char']],
} ],
  '__unnamed_279e' : [ 0x8, {
    'Tradable' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'NonPagedBuddy' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 44, native_type='unsigned long long')]],
} ],
  '__unnamed_27a4' : [ 0x8, {
    'Tradable' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'WsleAge' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 4, native_type='unsigned long long')]],
    'OldestWsleLeafEntries' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 14, native_type='unsigned long long')]],
    'OldestWsleLeafAge' : [ 0x0, ['BitField', dict(start_bit = 14, end_bit = 17, native_type='unsigned long long')]],
    'NonPagedBuddy' : [ 0x0, ['BitField', dict(start_bit = 17, end_bit = 60, native_type='unsigned long long')]],
} ],
  '_MI_ACTIVE_PFN' : [ 0x8, {
    'Leaf' : [ 0x0, ['__unnamed_279e']],
    'PageTable' : [ 0x0, ['__unnamed_27a4']],
    'EntireActiveField' : [ 0x0, ['unsigned long long']],
} ],
  '_TRACE_ENABLE_INFO' : [ 0x20, {
    'IsEnabled' : [ 0x0, ['unsigned long']],
    'Level' : [ 0x4, ['unsigned char']],
    'Reserved1' : [ 0x5, ['unsigned char']],
    'LoggerId' : [ 0x6, ['unsigned short']],
    'EnableProperty' : [ 0x8, ['unsigned long']],
    'Reserved2' : [ 0xc, ['unsigned long']],
    'MatchAnyKeyword' : [ 0x10, ['unsigned long long']],
    'MatchAllKeyword' : [ 0x18, ['unsigned long long']],
} ],
  '_OBJECT_REF_STACK_INFO' : [ 0xc, {
    'Sequence' : [ 0x0, ['unsigned long']],
    'Index' : [ 0x4, ['unsigned short']],
    'NumTraces' : [ 0x6, ['unsigned short']],
    'Tag' : [ 0x8, ['unsigned long']],
} ],
  '_ETW_FILTER_STRING_TOKEN' : [ 0x18, {
    'Count' : [ 0x0, ['unsigned short']],
    'Tokens' : [ 0x8, ['array', 1, ['_ETW_FILTER_STRING_TOKEN_ELEMENT']]],
} ],
  '_MM_SYSTEM_PAGE_COUNTS' : [ 0x10, {
    'SystemCodePage' : [ 0x0, ['unsigned long']],
    'SystemDriverPage' : [ 0x4, ['unsigned long']],
    'TotalSystemCodePages' : [ 0x8, ['long']],
    'TotalSystemDriverPages' : [ 0xc, ['long']],
} ],
  '_KENLISTMENT' : [ 0x1e0, {
    'cookie' : [ 0x0, ['unsigned long']],
    'NamespaceLink' : [ 0x8, ['_KTMOBJECT_NAMESPACE_LINK']],
    'EnlistmentId' : [ 0x30, ['_GUID']],
    'Mutex' : [ 0x40, ['_KMUTANT']],
    'NextSameTx' : [ 0x78, ['_LIST_ENTRY']],
    'NextSameRm' : [ 0x88, ['_LIST_ENTRY']],
    'ResourceManager' : [ 0x98, ['pointer64', ['_KRESOURCEMANAGER']]],
    'Transaction' : [ 0xa0, ['pointer64', ['_KTRANSACTION']]],
    'State' : [ 0xa8, ['Enumeration', dict(target = 'long', choices = {0: u'KEnlistmentUninitialized', 256: u'KEnlistmentActive', 258: u'KEnlistmentPrepared', 259: u'KEnlistmentInDoubt', 260: u'KEnlistmentCommitted', 261: u'KEnlistmentCommittedNotify', 262: u'KEnlistmentCommitRequested', 257: u'KEnlistmentPreparing', 264: u'KEnlistmentDelegated', 265: u'KEnlistmentDelegatedDisconnected', 266: u'KEnlistmentPrePreparing', 263: u'KEnlistmentAborted', 268: u'KEnlistmentRecovering', 269: u'KEnlistmentAborting', 270: u'KEnlistmentReadOnly', 271: u'KEnlistmentOutcomeUnavailable', 272: u'KEnlistmentOffline', 273: u'KEnlistmentPrePrepared', 274: u'KEnlistmentInitialized', 267: u'KEnlistmentForgotten'})]],
    'Flags' : [ 0xac, ['unsigned long']],
    'NotificationMask' : [ 0xb0, ['unsigned long']],
    'Key' : [ 0xb8, ['pointer64', ['void']]],
    'KeyRefCount' : [ 0xc0, ['unsigned long']],
    'RecoveryInformation' : [ 0xc8, ['pointer64', ['void']]],
    'RecoveryInformationLength' : [ 0xd0, ['unsigned long']],
    'DynamicNameInformation' : [ 0xd8, ['pointer64', ['void']]],
    'DynamicNameInformationLength' : [ 0xe0, ['unsigned long']],
    'FinalNotification' : [ 0xe8, ['pointer64', ['_KTMNOTIFICATION_PACKET']]],
    'SupSubEnlistment' : [ 0xf0, ['pointer64', ['_KENLISTMENT']]],
    'SupSubEnlHandle' : [ 0xf8, ['pointer64', ['void']]],
    'SubordinateTxHandle' : [ 0x100, ['pointer64', ['void']]],
    'CrmEnlistmentEnId' : [ 0x108, ['_GUID']],
    'CrmEnlistmentTmId' : [ 0x118, ['_GUID']],
    'CrmEnlistmentRmId' : [ 0x128, ['_GUID']],
    'NextHistory' : [ 0x138, ['unsigned long']],
    'History' : [ 0x13c, ['array', 20, ['_KENLISTMENT_HISTORY']]],
} ],
  '_THERMAL_POLICY' : [ 0x18, {
    'Version' : [ 0x0, ['unsigned long']],
    'WaitForUpdate' : [ 0x4, ['unsigned char']],
    'Hibernate' : [ 0x5, ['unsigned char']],
    'Critical' : [ 0x6, ['unsigned char']],
    'ThermalStandby' : [ 0x7, ['unsigned char']],
    'ActivationReasons' : [ 0x8, ['unsigned long']],
    'PassiveLimit' : [ 0xc, ['unsigned long']],
    'ActiveLevel' : [ 0x10, ['unsigned long']],
    'OverThrottled' : [ 0x14, ['unsigned char']],
} ],
  '_FILE_GET_QUOTA_INFORMATION' : [ 0x14, {
    'NextEntryOffset' : [ 0x0, ['unsigned long']],
    'SidLength' : [ 0x4, ['unsigned long']],
    'Sid' : [ 0x8, ['_SID']],
} ],
  '_MI_ACCESS_LOG_STATE' : [ 0x80, {
    'CcAccessLog' : [ 0x0, ['pointer64', ['_MM_PAGE_ACCESS_INFO_HEADER']]],
    'DisableAccessLogging' : [ 0x8, ['_WORK_QUEUE_ITEM']],
    'Enabled' : [ 0x28, ['unsigned long']],
    'MinLoggingPriority' : [ 0x2c, ['unsigned long']],
    'AccessLoggingLock' : [ 0x40, ['unsigned long long']],
} ],
  '_HMAP_TABLE' : [ 0x3000, {
    'Table' : [ 0x0, ['array', 512, ['_HMAP_ENTRY']]],
} ],
  '__unnamed_27cf' : [ 0x4, {
    'SnapSharedExportsFailed' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Spare' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 32, native_type='unsigned long')]],
} ],
  '__unnamed_27d1' : [ 0x20, {
    'AllSharedExportThunks' : [ 0x0, ['_VF_TARGET_ALL_SHARED_EXPORT_THUNKS']],
    'Flags' : [ 0x0, ['__unnamed_27cf']],
} ],
  '_VF_TARGET_DRIVER' : [ 0x40, {
    'TreeNode' : [ 0x0, ['_VF_AVL_TREE_NODE_EX']],
    'u1' : [ 0x18, ['__unnamed_27d1']],
    'VerifiedData' : [ 0x38, ['pointer64', ['_VF_TARGET_VERIFIED_DRIVER_DATA']]],
} ],
  '_IO_SECURITY_CONTEXT' : [ 0x18, {
    'SecurityQos' : [ 0x0, ['pointer64', ['_SECURITY_QUALITY_OF_SERVICE']]],
    'AccessState' : [ 0x8, ['pointer64', ['_ACCESS_STATE']]],
    'DesiredAccess' : [ 0x10, ['unsigned long']],
    'FullCreateOptions' : [ 0x14, ['unsigned long']],
} ],
  '_ENERGY_STATE_DURATION' : [ 0x8, {
    'Value' : [ 0x0, ['unsigned long long']],
    'LastChangeTime' : [ 0x0, ['unsigned long']],
    'Duration' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 31, native_type='unsigned long')]],
    'IsInState' : [ 0x4, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
} ],
  '_MI_REVERSE_VIEW_MAP' : [ 0x30, {
    'ViewLinks' : [ 0x0, ['_LIST_ENTRY']],
    'SystemCacheVa' : [ 0x10, ['pointer64', ['void']]],
    'SessionViewVa' : [ 0x10, ['pointer64', ['void']]],
    'VadsProcess' : [ 0x10, ['pointer64', ['_EPROCESS']]],
    'Type' : [ 0x10, ['BitField', dict(start_bit = 0, end_bit = 2, native_type='unsigned long long')]],
    'Subsection' : [ 0x18, ['pointer64', ['_SUBSECTION']]],
    'SubsectionType' : [ 0x18, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'SystemCacheAttributes' : [ 0x20, ['_MI_SYSTEM_CACHE_VIEW_ATTRIBUTES']],
    'SectionOffset' : [ 0x20, ['unsigned long long']],
} ],
  '_MI_SYSTEM_PTE_STATE' : [ 0x200, {
    'MdlTrackerLookaside' : [ 0x0, ['_NPAGED_LOOKASIDE_LIST']],
    'DeadPteTrackerSListHead' : [ 0x80, ['_SLIST_HEADER']],
    'PteTrackerLock' : [ 0x90, ['unsigned long long']],
    'PteTrackingBitmap' : [ 0x98, ['_RTL_BITMAP_EX']],
    'CachedPteHeads' : [ 0xa8, ['pointer64', ['_MI_CACHED_PTES']]],
    'CachedKernelStackPteHeads' : [ 0xb0, ['pointer64', ['_MI_CACHED_PTES']]],
    'SystemViewPteInfo' : [ 0xb8, ['_MI_SYSTEM_PTE_TYPE']],
    'KernelStackPteInfo' : [ 0x118, ['_MI_SYSTEM_PTE_TYPE']],
    'StackGrowthFailures' : [ 0x178, ['unsigned long']],
    'KernelStackPages' : [ 0x17c, ['unsigned char']],
    'TrackPtesAborted' : [ 0x17d, ['unsigned char']],
    'AdjustCounter' : [ 0x17e, ['unsigned char']],
    'ReservedMappingLock' : [ 0x180, ['long']],
    'ReservedMappingTree' : [ 0x188, ['_RTL_AVL_TREE']],
    'ReservedMappingPageTablePfns' : [ 0x190, ['pointer64', ['_MMPFN']]],
    'OutswappedKernelStackRoot' : [ 0x198, ['_RTL_AVL_TREE']],
    'OutswappedKernelStackLock' : [ 0x1a0, ['long']],
    'UltraSpaceContext' : [ 0x1a8, ['_MI_ULTRA_VA_CONTEXT']],
    'NumberOfUltraMdlMaps' : [ 0x1e8, ['unsigned long']],
    'UltraMdlNodeMappings' : [ 0x1f0, ['pointer64', ['_MI_ULTRA_MDL_NODE']]],
} ],
  '__unnamed_27e6' : [ 0x4, {
    'LongFlags' : [ 0x0, ['unsigned long']],
    'Flags' : [ 0x0, ['_MI_PARTITION_FLAGS']],
} ],
  '_MI_PARTITION_CORE' : [ 0x1a8, {
    'PartitionId' : [ 0x0, ['unsigned short']],
    'u' : [ 0x4, ['__unnamed_27e6']],
    'Signature' : [ 0x8, ['unsigned long']],
    'MemoryConfigurationChanged' : [ 0xc, ['unsigned char']],
    'NodeInformation' : [ 0x10, ['pointer64', ['_MI_NODE_INFORMATION']]],
    'PageRoot' : [ 0x18, ['_RTL_AVL_TREE']],
    'MemoryNodeRuns' : [ 0x20, ['pointer64', ['_PHYSICAL_MEMORY_DESCRIPTOR']]],
    'MemoryBlockReferences' : [ 0x28, ['unsigned long long']],
    'PfnUnmapWorkItem' : [ 0x30, ['_WORK_QUEUE_ITEM']],
    'PfnUnmapCount' : [ 0x50, ['unsigned long long']],
    'PfnUnmapWaitList' : [ 0x58, ['pointer64', ['void']]],
    'MemoryRuns' : [ 0x60, ['pointer64', ['_PHYSICAL_MEMORY_DESCRIPTOR']]],
    'ExitEvent' : [ 0x68, ['_KEVENT']],
    'SystemThreadHandles' : [ 0x80, ['array', 5, ['pointer64', ['void']]]],
    'PartitionObject' : [ 0xa8, ['pointer64', ['_EPARTITION']]],
    'PartitionSystemThreadsLock' : [ 0xb0, ['_EX_PUSH_LOCK']],
    'DynamicMemoryPushLock' : [ 0xb8, ['_EX_PUSH_LOCK']],
    'DynamicMemoryLock' : [ 0xc0, ['long']],
    'PfnUnmapActive' : [ 0xc4, ['unsigned char']],
    'TemporaryMemoryEvent' : [ 0xc8, ['_KEVENT']],
    'RootDirectory' : [ 0xe0, ['pointer64', ['void']]],
    'KernelObjectsDirectory' : [ 0xe8, ['pointer64', ['void']]],
    'MemoryEvents' : [ 0xf0, ['array', 11, ['pointer64', ['_KEVENT']]]],
    'MemoryEventHandles' : [ 0x148, ['array', 11, ['pointer64', ['void']]]],
    'NonChargedSecurePages' : [ 0x1a0, ['unsigned long long']],
} ],
  '_KTSS64' : [ 0x68, {
    'Reserved0' : [ 0x0, ['unsigned long']],
    'Rsp0' : [ 0x4, ['unsigned long long']],
    'Rsp1' : [ 0xc, ['unsigned long long']],
    'Rsp2' : [ 0x14, ['unsigned long long']],
    'Ist' : [ 0x1c, ['array', 8, ['unsigned long long']]],
    'Reserved1' : [ 0x5c, ['unsigned long long']],
    'Reserved2' : [ 0x64, ['unsigned short']],
    'IoMapBase' : [ 0x66, ['unsigned short']],
} ],
  '_MMSUPPORT_INSTANCE' : [ 0xc0, {
    'NextPageColor' : [ 0x0, ['unsigned long']],
    'PageFaultCount' : [ 0x4, ['unsigned long']],
    'TrimmedPageCount' : [ 0x8, ['unsigned long long']],
    'VmWorkingSetList' : [ 0x10, ['pointer64', ['_MMWSL_INSTANCE']]],
    'WorkingSetExpansionLinks' : [ 0x18, ['_LIST_ENTRY']],
    'AgeDistribution' : [ 0x28, ['array', 8, ['unsigned long long']]],
    'ExitOutswapGate' : [ 0x68, ['pointer64', ['_KGATE']]],
    'MinimumWorkingSetSize' : [ 0x70, ['unsigned long long']],
    'WorkingSetLeafSize' : [ 0x78, ['unsigned long long']],
    'WorkingSetLeafPrivateSize' : [ 0x80, ['unsigned long long']],
    'WorkingSetSize' : [ 0x88, ['unsigned long long']],
    'WorkingSetPrivateSize' : [ 0x90, ['unsigned long long']],
    'MaximumWorkingSetSize' : [ 0x98, ['unsigned long long']],
    'PeakWorkingSetSize' : [ 0xa0, ['unsigned long long']],
    'HardFaultCount' : [ 0xa8, ['unsigned long']],
    'LastTrimStamp' : [ 0xac, ['unsigned short']],
    'PartitionId' : [ 0xae, ['unsigned short']],
    'SelfmapLock' : [ 0xb0, ['unsigned long long']],
    'Flags' : [ 0xb8, ['_MMSUPPORT_FLAGS']],
} ],
  '_KWAIT_BLOCK' : [ 0x30, {
    'WaitListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'WaitType' : [ 0x10, ['unsigned char']],
    'BlockState' : [ 0x11, ['unsigned char']],
    'WaitKey' : [ 0x12, ['unsigned short']],
    'SpareLong' : [ 0x14, ['long']],
    'Thread' : [ 0x18, ['pointer64', ['_KTHREAD']]],
    'NotificationQueue' : [ 0x18, ['pointer64', ['_KQUEUE']]],
    'Object' : [ 0x20, ['pointer64', ['void']]],
    'SparePtr' : [ 0x28, ['pointer64', ['void']]],
} ],
  '_PPM_SELECTION_MENU_ENTRY' : [ 0x18, {
    'StrictDependency' : [ 0x0, ['unsigned char']],
    'InitiatingState' : [ 0x1, ['unsigned char']],
    'DependentState' : [ 0x2, ['unsigned char']],
    'StateIndex' : [ 0x4, ['unsigned long']],
    'Dependencies' : [ 0x8, ['unsigned long']],
    'DependencyList' : [ 0x10, ['pointer64', ['_PPM_SELECTION_DEPENDENCY']]],
} ],
  '_VPB' : [ 0x60, {
    'Type' : [ 0x0, ['short']],
    'Size' : [ 0x2, ['short']],
    'Flags' : [ 0x4, ['unsigned short']],
    'VolumeLabelLength' : [ 0x6, ['unsigned short']],
    'DeviceObject' : [ 0x8, ['pointer64', ['_DEVICE_OBJECT']]],
    'RealDevice' : [ 0x10, ['pointer64', ['_DEVICE_OBJECT']]],
    'SerialNumber' : [ 0x18, ['unsigned long']],
    'ReferenceCount' : [ 0x1c, ['unsigned long']],
    'VolumeLabel' : [ 0x20, ['array', 32, ['wchar']]],
} ],
  '_MAILSLOT_CREATE_PARAMETERS' : [ 0x18, {
    'MailslotQuota' : [ 0x0, ['unsigned long']],
    'MaximumMessageSize' : [ 0x4, ['unsigned long']],
    'ReadTimeout' : [ 0x8, ['_LARGE_INTEGER']],
    'TimeoutSpecified' : [ 0x10, ['unsigned char']],
} ],
  '_HV_GET_BIN_CONTEXT' : [ 0x2, {
    'OutstandingReference' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
} ],
  '_INVERTED_FUNCTION_TABLE' : [ 0x1810, {
    'CurrentSize' : [ 0x0, ['unsigned long']],
    'MaximumSize' : [ 0x4, ['unsigned long']],
    'Epoch' : [ 0x8, ['unsigned long']],
    'Overflow' : [ 0xc, ['unsigned char']],
    'TableEntry' : [ 0x10, ['array', 256, ['_INVERTED_FUNCTION_TABLE_ENTRY']]],
} ],
  '_POP_FX_PLUGIN' : [ 0xb8, {
    'Link' : [ 0x0, ['_LIST_ENTRY']],
    'Version' : [ 0x10, ['unsigned long']],
    'Flags' : [ 0x18, ['unsigned long long']],
    'WorkQueue' : [ 0x20, ['_KQUEUE']],
    'AcceptDeviceNotification' : [ 0x60, ['pointer64', ['void']]],
    'AcceptProcessorNotification' : [ 0x68, ['pointer64', ['void']]],
    'AcceptAcpiNotification' : [ 0x70, ['pointer64', ['void']]],
    'WorkOrderCount' : [ 0x78, ['unsigned long']],
    'WorkOrders' : [ 0x80, ['array', 1, ['_POP_FX_WORK_ORDER']]],
} ],
  '_MMPTE_PROTOTYPE' : [ 0x8, {
    'Valid' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'DemandFillProto' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long long')]],
    'HiberVerifyConverted' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long long')]],
    'Unused1' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 8, native_type='unsigned long long')]],
    'ReadOnly' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long long')]],
    'Combined' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long long')]],
    'Prototype' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long long')]],
    'Protection' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 16, native_type='unsigned long long')]],
    'ProtoAddress' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 64, native_type='long long')]],
} ],
  '__unnamed_2816' : [ 0x38, {
    'Mdl' : [ 0x0, ['_MDL']],
    'Page' : [ 0x30, ['array', 1, ['unsigned long long']]],
} ],
  '_MI_PAGEFILE_TRACES' : [ 0x78, {
    'Status' : [ 0x0, ['long']],
    'PartitionId' : [ 0x4, ['unsigned short']],
    'Priority' : [ 0x6, ['unsigned char']],
    'IrpPriority' : [ 0x7, ['unsigned char']],
    'ReservationWrite' : [ 0x8, ['unsigned char']],
    'CurrentTime' : [ 0x10, ['_LARGE_INTEGER']],
    'AvailablePages' : [ 0x18, ['unsigned long long']],
    'ModifiedPagesTotal' : [ 0x20, ['unsigned long long']],
    'ModifiedPagefilePages' : [ 0x28, ['unsigned long long']],
    'ModifiedNoWritePages' : [ 0x30, ['unsigned long long']],
    'ModifiedPagefileNoReservationPages' : [ 0x38, ['unsigned long long']],
    'MdlHack' : [ 0x40, ['__unnamed_2816']],
} ],
  '_HAL_LBR_ENTRY' : [ 0x18, {
    'FromAddress' : [ 0x0, ['pointer64', ['void']]],
    'ToAddress' : [ 0x8, ['pointer64', ['void']]],
    'Reserved' : [ 0x10, ['pointer64', ['void']]],
} ],
  '_NT_TIB' : [ 0x38, {
    'ExceptionList' : [ 0x0, ['pointer64', ['_EXCEPTION_REGISTRATION_RECORD']]],
    'StackBase' : [ 0x8, ['pointer64', ['void']]],
    'StackLimit' : [ 0x10, ['pointer64', ['void']]],
    'SubSystemTib' : [ 0x18, ['pointer64', ['void']]],
    'FiberData' : [ 0x20, ['pointer64', ['void']]],
    'Version' : [ 0x20, ['unsigned long']],
    'ArbitraryUserPointer' : [ 0x28, ['pointer64', ['void']]],
    'Self' : [ 0x30, ['pointer64', ['_NT_TIB']]],
} ],
  '_ETW_REG_ENTRY' : [ 0x70, {
    'RegList' : [ 0x0, ['_LIST_ENTRY']],
    'GroupRegList' : [ 0x10, ['_LIST_ENTRY']],
    'GuidEntry' : [ 0x20, ['pointer64', ['_ETW_GUID_ENTRY']]],
    'GroupEntry' : [ 0x28, ['pointer64', ['_ETW_GUID_ENTRY']]],
    'ReplyQueue' : [ 0x30, ['pointer64', ['_ETW_REPLY_QUEUE']]],
    'ReplySlot' : [ 0x30, ['array', 4, ['pointer64', ['_ETW_QUEUE_ENTRY']]]],
    'Caller' : [ 0x30, ['pointer64', ['void']]],
    'SessionId' : [ 0x38, ['unsigned long']],
    'Process' : [ 0x50, ['pointer64', ['_EPROCESS']]],
    'CallbackContext' : [ 0x50, ['pointer64', ['void']]],
    'Callback' : [ 0x58, ['pointer64', ['void']]],
    'Index' : [ 0x60, ['unsigned short']],
    'Flags' : [ 0x62, ['unsigned short']],
    'DbgKernelRegistration' : [ 0x62, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
    'DbgUserRegistration' : [ 0x62, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned short')]],
    'DbgReplyRegistration' : [ 0x62, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned short')]],
    'DbgClassicRegistration' : [ 0x62, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned short')]],
    'DbgSessionSpaceRegistration' : [ 0x62, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned short')]],
    'DbgModernRegistration' : [ 0x62, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned short')]],
    'DbgClosed' : [ 0x62, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned short')]],
    'DbgInserted' : [ 0x62, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned short')]],
    'DbgWow64' : [ 0x62, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned short')]],
    'DbgUseDescriptorType' : [ 0x62, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned short')]],
    'DbgDropProviderTraits' : [ 0x62, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned short')]],
    'EnableMask' : [ 0x64, ['unsigned char']],
    'GroupEnableMask' : [ 0x65, ['unsigned char']],
    'Traits' : [ 0x68, ['pointer64', ['_ETW_PROVIDER_TRAITS']]],
} ],
  '_TERMINATION_PORT' : [ 0x10, {
    'Next' : [ 0x0, ['pointer64', ['_TERMINATION_PORT']]],
    'Port' : [ 0x8, ['pointer64', ['void']]],
} ],
  '_HAL_DP_REPLACE_PARAMETERS' : [ 0x18, {
    'Flags' : [ 0x0, ['unsigned long']],
    'TargetProcessors' : [ 0x8, ['pointer64', ['_PNP_REPLACE_PROCESSOR_LIST']]],
    'SpareProcessors' : [ 0x10, ['pointer64', ['_PNP_REPLACE_PROCESSOR_LIST']]],
} ],
  '_MI_COMBINE_WORKITEM' : [ 0x28, {
    'NextEntry' : [ 0x0, ['pointer64', ['void']]],
    'WorkItem' : [ 0x8, ['_WORK_QUEUE_ITEM']],
} ],
  '_PS_INTERLOCKED_TIMER_DELAY_VALUES' : [ 0x8, {
    'DelayMs' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 30, native_type='unsigned long long')]],
    'CoalescingWindowMs' : [ 0x0, ['BitField', dict(start_bit = 30, end_bit = 60, native_type='unsigned long long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 60, end_bit = 61, native_type='unsigned long long')]],
    'NewTimerWheel' : [ 0x0, ['BitField', dict(start_bit = 61, end_bit = 62, native_type='unsigned long long')]],
    'Retry' : [ 0x0, ['BitField', dict(start_bit = 62, end_bit = 63, native_type='unsigned long long')]],
    'Locked' : [ 0x0, ['BitField', dict(start_bit = 63, end_bit = 64, native_type='unsigned long long')]],
    'All' : [ 0x0, ['unsigned long long']],
} ],
  '_POWER_SEQUENCE' : [ 0xc, {
    'SequenceD1' : [ 0x0, ['unsigned long']],
    'SequenceD2' : [ 0x4, ['unsigned long']],
    'SequenceD3' : [ 0x8, ['unsigned long']],
} ],
  '_STRING32' : [ 0x8, {
    'Length' : [ 0x0, ['unsigned short']],
    'MaximumLength' : [ 0x2, ['unsigned short']],
    'Buffer' : [ 0x4, ['unsigned long']],
} ],
  '_MI_SYSTEM_VA_STATE' : [ 0x500, {
    'SystemTablesLock' : [ 0x0, ['unsigned long long']],
    'AvailableSystemCacheVa' : [ 0x8, ['unsigned long long']],
    'DynamicBitMapKernelStacks' : [ 0x10, ['_MI_DYNAMIC_BITMAP']],
    'DynamicBitMapSystemPtes' : [ 0x58, ['_MI_DYNAMIC_BITMAP']],
    'DynamicBitMapDriverImages' : [ 0xa0, ['array', 2, ['_MI_DYNAMIC_BITMAP']]],
    'DynamicBitMapPagedPool' : [ 0x130, ['_MI_DYNAMIC_BITMAP']],
    'DynamicBitMapSpecialPool' : [ 0x178, ['array', 2, ['_MI_DYNAMIC_BITMAP']]],
    'DynamicBitMapSystemCache' : [ 0x208, ['_MI_DYNAMIC_BITMAP']],
    'HalPrivateVaStart' : [ 0x250, ['pointer64', ['void']]],
    'HalPrivateVaSize' : [ 0x258, ['unsigned long long']],
    'SystemVaAssignment' : [ 0x260, ['array', 8, ['unsigned long']]],
    'SystemVaAssignmentHint' : [ 0x280, ['unsigned long']],
    'TopLevelPteLockBits' : [ 0x284, ['array', 32, ['unsigned long']]],
    'DeleteKvaLock' : [ 0x304, ['long']],
    'WsleArrays' : [ 0x308, ['array', 8, ['pointer64', ['_MI_WSLE']]]],
    'PagableHyperSpace' : [ 0x348, ['pointer64', ['_MI_HYPER_SPACE']]],
    'HyperSpaceEnd' : [ 0x350, ['pointer64', ['void']]],
    'FreeSystemCacheVa' : [ 0x358, ['_KEVENT']],
    'SystemVaLock' : [ 0x370, ['unsigned long long']],
    'SystemCacheViewLock' : [ 0x378, ['unsigned long long']],
    'SystemWorkingSetList' : [ 0x380, ['array', 8, ['_MMWSL_INSTANCE']]],
    'SelfmapLock' : [ 0x4c0, ['array', 4, ['unsigned long long']]],
} ],
  '_WHEA_ERROR_RECORD_HEADER' : [ 0x80, {
    'Signature' : [ 0x0, ['unsigned long']],
    'Revision' : [ 0x4, ['_WHEA_REVISION']],
    'SignatureEnd' : [ 0x6, ['unsigned long']],
    'SectionCount' : [ 0xa, ['unsigned short']],
    'Severity' : [ 0xc, ['Enumeration', dict(target = 'long', choices = {0: u'WheaErrSevRecoverable', 1: u'WheaErrSevFatal', 2: u'WheaErrSevCorrected', 3: u'WheaErrSevInformational'})]],
    'ValidBits' : [ 0x10, ['_WHEA_ERROR_RECORD_HEADER_VALIDBITS']],
    'Length' : [ 0x14, ['unsigned long']],
    'Timestamp' : [ 0x18, ['_WHEA_TIMESTAMP']],
    'PlatformId' : [ 0x20, ['_GUID']],
    'PartitionId' : [ 0x30, ['_GUID']],
    'CreatorId' : [ 0x40, ['_GUID']],
    'NotifyType' : [ 0x50, ['_GUID']],
    'RecordId' : [ 0x60, ['unsigned long long']],
    'Flags' : [ 0x68, ['_WHEA_ERROR_RECORD_HEADER_FLAGS']],
    'PersistenceInfo' : [ 0x6c, ['_WHEA_PERSISTENCE_INFO']],
    'Reserved' : [ 0x74, ['array', 12, ['unsigned char']]],
} ],
  '_EXCEPTION_REGISTRATION_RECORD' : [ 0x10, {
    'Next' : [ 0x0, ['pointer64', ['_EXCEPTION_REGISTRATION_RECORD']]],
    'Handler' : [ 0x8, ['pointer64', ['void']]],
} ],
  '_GDI_TEB_BATCH' : [ 0x4e8, {
    'Offset' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 31, native_type='unsigned long')]],
    'HasRenderingCommand' : [ 0x0, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
    'HDC' : [ 0x8, ['unsigned long long']],
    'Buffer' : [ 0x10, ['array', 310, ['unsigned long']]],
} ],
  '_MMSUPPORT_SHARED' : [ 0x50, {
    'WorkingSetLock' : [ 0x0, ['long']],
    'GoodCitizenWaiting' : [ 0x4, ['long']],
    'ReleasedCommitDebt' : [ 0x8, ['unsigned long long']],
    'ResetPagesRepurposedCount' : [ 0x10, ['unsigned long long']],
    'WsSwapSupport' : [ 0x18, ['pointer64', ['void']]],
    'CommitReleaseContext' : [ 0x20, ['pointer64', ['void']]],
    'WorkingSetCoreLock' : [ 0x28, ['long']],
    'AccessLog' : [ 0x30, ['pointer64', ['void']]],
    'ChargedWslePages' : [ 0x38, ['unsigned long long']],
    'ActualWslePages' : [ 0x40, ['unsigned long long']],
    'ShadowMapping' : [ 0x48, ['pointer64', ['void']]],
} ],
  '_ETW_SYSTEM_LOGGER' : [ 0x2, {
    'LoggerId' : [ 0x0, ['unsigned char']],
    'ClockType' : [ 0x1, ['unsigned char']],
} ],
  '_EXT_IOMMU_DEVICE_ID_ACPI' : [ 0x8, {
    'ObjectName' : [ 0x0, ['pointer64', ['unsigned char']]],
} ],
  '_ALPC_COMPLETION_LIST_HEADER' : [ 0x180, {
    'StartMagic' : [ 0x0, ['unsigned long long']],
    'TotalSize' : [ 0x8, ['unsigned long']],
    'ListOffset' : [ 0xc, ['unsigned long']],
    'ListSize' : [ 0x10, ['unsigned long']],
    'BitmapOffset' : [ 0x14, ['unsigned long']],
    'BitmapSize' : [ 0x18, ['unsigned long']],
    'DataOffset' : [ 0x1c, ['unsigned long']],
    'DataSize' : [ 0x20, ['unsigned long']],
    'AttributeFlags' : [ 0x24, ['unsigned long']],
    'AttributeSize' : [ 0x28, ['unsigned long']],
    'State' : [ 0x40, ['_ALPC_COMPLETION_LIST_STATE']],
    'LastMessageId' : [ 0x48, ['unsigned long']],
    'LastCallbackId' : [ 0x4c, ['unsigned long']],
    'PostCount' : [ 0x80, ['unsigned long']],
    'ReturnCount' : [ 0xc0, ['unsigned long']],
    'LogSequenceNumber' : [ 0x100, ['unsigned long']],
    'UserLock' : [ 0x140, ['_RTL_SRWLOCK']],
    'EndMagic' : [ 0x148, ['unsigned long long']],
} ],
  '_CM_INDEX_HINT_BLOCK' : [ 0x8, {
    'Count' : [ 0x0, ['unsigned long']],
    'HashKey' : [ 0x4, ['array', 1, ['unsigned long']]],
} ],
  '_AER_BRIDGE_DESCRIPTOR_FLAGS' : [ 0x2, {
    'UncorrectableErrorMaskRW' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
    'UncorrectableErrorSeverityRW' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned short')]],
    'CorrectableErrorMaskRW' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned short')]],
    'AdvancedCapsAndControlRW' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned short')]],
    'SecondaryUncorrectableErrorMaskRW' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned short')]],
    'SecondaryUncorrectableErrorSevRW' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned short')]],
    'SecondaryCapsAndControlRW' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned short')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 16, native_type='unsigned short')]],
    'AsUSHORT' : [ 0x0, ['unsigned short']],
} ],
  '_PNP_REPLACE_PROCESSOR_LIST' : [ 0x18, {
    'Affinity' : [ 0x0, ['pointer64', ['unsigned long long']]],
    'GroupCount' : [ 0x8, ['unsigned long']],
    'AllocatedCount' : [ 0xc, ['unsigned long']],
    'Count' : [ 0x10, ['unsigned long']],
    'ApicIds' : [ 0x14, ['array', 1, ['unsigned long']]],
} ],
  '_MI_ULTRA_VA_CONTEXT' : [ 0x40, {
    'Lock' : [ 0x0, ['unsigned long long']],
    'ZeroMapping' : [ 0x8, ['pointer64', ['void']]],
    'AllocationHintBit' : [ 0x10, ['unsigned long long']],
    'Bitmap' : [ 0x18, ['array', 2, ['_RTL_BITMAP_EX']]],
    'ConcurrencyMaximum' : [ 0x38, ['long']],
    'ConcurrencyCount' : [ 0x3c, ['long']],
} ],
  '_ETW_HW_TRACE_EXT_INTERFACE' : [ 0x18, {
    'StartProcessorTraceOnEachCore' : [ 0x0, ['pointer64', ['void']]],
    'StopProcessorTraceOnEachCore' : [ 0x8, ['pointer64', ['void']]],
    'LogProcessorTraceOnCurrentCore' : [ 0x10, ['pointer64', ['void']]],
} ],
  '_PS_CLIENT_SECURITY_CONTEXT' : [ 0x8, {
    'ImpersonationData' : [ 0x0, ['unsigned long long']],
    'ImpersonationToken' : [ 0x0, ['pointer64', ['void']]],
    'ImpersonationLevel' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 2, native_type='unsigned long long')]],
    'EffectiveOnly' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long long')]],
} ],
  '_ALPC_COMPLETION_PACKET_LOOKASIDE_ENTRY' : [ 0x18, {
    'ListEntry' : [ 0x0, ['_SINGLE_LIST_ENTRY']],
    'Packet' : [ 0x8, ['pointer64', ['_IO_MINI_COMPLETION_PACKET_USER']]],
    'Lookaside' : [ 0x10, ['pointer64', ['_ALPC_COMPLETION_PACKET_LOOKASIDE']]],
} ],
  '_DBGKD_GET_CONTEXT' : [ 0x4, {
    'Unused' : [ 0x0, ['unsigned long']],
} ],
  '_STRING64' : [ 0x10, {
    'Length' : [ 0x0, ['unsigned short']],
    'MaximumLength' : [ 0x2, ['unsigned short']],
    'Buffer' : [ 0x8, ['unsigned long long']],
} ],
  '_HEAP_STOP_ON_TAG' : [ 0x4, {
    'HeapAndTagIndex' : [ 0x0, ['unsigned long']],
    'TagIndex' : [ 0x0, ['unsigned short']],
    'HeapIndex' : [ 0x2, ['unsigned short']],
} ],
  '_ASYNC_READ_THREAD_STATS' : [ 0x194, {
    'CurrentLoad' : [ 0x0, ['array', 101, ['unsigned long']]],
} ],
  '_X86_DBGKD_CONTROL_SET' : [ 0x10, {
    'TraceFlag' : [ 0x0, ['unsigned long']],
    'Dr7' : [ 0x4, ['unsigned long']],
    'CurrentSymbolStart' : [ 0x8, ['unsigned long']],
    'CurrentSymbolEnd' : [ 0xc, ['unsigned long']],
} ],
  '_PO_IRP_MANAGER' : [ 0x20, {
    'DeviceIrpQueue' : [ 0x0, ['_PO_IRP_QUEUE']],
    'SystemIrpQueue' : [ 0x10, ['_PO_IRP_QUEUE']],
} ],
  '_CM_RESOURCE_LIST' : [ 0x28, {
    'Count' : [ 0x0, ['unsigned long']],
    'List' : [ 0x4, ['array', 1, ['_CM_FULL_RESOURCE_DESCRIPTOR']]],
} ],
  '_KWAIT_STATUS_REGISTER' : [ 0x1, {
    'Flags' : [ 0x0, ['unsigned char']],
    'State' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 3, native_type='unsigned char')]],
    'Affinity' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'Priority' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'Apc' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'UserApc' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned char')]],
    'Alert' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
} ],
  '_MI_LARGE_PAGE_CANDIDATES' : [ 0x208, {
    'Hand' : [ 0x0, ['unsigned short']],
    'ActiveEntryCount' : [ 0x2, ['unsigned short']],
    'Overflowed' : [ 0x4, ['unsigned char']],
    'PageFrames' : [ 0x8, ['array', 64, ['unsigned long long']]],
} ],
  '_MMCLONE_BLOCK' : [ 0x20, {
    'ProtoPte' : [ 0x0, ['_MMPTE']],
    'CrossPartitionReferences' : [ 0x8, ['unsigned long long']],
    'CloneCommitCount' : [ 0x10, ['unsigned long long']],
    'u1' : [ 0x10, ['_MI_CLONE_BLOCK_FLAGS']],
    'CloneRefCount' : [ 0x18, ['unsigned long long']],
} ],
  '_TEB_ACTIVE_FRAME_CONTEXT' : [ 0x10, {
    'Flags' : [ 0x0, ['unsigned long']],
    'FrameName' : [ 0x8, ['pointer64', ['unsigned char']]],
} ],
  '_EXT_IOMMU_DEVICE_ID_TEST' : [ 0x8, {
    'UniqueId' : [ 0x0, ['unsigned long long']],
} ],
  '_WHEA_ERROR_RECORD_SECTION_DESCRIPTOR_FLAGS' : [ 0x4, {
    'Primary' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'ContainmentWarning' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'Reset' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'ThresholdExceeded' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'ResourceNotAvailable' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'LatentError' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'Propagated' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 32, native_type='unsigned long')]],
    'AsULONG' : [ 0x0, ['unsigned long']],
} ],
  '_PS_TRUSTLET_TKSESSION_ID' : [ 0x20, {
    'SessionId' : [ 0x0, ['array', 4, ['unsigned long long']]],
} ],
  '__unnamed_28a1' : [ 0x8, {
    'ControlArea' : [ 0x0, ['pointer64', ['_CONTROL_AREA']]],
    'FileObject' : [ 0x0, ['pointer64', ['_FILE_OBJECT']]],
    'RemoteImageFileObject' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'RemoteDataFileObject' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long long')]],
} ],
  '_SECTION' : [ 0x40, {
    'SectionNode' : [ 0x0, ['_RTL_BALANCED_NODE']],
    'StartingVpn' : [ 0x18, ['unsigned long long']],
    'EndingVpn' : [ 0x20, ['unsigned long long']],
    'u1' : [ 0x28, ['__unnamed_28a1']],
    'SizeOfSection' : [ 0x30, ['unsigned long long']],
    'u' : [ 0x38, ['__unnamed_1769']],
    'InitialPageProtection' : [ 0x3c, ['BitField', dict(start_bit = 0, end_bit = 12, native_type='unsigned long')]],
    'SessionId' : [ 0x3c, ['BitField', dict(start_bit = 12, end_bit = 31, native_type='unsigned long')]],
    'NoValidationNeeded' : [ 0x3c, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
} ],
  '_FAST_OWNER_ENTRY' : [ 0x48, {
    'Reserved' : [ 0x0, ['array', 9, ['pointer64', ['void']]]],
} ],
  '_PNP_DEVICE_EVENT_ENTRY' : [ 0xc0, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'Argument' : [ 0x10, ['unsigned long']],
    'ArgumentStatus' : [ 0x14, ['long']],
    'CallerEvent' : [ 0x18, ['pointer64', ['_KEVENT']]],
    'Callback' : [ 0x20, ['pointer64', ['void']]],
    'Context' : [ 0x28, ['pointer64', ['void']]],
    'VetoType' : [ 0x30, ['pointer64', ['Enumeration', dict(target = 'long', choices = {0: u'PNP_VetoTypeUnknown', 1: u'PNP_VetoLegacyDevice', 2: u'PNP_VetoPendingClose', 3: u'PNP_VetoWindowsApp', 4: u'PNP_VetoWindowsService', 5: u'PNP_VetoOutstandingOpen', 6: u'PNP_VetoDevice', 7: u'PNP_VetoDriver', 8: u'PNP_VetoIllegalDeviceRequest', 9: u'PNP_VetoInsufficientPower', 10: u'PNP_VetoNonDisableable', 11: u'PNP_VetoLegacyDriver', 12: u'PNP_VetoInsufficientRights'})]]],
    'VetoName' : [ 0x38, ['pointer64', ['_UNICODE_STRING']]],
    'RefCount' : [ 0x40, ['unsigned long']],
    'Lock' : [ 0x44, ['unsigned long']],
    'Cancel' : [ 0x48, ['unsigned char']],
    'Parent' : [ 0x50, ['pointer64', ['_PNP_DEVICE_EVENT_ENTRY']]],
    'ActivityId' : [ 0x58, ['_GUID']],
    'Watchdog' : [ 0x68, ['pointer64', ['_PNP_WATCHDOG']]],
    'Data' : [ 0x70, ['_PLUGPLAY_EVENT_BLOCK']],
} ],
  '_HEAP_GLOBAL_APPCOMPAT_FLAGS' : [ 0x4, {
    'SafeInputValidation' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Padding' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'CommitLFHSubsegments' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'AllocateHeapFromEnv' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
} ],
  '_PO_DIAG_STACK_RECORD' : [ 0x10, {
    'StackDepth' : [ 0x0, ['unsigned long']],
    'Stack' : [ 0x8, ['array', 1, ['pointer64', ['void']]]],
} ],
  '_PROCESS_ENERGY_VALUES_EXTENSION' : [ 0xa0, {
    'Timelines' : [ 0x0, ['array', 14, ['_TIMELINE_BITMAP']]],
    'CpuTimeline' : [ 0x0, ['_TIMELINE_BITMAP']],
    'DiskTimeline' : [ 0x8, ['_TIMELINE_BITMAP']],
    'NetworkTimeline' : [ 0x10, ['_TIMELINE_BITMAP']],
    'MBBTimeline' : [ 0x18, ['_TIMELINE_BITMAP']],
    'ForegroundTimeline' : [ 0x20, ['_TIMELINE_BITMAP']],
    'DesktopVisibleTimeline' : [ 0x28, ['_TIMELINE_BITMAP']],
    'CompositionRenderedTimeline' : [ 0x30, ['_TIMELINE_BITMAP']],
    'CompositionDirtyGeneratedTimeline' : [ 0x38, ['_TIMELINE_BITMAP']],
    'CompositionDirtyPropagatedTimeline' : [ 0x40, ['_TIMELINE_BITMAP']],
    'InputTimeline' : [ 0x48, ['_TIMELINE_BITMAP']],
    'AudioInTimeline' : [ 0x50, ['_TIMELINE_BITMAP']],
    'AudioOutTimeline' : [ 0x58, ['_TIMELINE_BITMAP']],
    'DisplayRequiredTimeline' : [ 0x60, ['_TIMELINE_BITMAP']],
    'KeyboardInputTimeline' : [ 0x68, ['_TIMELINE_BITMAP']],
    'Durations' : [ 0x70, ['array', 5, ['_ENERGY_STATE_DURATION']]],
    'InputDuration' : [ 0x70, ['_ENERGY_STATE_DURATION']],
    'AudioInDuration' : [ 0x78, ['_ENERGY_STATE_DURATION']],
    'AudioOutDuration' : [ 0x80, ['_ENERGY_STATE_DURATION']],
    'DisplayRequiredDuration' : [ 0x88, ['_ENERGY_STATE_DURATION']],
    'PSMBackgroundDuration' : [ 0x90, ['_ENERGY_STATE_DURATION']],
    'KeyboardInput' : [ 0x98, ['unsigned long']],
    'MouseInput' : [ 0x9c, ['unsigned long']],
} ],
  '_MI_LDW_WORK_CONTEXT' : [ 0x38, {
    'WorkItem' : [ 0x0, ['_WORK_QUEUE_ITEM']],
    'FileObject' : [ 0x20, ['pointer64', ['_FILE_OBJECT']]],
    'ErrorStatus' : [ 0x28, ['long']],
    'Active' : [ 0x2c, ['long']],
    'FreeWhenDone' : [ 0x30, ['unsigned char']],
} ],
  '_MI_PAGE_COMBINE_STATISTICS' : [ 0x28, {
    'PagesScannedActive' : [ 0x0, ['unsigned long long']],
    'PagesScannedStandby' : [ 0x8, ['unsigned long long']],
    'PagesCombined' : [ 0x10, ['unsigned long long']],
    'CombineScanCount' : [ 0x18, ['unsigned long']],
    'CombinedBlocksInUse' : [ 0x1c, ['long']],
    'SumCombinedBlocksReferenceCount' : [ 0x20, ['long']],
} ],
  '_MI_DEBUGGER_STATE' : [ 0x118, {
    'TransientWrite' : [ 0x0, ['unsigned char']],
    'CodePageEdited' : [ 0x1, ['unsigned char']],
    'DebugPte' : [ 0x8, ['pointer64', ['_MMPTE']]],
    'PoisonedTb' : [ 0x10, ['unsigned long']],
    'InDebugger' : [ 0x14, ['long']],
    'Pfns' : [ 0x18, ['array', 32, ['pointer64', ['void']]]],
} ],
  '_KLOCK_ENTRY_LOCK_STATE' : [ 0x10, {
    'CrossThreadReleasable' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'Busy' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 63, native_type='unsigned long long')]],
    'InTree' : [ 0x0, ['BitField', dict(start_bit = 63, end_bit = 64, native_type='unsigned long long')]],
    'LockState' : [ 0x0, ['pointer64', ['void']]],
    'SessionState' : [ 0x8, ['pointer64', ['void']]],
    'SessionId' : [ 0x8, ['unsigned long']],
    'SessionPad' : [ 0xc, ['unsigned long']],
} ],
  '_RTL_RANGE' : [ 0x28, {
    'Start' : [ 0x0, ['unsigned long long']],
    'End' : [ 0x8, ['unsigned long long']],
    'UserData' : [ 0x10, ['pointer64', ['void']]],
    'Owner' : [ 0x18, ['pointer64', ['void']]],
    'Attributes' : [ 0x20, ['unsigned char']],
    'Flags' : [ 0x21, ['unsigned char']],
} ],
  '_FILE_NETWORK_OPEN_INFORMATION' : [ 0x38, {
    'CreationTime' : [ 0x0, ['_LARGE_INTEGER']],
    'LastAccessTime' : [ 0x8, ['_LARGE_INTEGER']],
    'LastWriteTime' : [ 0x10, ['_LARGE_INTEGER']],
    'ChangeTime' : [ 0x18, ['_LARGE_INTEGER']],
    'AllocationSize' : [ 0x20, ['_LARGE_INTEGER']],
    'EndOfFile' : [ 0x28, ['_LARGE_INTEGER']],
    'FileAttributes' : [ 0x30, ['unsigned long']],
} ],
  '_ETIMER' : [ 0x138, {
    'KeTimer' : [ 0x0, ['_KTIMER']],
    'Lock' : [ 0x40, ['unsigned long long']],
    'TimerApc' : [ 0x48, ['_KAPC']],
    'TimerDpc' : [ 0xa0, ['_KDPC']],
    'ActiveTimerListEntry' : [ 0xe0, ['_LIST_ENTRY']],
    'Period' : [ 0xf0, ['unsigned long']],
    'TimerFlags' : [ 0xf4, ['unsigned char']],
    'ApcAssociated' : [ 0xf4, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'FlushDpcs' : [ 0xf4, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'Paused' : [ 0xf4, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'Spare1' : [ 0xf4, ['BitField', dict(start_bit = 3, end_bit = 8, native_type='unsigned char')]],
    'DueTimeType' : [ 0xf5, ['unsigned char']],
    'Spare2' : [ 0xf6, ['unsigned short']],
    'WakeReason' : [ 0xf8, ['pointer64', ['_DIAGNOSTIC_CONTEXT']]],
    'WakeTimerListEntry' : [ 0x100, ['_LIST_ENTRY']],
    'VirtualizedTimerCookie' : [ 0x110, ['pointer64', ['void']]],
    'VirtualizedTimerLinks' : [ 0x118, ['_LIST_ENTRY']],
    'DueTime' : [ 0x128, ['unsigned long long']],
    'CoalescingWindow' : [ 0x130, ['unsigned long']],
} ],
  '_MI_SHUTDOWN_STATE' : [ 0x78, {
    'CrashDumpInitialized' : [ 0x0, ['unsigned char']],
    'ConnectedStandbyActive' : [ 0x1, ['unsigned char']],
    'ZeroPageFileAtShutdown' : [ 0x2, ['unsigned char']],
    'SystemShutdown' : [ 0x4, ['unsigned long']],
    'ShutdownFlushInProgress' : [ 0x8, ['long']],
    'MirroringActive' : [ 0xc, ['unsigned long']],
    'ResumeItem' : [ 0x10, ['_MI_RESUME_WORKITEM']],
    'MirrorHoldsPfn' : [ 0x48, ['pointer64', ['_ETHREAD']]],
    'MirrorBitMaps' : [ 0x50, ['array', 2, ['_RTL_BITMAP_EX']]],
    'CrashDumpPte' : [ 0x70, ['pointer64', ['_MMPTE']]],
} ],
  '_WHEA_IPF_CPE_DESCRIPTOR' : [ 0x4, {
    'Type' : [ 0x0, ['unsigned short']],
    'Enabled' : [ 0x2, ['unsigned char']],
    'Reserved' : [ 0x3, ['unsigned char']],
} ],
  '_VI_TRACK_IRQL' : [ 0x38, {
    'Thread' : [ 0x0, ['pointer64', ['void']]],
    'OldIrql' : [ 0x8, ['unsigned char']],
    'NewIrql' : [ 0x9, ['unsigned char']],
    'Processor' : [ 0xa, ['unsigned short']],
    'TickCount' : [ 0xc, ['unsigned long']],
    'StackTrace' : [ 0x10, ['array', 5, ['pointer64', ['void']]]],
} ],
  '_ETW_PRIV_HANDLE_DEMUX_TABLE' : [ 0x20, {
    'Tree' : [ 0x0, ['_RTL_RB_TREE']],
    'Lock' : [ 0x10, ['_EX_PUSH_LOCK']],
    'SequenceNumber' : [ 0x18, ['unsigned short']],
} ],
  '_ARM64_DBGKD_CONTROL_SET' : [ 0x18, {
    'Continue' : [ 0x0, ['unsigned long']],
    'TraceFlag' : [ 0x4, ['unsigned long']],
    'CurrentSymbolStart' : [ 0x8, ['unsigned long long']],
    'CurrentSymbolEnd' : [ 0x10, ['unsigned long long']],
} ],
  '_OWNER_ENTRY' : [ 0x10, {
    'OwnerThread' : [ 0x0, ['unsigned long long']],
    'IoPriorityBoosted' : [ 0x8, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'OwnerReferenced' : [ 0x8, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'IoQoSPriorityBoosted' : [ 0x8, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'OwnerCount' : [ 0x8, ['BitField', dict(start_bit = 3, end_bit = 32, native_type='unsigned long')]],
    'TableSize' : [ 0x8, ['unsigned long']],
} ],
  '_CM_KEY_HASH_TABLE_ENTRY' : [ 0x18, {
    'Lock' : [ 0x0, ['_EX_PUSH_LOCK']],
    'Owner' : [ 0x8, ['pointer64', ['_KTHREAD']]],
    'Entry' : [ 0x10, ['pointer64', ['_CM_KEY_HASH']]],
} ],
  '_XPF_MCE_FLAGS' : [ 0x4, {
    'MCG_CapabilityRW' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'MCG_GlobalControlRW' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 32, native_type='unsigned long')]],
    'AsULONG' : [ 0x0, ['unsigned long']],
} ],
  '_PERIODIC_CAPTURE_STATE_GUIDS' : [ 0x10, {
    'ProviderCount' : [ 0x0, ['unsigned short']],
    'Providers' : [ 0x8, ['pointer64', ['_GUID']]],
} ],
  '_HEAP_FREE_ENTRY_EXTRA' : [ 0x4, {
    'TagIndex' : [ 0x0, ['unsigned short']],
    'FreeBackTraceIndex' : [ 0x2, ['unsigned short']],
} ],
  '_SE_AUDIT_PROCESS_CREATION_INFO' : [ 0x8, {
    'ImageFileName' : [ 0x0, ['pointer64', ['_OBJECT_NAME_INFORMATION']]],
} ],
  '_ACTIVATION_CONTEXT_STACK64' : [ 0x28, {
    'ActiveFrame' : [ 0x0, ['unsigned long long']],
    'FrameListCache' : [ 0x8, ['LIST_ENTRY64']],
    'Flags' : [ 0x18, ['unsigned long']],
    'NextCookieSequenceNumber' : [ 0x1c, ['unsigned long']],
    'StackId' : [ 0x20, ['unsigned long']],
} ],
  '_PROCESSOR_POWER_STATE' : [ 0x200, {
    'IdleStates' : [ 0x0, ['pointer64', ['_PPM_IDLE_STATES']]],
    'IdleAccounting' : [ 0x8, ['pointer64', ['_PROC_IDLE_ACCOUNTING']]],
    'IdleTimeLast' : [ 0x10, ['unsigned long long']],
    'IdleTimeTotal' : [ 0x18, ['unsigned long long']],
    'IdleTimeEntry' : [ 0x20, ['unsigned long long']],
    'IdleTimeExpiration' : [ 0x28, ['unsigned long long']],
    'NonInterruptibleTransition' : [ 0x30, ['unsigned char']],
    'PepWokenTransition' : [ 0x31, ['unsigned char']],
    'EfficiencyClass' : [ 0x32, ['unsigned char']],
    'SchedulingClass' : [ 0x33, ['unsigned char']],
    'TargetIdleState' : [ 0x34, ['unsigned long']],
    'IdlePolicy' : [ 0x38, ['_PROC_IDLE_POLICY']],
    'Synchronization' : [ 0x40, ['_PPM_IDLE_SYNCHRONIZATION_STATE']],
    'PerfFeedback' : [ 0x48, ['_PROC_FEEDBACK']],
    'Hypervisor' : [ 0xd8, ['Enumeration', dict(target = 'long', choices = {0: u'ProcHypervisorNone', 1: u'ProcHypervisorPresent', 2: u'ProcHypervisorPower', 3: u'ProcHypervisorHvCounters'})]],
    'LastSysTime' : [ 0xdc, ['unsigned long']],
    'WmiDispatchPtr' : [ 0xe0, ['unsigned long long']],
    'WmiInterfaceEnabled' : [ 0xe8, ['long']],
    'FFHThrottleStateInfo' : [ 0xf0, ['_PPM_FFH_THROTTLE_STATE_INFO']],
    'PerfActionDpc' : [ 0x110, ['_KDPC']],
    'PerfActionMask' : [ 0x150, ['long']],
    'HvIdleCheck' : [ 0x158, ['_PROC_IDLE_SNAP']],
    'PerfCheck' : [ 0x168, ['pointer64', ['_PROC_PERF_CHECK']]],
    'Domain' : [ 0x170, ['pointer64', ['_PROC_PERF_DOMAIN']]],
    'PerfConstraint' : [ 0x178, ['pointer64', ['_PROC_PERF_CONSTRAINT']]],
    'Concurrency' : [ 0x180, ['pointer64', ['_PPM_CONCURRENCY_ACCOUNTING']]],
    'ClassConcurrency' : [ 0x188, ['pointer64', ['_PPM_CONCURRENCY_ACCOUNTING']]],
    'Load' : [ 0x190, ['pointer64', ['_PROC_PERF_LOAD']]],
    'PerfHistory' : [ 0x198, ['pointer64', ['_PROC_PERF_HISTORY']]],
    'GuaranteedPerformancePercent' : [ 0x1a0, ['unsigned char']],
    'HvTargetState' : [ 0x1a1, ['unsigned char']],
    'Parked' : [ 0x1a2, ['unsigned char']],
    'LongPriorQosPeriod' : [ 0x1a3, ['unsigned char']],
    'LatestPerformancePercent' : [ 0x1a4, ['unsigned long']],
    'AveragePerformancePercent' : [ 0x1a8, ['unsigned long']],
    'LatestAffinitizedPercent' : [ 0x1ac, ['unsigned long']],
    'RelativePerformance' : [ 0x1b0, ['unsigned long']],
    'Utility' : [ 0x1b4, ['unsigned long']],
    'AffinitizedUtility' : [ 0x1b8, ['unsigned long']],
    'SnapTimeLast' : [ 0x1c0, ['unsigned long long']],
    'EnergyConsumed' : [ 0x1c0, ['unsigned long long']],
    'ActiveTime' : [ 0x1c8, ['unsigned long long']],
    'TotalTime' : [ 0x1d0, ['unsigned long long']],
    'FxDevice' : [ 0x1d8, ['pointer64', ['_POP_FX_DEVICE']]],
    'LastQosTranstionTsc' : [ 0x1e0, ['unsigned long long']],
    'QosTransitionHysteresis' : [ 0x1e8, ['unsigned long long']],
    'RequestedQosClass' : [ 0x1f0, ['Enumeration', dict(target = 'long', choices = {0: u'KHeteroCpuQosHigh', 1: u'KHeteroCpuQosMedium', 2: u'KHeteroCpuQosLow', 3: u'KHeteroCpuQosMultimedia', 4: u'KHeteroCpuQosMax'})]],
    'ResolvedQosClass' : [ 0x1f4, ['Enumeration', dict(target = 'long', choices = {0: u'KHeteroCpuQosHigh', 1: u'KHeteroCpuQosMedium', 2: u'KHeteroCpuQosLow', 3: u'KHeteroCpuQosMultimedia', 4: u'KHeteroCpuQosMax'})]],
    'QosEquivalencyMask' : [ 0x1f8, ['unsigned long']],
} ],
  '_MI_PARTITION_SEGMENTS' : [ 0x340, {
    'SegmentListLock' : [ 0x0, ['long']],
    'DeleteOnCloseCount' : [ 0x4, ['unsigned long']],
    'FsControlAreaCount' : [ 0x8, ['long long']],
    'PfControlAreaCount' : [ 0x10, ['long long']],
    'CloneHeaderCount' : [ 0x18, ['long long']],
    'DeleteSubsectionCleanup' : [ 0x20, ['_KEVENT']],
    'UnusedSegmentCleanup' : [ 0x38, ['_KEVENT']],
    'SubsectionDeletePtes' : [ 0x50, ['unsigned long long']],
    'AttemptForCantExtend' : [ 0x58, ['_MMPAGE_FILE_EXPANSION']],
    'DereferenceSegmentHeader' : [ 0xb0, ['_MMDEREFERENCE_SEGMENT_HEADER']],
    'DeleteOnCloseList' : [ 0x100, ['_LIST_ENTRY']],
    'DeleteOnCloseTimer' : [ 0x110, ['_KTIMER']],
    'DeleteOnCloseTimerActive' : [ 0x150, ['unsigned char']],
    'SegmentDereferenceThreadExists' : [ 0x151, ['unsigned char']],
    'UnusedSegmentPagedPool' : [ 0x158, ['unsigned long long']],
    'UnusedSegmentList' : [ 0x160, ['_LIST_ENTRY']],
    'UnusedSubsectionList' : [ 0x170, ['_LIST_ENTRY']],
    'DeleteSubsectionList' : [ 0x180, ['_LIST_ENTRY']],
    'ControlAreaDeleteEvent' : [ 0x190, ['_KEVENT']],
    'ControlAreaDeleteList' : [ 0x1a8, ['_SINGLE_LIST_ENTRY']],
    'FreeSystemCache' : [ 0x1b0, ['_MI_PTE_CHAIN_HEAD']],
    'CloneDereferenceEvent' : [ 0x1c8, ['_KEVENT']],
    'CloneProtosSListHead' : [ 0x1e0, ['_SLIST_HEADER']],
    'SystemCacheInitLock' : [ 0x1f0, ['_EX_PUSH_LOCK']],
    'PagefileExtensionWaiters' : [ 0x1f8, ['unsigned long']],
    'PagefileExtensionRequests' : [ 0x1fc, ['unsigned long']],
    'PagefileExtensionWaitEvent' : [ 0x200, ['_KEVENT']],
    'SharedCharges' : [ 0x218, ['array', 7, ['_MI_CROSS_PARTITION_CHARGES']]],
    'SharedChargesDrainEvent' : [ 0x2f8, ['pointer64', ['_KEVENT']]],
    'ControlAreasDrainEvent' : [ 0x300, ['pointer64', ['_KEVENT']]],
    'CloneHeaderDrainEvent' : [ 0x308, ['pointer64', ['_KEVENT']]],
    'ProbeRundownReference' : [ 0x310, ['pointer64', ['_EX_RUNDOWN_REF_CACHE_AWARE']]],
} ],
  '_WHEA_ERROR_STATUS' : [ 0x8, {
    'ErrorStatus' : [ 0x0, ['unsigned long long']],
    'Reserved1' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned long long')]],
    'ErrorType' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 16, native_type='unsigned long long')]],
    'Address' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long long')]],
    'Control' : [ 0x0, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long long')]],
    'Data' : [ 0x0, ['BitField', dict(start_bit = 18, end_bit = 19, native_type='unsigned long long')]],
    'Responder' : [ 0x0, ['BitField', dict(start_bit = 19, end_bit = 20, native_type='unsigned long long')]],
    'Requester' : [ 0x0, ['BitField', dict(start_bit = 20, end_bit = 21, native_type='unsigned long long')]],
    'FirstError' : [ 0x0, ['BitField', dict(start_bit = 21, end_bit = 22, native_type='unsigned long long')]],
    'Overflow' : [ 0x0, ['BitField', dict(start_bit = 22, end_bit = 23, native_type='unsigned long long')]],
    'Reserved2' : [ 0x0, ['BitField', dict(start_bit = 23, end_bit = 64, native_type='unsigned long long')]],
} ],
  '_BUS_HANDLER' : [ 0xb0, {
    'Version' : [ 0x0, ['unsigned long']],
    'InterfaceType' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {0: u'Internal', 1: u'Isa', 2: u'Eisa', 3: u'MicroChannel', 4: u'TurboChannel', 5: u'PCIBus', 6: u'VMEBus', 7: u'NuBus', 8: u'PCMCIABus', 9: u'CBus', 10: u'MPIBus', 11: u'MPSABus', 12: u'ProcessorInternal', 13: u'InternalPowerBus', 14: u'PNPISABus', 15: u'PNPBus', 16: u'Vmcs', 17: u'ACPIBus', 18: u'MaximumInterfaceType', -1: u'InterfaceTypeUndefined'})]],
    'ConfigurationType' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {0: u'Cmos', 1: u'EisaConfiguration', 2: u'Pos', 3: u'CbusConfiguration', 4: u'PCIConfiguration', 5: u'VMEConfiguration', 6: u'NuBusConfiguration', 7: u'PCMCIAConfiguration', 8: u'MPIConfiguration', 9: u'MPSAConfiguration', 10: u'PNPISAConfiguration', 11: u'SgiInternalConfiguration', 12: u'MaximumBusDataType', -1: u'ConfigurationSpaceUndefined'})]],
    'BusNumber' : [ 0xc, ['unsigned long']],
    'DeviceObject' : [ 0x10, ['pointer64', ['_DEVICE_OBJECT']]],
    'ParentHandler' : [ 0x18, ['pointer64', ['_BUS_HANDLER']]],
    'BusData' : [ 0x20, ['pointer64', ['void']]],
    'DeviceControlExtensionSize' : [ 0x28, ['unsigned long']],
    'BusAddresses' : [ 0x30, ['pointer64', ['_SUPPORTED_RANGES']]],
    'Reserved' : [ 0x38, ['array', 4, ['unsigned long']]],
    'GetBusData' : [ 0x48, ['pointer64', ['void']]],
    'SetBusData' : [ 0x50, ['pointer64', ['void']]],
    'AdjustResourceList' : [ 0x58, ['pointer64', ['void']]],
    'AssignSlotResources' : [ 0x60, ['pointer64', ['void']]],
    'TranslateBusAddress' : [ 0x68, ['pointer64', ['void']]],
    'Spare1' : [ 0x70, ['pointer64', ['void']]],
    'Spare2' : [ 0x78, ['pointer64', ['void']]],
    'Spare3' : [ 0x80, ['pointer64', ['void']]],
    'Spare4' : [ 0x88, ['pointer64', ['void']]],
    'Spare5' : [ 0x90, ['pointer64', ['void']]],
    'Spare6' : [ 0x98, ['pointer64', ['void']]],
    'Spare7' : [ 0xa0, ['pointer64', ['void']]],
    'Spare8' : [ 0xa8, ['pointer64', ['void']]],
} ],
  '_MI_AVAILABLE_PAGE_WAIT_STATES' : [ 0x20, {
    'Event' : [ 0x0, ['_KEVENT']],
    'EventSets' : [ 0x18, ['unsigned long']],
} ],
  '_MMPTE_TIMESTAMP' : [ 0x8, {
    'MustBeZero' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'PageFileLow' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 5, native_type='unsigned long long')]],
    'Protection' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 10, native_type='unsigned long long')]],
    'Prototype' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long long')]],
    'Transition' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 32, native_type='unsigned long long')]],
    'GlobalTimeStamp' : [ 0x0, ['BitField', dict(start_bit = 32, end_bit = 64, native_type='unsigned long long')]],
} ],
  '_KRESOURCEMANAGER' : [ 0x250, {
    'NotificationAvailable' : [ 0x0, ['_KEVENT']],
    'cookie' : [ 0x18, ['unsigned long']],
    'State' : [ 0x1c, ['Enumeration', dict(target = 'long', choices = {0: u'KResourceManagerUninitialized', 1: u'KResourceManagerOffline', 2: u'KResourceManagerOnline'})]],
    'Flags' : [ 0x20, ['unsigned long']],
    'Mutex' : [ 0x28, ['_KMUTANT']],
    'NamespaceLink' : [ 0x60, ['_KTMOBJECT_NAMESPACE_LINK']],
    'RmId' : [ 0x88, ['_GUID']],
    'NotificationQueue' : [ 0x98, ['_KQUEUE']],
    'NotificationMutex' : [ 0xd8, ['_KMUTANT']],
    'EnlistmentHead' : [ 0x110, ['_LIST_ENTRY']],
    'EnlistmentCount' : [ 0x120, ['unsigned long']],
    'NotificationRoutine' : [ 0x128, ['pointer64', ['void']]],
    'Key' : [ 0x130, ['pointer64', ['void']]],
    'ProtocolListHead' : [ 0x138, ['_LIST_ENTRY']],
    'PendingPropReqListHead' : [ 0x148, ['_LIST_ENTRY']],
    'CRMListEntry' : [ 0x158, ['_LIST_ENTRY']],
    'Tm' : [ 0x168, ['pointer64', ['_KTM']]],
    'Description' : [ 0x170, ['_UNICODE_STRING']],
    'Enlistments' : [ 0x180, ['_KTMOBJECT_NAMESPACE']],
    'CompletionBinding' : [ 0x228, ['_KRESOURCEMANAGER_COMPLETION_BINDING']],
} ],
  '_ARBITER_QUERY_ARBITRATE_PARAMETERS' : [ 0x8, {
    'ArbitrationList' : [ 0x0, ['pointer64', ['_LIST_ENTRY']]],
} ],
  '_POP_FX_DEVICE' : [ 0x318, {
    'Link' : [ 0x0, ['_LIST_ENTRY']],
    'Irp' : [ 0x10, ['pointer64', ['_IRP']]],
    'IrpData' : [ 0x18, ['pointer64', ['_POP_IRP_DATA']]],
    'Status' : [ 0x20, ['_POP_FX_DEVICE_STATUS']],
    'PowerReqCall' : [ 0x24, ['long']],
    'PowerNotReqCall' : [ 0x28, ['long']],
    'DevNode' : [ 0x30, ['pointer64', ['_DEVICE_NODE']]],
    'DpmContext' : [ 0x38, ['pointer64', ['PEPHANDLE__']]],
    'Plugin' : [ 0x40, ['pointer64', ['_POP_FX_PLUGIN']]],
    'PluginHandle' : [ 0x48, ['pointer64', ['PEPHANDLE__']]],
    'AcpiPlugin' : [ 0x50, ['pointer64', ['_POP_FX_PLUGIN']]],
    'AcpiPluginHandle' : [ 0x58, ['pointer64', ['PEPHANDLE__']]],
    'DeviceObject' : [ 0x60, ['pointer64', ['_DEVICE_OBJECT']]],
    'TargetDevice' : [ 0x68, ['pointer64', ['_DEVICE_OBJECT']]],
    'Callbacks' : [ 0x70, ['_POP_FX_DRIVER_CALLBACKS']],
    'DriverContext' : [ 0xb0, ['pointer64', ['void']]],
    'AcpiLink' : [ 0xb8, ['_LIST_ENTRY']],
    'DeviceId' : [ 0xc8, ['_UNICODE_STRING']],
    'RemoveLock' : [ 0xd8, ['_IO_REMOVE_LOCK']],
    'AcpiRemoveLock' : [ 0xf8, ['_IO_REMOVE_LOCK']],
    'WorkOrder' : [ 0x118, ['_POP_FX_WORK_ORDER']],
    'IdleLock' : [ 0x150, ['unsigned long long']],
    'IdleTimer' : [ 0x158, ['_KTIMER']],
    'IdleDpc' : [ 0x198, ['_KDPC']],
    'IdleTimeout' : [ 0x1d8, ['unsigned long long']],
    'IdleStamp' : [ 0x1e0, ['unsigned long long']],
    'NextIrpDeviceObject' : [ 0x1e8, ['array', 2, ['pointer64', ['_DEVICE_OBJECT']]]],
    'NextIrpPowerState' : [ 0x1f8, ['array', 2, ['_POWER_STATE']]],
    'NextIrpCallerCompletion' : [ 0x200, ['array', 2, ['pointer64', ['void']]]],
    'NextIrpCallerContext' : [ 0x210, ['array', 2, ['pointer64', ['void']]]],
    'IrpCompleteEvent' : [ 0x220, ['_KEVENT']],
    'PowerOnDumpDeviceCallback' : [ 0x238, ['pointer64', ['void']]],
    'Accounting' : [ 0x240, ['_POP_FX_ACCOUNTING']],
    'Flags' : [ 0x2c0, ['unsigned long']],
    'ComponentCount' : [ 0x2c4, ['unsigned long']],
    'Components' : [ 0x2c8, ['pointer64', ['pointer64', ['_POP_FX_COMPONENT']]]],
    'LogEntries' : [ 0x2d0, ['unsigned long']],
    'Log' : [ 0x2d8, ['pointer64', ['_POP_FX_LOG_ENTRY']]],
    'LogIndex' : [ 0x2e0, ['long']],
    'DripsWatchdogDriverObject' : [ 0x2e8, ['pointer64', ['_DRIVER_OBJECT']]],
    'DripsWatchdogContext' : [ 0x2f0, ['_POP_FX_DRIPS_WATCHDOG_CONTEXT']],
} ],
  '_CELL_DATA' : [ 0x50, {
    'u' : [ 0x0, ['_u']],
} ],
  '_IOV_IRP_TRACE' : [ 0x80, {
    'Irp' : [ 0x0, ['pointer64', ['_IRP']]],
    'Thread' : [ 0x8, ['pointer64', ['_KTHREAD']]],
    'KernelApcDisable' : [ 0x10, ['short']],
    'SpecialApcDisable' : [ 0x12, ['short']],
    'CombinedApcDisable' : [ 0x10, ['unsigned long']],
    'Irql' : [ 0x14, ['unsigned char']],
    'StackTrace' : [ 0x18, ['array', 13, ['pointer64', ['void']]]],
} ],
  '_MI_CLONE_BLOCK_FLAGS' : [ 0x8, {
    'ActualCloneCommit' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 59, native_type='unsigned long long')]],
    'CloneProtection' : [ 0x0, ['BitField', dict(start_bit = 59, end_bit = 64, native_type='unsigned long long')]],
} ],
  '_PS_JOB_WAKE_INFORMATION' : [ 0x48, {
    'NotificationChannel' : [ 0x0, ['unsigned long long']],
    'WakeCounters' : [ 0x8, ['array', 7, ['unsigned long long']]],
    'NoWakeCounter' : [ 0x40, ['unsigned long long']],
} ],
  '_MMINPAGE_FLAGS' : [ 0x4, {
    'InjectRetry' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'GetExtents' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'CrossThreadPadding' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 8, native_type='unsigned char')]],
    'PrefetchSystemVmType' : [ 0x1, ['BitField', dict(start_bit = 0, end_bit = 2, native_type='unsigned char')]],
    'VaPrefetchReadBlock' : [ 0x1, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'CollidedFlowThrough' : [ 0x1, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'ForceCollisions' : [ 0x1, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'InPageExpanded' : [ 0x1, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'IssuedAtLowPriority' : [ 0x1, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned char')]],
    'FaultFromStore' : [ 0x1, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
    'PagePriority' : [ 0x2, ['BitField', dict(start_bit = 0, end_bit = 3, native_type='unsigned char')]],
    'PerformRelocations' : [ 0x2, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'ClusteredPagePriority' : [ 0x2, ['BitField', dict(start_bit = 4, end_bit = 7, native_type='unsigned char')]],
    'MakeClusterValid' : [ 0x2, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
    'ZeroLastPage' : [ 0x3, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'UserFault' : [ 0x3, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'StandbyProtectionNeeded' : [ 0x3, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'PteChanged' : [ 0x3, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'PageFileFault' : [ 0x3, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'PageFilePageHashActive' : [ 0x3, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'CoalescedIo' : [ 0x3, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned char')]],
    'VmLockNotNeeded' : [ 0x3, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
} ],
  '_IO_ADAPTER_CRYPTO_KEY_DESCRIPTOR' : [ 0x48, {
    'Version' : [ 0x0, ['unsigned long']],
    'Size' : [ 0x4, ['unsigned long']],
    'CryptoIndex' : [ 0x8, ['unsigned long']],
    'AlgorithmId' : [ 0xc, ['unsigned long']],
    'DataUnitSize' : [ 0x10, ['unsigned long']],
    'KeySize' : [ 0x14, ['unsigned long']],
    'KeyHash' : [ 0x18, ['array', 32, ['unsigned char']]],
    'KeyVirtualAddress' : [ 0x38, ['pointer64', ['void']]],
    'KeyPhysicalAddress' : [ 0x40, ['_LARGE_INTEGER']],
} ],
  '_PPM_CONCURRENCY_ACCOUNTING' : [ 0x28, {
    'Lock' : [ 0x0, ['unsigned long long']],
    'Processors' : [ 0x8, ['unsigned long']],
    'ActiveProcessors' : [ 0xc, ['unsigned long']],
    'LastUpdateTime' : [ 0x10, ['unsigned long long']],
    'TotalTime' : [ 0x18, ['unsigned long long']],
    'AccumulatedTime' : [ 0x20, ['array', 1, ['unsigned long long']]],
} ],
  '_RTL_HP_SUB_ALLOCATOR_CONFIGS' : [ 0x10, {
    'LfhConfigs' : [ 0x0, ['_RTL_HP_LFH_CONFIG']],
    'VsConfigs' : [ 0xc, ['_RTL_HP_VS_CONFIG']],
} ],
  '_SEP_CACHED_HANDLES_ENTRY_DESCRIPTOR' : [ 0x18, {
    'DescriptorType' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: u'SepCachedHandlesEntryLowbox', 1: u'SepCachedHandlesEntryBnoIsolation'})]],
    'PackageSid' : [ 0x8, ['pointer64', ['void']]],
    'IsolationPrefix' : [ 0x8, ['_UNICODE_STRING']],
} ],
  '_MI_ULTRA_MDL_NODE' : [ 0x200, {
    'UltraMdlMaps' : [ 0x0, ['array', 8, ['_MI_ALIGNED_SLIST']]],
} ],
  '_HEAP_ENTRY_EXTRA' : [ 0x10, {
    'AllocatorBackTraceIndex' : [ 0x0, ['unsigned short']],
    'TagIndex' : [ 0x2, ['unsigned short']],
    'Settable' : [ 0x8, ['unsigned long long']],
    'ZeroInit' : [ 0x0, ['unsigned long long']],
    'ZeroInit1' : [ 0x8, ['unsigned long long']],
} ],
  '_VF_AVL_TABLE' : [ 0xc0, {
    'RtlTable' : [ 0x0, ['_RTL_AVL_TABLE']],
    'ReservedNode' : [ 0x68, ['pointer64', ['_VF_AVL_TREE_NODE']]],
    'NodeToFree' : [ 0x70, ['pointer64', ['void']]],
    'Lock' : [ 0x80, ['long']],
} ],
  '__unnamed_2977' : [ 0x8, {
    'IdleTime' : [ 0x0, ['unsigned long']],
    'NonIdleTime' : [ 0x4, ['unsigned long']],
} ],
  '__unnamed_2979' : [ 0x8, {
    'Disk' : [ 0x0, ['__unnamed_2977']],
} ],
  '_DEVICE_OBJECT_POWER_EXTENSION' : [ 0x60, {
    'IdleCount' : [ 0x0, ['unsigned long']],
    'BusyCount' : [ 0x4, ['unsigned long']],
    'BusyReference' : [ 0x8, ['unsigned long']],
    'TotalBusyCount' : [ 0xc, ['unsigned long']],
    'ConservationIdleTime' : [ 0x10, ['unsigned long']],
    'PerformanceIdleTime' : [ 0x14, ['unsigned long']],
    'DeviceObject' : [ 0x18, ['pointer64', ['_DEVICE_OBJECT']]],
    'IdleList' : [ 0x20, ['_LIST_ENTRY']],
    'IdleType' : [ 0x30, ['Enumeration', dict(target = 'long', choices = {0: u'DeviceIdleNormal', 1: u'DeviceIdleDisk'})]],
    'IdleState' : [ 0x34, ['Enumeration', dict(target = 'long', choices = {0: u'PowerDeviceUnspecified', 1: u'PowerDeviceD0', 2: u'PowerDeviceD1', 3: u'PowerDeviceD2', 4: u'PowerDeviceD3', 5: u'PowerDeviceMaximum'})]],
    'CurrentState' : [ 0x38, ['Enumeration', dict(target = 'long', choices = {0: u'PowerDeviceUnspecified', 1: u'PowerDeviceD0', 2: u'PowerDeviceD1', 3: u'PowerDeviceD2', 4: u'PowerDeviceD3', 5: u'PowerDeviceMaximum'})]],
    'CoolingExtension' : [ 0x40, ['pointer64', ['_POP_COOLING_EXTENSION']]],
    'Volume' : [ 0x48, ['_LIST_ENTRY']],
    'Specific' : [ 0x58, ['__unnamed_2979']],
} ],
  '_OBJECT_DIRECTORY_ENTRY' : [ 0x18, {
    'ChainLink' : [ 0x0, ['pointer64', ['_OBJECT_DIRECTORY_ENTRY']]],
    'Object' : [ 0x8, ['pointer64', ['void']]],
    'HashValue' : [ 0x10, ['unsigned long']],
} ],
  '_CM_UOW_SET_SD_DATA' : [ 0x4, {
    'SecurityCell' : [ 0x0, ['unsigned long']],
} ],
  '_PNP_DEVICE_COMPLETION_REQUEST' : [ 0x80, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'DeviceNode' : [ 0x10, ['pointer64', ['_DEVICE_NODE']]],
    'Context' : [ 0x18, ['pointer64', ['void']]],
    'CompletionState' : [ 0x20, ['Enumeration', dict(target = 'long', choices = {768: u'DeviceNodeUnspecified', 769: u'DeviceNodeUninitialized', 770: u'DeviceNodeInitialized', 771: u'DeviceNodeDriversAdded', 772: u'DeviceNodeResourcesAssigned', 773: u'DeviceNodeStartPending', 774: u'DeviceNodeStartCompletion', 775: u'DeviceNodeStartPostWork', 776: u'DeviceNodeStarted', 777: u'DeviceNodeQueryStopped', 778: u'DeviceNodeStopped', 779: u'DeviceNodeRestartCompletion', 780: u'DeviceNodeEnumeratePending', 781: u'DeviceNodeEnumerateCompletion', 782: u'DeviceNodeAwaitingQueuedDeletion', 783: u'DeviceNodeAwaitingQueuedRemoval', 784: u'DeviceNodeQueryRemoved', 785: u'DeviceNodeRemovePendingCloses', 786: u'DeviceNodeRemoved', 787: u'DeviceNodeDeletePendingCloses', 788: u'DeviceNodeDeleted', 789: u'MaxDeviceNodeState'})]],
    'IrpPended' : [ 0x24, ['unsigned long']],
    'Status' : [ 0x28, ['long']],
    'Information' : [ 0x30, ['pointer64', ['void']]],
    'ReferenceCount' : [ 0x38, ['long']],
    'PnpDeviceCompletionQueueWatchdogLock' : [ 0x40, ['_FAST_MUTEX']],
    'Watchdog' : [ 0x78, ['pointer64', ['_PNP_WATCHDOG']]],
} ],
  '_ETW_STACK_TRACE_BLOCK' : [ 0x80, {
    'RelatedTimestamp' : [ 0x0, ['_LARGE_INTEGER']],
    'Thread' : [ 0x8, ['pointer64', ['_ETHREAD']]],
    'StackWalkDpc' : [ 0x10, ['_KDPC']],
    'ApcListHead' : [ 0x50, ['_SLIST_HEADER']],
    'ApcEntry' : [ 0x60, ['pointer64', ['_ETW_APC_ENTRY']]],
    'ApcEntryCount' : [ 0x68, ['unsigned long']],
    'Flags' : [ 0x6c, ['long']],
    'ApcCount' : [ 0x70, ['long']],
    'MaxApcCount' : [ 0x74, ['long']],
} ],
  '_EVENT_FILTER_LEVEL_KW' : [ 0x18, {
    'MatchAnyKeyword' : [ 0x0, ['unsigned long long']],
    'MatchAllKeyword' : [ 0x8, ['unsigned long long']],
    'Level' : [ 0x10, ['unsigned char']],
    'FilterIn' : [ 0x11, ['unsigned char']],
} ],
  '_WRITE_BEHIND_THROUGHPUT' : [ 0x8, {
    'PagesYetToWrite' : [ 0x0, ['unsigned long']],
    'Throughput' : [ 0x4, ['unsigned long']],
} ],
  '_THREAD_PERFORMANCE_DATA' : [ 0x1c0, {
    'Size' : [ 0x0, ['unsigned short']],
    'Version' : [ 0x2, ['unsigned short']],
    'ProcessorNumber' : [ 0x4, ['_PROCESSOR_NUMBER']],
    'ContextSwitches' : [ 0x8, ['unsigned long']],
    'HwCountersCount' : [ 0xc, ['unsigned long']],
    'UpdateCount' : [ 0x10, ['unsigned long long']],
    'WaitReasonBitMap' : [ 0x18, ['unsigned long long']],
    'HardwareCounters' : [ 0x20, ['unsigned long long']],
    'CycleTime' : [ 0x28, ['_COUNTER_READING']],
    'HwCounters' : [ 0x40, ['array', 16, ['_COUNTER_READING']]],
} ],
  '_SEP_TOKEN_PRIVILEGES' : [ 0x18, {
    'Present' : [ 0x0, ['unsigned long long']],
    'Enabled' : [ 0x8, ['unsigned long long']],
    'EnabledByDefault' : [ 0x10, ['unsigned long long']],
} ],
  '_MI_VERIFIER_POOL_HEADER' : [ 0x8, {
    'VerifierPoolEntry' : [ 0x0, ['pointer64', ['_VI_POOL_ENTRY']]],
} ],
  '__unnamed_2998' : [ 0x4, {
    'LongFlags' : [ 0x0, ['unsigned long']],
    'Flags' : [ 0x0, ['_MMPAGE_FILE_EXPANSION_FLAGS']],
} ],
  '_MMPAGE_FILE_EXPANSION' : [ 0x58, {
    'Segment' : [ 0x0, ['pointer64', ['_SEGMENT']]],
    'DereferenceList' : [ 0x8, ['_LIST_ENTRY']],
    'Partition' : [ 0x18, ['pointer64', ['_MI_PARTITION']]],
    'RequestedExpansionSize' : [ 0x20, ['unsigned long long']],
    'ActualExpansion' : [ 0x28, ['unsigned long long']],
    'Event' : [ 0x30, ['_KEVENT']],
    'InProgress' : [ 0x48, ['long']],
    'u1' : [ 0x4c, ['__unnamed_2998']],
    'ActiveEntry' : [ 0x50, ['pointer64', ['pointer64', ['void']]]],
} ],
  '_NT_TIB32' : [ 0x1c, {
    'ExceptionList' : [ 0x0, ['unsigned long']],
    'StackBase' : [ 0x4, ['unsigned long']],
    'StackLimit' : [ 0x8, ['unsigned long']],
    'SubSystemTib' : [ 0xc, ['unsigned long']],
    'FiberData' : [ 0x10, ['unsigned long']],
    'Version' : [ 0x10, ['unsigned long']],
    'ArbitraryUserPointer' : [ 0x14, ['unsigned long']],
    'Self' : [ 0x18, ['unsigned long']],
} ],
  '_PPM_COORDINATED_SYNCHRONIZATION' : [ 0x4, {
    'AsLong' : [ 0x0, ['long']],
    'EnterProcessor' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 12, native_type='unsigned long')]],
    'ExitProcessor' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 24, native_type='unsigned long')]],
    'Transition' : [ 0x0, ['BitField', dict(start_bit = 24, end_bit = 26, native_type='unsigned long')]],
    'Entered' : [ 0x0, ['BitField', dict(start_bit = 26, end_bit = 27, native_type='unsigned long')]],
    'EntryPriority' : [ 0x0, ['BitField', dict(start_bit = 27, end_bit = 32, native_type='unsigned long')]],
} ],
  '_KDPC_LIST' : [ 0x10, {
    'ListHead' : [ 0x0, ['_SINGLE_LIST_ENTRY']],
    'LastEntry' : [ 0x8, ['pointer64', ['_SINGLE_LIST_ENTRY']]],
} ],
  '_LPCP_PORT_OBJECT' : [ 0x100, {
    'ConnectionPort' : [ 0x0, ['pointer64', ['_LPCP_PORT_OBJECT']]],
    'ConnectedPort' : [ 0x8, ['pointer64', ['_LPCP_PORT_OBJECT']]],
    'MsgQueue' : [ 0x10, ['_LPCP_PORT_QUEUE']],
    'Creator' : [ 0x30, ['_CLIENT_ID']],
    'ClientSectionBase' : [ 0x40, ['pointer64', ['void']]],
    'ServerSectionBase' : [ 0x48, ['pointer64', ['void']]],
    'PortContext' : [ 0x50, ['pointer64', ['void']]],
    'ClientThread' : [ 0x58, ['pointer64', ['_ETHREAD']]],
    'SecurityQos' : [ 0x60, ['_SECURITY_QUALITY_OF_SERVICE']],
    'StaticSecurity' : [ 0x70, ['_SECURITY_CLIENT_CONTEXT']],
    'LpcReplyChainHead' : [ 0xb8, ['_LIST_ENTRY']],
    'LpcDataInfoChainHead' : [ 0xc8, ['_LIST_ENTRY']],
    'ServerProcess' : [ 0xd8, ['pointer64', ['_EPROCESS']]],
    'MappingProcess' : [ 0xd8, ['pointer64', ['_EPROCESS']]],
    'MaxMessageLength' : [ 0xe0, ['unsigned short']],
    'MaxConnectionInfoLength' : [ 0xe2, ['unsigned short']],
    'Flags' : [ 0xe4, ['unsigned long']],
    'WaitEvent' : [ 0xe8, ['_KEVENT']],
} ],
  '_ETW_FILTER_PID' : [ 0x24, {
    'Count' : [ 0x0, ['unsigned long']],
    'Pids' : [ 0x4, ['array', 8, ['unsigned long']]],
} ],
  '_RTL_SRWLOCK' : [ 0x8, {
    'Locked' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'Waiting' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long long')]],
    'Waking' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long long')]],
    'MultipleShared' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long long')]],
    'Shared' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 64, native_type='unsigned long long')]],
    'Value' : [ 0x0, ['unsigned long long']],
    'Ptr' : [ 0x0, ['pointer64', ['void']]],
} ],
  '_IOV_FORCED_PENDING_TRACE' : [ 0x200, {
    'Irp' : [ 0x0, ['pointer64', ['_IRP']]],
    'Thread' : [ 0x8, ['pointer64', ['_ETHREAD']]],
    'StackTrace' : [ 0x10, ['array', 62, ['pointer64', ['void']]]],
} ],
  '_ARBITER_QUERY_CONFLICT_PARAMETERS' : [ 0x20, {
    'PhysicalDeviceObject' : [ 0x0, ['pointer64', ['_DEVICE_OBJECT']]],
    'ConflictingResource' : [ 0x8, ['pointer64', ['_IO_RESOURCE_DESCRIPTOR']]],
    'ConflictCount' : [ 0x10, ['pointer64', ['unsigned long']]],
    'Conflicts' : [ 0x18, ['pointer64', ['pointer64', ['_ARBITER_CONFLICT_INFO']]]],
} ],
  '_POP_THERMAL_TELEMETRY_TRACKER' : [ 0x160, {
    'AccountingDisabled' : [ 0x0, ['unsigned char']],
    'LastPassiveUpdateTime' : [ 0x8, ['unsigned long long']],
    'TotalPassiveTime' : [ 0x10, ['array', 21, ['unsigned long long']]],
    'PassiveTimeSnap' : [ 0xb8, ['array', 21, ['unsigned long long']]],
} ],
  '_WHEA_ERROR_RECORD_SECTION_DESCRIPTOR_VALIDBITS' : [ 0x1, {
    'FRUId' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'FRUText' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 8, native_type='unsigned char')]],
    'AsUCHAR' : [ 0x0, ['unsigned char']],
} ],
  '_POP_FX_LOG_ENTRY' : [ 0x18, {
    'Timestamp' : [ 0x0, ['unsigned long long']],
    'Operation' : [ 0x8, ['unsigned char']],
    'Component' : [ 0x9, ['unsigned char']],
    'Processor' : [ 0xa, ['unsigned short']],
    'Process' : [ 0xc, ['unsigned short']],
    'Thread' : [ 0xe, ['unsigned short']],
    'Information' : [ 0x10, ['unsigned long long']],
} ],
  '_OBJECT_HANDLE_COUNT_ENTRY' : [ 0x10, {
    'Process' : [ 0x0, ['pointer64', ['_EPROCESS']]],
    'HandleCount' : [ 0x8, ['BitField', dict(start_bit = 0, end_bit = 24, native_type='unsigned long')]],
    'LockCount' : [ 0x8, ['BitField', dict(start_bit = 24, end_bit = 32, native_type='unsigned long')]],
} ],
  '_FREE_DISPLAY' : [ 0x18, {
    'RealVectorSize' : [ 0x0, ['unsigned long']],
    'Hint' : [ 0x4, ['unsigned long']],
    'Display' : [ 0x8, ['_RTL_BITMAP']],
} ],
  '_MAP_REGISTER_ENTRY' : [ 0x10, {
    'MapRegister' : [ 0x0, ['pointer64', ['void']]],
    'WriteToDevice' : [ 0x8, ['unsigned char']],
} ],
  'SYSTEM_POWER_LEVEL' : [ 0x18, {
    'Enable' : [ 0x0, ['unsigned char']],
    'Spare' : [ 0x1, ['array', 3, ['unsigned char']]],
    'BatteryLevel' : [ 0x4, ['unsigned long']],
    'PowerPolicy' : [ 0x8, ['POWER_ACTION_POLICY']],
    'MinSystemState' : [ 0x14, ['Enumeration', dict(target = 'long', choices = {0: u'PowerSystemUnspecified', 1: u'PowerSystemWorking', 2: u'PowerSystemSleeping1', 3: u'PowerSystemSleeping2', 4: u'PowerSystemSleeping3', 5: u'PowerSystemHibernate', 6: u'PowerSystemShutdown', 7: u'PowerSystemMaximum'})]],
} ],
  '_PROCESSOR_IDLE_PREPARE_INFO' : [ 0x58, {
    'Context' : [ 0x0, ['pointer64', ['void']]],
    'Constraints' : [ 0x8, ['_PROCESSOR_IDLE_CONSTRAINTS']],
    'DependencyCount' : [ 0x38, ['unsigned long']],
    'DependencyUsed' : [ 0x3c, ['unsigned long']],
    'DependencyArray' : [ 0x40, ['pointer64', ['_PROCESSOR_IDLE_DEPENDENCY']]],
    'PlatformIdleStateIndex' : [ 0x48, ['unsigned long']],
    'ProcessorIdleStateIndex' : [ 0x4c, ['unsigned long']],
    'IdleSelectFailureMask' : [ 0x50, ['unsigned long']],
} ],
  '_PNP_REBALANCE_TRACE_CONTEXT' : [ 0x70, {
    'DeviceCount' : [ 0x0, ['unsigned long']],
    'RebalancePhase' : [ 0x4, ['unsigned long']],
    'Reason' : [ 0x8, ['array', 2, ['Enumeration', dict(target = 'long', choices = {0: u'RebalanceReasonUnknown', 1: u'RebalanceReasonRequirementsChanged', 2: u'RebalanceReasonNewDevice'})]]],
    'Failure' : [ 0x10, ['array', 2, ['Enumeration', dict(target = 'long', choices = {0: u'RebalanceFailureNone', 1: u'RebalanceFailureDisabled', 2: u'RebalanceFailureNoMemory', 3: u'RebalanceFailureQueryStopUnexpectedVeto', 4: u'RebalanceFailureNoRequirements', 5: u'RebalanceFailureNoCandidates', 6: u'RebalanceFailureNoConfiguration'})]]],
    'SubtreeRoot' : [ 0x18, ['pointer64', ['_DEVICE_NODE']]],
    'SubtreeIncludesRoot' : [ 0x20, ['unsigned char']],
    'TriggerRoot' : [ 0x28, ['pointer64', ['_DEVICE_NODE']]],
    'RebalanceDueToDynamicPartitioning' : [ 0x30, ['unsigned char']],
    'BeginTime' : [ 0x38, ['unsigned long long']],
    'VetoNode' : [ 0x40, ['array', 2, ['pointer64', ['_DEVICE_NODE']]]],
    'VetoQueryRebalanceReason' : [ 0x50, ['array', 2, ['Enumeration', dict(target = 'long', choices = {0: u'DeviceQueryRebalanceSucceeded', 1: u'DeviceQueryStopFailed', 2: u'DeviceFailedGetNewResourceRequirement', 3: u'DeviceInUnexpectedState', 4: u'DeviceNotSupportQueryRebalance'})]]],
    'ConflictContext' : [ 0x58, ['_PNP_RESOURCE_CONFLICT_TRACE_CONTEXT']],
} ],
  '_IOP_IRP_STACK_PROFILER' : [ 0x54, {
    'Profile' : [ 0x0, ['array', 20, ['unsigned long']]],
    'TotalIrps' : [ 0x50, ['unsigned long']],
} ],
  '_HMAP_ENTRY' : [ 0x18, {
    'BlockOffset' : [ 0x0, ['unsigned long long']],
    'PermanentBinAddress' : [ 0x8, ['unsigned long long']],
    'MemAlloc' : [ 0x10, ['unsigned long']],
} ],
  '__unnamed_29e6' : [ 0x18, {
    'RequestedTime' : [ 0x0, ['unsigned long long']],
    'ProgrammedTime' : [ 0x8, ['unsigned long long']],
    'TimerInfo' : [ 0x10, ['pointer64', ['_DIAGNOSTIC_BUFFER']]],
} ],
  '_POP_POWER_ACTION' : [ 0x118, {
    'Updates' : [ 0x0, ['unsigned char']],
    'State' : [ 0x1, ['unsigned char']],
    'Shutdown' : [ 0x2, ['unsigned char']],
    'Action' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {0: u'PowerActionNone', 1: u'PowerActionReserved', 2: u'PowerActionSleep', 3: u'PowerActionHibernate', 4: u'PowerActionShutdown', 5: u'PowerActionShutdownReset', 6: u'PowerActionShutdownOff', 7: u'PowerActionWarmEject', 8: u'PowerActionDisplayOff'})]],
    'LightestState' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {0: u'PowerSystemUnspecified', 1: u'PowerSystemWorking', 2: u'PowerSystemSleeping1', 3: u'PowerSystemSleeping2', 4: u'PowerSystemSleeping3', 5: u'PowerSystemHibernate', 6: u'PowerSystemShutdown', 7: u'PowerSystemMaximum'})]],
    'Flags' : [ 0xc, ['unsigned long']],
    'Status' : [ 0x10, ['long']],
    'DeviceType' : [ 0x14, ['Enumeration', dict(target = 'long', choices = {0: u'PolicyDeviceSystemButton', 1: u'PolicyDeviceThermalZone', 2: u'PolicyDeviceBattery', 3: u'PolicyDeviceMemory', 4: u'PolicyInitiatePowerActionAPI', 5: u'PolicySetPowerStateAPI', 6: u'PolicyImmediateDozeS4', 7: u'PolicySystemIdle', 8: u'PolicyDeviceWakeAlarm', 9: u'PolicyDeviceFan', 10: u'PolicyCsBatterySaver', 11: u'PolicyImmediateDozeS4Predicted', 12: u'PolicyImmediateDozeS4PredictedNoWake', 13: u'PolicyImmediateDozeS4AdaptiveBudget', 14: u'PolicyImmediateDozeS4AdaptiveReserveNoWake', 15: u'PolicySystemInitiatedShutdown', 16: u'PolicyDeviceMax'})]],
    'DeviceTypeFlags' : [ 0x18, ['unsigned long']],
    'IrpMinor' : [ 0x1c, ['unsigned char']],
    'Waking' : [ 0x1d, ['unsigned char']],
    'SystemState' : [ 0x20, ['Enumeration', dict(target = 'long', choices = {0: u'PowerSystemUnspecified', 1: u'PowerSystemWorking', 2: u'PowerSystemSleeping1', 3: u'PowerSystemSleeping2', 4: u'PowerSystemSleeping3', 5: u'PowerSystemHibernate', 6: u'PowerSystemShutdown', 7: u'PowerSystemMaximum'})]],
    'NextSystemState' : [ 0x24, ['Enumeration', dict(target = 'long', choices = {0: u'PowerSystemUnspecified', 1: u'PowerSystemWorking', 2: u'PowerSystemSleeping1', 3: u'PowerSystemSleeping2', 4: u'PowerSystemSleeping3', 5: u'PowerSystemHibernate', 6: u'PowerSystemShutdown', 7: u'PowerSystemMaximum'})]],
    'EffectiveSystemState' : [ 0x28, ['Enumeration', dict(target = 'long', choices = {0: u'PowerSystemUnspecified', 1: u'PowerSystemWorking', 2: u'PowerSystemSleeping1', 3: u'PowerSystemSleeping2', 4: u'PowerSystemSleeping3', 5: u'PowerSystemHibernate', 6: u'PowerSystemShutdown', 7: u'PowerSystemMaximum'})]],
    'CurrentSystemState' : [ 0x2c, ['Enumeration', dict(target = 'long', choices = {0: u'PowerSystemUnspecified', 1: u'PowerSystemWorking', 2: u'PowerSystemSleeping1', 3: u'PowerSystemSleeping2', 4: u'PowerSystemSleeping3', 5: u'PowerSystemHibernate', 6: u'PowerSystemShutdown', 7: u'PowerSystemMaximum'})]],
    'ShutdownBugCode' : [ 0x30, ['pointer64', ['_POP_SHUTDOWN_BUG_CHECK']]],
    'DevState' : [ 0x38, ['pointer64', ['_POP_DEVICE_SYS_STATE']]],
    'HiberContext' : [ 0x40, ['pointer64', ['_POP_HIBER_CONTEXT']]],
    'WakeTime' : [ 0x48, ['unsigned long long']],
    'SleepTime' : [ 0x50, ['unsigned long long']],
    'WakeFirstUnattendedTime' : [ 0x58, ['unsigned long long']],
    'WakeAlarmSignaled' : [ 0x60, ['Enumeration', dict(target = 'long', choices = {0: u'PoAc', 1: u'PoDc', 2: u'PoHot', 3: u'PoConditionMaximum'})]],
    'WakeAlarm' : [ 0x68, ['array', 3, ['__unnamed_29e6']]],
    'WakeAlarmPaused' : [ 0xb0, ['unsigned char']],
    'WakeAlarmLastTime' : [ 0xb8, ['unsigned long long']],
    'DozeDeferralStartTime' : [ 0xc0, ['unsigned long long']],
    'FilteredCapabilities' : [ 0xc8, ['SYSTEM_POWER_CAPABILITIES']],
} ],
  '_RTL_RANGE_LIST' : [ 0x20, {
    'ListHead' : [ 0x0, ['_LIST_ENTRY']],
    'Flags' : [ 0x10, ['unsigned long']],
    'Count' : [ 0x14, ['unsigned long']],
    'Stamp' : [ 0x18, ['unsigned long']],
} ],
  '_PROCESSOR_PLATFORM_STATE_RESIDENCIES' : [ 0x18, {
    'Count' : [ 0x0, ['unsigned long']],
    'States' : [ 0x8, ['array', 1, ['_PROCESSOR_PLATFORM_STATE_RESIDENCY']]],
} ],
  '_WNF_LOCK' : [ 0x8, {
    'PushLock' : [ 0x0, ['_EX_PUSH_LOCK']],
} ],
  '_RELATION_LIST' : [ 0x10, {
    'DeviceObjectList' : [ 0x0, ['pointer64', ['_DEVICE_OBJECT_LIST']]],
    'Sorted' : [ 0x8, ['unsigned char']],
} ],
  'PEPHANDLE__' : [ 0x4, {
    'unused' : [ 0x0, ['long']],
} ],
  '_ISR_THUNK' : [ 0x8, {
    'PushImm' : [ 0x0, ['unsigned char']],
    'Vector' : [ 0x1, ['unsigned char']],
    'PushRbp' : [ 0x2, ['unsigned char']],
    'JmpOp' : [ 0x3, ['unsigned char']],
    'JmpOffset' : [ 0x4, ['long']],
} ],
  '_COMPRESSED_DATA_INFO' : [ 0xc, {
    'CompressionFormatAndEngine' : [ 0x0, ['unsigned short']],
    'CompressionUnitShift' : [ 0x2, ['unsigned char']],
    'ChunkShift' : [ 0x3, ['unsigned char']],
    'ClusterShift' : [ 0x4, ['unsigned char']],
    'Reserved' : [ 0x5, ['unsigned char']],
    'NumberOfChunks' : [ 0x6, ['unsigned short']],
    'CompressedChunkSizes' : [ 0x8, ['array', 1, ['unsigned long']]],
} ],
  '_MI_PARTITION_ZEROING' : [ 0x68, {
    'PageEvent' : [ 0x0, ['_KEVENT']],
    'ThreadActive' : [ 0x18, ['unsigned char']],
    'ThreadPriorityStatic' : [ 0x19, ['unsigned char']],
    'ZeroFreePageSlistMinimum' : [ 0x1c, ['long']],
    'RebalanceZeroFreeWorkItem' : [ 0x20, ['_WORK_QUEUE_ITEM']],
    'ThreadCount' : [ 0x40, ['long']],
    'Gate' : [ 0x48, ['_KGATE']],
    'ThreadContext' : [ 0x60, ['pointer64', ['_MI_ZERO_THREAD_CONTEXT']]],
} ],
  '_KERNEL_STACK_SEGMENT' : [ 0x20, {
    'StackBase' : [ 0x0, ['unsigned long long']],
    'StackLimit' : [ 0x8, ['unsigned long long']],
    'KernelStack' : [ 0x10, ['unsigned long long']],
    'InitialStack' : [ 0x18, ['unsigned long long']],
} ],
  '_POP_FX_DRIVER_CALLBACKS' : [ 0x40, {
    'ComponentActive' : [ 0x0, ['pointer64', ['void']]],
    'ComponentIdle' : [ 0x8, ['pointer64', ['void']]],
    'ComponentIdleState' : [ 0x10, ['pointer64', ['void']]],
    'DevicePowerRequired' : [ 0x18, ['pointer64', ['void']]],
    'DevicePowerNotRequired' : [ 0x20, ['pointer64', ['void']]],
    'PowerControl' : [ 0x28, ['pointer64', ['void']]],
    'ComponentCriticalTransition' : [ 0x30, ['pointer64', ['void']]],
    'DripsWatchdogCallback' : [ 0x38, ['pointer64', ['void']]],
} ],
  '_FAST_ERESOURCE_INTERNAL' : [ 0x68, {
    'SystemResourcesList' : [ 0x0, ['_LIST_ENTRY']],
    'ReservedPointer' : [ 0x10, ['pointer64', ['void']]],
    'ActiveCount' : [ 0x18, ['short']],
    'Flag' : [ 0x1a, ['unsigned short']],
    'SharedWaiters' : [ 0x20, ['_KWAIT_CHAIN']],
    'ExclusiveWaiters' : [ 0x28, ['_KWAIT_CHAIN']],
    'OwnerEntryListHead' : [ 0x30, ['_LIST_ENTRY']],
    'ActiveEntries' : [ 0x40, ['unsigned long']],
    'ContentionCount' : [ 0x44, ['unsigned long']],
    'NumberOfSharedWaiters' : [ 0x48, ['unsigned long']],
    'NumberOfExclusiveWaiters' : [ 0x4c, ['unsigned long']],
    'ReservedWin64OnlyPointer' : [ 0x50, ['pointer64', ['void']]],
    'Address' : [ 0x58, ['pointer64', ['void']]],
    'CreatorBackTraceIndex' : [ 0x58, ['unsigned long long']],
    'SpinLock' : [ 0x60, ['unsigned long long']],
} ],
  '_MMSUPPORT_FLAGS' : [ 0x4, {
    'WorkingSetType' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 3, native_type='unsigned char')]],
    'Reserved0' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 6, native_type='unsigned char')]],
    'MaximumWorkingSetHard' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned char')]],
    'MinimumWorkingSetHard' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
    'SessionMaster' : [ 0x1, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'TrimmerState' : [ 0x1, ['BitField', dict(start_bit = 1, end_bit = 3, native_type='unsigned char')]],
    'Reserved' : [ 0x1, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'PageStealers' : [ 0x1, ['BitField', dict(start_bit = 4, end_bit = 8, native_type='unsigned char')]],
    'u1' : [ 0x0, ['unsigned short']],
    'MemoryPriority' : [ 0x2, ['unsigned char']],
    'WsleDeleted' : [ 0x3, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'SvmEnabled' : [ 0x3, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'ForceAge' : [ 0x3, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'ForceTrim' : [ 0x3, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'NewMaximum' : [ 0x3, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'CommitReleaseState' : [ 0x3, ['BitField', dict(start_bit = 5, end_bit = 7, native_type='unsigned char')]],
    'u2' : [ 0x3, ['unsigned char']],
} ],
  '_BLOB_COUNTERS' : [ 0x8, {
    'CreatedObjects' : [ 0x0, ['unsigned long']],
    'DeletedObjects' : [ 0x4, ['unsigned long']],
} ],
  '_MI_SYSTEM_CACHE_VIEW_ATTRIBUTES' : [ 0x10, {
    'NumberOfPtes' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 6, native_type='unsigned long long')]],
    'PartitionId' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 16, native_type='unsigned long long')]],
    'Spare' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 18, native_type='unsigned long long')]],
    'SectionOffset' : [ 0x8, ['BitField', dict(start_bit = 0, end_bit = 48, native_type='unsigned long long')]],
} ],
  '_WAITING_IRP' : [ 0x40, {
    'Links' : [ 0x0, ['_LIST_ENTRY']],
    'Irp' : [ 0x10, ['pointer64', ['_IRP']]],
    'CompletionRoutine' : [ 0x18, ['pointer64', ['void']]],
    'Context' : [ 0x20, ['pointer64', ['void']]],
    'Event' : [ 0x28, ['pointer64', ['_KEVENT']]],
    'Information' : [ 0x30, ['unsigned long']],
    'BreakAllRH' : [ 0x34, ['unsigned char']],
    'OplockBreakNotify' : [ 0x35, ['unsigned char']],
    'FileObject' : [ 0x38, ['pointer64', ['_FILE_OBJECT']]],
} ],
  '_MI_DYNAMIC_BITMAP' : [ 0x48, {
    'Bitmap' : [ 0x0, ['_RTL_BITMAP_EX']],
    'MaximumSize' : [ 0x10, ['unsigned long long']],
    'Hint' : [ 0x18, ['unsigned long long']],
    'BaseVa' : [ 0x20, ['pointer64', ['void']]],
    'SizeTopDown' : [ 0x28, ['unsigned long long']],
    'HintTopDown' : [ 0x30, ['unsigned long long']],
    'BaseVaTopDown' : [ 0x38, ['pointer64', ['void']]],
    'SpinLock' : [ 0x40, ['unsigned long long']],
} ],
  '_UNEXPECTED_INTERRUPT' : [ 0x8, {
    'PushImm' : [ 0x0, ['unsigned char']],
    'Vector' : [ 0x1, ['unsigned char']],
    'PushRbp' : [ 0x2, ['unsigned char']],
    'JmpOp' : [ 0x3, ['unsigned char']],
    'JmpOffset' : [ 0x4, ['long']],
} ],
  '_WHEA_ERROR_PACKET_FLAGS' : [ 0x4, {
    'PreviousError' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Reserved1' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'HypervisorError' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'Simulated' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'PlatformPfaControl' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'PlatformDirectedOffline' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'Reserved2' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 32, native_type='unsigned long')]],
    'AsULONG' : [ 0x0, ['unsigned long']],
} ],
  '_KTIMER_EXPIRATION_TRACE' : [ 0x10, {
    'InterruptTime' : [ 0x0, ['unsigned long long']],
    'PerformanceCounter' : [ 0x8, ['_LARGE_INTEGER']],
} ],
  '_MMPTE_LIST' : [ 0x8, {
    'Valid' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'OneEntry' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long long')]],
    'filler0' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 5, native_type='unsigned long long')]],
    'Protection' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 10, native_type='unsigned long long')]],
    'Prototype' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long long')]],
    'Transition' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long long')]],
    'filler1' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 28, native_type='unsigned long long')]],
    'NextEntry' : [ 0x0, ['BitField', dict(start_bit = 28, end_bit = 64, native_type='unsigned long long')]],
} ],
  '_PLATFORM_IDLE_STATE_ACCOUNTING' : [ 0x3f0, {
    'CancelCount' : [ 0x0, ['unsigned long']],
    'FailureCount' : [ 0x4, ['unsigned long']],
    'SuccessCount' : [ 0x8, ['unsigned long']],
    'MaxTime' : [ 0x10, ['unsigned long long']],
    'MinTime' : [ 0x18, ['unsigned long long']],
    'TotalTime' : [ 0x20, ['unsigned long long']],
    'InvalidBucketIndex' : [ 0x28, ['unsigned long']],
    'SelectionStatistics' : [ 0x30, ['_PPM_SELECTION_STATISTICS']],
    'IdleTimeBuckets' : [ 0xb0, ['array', 26, ['_PROC_IDLE_STATE_BUCKET']]],
} ],
  '_FILE_STANDARD_INFORMATION' : [ 0x18, {
    'AllocationSize' : [ 0x0, ['_LARGE_INTEGER']],
    'EndOfFile' : [ 0x8, ['_LARGE_INTEGER']],
    'NumberOfLinks' : [ 0x10, ['unsigned long']],
    'DeletePending' : [ 0x14, ['unsigned char']],
    'Directory' : [ 0x15, ['unsigned char']],
} ],
  '_PROC_FEEDBACK' : [ 0x90, {
    'Lock' : [ 0x0, ['unsigned long long']],
    'CyclesLast' : [ 0x8, ['unsigned long long']],
    'CyclesActive' : [ 0x10, ['unsigned long long']],
    'Counters' : [ 0x18, ['array', 2, ['pointer64', ['_PROC_FEEDBACK_COUNTER']]]],
    'LastUpdateTime' : [ 0x28, ['unsigned long long']],
    'UnscaledTime' : [ 0x30, ['unsigned long long']],
    'UnaccountedTime' : [ 0x38, ['long long']],
    'ScaledTime' : [ 0x40, ['array', 2, ['unsigned long long']]],
    'UnaccountedKernelTime' : [ 0x50, ['unsigned long long']],
    'PerformanceScaledKernelTime' : [ 0x58, ['unsigned long long']],
    'UserTimeLast' : [ 0x60, ['unsigned long']],
    'KernelTimeLast' : [ 0x64, ['unsigned long']],
    'IdleGenerationNumberLast' : [ 0x68, ['unsigned long long']],
    'HvActiveTimeLast' : [ 0x70, ['unsigned long long']],
    'StallCyclesLast' : [ 0x78, ['unsigned long long']],
    'StallTime' : [ 0x80, ['unsigned long long']],
    'KernelTimesIndex' : [ 0x88, ['unsigned char']],
    'CounterDiscardsIdleTime' : [ 0x89, ['unsigned char']],
} ],
  '_TIMELINE_BITMAP' : [ 0x8, {
    'Value' : [ 0x0, ['unsigned long long']],
    'EndTime' : [ 0x0, ['unsigned long']],
    'Bitmap' : [ 0x4, ['unsigned long']],
} ],
  '_PROC_FEEDBACK_COUNTER' : [ 0x30, {
    'InstantaneousRead' : [ 0x0, ['pointer64', ['void']]],
    'DifferentialRead' : [ 0x0, ['pointer64', ['void']]],
    'LastActualCount' : [ 0x8, ['unsigned long long']],
    'LastReferenceCount' : [ 0x10, ['unsigned long long']],
    'CachedValue' : [ 0x18, ['unsigned long']],
    'Affinitized' : [ 0x20, ['unsigned char']],
    'Differential' : [ 0x21, ['unsigned char']],
    'DiscardIdleTime' : [ 0x22, ['unsigned char']],
    'Scaling' : [ 0x23, ['unsigned char']],
    'Context' : [ 0x28, ['unsigned long long']],
} ],
  '_DBGKD_SWITCH_PARTITION' : [ 0x4, {
    'Partition' : [ 0x0, ['unsigned long']],
} ],
  '_MI_DRIVER_VA' : [ 0x28, {
    'Next' : [ 0x0, ['pointer64', ['_MI_DRIVER_VA']]],
    'PointerPte' : [ 0x8, ['pointer64', ['_MMPTE']]],
    'BitMap' : [ 0x10, ['_RTL_BITMAP']],
    'Hint' : [ 0x20, ['unsigned long']],
    'Flags' : [ 0x24, ['unsigned long']],
} ],
  '_LEARNING_MODE_DATA' : [ 0x8, {
    'Settings' : [ 0x0, ['unsigned long']],
    'Enabled' : [ 0x4, ['unsigned char']],
    'PermissiveModeEnabled' : [ 0x5, ['unsigned char']],
} ],
  '_PEB64' : [ 0x7b8, {
    'InheritedAddressSpace' : [ 0x0, ['unsigned char']],
    'ReadImageFileExecOptions' : [ 0x1, ['unsigned char']],
    'BeingDebugged' : [ 0x2, ['unsigned char']],
    'BitField' : [ 0x3, ['unsigned char']],
    'ImageUsesLargePages' : [ 0x3, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'IsProtectedProcess' : [ 0x3, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'IsImageDynamicallyRelocated' : [ 0x3, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'SkipPatchingUser32Forwarders' : [ 0x3, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'IsPackagedProcess' : [ 0x3, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'IsAppContainer' : [ 0x3, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'IsProtectedProcessLight' : [ 0x3, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned char')]],
    'IsLongPathAwareProcess' : [ 0x3, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
    'Padding0' : [ 0x4, ['array', 4, ['unsigned char']]],
    'Mutant' : [ 0x8, ['unsigned long long']],
    'ImageBaseAddress' : [ 0x10, ['unsigned long long']],
    'Ldr' : [ 0x18, ['unsigned long long']],
    'ProcessParameters' : [ 0x20, ['unsigned long long']],
    'SubSystemData' : [ 0x28, ['unsigned long long']],
    'ProcessHeap' : [ 0x30, ['unsigned long long']],
    'FastPebLock' : [ 0x38, ['unsigned long long']],
    'AtlThunkSListPtr' : [ 0x40, ['unsigned long long']],
    'IFEOKey' : [ 0x48, ['unsigned long long']],
    'CrossProcessFlags' : [ 0x50, ['unsigned long']],
    'ProcessInJob' : [ 0x50, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'ProcessInitializing' : [ 0x50, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'ProcessUsingVEH' : [ 0x50, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'ProcessUsingVCH' : [ 0x50, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'ProcessUsingFTH' : [ 0x50, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'ProcessPreviouslyThrottled' : [ 0x50, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'ProcessCurrentlyThrottled' : [ 0x50, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'ReservedBits0' : [ 0x50, ['BitField', dict(start_bit = 7, end_bit = 32, native_type='unsigned long')]],
    'Padding1' : [ 0x54, ['array', 4, ['unsigned char']]],
    'KernelCallbackTable' : [ 0x58, ['unsigned long long']],
    'UserSharedInfoPtr' : [ 0x58, ['unsigned long long']],
    'SystemReserved' : [ 0x60, ['unsigned long']],
    'AtlThunkSListPtr32' : [ 0x64, ['unsigned long']],
    'ApiSetMap' : [ 0x68, ['unsigned long long']],
    'TlsExpansionCounter' : [ 0x70, ['unsigned long']],
    'Padding2' : [ 0x74, ['array', 4, ['unsigned char']]],
    'TlsBitmap' : [ 0x78, ['unsigned long long']],
    'TlsBitmapBits' : [ 0x80, ['array', 2, ['unsigned long']]],
    'ReadOnlySharedMemoryBase' : [ 0x88, ['unsigned long long']],
    'SharedData' : [ 0x90, ['unsigned long long']],
    'ReadOnlyStaticServerData' : [ 0x98, ['unsigned long long']],
    'AnsiCodePageData' : [ 0xa0, ['unsigned long long']],
    'OemCodePageData' : [ 0xa8, ['unsigned long long']],
    'UnicodeCaseTableData' : [ 0xb0, ['unsigned long long']],
    'NumberOfProcessors' : [ 0xb8, ['unsigned long']],
    'NtGlobalFlag' : [ 0xbc, ['unsigned long']],
    'CriticalSectionTimeout' : [ 0xc0, ['_LARGE_INTEGER']],
    'HeapSegmentReserve' : [ 0xc8, ['unsigned long long']],
    'HeapSegmentCommit' : [ 0xd0, ['unsigned long long']],
    'HeapDeCommitTotalFreeThreshold' : [ 0xd8, ['unsigned long long']],
    'HeapDeCommitFreeBlockThreshold' : [ 0xe0, ['unsigned long long']],
    'NumberOfHeaps' : [ 0xe8, ['unsigned long']],
    'MaximumNumberOfHeaps' : [ 0xec, ['unsigned long']],
    'ProcessHeaps' : [ 0xf0, ['unsigned long long']],
    'GdiSharedHandleTable' : [ 0xf8, ['unsigned long long']],
    'ProcessStarterHelper' : [ 0x100, ['unsigned long long']],
    'GdiDCAttributeList' : [ 0x108, ['unsigned long']],
    'Padding3' : [ 0x10c, ['array', 4, ['unsigned char']]],
    'LoaderLock' : [ 0x110, ['unsigned long long']],
    'OSMajorVersion' : [ 0x118, ['unsigned long']],
    'OSMinorVersion' : [ 0x11c, ['unsigned long']],
    'OSBuildNumber' : [ 0x120, ['unsigned short']],
    'OSCSDVersion' : [ 0x122, ['unsigned short']],
    'OSPlatformId' : [ 0x124, ['unsigned long']],
    'ImageSubsystem' : [ 0x128, ['unsigned long']],
    'ImageSubsystemMajorVersion' : [ 0x12c, ['unsigned long']],
    'ImageSubsystemMinorVersion' : [ 0x130, ['unsigned long']],
    'Padding4' : [ 0x134, ['array', 4, ['unsigned char']]],
    'ActiveProcessAffinityMask' : [ 0x138, ['unsigned long long']],
    'GdiHandleBuffer' : [ 0x140, ['array', 60, ['unsigned long']]],
    'PostProcessInitRoutine' : [ 0x230, ['unsigned long long']],
    'TlsExpansionBitmap' : [ 0x238, ['unsigned long long']],
    'TlsExpansionBitmapBits' : [ 0x240, ['array', 32, ['unsigned long']]],
    'SessionId' : [ 0x2c0, ['unsigned long']],
    'Padding5' : [ 0x2c4, ['array', 4, ['unsigned char']]],
    'AppCompatFlags' : [ 0x2c8, ['_ULARGE_INTEGER']],
    'AppCompatFlagsUser' : [ 0x2d0, ['_ULARGE_INTEGER']],
    'pShimData' : [ 0x2d8, ['unsigned long long']],
    'AppCompatInfo' : [ 0x2e0, ['unsigned long long']],
    'CSDVersion' : [ 0x2e8, ['_STRING64']],
    'ActivationContextData' : [ 0x2f8, ['unsigned long long']],
    'ProcessAssemblyStorageMap' : [ 0x300, ['unsigned long long']],
    'SystemDefaultActivationContextData' : [ 0x308, ['unsigned long long']],
    'SystemAssemblyStorageMap' : [ 0x310, ['unsigned long long']],
    'MinimumStackCommit' : [ 0x318, ['unsigned long long']],
    'FlsCallback' : [ 0x320, ['unsigned long long']],
    'FlsListHead' : [ 0x328, ['LIST_ENTRY64']],
    'FlsBitmap' : [ 0x338, ['unsigned long long']],
    'FlsBitmapBits' : [ 0x340, ['array', 4, ['unsigned long']]],
    'FlsHighIndex' : [ 0x350, ['unsigned long']],
    'WerRegistrationData' : [ 0x358, ['unsigned long long']],
    'WerShipAssertPtr' : [ 0x360, ['unsigned long long']],
    'pUnused' : [ 0x368, ['unsigned long long']],
    'pImageHeaderHash' : [ 0x370, ['unsigned long long']],
    'TracingFlags' : [ 0x378, ['unsigned long']],
    'HeapTracingEnabled' : [ 0x378, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'CritSecTracingEnabled' : [ 0x378, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'LibLoaderTracingEnabled' : [ 0x378, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'SpareTracingBits' : [ 0x378, ['BitField', dict(start_bit = 3, end_bit = 32, native_type='unsigned long')]],
    'Padding6' : [ 0x37c, ['array', 4, ['unsigned char']]],
    'CsrServerReadOnlySharedMemoryBase' : [ 0x380, ['unsigned long long']],
    'TppWorkerpListLock' : [ 0x388, ['unsigned long long']],
    'TppWorkerpList' : [ 0x390, ['LIST_ENTRY64']],
    'WaitOnAddressHashTable' : [ 0x3a0, ['array', 128, ['unsigned long long']]],
    'TelemetryCoverageHeader' : [ 0x7a0, ['unsigned long long']],
    'CloudFileFlags' : [ 0x7a8, ['unsigned long']],
    'CloudFileDiagFlags' : [ 0x7ac, ['unsigned long']],
    'PlaceholderCompatibilityMode' : [ 0x7b0, ['unsigned char']],
    'PlaceholderCompatibilityModeReserved' : [ 0x7b1, ['array', 7, ['unsigned char']]],
} ],
  '_M128A' : [ 0x10, {
    'Low' : [ 0x0, ['unsigned long long']],
    'High' : [ 0x8, ['long long']],
} ],
  '_ETW_REALTIME_CONSUMER' : [ 0xa0, {
    'Links' : [ 0x0, ['_LIST_ENTRY']],
    'ProcessHandle' : [ 0x10, ['pointer64', ['void']]],
    'ProcessObject' : [ 0x18, ['pointer64', ['_EPROCESS']]],
    'NextNotDelivered' : [ 0x20, ['pointer64', ['void']]],
    'RealtimeConnectContext' : [ 0x28, ['pointer64', ['void']]],
    'DisconnectEvent' : [ 0x30, ['pointer64', ['_KEVENT']]],
    'DataAvailableEvent' : [ 0x38, ['pointer64', ['_KEVENT']]],
    'UserBufferCount' : [ 0x40, ['pointer64', ['unsigned long']]],
    'UserBufferListHead' : [ 0x48, ['pointer64', ['_SINGLE_LIST_ENTRY']]],
    'BuffersLost' : [ 0x50, ['unsigned long']],
    'EmptyBuffersCount' : [ 0x54, ['unsigned long']],
    'LoggerId' : [ 0x58, ['unsigned short']],
    'Flags' : [ 0x5a, ['unsigned char']],
    'ShutDownRequested' : [ 0x5a, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'NewBuffersLost' : [ 0x5a, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'Disconnected' : [ 0x5a, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'Notified' : [ 0x5a, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'Wow' : [ 0x5a, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'ReservedBufferSpaceBitMap' : [ 0x60, ['_RTL_BITMAP']],
    'ReservedBufferSpace' : [ 0x70, ['pointer64', ['unsigned char']]],
    'ReservedBufferSpaceSize' : [ 0x78, ['unsigned long']],
    'UserPagesAllocated' : [ 0x7c, ['unsigned long']],
    'UserPagesReused' : [ 0x80, ['unsigned long']],
    'EventsLostCount' : [ 0x88, ['pointer64', ['unsigned long']]],
    'BuffersLostCount' : [ 0x90, ['pointer64', ['unsigned long']]],
    'SiloState' : [ 0x98, ['pointer64', ['_ETW_SILODRIVERSTATE']]],
} ],
  '_IA64_DBGKD_CONTROL_SET' : [ 0x14, {
    'Continue' : [ 0x0, ['unsigned long']],
    'CurrentSymbolStart' : [ 0x4, ['unsigned long long']],
    'CurrentSymbolEnd' : [ 0xc, ['unsigned long long']],
} ],
  'tagSWITCH_CONTEXT_ATTRIBUTE' : [ 0x18, {
    'ulContextUpdateCounter' : [ 0x0, ['unsigned long long']],
    'fAllowContextUpdate' : [ 0x8, ['long']],
    'fEnableTrace' : [ 0xc, ['long']],
    'EtwHandle' : [ 0x10, ['unsigned long long']],
} ],
  '_POP_HIBER_CONTEXT' : [ 0x1c8, {
    'Reset' : [ 0x0, ['unsigned char']],
    'HiberFlags' : [ 0x1, ['unsigned char']],
    'WroteHiberFile' : [ 0x2, ['unsigned char']],
    'KernelPhaseVerificationActive' : [ 0x3, ['unsigned char']],
    'InitializationFinished' : [ 0x4, ['unsigned char']],
    'NextTableLockHeld' : [ 0x8, ['long']],
    'BootPhaseFinishedBarrier' : [ 0xc, ['long']],
    'KernelResumeFinishedBarrier' : [ 0x10, ['long']],
    'HvCaptureReadyBarrier' : [ 0x14, ['long']],
    'HvCaptureCompletedBarrier' : [ 0x18, ['long']],
    'MapFrozen' : [ 0x1c, ['unsigned char']],
    'DiscardMap' : [ 0x20, ['_RTL_BITMAP']],
    'KernelPhaseMap' : [ 0x20, ['_RTL_BITMAP']],
    'BootPhaseMap' : [ 0x30, ['_RTL_BITMAP']],
    'ClonedRanges' : [ 0x40, ['_LIST_ENTRY']],
    'ClonedRangeCount' : [ 0x50, ['unsigned long']],
    'ClonedPageCount' : [ 0x58, ['unsigned long long']],
    'CurrentMap' : [ 0x60, ['pointer64', ['_RTL_BITMAP']]],
    'NextCloneRange' : [ 0x68, ['pointer64', ['_LIST_ENTRY']]],
    'NextPreserve' : [ 0x70, ['unsigned long long']],
    'LoaderMdl' : [ 0x78, ['pointer64', ['_MDL']]],
    'AllocatedMdl' : [ 0x80, ['pointer64', ['_MDL']]],
    'PagesOut' : [ 0x88, ['unsigned long long']],
    'IoPages' : [ 0x90, ['pointer64', ['void']]],
    'IoPagesCount' : [ 0x98, ['unsigned long']],
    'CurrentMcb' : [ 0xa0, ['pointer64', ['void']]],
    'DumpStack' : [ 0xa8, ['pointer64', ['_DUMP_STACK_CONTEXT']]],
    'WakeState' : [ 0xb0, ['pointer64', ['_KPROCESSOR_STATE']]],
    'IoProgress' : [ 0xb8, ['unsigned long']],
    'Status' : [ 0xbc, ['long']],
    'GraphicsProc' : [ 0xc0, ['unsigned long']],
    'MemoryImage' : [ 0xc8, ['pointer64', ['PO_MEMORY_IMAGE']]],
    'PerformanceStats' : [ 0xd0, ['pointer64', ['unsigned long']]],
    'BootLoaderLogMdl' : [ 0xd8, ['pointer64', ['_MDL']]],
    'FirmwareRuntimeInformationMdl' : [ 0xe0, ['pointer64', ['_MDL']]],
    'FirmwareRuntimeInformationVa' : [ 0xe8, ['pointer64', ['void']]],
    'ResumeContext' : [ 0xf0, ['pointer64', ['void']]],
    'ResumeContextPages' : [ 0xf8, ['unsigned long']],
    'SecurePages' : [ 0xfc, ['unsigned long']],
    'ProcessorCount' : [ 0x100, ['unsigned long']],
    'ProcessorContext' : [ 0x108, ['pointer64', ['_POP_PER_PROCESSOR_CONTEXT']]],
    'ProdConsBuffer' : [ 0x110, ['pointer64', ['unsigned char']]],
    'ProdConsSize' : [ 0x118, ['unsigned long']],
    'MaxDataPages' : [ 0x11c, ['unsigned long']],
    'ExtraBuffer' : [ 0x120, ['pointer64', ['void']]],
    'ExtraBufferSize' : [ 0x128, ['unsigned long long']],
    'ExtraMapVa' : [ 0x130, ['pointer64', ['void']]],
    'BitlockerKeyPFN' : [ 0x138, ['unsigned long long']],
    'IoInfo' : [ 0x140, ['_POP_IO_INFO']],
    'IoChecksums' : [ 0x1b0, ['pointer64', ['unsigned short']]],
    'IoChecksumsSize' : [ 0x1b8, ['unsigned long long']],
    'HardwareConfigurationSignature' : [ 0x1c0, ['unsigned long']],
    'IumEnabled' : [ 0x1c4, ['unsigned char']],
    'SecureBoot' : [ 0x1c5, ['unsigned char']],
} ],
  '_SEP_CACHED_HANDLES_TABLE' : [ 0x10, {
    'Lock' : [ 0x0, ['_EX_PUSH_LOCK']],
    'HashTable' : [ 0x8, ['pointer64', ['_RTL_DYNAMIC_HASH_TABLE']]],
} ],
  '_PPM_FFH_THROTTLE_STATE_INFO' : [ 0x20, {
    'EnableLogging' : [ 0x0, ['unsigned char']],
    'MismatchCount' : [ 0x4, ['unsigned long']],
    'Initialized' : [ 0x8, ['unsigned char']],
    'LastValue' : [ 0x10, ['unsigned long long']],
    'LastLogTickCount' : [ 0x18, ['_LARGE_INTEGER']],
} ],
  '__unnamed_2a70' : [ 0x4, {
    'Active' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'OnlyTryAcquireUsed' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'ReleasedOutOfOrder' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'SequenceNumber' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 32, native_type='unsigned long')]],
    'Whole' : [ 0x0, ['unsigned long']],
} ],
  '_VI_DEADLOCK_NODE' : [ 0xd0, {
    'Parent' : [ 0x0, ['pointer64', ['_VI_DEADLOCK_NODE']]],
    'ChildrenList' : [ 0x8, ['_LIST_ENTRY']],
    'SiblingsList' : [ 0x18, ['_LIST_ENTRY']],
    'ResourceList' : [ 0x28, ['_LIST_ENTRY']],
    'FreeListEntry' : [ 0x28, ['_LIST_ENTRY']],
    'Root' : [ 0x38, ['pointer64', ['_VI_DEADLOCK_RESOURCE']]],
    'ThreadEntry' : [ 0x40, ['pointer64', ['_VI_DEADLOCK_THREAD']]],
    'u1' : [ 0x48, ['__unnamed_2a70']],
    'ChildrenCount' : [ 0x4c, ['long']],
    'StackTrace' : [ 0x50, ['array', 8, ['pointer64', ['void']]]],
    'ParentStackTrace' : [ 0x90, ['array', 8, ['pointer64', ['void']]]],
} ],
  '_RTL_TIME_ZONE_INFORMATION' : [ 0xac, {
    'Bias' : [ 0x0, ['long']],
    'StandardName' : [ 0x4, ['array', 32, ['wchar']]],
    'StandardStart' : [ 0x44, ['_TIME_FIELDS']],
    'StandardBias' : [ 0x54, ['long']],
    'DaylightName' : [ 0x58, ['array', 32, ['wchar']]],
    'DaylightStart' : [ 0x98, ['_TIME_FIELDS']],
    'DaylightBias' : [ 0xa8, ['long']],
} ],
  '_VF_AVL_TREE_NODE' : [ 0x10, {
    'p' : [ 0x0, ['pointer64', ['void']]],
    'RangeSize' : [ 0x8, ['unsigned long long']],
} ],
  '_MI_PARTITION_COMMIT' : [ 0x80, {
    'PeakCommitment' : [ 0x0, ['unsigned long long']],
    'TotalCommitLimitMaximum' : [ 0x8, ['unsigned long long']],
    'Popups' : [ 0x10, ['array', 2, ['long']]],
    'LowCommitThreshold' : [ 0x18, ['unsigned long long']],
    'HighCommitThreshold' : [ 0x20, ['unsigned long long']],
    'EventLock' : [ 0x28, ['unsigned long long']],
    'SystemCommitReserve' : [ 0x30, ['unsigned long long']],
    'OverCommit' : [ 0x40, ['unsigned long long']],
} ],
  '_TRIAGE_DEVICE_NODE' : [ 0x58, {
    'Sibling' : [ 0x0, ['pointer64', ['_TRIAGE_DEVICE_NODE']]],
    'Child' : [ 0x8, ['pointer64', ['_TRIAGE_DEVICE_NODE']]],
    'Parent' : [ 0x10, ['pointer64', ['_TRIAGE_DEVICE_NODE']]],
    'LastChild' : [ 0x18, ['pointer64', ['_TRIAGE_DEVICE_NODE']]],
    'PhysicalDeviceObject' : [ 0x20, ['pointer64', ['_DEVICE_OBJECT']]],
    'InstancePath' : [ 0x28, ['_UNICODE_STRING']],
    'ServiceName' : [ 0x38, ['_UNICODE_STRING']],
    'PendingIrp' : [ 0x48, ['pointer64', ['_IRP']]],
    'FxDevice' : [ 0x50, ['pointer64', ['_TRIAGE_POP_FX_DEVICE']]],
} ],
  '_DIAGNOSTIC_BUFFER' : [ 0x28, {
    'Size' : [ 0x0, ['unsigned long long']],
    'CallerType' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {0: u'KernelRequester', 1: u'UserProcessRequester', 2: u'UserSharedServiceRequester'})]],
    'ProcessImageNameOffset' : [ 0x10, ['unsigned long long']],
    'ProcessId' : [ 0x18, ['unsigned long']],
    'ServiceTag' : [ 0x1c, ['unsigned long']],
    'DeviceDescriptionOffset' : [ 0x10, ['unsigned long long']],
    'DevicePathOffset' : [ 0x18, ['unsigned long long']],
    'ReasonOffset' : [ 0x20, ['unsigned long long']],
} ],
  '_MMEXTEND_INFO' : [ 0x10, {
    'CommittedSize' : [ 0x0, ['unsigned long long']],
    'ReferenceCount' : [ 0x8, ['unsigned long']],
} ],
  '_WHEA_ERROR_RECORD_HEADER_VALIDBITS' : [ 0x4, {
    'PlatformId' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Timestamp' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'PartitionId' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 32, native_type='unsigned long')]],
    'AsULONG' : [ 0x0, ['unsigned long']],
} ],
  '_ARBITER_ALTERNATIVE' : [ 0x40, {
    'Minimum' : [ 0x0, ['unsigned long long']],
    'Maximum' : [ 0x8, ['unsigned long long']],
    'Length' : [ 0x10, ['unsigned long long']],
    'Alignment' : [ 0x18, ['unsigned long long']],
    'Priority' : [ 0x20, ['long']],
    'Flags' : [ 0x24, ['unsigned long']],
    'Descriptor' : [ 0x28, ['pointer64', ['_IO_RESOURCE_DESCRIPTOR']]],
    'Reserved' : [ 0x30, ['array', 3, ['unsigned long']]],
} ],
  '_DBGKD_GET_VERSION64' : [ 0x28, {
    'MajorVersion' : [ 0x0, ['unsigned short']],
    'MinorVersion' : [ 0x2, ['unsigned short']],
    'ProtocolVersion' : [ 0x4, ['unsigned char']],
    'KdSecondaryVersion' : [ 0x5, ['unsigned char']],
    'Flags' : [ 0x6, ['unsigned short']],
    'MachineType' : [ 0x8, ['unsigned short']],
    'MaxPacketType' : [ 0xa, ['unsigned char']],
    'MaxStateChange' : [ 0xb, ['unsigned char']],
    'MaxManipulate' : [ 0xc, ['unsigned char']],
    'Simulation' : [ 0xd, ['unsigned char']],
    'Unused' : [ 0xe, ['array', 1, ['unsigned short']]],
    'KernBase' : [ 0x10, ['unsigned long long']],
    'PsLoadedModuleList' : [ 0x18, ['unsigned long long']],
    'DebuggerDataList' : [ 0x20, ['unsigned long long']],
} ],
  '_POP_SHUTDOWN_BUG_CHECK' : [ 0x48, {
    'InitiatingThread' : [ 0x0, ['pointer64', ['_ETHREAD']]],
    'InitiatingProcess' : [ 0x8, ['pointer64', ['_EPROCESS']]],
    'ThreadId' : [ 0x10, ['pointer64', ['void']]],
    'ProcessId' : [ 0x18, ['pointer64', ['void']]],
    'Code' : [ 0x20, ['unsigned long']],
    'Parameter1' : [ 0x28, ['unsigned long long']],
    'Parameter2' : [ 0x30, ['unsigned long long']],
    'Parameter3' : [ 0x38, ['unsigned long long']],
    'Parameter4' : [ 0x40, ['unsigned long long']],
} ],
  '_OBJECT_CREATE_INFORMATION' : [ 0x40, {
    'Attributes' : [ 0x0, ['unsigned long']],
    'RootDirectory' : [ 0x8, ['pointer64', ['void']]],
    'ProbeMode' : [ 0x10, ['unsigned char']],
    'PagedPoolCharge' : [ 0x14, ['unsigned long']],
    'NonPagedPoolCharge' : [ 0x18, ['unsigned long']],
    'SecurityDescriptorCharge' : [ 0x1c, ['unsigned long']],
    'SecurityDescriptor' : [ 0x20, ['pointer64', ['void']]],
    'SecurityQos' : [ 0x28, ['pointer64', ['_SECURITY_QUALITY_OF_SERVICE']]],
    'SecurityQualityOfService' : [ 0x30, ['_SECURITY_QUALITY_OF_SERVICE']],
} ],
  '_ETW_FILTER_STRING_TOKEN_ELEMENT' : [ 0x10, {
    'Length' : [ 0x0, ['unsigned short']],
    'String' : [ 0x8, ['pointer64', ['wchar']]],
} ],
  '_VI_DEADLOCK_GLOBALS' : [ 0x8180, {
    'TimeAcquire' : [ 0x0, ['long long']],
    'TimeRelease' : [ 0x8, ['long long']],
    'ResourceDatabase' : [ 0x10, ['pointer64', ['_LIST_ENTRY']]],
    'ResourceDatabaseCount' : [ 0x18, ['unsigned long long']],
    'ResourceAddressRange' : [ 0x20, ['array', 1023, ['_VF_ADDRESS_RANGE']]],
    'ThreadDatabase' : [ 0x4010, ['pointer64', ['_LIST_ENTRY']]],
    'ThreadDatabaseCount' : [ 0x4018, ['unsigned long long']],
    'ThreadAddressRange' : [ 0x4020, ['array', 1023, ['_VF_ADDRESS_RANGE']]],
    'AllocationFailures' : [ 0x8010, ['unsigned long']],
    'NodesTrimmedBasedOnAge' : [ 0x8014, ['unsigned long']],
    'NodesTrimmedBasedOnCount' : [ 0x8018, ['unsigned long']],
    'NodesSearched' : [ 0x801c, ['unsigned long']],
    'MaxNodesSearched' : [ 0x8020, ['unsigned long']],
    'SequenceNumber' : [ 0x8024, ['unsigned long']],
    'RecursionDepthLimit' : [ 0x8028, ['unsigned long']],
    'SearchedNodesLimit' : [ 0x802c, ['unsigned long']],
    'DepthLimitHits' : [ 0x8030, ['unsigned long']],
    'SearchLimitHits' : [ 0x8034, ['unsigned long']],
    'StackLimitHits' : [ 0x8038, ['unsigned long']],
    'ABC_ACB_Skipped' : [ 0x803c, ['unsigned long']],
    'OutOfOrderReleases' : [ 0x8040, ['unsigned long']],
    'NodesReleasedOutOfOrder' : [ 0x8044, ['unsigned long']],
    'TotalReleases' : [ 0x8048, ['unsigned long']],
    'RootNodesDeleted' : [ 0x804c, ['unsigned long']],
    'ForgetHistoryCounter' : [ 0x8050, ['unsigned long']],
    'Instigator' : [ 0x8058, ['pointer64', ['void']]],
    'NumberOfParticipants' : [ 0x8060, ['unsigned long']],
    'Participant' : [ 0x8068, ['array', 32, ['pointer64', ['_VI_DEADLOCK_NODE']]]],
    'ChildrenCountWatermark' : [ 0x8168, ['long']],
    'StackType' : [ 0x816c, ['Enumeration', dict(target = 'long', choices = {0: u'BugcheckStackLimits', 1: u'DPCStackLimits', 2: u'ExpandedStackLimits', 3: u'NormalStackLimits', 4: u'Win32kStackLimits', 5: u'SwapBusyStackLimits', 6: u'IsrStackLimits', 7: u'DebuggerStackLimits', 8: u'MaximumStackLimits'})]],
    'StackLowLimit' : [ 0x8170, ['unsigned long long']],
    'StackHighLimit' : [ 0x8178, ['unsigned long long']],
} ],
  'DOCK_INTERFACE' : [ 0x30, {
    'Size' : [ 0x0, ['unsigned short']],
    'Version' : [ 0x2, ['unsigned short']],
    'Context' : [ 0x8, ['pointer64', ['void']]],
    'InterfaceReference' : [ 0x10, ['pointer64', ['void']]],
    'InterfaceDereference' : [ 0x18, ['pointer64', ['void']]],
    'ProfileDepartureSetMode' : [ 0x20, ['pointer64', ['void']]],
    'ProfileDepartureUpdate' : [ 0x28, ['pointer64', ['void']]],
} ],
  'PO_MEMORY_IMAGE' : [ 0x3d8, {
    'Signature' : [ 0x0, ['unsigned long']],
    'ImageType' : [ 0x4, ['unsigned long']],
    'CheckSum' : [ 0x8, ['unsigned long']],
    'LengthSelf' : [ 0xc, ['unsigned long']],
    'PageSelf' : [ 0x10, ['unsigned long long']],
    'PageSize' : [ 0x18, ['unsigned long']],
    'SystemTime' : [ 0x20, ['_LARGE_INTEGER']],
    'InterruptTime' : [ 0x28, ['unsigned long long']],
    'FeatureFlags' : [ 0x30, ['unsigned long long']],
    'HiberFlags' : [ 0x38, ['unsigned char']],
    'spare' : [ 0x39, ['array', 3, ['unsigned char']]],
    'NoHiberPtes' : [ 0x3c, ['unsigned long']],
    'HiberVa' : [ 0x40, ['unsigned long long']],
    'NoFreePages' : [ 0x48, ['unsigned long']],
    'FreeMapCheck' : [ 0x4c, ['unsigned long']],
    'WakeCheck' : [ 0x50, ['unsigned long']],
    'NumPagesForLoader' : [ 0x58, ['unsigned long long']],
    'FirstSecureRestorePage' : [ 0x60, ['unsigned long long']],
    'FirstBootRestorePage' : [ 0x68, ['unsigned long long']],
    'FirstKernelRestorePage' : [ 0x70, ['unsigned long long']],
    'FirstChecksumRestorePage' : [ 0x78, ['unsigned long long']],
    'NoChecksumEntries' : [ 0x80, ['unsigned long long']],
    'PerfInfo' : [ 0x88, ['_PO_HIBER_PERF']],
    'FirmwareRuntimeInformationPages' : [ 0x280, ['unsigned long']],
    'FirmwareRuntimeInformation' : [ 0x288, ['array', 1, ['unsigned long long']]],
    'SpareUlong' : [ 0x290, ['unsigned long']],
    'NoBootLoaderLogPages' : [ 0x294, ['unsigned long']],
    'BootLoaderLogPages' : [ 0x298, ['array', 24, ['unsigned long long']]],
    'NotUsed' : [ 0x358, ['unsigned long']],
    'ResumeContextCheck' : [ 0x35c, ['unsigned long']],
    'ResumeContextPages' : [ 0x360, ['unsigned long']],
    'Hiberboot' : [ 0x364, ['unsigned char']],
    'SecureLaunched' : [ 0x365, ['unsigned char']],
    'SecureBoot' : [ 0x366, ['unsigned char']],
    'HvCr3' : [ 0x368, ['unsigned long long']],
    'HvEntryPoint' : [ 0x370, ['unsigned long long']],
    'HvReservedTransitionAddress' : [ 0x378, ['unsigned long long']],
    'HvReservedTransitionAddressSize' : [ 0x380, ['unsigned long long']],
    'BootFlags' : [ 0x388, ['unsigned long long']],
    'RestoreProcessorStateRoutine' : [ 0x390, ['unsigned long long']],
    'HighestPhysicalPage' : [ 0x398, ['unsigned long long']],
    'BitlockerKeyPfns' : [ 0x3a0, ['array', 4, ['unsigned long long']]],
    'HardwareSignature' : [ 0x3c0, ['unsigned long']],
    'SMBiosTablePhysicalAddress' : [ 0x3c8, ['_LARGE_INTEGER']],
    'SMBiosTableLength' : [ 0x3d0, ['unsigned long']],
    'SMBiosMajorVersion' : [ 0x3d4, ['unsigned char']],
    'SMBiosMinorVersion' : [ 0x3d5, ['unsigned char']],
    'HiberResumeXhciHandoffSkip' : [ 0x3d6, ['unsigned char']],
} ],
  'DEBUG_MEMORY_REQUIREMENTS' : [ 0x20, {
    'Start' : [ 0x0, ['_LARGE_INTEGER']],
    'MaxEnd' : [ 0x8, ['_LARGE_INTEGER']],
    'VirtualAddress' : [ 0x10, ['pointer64', ['void']]],
    'Length' : [ 0x18, ['unsigned long']],
    'Cached' : [ 0x1c, ['unsigned char']],
    'Aligned' : [ 0x1d, ['unsigned char']],
} ],
  'DEBUG_DEVICE_ADDRESS' : [ 0x18, {
    'Type' : [ 0x0, ['unsigned char']],
    'Valid' : [ 0x1, ['unsigned char']],
    'Reserved' : [ 0x2, ['array', 2, ['unsigned char']]],
    'BitWidth' : [ 0x2, ['unsigned char']],
    'AccessSize' : [ 0x3, ['unsigned char']],
    'TranslatedAddress' : [ 0x8, ['pointer64', ['unsigned char']]],
    'Length' : [ 0x10, ['unsigned long']],
} ],
  'PROCESSOR_IDLESTATE_INFO' : [ 0x8, {
    'TimeCheck' : [ 0x0, ['unsigned long']],
    'DemotePercent' : [ 0x4, ['unsigned char']],
    'PromotePercent' : [ 0x5, ['unsigned char']],
    'Spare' : [ 0x6, ['array', 2, ['unsigned char']]],
} ],
  'POWER_ACTION_POLICY' : [ 0xc, {
    'Action' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: u'PowerActionNone', 1: u'PowerActionReserved', 2: u'PowerActionSleep', 3: u'PowerActionHibernate', 4: u'PowerActionShutdown', 5: u'PowerActionShutdownReset', 6: u'PowerActionShutdownOff', 7: u'PowerActionWarmEject', 8: u'PowerActionDisplayOff'})]],
    'Flags' : [ 0x4, ['unsigned long']],
    'EventCode' : [ 0x8, ['unsigned long']],
} ],
  'BATTERY_REPORTING_SCALE' : [ 0x8, {
    'Granularity' : [ 0x0, ['unsigned long']],
    'Capacity' : [ 0x4, ['unsigned long']],
} ],
  '_KTIMER' : [ 0x40, {
    'Header' : [ 0x0, ['_DISPATCHER_HEADER']],
    'DueTime' : [ 0x18, ['_ULARGE_INTEGER']],
    'TimerListEntry' : [ 0x20, ['_LIST_ENTRY']],
    'Dpc' : [ 0x30, ['pointer64', ['_KDPC']]],
    'Processor' : [ 0x38, ['unsigned long']],
    'Period' : [ 0x3c, ['unsigned long']],
} ],
  '_IMAGE_SECURITY_CONTEXT' : [ 0x8, {
    'PageHashes' : [ 0x0, ['pointer64', ['void']]],
    'Value' : [ 0x0, ['unsigned long long']],
    'SecurityBeingCreated' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 2, native_type='unsigned long long')]],
    'SecurityMandatory' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long long')]],
    'PageHashPointer' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 64, native_type='unsigned long long')]],
} ],
  '_ARBITER_LIST_ENTRY' : [ 0x60, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'AlternativeCount' : [ 0x10, ['unsigned long']],
    'Alternatives' : [ 0x18, ['pointer64', ['_IO_RESOURCE_DESCRIPTOR']]],
    'PhysicalDeviceObject' : [ 0x20, ['pointer64', ['_DEVICE_OBJECT']]],
    'RequestSource' : [ 0x28, ['Enumeration', dict(target = 'long', choices = {0: u'ArbiterRequestLegacyReported', 1: u'ArbiterRequestHalReported', 2: u'ArbiterRequestLegacyAssigned', 3: u'ArbiterRequestPnpDetected', 4: u'ArbiterRequestPnpEnumerated', -1: u'ArbiterRequestUndefined'})]],
    'Flags' : [ 0x2c, ['unsigned long']],
    'WorkSpace' : [ 0x30, ['long long']],
    'InterfaceType' : [ 0x38, ['Enumeration', dict(target = 'long', choices = {0: u'Internal', 1: u'Isa', 2: u'Eisa', 3: u'MicroChannel', 4: u'TurboChannel', 5: u'PCIBus', 6: u'VMEBus', 7: u'NuBus', 8: u'PCMCIABus', 9: u'CBus', 10: u'MPIBus', 11: u'MPSABus', 12: u'ProcessorInternal', 13: u'InternalPowerBus', 14: u'PNPISABus', 15: u'PNPBus', 16: u'Vmcs', 17: u'ACPIBus', 18: u'MaximumInterfaceType', -1: u'InterfaceTypeUndefined'})]],
    'SlotNumber' : [ 0x3c, ['unsigned long']],
    'BusNumber' : [ 0x40, ['unsigned long']],
    'Assignment' : [ 0x48, ['pointer64', ['_CM_PARTIAL_RESOURCE_DESCRIPTOR']]],
    'SelectedAlternative' : [ 0x50, ['pointer64', ['_IO_RESOURCE_DESCRIPTOR']]],
    'Result' : [ 0x58, ['Enumeration', dict(target = 'long', choices = {0: u'ArbiterResultSuccess', 1: u'ArbiterResultExternalConflict', 2: u'ArbiterResultNullRequest', -1: u'ArbiterResultUndefined'})]],
} ],
  '_MI_PAGING_IO_STATE' : [ 0x50, {
    'PageFileHead' : [ 0x0, ['_RTL_AVL_TREE']],
    'PageFileHeadSpinLock' : [ 0x8, ['long']],
    'PrefetchSeekThreshold' : [ 0xc, ['long']],
    'InPageSupportSListHead' : [ 0x10, ['array', 2, ['_SLIST_HEADER']]],
    'InPageSupportSListMinimum' : [ 0x30, ['array', 2, ['unsigned char']]],
    'InPageSinglePages' : [ 0x34, ['unsigned long']],
    'DelayPageFaults' : [ 0x38, ['long']],
    'FileCompressionBoundary' : [ 0x3c, ['unsigned long']],
    'MdlsAdjusted' : [ 0x40, ['unsigned char']],
} ],
  '_MI_STANDBY_STATE' : [ 0x90, {
    'FirstDecayPage' : [ 0x0, ['unsigned long long']],
    'PfnDecayFreeSList' : [ 0x10, ['_SLIST_HEADER']],
    'PfnRepurposeLog' : [ 0x20, ['pointer64', ['_MM_PAGE_ACCESS_INFO_HEADER']]],
    'AllocatePfnRepurposeDpc' : [ 0x28, ['_KDPC']],
    'PageHeatListSlist' : [ 0x70, ['_SLIST_HEADER']],
    'PageHeatListDisableAllocation' : [ 0x80, ['long']],
} ],
  '_MI_DECAY_TIMER_LINKAGE' : [ 0x8, {
    'Spare0' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'PreviousDecayPfn' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 32, native_type='unsigned long long')]],
    'Spare1' : [ 0x0, ['BitField', dict(start_bit = 32, end_bit = 33, native_type='unsigned long long')]],
    'NextDecayPfn' : [ 0x0, ['BitField', dict(start_bit = 33, end_bit = 64, native_type='unsigned long long')]],
} ],
  '_SECURITY_DESCRIPTOR_RELATIVE' : [ 0x14, {
    'Revision' : [ 0x0, ['unsigned char']],
    'Sbz1' : [ 0x1, ['unsigned char']],
    'Control' : [ 0x2, ['unsigned short']],
    'Owner' : [ 0x4, ['unsigned long']],
    'Group' : [ 0x8, ['unsigned long']],
    'Sacl' : [ 0xc, ['unsigned long']],
    'Dacl' : [ 0x10, ['unsigned long']],
} ],
  '_PRIVATE_CACHE_MAP_FLAGS' : [ 0x4, {
    'DontUse' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 16, native_type='unsigned long')]],
    'ReadAheadActive' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'ReadAheadEnabled' : [ 0x0, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'PagePriority' : [ 0x0, ['BitField', dict(start_bit = 18, end_bit = 21, native_type='unsigned long')]],
    'PipelineReadAheads' : [ 0x0, ['BitField', dict(start_bit = 21, end_bit = 22, native_type='unsigned long')]],
    'Available' : [ 0x0, ['BitField', dict(start_bit = 22, end_bit = 32, native_type='unsigned long')]],
} ],
  '_KENTROPY_TIMING_STATE' : [ 0x150, {
    'EntropyCount' : [ 0x0, ['unsigned long']],
    'Buffer' : [ 0x4, ['array', 64, ['unsigned long']]],
    'Dpc' : [ 0x108, ['_KDPC']],
    'LastDeliveredBuffer' : [ 0x148, ['unsigned long']],
} ],
  '_DBGKD_CONTEXT_EX' : [ 0xc, {
    'Offset' : [ 0x0, ['unsigned long']],
    'ByteCount' : [ 0x4, ['unsigned long']],
    'BytesCopied' : [ 0x8, ['unsigned long']],
} ],
  '_PROCESSOR_IDLE_DEPENDENCY' : [ 0x8, {
    'ProcessorIndex' : [ 0x0, ['unsigned long']],
    'ExpectedState' : [ 0x4, ['unsigned char']],
    'AllowDeeperStates' : [ 0x5, ['unsigned char']],
    'LooseDependency' : [ 0x6, ['unsigned char']],
} ],
  '_TRIAGE_9F_POWER' : [ 0x28, {
    'Signature' : [ 0x0, ['unsigned short']],
    'Revision' : [ 0x2, ['unsigned short']],
    'IrpList' : [ 0x8, ['pointer64', ['_LIST_ENTRY']]],
    'ThreadList' : [ 0x10, ['pointer64', ['_LIST_ENTRY']]],
    'DelayedWorkQueue' : [ 0x18, ['pointer64', ['_TRIAGE_EX_WORK_QUEUE']]],
    'DelayedIoWorkQueue' : [ 0x20, ['pointer64', ['_TRIAGE_EX_WORK_QUEUE']]],
} ],
  '_EXT_IOMMU_DEVICE_ID_PCI' : [ 0x10, {
    'AsUINT64' : [ 0x0, ['unsigned long long']],
    'PciSegmentNumber' : [ 0x0, ['unsigned short']],
    'PhantomFunctionBits' : [ 0x2, ['BitField', dict(start_bit = 0, end_bit = 2, native_type='unsigned short')]],
    'BusRange' : [ 0x2, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned short')]],
    'DevicePathLength' : [ 0x2, ['BitField', dict(start_bit = 3, end_bit = 8, native_type='unsigned short')]],
    'StartBusNumber' : [ 0x2, ['BitField', dict(start_bit = 8, end_bit = 16, native_type='unsigned short')]],
    'Bdf' : [ 0x4, ['unsigned short']],
    'SubordinateBus' : [ 0x4, ['unsigned char']],
    'SecondaryBus' : [ 0x5, ['unsigned char']],
    'DevicePath' : [ 0x8, ['pointer64', ['unsigned short']]],
} ],
  '_MMINPAGE_SUPPORT_FLOW_THROUGH' : [ 0x38, {
    'Page' : [ 0x0, ['array', 1, ['unsigned long long']]],
    'InitialInPageSupport' : [ 0x8, ['pointer64', ['_MMINPAGE_SUPPORT']]],
    'PagingFile' : [ 0x10, ['pointer64', ['_MMPAGING_FILE']]],
    'PageFileOffset' : [ 0x18, ['unsigned long long']],
    'Node' : [ 0x20, ['_RTL_BALANCED_NODE']],
} ],
  '_MI_COMBINE_STATE' : [ 0x18, {
    'ActiveSpinLock' : [ 0x0, ['long']],
    'CombiningThreadCount' : [ 0x4, ['unsigned long']],
    'ActiveThreadTree' : [ 0x8, ['_RTL_AVL_TREE']],
    'ZeroPageHashValue' : [ 0x10, ['unsigned long long']],
} ],
  '_ETW_PAYLOAD_FILTER' : [ 0x58, {
    'RefCount' : [ 0x0, ['long']],
    'PayloadFilter' : [ 0x8, ['_AGGREGATED_PAYLOAD_FILTER']],
} ],
  '_HANDLE_TRACE_DB_ENTRY' : [ 0xa0, {
    'ClientId' : [ 0x0, ['_CLIENT_ID']],
    'Handle' : [ 0x10, ['pointer64', ['void']]],
    'Type' : [ 0x18, ['unsigned long']],
    'StackTrace' : [ 0x20, ['array', 16, ['pointer64', ['void']]]],
} ],
  '_PTE_TRACKER' : [ 0x80, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'Mdl' : [ 0x10, ['pointer64', ['_MDL']]],
    'Count' : [ 0x18, ['unsigned long long']],
    'SystemVa' : [ 0x20, ['pointer64', ['void']]],
    'StartVa' : [ 0x28, ['pointer64', ['void']]],
    'Offset' : [ 0x30, ['unsigned long']],
    'Length' : [ 0x34, ['unsigned long']],
    'Page' : [ 0x38, ['unsigned long long']],
    'IoMapping' : [ 0x40, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Matched' : [ 0x40, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'CacheAttribute' : [ 0x40, ['BitField', dict(start_bit = 2, end_bit = 4, native_type='unsigned long')]],
    'GuardPte' : [ 0x40, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'Spare' : [ 0x40, ['BitField', dict(start_bit = 5, end_bit = 32, native_type='unsigned long')]],
    'StackTrace' : [ 0x48, ['array', 7, ['pointer64', ['void']]]],
} ],
  '_WHEA_IPF_CMC_DESCRIPTOR' : [ 0x4, {
    'Type' : [ 0x0, ['unsigned short']],
    'Enabled' : [ 0x2, ['unsigned char']],
    'Reserved' : [ 0x3, ['unsigned char']],
} ],
  '_HIVE_WAIT_PACKET' : [ 0x28, {
    'WakeEvent' : [ 0x0, ['_KEVENT']],
    'Status' : [ 0x18, ['long']],
    'Next' : [ 0x20, ['pointer64', ['_HIVE_WAIT_PACKET']]],
} ],
  '_VF_AVL_TREE_NODE_EX' : [ 0x18, {
    'Base' : [ 0x0, ['_VF_AVL_TREE_NODE']],
    'SessionId' : [ 0x10, ['unsigned long']],
} ],
  '_VACB_ARRAY_HEADER' : [ 0x10, {
    'VacbArrayIndex' : [ 0x0, ['unsigned long']],
    'MappingCount' : [ 0x4, ['unsigned long']],
    'HighestMappedIndex' : [ 0x8, ['unsigned long']],
    'Reserved' : [ 0xc, ['unsigned long']],
} ],
  '_CM_INDEX' : [ 0x8, {
    'Cell' : [ 0x0, ['unsigned long']],
    'NameHint' : [ 0x4, ['_CM_FAST_LEAF_HINT']],
    'HashKey' : [ 0x4, ['_CM_COMPONENT_HASH']],
} ],
  '_ETW_BUFFER_CONTEXT' : [ 0x4, {
    'ProcessorNumber' : [ 0x0, ['unsigned char']],
    'Alignment' : [ 0x1, ['unsigned char']],
    'ProcessorIndex' : [ 0x0, ['unsigned short']],
    'LoggerId' : [ 0x2, ['unsigned short']],
} ],
  '_MMPAGING_FILE' : [ 0x120, {
    'Size' : [ 0x0, ['unsigned long long']],
    'MaximumSize' : [ 0x8, ['unsigned long long']],
    'MinimumSize' : [ 0x10, ['unsigned long long']],
    'FreeSpace' : [ 0x18, ['unsigned long long']],
    'PeakUsage' : [ 0x20, ['unsigned long long']],
    'HighestPage' : [ 0x28, ['unsigned long long']],
    'FreeReservationSpace' : [ 0x30, ['unsigned long long']],
    'File' : [ 0x38, ['pointer64', ['_FILE_OBJECT']]],
    'Entry' : [ 0x40, ['array', 2, ['pointer64', ['_MMMOD_WRITER_MDL_ENTRY']]]],
    'PfnsToFree' : [ 0x50, ['_SLIST_HEADER']],
    'PageFileName' : [ 0x60, ['_UNICODE_STRING']],
    'Bitmaps' : [ 0x70, ['pointer64', ['_MI_PAGING_FILE_SPACE_BITMAPS']]],
    'AllocationBitmapHint' : [ 0x78, ['unsigned long']],
    'LargestAllocationCluster' : [ 0x7c, ['unsigned long']],
    'RefreshAllocationCluster' : [ 0x80, ['unsigned long']],
    'LastRefreshAllocationCluster' : [ 0x84, ['unsigned long']],
    'ReservedClusterSizeAggregate' : [ 0x88, ['unsigned long']],
    'MaximumRunLengthInBitmaps' : [ 0x8c, ['unsigned long']],
    'BitmapsCacheLengthTree' : [ 0x90, ['_RTL_RB_TREE']],
    'BitmapsCacheLocationTree' : [ 0xa0, ['_RTL_RB_TREE']],
    'BitmapsCacheFreeList' : [ 0xb0, ['_LIST_ENTRY']],
    'BitmapsCacheEntries' : [ 0xc0, ['pointer64', ['_MI_PAGEFILE_BITMAPS_CACHE_ENTRY']]],
    'ToBeEvictedCount' : [ 0xc8, ['unsigned long']],
    'HybridPriority' : [ 0xc8, ['unsigned long']],
    'PageFileNumber' : [ 0xcc, ['BitField', dict(start_bit = 0, end_bit = 4, native_type='unsigned short')]],
    'WsSwapPagefile' : [ 0xcc, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned short')]],
    'NoReservations' : [ 0xcc, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned short')]],
    'VirtualStorePagefile' : [ 0xcc, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned short')]],
    'SwapSupported' : [ 0xcc, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned short')]],
    'NodeInserted' : [ 0xcc, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned short')]],
    'StackNotified' : [ 0xcc, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned short')]],
    'BackedBySCM' : [ 0xcc, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned short')]],
    'Spare0' : [ 0xcc, ['BitField', dict(start_bit = 11, end_bit = 15, native_type='unsigned short')]],
    'AdriftMdls' : [ 0xce, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'Spare1' : [ 0xce, ['BitField', dict(start_bit = 1, end_bit = 8, native_type='unsigned char')]],
    'IgnoreReservations' : [ 0xcf, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'Spare2' : [ 0xcf, ['BitField', dict(start_bit = 1, end_bit = 8, native_type='unsigned char')]],
    'PageHashPages' : [ 0xd0, ['unsigned long']],
    'PageHashPagesPeak' : [ 0xd4, ['unsigned long']],
    'PageHash' : [ 0xd8, ['pointer64', ['unsigned long']]],
    'FileHandle' : [ 0xe0, ['pointer64', ['void']]],
    'Lock' : [ 0xe8, ['unsigned long long']],
    'LockOwner' : [ 0xf0, ['pointer64', ['_ETHREAD']]],
    'FlowThroughReadRoot' : [ 0xf8, ['_RTL_AVL_TREE']],
    'Partition' : [ 0x100, ['pointer64', ['_MI_PARTITION']]],
    'FileObjectNode' : [ 0x108, ['_RTL_BALANCED_NODE']],
} ],
  '_WHEA_XPF_MC_BANK_DESCRIPTOR' : [ 0x1c, {
    'BankNumber' : [ 0x0, ['unsigned char']],
    'ClearOnInitialization' : [ 0x1, ['unsigned char']],
    'StatusDataFormat' : [ 0x2, ['unsigned char']],
    'Flags' : [ 0x3, ['_XPF_MC_BANK_FLAGS']],
    'ControlMsr' : [ 0x4, ['unsigned long']],
    'StatusMsr' : [ 0x8, ['unsigned long']],
    'AddressMsr' : [ 0xc, ['unsigned long']],
    'MiscMsr' : [ 0x10, ['unsigned long']],
    'ControlData' : [ 0x14, ['unsigned long long']],
} ],
  '_SID_AND_ATTRIBUTES_HASH' : [ 0x110, {
    'SidCount' : [ 0x0, ['unsigned long']],
    'SidAttr' : [ 0x8, ['pointer64', ['_SID_AND_ATTRIBUTES']]],
    'Hash' : [ 0x10, ['array', 32, ['unsigned long long']]],
} ],
  '_ACCESS_REASONS' : [ 0x80, {
    'Data' : [ 0x0, ['array', 32, ['unsigned long']]],
} ],
  '_POP_FX_WORK_ORDER' : [ 0x38, {
    'WorkItem' : [ 0x0, ['_WORK_QUEUE_ITEM']],
    'WorkCount' : [ 0x20, ['long']],
    'Context' : [ 0x28, ['pointer64', ['void']]],
    'WatchdogTimerInfo' : [ 0x30, ['pointer64', ['_POP_FX_WORK_ORDER_WATCHDOG_INFO']]],
} ],
  '_RTL_ATOM_TABLE_REFERENCE' : [ 0x18, {
    'LowBoxList' : [ 0x0, ['_LIST_ENTRY']],
    'LowBoxID' : [ 0x10, ['unsigned long']],
    'ReferenceCount' : [ 0x14, ['unsigned short']],
    'Flags' : [ 0x16, ['unsigned short']],
} ],
  '_PPM_IDLE_SYNCHRONIZATION_STATE' : [ 0x4, {
    'AsLong' : [ 0x0, ['long']],
    'RefCount' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 24, native_type='long')]],
    'State' : [ 0x0, ['BitField', dict(start_bit = 24, end_bit = 32, native_type='unsigned long')]],
} ],
  '_MI_PAGELIST_STATE' : [ 0x28, {
    'ActiveSpinLock' : [ 0x0, ['long']],
    'ActiveThreadTree' : [ 0x8, ['_RTL_AVL_TREE']],
    'ActiveZeroSpinLock' : [ 0x10, ['long']],
    'ActiveZeroThreadTree' : [ 0x18, ['_RTL_AVL_TREE']],
    'NumberOfLargePageListHeads' : [ 0x20, ['unsigned long']],
} ],
  '_CRITICAL_PROCESS_EXCEPTION_DATA' : [ 0x30, {
    'ReportId' : [ 0x0, ['_GUID']],
    'ModuleName' : [ 0x10, ['_UNICODE_STRING']],
    'ModuleTimestamp' : [ 0x20, ['unsigned long']],
    'ModuleSize' : [ 0x24, ['unsigned long']],
    'Offset' : [ 0x28, ['unsigned long long']],
} ],
  '__unnamed_2b1a' : [ 0x8, {
    'Head' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 24, native_type='unsigned long long')]],
    'Tail' : [ 0x0, ['BitField', dict(start_bit = 24, end_bit = 48, native_type='unsigned long long')]],
    'ActiveThreadCount' : [ 0x0, ['BitField', dict(start_bit = 48, end_bit = 64, native_type='unsigned long long')]],
} ],
  '__unnamed_2b1c' : [ 0x8, {
    's1' : [ 0x0, ['__unnamed_2b1a']],
    'Value' : [ 0x0, ['long long']],
} ],
  '_ALPC_COMPLETION_LIST_STATE' : [ 0x8, {
    'u1' : [ 0x0, ['__unnamed_2b1c']],
} ],
  '_WHEA_TIMESTAMP' : [ 0x8, {
    'Seconds' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned long long')]],
    'Minutes' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 16, native_type='unsigned long long')]],
    'Hours' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 24, native_type='unsigned long long')]],
    'Precise' : [ 0x0, ['BitField', dict(start_bit = 24, end_bit = 25, native_type='unsigned long long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 25, end_bit = 32, native_type='unsigned long long')]],
    'Day' : [ 0x0, ['BitField', dict(start_bit = 32, end_bit = 40, native_type='unsigned long long')]],
    'Month' : [ 0x0, ['BitField', dict(start_bit = 40, end_bit = 48, native_type='unsigned long long')]],
    'Year' : [ 0x0, ['BitField', dict(start_bit = 48, end_bit = 56, native_type='unsigned long long')]],
    'Century' : [ 0x0, ['BitField', dict(start_bit = 56, end_bit = 64, native_type='unsigned long long')]],
    'AsLARGE_INTEGER' : [ 0x0, ['_LARGE_INTEGER']],
} ],
  '_CALL_PERFORMANCE_DATA' : [ 0x408, {
    'SpinLock' : [ 0x0, ['unsigned long long']],
    'HashTable' : [ 0x8, ['array', 64, ['_LIST_ENTRY']]],
} ],
  '_WHEA_XPF_NMI_DESCRIPTOR' : [ 0x3, {
    'Type' : [ 0x0, ['unsigned short']],
    'Enabled' : [ 0x2, ['unsigned char']],
} ],
  '_IO_IRP_EXT_TRACK_OFFSET_HEADER' : [ 0x10, {
    'Validation' : [ 0x0, ['unsigned short']],
    'Flags' : [ 0x2, ['unsigned short']],
    'TrackedOffsetCallback' : [ 0x8, ['pointer64', ['void']]],
} ],
  'tagSWITCH_CONTEXT_DATA' : [ 0x340, {
    'ullOsMaxVersionTested' : [ 0x0, ['unsigned long long']],
    'ulTargetPlatform' : [ 0x8, ['unsigned long']],
    'ullContextMinimum' : [ 0x10, ['unsigned long long']],
    'guPlatform' : [ 0x18, ['_GUID']],
    'guMinPlatform' : [ 0x28, ['_GUID']],
    'ulContextSource' : [ 0x38, ['unsigned long']],
    'ulElementCount' : [ 0x3c, ['unsigned long']],
    'guElements' : [ 0x40, ['array', 48, ['_GUID']]],
} ],
  '_SESSION_LOWBOX_MAP' : [ 0x40, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'SessionId' : [ 0x10, ['unsigned long']],
    'LowboxMap' : [ 0x18, ['_SEP_LOWBOX_NUMBER_MAPPING']],
} ],
  '_POP_IO_INFO' : [ 0x70, {
    'DumpMdl' : [ 0x0, ['pointer64', ['_MDL']]],
    'IoStatus' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {0: u'IoReady', 1: u'IoPending', 2: u'IoDone'})]],
    'IoStartCount' : [ 0x10, ['unsigned long long']],
    'IoBytesCompleted' : [ 0x18, ['unsigned long long']],
    'IoBytesInProgress' : [ 0x20, ['unsigned long long']],
    'RequestSize' : [ 0x28, ['unsigned long long']],
    'IoLocation' : [ 0x30, ['_LARGE_INTEGER']],
    'FileOffset' : [ 0x38, ['unsigned long long']],
    'Buffer' : [ 0x40, ['pointer64', ['void']]],
    'AsyncCapable' : [ 0x48, ['unsigned char']],
    'BytesToRead' : [ 0x50, ['unsigned long long']],
    'Pages' : [ 0x58, ['unsigned long']],
    'HighestChecksumIndex' : [ 0x60, ['unsigned long long']],
    'PreviousChecksum' : [ 0x68, ['unsigned short']],
} ],
  '_TOKEN_ACCESS_INFORMATION' : [ 0x58, {
    'SidHash' : [ 0x0, ['pointer64', ['_SID_AND_ATTRIBUTES_HASH']]],
    'RestrictedSidHash' : [ 0x8, ['pointer64', ['_SID_AND_ATTRIBUTES_HASH']]],
    'Privileges' : [ 0x10, ['pointer64', ['_TOKEN_PRIVILEGES']]],
    'AuthenticationId' : [ 0x18, ['_LUID']],
    'TokenType' : [ 0x20, ['Enumeration', dict(target = 'long', choices = {1: u'TokenPrimary', 2: u'TokenImpersonation'})]],
    'ImpersonationLevel' : [ 0x24, ['Enumeration', dict(target = 'long', choices = {0: u'SecurityAnonymous', 1: u'SecurityIdentification', 2: u'SecurityImpersonation', 3: u'SecurityDelegation'})]],
    'MandatoryPolicy' : [ 0x28, ['_TOKEN_MANDATORY_POLICY']],
    'Flags' : [ 0x2c, ['unsigned long']],
    'AppContainerNumber' : [ 0x30, ['unsigned long']],
    'PackageSid' : [ 0x38, ['pointer64', ['void']]],
    'CapabilitiesHash' : [ 0x40, ['pointer64', ['_SID_AND_ATTRIBUTES_HASH']]],
    'TrustLevelSid' : [ 0x48, ['pointer64', ['void']]],
    'SecurityAttributes' : [ 0x50, ['pointer64', ['void']]],
} ],
  '_MIPFNBLINK' : [ 0x8, {
    'Blink' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 36, native_type='unsigned long long')]],
    'NodeBlinkHigh' : [ 0x0, ['BitField', dict(start_bit = 36, end_bit = 56, native_type='unsigned long long')]],
    'TbFlushStamp' : [ 0x0, ['BitField', dict(start_bit = 56, end_bit = 60, native_type='unsigned long long')]],
    'Unused' : [ 0x0, ['BitField', dict(start_bit = 60, end_bit = 62, native_type='unsigned long long')]],
    'PageBlinkDeleteBit' : [ 0x0, ['BitField', dict(start_bit = 62, end_bit = 63, native_type='unsigned long long')]],
    'PageBlinkLockBit' : [ 0x0, ['BitField', dict(start_bit = 63, end_bit = 64, native_type='unsigned long long')]],
    'ShareCount' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 62, native_type='unsigned long long')]],
    'PageShareCountDeleteBit' : [ 0x0, ['BitField', dict(start_bit = 62, end_bit = 63, native_type='unsigned long long')]],
    'PageShareCountLockBit' : [ 0x0, ['BitField', dict(start_bit = 63, end_bit = 64, native_type='unsigned long long')]],
    'EntireField' : [ 0x0, ['unsigned long long']],
    'Lock' : [ 0x0, ['long long']],
    'LockNotUsed' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 62, native_type='unsigned long long')]],
    'DeleteBit' : [ 0x0, ['BitField', dict(start_bit = 62, end_bit = 63, native_type='unsigned long long')]],
    'LockBit' : [ 0x0, ['BitField', dict(start_bit = 63, end_bit = 64, native_type='unsigned long long')]],
} ],
  '_OB_DUPLICATE_OBJECT_STATE' : [ 0x28, {
    'SourceProcess' : [ 0x0, ['pointer64', ['_EPROCESS']]],
    'SourceHandle' : [ 0x8, ['pointer64', ['void']]],
    'Object' : [ 0x10, ['pointer64', ['void']]],
    'TargetAccess' : [ 0x18, ['unsigned long']],
    'ObjectInfo' : [ 0x1c, ['_HANDLE_TABLE_ENTRY_INFO']],
    'HandleAttributes' : [ 0x24, ['unsigned long']],
} ],
  '_PPM_COORDINATED_SELECTION' : [ 0x18, {
    'MaximumStates' : [ 0x0, ['unsigned long']],
    'SelectedStates' : [ 0x4, ['unsigned long']],
    'DefaultSelection' : [ 0x8, ['unsigned long']],
    'Selection' : [ 0x10, ['pointer64', ['unsigned long']]],
} ],
  '_KRESOURCEMANAGER_COMPLETION_BINDING' : [ 0x28, {
    'NotificationListHead' : [ 0x0, ['_LIST_ENTRY']],
    'Port' : [ 0x10, ['pointer64', ['void']]],
    'Key' : [ 0x18, ['unsigned long long']],
    'BindingProcess' : [ 0x20, ['pointer64', ['_EPROCESS']]],
} ],
  '_IMAGE_OPTIONAL_HEADER64' : [ 0xf0, {
    'Magic' : [ 0x0, ['unsigned short']],
    'MajorLinkerVersion' : [ 0x2, ['unsigned char']],
    'MinorLinkerVersion' : [ 0x3, ['unsigned char']],
    'SizeOfCode' : [ 0x4, ['unsigned long']],
    'SizeOfInitializedData' : [ 0x8, ['unsigned long']],
    'SizeOfUninitializedData' : [ 0xc, ['unsigned long']],
    'AddressOfEntryPoint' : [ 0x10, ['unsigned long']],
    'BaseOfCode' : [ 0x14, ['unsigned long']],
    'ImageBase' : [ 0x18, ['unsigned long long']],
    'SectionAlignment' : [ 0x20, ['unsigned long']],
    'FileAlignment' : [ 0x24, ['unsigned long']],
    'MajorOperatingSystemVersion' : [ 0x28, ['unsigned short']],
    'MinorOperatingSystemVersion' : [ 0x2a, ['unsigned short']],
    'MajorImageVersion' : [ 0x2c, ['unsigned short']],
    'MinorImageVersion' : [ 0x2e, ['unsigned short']],
    'MajorSubsystemVersion' : [ 0x30, ['unsigned short']],
    'MinorSubsystemVersion' : [ 0x32, ['unsigned short']],
    'Win32VersionValue' : [ 0x34, ['unsigned long']],
    'SizeOfImage' : [ 0x38, ['unsigned long']],
    'SizeOfHeaders' : [ 0x3c, ['unsigned long']],
    'CheckSum' : [ 0x40, ['unsigned long']],
    'Subsystem' : [ 0x44, ['unsigned short']],
    'DllCharacteristics' : [ 0x46, ['unsigned short']],
    'SizeOfStackReserve' : [ 0x48, ['unsigned long long']],
    'SizeOfStackCommit' : [ 0x50, ['unsigned long long']],
    'SizeOfHeapReserve' : [ 0x58, ['unsigned long long']],
    'SizeOfHeapCommit' : [ 0x60, ['unsigned long long']],
    'LoaderFlags' : [ 0x68, ['unsigned long']],
    'NumberOfRvaAndSizes' : [ 0x6c, ['unsigned long']],
    'DataDirectory' : [ 0x70, ['array', 16, ['_IMAGE_DATA_DIRECTORY']]],
} ],
  '_ETW_LAST_ENABLE_INFO' : [ 0x10, {
    'EnableFlags' : [ 0x0, ['_LARGE_INTEGER']],
    'LoggerId' : [ 0x8, ['unsigned short']],
    'Level' : [ 0xa, ['unsigned char']],
    'Enabled' : [ 0xb, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'InternalFlag' : [ 0xb, ['BitField', dict(start_bit = 1, end_bit = 8, native_type='unsigned char')]],
} ],
  '_DMA_IOMMU_INTERFACE' : [ 0x68, {
    'Version' : [ 0x0, ['unsigned long']],
    'CreateDomain' : [ 0x8, ['pointer64', ['void']]],
    'DeleteDomain' : [ 0x10, ['pointer64', ['void']]],
    'AttachDevice' : [ 0x18, ['pointer64', ['void']]],
    'DetachDevice' : [ 0x20, ['pointer64', ['void']]],
    'ConfigureDomain' : [ 0x28, ['pointer64', ['void']]],
    'FlushDomain' : [ 0x30, ['pointer64', ['void']]],
    'FlushDomainByVaList' : [ 0x38, ['pointer64', ['void']]],
    'QueryInputMappings' : [ 0x40, ['pointer64', ['void']]],
    'MapLogicalRange' : [ 0x48, ['pointer64', ['void']]],
    'UnmapLogicalRange' : [ 0x50, ['pointer64', ['void']]],
    'MapIdentityRange' : [ 0x58, ['pointer64', ['void']]],
    'UnmapIdentityRange' : [ 0x60, ['pointer64', ['void']]],
} ],
  '_POOL_TRACKER_BIG_PAGES' : [ 0x18, {
    'Va' : [ 0x0, ['unsigned long long']],
    'Key' : [ 0x8, ['unsigned long']],
    'Pattern' : [ 0xc, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned long')]],
    'PoolType' : [ 0xc, ['BitField', dict(start_bit = 8, end_bit = 20, native_type='unsigned long')]],
    'SlushSize' : [ 0xc, ['BitField', dict(start_bit = 20, end_bit = 32, native_type='unsigned long')]],
    'NumberOfBytes' : [ 0x10, ['unsigned long long']],
} ],
  '__unnamed_2b86' : [ 0x1, {
    'AsUCHAR' : [ 0x0, ['unsigned char']],
    'NoDomainAccounting' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'IncreasePolicy' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 3, native_type='unsigned char')]],
    'DecreasePolicy' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 5, native_type='unsigned char')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 8, native_type='unsigned char')]],
} ],
  'PROCESSOR_PERFSTATE_POLICY' : [ 0x1c, {
    'Revision' : [ 0x0, ['unsigned long']],
    'MaxThrottle' : [ 0x4, ['unsigned char']],
    'MinThrottle' : [ 0x5, ['unsigned char']],
    'BusyAdjThreshold' : [ 0x6, ['unsigned char']],
    'Spare' : [ 0x7, ['unsigned char']],
    'Flags' : [ 0x7, ['__unnamed_2b86']],
    'TimeCheck' : [ 0x8, ['unsigned long']],
    'IncreaseTime' : [ 0xc, ['unsigned long']],
    'DecreaseTime' : [ 0x10, ['unsigned long']],
    'IncreasePercent' : [ 0x14, ['unsigned long']],
    'DecreasePercent' : [ 0x18, ['unsigned long']],
} ],
  '_HEAP_LOOKASIDE' : [ 0x40, {
    'ListHead' : [ 0x0, ['_SLIST_HEADER']],
    'Depth' : [ 0x10, ['unsigned short']],
    'MaximumDepth' : [ 0x12, ['unsigned short']],
    'TotalAllocates' : [ 0x14, ['unsigned long']],
    'AllocateMisses' : [ 0x18, ['unsigned long']],
    'TotalFrees' : [ 0x1c, ['unsigned long']],
    'FreeMisses' : [ 0x20, ['unsigned long']],
    'LastTotalAllocates' : [ 0x24, ['unsigned long']],
    'LastAllocateMisses' : [ 0x28, ['unsigned long']],
    'Counters' : [ 0x2c, ['array', 2, ['unsigned long']]],
} ],
  '_TXN_PARAMETER_BLOCK' : [ 0x10, {
    'Length' : [ 0x0, ['unsigned short']],
    'TxFsContext' : [ 0x2, ['unsigned short']],
    'TransactionObject' : [ 0x8, ['pointer64', ['void']]],
} ],
  '_PROC_PERF_HISTORY' : [ 0x24, {
    'Count' : [ 0x0, ['unsigned long']],
    'Slot' : [ 0x4, ['unsigned long']],
    'UtilityTotal' : [ 0x8, ['unsigned long']],
    'AffinitizedUtilityTotal' : [ 0xc, ['unsigned long']],
    'FrequencyTotal' : [ 0x10, ['unsigned long']],
    'TaggedPercentTotal' : [ 0x14, ['array', 2, ['unsigned long']]],
    'HistoryList' : [ 0x1c, ['array', 1, ['_PROC_PERF_HISTORY_ENTRY']]],
} ],
  '_DEVICE_RELATIONS' : [ 0x10, {
    'Count' : [ 0x0, ['unsigned long']],
    'Objects' : [ 0x8, ['array', 1, ['pointer64', ['_DEVICE_OBJECT']]]],
} ],
  '__unnamed_2b98' : [ 0x4, {
    'LongFlags2' : [ 0x0, ['unsigned long']],
    'VadFlags2' : [ 0x0, ['_MMVAD_FLAGS2']],
} ],
  '__unnamed_2b9b' : [ 0x8, {
    'SequentialVa' : [ 0x0, ['_MI_VAD_SEQUENTIAL_INFO']],
    'ExtendedInfo' : [ 0x0, ['pointer64', ['_MMEXTEND_INFO']]],
} ],
  '_MMVAD' : [ 0x88, {
    'Core' : [ 0x0, ['_MMVAD_SHORT']],
    'u2' : [ 0x40, ['__unnamed_2b98']],
    'Subsection' : [ 0x48, ['pointer64', ['_SUBSECTION']]],
    'FirstPrototypePte' : [ 0x50, ['pointer64', ['_MMPTE']]],
    'LastContiguousPte' : [ 0x58, ['pointer64', ['_MMPTE']]],
    'ViewLinks' : [ 0x60, ['_LIST_ENTRY']],
    'VadsProcess' : [ 0x70, ['pointer64', ['_EPROCESS']]],
    'u4' : [ 0x78, ['__unnamed_2b9b']],
    'FileObject' : [ 0x80, ['pointer64', ['_FILE_OBJECT']]],
} ],
  '_SEP_AUDIT_POLICY' : [ 0x1f, {
    'AdtTokenPolicy' : [ 0x0, ['_TOKEN_AUDIT_POLICY']],
    'PolicySetStatus' : [ 0x1e, ['unsigned char']],
} ],
  '_CMSI_PROCESS_TUPLE' : [ 0x10, {
    'ProcessHandle' : [ 0x0, ['pointer64', ['void']]],
    'ProcessReference' : [ 0x8, ['pointer64', ['void']]],
} ],
  '_HEAP_FAILURE_INFORMATION' : [ 0x6d0, {
    'Version' : [ 0x0, ['unsigned long']],
    'StructureSize' : [ 0x4, ['unsigned long']],
    'FailureType' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {0: u'heap_failure_internal', 1: u'heap_failure_unknown', 2: u'heap_failure_generic', 3: u'heap_failure_entry_corruption', 4: u'heap_failure_multiple_entries_corruption', 5: u'heap_failure_virtual_block_corruption', 6: u'heap_failure_buffer_overrun', 7: u'heap_failure_buffer_underrun', 8: u'heap_failure_block_not_busy', 9: u'heap_failure_invalid_argument', 10: u'heap_failure_invalid_allocation_type', 11: u'heap_failure_usage_after_free', 12: u'heap_failure_cross_heap_operation', 13: u'heap_failure_freelists_corruption', 14: u'heap_failure_listentry_corruption', 15: u'heap_failure_lfh_bitmap_mismatch', 16: u'heap_failure_segment_lfh_bitmap_corruption', 17: u'heap_failure_segment_lfh_double_free', 18: u'heap_failure_vs_subsegment_corruption', 19: u'heap_failure_null_heap'})]],
    'HeapAddress' : [ 0x10, ['pointer64', ['void']]],
    'Address' : [ 0x18, ['pointer64', ['void']]],
    'Param1' : [ 0x20, ['pointer64', ['void']]],
    'Param2' : [ 0x28, ['pointer64', ['void']]],
    'Param3' : [ 0x30, ['pointer64', ['void']]],
    'PreviousBlock' : [ 0x38, ['pointer64', ['void']]],
    'NextBlock' : [ 0x40, ['pointer64', ['void']]],
    'ExpectedDecodedEntry' : [ 0x48, ['_FAKE_HEAP_ENTRY']],
    'StackTrace' : [ 0x58, ['array', 32, ['pointer64', ['void']]]],
    'HeapMajorVersion' : [ 0x158, ['unsigned char']],
    'HeapMinorVersion' : [ 0x159, ['unsigned char']],
    'ExceptionRecord' : [ 0x160, ['_EXCEPTION_RECORD']],
    'ContextRecord' : [ 0x200, ['_CONTEXT']],
} ],
  '_PROC_IDLE_ACCOUNTING' : [ 0x410, {
    'StateCount' : [ 0x0, ['unsigned long']],
    'TotalTransitions' : [ 0x4, ['unsigned long']],
    'ResetCount' : [ 0x8, ['unsigned long']],
    'AbortCount' : [ 0xc, ['unsigned long']],
    'StartTime' : [ 0x10, ['unsigned long long']],
    'PriorIdleTime' : [ 0x18, ['unsigned long long']],
    'TimeUnit' : [ 0x20, ['Enumeration', dict(target = 'long', choices = {0: u'PpmIdleBucketTimeInQpc', 1: u'PpmIdleBucketTimeIn100ns', 2: u'PpmIdleBucketTimeMaximum'})]],
    'State' : [ 0x28, ['array', 1, ['_PROC_IDLE_STATE_ACCOUNTING']]],
} ],
  '_UMS_CONTROL_BLOCK' : [ 0x88, {
    'UmsContext' : [ 0x0, ['pointer64', ['_RTL_UMS_CONTEXT']]],
    'CompletionListEntry' : [ 0x8, ['pointer64', ['_SINGLE_LIST_ENTRY']]],
    'CompletionListEvent' : [ 0x10, ['pointer64', ['_KEVENT']]],
    'ServiceSequenceNumber' : [ 0x18, ['unsigned long']],
    'UmsQueue' : [ 0x20, ['_KQUEUE']],
    'QueueEntry' : [ 0x60, ['_LIST_ENTRY']],
    'YieldingUmsContext' : [ 0x70, ['pointer64', ['_RTL_UMS_CONTEXT']]],
    'YieldingParam' : [ 0x78, ['pointer64', ['void']]],
    'UmsTeb' : [ 0x80, ['pointer64', ['void']]],
    'UmsAssociatedQueue' : [ 0x20, ['pointer64', ['_KQUEUE']]],
    'UmsQueueListEntry' : [ 0x28, ['pointer64', ['_LIST_ENTRY']]],
    'UmsWaitEvent' : [ 0x30, ['_KEVENT']],
    'StagingArea' : [ 0x48, ['pointer64', ['void']]],
    'UmsPrimaryDeliveredContext' : [ 0x50, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'UmsAssociatedQueueUsed' : [ 0x50, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'UmsThreadParked' : [ 0x50, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'UmsFlags' : [ 0x50, ['unsigned long']],
} ],
  '_KTM' : [ 0x3c0, {
    'cookie' : [ 0x0, ['unsigned long']],
    'Mutex' : [ 0x8, ['_KMUTANT']],
    'State' : [ 0x40, ['Enumeration', dict(target = 'long', choices = {0: u'KKtmUninitialized', 1: u'KKtmInitialized', 2: u'KKtmRecovering', 3: u'KKtmOnline', 4: u'KKtmRecoveryFailed', 5: u'KKtmOffline'})]],
    'NamespaceLink' : [ 0x48, ['_KTMOBJECT_NAMESPACE_LINK']],
    'TmIdentity' : [ 0x70, ['_GUID']],
    'Flags' : [ 0x80, ['unsigned long']],
    'VolatileFlags' : [ 0x84, ['unsigned long']],
    'LogFileName' : [ 0x88, ['_UNICODE_STRING']],
    'LogFileObject' : [ 0x98, ['pointer64', ['_FILE_OBJECT']]],
    'MarshallingContext' : [ 0xa0, ['pointer64', ['void']]],
    'LogManagementContext' : [ 0xa8, ['pointer64', ['void']]],
    'Transactions' : [ 0xb0, ['_KTMOBJECT_NAMESPACE']],
    'ResourceManagers' : [ 0x158, ['_KTMOBJECT_NAMESPACE']],
    'LsnOrderedMutex' : [ 0x200, ['_KMUTANT']],
    'LsnOrderedList' : [ 0x238, ['_LIST_ENTRY']],
    'CommitVirtualClock' : [ 0x248, ['_LARGE_INTEGER']],
    'CommitVirtualClockMutex' : [ 0x250, ['_FAST_MUTEX']],
    'BaseLsn' : [ 0x288, ['_CLS_LSN']],
    'CurrentReadLsn' : [ 0x290, ['_CLS_LSN']],
    'LastRecoveredLsn' : [ 0x298, ['_CLS_LSN']],
    'TmRmHandle' : [ 0x2a0, ['pointer64', ['void']]],
    'TmRm' : [ 0x2a8, ['pointer64', ['_KRESOURCEMANAGER']]],
    'LogFullNotifyEvent' : [ 0x2b0, ['_KEVENT']],
    'CheckpointWorkItem' : [ 0x2c8, ['_WORK_QUEUE_ITEM']],
    'CheckpointTargetLsn' : [ 0x2e8, ['_CLS_LSN']],
    'LogFullCompletedWorkItem' : [ 0x2f0, ['_WORK_QUEUE_ITEM']],
    'LogWriteResource' : [ 0x310, ['_ERESOURCE']],
    'LogFlags' : [ 0x378, ['unsigned long']],
    'LogFullStatus' : [ 0x37c, ['long']],
    'RecoveryStatus' : [ 0x380, ['long']],
    'LastCheckBaseLsn' : [ 0x388, ['_CLS_LSN']],
    'RestartOrderedList' : [ 0x390, ['_LIST_ENTRY']],
    'OfflineWorkItem' : [ 0x3a0, ['_WORK_QUEUE_ITEM']],
} ],
  '_PO_IRP_QUEUE' : [ 0x10, {
    'CurrentIrp' : [ 0x0, ['pointer64', ['_IRP']]],
    'PendingIrpList' : [ 0x8, ['pointer64', ['_IRP']]],
} ],
  '_KALPC_WORK_ON_BEHALF_DATA' : [ 0x8, {
    'Ticket' : [ 0x0, ['_ALPC_WORK_ON_BEHALF_TICKET']],
} ],
  '_CM_NOTIFY_BLOCK' : [ 0x58, {
    'HiveList' : [ 0x0, ['_LIST_ENTRY']],
    'PostList' : [ 0x10, ['_LIST_ENTRY']],
    'KeyControlBlock' : [ 0x20, ['pointer64', ['_CM_KEY_CONTROL_BLOCK']]],
    'KeyBody' : [ 0x28, ['pointer64', ['_CM_KEY_BODY']]],
    'Filter' : [ 0x30, ['BitField', dict(start_bit = 0, end_bit = 30, native_type='unsigned long')]],
    'WatchTree' : [ 0x30, ['BitField', dict(start_bit = 30, end_bit = 31, native_type='unsigned long')]],
    'NotifyPending' : [ 0x30, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
    'SubjectContext' : [ 0x38, ['_SECURITY_SUBJECT_CONTEXT']],
} ],
  '_TOKEN_CONTROL' : [ 0x28, {
    'TokenId' : [ 0x0, ['_LUID']],
    'AuthenticationId' : [ 0x8, ['_LUID']],
    'ModifiedId' : [ 0x10, ['_LUID']],
    'TokenSource' : [ 0x18, ['_TOKEN_SOURCE']],
} ],
  '_LDR_DATA_TABLE_ENTRY' : [ 0x120, {
    'InLoadOrderLinks' : [ 0x0, ['_LIST_ENTRY']],
    'InMemoryOrderLinks' : [ 0x10, ['_LIST_ENTRY']],
    'InInitializationOrderLinks' : [ 0x20, ['_LIST_ENTRY']],
    'DllBase' : [ 0x30, ['pointer64', ['void']]],
    'EntryPoint' : [ 0x38, ['pointer64', ['void']]],
    'SizeOfImage' : [ 0x40, ['unsigned long']],
    'FullDllName' : [ 0x48, ['_UNICODE_STRING']],
    'BaseDllName' : [ 0x58, ['_UNICODE_STRING']],
    'FlagGroup' : [ 0x68, ['array', 4, ['unsigned char']]],
    'Flags' : [ 0x68, ['unsigned long']],
    'PackagedBinary' : [ 0x68, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'MarkedForRemoval' : [ 0x68, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'ImageDll' : [ 0x68, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'LoadNotificationsSent' : [ 0x68, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'TelemetryEntryProcessed' : [ 0x68, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'ProcessStaticImport' : [ 0x68, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'InLegacyLists' : [ 0x68, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'InIndexes' : [ 0x68, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'ShimDll' : [ 0x68, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'InExceptionTable' : [ 0x68, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'ReservedFlags1' : [ 0x68, ['BitField', dict(start_bit = 10, end_bit = 12, native_type='unsigned long')]],
    'LoadInProgress' : [ 0x68, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long')]],
    'LoadConfigProcessed' : [ 0x68, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long')]],
    'EntryProcessed' : [ 0x68, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long')]],
    'ProtectDelayLoad' : [ 0x68, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'ReservedFlags3' : [ 0x68, ['BitField', dict(start_bit = 16, end_bit = 18, native_type='unsigned long')]],
    'DontCallForThreads' : [ 0x68, ['BitField', dict(start_bit = 18, end_bit = 19, native_type='unsigned long')]],
    'ProcessAttachCalled' : [ 0x68, ['BitField', dict(start_bit = 19, end_bit = 20, native_type='unsigned long')]],
    'ProcessAttachFailed' : [ 0x68, ['BitField', dict(start_bit = 20, end_bit = 21, native_type='unsigned long')]],
    'CorDeferredValidate' : [ 0x68, ['BitField', dict(start_bit = 21, end_bit = 22, native_type='unsigned long')]],
    'CorImage' : [ 0x68, ['BitField', dict(start_bit = 22, end_bit = 23, native_type='unsigned long')]],
    'DontRelocate' : [ 0x68, ['BitField', dict(start_bit = 23, end_bit = 24, native_type='unsigned long')]],
    'CorILOnly' : [ 0x68, ['BitField', dict(start_bit = 24, end_bit = 25, native_type='unsigned long')]],
    'ChpeImage' : [ 0x68, ['BitField', dict(start_bit = 25, end_bit = 26, native_type='unsigned long')]],
    'ReservedFlags5' : [ 0x68, ['BitField', dict(start_bit = 26, end_bit = 28, native_type='unsigned long')]],
    'Redirected' : [ 0x68, ['BitField', dict(start_bit = 28, end_bit = 29, native_type='unsigned long')]],
    'ReservedFlags6' : [ 0x68, ['BitField', dict(start_bit = 29, end_bit = 31, native_type='unsigned long')]],
    'CompatDatabaseProcessed' : [ 0x68, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
    'ObsoleteLoadCount' : [ 0x6c, ['unsigned short']],
    'TlsIndex' : [ 0x6e, ['unsigned short']],
    'HashLinks' : [ 0x70, ['_LIST_ENTRY']],
    'TimeDateStamp' : [ 0x80, ['unsigned long']],
    'EntryPointActivationContext' : [ 0x88, ['pointer64', ['_ACTIVATION_CONTEXT']]],
    'Lock' : [ 0x90, ['pointer64', ['void']]],
    'DdagNode' : [ 0x98, ['pointer64', ['_LDR_DDAG_NODE']]],
    'NodeModuleLink' : [ 0xa0, ['_LIST_ENTRY']],
    'LoadContext' : [ 0xb0, ['pointer64', ['_LDRP_LOAD_CONTEXT']]],
    'ParentDllBase' : [ 0xb8, ['pointer64', ['void']]],
    'SwitchBackContext' : [ 0xc0, ['pointer64', ['void']]],
    'BaseAddressIndexNode' : [ 0xc8, ['_RTL_BALANCED_NODE']],
    'MappingInfoIndexNode' : [ 0xe0, ['_RTL_BALANCED_NODE']],
    'OriginalBase' : [ 0xf8, ['unsigned long long']],
    'LoadTime' : [ 0x100, ['_LARGE_INTEGER']],
    'BaseNameHashValue' : [ 0x108, ['unsigned long']],
    'LoadReason' : [ 0x10c, ['Enumeration', dict(target = 'long', choices = {0: u'LoadReasonStaticDependency', 1: u'LoadReasonStaticForwarderDependency', 2: u'LoadReasonDynamicForwarderDependency', 3: u'LoadReasonDelayloadDependency', 4: u'LoadReasonDynamicLoad', 5: u'LoadReasonAsImageLoad', 6: u'LoadReasonAsDataLoad', 7: u'LoadReasonEnclavePrimary', 8: u'LoadReasonEnclaveDependency', -1: u'LoadReasonUnknown'})]],
    'ImplicitPathOptions' : [ 0x110, ['unsigned long']],
    'ReferenceCount' : [ 0x114, ['unsigned long']],
    'DependentLoadFlags' : [ 0x118, ['unsigned long']],
    'SigningLevel' : [ 0x11c, ['unsigned char']],
} ],
  '_KTIMER2_COLLECTION' : [ 0x18, {
    'Tree' : [ 0x0, ['_RTL_RB_TREE']],
    'NextDueTime' : [ 0x10, ['unsigned long long']],
} ],
  '__unnamed_2bcd' : [ 0x1, {
    'Age' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 4, native_type='unsigned char')]],
    'Protection' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 7, native_type='unsigned char')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
} ],
  '__unnamed_2bcf' : [ 0x1, {
    'EntireWsle' : [ 0x0, ['unsigned char']],
} ],
  '__unnamed_2bd1' : [ 0x1, {
    'e1' : [ 0x0, ['__unnamed_2bcd']],
    'e2' : [ 0x0, ['__unnamed_2bcf']],
} ],
  '_MI_WSLE' : [ 0x1, {
    'u1' : [ 0x0, ['__unnamed_2bd1']],
} ],
  '_VF_WATCHDOG_IRP' : [ 0x20, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'Irp' : [ 0x10, ['pointer64', ['_IRP']]],
    'DueTickCount' : [ 0x18, ['unsigned long']],
    'Inserted' : [ 0x1c, ['unsigned char']],
    'TrackedStackLocation' : [ 0x1d, ['unsigned char']],
    'CancelTimeoutTicks' : [ 0x1e, ['unsigned short']],
} ],
  '_MMVAD_FLAGS2' : [ 0x4, {
    'FileOffset' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 24, native_type='unsigned long')]],
    'Large' : [ 0x0, ['BitField', dict(start_bit = 24, end_bit = 25, native_type='unsigned long')]],
    'TrimBehind' : [ 0x0, ['BitField', dict(start_bit = 25, end_bit = 26, native_type='unsigned long')]],
    'Inherit' : [ 0x0, ['BitField', dict(start_bit = 26, end_bit = 27, native_type='unsigned long')]],
    'NoValidationNeeded' : [ 0x0, ['BitField', dict(start_bit = 27, end_bit = 28, native_type='unsigned long')]],
    'PrivateDemandZero' : [ 0x0, ['BitField', dict(start_bit = 28, end_bit = 29, native_type='unsigned long')]],
    'Spare' : [ 0x0, ['BitField', dict(start_bit = 29, end_bit = 32, native_type='unsigned long')]],
} ],
  '_u' : [ 0x50, {
    'KeyNode' : [ 0x0, ['_CM_KEY_NODE']],
    'KeyValue' : [ 0x0, ['_CM_KEY_VALUE']],
    'KeySecurity' : [ 0x0, ['_CM_KEY_SECURITY']],
    'KeyIndex' : [ 0x0, ['_CM_KEY_INDEX']],
    'ValueData' : [ 0x0, ['_CM_BIG_DATA']],
    'KeyList' : [ 0x0, ['array', 1, ['unsigned long']]],
    'KeyString' : [ 0x0, ['array', 1, ['wchar']]],
} ],
  '_MI_PARTITION_MODWRITES' : [ 0x2c0, {
    'AttemptForCantExtend' : [ 0x0, ['_MMPAGE_FILE_EXPANSION']],
    'PageFileContract' : [ 0x58, ['_MMPAGE_FILE_EXPANSION']],
    'NumberOfMappedMdls' : [ 0xb0, ['unsigned long long']],
    'NumberOfMappedMdlsInUse' : [ 0xb8, ['long']],
    'NumberOfMappedMdlsInUsePeak' : [ 0xbc, ['unsigned long']],
    'MappedFileHeader' : [ 0xc0, ['_MMMOD_WRITER_LISTHEAD']],
    'NeedMappedMdl' : [ 0xe8, ['unsigned char']],
    'NeedPageFileMdl' : [ 0xe9, ['unsigned char']],
    'ModwriterActive' : [ 0xea, ['unsigned char']],
    'TransitionInserted' : [ 0xeb, ['unsigned char']],
    'LastModifiedWriteError' : [ 0xec, ['long']],
    'LastMappedWriteError' : [ 0xf0, ['long']],
    'MappedFileWriteSucceeded' : [ 0xf4, ['unsigned long']],
    'MappedWriteBurstCount' : [ 0xf8, ['unsigned long']],
    'LowPriorityModWritesOutstanding' : [ 0xfc, ['unsigned long']],
    'BoostModWriteIoPriorityEvent' : [ 0x100, ['_KEVENT']],
    'ModifiedWriterThreadPriority' : [ 0x118, ['long']],
    'ModifiedPagesLowPriorityGoal' : [ 0x120, ['unsigned long long']],
    'ModifiedPageWriterEvent' : [ 0x128, ['_KEVENT']],
    'ModifiedWriterExitedEvent' : [ 0x140, ['_KEVENT']],
    'WriteAllPagefilePages' : [ 0x158, ['long']],
    'WriteAllMappedPages' : [ 0x15c, ['long']],
    'MappedPageWriterEvent' : [ 0x160, ['_KEVENT']],
    'ModWriteData' : [ 0x178, ['_MI_MODWRITE_DATA']],
    'RescanPageFilesEvent' : [ 0x1b8, ['_KEVENT']],
    'PagingFileHeader' : [ 0x1d0, ['_MMMOD_WRITER_LISTHEAD']],
    'ModifiedPageWriterThread' : [ 0x1f8, ['pointer64', ['_ETHREAD']]],
    'ModifiedPageWriterRundown' : [ 0x200, ['_EX_RUNDOWN_REF']],
    'PagefileScanWorkItem' : [ 0x208, ['_WORK_QUEUE_ITEM']],
    'PagefileScanCount' : [ 0x228, ['unsigned long']],
    'ClusterRestrictionLock' : [ 0x22c, ['long']],
    'ClusterRestrictions' : [ 0x230, ['array', 2, ['_MI_RESTRICTED_MODWRITES']]],
    'NotifyStoreMemoryConditions' : [ 0x238, ['_KEVENT']],
    'DelayMappedWrite' : [ 0x250, ['unsigned char']],
    'PagefileReservationsEnabled' : [ 0x254, ['unsigned long']],
    'PageFileCreationLock' : [ 0x258, ['_EX_PUSH_LOCK']],
    'TrimPagefileWorkItem' : [ 0x260, ['_WORK_QUEUE_ITEM']],
    'LastTrimPagefileTime' : [ 0x280, ['unsigned long long']],
    'WsSwapPagefileContractWorkItem' : [ 0x288, ['_WORK_QUEUE_ITEM']],
    'WsSwapPageFileContractionInProgress' : [ 0x2a8, ['long']],
    'WorkingSetSwapLock' : [ 0x2b0, ['_EX_PUSH_LOCK']],
    'WorkingSetInswapLock' : [ 0x2b8, ['long']],
} ],
  '_PPC_DBGKD_CONTROL_SET' : [ 0xc, {
    'Continue' : [ 0x0, ['unsigned long']],
    'CurrentSymbolStart' : [ 0x4, ['unsigned long']],
    'CurrentSymbolEnd' : [ 0x8, ['unsigned long']],
} ],
  '_OB_EXTENDED_PARSE_PARAMETERS' : [ 0x10, {
    'Length' : [ 0x0, ['unsigned short']],
    'RestrictedAccessMask' : [ 0x4, ['unsigned long']],
    'Silo' : [ 0x8, ['pointer64', ['_EJOB']]],
} ],
  '_MMSUBSECTION_FLAGS' : [ 0x4, {
    'SubsectionAccessed' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
    'Protection' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 6, native_type='unsigned short')]],
    'StartingSector4132' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 16, native_type='unsigned short')]],
    'SubsectionStatic' : [ 0x2, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
    'GlobalMemory' : [ 0x2, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned short')]],
    'Spare' : [ 0x2, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned short')]],
    'OnDereferenceList' : [ 0x2, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned short')]],
    'SectorEndOffset' : [ 0x2, ['BitField', dict(start_bit = 4, end_bit = 16, native_type='unsigned short')]],
} ],
  '_MI_COMBINE_PAGE_LISTHEAD' : [ 0x10, {
    'Table' : [ 0x0, ['_RTL_AVL_TREE']],
    'Lock' : [ 0x8, ['long']],
} ],
  '_RTL_AVL_TABLE' : [ 0x68, {
    'BalancedRoot' : [ 0x0, ['_RTL_BALANCED_LINKS']],
    'OrderedPointer' : [ 0x20, ['pointer64', ['void']]],
    'WhichOrderedElement' : [ 0x28, ['unsigned long']],
    'NumberGenericTableElements' : [ 0x2c, ['unsigned long']],
    'DepthOfTree' : [ 0x30, ['unsigned long']],
    'RestartKey' : [ 0x38, ['pointer64', ['_RTL_BALANCED_LINKS']]],
    'DeleteCount' : [ 0x40, ['unsigned long']],
    'CompareRoutine' : [ 0x48, ['pointer64', ['void']]],
    'AllocateRoutine' : [ 0x50, ['pointer64', ['void']]],
    'FreeRoutine' : [ 0x58, ['pointer64', ['void']]],
    'TableContext' : [ 0x60, ['pointer64', ['void']]],
} ],
  '_WHEA_PERSISTENCE_INFO' : [ 0x8, {
    'Signature' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 16, native_type='unsigned long long')]],
    'Length' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 40, native_type='unsigned long long')]],
    'Identifier' : [ 0x0, ['BitField', dict(start_bit = 40, end_bit = 56, native_type='unsigned long long')]],
    'Attributes' : [ 0x0, ['BitField', dict(start_bit = 56, end_bit = 58, native_type='unsigned long long')]],
    'DoNotLog' : [ 0x0, ['BitField', dict(start_bit = 58, end_bit = 59, native_type='unsigned long long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 59, end_bit = 64, native_type='unsigned long long')]],
    'AsULONGLONG' : [ 0x0, ['unsigned long long']],
} ],
  '_DBGKD_FILL_MEMORY' : [ 0x10, {
    'Address' : [ 0x0, ['unsigned long long']],
    'Length' : [ 0x8, ['unsigned long']],
    'Flags' : [ 0xc, ['unsigned short']],
    'PatternLength' : [ 0xe, ['unsigned short']],
} ],
  '_GENERIC_MAPPING' : [ 0x10, {
    'GenericRead' : [ 0x0, ['unsigned long']],
    'GenericWrite' : [ 0x4, ['unsigned long']],
    'GenericExecute' : [ 0x8, ['unsigned long']],
    'GenericAll' : [ 0xc, ['unsigned long']],
} ],
  '_HAL_INTEL_ENLIGHTENMENT_INFORMATION' : [ 0x1e0, {
    'Enlightenments' : [ 0x0, ['unsigned long']],
    'HypervisorConnected' : [ 0x4, ['unsigned long']],
    'EndOfInterrupt' : [ 0x8, ['pointer64', ['void']]],
    'ApicWriteIcr' : [ 0x10, ['pointer64', ['void']]],
    'Reserved0' : [ 0x18, ['unsigned long']],
    'SpinCountMask' : [ 0x1c, ['unsigned long']],
    'LongSpinWait' : [ 0x20, ['pointer64', ['void']]],
    'GetReferenceTime' : [ 0x28, ['pointer64', ['void']]],
    'SetSystemSleepProperty' : [ 0x30, ['pointer64', ['void']]],
    'EnterSleepState' : [ 0x38, ['pointer64', ['void']]],
    'NotifyDebugDeviceAvailable' : [ 0x40, ['pointer64', ['void']]],
    'MapDeviceInterrupt' : [ 0x48, ['pointer64', ['void']]],
    'UnmapDeviceInterrupt' : [ 0x50, ['pointer64', ['void']]],
    'RetargetDeviceInterrupt' : [ 0x58, ['pointer64', ['void']]],
    'SetHpetConfig' : [ 0x60, ['pointer64', ['void']]],
    'NotifyHpetEnabled' : [ 0x68, ['pointer64', ['void']]],
    'QueryAssociatedProcessors' : [ 0x70, ['pointer64', ['void']]],
    'ReadMultipleMsr' : [ 0x78, ['pointer64', ['void']]],
    'WriteMultipleMsr' : [ 0x80, ['pointer64', ['void']]],
    'ReadCpuid' : [ 0x88, ['pointer64', ['void']]],
    'LpWritebackInvalidate' : [ 0x90, ['pointer64', ['void']]],
    'GetMachineCheckContext' : [ 0x98, ['pointer64', ['void']]],
    'SuspendPartition' : [ 0xa0, ['pointer64', ['void']]],
    'ResumePartition' : [ 0xa8, ['pointer64', ['void']]],
    'SetSystemMachineCheckProperty' : [ 0xb0, ['pointer64', ['void']]],
    'WheaErrorNotification' : [ 0xb8, ['pointer64', ['void']]],
    'GetProcessorIndexFromVpIndex' : [ 0xc0, ['pointer64', ['void']]],
    'SyntheticClusterIpi' : [ 0xc8, ['pointer64', ['void']]],
    'VpStartEnabled' : [ 0xd0, ['pointer64', ['void']]],
    'StartVirtualProcessor' : [ 0xd8, ['pointer64', ['void']]],
    'GetVpIndexFromApicId' : [ 0xe0, ['pointer64', ['void']]],
    'IumAccessPciDevice' : [ 0xe8, ['pointer64', ['void']]],
    'IumEfiRuntimeService' : [ 0xf0, ['pointer64', ['void']]],
    'SvmGetSystemCapabilities' : [ 0xf8, ['pointer64', ['void']]],
    'SvmGetDeviceCapabilities' : [ 0x100, ['pointer64', ['void']]],
    'SvmCreatePasidSpace' : [ 0x108, ['pointer64', ['void']]],
    'SvmSetPasidAddressSpace' : [ 0x110, ['pointer64', ['void']]],
    'SvmFlushPasid' : [ 0x118, ['pointer64', ['void']]],
    'SvmAttachPasidSpace' : [ 0x120, ['pointer64', ['void']]],
    'SvmDetachPasidSpace' : [ 0x128, ['pointer64', ['void']]],
    'SvmEnablePasid' : [ 0x130, ['pointer64', ['void']]],
    'SvmDisablePasid' : [ 0x138, ['pointer64', ['void']]],
    'SvmAcknowledgePageRequest' : [ 0x140, ['pointer64', ['void']]],
    'SvmCreatePrQueue' : [ 0x148, ['pointer64', ['void']]],
    'SvmDeletePrQueue' : [ 0x150, ['pointer64', ['void']]],
    'SvmClearPrqStalled' : [ 0x158, ['pointer64', ['void']]],
    'SvmSetDeviceEnabled' : [ 0x160, ['pointer64', ['void']]],
    'HvDebuggerPowerHandler' : [ 0x168, ['pointer64', ['void']]],
    'SetQpcBias' : [ 0x170, ['pointer64', ['void']]],
    'GetQpcBias' : [ 0x178, ['pointer64', ['void']]],
    'RegisterDeviceId' : [ 0x180, ['pointer64', ['void']]],
    'UnregisterDeviceId' : [ 0x188, ['pointer64', ['void']]],
    'AllocateDeviceDomain' : [ 0x190, ['pointer64', ['void']]],
    'AttachDeviceDomain' : [ 0x198, ['pointer64', ['void']]],
    'DetachDeviceDomain' : [ 0x1a0, ['pointer64', ['void']]],
    'DeleteDeviceDomain' : [ 0x1a8, ['pointer64', ['void']]],
    'MapDeviceLogicalRange' : [ 0x1b0, ['pointer64', ['void']]],
    'UnmapDeviceLogicalRange' : [ 0x1b8, ['pointer64', ['void']]],
    'MapDeviceSparsePages' : [ 0x1c0, ['pointer64', ['void']]],
    'UnmapDeviceSparsePages' : [ 0x1c8, ['pointer64', ['void']]],
    'GetDmaGuardEnabled' : [ 0x1d0, ['pointer64', ['void']]],
    'UpdateMicrocode' : [ 0x1d8, ['pointer64', ['void']]],
} ],
  '_RTL_CRITICAL_SECTION_DEBUG' : [ 0x30, {
    'Type' : [ 0x0, ['unsigned short']],
    'CreatorBackTraceIndex' : [ 0x2, ['unsigned short']],
    'CriticalSection' : [ 0x8, ['pointer64', ['_RTL_CRITICAL_SECTION']]],
    'ProcessLocksList' : [ 0x10, ['_LIST_ENTRY']],
    'EntryCount' : [ 0x20, ['unsigned long']],
    'ContentionCount' : [ 0x24, ['unsigned long']],
    'Flags' : [ 0x28, ['unsigned long']],
    'CreatorBackTraceIndexHigh' : [ 0x2c, ['unsigned short']],
    'SpareUSHORT' : [ 0x2e, ['unsigned short']],
} ],
  '_DEVICE_DESCRIPTION' : [ 0x40, {
    'Version' : [ 0x0, ['unsigned long']],
    'Master' : [ 0x4, ['unsigned char']],
    'ScatterGather' : [ 0x5, ['unsigned char']],
    'DemandMode' : [ 0x6, ['unsigned char']],
    'AutoInitialize' : [ 0x7, ['unsigned char']],
    'Dma32BitAddresses' : [ 0x8, ['unsigned char']],
    'IgnoreCount' : [ 0x9, ['unsigned char']],
    'Reserved1' : [ 0xa, ['unsigned char']],
    'Dma64BitAddresses' : [ 0xb, ['unsigned char']],
    'BusNumber' : [ 0xc, ['unsigned long']],
    'DmaChannel' : [ 0x10, ['unsigned long']],
    'InterfaceType' : [ 0x14, ['Enumeration', dict(target = 'long', choices = {0: u'Internal', 1: u'Isa', 2: u'Eisa', 3: u'MicroChannel', 4: u'TurboChannel', 5: u'PCIBus', 6: u'VMEBus', 7: u'NuBus', 8: u'PCMCIABus', 9: u'CBus', 10: u'MPIBus', 11: u'MPSABus', 12: u'ProcessorInternal', 13: u'InternalPowerBus', 14: u'PNPISABus', 15: u'PNPBus', 16: u'Vmcs', 17: u'ACPIBus', 18: u'MaximumInterfaceType', -1: u'InterfaceTypeUndefined'})]],
    'DmaWidth' : [ 0x18, ['Enumeration', dict(target = 'long', choices = {0: u'Width8Bits', 1: u'Width16Bits', 2: u'Width32Bits', 3: u'Width64Bits', 4: u'WidthNoWrap', 5: u'MaximumDmaWidth'})]],
    'DmaSpeed' : [ 0x1c, ['Enumeration', dict(target = 'long', choices = {0: u'Compatible', 1: u'TypeA', 2: u'TypeB', 3: u'TypeC', 4: u'TypeF', 5: u'MaximumDmaSpeed'})]],
    'MaximumLength' : [ 0x20, ['unsigned long']],
    'DmaPort' : [ 0x24, ['unsigned long']],
    'DmaAddressWidth' : [ 0x28, ['unsigned long']],
    'DmaControllerInstance' : [ 0x2c, ['unsigned long']],
    'DmaRequestLine' : [ 0x30, ['unsigned long']],
    'DeviceAddress' : [ 0x38, ['_LARGE_INTEGER']],
} ],
  '_POP_FX_ACCOUNTING' : [ 0x80, {
    'Lock' : [ 0x0, ['unsigned long long']],
    'Active' : [ 0x8, ['unsigned char']],
    'DripsRequiredState' : [ 0xc, ['unsigned long']],
    'Level' : [ 0x10, ['long']],
    'ActiveStamp' : [ 0x18, ['long long']],
    'CsActiveTime' : [ 0x20, ['unsigned long long']],
    'CriticalActiveTime' : [ 0x28, ['long long']],
    'CriticalActiveTimeBuckets' : [ 0x30, ['array', 5, ['unsigned long long']]],
    'CsActiveTimeBuckets' : [ 0x58, ['array', 5, ['unsigned long long']]],
} ],
  '_KSCHEDULING_GROUP_POLICY' : [ 0x8, {
    'Value' : [ 0x0, ['unsigned long']],
    'Weight' : [ 0x0, ['unsigned short']],
    'MinRate' : [ 0x0, ['unsigned short']],
    'MaxRate' : [ 0x2, ['unsigned short']],
    'AllFlags' : [ 0x4, ['unsigned long']],
    'Type' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Disabled' : [ 0x4, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'RankBias' : [ 0x4, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'Spare1' : [ 0x4, ['BitField', dict(start_bit = 3, end_bit = 32, native_type='unsigned long')]],
} ],
  '_DOMAIN_CONFIGURATION' : [ 0x28, {
    'Type' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: u'DomainConfigurationArm64', 1: u'DomainConfigurationInvalid'})]],
    'Arm64' : [ 0x8, ['_DOMAIN_CONFIGURATION_ARM64']],
} ],
  '_POP_POLICY_DEVICE' : [ 0x40, {
    'Link' : [ 0x0, ['_LIST_ENTRY']],
    'DeviceType' : [ 0x10, ['Enumeration', dict(target = 'long', choices = {0: u'PolicyDeviceSystemButton', 1: u'PolicyDeviceThermalZone', 2: u'PolicyDeviceBattery', 3: u'PolicyDeviceMemory', 4: u'PolicyInitiatePowerActionAPI', 5: u'PolicySetPowerStateAPI', 6: u'PolicyImmediateDozeS4', 7: u'PolicySystemIdle', 8: u'PolicyDeviceWakeAlarm', 9: u'PolicyDeviceFan', 10: u'PolicyCsBatterySaver', 11: u'PolicyImmediateDozeS4Predicted', 12: u'PolicyImmediateDozeS4PredictedNoWake', 13: u'PolicyImmediateDozeS4AdaptiveBudget', 14: u'PolicyImmediateDozeS4AdaptiveReserveNoWake', 15: u'PolicySystemInitiatedShutdown', 16: u'PolicyDeviceMax'})]],
    'Notification' : [ 0x18, ['pointer64', ['void']]],
    'Name' : [ 0x20, ['_UNICODE_STRING']],
    'Device' : [ 0x30, ['pointer64', ['_DEVICE_OBJECT']]],
    'Irp' : [ 0x38, ['pointer64', ['_IRP']]],
} ],
  '_INVERTED_FUNCTION_TABLE_ENTRY' : [ 0x18, {
    'FunctionTable' : [ 0x0, ['pointer64', ['_IMAGE_RUNTIME_FUNCTION_ENTRY']]],
    'DynamicTable' : [ 0x0, ['pointer64', ['_DYNAMIC_FUNCTION_TABLE']]],
    'ImageBase' : [ 0x8, ['pointer64', ['void']]],
    'SizeOfImage' : [ 0x10, ['unsigned long']],
    'SizeOfTable' : [ 0x14, ['unsigned long']],
} ],
  '_MI_SECTION_IMAGE_INFORMATION' : [ 0x48, {
    'ExportedImageInformation' : [ 0x0, ['_SECTION_IMAGE_INFORMATION']],
    'InternalImageInformation' : [ 0x40, ['_MI_EXTRA_IMAGE_INFORMATION']],
} ],
  '_PPM_SELECTION_STATISTICS' : [ 0x80, {
    'SelectedCount' : [ 0x0, ['unsigned long long']],
    'VetoCount' : [ 0x8, ['unsigned long long']],
    'PreVetoCount' : [ 0x10, ['unsigned long long']],
    'WrongProcessorCount' : [ 0x18, ['unsigned long long']],
    'LatencyCount' : [ 0x20, ['unsigned long long']],
    'IdleDurationCount' : [ 0x28, ['unsigned long long']],
    'DeviceDependencyCount' : [ 0x30, ['unsigned long long']],
    'ProcessorDependencyCount' : [ 0x38, ['unsigned long long']],
    'PlatformOnlyCount' : [ 0x40, ['unsigned long long']],
    'InterruptibleCount' : [ 0x48, ['unsigned long long']],
    'LegacyOverrideCount' : [ 0x50, ['unsigned long long']],
    'CstateCheckCount' : [ 0x58, ['unsigned long long']],
    'NoCStateCount' : [ 0x60, ['unsigned long long']],
    'CoordinatedDependencyCount' : [ 0x68, ['unsigned long long']],
    'NotClockOwnerCount' : [ 0x70, ['unsigned long long']],
    'PreVetoAccounting' : [ 0x78, ['pointer64', ['_PPM_VETO_ACCOUNTING']]],
} ],
  '_CM_KEY_SECURITY' : [ 0x28, {
    'Signature' : [ 0x0, ['unsigned short']],
    'Reserved' : [ 0x2, ['unsigned short']],
    'Flink' : [ 0x4, ['unsigned long']],
    'Blink' : [ 0x8, ['unsigned long']],
    'ReferenceCount' : [ 0xc, ['unsigned long']],
    'DescriptorLength' : [ 0x10, ['unsigned long']],
    'Descriptor' : [ 0x14, ['_SECURITY_DESCRIPTOR_RELATIVE']],
} ],
  '_MI_FREE_LARGE_PAGE_LIST' : [ 0x18, {
    'ListHead' : [ 0x0, ['_LIST_ENTRY']],
    'EntryCount' : [ 0x10, ['unsigned long long']],
} ],
  '_MI_RFG_PROTECTED_STACK' : [ 0x18, {
    'ControlStackBase' : [ 0x0, ['pointer64', ['void']]],
    'ControlStackVad' : [ 0x8, ['pointer64', ['_MMVAD_SHORT']]],
    'OwnerThread' : [ 0x10, ['pointer64', ['void']]],
} ],
  '_POP_FX_COMPONENT' : [ 0x150, {
    'Id' : [ 0x0, ['_GUID']],
    'Index' : [ 0x10, ['unsigned long']],
    'WorkOrder' : [ 0x18, ['_POP_FX_WORK_ORDER']],
    'Device' : [ 0x50, ['pointer64', ['_POP_FX_DEVICE']]],
    'Flags' : [ 0x58, ['_POP_FX_COMPONENT_FLAGS']],
    'Resident' : [ 0x60, ['long']],
    'ActiveEvent' : [ 0x68, ['_KEVENT']],
    'IdleLock' : [ 0x80, ['unsigned long long']],
    'IdleConditionComplete' : [ 0x88, ['long']],
    'IdleStateComplete' : [ 0x8c, ['long']],
    'IdleStamp' : [ 0x90, ['unsigned long long']],
    'CurrentIdleState' : [ 0x98, ['unsigned long']],
    'IdleStateCount' : [ 0x9c, ['unsigned long']],
    'IdleStates' : [ 0xa0, ['pointer64', ['_POP_FX_IDLE_STATE']]],
    'DeepestWakeableIdleState' : [ 0xa8, ['unsigned long']],
    'ProviderCount' : [ 0xac, ['unsigned long']],
    'Providers' : [ 0xb0, ['pointer64', ['_POP_FX_PROVIDER']]],
    'IdleProviderCount' : [ 0xb8, ['unsigned long']],
    'DependentCount' : [ 0xbc, ['unsigned long']],
    'Dependents' : [ 0xc0, ['pointer64', ['_POP_FX_DEPENDENT']]],
    'Accounting' : [ 0xc8, ['_POP_FX_ACCOUNTING']],
    'Performance' : [ 0x148, ['pointer64', ['_POP_FX_PERF_INFO']]],
} ],
  '_DYNAMIC_FUNCTION_TABLE' : [ 0x70, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'FunctionTable' : [ 0x10, ['pointer64', ['_IMAGE_RUNTIME_FUNCTION_ENTRY']]],
    'TimeStamp' : [ 0x18, ['_LARGE_INTEGER']],
    'MinimumAddress' : [ 0x20, ['unsigned long long']],
    'MaximumAddress' : [ 0x28, ['unsigned long long']],
    'BaseAddress' : [ 0x30, ['unsigned long long']],
    'Callback' : [ 0x38, ['pointer64', ['void']]],
    'Context' : [ 0x40, ['pointer64', ['void']]],
    'OutOfProcessCallbackDll' : [ 0x48, ['pointer64', ['wchar']]],
    'Type' : [ 0x50, ['Enumeration', dict(target = 'long', choices = {0: u'RF_SORTED', 1: u'RF_UNSORTED', 2: u'RF_CALLBACK', 3: u'RF_KERNEL_DYNAMIC'})]],
    'EntryCount' : [ 0x54, ['unsigned long']],
    'TreeNode' : [ 0x58, ['_RTL_BALANCED_NODE']],
} ],
  '_ISRDPCSTATS' : [ 0x40, {
    'IsrTime' : [ 0x0, ['unsigned long long']],
    'IsrTimeStart' : [ 0x8, ['unsigned long long']],
    'IsrCount' : [ 0x10, ['unsigned long long']],
    'DpcTime' : [ 0x18, ['unsigned long long']],
    'DpcTimeStart' : [ 0x20, ['unsigned long long']],
    'DpcCount' : [ 0x28, ['unsigned long long']],
    'IsrActive' : [ 0x30, ['unsigned char']],
    'Reserved' : [ 0x31, ['array', 15, ['unsigned char']]],
} ],
  '_XSAVE_FORMAT' : [ 0x200, {
    'ControlWord' : [ 0x0, ['unsigned short']],
    'StatusWord' : [ 0x2, ['unsigned short']],
    'TagWord' : [ 0x4, ['unsigned char']],
    'Reserved1' : [ 0x5, ['unsigned char']],
    'ErrorOpcode' : [ 0x6, ['unsigned short']],
    'ErrorOffset' : [ 0x8, ['unsigned long']],
    'ErrorSelector' : [ 0xc, ['unsigned short']],
    'Reserved2' : [ 0xe, ['unsigned short']],
    'DataOffset' : [ 0x10, ['unsigned long']],
    'DataSelector' : [ 0x14, ['unsigned short']],
    'Reserved3' : [ 0x16, ['unsigned short']],
    'MxCsr' : [ 0x18, ['unsigned long']],
    'MxCsr_Mask' : [ 0x1c, ['unsigned long']],
    'FloatRegisters' : [ 0x20, ['array', 8, ['_M128A']]],
    'XmmRegisters' : [ 0xa0, ['array', 16, ['_M128A']]],
    'Reserved4' : [ 0x1a0, ['array', 96, ['unsigned char']]],
} ],
  '_SEGMENT_FLAGS' : [ 0x4, {
    'TotalNumberOfPtes4132' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 10, native_type='unsigned short')]],
    'Spare0' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 12, native_type='unsigned short')]],
    'LargePages' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned short')]],
    'DebugSymbolsLoaded' : [ 0x0, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned short')]],
    'WriteCombined' : [ 0x0, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned short')]],
    'NoCache' : [ 0x0, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned short')]],
    'Short0' : [ 0x0, ['unsigned short']],
    'Unused' : [ 0x2, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'DefaultProtectionMask' : [ 0x2, ['BitField', dict(start_bit = 1, end_bit = 6, native_type='unsigned char')]],
    'Binary32' : [ 0x2, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned char')]],
    'ContainsDebug' : [ 0x2, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
    'UChar1' : [ 0x2, ['unsigned char']],
    'ForceCollision' : [ 0x3, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'ImageSigningType' : [ 0x3, ['BitField', dict(start_bit = 1, end_bit = 4, native_type='unsigned char')]],
    'ImageSigningLevel' : [ 0x3, ['BitField', dict(start_bit = 4, end_bit = 8, native_type='unsigned char')]],
    'UChar2' : [ 0x3, ['unsigned char']],
} ],
  '_XSTATE_CONTEXT' : [ 0x20, {
    'Mask' : [ 0x0, ['unsigned long long']],
    'Length' : [ 0x8, ['unsigned long']],
    'Reserved1' : [ 0xc, ['unsigned long']],
    'Area' : [ 0x10, ['pointer64', ['_XSAVE_AREA']]],
    'Buffer' : [ 0x18, ['pointer64', ['void']]],
} ],
  '_IO_REMOVE_LOCK' : [ 0x20, {
    'Common' : [ 0x0, ['_IO_REMOVE_LOCK_COMMON_BLOCK']],
} ],
  '__unnamed_2cca' : [ 0x10, {
    'I386' : [ 0x0, ['_I386_LOADER_BLOCK']],
    'Arm' : [ 0x0, ['_ARM_LOADER_BLOCK']],
} ],
  '_LOADER_PARAMETER_BLOCK' : [ 0x160, {
    'OsMajorVersion' : [ 0x0, ['unsigned long']],
    'OsMinorVersion' : [ 0x4, ['unsigned long']],
    'Size' : [ 0x8, ['unsigned long']],
    'OsLoaderSecurityVersion' : [ 0xc, ['unsigned long']],
    'LoadOrderListHead' : [ 0x10, ['_LIST_ENTRY']],
    'MemoryDescriptorListHead' : [ 0x20, ['_LIST_ENTRY']],
    'BootDriverListHead' : [ 0x30, ['_LIST_ENTRY']],
    'EarlyLaunchListHead' : [ 0x40, ['_LIST_ENTRY']],
    'CoreDriverListHead' : [ 0x50, ['_LIST_ENTRY']],
    'CoreExtensionsDriverListHead' : [ 0x60, ['_LIST_ENTRY']],
    'TpmCoreDriverListHead' : [ 0x70, ['_LIST_ENTRY']],
    'KernelStack' : [ 0x80, ['unsigned long long']],
    'Prcb' : [ 0x88, ['unsigned long long']],
    'Process' : [ 0x90, ['unsigned long long']],
    'Thread' : [ 0x98, ['unsigned long long']],
    'KernelStackSize' : [ 0xa0, ['unsigned long']],
    'RegistryLength' : [ 0xa4, ['unsigned long']],
    'RegistryBase' : [ 0xa8, ['pointer64', ['void']]],
    'ConfigurationRoot' : [ 0xb0, ['pointer64', ['_CONFIGURATION_COMPONENT_DATA']]],
    'ArcBootDeviceName' : [ 0xb8, ['pointer64', ['unsigned char']]],
    'ArcHalDeviceName' : [ 0xc0, ['pointer64', ['unsigned char']]],
    'NtBootPathName' : [ 0xc8, ['pointer64', ['unsigned char']]],
    'NtHalPathName' : [ 0xd0, ['pointer64', ['unsigned char']]],
    'LoadOptions' : [ 0xd8, ['pointer64', ['unsigned char']]],
    'NlsData' : [ 0xe0, ['pointer64', ['_NLS_DATA_BLOCK']]],
    'ArcDiskInformation' : [ 0xe8, ['pointer64', ['_ARC_DISK_INFORMATION']]],
    'Extension' : [ 0xf0, ['pointer64', ['_LOADER_PARAMETER_EXTENSION']]],
    'u' : [ 0xf8, ['__unnamed_2cca']],
    'FirmwareInformation' : [ 0x108, ['_FIRMWARE_INFORMATION_LOADER_BLOCK']],
    'OsBootstatPathName' : [ 0x148, ['pointer64', ['unsigned char']]],
    'ArcOSDataDeviceName' : [ 0x150, ['pointer64', ['unsigned char']]],
    'ArcWindowsSysPartName' : [ 0x158, ['pointer64', ['unsigned char']]],
} ],
  '_OBJECT_DUMP_CONTROL' : [ 0x10, {
    'Stream' : [ 0x0, ['pointer64', ['void']]],
    'Detail' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_2cd2' : [ 0x4, {
    'PhysicalAddress' : [ 0x0, ['unsigned long']],
    'VirtualSize' : [ 0x0, ['unsigned long']],
} ],
  '_IMAGE_SECTION_HEADER' : [ 0x28, {
    'Name' : [ 0x0, ['array', 8, ['unsigned char']]],
    'Misc' : [ 0x8, ['__unnamed_2cd2']],
    'VirtualAddress' : [ 0xc, ['unsigned long']],
    'SizeOfRawData' : [ 0x10, ['unsigned long']],
    'PointerToRawData' : [ 0x14, ['unsigned long']],
    'PointerToRelocations' : [ 0x18, ['unsigned long']],
    'PointerToLinenumbers' : [ 0x1c, ['unsigned long']],
    'NumberOfRelocations' : [ 0x20, ['unsigned short']],
    'NumberOfLinenumbers' : [ 0x22, ['unsigned short']],
    'Characteristics' : [ 0x24, ['unsigned long']],
} ],
  '_FAST_OWNER_ENTRY_INTERNAL' : [ 0x48, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'AbLockHandle' : [ 0x10, ['unsigned char']],
    'Disowned' : [ 0x11, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'DynamicallyAllocated' : [ 0x11, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'CallerExclusive' : [ 0x11, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'IsSublistHead' : [ 0x12, ['unsigned char']],
    'IsWaiting' : [ 0x13, ['unsigned char']],
    'LockAddress' : [ 0x18, ['pointer64', ['void']]],
    'ThreadAddress' : [ 0x20, ['pointer64', ['void']]],
    'SublistHead' : [ 0x28, ['_LIST_ENTRY']],
    'LockListEntry' : [ 0x38, ['_LIST_ENTRY']],
} ],
  '_MI_POOL_STATE' : [ 0x148, {
    'MaximumNonPagedPoolThreshold' : [ 0x0, ['unsigned long long']],
    'NonPagedPoolSListMaximum' : [ 0x8, ['array', 3, ['unsigned long']]],
    'AllocatedNonPagedPool' : [ 0x18, ['unsigned long long']],
    'BadPoolHead' : [ 0x20, ['_SINGLE_LIST_ENTRY']],
    'HighEventSets' : [ 0x28, ['unsigned long']],
    'HighEventSetsValid' : [ 0x2c, ['unsigned char']],
    'PoolFailures' : [ 0x30, ['array', 3, ['array', 3, ['unsigned long']]]],
    'PoolFailureReasons' : [ 0x54, ['_MI_POOL_FAILURE_REASONS']],
    'LowPagedPoolThreshold' : [ 0x80, ['unsigned long long']],
    'HighPagedPoolThreshold' : [ 0x88, ['unsigned long long']],
    'PagedPoolSListMaximum' : [ 0x90, ['unsigned long']],
    'PreemptiveTrims' : [ 0x94, ['array', 4, ['unsigned long']]],
    'SpecialPagesInUsePeak' : [ 0xa8, ['unsigned long long']],
    'SpecialPoolRejected' : [ 0xb0, ['array', 6, ['unsigned long']]],
    'SpecialPagesNonPaged' : [ 0xc8, ['unsigned long long']],
    'SpecialPoolPdes' : [ 0xd0, ['long']],
    'SessionSpecialPoolPdesMax' : [ 0xd4, ['unsigned long']],
    'PermittedFaultsLock' : [ 0xd8, ['long']],
    'PermittedFaultsTree' : [ 0xe0, ['_RTL_AVL_TREE']],
    'PermittedFaultsInitialNode' : [ 0xe8, ['array', 2, ['_MI_ACCESS_VIOLATION_RANGE']]],
    'TotalPagedPoolQuota' : [ 0x138, ['unsigned long long']],
    'TotalNonPagedPoolQuota' : [ 0x140, ['unsigned long long']],
} ],
  '_IMAGE_RUNTIME_FUNCTION_ENTRY' : [ 0xc, {
    'BeginAddress' : [ 0x0, ['unsigned long']],
    'EndAddress' : [ 0x4, ['unsigned long']],
    'UnwindInfoAddress' : [ 0x8, ['unsigned long']],
    'UnwindData' : [ 0x8, ['unsigned long']],
} ],
  '_SECTION_IMAGE_INFORMATION' : [ 0x40, {
    'TransferAddress' : [ 0x0, ['pointer64', ['void']]],
    'ZeroBits' : [ 0x8, ['unsigned long']],
    'MaximumStackSize' : [ 0x10, ['unsigned long long']],
    'CommittedStackSize' : [ 0x18, ['unsigned long long']],
    'SubSystemType' : [ 0x20, ['unsigned long']],
    'SubSystemMinorVersion' : [ 0x24, ['unsigned short']],
    'SubSystemMajorVersion' : [ 0x26, ['unsigned short']],
    'SubSystemVersion' : [ 0x24, ['unsigned long']],
    'MajorOperatingSystemVersion' : [ 0x28, ['unsigned short']],
    'MinorOperatingSystemVersion' : [ 0x2a, ['unsigned short']],
    'OperatingSystemVersion' : [ 0x28, ['unsigned long']],
    'ImageCharacteristics' : [ 0x2c, ['unsigned short']],
    'DllCharacteristics' : [ 0x2e, ['unsigned short']],
    'Machine' : [ 0x30, ['unsigned short']],
    'ImageContainsCode' : [ 0x32, ['unsigned char']],
    'ImageFlags' : [ 0x33, ['unsigned char']],
    'ComPlusNativeReady' : [ 0x33, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'ComPlusILOnly' : [ 0x33, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'ImageDynamicallyRelocated' : [ 0x33, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'ImageMappedFlat' : [ 0x33, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'BaseBelow4gb' : [ 0x33, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'ComPlusPrefer32bit' : [ 0x33, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'Reserved' : [ 0x33, ['BitField', dict(start_bit = 6, end_bit = 8, native_type='unsigned char')]],
    'LoaderFlags' : [ 0x34, ['unsigned long']],
    'ImageFileSize' : [ 0x38, ['unsigned long']],
    'CheckSum' : [ 0x3c, ['unsigned long']],
} ],
  '_KSECONDARY_IDT_ENTRY' : [ 0x30, {
    'SpinLock' : [ 0x0, ['unsigned long long']],
    'ConnectLock' : [ 0x8, ['_KEVENT']],
    'LineMasked' : [ 0x20, ['unsigned char']],
    'InterruptList' : [ 0x28, ['pointer64', ['_KINTERRUPT']]],
} ],
  '_PPM_SELECTION_DEPENDENCY' : [ 0x18, {
    'Processor' : [ 0x0, ['unsigned long']],
    'Menu' : [ 0x8, ['_PPM_SELECTION_MENU']],
} ],
  '_AGGREGATED_PAYLOAD_FILTER' : [ 0x50, {
    'MagicValue' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 12, native_type='unsigned short')]],
    'DescriptorVersion' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 16, native_type='unsigned short')]],
    'Size' : [ 0x2, ['unsigned short']],
    'PredicateCount' : [ 0x4, ['unsigned short']],
    'Reserved' : [ 0x6, ['unsigned short']],
    'HashedEventIdBitmap' : [ 0x8, ['unsigned long long']],
    'ProviderGuid' : [ 0x10, ['_GUID']],
    'EachEventTableOffset' : [ 0x20, ['unsigned short']],
    'EachEventTableLength' : [ 0x22, ['unsigned short']],
    'PayloadDecoderTableOffset' : [ 0x24, ['unsigned short']],
    'PayloadDecoderTableLength' : [ 0x26, ['unsigned short']],
    'EventFilterTableOffset' : [ 0x28, ['unsigned short']],
    'EventFilterTableLength' : [ 0x2a, ['unsigned short']],
    'UNICODEStringTableOffset' : [ 0x2c, ['unsigned short']],
    'UNICODEStringTableLength' : [ 0x2e, ['unsigned short']],
    'ANSIStringTableOffset' : [ 0x30, ['unsigned short']],
    'ANSIStringTableLength' : [ 0x32, ['unsigned short']],
    'PredicateTable' : [ 0x38, ['array', 1, ['_EVENT_PAYLOAD_PREDICATE']]],
} ],
  '__unnamed_2cef' : [ 0x4, {
    'PageAlignLargeAllocs' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'FullDecommit' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
} ],
  '_RTL_HP_VS_CONFIG' : [ 0x4, {
    'Flags' : [ 0x0, ['__unnamed_2cef']],
} ],
  '_ARBITER_ORDERING_LIST' : [ 0x10, {
    'Count' : [ 0x0, ['unsigned short']],
    'Maximum' : [ 0x2, ['unsigned short']],
    'Orderings' : [ 0x8, ['pointer64', ['_ARBITER_ORDERING']]],
} ],
  '_MI_HARDWARE_STATE' : [ 0x138, {
    'NodeMask' : [ 0x0, ['unsigned long']],
    'NumaLastRangeIndex' : [ 0x4, ['unsigned long']],
    'NumaTableCaptured' : [ 0x8, ['unsigned char']],
    'NodeShift' : [ 0x9, ['unsigned char']],
    'ChannelShift' : [ 0xa, ['unsigned char']],
    'NodeGraph' : [ 0x10, ['pointer64', ['unsigned short']]],
    'SystemNodeInformation' : [ 0x18, ['pointer64', ['_MI_SYSTEM_NODE_INFORMATION']]],
    'NumaMemoryRanges' : [ 0x20, ['pointer64', ['_HAL_NODE_RANGE']]],
    'ChannelMemoryRanges' : [ 0x28, ['pointer64', ['_HAL_CHANNEL_MEMORY_RANGES']]],
    'SecondLevelCacheSize' : [ 0x30, ['unsigned long']],
    'FirstLevelCacheSize' : [ 0x34, ['unsigned long']],
    'PhysicalAddressBits' : [ 0x38, ['unsigned long']],
    'TotalPagesAllowed' : [ 0x40, ['unsigned long long']],
    'SecondaryColorMask' : [ 0x48, ['unsigned long']],
    'SecondaryColors' : [ 0x4c, ['unsigned long']],
    'LargePageColors' : [ 0x50, ['array', 3, ['unsigned long']]],
    'FlushTbForAttributeChange' : [ 0x5c, ['unsigned long']],
    'FlushCacheForAttributeChange' : [ 0x60, ['unsigned long']],
    'FlushCacheForPageAttributeChange' : [ 0x64, ['unsigned long']],
    'CacheFlushPromoteThreshold' : [ 0x68, ['unsigned long']],
    'FlushTbThreshold' : [ 0x70, ['unsigned long long']],
    'OptimalZeroingAttribute' : [ 0x78, ['array', 4, ['array', 4, ['Enumeration', dict(target = 'long', choices = {0: u'MiNonCached', 1: u'MiCached', 2: u'MiWriteCombined', 3: u'MiNotMapped'})]]]],
    'AttributeChangeRequiresReZero' : [ 0xb8, ['unsigned char']],
    'ZeroCostCounts' : [ 0xc0, ['array', 2, ['_MI_ZERO_COST_COUNTS']]],
    'PrimaryPfns' : [ 0xe0, ['unsigned long long']],
    'HighestPossiblePhysicalPage' : [ 0xe8, ['unsigned long long']],
    'EnclaveRegions' : [ 0xf0, ['_RTL_AVL_TREE']],
    'EnclaveMetadataPage' : [ 0xf8, ['pointer64', ['void']]],
    'EnclaveMetadataBitMap' : [ 0x100, ['pointer64', ['_RTL_BITMAP']]],
    'EnclaveMetadataEntryLock' : [ 0x108, ['_EX_PUSH_LOCK']],
    'EnclaveMetadataPageLock' : [ 0x110, ['long']],
    'VsmKernelPageCount' : [ 0x118, ['unsigned long long']],
    'ColorCount' : [ 0x120, ['array', 3, ['unsigned long long']]],
} ],
  '_PPM_VETO_ACCOUNTING' : [ 0x28, {
    'VetoPresent' : [ 0x0, ['long']],
    'VetoListHead' : [ 0x8, ['_LIST_ENTRY']],
    'CsAccountingBlocks' : [ 0x18, ['unsigned char']],
    'BlocksDrips' : [ 0x19, ['unsigned char']],
    'PreallocatedVetoCount' : [ 0x1c, ['unsigned long']],
    'PreallocatedVetoList' : [ 0x20, ['pointer64', ['_PPM_VETO_ENTRY']]],
} ],
  '_EX_PARTITION' : [ 0x20, {
    'PartitionObject' : [ 0x0, ['pointer64', ['_EPARTITION']]],
    'WorkQueues' : [ 0x8, ['pointer64', ['pointer64', ['pointer64', ['_EX_WORK_QUEUE']]]]],
    'WorkQueueManagers' : [ 0x10, ['pointer64', ['pointer64', ['_EX_WORK_QUEUE_MANAGER']]]],
    'QueueAllocationMask' : [ 0x18, ['long']],
} ],
  '__unnamed_2d10' : [ 0x8, {
    'idxRecord' : [ 0x0, ['unsigned long']],
    'cidContainer' : [ 0x4, ['unsigned long']],
} ],
  '_CLS_LSN' : [ 0x8, {
    'offset' : [ 0x0, ['__unnamed_2d10']],
    'ullOffset' : [ 0x0, ['unsigned long long']],
} ],
  '_SYSPTES_HEADER' : [ 0x118, {
    'ListHead' : [ 0x0, ['array', 16, ['_LIST_ENTRY']]],
    'Count' : [ 0x100, ['unsigned long long']],
    'NumberOfEntries' : [ 0x108, ['unsigned long long']],
    'NumberOfEntriesPeak' : [ 0x110, ['unsigned long long']],
} ],
  '_MI_ERROR_STATE' : [ 0xc8, {
    'BadMemoryEventEntry' : [ 0x0, ['_MI_BAD_MEMORY_EVENT_ENTRY']],
    'PageOfInterest' : [ 0x38, ['unsigned long long']],
    'ProbeRaises' : [ 0x40, ['_MI_PROBE_RAISE_TRACKER']],
    'ForcedCommits' : [ 0x84, ['_MI_FORCED_COMMITS']],
    'WsleFailures' : [ 0x8c, ['array', 1, ['unsigned long']]],
    'PageHashErrors' : [ 0x90, ['unsigned long']],
    'CheckZeroCount' : [ 0x94, ['unsigned long']],
    'ZeroedPageSingleBitErrorsDetected' : [ 0x98, ['long']],
    'BadPagesDetected' : [ 0x9c, ['long']],
    'ScrubPasses' : [ 0xa0, ['long']],
    'ScrubBadPagesFound' : [ 0xa4, ['long']],
    'UserViewFailures' : [ 0xa8, ['unsigned long']],
    'UserViewCollisionFailures' : [ 0xac, ['unsigned long']],
    'UserAllocateFailures' : [ 0xb0, ['unsigned long']],
    'UserAllocateCollisionFailures' : [ 0xb4, ['unsigned long']],
    'ResavailFailures' : [ 0xb8, ['_MI_RESAVAIL_FAILURES']],
    'PendingBadPages' : [ 0xc0, ['unsigned char']],
    'InitFailure' : [ 0xc1, ['unsigned char']],
    'StopBadMaps' : [ 0xc2, ['unsigned char']],
} ],
  '_PROC_PERF_DOMAIN' : [ 0x2b8, {
    'Link' : [ 0x0, ['_LIST_ENTRY']],
    'Master' : [ 0x10, ['pointer64', ['_KPRCB']]],
    'Members' : [ 0x18, ['_KAFFINITY_EX']],
    'DomainContext' : [ 0xc0, ['unsigned long long']],
    'ProcessorCount' : [ 0xc8, ['unsigned long']],
    'EfficiencyClass' : [ 0xcc, ['unsigned char']],
    'NominalPerformanceClass' : [ 0xcd, ['unsigned char']],
    'HighestPerformanceClass' : [ 0xce, ['unsigned char']],
    'Spare' : [ 0xcf, ['unsigned char']],
    'Processors' : [ 0xd0, ['pointer64', ['_PROC_PERF_CONSTRAINT']]],
    'GetFFHThrottleState' : [ 0xd8, ['pointer64', ['void']]],
    'TimeWindowHandler' : [ 0xe0, ['pointer64', ['void']]],
    'BoostPolicyHandler' : [ 0xe8, ['pointer64', ['void']]],
    'BoostModeHandler' : [ 0xf0, ['pointer64', ['void']]],
    'EnergyPerfPreferenceHandler' : [ 0xf8, ['pointer64', ['void']]],
    'AutonomousActivityWindowHandler' : [ 0x100, ['pointer64', ['void']]],
    'AutonomousModeHandler' : [ 0x108, ['pointer64', ['void']]],
    'ReinitializeHandler' : [ 0x110, ['pointer64', ['void']]],
    'PerfSelectionHandler' : [ 0x118, ['pointer64', ['void']]],
    'PerfControlHandler' : [ 0x120, ['pointer64', ['void']]],
    'DomainPerfControlHandler' : [ 0x128, ['pointer64', ['void']]],
    'MaxFrequency' : [ 0x130, ['unsigned long']],
    'NominalFrequency' : [ 0x134, ['unsigned long']],
    'MaxPercent' : [ 0x138, ['unsigned long']],
    'MinPerfPercent' : [ 0x13c, ['unsigned long']],
    'MinThrottlePercent' : [ 0x140, ['unsigned long']],
    'MinimumRelativePerformance' : [ 0x148, ['unsigned long long']],
    'NominalRelativePerformance' : [ 0x150, ['unsigned long long']],
    'NominalRelativePerformancePercent' : [ 0x158, ['unsigned char']],
    'Coordination' : [ 0x159, ['unsigned char']],
    'HardPlatformCap' : [ 0x15a, ['unsigned char']],
    'AffinitizeControl' : [ 0x15b, ['unsigned char']],
    'EfficientThrottle' : [ 0x15c, ['unsigned char']],
    'AllowSchedulerDirectedPerfStates' : [ 0x15d, ['unsigned char']],
    'InitiateAllProcessors' : [ 0x15e, ['unsigned char']],
    'AutonomousMode' : [ 0x15f, ['unsigned char']],
    'ProvideGuidance' : [ 0x160, ['unsigned char']],
    'DesiredPercent' : [ 0x164, ['unsigned long']],
    'GuaranteedPercent' : [ 0x168, ['unsigned long']],
    'QosPolicies' : [ 0x16c, ['array', 4, ['_PROC_PERF_QOS_CLASS_POLICY']]],
    'QosDisableReasons' : [ 0x1dc, ['array', 4, ['unsigned long']]],
    'QosEquivalencyMasks' : [ 0x1ec, ['array', 4, ['unsigned long']]],
    'QosSupported' : [ 0x1fc, ['unsigned char']],
    'SelectionGeneration' : [ 0x200, ['unsigned long']],
    'QosSelection' : [ 0x208, ['array', 4, ['_PERF_CONTROL_STATE_SELECTION']]],
    'PerfChangeTime' : [ 0x2a8, ['unsigned long long']],
    'PerfChangeIntervalCount' : [ 0x2b0, ['unsigned long']],
    'Force' : [ 0x2b4, ['unsigned char']],
} ],
  '_MI_COMMON_PAGE_STATE' : [ 0xa8, {
    'PageOfOnesPfn' : [ 0x0, ['pointer64', ['_MMPFN']]],
    'PageOfOnes' : [ 0x8, ['unsigned long long']],
    'DummyPagePfn' : [ 0x10, ['pointer64', ['_MMPFN']]],
    'DummyPage' : [ 0x18, ['unsigned long long']],
    'PageOfZeroes' : [ 0x20, ['unsigned long long']],
    'ZeroMapping' : [ 0x28, ['pointer64', ['void']]],
    'OnesMapping' : [ 0x30, ['pointer64', ['void']]],
    'ZeroCrc' : [ 0x38, ['unsigned long long']],
    'OnesCrc' : [ 0x40, ['unsigned long long']],
    'BitmapGapFrames' : [ 0x48, ['array', 4, ['unsigned long long']]],
    'PfnGapFrames' : [ 0x68, ['array', 4, ['unsigned long long']]],
    'PageTableOfZeroes' : [ 0x88, ['unsigned long long']],
    'PdeOfZeroes' : [ 0x90, ['_MMPTE']],
    'PageTableOfOnes' : [ 0x98, ['unsigned long long']],
    'PdeOfOnes' : [ 0xa0, ['_MMPTE']],
} ],
  '_HAL_HV_DMA_DOMAIN_INFO' : [ 0x8, {
    'DomainId' : [ 0x0, ['unsigned long']],
    'IsStage1' : [ 0x4, ['unsigned char']],
} ],
  '_RTL_BALANCED_LINKS' : [ 0x20, {
    'Parent' : [ 0x0, ['pointer64', ['_RTL_BALANCED_LINKS']]],
    'LeftChild' : [ 0x8, ['pointer64', ['_RTL_BALANCED_LINKS']]],
    'RightChild' : [ 0x10, ['pointer64', ['_RTL_BALANCED_LINKS']]],
    'Balance' : [ 0x18, ['unsigned char']],
    'Reserved' : [ 0x19, ['array', 3, ['unsigned char']]],
} ],
  '_HEAP_EXTENDED_ENTRY' : [ 0x10, {
    'Reserved' : [ 0x0, ['pointer64', ['void']]],
    'FunctionIndex' : [ 0x8, ['unsigned short']],
    'ContextValue' : [ 0xa, ['unsigned short']],
    'InterceptorValue' : [ 0x8, ['unsigned long']],
    'UnusedBytesLength' : [ 0xc, ['unsigned short']],
    'EntryOffset' : [ 0xe, ['unsigned char']],
    'ExtendedBlockSignature' : [ 0xf, ['unsigned char']],
} ],
  '_SUPPORTED_RANGES' : [ 0xc0, {
    'Version' : [ 0x0, ['unsigned short']],
    'Sorted' : [ 0x2, ['unsigned char']],
    'Reserved' : [ 0x3, ['unsigned char']],
    'NoIO' : [ 0x4, ['unsigned long']],
    'IO' : [ 0x8, ['_SUPPORTED_RANGE']],
    'NoMemory' : [ 0x30, ['unsigned long']],
    'Memory' : [ 0x38, ['_SUPPORTED_RANGE']],
    'NoPrefetchMemory' : [ 0x60, ['unsigned long']],
    'PrefetchMemory' : [ 0x68, ['_SUPPORTED_RANGE']],
    'NoDma' : [ 0x90, ['unsigned long']],
    'Dma' : [ 0x98, ['_SUPPORTED_RANGE']],
} ],
  '_ETW_WMITRACE_WORK' : [ 0xf0, {
    'LoggerId' : [ 0x0, ['unsigned long']],
    'SiloSessionId' : [ 0x4, ['unsigned long']],
    'LoggerName' : [ 0x8, ['array', 65, ['unsigned char']]],
    'FileName' : [ 0x49, ['array', 129, ['unsigned char']]],
    'MaximumFileSize' : [ 0xcc, ['unsigned long']],
    'MinBuffers' : [ 0xd0, ['unsigned long']],
    'MaxBuffers' : [ 0xd4, ['unsigned long']],
    'BufferSize' : [ 0xd8, ['unsigned long']],
    'Mode' : [ 0xdc, ['unsigned long']],
    'FlushTimer' : [ 0xe0, ['unsigned long']],
    'MatchAny' : [ 0x8, ['unsigned long long']],
    'MatchAll' : [ 0x10, ['unsigned long long']],
    'EnableProperty' : [ 0x18, ['unsigned long']],
    'Guid' : [ 0x1c, ['_GUID']],
    'Level' : [ 0x2c, ['unsigned char']],
    'Status' : [ 0xe8, ['long']],
} ],
  '_MAPPED_FILE_SEGMENT' : [ 0x30, {
    'ControlArea' : [ 0x0, ['pointer64', ['_CONTROL_AREA']]],
    'TotalNumberOfPtes' : [ 0x8, ['unsigned long']],
    'SegmentFlags' : [ 0xc, ['_SEGMENT_FLAGS']],
    'NumberOfCommittedPages' : [ 0x10, ['unsigned long long']],
    'SizeOfSegment' : [ 0x18, ['unsigned long long']],
    'ExtendInfo' : [ 0x20, ['pointer64', ['_MMEXTEND_INFO']]],
    'BasedAddress' : [ 0x20, ['pointer64', ['void']]],
    'SegmentLock' : [ 0x28, ['_EX_PUSH_LOCK']],
} ],
  '_MMPTE_TRANSITION' : [ 0x8, {
    'Valid' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'Write' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long long')]],
    'Spare' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 4, native_type='unsigned long long')]],
    'IoTracker' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long long')]],
    'Protection' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 10, native_type='unsigned long long')]],
    'Prototype' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long long')]],
    'Transition' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long long')]],
    'PageFrameNumber' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 48, native_type='unsigned long long')]],
    'Unused' : [ 0x0, ['BitField', dict(start_bit = 48, end_bit = 64, native_type='unsigned long long')]],
} ],
  '_DEVICE_OBJECT_LIST' : [ 0x28, {
    'Count' : [ 0x0, ['unsigned long']],
    'MaxCount' : [ 0x4, ['unsigned long']],
    'TagCount' : [ 0x8, ['unsigned long']],
    'OperationCode' : [ 0xc, ['Enumeration', dict(target = 'long', choices = {0: u'QueryRemoveDevice', 1: u'CancelRemoveDevice', 2: u'RemoveDevice', 3: u'SurpriseRemoveDevice', 4: u'EjectDevice', 5: u'RemoveFailedDevice', 6: u'RemoveUnstartedFailedDevice', 7: u'MaxDeviceDeleteType'})]],
    'Devices' : [ 0x10, ['array', 1, ['_DEVICE_OBJECT_LIST_ENTRY']]],
} ],
  '_DEBUG_TRANSPORT_DATA' : [ 0x8, {
    'HwContextSize' : [ 0x0, ['unsigned long']],
    'UseSerialFraming' : [ 0x4, ['unsigned char']],
} ],
  '_CM_KEY_INDEX' : [ 0x8, {
    'Signature' : [ 0x0, ['unsigned short']],
    'Count' : [ 0x2, ['unsigned short']],
    'List' : [ 0x4, ['array', 1, ['unsigned long']]],
} ],
  '_HAL_HV_SVM_DEVICE_CAPABILITIES' : [ 0xc, {
    'SvmSupported' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'PciExecute' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'NoExecute' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 31, native_type='unsigned long')]],
    'OverflowPossible' : [ 0x0, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
    'PasidCount' : [ 0x4, ['unsigned long']],
    'IommuIndex' : [ 0x8, ['unsigned long']],
} ],
  '_POP_COOLING_EXTENSION' : [ 0x90, {
    'Link' : [ 0x0, ['_LIST_ENTRY']],
    'RequestListHead' : [ 0x10, ['_LIST_ENTRY']],
    'Lock' : [ 0x20, ['_POP_RW_LOCK']],
    'DeviceObject' : [ 0x30, ['pointer64', ['_DEVICE_OBJECT']]],
    'NotificationEntry' : [ 0x38, ['pointer64', ['void']]],
    'Enabled' : [ 0x40, ['unsigned char']],
    'ActiveEngaged' : [ 0x41, ['unsigned char']],
    'ThrottleLimit' : [ 0x42, ['unsigned char']],
    'UpdatingToCurrent' : [ 0x43, ['unsigned char']],
    'RemovalFlushEvent' : [ 0x48, ['pointer64', ['_KEVENT']]],
    'PnpFlushEvent' : [ 0x50, ['pointer64', ['_KEVENT']]],
    'Interface' : [ 0x58, ['_THERMAL_COOLING_INTERFACE']],
} ],
  '__unnamed_2d53' : [ 0x50, {
    'CellData' : [ 0x0, ['_CELL_DATA']],
    'List' : [ 0x0, ['array', 1, ['unsigned long long']]],
} ],
  '_CM_CACHED_VALUE_INDEX' : [ 0x58, {
    'CellIndex' : [ 0x0, ['unsigned long']],
    'Data' : [ 0x8, ['__unnamed_2d53']],
} ],
  '_KTMOBJECT_NAMESPACE_LINK' : [ 0x28, {
    'Links' : [ 0x0, ['_RTL_BALANCED_LINKS']],
    'Expired' : [ 0x20, ['unsigned char']],
} ],
  '_POOL_HEADER' : [ 0x10, {
    'PreviousSize' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned short')]],
    'PoolIndex' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 16, native_type='unsigned short')]],
    'BlockSize' : [ 0x2, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned short')]],
    'PoolType' : [ 0x2, ['BitField', dict(start_bit = 8, end_bit = 16, native_type='unsigned short')]],
    'Ulong1' : [ 0x0, ['unsigned long']],
    'PoolTag' : [ 0x4, ['unsigned long']],
    'ProcessBilled' : [ 0x8, ['pointer64', ['_EPROCESS']]],
    'AllocatorBackTraceIndex' : [ 0x8, ['unsigned short']],
    'PoolTagHash' : [ 0xa, ['unsigned short']],
} ],
  '_POP_POWER_SETTING_VALUES' : [ 0x144, {
    'StructureSize' : [ 0x0, ['unsigned long']],
    'PopPolicy' : [ 0x4, ['_SYSTEM_POWER_POLICY']],
    'CurrentAcDcPowerState' : [ 0xec, ['Enumeration', dict(target = 'long', choices = {0: u'PoAc', 1: u'PoDc', 2: u'PoHot', 3: u'PoConditionMaximum'})]],
    'AwayModeEnabled' : [ 0xf0, ['unsigned char']],
    'AwayModeEngaged' : [ 0xf1, ['unsigned char']],
    'AwayModePolicyAllowed' : [ 0xf2, ['unsigned char']],
    'AwayModeIgnoreUserPresent' : [ 0xf4, ['long']],
    'AwayModeIgnoreAction' : [ 0xf8, ['long']],
    'DisableFastS4' : [ 0xfc, ['unsigned char']],
    'DisableStandbyStates' : [ 0xfd, ['unsigned char']],
    'UnattendSleepTimeout' : [ 0x100, ['unsigned long']],
    'DiskIgnoreTime' : [ 0x104, ['unsigned long']],
    'DeviceIdlePolicy' : [ 0x108, ['unsigned long']],
    'VideoDimTimeout' : [ 0x10c, ['unsigned long']],
    'VideoNormalBrightness' : [ 0x110, ['unsigned long']],
    'VideoDimBrightness' : [ 0x114, ['unsigned long']],
    'AlsOffset' : [ 0x118, ['unsigned long']],
    'AlsEnabled' : [ 0x11c, ['unsigned long']],
    'EsBrightness' : [ 0x120, ['unsigned long']],
    'SwitchShutdownForced' : [ 0x124, ['unsigned char']],
    'SystemCoolingPolicy' : [ 0x128, ['unsigned long']],
    'MediaBufferingEngaged' : [ 0x12c, ['unsigned char']],
    'AudioActivity' : [ 0x12d, ['unsigned char']],
    'FullscreenVideoPlayback' : [ 0x12e, ['unsigned char']],
    'EsBatteryThreshold' : [ 0x130, ['unsigned long']],
    'EsAggressive' : [ 0x134, ['unsigned char']],
    'EsUserAwaySetting' : [ 0x135, ['unsigned char']],
    'ConnectivityInStandby' : [ 0x138, ['unsigned long']],
    'DisconnectedStandbyMode' : [ 0x13c, ['unsigned long']],
    'UserPresencePredictionEnabled' : [ 0x140, ['unsigned long']],
} ],
  '_XPF_MC_BANK_FLAGS' : [ 0x1, {
    'ClearOnInitializationRW' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'ControlDataRW' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 8, native_type='unsigned char')]],
    'AsUCHAR' : [ 0x0, ['unsigned char']],
} ],
  '_PROC_PERF_HISTORY_ENTRY' : [ 0x8, {
    'Utility' : [ 0x0, ['unsigned short']],
    'AffinitizedUtility' : [ 0x2, ['unsigned short']],
    'Frequency' : [ 0x4, ['unsigned char']],
    'TaggedPercent' : [ 0x5, ['array', 2, ['unsigned char']]],
} ],
  '_ARBITER_BOOT_ALLOCATION_PARAMETERS' : [ 0x8, {
    'ArbitrationList' : [ 0x0, ['pointer64', ['_LIST_ENTRY']]],
} ],
  '__unnamed_2d66' : [ 0x8, {
    'Flags' : [ 0x0, ['_MMSECURE_FLAGS']],
    'FlagsLong' : [ 0x0, ['unsigned long']],
    'StartVa' : [ 0x0, ['pointer64', ['void']]],
} ],
  '_MMADDRESS_LIST' : [ 0x10, {
    'u1' : [ 0x0, ['__unnamed_2d66']],
    'EndVa' : [ 0x8, ['pointer64', ['void']]],
} ],
  '_POP_FX_IDLE_STATE' : [ 0x18, {
    'TransitionLatency' : [ 0x0, ['unsigned long long']],
    'ResidencyRequirement' : [ 0x8, ['unsigned long long']],
    'NominalPower' : [ 0x10, ['unsigned long']],
} ],
  '_HAL_IOMMU_DISPATCH' : [ 0x98, {
    'HalIommuSupportEnabled' : [ 0x0, ['pointer64', ['void']]],
    'HalIommuGetConfiguration' : [ 0x8, ['pointer64', ['void']]],
    'HalIommuGetLibraryContext' : [ 0x10, ['pointer64', ['void']]],
    'HalIommuMapDevice' : [ 0x18, ['pointer64', ['void']]],
    'HalIommuEnableDevicePasid' : [ 0x20, ['pointer64', ['void']]],
    'HalIommuSetAddressSpace' : [ 0x28, ['pointer64', ['void']]],
    'HalIommuDisableDevicePasid' : [ 0x30, ['pointer64', ['void']]],
    'HalIommuUnmapDevice' : [ 0x38, ['pointer64', ['void']]],
    'HalIommuFreeLibraryContext' : [ 0x40, ['pointer64', ['void']]],
    'HalIommuFlushTb' : [ 0x48, ['pointer64', ['void']]],
    'HalIommuFlushAllPasid' : [ 0x50, ['pointer64', ['void']]],
    'HalIommuProcessPageRequestQueue' : [ 0x58, ['pointer64', ['void']]],
    'HalIommuFaultRoutine' : [ 0x60, ['pointer64', ['void']]],
    'HalIommuReferenceAsid' : [ 0x68, ['pointer64', ['void']]],
    'HalIommuDereferenceAsid' : [ 0x70, ['pointer64', ['void']]],
    'HalIommuServicePageFault' : [ 0x78, ['pointer64', ['void']]],
    'HalIommuDevicePowerChange' : [ 0x80, ['pointer64', ['void']]],
    'HalIommuBeginDeviceReset' : [ 0x88, ['pointer64', ['void']]],
    'HalIommuFinalizeDeviceReset' : [ 0x90, ['pointer64', ['void']]],
} ],
  '_MI_ZERO_COST_COUNTS' : [ 0x10, {
    'NativeSum' : [ 0x0, ['unsigned long long']],
    'CachedSum' : [ 0x8, ['unsigned long long']],
} ],
  '_POP_FX_WORK_ORDER_WATCHDOG_INFO' : [ 0xb0, {
    'Link' : [ 0x0, ['_LIST_ENTRY']],
    'Timer' : [ 0x10, ['_KTIMER']],
    'Dpc' : [ 0x50, ['_KDPC']],
    'WorkOrder' : [ 0x90, ['pointer64', ['_POP_FX_WORK_ORDER']]],
    'CurrentWorkInfo' : [ 0x98, ['pointer64', ['_PEP_WORK_INFORMATION']]],
    'WatchdogStart' : [ 0xa0, ['unsigned long long']],
    'WorkerThread' : [ 0xa8, ['pointer64', ['_KTHREAD']]],
} ],
  '_ARBITER_INTERFACE' : [ 0x30, {
    'Size' : [ 0x0, ['unsigned short']],
    'Version' : [ 0x2, ['unsigned short']],
    'Context' : [ 0x8, ['pointer64', ['void']]],
    'InterfaceReference' : [ 0x10, ['pointer64', ['void']]],
    'InterfaceDereference' : [ 0x18, ['pointer64', ['void']]],
    'ArbiterHandler' : [ 0x20, ['pointer64', ['void']]],
    'Flags' : [ 0x28, ['unsigned long']],
} ],
  '__unnamed_2d97' : [ 0x20, {
    'TestAllocation' : [ 0x0, ['_ARBITER_TEST_ALLOCATION_PARAMETERS']],
    'RetestAllocation' : [ 0x0, ['_ARBITER_RETEST_ALLOCATION_PARAMETERS']],
    'BootAllocation' : [ 0x0, ['_ARBITER_BOOT_ALLOCATION_PARAMETERS']],
    'QueryAllocatedResources' : [ 0x0, ['_ARBITER_QUERY_ALLOCATED_RESOURCES_PARAMETERS']],
    'QueryConflict' : [ 0x0, ['_ARBITER_QUERY_CONFLICT_PARAMETERS']],
    'QueryArbitrate' : [ 0x0, ['_ARBITER_QUERY_ARBITRATE_PARAMETERS']],
    'AddReserved' : [ 0x0, ['_ARBITER_ADD_RESERVED_PARAMETERS']],
} ],
  '_ARBITER_PARAMETERS' : [ 0x20, {
    'Parameters' : [ 0x0, ['__unnamed_2d97']],
} ],
  '__unnamed_2d9b' : [ 0x18, {
    'Length' : [ 0x0, ['unsigned long']],
    'Alignment' : [ 0x4, ['unsigned long']],
    'MinimumAddress' : [ 0x8, ['_LARGE_INTEGER']],
    'MaximumAddress' : [ 0x10, ['_LARGE_INTEGER']],
} ],
  '__unnamed_2d9f' : [ 0x18, {
    'MinimumVector' : [ 0x0, ['unsigned long']],
    'MaximumVector' : [ 0x4, ['unsigned long']],
    'AffinityPolicy' : [ 0x8, ['unsigned short']],
    'Group' : [ 0xa, ['unsigned short']],
    'PriorityPolicy' : [ 0xc, ['Enumeration', dict(target = 'long', choices = {0: u'IrqPriorityUndefined', 1: u'IrqPriorityLow', 2: u'IrqPriorityNormal', 3: u'IrqPriorityHigh'})]],
    'TargetedProcessors' : [ 0x10, ['unsigned long long']],
} ],
  '__unnamed_2da1' : [ 0x8, {
    'MinimumChannel' : [ 0x0, ['unsigned long']],
    'MaximumChannel' : [ 0x4, ['unsigned long']],
} ],
  '__unnamed_2da3' : [ 0x10, {
    'RequestLine' : [ 0x0, ['unsigned long']],
    'Reserved' : [ 0x4, ['unsigned long']],
    'Channel' : [ 0x8, ['unsigned long']],
    'TransferWidth' : [ 0xc, ['unsigned long']],
} ],
  '__unnamed_2da5' : [ 0xc, {
    'Data' : [ 0x0, ['array', 3, ['unsigned long']]],
} ],
  '__unnamed_2da7' : [ 0x10, {
    'Length' : [ 0x0, ['unsigned long']],
    'MinBusNumber' : [ 0x4, ['unsigned long']],
    'MaxBusNumber' : [ 0x8, ['unsigned long']],
    'Reserved' : [ 0xc, ['unsigned long']],
} ],
  '__unnamed_2da9' : [ 0xc, {
    'Priority' : [ 0x0, ['unsigned long']],
    'Reserved1' : [ 0x4, ['unsigned long']],
    'Reserved2' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_2dab' : [ 0x18, {
    'Length40' : [ 0x0, ['unsigned long']],
    'Alignment40' : [ 0x4, ['unsigned long']],
    'MinimumAddress' : [ 0x8, ['_LARGE_INTEGER']],
    'MaximumAddress' : [ 0x10, ['_LARGE_INTEGER']],
} ],
  '__unnamed_2dad' : [ 0x18, {
    'Length48' : [ 0x0, ['unsigned long']],
    'Alignment48' : [ 0x4, ['unsigned long']],
    'MinimumAddress' : [ 0x8, ['_LARGE_INTEGER']],
    'MaximumAddress' : [ 0x10, ['_LARGE_INTEGER']],
} ],
  '__unnamed_2daf' : [ 0x18, {
    'Length64' : [ 0x0, ['unsigned long']],
    'Alignment64' : [ 0x4, ['unsigned long']],
    'MinimumAddress' : [ 0x8, ['_LARGE_INTEGER']],
    'MaximumAddress' : [ 0x10, ['_LARGE_INTEGER']],
} ],
  '__unnamed_2db1' : [ 0xc, {
    'Class' : [ 0x0, ['unsigned char']],
    'Type' : [ 0x1, ['unsigned char']],
    'Reserved1' : [ 0x2, ['unsigned char']],
    'Reserved2' : [ 0x3, ['unsigned char']],
    'IdLowPart' : [ 0x4, ['unsigned long']],
    'IdHighPart' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_2db3' : [ 0x18, {
    'Port' : [ 0x0, ['__unnamed_2d9b']],
    'Memory' : [ 0x0, ['__unnamed_2d9b']],
    'Interrupt' : [ 0x0, ['__unnamed_2d9f']],
    'Dma' : [ 0x0, ['__unnamed_2da1']],
    'DmaV3' : [ 0x0, ['__unnamed_2da3']],
    'Generic' : [ 0x0, ['__unnamed_2d9b']],
    'DevicePrivate' : [ 0x0, ['__unnamed_2da5']],
    'BusNumber' : [ 0x0, ['__unnamed_2da7']],
    'ConfigData' : [ 0x0, ['__unnamed_2da9']],
    'Memory40' : [ 0x0, ['__unnamed_2dab']],
    'Memory48' : [ 0x0, ['__unnamed_2dad']],
    'Memory64' : [ 0x0, ['__unnamed_2daf']],
    'Connection' : [ 0x0, ['__unnamed_2db1']],
} ],
  '_IO_RESOURCE_DESCRIPTOR' : [ 0x20, {
    'Option' : [ 0x0, ['unsigned char']],
    'Type' : [ 0x1, ['unsigned char']],
    'ShareDisposition' : [ 0x2, ['unsigned char']],
    'Spare1' : [ 0x3, ['unsigned char']],
    'Flags' : [ 0x4, ['unsigned short']],
    'Spare2' : [ 0x6, ['unsigned short']],
    'u' : [ 0x8, ['__unnamed_2db3']],
} ],
  '_HEAP_UNPACKED_ENTRY' : [ 0x10, {
    'PreviousBlockPrivateData' : [ 0x0, ['pointer64', ['void']]],
    'Size' : [ 0x8, ['unsigned short']],
    'Flags' : [ 0xa, ['unsigned char']],
    'SmallTagIndex' : [ 0xb, ['unsigned char']],
    'SubSegmentCode' : [ 0x8, ['unsigned long']],
    'PreviousSize' : [ 0xc, ['unsigned short']],
    'SegmentOffset' : [ 0xe, ['unsigned char']],
    'LFHFlags' : [ 0xe, ['unsigned char']],
    'UnusedBytes' : [ 0xf, ['unsigned char']],
    'CompactHeader' : [ 0x8, ['unsigned long long']],
} ],
  '_HEAP_UCR_DESCRIPTOR' : [ 0x30, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'SegmentEntry' : [ 0x10, ['_LIST_ENTRY']],
    'Address' : [ 0x20, ['pointer64', ['void']]],
    'Size' : [ 0x28, ['unsigned long long']],
} ],
  '_DRIVER_EXTENSION' : [ 0x50, {
    'DriverObject' : [ 0x0, ['pointer64', ['_DRIVER_OBJECT']]],
    'AddDevice' : [ 0x8, ['pointer64', ['void']]],
    'Count' : [ 0x10, ['unsigned long']],
    'ServiceKeyName' : [ 0x18, ['_UNICODE_STRING']],
    'ClientDriverExtension' : [ 0x28, ['pointer64', ['_IO_CLIENT_EXTENSION']]],
    'FsFilterCallbacks' : [ 0x30, ['pointer64', ['_FS_FILTER_CALLBACKS']]],
    'KseCallbacks' : [ 0x38, ['pointer64', ['void']]],
    'DvCallbacks' : [ 0x40, ['pointer64', ['void']]],
    'VerifierContext' : [ 0x48, ['pointer64', ['void']]],
} ],
  '_ETW_PROVIDER_TRAITS' : [ 0x20, {
    'Node' : [ 0x0, ['_RTL_BALANCED_NODE']],
    'ReferenceCount' : [ 0x18, ['unsigned long']],
    'Traits' : [ 0x1c, ['array', 1, ['unsigned char']]],
} ],
  '_ETW_QUEUE_ENTRY' : [ 0x38, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'DataBlock' : [ 0x10, ['pointer64', ['_ETWP_NOTIFICATION_HEADER']]],
    'RegEntry' : [ 0x18, ['pointer64', ['_ETW_REG_ENTRY']]],
    'ReplyObject' : [ 0x20, ['pointer64', ['_ETW_REG_ENTRY']]],
    'WakeReference' : [ 0x28, ['pointer64', ['void']]],
    'RegIndex' : [ 0x30, ['unsigned short']],
    'ReplyIndex' : [ 0x32, ['unsigned short']],
    'Flags' : [ 0x34, ['unsigned long']],
} ],
  '_MI_PARTITION_FLAGS' : [ 0x4, {
    'BeingDeleted' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'PageListsInitialized' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'StoreReservedPagesCharged' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'PureHoldingPartition' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
} ],
  '_PERFINFO_PPM_STATE_SELECTION' : [ 0xc, {
    'SelectedState' : [ 0x0, ['unsigned long']],
    'VetoedStates' : [ 0x4, ['unsigned long']],
    'VetoReason' : [ 0x8, ['array', 1, ['unsigned long']]],
} ],
  '_INTERRUPT_CONNECTION_DATA' : [ 0x60, {
    'Count' : [ 0x0, ['unsigned long']],
    'Vectors' : [ 0x8, ['array', 1, ['_INTERRUPT_VECTOR_DATA']]],
} ],
  '__unnamed_2dd0' : [ 0xc, {
    'MessageAddressHigh' : [ 0x0, ['unsigned long']],
    'MessageAddressLow' : [ 0x4, ['unsigned long']],
    'MessageData' : [ 0x8, ['unsigned short']],
    'Reserved' : [ 0xa, ['unsigned short']],
} ],
  '__unnamed_2dd2' : [ 0xc, {
    'Msi' : [ 0x0, ['__unnamed_2dd0']],
} ],
  '_INTERRUPT_REMAPPING_INFO' : [ 0x10, {
    'IrtIndex' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 30, native_type='unsigned long')]],
    'FlagHalInternal' : [ 0x0, ['BitField', dict(start_bit = 30, end_bit = 31, native_type='unsigned long')]],
    'FlagTranslated' : [ 0x0, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
    'u' : [ 0x4, ['__unnamed_2dd2']],
} ],
  '_NON_PAGED_DEBUG_INFO' : [ 0x20, {
    'Signature' : [ 0x0, ['unsigned short']],
    'Flags' : [ 0x2, ['unsigned short']],
    'Size' : [ 0x4, ['unsigned long']],
    'Machine' : [ 0x8, ['unsigned short']],
    'Characteristics' : [ 0xa, ['unsigned short']],
    'TimeDateStamp' : [ 0xc, ['unsigned long']],
    'CheckSum' : [ 0x10, ['unsigned long']],
    'SizeOfImage' : [ 0x14, ['unsigned long']],
    'ImageBase' : [ 0x18, ['unsigned long long']],
} ],
  '_ARBITER_ADD_RESERVED_PARAMETERS' : [ 0x8, {
    'ReserveDevice' : [ 0x0, ['pointer64', ['_DEVICE_OBJECT']]],
} ],
  '_MMMOD_WRITER_LISTHEAD' : [ 0x28, {
    'ListHead' : [ 0x0, ['_LIST_ENTRY']],
    'Gate' : [ 0x10, ['_KGATE']],
    'Event' : [ 0x10, ['_KEVENT']],
} ],
  '__unnamed_2ddc' : [ 0x10, {
    'IoStatus' : [ 0x0, ['_IO_STATUS_BLOCK']],
} ],
  '_MMMOD_WRITER_MDL_ENTRY' : [ 0x108, {
    'Links' : [ 0x0, ['_LIST_ENTRY']],
    'u' : [ 0x10, ['__unnamed_2ddc']],
    'Irp' : [ 0x20, ['pointer64', ['_IRP']]],
    'u1' : [ 0x28, ['_MODWRITER_FLAGS']],
    'StoreWriteRefCount' : [ 0x2c, ['unsigned long']],
    'StoreWriteCompletionApc' : [ 0x30, ['_KAPC']],
    'ByteCount' : [ 0x88, ['unsigned long']],
    'ChargedPages' : [ 0x8c, ['unsigned long']],
    'PagingFile' : [ 0x90, ['pointer64', ['_MMPAGING_FILE']]],
    'File' : [ 0x98, ['pointer64', ['_FILE_OBJECT']]],
    'ControlArea' : [ 0xa0, ['pointer64', ['_CONTROL_AREA']]],
    'FileResource' : [ 0xa8, ['pointer64', ['_ERESOURCE']]],
    'WriteOffset' : [ 0xb0, ['_LARGE_INTEGER']],
    'IssueTime' : [ 0xb8, ['_LARGE_INTEGER']],
    'Partition' : [ 0xc0, ['pointer64', ['_MI_PARTITION']]],
    'PointerMdl' : [ 0xc8, ['pointer64', ['_MDL']]],
    'Mdl' : [ 0xd0, ['_MDL']],
    'Page' : [ 0x100, ['array', 1, ['unsigned long long']]],
} ],
  '_NONOPAQUE_OPLOCK' : [ 0xa0, {
    'IrpExclusiveOplock' : [ 0x0, ['pointer64', ['_IRP']]],
    'FileObject' : [ 0x8, ['pointer64', ['_FILE_OBJECT']]],
    'ExclusiveOplockOwner' : [ 0x10, ['pointer64', ['_EPROCESS']]],
    'ExclusiveOplockOwnerThread' : [ 0x18, ['pointer64', ['_ETHREAD']]],
    'WaiterPriority' : [ 0x20, ['unsigned char']],
    'IrpOplocksR' : [ 0x28, ['_LIST_ENTRY']],
    'IrpOplocksRH' : [ 0x38, ['_LIST_ENTRY']],
    'RHBreakQueue' : [ 0x48, ['_LIST_ENTRY']],
    'WaitingIrps' : [ 0x58, ['_LIST_ENTRY']],
    'DelayAckFileObjectQueue' : [ 0x68, ['_LIST_ENTRY']],
    'AtomicQueue' : [ 0x78, ['_LIST_ENTRY']],
    'DeleterParentKey' : [ 0x88, ['pointer64', ['_GUID']]],
    'OplockState' : [ 0x90, ['unsigned long']],
    'FastMutex' : [ 0x98, ['pointer64', ['_FAST_MUTEX']]],
} ],
  '_HAL_HV_SVM_SYSTEM_CAPABILITIES' : [ 0x18, {
    'SvmSupported' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'GpaAlwaysValid' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'MaxPasidSpaceCount' : [ 0x4, ['unsigned long']],
    'MaxPasidSpacePasidCount' : [ 0x8, ['unsigned long']],
    'MaxPrqSize' : [ 0xc, ['unsigned long']],
    'IommuCount' : [ 0x10, ['unsigned long']],
    'MinIommuPasidCount' : [ 0x14, ['unsigned long']],
} ],
  '__unnamed_2de7' : [ 0x10, {
    'UserData' : [ 0x0, ['pointer64', ['void']]],
    'Owner' : [ 0x8, ['pointer64', ['void']]],
} ],
  '__unnamed_2de8' : [ 0x10, {
    'ListHead' : [ 0x0, ['_LIST_ENTRY']],
} ],
  '_RTLP_RANGE_LIST_ENTRY' : [ 0x38, {
    'Start' : [ 0x0, ['unsigned long long']],
    'End' : [ 0x8, ['unsigned long long']],
    'Allocated' : [ 0x10, ['__unnamed_2de7']],
    'Merged' : [ 0x10, ['__unnamed_2de8']],
    'Attributes' : [ 0x20, ['unsigned char']],
    'PublicFlags' : [ 0x21, ['unsigned char']],
    'PrivateFlags' : [ 0x22, ['unsigned short']],
    'ListEntry' : [ 0x28, ['_LIST_ENTRY']],
} ],
  '__unnamed_2dec' : [ 0xc, {
    'Start' : [ 0x0, ['_LARGE_INTEGER']],
    'Length' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_2dee' : [ 0x10, {
    'Level' : [ 0x0, ['unsigned short']],
    'Group' : [ 0x2, ['unsigned short']],
    'Vector' : [ 0x4, ['unsigned long']],
    'Affinity' : [ 0x8, ['unsigned long long']],
} ],
  '__unnamed_2df0' : [ 0x10, {
    'Group' : [ 0x0, ['unsigned short']],
    'MessageCount' : [ 0x2, ['unsigned short']],
    'Vector' : [ 0x4, ['unsigned long']],
    'Affinity' : [ 0x8, ['unsigned long long']],
} ],
  '__unnamed_2df2' : [ 0x10, {
    'Raw' : [ 0x0, ['__unnamed_2df0']],
    'Translated' : [ 0x0, ['__unnamed_2dee']],
} ],
  '__unnamed_2df4' : [ 0xc, {
    'Channel' : [ 0x0, ['unsigned long']],
    'Port' : [ 0x4, ['unsigned long']],
    'Reserved1' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_2df6' : [ 0xc, {
    'Channel' : [ 0x0, ['unsigned long']],
    'RequestLine' : [ 0x4, ['unsigned long']],
    'TransferWidth' : [ 0x8, ['unsigned char']],
    'Reserved1' : [ 0x9, ['unsigned char']],
    'Reserved2' : [ 0xa, ['unsigned char']],
    'Reserved3' : [ 0xb, ['unsigned char']],
} ],
  '__unnamed_2df8' : [ 0xc, {
    'Start' : [ 0x0, ['unsigned long']],
    'Length' : [ 0x4, ['unsigned long']],
    'Reserved' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_2dfa' : [ 0xc, {
    'DataSize' : [ 0x0, ['unsigned long']],
    'Reserved1' : [ 0x4, ['unsigned long']],
    'Reserved2' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_2dfc' : [ 0xc, {
    'Start' : [ 0x0, ['_LARGE_INTEGER']],
    'Length40' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_2dfe' : [ 0xc, {
    'Start' : [ 0x0, ['_LARGE_INTEGER']],
    'Length48' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_2e00' : [ 0xc, {
    'Start' : [ 0x0, ['_LARGE_INTEGER']],
    'Length64' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_2e02' : [ 0x10, {
    'Generic' : [ 0x0, ['__unnamed_2dec']],
    'Port' : [ 0x0, ['__unnamed_2dec']],
    'Interrupt' : [ 0x0, ['__unnamed_2dee']],
    'MessageInterrupt' : [ 0x0, ['__unnamed_2df2']],
    'Memory' : [ 0x0, ['__unnamed_2dec']],
    'Dma' : [ 0x0, ['__unnamed_2df4']],
    'DmaV3' : [ 0x0, ['__unnamed_2df6']],
    'DevicePrivate' : [ 0x0, ['__unnamed_2da5']],
    'BusNumber' : [ 0x0, ['__unnamed_2df8']],
    'DeviceSpecificData' : [ 0x0, ['__unnamed_2dfa']],
    'Memory40' : [ 0x0, ['__unnamed_2dfc']],
    'Memory48' : [ 0x0, ['__unnamed_2dfe']],
    'Memory64' : [ 0x0, ['__unnamed_2e00']],
    'Connection' : [ 0x0, ['__unnamed_2db1']],
} ],
  '_CM_PARTIAL_RESOURCE_DESCRIPTOR' : [ 0x14, {
    'Type' : [ 0x0, ['unsigned char']],
    'ShareDisposition' : [ 0x1, ['unsigned char']],
    'Flags' : [ 0x2, ['unsigned short']],
    'u' : [ 0x4, ['__unnamed_2e02']],
} ],
  '_ARBITER_CONFLICT_INFO' : [ 0x18, {
    'OwningObject' : [ 0x0, ['pointer64', ['_DEVICE_OBJECT']]],
    'Start' : [ 0x8, ['unsigned long long']],
    'End' : [ 0x10, ['unsigned long long']],
} ],
  '_OBJECT_REF_TRACE' : [ 0x80, {
    'StackTrace' : [ 0x0, ['array', 16, ['pointer64', ['void']]]],
} ],
  '_POP_FX_PROVIDER' : [ 0x8, {
    'Index' : [ 0x0, ['unsigned long']],
    'Activating' : [ 0x4, ['unsigned char']],
} ],
  '_ETW_FILTER_EVENT_NAME_DATA' : [ 0x28, {
    'FilterIn' : [ 0x0, ['unsigned char']],
    'Level' : [ 0x1, ['unsigned char']],
    'MatchAnyKeyword' : [ 0x8, ['unsigned long long']],
    'MatchAllKeyword' : [ 0x10, ['unsigned long long']],
    'NameTable' : [ 0x18, ['_RTL_HASH_TABLE']],
} ],
  '_MI_VISIBLE_STATE' : [ 0xc40, {
    'SpecialPool' : [ 0x0, ['_MI_SPECIAL_POOL']],
    'SessionWsList' : [ 0x40, ['_LIST_ENTRY']],
    'SessionIdBitmap' : [ 0x50, ['pointer64', ['_RTL_BITMAP']]],
    'PagedPoolInfo' : [ 0x58, ['_MM_PAGED_POOL_INFO']],
    'MaximumNonPagedPoolInPages' : [ 0x90, ['unsigned long long']],
    'SizeOfPagedPoolInPages' : [ 0x98, ['unsigned long long']],
    'SystemPteInfo' : [ 0xa0, ['_MI_SYSTEM_PTE_TYPE']],
    'NonPagedPoolCommit' : [ 0x100, ['unsigned long long']],
    'SmallNonPagedPtesCommit' : [ 0x108, ['unsigned long long']],
    'BootCommit' : [ 0x110, ['unsigned long long']],
    'MdlPagesAllocated' : [ 0x118, ['unsigned long long']],
    'SystemPageTableCommit' : [ 0x120, ['unsigned long long']],
    'SpecialPagesInUse' : [ 0x128, ['unsigned long long']],
    'ProcessCommit' : [ 0x130, ['unsigned long long']],
    'DriverCommit' : [ 0x138, ['long']],
    'PfnDatabaseCommit' : [ 0x140, ['unsigned long long']],
    'SystemWs' : [ 0x180, ['array', 6, ['_MMSUPPORT_FULL']]],
    'SystemCacheShared' : [ 0x800, ['_MMSUPPORT_SHARED']],
    'AggregateSystemWs' : [ 0x880, ['array', 1, ['_MMSUPPORT_AGGREGATION']]],
    'MapCacheFailures' : [ 0x8a0, ['unsigned long']],
    'PagefileHashPages' : [ 0x8a8, ['unsigned long long']],
    'PteHeader' : [ 0x8b0, ['_SYSPTES_HEADER']],
    'SessionSpecialPool' : [ 0x9c8, ['pointer64', ['_MI_SPECIAL_POOL']]],
    'SystemVaTypeCount' : [ 0x9d0, ['array', 16, ['unsigned long long']]],
    'SystemVaType' : [ 0xa50, ['array', 256, ['unsigned char']]],
    'SystemVaRegions' : [ 0xb50, ['array', 14, ['_MI_SYSTEM_VA_ASSIGNMENT']]],
} ],
  '_WHEA_AER_ENDPOINT_DESCRIPTOR' : [ 0x20, {
    'Type' : [ 0x0, ['unsigned short']],
    'Enabled' : [ 0x2, ['unsigned char']],
    'Reserved' : [ 0x3, ['unsigned char']],
    'BusNumber' : [ 0x4, ['unsigned long']],
    'Slot' : [ 0x8, ['_WHEA_PCI_SLOT_NUMBER']],
    'DeviceControl' : [ 0xc, ['unsigned short']],
    'Flags' : [ 0xe, ['_AER_ENDPOINT_DESCRIPTOR_FLAGS']],
    'UncorrectableErrorMask' : [ 0x10, ['unsigned long']],
    'UncorrectableErrorSeverity' : [ 0x14, ['unsigned long']],
    'CorrectableErrorMask' : [ 0x18, ['unsigned long']],
    'AdvancedCapsAndControl' : [ 0x1c, ['unsigned long']],
} ],
  '_CM_COMPONENT_HASH' : [ 0x4, {
    'Hash' : [ 0x0, ['unsigned long']],
} ],
  '_KSPECIAL_REGISTERS' : [ 0xf0, {
    'Cr0' : [ 0x0, ['unsigned long long']],
    'Cr2' : [ 0x8, ['unsigned long long']],
    'Cr3' : [ 0x10, ['unsigned long long']],
    'Cr4' : [ 0x18, ['unsigned long long']],
    'KernelDr0' : [ 0x20, ['unsigned long long']],
    'KernelDr1' : [ 0x28, ['unsigned long long']],
    'KernelDr2' : [ 0x30, ['unsigned long long']],
    'KernelDr3' : [ 0x38, ['unsigned long long']],
    'KernelDr6' : [ 0x40, ['unsigned long long']],
    'KernelDr7' : [ 0x48, ['unsigned long long']],
    'Gdtr' : [ 0x50, ['_KDESCRIPTOR']],
    'Idtr' : [ 0x60, ['_KDESCRIPTOR']],
    'Tr' : [ 0x70, ['unsigned short']],
    'Ldtr' : [ 0x72, ['unsigned short']],
    'MxCsr' : [ 0x74, ['unsigned long']],
    'DebugControl' : [ 0x78, ['unsigned long long']],
    'LastBranchToRip' : [ 0x80, ['unsigned long long']],
    'LastBranchFromRip' : [ 0x88, ['unsigned long long']],
    'LastExceptionToRip' : [ 0x90, ['unsigned long long']],
    'LastExceptionFromRip' : [ 0x98, ['unsigned long long']],
    'Cr8' : [ 0xa0, ['unsigned long long']],
    'MsrGsBase' : [ 0xa8, ['unsigned long long']],
    'MsrGsSwap' : [ 0xb0, ['unsigned long long']],
    'MsrStar' : [ 0xb8, ['unsigned long long']],
    'MsrLStar' : [ 0xc0, ['unsigned long long']],
    'MsrCStar' : [ 0xc8, ['unsigned long long']],
    'MsrSyscallMask' : [ 0xd0, ['unsigned long long']],
    'Xcr0' : [ 0xd8, ['unsigned long long']],
    'MsrFsBase' : [ 0xe0, ['unsigned long long']],
    'SpecialPadding0' : [ 0xe8, ['unsigned long long']],
} ],
  '_RH_OP_CONTEXT' : [ 0x48, {
    'Links' : [ 0x0, ['_LIST_ENTRY']],
    'OplockRequestIrp' : [ 0x10, ['pointer64', ['_IRP']]],
    'OplockRequestFileObject' : [ 0x18, ['pointer64', ['_FILE_OBJECT']]],
    'OplockRequestProcess' : [ 0x20, ['pointer64', ['_EPROCESS']]],
    'OplockOwnerThread' : [ 0x28, ['pointer64', ['_ETHREAD']]],
    'Flags' : [ 0x30, ['unsigned long']],
    'AtomicLinks' : [ 0x38, ['_LIST_ENTRY']],
} ],
  '_MSUBSECTION' : [ 0x90, {
    'Core' : [ 0x0, ['_SUBSECTION']],
    'SubsectionNode' : [ 0x38, ['_RTL_BALANCED_NODE']],
    'DereferenceList' : [ 0x50, ['_LIST_ENTRY']],
    'NumberOfMappedViews' : [ 0x60, ['unsigned long long']],
    'NumberOfPfnReferences' : [ 0x68, ['unsigned long']],
    'LargeViews' : [ 0x6c, ['unsigned long']],
    'ProtosNode' : [ 0x70, ['_MI_PROTOTYPE_PTES_NODE']],
} ],
  '_PROC_PERF_CHECK' : [ 0x118, {
    'LastActive' : [ 0x0, ['unsigned long long']],
    'LastTime' : [ 0x8, ['unsigned long long']],
    'LastStall' : [ 0x10, ['unsigned long long']],
    'LastPerfCheckSnap' : [ 0x18, ['_PROC_PERF_CHECK_SNAP']],
    'CurrentSnap' : [ 0x68, ['_PROC_PERF_CHECK_SNAP']],
    'LastDeliveredSnap' : [ 0xb8, ['_PROC_PERF_CHECK_SNAP']],
    'LastDeliveredPerformance' : [ 0x108, ['unsigned long']],
    'LastDeliveredFrequency' : [ 0x10c, ['unsigned long']],
    'TaggedThreadPercent' : [ 0x110, ['array', 2, ['unsigned char']]],
    'Class0FloorPerfSelection' : [ 0x112, ['unsigned char']],
    'Class1MinimumPerfSelection' : [ 0x113, ['unsigned char']],
} ],
  '_MI_HARD_FAULT_STATE' : [ 0x10, {
    'SwapPfn' : [ 0x0, ['pointer64', ['_MMPFN']]],
    'StoreFlags' : [ 0x8, ['_MI_STORE_INPAGE_COMPLETE_FLAGS']],
} ],
  '_MODWRITER_FLAGS' : [ 0x4, {
    'KeepForever' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Networked' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'IoPriority' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 5, native_type='unsigned long')]],
    'ModifiedStoreWrite' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
} ],
  '_IMAGE_DATA_DIRECTORY' : [ 0x8, {
    'VirtualAddress' : [ 0x0, ['unsigned long']],
    'Size' : [ 0x4, ['unsigned long']],
} ],
  '_PEB32' : [ 0x470, {
    'InheritedAddressSpace' : [ 0x0, ['unsigned char']],
    'ReadImageFileExecOptions' : [ 0x1, ['unsigned char']],
    'BeingDebugged' : [ 0x2, ['unsigned char']],
    'BitField' : [ 0x3, ['unsigned char']],
    'ImageUsesLargePages' : [ 0x3, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'IsProtectedProcess' : [ 0x3, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'IsImageDynamicallyRelocated' : [ 0x3, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'SkipPatchingUser32Forwarders' : [ 0x3, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'IsPackagedProcess' : [ 0x3, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'IsAppContainer' : [ 0x3, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'IsProtectedProcessLight' : [ 0x3, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned char')]],
    'IsLongPathAwareProcess' : [ 0x3, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
    'Mutant' : [ 0x4, ['unsigned long']],
    'ImageBaseAddress' : [ 0x8, ['unsigned long']],
    'Ldr' : [ 0xc, ['unsigned long']],
    'ProcessParameters' : [ 0x10, ['unsigned long']],
    'SubSystemData' : [ 0x14, ['unsigned long']],
    'ProcessHeap' : [ 0x18, ['unsigned long']],
    'FastPebLock' : [ 0x1c, ['unsigned long']],
    'AtlThunkSListPtr' : [ 0x20, ['unsigned long']],
    'IFEOKey' : [ 0x24, ['unsigned long']],
    'CrossProcessFlags' : [ 0x28, ['unsigned long']],
    'ProcessInJob' : [ 0x28, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'ProcessInitializing' : [ 0x28, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'ProcessUsingVEH' : [ 0x28, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'ProcessUsingVCH' : [ 0x28, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'ProcessUsingFTH' : [ 0x28, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'ProcessPreviouslyThrottled' : [ 0x28, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'ProcessCurrentlyThrottled' : [ 0x28, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'ReservedBits0' : [ 0x28, ['BitField', dict(start_bit = 7, end_bit = 32, native_type='unsigned long')]],
    'KernelCallbackTable' : [ 0x2c, ['unsigned long']],
    'UserSharedInfoPtr' : [ 0x2c, ['unsigned long']],
    'SystemReserved' : [ 0x30, ['unsigned long']],
    'AtlThunkSListPtr32' : [ 0x34, ['unsigned long']],
    'ApiSetMap' : [ 0x38, ['unsigned long']],
    'TlsExpansionCounter' : [ 0x3c, ['unsigned long']],
    'TlsBitmap' : [ 0x40, ['unsigned long']],
    'TlsBitmapBits' : [ 0x44, ['array', 2, ['unsigned long']]],
    'ReadOnlySharedMemoryBase' : [ 0x4c, ['unsigned long']],
    'SharedData' : [ 0x50, ['unsigned long']],
    'ReadOnlyStaticServerData' : [ 0x54, ['unsigned long']],
    'AnsiCodePageData' : [ 0x58, ['unsigned long']],
    'OemCodePageData' : [ 0x5c, ['unsigned long']],
    'UnicodeCaseTableData' : [ 0x60, ['unsigned long']],
    'NumberOfProcessors' : [ 0x64, ['unsigned long']],
    'NtGlobalFlag' : [ 0x68, ['unsigned long']],
    'CriticalSectionTimeout' : [ 0x70, ['_LARGE_INTEGER']],
    'HeapSegmentReserve' : [ 0x78, ['unsigned long']],
    'HeapSegmentCommit' : [ 0x7c, ['unsigned long']],
    'HeapDeCommitTotalFreeThreshold' : [ 0x80, ['unsigned long']],
    'HeapDeCommitFreeBlockThreshold' : [ 0x84, ['unsigned long']],
    'NumberOfHeaps' : [ 0x88, ['unsigned long']],
    'MaximumNumberOfHeaps' : [ 0x8c, ['unsigned long']],
    'ProcessHeaps' : [ 0x90, ['unsigned long']],
    'GdiSharedHandleTable' : [ 0x94, ['unsigned long']],
    'ProcessStarterHelper' : [ 0x98, ['unsigned long']],
    'GdiDCAttributeList' : [ 0x9c, ['unsigned long']],
    'LoaderLock' : [ 0xa0, ['unsigned long']],
    'OSMajorVersion' : [ 0xa4, ['unsigned long']],
    'OSMinorVersion' : [ 0xa8, ['unsigned long']],
    'OSBuildNumber' : [ 0xac, ['unsigned short']],
    'OSCSDVersion' : [ 0xae, ['unsigned short']],
    'OSPlatformId' : [ 0xb0, ['unsigned long']],
    'ImageSubsystem' : [ 0xb4, ['unsigned long']],
    'ImageSubsystemMajorVersion' : [ 0xb8, ['unsigned long']],
    'ImageSubsystemMinorVersion' : [ 0xbc, ['unsigned long']],
    'ActiveProcessAffinityMask' : [ 0xc0, ['unsigned long']],
    'GdiHandleBuffer' : [ 0xc4, ['array', 34, ['unsigned long']]],
    'PostProcessInitRoutine' : [ 0x14c, ['unsigned long']],
    'TlsExpansionBitmap' : [ 0x150, ['unsigned long']],
    'TlsExpansionBitmapBits' : [ 0x154, ['array', 32, ['unsigned long']]],
    'SessionId' : [ 0x1d4, ['unsigned long']],
    'AppCompatFlags' : [ 0x1d8, ['_ULARGE_INTEGER']],
    'AppCompatFlagsUser' : [ 0x1e0, ['_ULARGE_INTEGER']],
    'pShimData' : [ 0x1e8, ['unsigned long']],
    'AppCompatInfo' : [ 0x1ec, ['unsigned long']],
    'CSDVersion' : [ 0x1f0, ['_STRING32']],
    'ActivationContextData' : [ 0x1f8, ['unsigned long']],
    'ProcessAssemblyStorageMap' : [ 0x1fc, ['unsigned long']],
    'SystemDefaultActivationContextData' : [ 0x200, ['unsigned long']],
    'SystemAssemblyStorageMap' : [ 0x204, ['unsigned long']],
    'MinimumStackCommit' : [ 0x208, ['unsigned long']],
    'FlsCallback' : [ 0x20c, ['unsigned long']],
    'FlsListHead' : [ 0x210, ['LIST_ENTRY32']],
    'FlsBitmap' : [ 0x218, ['unsigned long']],
    'FlsBitmapBits' : [ 0x21c, ['array', 4, ['unsigned long']]],
    'FlsHighIndex' : [ 0x22c, ['unsigned long']],
    'WerRegistrationData' : [ 0x230, ['unsigned long']],
    'WerShipAssertPtr' : [ 0x234, ['unsigned long']],
    'pUnused' : [ 0x238, ['unsigned long']],
    'pImageHeaderHash' : [ 0x23c, ['unsigned long']],
    'TracingFlags' : [ 0x240, ['unsigned long']],
    'HeapTracingEnabled' : [ 0x240, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'CritSecTracingEnabled' : [ 0x240, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'LibLoaderTracingEnabled' : [ 0x240, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'SpareTracingBits' : [ 0x240, ['BitField', dict(start_bit = 3, end_bit = 32, native_type='unsigned long')]],
    'CsrServerReadOnlySharedMemoryBase' : [ 0x248, ['unsigned long long']],
    'TppWorkerpListLock' : [ 0x250, ['unsigned long']],
    'TppWorkerpList' : [ 0x254, ['LIST_ENTRY32']],
    'WaitOnAddressHashTable' : [ 0x25c, ['array', 128, ['unsigned long']]],
    'TelemetryCoverageHeader' : [ 0x45c, ['unsigned long']],
    'CloudFileFlags' : [ 0x460, ['unsigned long']],
    'CloudFileDiagFlags' : [ 0x464, ['unsigned long']],
    'PlaceholderCompatibilityMode' : [ 0x468, ['unsigned char']],
    'PlaceholderCompatibilityModeReserved' : [ 0x469, ['array', 7, ['unsigned char']]],
} ],
  '_POP_DEVICE_SYS_STATE' : [ 0x1d8, {
    'IrpMinor' : [ 0x0, ['unsigned char']],
    'SystemState' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {0: u'PowerSystemUnspecified', 1: u'PowerSystemWorking', 2: u'PowerSystemSleeping1', 3: u'PowerSystemSleeping2', 4: u'PowerSystemSleeping3', 5: u'PowerSystemHibernate', 6: u'PowerSystemShutdown', 7: u'PowerSystemMaximum'})]],
    'SpinLock' : [ 0x8, ['unsigned long long']],
    'Thread' : [ 0x10, ['pointer64', ['_KTHREAD']]],
    'AbortEvent' : [ 0x18, ['pointer64', ['_KEVENT']]],
    'ReadySemaphore' : [ 0x20, ['pointer64', ['_KSEMAPHORE']]],
    'FinishedSemaphore' : [ 0x28, ['pointer64', ['_KSEMAPHORE']]],
    'Order' : [ 0x30, ['_PO_DEVICE_NOTIFY_ORDER']],
    'Pending' : [ 0x1b0, ['_LIST_ENTRY']],
    'Status' : [ 0x1c0, ['long']],
    'FailedDevice' : [ 0x1c8, ['pointer64', ['_DEVICE_OBJECT']]],
    'Waking' : [ 0x1d0, ['unsigned char']],
    'Cancelled' : [ 0x1d1, ['unsigned char']],
    'IgnoreErrors' : [ 0x1d2, ['unsigned char']],
    'IgnoreNotImplemented' : [ 0x1d3, ['unsigned char']],
    'TimeRefreshLockAcquired' : [ 0x1d4, ['unsigned char']],
} ],
  '_THERMAL_INFORMATION' : [ 0x58, {
    'ThermalStamp' : [ 0x0, ['unsigned long']],
    'ThermalConstant1' : [ 0x4, ['unsigned long']],
    'ThermalConstant2' : [ 0x8, ['unsigned long']],
    'Processors' : [ 0x10, ['unsigned long long']],
    'SamplingPeriod' : [ 0x18, ['unsigned long']],
    'CurrentTemperature' : [ 0x1c, ['unsigned long']],
    'PassiveTripPoint' : [ 0x20, ['unsigned long']],
    'CriticalTripPoint' : [ 0x24, ['unsigned long']],
    'ActiveTripPointCount' : [ 0x28, ['unsigned char']],
    'ActiveTripPoint' : [ 0x2c, ['array', 10, ['unsigned long']]],
} ],
  '_XSTATE_FEATURE' : [ 0x8, {
    'Offset' : [ 0x0, ['unsigned long']],
    'Size' : [ 0x4, ['unsigned long']],
} ],
  '_HIVE_LIST_ENTRY' : [ 0x98, {
    'FileName' : [ 0x0, ['pointer64', ['wchar']]],
    'BaseName' : [ 0x8, ['pointer64', ['wchar']]],
    'RegRootName' : [ 0x10, ['pointer64', ['wchar']]],
    'CmHive' : [ 0x18, ['pointer64', ['_CMHIVE']]],
    'HHiveFlags' : [ 0x20, ['unsigned long']],
    'CmHiveFlags' : [ 0x24, ['unsigned long']],
    'CmKcbCacheSize' : [ 0x28, ['unsigned long']],
    'CmHive2' : [ 0x30, ['pointer64', ['_CMHIVE']]],
    'HiveMounted' : [ 0x38, ['unsigned char']],
    'ThreadFinished' : [ 0x39, ['unsigned char']],
    'ThreadStarted' : [ 0x3a, ['unsigned char']],
    'Allocate' : [ 0x3b, ['unsigned char']],
    'WinPERequired' : [ 0x3c, ['unsigned char']],
    'StartEvent' : [ 0x40, ['_KEVENT']],
    'FinishedEvent' : [ 0x58, ['_KEVENT']],
    'MountLock' : [ 0x70, ['_KEVENT']],
    'FilePath' : [ 0x88, ['_UNICODE_STRING']],
} ],
  '_PO_DEVICE_NOTIFY_ORDER' : [ 0x180, {
    'Locked' : [ 0x0, ['unsigned char']],
    'WarmEjectPdoPointer' : [ 0x8, ['pointer64', ['pointer64', ['_DEVICE_OBJECT']]]],
    'OrderLevel' : [ 0x10, ['array', 5, ['_PO_NOTIFY_ORDER_LEVEL']]],
    'Flags' : [ 0x178, ['unsigned long']],
} ],
  '_PPM_VETO_ENTRY' : [ 0x40, {
    'Link' : [ 0x0, ['_LIST_ENTRY']],
    'VetoReason' : [ 0x10, ['unsigned long']],
    'ReferenceCount' : [ 0x14, ['unsigned long']],
    'HitCount' : [ 0x18, ['unsigned long long']],
    'LastActivationTime' : [ 0x20, ['unsigned long long']],
    'TotalActiveTime' : [ 0x28, ['unsigned long long']],
    'CsActivationTime' : [ 0x30, ['unsigned long long']],
    'CsActiveTime' : [ 0x38, ['unsigned long long']],
} ],
  '_ARBITER_TEST_ALLOCATION_PARAMETERS' : [ 0x18, {
    'ArbitrationList' : [ 0x0, ['pointer64', ['_LIST_ENTRY']]],
    'AllocateFromCount' : [ 0x8, ['unsigned long']],
    'AllocateFrom' : [ 0x10, ['pointer64', ['_CM_PARTIAL_RESOURCE_DESCRIPTOR']]],
} ],
  '_MI_BAD_MEMORY_EVENT_ENTRY' : [ 0x38, {
    'BugCheckCode' : [ 0x0, ['unsigned long']],
    'Active' : [ 0x4, ['long']],
    'Data' : [ 0x8, ['unsigned long']],
    'PhysicalAddress' : [ 0x10, ['_LARGE_INTEGER']],
    'WorkItem' : [ 0x18, ['_WORK_QUEUE_ITEM']],
} ],
  '_HAL_CLOCK_TIMER_CONFIGURATION' : [ 0x20, {
    'Flags' : [ 0x0, ['unsigned char']],
    'AlwaysOnTimer' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'HighLatency' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'PerCpuTimer' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'DynamicTickSupported' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'KnownType' : [ 0x4, ['unsigned long']],
    'Capabilities' : [ 0x8, ['unsigned long']],
    'MaxIncrement' : [ 0x10, ['unsigned long long']],
    'MinIncrement' : [ 0x18, ['unsigned long']],
} ],
  '_ETW_DEBUGID_TRACKING_ENTRY' : [ 0x38, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'ConsumersNotified' : [ 0x10, ['unsigned char']],
    'Spare' : [ 0x11, ['array', 3, ['unsigned char']]],
    'DebugIdSize' : [ 0x14, ['unsigned long']],
    'DebugId' : [ 0x18, ['_CVDD']],
} ],
  '_KWAIT_CHAIN_ENTRY' : [ 0x28, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'Event' : [ 0x10, ['_KEVENT']],
} ],
  '_PROC_IDLE_SNAP' : [ 0x10, {
    'Time' : [ 0x0, ['unsigned long long']],
    'Idle' : [ 0x8, ['unsigned long long']],
} ],
  '_TOKEN_PRIVILEGES' : [ 0x10, {
    'PrivilegeCount' : [ 0x0, ['unsigned long']],
    'Privileges' : [ 0x4, ['array', 1, ['_LUID_AND_ATTRIBUTES']]],
} ],
  '_WHEA_NOTIFICATION_FLAGS' : [ 0x2, {
    'PollIntervalRW' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
    'SwitchToPollingThresholdRW' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned short')]],
    'SwitchToPollingWindowRW' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned short')]],
    'ErrorThresholdRW' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned short')]],
    'ErrorThresholdWindowRW' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned short')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 16, native_type='unsigned short')]],
    'AsUSHORT' : [ 0x0, ['unsigned short']],
} ],
  '_IMAGE_DEBUG_DIRECTORY' : [ 0x1c, {
    'Characteristics' : [ 0x0, ['unsigned long']],
    'TimeDateStamp' : [ 0x4, ['unsigned long']],
    'MajorVersion' : [ 0x8, ['unsigned short']],
    'MinorVersion' : [ 0xa, ['unsigned short']],
    'Type' : [ 0xc, ['unsigned long']],
    'SizeOfData' : [ 0x10, ['unsigned long']],
    'AddressOfRawData' : [ 0x14, ['unsigned long']],
    'PointerToRawData' : [ 0x18, ['unsigned long']],
} ],
  '_CONFIGURATION_COMPONENT_DATA' : [ 0x48, {
    'Parent' : [ 0x0, ['pointer64', ['_CONFIGURATION_COMPONENT_DATA']]],
    'Child' : [ 0x8, ['pointer64', ['_CONFIGURATION_COMPONENT_DATA']]],
    'Sibling' : [ 0x10, ['pointer64', ['_CONFIGURATION_COMPONENT_DATA']]],
    'ComponentEntry' : [ 0x18, ['_CONFIGURATION_COMPONENT']],
    'ConfigurationData' : [ 0x40, ['pointer64', ['void']]],
} ],
  '_SEP_LOWBOX_NUMBER_MAPPING' : [ 0x28, {
    'Lock' : [ 0x0, ['_EX_PUSH_LOCK']],
    'Bitmap' : [ 0x8, ['_RTL_BITMAP']],
    'HashTable' : [ 0x18, ['pointer64', ['_RTL_DYNAMIC_HASH_TABLE']]],
    'Active' : [ 0x20, ['unsigned char']],
} ],
  '_MMDEREFERENCE_SEGMENT_HEADER' : [ 0x50, {
    'Semaphore' : [ 0x0, ['_KSEMAPHORE']],
    'ControlAreaDeleteListHead' : [ 0x20, ['_LIST_ENTRY']],
    'UnusedSegmentDeleteListHead' : [ 0x30, ['_LIST_ENTRY']],
    'PagefileExtensionListHead' : [ 0x40, ['_LIST_ENTRY']],
} ],
  '_OBJECT_HEADER_PADDING_INFO' : [ 0x4, {
    'PaddingAmount' : [ 0x0, ['unsigned long']],
} ],
  '_KQUEUE' : [ 0x40, {
    'Header' : [ 0x0, ['_DISPATCHER_HEADER']],
    'EntryListHead' : [ 0x18, ['_LIST_ENTRY']],
    'CurrentCount' : [ 0x28, ['unsigned long']],
    'MaximumCount' : [ 0x2c, ['unsigned long']],
    'ThreadListHead' : [ 0x30, ['_LIST_ENTRY']],
} ],
  '__unnamed_2e6d' : [ 0x4, {
    'ChannelsHotCold' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Spare' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 32, native_type='unsigned long')]],
} ],
  '_MI_NODE_INFORMATION' : [ 0x7c0, {
    'FreeLargePages' : [ 0x0, ['array', 3, ['_MI_FREE_LARGE_PAGES']]],
    'LargePageRebuildTimer' : [ 0x330, ['_MI_REBUILD_LARGE_PAGE_TIMER']],
    'StandbyPageList' : [ 0x358, ['array', 4, ['array', 8, ['_MMPFNLIST_SHORT']]]],
    'FreePageListHeadsBitmap' : [ 0x680, ['array', 2, ['_RTL_BITMAP']]],
    'FreePageListHeadsBitmapBuffer' : [ 0x6a0, ['array', 16, ['unsigned long']]],
    'FreeCount' : [ 0x6e0, ['array', 2, ['unsigned long long']]],
    'TotalPages' : [ 0x6f0, ['array', 4, ['unsigned long long']]],
    'TotalPagesEntireNode' : [ 0x710, ['unsigned long long']],
    'MmShiftedColor' : [ 0x718, ['unsigned long']],
    'Color' : [ 0x71c, ['unsigned long']],
    'ChannelFreeCount' : [ 0x720, ['array', 4, ['array', 2, ['unsigned long long']]]],
    'Flags' : [ 0x760, ['__unnamed_2e6d']],
    'NodeLock' : [ 0x768, ['_EX_PUSH_LOCK']],
    'ZeroThreadHugeMapLock' : [ 0x770, ['unsigned long long']],
    'LargeListMoveInProgress' : [ 0x778, ['unsigned char']],
    'ChannelStatus' : [ 0x779, ['unsigned char']],
    'ChannelOrdering' : [ 0x77a, ['array', 4, ['unsigned char']]],
    'LockedChannelOrdering' : [ 0x77e, ['array', 4, ['unsigned char']]],
    'PowerAttribute' : [ 0x782, ['array', 4, ['unsigned char']]],
    'LargePageLock' : [ 0x788, ['unsigned long long']],
    'PageColorTable' : [ 0x790, ['_MI_PAGE_COLORS']],
} ],
  '_PROC_PERF_LOAD' : [ 0x2, {
    'BusyPercentage' : [ 0x0, ['unsigned char']],
    'FrequencyPercentage' : [ 0x1, ['unsigned char']],
} ],
  '_WHEA_PROCESSOR_GENERIC_ERROR_SECTION' : [ 0xc0, {
    'ValidBits' : [ 0x0, ['_WHEA_PROCESSOR_GENERIC_ERROR_SECTION_VALIDBITS']],
    'ProcessorType' : [ 0x8, ['unsigned char']],
    'InstructionSet' : [ 0x9, ['unsigned char']],
    'ErrorType' : [ 0xa, ['unsigned char']],
    'Operation' : [ 0xb, ['unsigned char']],
    'Flags' : [ 0xc, ['unsigned char']],
    'Level' : [ 0xd, ['unsigned char']],
    'Reserved' : [ 0xe, ['unsigned short']],
    'CPUVersion' : [ 0x10, ['unsigned long long']],
    'CPUBrandString' : [ 0x18, ['array', 128, ['unsigned char']]],
    'ProcessorId' : [ 0x98, ['unsigned long long']],
    'TargetAddress' : [ 0xa0, ['unsigned long long']],
    'RequesterId' : [ 0xa8, ['unsigned long long']],
    'ResponderId' : [ 0xb0, ['unsigned long long']],
    'InstructionPointer' : [ 0xb8, ['unsigned long long']],
} ],
  '_MI_HYPER_SPACE' : [ 0x10804000, {
    'VadBitmap' : [ 0x0, ['array', 268435456, ['unsigned char']]],
    'PageDirectoryCommitmentBitmap' : [ 0x10000000, ['array', 16384, ['unsigned char']]],
    'PageTableCommitmentBitmap' : [ 0x10004000, ['array', 8388608, ['unsigned char']]],
} ],
  '_TRIAGE_POP_FX_DEVICE' : [ 0x38, {
    'Link' : [ 0x0, ['_LIST_ENTRY']],
    'Irp' : [ 0x10, ['pointer64', ['_IRP']]],
    'IrpData' : [ 0x18, ['pointer64', ['_TRIAGE_POP_IRP_DATA']]],
    'Status' : [ 0x20, ['long']],
    'PowerReqCall' : [ 0x24, ['long']],
    'PowerNotReqCall' : [ 0x28, ['long']],
    'DeviceNode' : [ 0x30, ['pointer64', ['_TRIAGE_DEVICE_NODE']]],
} ],
  '_KENLISTMENT_HISTORY' : [ 0x8, {
    'Notification' : [ 0x0, ['unsigned long']],
    'NewState' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {0: u'KEnlistmentUninitialized', 256: u'KEnlistmentActive', 258: u'KEnlistmentPrepared', 259: u'KEnlistmentInDoubt', 260: u'KEnlistmentCommitted', 261: u'KEnlistmentCommittedNotify', 262: u'KEnlistmentCommitRequested', 257: u'KEnlistmentPreparing', 264: u'KEnlistmentDelegated', 265: u'KEnlistmentDelegatedDisconnected', 266: u'KEnlistmentPrePreparing', 263: u'KEnlistmentAborted', 268: u'KEnlistmentRecovering', 269: u'KEnlistmentAborting', 270: u'KEnlistmentReadOnly', 271: u'KEnlistmentOutcomeUnavailable', 272: u'KEnlistmentOffline', 273: u'KEnlistmentPrePrepared', 274: u'KEnlistmentInitialized', 267: u'KEnlistmentForgotten'})]],
} ],
  '_LPCP_PORT_QUEUE' : [ 0x20, {
    'NonPagedPortQueue' : [ 0x0, ['pointer64', ['_LPCP_NONPAGED_PORT_QUEUE']]],
    'Semaphore' : [ 0x8, ['pointer64', ['_KSEMAPHORE']]],
    'ReceiveHead' : [ 0x10, ['_LIST_ENTRY']],
} ],
  '_PF_KERNEL_GLOBALS' : [ 0x60, {
    'AccessBufferAgeThreshold' : [ 0x0, ['unsigned long long']],
    'AccessBufferRef' : [ 0x8, ['_EX_RUNDOWN_REF']],
    'AccessBufferExistsEvent' : [ 0x10, ['_KEVENT']],
    'AccessBufferMax' : [ 0x28, ['unsigned long']],
    'AccessBufferList' : [ 0x40, ['_SLIST_HEADER']],
    'StreamSequenceNumber' : [ 0x50, ['long']],
    'Flags' : [ 0x54, ['unsigned long']],
    'ScenarioPrefetchCount' : [ 0x58, ['long']],
} ],
  '_DOMAIN_CONFIGURATION_ARM64' : [ 0x20, {
    'Ttbr0' : [ 0x0, ['_LARGE_INTEGER']],
    'Ttbr1' : [ 0x8, ['_LARGE_INTEGER']],
    'Mair0' : [ 0x10, ['unsigned long']],
    'Mair1' : [ 0x14, ['unsigned long']],
    'InputSize0' : [ 0x18, ['unsigned char']],
    'InputSize1' : [ 0x19, ['unsigned char']],
} ],
  '_CALL_HASH_ENTRY' : [ 0x28, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'CallersAddress' : [ 0x10, ['pointer64', ['void']]],
    'CallersCaller' : [ 0x18, ['pointer64', ['void']]],
    'CallCount' : [ 0x20, ['unsigned long']],
} ],
  '_RTL_ACTIVATION_CONTEXT_STACK_FRAME' : [ 0x18, {
    'Previous' : [ 0x0, ['pointer64', ['_RTL_ACTIVATION_CONTEXT_STACK_FRAME']]],
    'ActivationContext' : [ 0x8, ['pointer64', ['_ACTIVATION_CONTEXT']]],
    'Flags' : [ 0x10, ['unsigned long']],
} ],
  '_DIAGNOSTIC_CONTEXT' : [ 0x20, {
    'CallerType' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: u'KernelRequester', 1: u'UserProcessRequester', 2: u'UserSharedServiceRequester'})]],
    'Process' : [ 0x8, ['pointer64', ['_EPROCESS']]],
    'ServiceTag' : [ 0x10, ['unsigned long']],
    'DeviceObject' : [ 0x8, ['pointer64', ['_DEVICE_OBJECT']]],
    'ReasonSize' : [ 0x18, ['unsigned long long']],
} ],
  '_MI_SYSTEM_NODE_INFORMATION' : [ 0x190, {
    'PagedPoolSListHead' : [ 0x0, ['_SLIST_HEADER']],
    'NonPagedPoolSListHead' : [ 0x10, ['array', 3, ['_SLIST_HEADER']]],
    'NonPagedPoolSListHeadNx' : [ 0x40, ['array', 3, ['_SLIST_HEADER']]],
    'CachedKernelStacks' : [ 0x70, ['array', 2, ['_CACHED_KSTACK_LIST']]],
    'NonPagedBitMapMaximum' : [ 0xb0, ['unsigned long long']],
    'DynamicBitMapNonPagedPool' : [ 0xb8, ['_MI_DYNAMIC_BITMAP']],
    'NonPagedPoolLowestPage' : [ 0x100, ['unsigned long long']],
    'NonPagedPoolHighestPage' : [ 0x108, ['unsigned long long']],
    'AllocatedNonPagedPool' : [ 0x110, ['unsigned long long']],
    'PartialLargePoolRegions' : [ 0x118, ['unsigned long long']],
    'PagesInPartialLargePoolRegions' : [ 0x120, ['unsigned long long']],
    'CachedNonPagedPoolCount' : [ 0x128, ['unsigned long long']],
    'NonPagedPoolSpinLock' : [ 0x130, ['unsigned long long']],
    'CachedNonPagedPool' : [ 0x138, ['pointer64', ['_MMPFN']]],
    'NonPagedPoolFirstVa' : [ 0x140, ['pointer64', ['void']]],
    'NonPagedPoolLastVa' : [ 0x148, ['pointer64', ['void']]],
    'NonPagedBitMap' : [ 0x150, ['array', 3, ['_RTL_BITMAP_EX']]],
    'NonPagedHint' : [ 0x180, ['array', 2, ['unsigned long long']]],
} ],
  '_PROC_PERF_QOS_CLASS_POLICY' : [ 0x1c, {
    'MaxPolicyPercent' : [ 0x0, ['unsigned long']],
    'MaxEquivalentFrequencyPercent' : [ 0x4, ['unsigned long']],
    'MinPolicyPercent' : [ 0x8, ['unsigned long']],
    'AutonomousActivityWindow' : [ 0xc, ['unsigned long']],
    'EnergyPerfPreference' : [ 0x10, ['unsigned long']],
    'ProvideGuidance' : [ 0x14, ['unsigned char']],
    'AllowThrottling' : [ 0x15, ['unsigned char']],
    'PerfBoostMode' : [ 0x16, ['unsigned char']],
    'LatencyHintPerf' : [ 0x17, ['unsigned char']],
    'TrackDesiredCrossClass' : [ 0x18, ['unsigned char']],
} ],
  '_MI_TRIAGE_DUMP_DATA' : [ 0x38, {
    'BadPageCount' : [ 0x0, ['unsigned long long']],
    'BadPagesDetected' : [ 0x8, ['long']],
    'ZeroedPageSingleBitErrorsDetected' : [ 0xc, ['long']],
    'ScrubPasses' : [ 0x10, ['long']],
    'ScrubBadPagesFound' : [ 0x14, ['long']],
    'PageHashErrors' : [ 0x18, ['unsigned long']],
    'FeatureBits' : [ 0x20, ['unsigned long long']],
    'TimeZoneId' : [ 0x28, ['unsigned long']],
    'Flags' : [ 0x2c, ['_MI_FLAGS']],
    'VsmConnection' : [ 0x30, ['pointer64', ['void']]],
} ],
  '_MI_FORCED_COMMITS' : [ 0x8, {
    'Regular' : [ 0x0, ['unsigned long']],
    'Wrap' : [ 0x4, ['unsigned long']],
} ],
  '_VF_TARGET_ALL_SHARED_EXPORT_THUNKS' : [ 0x20, {
    'SharedExportThunks' : [ 0x0, ['pointer64', ['_VERIFIER_SHARED_EXPORT_THUNK']]],
    'PoolSharedExportThunks' : [ 0x8, ['pointer64', ['_VERIFIER_SHARED_EXPORT_THUNK']]],
    'OrderDependentSharedExportThunks' : [ 0x10, ['pointer64', ['_VERIFIER_SHARED_EXPORT_THUNK']]],
    'XdvSharedExportThunks' : [ 0x18, ['pointer64', ['_VERIFIER_SHARED_EXPORT_THUNK']]],
} ],
  '_PERF_CONTROL_STATE_SELECTION' : [ 0x28, {
    'SelectedState' : [ 0x0, ['unsigned long long']],
    'SelectedPercent' : [ 0x8, ['unsigned long']],
    'SelectedFrequency' : [ 0xc, ['unsigned long']],
    'MinPercent' : [ 0x10, ['unsigned long']],
    'MaxPercent' : [ 0x14, ['unsigned long']],
    'TolerancePercent' : [ 0x18, ['unsigned long']],
    'EppPercent' : [ 0x1c, ['unsigned long']],
    'AutonomousActivityWindow' : [ 0x20, ['unsigned long']],
    'Autonomous' : [ 0x24, ['unsigned char']],
    'InheritFromDomain' : [ 0x25, ['unsigned char']],
} ],
  '_MI_REBUILD_LARGE_PAGE_TIMER' : [ 0x28, {
    'WorkItem' : [ 0x0, ['_WORK_QUEUE_ITEM']],
    'SecondsLeft' : [ 0x20, ['unsigned char']],
    'RebuildActive' : [ 0x21, ['unsigned char']],
    'NextPassDelta' : [ 0x22, ['unsigned char']],
    'LargeSubPagesActive' : [ 0x23, ['unsigned char']],
} ],
  '_MI_IO_PAGE_STATE' : [ 0x68, {
    'IoPfnLock' : [ 0x0, ['long']],
    'IoPfnRoot' : [ 0x8, ['array', 3, ['_RTL_AVL_TREE']]],
    'UnusedCachedMaps' : [ 0x20, ['_LIST_ENTRY']],
    'OldestCacheFlushTimeStamp' : [ 0x30, ['unsigned long']],
    'IoCacheStats' : [ 0x38, ['_MI_IO_CACHE_STATS']],
    'InvariantIoSpace' : [ 0x60, ['_RTL_AVL_TREE']],
} ],
  '_ETW_REPLY_QUEUE' : [ 0x48, {
    'Queue' : [ 0x0, ['_KQUEUE']],
    'EventsLost' : [ 0x40, ['long']],
} ],
  '_LOADER_PARAMETER_EXTENSION' : [ 0xc40, {
    'Size' : [ 0x0, ['unsigned long']],
    'Profile' : [ 0x4, ['_PROFILE_PARAMETER_BLOCK']],
    'EmInfFileImage' : [ 0x18, ['pointer64', ['void']]],
    'EmInfFileSize' : [ 0x20, ['unsigned long']],
    'TriageDumpBlock' : [ 0x28, ['pointer64', ['void']]],
    'HeadlessLoaderBlock' : [ 0x30, ['pointer64', ['_HEADLESS_LOADER_BLOCK']]],
    'SMBiosEPSHeader' : [ 0x38, ['pointer64', ['_SMBIOS3_TABLE_HEADER']]],
    'DrvDBImage' : [ 0x40, ['pointer64', ['void']]],
    'DrvDBSize' : [ 0x48, ['unsigned long']],
    'NetworkLoaderBlock' : [ 0x50, ['pointer64', ['_NETWORK_LOADER_BLOCK']]],
    'FirmwareDescriptorListHead' : [ 0x58, ['_LIST_ENTRY']],
    'AcpiTable' : [ 0x68, ['pointer64', ['void']]],
    'AcpiTableSize' : [ 0x70, ['unsigned long']],
    'LastBootSucceeded' : [ 0x74, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'LastBootShutdown' : [ 0x74, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'IoPortAccessSupported' : [ 0x74, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'BootDebuggerActive' : [ 0x74, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'StrongCodeGuarantees' : [ 0x74, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'HardStrongCodeGuarantees' : [ 0x74, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'SidSharingDisabled' : [ 0x74, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'TpmInitialized' : [ 0x74, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'VsmConfigured' : [ 0x74, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'IumEnabled' : [ 0x74, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'IsSmbboot' : [ 0x74, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'BootLogEnabled' : [ 0x74, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'FeatureSettings' : [ 0x74, ['BitField', dict(start_bit = 12, end_bit = 19, native_type='unsigned long')]],
    'FeatureSimulations' : [ 0x74, ['BitField', dict(start_bit = 19, end_bit = 25, native_type='unsigned long')]],
    'MicrocodeOptedOut' : [ 0x74, ['BitField', dict(start_bit = 25, end_bit = 26, native_type='unsigned long')]],
    'XhciLegacyHandoffSkip' : [ 0x74, ['BitField', dict(start_bit = 26, end_bit = 27, native_type='unsigned long')]],
    'Reserved' : [ 0x74, ['BitField', dict(start_bit = 27, end_bit = 32, native_type='unsigned long')]],
    'LoaderPerformanceData' : [ 0x78, ['pointer64', ['_LOADER_PERFORMANCE_DATA']]],
    'BootApplicationPersistentData' : [ 0x80, ['_LIST_ENTRY']],
    'WmdTestResult' : [ 0x90, ['pointer64', ['void']]],
    'BootIdentifier' : [ 0x98, ['_GUID']],
    'ResumePages' : [ 0xa8, ['unsigned long']],
    'DumpHeader' : [ 0xb0, ['pointer64', ['void']]],
    'BgContext' : [ 0xb8, ['pointer64', ['void']]],
    'NumaLocalityInfo' : [ 0xc0, ['pointer64', ['void']]],
    'NumaGroupAssignment' : [ 0xc8, ['pointer64', ['void']]],
    'AttachedHives' : [ 0xd0, ['_LIST_ENTRY']],
    'MemoryCachingRequirementsCount' : [ 0xe0, ['unsigned long']],
    'MemoryCachingRequirements' : [ 0xe8, ['pointer64', ['void']]],
    'BootEntropyResult' : [ 0xf0, ['_BOOT_ENTROPY_LDR_RESULT']],
    'ProcessorCounterFrequency' : [ 0x888, ['unsigned long long']],
    'HypervisorExtension' : [ 0x890, ['_LOADER_PARAMETER_HYPERVISOR_EXTENSION']],
    'HardwareConfigurationId' : [ 0x8c8, ['_GUID']],
    'HalExtensionModuleList' : [ 0x8d8, ['_LIST_ENTRY']],
    'SystemTime' : [ 0x8e8, ['_LARGE_INTEGER']],
    'TimeStampAtSystemTimeRead' : [ 0x8f0, ['unsigned long long']],
    'BootFlags' : [ 0x8f8, ['unsigned long long']],
    'DbgMenuOsSelection' : [ 0x8f8, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'DbgHiberBoot' : [ 0x8f8, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long long')]],
    'DbgSoftRestart' : [ 0x8f8, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long long')]],
    'InternalBootFlags' : [ 0x900, ['unsigned long long']],
    'DbgUtcBootTime' : [ 0x900, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'DbgRtcBootTime' : [ 0x900, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long long')]],
    'DbgNoLegacyServices' : [ 0x900, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long long')]],
    'WfsFPData' : [ 0x908, ['pointer64', ['void']]],
    'WfsFPDataSize' : [ 0x910, ['unsigned long']],
    'BugcheckParameters' : [ 0x918, ['_LOADER_BUGCHECK_PARAMETERS']],
    'ApiSetSchema' : [ 0x940, ['pointer64', ['void']]],
    'ApiSetSchemaSize' : [ 0x948, ['unsigned long']],
    'ApiSetSchemaExtensions' : [ 0x950, ['_LIST_ENTRY']],
    'AcpiBiosVersion' : [ 0x960, ['_UNICODE_STRING']],
    'SmbiosVersion' : [ 0x970, ['_UNICODE_STRING']],
    'EfiVersion' : [ 0x980, ['_UNICODE_STRING']],
    'KdDebugDevice' : [ 0x990, ['pointer64', ['_DEBUG_DEVICE_DESCRIPTOR']]],
    'OfflineCrashdumpConfigurationTable' : [ 0x998, ['_OFFLINE_CRASHDUMP_CONFIGURATION_TABLE_V2']],
    'ManufacturingProfile' : [ 0x9b8, ['_UNICODE_STRING']],
    'BbtBuffer' : [ 0x9c8, ['pointer64', ['void']]],
    'XsaveAllowedFeatures' : [ 0x9d0, ['unsigned long long']],
    'XsaveFlags' : [ 0x9d8, ['unsigned long']],
    'BootOptions' : [ 0x9e0, ['pointer64', ['void']]],
    'IumEnablement' : [ 0x9e8, ['unsigned long']],
    'IumPolicy' : [ 0x9ec, ['unsigned long']],
    'IumStatus' : [ 0x9f0, ['long']],
    'BootId' : [ 0x9f4, ['unsigned long']],
    'CodeIntegrityData' : [ 0x9f8, ['pointer64', ['_LOADER_PARAMETER_CI_EXTENSION']]],
    'CodeIntegrityDataSize' : [ 0xa00, ['unsigned long']],
    'SystemHiveRecoveryInfo' : [ 0xa04, ['_LOADER_HIVE_RECOVERY_INFO']],
    'SoftRestartCount' : [ 0xa18, ['unsigned long']],
    'SoftRestartTime' : [ 0xa20, ['long long']],
    'HypercallCodeVa' : [ 0xa28, ['pointer64', ['void']]],
    'HalVirtualAddress' : [ 0xa30, ['pointer64', ['void']]],
    'HalNumberOfBytes' : [ 0xa38, ['unsigned long long']],
    'MajorRelease' : [ 0xa40, ['unsigned long']],
    'Reserved1' : [ 0xa44, ['unsigned long']],
    'NtBuildLab' : [ 0xa48, ['array', 224, ['unsigned char']]],
    'NtBuildLabEx' : [ 0xb28, ['array', 224, ['unsigned char']]],
    'ResetReason' : [ 0xc08, ['_LOADER_RESET_REASON']],
    'MaxPciBusNumber' : [ 0xc38, ['unsigned long']],
} ],
  '_NLS_DATA_BLOCK' : [ 0x18, {
    'AnsiCodePageData' : [ 0x0, ['pointer64', ['void']]],
    'OemCodePageData' : [ 0x8, ['pointer64', ['void']]],
    'UnicodeCaseTableData' : [ 0x10, ['pointer64', ['void']]],
} ],
  '_CM_BIG_DATA' : [ 0x8, {
    'Signature' : [ 0x0, ['unsigned short']],
    'Count' : [ 0x2, ['unsigned short']],
    'List' : [ 0x4, ['unsigned long']],
} ],
  '_MI_CROSS_PARTITION_CHARGES' : [ 0x20, {
    'CurrentCharges' : [ 0x0, ['unsigned long long']],
    'ChargeFailures' : [ 0x8, ['unsigned long long']],
    'ChargePeak' : [ 0x10, ['unsigned long long']],
    'ChargeMinimum' : [ 0x18, ['unsigned long long']],
} ],
  '__unnamed_2ecb' : [ 0x4, {
    'ReferenceCount' : [ 0x0, ['unsigned long']],
    'NumberOfPtesToFree' : [ 0x0, ['unsigned long']],
} ],
  '_MI_PER_SESSION_PROTOS' : [ 0x58, {
    'SessionProtoNode' : [ 0x0, ['_RTL_BALANCED_NODE']],
    'FreeList' : [ 0x0, ['_SINGLE_LIST_ENTRY']],
    'DriverAddress' : [ 0x0, ['pointer64', ['void']]],
    'ProtosNode' : [ 0x18, ['_MI_PROTOTYPE_PTES_NODE']],
    'NumberOfPtes' : [ 0x38, ['unsigned long long']],
    'SessionId' : [ 0x40, ['unsigned long']],
    'Subsection' : [ 0x40, ['pointer64', ['_SUBSECTION']]],
    'SubsectionBase' : [ 0x48, ['pointer64', ['_MMPTE']]],
    'u2' : [ 0x50, ['__unnamed_2ecb']],
} ],
  '_TOKEN_MANDATORY_POLICY' : [ 0x4, {
    'Policy' : [ 0x0, ['unsigned long']],
} ],
  '_MI_MODWRITE_DATA' : [ 0x40, {
    'PagesLoad' : [ 0x0, ['long long']],
    'PagesAverage' : [ 0x8, ['unsigned long long']],
    'AverageAvailablePages' : [ 0x10, ['unsigned long long']],
    'PagesWritten' : [ 0x18, ['unsigned long long']],
    'WritesIssued' : [ 0x20, ['unsigned long']],
    'IgnoredReservationsCount' : [ 0x24, ['unsigned long']],
    'FreedReservationsCount' : [ 0x28, ['unsigned long']],
    'WriteBurstCount' : [ 0x2c, ['unsigned long']],
    'IgnoreReservationsStartTime' : [ 0x30, ['unsigned long long']],
    'ReservationClusterInfo' : [ 0x38, ['_MI_RESERVATION_CLUSTER_INFO']],
    'IgnoreReservations' : [ 0x3c, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
    'Spare' : [ 0x3c, ['BitField', dict(start_bit = 1, end_bit = 16, native_type='unsigned short')]],
    'Spare1' : [ 0x3e, ['unsigned short']],
} ],
  '_PROC_IDLE_POLICY' : [ 0x6, {
    'PromotePercent' : [ 0x0, ['unsigned char']],
    'DemotePercent' : [ 0x1, ['unsigned char']],
    'PromotePercentBase' : [ 0x2, ['unsigned char']],
    'DemotePercentBase' : [ 0x3, ['unsigned char']],
    'AllowScaling' : [ 0x4, ['unsigned char']],
    'ForceLightIdle' : [ 0x5, ['unsigned char']],
} ],
  '_MI_RESAVAIL_FAILURES' : [ 0x8, {
    'Wrap' : [ 0x0, ['unsigned long']],
    'NoCharge' : [ 0x4, ['unsigned long']],
} ],
  '_PO_HIBER_PERF' : [ 0x1f8, {
    'HiberIoTicks' : [ 0x0, ['unsigned long long']],
    'HiberIoCpuTicks' : [ 0x8, ['unsigned long long']],
    'HiberInitTicks' : [ 0x10, ['unsigned long long']],
    'HiberHiberFileTicks' : [ 0x18, ['unsigned long long']],
    'HiberCompressTicks' : [ 0x20, ['unsigned long long']],
    'HiberSharedBufferTicks' : [ 0x28, ['unsigned long long']],
    'HiberChecksumTicks' : [ 0x30, ['unsigned long long']],
    'HiberChecksumIoTicks' : [ 0x38, ['unsigned long long']],
    'TotalHibernateTime' : [ 0x40, ['_LARGE_INTEGER']],
    'HibernateCompleteTimestamp' : [ 0x48, ['_LARGE_INTEGER']],
    'POSTTime' : [ 0x50, ['unsigned long']],
    'ResumeBootMgrTime' : [ 0x54, ['unsigned long']],
    'BootmgrUserInputTime' : [ 0x58, ['unsigned long']],
    'ResumeAppTicks' : [ 0x60, ['unsigned long long']],
    'ResumeAppStartTimestamp' : [ 0x68, ['unsigned long long']],
    'ResumeLibraryInitTicks' : [ 0x70, ['unsigned long long']],
    'ResumeInitTicks' : [ 0x78, ['unsigned long long']],
    'ResumeRestoreImageStartTimestamp' : [ 0x80, ['unsigned long long']],
    'ResumeHiberFileTicks' : [ 0x88, ['unsigned long long']],
    'ResumeIoTicks' : [ 0x90, ['unsigned long long']],
    'ResumeDecompressTicks' : [ 0x98, ['unsigned long long']],
    'ResumeAllocateTicks' : [ 0xa0, ['unsigned long long']],
    'ResumeUserInOutTicks' : [ 0xa8, ['unsigned long long']],
    'ResumeMapTicks' : [ 0xb0, ['unsigned long long']],
    'ResumeUnmapTicks' : [ 0xb8, ['unsigned long long']],
    'ResumeChecksumTicks' : [ 0xc0, ['unsigned long long']],
    'ResumeChecksumIoTicks' : [ 0xc8, ['unsigned long long']],
    'ResumeKernelSwitchTimestamp' : [ 0xd0, ['unsigned long long']],
    'CyclesPerMs' : [ 0xd8, ['unsigned long long']],
    'WriteLogDataTimestamp' : [ 0xe0, ['unsigned long long']],
    'KernelReturnFromHandler' : [ 0xe8, ['unsigned long long']],
    'TimeStampCounterAtSwitchTime' : [ 0xf0, ['unsigned long long']],
    'HalTscOffset' : [ 0xf8, ['unsigned long long']],
    'HvlTscOffset' : [ 0x100, ['unsigned long long']],
    'SleeperThreadEnd' : [ 0x108, ['unsigned long long']],
    'PostCmosUpdateTimestamp' : [ 0x110, ['unsigned long long']],
    'KernelReturnSystemPowerStateTimestamp' : [ 0x118, ['unsigned long long']],
    'IoBoundedness' : [ 0x120, ['unsigned long long']],
    'KernelDecompressTicks' : [ 0x128, ['unsigned long long']],
    'KernelIoTicks' : [ 0x130, ['unsigned long long']],
    'KernelCopyTicks' : [ 0x138, ['unsigned long long']],
    'ReadCheckCount' : [ 0x140, ['unsigned long long']],
    'KernelInitTicks' : [ 0x148, ['unsigned long long']],
    'KernelResumeHiberFileTicks' : [ 0x150, ['unsigned long long']],
    'KernelIoCpuTicks' : [ 0x158, ['unsigned long long']],
    'KernelSharedBufferTicks' : [ 0x160, ['unsigned long long']],
    'KernelAnimationTicks' : [ 0x168, ['unsigned long long']],
    'KernelChecksumTicks' : [ 0x170, ['unsigned long long']],
    'KernelChecksumIoTicks' : [ 0x178, ['unsigned long long']],
    'AnimationStart' : [ 0x180, ['_LARGE_INTEGER']],
    'AnimationStop' : [ 0x188, ['_LARGE_INTEGER']],
    'DeviceResumeTime' : [ 0x190, ['unsigned long']],
    'SecurePagesProcessed' : [ 0x198, ['unsigned long long']],
    'BootPagesProcessed' : [ 0x1a0, ['unsigned long long']],
    'KernelPagesProcessed' : [ 0x1a8, ['unsigned long long']],
    'BootBytesWritten' : [ 0x1b0, ['unsigned long long']],
    'KernelBytesWritten' : [ 0x1b8, ['unsigned long long']],
    'BootPagesWritten' : [ 0x1c0, ['unsigned long long']],
    'KernelPagesWritten' : [ 0x1c8, ['unsigned long long']],
    'BytesWritten' : [ 0x1d0, ['unsigned long long']],
    'PagesWritten' : [ 0x1d8, ['unsigned long']],
    'FileRuns' : [ 0x1dc, ['unsigned long']],
    'NoMultiStageResumeReason' : [ 0x1e0, ['unsigned long']],
    'MaxHuffRatio' : [ 0x1e4, ['unsigned long']],
    'AdjustedTotalResumeTime' : [ 0x1e8, ['unsigned long long']],
    'ResumeCompleteTimestamp' : [ 0x1f0, ['unsigned long long']],
} ],
  '_HAL_UNMASKED_INTERRUPT_INFORMATION' : [ 0x20, {
    'Version' : [ 0x0, ['unsigned short']],
    'Size' : [ 0x2, ['unsigned short']],
    'Flags' : [ 0x4, ['_HAL_UNMASKED_INTERRUPT_FLAGS']],
    'Mode' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {0: u'LevelSensitive', 1: u'Latched'})]],
    'Polarity' : [ 0xc, ['Enumeration', dict(target = 'long', choices = {0: u'InterruptPolarityUnknown', 1: u'InterruptRisingEdge', 2: u'InterruptFallingEdge', 3: u'InterruptActiveBothTriggerLow', 4: u'InterruptActiveBothTriggerHigh'})]],
    'Gsiv' : [ 0x10, ['unsigned long']],
    'PinNumber' : [ 0x14, ['unsigned short']],
    'DeviceHandle' : [ 0x18, ['pointer64', ['void']]],
} ],
  '_KTRANSACTION' : [ 0x2d8, {
    'OutcomeEvent' : [ 0x0, ['_KEVENT']],
    'cookie' : [ 0x18, ['unsigned long']],
    'Mutex' : [ 0x20, ['_KMUTANT']],
    'TreeTx' : [ 0x58, ['pointer64', ['_KTRANSACTION']]],
    'GlobalNamespaceLink' : [ 0x60, ['_KTMOBJECT_NAMESPACE_LINK']],
    'TmNamespaceLink' : [ 0x88, ['_KTMOBJECT_NAMESPACE_LINK']],
    'UOW' : [ 0xb0, ['_GUID']],
    'State' : [ 0xc0, ['Enumeration', dict(target = 'long', choices = {0: u'KTransactionUninitialized', 1: u'KTransactionActive', 2: u'KTransactionPreparing', 3: u'KTransactionPrepared', 4: u'KTransactionInDoubt', 5: u'KTransactionCommitted', 6: u'KTransactionAborted', 7: u'KTransactionDelegated', 8: u'KTransactionPrePreparing', 9: u'KTransactionForgotten', 10: u'KTransactionRecovering', 11: u'KTransactionPrePrepared'})]],
    'Flags' : [ 0xc4, ['unsigned long']],
    'EnlistmentHead' : [ 0xc8, ['_LIST_ENTRY']],
    'EnlistmentCount' : [ 0xd8, ['unsigned long']],
    'RecoverableEnlistmentCount' : [ 0xdc, ['unsigned long']],
    'PrePrepareRequiredEnlistmentCount' : [ 0xe0, ['unsigned long']],
    'PrepareRequiredEnlistmentCount' : [ 0xe4, ['unsigned long']],
    'OutcomeRequiredEnlistmentCount' : [ 0xe8, ['unsigned long']],
    'PendingResponses' : [ 0xec, ['unsigned long']],
    'SuperiorEnlistment' : [ 0xf0, ['pointer64', ['_KENLISTMENT']]],
    'LastLsn' : [ 0xf8, ['_CLS_LSN']],
    'PromotedEntry' : [ 0x100, ['_LIST_ENTRY']],
    'PromoterTransaction' : [ 0x110, ['pointer64', ['_KTRANSACTION']]],
    'PromotePropagation' : [ 0x118, ['pointer64', ['void']]],
    'IsolationLevel' : [ 0x120, ['unsigned long']],
    'IsolationFlags' : [ 0x124, ['unsigned long']],
    'Timeout' : [ 0x128, ['_LARGE_INTEGER']],
    'Description' : [ 0x130, ['_UNICODE_STRING']],
    'RollbackThread' : [ 0x140, ['pointer64', ['_KTHREAD']]],
    'RollbackWorkItem' : [ 0x148, ['_WORK_QUEUE_ITEM']],
    'RollbackDpc' : [ 0x168, ['_KDPC']],
    'RollbackTimer' : [ 0x1a8, ['_KTIMER']],
    'LsnOrderedEntry' : [ 0x1e8, ['_LIST_ENTRY']],
    'Outcome' : [ 0x1f8, ['Enumeration', dict(target = 'long', choices = {0: u'KTxOutcomeUninitialized', 1: u'KTxOutcomeUndetermined', 2: u'KTxOutcomeCommitted', 3: u'KTxOutcomeAborted', 4: u'KTxOutcomeUnavailable'})]],
    'Tm' : [ 0x200, ['pointer64', ['_KTM']]],
    'CommitReservation' : [ 0x208, ['long long']],
    'TransactionHistory' : [ 0x210, ['array', 10, ['_KTRANSACTION_HISTORY']]],
    'TransactionHistoryCount' : [ 0x260, ['unsigned long']],
    'DTCPrivateInformation' : [ 0x268, ['pointer64', ['void']]],
    'DTCPrivateInformationLength' : [ 0x270, ['unsigned long']],
    'DTCPrivateInformationMutex' : [ 0x278, ['_KMUTANT']],
    'PromotedTxSelfHandle' : [ 0x2b0, ['pointer64', ['void']]],
    'PendingPromotionCount' : [ 0x2b8, ['unsigned long']],
    'PromotionCompletedEvent' : [ 0x2c0, ['_KEVENT']],
} ],
  '_FAKE_HEAP_ENTRY' : [ 0x10, {
    'Size' : [ 0x0, ['unsigned long long']],
    'PreviousSize' : [ 0x8, ['unsigned long long']],
} ],
  '_TOKEN_AUDIT_POLICY' : [ 0x1e, {
    'PerUserPolicy' : [ 0x0, ['array', 30, ['unsigned char']]],
} ],
  '_MI_PROBE_RAISE_TRACKER' : [ 0x44, {
    'UserRangeInKernel' : [ 0x0, ['unsigned long']],
    'FaultFailed' : [ 0x4, ['unsigned long']],
    'WriteFaultFailed' : [ 0x8, ['unsigned long']],
    'LargePageFailed' : [ 0xc, ['unsigned long']],
    'UserAccessToKernelPte' : [ 0x10, ['unsigned long']],
    'BadPageLocation' : [ 0x14, ['unsigned long']],
    'InsufficientCharge' : [ 0x18, ['unsigned long']],
    'PageTableCharge' : [ 0x1c, ['unsigned long']],
    'NoPhysicalMapping' : [ 0x20, ['unsigned long']],
    'NoIoReference' : [ 0x24, ['unsigned long']],
    'ProbeFailed' : [ 0x28, ['unsigned long']],
    'PteIsZero' : [ 0x2c, ['unsigned long']],
    'StrongCodeWrite' : [ 0x30, ['unsigned long']],
    'ReducedCloneCommitChargeFailed' : [ 0x34, ['unsigned long']],
    'CopyOnWriteAtDispatchNoPages' : [ 0x38, ['unsigned long']],
    'NoPageTablesAllowed' : [ 0x3c, ['unsigned long']],
    'EnclavePageFailed' : [ 0x40, ['unsigned long']],
} ],
  '_KTMOBJECT_NAMESPACE' : [ 0xa8, {
    'Table' : [ 0x0, ['_RTL_AVL_TABLE']],
    'Mutex' : [ 0x68, ['_KMUTANT']],
    'LinksOffset' : [ 0xa0, ['unsigned short']],
    'GuidOffset' : [ 0xa2, ['unsigned short']],
    'Expired' : [ 0xa4, ['unsigned char']],
} ],
  '_LOADER_BUGCHECK_PARAMETERS' : [ 0x28, {
    'BugcheckCode' : [ 0x0, ['unsigned long']],
    'BugcheckParameter1' : [ 0x8, ['unsigned long long']],
    'BugcheckParameter2' : [ 0x10, ['unsigned long long']],
    'BugcheckParameter3' : [ 0x18, ['unsigned long long']],
    'BugcheckParameter4' : [ 0x20, ['unsigned long long']],
} ],
  '_POP_FX_DRIPS_WATCHDOG_CONTEXT' : [ 0x28, {
    'Link' : [ 0x0, ['_LIST_ENTRY']],
    'ComponentIndex' : [ 0x10, ['unsigned long']],
    'ChildDevices' : [ 0x18, ['pointer64', ['pointer64', ['_DEVICE_NODE']]]],
    'ChildDeviceCount' : [ 0x20, ['unsigned long']],
} ],
  '_SUPPORTED_RANGE' : [ 0x28, {
    'Next' : [ 0x0, ['pointer64', ['_SUPPORTED_RANGE']]],
    'SystemAddressSpace' : [ 0x8, ['unsigned long']],
    'SystemBase' : [ 0x10, ['long long']],
    'Base' : [ 0x18, ['long long']],
    'Limit' : [ 0x20, ['long long']],
} ],
  '__unnamed_2ef8' : [ 0x8, {
    'NumberOfEntries' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 10, native_type='unsigned long long')]],
    'PageSize' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 12, native_type='unsigned long long')]],
    'Va' : [ 0x0, ['pointer64', ['void']]],
    'VaLong' : [ 0x0, ['unsigned long long']],
} ],
  '_KTB_FLUSH_VA' : [ 0x8, {
    'u1' : [ 0x0, ['__unnamed_2ef8']],
} ],
  '_LDR_DDAG_NODE' : [ 0x50, {
    'Modules' : [ 0x0, ['_LIST_ENTRY']],
    'ServiceTagList' : [ 0x10, ['pointer64', ['_LDR_SERVICE_TAG_RECORD']]],
    'LoadCount' : [ 0x18, ['unsigned long']],
    'LoadWhileUnloadingCount' : [ 0x1c, ['unsigned long']],
    'LowestLink' : [ 0x20, ['unsigned long']],
    'Dependencies' : [ 0x28, ['_LDRP_CSLIST']],
    'IncomingDependencies' : [ 0x30, ['_LDRP_CSLIST']],
    'State' : [ 0x38, ['Enumeration', dict(target = 'long', choices = {0: u'LdrModulesPlaceHolder', 1: u'LdrModulesMapping', 2: u'LdrModulesMapped', 3: u'LdrModulesWaitingForDependencies', 4: u'LdrModulesSnapping', 5: u'LdrModulesSnapped', 6: u'LdrModulesCondensed', 7: u'LdrModulesReadyToInit', 8: u'LdrModulesInitializing', 9: u'LdrModulesReadyToRun', -2: u'LdrModulesUnloaded', -5: u'LdrModulesMerged', -4: u'LdrModulesInitError', -3: u'LdrModulesSnapError', -1: u'LdrModulesUnloading'})]],
    'CondenseLink' : [ 0x40, ['_SINGLE_LIST_ENTRY']],
    'PreorderNumber' : [ 0x48, ['unsigned long']],
} ],
  '_MI_PAGE_COLORS' : [ 0x10, {
    'PageSize' : [ 0x0, ['array', 4, ['unsigned long']]],
} ],
  '_DUMP_STACK_CONTEXT' : [ 0x178, {
    'Init' : [ 0x0, ['_DUMP_INITIALIZATION_CONTEXT']],
    'PartitionOffset' : [ 0x108, ['_LARGE_INTEGER']],
    'DumpPointers' : [ 0x110, ['pointer64', ['void']]],
    'StorageInfo' : [ 0x110, ['pointer64', ['void']]],
    'UseStorageInfo' : [ 0x118, ['unsigned char']],
    'PointersLength' : [ 0x11c, ['unsigned long']],
    'ModulePrefix' : [ 0x120, ['pointer64', ['wchar']]],
    'DriverList' : [ 0x128, ['_LIST_ENTRY']],
    'InitMsg' : [ 0x138, ['_STRING']],
    'ProgMsg' : [ 0x148, ['_STRING']],
    'DoneMsg' : [ 0x158, ['_STRING']],
    'FileObject' : [ 0x168, ['pointer64', ['void']]],
    'UsageType' : [ 0x170, ['Enumeration', dict(target = 'long', choices = {0: u'DeviceUsageTypeUndefined', 1: u'DeviceUsageTypePaging', 2: u'DeviceUsageTypeHibernation', 3: u'DeviceUsageTypeDumpFile', 4: u'DeviceUsageTypeBoot', 5: u'DeviceUsageTypePostDisplay'})]],
} ],
  '_PNP_WATCHDOG' : [ 0xd8, {
    'WatchdogStart' : [ 0x0, ['unsigned long long']],
    'WatchdogTimer' : [ 0x8, ['_KTIMER']],
    'WatchdogDpc' : [ 0x48, ['_KDPC']],
    'WatchdogEnabled' : [ 0x88, ['unsigned char']],
    'WatchdogSecondChance' : [ 0x89, ['unsigned char']],
    'WatchdogComplete' : [ 0x90, ['_KEVENT']],
    'WatchdogWorkItem' : [ 0xa8, ['_WORK_QUEUE_ITEM']],
    'WatchdogContextType' : [ 0xc8, ['Enumeration', dict(target = 'long', choices = {1: u'PNP_EVENT_WORKER_WATCHDOG', 2: u'PNP_DEVICE_COMPLETION_QUEUE_WATCHDOG', 3: u'PNP_DELAYED_REMOVE_WORKER_WATCHDOG'})]],
    'WatchdogContext' : [ 0xd0, ['pointer64', ['void']]],
} ],
  '_AER_ENDPOINT_DESCRIPTOR_FLAGS' : [ 0x2, {
    'UncorrectableErrorMaskRW' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
    'UncorrectableErrorSeverityRW' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned short')]],
    'CorrectableErrorMaskRW' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned short')]],
    'AdvancedCapsAndControlRW' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned short')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 16, native_type='unsigned short')]],
    'AsUSHORT' : [ 0x0, ['unsigned short']],
} ],
  '_HAL_NODE_RANGE' : [ 0x10, {
    'PageFrameIndex' : [ 0x0, ['unsigned long long']],
    'Node' : [ 0x8, ['unsigned long']],
} ],
  '_ARC_DISK_INFORMATION' : [ 0x10, {
    'DiskSignatures' : [ 0x0, ['_LIST_ENTRY']],
} ],
  '_POP_FX_DEPENDENT' : [ 0x8, {
    'Index' : [ 0x0, ['unsigned long']],
    'ProviderIndex' : [ 0x4, ['unsigned long']],
} ],
  '_MI_PAGEFILE_BITMAPS_CACHE_ENTRY' : [ 0x38, {
    'LengthTreeNode' : [ 0x0, ['_RTL_BALANCED_NODE']],
    'FreeListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'LocationTreeNode' : [ 0x18, ['_RTL_BALANCED_NODE']],
    'StartingIndex' : [ 0x30, ['unsigned long']],
    'Length' : [ 0x34, ['unsigned long']],
} ],
  '_RTL_UMS_CONTEXT' : [ 0x520, {
    'Link' : [ 0x0, ['_SINGLE_LIST_ENTRY']],
    'Context' : [ 0x10, ['_CONTEXT']],
    'Teb' : [ 0x4e0, ['pointer64', ['void']]],
    'UserContext' : [ 0x4e8, ['pointer64', ['void']]],
    'ScheduledThread' : [ 0x4f0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Suspended' : [ 0x4f0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'VolatileContext' : [ 0x4f0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'Terminated' : [ 0x4f0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'DebugActive' : [ 0x4f0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'RunningOnSelfThread' : [ 0x4f0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'DenyRunningOnSelfThread' : [ 0x4f0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'Flags' : [ 0x4f0, ['long']],
    'KernelUpdateLock' : [ 0x4f8, ['BitField', dict(start_bit = 0, end_bit = 2, native_type='unsigned long long')]],
    'PrimaryClientID' : [ 0x4f8, ['BitField', dict(start_bit = 2, end_bit = 64, native_type='unsigned long long')]],
    'ContextLock' : [ 0x4f8, ['unsigned long long']],
    'PrimaryUmsContext' : [ 0x500, ['pointer64', ['_RTL_UMS_CONTEXT']]],
    'SwitchCount' : [ 0x508, ['unsigned long']],
    'KernelYieldCount' : [ 0x50c, ['unsigned long']],
    'MixedYieldCount' : [ 0x510, ['unsigned long']],
    'YieldCount' : [ 0x514, ['unsigned long']],
} ],
  '_MI_RESUME_WORKITEM' : [ 0x38, {
    'ResumeCompleteEvent' : [ 0x0, ['_KEVENT']],
    'WorkItem' : [ 0x18, ['_WORK_QUEUE_ITEM']],
} ],
  '_INPUT_MAPPING_ELEMENT' : [ 0x4, {
    'InputMappingId' : [ 0x0, ['unsigned long']],
} ],
  '_KDESCRIPTOR' : [ 0x10, {
    'Pad' : [ 0x0, ['array', 3, ['unsigned short']]],
    'Limit' : [ 0x6, ['unsigned short']],
    'Base' : [ 0x8, ['pointer64', ['void']]],
} ],
  '__unnamed_2f29' : [ 0x14, {
    'ClassGuid' : [ 0x0, ['_GUID']],
    'SymbolicLinkName' : [ 0x10, ['array', 1, ['wchar']]],
} ],
  '__unnamed_2f2b' : [ 0x2, {
    'DeviceId' : [ 0x0, ['array', 1, ['wchar']]],
} ],
  '__unnamed_2f2d' : [ 0x10, {
    'NotificationStructure' : [ 0x0, ['pointer64', ['void']]],
    'DeviceId' : [ 0x8, ['array', 1, ['wchar']]],
} ],
  '__unnamed_2f2f' : [ 0x8, {
    'Notification' : [ 0x0, ['pointer64', ['void']]],
} ],
  '__unnamed_2f31' : [ 0x8, {
    'NotificationCode' : [ 0x0, ['unsigned long']],
    'NotificationData' : [ 0x4, ['unsigned long']],
} ],
  '__unnamed_2f33' : [ 0x8, {
    'VetoType' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: u'PNP_VetoTypeUnknown', 1: u'PNP_VetoLegacyDevice', 2: u'PNP_VetoPendingClose', 3: u'PNP_VetoWindowsApp', 4: u'PNP_VetoWindowsService', 5: u'PNP_VetoOutstandingOpen', 6: u'PNP_VetoDevice', 7: u'PNP_VetoDriver', 8: u'PNP_VetoIllegalDeviceRequest', 9: u'PNP_VetoInsufficientPower', 10: u'PNP_VetoNonDisableable', 11: u'PNP_VetoLegacyDriver', 12: u'PNP_VetoInsufficientRights'})]],
    'DeviceIdVetoNameBuffer' : [ 0x4, ['array', 1, ['wchar']]],
} ],
  '__unnamed_2f35' : [ 0x10, {
    'BlockedDriverGuid' : [ 0x0, ['_GUID']],
} ],
  '__unnamed_2f37' : [ 0x2, {
    'ParentId' : [ 0x0, ['array', 1, ['wchar']]],
} ],
  '__unnamed_2f39' : [ 0x20, {
    'PowerSettingGuid' : [ 0x0, ['_GUID']],
    'Flags' : [ 0x10, ['unsigned long']],
    'SessionId' : [ 0x14, ['unsigned long']],
    'DataLength' : [ 0x18, ['unsigned long']],
    'Data' : [ 0x1c, ['array', 1, ['unsigned char']]],
} ],
  '__unnamed_2f3b' : [ 0x20, {
    'DeviceClass' : [ 0x0, ['__unnamed_2f29']],
    'TargetDevice' : [ 0x0, ['__unnamed_2f2b']],
    'InstallDevice' : [ 0x0, ['__unnamed_2f2b']],
    'CustomNotification' : [ 0x0, ['__unnamed_2f2d']],
    'ProfileNotification' : [ 0x0, ['__unnamed_2f2f']],
    'PowerNotification' : [ 0x0, ['__unnamed_2f31']],
    'VetoNotification' : [ 0x0, ['__unnamed_2f33']],
    'BlockedDriverNotification' : [ 0x0, ['__unnamed_2f35']],
    'InvalidIDNotification' : [ 0x0, ['__unnamed_2f37']],
    'PowerSettingNotification' : [ 0x0, ['__unnamed_2f39']],
    'PropertyChangeNotification' : [ 0x0, ['__unnamed_2f2b']],
    'DeviceInstanceNotification' : [ 0x0, ['__unnamed_2f2b']],
} ],
  '_PLUGPLAY_EVENT_BLOCK' : [ 0x50, {
    'EventGuid' : [ 0x0, ['_GUID']],
    'EventCategory' : [ 0x10, ['Enumeration', dict(target = 'long', choices = {0: u'HardwareProfileChangeEvent', 1: u'TargetDeviceChangeEvent', 2: u'DeviceClassChangeEvent', 3: u'CustomDeviceEvent', 4: u'DeviceInstallEvent', 5: u'DeviceArrivalEvent', 6: u'VetoEvent', 7: u'BlockedDriverEvent', 8: u'InvalidIDEvent', 9: u'DevicePropertyChangeEvent', 10: u'DeviceInstanceRemovalEvent', 11: u'DeviceInstanceStartedEvent', 12: u'MaxPlugEventCategory'})]],
    'Result' : [ 0x18, ['pointer64', ['unsigned long']]],
    'Flags' : [ 0x20, ['unsigned long']],
    'TotalSize' : [ 0x24, ['unsigned long']],
    'DeviceObject' : [ 0x28, ['pointer64', ['void']]],
    'u' : [ 0x30, ['__unnamed_2f3b']],
} ],
  '_WHEA_PROCESSOR_GENERIC_ERROR_SECTION_VALIDBITS' : [ 0x8, {
    'ProcessorType' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'InstructionSet' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long long')]],
    'ErrorType' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long long')]],
    'Operation' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long long')]],
    'Flags' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long long')]],
    'Level' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long long')]],
    'CPUVersion' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long long')]],
    'CPUBrandString' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long long')]],
    'ProcessorId' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long long')]],
    'TargetAddress' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long long')]],
    'RequesterId' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long long')]],
    'ResponderId' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long long')]],
    'InstructionPointer' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 13, end_bit = 64, native_type='unsigned long long')]],
    'ValidBits' : [ 0x0, ['unsigned long long']],
} ],
  '_WHEA_ERROR_RECORD_HEADER_FLAGS' : [ 0x4, {
    'Recovered' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'PreviousError' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'Simulated' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 32, native_type='unsigned long')]],
    'AsULONG' : [ 0x0, ['unsigned long']],
} ],
  '_CACHED_KSTACK_LIST' : [ 0x20, {
    'SListHead' : [ 0x0, ['_SLIST_HEADER']],
    'MinimumFree' : [ 0x10, ['long']],
    'Misses' : [ 0x14, ['unsigned long']],
    'MissesLast' : [ 0x18, ['unsigned long']],
    'AllStacksInUse' : [ 0x1c, ['unsigned long']],
} ],
  '_I386_LOADER_BLOCK' : [ 0x10, {
    'CommonDataArea' : [ 0x0, ['pointer64', ['void']]],
    'MachineType' : [ 0x8, ['unsigned long']],
    'VirtualBias' : [ 0xc, ['unsigned long']],
} ],
  '_PROC_IDLE_STATE_BUCKET' : [ 0x20, {
    'TotalTime' : [ 0x0, ['unsigned long long']],
    'MinTime' : [ 0x8, ['unsigned long long']],
    'MaxTime' : [ 0x10, ['unsigned long long']],
    'Count' : [ 0x18, ['unsigned long']],
} ],
  '_ARBITER_ORDERING' : [ 0x10, {
    'Start' : [ 0x0, ['unsigned long long']],
    'End' : [ 0x8, ['unsigned long long']],
} ],
  '__unnamed_2f4c' : [ 0x8, {
    'Pch' : [ 0x0, ['unsigned char']],
    'EmbeddedController' : [ 0x1, ['unsigned char']],
    'Reserved' : [ 0x2, ['array', 6, ['unsigned char']]],
} ],
  '__unnamed_2f4e' : [ 0x8, {
    'Component' : [ 0x0, ['__unnamed_2f4c']],
    'AsULONG64' : [ 0x0, ['unsigned long long']],
    'AsBytes' : [ 0x0, ['array', 8, ['unsigned char']]],
} ],
  '_LOADER_RESET_REASON' : [ 0x30, {
    'Supplied' : [ 0x0, ['unsigned char']],
    'Basic' : [ 0x8, ['__unnamed_2f4e']],
    'AdditionalInfo' : [ 0x10, ['array', 8, ['unsigned long']]],
} ],
  '_ARBITER_QUERY_ALLOCATED_RESOURCES_PARAMETERS' : [ 0x8, {
    'AllocatedResources' : [ 0x0, ['pointer64', ['pointer64', ['_CM_PARTIAL_RESOURCE_LIST']]]],
} ],
  '_HAL_CHANNEL_MEMORY_RANGES' : [ 0x10, {
    'PageFrameIndex' : [ 0x0, ['unsigned long long']],
    'MpnId' : [ 0x8, ['unsigned short']],
    'Node' : [ 0xa, ['unsigned short']],
    'Channel' : [ 0xc, ['unsigned short']],
    'IsPowerManageable' : [ 0xe, ['unsigned char']],
    'DeepPowerState' : [ 0xf, ['unsigned char']],
} ],
  '_LOADER_HIVE_RECOVERY_INFO' : [ 0x14, {
    'Recovered' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'LegacyRecovery' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'SoftRebootConflict' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'MostRecentLog' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 6, native_type='unsigned long')]],
    'Spare' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 27, native_type='unsigned long')]],
    'LogNextSequence' : [ 0x8, ['unsigned long']],
    'LogMinimumSequence' : [ 0xc, ['unsigned long']],
    'LogCurrentOffset' : [ 0x10, ['unsigned long']],
} ],
  '__unnamed_2f5f' : [ 0x38, {
    'EfiInformation' : [ 0x0, ['_EFI_FIRMWARE_INFORMATION']],
    'PcatInformation' : [ 0x0, ['_PCAT_FIRMWARE_INFORMATION']],
} ],
  '_FIRMWARE_INFORMATION_LOADER_BLOCK' : [ 0x40, {
    'FirmwareTypeUefi' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'EfiRuntimeUseIum' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'EfiRuntimePageProtectionSupported' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 32, native_type='unsigned long')]],
    'u' : [ 0x8, ['__unnamed_2f5f']],
} ],
  '__unnamed_2f63' : [ 0x10, {
    'Address' : [ 0x0, ['unsigned long long']],
    'Consumed' : [ 0x8, ['unsigned char']],
    'ErrorCode' : [ 0xa, ['unsigned short']],
    'ErrorIpValid' : [ 0xc, ['unsigned char']],
    'RestartIpValid' : [ 0xd, ['unsigned char']],
} ],
  '_WHEA_RECOVERY_CONTEXT' : [ 0x20, {
    'MemoryError' : [ 0x0, ['__unnamed_2f63']],
    'PartitionId' : [ 0x10, ['unsigned long long']],
    'VpIndex' : [ 0x18, ['unsigned long']],
} ],
  '_POP_TRIGGER_WAIT' : [ 0x38, {
    'Event' : [ 0x0, ['_KEVENT']],
    'Status' : [ 0x18, ['long']],
    'Link' : [ 0x20, ['_LIST_ENTRY']],
    'Trigger' : [ 0x30, ['pointer64', ['_POP_ACTION_TRIGGER']]],
} ],
  '_PROC_PERF_CONSTRAINT' : [ 0x80, {
    'Prcb' : [ 0x0, ['pointer64', ['_KPRCB']]],
    'PerfContext' : [ 0x8, ['unsigned long long']],
    'PlatformCap' : [ 0x10, ['unsigned long']],
    'ThermalCap' : [ 0x14, ['unsigned long']],
    'LimitReasons' : [ 0x18, ['unsigned long']],
    'PlatformCapStartTime' : [ 0x20, ['unsigned long long']],
    'ProcCap' : [ 0x28, ['unsigned long']],
    'ProcFloor' : [ 0x2c, ['unsigned long']],
    'TargetPercent' : [ 0x30, ['unsigned long']],
    'Selection' : [ 0x38, ['_PERF_CONTROL_STATE_SELECTION']],
    'DomainSelectionGeneration' : [ 0x60, ['unsigned long']],
    'PreviousFrequency' : [ 0x64, ['unsigned long']],
    'PreviousPercent' : [ 0x68, ['unsigned long']],
    'LatestFrequencyPercent' : [ 0x6c, ['unsigned long']],
    'Force' : [ 0x70, ['unsigned char']],
    'UseQosUpdateLock' : [ 0x71, ['unsigned char']],
    'QosUpdateLock' : [ 0x78, ['unsigned long long']],
} ],
  '_MI_ALIGNED_SLIST' : [ 0x40, {
    'SList' : [ 0x0, ['_SLIST_HEADER']],
} ],
  '_PROC_IDLE_STATE_ACCOUNTING' : [ 0x3e8, {
    'TotalTime' : [ 0x0, ['unsigned long long']],
    'CancelCount' : [ 0x8, ['unsigned long']],
    'FailureCount' : [ 0xc, ['unsigned long']],
    'SuccessCount' : [ 0x10, ['unsigned long']],
    'InvalidBucketIndex' : [ 0x14, ['unsigned long']],
    'MinTime' : [ 0x18, ['unsigned long long']],
    'MaxTime' : [ 0x20, ['unsigned long long']],
    'SelectionStatistics' : [ 0x28, ['_PPM_SELECTION_STATISTICS']],
    'IdleTimeBuckets' : [ 0xa8, ['array', 26, ['_PROC_IDLE_STATE_BUCKET']]],
} ],
  '_HEADLESS_LOADER_BLOCK' : [ 0x40, {
    'UsedBiosSettings' : [ 0x0, ['unsigned char']],
    'DataBits' : [ 0x1, ['unsigned char']],
    'StopBits' : [ 0x2, ['unsigned char']],
    'Parity' : [ 0x3, ['unsigned char']],
    'BaudRate' : [ 0x4, ['unsigned long']],
    'PortNumber' : [ 0x8, ['unsigned long']],
    'PortAddress' : [ 0x10, ['pointer64', ['unsigned char']]],
    'PciDeviceId' : [ 0x18, ['unsigned short']],
    'PciVendorId' : [ 0x1a, ['unsigned short']],
    'PciBusNumber' : [ 0x1c, ['unsigned char']],
    'PciBusSegment' : [ 0x1e, ['unsigned short']],
    'PciSlotNumber' : [ 0x20, ['unsigned char']],
    'PciFunctionNumber' : [ 0x21, ['unsigned char']],
    'PciFlags' : [ 0x24, ['unsigned long']],
    'SystemGUID' : [ 0x28, ['_GUID']],
    'IsMMIODevice' : [ 0x38, ['unsigned char']],
    'TerminalType' : [ 0x39, ['unsigned char']],
    'InterfaceType' : [ 0x3a, ['unsigned char']],
    'RegisterBitWidth' : [ 0x3b, ['unsigned char']],
    'RegisterAccessSize' : [ 0x3c, ['unsigned char']],
} ],
  '_WHEA_MEMORY_ERROR_SECTION_VALIDBITS' : [ 0x8, {
    'ErrorStatus' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'PhysicalAddress' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long long')]],
    'PhysicalAddressMask' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long long')]],
    'Node' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long long')]],
    'Card' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long long')]],
    'Module' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long long')]],
    'Bank' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long long')]],
    'Device' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long long')]],
    'Row' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long long')]],
    'Column' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long long')]],
    'BitPosition' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long long')]],
    'RequesterId' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long long')]],
    'ResponderId' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long long')]],
    'TargetId' : [ 0x0, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long long')]],
    'ErrorType' : [ 0x0, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long long')]],
    'RankNumber' : [ 0x0, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long long')]],
    'CardHandle' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long long')]],
    'ModuleHandle' : [ 0x0, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long long')]],
    'ExtendedRow' : [ 0x0, ['BitField', dict(start_bit = 18, end_bit = 19, native_type='unsigned long long')]],
    'BankGroup' : [ 0x0, ['BitField', dict(start_bit = 19, end_bit = 20, native_type='unsigned long long')]],
    'BankAddress' : [ 0x0, ['BitField', dict(start_bit = 20, end_bit = 21, native_type='unsigned long long')]],
    'ChipIdentification' : [ 0x0, ['BitField', dict(start_bit = 21, end_bit = 22, native_type='unsigned long long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 22, end_bit = 64, native_type='unsigned long long')]],
    'ValidBits' : [ 0x0, ['unsigned long long']],
} ],
  '_IO_REMOVE_LOCK_COMMON_BLOCK' : [ 0x20, {
    'Removed' : [ 0x0, ['unsigned char']],
    'Reserved' : [ 0x1, ['array', 3, ['unsigned char']]],
    'IoCount' : [ 0x4, ['long']],
    'RemoveEvent' : [ 0x8, ['_KEVENT']],
} ],
  '_PEP_CRASHDUMP_INFORMATION' : [ 0x10, {
    'DeviceHandle' : [ 0x0, ['pointer64', ['PEPHANDLE__']]],
    'DeviceContext' : [ 0x8, ['pointer64', ['void']]],
} ],
  '_CM_FULL_RESOURCE_DESCRIPTOR' : [ 0x24, {
    'InterfaceType' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: u'Internal', 1: u'Isa', 2: u'Eisa', 3: u'MicroChannel', 4: u'TurboChannel', 5: u'PCIBus', 6: u'VMEBus', 7: u'NuBus', 8: u'PCMCIABus', 9: u'CBus', 10: u'MPIBus', 11: u'MPSABus', 12: u'ProcessorInternal', 13: u'InternalPowerBus', 14: u'PNPISABus', 15: u'PNPBus', 16: u'Vmcs', 17: u'ACPIBus', 18: u'MaximumInterfaceType', -1: u'InterfaceTypeUndefined'})]],
    'BusNumber' : [ 0x4, ['unsigned long']],
    'PartialResourceList' : [ 0x8, ['_CM_PARTIAL_RESOURCE_LIST']],
} ],
  '_MMSECURE_FLAGS' : [ 0x4, {
    'ReadOnly' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'ReadWrite' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'SecNoChange' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'NoDelete' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'RequiresPteReversal' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'ExclusiveSecure' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'UserModeOnly' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'NoInherit' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'Spare' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 12, native_type='unsigned long')]],
} ],
  '_RTL_USER_PROCESS_PARAMETERS' : [ 0x410, {
    'MaximumLength' : [ 0x0, ['unsigned long']],
    'Length' : [ 0x4, ['unsigned long']],
    'Flags' : [ 0x8, ['unsigned long']],
    'DebugFlags' : [ 0xc, ['unsigned long']],
    'ConsoleHandle' : [ 0x10, ['pointer64', ['void']]],
    'ConsoleFlags' : [ 0x18, ['unsigned long']],
    'StandardInput' : [ 0x20, ['pointer64', ['void']]],
    'StandardOutput' : [ 0x28, ['pointer64', ['void']]],
    'StandardError' : [ 0x30, ['pointer64', ['void']]],
    'CurrentDirectory' : [ 0x38, ['_CURDIR']],
    'DllPath' : [ 0x50, ['_UNICODE_STRING']],
    'ImagePathName' : [ 0x60, ['_UNICODE_STRING']],
    'CommandLine' : [ 0x70, ['_UNICODE_STRING']],
    'Environment' : [ 0x80, ['pointer64', ['void']]],
    'StartingX' : [ 0x88, ['unsigned long']],
    'StartingY' : [ 0x8c, ['unsigned long']],
    'CountX' : [ 0x90, ['unsigned long']],
    'CountY' : [ 0x94, ['unsigned long']],
    'CountCharsX' : [ 0x98, ['unsigned long']],
    'CountCharsY' : [ 0x9c, ['unsigned long']],
    'FillAttribute' : [ 0xa0, ['unsigned long']],
    'WindowFlags' : [ 0xa4, ['unsigned long']],
    'ShowWindowFlags' : [ 0xa8, ['unsigned long']],
    'WindowTitle' : [ 0xb0, ['_UNICODE_STRING']],
    'DesktopInfo' : [ 0xc0, ['_UNICODE_STRING']],
    'ShellInfo' : [ 0xd0, ['_UNICODE_STRING']],
    'RuntimeData' : [ 0xe0, ['_UNICODE_STRING']],
    'CurrentDirectores' : [ 0xf0, ['array', 32, ['_RTL_DRIVE_LETTER_CURDIR']]],
    'EnvironmentSize' : [ 0x3f0, ['unsigned long long']],
    'EnvironmentVersion' : [ 0x3f8, ['unsigned long long']],
    'PackageDependencyData' : [ 0x400, ['pointer64', ['void']]],
    'ProcessGroupId' : [ 0x408, ['unsigned long']],
    'LoaderThreads' : [ 0x40c, ['unsigned long']],
} ],
  '_MI_IO_CACHE_STATS' : [ 0x28, {
    'UnusedBlocks' : [ 0x0, ['unsigned long long']],
    'ActiveCacheMatch' : [ 0x8, ['unsigned long']],
    'ActiveCacheOverride' : [ 0xc, ['unsigned long']],
    'UnmappedCacheFlush' : [ 0x10, ['unsigned long']],
    'UnmappedCacheMatch' : [ 0x14, ['unsigned long']],
    'UnmappedCacheConflict' : [ 0x18, ['unsigned long']],
    'PermanentIoAttributeConflict' : [ 0x1c, ['unsigned long']],
    'PermanentIoNodeConflict' : [ 0x20, ['unsigned long']],
} ],
  '__unnamed_2f85' : [ 0x4, {
    'PasidMaxWidth' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 5, native_type='unsigned long')]],
    'PasidExePerm' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'PasidPrivMode' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'AtsPageAlignedRequest' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'AtsGlobalInvalidate' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'AtsInvalidateQueueDepth' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 14, native_type='unsigned long')]],
} ],
  '_IOMMU_SVM_CAPABILITIES' : [ 0xc, {
    'AtsCapability' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'PriCapability' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'PasidCapability' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'CapReg' : [ 0x4, ['__unnamed_2f85']],
    'Rsvd' : [ 0x8, ['BitField', dict(start_bit = 0, end_bit = 15, native_type='unsigned long')]],
    'AsULONG' : [ 0x0, ['unsigned long']],
} ],
  '__unnamed_2f92' : [ 0x8, {
    'Signature' : [ 0x0, ['unsigned long']],
    'CheckSum' : [ 0x4, ['unsigned long']],
} ],
  '__unnamed_2f94' : [ 0x10, {
    'DiskId' : [ 0x0, ['_GUID']],
} ],
  '__unnamed_2f96' : [ 0x10, {
    'Mbr' : [ 0x0, ['__unnamed_2f92']],
    'Gpt' : [ 0x0, ['__unnamed_2f94']],
} ],
  '_DUMP_INITIALIZATION_CONTEXT' : [ 0x108, {
    'Length' : [ 0x0, ['unsigned long']],
    'Reserved' : [ 0x4, ['unsigned long']],
    'MemoryBlock' : [ 0x8, ['pointer64', ['void']]],
    'CommonBuffer' : [ 0x10, ['array', 2, ['pointer64', ['void']]]],
    'PhysicalAddress' : [ 0x20, ['array', 2, ['_LARGE_INTEGER']]],
    'StallRoutine' : [ 0x30, ['pointer64', ['void']]],
    'OpenRoutine' : [ 0x38, ['pointer64', ['void']]],
    'WriteRoutine' : [ 0x40, ['pointer64', ['void']]],
    'FinishRoutine' : [ 0x48, ['pointer64', ['void']]],
    'AdapterObject' : [ 0x50, ['pointer64', ['_ADAPTER_OBJECT']]],
    'MappedRegisterBase' : [ 0x58, ['pointer64', ['void']]],
    'PortConfiguration' : [ 0x60, ['pointer64', ['void']]],
    'CrashDump' : [ 0x68, ['unsigned char']],
    'MarkMemoryOnly' : [ 0x69, ['unsigned char']],
    'HiberResume' : [ 0x6a, ['unsigned char']],
    'Reserved1' : [ 0x6b, ['unsigned char']],
    'MaximumTransferSize' : [ 0x6c, ['unsigned long']],
    'CommonBufferSize' : [ 0x70, ['unsigned long']],
    'TargetAddress' : [ 0x78, ['pointer64', ['void']]],
    'WritePendingRoutine' : [ 0x80, ['pointer64', ['void']]],
    'PartitionStyle' : [ 0x88, ['unsigned long']],
    'DiskInfo' : [ 0x8c, ['__unnamed_2f96']],
    'ReadRoutine' : [ 0xa0, ['pointer64', ['void']]],
    'GetDriveTelemetryRoutine' : [ 0xa8, ['pointer64', ['void']]],
    'LogSectionTruncateSize' : [ 0xb0, ['unsigned long']],
    'Parameters' : [ 0xb4, ['array', 16, ['unsigned long']]],
    'GetTransferSizesRoutine' : [ 0xf8, ['pointer64', ['void']]],
    'DumpNotifyRoutine' : [ 0x100, ['pointer64', ['void']]],
} ],
  '_CM_FAST_LEAF_HINT' : [ 0x4, {
    'Characters' : [ 0x0, ['array', 4, ['unsigned char']]],
    'FullHint' : [ 0x0, ['unsigned long']],
} ],
  '_THERMAL_COOLING_INTERFACE' : [ 0x38, {
    'Size' : [ 0x0, ['unsigned short']],
    'Version' : [ 0x2, ['unsigned short']],
    'Context' : [ 0x8, ['pointer64', ['void']]],
    'InterfaceReference' : [ 0x10, ['pointer64', ['void']]],
    'InterfaceDereference' : [ 0x18, ['pointer64', ['void']]],
    'Flags' : [ 0x20, ['unsigned long']],
    'ActiveCooling' : [ 0x28, ['pointer64', ['void']]],
    'PassiveCooling' : [ 0x30, ['pointer64', ['void']]],
} ],
  '_PEP_WORK_INFORMATION' : [ 0x40, {
    'WorkType' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: u'PepWorkActiveComplete', 1: u'PepWorkRequestIdleState', 2: u'PepWorkDevicePower', 3: u'PepWorkRequestPowerControl', 4: u'PepWorkDeviceIdle', 5: u'PepWorkCompleteIdleState', 6: u'PepWorkCompletePerfState', 7: u'PepWorkAcpiNotify', 8: u'PepWorkAcpiEvaluateControlMethodComplete', 9: u'PepWorkMax'})]],
    'ActiveComplete' : [ 0x8, ['_PEP_WORK_ACTIVE_COMPLETE']],
    'IdleState' : [ 0x8, ['_PEP_WORK_IDLE_STATE']],
    'DevicePower' : [ 0x8, ['_PEP_WORK_DEVICE_POWER']],
    'PowerControl' : [ 0x8, ['_PEP_WORK_POWER_CONTROL']],
    'DeviceIdle' : [ 0x8, ['_PEP_WORK_DEVICE_IDLE']],
    'CompleteIdleState' : [ 0x8, ['_PEP_WORK_COMPLETE_IDLE_STATE']],
    'CompletePerfState' : [ 0x8, ['_PEP_WORK_COMPLETE_PERF_STATE']],
    'AcpiNotify' : [ 0x8, ['_PEP_WORK_ACPI_NOTIFY']],
    'ControlMethodComplete' : [ 0x8, ['_PEP_WORK_ACPI_EVALUATE_CONTROL_METHOD_COMPLETE']],
} ],
  '_VF_ADDRESS_RANGE' : [ 0x10, {
    'Start' : [ 0x0, ['pointer64', ['unsigned char']]],
    'End' : [ 0x8, ['pointer64', ['unsigned char']]],
} ],
  '_POP_FX_PERF_INFO' : [ 0xa0, {
    'Component' : [ 0x0, ['pointer64', ['_POP_FX_COMPONENT']]],
    'CompletedEvent' : [ 0x8, ['_KEVENT']],
    'ComponentPerfState' : [ 0x20, ['pointer64', ['void']]],
    'Flags' : [ 0x28, ['_POP_FX_PERF_FLAGS']],
    'LastChange' : [ 0x30, ['pointer64', ['_PO_FX_PERF_STATE_CHANGE']]],
    'LastChangeCount' : [ 0x38, ['unsigned long']],
    'LastChangeStamp' : [ 0x40, ['unsigned long long']],
    'LastChangeNominal' : [ 0x48, ['unsigned char']],
    'PepRegistered' : [ 0x49, ['unsigned char']],
    'QueryOnIdleStates' : [ 0x4a, ['unsigned char']],
    'RequestDriverContext' : [ 0x50, ['pointer64', ['void']]],
    'WorkOrder' : [ 0x58, ['_POP_FX_WORK_ORDER']],
    'SetsCount' : [ 0x90, ['unsigned long']],
    'Sets' : [ 0x98, ['pointer64', ['_POP_FX_PERF_SET']]],
} ],
  '_CVDD' : [ 0x1c, {
    'Signature' : [ 0x0, ['unsigned long']],
    'NB10' : [ 0x0, ['_NB10']],
    'RsDs' : [ 0x0, ['_RSDS']],
} ],
  '__unnamed_2fca' : [ 0x4, {
    'ForceEnable' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
} ],
  '_RTL_HP_LFH_CONFIG' : [ 0xc, {
    'MaxBlockSize' : [ 0x0, ['unsigned long']],
    'MaxSubsegmentSize' : [ 0x4, ['unsigned long']],
    'Flags' : [ 0x8, ['__unnamed_2fca']],
} ],
  '_MI_ACCESS_VIOLATION_RANGE' : [ 0x28, {
    'Node' : [ 0x0, ['_RTL_BALANCED_NODE']],
    'Va' : [ 0x18, ['pointer64', ['void']]],
    'EndVaInclusive' : [ 0x20, ['pointer64', ['void']]],
} ],
  '_PEP_WORK_ACPI_EVALUATE_CONTROL_METHOD_COMPLETE' : [ 0x28, {
    'DeviceHandle' : [ 0x0, ['pointer64', ['POHANDLE__']]],
    'CompletionFlags' : [ 0x8, ['unsigned long']],
    'MethodStatus' : [ 0xc, ['long']],
    'CompletionContext' : [ 0x10, ['pointer64', ['void']]],
    'OutputArgumentSize' : [ 0x18, ['unsigned long long']],
    'OutputArguments' : [ 0x20, ['pointer64', ['_ACPI_METHOD_ARGUMENT_V1']]],
} ],
  '_MMPAGE_FILE_EXPANSION_FLAGS' : [ 0x4, {
    'PageFileNumber' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned char')]],
    'Spare1' : [ 0x1, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned char')]],
    'Spare2' : [ 0x2, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned char')]],
    'IgnoreCurrentCommit' : [ 0x3, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'IncreaseMinimumSize' : [ 0x3, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'AttemptForCantExtend' : [ 0x3, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'UnusedSegmentDeletion' : [ 0x3, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'PageFileContract' : [ 0x3, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'Spare3' : [ 0x3, ['BitField', dict(start_bit = 5, end_bit = 8, native_type='unsigned char')]],
} ],
  '_MMPFNLIST_SHORT' : [ 0x18, {
    'Total' : [ 0x0, ['unsigned long long']],
    'Flink' : [ 0x8, ['unsigned long long']],
    'Blink' : [ 0x10, ['unsigned long long']],
} ],
  '_MI_RESTRICTED_MODWRITES' : [ 0x3, {
    'MaximumClusterPages' : [ 0x0, ['unsigned char']],
    'ReducedClusterWrites' : [ 0x1, ['unsigned char']],
    'ImposeDelay' : [ 0x2, ['unsigned char']],
} ],
  '_OFFLINE_CRASHDUMP_CONFIGURATION_TABLE_V2' : [ 0x20, {
    'Version' : [ 0x0, ['unsigned long']],
    'AbnormalResetOccurred' : [ 0x4, ['unsigned long']],
    'OfflineMemoryDumpCapable' : [ 0x8, ['unsigned long']],
    'ResetDataAddress' : [ 0x10, ['_LARGE_INTEGER']],
    'ResetDataSize' : [ 0x18, ['unsigned long']],
} ],
  '_ACPI_METHOD_ARGUMENT_V1' : [ 0x8, {
    'Type' : [ 0x0, ['unsigned short']],
    'DataLength' : [ 0x2, ['unsigned short']],
    'Argument' : [ 0x4, ['unsigned long']],
    'Data' : [ 0x4, ['array', 1, ['unsigned char']]],
} ],
  '_MI_VAD_SEQUENTIAL_INFO' : [ 0x8, {
    'Length' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 12, native_type='unsigned long long')]],
    'Vpn' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 64, native_type='unsigned long long')]],
} ],
  '_PEP_WORK_ACPI_NOTIFY' : [ 0x10, {
    'DeviceHandle' : [ 0x0, ['pointer64', ['POHANDLE__']]],
    'NotifyCode' : [ 0x8, ['unsigned long']],
} ],
  '_TRIAGE_POP_IRP_DATA' : [ 0x20, {
    'Link' : [ 0x0, ['_LIST_ENTRY']],
    'Irp' : [ 0x10, ['pointer64', ['_IRP']]],
    'Pdo' : [ 0x18, ['pointer64', ['_DEVICE_OBJECT']]],
} ],
  '_VI_POOL_ENTRY' : [ 0x20, {
    'PageHeader' : [ 0x0, ['_VI_POOL_PAGE_HEADER']],
    'InUse' : [ 0x0, ['_VI_POOL_ENTRY_INUSE']],
    'NextFree' : [ 0x0, ['pointer64', ['_SLIST_ENTRY']]],
} ],
  '_MI_PAGING_FILE_SPACE_BITMAPS' : [ 0x28, {
    'RefCount' : [ 0x0, ['unsigned long']],
    'Anchor' : [ 0x0, ['pointer64', ['_MI_PAGING_FILE_SPACE_BITMAPS']]],
    'AllocationBitmap' : [ 0x8, ['_RTL_BITMAP']],
    'ReservationBitmap' : [ 0x18, ['_RTL_BITMAP']],
    'EvictedBitmap' : [ 0x18, ['_RTL_BITMAP']],
} ],
  '_MI_SYSTEM_VA_ASSIGNMENT' : [ 0x10, {
    'BaseAddress' : [ 0x0, ['pointer64', ['void']]],
    'NumberOfBytes' : [ 0x8, ['unsigned long long']],
} ],
  '_PROCESSOR_PLATFORM_STATE_RESIDENCY' : [ 0x10, {
    'Residency' : [ 0x0, ['unsigned long long']],
    'TransitionCount' : [ 0x8, ['unsigned long long']],
} ],
  '_POP_PER_PROCESSOR_CONTEXT' : [ 0x80, {
    'UncompressedData' : [ 0x0, ['pointer64', ['unsigned char']]],
    'MappingVa' : [ 0x8, ['pointer64', ['void']]],
    'XpressEncodeWorkspace' : [ 0x10, ['pointer64', ['void']]],
    'CompressedDataBuffer' : [ 0x18, ['pointer64', ['unsigned char']]],
    'CopyTicks' : [ 0x20, ['unsigned long long']],
    'CompressTicks' : [ 0x28, ['unsigned long long']],
    'BytesCopied' : [ 0x30, ['unsigned long long']],
    'PagesProcessed' : [ 0x38, ['unsigned long long']],
    'DecompressTicks' : [ 0x40, ['unsigned long long']],
    'ResumeCopyTicks' : [ 0x48, ['unsigned long long']],
    'SharedBufferTicks' : [ 0x50, ['unsigned long long']],
    'DecompressTicksByMethod' : [ 0x58, ['array', 2, ['unsigned long long']]],
    'DecompressSizeByMethod' : [ 0x68, ['array', 2, ['unsigned long long']]],
    'CompressCount' : [ 0x78, ['unsigned long']],
    'HuffCompressCount' : [ 0x7c, ['unsigned long']],
} ],
  '_ETW_APC_ENTRY' : [ 0x60, {
    'SListEntry' : [ 0x0, ['_SLIST_ENTRY']],
    'Apc' : [ 0x0, ['_KAPC']],
} ],
  '_CONFIGURATION_COMPONENT' : [ 0x28, {
    'Class' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: u'SystemClass', 1: u'ProcessorClass', 2: u'CacheClass', 3: u'AdapterClass', 4: u'ControllerClass', 5: u'PeripheralClass', 6: u'MemoryClass', 7: u'MaximumClass'})]],
    'Type' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {0: u'ArcSystem', 1: u'CentralProcessor', 2: u'FloatingPointProcessor', 3: u'PrimaryIcache', 4: u'PrimaryDcache', 5: u'SecondaryIcache', 6: u'SecondaryDcache', 7: u'SecondaryCache', 8: u'EisaAdapter', 9: u'TcAdapter', 10: u'ScsiAdapter', 11: u'DtiAdapter', 12: u'MultiFunctionAdapter', 13: u'DiskController', 14: u'TapeController', 15: u'CdromController', 16: u'WormController', 17: u'SerialController', 18: u'NetworkController', 19: u'DisplayController', 20: u'ParallelController', 21: u'PointerController', 22: u'KeyboardController', 23: u'AudioController', 24: u'OtherController', 25: u'DiskPeripheral', 26: u'FloppyDiskPeripheral', 27: u'TapePeripheral', 28: u'ModemPeripheral', 29: u'MonitorPeripheral', 30: u'PrinterPeripheral', 31: u'PointerPeripheral', 32: u'KeyboardPeripheral', 33: u'TerminalPeripheral', 34: u'OtherPeripheral', 35: u'LinePeripheral', 36: u'NetworkPeripheral', 37: u'SystemMemory', 38: u'DockingInformation', 39: u'RealModeIrqRoutingTable', 40: u'RealModePCIEnumeration', 41: u'MaximumType'})]],
    'Flags' : [ 0x8, ['_DEVICE_FLAGS']],
    'Version' : [ 0xc, ['unsigned short']],
    'Revision' : [ 0xe, ['unsigned short']],
    'Key' : [ 0x10, ['unsigned long']],
    'AffinityMask' : [ 0x14, ['unsigned long']],
    'Group' : [ 0x14, ['unsigned short']],
    'GroupIndex' : [ 0x16, ['unsigned short']],
    'ConfigurationDataLength' : [ 0x18, ['unsigned long']],
    'IdentifierLength' : [ 0x1c, ['unsigned long']],
    'Identifier' : [ 0x20, ['pointer64', ['unsigned char']]],
} ],
  '_PROC_PERF_CHECK_SNAP' : [ 0x50, {
    'Time' : [ 0x0, ['unsigned long long']],
    'Active' : [ 0x8, ['unsigned long long']],
    'Stall' : [ 0x10, ['unsigned long long']],
    'FrequencyScaledActive' : [ 0x18, ['unsigned long long']],
    'PerformanceScaledActive' : [ 0x20, ['unsigned long long']],
    'PerformanceScaledKernelActive' : [ 0x28, ['unsigned long long']],
    'CyclesActive' : [ 0x30, ['unsigned long long']],
    'CyclesAffinitized' : [ 0x38, ['unsigned long long']],
    'TaggedThreadCycles' : [ 0x40, ['array', 2, ['unsigned long long']]],
} ],
  '_HAL_UNMASKED_INTERRUPT_FLAGS' : [ 0x2, {
    'SecondaryInterrupt' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 16, native_type='unsigned short')]],
    'AsUSHORT' : [ 0x0, ['unsigned short']],
} ],
  '_KTRANSACTION_HISTORY' : [ 0x8, {
    'RecordType' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {1: u'KTMOH_CommitTransaction_Result', 2: u'KTMOH_RollbackTransaction_Result'})]],
    'Payload' : [ 0x4, ['unsigned long']],
} ],
  '_EVENT_PAYLOAD_PREDICATE' : [ 0x18, {
    'FieldIndex' : [ 0x0, ['unsigned short']],
    'CompareOp' : [ 0x2, ['unsigned short']],
    'Value' : [ 0x8, ['array', 2, ['unsigned long long']]],
} ],
  '_ARM_LOADER_BLOCK' : [ 0x4, {
    'PlaceHolder' : [ 0x0, ['unsigned long']],
} ],
  '_PNP_RESOURCE_CONFLICT_TRACE_CONTEXT' : [ 0x18, {
    'ResourceType' : [ 0x0, ['unsigned char']],
    'AlternativeCount' : [ 0x4, ['unsigned long']],
    'ResourceRequests' : [ 0x8, ['pointer64', ['_IO_RESOURCE_DESCRIPTOR']]],
    'ArbiterInstance' : [ 0x10, ['pointer64', ['void']]],
} ],
  '_MI_POOL_FAILURE_REASONS' : [ 0x2c, {
    'NonPagedNoPtes' : [ 0x0, ['unsigned long']],
    'PriorityTooLow' : [ 0x4, ['unsigned long']],
    'NonPagedNoPagesAvailable' : [ 0x8, ['unsigned long']],
    'PagedNoPtes' : [ 0xc, ['unsigned long']],
    'SessionPagedNoPtes' : [ 0x10, ['unsigned long']],
    'PagedNoPagesAvailable' : [ 0x14, ['unsigned long']],
    'SessionPagedNoPagesAvailable' : [ 0x18, ['unsigned long']],
    'PagedNoCommit' : [ 0x1c, ['unsigned long']],
    'SessionPagedNoCommit' : [ 0x20, ['unsigned long']],
    'NonPagedNoResidentAvailable' : [ 0x24, ['unsigned long']],
    'NonPagedNoCommit' : [ 0x28, ['unsigned long']],
} ],
  '_PEP_WORK_COMPLETE_PERF_STATE' : [ 0x10, {
    'DeviceHandle' : [ 0x0, ['pointer64', ['POHANDLE__']]],
    'Component' : [ 0x8, ['unsigned long']],
    'Succeeded' : [ 0xc, ['unsigned char']],
} ],
  '_LOADER_PERFORMANCE_DATA' : [ 0x10, {
    'StartTime' : [ 0x0, ['unsigned long long']],
    'EndTime' : [ 0x8, ['unsigned long long']],
} ],
  '_MI_FREE_LARGE_PAGES' : [ 0x110, {
    'LargePageFreeCount' : [ 0x0, ['array', 2, ['unsigned long long']]],
    'LargePagesCount' : [ 0x10, ['array', 2, ['array', 2, ['array', 4, ['unsigned long long']]]]],
    'LargePageEntries' : [ 0x90, ['array', 2, ['array', 2, ['array', 4, ['pointer64', ['_MI_FREE_LARGE_PAGE_LIST']]]]]],
} ],
  '_RTL_DRIVE_LETTER_CURDIR' : [ 0x18, {
    'Flags' : [ 0x0, ['unsigned short']],
    'Length' : [ 0x2, ['unsigned short']],
    'TimeStamp' : [ 0x4, ['unsigned long']],
    'DosPath' : [ 0x8, ['_STRING']],
} ],
  '_EFI_FIRMWARE_INFORMATION' : [ 0x38, {
    'FirmwareVersion' : [ 0x0, ['unsigned long']],
    'VirtualEfiRuntimeServices' : [ 0x8, ['pointer64', ['_VIRTUAL_EFI_RUNTIME_SERVICES']]],
    'SetVirtualAddressMapStatus' : [ 0x10, ['long']],
    'MissedMappingsCount' : [ 0x14, ['unsigned long']],
    'FirmwareResourceList' : [ 0x18, ['_LIST_ENTRY']],
    'EfiMemoryMap' : [ 0x28, ['pointer64', ['void']]],
    'EfiMemoryMapSize' : [ 0x30, ['unsigned long']],
    'EfiMemoryMapDescriptorSize' : [ 0x34, ['unsigned long']],
} ],
  '_PEP_WORK_IDLE_STATE' : [ 0x10, {
    'DeviceHandle' : [ 0x0, ['pointer64', ['POHANDLE__']]],
    'Component' : [ 0x8, ['unsigned long']],
    'State' : [ 0xc, ['unsigned long']],
} ],
  '_VI_POOL_ENTRY_INUSE' : [ 0x20, {
    'VirtualAddress' : [ 0x0, ['pointer64', ['void']]],
    'CallingAddress' : [ 0x8, ['pointer64', ['void']]],
    'NumberOfBytes' : [ 0x10, ['unsigned long long']],
    'Tag' : [ 0x18, ['unsigned long long']],
} ],
  '_IO_CLIENT_EXTENSION' : [ 0x10, {
    'NextExtension' : [ 0x0, ['pointer64', ['_IO_CLIENT_EXTENSION']]],
    'ClientIdentificationAddress' : [ 0x8, ['pointer64', ['void']]],
} ],
  '_SMBIOS3_TABLE_HEADER' : [ 0x18, {
    'Signature' : [ 0x0, ['array', 5, ['unsigned char']]],
    'Checksum' : [ 0x5, ['unsigned char']],
    'Length' : [ 0x6, ['unsigned char']],
    'MajorVersion' : [ 0x7, ['unsigned char']],
    'MinorVersion' : [ 0x8, ['unsigned char']],
    'Docrev' : [ 0x9, ['unsigned char']],
    'EntryPointRevision' : [ 0xa, ['unsigned char']],
    'Reserved' : [ 0xb, ['unsigned char']],
    'StructureTableMaximumSize' : [ 0xc, ['unsigned long']],
    'StructureTableAddress' : [ 0x10, ['unsigned long long']],
} ],
  '_LOADER_PARAMETER_CI_EXTENSION' : [ 0x50, {
    'CodeIntegrityOptions' : [ 0x0, ['unsigned long']],
    'UpgradeInProgress' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'IsWinPE' : [ 0x4, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'CustomKernelSignersAllowed' : [ 0x4, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'Reserved' : [ 0x4, ['BitField', dict(start_bit = 3, end_bit = 32, native_type='unsigned long')]],
    'WhqlEnforcementDate' : [ 0x8, ['_LARGE_INTEGER']],
    'RevocationListOffset' : [ 0x10, ['unsigned long']],
    'RevocationListSize' : [ 0x14, ['unsigned long']],
    'CodeIntegrityPolicyOffset' : [ 0x18, ['unsigned long']],
    'CodeIntegrityPolicySize' : [ 0x1c, ['unsigned long']],
    'CodeIntegrityPolicyHashOffset' : [ 0x20, ['unsigned long']],
    'CodeIntegrityPolicyHashSize' : [ 0x24, ['unsigned long']],
    'CodeIntegrityPolicyOriginalHashOffset' : [ 0x28, ['unsigned long']],
    'CodeIntegrityPolicyOriginalHashSize' : [ 0x2c, ['unsigned long']],
    'WeakCryptoPolicyLoadStatus' : [ 0x30, ['long']],
    'WeakCryptoPolicyOffset' : [ 0x34, ['unsigned long']],
    'WeakCryptoPolicySize' : [ 0x38, ['unsigned long']],
    'SecureBootPolicyOffset' : [ 0x3c, ['unsigned long']],
    'SecureBootPolicySize' : [ 0x40, ['unsigned long']],
    'Reserved2' : [ 0x44, ['unsigned long']],
    'SerializedData' : [ 0x48, ['array', 1, ['unsigned char']]],
} ],
  '_PCAT_FIRMWARE_INFORMATION' : [ 0x4, {
    'PlaceHolder' : [ 0x0, ['unsigned long']],
} ],
  '_LDRP_CSLIST' : [ 0x8, {
    'Tail' : [ 0x0, ['pointer64', ['_SINGLE_LIST_ENTRY']]],
} ],
  '_MI_RESERVATION_CLUSTER_INFO' : [ 0x4, {
    'ClusterSize' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 10, native_type='unsigned long')]],
    'SequenceNumber' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 32, native_type='unsigned long')]],
    'EntireInfo' : [ 0x0, ['long']],
} ],
  '_VIRTUAL_EFI_RUNTIME_SERVICES' : [ 0x70, {
    'GetTime' : [ 0x0, ['unsigned long long']],
    'SetTime' : [ 0x8, ['unsigned long long']],
    'GetWakeupTime' : [ 0x10, ['unsigned long long']],
    'SetWakeupTime' : [ 0x18, ['unsigned long long']],
    'SetVirtualAddressMap' : [ 0x20, ['unsigned long long']],
    'ConvertPointer' : [ 0x28, ['unsigned long long']],
    'GetVariable' : [ 0x30, ['unsigned long long']],
    'GetNextVariableName' : [ 0x38, ['unsigned long long']],
    'SetVariable' : [ 0x40, ['unsigned long long']],
    'GetNextHighMonotonicCount' : [ 0x48, ['unsigned long long']],
    'ResetSystem' : [ 0x50, ['unsigned long long']],
    'UpdateCapsule' : [ 0x58, ['unsigned long long']],
    'QueryCapsuleCapabilities' : [ 0x60, ['unsigned long long']],
    'QueryVariableInfo' : [ 0x68, ['unsigned long long']],
} ],
  '_VI_POOL_PAGE_HEADER' : [ 0x18, {
    'NextPage' : [ 0x0, ['pointer64', ['_SLIST_ENTRY']]],
    'VerifierEntry' : [ 0x8, ['pointer64', ['void']]],
    'Signature' : [ 0x10, ['unsigned long long']],
} ],
  '_MI_STORE_INPAGE_COMPLETE_FLAGS' : [ 0x4, {
    'EntireFlags' : [ 0x0, ['unsigned long']],
    'StoreFault' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'LowResourceFailure' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'Spare' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 16, native_type='unsigned long')]],
    'RemainingPageCount' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 32, native_type='unsigned long')]],
} ],
  '_EX_WORK_QUEUE_MANAGER' : [ 0x118, {
    'Partition' : [ 0x0, ['pointer64', ['_EX_PARTITION']]],
    'Node' : [ 0x8, ['pointer64', ['_ENODE']]],
    'Event' : [ 0x10, ['_KEVENT']],
    'DeadlockTimer' : [ 0x28, ['_KTIMER']],
    'ReaperEvent' : [ 0x68, ['_KEVENT']],
    'ReaperTimer' : [ 0x80, ['_KTIMER2']],
    'ThreadHandle' : [ 0x108, ['pointer64', ['void']]],
    'ExitThread' : [ 0x110, ['unsigned long']],
    'ThreadSeed' : [ 0x114, ['unsigned long']],
} ],
  '_LOADER_PARAMETER_HYPERVISOR_EXTENSION' : [ 0x38, {
    'HypervisorCrashdumpAreaPageCount' : [ 0x0, ['unsigned long']],
    'HypervisorCrashdumpAreaSpa' : [ 0x8, ['unsigned long long']],
    'HypervisorLaunchStatus' : [ 0x10, ['unsigned long long']],
    'HypervisorLaunchStatusArg1' : [ 0x18, ['unsigned long long']],
    'HypervisorLaunchStatusArg2' : [ 0x20, ['unsigned long long']],
    'HypervisorLaunchStatusArg3' : [ 0x28, ['unsigned long long']],
    'HypervisorLaunchStatusArg4' : [ 0x30, ['unsigned long long']],
} ],
  '_DEVICE_FLAGS' : [ 0x4, {
    'Failed' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'ReadOnly' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'Removable' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'ConsoleIn' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'ConsoleOut' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'Input' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'Output' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
} ],
  '_PO_NOTIFY_ORDER_LEVEL' : [ 0x48, {
    'DeviceCount' : [ 0x0, ['unsigned long']],
    'ActiveCount' : [ 0x4, ['unsigned long']],
    'WaitSleep' : [ 0x8, ['_LIST_ENTRY']],
    'ReadySleep' : [ 0x18, ['_LIST_ENTRY']],
    'ReadyS0' : [ 0x28, ['_LIST_ENTRY']],
    'WaitS0' : [ 0x38, ['_LIST_ENTRY']],
} ],
  '_PROFILE_PARAMETER_BLOCK' : [ 0x10, {
    'Status' : [ 0x0, ['unsigned short']],
    'Reserved' : [ 0x2, ['unsigned short']],
    'DockingState' : [ 0x4, ['unsigned short']],
    'Capabilities' : [ 0x6, ['unsigned short']],
    'DockID' : [ 0x8, ['unsigned long']],
    'SerialNumber' : [ 0xc, ['unsigned long']],
} ],
  '_PEP_WORK_POWER_CONTROL' : [ 0x38, {
    'DeviceHandle' : [ 0x0, ['pointer64', ['POHANDLE__']]],
    'PowerControlCode' : [ 0x8, ['pointer64', ['_GUID']]],
    'RequestContext' : [ 0x10, ['pointer64', ['void']]],
    'InBuffer' : [ 0x18, ['pointer64', ['void']]],
    'InBufferSize' : [ 0x20, ['unsigned long long']],
    'OutBuffer' : [ 0x28, ['pointer64', ['void']]],
    'OutBufferSize' : [ 0x30, ['unsigned long long']],
} ],
  '_PEP_WORK_DEVICE_POWER' : [ 0x10, {
    'DeviceHandle' : [ 0x0, ['pointer64', ['POHANDLE__']]],
    'PowerRequired' : [ 0x8, ['unsigned char']],
} ],
  '_ETWP_NOTIFICATION_HEADER' : [ 0x48, {
    'NotificationType' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {1: u'EtwNotificationTypeNoReply', 2: u'EtwNotificationTypeLegacyEnable', 3: u'EtwNotificationTypeEnable', 4: u'EtwNotificationTypePrivateLogger', 5: u'EtwNotificationTypePerflib', 6: u'EtwNotificationTypeAudio', 7: u'EtwNotificationTypeSession', 8: u'EtwNotificationTypeReserved', 9: u'EtwNotificationTypeCredentialUI', 10: u'EtwNotificationTypeInProcSession', 11: u'EtwNotificationTypeFilteredPrivateLogger', 12: u'EtwNotificationTypeMax'})]],
    'NotificationSize' : [ 0x4, ['unsigned long']],
    'RefCount' : [ 0x8, ['long']],
    'ReplyRequested' : [ 0xc, ['unsigned char']],
    'ReplyIndex' : [ 0x10, ['unsigned long']],
    'Timeout' : [ 0x10, ['unsigned long']],
    'ReplyCount' : [ 0x14, ['unsigned long']],
    'NotifyeeCount' : [ 0x14, ['unsigned long']],
    'ReplyHandle' : [ 0x18, ['unsigned long long']],
    'ReplyObject' : [ 0x18, ['pointer64', ['void']]],
    'RegIndex' : [ 0x18, ['unsigned long']],
    'TargetPID' : [ 0x20, ['unsigned long']],
    'SourcePID' : [ 0x24, ['unsigned long']],
    'DestinationGuid' : [ 0x28, ['_GUID']],
    'SourceGuid' : [ 0x38, ['_GUID']],
} ],
  '_MI_EXTRA_IMAGE_INFORMATION' : [ 0x8, {
    'SizeOfHeaders' : [ 0x0, ['unsigned long']],
    'SizeOfImage' : [ 0x4, ['unsigned long']],
} ],
  '_NETWORK_LOADER_BLOCK' : [ 0x20, {
    'DHCPServerACK' : [ 0x0, ['pointer64', ['unsigned char']]],
    'DHCPServerACKLength' : [ 0x8, ['unsigned long']],
    'BootServerReplyPacket' : [ 0x10, ['pointer64', ['unsigned char']]],
    'BootServerReplyPacketLength' : [ 0x18, ['unsigned long']],
} ],
  '_BOOT_ENTROPY_LDR_RESULT' : [ 0x798, {
    'maxEntropySources' : [ 0x0, ['unsigned long']],
    'EntropySourceResult' : [ 0x8, ['array', 8, ['_BOOT_ENTROPY_SOURCE_LDR_RESULT']]],
    'SeedBytesForCng' : [ 0x348, ['array', 48, ['unsigned char']]],
    'RngBytesForNtoskrnl' : [ 0x378, ['array', 1024, ['unsigned char']]],
    'KdEntropy' : [ 0x778, ['array', 32, ['unsigned char']]],
} ],
  '_FS_FILTER_CALLBACKS' : [ 0x78, {
    'SizeOfFsFilterCallbacks' : [ 0x0, ['unsigned long']],
    'Reserved' : [ 0x4, ['unsigned long']],
    'PreAcquireForSectionSynchronization' : [ 0x8, ['pointer64', ['void']]],
    'PostAcquireForSectionSynchronization' : [ 0x10, ['pointer64', ['void']]],
    'PreReleaseForSectionSynchronization' : [ 0x18, ['pointer64', ['void']]],
    'PostReleaseForSectionSynchronization' : [ 0x20, ['pointer64', ['void']]],
    'PreAcquireForCcFlush' : [ 0x28, ['pointer64', ['void']]],
    'PostAcquireForCcFlush' : [ 0x30, ['pointer64', ['void']]],
    'PreReleaseForCcFlush' : [ 0x38, ['pointer64', ['void']]],
    'PostReleaseForCcFlush' : [ 0x40, ['pointer64', ['void']]],
    'PreAcquireForModifiedPageWriter' : [ 0x48, ['pointer64', ['void']]],
    'PostAcquireForModifiedPageWriter' : [ 0x50, ['pointer64', ['void']]],
    'PreReleaseForModifiedPageWriter' : [ 0x58, ['pointer64', ['void']]],
    'PostReleaseForModifiedPageWriter' : [ 0x60, ['pointer64', ['void']]],
    'PreQueryOpen' : [ 0x68, ['pointer64', ['void']]],
    'PostQueryOpen' : [ 0x70, ['pointer64', ['void']]],
} ],
  '_LPCP_NONPAGED_PORT_QUEUE' : [ 0x28, {
    'Semaphore' : [ 0x0, ['_KSEMAPHORE']],
    'BackPointer' : [ 0x20, ['pointer64', ['_LPCP_PORT_OBJECT']]],
} ],
  '_POP_FX_PERF_SET' : [ 0x20, {
    'PerfSet' : [ 0x0, ['pointer64', ['_PO_FX_COMPONENT_PERF_SET']]],
    'CurrentPerf' : [ 0x8, ['unsigned long long']],
    'CurrentPerfStamp' : [ 0x10, ['unsigned long long']],
    'CurrentPerfNominal' : [ 0x18, ['unsigned char']],
} ],
  '_PO_FX_PERF_STATE_CHANGE' : [ 0x10, {
    'Set' : [ 0x0, ['unsigned long']],
    'StateIndex' : [ 0x8, ['unsigned long']],
    'StateValue' : [ 0x8, ['unsigned long long']],
} ],
  '_PEP_WORK_COMPLETE_IDLE_STATE' : [ 0x10, {
    'DeviceHandle' : [ 0x0, ['pointer64', ['POHANDLE__']]],
    'Component' : [ 0x8, ['unsigned long']],
} ],
  '_LDR_SERVICE_TAG_RECORD' : [ 0x10, {
    'Next' : [ 0x0, ['pointer64', ['_LDR_SERVICE_TAG_RECORD']]],
    'ServiceTag' : [ 0x8, ['unsigned long']],
} ],
  '_PEP_WORK_ACTIVE_COMPLETE' : [ 0x10, {
    'DeviceHandle' : [ 0x0, ['pointer64', ['POHANDLE__']]],
    'Component' : [ 0x8, ['unsigned long']],
} ],
  '_CM_PARTIAL_RESOURCE_LIST' : [ 0x1c, {
    'Version' : [ 0x0, ['unsigned short']],
    'Revision' : [ 0x2, ['unsigned short']],
    'Count' : [ 0x4, ['unsigned long']],
    'PartialDescriptors' : [ 0x8, ['array', 1, ['_CM_PARTIAL_RESOURCE_DESCRIPTOR']]],
} ],
  '_FS_FILTER_CALLBACK_DATA' : [ 0x40, {
    'SizeOfFsFilterCallbackData' : [ 0x0, ['unsigned long']],
    'Operation' : [ 0x4, ['unsigned char']],
    'Reserved' : [ 0x5, ['unsigned char']],
    'DeviceObject' : [ 0x8, ['pointer64', ['_DEVICE_OBJECT']]],
    'FileObject' : [ 0x10, ['pointer64', ['_FILE_OBJECT']]],
    'Parameters' : [ 0x18, ['_FS_FILTER_PARAMETERS']],
} ],
  '__unnamed_3074' : [ 0x10, {
    'Count' : [ 0x0, ['unsigned long']],
    'States' : [ 0x8, ['pointer64', ['_PO_FX_PERF_STATE']]],
} ],
  '__unnamed_3076' : [ 0x10, {
    'Minimum' : [ 0x0, ['unsigned long long']],
    'Maximum' : [ 0x8, ['unsigned long long']],
} ],
  '_PO_FX_COMPONENT_PERF_SET' : [ 0x30, {
    'Name' : [ 0x0, ['_UNICODE_STRING']],
    'Flags' : [ 0x10, ['unsigned long long']],
    'Unit' : [ 0x18, ['Enumeration', dict(target = 'long', choices = {0: u'PoFxPerfStateUnitOther', 1: u'PoFxPerfStateUnitFrequency', 2: u'PoFxPerfStateUnitBandwidth', 3: u'PoFxPerfStateUnitMaximum'})]],
    'Type' : [ 0x1c, ['Enumeration', dict(target = 'long', choices = {0: u'PoFxPerfStateTypeDiscrete', 1: u'PoFxPerfStateTypeRange', 2: u'PoFxPerfStateTypeMaximum'})]],
    'Discrete' : [ 0x20, ['__unnamed_3074']],
    'Range' : [ 0x20, ['__unnamed_3076']],
} ],
  '_NB10' : [ 0x14, {
    'Signature' : [ 0x0, ['unsigned long']],
    'Offset' : [ 0x4, ['unsigned long']],
    'TimeStamp' : [ 0x8, ['unsigned long']],
    'Age' : [ 0xc, ['unsigned long']],
    'PdbName' : [ 0x10, ['array', 1, ['unsigned char']]],
} ],
  '_CURDIR' : [ 0x18, {
    'DosPath' : [ 0x0, ['_UNICODE_STRING']],
    'Handle' : [ 0x10, ['pointer64', ['void']]],
} ],
  '_BOOT_ENTROPY_SOURCE_LDR_RESULT' : [ 0x68, {
    'SourceId' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: u'BootEntropySourceNone', 1: u'BootEntropySourceSeedfile', 2: u'BootEntropySourceExternal', 3: u'BootEntropySourceTpm', 4: u'BootEntropySourceRdrand', 5: u'BootEntropySourceTime', 6: u'BootEntropySourceAcpiOem0', 7: u'BootEntropySourceUefi', 8: u'BootMaxEntropySources'})]],
    'Policy' : [ 0x8, ['unsigned long long']],
    'ResultCode' : [ 0x10, ['Enumeration', dict(target = 'long', choices = {0: u'BootEntropySourceStructureUninitialized', 1: u'BootEntropySourceDisabledByPolicy', 2: u'BootEntropySourceNotPresent', 3: u'BootEntropySourceError', 4: u'BootEntropySourceSuccess'})]],
    'ResultStatus' : [ 0x14, ['long']],
    'Time' : [ 0x18, ['unsigned long long']],
    'EntropyLength' : [ 0x20, ['unsigned long']],
    'EntropyData' : [ 0x24, ['array', 64, ['unsigned char']]],
} ],
  'POHANDLE__' : [ 0x4, {
    'unused' : [ 0x0, ['long']],
} ],
  '_PO_FX_PERF_STATE' : [ 0x10, {
    'Value' : [ 0x0, ['unsigned long long']],
    'Context' : [ 0x8, ['pointer64', ['void']]],
} ],
  '__unnamed_3087' : [ 0x10, {
    'EndingOffset' : [ 0x0, ['pointer64', ['_LARGE_INTEGER']]],
    'ResourceToRelease' : [ 0x8, ['pointer64', ['pointer64', ['_ERESOURCE']]]],
} ],
  '__unnamed_3089' : [ 0x8, {
    'ResourceToRelease' : [ 0x0, ['pointer64', ['_ERESOURCE']]],
} ],
  '__unnamed_308f' : [ 0x10, {
    'SyncType' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: u'SyncTypeOther', 1: u'SyncTypeCreateSection'})]],
    'PageProtection' : [ 0x4, ['unsigned long']],
    'OutputInformation' : [ 0x8, ['pointer64', ['_FS_FILTER_SECTION_SYNC_OUTPUT']]],
} ],
  '__unnamed_3093' : [ 0x10, {
    'NotificationType' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: u'NotifyTypeCreate', 1: u'NotifyTypeRetired'})]],
    'SafeToRecurse' : [ 0x8, ['unsigned char']],
} ],
  '__unnamed_3095' : [ 0x20, {
    'Irp' : [ 0x0, ['pointer64', ['_IRP']]],
    'FileInformation' : [ 0x8, ['pointer64', ['void']]],
    'Length' : [ 0x10, ['pointer64', ['unsigned long']]],
    'FileInformationClass' : [ 0x18, ['Enumeration', dict(target = 'long', choices = {1: u'FileDirectoryInformation', 2: u'FileFullDirectoryInformation', 3: u'FileBothDirectoryInformation', 4: u'FileBasicInformation', 5: u'FileStandardInformation', 6: u'FileInternalInformation', 7: u'FileEaInformation', 8: u'FileAccessInformation', 9: u'FileNameInformation', 10: u'FileRenameInformation', 11: u'FileLinkInformation', 12: u'FileNamesInformation', 13: u'FileDispositionInformation', 14: u'FilePositionInformation', 15: u'FileFullEaInformation', 16: u'FileModeInformation', 17: u'FileAlignmentInformation', 18: u'FileAllInformation', 19: u'FileAllocationInformation', 20: u'FileEndOfFileInformation', 21: u'FileAlternateNameInformation', 22: u'FileStreamInformation', 23: u'FilePipeInformation', 24: u'FilePipeLocalInformation', 25: u'FilePipeRemoteInformation', 26: u'FileMailslotQueryInformation', 27: u'FileMailslotSetInformation', 28: u'FileCompressionInformation', 29: u'FileObjectIdInformation', 30: u'FileCompletionInformation', 31: u'FileMoveClusterInformation', 32: u'FileQuotaInformation', 33: u'FileReparsePointInformation', 34: u'FileNetworkOpenInformation', 35: u'FileAttributeTagInformation', 36: u'FileTrackingInformation', 37: u'FileIdBothDirectoryInformation', 38: u'FileIdFullDirectoryInformation', 39: u'FileValidDataLengthInformation', 40: u'FileShortNameInformation', 41: u'FileIoCompletionNotificationInformation', 42: u'FileIoStatusBlockRangeInformation', 43: u'FileIoPriorityHintInformation', 44: u'FileSfioReserveInformation', 45: u'FileSfioVolumeInformation', 46: u'FileHardLinkInformation', 47: u'FileProcessIdsUsingFileInformation', 48: u'FileNormalizedNameInformation', 49: u'FileNetworkPhysicalNameInformation', 50: u'FileIdGlobalTxDirectoryInformation', 51: u'FileIsRemoteDeviceInformation', 52: u'FileUnusedInformation', 53: u'FileNumaNodeInformation', 54: u'FileStandardLinkInformation', 55: u'FileRemoteProtocolInformation', 56: u'FileRenameInformationBypassAccessCheck', 57: u'FileLinkInformationBypassAccessCheck', 58: u'FileVolumeNameInformation', 59: u'FileIdInformation', 60: u'FileIdExtdDirectoryInformation', 61: u'FileReplaceCompletionInformation', 62: u'FileHardLinkFullIdInformation', 63: u'FileIdExtdBothDirectoryInformation', 64: u'FileDispositionInformationEx', 65: u'FileRenameInformationEx', 66: u'FileRenameInformationExBypassAccessCheck', 67: u'FileDesiredStorageClassInformation', 68: u'FileStatInformation', 69: u'FileMemoryPartitionInformation', 70: u'FileStatLxInformation', 71: u'FileCaseSensitiveInformation', 72: u'FileMaximumInformation'})]],
    'CompletionStatus' : [ 0x1c, ['long']],
} ],
  '__unnamed_3097' : [ 0x28, {
    'Argument1' : [ 0x0, ['pointer64', ['void']]],
    'Argument2' : [ 0x8, ['pointer64', ['void']]],
    'Argument3' : [ 0x10, ['pointer64', ['void']]],
    'Argument4' : [ 0x18, ['pointer64', ['void']]],
    'Argument5' : [ 0x20, ['pointer64', ['void']]],
} ],
  '_FS_FILTER_PARAMETERS' : [ 0x28, {
    'AcquireForModifiedPageWriter' : [ 0x0, ['__unnamed_3087']],
    'ReleaseForModifiedPageWriter' : [ 0x0, ['__unnamed_3089']],
    'AcquireForSectionSynchronization' : [ 0x0, ['__unnamed_308f']],
    'NotifyStreamFileObject' : [ 0x0, ['__unnamed_3093']],
    'QueryOpen' : [ 0x0, ['__unnamed_3095']],
    'Others' : [ 0x0, ['__unnamed_3097']],
} ],
  '_RSDS' : [ 0x1c, {
    'Signature' : [ 0x0, ['unsigned long']],
    'Guid' : [ 0x4, ['_GUID']],
    'Age' : [ 0x14, ['unsigned long']],
    'PdbName' : [ 0x18, ['array', 1, ['unsigned char']]],
} ],
  '_PEP_WORK_DEVICE_IDLE' : [ 0x10, {
    'DeviceHandle' : [ 0x0, ['pointer64', ['POHANDLE__']]],
    'IgnoreIdleTimeout' : [ 0x8, ['unsigned char']],
} ],
  '_FS_FILTER_SECTION_SYNC_OUTPUT' : [ 0x10, {
    'StructureSize' : [ 0x0, ['unsigned long']],
    'SizeReturned' : [ 0x4, ['unsigned long']],
    'Flags' : [ 0x8, ['unsigned long']],
    'DesiredReadAlignment' : [ 0xc, ['unsigned long']],
} ],
}
